import{s as Fl,f as zl,o as ql,n as Xl}from"../chunks/scheduler.f6319a2a.js";import{S as Ll,i as Dl,g as o,s as n,r as p,A as Pl,h as i,f as l,c as a,j as Hl,u as y,x as M,k as Kt,y as Kl,a as s,v as c,d as u,t as J,w as r}from"../chunks/index.85aa684c.js";import{T as Yl}from"../chunks/Tip.3d397a88.js";import{C as m}from"../chunks/CodeBlock.97b48fd2.js";import{D as Ol}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as U,E as es}from"../chunks/EditOnGithub.006048dd.js";function ts(Ee){let w,d='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){w=o("p"),w.innerHTML=d},l(T){w=i(T,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1p1d9vw"&&(w.innerHTML=d)},m(T,I){s(T,w,I)},p:Xl,d(T){T&&l(w)}}}function ls(Ee){let w,d="The only way to run LLM-generated code securely is to isolate the execution from your local environment.";return{c(){w=o("p"),w.textContent=d},l(T){w=i(T,"P",{"data-svelte-h":!0}),M(w)!=="svelte-126gpxq"&&(w.textContent=d)},m(T,I){s(T,w,I)},p:Xl,d(T){T&&l(w)}}}function ss(Ee){let w,d,T,I,C,Re,g,Ne,j,Se,f,$e,B,Ot='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',Qe,x,el="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",_e,Z,tl="Code is just a better way to express actions on a computer. It has better:",He,v,ll="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",Ye,k,sl='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',Xe,Ae,nl,Fe,W,al="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",ze,G,qe,E,ol="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",Le,A,il="This is inherently risky, LLM-generated code could be harmful to your environment.",De,V,Ml="Malicious code execution can occur in several ways:",Pe,R,pl=`<li><strong>Plain LLM error:</strong> LLMs are still far from perfect and may unintentionally generate harmful commands while attempting to be helpful. While this risk is low, instances have been observed where an LLM attempted to execute potentially dangerous code.</li> <li><strong>Supply chain attack:</strong> Running an untrusted or compromised LLM could expose a system to harmful code generation. While this risk is extremely low when using well-known models on secure inference infrastructure, it remains a theoretical possibility.</li> <li><strong>Prompt injection:</strong> an agent browsing the web could arrive on a malicious website that contains harmful instructions, thus injecting an attack into the agent’s memory</li> <li><strong>Exploitation of publicly accessible agents:</strong> Agents exposed to the public can be misused by malicious actors to execute harmful code. Attackers may craft adversarial inputs to exploit the agent’s execution capabilities, leading to unintended consequences.
Once malicious code is executed, whether accidentally or intentionally, it can damage the file system, exploit local or cloud-based resources, abuse API services, and even compromise network security.</li>`,Ke,N,yl='One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.',Oe,S,cl="So you need to be very mindful of security.",et,$,ul=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonExecutor</code> from the ground up.`,tt,Q,Jl="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",lt,_,rl="<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.</li> <li>Furthermore, access to submodules is disabled by default, and each must be explicitly authorized in the import list as well.<ul><li>Note that some seemingly innocuous packages like <code>random</code> can give access to potentially harmful submodules, as in <code>random._os</code>.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>",st,H,wl="You could try these safeguards as follows:",nt,Y,at,X,Tl=`These safeguards make out interpreter is safer.
We have used it on a diversity of use cases, without ever observing any damage to the environment.`,ot,F,Ul="However, this solution is certainly not watertight, as no local python sandbox can really be: one could imagine occasions where LLMs fine-tuned for malignant actions could still hurt your environment.",it,z,dl="For instance, if you have allowed an innocuous package like <code>Pillow</code> to process images, the LLM could generate thousands of image saves to bloat your hard drive.",Mt,q,pt,L,ml='Other examples of attacks can be found <a href="https://gynvael.coldwind.pl/n/python_sandbox_escape" rel="nofollow">here</a>.',yt,D,Il="Running these targeted malicious code snippet require a supply chain attack, meaning the LLM you use has been intoxicated.",ct,P,jl="The likelihood of this happening is low when using well-known LLMs from trusted inference providers, but it is still non-zero.",ut,h,Jt,K,hl="So if you want to exercise caution, you should use a remote execution sandbox.",rt,O,bl="Here are examples of how to do it.",wt,ee,Tt,te,Cl="When working with AI agents that execute code, security is paramount. This guide describes how to set up and use secure sandboxes for your agent applications using either E2B cloud sandboxes or local Docker containers.",Ut,le,dt,se,mt,ne,gl='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',It,ae,jt,oe,ht,ie,fl="We provide a simple way to use an E2B Sandbox: simply add <code>executor_type=&quot;e2b&quot;</code> to the agent initialization, as follows:",bt,Me,Ct,pe,Bl=`This solution send the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,gt,ye,xl="This is illustrated in the figure below.",ft,b,Zl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="sandboxed code execution" width="60%" max-width="500px"/>',Bt,ce,vl=`However, since any call to a <a href="../examples/multiagents">managed agent</a> would require model calls, since we do not transfer secrets to the remote sandbox, the model call would lack credentials.
Hence this solution does not work (yet) with more complicated multi-agent setups.`,xt,ue,Zt,Je,kl="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",vt,re,Wl="Here is how to do it:",kt,we,Wt,Te,Gt,Ue,Et,de,Gl='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',At,me,Vt,Ie,Rt,je,El="Similar to the E2B Sandbox above, to quickly get started with Docker, simply add <code>executor_type=&quot;docker&quot;</code> to the agent initialization, like:",Nt,he,St,be,$t,Ce,Al="If you want to run multi-agent systems in Docker, you’ll need to setup a custom interpreter in a sandbox.",Qt,ge,Vl="Here is how to setup the a Dockerfile:",_t,fe,Ht,Be,Rl="Create a sandbox manager to run code:",Yt,xe,Xt,Ze,Ft,ve,Nl="These key practices apply to both E2B and Docker sandboxes:",zt,ke,Sl="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",qt,We,$l="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",Lt,Ge,Dt,Ve,Pt;return C=new U({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),g=new Ol({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),j=new Yl({props:{warning:!1,$$slots:{default:[ts]},$$scope:{ctx:Ee}}}),f=new U({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),G=new U({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),Y=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.local_python_executor <span class="hljs-keyword">import</span> LocalPythonExecutor

<span class="hljs-comment"># Set up custom executor, authorize package &quot;numpy&quot;</span>
custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;numpy&quot;</span>])

<span class="hljs-comment"># Utilisty for pretty printing errors</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_capture_exception</span>(<span class="hljs-params">command: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        custom_executor(harmful_command)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR:\\n&quot;</span>, e)

<span class="hljs-comment"># Undefined command just do not work</span>
harmful_command=<span class="hljs-string">&quot;!echo Bad command&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: invalid syntax (&lt;unknown&gt;, line 1)</span>


<span class="hljs-comment"># Imports like os will not be performed unless explicitly added to \`additional_authorized_imports\`</span>
harmful_command=<span class="hljs-string">&quot;import os; exit_code = os.system(&quot;</span>echo Bad command<span class="hljs-string">&quot;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;import os&#x27; due to: InterpreterError: Import of os is not allowed. Authorized imports are: [&#x27;statistics&#x27;, &#x27;numpy&#x27;, &#x27;itertools&#x27;, &#x27;time&#x27;, &#x27;queue&#x27;, &#x27;collections&#x27;, &#x27;math&#x27;, &#x27;random&#x27;, &#x27;re&#x27;, &#x27;datetime&#x27;, &#x27;stat&#x27;, &#x27;unicodedata&#x27;]</span>

<span class="hljs-comment"># Even in authorized imports, potentially harmful packages will not be imported</span>
harmful_command=<span class="hljs-string">&quot;import random; random._os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;random._os.system(&#x27;echo Bad command&#x27;)&#x27; due to: InterpreterError: Forbidden access to module: os</span>

<span class="hljs-comment"># Infinite loop are interrupted after N operations</span>
harmful_command=<span class="hljs-string">&quot;&quot;&quot;
while True:
    pass
&quot;&quot;&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;while True: pass&#x27; due to: InterpreterError: Maximum number of 1000000 iterations in While loop exceeded</span>`,wrap:!1}}),q=new m({props:{code:"Y3VzdG9tX2V4ZWN1dG9yJTIwJTNEJTIwTG9jYWxQeXRob25FeGVjdXRvciglNUIlMjJQSUwlMjIlNUQpJTBBJTBBaGFybWZ1bF9jb21tYW5kJTNEJTIyJTIyJTIyJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBaW1nJTIwJTNEJTIwSW1hZ2UubmV3KCdSR0InJTJDJTIwKDEwMCUyQyUyMDEwMCklMkMlMjBjb2xvciUzRCdibHVlJyklMEElMEFpJTNEMCUwQXdoaWxlJTIwaSUyMCUzQyUyMDEwMDAwJTNBJTBBJTIwJTIwJTIwJTIwaW1nLnNhdmUoJ3NpbXBsZV9pbWFnZV8lN0JpJTdELnBuZycpJTBBJTIwJTIwJTIwJTIwaSUyMCUyQiUzRCUyMDElMEElMjIlMjIlMjIlMEElMjMlMjBMZXQncyUyMG5vdCUyMGV4ZWN1dGUlMjB0aGlzJTIwYnV0JTIwaXQlMjB3b3VsZCUyMG5vdCUyMGVycm9yJTIwb3V0JTJDJTIwYW5kJTIwaXQlMjB3b3VsZCUyMGJsb2F0JTIweW91ciUyMHN5c3RlbSUyMHdpdGglMjBpbWFnZXMu",highlighted:`custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;PIL&quot;</span>])

harmful_command=<span class="hljs-string">&quot;&quot;&quot;
from PIL import Image

img = Image.new(&#x27;RGB&#x27;, (100, 100), color=&#x27;blue&#x27;)

i=0
while i &lt; 10000:
    img.save(&#x27;simple_image_{i}.png&#x27;)
    i += 1
&quot;&quot;&quot;</span>
<span class="hljs-comment"># Let&#x27;s not execute this but it would not error out, and it would bloat your system with images.</span>`,wrap:!1}}),h=new Yl({props:{warning:!0,$$slots:{default:[ls]},$$scope:{ctx:Ee}}}),ee=new U({props:{title:"Sandbox setup for secure code execution",local:"sandbox-setup-for-secure-code-execution",headingTag:"h2"}}),le=new U({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),se=new U({props:{title:"Installation",local:"installation",headingTag:"h4"}}),ae=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),oe=new U({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),Me=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQobW9kZWwlM0RIZkFwaU1vZGVsKCklMkMlMjB0b29scyUzRCU1QiU1RCUyQyUyMGV4ZWN1dG9yX3R5cGUlM0QlMjJlMmIlMjIpJTBBJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMDEwMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent

agent = CodeAgent(model=HfApiModel(), tools=[], executor_type=<span class="hljs-string">&quot;e2b&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),ue=new U({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),we=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, HfApiModel

# Initialize the agents
agent = CodeAgent(
    model=HfApiModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=HfApiModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),Te=new U({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),Ue=new U({props:{title:"Installation",local:"installation",headingTag:"h4"}}),me=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),Ie=new U({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),he=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQobW9kZWwlM0RIZkFwaU1vZGVsKCklMkMlMjB0b29scyUzRCU1QiU1RCUyQyUyMGV4ZWN1dG9yX3R5cGUlM0QlMjJkb2NrZXIlMjIpJTBBJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMDEwMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent

agent = CodeAgent(model=HfApiModel(), tools=[], executor_type=<span class="hljs-string">&quot;docker&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),be=new U({props:{title:"Advanced docker usage",local:"advanced-docker-usage",headingTag:"h4"}}),fe=new m({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),xe=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, HfApiModel

# Initialize the agent
agent = CodeAgent(
    model=HfApiModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),Ze=new U({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),Ge=new es({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.mdx"}}),{c(){w=o("meta"),d=n(),T=o("p"),I=n(),p(C.$$.fragment),Re=n(),p(g.$$.fragment),Ne=n(),p(j.$$.fragment),Se=n(),p(f.$$.fragment),$e=n(),B=o("p"),B.innerHTML=Ot,Qe=n(),x=o("p"),x.textContent=el,_e=n(),Z=o("p"),Z.textContent=tl,He=n(),v=o("ul"),v.innerHTML=ll,Ye=n(),k=o("p"),k.innerHTML=sl,Xe=n(),Ae=o("img"),Fe=n(),W=o("p"),W.textContent=al,ze=n(),p(G.$$.fragment),qe=n(),E=o("p"),E.innerHTML=ol,Le=n(),A=o("p"),A.textContent=il,De=n(),V=o("p"),V.textContent=Ml,Pe=n(),R=o("ul"),R.innerHTML=pl,Ke=n(),N=o("p"),N.innerHTML=yl,Oe=n(),S=o("p"),S.textContent=cl,et=n(),$=o("p"),$.innerHTML=ul,tt=n(),Q=o("p"),Q.textContent=Jl,lt=n(),_=o("ul"),_.innerHTML=rl,st=n(),H=o("p"),H.textContent=wl,nt=n(),p(Y.$$.fragment),at=n(),X=o("p"),X.textContent=Tl,ot=n(),F=o("p"),F.textContent=Ul,it=n(),z=o("p"),z.innerHTML=dl,Mt=n(),p(q.$$.fragment),pt=n(),L=o("p"),L.innerHTML=ml,yt=n(),D=o("p"),D.textContent=Il,ct=n(),P=o("p"),P.textContent=jl,ut=n(),p(h.$$.fragment),Jt=n(),K=o("p"),K.textContent=hl,rt=n(),O=o("p"),O.textContent=bl,wt=n(),p(ee.$$.fragment),Tt=n(),te=o("p"),te.textContent=Cl,Ut=n(),p(le.$$.fragment),dt=n(),p(se.$$.fragment),mt=n(),ne=o("ol"),ne.innerHTML=gl,It=n(),p(ae.$$.fragment),jt=n(),p(oe.$$.fragment),ht=n(),ie=o("p"),ie.innerHTML=fl,bt=n(),p(Me.$$.fragment),Ct=n(),pe=o("p"),pe.innerHTML=Bl,gt=n(),ye=o("p"),ye.textContent=xl,ft=n(),b=o("p"),b.innerHTML=Zl,Bt=n(),ce=o("p"),ce.innerHTML=vl,xt=n(),p(ue.$$.fragment),Zt=n(),Je=o("p"),Je.textContent=kl,vt=n(),re=o("p"),re.textContent=Wl,kt=n(),p(we.$$.fragment),Wt=n(),p(Te.$$.fragment),Gt=n(),p(Ue.$$.fragment),Et=n(),de=o("ol"),de.innerHTML=Gl,At=n(),p(me.$$.fragment),Vt=n(),p(Ie.$$.fragment),Rt=n(),je=o("p"),je.innerHTML=El,Nt=n(),p(he.$$.fragment),St=n(),p(be.$$.fragment),$t=n(),Ce=o("p"),Ce.textContent=Al,Qt=n(),ge=o("p"),ge.textContent=Vl,_t=n(),p(fe.$$.fragment),Ht=n(),Be=o("p"),Be.textContent=Rl,Yt=n(),p(xe.$$.fragment),Xt=n(),p(Ze.$$.fragment),Ft=n(),ve=o("p"),ve.textContent=Nl,zt=n(),ke=o("ul"),ke.innerHTML=Sl,qt=n(),We=o("p"),We.textContent=$l,Lt=n(),p(Ge.$$.fragment),Dt=n(),Ve=o("p"),this.h()},l(e){const t=Pl("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(l),d=a(e),T=i(e,"P",{}),Hl(T).forEach(l),I=a(e),y(C.$$.fragment,e),Re=a(e),y(g.$$.fragment,e),Ne=a(e),y(j.$$.fragment,e),Se=a(e),y(f.$$.fragment,e),$e=a(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1nor5c0"&&(B.innerHTML=Ot),Qe=a(e),x=i(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1b2f48c"&&(x.textContent=el),_e=a(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1jp5kiv"&&(Z.textContent=tl),He=a(e),v=i(e,"UL",{"data-svelte-h":!0}),M(v)!=="svelte-a7ou7n"&&(v.innerHTML=ll),Ye=a(e),k=i(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1ugtxvn"&&(k.innerHTML=sl),Xe=a(e),Ae=i(e,"IMG",{src:!0}),Fe=a(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1lbgv3o"&&(W.textContent=al),ze=a(e),y(G.$$.fragment,e),qe=a(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-19p3p3d"&&(E.innerHTML=ol),Le=a(e),A=i(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-y55i8i"&&(A.textContent=il),De=a(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-y4kupg"&&(V.textContent=Ml),Pe=a(e),R=i(e,"UL",{"data-svelte-h":!0}),M(R)!=="svelte-1b6z7ic"&&(R.innerHTML=pl),Ke=a(e),N=i(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-uopq3c"&&(N.innerHTML=yl),Oe=a(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-gfolx1"&&(S.textContent=cl),et=a(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-845rka"&&($.innerHTML=ul),tt=a(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-180snho"&&(Q.textContent=Jl),lt=a(e),_=i(e,"UL",{"data-svelte-h":!0}),M(_)!=="svelte-1c048bi"&&(_.innerHTML=rl),st=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1wz8jbt"&&(H.textContent=wl),nt=a(e),y(Y.$$.fragment,e),at=a(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1gk7uki"&&(X.textContent=Tl),ot=a(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1xn198z"&&(F.textContent=Ul),it=a(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-4jqgb9"&&(z.innerHTML=dl),Mt=a(e),y(q.$$.fragment,e),pt=a(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-r8kpdu"&&(L.innerHTML=ml),yt=a(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1u5rz9v"&&(D.textContent=Il),ct=a(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-31qg8m"&&(P.textContent=jl),ut=a(e),y(h.$$.fragment,e),Jt=a(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-pv9x3v"&&(K.textContent=hl),rt=a(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-7irprr"&&(O.textContent=bl),wt=a(e),y(ee.$$.fragment,e),Tt=a(e),te=i(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-6dqx27"&&(te.textContent=Cl),Ut=a(e),y(le.$$.fragment,e),dt=a(e),y(se.$$.fragment,e),mt=a(e),ne=i(e,"OL",{"data-svelte-h":!0}),M(ne)!=="svelte-uvtwg2"&&(ne.innerHTML=gl),It=a(e),y(ae.$$.fragment,e),jt=a(e),y(oe.$$.fragment,e),ht=a(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-r3242t"&&(ie.innerHTML=fl),bt=a(e),y(Me.$$.fragment,e),Ct=a(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-jrgx8f"&&(pe.innerHTML=Bl),gt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-8sir7q"&&(ye.textContent=xl),ft=a(e),b=i(e,"P",{align:!0,"data-svelte-h":!0}),M(b)!=="svelte-11rtdvt"&&(b.innerHTML=Zl),Bt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-ofpo9r"&&(ce.innerHTML=vl),xt=a(e),y(ue.$$.fragment,e),Zt=a(e),Je=i(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-geglm0"&&(Je.textContent=kl),vt=a(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-1iycphr"&&(re.textContent=Wl),kt=a(e),y(we.$$.fragment,e),Wt=a(e),y(Te.$$.fragment,e),Gt=a(e),y(Ue.$$.fragment,e),Et=a(e),de=i(e,"OL",{"data-svelte-h":!0}),M(de)!=="svelte-19h0avy"&&(de.innerHTML=Gl),At=a(e),y(me.$$.fragment,e),Vt=a(e),y(Ie.$$.fragment,e),Rt=a(e),je=i(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-1j9zoi1"&&(je.innerHTML=El),Nt=a(e),y(he.$$.fragment,e),St=a(e),y(be.$$.fragment,e),$t=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-t1it0d"&&(Ce.textContent=Al),Qt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1lygj8"&&(ge.textContent=Vl),_t=a(e),y(fe.$$.fragment,e),Ht=a(e),Be=i(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-8mtm8c"&&(Be.textContent=Rl),Yt=a(e),y(xe.$$.fragment,e),Xt=a(e),y(Ze.$$.fragment,e),Ft=a(e),ve=i(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-5fyo5r"&&(ve.textContent=Nl),zt=a(e),ke=i(e,"UL",{"data-svelte-h":!0}),M(ke)!=="svelte-162p62u"&&(ke.innerHTML=Sl),qt=a(e),We=i(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-1hbg2e4"&&(We.textContent=$l),Lt=a(e),y(Ge.$$.fragment,e),Dt=a(e),Ve=i(e,"P",{}),Hl(Ve).forEach(l),this.h()},h(){Kt(w,"name","hf:doc:metadata"),Kt(w,"content",ns),zl(Ae.src,nl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||Kt(Ae,"src",nl),Kt(b,"align","center")},m(e,t){Kl(document.head,w),s(e,d,t),s(e,T,t),s(e,I,t),c(C,e,t),s(e,Re,t),c(g,e,t),s(e,Ne,t),c(j,e,t),s(e,Se,t),c(f,e,t),s(e,$e,t),s(e,B,t),s(e,Qe,t),s(e,x,t),s(e,_e,t),s(e,Z,t),s(e,He,t),s(e,v,t),s(e,Ye,t),s(e,k,t),s(e,Xe,t),s(e,Ae,t),s(e,Fe,t),s(e,W,t),s(e,ze,t),c(G,e,t),s(e,qe,t),s(e,E,t),s(e,Le,t),s(e,A,t),s(e,De,t),s(e,V,t),s(e,Pe,t),s(e,R,t),s(e,Ke,t),s(e,N,t),s(e,Oe,t),s(e,S,t),s(e,et,t),s(e,$,t),s(e,tt,t),s(e,Q,t),s(e,lt,t),s(e,_,t),s(e,st,t),s(e,H,t),s(e,nt,t),c(Y,e,t),s(e,at,t),s(e,X,t),s(e,ot,t),s(e,F,t),s(e,it,t),s(e,z,t),s(e,Mt,t),c(q,e,t),s(e,pt,t),s(e,L,t),s(e,yt,t),s(e,D,t),s(e,ct,t),s(e,P,t),s(e,ut,t),c(h,e,t),s(e,Jt,t),s(e,K,t),s(e,rt,t),s(e,O,t),s(e,wt,t),c(ee,e,t),s(e,Tt,t),s(e,te,t),s(e,Ut,t),c(le,e,t),s(e,dt,t),c(se,e,t),s(e,mt,t),s(e,ne,t),s(e,It,t),c(ae,e,t),s(e,jt,t),c(oe,e,t),s(e,ht,t),s(e,ie,t),s(e,bt,t),c(Me,e,t),s(e,Ct,t),s(e,pe,t),s(e,gt,t),s(e,ye,t),s(e,ft,t),s(e,b,t),s(e,Bt,t),s(e,ce,t),s(e,xt,t),c(ue,e,t),s(e,Zt,t),s(e,Je,t),s(e,vt,t),s(e,re,t),s(e,kt,t),c(we,e,t),s(e,Wt,t),c(Te,e,t),s(e,Gt,t),c(Ue,e,t),s(e,Et,t),s(e,de,t),s(e,At,t),c(me,e,t),s(e,Vt,t),c(Ie,e,t),s(e,Rt,t),s(e,je,t),s(e,Nt,t),c(he,e,t),s(e,St,t),c(be,e,t),s(e,$t,t),s(e,Ce,t),s(e,Qt,t),s(e,ge,t),s(e,_t,t),c(fe,e,t),s(e,Ht,t),s(e,Be,t),s(e,Yt,t),c(xe,e,t),s(e,Xt,t),c(Ze,e,t),s(e,Ft,t),s(e,ve,t),s(e,zt,t),s(e,ke,t),s(e,qt,t),s(e,We,t),s(e,Lt,t),c(Ge,e,t),s(e,Dt,t),s(e,Ve,t),Pt=!0},p(e,[t]){const Ql={};t&2&&(Ql.$$scope={dirty:t,ctx:e}),j.$set(Ql);const _l={};t&2&&(_l.$$scope={dirty:t,ctx:e}),h.$set(_l)},i(e){Pt||(u(C.$$.fragment,e),u(g.$$.fragment,e),u(j.$$.fragment,e),u(f.$$.fragment,e),u(G.$$.fragment,e),u(Y.$$.fragment,e),u(q.$$.fragment,e),u(h.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(Me.$$.fragment,e),u(ue.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(Ue.$$.fragment,e),u(me.$$.fragment,e),u(Ie.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),u(fe.$$.fragment,e),u(xe.$$.fragment,e),u(Ze.$$.fragment,e),u(Ge.$$.fragment,e),Pt=!0)},o(e){J(C.$$.fragment,e),J(g.$$.fragment,e),J(j.$$.fragment,e),J(f.$$.fragment,e),J(G.$$.fragment,e),J(Y.$$.fragment,e),J(q.$$.fragment,e),J(h.$$.fragment,e),J(ee.$$.fragment,e),J(le.$$.fragment,e),J(se.$$.fragment,e),J(ae.$$.fragment,e),J(oe.$$.fragment,e),J(Me.$$.fragment,e),J(ue.$$.fragment,e),J(we.$$.fragment,e),J(Te.$$.fragment,e),J(Ue.$$.fragment,e),J(me.$$.fragment,e),J(Ie.$$.fragment,e),J(he.$$.fragment,e),J(be.$$.fragment,e),J(fe.$$.fragment,e),J(xe.$$.fragment,e),J(Ze.$$.fragment,e),J(Ge.$$.fragment,e),Pt=!1},d(e){e&&(l(d),l(T),l(I),l(Re),l(Ne),l(Se),l($e),l(B),l(Qe),l(x),l(_e),l(Z),l(He),l(v),l(Ye),l(k),l(Xe),l(Ae),l(Fe),l(W),l(ze),l(qe),l(E),l(Le),l(A),l(De),l(V),l(Pe),l(R),l(Ke),l(N),l(Oe),l(S),l(et),l($),l(tt),l(Q),l(lt),l(_),l(st),l(H),l(nt),l(at),l(X),l(ot),l(F),l(it),l(z),l(Mt),l(pt),l(L),l(yt),l(D),l(ct),l(P),l(ut),l(Jt),l(K),l(rt),l(O),l(wt),l(Tt),l(te),l(Ut),l(dt),l(mt),l(ne),l(It),l(jt),l(ht),l(ie),l(bt),l(Ct),l(pe),l(gt),l(ye),l(ft),l(b),l(Bt),l(ce),l(xt),l(Zt),l(Je),l(vt),l(re),l(kt),l(Wt),l(Gt),l(Et),l(de),l(At),l(Vt),l(Rt),l(je),l(Nt),l(St),l($t),l(Ce),l(Qt),l(ge),l(_t),l(Ht),l(Be),l(Yt),l(Xt),l(Ft),l(ve),l(zt),l(ke),l(qt),l(We),l(Lt),l(Dt),l(Ve)),l(w),r(C,e),r(g,e),r(j,e),r(f,e),r(G,e),r(Y,e),r(q,e),r(h,e),r(ee,e),r(le,e),r(se,e),r(ae,e),r(oe,e),r(Me,e),r(ue,e),r(we,e),r(Te,e),r(Ue,e),r(me,e),r(Ie,e),r(he,e),r(be,e),r(fe,e),r(xe,e),r(Ze,e),r(Ge,e)}}}const ns='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Sandbox setup for secure code execution","local":"sandbox-setup-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Advanced docker usage","local":"advanced-docker-usage","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2}],"depth":1}';function as(Ee){return ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class us extends Ll{constructor(w){super(),Dl(this,w,as,ss,Fl,{})}}export{us as component};
