import{s as Pl,o as Kl,n as Te}from"../chunks/scheduler.7da89386.js";import{S as Ol,i as en,g as w,s as a,r as M,A as ln,h as U,f as s,c as o,j as X,u as d,x as J,k as V,y as i,a as p,v as y,d as u,t as h,w as f}from"../chunks/index.0b7befd3.js";import{D as S,E as Ue}from"../chunks/ExampleCodeBlock.a2c7df44.js";import{C as ge}from"../chunks/CodeBlock.c5b6371f.js";import{H as x,E as nn}from"../chunks/getInferenceSnippets.dcce2733.js";function tn(k){let t,g="Example:",m,r,c;return r=new ge({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMHVzZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1YiUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwTW9kZSUyQyUyMGtlcm5lbGl6ZSUwQSUwQSU0MHVzZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1YiglMjJNeUN1c3RvbUxheWVyJTIyKSUwQWNsYXNzJTIwTXlDdXN0b21MYXllcihubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGhpZGRlbl9zaXplKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBoaWRkZW5fc2l6ZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHglM0ElMjB0b3JjaC5UZW5zb3IpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwb3JpZ2luYWwlMjBpbXBsZW1lbnRhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEFtb2RlbCUyMCUzRCUyME15Q3VzdG9tTGF5ZXIoNzY4KSUwQSUwQSUyMyUyMFRoZSUyMGxheWVyJTIwY2FuJTIwbm93JTIwYmUlMjBrZXJuZWxpemVkJTNBJTBBJTIzJTIwbW9kZWwlMjAlM0QlMjBrZXJuZWxpemUobW9kZWwlMkMlMjBtb2RlJTNETW9kZS5UUkFJTklORyUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Mode, kernelize

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;MyCustomLayer&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomLayer</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.hidden_size = hidden_size

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>):
        <span class="hljs-comment"># original implementation</span>
        <span class="hljs-keyword">return</span> x

model = MyCustomLayer(<span class="hljs-number">768</span>)

<span class="hljs-comment"># The layer can now be kernelized:</span>
<span class="hljs-comment"># model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE, device=&quot;cuda&quot;)</span>`,wrap:!1}}),{c(){t=w("p"),t.textContent=g,m=a(),M(r.$$.fragment)},l(l){t=U(l,"P",{"data-svelte-h":!0}),J(t)!=="svelte-11lpom8"&&(t.textContent=g),m=o(l),d(r.$$.fragment,l)},m(l,T){p(l,t,T),p(l,m,T),y(r,l,T),c=!0},p:Te,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),f(r,l)}}}function sn(k){let t,g="Example:",m,r,c;return r=new ge({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjByZXBsYWNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViJTBBaW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBJTBBcmVwbGFjZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1Yihubi5MYXllck5vcm0lMkMlMjAlMjJMYXllck5vcm0lMjIp",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> replace_kernel_forward_from_hub
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

replace_kernel_forward_from_hub(nn.LayerNorm, <span class="hljs-string">&quot;LayerNorm&quot;</span>)`,wrap:!1}}),{c(){t=w("p"),t.textContent=g,m=a(),M(r.$$.fragment)},l(l){t=U(l,"P",{"data-svelte-h":!0}),J(t)!=="svelte-11lpom8"&&(t.textContent=g),m=o(l),d(r.$$.fragment,l)},m(l,T){p(l,t,T),p(l,m,T),y(r,l,T),c=!0},p:Te,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),f(r,l)}}}function rn(k){let t,g="Example:",m,r,c;return r=new ge({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwdG9yY2gubm4lMjBpbXBvcnQlMjBmdW5jdGlvbmFsJTIwYXMlMjBGJTBBJTBBZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjB1c2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIlMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMHVzZV9rZXJuZWxfbWFwcGluZyUyQyUyMExheWVyUmVwb3NpdG9yeSUyQyUyMERldmljZSUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwTW9kZSUyQyUyMGtlcm5lbGl6ZSUwQSUwQSUyMyUyMERlZmluZSUyMGElMjBtYXBwaW5nJTBBbWFwcGluZyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMlNpbHVBbmRNdWwlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjdWRhJTIyJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlN0QlMEElN0QlMEElMEElNDB1c2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIoJTIyU2lsdUFuZE11bCUyMiklMEFjbGFzcyUyMFNpbHVBbmRNdWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHglM0ElMjB0b3JjaC5UZW5zb3IpJTIwLSUzRSUyMHRvcmNoLlRlbnNvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGQlMjAlM0QlMjB4LnNoYXBlJTVCLTElNUQlMjAlMkYlMkYlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zaWx1KHglNUIuLi4lMkMlMjAlM0FkJTVEKSUyMColMjB4JTVCLi4uJTJDJTIwZCUzQSU1RCUwQSUwQW1vZGVsJTIwJTNEJTIwU2lsdUFuZE11bCgpJTBBJTBBJTIzJTIwVXNlJTIwdGhlJTIwbWFwcGluZyUyMGZvciUyMHRoZSUyMGR1cmF0aW9uJTIwb2YlMjB0aGUlMjBjb250ZXh0LiUwQXdpdGglMjB1c2Vfa2VybmVsX21hcHBpbmcobWFwcGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBrZXJuZWxpemUlMjB1c2VzJTIwdGhlJTIwdGVtcG9yYXJ5JTIwbWFwcGluZyUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwa2VybmVsaXplKG1vZGVsJTJDJTIwbW9kZSUzRE1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyME91dHNpZGUlMjB0aGUlMjBjb250ZXh0JTJDJTIwb3JpZ2luYWwlMjBtYXBwaW5ncyUyMGFyZSUyMHJlc3RvcmVk",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> torch.nn <span class="hljs-keyword">import</span> functional <span class="hljs-keyword">as</span> F

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_mapping, LayerRepository, Device
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Mode, kernelize

<span class="hljs-comment"># Define a mapping</span>
mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>) -&gt; torch.Tensor:
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(x[..., :d]) * x[..., d:]

model = SiluAndMul()

<span class="hljs-comment"># Use the mapping for the duration of the context.</span>
<span class="hljs-keyword">with</span> use_kernel_mapping(mapping):
    <span class="hljs-comment"># kernelize uses the temporary mapping</span>
    model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE, device=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Outside the context, original mappings are restored</span>`,wrap:!1}}),{c(){t=w("p"),t.textContent=g,m=a(),M(r.$$.fragment)},l(l){t=U(l,"P",{"data-svelte-h":!0}),J(t)!=="svelte-11lpom8"&&(t.textContent=g),m=o(l),d(r.$$.fragment,l)},m(l,T){p(l,t,T),p(l,m,T),y(r,l,T),c=!0},p:Te,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),f(r,l)}}}function an(k){let t,g="Example:",m,r,c;return r=new ge({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LayerRepository, register_kernel_mapping, Mode

<span class="hljs-comment"># Simple mapping for a single kernel per device</span>
kernel_layer_mapping = {
    <span class="hljs-string">&quot;LlamaRMSNorm&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;RmsNorm&quot;</span>,
            revision=<span class="hljs-string">&quot;layers&quot;</span>,
        ),
    },
}
register_kernel_mapping(kernel_layer_mapping)

<span class="hljs-comment"># Advanced mapping with mode-specific kernels</span>
advanced_mapping = {
    <span class="hljs-string">&quot;MultiHeadAttention&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;username/training-kernels&quot;</span>,
                layer_name=<span class="hljs-string">&quot;TrainingAttention&quot;</span>
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;username/inference-kernels&quot;</span>,
                layer_name=<span class="hljs-string">&quot;FastAttention&quot;</span>
            ),
        }
    }
}
register_kernel_mapping(advanced_mapping)`,wrap:!1}}),{c(){t=w("p"),t.textContent=g,m=a(),M(r.$$.fragment)},l(l){t=U(l,"P",{"data-svelte-h":!0}),J(t)!=="svelte-11lpom8"&&(t.textContent=g),m=o(l),d(r.$$.fragment,l)},m(l,T){p(l,t,T),p(l,m,T),y(r,l,T),c=!0},p:Te,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),f(r,l)}}}function on(k){let t,g="Example:",m,r,c;return r=new ge({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMGtlcm5lbGl6ZSUyQyUyME1vZGUlMkMlMjByZWdpc3Rlcl9rZXJuZWxfbWFwcGluZyUyQyUyMExheWVyUmVwb3NpdG9yeSUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViJTBBJTBBJTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4JTNBJTIwdG9yY2guVGVuc29yKSUyMC0lM0UlMjB0b3JjaC5UZW5zb3IlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkJTIwJTNEJTIweC5zaGFwZSU1Qi0xJTVEJTIwJTJGJTJGJTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEYuc2lsdSh4JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIweCU1Qi4uLiUyQyUyMGQlM0ElNUQlMEElMEFtYXBwaW5nJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyTGF5ZXJOb3JtJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdEJTBBcmVnaXN0ZXJfa2VybmVsX21hcHBpbmcobWFwcGluZyklMEElMEElMjMlMjBDcmVhdGUlMjBhbmQlMjBrZXJuZWxpemUlMjBhJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMG5uLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwbm4uTGluZWFyKDEwMjQlMkMlMjAyMDQ4JTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiklMkMlMEElMjAlMjAlMjAlMjBTaWx1QW5kTXVsKCklMkMlMEEpJTBBJTBBJTIzJTIwS2VybmVsaXplJTIwZm9yJTIwaW5mZXJlbmNlJTBBa2VybmVsaXplZF9tb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLlRSQUlOSU5HJTIwJTdDJTIwTW9kZS5UT1JDSF9DT01QSUxFKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> kernelize, Mode, register_kernel_mapping, LayerRepository
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>) -&gt; torch.Tensor:
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(x[..., :d]) * x[..., d:]

mapping = {
    <span class="hljs-string">&quot;LayerNorm&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}
register_kernel_mapping(mapping)

<span class="hljs-comment"># Create and kernelize a model</span>
model = nn.Sequential(
    nn.Linear(<span class="hljs-number">1024</span>, <span class="hljs-number">2048</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>),
    SiluAndMul(),
)

<span class="hljs-comment"># Kernelize for inference</span>
kernelized_model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),{c(){t=w("p"),t.textContent=g,m=a(),M(r.$$.fragment)},l(l){t=U(l,"P",{"data-svelte-h":!0}),J(t)!=="svelte-11lpom8"&&(t.textContent=g),m=o(l),d(r.$$.fragment,l)},m(l,T){p(l,t,T),p(l,m,T),y(r,l,T),c=!0},p:Te,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),f(r,l)}}}function pn(k){let t,g="Example:",m,r,c;return r=new ge({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBEZXZpY2UlMkMlMjBDVURBUHJvcGVydGllcyUwQSUwQSUyMyUyMEJhc2ljJTIwQ1VEQSUyMGRldmljZSUwQWN1ZGFfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyMENVREElMjBkZXZpY2UlMjB3aXRoJTIwc3BlY2lmaWMlMjBjYXBhYmlsaXR5JTIwcmVxdWlyZW1lbnRzJTBBY3VkYV9kZXZpY2Vfd2l0aF9wcm9wcyUyMCUzRCUyMERldmljZSglMEElMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyhtaW5fY2FwYWJpbGl0eSUzRDc1JTJDJTIwbWF4X2NhcGFiaWxpdHklM0Q5MCklMEEpJTBBJTBBJTIzJTIwTVBTJTIwZGV2aWNlJTIwZm9yJTIwQXBwbGUlMjBTaWxpY29uJTBBbXBzX2RldmljZSUyMCUzRCUyMERldmljZSh0eXBlJTNEJTIybXBzJTIyKSUwQSUwQSUyMyUyMFhQVSUyMGRldmljZSUyMChlLmcuJTJDJTIwSW50ZWwoUiklMjBEYXRhJTIwQ2VudGVyJTIwR1BVJTIwTWF4JTIwMTU1MCklMEF4cHVfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJ4cHUlMjIp",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Device, CUDAProperties

<span class="hljs-comment"># Basic CUDA device</span>
cuda_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># CUDA device with specific capability requirements</span>
cuda_device_with_props = Device(
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
    properties=CUDAProperties(min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">90</span>)
)

<span class="hljs-comment"># MPS device for Apple Silicon</span>
mps_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;mps&quot;</span>)

<span class="hljs-comment"># XPU device (e.g., Intel(R) Data Center GPU Max 1550)</span>
xpu_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;xpu&quot;</span>)`,wrap:!1}}),{c(){t=w("p"),t.textContent=g,m=a(),M(r.$$.fragment)},l(l){t=U(l,"P",{"data-svelte-h":!0}),J(t)!=="svelte-11lpom8"&&(t.textContent=g),m=o(l),d(r.$$.fragment,l)},m(l,T){p(l,t,T),p(l,m,T),y(r,l,T),c=!0},p:Te,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),f(r,l)}}}function cn(k){let t,g="Example:",m,r,c;return r=new ge({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBMYXllclJlcG9zaXRvcnklMEElMEElMjMlMjBSZWZlcmVuY2UlMjBhJTIwc3BlY2lmaWMlMjBsYXllciUyMGJ5JTIwcmV2aXNpb24lMEFsYXllcl9yZXBvJTIwJTNEJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSklMEElMEElMjMlMjBSZWZlcmVuY2UlMjBhJTIwbGF5ZXIlMjBieSUyMHZlcnNpb24lMjBjb25zdHJhaW50JTBBbGF5ZXJfcmVwb192ZXJzaW9uZWQlMjAlM0QlMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdmVyc2lvbiUzRCUyMiUzRSUzRDAuMC4zJTJDJTNDMC4xJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LayerRepository

<span class="hljs-comment"># Reference a specific layer by revision</span>
layer_repo = LayerRepository(
    repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
)

<span class="hljs-comment"># Reference a layer by version constraint</span>
layer_repo_versioned = LayerRepository(
    repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
    version=<span class="hljs-string">&quot;&gt;=0.0.3,&lt;0.1&quot;</span>
)`,wrap:!1}}),{c(){t=w("p"),t.textContent=g,m=a(),M(r.$$.fragment)},l(l){t=U(l,"P",{"data-svelte-h":!0}),J(t)!=="svelte-11lpom8"&&(t.textContent=g),m=o(l),d(r.$$.fragment,l)},m(l,T){p(l,t,T),p(l,m,T),y(r,l,T),c=!0},p:Te,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){h(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),f(r,l)}}}function mn(k){let t,g,m,r,c,l,T,Se,P,Ne,b,K,il,Je,El="Decorator factory that makes a layer extensible using the specified layer name.",cl,ke,Al=`This is a decorator factory that returns a decorator which prepares a layer class to use kernels from the
Hugging Face Hub.`,ml,N,Qe,O,Fe,$,ee,Ml,je,Rl="Function that prepares a layer class to use kernels from the Hugging Face Hub.",dl,be,Gl=`It is recommended to use <a href="/docs/kernels/pr_152/en/api/layers#kernels.use_kernel_forward_from_hub">use_kernel_forward_from_hub()</a> decorator instead.
This function should only be used as a last resort to extend third-party layers,
it is inherently fragile since the member variables and <code>forward</code> signature
of usch a layer can change.`,yl,Q,ze,le,De,ne,Le,C,te,ul,$e,Wl="Context manager that sets a kernel mapping for the duration of the context.",hl,Ce,Xl=`This function allows temporary kernel mappings to be applied within a specific context, enabling different
kernel configurations for different parts of your code.`,fl,F,Ye,se,He,_,re,wl,_e,Vl="Register a global mapping between layer names and their corresponding kernel implementations.",Ul,Ie,Sl=`This function allows you to register a mapping between a layer name and the corresponding kernel(s) to use,
depending on the device and mode. This should be used in conjunction with <a href="/docs/kernels/pr_152/en/api/layers#kernels.kernelize">kernelize()</a>.`,Tl,z,qe,ae,Pe,oe,Ke,I,pe,gl,ve,Nl="Replace layer forward methods with optimized kernel implementations.",Jl,Be,Ql=`This function iterates over all modules in the model and replaces the <code>forward</code> method of extensible layers
for which kernels are registered using <a href="/docs/kernels/pr_152/en/api/layers#kernels.register_kernel_mapping">register_kernel_mapping()</a> or <a href="/docs/kernels/pr_152/en/api/layers#kernels.use_kernel_mapping">use_kernel_mapping()</a>.`,kl,D,Oe,ie,el,ce,ll,j,me,jl,xe,Fl="Represents a compute device with optional properties.",bl,Ze,zl=`This class encapsulates device information including device type and optional device-specific properties
like CUDA capabilities.`,$l,L,Cl,Y,Me,_l,Ee,Dl="Create an appropriate repository set for this device type.",nl,de,tl,v,ye,Il,Ae,Ll="Kernelize mode",vl,Re,Yl=`The <code>Mode</code> flag is used by <a href="/docs/kernels/pr_152/en/api/layers#kernels.kernelize">kernelize()</a> to select kernels for the given mode. Mappings can be registered for
specific modes.`,Bl,Ge,Hl=`Note:
Different modes can be combined. For instance, <code>INFERENCE | TORCH_COMPILE</code> should be used for layers that
are used for inference <em>with</em> <code>torch.compile</code>.`,sl,ue,rl,Z,he,xl,We,ql="Repository and name of a layer for kernel mapping.",Zl,H,al,fe,ol,Ve,pl;return c=new x({props:{title:"Layers API Reference",local:"layers-api-reference",headingTag:"h1"}}),T=new x({props:{title:"Making layers kernel-aware",local:"making-layers-kernel-aware",headingTag:"h2"}}),P=new x({props:{title:"use_kernel_forward_from_hub",local:"kernels.use_kernel_forward_from_hub",headingTag:"h3"}}),K=new S({props:{name:"kernels.use_kernel_forward_from_hub",anchor:"kernels.use_kernel_forward_from_hub",parameters:[{name:"layer_name",val:": str"}],parametersDescription:[{anchor:"kernels.use_kernel_forward_from_hub.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer to use for kernel lookup in registered mappings.`,name:"layer_name"}],source:"https://github.com/huggingface/kernels/blob/vr_152/src/kernels/layer.py#L963",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A decorator function that can be applied to layer classes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Callable</code></p>
`}}),N=new Ue({props:{anchor:"kernels.use_kernel_forward_from_hub.example",$$slots:{default:[tn]},$$scope:{ctx:k}}}),O=new x({props:{title:"replace_kernel_forward_from_hub",local:"kernels.replace_kernel_forward_from_hub",headingTag:"h3"}}),ee=new S({props:{name:"kernels.replace_kernel_forward_from_hub",anchor:"kernels.replace_kernel_forward_from_hub",parameters:[{name:"layer_name",val:": str"}],source:"https://github.com/huggingface/kernels/blob/vr_152/src/kernels/layer.py#L728"}}),Q=new Ue({props:{anchor:"kernels.replace_kernel_forward_from_hub.example",$$slots:{default:[sn]},$$scope:{ctx:k}}}),le=new x({props:{title:"Registering kernel mappings",local:"registering-kernel-mappings",headingTag:"h2"}}),ne=new x({props:{title:"use_kernel_mapping",local:"kernels.use_kernel_mapping",headingTag:"h3"}}),te=new S({props:{name:"kernels.use_kernel_mapping",anchor:"kernels.use_kernel_mapping",parameters:[{name:"mapping",val:": Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]"},{name:"inherit_mapping",val:": bool = True"}],parametersDescription:[{anchor:"kernels.use_kernel_mapping.mapping",description:`<strong>mapping</strong> (<code>Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]</code>) &#x2014;
The kernel mapping to apply. Maps layer names to device-specific kernel configurations.`,name:"mapping"},{anchor:"kernels.use_kernel_mapping.inherit_mapping",description:`<strong>inherit_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When <code>True</code>, the current mapping will be extended by <code>mapping</code> inside the context. When <code>False</code>,
only <code>mapping</code> is used inside the context.`,name:"inherit_mapping"}],source:"https://github.com/huggingface/kernels/blob/vr_152/src/kernels/layer.py#L571",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Context manager that handles the temporary kernel mapping.</p>
`}}),F=new Ue({props:{anchor:"kernels.use_kernel_mapping.example",$$slots:{default:[rn]},$$scope:{ctx:k}}}),se=new x({props:{title:"register_kernel_mapping",local:"kernels.register_kernel_mapping",headingTag:"h3"}}),re=new S({props:{name:"kernels.register_kernel_mapping",anchor:"kernels.register_kernel_mapping",parameters:[{name:"mapping",val:": Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]"},{name:"inherit_mapping",val:": bool = True"}],parametersDescription:[{anchor:"kernels.register_kernel_mapping.mapping",description:`<strong>mapping</strong> (<code>Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]</code>) &#x2014;
The kernel mapping to register globally. Maps layer names to device-specific kernels.
The mapping can specify different kernels for different modes (training, inference, etc.).`,name:"mapping"},{anchor:"kernels.register_kernel_mapping.inherit_mapping",description:`<strong>inherit_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When <code>True</code>, the current mapping will be extended by <code>mapping</code>. When <code>False</code>, the existing mappings
are erased before adding <code>mapping</code>.`,name:"inherit_mapping"}],source:"https://github.com/huggingface/kernels/blob/vr_152/src/kernels/layer.py#L650"}}),z=new Ue({props:{anchor:"kernels.register_kernel_mapping.example",$$slots:{default:[an]},$$scope:{ctx:k}}}),ae=new x({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),oe=new x({props:{title:"kernelize",local:"kernels.kernelize",headingTag:"h3"}}),pe=new S({props:{name:"kernels.kernelize",anchor:"kernels.kernelize",parameters:[{name:"model",val:": 'nn.Module'"},{name:"mode",val:": Mode"},{name:"device",val:": Optional[Union[str, 'torch.device']] = None"},{name:"use_fallback",val:": bool = True"}],parametersDescription:[{anchor:"kernels.kernelize.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The PyTorch model to kernelize.`,name:"model"},{anchor:"kernels.kernelize.mode",description:`<strong>mode</strong> (<a href="/docs/kernels/pr_152/en/api/layers#kernels.Mode">Mode</a>) &#x2014; The mode that the kernel is going to be used in. For example,
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> kernelizes the model for training with
<code>torch.compile</code>.`,name:"mode"},{anchor:"kernels.kernelize.device",description:`<strong>device</strong> (<code>Union[str, torch.device]</code>, <em>optional</em>) &#x2014;
The device type to load kernels for. Supported device types are: &#x201C;cuda&#x201D;, &#x201C;mps&#x201D;, &#x201C;rocm&#x201D;, &#x201C;xpu&#x201D;.
The device type will be inferred from the model parameters when not provided.`,name:"device"},{anchor:"kernels.kernelize.use_fallback",description:`<strong>use_fallback</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the original forward method of modules when no compatible kernel could be found.
If set to <code>False</code>, an exception will be raised in such cases.`,name:"use_fallback"}],source:"https://github.com/huggingface/kernels/blob/vr_152/src/kernels/layer.py#L797",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The kernelized model with optimized kernel implementations.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>nn.Module</code></p>
`}}),D=new Ue({props:{anchor:"kernels.kernelize.example",$$slots:{default:[on]},$$scope:{ctx:k}}}),ie=new x({props:{title:"Classes",local:"classes",headingTag:"h2"}}),ce=new x({props:{title:"Device",local:"kernels.Device",headingTag:"h3"}}),me=new S({props:{name:"class kernels.Device",anchor:"kernels.Device",parameters:[{name:"type",val:": str"},{name:"properties",val:": Optional[CUDAProperties] = None"}],parametersDescription:[{anchor:"kernels.Device.type",description:`<strong>type</strong> (<code>str</code>) &#x2014;
The device type (e.g., &#x201C;cuda&#x201D;, &#x201C;mps&#x201D;, &#x201C;rocm&#x201D;, &#x201C;xpu&#x201D;).`,name:"type"},{anchor:"kernels.Device.properties",description:`<strong>properties</strong> (<code>CUDAProperties</code>, <em>optional</em>) &#x2014;
Device-specific properties. Currently only <code>CUDAProperties</code> is supported for CUDA devices.`,name:"properties"}],source:"https://github.com/huggingface/kernels/blob/vr_152/src/kernels/layer.py#L81"}}),L=new Ue({props:{anchor:"kernels.Device.example",$$slots:{default:[pn]},$$scope:{ctx:k}}}),Me=new S({props:{name:"create_repo",anchor:"kernels.Device.create_repo",parameters:[],source:"https://github.com/huggingface/kernels/blob/vr_152/src/kernels/layer.py#L123"}}),de=new x({props:{title:"Mode",local:"kernels.Mode",headingTag:"h3"}}),ye=new S({props:{name:"class kernels.Mode",anchor:"kernels.Mode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],parametersDescription:[{anchor:"kernels.Mode.INFERENCE",description:"<strong>INFERENCE</strong> &#x2014; The kernel is used for inference.",name:"INFERENCE"},{anchor:"kernels.Mode.TRAINING",description:"<strong>TRAINING</strong> &#x2014; The kernel is used for training.",name:"TRAINING"},{anchor:"kernels.Mode.TORCH_COMPILE",description:"<strong>TORCH_COMPILE</strong> &#x2014; The kernel is used with <code>torch.compile</code>.",name:"TORCH_COMPILE"},{anchor:"kernels.Mode.FALLBACK",description:"<strong>FALLBACK</strong> &#x2014; In a kernel mapping, this kernel is used when no other mode matches.",name:"FALLBACK"}],source:"https://github.com/huggingface/kernels/blob/vr_152/src/kernels/layer.py#L43"}}),ue=new x({props:{title:"LayerRepository",local:"kernels.LayerRepository",headingTag:"h3"}}),he=new S({props:{name:"class kernels.LayerRepository",anchor:"kernels.LayerRepository",parameters:[{name:"repo_id",val:": str"},{name:"layer_name",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"version",val:": Optional[str] = None"}],parametersDescription:[{anchor:"kernels.LayerRepository.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The Hub repository containing the layer.`,name:"repo_id"},{anchor:"kernels.LayerRepository.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer within the kernel repository.`,name:"layer_name"},{anchor:"kernels.LayerRepository.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision (branch, tag, or commit) to download. Cannot be used together with <code>version</code>.`,name:"revision"},{anchor:"kernels.LayerRepository.version",description:`<strong>version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The kernel version to download. This can be a Python version specifier, such as <code>&quot;&gt;=1.0.0,&lt;2.0.0&quot;</code>.
Cannot be used together with <code>revision</code>.`,name:"version"}],source:"https://github.com/huggingface/kernels/blob/vr_152/src/kernels/layer.py#L242"}}),H=new Ue({props:{anchor:"kernels.LayerRepository.example",$$slots:{default:[cn]},$$scope:{ctx:k}}}),fe=new nn({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/api/layers.md"}}),{c(){t=w("meta"),g=a(),m=w("p"),r=a(),M(c.$$.fragment),l=a(),M(T.$$.fragment),Se=a(),M(P.$$.fragment),Ne=a(),b=w("div"),M(K.$$.fragment),il=a(),Je=w("p"),Je.textContent=El,cl=a(),ke=w("p"),ke.textContent=Al,ml=a(),M(N.$$.fragment),Qe=a(),M(O.$$.fragment),Fe=a(),$=w("div"),M(ee.$$.fragment),Ml=a(),je=w("p"),je.textContent=Rl,dl=a(),be=w("p"),be.innerHTML=Gl,yl=a(),M(Q.$$.fragment),ze=a(),M(le.$$.fragment),De=a(),M(ne.$$.fragment),Le=a(),C=w("div"),M(te.$$.fragment),ul=a(),$e=w("p"),$e.textContent=Wl,hl=a(),Ce=w("p"),Ce.textContent=Xl,fl=a(),M(F.$$.fragment),Ye=a(),M(se.$$.fragment),He=a(),_=w("div"),M(re.$$.fragment),wl=a(),_e=w("p"),_e.textContent=Vl,Ul=a(),Ie=w("p"),Ie.innerHTML=Sl,Tl=a(),M(z.$$.fragment),qe=a(),M(ae.$$.fragment),Pe=a(),M(oe.$$.fragment),Ke=a(),I=w("div"),M(pe.$$.fragment),gl=a(),ve=w("p"),ve.textContent=Nl,Jl=a(),Be=w("p"),Be.innerHTML=Ql,kl=a(),M(D.$$.fragment),Oe=a(),M(ie.$$.fragment),el=a(),M(ce.$$.fragment),ll=a(),j=w("div"),M(me.$$.fragment),jl=a(),xe=w("p"),xe.textContent=Fl,bl=a(),Ze=w("p"),Ze.textContent=zl,$l=a(),M(L.$$.fragment),Cl=a(),Y=w("div"),M(Me.$$.fragment),_l=a(),Ee=w("p"),Ee.textContent=Dl,nl=a(),M(de.$$.fragment),tl=a(),v=w("div"),M(ye.$$.fragment),Il=a(),Ae=w("p"),Ae.textContent=Ll,vl=a(),Re=w("p"),Re.innerHTML=Yl,Bl=a(),Ge=w("p"),Ge.innerHTML=Hl,sl=a(),M(ue.$$.fragment),rl=a(),Z=w("div"),M(he.$$.fragment),xl=a(),We=w("p"),We.textContent=ql,Zl=a(),M(H.$$.fragment),al=a(),M(fe.$$.fragment),ol=a(),Ve=w("p"),this.h()},l(e){const n=ln("svelte-u9bgzb",document.head);t=U(n,"META",{name:!0,content:!0}),n.forEach(s),g=o(e),m=U(e,"P",{}),X(m).forEach(s),r=o(e),d(c.$$.fragment,e),l=o(e),d(T.$$.fragment,e),Se=o(e),d(P.$$.fragment,e),Ne=o(e),b=U(e,"DIV",{class:!0});var E=X(b);d(K.$$.fragment,E),il=o(E),Je=U(E,"P",{"data-svelte-h":!0}),J(Je)!=="svelte-17ebw3h"&&(Je.textContent=El),cl=o(E),ke=U(E,"P",{"data-svelte-h":!0}),J(ke)!=="svelte-wgdatn"&&(ke.textContent=Al),ml=o(E),d(N.$$.fragment,E),E.forEach(s),Qe=o(e),d(O.$$.fragment,e),Fe=o(e),$=U(e,"DIV",{class:!0});var A=X($);d(ee.$$.fragment,A),Ml=o(A),je=U(A,"P",{"data-svelte-h":!0}),J(je)!=="svelte-17bjf1v"&&(je.textContent=Rl),dl=o(A),be=U(A,"P",{"data-svelte-h":!0}),J(be)!=="svelte-1uuhjwt"&&(be.innerHTML=Gl),yl=o(A),d(Q.$$.fragment,A),A.forEach(s),ze=o(e),d(le.$$.fragment,e),De=o(e),d(ne.$$.fragment,e),Le=o(e),C=U(e,"DIV",{class:!0});var R=X(C);d(te.$$.fragment,R),ul=o(R),$e=U(R,"P",{"data-svelte-h":!0}),J($e)!=="svelte-4v5vcp"&&($e.textContent=Wl),hl=o(R),Ce=U(R,"P",{"data-svelte-h":!0}),J(Ce)!=="svelte-124m5et"&&(Ce.textContent=Xl),fl=o(R),d(F.$$.fragment,R),R.forEach(s),Ye=o(e),d(se.$$.fragment,e),He=o(e),_=U(e,"DIV",{class:!0});var G=X(_);d(re.$$.fragment,G),wl=o(G),_e=U(G,"P",{"data-svelte-h":!0}),J(_e)!=="svelte-h5yso0"&&(_e.textContent=Vl),Ul=o(G),Ie=U(G,"P",{"data-svelte-h":!0}),J(Ie)!=="svelte-18x5ye3"&&(Ie.innerHTML=Sl),Tl=o(G),d(z.$$.fragment,G),G.forEach(s),qe=o(e),d(ae.$$.fragment,e),Pe=o(e),d(oe.$$.fragment,e),Ke=o(e),I=U(e,"DIV",{class:!0});var W=X(I);d(pe.$$.fragment,W),gl=o(W),ve=U(W,"P",{"data-svelte-h":!0}),J(ve)!=="svelte-11gfrdt"&&(ve.textContent=Nl),Jl=o(W),Be=U(W,"P",{"data-svelte-h":!0}),J(Be)!=="svelte-1tj8onz"&&(Be.innerHTML=Ql),kl=o(W),d(D.$$.fragment,W),W.forEach(s),Oe=o(e),d(ie.$$.fragment,e),el=o(e),d(ce.$$.fragment,e),ll=o(e),j=U(e,"DIV",{class:!0});var B=X(j);d(me.$$.fragment,B),jl=o(B),xe=U(B,"P",{"data-svelte-h":!0}),J(xe)!=="svelte-19eu2wi"&&(xe.textContent=Fl),bl=o(B),Ze=U(B,"P",{"data-svelte-h":!0}),J(Ze)!=="svelte-9t0i4c"&&(Ze.textContent=zl),$l=o(B),d(L.$$.fragment,B),Cl=o(B),Y=U(B,"DIV",{class:!0});var we=X(Y);d(Me.$$.fragment,we),_l=o(we),Ee=U(we,"P",{"data-svelte-h":!0}),J(Ee)!=="svelte-1naj9x1"&&(Ee.textContent=Dl),we.forEach(s),B.forEach(s),nl=o(e),d(de.$$.fragment,e),tl=o(e),v=U(e,"DIV",{class:!0});var q=X(v);d(ye.$$.fragment,q),Il=o(q),Ae=U(q,"P",{"data-svelte-h":!0}),J(Ae)!=="svelte-wlnf64"&&(Ae.textContent=Ll),vl=o(q),Re=U(q,"P",{"data-svelte-h":!0}),J(Re)!=="svelte-1ulsd5r"&&(Re.innerHTML=Yl),Bl=o(q),Ge=U(q,"P",{"data-svelte-h":!0}),J(Ge)!=="svelte-x58jtu"&&(Ge.innerHTML=Hl),q.forEach(s),sl=o(e),d(ue.$$.fragment,e),rl=o(e),Z=U(e,"DIV",{class:!0});var Xe=X(Z);d(he.$$.fragment,Xe),xl=o(Xe),We=U(Xe,"P",{"data-svelte-h":!0}),J(We)!=="svelte-1foq575"&&(We.textContent=ql),Zl=o(Xe),d(H.$$.fragment,Xe),Xe.forEach(s),al=o(e),d(fe.$$.fragment,e),ol=o(e),Ve=U(e,"P",{}),X(Ve).forEach(s),this.h()},h(){V(t,"name","hf:doc:metadata"),V(t,"content",Mn),V(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){i(document.head,t),p(e,g,n),p(e,m,n),p(e,r,n),y(c,e,n),p(e,l,n),y(T,e,n),p(e,Se,n),y(P,e,n),p(e,Ne,n),p(e,b,n),y(K,b,null),i(b,il),i(b,Je),i(b,cl),i(b,ke),i(b,ml),y(N,b,null),p(e,Qe,n),y(O,e,n),p(e,Fe,n),p(e,$,n),y(ee,$,null),i($,Ml),i($,je),i($,dl),i($,be),i($,yl),y(Q,$,null),p(e,ze,n),y(le,e,n),p(e,De,n),y(ne,e,n),p(e,Le,n),p(e,C,n),y(te,C,null),i(C,ul),i(C,$e),i(C,hl),i(C,Ce),i(C,fl),y(F,C,null),p(e,Ye,n),y(se,e,n),p(e,He,n),p(e,_,n),y(re,_,null),i(_,wl),i(_,_e),i(_,Ul),i(_,Ie),i(_,Tl),y(z,_,null),p(e,qe,n),y(ae,e,n),p(e,Pe,n),y(oe,e,n),p(e,Ke,n),p(e,I,n),y(pe,I,null),i(I,gl),i(I,ve),i(I,Jl),i(I,Be),i(I,kl),y(D,I,null),p(e,Oe,n),y(ie,e,n),p(e,el,n),y(ce,e,n),p(e,ll,n),p(e,j,n),y(me,j,null),i(j,jl),i(j,xe),i(j,bl),i(j,Ze),i(j,$l),y(L,j,null),i(j,Cl),i(j,Y),y(Me,Y,null),i(Y,_l),i(Y,Ee),p(e,nl,n),y(de,e,n),p(e,tl,n),p(e,v,n),y(ye,v,null),i(v,Il),i(v,Ae),i(v,vl),i(v,Re),i(v,Bl),i(v,Ge),p(e,sl,n),y(ue,e,n),p(e,rl,n),p(e,Z,n),y(he,Z,null),i(Z,xl),i(Z,We),i(Z,Zl),y(H,Z,null),p(e,al,n),y(fe,e,n),p(e,ol,n),p(e,Ve,n),pl=!0},p(e,[n]){const E={};n&2&&(E.$$scope={dirty:n,ctx:e}),N.$set(E);const A={};n&2&&(A.$$scope={dirty:n,ctx:e}),Q.$set(A);const R={};n&2&&(R.$$scope={dirty:n,ctx:e}),F.$set(R);const G={};n&2&&(G.$$scope={dirty:n,ctx:e}),z.$set(G);const W={};n&2&&(W.$$scope={dirty:n,ctx:e}),D.$set(W);const B={};n&2&&(B.$$scope={dirty:n,ctx:e}),L.$set(B);const we={};n&2&&(we.$$scope={dirty:n,ctx:e}),H.$set(we)},i(e){pl||(u(c.$$.fragment,e),u(T.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(N.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(Q.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(te.$$.fragment,e),u(F.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(z.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(D.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(L.$$.fragment,e),u(Me.$$.fragment,e),u(de.$$.fragment,e),u(ye.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(H.$$.fragment,e),u(fe.$$.fragment,e),pl=!0)},o(e){h(c.$$.fragment,e),h(T.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(N.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(Q.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(te.$$.fragment,e),h(F.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(z.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(D.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(L.$$.fragment,e),h(Me.$$.fragment,e),h(de.$$.fragment,e),h(ye.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(H.$$.fragment,e),h(fe.$$.fragment,e),pl=!1},d(e){e&&(s(g),s(m),s(r),s(l),s(Se),s(Ne),s(b),s(Qe),s(Fe),s($),s(ze),s(De),s(Le),s(C),s(Ye),s(He),s(_),s(qe),s(Pe),s(Ke),s(I),s(Oe),s(el),s(ll),s(j),s(nl),s(tl),s(v),s(sl),s(rl),s(Z),s(al),s(ol),s(Ve)),s(t),f(c,e),f(T,e),f(P,e),f(K),f(N),f(O,e),f(ee),f(Q),f(le,e),f(ne,e),f(te),f(F),f(se,e),f(re),f(z),f(ae,e),f(oe,e),f(pe),f(D),f(ie,e),f(ce,e),f(me),f(L),f(Me),f(de,e),f(ye),f(ue,e),f(he),f(H),f(fe,e)}}}const Mn='{"title":"Layers API Reference","local":"layers-api-reference","sections":[{"title":"Making layers kernel-aware","local":"making-layers-kernel-aware","sections":[{"title":"use_kernel_forward_from_hub","local":"kernels.use_kernel_forward_from_hub","sections":[],"depth":3},{"title":"replace_kernel_forward_from_hub","local":"kernels.replace_kernel_forward_from_hub","sections":[],"depth":3}],"depth":2},{"title":"Registering kernel mappings","local":"registering-kernel-mappings","sections":[{"title":"use_kernel_mapping","local":"kernels.use_kernel_mapping","sections":[],"depth":3},{"title":"register_kernel_mapping","local":"kernels.register_kernel_mapping","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"kernelize","local":"kernels.kernelize","sections":[],"depth":3}],"depth":2},{"title":"Classes","local":"classes","sections":[{"title":"Device","local":"kernels.Device","sections":[],"depth":3},{"title":"Mode","local":"kernels.Mode","sections":[],"depth":3},{"title":"LayerRepository","local":"kernels.LayerRepository","sections":[],"depth":3}],"depth":2}],"depth":1}';function dn(k){return Kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Un extends Ol{constructor(t){super(),en(this,t,dn,mn,Pl,{})}}export{Un as component};
