import{s as it,n as st,o as nt}from"../chunks/scheduler.7da89386.js";import{S as at,i as rt,g as n,s as i,r,A as ot,h as a,f as t,c as s,j as tt,u as o,x as y,k as Mt,y as yt,a as M,v as p,d as U,t as T,w as c}from"../chunks/index.0b7befd3.js";import{C as d}from"../chunks/CodeBlock.c5b6371f.js";import{H as m,E as pt}from"../chunks/getInferenceSnippets.6ead4bda.js";function Ut(kl){let J,je,ue,fe,w,he,C,gl=`A kernel can provide layers in addition to kernel functions. A layer from
the Hub can replace the <code>forward</code> method of an existing layer for a certain
device type. This makes it possible to provide more performant kernels for
existing layers.`,be,u,$l=`See <a href="kernel-requirements.md">Kernel requirements</a> for more information the
requirements of Hub layers.`,Ae,I,ke,j,ge,f,El=`A layer can be made extensible with the <code>use_kernel_forward_from_hub</code>
decorator. For example:`,$e,h,Ee,b,Rl=`The decorator does not change the behavior of the class — it annotates
the class with the given name (here <code>SiluAndMul</code>). The <code>kernelize</code> function
described below uses this name to look up kernels for the layer.`,Re,A,ve,k,vl=`An existing layer that does not (yet) have the <code>use_kernel_forward_from_hub</code>
decorator can be made extensible using the <code>replace_kernel_forward_from_hub</code>
function:`,Ne,g,_e,$,Nl=`<strong>Warning:</strong> we strongly recommend using layers with a decorator, since
it signifies that the maintainer intends to keep the <code>forward</code> signature
compatible with layers from the hub.`,Be,E,Ge,R,_l=`A model will not use Hub kernels by default, even if it contains extensible
layers. To enable the use of Hub kernels in the model, it needs to be
‘kernelized’ using the <code>kernelize</code> function. This function traverses the
model graph and replaces the <code>forward</code> methods of extensible layers for which
Hub kernels are registered. <code>kernelize</code> can be used as follows:`,Ze,v,Se,N,Bl=`The <code>kernelize</code> function modifies the model in-place, the model itself is
returned as a convenience. The <code>mode</code> specifies that the model will be used
in inference. Similarly, you can ask <code>kernelize</code> to prepare the model for
training:`,Le,_,He,B,Gl=`A model that is kernelized for training can also be used for inference, but
not the other way around. If you want to change the mode of the kernelized
model, you can just run <code>kernelize</code> on the model again with the new mode.`,We,G,Zl=`If you want to compile a model with <code>torch.compile</code>, this should be indicated
in the mode as well. You can do this by combining <code>Mode.INFERENCE</code> or
<code>Mode.TRAINING</code> with <code>Mode.TORCH_COMPILE</code> using the set union (<code>|</code>) operator:`,Qe,Z,xe,S,Ve,L,Sl=`Kernels can be registered per device type. For instance, separate <code>cuda</code> and
<code>metal</code> kernels could be registered for the name <code>SiluAndMul</code>. By default,
<code>kernelize</code> will try to infer the device type from the model’s parameters.
You can pass the device type to <code>kernelize</code> if the device type cannot be
inferred (e.g. because the model has no parameters):`,Xe,H,Fe,W,ze,Q,Ll=`If the <code>TRAINING</code> and/or <code>TORCH_COMPILE</code> modes are used, but a registered
kernel does not support backward passes or <code>torch.compile</code> respectively,
<code>kernelize</code> will fall back to the original, non-kernelized, layer. You
can let <code>kernelize</code> raise an exception instead by using <code>use_fallback=False</code>:`,qe,x,Ye,V,Hl="This can be useful if you want to guarantee that Hub kernels are used.",Pe,X,Oe,F,Wl=`The kernels that are used are logged at the <code>INFO</code> level by <code>kernelize</code>.
See the <a href="https://docs.python.org/3/library/logging.html" rel="nofollow">Python logging</a>
documentation for information on how to configure logging.`,Ke,z,De,q,Ql=`<code>kernelize</code> relies on kernel mappings to find Hub kernels for layers.
Kernel mappings map a kernel name such as <code>SiluAndMul</code> to a kernel on
the Hub. For example:`,el,Y,ll,P,xl="You can register such a mapping using <code>register_kernel_mapping</code>:",tl,O,Ml,K,Vl=`This will register the kernel mapping in the current context, which is
normally global. It is recommended to scope the mapping to where it is
used with the <code>use_kernel_mapping</code> context manager:`,il,D,sl,ee,Xl=`This ensures that the mapping is not active anymore outside the
<code>with</code>-scope.`,nl,le,al,te,Fl=`You might want to register two different kernels for a particular layer,
where one kernel is optimized for a specific mode. You can do so by
registering layer repositories for specific modes. For example:`,rl,Me,ol,ie,zl=`The <code>kernelize</code> function will attempt to use the following registered
kernels for a given mode:`,yl,se,ql=`<li><code>INFERENCE</code>: <code>INFERENCE</code> → <code>INFERENCE | TORCH_COMPILE</code> → <code>TRAINING</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>INFERENCE | TORCH_COMPILE</code>: <code>INFERENCE | TORCH_COMPILE</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING</code>: <code>TRAINING</code> → <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING | TORCH_COMPILE</code>: <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li>`,pl,ne,Yl=`<code>Mode.FALLBACK</code> is a special mode that is used when no other mode matches. It
is also used when a kernel is registered without a mode, as described in the
previous section.`,Ul,ae,Tl,re,Pl=`In this case, both <code>Mode.INFERENCE | Mode.TORCH_COMPILE</code> and
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> will use the <code>Mode.FALLBACK</code> kernel,
since the other kernels do not support <code>torch.compile</code>.`,cl,oe,dl,ye,Ol=`Some kernels only work with newer CUDA architectures. For instance, some
kernels require capability 9.0 for the TMA unit on Hopper GPUs. <code>kernels</code>
supports registering layers for a range of CUDA capabilities. To do so,
you need to register the layer for a <code>Device</code> with type <code>cuda</code> and
set the supported range of CUDA capabilities with using <code>CUDAProperties</code>:`,ml,pe,Jl,Ue,Kl="Capabilities behave as follows:",wl,Te,Dl=`<li><p>The minimum and maximum capabilities are inclusive.</p></li> <li><p>When a new kernel is registered with the same min/max capabilities as
an existing kernel, the new kernel will replace the old kernel.</p></li> <li><p>When there are multiple kernels that support a capability, the kernel
with the smaller capability interval will be used. E.g. given:</p> <ul><li><code>KernelA</code> with <code>min_capability=80</code> and <code>max_capability=89</code>;</li> <li><code>KernelB</code> with <code>min_capability=75</code> and <code>max_capability=89</code>;</li> <li><code>kernelize</code> runs on a system with capability 8.6.</li></ul> <p>Then <code>KernelA</code> will be used because the interval 80..89 is smaller
than 75..89. The motivation is that kernels with smaller ranges
tend to be more optimized for a specific set of GPUs. <strong>This behavior
might still change in the future.</strong></p></li>`,Cl,ce,ul,de,et=`Registering kernels for the ROCm architecture follows the exact same
pattern as CUDA kernels, using <code>min_capability</code> and <code>max_capability</code> to restrict
a kernel to a range of ROCm capabilities.`,Il,me,jl,Je,lt=`The <code>LocalLayerRepository</code> class is provided to load a repository from
a local directory. For example:`,fl,we,hl,Ce,bl,Ie,Al;return w=new m({props:{title:"Layers",local:"layers",headingTag:"h1"}}),I=new m({props:{title:"Making a layer extensible with kernels from the hub",local:"making-a-layer-extensible-with-kernels-from-the-hub",headingTag:"h2"}}),j=new m({props:{title:"Using a decorator",local:"using-a-decorator",headingTag:"h3"}}),h=new d({props:{code:"JTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBpbnB1dCUzQSUyMHRvcmNoLlRlbnNvciklMjAtJTNFJTIwdG9yY2guVGVuc29yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZCUyMCUzRCUyMGlucHV0LnNoYXBlJTVCLTElNUQlMjAlMkYlMkYlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zaWx1KGlucHV0JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIwaW5wdXQlNUIuLi4lMkMlMjBkJTNBJTVE",highlighted:`<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, <span class="hljs-built_in">input</span>: torch.Tensor</span>) -&gt; torch.Tensor:
        d = <span class="hljs-built_in">input</span>.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(<span class="hljs-built_in">input</span>[..., :d]) * <span class="hljs-built_in">input</span>[..., d:]`,wrap:!1}}),A=new m({props:{title:"External layers",local:"external-layers",headingTag:"h3"}}),g=new d({props:{code:"ZnJvbSUyMHNvbWVsaWJyYXJ5JTIwaW1wb3J0JTIwU2lsdUFuZE11bCUwQSUwQXJlcGxhY2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIoU2lsdUFuZE11bCUyQyUyMCUyMlNpbHVBbmRNdWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> somelibrary <span class="hljs-keyword">import</span> SiluAndMul

replace_kernel_forward_from_hub(SiluAndMul, <span class="hljs-string">&quot;SiluAndMul&quot;</span>)`,wrap:!1}}),E=new m({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),v=new d({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSk=",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE)`,wrap:!1}}),_=new d({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLlRSQUlOSU5HKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.TRAINING)`,wrap:!1}}),Z=new d({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEElMEElMjMlMjBJbmZlcmVuY2UlMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSklMEElMEElMjMlMjBUcmFpbmluZyUwQW1vZGVsJTIwJTNEJTIwa2VybmVsaXplKG1vZGVsJTJDJTIwbW9kZSUzRE1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUp",highlighted:`model = MyModel(...)

<span class="hljs-comment"># Inference</span>
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE)

<span class="hljs-comment"># Training</span>
model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),S=new m({props:{title:"Kernel device",local:"kernel-device",headingTag:"h3"}}),H=new d({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBtb2RlJTNETW9kZS5JTkZFUkVOQ0Up",highlighted:`model = MyModel(...)
model = kernelize(model, device=<span class="hljs-string">&quot;cuda&quot;</span>, mode=Mode.INFERENCE)`,wrap:!1}}),W=new m({props:{title:"Fallback forward",local:"fallback-forward",headingTag:"h3"}}),x=new d({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSUyQyUyMHVzZV9mYWxsYmFjayUzREZhbHNlKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE, use_fallback=<span class="hljs-literal">False</span>)`,wrap:!1}}),X=new m({props:{title:"Inspecting kernels which kernels are used",local:"inspecting-kernels-which-kernels-are-used",headingTag:"h3"}}),z=new m({props:{title:"Registering a hub kernel for a layer",local:"registering-a-hub-kernel-for-a-layer",headingTag:"h2"}}),Y=new d({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9jbSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        <span class="hljs-string">&quot;rocm&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}`,wrap:!1}}),O=new d({props:{code:"cmVnaXN0ZXJfa2VybmVsX21hcHBpbmcoa2VybmVsX2xheWVyX21hcHBpbmcp",highlighted:"register_kernel_mapping(kernel_layer_mapping)",wrap:!1}}),D=new d({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyhrZXJuZWxfbGF5ZXJfbWFwcGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBsYXllciUyMGZvciUyMHdoaWNoJTIwdGhlJTIwbWFwcGluZyUyMGlzJTIwYXBwbGllZC4lMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLlRSQUlOSU5HJTIwJTdDJTIwTW9kZS5UT1JDSF9DT01QSUxFKQ==",highlighted:`<span class="hljs-keyword">with</span> use_kernel_mapping(kernel_layer_mapping):
    <span class="hljs-comment"># Use the layer for which the mapping is applied.</span>
    model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),le=new m({props:{title:"Registering kernels for specific modes",local:"registering-kernels-for-specific-modes",headingTag:"h3"}}),Me=new d({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUlM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
          Mode.INFERENCE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
          Mode.TRAINING | Mode.TORCH_COMPILE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
      }
    }
}`,wrap:!1}}),ae=new d({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuRkFMTEJBQ0slM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.FALLBACK: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
        }
    }
}`,wrap:!1}}),oe=new m({props:{title:"Registering kernels for specific CUDA capabilities",local:"registering-kernels-for-specific-cuda-capabilities",headingTag:"h3"}}),pe=new d({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGV2aWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvcGVydGllcyUzRENVREFQcm9wZXJ0aWVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1pbl9jYXBhYmlsaXR5JTNENzUlMkMlMjBtYXhfY2FwYWJpbGl0eSUzRDg5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMERldmljZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtaW5fY2FwYWJpbGl0eSUzRDkwJTJDJTIwbWF4X2NhcGFiaWxpdHklM0RzeXMubWF4c2l6ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taG9wcGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">89</span>
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">90</span>, max_capability=sys.maxsize
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation-hopper&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
    }
}`,wrap:!1}}),ce=new m({props:{title:"Registering kernels for specific ROCm capabilities",local:"registering-kernels-for-specific-rocm-capabilities",headingTag:"h3"}}),me=new m({props:{title:"Loading from a local repository for testing",local:"loading-from-a-local-repository-for-testing",headingTag:"h3"}}),we=new d({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExvY2FsTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9fcGF0aCUzRCUyMiUyRmhvbWUlMkZkYW5pZWwlMkZrZXJuZWxzJTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhY2thZ2VfbmFtZSUzRCUyMmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBpbmhlcml0X21hcHBpbmclM0RGYWxzZSUyQyUwQSklM0ElMEElMjAlMjAlMjAlMjBrZXJuZWxpemUobGluZWFyJTJDJTIwbW9kZSUzRE1vZGUuSU5GRVJFTkNFKQ==",highlighted:`<span class="hljs-keyword">with</span> use_kernel_mapping(
    {
        <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
            <span class="hljs-string">&quot;cuda&quot;</span>: LocalLayerRepository(
                repo_path=<span class="hljs-string">&quot;/home/daniel/kernels/activation&quot;</span>,
                package_name=<span class="hljs-string">&quot;activation&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            )
        }
    },
    inherit_mapping=<span class="hljs-literal">False</span>,
):
    kernelize(linear, mode=Mode.INFERENCE)`,wrap:!1}}),Ce=new pt({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/layers.md"}}),{c(){J=n("meta"),je=i(),ue=n("p"),fe=i(),r(w.$$.fragment),he=i(),C=n("p"),C.innerHTML=gl,be=i(),u=n("p"),u.innerHTML=$l,Ae=i(),r(I.$$.fragment),ke=i(),r(j.$$.fragment),ge=i(),f=n("p"),f.innerHTML=El,$e=i(),r(h.$$.fragment),Ee=i(),b=n("p"),b.innerHTML=Rl,Re=i(),r(A.$$.fragment),ve=i(),k=n("p"),k.innerHTML=vl,Ne=i(),r(g.$$.fragment),_e=i(),$=n("p"),$.innerHTML=Nl,Be=i(),r(E.$$.fragment),Ge=i(),R=n("p"),R.innerHTML=_l,Ze=i(),r(v.$$.fragment),Se=i(),N=n("p"),N.innerHTML=Bl,Le=i(),r(_.$$.fragment),He=i(),B=n("p"),B.innerHTML=Gl,We=i(),G=n("p"),G.innerHTML=Zl,Qe=i(),r(Z.$$.fragment),xe=i(),r(S.$$.fragment),Ve=i(),L=n("p"),L.innerHTML=Sl,Xe=i(),r(H.$$.fragment),Fe=i(),r(W.$$.fragment),ze=i(),Q=n("p"),Q.innerHTML=Ll,qe=i(),r(x.$$.fragment),Ye=i(),V=n("p"),V.textContent=Hl,Pe=i(),r(X.$$.fragment),Oe=i(),F=n("p"),F.innerHTML=Wl,Ke=i(),r(z.$$.fragment),De=i(),q=n("p"),q.innerHTML=Ql,el=i(),r(Y.$$.fragment),ll=i(),P=n("p"),P.innerHTML=xl,tl=i(),r(O.$$.fragment),Ml=i(),K=n("p"),K.innerHTML=Vl,il=i(),r(D.$$.fragment),sl=i(),ee=n("p"),ee.innerHTML=Xl,nl=i(),r(le.$$.fragment),al=i(),te=n("p"),te.textContent=Fl,rl=i(),r(Me.$$.fragment),ol=i(),ie=n("p"),ie.innerHTML=zl,yl=i(),se=n("ul"),se.innerHTML=ql,pl=i(),ne=n("p"),ne.innerHTML=Yl,Ul=i(),r(ae.$$.fragment),Tl=i(),re=n("p"),re.innerHTML=Pl,cl=i(),r(oe.$$.fragment),dl=i(),ye=n("p"),ye.innerHTML=Ol,ml=i(),r(pe.$$.fragment),Jl=i(),Ue=n("p"),Ue.textContent=Kl,wl=i(),Te=n("ul"),Te.innerHTML=Dl,Cl=i(),r(ce.$$.fragment),ul=i(),de=n("p"),de.innerHTML=et,Il=i(),r(me.$$.fragment),jl=i(),Je=n("p"),Je.innerHTML=lt,fl=i(),r(we.$$.fragment),hl=i(),r(Ce.$$.fragment),bl=i(),Ie=n("p"),this.h()},l(e){const l=ot("svelte-u9bgzb",document.head);J=a(l,"META",{name:!0,content:!0}),l.forEach(t),je=s(e),ue=a(e,"P",{}),tt(ue).forEach(t),fe=s(e),o(w.$$.fragment,e),he=s(e),C=a(e,"P",{"data-svelte-h":!0}),y(C)!=="svelte-178x673"&&(C.innerHTML=gl),be=s(e),u=a(e,"P",{"data-svelte-h":!0}),y(u)!=="svelte-v68zn9"&&(u.innerHTML=$l),Ae=s(e),o(I.$$.fragment,e),ke=s(e),o(j.$$.fragment,e),ge=s(e),f=a(e,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1jd41lf"&&(f.innerHTML=El),$e=s(e),o(h.$$.fragment,e),Ee=s(e),b=a(e,"P",{"data-svelte-h":!0}),y(b)!=="svelte-tily1x"&&(b.innerHTML=Rl),Re=s(e),o(A.$$.fragment,e),ve=s(e),k=a(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1hj9ahw"&&(k.innerHTML=vl),Ne=s(e),o(g.$$.fragment,e),_e=s(e),$=a(e,"P",{"data-svelte-h":!0}),y($)!=="svelte-13coke1"&&($.innerHTML=Nl),Be=s(e),o(E.$$.fragment,e),Ge=s(e),R=a(e,"P",{"data-svelte-h":!0}),y(R)!=="svelte-stkx9y"&&(R.innerHTML=_l),Ze=s(e),o(v.$$.fragment,e),Se=s(e),N=a(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1mdicvi"&&(N.innerHTML=Bl),Le=s(e),o(_.$$.fragment,e),He=s(e),B=a(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-xhc5xj"&&(B.innerHTML=Gl),We=s(e),G=a(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-195gdzl"&&(G.innerHTML=Zl),Qe=s(e),o(Z.$$.fragment,e),xe=s(e),o(S.$$.fragment,e),Ve=s(e),L=a(e,"P",{"data-svelte-h":!0}),y(L)!=="svelte-808tau"&&(L.innerHTML=Sl),Xe=s(e),o(H.$$.fragment,e),Fe=s(e),o(W.$$.fragment,e),ze=s(e),Q=a(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-yu926d"&&(Q.innerHTML=Ll),qe=s(e),o(x.$$.fragment,e),Ye=s(e),V=a(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-1lkusth"&&(V.textContent=Hl),Pe=s(e),o(X.$$.fragment,e),Oe=s(e),F=a(e,"P",{"data-svelte-h":!0}),y(F)!=="svelte-161p6z8"&&(F.innerHTML=Wl),Ke=s(e),o(z.$$.fragment,e),De=s(e),q=a(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-1r5il31"&&(q.innerHTML=Ql),el=s(e),o(Y.$$.fragment,e),ll=s(e),P=a(e,"P",{"data-svelte-h":!0}),y(P)!=="svelte-1mzc83p"&&(P.innerHTML=xl),tl=s(e),o(O.$$.fragment,e),Ml=s(e),K=a(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-p5ro9n"&&(K.innerHTML=Vl),il=s(e),o(D.$$.fragment,e),sl=s(e),ee=a(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-z3xuuf"&&(ee.innerHTML=Xl),nl=s(e),o(le.$$.fragment,e),al=s(e),te=a(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-1ed3b6y"&&(te.textContent=Fl),rl=s(e),o(Me.$$.fragment,e),ol=s(e),ie=a(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-sek2d8"&&(ie.innerHTML=zl),yl=s(e),se=a(e,"UL",{"data-svelte-h":!0}),y(se)!=="svelte-ewhtf4"&&(se.innerHTML=ql),pl=s(e),ne=a(e,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-m4furw"&&(ne.innerHTML=Yl),Ul=s(e),o(ae.$$.fragment,e),Tl=s(e),re=a(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-1oi4pcx"&&(re.innerHTML=Pl),cl=s(e),o(oe.$$.fragment,e),dl=s(e),ye=a(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-1wl92tu"&&(ye.innerHTML=Ol),ml=s(e),o(pe.$$.fragment,e),Jl=s(e),Ue=a(e,"P",{"data-svelte-h":!0}),y(Ue)!=="svelte-1k7nbkd"&&(Ue.textContent=Kl),wl=s(e),Te=a(e,"UL",{"data-svelte-h":!0}),y(Te)!=="svelte-xyngc6"&&(Te.innerHTML=Dl),Cl=s(e),o(ce.$$.fragment,e),ul=s(e),de=a(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-1q9vv7t"&&(de.innerHTML=et),Il=s(e),o(me.$$.fragment,e),jl=s(e),Je=a(e,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-qa4iob"&&(Je.innerHTML=lt),fl=s(e),o(we.$$.fragment,e),hl=s(e),o(Ce.$$.fragment,e),bl=s(e),Ie=a(e,"P",{}),tt(Ie).forEach(t),this.h()},h(){Mt(J,"name","hf:doc:metadata"),Mt(J,"content",Tt)},m(e,l){yt(document.head,J),M(e,je,l),M(e,ue,l),M(e,fe,l),p(w,e,l),M(e,he,l),M(e,C,l),M(e,be,l),M(e,u,l),M(e,Ae,l),p(I,e,l),M(e,ke,l),p(j,e,l),M(e,ge,l),M(e,f,l),M(e,$e,l),p(h,e,l),M(e,Ee,l),M(e,b,l),M(e,Re,l),p(A,e,l),M(e,ve,l),M(e,k,l),M(e,Ne,l),p(g,e,l),M(e,_e,l),M(e,$,l),M(e,Be,l),p(E,e,l),M(e,Ge,l),M(e,R,l),M(e,Ze,l),p(v,e,l),M(e,Se,l),M(e,N,l),M(e,Le,l),p(_,e,l),M(e,He,l),M(e,B,l),M(e,We,l),M(e,G,l),M(e,Qe,l),p(Z,e,l),M(e,xe,l),p(S,e,l),M(e,Ve,l),M(e,L,l),M(e,Xe,l),p(H,e,l),M(e,Fe,l),p(W,e,l),M(e,ze,l),M(e,Q,l),M(e,qe,l),p(x,e,l),M(e,Ye,l),M(e,V,l),M(e,Pe,l),p(X,e,l),M(e,Oe,l),M(e,F,l),M(e,Ke,l),p(z,e,l),M(e,De,l),M(e,q,l),M(e,el,l),p(Y,e,l),M(e,ll,l),M(e,P,l),M(e,tl,l),p(O,e,l),M(e,Ml,l),M(e,K,l),M(e,il,l),p(D,e,l),M(e,sl,l),M(e,ee,l),M(e,nl,l),p(le,e,l),M(e,al,l),M(e,te,l),M(e,rl,l),p(Me,e,l),M(e,ol,l),M(e,ie,l),M(e,yl,l),M(e,se,l),M(e,pl,l),M(e,ne,l),M(e,Ul,l),p(ae,e,l),M(e,Tl,l),M(e,re,l),M(e,cl,l),p(oe,e,l),M(e,dl,l),M(e,ye,l),M(e,ml,l),p(pe,e,l),M(e,Jl,l),M(e,Ue,l),M(e,wl,l),M(e,Te,l),M(e,Cl,l),p(ce,e,l),M(e,ul,l),M(e,de,l),M(e,Il,l),p(me,e,l),M(e,jl,l),M(e,Je,l),M(e,fl,l),p(we,e,l),M(e,hl,l),p(Ce,e,l),M(e,bl,l),M(e,Ie,l),Al=!0},p:st,i(e){Al||(U(w.$$.fragment,e),U(I.$$.fragment,e),U(j.$$.fragment,e),U(h.$$.fragment,e),U(A.$$.fragment,e),U(g.$$.fragment,e),U(E.$$.fragment,e),U(v.$$.fragment,e),U(_.$$.fragment,e),U(Z.$$.fragment,e),U(S.$$.fragment,e),U(H.$$.fragment,e),U(W.$$.fragment,e),U(x.$$.fragment,e),U(X.$$.fragment,e),U(z.$$.fragment,e),U(Y.$$.fragment,e),U(O.$$.fragment,e),U(D.$$.fragment,e),U(le.$$.fragment,e),U(Me.$$.fragment,e),U(ae.$$.fragment,e),U(oe.$$.fragment,e),U(pe.$$.fragment,e),U(ce.$$.fragment,e),U(me.$$.fragment,e),U(we.$$.fragment,e),U(Ce.$$.fragment,e),Al=!0)},o(e){T(w.$$.fragment,e),T(I.$$.fragment,e),T(j.$$.fragment,e),T(h.$$.fragment,e),T(A.$$.fragment,e),T(g.$$.fragment,e),T(E.$$.fragment,e),T(v.$$.fragment,e),T(_.$$.fragment,e),T(Z.$$.fragment,e),T(S.$$.fragment,e),T(H.$$.fragment,e),T(W.$$.fragment,e),T(x.$$.fragment,e),T(X.$$.fragment,e),T(z.$$.fragment,e),T(Y.$$.fragment,e),T(O.$$.fragment,e),T(D.$$.fragment,e),T(le.$$.fragment,e),T(Me.$$.fragment,e),T(ae.$$.fragment,e),T(oe.$$.fragment,e),T(pe.$$.fragment,e),T(ce.$$.fragment,e),T(me.$$.fragment,e),T(we.$$.fragment,e),T(Ce.$$.fragment,e),Al=!1},d(e){e&&(t(je),t(ue),t(fe),t(he),t(C),t(be),t(u),t(Ae),t(ke),t(ge),t(f),t($e),t(Ee),t(b),t(Re),t(ve),t(k),t(Ne),t(_e),t($),t(Be),t(Ge),t(R),t(Ze),t(Se),t(N),t(Le),t(He),t(B),t(We),t(G),t(Qe),t(xe),t(Ve),t(L),t(Xe),t(Fe),t(ze),t(Q),t(qe),t(Ye),t(V),t(Pe),t(Oe),t(F),t(Ke),t(De),t(q),t(el),t(ll),t(P),t(tl),t(Ml),t(K),t(il),t(sl),t(ee),t(nl),t(al),t(te),t(rl),t(ol),t(ie),t(yl),t(se),t(pl),t(ne),t(Ul),t(Tl),t(re),t(cl),t(dl),t(ye),t(ml),t(Jl),t(Ue),t(wl),t(Te),t(Cl),t(ul),t(de),t(Il),t(jl),t(Je),t(fl),t(hl),t(bl),t(Ie)),t(J),c(w,e),c(I,e),c(j,e),c(h,e),c(A,e),c(g,e),c(E,e),c(v,e),c(_,e),c(Z,e),c(S,e),c(H,e),c(W,e),c(x,e),c(X,e),c(z,e),c(Y,e),c(O,e),c(D,e),c(le,e),c(Me,e),c(ae,e),c(oe,e),c(pe,e),c(ce,e),c(me,e),c(we,e),c(Ce,e)}}}const Tt='{"title":"Layers","local":"layers","sections":[{"title":"Making a layer extensible with kernels from the hub","local":"making-a-layer-extensible-with-kernels-from-the-hub","sections":[{"title":"Using a decorator","local":"using-a-decorator","sections":[],"depth":3},{"title":"External layers","local":"external-layers","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"Kernel device","local":"kernel-device","sections":[],"depth":3},{"title":"Fallback forward","local":"fallback-forward","sections":[],"depth":3},{"title":"Inspecting kernels which kernels are used","local":"inspecting-kernels-which-kernels-are-used","sections":[],"depth":3}],"depth":2},{"title":"Registering a hub kernel for a layer","local":"registering-a-hub-kernel-for-a-layer","sections":[{"title":"Registering kernels for specific modes","local":"registering-kernels-for-specific-modes","sections":[],"depth":3},{"title":"Registering kernels for specific CUDA capabilities","local":"registering-kernels-for-specific-cuda-capabilities","sections":[],"depth":3},{"title":"Registering kernels for specific ROCm capabilities","local":"registering-kernels-for-specific-rocm-capabilities","sections":[],"depth":3},{"title":"Loading from a local repository for testing","local":"loading-from-a-local-repository-for-testing","sections":[],"depth":3}],"depth":2}],"depth":1}';function ct(kl){return nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends at{constructor(J){super(),rt(this,J,ct,Ut,it,{})}}export{Ct as component};
