import{s as Kt,n as el,o as tl}from"../chunks/scheduler.7da89386.js";import{S as ll,i as nl,g as s,s as i,r as m,A as il,h as r,f as l,c as a,j as ut,u as p,x as o,k as Ot,y as f,a as n,v as c,d as h,t as d,w as u}from"../chunks/index.0b7befd3.js";import{C as we}from"../chunks/CodeBlock.c5b6371f.js";import{H as y,E as al}from"../chunks/getInferenceSnippets.6ead4bda.js";function sl(bt){let J,be,Me,$e,b,ve,$,$t=`Kernels on the Hub must fulfill the requirements outlined on this page. By
ensuring kernels are compliant, they can be used on a wide range of Linux
systems and Torch builds.`,Ue,v,vt=`You can use <a href="https://github.com/huggingface/kernel-builder/" rel="nofollow">kernel-builder</a>
to build compliant kernels.`,Ce,U,Ie,C,Ut=`A kernel repository on the Hub must contain a <code>build</code> directory. This
directory contains build variants of a kernel in the form of directories
following the template
<code>&lt;framework&gt;&lt;version&gt;-cxx&lt;abiver&gt;-&lt;cu&gt;&lt;cudaver&gt;-&lt;arch&gt;-&lt;os&gt;</code>.
For example <code>build/torch26-cxx98-cu118-x86_64-linux</code>.`,ge,I,Ct=`Each variant directory must contain a single directory with the same name
as the repository (replacing <code>-</code> by <code>_</code>). For instance, kernels in the
<code>kernels-community/activation</code> repository have a directories like
<code>build/&lt;variant&gt;/activation</code>. This directory
must be a Python package with an <code>__init__.py</code> file.`,xe,g,je,x,It=`A kernel can be compliant for a specific compute framework (e.g. CUDA) or
architecture (e.g. x86_64). For compliance with a compute framework and
architecture combination, all the variants from the <a href="https://github.com/huggingface/kernel-builder/blob/main/docs/build-variants.md" rel="nofollow">build variant list</a>
must be available for that combination.`,_e,j,ke,_,gt=`Kernels are versioned on the Hub using Git tags. Version tags must be of
the form <code>v&lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;</code>. Versions are used by <a href="./locking.md">locking</a>
to resolve the version constraints.`,He,k,Le,H,xt=`Kernels will typically contain a native Python module with precompiled
compute kernels and bindings. This module must fulfill the requirements
outlined in this section. For all operating systems, a kernel must not
have dynamic library dependencies outside:`,Be,L,jt="<li>Torch;</li> <li>CUDA/ROCm libraries installed as dependencies of Torch.</li>",Ae,B,Ge,A,_t=`<li><p>Use <a href="https://docs.python.org/3/c-api/stable.html#stable-application-binary-interface" rel="nofollow">ABI3/Limited API</a>
for compatibility with Python 3.9 and later.</p></li> <li><p>Compatible with <a href="https://github.com/pypa/manylinux?tab=readme-ov-file#manylinux_2_28-almalinux-8-based" rel="nofollow"><code>manylinux_2_28</code></a>.
This means that the extension <strong>must not</strong> use symbols versions higher than:</p> <ul><li>GLIBC 2.28</li> <li>GLIBCXX 3.4.24</li> <li>CXXABI 1.3.11</li> <li>GCC 7.0.0</li></ul></li>`,Se,G,kt="These requirement can be checked with the ABI checker (see below).",Ze,S,Pe,Z,Ht=`<li>Use <a href="https://docs.python.org/3/c-api/stable.html#stable-application-binary-interface" rel="nofollow">ABI3/Limited API</a>
for compatibility with Python 3.9 and later.</li> <li>macOS deployment target 15.0.</li> <li>Metal 3.0 (<code>-std=metal3.0</code>).</li>`,Ee,P,Lt="The ABI3 requirement can be checked with the ABI checker (see below).",ze,E,Fe,z,Bt=`The manylinux_2_28 and Python ABI 3.9 version requirements can be checked with
<a href="https://crates.io/crates/kernel-abi-check" rel="nofollow"><code>kernel-abi-check</code></a>:`,Ne,F,Ve,N,Qe,V,At=`Torch native extension functions must be <a href="https://pytorch.org/tutorials/advanced/cpp_custom_ops.html#cpp-custom-ops-tutorial" rel="nofollow">registered</a>
in <code>torch.ops.&lt;namespace&gt;</code>. Since we allow loading of multiple versions of
a module in the same Python process, <code>namespace</code> must be unique for each
version of a kernel. Failing to do so will create clashes when different
versions of the same kernel are loaded. Two suggested ways of doing this
are:`,Re,Q,Gt=`<li>Appending a truncated SHA-1 hash of the git commit that the kernel was
built from to the name of the extension.</li> <li>Appending random material to the name of the extension.</li>`,We,R,St=`<strong>Note:</strong> we recommend against appending a version number or git tag.
Version numbers are typically not bumped on each commit, so users
might use two different commits that happen to have the same version
number. Git tags are not stable, so they do not provide a good way
of guaranteeing uniqueness of the namespace.`,Xe,W,Ye,X,Zt=`A kernel can provide layers in addition to kernel functions. A layer from
the Hub can replace the <code>forward</code> method of an existing layer for a certain
device type. This makes it possible to provide more performant kernels for
existing layers. See the <a href="layers.md">layers documentation</a> for more information
on how to use layers.`,qe,Y,De,q,Pt=`To make the extension of layers safe, the layers must fulfill the following
requirements:`,Oe,D,Et=`<li>The layers are subclasses of <code>torch.nn.Module</code>.</li> <li>The layers are pure, meaning that they do not have their own state. This
means that:<ul><li>The layer must not define its own constructor.</li> <li>The layer must not use class variables.</li></ul></li> <li>No other methods must be defined than <code>forward</code>.</li> <li>The <code>forward</code> method has a signature that is compatible with the
<code>forward</code> method that it is extending.</li>`,Ke,O,zt="There are two exceptions to the <em>no class variables rule</em>:",et,K,Ft=`<li>The <code>has_backward</code> variable can be used to indicate whether the layer has
a backward pass implemented (<code>True</code> when absent).</li> <li>The <code>can_torch_compile</code> variable can be used to indicate whether the layer
supports <code>torch.compile</code> (<code>False</code> when absent).</li>`,tt,ee,Nt="This is an example of a pure layer:",lt,te,nt,le,Vt=`For some layers, the <code>forward</code> method has to use state from the adopting class.
In these cases, we recommend to use type annotations to indicate what member
variables are expected. For instance:`,it,ne,at,ie,Qt=`This layer expects the adopting layer to have <code>weight</code> and <code>variance_epsilon</code>
member variables and uses them in the <code>forward</code> method.`,st,ae,rt,se,Rt=`To accommodate portable loading, <code>layers</code> must be defined in the main
<code>__init__.py</code> file. For example:`,ot,re,mt,oe,pt,w,he,Wt="<p>Python code must be compatible with Python 3.9 and later.</p>",Tt,T,de,Xt=`All Python code imports from the kernel itself must be relative. So,
for instance if in the example kernel <code>example</code>,
<code>module_b</code> needs a function from <code>module_a</code>, import as:`,ft,me,yt,ue,Yt="<strong>Never use:</strong>",wt,pe,Mt,Te,qt=`The latter would import from the module <code>example</code> that is in Python’s
global module dict. However, since we allow loading multiple versions
of a module, we uniquely name the module.`,Jt,fe,Dt=`<p>Only modules from the Python standard library, Torch, or the kernel itself
can be imported.</p>`,ct,ce,ht,Je,dt;return b=new y({props:{title:"Kernel requirements",local:"kernel-requirements",headingTag:"h1"}}),U=new y({props:{title:"Directory layout",local:"directory-layout",headingTag:"h2"}}),g=new y({props:{title:"Build variants",local:"build-variants",headingTag:"h2"}}),j=new y({props:{title:"Versioning",local:"versioning",headingTag:"h2"}}),k=new y({props:{title:"Native Python module",local:"native-python-module",headingTag:"h2"}}),B=new y({props:{title:"Linux",local:"linux",headingTag:"h3"}}),S=new y({props:{title:"macOS",local:"macos",headingTag:"h3"}}),E=new y({props:{title:"ABI checker",local:"abi-checker",headingTag:"h3"}}),F=new we({props:{code:"JTBBJTI0JTIwY2FyZ28lMjBpbnN0YWxsJTIwa2VybmVsLWFiaS1jaGVjayUwQSUyNCUyMGtlcm5lbC1hYmktY2hlY2slMjByZXN1bHQlMkZyZWx1JTJGX3JlbHVfZTg3ZTBjYV9kaXJ0eS5hYmkzLnNvJTBBJUYwJTlGJTkwJThEJTIwQ2hlY2tpbmclMjBmb3IlMjBjb21wYXRpYmlsaXR5JTIwd2l0aCUyMG1hbnlsaW51eF8yXzI4JTIwYW5kJTIwUHl0aG9uJTIwQUJJJTIwdmVyc2lvbiUyMDMuOSUwQSVFMiU5QyU4NSUyME5vJTIwY29tcGF0aWJpbGl0eSUyMGlzc3VlcyUyMGZvdW5k",highlighted:`
$ cargo install kernel-abi-check
$ kernel-abi-check result/relu/_relu_e87e0ca_dirty.abi3.so
🐍 Checking <span class="hljs-keyword">for</span> compatibility with manylinux_2_28 and Python ABI version 3.9
✅ No compatibility issues found`,wrap:!1}}),N=new y({props:{title:"Torch extension",local:"torch-extension",headingTag:"h2"}}),W=new y({props:{title:"Layers",local:"layers",headingTag:"h2"}}),Y=new y({props:{title:"Writing layers",local:"writing-layers",headingTag:"h3"}}),te=new we({props:{code:"Y2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGlzJTIwbGF5ZXIlMjBkb2VzJTIwbm90JTIwaW1wbGVtZW50JTIwYmFja3dhcmQuJTBBJTIwJTIwJTIwJTIwaGFzX2JhY2t3YXJkJTNBJTIwYm9vbCUyMCUzRCUyMEZhbHNlJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCUzQSUyMHRvcmNoLlRlbnNvciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkJTIwJTNEJTIweC5zaGFwZSU1Qi0xJTVEJTIwJTJGJTJGJTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF9zaGFwZSUyMCUzRCUyMHguc2hhcGUlNUIlM0EtMSU1RCUyMCUyQiUyMChkJTJDKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMHRvcmNoLmVtcHR5KG91dHB1dF9zaGFwZSUyQyUyMGR0eXBlJTNEeC5kdHlwZSUyQyUyMGRldmljZSUzRHguZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wcy5zaWx1X2FuZF9tdWwob3V0JTJDJTIweCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXQ=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-comment"># This layer does not implement backward.</span>
    has_backward: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>):
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        output_shape = x.shape[:-<span class="hljs-number">1</span>] + (d,)
        out = torch.empty(output_shape, dtype=x.dtype, device=x.device)
        ops.silu_and_mul(out, x)
        <span class="hljs-keyword">return</span> out`,wrap:!1}}),ne=new we({props:{code:"Y2xhc3MlMjBMbGFtYVJNU05vcm0obm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMHdlaWdodCUzQSUyMHRvcmNoLlRlbnNvciUwQSUyMCUyMCUyMCUyMHZhcmlhbmNlX2Vwc2lsb24lM0ElMjBmbG9hdCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGhpZGRlbl9zdGF0ZXMlM0ElMjB0b3JjaC5UZW5zb3IpJTIwLSUzRSUyMHRvcmNoLlRlbnNvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHJtc19ub3JtX2ZuKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLndlaWdodCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJpYXMlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXBzJTNEc2VsZi52YXJpYW5jZV9lcHNpbG9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJvcG91dF9wJTNEMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlbm9ybSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWxfaW5fZnAzMiUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaRMSNorm</span>(nn.Module):
    weight: torch.Tensor
    variance_epsilon: <span class="hljs-built_in">float</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states: torch.Tensor</span>) -&gt; torch.Tensor:
        <span class="hljs-keyword">return</span> rms_norm_fn(
            hidden_states,
            self.weight,
            bias=<span class="hljs-literal">None</span>,
            residual=<span class="hljs-literal">None</span>,
            eps=self.variance_epsilon,
            dropout_p=<span class="hljs-number">0.0</span>,
            prenorm=<span class="hljs-literal">False</span>,
            residual_in_fp32=<span class="hljs-literal">False</span>,
        )`,wrap:!1}}),ae=new y({props:{title:"Exporting layers",local:"exporting-layers",headingTag:"h3"}}),re=new we({props:{code:"ZnJvbSUyMC4lMjBpbXBvcnQlMjBsYXllcnMlMEElMEFfX2FsbF9fJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIzJTIwLi4uJTBBJTIwJTIwJTIybGF5ZXJzJTIyJTBBJTIwJTIwJTIzJTIwLi4uJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> . <span class="hljs-keyword">import</span> layers

__all__ = [
  <span class="hljs-comment"># ...</span>
  <span class="hljs-string">&quot;layers&quot;</span>
  <span class="hljs-comment"># ...</span>
]`,wrap:!1}}),oe=new y({props:{title:"Python requirements",local:"python-requirements",headingTag:"h2"}}),me=new we({props:{code:"ZnJvbSUyMC5tb2R1bGVfYSUyMGltcG9ydCUyMGZvbw==",highlighted:'<span class="hljs-keyword">from</span> .module_a <span class="hljs-keyword">import</span> foo',wrap:!1}}),pe=new we({props:{code:"JTIzJTIwRE8lMjBOT1QlMjBETyUyMFRISVMhJTBBJTBBZnJvbSUyMGV4YW1wbGUubW9kdWxlX2ElMjBpbXBvcnQlMjBmb28=",highlighted:`<span class="hljs-comment"># DO NOT DO THIS!</span>

<span class="hljs-keyword">from</span> example.module_a <span class="hljs-keyword">import</span> foo`,wrap:!1}}),ce=new al({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/kernel-requirements.md"}}),{c(){J=s("meta"),be=i(),Me=s("p"),$e=i(),m(b.$$.fragment),ve=i(),$=s("p"),$.textContent=$t,Ue=i(),v=s("p"),v.innerHTML=vt,Ce=i(),m(U.$$.fragment),Ie=i(),C=s("p"),C.innerHTML=Ut,ge=i(),I=s("p"),I.innerHTML=Ct,xe=i(),m(g.$$.fragment),je=i(),x=s("p"),x.innerHTML=It,_e=i(),m(j.$$.fragment),ke=i(),_=s("p"),_.innerHTML=gt,He=i(),m(k.$$.fragment),Le=i(),H=s("p"),H.textContent=xt,Be=i(),L=s("ul"),L.innerHTML=jt,Ae=i(),m(B.$$.fragment),Ge=i(),A=s("ul"),A.innerHTML=_t,Se=i(),G=s("p"),G.textContent=kt,Ze=i(),m(S.$$.fragment),Pe=i(),Z=s("ul"),Z.innerHTML=Ht,Ee=i(),P=s("p"),P.textContent=Lt,ze=i(),m(E.$$.fragment),Fe=i(),z=s("p"),z.innerHTML=Bt,Ne=i(),m(F.$$.fragment),Ve=i(),m(N.$$.fragment),Qe=i(),V=s("p"),V.innerHTML=At,Re=i(),Q=s("ul"),Q.innerHTML=Gt,We=i(),R=s("p"),R.innerHTML=St,Xe=i(),m(W.$$.fragment),Ye=i(),X=s("p"),X.innerHTML=Zt,qe=i(),m(Y.$$.fragment),De=i(),q=s("p"),q.textContent=Pt,Oe=i(),D=s("ul"),D.innerHTML=Et,Ke=i(),O=s("p"),O.innerHTML=zt,et=i(),K=s("ol"),K.innerHTML=Ft,tt=i(),ee=s("p"),ee.textContent=Nt,lt=i(),m(te.$$.fragment),nt=i(),le=s("p"),le.innerHTML=Vt,it=i(),m(ne.$$.fragment),at=i(),ie=s("p"),ie.innerHTML=Qt,st=i(),m(ae.$$.fragment),rt=i(),se=s("p"),se.innerHTML=Rt,ot=i(),m(re.$$.fragment),mt=i(),m(oe.$$.fragment),pt=i(),w=s("ul"),he=s("li"),he.innerHTML=Wt,Tt=i(),T=s("li"),de=s("p"),de.innerHTML=Xt,ft=i(),m(me.$$.fragment),yt=i(),ue=s("p"),ue.innerHTML=Yt,wt=i(),m(pe.$$.fragment),Mt=i(),Te=s("p"),Te.innerHTML=qt,Jt=i(),fe=s("li"),fe.innerHTML=Dt,ct=i(),m(ce.$$.fragment),ht=i(),Je=s("p"),this.h()},l(e){const t=il("svelte-u9bgzb",document.head);J=r(t,"META",{name:!0,content:!0}),t.forEach(l),be=a(e),Me=r(e,"P",{}),ut(Me).forEach(l),$e=a(e),p(b.$$.fragment,e),ve=a(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-omjx4j"&&($.textContent=$t),Ue=a(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-mwob7l"&&(v.innerHTML=vt),Ce=a(e),p(U.$$.fragment,e),Ie=a(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1j93b1m"&&(C.innerHTML=Ut),ge=a(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1cuxqpl"&&(I.innerHTML=Ct),xe=a(e),p(g.$$.fragment,e),je=a(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-11ghnwy"&&(x.innerHTML=It),_e=a(e),p(j.$$.fragment,e),ke=a(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1869t00"&&(_.innerHTML=gt),He=a(e),p(k.$$.fragment,e),Le=a(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-17te4hc"&&(H.textContent=xt),Be=a(e),L=r(e,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-17x1sgf"&&(L.innerHTML=jt),Ae=a(e),p(B.$$.fragment,e),Ge=a(e),A=r(e,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-1lza6fb"&&(A.innerHTML=_t),Se=a(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-ws4wqr"&&(G.textContent=kt),Ze=a(e),p(S.$$.fragment,e),Pe=a(e),Z=r(e,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-nrm36c"&&(Z.innerHTML=Ht),Ee=a(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1xbbttu"&&(P.textContent=Lt),ze=a(e),p(E.$$.fragment,e),Fe=a(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-16l01xm"&&(z.innerHTML=Bt),Ne=a(e),p(F.$$.fragment,e),Ve=a(e),p(N.$$.fragment,e),Qe=a(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1z00i8l"&&(V.innerHTML=At),Re=a(e),Q=r(e,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-1n44n6m"&&(Q.innerHTML=Gt),We=a(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-vo8uhp"&&(R.innerHTML=St),Xe=a(e),p(W.$$.fragment,e),Ye=a(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-17jmyq"&&(X.innerHTML=Zt),qe=a(e),p(Y.$$.fragment,e),De=a(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-ew142v"&&(q.textContent=Pt),Oe=a(e),D=r(e,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-pm5vd9"&&(D.innerHTML=Et),Ke=a(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-17brked"&&(O.innerHTML=zt),et=a(e),K=r(e,"OL",{"data-svelte-h":!0}),o(K)!=="svelte-1a9mvrx"&&(K.innerHTML=Ft),tt=a(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-mthj86"&&(ee.textContent=Nt),lt=a(e),p(te.$$.fragment,e),nt=a(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1xsl1kb"&&(le.innerHTML=Vt),it=a(e),p(ne.$$.fragment,e),at=a(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-9hcs08"&&(ie.innerHTML=Qt),st=a(e),p(ae.$$.fragment,e),rt=a(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1jwjnkj"&&(se.innerHTML=Rt),ot=a(e),p(re.$$.fragment,e),mt=a(e),p(oe.$$.fragment,e),pt=a(e),w=r(e,"UL",{});var ye=ut(w);he=r(ye,"LI",{"data-svelte-h":!0}),o(he)!=="svelte-1yjmw8t"&&(he.innerHTML=Wt),Tt=a(ye),T=r(ye,"LI",{});var M=ut(T);de=r(M,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1xx048c"&&(de.innerHTML=Xt),ft=a(M),p(me.$$.fragment,M),yt=a(M),ue=r(M,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-ca1g42"&&(ue.innerHTML=Yt),wt=a(M),p(pe.$$.fragment,M),Mt=a(M),Te=r(M,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1v83762"&&(Te.innerHTML=qt),M.forEach(l),Jt=a(ye),fe=r(ye,"LI",{"data-svelte-h":!0}),o(fe)!=="svelte-wkdo8"&&(fe.innerHTML=Dt),ye.forEach(l),ct=a(e),p(ce.$$.fragment,e),ht=a(e),Je=r(e,"P",{}),ut(Je).forEach(l),this.h()},h(){Ot(J,"name","hf:doc:metadata"),Ot(J,"content",rl)},m(e,t){f(document.head,J),n(e,be,t),n(e,Me,t),n(e,$e,t),c(b,e,t),n(e,ve,t),n(e,$,t),n(e,Ue,t),n(e,v,t),n(e,Ce,t),c(U,e,t),n(e,Ie,t),n(e,C,t),n(e,ge,t),n(e,I,t),n(e,xe,t),c(g,e,t),n(e,je,t),n(e,x,t),n(e,_e,t),c(j,e,t),n(e,ke,t),n(e,_,t),n(e,He,t),c(k,e,t),n(e,Le,t),n(e,H,t),n(e,Be,t),n(e,L,t),n(e,Ae,t),c(B,e,t),n(e,Ge,t),n(e,A,t),n(e,Se,t),n(e,G,t),n(e,Ze,t),c(S,e,t),n(e,Pe,t),n(e,Z,t),n(e,Ee,t),n(e,P,t),n(e,ze,t),c(E,e,t),n(e,Fe,t),n(e,z,t),n(e,Ne,t),c(F,e,t),n(e,Ve,t),c(N,e,t),n(e,Qe,t),n(e,V,t),n(e,Re,t),n(e,Q,t),n(e,We,t),n(e,R,t),n(e,Xe,t),c(W,e,t),n(e,Ye,t),n(e,X,t),n(e,qe,t),c(Y,e,t),n(e,De,t),n(e,q,t),n(e,Oe,t),n(e,D,t),n(e,Ke,t),n(e,O,t),n(e,et,t),n(e,K,t),n(e,tt,t),n(e,ee,t),n(e,lt,t),c(te,e,t),n(e,nt,t),n(e,le,t),n(e,it,t),c(ne,e,t),n(e,at,t),n(e,ie,t),n(e,st,t),c(ae,e,t),n(e,rt,t),n(e,se,t),n(e,ot,t),c(re,e,t),n(e,mt,t),c(oe,e,t),n(e,pt,t),n(e,w,t),f(w,he),f(w,Tt),f(w,T),f(T,de),f(T,ft),c(me,T,null),f(T,yt),f(T,ue),f(T,wt),c(pe,T,null),f(T,Mt),f(T,Te),f(w,Jt),f(w,fe),n(e,ct,t),c(ce,e,t),n(e,ht,t),n(e,Je,t),dt=!0},p:el,i(e){dt||(h(b.$$.fragment,e),h(U.$$.fragment,e),h(g.$$.fragment,e),h(j.$$.fragment,e),h(k.$$.fragment,e),h(B.$$.fragment,e),h(S.$$.fragment,e),h(E.$$.fragment,e),h(F.$$.fragment,e),h(N.$$.fragment,e),h(W.$$.fragment,e),h(Y.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(oe.$$.fragment,e),h(me.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),dt=!0)},o(e){d(b.$$.fragment,e),d(U.$$.fragment,e),d(g.$$.fragment,e),d(j.$$.fragment,e),d(k.$$.fragment,e),d(B.$$.fragment,e),d(S.$$.fragment,e),d(E.$$.fragment,e),d(F.$$.fragment,e),d(N.$$.fragment,e),d(W.$$.fragment,e),d(Y.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(re.$$.fragment,e),d(oe.$$.fragment,e),d(me.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),dt=!1},d(e){e&&(l(be),l(Me),l($e),l(ve),l($),l(Ue),l(v),l(Ce),l(Ie),l(C),l(ge),l(I),l(xe),l(je),l(x),l(_e),l(ke),l(_),l(He),l(Le),l(H),l(Be),l(L),l(Ae),l(Ge),l(A),l(Se),l(G),l(Ze),l(Pe),l(Z),l(Ee),l(P),l(ze),l(Fe),l(z),l(Ne),l(Ve),l(Qe),l(V),l(Re),l(Q),l(We),l(R),l(Xe),l(Ye),l(X),l(qe),l(De),l(q),l(Oe),l(D),l(Ke),l(O),l(et),l(K),l(tt),l(ee),l(lt),l(nt),l(le),l(it),l(at),l(ie),l(st),l(rt),l(se),l(ot),l(mt),l(pt),l(w),l(ct),l(ht),l(Je)),l(J),u(b,e),u(U,e),u(g,e),u(j,e),u(k,e),u(B,e),u(S,e),u(E,e),u(F,e),u(N,e),u(W,e),u(Y,e),u(te,e),u(ne,e),u(ae,e),u(re,e),u(oe,e),u(me),u(pe),u(ce,e)}}}const rl='{"title":"Kernel requirements","local":"kernel-requirements","sections":[{"title":"Directory layout","local":"directory-layout","sections":[],"depth":2},{"title":"Build variants","local":"build-variants","sections":[],"depth":2},{"title":"Versioning","local":"versioning","sections":[],"depth":2},{"title":"Native Python module","local":"native-python-module","sections":[{"title":"Linux","local":"linux","sections":[],"depth":3},{"title":"macOS","local":"macos","sections":[],"depth":3},{"title":"ABI checker","local":"abi-checker","sections":[],"depth":3}],"depth":2},{"title":"Torch extension","local":"torch-extension","sections":[],"depth":2},{"title":"Layers","local":"layers","sections":[{"title":"Writing layers","local":"writing-layers","sections":[],"depth":3},{"title":"Exporting layers","local":"exporting-layers","sections":[],"depth":3}],"depth":2},{"title":"Python requirements","local":"python-requirements","sections":[],"depth":2}],"depth":1}';function ol(bt){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends ll{constructor(J){super(),nl(this,J,ol,sl,Kt,{})}}export{dl as component};
