import{s as Ma,f as pa,n as ha,o as ma}from"../chunks/scheduler.65852ee5.js";import{S as ya,i as ua,g as i,s as n,r as c,A as wa,h as o,f as s,c as a,j as ca,u as M,x as r,k as Sl,y as da,a as l,v as p,d as h,t as m,w as y}from"../chunks/index.aa74147d.js";import{D as ja,C as u}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as w,E as fa}from"../chunks/EditOnGithub.4eda6a96.js";function Ua(Vl){let d,At,vt,Gt,j,xt,f,Bt,U,Yl='<em>Authored by:<a href="https://github.com/peremartra" rel="nofollow">Pere Martra</a></em>',Zt,T,El="In this notebook, we will explore a typical RAG solution where we will utilize an open-source model and the vector database Chroma DB. <strong>However, we will integrate a semantic cache system that will store various user queries and decide whether to generate the prompt enriched with information from the vector database or the cache.</strong>",$t,J,ql="A semantic caching system aims to identify similar or identical user requests. When a matching request is found, the system retrieves the corresponding information from the cache, reducing the need to fetch it from the original source.",kt,b,zl="As the comparison takes into account the semantic meaning of the requests, they don’t have to be identical for the system to recognize them as the same question.  They can be formulated differently or contain inaccuracies, be they typographical or in the sentence structure, and we can identify that the user is actually requesting the same information.",Nt,C,Ql="For instance, queries like <strong>What is the capital of France?</strong>, <strong>Tell me the name of the capital of France?</strong>, and <strong>What The capital of France is?</strong> all convey the same intent and should be identified as the same question.",Wt,I,Hl="While the model’s response may differ based on the request for a concise answer in the second example, the information retrieved from the vector database should be the same. This is why I’m placing the cache system between the user and the vector database, not between the user and the Large Language Model.",_t,It,Xl,Rt,v,Fl="Most tutorials that guide you through creating a RAG system are designed for single-user use, meant to operate in a testing environment. In other words, within a notebook, interacting with a local vector database and making API calls or using a locally stored model.",St,g,Ll="This architecture quickly becomes insufficient when attempting to transition one of these models to production, where they might encounter from tens to thousands of recurrent requests.",Vt,A,Pl="One way to enhance performance is through one or multiple semantic caches. This cache retains the results of previous requests, and before resolving a new request, it checks if a similar one has been received before. If so, instead of re-executing the process, it retrieves the information from the cache.",Yt,G,Dl="In a RAG system, there are two points that are time consuming:",Et,x,Kl="<li>Retrieve the information used to construct the enriched prompt:</li> <li>Call the Large Language Model to obtain the response.</li>",qt,B,Ol="In both points, a semantic cache system can be implemented, and we could even have two caches, one for each point.",zt,Z,en="Placing it at the model’s response point may lead to a loss of influence over the obtained response. Our cache system could consider “Explain the French Revolution in 10 words” and “Explain the French Revolution in a hundred words” as the same query. If our cache system stores model responses, users might think that their instructions are not being followed accurately.",Qt,$,tn="But both requests will require the same information to enrich the prompt. This is the main reason why I chose to place the semantic cache system between the user’s request and the retrieval of information from the vector database.",Ht,k,sn="However, this is a design decision. Depending on the type of responses and system requests, it can be placed at one point or another. It’s evident that caching model responses would yield the most time savings, but as I’ve already explained, it comes at the cost of losing user influence over the response.",Xt,N,Ft,W,ln="To start we need to install the necesary Python packages.",Lt,_,nn='<li><strong><a href="http:/www.sbert.net/" rel="nofollow">sentence transformers</a></strong>. This library is necessary to transform the sentences into fixed-length vectors, also know as embeddings.</li> <li><strong><a href="https://github.com/facebookresearch/xformers" rel="nofollow">xformers</a></strong>. it’s a package that provides libraries an utilities to facilitate the work with transformers models. We need to install in order to avoid an error when we work with the model and embeddings.</li> <li><strong><a href="https://www.trychroma.com/" rel="nofollow">chromadb</a></strong>. This is our vector Database. ChromaDB is easy to use and open source, maybe the most used Vector Database used to store embeddings.</li> <li><strong><a href="https://github.com/huggingface/accelerate" rel="nofollow">accelerate</a></strong> Necesary to run the Model in a GPU.</li>',Pt,R,Dt,S,Kt,V,Ot,Y,an="As we are working in a free and limited space, and we can use just a few GB of memory I limited the number of rows to use from the Dataset with the variable <code>MAX_ROWS</code>.",es,E,ts,q,ss,z,on="ChromaDB requires that the data has a unique identifier. We can make it with this statement, which will create a new column called <strong>Id</strong>.",ls,Q,ns,H,as,X,is,F,os,L,rn="To store the information, I’ve chosen to use ChromaDB, one of the most well-known and widely used open-source vector databases.",rs,P,cn="First we need to import ChromaDB.",cs,D,Ms,K,Mn="Now we only need to indicate the path where the vector database will be stored.",ps,O,hs,ee,ms,te,pn="The Data in ChromaDB is stored in collections. If the collection exist we need to delete it.",ys,se,hn="In the next lines, we are creating the collection by calling the <code>create_collection</code> function in the <code>chroma_client</code> created above.",us,le,ws,ne,mn="We are now ready to add the data to the collection using the <code>add</code> function. This function requires three key pieces of information:",ds,ae,yn="<li>In the <strong>document</strong> we store the content of the <code>Answer</code> column in the Dataset.</li> <li>In <strong>metadatas</strong>, we can inform a list of topics. I used the value in the column <code>qtype</code>.</li> <li>In <strong>id</strong> we need to inform an unique identificator for each row. I’m creating the ID using the range of <code>MAX_ROWS</code>.</li>",js,ie,fs,oe,un="Once we have the information in the Database we can query it, and ask for data that matches our needs. The search is done inside the content of the document, and it dosn’t look for the exact word, or phrase. The results will be based on the similarity between the search terms and the content of documents.",Us,re,wn="Metadata isn’t directly involved in the initial search process, it can be used to filter or refine the results after retrieval, enabling further customization and precision.",Ts,ce,dn="Let’s define a function to query the ChromaDB Database.",Js,Me,bs,pe,Cs,he,jn="To implement the cache system, we will use Faiss, a library that allows storing embeddings in memory. It’s quite similar to what Chroma does, but without its persistence.",Is,me,fn="For this purpose, we will create a class called <code>semantic_cache</code> that will work with its own encoder and provide the necessary functions for the user to perform queries.",vs,ye,Un="In this class, we first query the cache implemented with Faiss, that contains the previous petitions, and if the returned results are above a specified threshold, it will return the content of the cache. Otherwise, it will fetch the result from the Chroma database.",gs,ue,Tn="The cache is stored in a .json file.",As,we,Gs,de,xs,je,Jn="The <code>init_cache()</code> function below initializes the semantic cache.",Bs,fe,bn="It employs the FlatLS index, which might not be the fastest but is ideal for small datasets. Depending on the characteristics of the data intended for the cache and the expected dataset size, another index such as HNSW or IVF could be utilized.",Zs,Ue,Cn="I chose this index because it aligns well with the example. It can be used with vectors of high dimensions, consumes minimal memory, and performs well with small datasets.",$s,Te,In="I outline the key features of the various indices available with Faiss.",ks,Je,vn="<li>FlatL2 or FlatIP. Well-suited for small datasets, it may not be the fastest, but its memory consumption is not excessive.</li> <li>LSH. It works effectively with small datasets and is recommended for use with vectors of up to 128 dimensions.</li> <li>HNSW. Very fast but demands a substantial amount of RAM.</li> <li>IVF. Works well with large datasets without consuming much memory or compromising performance.</li>",Ns,be,gn='More information about the different indices available with Faiss can be found at this link: <a href="https://github.com/facebookresearch/faiss/wiki/Guidelines-to-choose-an-index" rel="nofollow">https://github.com/facebookresearch/faiss/wiki/Guidelines-to-choose-an-index</a>',Ws,Ce,_s,Ie,An="In the <code>retrieve_cache</code> function, the .json file is retrieved from disk in case there is a need to reuse the cache across sessions.",Rs,ve,Ss,ge,Gn="The <code>store_cache</code> function saves the file containing the cache data to disk.",Vs,Ae,Ys,Ge,xn="These functions will be used within the <code>SemanticCache</code> class, which includes the search function and its initialization function.",Es,xe,Bn="Even though the <code>ask</code> function has a substantial amount of code, its purpose is quite straightforward. It looks in the cache for the closest question to the one just made by the user.",qs,Be,Zn="Afterward, checks if it is within the specified threshold. If positive, it directly returns the response from the cache; otherwise, it calls the <code>query_database</code> function to retrieve the data from ChromaDB.",zs,Ze,$n="I’ve used Euclidean distance instead of Cosine, which is widely employed in vector comparisons. This choice is based on the fact that Euclidean distance is the default metric used by Faiss. Although Cosine distance can also be calculated, doing so adds complexity that may not significantly contribute to the final result.",Qs,$e,kn="I have included FIFO eviction policy in the semantic_cache class, which aims to improve its efficiency and flexibility. By introducing eviction policies, we provide users with the ability to control how the cache behaves when it reaches its maximum capacity. This is crucial for maintaining optimal cache performance and for handling situations where the available memory is constrained.",Hs,ke,Nn="Looking at the structure of the cache, the implementation of FIFO seemed straightforward. Whenever a new question-answer pair is added to the cache, it’s appended to the end of the lists. Thus, the oldest (first-in) items are at the front of the lists. When the cache reaches its maximum size and you need to evict an item, you remove (pop) the first item from each list. This is the FIFO eviction policy.",Xs,Ne,Wn="Another eviction policy is the Least Recently Used (LRU) policy, which is more complex because it requires knowledge of when each item in the cache was last accessed. However, this policy is not yet available and will be implemented later.",Fs,We,Ls,_e,Ps,Re,Ds,Se,_n=`Index trained
`,Ks,Ve,Os,Ye,Rn=`Answer recovered from ChromaDB. 
response_text: Summary : Shots may hurt a little, but the diseases they can prevent are a lot worse. Some are even life-threatening. Immunization shots, or vaccinations, are essential. They protect against things like measles, mumps, rubella, hepatitis B, polio, tetanus, diphtheria, and pertussis (whooping cough). Immunizations are important for adults as well as children.    Your immune system helps your body fight germs by producing substances to combat them. Once it does, the immune system "remembers" the germ and can fight it again. Vaccines contain germs that have been killed or weakened. When given to a healthy person, the vaccine triggers the immune system to respond and thus build immunity.     Before vaccines, people became immune only by actually getting a disease and surviving it. Immunizations are an easier and less risky way to become immune.     NIH: National Institute of Allergy and Infectious Diseases
Time taken: 0.057 seconds
`,el,Ee,Sn="As expected, this response has been obtained from ChromaDB. The class then stores it in the cache.",tl,qe,Vn="Now, if we send a second question that is quite different, the response should also be retrieved from ChromaDB. This is because the question stored previously is so dissimilar that it would surpass the specified threshold in terms of Euclidean distance.",sl,ze,ll,Qe,Yn=`Answer recovered from ChromaDB. 
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.082 seconds
`,nl,He,En="Perfect, the semantic cache system is behaving as expected.",al,Xe,qn="Let’s proceed to test it with a question very similar to the one we just asked.",il,Fe,zn="In this case, the response should come directly from the cache without the need to access the ChromaDB database.",ol,Le,rl,Pe,Qn=`Answer recovered from Cache. 
0.028 smaller than 0.35
Found cache in row: 1 with score 0.028
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.019 seconds
`,cl,De,Hn="The two questions are so similar that their Euclidean distance is truly minimal, almost as if they were identical.",Ml,Ke,Xn="Now, let’s try another question, this time a bit more distinct, and observe how the system behaves.",pl,Oe,hl,et,Fn=`Answer recovered from Cache. 
0.228 smaller than 0.35
Found cache in row: 1 with score 0.228
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.016 seconds
`,ml,tt,Ln="We observe that the Euclidean distance has increased, but it still remains within the specified threshold. Therefore, it continues to return the response directly from the cache.",yl,st,ul,lt,Pn='Time to use the library <strong>transformers</strong>, the most famous library from <a href="https://huggingface.co/" rel="nofollow">hugging face</a> for working with language models.',wl,nt,Dn="We are importing:",dl,at,Kn='<li><strong>Autotokenizer</strong>: It is a utility class for tokenizing text inputs that are compatible with various pre-trained language models.</li> <li><strong>AutoModelForCausalLM</strong>: it provides an interface to pre-trained language models specifically designed for language generation tasks using causal language modeling (e.g., GPT models), or the model used in this notebook <a href="https://huggingface.co/google/gemma-2b-it" rel="nofollow">Gemma-2b-it</a>.</li>',jl,it,On='Please, feel free to test <a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;sort=trending" rel="nofollow">different Models</a>, you need to search for NLP models trained for text-generation.',fl,ot,Ul,rt,Tl,ct,Jl,Mt,bl,pt,ea="To create the prompt we use the result from query the ‘semantic_cache’ class  and the question introduced by the user.",Cl,ht,ta="The prompt have two parts, the <strong>relevant context</strong> that is the information recovered from the database and the <strong>user’s question</strong>.",Il,mt,sa="We only need to put the two parts together to create the prompt then send it to the model.",vl,yt,gl,ut,Al,wt,la="Now all that remains is to send the prompt to the model and wait for its response!",Gl,dt,xl,jt,na=`<bos>Relevant context: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.

 The user&#39;s question: Write in 20 words what is a Sydenham chorea.

Sure, here is a 20-word answer:

Sydenham chorea is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS).<eos>
</eos></bos>`,Bl,ft,Zl,Ut,aa="There’s a 50% reduction in data retrieval time between accessing ChromaDB and going directly to the cache. However, in larger projects, this difference increases, leading to enhancements of 90-95%.",$l,Tt,ia="We have very few data in Chroma, and only a single instance of the cache class. Typically, the data behind the cache system is much larger, possibly involving more than just a query to a vector database but sourced from various places.",kl,Jt,oa="It’s common to have multiple instances of the cache class, usually based on user typology, as questions tend to repeat more among users who share common traits.",Nl,bt,ra="In summary, we have created a very simple RAG (Retrieval-Augmented Generation) system and enhanced it with a semantic cache layer between the user’s question and obtaining the information necessary to create the enriched prompt.",Wl,Ct,_l,gt,Rl;return j=new ja({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/add_hf_login/notebooks/en/semantic_cache_chroma_vector_database.ipynb"}]}}),f=new w({props:{title:"Implementing semantic cache to improve a RAG system with FAISS.",local:"implementing-semantic-cache-to-improve-a-rag-system-with-faiss",headingTag:"h1"}}),N=new w({props:{title:"Import and load the libraries.",local:"import-and-load-the-libraries",headingTag:"h1"}}),R=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRyYW5zZm9ybWVycyUzRCUzRDQuMzguMSUwQSFwaXAlMjBpbnN0YWxsJTIwLXElMjBhY2NlbGVyYXRlJTNEJTNEMC4yNy4yJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUzRCUzRDIuNS4xJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMHhmb3JtZXJzJTNEJTNEMC4wLjI0JTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMGNocm9tYWRiJTNEJTNEMC40LjI0JTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTNEJTNEMi4xNy4x",highlighted:`!pip install -q transformers==<span class="hljs-number">4.38</span><span class="hljs-number">.1</span>
!pip install -q accelerate==<span class="hljs-number">0.27</span><span class="hljs-number">.2</span>
!pip install -q sentence-transformers==<span class="hljs-number">2.5</span><span class="hljs-number">.1</span>
!pip install -q xformers==<span class="hljs-number">0.0</span><span class="hljs-number">.24</span>
!pip install -q chromadb==<span class="hljs-number">0.4</span><span class="hljs-number">.24</span>
!pip install -q datasets==<span class="hljs-number">2.17</span><span class="hljs-number">.1</span>`,wrap:!1}}),S=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZA==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd`,wrap:!1}}),V=new w({props:{title:"Load the Dataset",local:"load-the-dataset",headingTag:"h1"}}),E=new u({props:{code:"JTIzTG9naW4lMjB0byUyMEh1Z2dpbmclMjBGYWNlLiUyMEl0JTIwaXMlMjBtYW5kYXRvcnklMjB0byUyMHVzZSUyMHRoZSUyMEdlbW1hJTIwTW9kZWwlMkMlMEElMjNhbmQlMjByZWNvbW1lbmRlZCUyMHRvJTIwYWNjZXMlMjBwdWJsaWMlMjBtb2RlbHMlMjBhbmQlMjBEYXRhc2V0cy4lMEFmcm9tJTIwZ2V0cGFzcyUyMGltcG9ydCUyMGdldHBhc3MlMEFpZiUyMCdoZl9rZXknJTIwbm90JTIwaW4lMjBsb2NhbHMoKSUzQSUwQSUyMCUyMGhmX2tleSUyMCUzRCUyMGdldHBhc3MoJTIyWW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwQVBJJTIwS2V5JTNBJTIwJTIyKSUwQSFodWdnaW5nZmFjZS1jbGklMjBsb2dpbiUyMC0tdG9rZW4lMjAlMjRoZl9rZXk=",highlighted:`<span class="hljs-comment">#Login to Hugging Face. It is mandatory to use the Gemma Model,</span>
<span class="hljs-comment">#and recommended to acces public models and Datasets.</span>
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;hf_key&#x27;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">locals</span>():
  hf_key = getpass(<span class="hljs-string">&quot;Your Hugging Face API Key: &quot;</span>)
!huggingface-cli login --token $hf_key`,wrap:!1}}),q=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJrZWl2YWx5YSUyRk1lZFF1YWQtTWVkaWNhbFFuQURhdGFzZXQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

data = load_dataset(<span class="hljs-string">&quot;keivalya/MedQuad-MedicalQnADataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Q=new u({props:{code:"ZGF0YSUyMCUzRCUyMGRhdGEudG9fcGFuZGFzKCklMEFkYXRhJTVCJTIyaWQlMjIlNUQlMjAlM0QlMjBkYXRhLmluZGV4JTBBZGF0YS5oZWFkKDEwKQ==",highlighted:`data = data.to_pandas()
data[<span class="hljs-string">&quot;id&quot;</span>] = data.index
data.head(<span class="hljs-number">10</span>)`,wrap:!1}}),H=new u({props:{code:"TUFYX1JPV1MlMjAlM0QlMjAxNTAwMCUwQURPQ1VNRU5UJTIwJTNEJTIwJTIyQW5zd2VyJTIyJTBBVE9QSUMlMjAlM0QlMjAlMjJxdHlwZSUyMg==",highlighted:`MAX_ROWS = <span class="hljs-number">15000</span>
DOCUMENT = <span class="hljs-string">&quot;Answer&quot;</span>
TOPIC = <span class="hljs-string">&quot;qtype&quot;</span>`,wrap:!1}}),X=new u({props:{code:"JTIzJTIwQmVjYXVzZSUyMGl0JTIwaXMlMjBqdXN0JTIwYSUyMHNhbXBsZSUyMHdlJTIwc2VsZWN0JTIwYSUyMHNtYWxsJTIwcG9ydGlvbiUyMG9mJTIwTmV3cy4lMEFzdWJzZXRfZGF0YSUyMCUzRCUyMGRhdGEuaGVhZChNQVhfUk9XUyk=",highlighted:`<span class="hljs-comment"># Because it is just a sample we select a small portion of News.</span>
subset_data = data.head(MAX_ROWS)`,wrap:!1}}),F=new w({props:{title:"Import and configure the Vector Database",local:"import-and-configure-the-vector-database",headingTag:"h1"}}),D=new u({props:{code:"aW1wb3J0JTIwY2hyb21hZGI=",highlighted:'<span class="hljs-keyword">import</span> chromadb',wrap:!1}}),O=new u({props:{code:"Y2hyb21hX2NsaWVudCUyMCUzRCUyMGNocm9tYWRiLlBlcnNpc3RlbnRDbGllbnQocGF0aCUzRCUyMiUyRnBhdGglMkZ0byUyRnBlcnNpc3QlMkZkaXJlY3RvcnklMjIp",highlighted:'chroma_client = chromadb.PersistentClient(path=<span class="hljs-string">&quot;/path/to/persist/directory&quot;</span>)',wrap:!1}}),ee=new w({props:{title:"Filling and Querying the ChromaDB Database",local:"filling-and-querying-the-chromadb-database",headingTag:"h1"}}),le=new u({props:{code:"Y29sbGVjdGlvbl9uYW1lJTIwJTNEJTIwJTIybmV3c19jb2xsZWN0aW9uJTIyJTBBaWYlMjBsZW4oY2hyb21hX2NsaWVudC5saXN0X2NvbGxlY3Rpb25zKCkpJTIwJTNFJTIwMCUyMGFuZCUyMGNvbGxlY3Rpb25fbmFtZSUyMGluJTIwJTVCY2hyb21hX2NsaWVudC5saXN0X2NvbGxlY3Rpb25zKCklNUIwJTVELm5hbWUlNUQlM0ElMEElMjAlMjAlMjAlMjBjaHJvbWFfY2xpZW50LmRlbGV0ZV9jb2xsZWN0aW9uKG5hbWUlM0Rjb2xsZWN0aW9uX25hbWUpJTBBJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNocm9tYV9jbGllbnQuY3JlYXRlX2NvbGxlY3Rpb24obmFtZSUzRGNvbGxlY3Rpb25fbmFtZSk=",highlighted:`collection_name = <span class="hljs-string">&quot;news_collection&quot;</span>
<span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(chroma_client.list_collections()) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> collection_name <span class="hljs-keyword">in</span> [chroma_client.list_collections()[<span class="hljs-number">0</span>].name]:
    chroma_client.delete_collection(name=collection_name)

collection = chroma_client.create_collection(name=collection_name)`,wrap:!1}}),ie=new u({props:{code:"Y29sbGVjdGlvbi5hZGQoJTBBJTIwJTIwJTIwJTIwZG9jdW1lbnRzJTNEc3Vic2V0X2RhdGElNUJET0NVTUVOVCU1RC50b2xpc3QoKSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhcyUzRCU1QiU3QlRPUElDJTNBJTIwdG9waWMlN0QlMjBmb3IlMjB0b3BpYyUyMGluJTIwc3Vic2V0X2RhdGElNUJUT1BJQyU1RC50b2xpc3QoKSU1RCUyQyUwQSUyMCUyMCUyMCUyMGlkcyUzRCU1QmYlMjJpZCU3QnglN0QlMjIlMjBmb3IlMjB4JTIwaW4lMjByYW5nZShNQVhfUk9XUyklNUQlMkMlMEEp",highlighted:`collection.add(
    documents=subset_data[DOCUMENT].tolist(),
    metadatas=[{TOPIC: topic} <span class="hljs-keyword">for</span> topic <span class="hljs-keyword">in</span> subset_data[TOPIC].tolist()],
    ids=[<span class="hljs-string">f&quot;id<span class="hljs-subst">{x}</span>&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(MAX_ROWS)],
)`,wrap:!1}}),Me=new u({props:{code:"ZGVmJTIwcXVlcnlfZGF0YWJhc2UocXVlcnlfdGV4dCUyQyUyMG5fcmVzdWx0cyUzRDEwKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBjb2xsZWN0aW9uLnF1ZXJ5KHF1ZXJ5X3RleHRzJTNEcXVlcnlfdGV4dCUyQyUyMG5fcmVzdWx0cyUzRG5fcmVzdWx0cyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">query_database</span>(<span class="hljs-params">query_text, n_results=<span class="hljs-number">10</span></span>):
    results = collection.query(query_texts=query_text, n_results=n_results)
    <span class="hljs-keyword">return</span> results`,wrap:!1}}),pe=new w({props:{title:"Creating the semantic cache system",local:"creating-the-semantic-cache-system",headingTag:"h2"}}),we=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGZhaXNzLWNwdSUzRCUzRDEuOC4w",highlighted:'!pip install -q faiss-cpu==<span class="hljs-number">1.8</span><span class="hljs-number">.0</span>',wrap:!1}}),de=new u({props:{code:"aW1wb3J0JTIwZmFpc3MlMEFmcm9tJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwU2VudGVuY2VUcmFuc2Zvcm1lciUwQWltcG9ydCUyMHRpbWUlMEFpbXBvcnQlMjBqc29u",highlighted:`<span class="hljs-keyword">import</span> faiss
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> json`,wrap:!1}}),Ce=new u({props:{code:"ZGVmJTIwaW5pdF9jYWNoZSgpJTNBJTBBJTIwJTIwJTIwJTIwaW5kZXglMjAlM0QlMjBmYWlzcy5JbmRleEZsYXRMMig3NjgpJTBBJTIwJTIwJTIwJTIwaWYlMjBpbmRleC5pc190cmFpbmVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIySW5kZXglMjB0cmFpbmVkJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEluaXRpYWxpemUlMjBTZW50ZW5jZSUyMFRyYW5zZm9ybWVyJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBlbmNvZGVyJTIwJTNEJTIwU2VudGVuY2VUcmFuc2Zvcm1lciglMjJhbGwtbXBuZXQtYmFzZS12MiUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbmRleCUyQyUyMGVuY29kZXI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">init_cache</span>():
    index = faiss.IndexFlatL2(<span class="hljs-number">768</span>)
    <span class="hljs-keyword">if</span> index.is_trained:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Index trained&quot;</span>)

    <span class="hljs-comment"># Initialize Sentence Transformer model</span>
    encoder = SentenceTransformer(<span class="hljs-string">&quot;all-mpnet-base-v2&quot;</span>)

    <span class="hljs-keyword">return</span> index, encoder`,wrap:!1}}),ve=new u({props:{code:"ZGVmJTIwcmV0cmlldmVfY2FjaGUoanNvbl9maWxlKSUzQSUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKGpzb25fZmlsZSUyQyUyMCUyMnIlMjIpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGUlMjAlM0QlMjBqc29uLmxvYWQoZmlsZSklMEElMjAlMjAlMjAlMjBleGNlcHQlMjBGaWxlTm90Rm91bmRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhY2hlJTIwJTNEJTIwJTdCJTIycXVlc3Rpb25zJTIyJTNBJTIwJTVCJTVEJTJDJTIwJTIyZW1iZWRkaW5ncyUyMiUzQSUyMCU1QiU1RCUyQyUyMCUyMmFuc3dlcnMlMjIlM0ElMjAlNUIlNUQlMkMlMjAlMjJyZXNwb25zZV90ZXh0JTIyJTNBJTIwJTVCJTVEJTdEJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2FjaGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">retrieve_cache</span>(<span class="hljs-params">json_file</span>):
    <span class="hljs-keyword">try</span>:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(json_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> file:
            cache = json.load(file)
    <span class="hljs-keyword">except</span> FileNotFoundError:
        cache = {<span class="hljs-string">&quot;questions&quot;</span>: [], <span class="hljs-string">&quot;embeddings&quot;</span>: [], <span class="hljs-string">&quot;answers&quot;</span>: [], <span class="hljs-string">&quot;response_text&quot;</span>: []}

    <span class="hljs-keyword">return</span> cache`,wrap:!1}}),Ae=new u({props:{code:"ZGVmJTIwc3RvcmVfY2FjaGUoanNvbl9maWxlJTJDJTIwY2FjaGUpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oanNvbl9maWxlJTJDJTIwJTIydyUyMiklMjBhcyUyMGZpbGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqc29uLmR1bXAoY2FjaGUlMkMlMjBmaWxlKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">store_cache</span>(<span class="hljs-params">json_file, cache</span>):
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(json_file, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> file:
        json.dump(cache, file)`,wrap:!1}}),We=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">semantic_cache</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, json_file=<span class="hljs-string">&quot;cache_file.json&quot;</span>, thresold=<span class="hljs-number">0.35</span>, max_response=<span class="hljs-number">100</span>, eviction_policy=<span class="hljs-literal">None</span></span>):
        <span class="hljs-string">&quot;&quot;&quot;Initializes the semantic cache.

        Args:
        json_file (str): The name of the JSON file where the cache is stored.
        thresold (float): The threshold for the Euclidean distance to determine if a question is similar.
        max_response (int): The maximum number of responses the cache can store.
        eviction_policy (str): The policy for evicting items from the cache.
                                This can be any policy, but &#x27;FIFO&#x27; (First In First Out) has been implemented for now.
                                If None, no eviction policy will be applied.
        &quot;&quot;&quot;</span>

        <span class="hljs-comment"># Initialize Faiss index with Euclidean distance</span>
        self.index, self.encoder = init_cache()

        <span class="hljs-comment"># Set Euclidean distance threshold</span>
        <span class="hljs-comment"># a distance of 0 means identicals sentences</span>
        <span class="hljs-comment"># We only return from cache sentences under this thresold</span>
        self.euclidean_threshold = thresold

        self.json_file = json_file
        self.cache = retrieve_cache(self.json_file)
        self.max_response = max_response
        self.eviction_policy = eviction_policy

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">evict</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Evicts an item from the cache based on the eviction policy.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">if</span> self.eviction_policy <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(self.cache[<span class="hljs-string">&quot;questions&quot;</span>]) &gt; self.max_size:
            <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>((<span class="hljs-built_in">len</span>(self.cache[<span class="hljs-string">&quot;questions&quot;</span>]) - self.max_response)):
                <span class="hljs-keyword">if</span> self.eviction_policy == <span class="hljs-string">&quot;FIFO&quot;</span>:
                    self.cache[<span class="hljs-string">&quot;questions&quot;</span>].pop(<span class="hljs-number">0</span>)
                    self.cache[<span class="hljs-string">&quot;embeddings&quot;</span>].pop(<span class="hljs-number">0</span>)
                    self.cache[<span class="hljs-string">&quot;answers&quot;</span>].pop(<span class="hljs-number">0</span>)
                    self.cache[<span class="hljs-string">&quot;response_text&quot;</span>].pop(<span class="hljs-number">0</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">ask</span>(<span class="hljs-params">self, question: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-comment"># Method to retrieve an answer from the cache or generate a new one</span>
        start_time = time.time()
        <span class="hljs-keyword">try</span>:
            <span class="hljs-comment"># First we obtain the embeddings corresponding to the user question</span>
            embedding = self.encoder.encode([question])

            <span class="hljs-comment"># Search for the nearest neighbor in the index</span>
            self.index.nprobe = <span class="hljs-number">8</span>
            D, I = self.index.search(embedding, <span class="hljs-number">1</span>)

            <span class="hljs-keyword">if</span> D[<span class="hljs-number">0</span>] &gt;= <span class="hljs-number">0</span>:
                <span class="hljs-keyword">if</span> I[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>] &gt;= <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>] &lt;= self.euclidean_threshold:
                    row_id = <span class="hljs-built_in">int</span>(I[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>])

                    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Answer recovered from Cache. &quot;</span>)
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.3</span>f}</span> smaller than <span class="hljs-subst">{self.euclidean_threshold}</span>&quot;</span>)
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Found cache in row: <span class="hljs-subst">{row_id}</span> with score <span class="hljs-subst">{D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.3</span>f}</span>&quot;</span>)
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;response_text: &quot;</span> + self.cache[<span class="hljs-string">&quot;response_text&quot;</span>][row_id])

                    end_time = time.time()
                    elapsed_time = end_time - start_time
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time taken: <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.3</span>f}</span> seconds&quot;</span>)
                    <span class="hljs-keyword">return</span> self.cache[<span class="hljs-string">&quot;response_text&quot;</span>][row_id]

            <span class="hljs-comment"># Handle the case when there are not enough results</span>
            <span class="hljs-comment"># or Euclidean distance is not met, asking to chromaDB.</span>
            answer = query_database([question], <span class="hljs-number">1</span>)
            response_text = answer[<span class="hljs-string">&quot;documents&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]

            self.cache[<span class="hljs-string">&quot;questions&quot;</span>].append(question)
            self.cache[<span class="hljs-string">&quot;embeddings&quot;</span>].append(embedding[<span class="hljs-number">0</span>].tolist())
            self.cache[<span class="hljs-string">&quot;answers&quot;</span>].append(answer)
            self.cache[<span class="hljs-string">&quot;response_text&quot;</span>].append(response_text)

            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Answer recovered from ChromaDB. &quot;</span>)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;response_text: <span class="hljs-subst">{response_text}</span>&quot;</span>)

            self.index.add(embedding)

            self.evict()

            store_cache(self.json_file, self.cache)

            end_time = time.time()
            elapsed_time = end_time - start_time
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time taken: <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.3</span>f}</span> seconds&quot;</span>)

            <span class="hljs-keyword">return</span> response_text
        <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
            <span class="hljs-keyword">raise</span> RuntimeError(<span class="hljs-string">f&quot;Error during &#x27;ask&#x27; method: <span class="hljs-subst">{e}</span>&quot;</span>)`,wrap:!1}}),_e=new w({props:{title:"Testing the semantic_cache class.",local:"testing-the-semanticcache-class",headingTag:"h3"}}),Re=new u({props:{code:"JTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMGNhY2hlLiUwQWNhY2hlJTIwJTNEJTIwc2VtYW50aWNfY2FjaGUoJTIyNGNhY2hlLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache = semantic_cache(<span class="hljs-string">&quot;4cache.json&quot;</span>)`,wrap:!1}}),Ve=new u({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJIb3clMjBkbyUyMHZhY2NpbmVzJTIwd29yayUzRiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;How do vaccines work?&quot;</span>)',wrap:!1}}),ze=new u({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJFeHBsYWluJTIwYnJpZWZseSUyMHdoYXQlMjBpcyUyMGElMjBTeWRlbmhhbSUyMGNob3JlYSUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;Explain briefly what is a Sydenham chorea&quot;</span>)',wrap:!1}}),Le=new u({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJCcmllZmx5JTIwZXhwbGFpbiUyMG1lJTIwd2hhdCUyMGlzJTIwYSUyMFN5ZGVuaGFtJTIwY2hvcmVhLiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;Briefly explain me what is a Sydenham chorea.&quot;</span>)',wrap:!1}}),Oe=new u({props:{code:"cXVlc3Rpb25fZGVmJTIwJTNEJTIwJTIyV3JpdGUlMjBpbiUyMDIwJTIwd29yZHMlMjB3aGF0JTIwaXMlMjBhJTIwU3lkZW5oYW0lMjBjaG9yZWEuJTIyJTBBcmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayhxdWVzdGlvbl9kZWYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question_def = <span class="hljs-string">&quot;Write in 20 words what is a Sydenham chorea.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(question_def)`,wrap:!1}}),st=new w({props:{title:"Loading the model and creating the prompt",local:"loading-the-model-and-creating-the-prompt",headingTag:"h1"}}),ot=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0b3JjaA==",highlighted:"!pip install torch",wrap:!1}}),rt=new u({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwY3VkYSUyQyUyMHRvcmNoJTBBJTBBJTIzJTIwSW4lMjBhJTIwTUFDJTIwU2lsaWNvbiUyMHRoZSUyMGRldmljZSUyMG11c3QlMjBiZSUyMCdtcHMnJTBBJTIzJTIwZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCdtcHMnKSUyMCUyM3RvJTIwdXNlJTIwd2l0aCUyME1BQyUyMFNpbGljb24lMEFkZXZpY2UlMjAlM0QlMjBmJTIyY3VkYSUzQSU3QmN1ZGEuY3VycmVudF9kZXZpY2UoKSU3RCUyMiUyMGlmJTIwY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjI=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> cuda, torch

<span class="hljs-comment"># In a MAC Silicon the device must be &#x27;mps&#x27;</span>
<span class="hljs-comment"># device = torch.device(&#x27;mps&#x27;) #to use with MAC Silicon</span>
device = <span class="hljs-string">f&quot;cuda:<span class="hljs-subst">{cuda.current_device()}</span>&quot;</span> <span class="hljs-keyword">if</span> cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>`,wrap:!1}}),ct=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmItaXQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.bfloat16)`,wrap:!1}}),Mt=new w({props:{title:"Creating the extended prompt",local:"creating-the-extended-prompt",headingTag:"h2"}}),yt=new u({props:{code:"cHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwZiUyMlJlbGV2YW50JTIwY29udGV4dCUzQSUyMCU3QnJlc3VsdHMlN0QlNUNuJTVDbiUyMFRoZSUyMHVzZXIncyUyMHF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb25fZGVmJTdEJTIyJTBBcHJvbXB0X3RlbXBsYXRl",highlighted:`prompt_template = <span class="hljs-string">f&quot;Relevant context: <span class="hljs-subst">{results}</span>\\n\\n The user&#x27;s question: <span class="hljs-subst">{question_def}</span>&quot;</span>
prompt_template`,wrap:!1}}),ut=new u({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdF90ZW1wbGF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:'input_ids = tokenizer(prompt_template, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),dt=new u({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),ft=new w({props:{title:"Conclusion.",local:"conclusion",headingTag:"h1"}}),Ct=new fa({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/semantic_cache_chroma_vector_database.md"}}),{c(){d=i("meta"),At=n(),vt=i("p"),Gt=n(),c(j.$$.fragment),xt=n(),c(f.$$.fragment),Bt=n(),U=i("p"),U.innerHTML=Yl,Zt=n(),T=i("p"),T.innerHTML=El,$t=n(),J=i("p"),J.textContent=ql,kt=n(),b=i("p"),b.textContent=zl,Nt=n(),C=i("p"),C.innerHTML=Ql,Wt=n(),I=i("p"),I.textContent=Hl,_t=n(),It=i("img"),Rt=n(),v=i("p"),v.textContent=Fl,St=n(),g=i("p"),g.textContent=Ll,Vt=n(),A=i("p"),A.textContent=Pl,Yt=n(),G=i("p"),G.textContent=Dl,Et=n(),x=i("ul"),x.innerHTML=Kl,qt=n(),B=i("p"),B.textContent=Ol,zt=n(),Z=i("p"),Z.textContent=en,Qt=n(),$=i("p"),$.textContent=tn,Ht=n(),k=i("p"),k.textContent=sn,Xt=n(),c(N.$$.fragment),Ft=n(),W=i("p"),W.textContent=ln,Lt=n(),_=i("ul"),_.innerHTML=nn,Pt=n(),c(R.$$.fragment),Dt=n(),c(S.$$.fragment),Kt=n(),c(V.$$.fragment),Ot=n(),Y=i("p"),Y.innerHTML=an,es=n(),c(E.$$.fragment),ts=n(),c(q.$$.fragment),ss=n(),z=i("p"),z.innerHTML=on,ls=n(),c(Q.$$.fragment),ns=n(),c(H.$$.fragment),as=n(),c(X.$$.fragment),is=n(),c(F.$$.fragment),os=n(),L=i("p"),L.textContent=rn,rs=n(),P=i("p"),P.textContent=cn,cs=n(),c(D.$$.fragment),Ms=n(),K=i("p"),K.textContent=Mn,ps=n(),c(O.$$.fragment),hs=n(),c(ee.$$.fragment),ms=n(),te=i("p"),te.textContent=pn,ys=n(),se=i("p"),se.innerHTML=hn,us=n(),c(le.$$.fragment),ws=n(),ne=i("p"),ne.innerHTML=mn,ds=n(),ae=i("ul"),ae.innerHTML=yn,js=n(),c(ie.$$.fragment),fs=n(),oe=i("p"),oe.textContent=un,Us=n(),re=i("p"),re.textContent=wn,Ts=n(),ce=i("p"),ce.textContent=dn,Js=n(),c(Me.$$.fragment),bs=n(),c(pe.$$.fragment),Cs=n(),he=i("p"),he.textContent=jn,Is=n(),me=i("p"),me.innerHTML=fn,vs=n(),ye=i("p"),ye.textContent=Un,gs=n(),ue=i("p"),ue.textContent=Tn,As=n(),c(we.$$.fragment),Gs=n(),c(de.$$.fragment),xs=n(),je=i("p"),je.innerHTML=Jn,Bs=n(),fe=i("p"),fe.textContent=bn,Zs=n(),Ue=i("p"),Ue.textContent=Cn,$s=n(),Te=i("p"),Te.textContent=In,ks=n(),Je=i("ul"),Je.innerHTML=vn,Ns=n(),be=i("p"),be.innerHTML=gn,Ws=n(),c(Ce.$$.fragment),_s=n(),Ie=i("p"),Ie.innerHTML=An,Rs=n(),c(ve.$$.fragment),Ss=n(),ge=i("p"),ge.innerHTML=Gn,Vs=n(),c(Ae.$$.fragment),Ys=n(),Ge=i("p"),Ge.innerHTML=xn,Es=n(),xe=i("p"),xe.innerHTML=Bn,qs=n(),Be=i("p"),Be.innerHTML=Zn,zs=n(),Ze=i("p"),Ze.textContent=$n,Qs=n(),$e=i("p"),$e.textContent=kn,Hs=n(),ke=i("p"),ke.textContent=Nn,Xs=n(),Ne=i("p"),Ne.textContent=Wn,Fs=n(),c(We.$$.fragment),Ls=n(),c(_e.$$.fragment),Ps=n(),c(Re.$$.fragment),Ds=n(),Se=i("pre"),Se.textContent=_n,Ks=n(),c(Ve.$$.fragment),Os=n(),Ye=i("pre"),Ye.textContent=Rn,el=n(),Ee=i("p"),Ee.textContent=Sn,tl=n(),qe=i("p"),qe.textContent=Vn,sl=n(),c(ze.$$.fragment),ll=n(),Qe=i("pre"),Qe.textContent=Yn,nl=n(),He=i("p"),He.textContent=En,al=n(),Xe=i("p"),Xe.textContent=qn,il=n(),Fe=i("p"),Fe.textContent=zn,ol=n(),c(Le.$$.fragment),rl=n(),Pe=i("pre"),Pe.textContent=Qn,cl=n(),De=i("p"),De.textContent=Hn,Ml=n(),Ke=i("p"),Ke.textContent=Xn,pl=n(),c(Oe.$$.fragment),hl=n(),et=i("pre"),et.textContent=Fn,ml=n(),tt=i("p"),tt.textContent=Ln,yl=n(),c(st.$$.fragment),ul=n(),lt=i("p"),lt.innerHTML=Pn,wl=n(),nt=i("p"),nt.textContent=Dn,dl=n(),at=i("ul"),at.innerHTML=Kn,jl=n(),it=i("p"),it.innerHTML=On,fl=n(),c(ot.$$.fragment),Ul=n(),c(rt.$$.fragment),Tl=n(),c(ct.$$.fragment),Jl=n(),c(Mt.$$.fragment),bl=n(),pt=i("p"),pt.textContent=ea,Cl=n(),ht=i("p"),ht.innerHTML=ta,Il=n(),mt=i("p"),mt.textContent=sa,vl=n(),c(yt.$$.fragment),gl=n(),c(ut.$$.fragment),Al=n(),wt=i("p"),wt.textContent=la,Gl=n(),c(dt.$$.fragment),xl=n(),jt=i("pre"),jt.innerHTML=na,Bl=n(),c(ft.$$.fragment),Zl=n(),Ut=i("p"),Ut.textContent=aa,$l=n(),Tt=i("p"),Tt.textContent=ia,kl=n(),Jt=i("p"),Jt.textContent=oa,Nl=n(),bt=i("p"),bt.textContent=ra,Wl=n(),c(Ct.$$.fragment),_l=n(),gt=i("p"),this.h()},l(e){const t=wa("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(s),At=a(e),vt=o(e,"P",{}),ca(vt).forEach(s),Gt=a(e),M(j.$$.fragment,e),xt=a(e),M(f.$$.fragment,e),Bt=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-ighhqz"&&(U.innerHTML=Yl),Zt=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-ydrdum"&&(T.innerHTML=El),$t=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1ci1eds"&&(J.textContent=ql),kt=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-5pgs5c"&&(b.textContent=zl),Nt=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1dk0w68"&&(C.innerHTML=Ql),Wt=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-cppufu"&&(I.textContent=Hl),_t=a(e),It=o(e,"IMG",{src:!0}),Rt=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1uya4d0"&&(v.textContent=Fl),St=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1y3an9l"&&(g.textContent=Ll),Vt=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-17nn2tu"&&(A.textContent=Pl),Yt=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1g6n4rl"&&(G.textContent=Dl),Et=a(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-4taq2a"&&(x.innerHTML=Kl),qt=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-hn5gp7"&&(B.textContent=Ol),zt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-j8wl7v"&&(Z.textContent=en),Qt=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1ssmgpb"&&($.textContent=tn),Ht=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-h63eiv"&&(k.textContent=sn),Xt=a(e),M(N.$$.fragment,e),Ft=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1ejfgk5"&&(W.textContent=ln),Lt=a(e),_=o(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-lid6ym"&&(_.innerHTML=nn),Pt=a(e),M(R.$$.fragment,e),Dt=a(e),M(S.$$.fragment,e),Kt=a(e),M(V.$$.fragment,e),Ot=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-mfr2mw"&&(Y.innerHTML=an),es=a(e),M(E.$$.fragment,e),ts=a(e),M(q.$$.fragment,e),ss=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1sfl7nk"&&(z.innerHTML=on),ls=a(e),M(Q.$$.fragment,e),ns=a(e),M(H.$$.fragment,e),as=a(e),M(X.$$.fragment,e),is=a(e),M(F.$$.fragment,e),os=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-185gao8"&&(L.textContent=rn),rs=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-e6nnzy"&&(P.textContent=cn),cs=a(e),M(D.$$.fragment,e),Ms=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-18dzsym"&&(K.textContent=Mn),ps=a(e),M(O.$$.fragment,e),hs=a(e),M(ee.$$.fragment,e),ms=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1t01wav"&&(te.textContent=pn),ys=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-j98tvi"&&(se.innerHTML=hn),us=a(e),M(le.$$.fragment,e),ws=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1r056o8"&&(ne.innerHTML=mn),ds=a(e),ae=o(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-1tnbgvc"&&(ae.innerHTML=yn),js=a(e),M(ie.$$.fragment,e),fs=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-im901f"&&(oe.textContent=un),Us=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1jamuql"&&(re.textContent=wn),Ts=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-18zgdsy"&&(ce.textContent=dn),Js=a(e),M(Me.$$.fragment,e),bs=a(e),M(pe.$$.fragment,e),Cs=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-xnkl8w"&&(he.textContent=jn),Is=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1aurt77"&&(me.innerHTML=fn),vs=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1yzpy08"&&(ye.textContent=Un),gs=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-o1h7a"&&(ue.textContent=Tn),As=a(e),M(we.$$.fragment,e),Gs=a(e),M(de.$$.fragment,e),xs=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-185bjpp"&&(je.innerHTML=Jn),Bs=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-6ni6w3"&&(fe.textContent=bn),Zs=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1suwwfe"&&(Ue.textContent=Cn),$s=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-a1a2e1"&&(Te.textContent=In),ks=a(e),Je=o(e,"UL",{"data-svelte-h":!0}),r(Je)!=="svelte-1sr1vnc"&&(Je.innerHTML=vn),Ns=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-dbx09b"&&(be.innerHTML=gn),Ws=a(e),M(Ce.$$.fragment,e),_s=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1x7rcj0"&&(Ie.innerHTML=An),Rs=a(e),M(ve.$$.fragment,e),Ss=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1tajk60"&&(ge.innerHTML=Gn),Vs=a(e),M(Ae.$$.fragment,e),Ys=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-p9izsn"&&(Ge.innerHTML=xn),Es=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-ist138"&&(xe.innerHTML=Bn),qs=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-11wavvk"&&(Be.innerHTML=Zn),zs=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-113m94f"&&(Ze.textContent=$n),Qs=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1tsvmsw"&&($e.textContent=kn),Hs=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1vb1g40"&&(ke.textContent=Nn),Xs=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-d4ocy7"&&(Ne.textContent=Wn),Fs=a(e),M(We.$$.fragment,e),Ls=a(e),M(_e.$$.fragment,e),Ps=a(e),M(Re.$$.fragment,e),Ds=a(e),Se=o(e,"PRE",{"data-svelte-h":!0}),r(Se)!=="svelte-mqrnyt"&&(Se.textContent=_n),Ks=a(e),M(Ve.$$.fragment,e),Os=a(e),Ye=o(e,"PRE",{"data-svelte-h":!0}),r(Ye)!=="svelte-ick26y"&&(Ye.textContent=Rn),el=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-wmkk7m"&&(Ee.textContent=Sn),tl=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1t94ag6"&&(qe.textContent=Vn),sl=a(e),M(ze.$$.fragment,e),ll=a(e),Qe=o(e,"PRE",{"data-svelte-h":!0}),r(Qe)!=="svelte-we3tc3"&&(Qe.textContent=Yn),nl=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-fu67dr"&&(He.textContent=En),al=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-11he3hz"&&(Xe.textContent=qn),il=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-wkh4v1"&&(Fe.textContent=zn),ol=a(e),M(Le.$$.fragment,e),rl=a(e),Pe=o(e,"PRE",{"data-svelte-h":!0}),r(Pe)!=="svelte-zuw07a"&&(Pe.textContent=Qn),cl=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-9995rt"&&(De.textContent=Hn),Ml=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1u7ud9q"&&(Ke.textContent=Xn),pl=a(e),M(Oe.$$.fragment,e),hl=a(e),et=o(e,"PRE",{"data-svelte-h":!0}),r(et)!=="svelte-158wm6z"&&(et.textContent=Fn),ml=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-qcml34"&&(tt.textContent=Ln),yl=a(e),M(st.$$.fragment,e),ul=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1fxal5n"&&(lt.innerHTML=Pn),wl=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-165ddml"&&(nt.textContent=Dn),dl=a(e),at=o(e,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-mhvp7d"&&(at.innerHTML=Kn),jl=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-i89iqv"&&(it.innerHTML=On),fl=a(e),M(ot.$$.fragment,e),Ul=a(e),M(rt.$$.fragment,e),Tl=a(e),M(ct.$$.fragment,e),Jl=a(e),M(Mt.$$.fragment,e),bl=a(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-15c3jn4"&&(pt.textContent=ea),Cl=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-3bfxya"&&(ht.innerHTML=ta),Il=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-nl1n48"&&(mt.textContent=sa),vl=a(e),M(yt.$$.fragment,e),gl=a(e),M(ut.$$.fragment,e),Al=a(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1qfx2ub"&&(wt.textContent=la),Gl=a(e),M(dt.$$.fragment,e),xl=a(e),jt=o(e,"PRE",{"data-svelte-h":!0}),r(jt)!=="svelte-1uv406t"&&(jt.innerHTML=na),Bl=a(e),M(ft.$$.fragment,e),Zl=a(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-8m24ut"&&(Ut.textContent=aa),$l=a(e),Tt=o(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-rknvvb"&&(Tt.textContent=ia),kl=a(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-wq8jse"&&(Jt.textContent=oa),Nl=a(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-11y4pel"&&(bt.textContent=ra),Wl=a(e),M(Ct.$$.fragment,e),_l=a(e),gt=o(e,"P",{}),ca(gt).forEach(s),this.h()},h(){Sl(d,"name","hf:doc:metadata"),Sl(d,"content",Ta),pa(It.src,Xl="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/semantic_cache.jpg")||Sl(It,"src",Xl)},m(e,t){da(document.head,d),l(e,At,t),l(e,vt,t),l(e,Gt,t),p(j,e,t),l(e,xt,t),p(f,e,t),l(e,Bt,t),l(e,U,t),l(e,Zt,t),l(e,T,t),l(e,$t,t),l(e,J,t),l(e,kt,t),l(e,b,t),l(e,Nt,t),l(e,C,t),l(e,Wt,t),l(e,I,t),l(e,_t,t),l(e,It,t),l(e,Rt,t),l(e,v,t),l(e,St,t),l(e,g,t),l(e,Vt,t),l(e,A,t),l(e,Yt,t),l(e,G,t),l(e,Et,t),l(e,x,t),l(e,qt,t),l(e,B,t),l(e,zt,t),l(e,Z,t),l(e,Qt,t),l(e,$,t),l(e,Ht,t),l(e,k,t),l(e,Xt,t),p(N,e,t),l(e,Ft,t),l(e,W,t),l(e,Lt,t),l(e,_,t),l(e,Pt,t),p(R,e,t),l(e,Dt,t),p(S,e,t),l(e,Kt,t),p(V,e,t),l(e,Ot,t),l(e,Y,t),l(e,es,t),p(E,e,t),l(e,ts,t),p(q,e,t),l(e,ss,t),l(e,z,t),l(e,ls,t),p(Q,e,t),l(e,ns,t),p(H,e,t),l(e,as,t),p(X,e,t),l(e,is,t),p(F,e,t),l(e,os,t),l(e,L,t),l(e,rs,t),l(e,P,t),l(e,cs,t),p(D,e,t),l(e,Ms,t),l(e,K,t),l(e,ps,t),p(O,e,t),l(e,hs,t),p(ee,e,t),l(e,ms,t),l(e,te,t),l(e,ys,t),l(e,se,t),l(e,us,t),p(le,e,t),l(e,ws,t),l(e,ne,t),l(e,ds,t),l(e,ae,t),l(e,js,t),p(ie,e,t),l(e,fs,t),l(e,oe,t),l(e,Us,t),l(e,re,t),l(e,Ts,t),l(e,ce,t),l(e,Js,t),p(Me,e,t),l(e,bs,t),p(pe,e,t),l(e,Cs,t),l(e,he,t),l(e,Is,t),l(e,me,t),l(e,vs,t),l(e,ye,t),l(e,gs,t),l(e,ue,t),l(e,As,t),p(we,e,t),l(e,Gs,t),p(de,e,t),l(e,xs,t),l(e,je,t),l(e,Bs,t),l(e,fe,t),l(e,Zs,t),l(e,Ue,t),l(e,$s,t),l(e,Te,t),l(e,ks,t),l(e,Je,t),l(e,Ns,t),l(e,be,t),l(e,Ws,t),p(Ce,e,t),l(e,_s,t),l(e,Ie,t),l(e,Rs,t),p(ve,e,t),l(e,Ss,t),l(e,ge,t),l(e,Vs,t),p(Ae,e,t),l(e,Ys,t),l(e,Ge,t),l(e,Es,t),l(e,xe,t),l(e,qs,t),l(e,Be,t),l(e,zs,t),l(e,Ze,t),l(e,Qs,t),l(e,$e,t),l(e,Hs,t),l(e,ke,t),l(e,Xs,t),l(e,Ne,t),l(e,Fs,t),p(We,e,t),l(e,Ls,t),p(_e,e,t),l(e,Ps,t),p(Re,e,t),l(e,Ds,t),l(e,Se,t),l(e,Ks,t),p(Ve,e,t),l(e,Os,t),l(e,Ye,t),l(e,el,t),l(e,Ee,t),l(e,tl,t),l(e,qe,t),l(e,sl,t),p(ze,e,t),l(e,ll,t),l(e,Qe,t),l(e,nl,t),l(e,He,t),l(e,al,t),l(e,Xe,t),l(e,il,t),l(e,Fe,t),l(e,ol,t),p(Le,e,t),l(e,rl,t),l(e,Pe,t),l(e,cl,t),l(e,De,t),l(e,Ml,t),l(e,Ke,t),l(e,pl,t),p(Oe,e,t),l(e,hl,t),l(e,et,t),l(e,ml,t),l(e,tt,t),l(e,yl,t),p(st,e,t),l(e,ul,t),l(e,lt,t),l(e,wl,t),l(e,nt,t),l(e,dl,t),l(e,at,t),l(e,jl,t),l(e,it,t),l(e,fl,t),p(ot,e,t),l(e,Ul,t),p(rt,e,t),l(e,Tl,t),p(ct,e,t),l(e,Jl,t),p(Mt,e,t),l(e,bl,t),l(e,pt,t),l(e,Cl,t),l(e,ht,t),l(e,Il,t),l(e,mt,t),l(e,vl,t),p(yt,e,t),l(e,gl,t),p(ut,e,t),l(e,Al,t),l(e,wt,t),l(e,Gl,t),p(dt,e,t),l(e,xl,t),l(e,jt,t),l(e,Bl,t),p(ft,e,t),l(e,Zl,t),l(e,Ut,t),l(e,$l,t),l(e,Tt,t),l(e,kl,t),l(e,Jt,t),l(e,Nl,t),l(e,bt,t),l(e,Wl,t),p(Ct,e,t),l(e,_l,t),l(e,gt,t),Rl=!0},p:ha,i(e){Rl||(h(j.$$.fragment,e),h(f.$$.fragment,e),h(N.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(V.$$.fragment,e),h(E.$$.fragment,e),h(q.$$.fragment,e),h(Q.$$.fragment,e),h(H.$$.fragment,e),h(X.$$.fragment,e),h(F.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(Me.$$.fragment,e),h(pe.$$.fragment,e),h(we.$$.fragment,e),h(de.$$.fragment,e),h(Ce.$$.fragment,e),h(ve.$$.fragment,e),h(Ae.$$.fragment,e),h(We.$$.fragment,e),h(_e.$$.fragment,e),h(Re.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),h(Le.$$.fragment,e),h(Oe.$$.fragment,e),h(st.$$.fragment,e),h(ot.$$.fragment,e),h(rt.$$.fragment,e),h(ct.$$.fragment,e),h(Mt.$$.fragment,e),h(yt.$$.fragment,e),h(ut.$$.fragment,e),h(dt.$$.fragment,e),h(ft.$$.fragment,e),h(Ct.$$.fragment,e),Rl=!0)},o(e){m(j.$$.fragment,e),m(f.$$.fragment,e),m(N.$$.fragment,e),m(R.$$.fragment,e),m(S.$$.fragment,e),m(V.$$.fragment,e),m(E.$$.fragment,e),m(q.$$.fragment,e),m(Q.$$.fragment,e),m(H.$$.fragment,e),m(X.$$.fragment,e),m(F.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(Me.$$.fragment,e),m(pe.$$.fragment,e),m(we.$$.fragment,e),m(de.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(Ae.$$.fragment,e),m(We.$$.fragment,e),m(_e.$$.fragment,e),m(Re.$$.fragment,e),m(Ve.$$.fragment,e),m(ze.$$.fragment,e),m(Le.$$.fragment,e),m(Oe.$$.fragment,e),m(st.$$.fragment,e),m(ot.$$.fragment,e),m(rt.$$.fragment,e),m(ct.$$.fragment,e),m(Mt.$$.fragment,e),m(yt.$$.fragment,e),m(ut.$$.fragment,e),m(dt.$$.fragment,e),m(ft.$$.fragment,e),m(Ct.$$.fragment,e),Rl=!1},d(e){e&&(s(At),s(vt),s(Gt),s(xt),s(Bt),s(U),s(Zt),s(T),s($t),s(J),s(kt),s(b),s(Nt),s(C),s(Wt),s(I),s(_t),s(It),s(Rt),s(v),s(St),s(g),s(Vt),s(A),s(Yt),s(G),s(Et),s(x),s(qt),s(B),s(zt),s(Z),s(Qt),s($),s(Ht),s(k),s(Xt),s(Ft),s(W),s(Lt),s(_),s(Pt),s(Dt),s(Kt),s(Ot),s(Y),s(es),s(ts),s(ss),s(z),s(ls),s(ns),s(as),s(is),s(os),s(L),s(rs),s(P),s(cs),s(Ms),s(K),s(ps),s(hs),s(ms),s(te),s(ys),s(se),s(us),s(ws),s(ne),s(ds),s(ae),s(js),s(fs),s(oe),s(Us),s(re),s(Ts),s(ce),s(Js),s(bs),s(Cs),s(he),s(Is),s(me),s(vs),s(ye),s(gs),s(ue),s(As),s(Gs),s(xs),s(je),s(Bs),s(fe),s(Zs),s(Ue),s($s),s(Te),s(ks),s(Je),s(Ns),s(be),s(Ws),s(_s),s(Ie),s(Rs),s(Ss),s(ge),s(Vs),s(Ys),s(Ge),s(Es),s(xe),s(qs),s(Be),s(zs),s(Ze),s(Qs),s($e),s(Hs),s(ke),s(Xs),s(Ne),s(Fs),s(Ls),s(Ps),s(Ds),s(Se),s(Ks),s(Os),s(Ye),s(el),s(Ee),s(tl),s(qe),s(sl),s(ll),s(Qe),s(nl),s(He),s(al),s(Xe),s(il),s(Fe),s(ol),s(rl),s(Pe),s(cl),s(De),s(Ml),s(Ke),s(pl),s(hl),s(et),s(ml),s(tt),s(yl),s(ul),s(lt),s(wl),s(nt),s(dl),s(at),s(jl),s(it),s(fl),s(Ul),s(Tl),s(Jl),s(bl),s(pt),s(Cl),s(ht),s(Il),s(mt),s(vl),s(gl),s(Al),s(wt),s(Gl),s(xl),s(jt),s(Bl),s(Zl),s(Ut),s($l),s(Tt),s(kl),s(Jt),s(Nl),s(bt),s(Wl),s(_l),s(gt)),s(d),y(j,e),y(f,e),y(N,e),y(R,e),y(S,e),y(V,e),y(E,e),y(q,e),y(Q,e),y(H,e),y(X,e),y(F,e),y(D,e),y(O,e),y(ee,e),y(le,e),y(ie,e),y(Me,e),y(pe,e),y(we,e),y(de,e),y(Ce,e),y(ve,e),y(Ae,e),y(We,e),y(_e,e),y(Re,e),y(Ve,e),y(ze,e),y(Le,e),y(Oe,e),y(st,e),y(ot,e),y(rt,e),y(ct,e),y(Mt,e),y(yt,e),y(ut,e),y(dt,e),y(ft,e),y(Ct,e)}}}const Ta='{"title":"Implementing semantic cache to improve a RAG system with FAISS.","local":"implementing-semantic-cache-to-improve-a-rag-system-with-faiss","sections":[],"depth":1}';function Ja(Vl){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ga extends ya{constructor(d){super(),ua(this,d,Ja,Ua,Ma,{})}}export{ga as component};
