import{s as Tl,f as yl,n as bl,o as vl}from"../chunks/scheduler.85c25b89.js";import{S as wl,i as Jl,g as r,s as n,r as c,A as Ul,h as s,f as a,c as l,j as T,u as m,x as d,k as M,l as Cl,y as i,a as o,v as h,d as f,t as u,w as g}from"../chunks/index.c142fe32.js";import{D as y}from"../chunks/Docstring.d3e0bcd1.js";import{C as Rt}from"../chunks/CodeBlock.a5e95a57.js";import{H as b,E as jl}from"../chunks/EditOnGithub.a592e7aa.js";function Il(an){let j,Wt,Lt,Ht,R,zt,L,on='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',Qt,Z,nn="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",Gt,W,St,H,ln="Fine-tuning a language model via DPO consists of two steps and is easier than PPO:",Xt,z,rn="<li><strong>Data collection</strong>: Gather a preference dataset with positive and negative selected pairs of generation, given a prompt.</li> <li><strong>Optimization</strong>: Maximize the log-likelihood of the DPO loss directly.</li>",Vt,Q,sn='DPO-compatible datasets can be found with <a href="https://huggingface.co/datasets?other=dpo" rel="nofollow">the tag <code>dpo</code> on Hugging Face Hub</a>. You can also explore the <a href="https://huggingface.co/collections/librarian-bots/direct-preference-optimization-datasets-66964b12835f46289b6ef2fc" rel="nofollow">librarian-bots/direct-preference-optimization-datasets</a> Collection to identify datasets that are likely to support DPO training.',Yt,G,dn='This process is illustrated in the sketch below (from <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">figure 1 of the original paper</a>):',Kt,x,pn,ea,S,cn='Read more about DPO algorithm in the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">original paper</a>.',ta,X,aa,V,mn='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',oa,O,hn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',na,Y,fn="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",la,K,un="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",ra,ee,gn="for example:",sa,te,ia,ae,_n="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",da,oe,Mn='<a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> can be used to fine-tune visual language models (VLMs). In this case, the dataset must also contain the key <code>images</code>, and the trainer’s <code>tokenizer</code> is the VLM’s <code>processor</code>. For example, for Idefics2, the processor expects the dataset to have the following format:',pa,ne,Tn="Note: Currently, VLM support is exclusive to Idefics2 and does not extend to other VLMs.",ca,le,ma,re,ha,se,yn="The DPO trainer expects a model of <code>AutoModelForCausalLM</code> or <code>AutoModelForVision2Seq</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",fa,ie,ua,de,bn='For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).',ga,pe,_a,ce,vn="After this one can then call:",Ma,me,Ta,he,wn="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",ya,fe,ba,ue,Jn='Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression. To use this loss, set the <code>loss_type=&quot;sigmoid&quot;</code> (default) in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',va,ge,Un='The <a href="https://huggingface.co/papers/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper. To use this loss, set the <code>loss_type=&quot;hinge&quot;</code> in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>. In this case, the <code>beta</code> is the reciprocal of the margin.',wa,_e,Cn='The <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss. To use the loss set the <code>loss_type=&quot;ipo&quot;</code> in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>. In this case, the <code>beta</code> is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).',Ja,Me,jn='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability. In this approach, the <code>label_smoothing</code> parameter in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> is used to model the probability of existing label noise. To apply this conservative loss, set <code>label_smoothing</code> to a value greater than 0.0 (between 0.0 and 0.5; the default is 0.0).',Ua,Te,In='The <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO</a> authors propose to minimize the reverse KL instead of the negative log-sigmoid loss of DPO which corresponds to forward KL. To use the loss set the <code>loss_type=&quot;exo_pair&quot;</code> in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>. Setting non-zero <code>label_smoothing</code> (default <code>1e-3</code>) leads to a simplified version of EXO on pair-wise preferences (see Eqn. (16) of the <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO paper</a>). The full version of EXO uses <code>K&gt;2</code> completions generated by the SFT policy, which becomes an unbiased estimator of the PPO objective (up to a constant) when <code>K</code> is sufficiently large.',Ca,ye,xn='The <a href="https://huggingface.co/papers/2402.05369" rel="nofollow">NCA</a> authors shows that NCA optimizes the absolute likelihood for each response rather than the relative likelihood. To use the loss set the <code>loss_type=&quot;nca_pair&quot;</code> in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',ja,be,On='The <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> authors propose an unbiased estimate of the DPO loss that is robust to preference noise in the data. Like in cDPO, it assumes that the preference labels are noisy with some probability. In this approach, the <code>label_smoothing</code> parameter in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> is used to model the probability of existing label noise. To apply this conservative loss, set <code>label_smoothing</code> to a value greater than 0.0 (between 0.0 and 0.5; the default is 0.0) and set the <code>loss_type=&quot;robust&quot;</code> in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',Ia,ve,$n='The <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0. To use this loss, set the <code>loss_type=&quot;bco_pair&quot;</code> in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',xa,we,Pn='The <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper suggests syncing the reference model weights after every <code>ref_model_sync_steps</code> steps of SGD with weight <code>ref_model_mixup_alpha</code> during DPO training. To toggle this callback use the <code>sync_ref_model=True</code> in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',Oa,Je,Dn='The <a href="https://huggingface.co/papers/2404.19733" rel="nofollow">RPO</a> paper implements an iterative preference tuning algorithm using a loss related to the RPO loss in this <a href="https://huggingface.co/papers/2405.16436" rel="nofollow">paper</a> that essentially consists of a weighted SFT loss on the chosen preferences together with the DPO loss. To use this loss, set the <code>rpo_alpha</code> in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> to an appropriate value. The paper suggests setting this weight to 1.0.',$a,Ue,kn='The <a href="https://huggingface.co/papers/2405.00675" rel="nofollow">SPPO</a> authors claim that SPPO is capable of solving the Nash equilibrium iteratively by pushing the chosen rewards to be as large as 1/2 and the rejected rewards to be as small as -1/2 and can alleviate data sparsity issues. The implementation approximates this algorithm by employing hard label probabilities, assigning 1 to the winner and 0 to the loser. To use this loss, set the <code>loss_type=&quot;sppo_hard&quot;</code> in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',Pa,Ce,An='The <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> authors propose to use Distributional Preference Alignment Via Optimal Transport. Traditionally, the alignment algorithms use paired preferences at a sample level, which does not ensure alignment on the distributional level. AOT, on the other hand, can align LLMs on paired or unpaired preference data by making the reward distribution of the positive samples stochastically dominant in the first order on the distribution of negative samples. Specifically, <code>loss_type=&quot;aot&quot;</code> is appropriate for paired datasets, where each prompt has both chosen and rejected responses; <code>loss_type=&quot;aot_pair&quot;</code> is for unpaired datasets. In a nutshell, <code>loss_type=&quot;aot&quot;</code> ensures that the log-likelihood ratio of chosen to rejected of the aligned model has higher quantiles than that ratio for the reference model. <code>loss_type=&quot;aot_pair&quot;</code> ensures that the chosen reward is higher on all quantiles than the rejected reward. Note that in both cases quantiles are obtained via sorting. To fully leverage the advantages of the AOT algorithm, it is important to maximize the per-GPU batch size.',Da,je,Nn='The <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> method introduces an “anchored” version of the alignment objective. There are two variants: <code>apo_zero</code> and <code>apo_down</code>. The <code>apo_zero</code> loss increases the likelihood of winning outputs while decreasing the likelihood of losing outputs, making it suitable when the model is less performant than the winning outputs. On the other hand, <code>apo_down</code> decreases the likelihood of both winning and losing outputs, but with a stronger emphasis on reducing the likelihood of losing outputs. This variant is more effective when the model is better than the winning outputs. To use these losses, set <code>loss_type=&quot;apo_zero&quot;</code> or <code>loss_type=&quot;apo_down&quot;</code> in the <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',ka,Ie,Aa,xe,qn=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,Na,Oe,Bn=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,qa,$e,Ba,Pe,Fn="While training and evaluating we record the following reward metrics:",Fa,De,En="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",Ea,ke,Ra,Ae,Rn='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',La,Ne,Ln="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",Za,qe,Zn='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',Wa,Be,Ha,Fe,Wn='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',za,Ee,Qa,Re,Hn="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",Ga,Le,zn="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>ref_model</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",Sa,Ze,Xa,We,Qn='As suggested by <a href="https://medium.com/@bnjmn_marie/dont-merge-your-lora-adapter-into-a-4-bit-llm-65b6da287997" rel="nofollow">Benjamin Marie</a>, the best option for merging QLoRA adapters is to first dequantize the base model, then merge the adapter. Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>.',Va,He,Gn="However, after using this approach, you will have an unquantized base model. Therefore, to use QLoRA for DPO, you will need to re-quantize the merged model or use the unquantized merge (resulting in higher memory demand).",Ya,ze,Ka,Qe,Sn='To avoid the downsides with option 2, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in <a href="/docs/trl/pr_1725/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a>.',eo,Ge,Xn="For example:",to,Se,ao,Xe,oo,p,Ve,yo,ut,Vn="Initialize DPOTrainer.",bo,$,Ye,vo,gt,Yn=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,wo,P,Ke,Jo,_t,Kn="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",Uo,w,et,Co,Mt,el="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",jo,Tt,tl="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Io,D,tt,xo,yt,al="Concatenate the chosen and rejected inputs into a single tensor.",Oo,k,at,$o,bt,ol="Compute the DPO loss for a batch of policy and reference model log probabilities.",Po,J,ot,Do,vt,nl=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,ko,wt,ll="Works both with or without labels.",Ao,A,nt,No,Jt,rl="Compute the log probabilities of the given labels under the given logits.",qo,N,lt,Bo,Ut,sl="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",Fo,q,rt,Eo,Ct,il="Generate samples from the model and reference model for the given batch of inputs.",Ro,U,st,Lo,jt,dl="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Zo,It,pl="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Wo,C,it,Ho,xt,cl="Returns the training <code>~torch.utils.data.DataLoader</code>.",zo,Ot,ml="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Qo,B,dt,Go,$t,hl="Log <code>logs</code> on the various objects watching training, including stored metrics.",So,F,pt,Xo,Pt,fl="Context manager for handling null reference model (that is, peft adapter manipulation).",Vo,v,ct,Yo,Dt,ul="Tokenize a single row from a DPO specific dataset.",Ko,kt,gl=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,en,At,_l=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,no,mt,lo,I,ht,tn,Nt,Ml="Initialize DPOConfig.",ro,ft,so,Zt,io;return R=new b({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),W=new b({props:{title:"How DPO works",local:"how-dpo-works",headingTag:"h2"}}),X=new b({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),te=new Rt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),le=new Rt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCdpbWFnZXMnJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCSW1hZ2Uub3BlbignYmVhY2guanBnJyklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJJbWFnZS5vcGVuKCdzdHJlZXQuanBnJyklNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAncHJvbXB0JyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdUaGUlMjBpbWFnZSUyMCUzQ2ltYWdlJTNFJTIwc2hvd3MnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJyUzQ2ltYWdlJTNFJTIwVGhlJTIwaW1hZ2UlMjBkZXBpY3RzJyUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCdjaG9zZW4nJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBzdW5ueSUyMGJlYWNoJTIwd2l0aCUyMHBhbG0lMjB0cmVlcy4nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBidXN5JTIwc3RyZWV0JTIwd2l0aCUyMHNldmVyYWwlMjBjYXJzJTIwYW5kJTIwYnVpbGRpbmdzLiclMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAncmVqZWN0ZWQnJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBzbm93eSUyMG1vdW50YWluJTIwd2l0aCUyMHNraWVycy4nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBjYWxtJTIwY291bnRyeXNpZGUlMjB3aXRoJTIwZ3JlZW4lMjBmaWVsZHMuJyUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RA==",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&#x27;images&#x27;</span>: [
        [Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;beach.jpg&#x27;</span>)],
        [Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;street.jpg&#x27;</span>)],
    ],
    <span class="hljs-string">&#x27;prompt&#x27;</span>: [
        <span class="hljs-string">&#x27;The image &lt;image&gt; shows&#x27;</span>,
        <span class="hljs-string">&#x27;&lt;image&gt; The image depicts&#x27;</span>,
    ],
    <span class="hljs-string">&#x27;chosen&#x27;</span>: [
        <span class="hljs-string">&#x27;a sunny beach with palm trees.&#x27;</span>,
        <span class="hljs-string">&#x27;a busy street with several cars and buildings.&#x27;</span>,
    ],
    <span class="hljs-string">&#x27;rejected&#x27;</span>: [
        <span class="hljs-string">&#x27;a snowy mountain with skiers.&#x27;</span>,
        <span class="hljs-string">&#x27;a calm countryside with green fields.&#x27;</span>,
    ],
}`,wrap:!1}}),re=new b({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),ie=new b({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),pe=new Rt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMERQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQWRwb190cmFpbmVyJTIwJTNEJTIwRFBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHJlZl9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjAlMjAlMjMlMjBmb3IlMjB2aXN1YWwlMjBsYW5ndWFnZSUyMG1vZGVscyUyQyUyMHVzZSUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyMGluc3RlYWQlMEEp",highlighted:`training_args = DPOConfig(
    beta=<span class="hljs-number">0.1</span>,
)
dpo_trainer = DPOTrainer(
    model,
    ref_model,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,  <span class="hljs-comment"># for visual language models, use tokenizer=processor instead</span>
)`,wrap:!1}}),me=new Rt({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),fe=new b({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),Ie=new b({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),$e=new b({props:{title:"Logging",local:"logging",headingTag:"h2"}}),ke=new b({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),Be=new Rt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number.</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/zephyr-sft&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False.</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

training_args = DPOConfig(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    beta=<span class="hljs-number">0.1</span>,
)

dpo_trainer = DPOTrainer(
    model,
    ref_model=<span class="hljs-literal">None</span>,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)
dpo_trainer.train()`,wrap:!1}}),Ee=new b({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),Ze=new b({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),ze=new b({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),Se=new Rt({props:{code:"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",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
training_args = DPOConfig(
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)
dpo_trainer = DPOTrainer(
    model,
    args=training_args,
    ...
)`,wrap:!1}}),Xe=new b({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Ve=new y({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>DPOConfig</code>) &#x2014;
The DPO config arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L73"}}),Ye=new y({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""},{name:"images",val:" = None"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L717"}}),Ke=new y({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L960"}}),et=new y({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L1271"}}),tt=new y({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"is_vision_model",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L986",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),at=new y({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L1057",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),ot=new y({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L1547"}}),nt=new y({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L1238",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A Tuple of two tensor of shape ((batch_size,), (batch_size,)) containing the sum of log probabilities of the given labels under the given logits in the first tensor and the number of non-masked tokens in the second tensor.</p>
`}}),lt=new y({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L1354"}}),rt=new y({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L1457"}}),st=new y({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L665"}}),it=new y({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L622"}}),dt=new y({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L1597"}}),pt=new y({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L948"}}),ct=new y({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_trainer.py#L788"}}),mt=new b({props:{title:"DPOConfig",local:"trl.DPOConfig",headingTag:"h2"}}),ht=new y({props:{name:"class trl.DPOConfig",anchor:"trl.DPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"},{name:"f_divergence_type",val:": FDivergenceType = <FDivergenceType.REVERSE_KL: 'reverse_kl'>"},{name:"f_alpha_divergence_coef",val:": float = 1.0"},{name:"sync_ref_model",val:": bool = False"},{name:"ref_model_mixup_alpha",val:": float = 0.9"},{name:"ref_model_sync_steps",val:": int = 64"},{name:"rpo_alpha",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.0</code>) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report and <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> paper that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: sigmoid loss from the original <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> paper.</li>
<li><code>&quot;hinge&quot;</code>: hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper.</li>
<li><code>&quot;ipo&quot;</code>: IPO loss from the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> paper.</li>
<li><code>&quot;exo_pair&quot;</code>: pairwise EXO loss from the <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO</a> paper.</li>
<li><code>&quot;nca_pair&quot;</code>: pairwise NCA loss from the <a href="https://huggingface.co/papers/2402.05369" rel="nofollow">NCA</a> paper.</li>
<li><code>&quot;robust&quot;</code>: unbiased estimate of the DPO loss that is robust to preference noise from the <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> paper.</li>
<li><code>&quot;bco_pair&quot;</code>: pairwise BCO loss from the <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> paper.</li>
<li><code>&quot;sppo_hard&quot;</code>: SPPO loss with hard label from the <a href="https://huggingface.co/papers/2405.00675" rel="nofollow">SPPO</a> paper.</li>
<li><code>&quot;aot&quot;</code>: AOT loss for paired datasets from the <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> paper.</li>
<li><code>&quot;aot_pair&quot;</code>: AOT loss for unpaired datasets from the <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> paper.</li>
<li><code>&quot;apo_zero&quot;</code>: APO-zero loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
<li><code>&quot;apo_down&quot;</code>: APO-down loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.DPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOConfig.max_length",description:`<strong>max_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOConfig.is_encoder_decoder(Optional[int],",description:`<strong>is_encoder_decoder(<code>Optional[int]</code>,</strong> <em>optional</em>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder(Optional[int],"},{anchor:"trl.DPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.DPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.DPOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOConfig.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOConfig.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOConfig.reference_free",description:`<strong>reference_free</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOConfig.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"},{anchor:"trl.DPOConfig.f_divergence_type",description:`<strong>f_divergence_type</strong> (<code>FDivergenceType</code>, <em>optional</em>, defaults to <code>FDivergenceType.REVERSE_KL</code>) &#x2014;
The type of f-divergence regularization function to compute divergence between policy and reference model. This argument is optional, defaults to <code>FDivergenceType.REVERSE_KL</code>.`,name:"f_divergence_type"},{anchor:"trl.DPOConfig.f_alpha_divergence_coef",description:`<strong>f_alpha_divergence_coef</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
The alpha coef in alpha-divergence(u^-alpha) regularization function for DPO loss.`,name:"f_alpha_divergence_coef"},{anchor:"trl.DPOConfig.sync_ref_model",description:`<strong>sync_ref_model</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The flag for syncing reference model during training from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"sync_ref_model"},{anchor:"trl.DPOConfig.ref_model_mixup_alpha",description:`<strong>ref_model_mixup_alpha</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
The alpha parameter from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"ref_model_mixup_alpha"},{anchor:"trl.DPOConfig.ref_model_sync_steps",description:`<strong>ref_model_sync_steps</strong> (&#x2018;int&#x2019;, <em>optional</em>, defaults to <code>2</code>) &#x2014;
The tau parameter from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"ref_model_sync_steps"},{anchor:"trl.DPOConfig.rpo_alpha",description:`<strong>rpo_alpha</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The alpha parameter from the <a href="https://huggingface.co/papers/2404.19733" rel="nofollow">RPO</a> paper V3. If None, no weighting is applied and the loss is the same as the DPO loss. The paper recommends <code>rpo_alpha=1.0</code>.`,name:"rpo_alpha"}],source:"https://github.com/huggingface/trl/blob/vr_1725/trl/trainer/dpo_config.py#L32"}}),ft=new jl({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dpo_trainer.mdx"}}),{c(){j=r("meta"),Wt=n(),Lt=r("p"),Ht=n(),c(R.$$.fragment),zt=n(),L=r("p"),L.innerHTML=on,Qt=n(),Z=r("p"),Z.textContent=nn,Gt=n(),c(W.$$.fragment),St=n(),H=r("p"),H.textContent=ln,Xt=n(),z=r("ol"),z.innerHTML=rn,Vt=n(),Q=r("p"),Q.innerHTML=sn,Yt=n(),G=r("p"),G.innerHTML=dn,Kt=n(),x=r("img"),ea=n(),S=r("p"),S.innerHTML=cn,ta=n(),c(X.$$.fragment),aa=n(),V=r("p"),V.innerHTML=mn,oa=n(),O=r("div"),O.innerHTML=hn,na=n(),Y=r("p"),Y.innerHTML=fn,la=n(),K=r("ul"),K.innerHTML=un,ra=n(),ee=r("p"),ee.textContent=gn,sa=n(),c(te.$$.fragment),ia=n(),ae=r("p"),ae.innerHTML=_n,da=n(),oe=r("p"),oe.innerHTML=Mn,pa=n(),ne=r("p"),ne.textContent=Tn,ca=n(),c(le.$$.fragment),ma=n(),c(re.$$.fragment),ha=n(),se=r("p"),se.innerHTML=yn,fa=n(),c(ie.$$.fragment),ua=n(),de=r("p"),de.innerHTML=bn,ga=n(),c(pe.$$.fragment),_a=n(),ce=r("p"),ce.textContent=vn,Ma=n(),c(me.$$.fragment),Ta=n(),he=r("p"),he.innerHTML=wn,ya=n(),c(fe.$$.fragment),ba=n(),ue=r("p"),ue.innerHTML=Jn,va=n(),ge=r("p"),ge.innerHTML=Un,wa=n(),_e=r("p"),_e.innerHTML=Cn,Ja=n(),Me=r("p"),Me.innerHTML=jn,Ua=n(),Te=r("p"),Te.innerHTML=In,Ca=n(),ye=r("p"),ye.innerHTML=xn,ja=n(),be=r("p"),be.innerHTML=On,Ia=n(),ve=r("p"),ve.innerHTML=$n,xa=n(),we=r("p"),we.innerHTML=Pn,Oa=n(),Je=r("p"),Je.innerHTML=Dn,$a=n(),Ue=r("p"),Ue.innerHTML=kn,Pa=n(),Ce=r("p"),Ce.innerHTML=An,Da=n(),je=r("p"),je.innerHTML=Nn,ka=n(),c(Ie.$$.fragment),Aa=n(),xe=r("p"),xe.innerHTML=qn,Na=n(),Oe=r("p"),Oe.innerHTML=Bn,qa=n(),c($e.$$.fragment),Ba=n(),Pe=r("p"),Pe.textContent=Fn,Fa=n(),De=r("ul"),De.innerHTML=En,Ea=n(),c(ke.$$.fragment),Ra=n(),Ae=r("p"),Ae.innerHTML=Rn,La=n(),Ne=r("table"),Ne.innerHTML=Ln,Za=n(),qe=r("p"),qe.innerHTML=Zn,Wa=n(),c(Be.$$.fragment),Ha=n(),Fe=r("p"),Fe.innerHTML=Wn,za=n(),c(Ee.$$.fragment),Qa=n(),Re=r("p"),Re.textContent=Hn,Ga=n(),Le=r("ol"),Le.innerHTML=zn,Sa=n(),c(Ze.$$.fragment),Xa=n(),We=r("p"),We.innerHTML=Qn,Va=n(),He=r("p"),He.textContent=Gn,Ya=n(),c(ze.$$.fragment),Ka=n(),Qe=r("p"),Qe.innerHTML=Sn,eo=n(),Ge=r("p"),Ge.textContent=Xn,to=n(),c(Se.$$.fragment),ao=n(),c(Xe.$$.fragment),oo=n(),p=r("div"),c(Ve.$$.fragment),yo=n(),ut=r("p"),ut.textContent=Vn,bo=n(),$=r("div"),c(Ye.$$.fragment),vo=n(),gt=r("p"),gt.innerHTML=Yn,wo=n(),P=r("div"),c(Ke.$$.fragment),Jo=n(),_t=r("p"),_t.textContent=Kn,Uo=n(),w=r("div"),c(et.$$.fragment),Co=n(),Mt=r("p"),Mt.textContent=el,jo=n(),Tt=r("p"),Tt.textContent=tl,Io=n(),D=r("div"),c(tt.$$.fragment),xo=n(),yt=r("p"),yt.textContent=al,Oo=n(),k=r("div"),c(at.$$.fragment),$o=n(),bt=r("p"),bt.textContent=ol,Po=n(),J=r("div"),c(ot.$$.fragment),Do=n(),vt=r("p"),vt.innerHTML=nl,ko=n(),wt=r("p"),wt.textContent=ll,Ao=n(),A=r("div"),c(nt.$$.fragment),No=n(),Jt=r("p"),Jt.textContent=rl,qo=n(),N=r("div"),c(lt.$$.fragment),Bo=n(),Ut=r("p"),Ut.textContent=sl,Fo=n(),q=r("div"),c(rt.$$.fragment),Eo=n(),Ct=r("p"),Ct.textContent=il,Ro=n(),U=r("div"),c(st.$$.fragment),Lo=n(),jt=r("p"),jt.innerHTML=dl,Zo=n(),It=r("p"),It.innerHTML=pl,Wo=n(),C=r("div"),c(it.$$.fragment),Ho=n(),xt=r("p"),xt.innerHTML=cl,zo=n(),Ot=r("p"),Ot.innerHTML=ml,Qo=n(),B=r("div"),c(dt.$$.fragment),Go=n(),$t=r("p"),$t.innerHTML=hl,So=n(),F=r("div"),c(pt.$$.fragment),Xo=n(),Pt=r("p"),Pt.textContent=fl,Vo=n(),v=r("div"),c(ct.$$.fragment),Yo=n(),Dt=r("p"),Dt.textContent=ul,Ko=n(),kt=r("p"),kt.textContent=gl,en=n(),At=r("p"),At.textContent=_l,no=n(),c(mt.$$.fragment),lo=n(),I=r("div"),c(ht.$$.fragment),tn=n(),Nt=r("p"),Nt.textContent=Ml,ro=n(),c(ft.$$.fragment),so=n(),Zt=r("p"),this.h()},l(e){const t=Ul("svelte-u9bgzb",document.head);j=s(t,"META",{name:!0,content:!0}),t.forEach(a),Wt=l(e),Lt=s(e,"P",{}),T(Lt).forEach(a),Ht=l(e),m(R.$$.fragment,e),zt=l(e),L=s(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1lm7578"&&(L.innerHTML=on),Qt=l(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-xh4sh7"&&(Z.textContent=nn),Gt=l(e),m(W.$$.fragment,e),St=l(e),H=s(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-e9zjgv"&&(H.textContent=ln),Xt=l(e),z=s(e,"OL",{"data-svelte-h":!0}),d(z)!=="svelte-1fzn07o"&&(z.innerHTML=rn),Vt=l(e),Q=s(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1smzh1j"&&(Q.innerHTML=sn),Yt=l(e),G=s(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1j7o61v"&&(G.innerHTML=dn),Kt=l(e),x=s(e,"IMG",{width:!0,alt:!0,src:!0}),ea=l(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-16acsjo"&&(S.innerHTML=cn),ta=l(e),m(X.$$.fragment,e),aa=l(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-dcawbe"&&(V.innerHTML=mn),oa=l(e),O=s(e,"DIV",{style:!0,"data-svelte-h":!0}),d(O)!=="svelte-z15c7z"&&(O.innerHTML=hn),na=l(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-cb9b0v"&&(Y.innerHTML=fn),la=l(e),K=s(e,"UL",{"data-svelte-h":!0}),d(K)!=="svelte-17vxuta"&&(K.innerHTML=un),ra=l(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1gl9mvz"&&(ee.textContent=gn),sa=l(e),m(te.$$.fragment,e),ia=l(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1a8oxjk"&&(ae.innerHTML=_n),da=l(e),oe=s(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-10amptz"&&(oe.innerHTML=Mn),pa=l(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1vo7l4i"&&(ne.textContent=Tn),ca=l(e),m(le.$$.fragment,e),ma=l(e),m(re.$$.fragment,e),ha=l(e),se=s(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1fbhxim"&&(se.innerHTML=yn),fa=l(e),m(ie.$$.fragment,e),ua=l(e),de=s(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-15c9ahs"&&(de.innerHTML=bn),ga=l(e),m(pe.$$.fragment,e),_a=l(e),ce=s(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1lg6q1l"&&(ce.textContent=vn),Ma=l(e),m(me.$$.fragment,e),Ta=l(e),he=s(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1ac5mum"&&(he.innerHTML=wn),ya=l(e),m(fe.$$.fragment,e),ba=l(e),ue=s(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1d1ts9u"&&(ue.innerHTML=Jn),va=l(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-f1znju"&&(ge.innerHTML=Un),wa=l(e),_e=s(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1y016p5"&&(_e.innerHTML=Cn),Ja=l(e),Me=s(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-15v1yil"&&(Me.innerHTML=jn),Ua=l(e),Te=s(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-sk4nr5"&&(Te.innerHTML=In),Ca=l(e),ye=s(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-jz8xxx"&&(ye.innerHTML=xn),ja=l(e),be=s(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-r9edt9"&&(be.innerHTML=On),Ia=l(e),ve=s(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-1q3u5ac"&&(ve.innerHTML=$n),xa=l(e),we=s(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-r5h11n"&&(we.innerHTML=Pn),Oa=l(e),Je=s(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1gq9w4o"&&(Je.innerHTML=Dn),$a=l(e),Ue=s(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1ru3bp"&&(Ue.innerHTML=kn),Pa=l(e),Ce=s(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-1ka1sjq"&&(Ce.innerHTML=An),Da=l(e),je=s(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-19y60s7"&&(je.innerHTML=Nn),ka=l(e),m(Ie.$$.fragment,e),Aa=l(e),xe=s(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-14px1ga"&&(xe.innerHTML=qn),Na=l(e),Oe=s(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1c01yo3"&&(Oe.innerHTML=Bn),qa=l(e),m($e.$$.fragment,e),Ba=l(e),Pe=s(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-132s7j9"&&(Pe.textContent=Fn),Fa=l(e),De=s(e,"UL",{"data-svelte-h":!0}),d(De)!=="svelte-1oji3mm"&&(De.innerHTML=En),Ea=l(e),m(ke.$$.fragment,e),Ra=l(e),Ae=s(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-2145zu"&&(Ae.innerHTML=Rn),La=l(e),Ne=s(e,"TABLE",{"data-svelte-h":!0}),d(Ne)!=="svelte-435mua"&&(Ne.innerHTML=Ln),Za=l(e),qe=s(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1p74c9x"&&(qe.innerHTML=Zn),Wa=l(e),m(Be.$$.fragment,e),Ha=l(e),Fe=s(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1o18rwj"&&(Fe.innerHTML=Wn),za=l(e),m(Ee.$$.fragment,e),Qa=l(e),Re=s(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-4infz6"&&(Re.textContent=Hn),Ga=l(e),Le=s(e,"OL",{"data-svelte-h":!0}),d(Le)!=="svelte-4ytutj"&&(Le.innerHTML=zn),Sa=l(e),m(Ze.$$.fragment,e),Xa=l(e),We=s(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-rqj7uy"&&(We.innerHTML=Qn),Va=l(e),He=s(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1xhv3st"&&(He.textContent=Gn),Ya=l(e),m(ze.$$.fragment,e),Ka=l(e),Qe=s(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-d3g6xu"&&(Qe.innerHTML=Sn),eo=l(e),Ge=s(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-1gkqha7"&&(Ge.textContent=Xn),to=l(e),m(Se.$$.fragment,e),ao=l(e),m(Xe.$$.fragment,e),oo=l(e),p=s(e,"DIV",{class:!0});var _=T(p);m(Ve.$$.fragment,_),yo=l(_),ut=s(_,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-n6cc8y"&&(ut.textContent=Vn),bo=l(_),$=s(_,"DIV",{class:!0});var po=T($);m(Ye.$$.fragment,po),vo=l(po),gt=s(po,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-mcz8nm"&&(gt.innerHTML=Yn),po.forEach(a),wo=l(_),P=s(_,"DIV",{class:!0});var co=T(P);m(Ke.$$.fragment,co),Jo=l(co),_t=s(co,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-10t1062"&&(_t.textContent=Kn),co.forEach(a),Uo=l(_),w=s(_,"DIV",{class:!0});var qt=T(w);m(et.$$.fragment,qt),Co=l(qt),Mt=s(qt,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-16i1nac"&&(Mt.textContent=el),jo=l(qt),Tt=s(qt,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-tgti68"&&(Tt.textContent=tl),qt.forEach(a),Io=l(_),D=s(_,"DIV",{class:!0});var mo=T(D);m(tt.$$.fragment,mo),xo=l(mo),yt=s(mo,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1cvsgkk"&&(yt.textContent=al),mo.forEach(a),Oo=l(_),k=s(_,"DIV",{class:!0});var ho=T(k);m(at.$$.fragment,ho),$o=l(ho),bt=s(ho,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-ymgxq7"&&(bt.textContent=ol),ho.forEach(a),Po=l(_),J=s(_,"DIV",{class:!0});var Bt=T(J);m(ot.$$.fragment,Bt),Do=l(Bt),vt=s(Bt,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-8qlty5"&&(vt.innerHTML=nl),ko=l(Bt),wt=s(Bt,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1tyo99t"&&(wt.textContent=ll),Bt.forEach(a),Ao=l(_),A=s(_,"DIV",{class:!0});var fo=T(A);m(nt.$$.fragment,fo),No=l(fo),Jt=s(fo,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-4nmimv"&&(Jt.textContent=rl),fo.forEach(a),qo=l(_),N=s(_,"DIV",{class:!0});var uo=T(N);m(lt.$$.fragment,uo),Bo=l(uo),Ut=s(uo,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-11q8u7l"&&(Ut.textContent=sl),uo.forEach(a),Fo=l(_),q=s(_,"DIV",{class:!0});var go=T(q);m(rt.$$.fragment,go),Eo=l(go),Ct=s(go,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-18uwvbi"&&(Ct.textContent=il),go.forEach(a),Ro=l(_),U=s(_,"DIV",{class:!0});var Ft=T(U);m(st.$$.fragment,Ft),Lo=l(Ft),jt=s(Ft,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-xesobz"&&(jt.innerHTML=dl),Zo=l(Ft),It=s(Ft,"P",{"data-svelte-h":!0}),d(It)!=="svelte-qg43tm"&&(It.innerHTML=pl),Ft.forEach(a),Wo=l(_),C=s(_,"DIV",{class:!0});var Et=T(C);m(it.$$.fragment,Et),Ho=l(Et),xt=s(Et,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-dkae9b"&&(xt.innerHTML=cl),zo=l(Et),Ot=s(Et,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-hmd5cw"&&(Ot.innerHTML=ml),Et.forEach(a),Qo=l(_),B=s(_,"DIV",{class:!0});var _o=T(B);m(dt.$$.fragment,_o),Go=l(_o),$t=s(_o,"P",{"data-svelte-h":!0}),d($t)!=="svelte-nqksfz"&&($t.innerHTML=hl),_o.forEach(a),So=l(_),F=s(_,"DIV",{class:!0});var Mo=T(F);m(pt.$$.fragment,Mo),Xo=l(Mo),Pt=s(Mo,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-17kjsy4"&&(Pt.textContent=fl),Mo.forEach(a),Vo=l(_),v=s(_,"DIV",{class:!0});var E=T(v);m(ct.$$.fragment,E),Yo=l(E),Dt=s(E,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-1861yti"&&(Dt.textContent=ul),Ko=l(E),kt=s(E,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1mn1gnw"&&(kt.textContent=gl),en=l(E),At=s(E,"P",{"data-svelte-h":!0}),d(At)!=="svelte-1xvpyih"&&(At.textContent=_l),E.forEach(a),_.forEach(a),no=l(e),m(mt.$$.fragment,e),lo=l(e),I=s(e,"DIV",{class:!0});var To=T(I);m(ht.$$.fragment,To),tn=l(To),Nt=s(To,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-1va94c9"&&(Nt.textContent=Ml),To.forEach(a),ro=l(e),m(ft.$$.fragment,e),so=l(e),Zt=s(e,"P",{}),T(Zt).forEach(a),this.h()},h(){M(j,"name","hf:doc:metadata"),M(j,"content",xl),M(x,"width","835"),M(x,"alt","Screenshot 2024-03-19 at 12 39 41"),yl(x.src,pn="https://github.com/huggingface/trl/assets/49240599/9150fac6-3d88-4ca2-8ec6-2a6f3473216d")||M(x,"src",pn),Cl(O,"text-align","center"),M($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,j),o(e,Wt,t),o(e,Lt,t),o(e,Ht,t),h(R,e,t),o(e,zt,t),o(e,L,t),o(e,Qt,t),o(e,Z,t),o(e,Gt,t),h(W,e,t),o(e,St,t),o(e,H,t),o(e,Xt,t),o(e,z,t),o(e,Vt,t),o(e,Q,t),o(e,Yt,t),o(e,G,t),o(e,Kt,t),o(e,x,t),o(e,ea,t),o(e,S,t),o(e,ta,t),h(X,e,t),o(e,aa,t),o(e,V,t),o(e,oa,t),o(e,O,t),o(e,na,t),o(e,Y,t),o(e,la,t),o(e,K,t),o(e,ra,t),o(e,ee,t),o(e,sa,t),h(te,e,t),o(e,ia,t),o(e,ae,t),o(e,da,t),o(e,oe,t),o(e,pa,t),o(e,ne,t),o(e,ca,t),h(le,e,t),o(e,ma,t),h(re,e,t),o(e,ha,t),o(e,se,t),o(e,fa,t),h(ie,e,t),o(e,ua,t),o(e,de,t),o(e,ga,t),h(pe,e,t),o(e,_a,t),o(e,ce,t),o(e,Ma,t),h(me,e,t),o(e,Ta,t),o(e,he,t),o(e,ya,t),h(fe,e,t),o(e,ba,t),o(e,ue,t),o(e,va,t),o(e,ge,t),o(e,wa,t),o(e,_e,t),o(e,Ja,t),o(e,Me,t),o(e,Ua,t),o(e,Te,t),o(e,Ca,t),o(e,ye,t),o(e,ja,t),o(e,be,t),o(e,Ia,t),o(e,ve,t),o(e,xa,t),o(e,we,t),o(e,Oa,t),o(e,Je,t),o(e,$a,t),o(e,Ue,t),o(e,Pa,t),o(e,Ce,t),o(e,Da,t),o(e,je,t),o(e,ka,t),h(Ie,e,t),o(e,Aa,t),o(e,xe,t),o(e,Na,t),o(e,Oe,t),o(e,qa,t),h($e,e,t),o(e,Ba,t),o(e,Pe,t),o(e,Fa,t),o(e,De,t),o(e,Ea,t),h(ke,e,t),o(e,Ra,t),o(e,Ae,t),o(e,La,t),o(e,Ne,t),o(e,Za,t),o(e,qe,t),o(e,Wa,t),h(Be,e,t),o(e,Ha,t),o(e,Fe,t),o(e,za,t),h(Ee,e,t),o(e,Qa,t),o(e,Re,t),o(e,Ga,t),o(e,Le,t),o(e,Sa,t),h(Ze,e,t),o(e,Xa,t),o(e,We,t),o(e,Va,t),o(e,He,t),o(e,Ya,t),h(ze,e,t),o(e,Ka,t),o(e,Qe,t),o(e,eo,t),o(e,Ge,t),o(e,to,t),h(Se,e,t),o(e,ao,t),h(Xe,e,t),o(e,oo,t),o(e,p,t),h(Ve,p,null),i(p,yo),i(p,ut),i(p,bo),i(p,$),h(Ye,$,null),i($,vo),i($,gt),i(p,wo),i(p,P),h(Ke,P,null),i(P,Jo),i(P,_t),i(p,Uo),i(p,w),h(et,w,null),i(w,Co),i(w,Mt),i(w,jo),i(w,Tt),i(p,Io),i(p,D),h(tt,D,null),i(D,xo),i(D,yt),i(p,Oo),i(p,k),h(at,k,null),i(k,$o),i(k,bt),i(p,Po),i(p,J),h(ot,J,null),i(J,Do),i(J,vt),i(J,ko),i(J,wt),i(p,Ao),i(p,A),h(nt,A,null),i(A,No),i(A,Jt),i(p,qo),i(p,N),h(lt,N,null),i(N,Bo),i(N,Ut),i(p,Fo),i(p,q),h(rt,q,null),i(q,Eo),i(q,Ct),i(p,Ro),i(p,U),h(st,U,null),i(U,Lo),i(U,jt),i(U,Zo),i(U,It),i(p,Wo),i(p,C),h(it,C,null),i(C,Ho),i(C,xt),i(C,zo),i(C,Ot),i(p,Qo),i(p,B),h(dt,B,null),i(B,Go),i(B,$t),i(p,So),i(p,F),h(pt,F,null),i(F,Xo),i(F,Pt),i(p,Vo),i(p,v),h(ct,v,null),i(v,Yo),i(v,Dt),i(v,Ko),i(v,kt),i(v,en),i(v,At),o(e,no,t),h(mt,e,t),o(e,lo,t),o(e,I,t),h(ht,I,null),i(I,tn),i(I,Nt),o(e,ro,t),h(ft,e,t),o(e,so,t),o(e,Zt,t),io=!0},p:bl,i(e){io||(f(R.$$.fragment,e),f(W.$$.fragment,e),f(X.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(re.$$.fragment,e),f(ie.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(Ie.$$.fragment,e),f($e.$$.fragment,e),f(ke.$$.fragment,e),f(Be.$$.fragment,e),f(Ee.$$.fragment,e),f(Ze.$$.fragment,e),f(ze.$$.fragment,e),f(Se.$$.fragment,e),f(Xe.$$.fragment,e),f(Ve.$$.fragment,e),f(Ye.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(lt.$$.fragment,e),f(rt.$$.fragment,e),f(st.$$.fragment,e),f(it.$$.fragment,e),f(dt.$$.fragment,e),f(pt.$$.fragment,e),f(ct.$$.fragment,e),f(mt.$$.fragment,e),f(ht.$$.fragment,e),f(ft.$$.fragment,e),io=!0)},o(e){u(R.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(fe.$$.fragment,e),u(Ie.$$.fragment,e),u($e.$$.fragment,e),u(ke.$$.fragment,e),u(Be.$$.fragment,e),u(Ee.$$.fragment,e),u(Ze.$$.fragment,e),u(ze.$$.fragment,e),u(Se.$$.fragment,e),u(Xe.$$.fragment,e),u(Ve.$$.fragment,e),u(Ye.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(lt.$$.fragment,e),u(rt.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),u(ct.$$.fragment,e),u(mt.$$.fragment,e),u(ht.$$.fragment,e),u(ft.$$.fragment,e),io=!1},d(e){e&&(a(Wt),a(Lt),a(Ht),a(zt),a(L),a(Qt),a(Z),a(Gt),a(St),a(H),a(Xt),a(z),a(Vt),a(Q),a(Yt),a(G),a(Kt),a(x),a(ea),a(S),a(ta),a(aa),a(V),a(oa),a(O),a(na),a(Y),a(la),a(K),a(ra),a(ee),a(sa),a(ia),a(ae),a(da),a(oe),a(pa),a(ne),a(ca),a(ma),a(ha),a(se),a(fa),a(ua),a(de),a(ga),a(_a),a(ce),a(Ma),a(Ta),a(he),a(ya),a(ba),a(ue),a(va),a(ge),a(wa),a(_e),a(Ja),a(Me),a(Ua),a(Te),a(Ca),a(ye),a(ja),a(be),a(Ia),a(ve),a(xa),a(we),a(Oa),a(Je),a($a),a(Ue),a(Pa),a(Ce),a(Da),a(je),a(ka),a(Aa),a(xe),a(Na),a(Oe),a(qa),a(Ba),a(Pe),a(Fa),a(De),a(Ea),a(Ra),a(Ae),a(La),a(Ne),a(Za),a(qe),a(Wa),a(Ha),a(Fe),a(za),a(Qa),a(Re),a(Ga),a(Le),a(Sa),a(Xa),a(We),a(Va),a(He),a(Ya),a(Ka),a(Qe),a(eo),a(Ge),a(to),a(ao),a(oo),a(p),a(no),a(lo),a(I),a(ro),a(so),a(Zt)),a(j),g(R,e),g(W,e),g(X,e),g(te,e),g(le,e),g(re,e),g(ie,e),g(pe,e),g(me,e),g(fe,e),g(Ie,e),g($e,e),g(ke,e),g(Be,e),g(Ee,e),g(Ze,e),g(ze,e),g(Se,e),g(Xe,e),g(Ve),g(Ye),g(Ke),g(et),g(tt),g(at),g(ot),g(nt),g(lt),g(rt),g(st),g(it),g(dt),g(pt),g(ct),g(mt,e),g(ht),g(ft,e)}}}const xl='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"How DPO works","local":"how-dpo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DPOConfig","local":"trl.DPOConfig","sections":[],"depth":2}],"depth":1}';function Ol(an){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nl extends wl{constructor(j){super(),Jl(this,j,Ol,Il,Tl,{})}}export{Nl as component};
