import{s as ue,n as fe,o as me}from"../chunks/scheduler.7bc62968.js";import{S as ce,i as ge,g as a,s as n,r as p,A as we,h as o,f as l,c as s,j as he,u as h,x as r,k as tt,y as de,a as i,v as u,d as f,t as m,w as c}from"../chunks/index.66556066.js";import{H as b,g as ye}from"../chunks/Heading.8f17e89c.js";import{C as K}from"../chunks/CodeBlock.a759539a.js";function $e(zt){let g,it,et,nt,M,st,v,Nt="These next sections highlight features and additional information that you may find useful to make the most out of the Git repositories on the Hugging Face Hub.",at,T,ot,j,At='Hugging Face supports accessing repos with Python via the <a href="https://huggingface.co/docs/huggingface_hub/index" rel="nofollow"><code>huggingface_hub</code> library</a>. The operations that we’ve explored, such as downloading repositories and uploading files, are available through the library, as well as other useful functions!',rt,k,Rt="If you prefer to use git directly, please read the sections below.",pt,H,ht,x,Vt='A good place to visit if you want to continue learning about Git is <a href="https://learngitbranching.js.org/" rel="nofollow">this Git tutorial</a>. For even more background on Git, you can take a look at <a href="https://github.com/git-guides" rel="nofollow">GitHub’s Git Guides</a>.',ut,L,ft,C,Qt='To effectively use Git repos collaboratively and to work on features without releasing premature code you can use <strong>branches</strong>. Branches allow you to separate your “work in progress” code from your “production-ready” code, with the additional benefit of letting multiple people work on a project without frequently conflicting with each others’ contributions. You can use branches to isolate experiments in their own branch, and even <a href="https://ericmjl.github.io/essays-on-data-science/workflow/gitflow/" rel="nofollow">adopt team-wide practices for managing branches</a>.',mt,G,Xt='To learn about Git branching, you can try out the <a href="https://learngitbranching.js.org/" rel="nofollow">Learn Git Branching interactive tutorial</a>.',ct,_,gt,Z,qt='Git allows you to <em>tag</em> commits so that you can easily note milestones in your project. As such, you can use tags to mark commits in your Hub repos! To learn about using tags, you can visit <a href="https://devconnected.com/how-to-create-git-tags/" rel="nofollow">this DevConnected post</a>.',wt,W,Dt='Beyond making it easy to identify important commits in your repo’s history, using Git tags also allows you to do A/B testing, <a href="https://www.techiedelight.com/clone-specific-tag-with-git/" rel="nofollow">clone a repository at a specific tag</a>, and more! The <code>huggingface_hub</code> library also supports working with tags, such as <a href="https://huggingface.co/docs/huggingface_hub/main/en/how-to-downstream#hfhuburl" rel="nofollow">downloading files from a specific tagged commit</a>.',dt,J,yt,I,Et="If you’d like to copy a repository, depending on whether you want to preserve the Git history there are two options.",$t,U,bt,F,Ot='In many scenarios, if you want your own copy of a particular codebase you might not be concerned about the previous Git history. In this case, you can quickly duplicate a repo with the handy <a href="https://huggingface.co/spaces/huggingface-projects/repo_duplicator" rel="nofollow">Repo Duplicator</a>! You’ll have to create a User Access Token, which you can read more about in the <a href="./security-tokens">security documentation</a>.',Mt,B,vt,P,Kt="A duplicate of a repository with the commit history preserved is called a <em>fork</em>. You may choose to fork one of your own repos, but it also common to fork other people’s projects if you would like to tinker with them.",Tt,Y,te='<strong>Note that you will need to <a href="https://git-lfs.github.com/" rel="nofollow">install Git LFS</a> and the <a href="https://huggingface.co/docs/huggingface_hub/index" rel="nofollow"><code>huggingface_hub</code> CLI</a> to follow this process</strong>. When you want to fork or <a href="https://git-scm.com/docs/git-rebase" rel="nofollow">rebase</a> a repository with LFS files you cannot use the usual Git approach that you might be familiar with since you need to be careful to not break the LFS pointers. Forking can take time depending on your bandwidth because you will have to fetch and re-upload all the LFS files in your fork.',jt,S,ee="For example, say you have an upstream repository, <strong>upstream</strong>, and you just created your own repository on the Hub which is <strong>myfork</strong> in this example.",kt,z,le='<li><p>Create a destination repository (e.g. <strong>myfork</strong>) in <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a></p></li> <li><p>Clone your fork repository:</p></li>',Ht,N,xt,w,ie="<li>Fetch non-LFS files:</li>",Lt,A,Ct,d,ne="<li>Fetch large files. This can take some time depending on your download bandwidth:</li>",Gt,R,_t,V,se="4.a. If you want to completely override the fork history (which should only have an initial commit), run:",Zt,Q,Wt,X,ae="4.b. If you want to rebase instead of overriding, run the following command and resolve any conflicts:",Jt,q,It,y,oe="<li>Prepare your LFS files to push:</li>",Ut,D,Ft,$,re="<li>And finally push:</li>",Bt,E,Pt,O,pe="Now you have your own fork or rebased repo in the Hub!",Yt,lt,St;return M=new b({props:{title:"Next Steps",local:"next-steps",headingTag:"h1"}}),T=new b({props:{title:"How to programmatically manage repositories",local:"how-to-programmatically-manage-repositories",headingTag:"h2"}}),H=new b({props:{title:"Learning more about Git",local:"learning-more-about-git",headingTag:"h2"}}),L=new b({props:{title:"How to use branches",local:"how-to-use-branches",headingTag:"h2"}}),_=new b({props:{title:"Using tags",local:"using-tags",headingTag:"h2"}}),J=new b({props:{title:"How to duplicate or fork a repo (including LFS pointers)",local:"how-to-duplicate-or-fork-a-repo-including-lfs-pointers",headingTag:"h2"}}),U=new b({props:{title:"Duplicating without Git history",local:"duplicating-without-git-history",headingTag:"h3"}}),B=new b({props:{title:"Duplicating with the Git history (Fork)",local:"duplicating-with-the-git-history-fork",headingTag:"h3"}}),N=new K({props:{code:"Z2l0JTIwY2xvbmUlMjBnaXQlNDBoZi5jbyUzQW1lJTJGbXlmb3Jr",highlighted:'git <span class="hljs-keyword">clone</span> <span class="hljs-title">git</span>@hf.co:me/myfork',wrap:!1}}),A=new K({props:{code:"Y2QlMjBteWZvcmslMEFnaXQlMjBsZnMlMjBpbnN0YWxsJTIwLS1za2lwLXNtdWRnZSUyMC0tbG9jYWwlMjAlMjMlMjBhZmZlY3RzJTIwb25seSUyMHRoaXMlMjBjbG9uZSUwQWdpdCUyMHJlbW90ZSUyMGFkZCUyMHVwc3RyZWFtJTIwZ2l0JTQwaGYuY28lM0FmcmllbmQlMkZ1cHN0cmVhbSUwQWdpdCUyMGZldGNoJTIwdXBzdHJlYW0=",highlighted:`<span class="hljs-built_in">cd</span> myfork
git lfs install --skip-smudge --<span class="hljs-built_in">local</span> <span class="hljs-comment"># affects only this clone</span>
git remote add upstream git@hf.co:friend/upstream
git fetch upstream`,wrap:!1}}),R=new K({props:{code:"Z2l0JTIwbGZzJTIwZmV0Y2glMjAtLWFsbCUyMHVwc3RyZWFtJTIwJTIzJTIwdGhpcyUyMGNhbiUyMHRha2UlMjB0aW1lJTIwZGVwZW5kaW5nJTIwb24lMjB5b3VyJTIwZG93bmxvYWQlMjBiYW5kd2lkdGg=",highlighted:'<span class="hljs-string">git</span> <span class="hljs-string">lfs</span> <span class="hljs-string">fetch</span> <span class="hljs-built_in">--all</span> <span class="hljs-string">upstream</span> <span class="hljs-comment"># this can take time depending on your download bandwidth</span>',wrap:!1}}),Q=new K({props:{code:"Z2l0JTIwcmVzZXQlMjAtLWhhcmQlMjB1cHN0cmVhbSUyRm1haW4=",highlighted:'git reset <span class="hljs-attr">--hard</span> upstream/<span class="hljs-selector-tag">main</span>',wrap:!1}}),q=new K({props:{code:"Z2l0JTIwcmViYXNlJTIwdXBzdHJlYW0lMkZtYWlu",highlighted:"git rebase upstream/main",wrap:!1}}),D=new K({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUyMC0tZm9yY2UlMjAtLWxvY2FsJTIwJTIzJTIwdGhpcyUyMHJlaW5zdGFsbHMlMjB0aGUlMjBMRlMlMjBob29rcyUwQWh1Z2dpbmdmYWNlLWNsaSUyMGxmcy1lbmFibGUtbGFyZ2VmaWxlcyUyMC4lMjAlMjMlMjBuZWVkZWQlMjBpZiUyMHNvbWUlMjBmaWxlcyUyMGFyZSUyMGJpZ2dlciUyMHRoYW4lMjA1R0I=",highlighted:`<span class="hljs-string">git</span> <span class="hljs-string">lfs</span> <span class="hljs-string">install</span> <span class="hljs-built_in">--force</span> <span class="hljs-built_in">--local</span> <span class="hljs-comment"># this reinstalls the LFS hooks</span>
<span class="hljs-string">huggingface-cli</span> <span class="hljs-string">lfs-enable-largefiles</span> . <span class="hljs-comment"># needed if some files are bigger than 5GB</span>`,wrap:!1}}),E=new K({props:{code:"Z2l0JTIwcHVzaCUyMC0tZm9yY2UlMjBvcmlnaW4lMjBtYWluJTIwJTIzJTIwdGhpcyUyMGNhbiUyMHRha2UlMjB0aW1lJTIwZGVwZW5kaW5nJTIwb24lMjB5b3VyJTIwdXBsb2FkJTIwYmFuZHdpZHRo",highlighted:'git <span class="hljs-keyword">push</span> --<span class="hljs-literal">force</span> origin main <span class="hljs-comment"># this can take time depending on your upload bandwidth</span>',wrap:!1}}),{c(){g=a("meta"),it=n(),et=a("p"),nt=n(),p(M.$$.fragment),st=n(),v=a("p"),v.textContent=Nt,at=n(),p(T.$$.fragment),ot=n(),j=a("p"),j.innerHTML=At,rt=n(),k=a("p"),k.textContent=Rt,pt=n(),p(H.$$.fragment),ht=n(),x=a("p"),x.innerHTML=Vt,ut=n(),p(L.$$.fragment),ft=n(),C=a("p"),C.innerHTML=Qt,mt=n(),G=a("p"),G.innerHTML=Xt,ct=n(),p(_.$$.fragment),gt=n(),Z=a("p"),Z.innerHTML=qt,wt=n(),W=a("p"),W.innerHTML=Dt,dt=n(),p(J.$$.fragment),yt=n(),I=a("p"),I.textContent=Et,$t=n(),p(U.$$.fragment),bt=n(),F=a("p"),F.innerHTML=Ot,Mt=n(),p(B.$$.fragment),vt=n(),P=a("p"),P.innerHTML=Kt,Tt=n(),Y=a("p"),Y.innerHTML=te,jt=n(),S=a("p"),S.innerHTML=ee,kt=n(),z=a("ol"),z.innerHTML=le,Ht=n(),p(N.$$.fragment),xt=n(),w=a("ol"),w.innerHTML=ie,Lt=n(),p(A.$$.fragment),Ct=n(),d=a("ol"),d.innerHTML=ne,Gt=n(),p(R.$$.fragment),_t=n(),V=a("p"),V.textContent=se,Zt=n(),p(Q.$$.fragment),Wt=n(),X=a("p"),X.textContent=ae,Jt=n(),p(q.$$.fragment),It=n(),y=a("ol"),y.innerHTML=oe,Ut=n(),p(D.$$.fragment),Ft=n(),$=a("ol"),$.innerHTML=re,Bt=n(),p(E.$$.fragment),Pt=n(),O=a("p"),O.textContent=pe,Yt=n(),lt=a("p"),this.h()},l(t){const e=we("svelte-u9bgzb",document.head);g=o(e,"META",{name:!0,content:!0}),e.forEach(l),it=s(t),et=o(t,"P",{}),he(et).forEach(l),nt=s(t),h(M.$$.fragment,t),st=s(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-btdqel"&&(v.textContent=Nt),at=s(t),h(T.$$.fragment,t),ot=s(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1jazqdv"&&(j.innerHTML=At),rt=s(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-qsyw3y"&&(k.textContent=Rt),pt=s(t),h(H.$$.fragment,t),ht=s(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-164omu7"&&(x.innerHTML=Vt),ut=s(t),h(L.$$.fragment,t),ft=s(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-msdaia"&&(C.innerHTML=Qt),mt=s(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-vufusn"&&(G.innerHTML=Xt),ct=s(t),h(_.$$.fragment,t),gt=s(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-23fdx"&&(Z.innerHTML=qt),wt=s(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-9rjmgo"&&(W.innerHTML=Dt),dt=s(t),h(J.$$.fragment,t),yt=s(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-o7wddi"&&(I.textContent=Et),$t=s(t),h(U.$$.fragment,t),bt=s(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-prc7et"&&(F.innerHTML=Ot),Mt=s(t),h(B.$$.fragment,t),vt=s(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-16x2jq4"&&(P.innerHTML=Kt),Tt=s(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1rdylac"&&(Y.innerHTML=te),jt=s(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-g5hdh6"&&(S.innerHTML=ee),kt=s(t),z=o(t,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-1osxpc3"&&(z.innerHTML=le),Ht=s(t),h(N.$$.fragment,t),xt=s(t),w=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(w)!=="svelte-1g3lxt"&&(w.innerHTML=ie),Lt=s(t),h(A.$$.fragment,t),Ct=s(t),d=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(d)!=="svelte-17yi54j"&&(d.innerHTML=ne),Gt=s(t),h(R.$$.fragment,t),_t=s(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1h5q4od"&&(V.textContent=se),Zt=s(t),h(Q.$$.fragment,t),Wt=s(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-y11elx"&&(X.textContent=ae),Jt=s(t),h(q.$$.fragment,t),It=s(t),y=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-17b7oso"&&(y.innerHTML=oe),Ut=s(t),h(D.$$.fragment,t),Ft=s(t),$=o(t,"OL",{start:!0,"data-svelte-h":!0}),r($)!=="svelte-t1bai4"&&($.innerHTML=re),Bt=s(t),h(E.$$.fragment,t),Pt=s(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-60fv4p"&&(O.textContent=pe),Yt=s(t),lt=o(t,"P",{}),he(lt).forEach(l),this.h()},h(){tt(g,"name","hf:doc:metadata"),tt(g,"content",be),tt(w,"start","3"),tt(d,"start","4"),tt(y,"start","5"),tt($,"start","6")},m(t,e){de(document.head,g),i(t,it,e),i(t,et,e),i(t,nt,e),u(M,t,e),i(t,st,e),i(t,v,e),i(t,at,e),u(T,t,e),i(t,ot,e),i(t,j,e),i(t,rt,e),i(t,k,e),i(t,pt,e),u(H,t,e),i(t,ht,e),i(t,x,e),i(t,ut,e),u(L,t,e),i(t,ft,e),i(t,C,e),i(t,mt,e),i(t,G,e),i(t,ct,e),u(_,t,e),i(t,gt,e),i(t,Z,e),i(t,wt,e),i(t,W,e),i(t,dt,e),u(J,t,e),i(t,yt,e),i(t,I,e),i(t,$t,e),u(U,t,e),i(t,bt,e),i(t,F,e),i(t,Mt,e),u(B,t,e),i(t,vt,e),i(t,P,e),i(t,Tt,e),i(t,Y,e),i(t,jt,e),i(t,S,e),i(t,kt,e),i(t,z,e),i(t,Ht,e),u(N,t,e),i(t,xt,e),i(t,w,e),i(t,Lt,e),u(A,t,e),i(t,Ct,e),i(t,d,e),i(t,Gt,e),u(R,t,e),i(t,_t,e),i(t,V,e),i(t,Zt,e),u(Q,t,e),i(t,Wt,e),i(t,X,e),i(t,Jt,e),u(q,t,e),i(t,It,e),i(t,y,e),i(t,Ut,e),u(D,t,e),i(t,Ft,e),i(t,$,e),i(t,Bt,e),u(E,t,e),i(t,Pt,e),i(t,O,e),i(t,Yt,e),i(t,lt,e),St=!0},p:fe,i(t){St||(f(M.$$.fragment,t),f(T.$$.fragment,t),f(H.$$.fragment,t),f(L.$$.fragment,t),f(_.$$.fragment,t),f(J.$$.fragment,t),f(U.$$.fragment,t),f(B.$$.fragment,t),f(N.$$.fragment,t),f(A.$$.fragment,t),f(R.$$.fragment,t),f(Q.$$.fragment,t),f(q.$$.fragment,t),f(D.$$.fragment,t),f(E.$$.fragment,t),St=!0)},o(t){m(M.$$.fragment,t),m(T.$$.fragment,t),m(H.$$.fragment,t),m(L.$$.fragment,t),m(_.$$.fragment,t),m(J.$$.fragment,t),m(U.$$.fragment,t),m(B.$$.fragment,t),m(N.$$.fragment,t),m(A.$$.fragment,t),m(R.$$.fragment,t),m(Q.$$.fragment,t),m(q.$$.fragment,t),m(D.$$.fragment,t),m(E.$$.fragment,t),St=!1},d(t){t&&(l(it),l(et),l(nt),l(st),l(v),l(at),l(ot),l(j),l(rt),l(k),l(pt),l(ht),l(x),l(ut),l(ft),l(C),l(mt),l(G),l(ct),l(gt),l(Z),l(wt),l(W),l(dt),l(yt),l(I),l($t),l(bt),l(F),l(Mt),l(vt),l(P),l(Tt),l(Y),l(jt),l(S),l(kt),l(z),l(Ht),l(xt),l(w),l(Lt),l(Ct),l(d),l(Gt),l(_t),l(V),l(Zt),l(Wt),l(X),l(Jt),l(It),l(y),l(Ut),l(Ft),l($),l(Bt),l(Pt),l(O),l(Yt),l(lt)),l(g),c(M,t),c(T,t),c(H,t),c(L,t),c(_,t),c(J,t),c(U,t),c(B,t),c(N,t),c(A,t),c(R,t),c(Q,t),c(q,t),c(D,t),c(E,t)}}}const be='{"title":"Next Steps","local":"next-steps","sections":[{"title":"How to programmatically manage repositories","local":"how-to-programmatically-manage-repositories","sections":[],"depth":2},{"title":"Learning more about Git","local":"learning-more-about-git","sections":[],"depth":2},{"title":"How to use branches","local":"how-to-use-branches","sections":[],"depth":2},{"title":"Using tags","local":"using-tags","sections":[],"depth":2},{"title":"How to duplicate or fork a repo (including LFS pointers)","local":"how-to-duplicate-or-fork-a-repo-including-lfs-pointers","sections":[{"title":"Duplicating without Git history","local":"duplicating-without-git-history","sections":[],"depth":3},{"title":"Duplicating with the Git history (Fork)","local":"duplicating-with-the-git-history-fork","sections":[],"depth":3}],"depth":2}],"depth":1}';function Me(zt){return me(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ye}),[]}class He extends ce{constructor(g){super(),ge(this,g,Me,$e,ue,{})}}export{He as component};
