import{s as Jt,o as ht,n as Ys}from"../chunks/scheduler.37c15a92.js";import{S as ut,i as Ut,g as j,s as a,r as M,A as wt,h as J,f as n,c as e,j as ct,u as i,x as u,k as jt,y as Tt,a as t,v as y,d as r,t as o,w as c}from"../chunks/index.2bf4358c.js";import{T as Rs}from"../chunks/Tip.363c041f.js";import{Y as gt}from"../chunks/Youtube.1e50a667.js";import{C as U}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as mt}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as dn}from"../chunks/Heading.8ada512a.js";import{E as xt}from"../chunks/EditOnGithub.9958bcdc.js";function Ct(g){let p,w="💡 This section covers BPE in depth, going as far as showing a full implementation. You can skip to the end if you just want a general overview of the tokenization algorithm.";return{c(){p=j("p"),p.textContent=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-ng6y15"&&(p.textContent=w)},m(h,T){t(h,p,T)},p:Ys,d(h){h&&n(p)}}}function dt(g){let p,w="The GPT-2 and RoBERTa tokenizers (which are pretty similar) have a clever way to deal with this: they don’t look at words as being written with Unicode characters, but with bytes. This way the base vocabulary has a small size (256), but every character you can think of will still be included and not end up being converted to the unknown token. This trick is called <em>byte-level BPE</em>.";return{c(){p=j("p"),p.innerHTML=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-98dqph"&&(p.innerHTML=w)},m(h,T){t(h,p,T)},p:Ys,d(h){h&&n(p)}}}function ft(g){let p,w="✏️ <strong>Now your turn!</strong> What do you think the next merge rule will be?";return{c(){p=j("p"),p.innerHTML=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-oqvl3w"&&(p.innerHTML=w)},m(h,T){t(h,p,T)},p:Ys,d(h){h&&n(p)}}}function It(g){let p,w="✏️ <strong>Now your turn!</strong> How do you think  the word <code>&quot;unhug&quot;</code> will be tokenized?";return{c(){p=j("p"),p.innerHTML=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-amahqs"&&(p.innerHTML=w)},m(h,T){t(h,p,T)},p:Ys,d(h){h&&n(p)}}}function bt(g){let p,w="💡 Using <code>train_new_from_iterator()</code> on the same corpus won’t result in the exact same vocabulary. This is because when there is a choice of the most frequent pair, we selected the first one encountered, while the 🤗 Tokenizers library selects the first one based on its inner IDs.";return{c(){p=j("p"),p.innerHTML=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-lvgbtz"&&(p.innerHTML=w)},m(h,T){t(h,p,T)},p:Ys,d(h){h&&n(p)}}}function kt(g){let p,w="⚠️ Our implementation will throw an error if there is an unknown character since we didn’t do anything to handle them. GPT-2 doesn’t actually have an unknown token (it’s impossible to get an unknown character when using byte-level BPE), but this could happen here because we did not include all the possible bytes in the initial vocabulary. This aspect of BPE is beyond the scope of this section, so we’ve left the details out.";return{c(){p=j("p"),p.textContent=w},l(h){p=J(h,"P",{"data-svelte-h":!0}),u(p)!=="svelte-165040c"&&(p.textContent=w)},m(h,T){t(h,p,T)},p:Ys,d(h){h&&n(p)}}}function $t(g){let p,w,h,T,b,Ks,k,Fs,$,fn="Byte-Pair Encoding (BPE) was initially developed as an algorithm to compress texts, and then used by OpenAI for tokenization when pretraining the GPT model. It’s used by a lot of Transformer models, including GPT, GPT-2, RoBERTa, BART, and DeBERTa.",Ls,q,Os,m,sl,Q,ll,A,In="BPE training starts by computing the unique set of words used in the corpus (after the normalization and pre-tokenization steps are completed), then building the vocabulary by taking all the symbols used to write those words. As a very simple example, let’s say our corpus uses these five words:",nl,B,tl,z,bn="The base vocabulary will then be <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>. For real-world cases, that base vocabulary will contain all the ASCII characters, at the very least, and probably some Unicode characters as well. If an example you are tokenizing uses a character that is not in the training corpus, that character will be converted to the unknown token. That’s one reason why lots of NLP models are very bad at analyzing content with emojis, for instance.",al,x,el,V,kn="After getting this base vocabulary, we add new tokens until the desired vocabulary size is reached by learning <em>merges</em>, which are rules to merge two elements of the existing vocabulary together into a new one. So, at the beginning these merges will create tokens with two characters, and then, as training progresses, longer subwords.",pl,v,$n="At any step during the tokenizer training, the BPE algorithm will search for the most frequent pair of existing tokens (by “pair,” here we mean two consecutive tokens in a word). That most frequent pair is the one that will be merged, and we rinse and repeat for the next step.",Ml,E,qn="Going back to our previous example, let’s assume the words had the following frequencies:",il,Z,yl,S,Qn="meaning <code>&quot;hug&quot;</code> was present 10 times in the corpus, <code>&quot;pug&quot;</code> 5 times, <code>&quot;pun&quot;</code> 12 times, <code>&quot;bun&quot;</code> 4 times, and <code>&quot;hugs&quot;</code> 5 times. We start the training by splitting each word into characters (the ones that form our initial vocabulary) so we can see each word as a list of tokens:",rl,G,ol,N,An="Then we look at pairs. The pair <code>(&quot;h&quot;, &quot;u&quot;)</code> is present in the words <code>&quot;hug&quot;</code> and <code>&quot;hugs&quot;</code>, so 15 times total in the corpus. It’s not the most frequent pair, though: that honor belongs to <code>(&quot;u&quot;, &quot;g&quot;)</code>, which is present in <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, and <code>&quot;hugs&quot;</code>, for a grand total of 20 times in the vocabulary.",cl,_,Bn="Thus, the first merge rule learned by the tokenizer is <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code>, which means that <code>&quot;ug&quot;</code> will be added to the vocabulary, and the pair should be merged in all the words of the corpus. At the end of this stage, the vocabulary and corpus look like this:",jl,H,Jl,X,zn="Now we have some pairs that result in a token longer than two characters: the pair <code>(&quot;h&quot;, &quot;ug&quot;)</code>, for instance (present 15 times in the corpus). The most frequent pair at this stage is <code>(&quot;u&quot;, &quot;n&quot;)</code>, however, present 16 times in the corpus, so the second merge rule learned is <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code>. Adding that to the vocabulary and merging all existing occurrences leads us to:",hl,D,ul,W,Vn="Now the most frequent pair is <code>(&quot;h&quot;, &quot;ug&quot;)</code>, so we learn the merge rule <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code>, which gives us our first three-letter token. After the merge, the corpus looks like this:",Ul,R,wl,Y,vn="And we continue like this until we reach the desired vocabulary size.",Tl,C,gl,P,ml,K,En="Tokenization follows the training process closely, in the sense that new inputs are tokenized by applying the following steps:",xl,F,Zn="<li>Normalization</li> <li>Pre-tokenization</li> <li>Splitting the words into individual characters</li> <li>Applying the merge rules learned in order on those splits</li>",Cl,L,Sn="Let’s take the example we used during training, with the three merge rules learned:",dl,O,fl,ss,Gn="The word <code>&quot;bug&quot;</code> will be tokenized as <code>[&quot;b&quot;, &quot;ug&quot;]</code>. <code>&quot;mug&quot;</code>, however, will be tokenized as <code>[&quot;[UNK]&quot;, &quot;ug&quot;]</code> since the letter <code>&quot;m&quot;</code> was not in the base vocabulary. Likewise, the word <code>&quot;thug&quot;</code> will be tokenized as <code>[&quot;[UNK]&quot;, &quot;hug&quot;]</code>: the letter <code>&quot;t&quot;</code> is not in the base vocabulary, and applying the merge rules results first in <code>&quot;u&quot;</code> and <code>&quot;g&quot;</code> being merged and then <code>&quot;h&quot;</code> and <code>&quot;ug&quot;</code> being merged.",Il,d,bl,ls,kl,ns,Nn="Now let’s take a look at an implementation of the BPE algorithm. This won’t be an optimized version you can actually use on a big corpus; we just want to show you the code so you can understand the algorithm a little bit better.",$l,ts,_n="First we need a corpus, so let’s create a simple one with a few sentences:",ql,as,Ql,es,Hn="Next, we need to pre-tokenize that corpus into words. Since we are replicating a BPE tokenizer (like GPT-2), we will use the <code>gpt2</code> tokenizer for the pre-tokenization:",Al,ps,Bl,Ms,Xn="Then we compute the frequencies of each word in the corpus as we do the pre-tokenization:",zl,is,Vl,ys,vl,rs,Dn="The next step is to compute the base vocabulary, formed by all the characters used in the corpus:",El,os,Zl,cs,Sl,js,Wn="We also add the special tokens used by the model at the beginning of that vocabulary. In the case of GPT-2, the only special token is <code>&quot;&lt;|endoftext|&gt;&quot;</code>:",Gl,Js,Nl,hs,Rn="We now need to split each word into individual characters, to be able to start training:",_l,us,Hl,Us,Yn="Now that we are ready for training, let’s write a function that computes the frequency of each pair. We’ll need to use this at each step of the training:",Xl,ws,Dl,Ts,Pn="Let’s have a look at a part of this dictionary after the initial splits:",Wl,gs,Rl,ms,Yl,xs,Kn="Now, finding the most frequent pair only takes a quick loop:",Pl,Cs,Kl,ds,Fl,fs,Fn="So the first merge to learn is <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code>, and we add <code>&#39;Ġt&#39;</code> to the vocabulary:",Ll,Is,Ol,bs,Ln="To continue, we need to apply that merge in our <code>splits</code> dictionary. Let’s write another function for this:",sn,ks,ln,$s,On="And we can have a look at the result of the first merge:",nn,qs,tn,Qs,an,As,st="Now we have everything we need to loop until we have learned all the merges we want. Let’s aim for a vocab size of 50:",en,Bs,pn,zs,lt="As a result, we’ve learned 19 merge rules (the initial vocabulary had a size of 31 — 30 characters in the alphabet, plus the special token):",Mn,Vs,yn,vs,rn,Es,nt="And the vocabulary is composed of the special token, the initial alphabet, and all the results of the merges:",on,Zs,cn,Ss,jn,f,Jn,Gs,tt="To tokenize a new text, we pre-tokenize it, split it, then apply all the merge rules learned:",hn,Ns,un,_s,at="We can try this on any text composed of characters in the alphabet:",Un,Hs,wn,Xs,Tn,I,gn,Ds,et="That’s it for the BPE algorithm! Next, we’ll have a look at WordPiece.",mn,Ws,xn,Ps,Cn;return b=new dn({props:{title:"Byte-Pair Encoding tokenization",local:"byte-pair-encoding-tokenization",headingTag:"h1"}}),k=new mt({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"}]}}),q=new gt({props:{id:"HEikzVL-lZU"}}),m=new Rs({props:{$$slots:{default:[Ct]},$$scope:{ctx:g}}}),Q=new dn({props:{title:"Training algorithm",local:"training-algorithm",headingTag:"h2"}}),B=new U({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMg==",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span>',wrap:!1}}),x=new Rs({props:{$$slots:{default:[dt]},$$scope:{ctx:g}}}),Z=new U({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),G=new U({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),H=new U({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIydWclMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMnVnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjJ1JTIyJTIwJTIybiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyMCUyMnMlMjIlMkMlMjA1KQ==",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),D=new U({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),R=new U({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),C=new Rs({props:{$$slots:{default:[ft]},$$scope:{ctx:g}}}),P=new dn({props:{title:"Tokenization algorithm",local:"tokenization-algorithm",headingTag:"h2"}}),O=new U({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),d=new Rs({props:{$$slots:{default:[It]},$$scope:{ctx:g}}}),ls=new dn({props:{title:"Implementing BPE",local:"implementing-bpe",headingTag:"h2"}}),as=new U({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),ps=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),is=new U({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),ys=new U({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),os=new U({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),cs=new U({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),Js=new U({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),us=new U({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),ws=new U({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),gs=new U({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),ms=new U({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),Cs=new U({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),ds=new U({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),Is=new U({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),ks=new U({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),qs=new U({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),Qs=new U({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),Bs=new U({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),Vs=new U({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),vs=new U({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Zs=new U({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Ss=new U({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),f=new Rs({props:{$$slots:{default:[bt]},$$scope:{ctx:g}}}),Ns=new U({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Hs=new U({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Xs=new U({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),I=new Rs({props:{warning:!0,$$slots:{default:[kt]},$$scope:{ctx:g}}}),Ws=new xt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter6/5.mdx"}}),{c(){p=j("meta"),w=a(),h=j("p"),T=a(),M(b.$$.fragment),Ks=a(),M(k.$$.fragment),Fs=a(),$=j("p"),$.textContent=fn,Ls=a(),M(q.$$.fragment),Os=a(),M(m.$$.fragment),sl=a(),M(Q.$$.fragment),ll=a(),A=j("p"),A.textContent=In,nl=a(),M(B.$$.fragment),tl=a(),z=j("p"),z.innerHTML=bn,al=a(),M(x.$$.fragment),el=a(),V=j("p"),V.innerHTML=kn,pl=a(),v=j("p"),v.textContent=$n,Ml=a(),E=j("p"),E.textContent=qn,il=a(),M(Z.$$.fragment),yl=a(),S=j("p"),S.innerHTML=Qn,rl=a(),M(G.$$.fragment),ol=a(),N=j("p"),N.innerHTML=An,cl=a(),_=j("p"),_.innerHTML=Bn,jl=a(),M(H.$$.fragment),Jl=a(),X=j("p"),X.innerHTML=zn,hl=a(),M(D.$$.fragment),ul=a(),W=j("p"),W.innerHTML=Vn,Ul=a(),M(R.$$.fragment),wl=a(),Y=j("p"),Y.textContent=vn,Tl=a(),M(C.$$.fragment),gl=a(),M(P.$$.fragment),ml=a(),K=j("p"),K.textContent=En,xl=a(),F=j("ol"),F.innerHTML=Zn,Cl=a(),L=j("p"),L.textContent=Sn,dl=a(),M(O.$$.fragment),fl=a(),ss=j("p"),ss.innerHTML=Gn,Il=a(),M(d.$$.fragment),bl=a(),M(ls.$$.fragment),kl=a(),ns=j("p"),ns.textContent=Nn,$l=a(),ts=j("p"),ts.textContent=_n,ql=a(),M(as.$$.fragment),Ql=a(),es=j("p"),es.innerHTML=Hn,Al=a(),M(ps.$$.fragment),Bl=a(),Ms=j("p"),Ms.textContent=Xn,zl=a(),M(is.$$.fragment),Vl=a(),M(ys.$$.fragment),vl=a(),rs=j("p"),rs.textContent=Dn,El=a(),M(os.$$.fragment),Zl=a(),M(cs.$$.fragment),Sl=a(),js=j("p"),js.innerHTML=Wn,Gl=a(),M(Js.$$.fragment),Nl=a(),hs=j("p"),hs.textContent=Rn,_l=a(),M(us.$$.fragment),Hl=a(),Us=j("p"),Us.textContent=Yn,Xl=a(),M(ws.$$.fragment),Dl=a(),Ts=j("p"),Ts.textContent=Pn,Wl=a(),M(gs.$$.fragment),Rl=a(),M(ms.$$.fragment),Yl=a(),xs=j("p"),xs.textContent=Kn,Pl=a(),M(Cs.$$.fragment),Kl=a(),M(ds.$$.fragment),Fl=a(),fs=j("p"),fs.innerHTML=Fn,Ll=a(),M(Is.$$.fragment),Ol=a(),bs=j("p"),bs.innerHTML=Ln,sn=a(),M(ks.$$.fragment),ln=a(),$s=j("p"),$s.textContent=On,nn=a(),M(qs.$$.fragment),tn=a(),M(Qs.$$.fragment),an=a(),As=j("p"),As.textContent=st,en=a(),M(Bs.$$.fragment),pn=a(),zs=j("p"),zs.textContent=lt,Mn=a(),M(Vs.$$.fragment),yn=a(),M(vs.$$.fragment),rn=a(),Es=j("p"),Es.textContent=nt,on=a(),M(Zs.$$.fragment),cn=a(),M(Ss.$$.fragment),jn=a(),M(f.$$.fragment),Jn=a(),Gs=j("p"),Gs.textContent=tt,hn=a(),M(Ns.$$.fragment),un=a(),_s=j("p"),_s.textContent=at,Un=a(),M(Hs.$$.fragment),wn=a(),M(Xs.$$.fragment),Tn=a(),M(I.$$.fragment),gn=a(),Ds=j("p"),Ds.textContent=et,mn=a(),M(Ws.$$.fragment),xn=a(),Ps=j("p"),this.h()},l(s){const l=wt("svelte-u9bgzb",document.head);p=J(l,"META",{name:!0,content:!0}),l.forEach(n),w=e(s),h=J(s,"P",{}),ct(h).forEach(n),T=e(s),i(b.$$.fragment,s),Ks=e(s),i(k.$$.fragment,s),Fs=e(s),$=J(s,"P",{"data-svelte-h":!0}),u($)!=="svelte-1ys35ik"&&($.textContent=fn),Ls=e(s),i(q.$$.fragment,s),Os=e(s),i(m.$$.fragment,s),sl=e(s),i(Q.$$.fragment,s),ll=e(s),A=J(s,"P",{"data-svelte-h":!0}),u(A)!=="svelte-shk7i3"&&(A.textContent=In),nl=e(s),i(B.$$.fragment,s),tl=e(s),z=J(s,"P",{"data-svelte-h":!0}),u(z)!=="svelte-1ld47wc"&&(z.innerHTML=bn),al=e(s),i(x.$$.fragment,s),el=e(s),V=J(s,"P",{"data-svelte-h":!0}),u(V)!=="svelte-dxqp15"&&(V.innerHTML=kn),pl=e(s),v=J(s,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1jt9hdc"&&(v.textContent=$n),Ml=e(s),E=J(s,"P",{"data-svelte-h":!0}),u(E)!=="svelte-tn0v5v"&&(E.textContent=qn),il=e(s),i(Z.$$.fragment,s),yl=e(s),S=J(s,"P",{"data-svelte-h":!0}),u(S)!=="svelte-253fgn"&&(S.innerHTML=Qn),rl=e(s),i(G.$$.fragment,s),ol=e(s),N=J(s,"P",{"data-svelte-h":!0}),u(N)!=="svelte-tikeus"&&(N.innerHTML=An),cl=e(s),_=J(s,"P",{"data-svelte-h":!0}),u(_)!=="svelte-1ba7gki"&&(_.innerHTML=Bn),jl=e(s),i(H.$$.fragment,s),Jl=e(s),X=J(s,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1jrr3se"&&(X.innerHTML=zn),hl=e(s),i(D.$$.fragment,s),ul=e(s),W=J(s,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1r77sw4"&&(W.innerHTML=Vn),Ul=e(s),i(R.$$.fragment,s),wl=e(s),Y=J(s,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1vbc3ju"&&(Y.textContent=vn),Tl=e(s),i(C.$$.fragment,s),gl=e(s),i(P.$$.fragment,s),ml=e(s),K=J(s,"P",{"data-svelte-h":!0}),u(K)!=="svelte-16041kn"&&(K.textContent=En),xl=e(s),F=J(s,"OL",{"data-svelte-h":!0}),u(F)!=="svelte-hczz4s"&&(F.innerHTML=Zn),Cl=e(s),L=J(s,"P",{"data-svelte-h":!0}),u(L)!=="svelte-waistw"&&(L.textContent=Sn),dl=e(s),i(O.$$.fragment,s),fl=e(s),ss=J(s,"P",{"data-svelte-h":!0}),u(ss)!=="svelte-57ne5c"&&(ss.innerHTML=Gn),Il=e(s),i(d.$$.fragment,s),bl=e(s),i(ls.$$.fragment,s),kl=e(s),ns=J(s,"P",{"data-svelte-h":!0}),u(ns)!=="svelte-1vmiqby"&&(ns.textContent=Nn),$l=e(s),ts=J(s,"P",{"data-svelte-h":!0}),u(ts)!=="svelte-ihocys"&&(ts.textContent=_n),ql=e(s),i(as.$$.fragment,s),Ql=e(s),es=J(s,"P",{"data-svelte-h":!0}),u(es)!=="svelte-17swp54"&&(es.innerHTML=Hn),Al=e(s),i(ps.$$.fragment,s),Bl=e(s),Ms=J(s,"P",{"data-svelte-h":!0}),u(Ms)!=="svelte-1piuede"&&(Ms.textContent=Xn),zl=e(s),i(is.$$.fragment,s),Vl=e(s),i(ys.$$.fragment,s),vl=e(s),rs=J(s,"P",{"data-svelte-h":!0}),u(rs)!=="svelte-1n97usn"&&(rs.textContent=Dn),El=e(s),i(os.$$.fragment,s),Zl=e(s),i(cs.$$.fragment,s),Sl=e(s),js=J(s,"P",{"data-svelte-h":!0}),u(js)!=="svelte-bp8or4"&&(js.innerHTML=Wn),Gl=e(s),i(Js.$$.fragment,s),Nl=e(s),hs=J(s,"P",{"data-svelte-h":!0}),u(hs)!=="svelte-pe9yho"&&(hs.textContent=Rn),_l=e(s),i(us.$$.fragment,s),Hl=e(s),Us=J(s,"P",{"data-svelte-h":!0}),u(Us)!=="svelte-i39iqv"&&(Us.textContent=Yn),Xl=e(s),i(ws.$$.fragment,s),Dl=e(s),Ts=J(s,"P",{"data-svelte-h":!0}),u(Ts)!=="svelte-h8brnl"&&(Ts.textContent=Pn),Wl=e(s),i(gs.$$.fragment,s),Rl=e(s),i(ms.$$.fragment,s),Yl=e(s),xs=J(s,"P",{"data-svelte-h":!0}),u(xs)!=="svelte-19ljpex"&&(xs.textContent=Kn),Pl=e(s),i(Cs.$$.fragment,s),Kl=e(s),i(ds.$$.fragment,s),Fl=e(s),fs=J(s,"P",{"data-svelte-h":!0}),u(fs)!=="svelte-m36xi"&&(fs.innerHTML=Fn),Ll=e(s),i(Is.$$.fragment,s),Ol=e(s),bs=J(s,"P",{"data-svelte-h":!0}),u(bs)!=="svelte-1pmzgqr"&&(bs.innerHTML=Ln),sn=e(s),i(ks.$$.fragment,s),ln=e(s),$s=J(s,"P",{"data-svelte-h":!0}),u($s)!=="svelte-d7zdjw"&&($s.textContent=On),nn=e(s),i(qs.$$.fragment,s),tn=e(s),i(Qs.$$.fragment,s),an=e(s),As=J(s,"P",{"data-svelte-h":!0}),u(As)!=="svelte-1vwdf9c"&&(As.textContent=st),en=e(s),i(Bs.$$.fragment,s),pn=e(s),zs=J(s,"P",{"data-svelte-h":!0}),u(zs)!=="svelte-1r8l9ln"&&(zs.textContent=lt),Mn=e(s),i(Vs.$$.fragment,s),yn=e(s),i(vs.$$.fragment,s),rn=e(s),Es=J(s,"P",{"data-svelte-h":!0}),u(Es)!=="svelte-okpg4u"&&(Es.textContent=nt),on=e(s),i(Zs.$$.fragment,s),cn=e(s),i(Ss.$$.fragment,s),jn=e(s),i(f.$$.fragment,s),Jn=e(s),Gs=J(s,"P",{"data-svelte-h":!0}),u(Gs)!=="svelte-15zp2fc"&&(Gs.textContent=tt),hn=e(s),i(Ns.$$.fragment,s),un=e(s),_s=J(s,"P",{"data-svelte-h":!0}),u(_s)!=="svelte-dgrd5"&&(_s.textContent=at),Un=e(s),i(Hs.$$.fragment,s),wn=e(s),i(Xs.$$.fragment,s),Tn=e(s),i(I.$$.fragment,s),gn=e(s),Ds=J(s,"P",{"data-svelte-h":!0}),u(Ds)!=="svelte-b3ofc6"&&(Ds.textContent=et),mn=e(s),i(Ws.$$.fragment,s),xn=e(s),Ps=J(s,"P",{}),ct(Ps).forEach(n),this.h()},h(){jt(p,"name","hf:doc:metadata"),jt(p,"content",qt)},m(s,l){Tt(document.head,p),t(s,w,l),t(s,h,l),t(s,T,l),y(b,s,l),t(s,Ks,l),y(k,s,l),t(s,Fs,l),t(s,$,l),t(s,Ls,l),y(q,s,l),t(s,Os,l),y(m,s,l),t(s,sl,l),y(Q,s,l),t(s,ll,l),t(s,A,l),t(s,nl,l),y(B,s,l),t(s,tl,l),t(s,z,l),t(s,al,l),y(x,s,l),t(s,el,l),t(s,V,l),t(s,pl,l),t(s,v,l),t(s,Ml,l),t(s,E,l),t(s,il,l),y(Z,s,l),t(s,yl,l),t(s,S,l),t(s,rl,l),y(G,s,l),t(s,ol,l),t(s,N,l),t(s,cl,l),t(s,_,l),t(s,jl,l),y(H,s,l),t(s,Jl,l),t(s,X,l),t(s,hl,l),y(D,s,l),t(s,ul,l),t(s,W,l),t(s,Ul,l),y(R,s,l),t(s,wl,l),t(s,Y,l),t(s,Tl,l),y(C,s,l),t(s,gl,l),y(P,s,l),t(s,ml,l),t(s,K,l),t(s,xl,l),t(s,F,l),t(s,Cl,l),t(s,L,l),t(s,dl,l),y(O,s,l),t(s,fl,l),t(s,ss,l),t(s,Il,l),y(d,s,l),t(s,bl,l),y(ls,s,l),t(s,kl,l),t(s,ns,l),t(s,$l,l),t(s,ts,l),t(s,ql,l),y(as,s,l),t(s,Ql,l),t(s,es,l),t(s,Al,l),y(ps,s,l),t(s,Bl,l),t(s,Ms,l),t(s,zl,l),y(is,s,l),t(s,Vl,l),y(ys,s,l),t(s,vl,l),t(s,rs,l),t(s,El,l),y(os,s,l),t(s,Zl,l),y(cs,s,l),t(s,Sl,l),t(s,js,l),t(s,Gl,l),y(Js,s,l),t(s,Nl,l),t(s,hs,l),t(s,_l,l),y(us,s,l),t(s,Hl,l),t(s,Us,l),t(s,Xl,l),y(ws,s,l),t(s,Dl,l),t(s,Ts,l),t(s,Wl,l),y(gs,s,l),t(s,Rl,l),y(ms,s,l),t(s,Yl,l),t(s,xs,l),t(s,Pl,l),y(Cs,s,l),t(s,Kl,l),y(ds,s,l),t(s,Fl,l),t(s,fs,l),t(s,Ll,l),y(Is,s,l),t(s,Ol,l),t(s,bs,l),t(s,sn,l),y(ks,s,l),t(s,ln,l),t(s,$s,l),t(s,nn,l),y(qs,s,l),t(s,tn,l),y(Qs,s,l),t(s,an,l),t(s,As,l),t(s,en,l),y(Bs,s,l),t(s,pn,l),t(s,zs,l),t(s,Mn,l),y(Vs,s,l),t(s,yn,l),y(vs,s,l),t(s,rn,l),t(s,Es,l),t(s,on,l),y(Zs,s,l),t(s,cn,l),y(Ss,s,l),t(s,jn,l),y(f,s,l),t(s,Jn,l),t(s,Gs,l),t(s,hn,l),y(Ns,s,l),t(s,un,l),t(s,_s,l),t(s,Un,l),y(Hs,s,l),t(s,wn,l),y(Xs,s,l),t(s,Tn,l),y(I,s,l),t(s,gn,l),t(s,Ds,l),t(s,mn,l),y(Ws,s,l),t(s,xn,l),t(s,Ps,l),Cn=!0},p(s,[l]){const pt={};l&2&&(pt.$$scope={dirty:l,ctx:s}),m.$set(pt);const Mt={};l&2&&(Mt.$$scope={dirty:l,ctx:s}),x.$set(Mt);const it={};l&2&&(it.$$scope={dirty:l,ctx:s}),C.$set(it);const yt={};l&2&&(yt.$$scope={dirty:l,ctx:s}),d.$set(yt);const rt={};l&2&&(rt.$$scope={dirty:l,ctx:s}),f.$set(rt);const ot={};l&2&&(ot.$$scope={dirty:l,ctx:s}),I.$set(ot)},i(s){Cn||(r(b.$$.fragment,s),r(k.$$.fragment,s),r(q.$$.fragment,s),r(m.$$.fragment,s),r(Q.$$.fragment,s),r(B.$$.fragment,s),r(x.$$.fragment,s),r(Z.$$.fragment,s),r(G.$$.fragment,s),r(H.$$.fragment,s),r(D.$$.fragment,s),r(R.$$.fragment,s),r(C.$$.fragment,s),r(P.$$.fragment,s),r(O.$$.fragment,s),r(d.$$.fragment,s),r(ls.$$.fragment,s),r(as.$$.fragment,s),r(ps.$$.fragment,s),r(is.$$.fragment,s),r(ys.$$.fragment,s),r(os.$$.fragment,s),r(cs.$$.fragment,s),r(Js.$$.fragment,s),r(us.$$.fragment,s),r(ws.$$.fragment,s),r(gs.$$.fragment,s),r(ms.$$.fragment,s),r(Cs.$$.fragment,s),r(ds.$$.fragment,s),r(Is.$$.fragment,s),r(ks.$$.fragment,s),r(qs.$$.fragment,s),r(Qs.$$.fragment,s),r(Bs.$$.fragment,s),r(Vs.$$.fragment,s),r(vs.$$.fragment,s),r(Zs.$$.fragment,s),r(Ss.$$.fragment,s),r(f.$$.fragment,s),r(Ns.$$.fragment,s),r(Hs.$$.fragment,s),r(Xs.$$.fragment,s),r(I.$$.fragment,s),r(Ws.$$.fragment,s),Cn=!0)},o(s){o(b.$$.fragment,s),o(k.$$.fragment,s),o(q.$$.fragment,s),o(m.$$.fragment,s),o(Q.$$.fragment,s),o(B.$$.fragment,s),o(x.$$.fragment,s),o(Z.$$.fragment,s),o(G.$$.fragment,s),o(H.$$.fragment,s),o(D.$$.fragment,s),o(R.$$.fragment,s),o(C.$$.fragment,s),o(P.$$.fragment,s),o(O.$$.fragment,s),o(d.$$.fragment,s),o(ls.$$.fragment,s),o(as.$$.fragment,s),o(ps.$$.fragment,s),o(is.$$.fragment,s),o(ys.$$.fragment,s),o(os.$$.fragment,s),o(cs.$$.fragment,s),o(Js.$$.fragment,s),o(us.$$.fragment,s),o(ws.$$.fragment,s),o(gs.$$.fragment,s),o(ms.$$.fragment,s),o(Cs.$$.fragment,s),o(ds.$$.fragment,s),o(Is.$$.fragment,s),o(ks.$$.fragment,s),o(qs.$$.fragment,s),o(Qs.$$.fragment,s),o(Bs.$$.fragment,s),o(Vs.$$.fragment,s),o(vs.$$.fragment,s),o(Zs.$$.fragment,s),o(Ss.$$.fragment,s),o(f.$$.fragment,s),o(Ns.$$.fragment,s),o(Hs.$$.fragment,s),o(Xs.$$.fragment,s),o(I.$$.fragment,s),o(Ws.$$.fragment,s),Cn=!1},d(s){s&&(n(w),n(h),n(T),n(Ks),n(Fs),n($),n(Ls),n(Os),n(sl),n(ll),n(A),n(nl),n(tl),n(z),n(al),n(el),n(V),n(pl),n(v),n(Ml),n(E),n(il),n(yl),n(S),n(rl),n(ol),n(N),n(cl),n(_),n(jl),n(Jl),n(X),n(hl),n(ul),n(W),n(Ul),n(wl),n(Y),n(Tl),n(gl),n(ml),n(K),n(xl),n(F),n(Cl),n(L),n(dl),n(fl),n(ss),n(Il),n(bl),n(kl),n(ns),n($l),n(ts),n(ql),n(Ql),n(es),n(Al),n(Bl),n(Ms),n(zl),n(Vl),n(vl),n(rs),n(El),n(Zl),n(Sl),n(js),n(Gl),n(Nl),n(hs),n(_l),n(Hl),n(Us),n(Xl),n(Dl),n(Ts),n(Wl),n(Rl),n(Yl),n(xs),n(Pl),n(Kl),n(Fl),n(fs),n(Ll),n(Ol),n(bs),n(sn),n(ln),n($s),n(nn),n(tn),n(an),n(As),n(en),n(pn),n(zs),n(Mn),n(yn),n(rn),n(Es),n(on),n(cn),n(jn),n(Jn),n(Gs),n(hn),n(un),n(_s),n(Un),n(wn),n(Tn),n(gn),n(Ds),n(mn),n(xn),n(Ps)),n(p),c(b,s),c(k,s),c(q,s),c(m,s),c(Q,s),c(B,s),c(x,s),c(Z,s),c(G,s),c(H,s),c(D,s),c(R,s),c(C,s),c(P,s),c(O,s),c(d,s),c(ls,s),c(as,s),c(ps,s),c(is,s),c(ys,s),c(os,s),c(cs,s),c(Js,s),c(us,s),c(ws,s),c(gs,s),c(ms,s),c(Cs,s),c(ds,s),c(Is,s),c(ks,s),c(qs,s),c(Qs,s),c(Bs,s),c(Vs,s),c(vs,s),c(Zs,s),c(Ss,s),c(f,s),c(Ns,s),c(Hs,s),c(Xs,s),c(I,s),c(Ws,s)}}}const qt='{"title":"Byte-Pair Encoding tokenization","local":"byte-pair-encoding-tokenization","sections":[{"title":"Training algorithm","local":"training-algorithm","sections":[],"depth":2},{"title":"Tokenization algorithm","local":"tokenization-algorithm","sections":[],"depth":2},{"title":"Implementing BPE","local":"implementing-bpe","sections":[],"depth":2}],"depth":1}';function Qt(g){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gt extends ut{constructor(p){super(),Ut(this,p,Qt,$t,Jt,{})}}export{Gt as component};
