import{s as Ge,o as De,n as ss}from"../chunks/scheduler.25b97de1.js";import{S as ve,i as Re,g as j,s as M,r as i,A as Ye,h as T,f as l,c as J,j as Ql,u as o,x as u,k as ys,y as hs,a,v as y,d as h,t as U,w}from"../chunks/index.d9030fc9.js";import{T as Pa}from"../chunks/Tip.baa67368.js";import{Y as Se}from"../chunks/Youtube.eaf1a617.js";import{C as $}from"../chunks/CodeBlock.e6cd0d95.js";import{D as ze}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{F as Us,M as ws}from"../chunks/Markdown.7217f838.js";import{H as O,E as Xe}from"../chunks/EditOnGithub.91d95064.js";function Fe(B){let t,c='To see all architectures and checkpoints compatible with this task, we recommend checking the <a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">task-page</a>';return{c(){t=j("p"),t.innerHTML=c},l(n){t=T(n,"P",{"data-svelte-h":!0}),u(t)!=="svelte-mb1wqs"&&(t.innerHTML=c)},m(n,r){a(n,t,r)},p:ss,d(n){n&&l(t)}}}function He(B){let t,c='It is common to apply some data augmentations to an image dataset to make a model more robust against overfitting. In this guide, you’ll use the <a href="https://pytorch.org/vision/stable/generated/torchvision.transforms.ColorJitter.html" rel="nofollow"><code>ColorJitter</code></a> function from <a href="https://pytorch.org/vision/stable/index.html" rel="nofollow">torchvision</a> to randomly change the color properties of an image, but you can also use any image library you like.',n,r,I,A,W="Now create two preprocessing functions to prepare the images and annotations for the model. These functions convert the images into <code>pixel_values</code> and annotations to <code>labels</code>. For the training set, <code>jitter</code> is applied before providing the images to the image processor. For the test set, the image processor crops and normalizes the <code>images</code>, and only crops the <code>labels</code> because no data augmentation is applied during testing.",N,C,Z,k,_='To apply the <code>jitter</code> over the entire dataset, use the 🤗 Datasets <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> function. The transform is applied on the fly which is faster and consumes less disk space:',Q,f,G;return r=new $({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBDb2xvckppdHRlciUwQSUwQWppdHRlciUyMCUzRCUyMENvbG9ySml0dGVyKGJyaWdodG5lc3MlM0QwLjI1JTJDJTIwY29udHJhc3QlM0QwLjI1JTJDJTIwc2F0dXJhdGlvbiUzRDAuMjUlMkMlMjBodWUlM0QwLjEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> ColorJitter

<span class="hljs-meta">&gt;&gt;&gt; </span>jitter = ColorJitter(brightness=<span class="hljs-number">0.25</span>, contrast=<span class="hljs-number">0.25</span>, saturation=<span class="hljs-number">0.25</span>, hue=<span class="hljs-number">0.1</span>)`,wrap:!1}}),C=new $({props:{code:"ZGVmJTIwdHJhaW5fdHJhbnNmb3JtcyhleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QmppdHRlcih4KSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyYW5ub3RhdGlvbiUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW5wdXRzJTBBJTBBJTBBZGVmJTIwdmFsX3RyYW5zZm9ybXMoZXhhbXBsZV9iYXRjaCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJ4JTIwZm9yJTIweCUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwJTVCeCUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJhbm5vdGF0aW9uJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUyQyUyMGxhYmVscyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [jitter(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">val_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs`,wrap:!1}}),f=new $({props:{code:"dHJhaW5fZHMuc2V0X3RyYW5zZm9ybSh0cmFpbl90cmFuc2Zvcm1zKSUwQXRlc3RfZHMuc2V0X3RyYW5zZm9ybSh2YWxfdHJhbnNmb3Jtcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds.set_transform(train_transforms)
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds.set_transform(val_transforms)`,wrap:!1}}),{c(){t=j("p"),t.innerHTML=c,n=M(),i(r.$$.fragment),I=M(),A=j("p"),A.innerHTML=W,N=M(),i(C.$$.fragment),Z=M(),k=j("p"),k.innerHTML=_,Q=M(),i(f.$$.fragment)},l(p){t=T(p,"P",{"data-svelte-h":!0}),u(t)!=="svelte-43dxhy"&&(t.innerHTML=c),n=J(p),o(r.$$.fragment,p),I=J(p),A=T(p,"P",{"data-svelte-h":!0}),u(A)!=="svelte-qerdt3"&&(A.innerHTML=W),N=J(p),o(C.$$.fragment,p),Z=J(p),k=T(p,"P",{"data-svelte-h":!0}),u(k)!=="svelte-tijv00"&&(k.innerHTML=_),Q=J(p),o(f.$$.fragment,p)},m(p,b){a(p,t,b),a(p,n,b),y(r,p,b),a(p,I,b),a(p,A,b),a(p,N,b),y(C,p,b),a(p,Z,b),a(p,k,b),a(p,Q,b),y(f,p,b),G=!0},p:ss,i(p){G||(h(r.$$.fragment,p),h(C.$$.fragment,p),h(f.$$.fragment,p),G=!0)},o(p){U(r.$$.fragment,p),U(C.$$.fragment,p),U(f.$$.fragment,p),G=!1},d(p){p&&(l(t),l(n),l(I),l(A),l(N),l(Z),l(k),l(Q)),w(r,p),w(C,p),w(f,p)}}}function Le(B){let t,c;return t=new ws({props:{$$slots:{default:[He]},$$scope:{ctx:B}}}),{c(){i(t.$$.fragment)},l(n){o(t.$$.fragment,n)},m(n,r){y(t,n,r),c=!0},p(n,r){const I={};r&2&&(I.$$scope={dirty:r,ctx:n}),t.$set(I)},i(n){c||(h(t.$$.fragment,n),c=!0)},o(n){U(t.$$.fragment,n),c=!1},d(n){w(t,n)}}}function qe(B){let t,c=`It is common to apply some data augmentations to an image dataset to make a model more robust against overfitting.
In this guide, you’ll use <a href="https://www.tensorflow.org/api_docs/python/tf/image" rel="nofollow"><code>tf.image</code></a> to randomly change the color properties of an image, but you can also use any image
library you like.
Define two separate transformation functions:`,n,r,I="<li>training data transformations that include image augmentation</li> <li>validation data transformations that only transpose the images, since computer vision models in 🤗 Transformers expect channels-first layout</li>",A,W,N,C,Z=`Next, create two preprocessing functions to prepare batches of images and annotations for the model. These functions apply
the image transformations and use the earlier loaded <code>image_processor</code> to convert the images into <code>pixel_values</code> and
annotations to <code>labels</code>. <code>ImageProcessor</code> also takes care of resizing and normalizing the images.`,k,_,Q,f,G=`To apply the preprocessing transformations over the entire dataset, use the 🤗 Datasets <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> function.
The transform is applied on the fly which is faster and consumes less disk space:`,p,b,D;return W=new $({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEElMEFkZWYlMjBhdWdfdHJhbnNmb3JtcyhpbWFnZSklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmtlcmFzLnV0aWxzLmltZ190b19hcnJheShpbWFnZSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmltYWdlLnJhbmRvbV9icmlnaHRuZXNzKGltYWdlJTJDJTIwMC4yNSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmltYWdlLnJhbmRvbV9jb250cmFzdChpbWFnZSUyQyUyMDAuNSUyQyUyMDIuMCklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRmLmltYWdlLnJhbmRvbV9zYXR1cmF0aW9uKGltYWdlJTJDJTIwMC43NSUyQyUyMDEuMjUpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB0Zi5pbWFnZS5yYW5kb21faHVlKGltYWdlJTJDJTIwMC4xKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdGYudHJhbnNwb3NlKGltYWdlJTJDJTIwKDIlMkMlMjAwJTJDJTIwMSkpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEElMEFkZWYlMjB0cmFuc2Zvcm1zKGltYWdlKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdGYua2VyYXMudXRpbHMuaW1nX3RvX2FycmF5KGltYWdlKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwdGYudHJhbnNwb3NlKGltYWdlJTJDJTIwKDIlMkMlMjAwJTJDJTIwMSkpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">aug_transforms</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = tf.keras.utils.img_to_array(image)
<span class="hljs-meta">... </span>    image = tf.image.random_brightness(image, <span class="hljs-number">0.25</span>)
<span class="hljs-meta">... </span>    image = tf.image.random_contrast(image, <span class="hljs-number">0.5</span>, <span class="hljs-number">2.0</span>)
<span class="hljs-meta">... </span>    image = tf.image.random_saturation(image, <span class="hljs-number">0.75</span>, <span class="hljs-number">1.25</span>)
<span class="hljs-meta">... </span>    image = tf.image.random_hue(image, <span class="hljs-number">0.1</span>)
<span class="hljs-meta">... </span>    image = tf.transpose(image, (<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = tf.keras.utils.img_to_array(image)
<span class="hljs-meta">... </span>    image = tf.transpose(image, (<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image`,wrap:!1}}),_=new $({props:{code:"ZGVmJTIwdHJhaW5fdHJhbnNmb3JtcyhleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QmF1Z190cmFuc2Zvcm1zKHguY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyYW5ub3RhdGlvbiUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW5wdXRzJTBBJTBBJTBBZGVmJTIwdmFsX3RyYW5zZm9ybXMoZXhhbXBsZV9iYXRjaCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJ0cmFuc2Zvcm1zKHguY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyYW5ub3RhdGlvbiUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW5wdXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [aug_transforms(x.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">val_transforms</span>(<span class="hljs-params">example_batch</span>):
<span class="hljs-meta">... </span>    images = [transforms(x.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = image_processor(images, labels)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs`,wrap:!1}}),b=new $({props:{code:"dHJhaW5fZHMuc2V0X3RyYW5zZm9ybSh0cmFpbl90cmFuc2Zvcm1zKSUwQXRlc3RfZHMuc2V0X3RyYW5zZm9ybSh2YWxfdHJhbnNmb3Jtcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds.set_transform(train_transforms)
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds.set_transform(val_transforms)`,wrap:!1}}),{c(){t=j("p"),t.innerHTML=c,n=M(),r=j("ul"),r.innerHTML=I,A=M(),i(W.$$.fragment),N=M(),C=j("p"),C.innerHTML=Z,k=M(),i(_.$$.fragment),Q=M(),f=j("p"),f.innerHTML=G,p=M(),i(b.$$.fragment)},l(g){t=T(g,"P",{"data-svelte-h":!0}),u(t)!=="svelte-1rj6vla"&&(t.innerHTML=c),n=J(g),r=T(g,"UL",{"data-svelte-h":!0}),u(r)!=="svelte-lmmfid"&&(r.innerHTML=I),A=J(g),o(W.$$.fragment,g),N=J(g),C=T(g,"P",{"data-svelte-h":!0}),u(C)!=="svelte-hpi41l"&&(C.innerHTML=Z),k=J(g),o(_.$$.fragment,g),Q=J(g),f=T(g,"P",{"data-svelte-h":!0}),u(f)!=="svelte-19lox7v"&&(f.innerHTML=G),p=J(g),o(b.$$.fragment,g)},m(g,V){a(g,t,V),a(g,n,V),a(g,r,V),a(g,A,V),y(W,g,V),a(g,N,V),a(g,C,V),a(g,k,V),y(_,g,V),a(g,Q,V),a(g,f,V),a(g,p,V),y(b,g,V),D=!0},p:ss,i(g){D||(h(W.$$.fragment,g),h(_.$$.fragment,g),h(b.$$.fragment,g),D=!0)},o(g){U(W.$$.fragment,g),U(_.$$.fragment,g),U(b.$$.fragment,g),D=!1},d(g){g&&(l(t),l(n),l(r),l(A),l(N),l(C),l(k),l(Q),l(f),l(p)),w(W,g),w(_,g),w(b,g)}}}function Pe(B){let t,c;return t=new ws({props:{$$slots:{default:[qe]},$$scope:{ctx:B}}}),{c(){i(t.$$.fragment)},l(n){o(t.$$.fragment,n)},m(n,r){y(t,n,r),c=!0},p(n,r){const I={};r&2&&(I.$$scope={dirty:r,ctx:n}),t.$set(I)},i(n){c||(h(t.$$.fragment,n),c=!0)},o(n){U(t.$$.fragment,n),c=!1},d(n){w(t,n)}}}function Ke(B){let t,c;return t=new $({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2glMjBpbXBvcnQlMjBubiUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvZ2l0cyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvZ2l0c190ZW5zb3IlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KGxvZ2l0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dpdHNfdGVuc29yJTIwJTNEJTIwbm4uZnVuY3Rpb25hbC5pbnRlcnBvbGF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2dpdHNfdGVuc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZSUzRGxhYmVscy5zaGFwZSU1Qi0yJTNBJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZSUzRCUyMmJpbGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxpZ25fY29ybmVycyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5hcmdtYXgoZGltJTNEMSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkX2xhYmVscyUyMCUzRCUyMGxvZ2l0c190ZW5zb3IuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldHJpY3MlMjAlM0QlMjBtZXRyaWMuY29tcHV0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUzRHByZWRfbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVmZXJlbmNlcyUzRGxhYmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWdub3JlX2luZGV4JTNEMjU1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVkdWNlX2xhYmVscyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGtleSUyQyUyMHZhbHVlJTIwaW4lMjBtZXRyaWNzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGlzaW5zdGFuY2UodmFsdWUlMkMlMjBucC5uZGFycmF5KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldHJpY3MlNUJrZXklNUQlMjAlM0QlMjB2YWx1ZS50b2xpc3QoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpY3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        logits, labels = eval_pred
<span class="hljs-meta">... </span>        logits_tensor = torch.from_numpy(logits)
<span class="hljs-meta">... </span>        logits_tensor = nn.functional.interpolate(
<span class="hljs-meta">... </span>            logits_tensor,
<span class="hljs-meta">... </span>            size=labels.shape[-<span class="hljs-number">2</span>:],
<span class="hljs-meta">... </span>            mode=<span class="hljs-string">&quot;bilinear&quot;</span>,
<span class="hljs-meta">... </span>            align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        ).argmax(dim=<span class="hljs-number">1</span>)

<span class="hljs-meta">... </span>        pred_labels = logits_tensor.detach().cpu().numpy()
<span class="hljs-meta">... </span>        metrics = metric.compute(
<span class="hljs-meta">... </span>            predictions=pred_labels,
<span class="hljs-meta">... </span>            references=labels,
<span class="hljs-meta">... </span>            num_labels=num_labels,
<span class="hljs-meta">... </span>            ignore_index=<span class="hljs-number">255</span>,
<span class="hljs-meta">... </span>            reduce_labels=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> metrics.items():
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, np.ndarray):
<span class="hljs-meta">... </span>                metrics[key] = value.tolist()
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> metrics`,wrap:!1}}),{c(){i(t.$$.fragment)},l(n){o(t.$$.fragment,n)},m(n,r){y(t,n,r),c=!0},p:ss,i(n){c||(h(t.$$.fragment,n),c=!0)},o(n){U(t.$$.fragment,n),c=!1},d(n){w(t,n)}}}function Oe(B){let t,c;return t=new ws({props:{$$slots:{default:[Ke]},$$scope:{ctx:B}}}),{c(){i(t.$$.fragment)},l(n){o(t.$$.fragment,n)},m(n,r){y(t,n,r),c=!0},p(n,r){const I={};r&2&&(I.$$scope={dirty:r,ctx:n}),t.$set(I)},i(n){c||(h(t.$$.fragment,n),c=!0)},o(n){U(t.$$.fragment,n),c=!1},d(n){w(t,n)}}}function sn(B){let t,c;return t=new $({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjB0Zi50cmFuc3Bvc2UobG9naXRzJTJDJTIwcGVybSUzRCU1QjAlMkMlMjAyJTJDJTIwMyUyQyUyMDElNUQpJTBBJTIwJTIwJTIwJTIwbG9naXRzX3Jlc2l6ZWQlMjAlM0QlMjB0Zi5pbWFnZS5yZXNpemUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZSUzRHRmLnNoYXBlKGxhYmVscyklNUIxJTNBJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0aG9kJTNEJTIyYmlsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwcHJlZF9sYWJlbHMlMjAlM0QlMjB0Zi5hcmdtYXgobG9naXRzX3Jlc2l6ZWQlMkMlMjBheGlzJTNELTEpJTBBJTIwJTIwJTIwJTIwbWV0cmljcyUyMCUzRCUyMG1ldHJpYy5jb21wdXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTNEcHJlZF9sYWJlbHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWZlcmVuY2VzJTNEbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZ25vcmVfaW5kZXglM0QtMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlZHVjZV9sYWJlbHMlM0RpbWFnZV9wcm9jZXNzb3IuZG9fcmVkdWNlX2xhYmVscyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBwZXJfY2F0ZWdvcnlfYWNjdXJhY3klMjAlM0QlMjBtZXRyaWNzLnBvcCglMjJwZXJfY2F0ZWdvcnlfYWNjdXJhY3klMjIpLnRvbGlzdCgpJTBBJTIwJTIwJTIwJTIwcGVyX2NhdGVnb3J5X2lvdSUyMCUzRCUyMG1ldHJpY3MucG9wKCUyMnBlcl9jYXRlZ29yeV9pb3UlMjIpLnRvbGlzdCgpJTBBJTBBJTIwJTIwJTIwJTIwbWV0cmljcy51cGRhdGUoJTdCZiUyMmFjY3VyYWN5XyU3QmlkMmxhYmVsJTVCaSU1RCU3RCUyMiUzQSUyMHYlMjBmb3IlMjBpJTJDJTIwdiUyMGluJTIwZW51bWVyYXRlKHBlcl9jYXRlZ29yeV9hY2N1cmFjeSklN0QpJTBBJTIwJTIwJTIwJTIwbWV0cmljcy51cGRhdGUoJTdCZiUyMmlvdV8lN0JpZDJsYWJlbCU1QmklNUQlN0QlMjIlM0ElMjB2JTIwZm9yJTIwaSUyQyUyMHYlMjBpbiUyMGVudW1lcmF0ZShwZXJfY2F0ZWdvcnlfaW91KSU3RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2YWxfJTIyJTIwJTJCJTIwayUzQSUyMHYlMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwbWV0cmljcy5pdGVtcygpJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    logits, labels = eval_pred
<span class="hljs-meta">... </span>    logits = tf.transpose(logits, perm=[<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>])
<span class="hljs-meta">... </span>    logits_resized = tf.image.resize(
<span class="hljs-meta">... </span>        logits,
<span class="hljs-meta">... </span>        size=tf.shape(labels)[<span class="hljs-number">1</span>:],
<span class="hljs-meta">... </span>        method=<span class="hljs-string">&quot;bilinear&quot;</span>,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    pred_labels = tf.argmax(logits_resized, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    metrics = metric.compute(
<span class="hljs-meta">... </span>        predictions=pred_labels,
<span class="hljs-meta">... </span>        references=labels,
<span class="hljs-meta">... </span>        num_labels=num_labels,
<span class="hljs-meta">... </span>        ignore_index=-<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>        reduce_labels=image_processor.do_reduce_labels,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    per_category_accuracy = metrics.pop(<span class="hljs-string">&quot;per_category_accuracy&quot;</span>).tolist()
<span class="hljs-meta">... </span>    per_category_iou = metrics.pop(<span class="hljs-string">&quot;per_category_iou&quot;</span>).tolist()

<span class="hljs-meta">... </span>    metrics.update({<span class="hljs-string">f&quot;accuracy_<span class="hljs-subst">{id2label[i]}</span>&quot;</span>: v <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(per_category_accuracy)})
<span class="hljs-meta">... </span>    metrics.update({<span class="hljs-string">f&quot;iou_<span class="hljs-subst">{id2label[i]}</span>&quot;</span>: v <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(per_category_iou)})
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;val_&quot;</span> + k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> metrics.items()}`,wrap:!1}}),{c(){i(t.$$.fragment)},l(n){o(t.$$.fragment,n)},m(n,r){y(t,n,r),c=!0},p:ss,i(n){c||(h(t.$$.fragment,n),c=!0)},o(n){U(t.$$.fragment,n),c=!1},d(n){w(t,n)}}}function ln(B){let t,c;return t=new ws({props:{$$slots:{default:[sn]},$$scope:{ctx:B}}}),{c(){i(t.$$.fragment)},l(n){o(t.$$.fragment,n)},m(n,r){y(t,n,r),c=!0},p(n,r){const I={};r&2&&(I.$$scope={dirty:r,ctx:n}),t.$set(I)},i(n){c||(h(t.$$.fragment,n),c=!0)},o(n){U(t.$$.fragment,n),c=!1},d(n){w(t,n)}}}function an(B){let t,c='If you aren’t familiar with finetuning a model with the <a href="/docs/transformers/pr_30690/en/main_classes/trainer#transformers.Trainer">Trainer</a>, take a look at the basic tutorial <a href="../training#finetune-with-trainer">here</a>!';return{c(){t=j("p"),t.innerHTML=c},l(n){t=T(n,"P",{"data-svelte-h":!0}),u(t)!=="svelte-1gqfjgo"&&(t.innerHTML=c)},m(n,r){a(n,t,r)},p:ss,d(n){n&&l(t)}}}function en(B){let t,c,n,r='You’re ready to start training your model now! Load SegFormer with <a href="/docs/transformers/pr_30690/en/model_doc/auto#transformers.AutoModelForSemanticSegmentation">AutoModelForSemanticSegmentation</a>, and pass the model the mapping between label ids and label classes:',I,A,W,N,C="At this point, only three steps remain:",Z,k,_='<li>Define your training hyperparameters in <a href="/docs/transformers/pr_30690/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>. It is important you don’t remove unused columns because this’ll drop the <code>image</code> column. Without the <code>image</code> column, you can’t create <code>pixel_values</code>. Set <code>remove_unused_columns=False</code> to prevent this behavior! The only other required parameter is <code>output_dir</code> which specifies where to save your model. You’ll push this model to the Hub by setting <code>push_to_hub=True</code> (you need to be signed in to Hugging Face to upload your model). At the end of each epoch, the <a href="/docs/transformers/pr_30690/en/main_classes/trainer#transformers.Trainer">Trainer</a> will evaluate the IoU metric and save the training checkpoint.</li> <li>Pass the training arguments to <a href="/docs/transformers/pr_30690/en/main_classes/trainer#transformers.Trainer">Trainer</a> along with the model, dataset, tokenizer, data collator, and <code>compute_metrics</code> function.</li> <li>Call <a href="/docs/transformers/pr_30690/en/main_classes/trainer#transformers.Trainer.train">train()</a> to finetune your model.</li>',Q,f,G,p,b='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/pr_30690/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method so everyone can use your model:',D,g,V;return t=new Pa({props:{$$slots:{default:[an]},$$scope:{ctx:B}}}),A=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBUcmFpbmVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMjBsYWJlbDJpZCUzRGxhYmVsMmlkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSemanticSegmentation, TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(checkpoint, id2label=id2label, label2id=label2id)`,wrap:!1}}),f=new $({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJzZWdmb3JtZXItYjAtc2NlbmUtcGFyc2UtMTUwJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDZlLTUlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0QyJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV90b3RhbF9saW1pdCUzRDMlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfYWNjdW11bGF0aW9uX3N0ZXBzJTNENSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kcyUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHRlc3RfZHMlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;segformer-b0-scene-parse-150&quot;</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">6e-5</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    eval_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    eval_accumulation_steps=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=train_ds,
<span class="hljs-meta">... </span>    eval_dataset=test_ds,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),g=new $({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),{c(){i(t.$$.fragment),c=M(),n=j("p"),n.innerHTML=r,I=M(),i(A.$$.fragment),W=M(),N=j("p"),N.textContent=C,Z=M(),k=j("ol"),k.innerHTML=_,Q=M(),i(f.$$.fragment),G=M(),p=j("p"),p.innerHTML=b,D=M(),i(g.$$.fragment)},l(d){o(t.$$.fragment,d),c=J(d),n=T(d,"P",{"data-svelte-h":!0}),u(n)!=="svelte-198y4u2"&&(n.innerHTML=r),I=J(d),o(A.$$.fragment,d),W=J(d),N=T(d,"P",{"data-svelte-h":!0}),u(N)!=="svelte-l42k0i"&&(N.textContent=C),Z=J(d),k=T(d,"OL",{"data-svelte-h":!0}),u(k)!=="svelte-1clwa4w"&&(k.innerHTML=_),Q=J(d),o(f.$$.fragment,d),G=J(d),p=T(d,"P",{"data-svelte-h":!0}),u(p)!=="svelte-jq85h2"&&(p.innerHTML=b),D=J(d),o(g.$$.fragment,d)},m(d,E){y(t,d,E),a(d,c,E),a(d,n,E),a(d,I,E),y(A,d,E),a(d,W,E),a(d,N,E),a(d,Z,E),a(d,k,E),a(d,Q,E),y(f,d,E),a(d,G,E),a(d,p,E),a(d,D,E),y(g,d,E),V=!0},p(d,E){const v={};E&2&&(v.$$scope={dirty:E,ctx:d}),t.$set(v)},i(d){V||(h(t.$$.fragment,d),h(A.$$.fragment,d),h(f.$$.fragment,d),h(g.$$.fragment,d),V=!0)},o(d){U(t.$$.fragment,d),U(A.$$.fragment,d),U(f.$$.fragment,d),U(g.$$.fragment,d),V=!1},d(d){d&&(l(c),l(n),l(I),l(W),l(N),l(Z),l(k),l(Q),l(G),l(p),l(D)),w(t,d),w(A,d),w(f,d),w(g,d)}}}function nn(B){let t,c;return t=new ws({props:{$$slots:{default:[en]},$$scope:{ctx:B}}}),{c(){i(t.$$.fragment)},l(n){o(t.$$.fragment,n)},m(n,r){y(t,n,r),c=!0},p(n,r){const I={};r&2&&(I.$$scope={dirty:r,ctx:n}),t.$set(I)},i(n){c||(h(t.$$.fragment,n),c=!0)},o(n){U(t.$$.fragment,n),c=!1},d(n){w(t,n)}}}function tn(B){let t,c='If you are unfamiliar with fine-tuning a model with Keras, check out the <a href="./training#train-a-tensorflow-model-with-keras">basic tutorial</a> first!';return{c(){t=j("p"),t.innerHTML=c},l(n){t=T(n,"P",{"data-svelte-h":!0}),u(t)!=="svelte-1egt5s9"&&(t.innerHTML=c)},m(n,r){a(n,t,r)},p:ss,d(n){n&&l(t)}}}function pn(B){let t,c,n,r="To fine-tune a model in TensorFlow, follow these steps:",I,A,W="<li>Define the training hyperparameters, and set up an optimizer and a learning rate schedule.</li> <li>Instantiate a pretrained model.</li> <li>Convert a 🤗 Dataset to a <code>tf.data.Dataset</code>.</li> <li>Compile your model.</li> <li>Add callbacks to calculate metrics and upload your model to 🤗 Hub</li> <li>Use the <code>fit()</code> method to run the training.</li>",N,C,Z="Start by defining the hyperparameters, optimizer and learning rate schedule:",k,_,Q,f,G=`Then, load SegFormer with <a href="/docs/transformers/pr_30690/en/model_doc/auto#transformers.TFAutoModelForSemanticSegmentation">TFAutoModelForSemanticSegmentation</a> along with the label mappings, and compile it with the
optimizer. Note that Transformers models all have a default task-relevant loss function, so you don’t need to specify one unless you want to:`,p,b,D,g,V='Convert your datasets to the <code>tf.data.Dataset</code> format using the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.to_tf_dataset" rel="nofollow">to_tf_dataset</a> and the <a href="/docs/transformers/pr_30690/en/main_classes/data_collator#transformers.DefaultDataCollator">DefaultDataCollator</a>:',d,E,v,Y,H=`To compute the accuracy from the predictions and push your model to the 🤗 Hub, use <a href="../main_classes/keras_callbacks">Keras callbacks</a>.
Pass your <code>compute_metrics</code> function to <a href="/docs/transformers/pr_30690/en/main_classes/keras_callbacks#transformers.KerasMetricCallback">KerasMetricCallback</a>,
and use the <a href="/docs/transformers/pr_30690/en/main_classes/keras_callbacks#transformers.PushToHubCallback">PushToHubCallback</a> to upload the model:`,us,S,z,X,L=`Finally, you are ready to train your model! Call <code>fit()</code> with your training and validation datasets, the number of epochs,
and your callbacks to fine-tune the model:`,P,R,bs,F,q="Congratulations! You have fine-tuned your model and shared it on the 🤗 Hub. You can now use it for inference!",K;return t=new Pa({props:{$$slots:{default:[tn]},$$scope:{ctx:B}}}),_=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGNyZWF0ZV9vcHRpbWl6ZXIlMEElMEFiYXRjaF9zaXplJTIwJTNEJTIwMiUwQW51bV9lcG9jaHMlMjAlM0QlMjA1MCUwQW51bV90cmFpbl9zdGVwcyUyMCUzRCUyMGxlbih0cmFpbl9kcyklMjAqJTIwbnVtX2Vwb2NocyUwQWxlYXJuaW5nX3JhdGUlMjAlM0QlMjA2ZS01JTBBd2VpZ2h0X2RlY2F5X3JhdGUlMjAlM0QlMjAwLjAxJTBBJTBBb3B0aW1pemVyJTJDJTIwbHJfc2NoZWR1bGUlMjAlM0QlMjBjcmVhdGVfb3B0aW1pemVyKCUwQSUyMCUyMCUyMCUyMGluaXRfbHIlM0RsZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX3N0ZXBzJTNEbnVtX3RyYWluX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5X3JhdGUlM0R3ZWlnaHRfZGVjYXlfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> create_optimizer

<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">50</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_train_steps = <span class="hljs-built_in">len</span>(train_ds) * num_epochs
<span class="hljs-meta">&gt;&gt;&gt; </span>learning_rate = <span class="hljs-number">6e-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>weight_decay_rate = <span class="hljs-number">0.01</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer, lr_schedule = create_optimizer(
<span class="hljs-meta">... </span>    init_lr=learning_rate,
<span class="hljs-meta">... </span>    num_train_steps=num_train_steps,
<span class="hljs-meta">... </span>    weight_decay_rate=weight_decay_rate,
<span class="hljs-meta">... </span>    num_warmup_steps=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),b=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGNoZWNrcG9pbnQlMkMlMEElMjAlMjAlMjAlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSklMEFtb2RlbC5jb21waWxlKG9wdGltaXplciUzRG9wdGltaXplciklMjAlMjAlMjMlMjBObyUyMGxvc3MlMjBhcmd1bWVudCE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    checkpoint,
<span class="hljs-meta">... </span>    id2label=id2label,
<span class="hljs-meta">... </span>    label2id=label2id,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(optimizer=optimizer)  <span class="hljs-comment"># No loss argument!</span>`,wrap:!1}}),E=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcihyZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUwQXRmX3RyYWluX2RhdGFzZXQlMjAlM0QlMjB0cmFpbl9kcy50b190Zl9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMGNvbHVtbnMlM0QlNUIlMjJwaXhlbF92YWx1ZXMlMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNodWZmbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUyQyUwQSklMEElMEF0Zl9ldmFsX2RhdGFzZXQlMjAlM0QlMjB0ZXN0X2RzLnRvX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiUyQyUyMCUyMmxhYmVsJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGNvbGxhdGVfZm4lM0RkYXRhX2NvbGxhdG9yJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator(return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_dataset = train_ds.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;pixel_values&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_eval_dataset = test_ds.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;pixel_values&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)`,wrap:!1}}),S=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5rZXJhc19jYWxsYmFja3MlMjBpbXBvcnQlMjBLZXJhc01ldHJpY0NhbGxiYWNrJTJDJTIwUHVzaFRvSHViQ2FsbGJhY2slMEElMEFtZXRyaWNfY2FsbGJhY2slMjAlM0QlMjBLZXJhc01ldHJpY0NhbGxiYWNrKCUwQSUyMCUyMCUyMCUyMG1ldHJpY19mbiUzRGNvbXB1dGVfbWV0cmljcyUyQyUyMGV2YWxfZGF0YXNldCUzRHRmX2V2YWxfZGF0YXNldCUyQyUyMGJhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTIwbGFiZWxfY29scyUzRCU1QiUyMmxhYmVscyUyMiU1RCUwQSklMEElMEFwdXNoX3RvX2h1Yl9jYWxsYmFjayUyMCUzRCUyMFB1c2hUb0h1YkNhbGxiYWNrKG91dHB1dF9kaXIlM0QlMjJzY2VuZV9zZWdtZW50YXRpb24lMjIlMkMlMjB0b2tlbml6ZXIlM0RpbWFnZV9wcm9jZXNzb3IpJTBBJTBBY2FsbGJhY2tzJTIwJTNEJTIwJTVCbWV0cmljX2NhbGxiYWNrJTJDJTIwcHVzaF90b19odWJfY2FsbGJhY2slNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.keras_callbacks <span class="hljs-keyword">import</span> KerasMetricCallback, PushToHubCallback

<span class="hljs-meta">&gt;&gt;&gt; </span>metric_callback = KerasMetricCallback(
<span class="hljs-meta">... </span>    metric_fn=compute_metrics, eval_dataset=tf_eval_dataset, batch_size=batch_size, label_cols=[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>push_to_hub_callback = PushToHubCallback(output_dir=<span class="hljs-string">&quot;scene_segmentation&quot;</span>, tokenizer=image_processor)

<span class="hljs-meta">&gt;&gt;&gt; </span>callbacks = [metric_callback, push_to_hub_callback]`,wrap:!1}}),R=new $({props:{code:"bW9kZWwuZml0KCUwQSUyMCUyMCUyMCUyMHRmX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB2YWxpZGF0aW9uX2RhdGElM0R0Zl9ldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja3MlM0RjYWxsYmFja3MlMkMlMEElMjAlMjAlMjAlMjBlcG9jaHMlM0RudW1fZXBvY2hzJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(
<span class="hljs-meta">... </span>    tf_train_dataset,
<span class="hljs-meta">... </span>    validation_data=tf_eval_dataset,
<span class="hljs-meta">... </span>    callbacks=callbacks,
<span class="hljs-meta">... </span>    epochs=num_epochs,
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){i(t.$$.fragment),c=M(),n=j("p"),n.textContent=r,I=M(),A=j("ol"),A.innerHTML=W,N=M(),C=j("p"),C.textContent=Z,k=M(),i(_.$$.fragment),Q=M(),f=j("p"),f.innerHTML=G,p=M(),i(b.$$.fragment),D=M(),g=j("p"),g.innerHTML=V,d=M(),i(E.$$.fragment),v=M(),Y=j("p"),Y.innerHTML=H,us=M(),i(S.$$.fragment),z=M(),X=j("p"),X.innerHTML=L,P=M(),i(R.$$.fragment),bs=M(),F=j("p"),F.textContent=q},l(m){o(t.$$.fragment,m),c=J(m),n=T(m,"P",{"data-svelte-h":!0}),u(n)!=="svelte-s07fxj"&&(n.textContent=r),I=J(m),A=T(m,"OL",{"data-svelte-h":!0}),u(A)!=="svelte-1e3w1hr"&&(A.innerHTML=W),N=J(m),C=T(m,"P",{"data-svelte-h":!0}),u(C)!=="svelte-ccl3wn"&&(C.textContent=Z),k=J(m),o(_.$$.fragment,m),Q=J(m),f=T(m,"P",{"data-svelte-h":!0}),u(f)!=="svelte-5jbtha"&&(f.innerHTML=G),p=J(m),o(b.$$.fragment,m),D=J(m),g=T(m,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1yqybn0"&&(g.innerHTML=V),d=J(m),o(E.$$.fragment,m),v=J(m),Y=T(m,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1qpkc6v"&&(Y.innerHTML=H),us=J(m),o(S.$$.fragment,m),z=J(m),X=T(m,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1occr1z"&&(X.innerHTML=L),P=J(m),o(R.$$.fragment,m),bs=J(m),F=T(m,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1r99pbn"&&(F.textContent=q)},m(m,x){y(t,m,x),a(m,c,x),a(m,n,x),a(m,I,x),a(m,A,x),a(m,N,x),a(m,C,x),a(m,k,x),y(_,m,x),a(m,Q,x),a(m,f,x),a(m,p,x),y(b,m,x),a(m,D,x),a(m,g,x),a(m,d,x),y(E,m,x),a(m,v,x),a(m,Y,x),a(m,us,x),y(S,m,x),a(m,z,x),a(m,X,x),a(m,P,x),y(R,m,x),a(m,bs,x),a(m,F,x),K=!0},p(m,x){const gs={};x&2&&(gs.$$scope={dirty:x,ctx:m}),t.$set(gs)},i(m){K||(h(t.$$.fragment,m),h(_.$$.fragment,m),h(b.$$.fragment,m),h(E.$$.fragment,m),h(S.$$.fragment,m),h(R.$$.fragment,m),K=!0)},o(m){U(t.$$.fragment,m),U(_.$$.fragment,m),U(b.$$.fragment,m),U(E.$$.fragment,m),U(S.$$.fragment,m),U(R.$$.fragment,m),K=!1},d(m){m&&(l(c),l(n),l(I),l(A),l(N),l(C),l(k),l(Q),l(f),l(p),l(D),l(g),l(d),l(v),l(Y),l(us),l(z),l(X),l(P),l(bs),l(F)),w(t,m),w(_,m),w(b,m),w(E,m),w(S,m),w(R,m)}}}function Mn(B){let t,c;return t=new ws({props:{$$slots:{default:[pn]},$$scope:{ctx:B}}}),{c(){i(t.$$.fragment)},l(n){o(t.$$.fragment,n)},m(n,r){y(t,n,r),c=!0},p(n,r){const I={};r&2&&(I.$$scope={dirty:r,ctx:n}),t.$set(I)},i(n){c||(h(t.$$.fragment,n),c=!0)},o(n){U(t.$$.fragment,n),c=!1},d(n){w(t,n)}}}function Jn(B){let t,c="We will now see how to infer without a pipeline. Process the image with an image processor and place the <code>pixel_values</code> on a GPU:",n,r,I,A,W="Pass your input to the model and return the <code>logits</code>:",N,C,Z,k,_="Next, rescale the logits to the original image size:",Q,f,G;return r=new $({props:{code:"ZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUyMCUyMCUyMyUyMHVzZSUyMEdQVSUyMGlmJTIwYXZhaWxhYmxlJTJDJTIwb3RoZXJ3aXNlJTIwdXNlJTIwYSUyMENQVSUwQWVuY29kaW5nJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBlbmNvZGluZy5waXhlbF92YWx1ZXMudG8oZGV2aWNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)  <span class="hljs-comment"># use GPU if available, otherwise use a CPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = encoding.pixel_values.to(device)`,wrap:!1}}),C=new $({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyUzRHBpeGVsX3ZhbHVlcyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5jcHUoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values=pixel_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits.cpu()`,wrap:!1}}),f=new $({props:{code:"dXBzYW1wbGVkX2xvZ2l0cyUyMCUzRCUyMG5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwbG9naXRzJTJDJTBBJTIwJTIwJTIwJTIwc2l6ZSUzRGltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGUlM0QlMjJiaWxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEFwcmVkX3NlZyUyMCUzRCUyMHVwc2FtcGxlZF9sb2dpdHMuYXJnbWF4KGRpbSUzRDEpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>upsampled_logits = nn.functional.interpolate(
<span class="hljs-meta">... </span>    logits,
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bilinear&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred_seg = upsampled_logits.argmax(dim=<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){t=j("p"),t.innerHTML=c,n=M(),i(r.$$.fragment),I=M(),A=j("p"),A.innerHTML=W,N=M(),i(C.$$.fragment),Z=M(),k=j("p"),k.textContent=_,Q=M(),i(f.$$.fragment)},l(p){t=T(p,"P",{"data-svelte-h":!0}),u(t)!=="svelte-appsul"&&(t.innerHTML=c),n=J(p),o(r.$$.fragment,p),I=J(p),A=T(p,"P",{"data-svelte-h":!0}),u(A)!=="svelte-oyplyw"&&(A.innerHTML=W),N=J(p),o(C.$$.fragment,p),Z=J(p),k=T(p,"P",{"data-svelte-h":!0}),u(k)!=="svelte-tk6q3q"&&(k.textContent=_),Q=J(p),o(f.$$.fragment,p)},m(p,b){a(p,t,b),a(p,n,b),y(r,p,b),a(p,I,b),a(p,A,b),a(p,N,b),y(C,p,b),a(p,Z,b),a(p,k,b),a(p,Q,b),y(f,p,b),G=!0},p:ss,i(p){G||(h(r.$$.fragment,p),h(C.$$.fragment,p),h(f.$$.fragment,p),G=!0)},o(p){U(r.$$.fragment,p),U(C.$$.fragment,p),U(f.$$.fragment,p),G=!1},d(p){p&&(l(t),l(n),l(I),l(A),l(N),l(Z),l(k),l(Q)),w(r,p),w(C,p),w(f,p)}}}function rn(B){let t,c;return t=new ws({props:{$$slots:{default:[Jn]},$$scope:{ctx:B}}}),{c(){i(t.$$.fragment)},l(n){o(t.$$.fragment,n)},m(n,r){y(t,n,r),c=!0},p(n,r){const I={};r&2&&(I.$$scope={dirty:r,ctx:n}),t.$set(I)},i(n){c||(h(t.$$.fragment,n),c=!0)},o(n){U(t.$$.fragment,n),c=!1},d(n){w(t,n)}}}function mn(B){let t,c="Load an image processor to preprocess the image and return the input as TensorFlow tensors:",n,r,I,A,W="Pass your input to the model and return the <code>logits</code>:",N,C,Z,k,_="Next, rescale the logits to the original image size and apply argmax on the class dimension:",Q,f,G;return r=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGc2NlbmVfc2VnbWVudGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MariaK/scene_segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)`,wrap:!1}}),C=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMk1hcmlhSyUyRnNjZW5lX3NlZ21lbnRhdGlvbiUyMiklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;MariaK/scene_segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits`,wrap:!1}}),f=new $({props:{code:"bG9naXRzJTIwJTNEJTIwdGYudHJhbnNwb3NlKGxvZ2l0cyUyQyUyMCU1QjAlMkMlMjAyJTJDJTIwMyUyQyUyMDElNUQpJTBBJTBBdXBzYW1wbGVkX2xvZ2l0cyUyMCUzRCUyMHRmLmltYWdlLnJlc2l6ZSglMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBXZSUyMHJldmVyc2UlMjB0aGUlMjBzaGFwZSUyMG9mJTIwJTYwaW1hZ2UlNjAlMjBiZWNhdXNlJTIwJTYwaW1hZ2Uuc2l6ZSU2MCUyMHJldHVybnMlMjB3aWR0aCUyMGFuZCUyMGhlaWdodC4lMEElMjAlMjAlMjAlMjBpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlMkMlMEEpJTBBJTBBcHJlZF9zZWclMjAlM0QlMjB0Zi5tYXRoLmFyZ21heCh1cHNhbXBsZWRfbG9naXRzJTJDJTIwYXhpcyUzRC0xKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>logits = tf.transpose(logits, [<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>upsampled_logits = tf.image.resize(
<span class="hljs-meta">... </span>    logits,
<span class="hljs-meta">... </span>    <span class="hljs-comment"># We reverse the shape of \`image\` because \`image.size\` returns width and height.</span>
<span class="hljs-meta">... </span>    image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred_seg = tf.math.argmax(upsampled_logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){t=j("p"),t.textContent=c,n=M(),i(r.$$.fragment),I=M(),A=j("p"),A.innerHTML=W,N=M(),i(C.$$.fragment),Z=M(),k=j("p"),k.textContent=_,Q=M(),i(f.$$.fragment)},l(p){t=T(p,"P",{"data-svelte-h":!0}),u(t)!=="svelte-1r2yss0"&&(t.textContent=c),n=J(p),o(r.$$.fragment,p),I=J(p),A=T(p,"P",{"data-svelte-h":!0}),u(A)!=="svelte-oyplyw"&&(A.innerHTML=W),N=J(p),o(C.$$.fragment,p),Z=J(p),k=T(p,"P",{"data-svelte-h":!0}),u(k)!=="svelte-enih9r"&&(k.textContent=_),Q=J(p),o(f.$$.fragment,p)},m(p,b){a(p,t,b),a(p,n,b),y(r,p,b),a(p,I,b),a(p,A,b),a(p,N,b),y(C,p,b),a(p,Z,b),a(p,k,b),a(p,Q,b),y(f,p,b),G=!0},p:ss,i(p){G||(h(r.$$.fragment,p),h(C.$$.fragment,p),h(f.$$.fragment,p),G=!0)},o(p){U(r.$$.fragment,p),U(C.$$.fragment,p),U(f.$$.fragment,p),G=!1},d(p){p&&(l(t),l(n),l(I),l(A),l(N),l(Z),l(k),l(Q)),w(r,p),w(C,p),w(f,p)}}}function cn(B){let t,c;return t=new ws({props:{$$slots:{default:[mn]},$$scope:{ctx:B}}}),{c(){i(t.$$.fragment)},l(n){o(t.$$.fragment,n)},m(n,r){y(t,n,r),c=!0},p(n,r){const I={};r&2&&(I.$$scope={dirty:r,ctx:n}),t.$set(I)},i(n){c||(h(t.$$.fragment,n),c=!0)},o(n){U(t.$$.fragment,n),c=!1},d(n){w(t,n)}}}function jn(B){let t,c,n,r,I,A,W,N,C,Z,k,_="Image segmentation models separate areas corresponding to different areas of interest in an image. These models work by assigning a label to each pixel. There are several types of segmentation: semantic segmentation, instance segmentation, and panoptic segmentation.",Q,f,G="In this guide, we will:",p,b,D='<li><a href="#types-of-segmentation">Take a look at different types of segmentation</a>.</li> <li><a href="#fine-tuning-a-model-for-segmentation">Have an end-to-end fine-tuning example for semantic segmentation</a>.</li>',g,V,d="Before you begin, make sure you have all the necessary libraries installed:",E,v,Y,H,us="We encourage you to log in to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to log in:",S,z,X,L,P,R,bs=`Semantic segmentation assigns a label or class to every single pixel in an image. Let’s take a look at a semantic segmentation model output. It will assign the same class to every instance of an object it comes across in an image, for example, all cats will be labeled as “cat” instead of “cat-1”, “cat-2”.
We can use transformers’ image segmentation pipeline to quickly infer a semantic segmentation model. Let’s take a look at the example image.`,F,q,K,m,x='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/segmentation_input.jpg" alt="Segmentation Input"/>',gs,Is,Ka='We will use <a href="https://huggingface.co/nvidia/segformer-b1-finetuned-cityscapes-1024-1024" rel="nofollow">nvidia/segformer-b1-finetuned-cityscapes-1024-1024</a>.',xl,ds,Wl,fs,Oa="The segmentation pipeline output includes a mask for every predicted class.",El,Cs,Zl,As,se="Taking a look at the mask for the car class, we can see every car is classified with the same mask.",_l,ks,Vl,ls,le='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/semantic_segmentation_output.png" alt="Semantic Segmentation Output"/>',Gl,$s,ae='In instance segmentation, the goal is not to classify every pixel, but to predict a mask for <strong>every instance of an object</strong> in a given image. It works very similar to object detection, where there is a bounding box for every instance, there’s a segmentation mask instead. We will use <a href="https://huggingface.co/facebook/mask2former-swin-large-cityscapes-instance" rel="nofollow">facebook/mask2former-swin-large-cityscapes-instance</a> for this.',Dl,Bs,vl,Ns,ee="As you can see below, there are multiple cars classified, and there’s no classification for pixels other than pixels that belong to car and person instances.",Rl,Qs,Yl,xs,ne="Checking out one of the car masks below.",Sl,Ws,zl,as,te='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/instance_segmentation_output.png" alt="Semantic Segmentation Output"/>',Xl,Es,pe='Panoptic segmentation combines semantic segmentation and instance segmentation, where every pixel is classified into a class and an instance of that class, and there are multiple masks for each instance of a class. We can use <a href="https://huggingface.co/facebook/mask2former-swin-large-cityscapes-panoptic" rel="nofollow">facebook/mask2former-swin-large-cityscapes-panoptic</a> for this.',Fl,Zs,Hl,_s,Me="As you can see below, we have more classes. We will later illustrate to see that every pixel is classified into one of the classes.",Ll,Vs,ql,Gs,Je="Let’s have a side by side comparison for all types of segmentation.",Pl,es,re='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/segmentation-comparison.png" alt="Segmentation Maps Compared"/>',Kl,Ds,me="Seeing all types of segmentation, let’s have a deep dive on fine-tuning a model for semantic segmentation.",Ol,vs,ce="Common real-world applications of semantic segmentation include training self-driving cars to identify pedestrians and important traffic information, identifying cells and abnormalities in medical imagery, and monitoring environmental changes from satellite imagery.",sa,Rs,la,Ys,je="We will now:",aa,Ss,Te='<li>Finetune <a href="https://huggingface.co/docs/transformers/main/en/model_doc/segformer#segformer" rel="nofollow">SegFormer</a> on the <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">SceneParse150</a> dataset.</li> <li>Use your fine-tuned model for inference.</li>',ea,ns,na,zs,ta,Xs,ie="Start by loading a smaller subset of the SceneParse150 dataset from the 🤗 Datasets library. This’ll give you a chance to experiment and make sure everything works before spending more time training on the full dataset.",pa,Fs,Ma,Hs,oe='Split the dataset’s <code>train</code> split into a train and test set with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.train_test_split" rel="nofollow">train_test_split</a> method:',Ja,Ls,ra,qs,ye="Then take a look at an example:",ma,Ps,ca,Ks,he="<li><code>image</code>: a PIL image of the scene.</li> <li><code>annotation</code>: a PIL image of the segmentation map, which is also the model’s target.</li> <li><code>scene_category</code>: a category id that describes the image scene like “kitchen” or “office”. In this guide, you’ll only need <code>image</code> and <code>annotation</code>, both of which are PIL images.</li>",ja,Os,Ue="You’ll also want to create a dictionary that maps a label id to a label class which will be useful when you set up the model later. Download the mappings from the Hub and create the <code>id2label</code> and <code>label2id</code> dictionaries:",Ta,sl,ia,ll,oa,al,we='You could also create and use your own dataset if you prefer to train with the <a href="https://github.com/huggingface/transformers/blob/main/examples/pytorch/semantic-segmentation/run_semantic_segmentation.py" rel="nofollow">run_semantic_segmentation.py</a> script instead of a notebook instance. The script requires:',ya,ts,el,$l,ue='a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.DatasetDict" rel="nofollow">DatasetDict</a> with two <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Image" rel="nofollow">Image</a> columns, “image” and “label”',Ha,nl,La,tl,Bl,be="an id2label dictionary mapping the class integers to their class names",qa,pl,ha,Ml,ge='As an example, take a look at this <a href="https://huggingface.co/datasets/nielsr/ade20k-demo" rel="nofollow">example dataset</a> which was created with the steps shown above.',Ua,Jl,wa,rl,Ie="The next step is to load a SegFormer image processor to prepare the images and annotations for the model. Some datasets, like this one, use the zero-index as the background class. However, the background class isn’t actually included in the 150 classes, so you’ll need to set <code>do_reduce_labels=True</code> to subtract one from all the labels. The zero-index is replaced by <code>255</code> so it’s ignored by SegFormer’s loss function:",ua,ml,ba,ps,ga,Ms,Ia,cl,da,jl,de='Including a metric during training is often helpful for evaluating your model’s performance. You can quickly load an evaluation method with the 🤗 <a href="https://huggingface.co/docs/evaluate/index" rel="nofollow">Evaluate</a> library. For this task, load the <a href="https://huggingface.co/spaces/evaluate-metric/accuracy" rel="nofollow">mean Intersection over Union</a> (IoU) metric (see the 🤗 Evaluate <a href="https://huggingface.co/docs/evaluate/a_quick_tour" rel="nofollow">quick tour</a> to learn more about how to load and compute a metric):',fa,Tl,Ca,il,fe=`Then create a function to <a href="https://huggingface.co/docs/evaluate/main/en/package_reference/main_classes#evaluate.EvaluationModule.compute" rel="nofollow">compute</a> the metrics. Your predictions need to be converted to
logits first, and then reshaped to match the size of the labels before you can call <a href="https://huggingface.co/docs/evaluate/main/en/package_reference/main_classes#evaluate.EvaluationModule.compute" rel="nofollow">compute</a>:`,Aa,Js,ka,rs,$a,ol,Ce="Your <code>compute_metrics</code> function is ready to go now, and you’ll return to it when you setup your training.",Ba,yl,Na,ms,Qa,cs,xa,hl,Wa,Ul,Ae="Great, now that you’ve finetuned a model, you can use it for inference!",Ea,wl,ke="Reload the dataset and load an image for inference.",Za,ul,_a,js,$e='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/semantic-seg-image.png" alt="Image of bedroom"/>',Va,Ts,Ga,is,Da,bl,Be='To visualize the results, load the <a href="https://github.com/tensorflow/models/blob/3f1ca33afe3c1631b733ea7e40c294273b9e406d/research/deeplab/utils/get_dataset_colormap.py#L51" rel="nofollow">dataset color palette</a> as <code>ade_palette()</code> that maps each class to their RGB values.',va,gl,Ra,Il,Ne="Then you can combine and plot your image and the predicted segmentation map:",Ya,dl,Sa,os,Qe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/semantic-seg-preds.png" alt="Image of bedroom overlaid with segmentation map"/>',za,fl,Xa,Nl,Fa;return I=new O({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h1"}}),W=new ze({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/semantic_segmentation.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/semantic_segmentation.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/semantic_segmentation.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/semantic_segmentation.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/semantic_segmentation.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/semantic_segmentation.ipynb"}]}}),C=new Se({props:{id:"dKE8SIt9C-w"}}),v=new $({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTIwdHJhbnNmb3JtZXJzJTIwZXZhbHVhdGUlMjBhY2NlbGVyYXRl",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries</span>
!pip install -q datasets transformers evaluate accelerate`,wrap:!1}}),z=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),L=new O({props:{title:"Types of Segmentation",local:"types-of-segmentation",headingTag:"h2"}}),q=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRnNlZ21lbnRhdGlvbl9pbnB1dC5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/segmentation_input.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),ds=new $({props:{code:"c2VtYW50aWNfc2VnbWVudGF0aW9uJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwJTIybnZpZGlhJTJGc2VnZm9ybWVyLWIxLWZpbmV0dW5lZC1jaXR5c2NhcGVzLTEwMjQtMTAyNCUyMiklMEFyZXN1bHRzJTIwJTNEJTIwc2VtYW50aWNfc2VnbWVudGF0aW9uKGltYWdlKSUwQXJlc3VsdHM=",highlighted:`semantic_segmentation = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, <span class="hljs-string">&quot;nvidia/segformer-b1-finetuned-cityscapes-1024-1024&quot;</span>)
results = semantic_segmentation(image)
results`,wrap:!1}}),Cs=new $({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyME5vbmUlMkMlMEElMjAlMjAnbGFiZWwnJTNBJTIwJ3JvYWQnJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyME5vbmUlMkMlMEElMjAlMjAnbGFiZWwnJTNBJTIwJ3NpZGV3YWxrJyUyQyUwQSUyMCUyMCdtYXNrJyUzQSUyMCUzQ1BJTC5JbWFnZS5JbWFnZSUyMGltYWdlJTIwbW9kZSUzREwlMjBzaXplJTNENjEyeDQxNSUzRSU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjBOb25lJTJDJTBBJTIwJTIwJ2xhYmVsJyUzQSUyMCdidWlsZGluZyclMkMlMEElMjAlMjAnbWFzayclM0ElMjAlM0NQSUwuSW1hZ2UuSW1hZ2UlMjBpbWFnZSUyMG1vZGUlM0RMJTIwc2l6ZSUzRDYxMng0MTUlM0UlN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwTm9uZSUyQyUwQSUyMCUyMCdsYWJlbCclM0ElMjAnd2FsbCclMkMlMEElMjAlMjAnbWFzayclM0ElMjAlM0NQSUwuSW1hZ2UuSW1hZ2UlMjBpbWFnZSUyMG1vZGUlM0RMJTIwc2l6ZSUzRDYxMng0MTUlM0UlN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwTm9uZSUyQyUwQSUyMCUyMCdsYWJlbCclM0ElMjAncG9sZSclMkMlMEElMjAlMjAnbWFzayclM0ElMjAlM0NQSUwuSW1hZ2UuSW1hZ2UlMjBpbWFnZSUyMG1vZGUlM0RMJTIwc2l6ZSUzRDYxMng0MTUlM0UlN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwTm9uZSUyQyUwQSUyMCUyMCdsYWJlbCclM0ElMjAndHJhZmZpYyUyMHNpZ24nJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyME5vbmUlMkMlMEElMjAlMjAnbGFiZWwnJTNBJTIwJ3ZlZ2V0YXRpb24nJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyME5vbmUlMkMlMEElMjAlMjAnbGFiZWwnJTNBJTIwJ3RlcnJhaW4nJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyME5vbmUlMkMlMEElMjAlMjAnbGFiZWwnJTNBJTIwJ3NreSclMkMlMEElMjAlMjAnbWFzayclM0ElMjAlM0NQSUwuSW1hZ2UuSW1hZ2UlMjBpbWFnZSUyMG1vZGUlM0RMJTIwc2l6ZSUzRDYxMng0MTUlM0UlN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwTm9uZSUyQyUwQSUyMCUyMCdsYWJlbCclM0ElMjAnY2FyJyUyQyUwQSUyMCUyMCdtYXNrJyUzQSUyMCUzQ1BJTC5JbWFnZS5JbWFnZSUyMGltYWdlJTIwbW9kZSUzREwlMjBzaXplJTNENjEyeDQxNSUzRSU3RCU1RA==",highlighted:`[{<span class="hljs-string">&#x27;score&#x27;</span>: None,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;road&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: None,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sidewalk&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: None,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;building&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: None,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;wall&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: None,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;pole&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: None,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;traffic sign&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: None,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;vegetation&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: None,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;terrain&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: None,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sky&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: None,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;}]`,wrap:!1}}),ks=new $({props:{code:"cmVzdWx0cyU1Qi0xJTVEJTVCJTIybWFzayUyMiU1RA==",highlighted:'results[-<span class="hljs-number">1</span>][<span class="hljs-string">&quot;mask&quot;</span>]',wrap:!1}}),Bs=new $({props:{code:"aW5zdGFuY2Vfc2VnbWVudGF0aW9uJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwJTIyZmFjZWJvb2slMkZtYXNrMmZvcm1lci1zd2luLWxhcmdlLWNpdHlzY2FwZXMtaW5zdGFuY2UlMjIpJTBBcmVzdWx0cyUyMCUzRCUyMGluc3RhbmNlX3NlZ21lbnRhdGlvbihpbWFnZSklMEFyZXN1bHRz",highlighted:`instance_segmentation = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, <span class="hljs-string">&quot;facebook/mask2former-swin-large-cityscapes-instance&quot;</span>)
results = instance_segmentation(image)
results`,wrap:!1}}),Qs=new $({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTQ0JTJDJTBBJTIwJTIwJ2xhYmVsJyUzQSUyMCdjYXInJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTQ1JTJDJTBBJTIwJTIwJ2xhYmVsJyUzQSUyMCdjYXInJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDAuOTk5NjUyJTJDJTBBJTIwJTIwJ2xhYmVsJyUzQSUyMCdjYXInJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDAuOTAzNTI5JTJDJTBBJTIwJTIwJ2xhYmVsJyUzQSUyMCdwZXJzb24nJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTVE",highlighted:`[{<span class="hljs-string">&#x27;score&#x27;</span>: 0.999944,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.999945,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.999652,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.903529,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;person&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;}]`,wrap:!1}}),Ws=new $({props:{code:"cmVzdWx0cyU1QjIlNUQlNUIlMjJtYXNrJTIyJTVE",highlighted:'results[<span class="hljs-number">2</span>][<span class="hljs-string">&quot;mask&quot;</span>]',wrap:!1}}),Zs=new $({props:{code:"cGFub3B0aWNfc2VnbWVudGF0aW9uJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwJTIyZmFjZWJvb2slMkZtYXNrMmZvcm1lci1zd2luLWxhcmdlLWNpdHlzY2FwZXMtcGFub3B0aWMlMjIpJTBBcmVzdWx0cyUyMCUzRCUyMHBhbm9wdGljX3NlZ21lbnRhdGlvbihpbWFnZSklMEFyZXN1bHRz",highlighted:`panoptic_segmentation = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, <span class="hljs-string">&quot;facebook/mask2former-swin-large-cityscapes-panoptic&quot;</span>)
results = panoptic_segmentation(image)
results`,wrap:!1}}),Vs=new $({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTgxJTJDJTBBJTIwJTIwJ2xhYmVsJyUzQSUyMCdjYXInJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTU4JTJDJTBBJTIwJTIwJ2xhYmVsJyUzQSUyMCdjYXInJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTclMkMlMEElMjAlMjAnbGFiZWwnJTNBJTIwJ3ZlZ2V0YXRpb24nJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDAuOTk5NTc1JTJDJTBBJTIwJTIwJ2xhYmVsJyUzQSUyMCdwb2xlJyUyQyUwQSUyMCUyMCdtYXNrJyUzQSUyMCUzQ1BJTC5JbWFnZS5JbWFnZSUyMGltYWdlJTIwbW9kZSUzREwlMjBzaXplJTNENjEyeDQxNSUzRSU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAwLjk5OTk1OCUyQyUwQSUyMCUyMCdsYWJlbCclM0ElMjAnYnVpbGRpbmcnJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDAuOTk5NjM0JTJDJTBBJTIwJTIwJ2xhYmVsJyUzQSUyMCdyb2FkJyUyQyUwQSUyMCUyMCdtYXNrJyUzQSUyMCUzQ1BJTC5JbWFnZS5JbWFnZSUyMGltYWdlJTIwbW9kZSUzREwlMjBzaXplJTNENjEyeDQxNSUzRSU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAwLjk5NjA5MiUyQyUwQSUyMCUyMCdsYWJlbCclM0ElMjAnc2lkZXdhbGsnJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDAuOTk5MjIxJTJDJTBBJTIwJTIwJ2xhYmVsJyUzQSUyMCdjYXInJTJDJTBBJTIwJTIwJ21hc2snJTNBJTIwJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNETCUyMHNpemUlM0Q2MTJ4NDE1JTNFJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDAuOTk5ODclMkMlMEElMjAlMjAnbGFiZWwnJTNBJTIwJ3NreSclMkMlMEElMjAlMjAnbWFzayclM0ElMjAlM0NQSUwuSW1hZ2UuSW1hZ2UlMjBpbWFnZSUyMG1vZGUlM0RMJTIwc2l6ZSUzRDYxMng0MTUlM0UlN0QlNUQ=",highlighted:`[{<span class="hljs-string">&#x27;score&#x27;</span>: 0.999981,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.999958,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.99997,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;vegetation&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.999575,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;pole&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.999958,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;building&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.999634,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;road&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.996092,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sidewalk&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.999221,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.99987,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sky&#x27;</span>,
  <span class="hljs-string">&#x27;mask&#x27;</span>: &lt;PIL.Image.Image image mode=L size=612x415&gt;}]`,wrap:!1}}),Rs=new O({props:{title:"Fine-tuning a Model for Segmentation",local:"fine-tuning-a-model-for-segmentation",headingTag:"h2"}}),ns=new Pa({props:{$$slots:{default:[Fe]},$$scope:{ctx:B}}}),zs=new O({props:{title:"Load SceneParse150 dataset",local:"load-sceneparse150-dataset",headingTag:"h3"}}),Fs=new $({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyc2NlbmVfcGFyc2VfMTUwJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTUwJTVEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;scene_parse_150&quot;</span>, split=<span class="hljs-string">&quot;train[:50]&quot;</span>)`,wrap:!1}}),Ls=new $({props:{code:"ZHMlMjAlM0QlMjBkcy50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMiklMEF0cmFpbl9kcyUyMCUzRCUyMGRzJTVCJTIydHJhaW4lMjIlNUQlMEF0ZXN0X2RzJTIwJTNEJTIwZHMlNUIlMjJ0ZXN0JTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.train_test_split(test_size=<span class="hljs-number">0.2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds = ds[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),Ps=new $({props:{code:"dHJhaW5fZHMlNUIwJTVEJTBBJTBBdHJhaW5fZHMlNUIwJTVEJTVCJTIyaW1hZ2UlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x683 at <span class="hljs-number">0x7F9B0C201F90</span>&gt;,
 <span class="hljs-string">&#x27;annotation&#x27;</span>: &lt;PIL.PngImagePlugin.PngImageFile image mode=L size=512x683 at <span class="hljs-number">0x7F9B0C201DD0</span>&gt;,
 <span class="hljs-string">&#x27;scene_category&#x27;</span>: <span class="hljs-number">368</span>}

<span class="hljs-comment"># view the image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]`,wrap:!1}}),sl=new $({props:{code:"aW1wb3J0JTIwanNvbiUwQWZyb20lMjBwYXRobGliJTIwaW1wb3J0JTIwUGF0aCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEElMEFyZXBvX2lkJTIwJTNEJTIwJTIyaHVnZ2luZ2ZhY2UlMkZsYWJlbC1maWxlcyUyMiUwQWZpbGVuYW1lJTIwJTNEJTIwJTIyYWRlMjBrLWlkMmxhYmVsLmpzb24lMjIlMEFpZDJsYWJlbCUyMCUzRCUyMGpzb24ubG9hZHMoUGF0aChoZl9odWJfZG93bmxvYWQocmVwb19pZCUyQyUyMGZpbGVuYW1lJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMikpLnJlYWRfdGV4dCgpKSUwQWlkMmxhYmVsJTIwJTNEJTIwJTdCaW50KGspJTNBJTIwdiUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpZDJsYWJlbC5pdGVtcygpJTdEJTBBbGFiZWwyaWQlMjAlM0QlMjAlN0J2JTNBJTIwayUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpZDJsYWJlbC5pdGVtcygpJTdEJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihpZDJsYWJlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;huggingface/label-files&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>filename = <span class="hljs-string">&quot;ade20k-id2label.json&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = json.loads(Path(hf_hub_download(repo_id, filename, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)).read_text())
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {<span class="hljs-built_in">int</span>(k): v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(id2label)`,wrap:!1}}),ll=new O({props:{title:"Custom dataset",local:"custom-dataset",headingTag:"h4"}}),nl=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, DatasetDict, Image

image_paths_train = [<span class="hljs-string">&quot;path/to/image_1.jpg/jpg&quot;</span>, <span class="hljs-string">&quot;path/to/image_2.jpg/jpg&quot;</span>, ..., <span class="hljs-string">&quot;path/to/image_n.jpg/jpg&quot;</span>]
label_paths_train = [<span class="hljs-string">&quot;path/to/annotation_1.png&quot;</span>, <span class="hljs-string">&quot;path/to/annotation_2.png&quot;</span>, ..., <span class="hljs-string">&quot;path/to/annotation_n.png&quot;</span>]

image_paths_validation = [...]
label_paths_validation = [...]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_dataset</span>(<span class="hljs-params">image_paths, label_paths</span>):
    dataset = Dataset.from_dict({<span class="hljs-string">&quot;image&quot;</span>: <span class="hljs-built_in">sorted</span>(image_paths),
                                <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-built_in">sorted</span>(label_paths)})
    dataset = dataset.cast_column(<span class="hljs-string">&quot;image&quot;</span>, Image())
    dataset = dataset.cast_column(<span class="hljs-string">&quot;label&quot;</span>, Image())
    <span class="hljs-keyword">return</span> dataset

<span class="hljs-comment"># step 1: create Dataset objects</span>
train_dataset = create_dataset(image_paths_train, label_paths_train)
validation_dataset = create_dataset(image_paths_validation, label_paths_validation)

<span class="hljs-comment"># step 2: create DatasetDict</span>
dataset = DatasetDict({
     <span class="hljs-string">&quot;train&quot;</span>: train_dataset,
     <span class="hljs-string">&quot;validation&quot;</span>: validation_dataset,
     }
)

<span class="hljs-comment"># step 3: push to Hub (assumes you have ran the huggingface-cli login command in a terminal/notebook)</span>
dataset.push_to_hub(<span class="hljs-string">&quot;your-name/dataset-repo&quot;</span>)

<span class="hljs-comment"># optionally, you can push to a private repo on the Hub</span>
<span class="hljs-comment"># dataset.push_to_hub(&quot;name of repo on the hub&quot;, private=True)</span>`,wrap:!1}}),pl=new $({props:{code:"aW1wb3J0JTIwanNvbiUwQSUyMyUyMHNpbXBsZSUyMGV4YW1wbGUlMEFpZDJsYWJlbCUyMCUzRCUyMCU3QjAlM0ElMjAnY2F0JyUyQyUyMDElM0ElMjAnZG9nJyU3RCUwQXdpdGglMjBvcGVuKCdpZDJsYWJlbC5qc29uJyUyQyUyMCd3JyklMjBhcyUyMGZwJTNBJTBBanNvbi5kdW1wKGlkMmxhYmVsJTJDJTIwZnAp",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-comment"># simple example</span>
id2label = {<span class="hljs-number">0</span>: <span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&#x27;dog&#x27;</span>}
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;id2label.json&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>) <span class="hljs-keyword">as</span> fp:
json.dump(id2label, fp)`,wrap:!1}}),Jl=new O({props:{title:"Preprocess",local:"preprocess",headingTag:"h3"}}),ml=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJudmlkaWElMkZtaXQtYjAlMjIlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBkb19yZWR1Y2VfbGFiZWxzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;nvidia/mit-b0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint, do_reduce_labels=<span class="hljs-literal">True</span>)`,wrap:!1}}),ps=new Us({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[Le]},$$scope:{ctx:B}}}),Ms=new Us({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[Pe]},$$scope:{ctx:B}}}),cl=new O({props:{title:"Evaluate",local:"evaluate",headingTag:"h3"}}),Tl=new $({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMm1lYW5faW91JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate

<span class="hljs-meta">&gt;&gt;&gt; </span>metric = evaluate.load(<span class="hljs-string">&quot;mean_iou&quot;</span>)`,wrap:!1}}),Js=new Us({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[Oe]},$$scope:{ctx:B}}}),rs=new Us({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[ln]},$$scope:{ctx:B}}}),yl=new O({props:{title:"Train",local:"train",headingTag:"h3"}}),ms=new Us({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[nn]},$$scope:{ctx:B}}}),cs=new Us({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[Mn]},$$scope:{ctx:B}}}),hl=new O({props:{title:"Inference",local:"inference",headingTag:"h3"}}),ul=new $({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyc2NlbmVfcGFyc2VfMTUwJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTUwJTVEJTIyKSUwQWRzJTIwJTNEJTIwZHMudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjIpJTBBdGVzdF9kcyUyMCUzRCUyMGRzJTVCJTIydGVzdCUyMiU1RCUwQWltYWdlJTIwJTNEJTIwZHMlNUIlMjJ0ZXN0JTIyJTVEJTVCMCU1RCU1QiUyMmltYWdlJTIyJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;scene_parse_150&quot;</span>, split=<span class="hljs-string">&quot;train[:50]&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.train_test_split(test_size=<span class="hljs-number">0.2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds = ds[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = ds[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),Ts=new Us({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[rn]},$$scope:{ctx:B}}}),is=new Us({props:{pytorch:!1,tensorflow:!0,jax:!1,$$slots:{tensorflow:[cn]},$$scope:{ctx:B}}}),gl=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">ade_palette</span>():
  <span class="hljs-keyword">return</span> np.asarray([
      [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">120</span>, <span class="hljs-number">120</span>, <span class="hljs-number">120</span>],
      [<span class="hljs-number">180</span>, <span class="hljs-number">120</span>, <span class="hljs-number">120</span>],
      [<span class="hljs-number">6</span>, <span class="hljs-number">230</span>, <span class="hljs-number">230</span>],
      [<span class="hljs-number">80</span>, <span class="hljs-number">50</span>, <span class="hljs-number">50</span>],
      [<span class="hljs-number">4</span>, <span class="hljs-number">200</span>, <span class="hljs-number">3</span>],
      [<span class="hljs-number">120</span>, <span class="hljs-number">120</span>, <span class="hljs-number">80</span>],
      [<span class="hljs-number">140</span>, <span class="hljs-number">140</span>, <span class="hljs-number">140</span>],
      [<span class="hljs-number">204</span>, <span class="hljs-number">5</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">230</span>, <span class="hljs-number">230</span>, <span class="hljs-number">230</span>],
      [<span class="hljs-number">4</span>, <span class="hljs-number">250</span>, <span class="hljs-number">7</span>],
      [<span class="hljs-number">224</span>, <span class="hljs-number">5</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">235</span>, <span class="hljs-number">255</span>, <span class="hljs-number">7</span>],
      [<span class="hljs-number">150</span>, <span class="hljs-number">5</span>, <span class="hljs-number">61</span>],
      [<span class="hljs-number">120</span>, <span class="hljs-number">120</span>, <span class="hljs-number">70</span>],
      [<span class="hljs-number">8</span>, <span class="hljs-number">255</span>, <span class="hljs-number">51</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">6</span>, <span class="hljs-number">82</span>],
      [<span class="hljs-number">143</span>, <span class="hljs-number">255</span>, <span class="hljs-number">140</span>],
      [<span class="hljs-number">204</span>, <span class="hljs-number">255</span>, <span class="hljs-number">4</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">51</span>, <span class="hljs-number">7</span>],
      [<span class="hljs-number">204</span>, <span class="hljs-number">70</span>, <span class="hljs-number">3</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">102</span>, <span class="hljs-number">200</span>],
      [<span class="hljs-number">61</span>, <span class="hljs-number">230</span>, <span class="hljs-number">250</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">6</span>, <span class="hljs-number">51</span>],
      [<span class="hljs-number">11</span>, <span class="hljs-number">102</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">7</span>, <span class="hljs-number">71</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">9</span>, <span class="hljs-number">224</span>],
      [<span class="hljs-number">9</span>, <span class="hljs-number">7</span>, <span class="hljs-number">230</span>],
      [<span class="hljs-number">220</span>, <span class="hljs-number">220</span>, <span class="hljs-number">220</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">9</span>, <span class="hljs-number">92</span>],
      [<span class="hljs-number">112</span>, <span class="hljs-number">9</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">8</span>, <span class="hljs-number">255</span>, <span class="hljs-number">214</span>],
      [<span class="hljs-number">7</span>, <span class="hljs-number">255</span>, <span class="hljs-number">224</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">184</span>, <span class="hljs-number">6</span>],
      [<span class="hljs-number">10</span>, <span class="hljs-number">255</span>, <span class="hljs-number">71</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">41</span>, <span class="hljs-number">10</span>],
      [<span class="hljs-number">7</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">224</span>, <span class="hljs-number">255</span>, <span class="hljs-number">8</span>],
      [<span class="hljs-number">102</span>, <span class="hljs-number">8</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">61</span>, <span class="hljs-number">6</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">194</span>, <span class="hljs-number">7</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">122</span>, <span class="hljs-number">8</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">20</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">8</span>, <span class="hljs-number">41</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">5</span>, <span class="hljs-number">153</span>],
      [<span class="hljs-number">6</span>, <span class="hljs-number">51</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">235</span>, <span class="hljs-number">12</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">160</span>, <span class="hljs-number">150</span>, <span class="hljs-number">20</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">163</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">140</span>, <span class="hljs-number">140</span>, <span class="hljs-number">140</span>],
      [<span class="hljs-number">250</span>, <span class="hljs-number">10</span>, <span class="hljs-number">15</span>],
      [<span class="hljs-number">20</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">31</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">31</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">224</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">153</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">71</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">235</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">173</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">31</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">11</span>, <span class="hljs-number">200</span>, <span class="hljs-number">200</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">82</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">245</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">61</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">112</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">133</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">163</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">102</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">194</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">143</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">51</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">82</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">41</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">173</span>],
      [<span class="hljs-number">10</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">173</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">153</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">92</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">245</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">102</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">173</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">20</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">184</span>, <span class="hljs-number">184</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">31</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">61</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">71</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">204</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">194</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">82</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">10</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">112</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">51</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">194</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">122</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">163</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">153</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">10</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">112</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">143</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">82</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">163</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">235</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">8</span>, <span class="hljs-number">184</span>, <span class="hljs-number">170</span>],
      [<span class="hljs-number">133</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">92</span>],
      [<span class="hljs-number">184</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">31</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">184</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">214</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">112</span>],
      [<span class="hljs-number">92</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">224</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">112</span>, <span class="hljs-number">224</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">70</span>, <span class="hljs-number">184</span>, <span class="hljs-number">160</span>],
      [<span class="hljs-number">163</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">153</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">71</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">163</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">204</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">143</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">235</span>],
      [<span class="hljs-number">133</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">235</span>],
      [<span class="hljs-number">245</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">122</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">245</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">10</span>, <span class="hljs-number">190</span>, <span class="hljs-number">212</span>],
      [<span class="hljs-number">214</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">204</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">20</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">153</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">41</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">204</span>],
      [<span class="hljs-number">41</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">41</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">173</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">245</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">71</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">122</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">184</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">92</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">184</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">0</span>, <span class="hljs-number">133</span>, <span class="hljs-number">255</span>],
      [<span class="hljs-number">255</span>, <span class="hljs-number">214</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">25</span>, <span class="hljs-number">194</span>, <span class="hljs-number">194</span>],
      [<span class="hljs-number">102</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
      [<span class="hljs-number">92</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
  ])`,wrap:!1}}),dl=new $({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQWNvbG9yX3NlZyUyMCUzRCUyMG5wLnplcm9zKChwcmVkX3NlZy5zaGFwZSU1QjAlNUQlMkMlMjBwcmVkX3NlZy5zaGFwZSU1QjElNUQlMkMlMjAzKSUyQyUyMGR0eXBlJTNEbnAudWludDgpJTBBcGFsZXR0ZSUyMCUzRCUyMG5wLmFycmF5KGFkZV9wYWxldHRlKCkpJTBBZm9yJTIwbGFiZWwlMkMlMjBjb2xvciUyMGluJTIwZW51bWVyYXRlKHBhbGV0dGUpJTNBJTBBJTIwJTIwJTIwJTIwY29sb3Jfc2VnJTVCcHJlZF9zZWclMjAlM0QlM0QlMjBsYWJlbCUyQyUyMCUzQSU1RCUyMCUzRCUyMGNvbG9yJTBBY29sb3Jfc2VnJTIwJTNEJTIwY29sb3Jfc2VnJTVCLi4uJTJDJTIwJTNBJTNBLTElNUQlMjAlMjAlMjMlMjBjb252ZXJ0JTIwdG8lMjBCR1IlMEElMEFpbWclMjAlM0QlMjBucC5hcnJheShpbWFnZSklMjAqJTIwMC41JTIwJTJCJTIwY29sb3Jfc2VnJTIwKiUyMDAuNSUyMCUyMCUyMyUyMHBsb3QlMjB0aGUlMjBpbWFnZSUyMHdpdGglMjB0aGUlMjBzZWdtZW50YXRpb24lMjBtYXAlMEFpbWclMjAlM0QlMjBpbWcuYXN0eXBlKG5wLnVpbnQ4KSUwQSUwQXBsdC5maWd1cmUoZmlnc2l6ZSUzRCgxNSUyQyUyMDEwKSklMEFwbHQuaW1zaG93KGltZyklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>color_seg = np.zeros((pred_seg.shape[<span class="hljs-number">0</span>], pred_seg.shape[<span class="hljs-number">1</span>], <span class="hljs-number">3</span>), dtype=np.uint8)
<span class="hljs-meta">&gt;&gt;&gt; </span>palette = np.array(ade_palette())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> label, color <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(palette):
<span class="hljs-meta">... </span>    color_seg[pred_seg == label, :] = color
<span class="hljs-meta">&gt;&gt;&gt; </span>color_seg = color_seg[..., ::-<span class="hljs-number">1</span>]  <span class="hljs-comment"># convert to BGR</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>img = np.array(image) * <span class="hljs-number">0.5</span> + color_seg * <span class="hljs-number">0.5</span>  <span class="hljs-comment"># plot the image with the segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img = img.astype(np.uint8)

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure(figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(img)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),fl=new Xe({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/semantic_segmentation.md"}}),{c(){t=j("meta"),c=M(),n=j("p"),r=M(),i(I.$$.fragment),A=M(),i(W.$$.fragment),N=M(),i(C.$$.fragment),Z=M(),k=j("p"),k.textContent=_,Q=M(),f=j("p"),f.textContent=G,p=M(),b=j("ol"),b.innerHTML=D,g=M(),V=j("p"),V.textContent=d,E=M(),i(v.$$.fragment),Y=M(),H=j("p"),H.textContent=us,S=M(),i(z.$$.fragment),X=M(),i(L.$$.fragment),P=M(),R=j("p"),R.textContent=bs,F=M(),i(q.$$.fragment),K=M(),m=j("div"),m.innerHTML=x,gs=M(),Is=j("p"),Is.innerHTML=Ka,xl=M(),i(ds.$$.fragment),Wl=M(),fs=j("p"),fs.textContent=Oa,El=M(),i(Cs.$$.fragment),Zl=M(),As=j("p"),As.textContent=se,_l=M(),i(ks.$$.fragment),Vl=M(),ls=j("div"),ls.innerHTML=le,Gl=M(),$s=j("p"),$s.innerHTML=ae,Dl=M(),i(Bs.$$.fragment),vl=M(),Ns=j("p"),Ns.textContent=ee,Rl=M(),i(Qs.$$.fragment),Yl=M(),xs=j("p"),xs.textContent=ne,Sl=M(),i(Ws.$$.fragment),zl=M(),as=j("div"),as.innerHTML=te,Xl=M(),Es=j("p"),Es.innerHTML=pe,Fl=M(),i(Zs.$$.fragment),Hl=M(),_s=j("p"),_s.textContent=Me,Ll=M(),i(Vs.$$.fragment),ql=M(),Gs=j("p"),Gs.textContent=Je,Pl=M(),es=j("div"),es.innerHTML=re,Kl=M(),Ds=j("p"),Ds.textContent=me,Ol=M(),vs=j("p"),vs.textContent=ce,sa=M(),i(Rs.$$.fragment),la=M(),Ys=j("p"),Ys.textContent=je,aa=M(),Ss=j("ol"),Ss.innerHTML=Te,ea=M(),i(ns.$$.fragment),na=M(),i(zs.$$.fragment),ta=M(),Xs=j("p"),Xs.textContent=ie,pa=M(),i(Fs.$$.fragment),Ma=M(),Hs=j("p"),Hs.innerHTML=oe,Ja=M(),i(Ls.$$.fragment),ra=M(),qs=j("p"),qs.textContent=ye,ma=M(),i(Ps.$$.fragment),ca=M(),Ks=j("ul"),Ks.innerHTML=he,ja=M(),Os=j("p"),Os.innerHTML=Ue,Ta=M(),i(sl.$$.fragment),ia=M(),i(ll.$$.fragment),oa=M(),al=j("p"),al.innerHTML=we,ya=M(),ts=j("ol"),el=j("li"),$l=j("p"),$l.innerHTML=ue,Ha=M(),i(nl.$$.fragment),La=M(),tl=j("li"),Bl=j("p"),Bl.textContent=be,qa=M(),i(pl.$$.fragment),ha=M(),Ml=j("p"),Ml.innerHTML=ge,Ua=M(),i(Jl.$$.fragment),wa=M(),rl=j("p"),rl.innerHTML=Ie,ua=M(),i(ml.$$.fragment),ba=M(),i(ps.$$.fragment),ga=M(),i(Ms.$$.fragment),Ia=M(),i(cl.$$.fragment),da=M(),jl=j("p"),jl.innerHTML=de,fa=M(),i(Tl.$$.fragment),Ca=M(),il=j("p"),il.innerHTML=fe,Aa=M(),i(Js.$$.fragment),ka=M(),i(rs.$$.fragment),$a=M(),ol=j("p"),ol.innerHTML=Ce,Ba=M(),i(yl.$$.fragment),Na=M(),i(ms.$$.fragment),Qa=M(),i(cs.$$.fragment),xa=M(),i(hl.$$.fragment),Wa=M(),Ul=j("p"),Ul.textContent=Ae,Ea=M(),wl=j("p"),wl.textContent=ke,Za=M(),i(ul.$$.fragment),_a=M(),js=j("div"),js.innerHTML=$e,Va=M(),i(Ts.$$.fragment),Ga=M(),i(is.$$.fragment),Da=M(),bl=j("p"),bl.innerHTML=Be,va=M(),i(gl.$$.fragment),Ra=M(),Il=j("p"),Il.textContent=Ne,Ya=M(),i(dl.$$.fragment),Sa=M(),os=j("div"),os.innerHTML=Qe,za=M(),i(fl.$$.fragment),Xa=M(),Nl=j("p"),this.h()},l(s){const e=Ye("svelte-u9bgzb",document.head);t=T(e,"META",{name:!0,content:!0}),e.forEach(l),c=J(s),n=T(s,"P",{}),Ql(n).forEach(l),r=J(s),o(I.$$.fragment,s),A=J(s),o(W.$$.fragment,s),N=J(s),o(C.$$.fragment,s),Z=J(s),k=T(s,"P",{"data-svelte-h":!0}),u(k)!=="svelte-i2v9l4"&&(k.textContent=_),Q=J(s),f=T(s,"P",{"data-svelte-h":!0}),u(f)!=="svelte-1ad2x5z"&&(f.textContent=G),p=J(s),b=T(s,"OL",{"data-svelte-h":!0}),u(b)!=="svelte-phis9l"&&(b.innerHTML=D),g=J(s),V=T(s,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1c9nexd"&&(V.textContent=d),E=J(s),o(v.$$.fragment,s),Y=J(s),H=T(s,"P",{"data-svelte-h":!0}),u(H)!=="svelte-27hn0u"&&(H.textContent=us),S=J(s),o(z.$$.fragment,s),X=J(s),o(L.$$.fragment,s),P=J(s),R=T(s,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1uhznwp"&&(R.textContent=bs),F=J(s),o(q.$$.fragment,s),K=J(s),m=T(s,"DIV",{class:!0,"data-svelte-h":!0}),u(m)!=="svelte-xdljqs"&&(m.innerHTML=x),gs=J(s),Is=T(s,"P",{"data-svelte-h":!0}),u(Is)!=="svelte-1auudos"&&(Is.innerHTML=Ka),xl=J(s),o(ds.$$.fragment,s),Wl=J(s),fs=T(s,"P",{"data-svelte-h":!0}),u(fs)!=="svelte-qumeg4"&&(fs.textContent=Oa),El=J(s),o(Cs.$$.fragment,s),Zl=J(s),As=T(s,"P",{"data-svelte-h":!0}),u(As)!=="svelte-55zn24"&&(As.textContent=se),_l=J(s),o(ks.$$.fragment,s),Vl=J(s),ls=T(s,"DIV",{class:!0,"data-svelte-h":!0}),u(ls)!=="svelte-v81gtv"&&(ls.innerHTML=le),Gl=J(s),$s=T(s,"P",{"data-svelte-h":!0}),u($s)!=="svelte-11nij9p"&&($s.innerHTML=ae),Dl=J(s),o(Bs.$$.fragment,s),vl=J(s),Ns=T(s,"P",{"data-svelte-h":!0}),u(Ns)!=="svelte-iszmk4"&&(Ns.textContent=ee),Rl=J(s),o(Qs.$$.fragment,s),Yl=J(s),xs=T(s,"P",{"data-svelte-h":!0}),u(xs)!=="svelte-76cxem"&&(xs.textContent=ne),Sl=J(s),o(Ws.$$.fragment,s),zl=J(s),as=T(s,"DIV",{class:!0,"data-svelte-h":!0}),u(as)!=="svelte-9fwyws"&&(as.innerHTML=te),Xl=J(s),Es=T(s,"P",{"data-svelte-h":!0}),u(Es)!=="svelte-1oc30s7"&&(Es.innerHTML=pe),Fl=J(s),o(Zs.$$.fragment,s),Hl=J(s),_s=T(s,"P",{"data-svelte-h":!0}),u(_s)!=="svelte-13r9j62"&&(_s.textContent=Me),Ll=J(s),o(Vs.$$.fragment,s),ql=J(s),Gs=T(s,"P",{"data-svelte-h":!0}),u(Gs)!=="svelte-knvn6c"&&(Gs.textContent=Je),Pl=J(s),es=T(s,"DIV",{class:!0,"data-svelte-h":!0}),u(es)!=="svelte-6p9cmp"&&(es.innerHTML=re),Kl=J(s),Ds=T(s,"P",{"data-svelte-h":!0}),u(Ds)!=="svelte-1j96k2e"&&(Ds.textContent=me),Ol=J(s),vs=T(s,"P",{"data-svelte-h":!0}),u(vs)!=="svelte-1bguxrb"&&(vs.textContent=ce),sa=J(s),o(Rs.$$.fragment,s),la=J(s),Ys=T(s,"P",{"data-svelte-h":!0}),u(Ys)!=="svelte-7mxw3i"&&(Ys.textContent=je),aa=J(s),Ss=T(s,"OL",{"data-svelte-h":!0}),u(Ss)!=="svelte-ofzxxl"&&(Ss.innerHTML=Te),ea=J(s),o(ns.$$.fragment,s),na=J(s),o(zs.$$.fragment,s),ta=J(s),Xs=T(s,"P",{"data-svelte-h":!0}),u(Xs)!=="svelte-ldhwp2"&&(Xs.textContent=ie),pa=J(s),o(Fs.$$.fragment,s),Ma=J(s),Hs=T(s,"P",{"data-svelte-h":!0}),u(Hs)!=="svelte-rugbz4"&&(Hs.innerHTML=oe),Ja=J(s),o(Ls.$$.fragment,s),ra=J(s),qs=T(s,"P",{"data-svelte-h":!0}),u(qs)!=="svelte-1m91ua0"&&(qs.textContent=ye),ma=J(s),o(Ps.$$.fragment,s),ca=J(s),Ks=T(s,"UL",{"data-svelte-h":!0}),u(Ks)!=="svelte-1gb3b0f"&&(Ks.innerHTML=he),ja=J(s),Os=T(s,"P",{"data-svelte-h":!0}),u(Os)!=="svelte-j46pio"&&(Os.innerHTML=Ue),Ta=J(s),o(sl.$$.fragment,s),ia=J(s),o(ll.$$.fragment,s),oa=J(s),al=T(s,"P",{"data-svelte-h":!0}),u(al)!=="svelte-1j7tkla"&&(al.innerHTML=we),ya=J(s),ts=T(s,"OL",{});var Cl=Ql(ts);el=T(Cl,"LI",{});var Al=Ql(el);$l=T(Al,"P",{"data-svelte-h":!0}),u($l)!=="svelte-137f4ce"&&($l.innerHTML=ue),Ha=J(Al),o(nl.$$.fragment,Al),Al.forEach(l),La=J(Cl),tl=T(Cl,"LI",{});var kl=Ql(tl);Bl=T(kl,"P",{"data-svelte-h":!0}),u(Bl)!=="svelte-1je4dsn"&&(Bl.textContent=be),qa=J(kl),o(pl.$$.fragment,kl),kl.forEach(l),Cl.forEach(l),ha=J(s),Ml=T(s,"P",{"data-svelte-h":!0}),u(Ml)!=="svelte-1k7ggj5"&&(Ml.innerHTML=ge),Ua=J(s),o(Jl.$$.fragment,s),wa=J(s),rl=T(s,"P",{"data-svelte-h":!0}),u(rl)!=="svelte-1wntzlt"&&(rl.innerHTML=Ie),ua=J(s),o(ml.$$.fragment,s),ba=J(s),o(ps.$$.fragment,s),ga=J(s),o(Ms.$$.fragment,s),Ia=J(s),o(cl.$$.fragment,s),da=J(s),jl=T(s,"P",{"data-svelte-h":!0}),u(jl)!=="svelte-vg2xml"&&(jl.innerHTML=de),fa=J(s),o(Tl.$$.fragment,s),Ca=J(s),il=T(s,"P",{"data-svelte-h":!0}),u(il)!=="svelte-aq72n8"&&(il.innerHTML=fe),Aa=J(s),o(Js.$$.fragment,s),ka=J(s),o(rs.$$.fragment,s),$a=J(s),ol=T(s,"P",{"data-svelte-h":!0}),u(ol)!=="svelte-183aynn"&&(ol.innerHTML=Ce),Ba=J(s),o(yl.$$.fragment,s),Na=J(s),o(ms.$$.fragment,s),Qa=J(s),o(cs.$$.fragment,s),xa=J(s),o(hl.$$.fragment,s),Wa=J(s),Ul=T(s,"P",{"data-svelte-h":!0}),u(Ul)!=="svelte-633ppb"&&(Ul.textContent=Ae),Ea=J(s),wl=T(s,"P",{"data-svelte-h":!0}),u(wl)!=="svelte-13x04z1"&&(wl.textContent=ke),Za=J(s),o(ul.$$.fragment,s),_a=J(s),js=T(s,"DIV",{class:!0,"data-svelte-h":!0}),u(js)!=="svelte-11jfm1f"&&(js.innerHTML=$e),Va=J(s),o(Ts.$$.fragment,s),Ga=J(s),o(is.$$.fragment,s),Da=J(s),bl=T(s,"P",{"data-svelte-h":!0}),u(bl)!=="svelte-9v6c94"&&(bl.innerHTML=Be),va=J(s),o(gl.$$.fragment,s),Ra=J(s),Il=T(s,"P",{"data-svelte-h":!0}),u(Il)!=="svelte-93zsmv"&&(Il.textContent=Ne),Ya=J(s),o(dl.$$.fragment,s),Sa=J(s),os=T(s,"DIV",{class:!0,"data-svelte-h":!0}),u(os)!=="svelte-nsecok"&&(os.innerHTML=Qe),za=J(s),o(fl.$$.fragment,s),Xa=J(s),Nl=T(s,"P",{}),Ql(Nl).forEach(l),this.h()},h(){ys(t,"name","hf:doc:metadata"),ys(t,"content",Tn),ys(m,"class","flex justify-center"),ys(ls,"class","flex justify-center"),ys(as,"class","flex justify-center"),ys(es,"class","flex justify-center"),ys(js,"class","flex justify-center"),ys(os,"class","flex justify-center")},m(s,e){hs(document.head,t),a(s,c,e),a(s,n,e),a(s,r,e),y(I,s,e),a(s,A,e),y(W,s,e),a(s,N,e),y(C,s,e),a(s,Z,e),a(s,k,e),a(s,Q,e),a(s,f,e),a(s,p,e),a(s,b,e),a(s,g,e),a(s,V,e),a(s,E,e),y(v,s,e),a(s,Y,e),a(s,H,e),a(s,S,e),y(z,s,e),a(s,X,e),y(L,s,e),a(s,P,e),a(s,R,e),a(s,F,e),y(q,s,e),a(s,K,e),a(s,m,e),a(s,gs,e),a(s,Is,e),a(s,xl,e),y(ds,s,e),a(s,Wl,e),a(s,fs,e),a(s,El,e),y(Cs,s,e),a(s,Zl,e),a(s,As,e),a(s,_l,e),y(ks,s,e),a(s,Vl,e),a(s,ls,e),a(s,Gl,e),a(s,$s,e),a(s,Dl,e),y(Bs,s,e),a(s,vl,e),a(s,Ns,e),a(s,Rl,e),y(Qs,s,e),a(s,Yl,e),a(s,xs,e),a(s,Sl,e),y(Ws,s,e),a(s,zl,e),a(s,as,e),a(s,Xl,e),a(s,Es,e),a(s,Fl,e),y(Zs,s,e),a(s,Hl,e),a(s,_s,e),a(s,Ll,e),y(Vs,s,e),a(s,ql,e),a(s,Gs,e),a(s,Pl,e),a(s,es,e),a(s,Kl,e),a(s,Ds,e),a(s,Ol,e),a(s,vs,e),a(s,sa,e),y(Rs,s,e),a(s,la,e),a(s,Ys,e),a(s,aa,e),a(s,Ss,e),a(s,ea,e),y(ns,s,e),a(s,na,e),y(zs,s,e),a(s,ta,e),a(s,Xs,e),a(s,pa,e),y(Fs,s,e),a(s,Ma,e),a(s,Hs,e),a(s,Ja,e),y(Ls,s,e),a(s,ra,e),a(s,qs,e),a(s,ma,e),y(Ps,s,e),a(s,ca,e),a(s,Ks,e),a(s,ja,e),a(s,Os,e),a(s,Ta,e),y(sl,s,e),a(s,ia,e),y(ll,s,e),a(s,oa,e),a(s,al,e),a(s,ya,e),a(s,ts,e),hs(ts,el),hs(el,$l),hs(el,Ha),y(nl,el,null),hs(ts,La),hs(ts,tl),hs(tl,Bl),hs(tl,qa),y(pl,tl,null),a(s,ha,e),a(s,Ml,e),a(s,Ua,e),y(Jl,s,e),a(s,wa,e),a(s,rl,e),a(s,ua,e),y(ml,s,e),a(s,ba,e),y(ps,s,e),a(s,ga,e),y(Ms,s,e),a(s,Ia,e),y(cl,s,e),a(s,da,e),a(s,jl,e),a(s,fa,e),y(Tl,s,e),a(s,Ca,e),a(s,il,e),a(s,Aa,e),y(Js,s,e),a(s,ka,e),y(rs,s,e),a(s,$a,e),a(s,ol,e),a(s,Ba,e),y(yl,s,e),a(s,Na,e),y(ms,s,e),a(s,Qa,e),y(cs,s,e),a(s,xa,e),y(hl,s,e),a(s,Wa,e),a(s,Ul,e),a(s,Ea,e),a(s,wl,e),a(s,Za,e),y(ul,s,e),a(s,_a,e),a(s,js,e),a(s,Va,e),y(Ts,s,e),a(s,Ga,e),y(is,s,e),a(s,Da,e),a(s,bl,e),a(s,va,e),y(gl,s,e),a(s,Ra,e),a(s,Il,e),a(s,Ya,e),y(dl,s,e),a(s,Sa,e),a(s,os,e),a(s,za,e),y(fl,s,e),a(s,Xa,e),a(s,Nl,e),Fa=!0},p(s,[e]){const Cl={};e&2&&(Cl.$$scope={dirty:e,ctx:s}),ns.$set(Cl);const Al={};e&2&&(Al.$$scope={dirty:e,ctx:s}),ps.$set(Al);const kl={};e&2&&(kl.$$scope={dirty:e,ctx:s}),Ms.$set(kl);const xe={};e&2&&(xe.$$scope={dirty:e,ctx:s}),Js.$set(xe);const We={};e&2&&(We.$$scope={dirty:e,ctx:s}),rs.$set(We);const Ee={};e&2&&(Ee.$$scope={dirty:e,ctx:s}),ms.$set(Ee);const Ze={};e&2&&(Ze.$$scope={dirty:e,ctx:s}),cs.$set(Ze);const _e={};e&2&&(_e.$$scope={dirty:e,ctx:s}),Ts.$set(_e);const Ve={};e&2&&(Ve.$$scope={dirty:e,ctx:s}),is.$set(Ve)},i(s){Fa||(h(I.$$.fragment,s),h(W.$$.fragment,s),h(C.$$.fragment,s),h(v.$$.fragment,s),h(z.$$.fragment,s),h(L.$$.fragment,s),h(q.$$.fragment,s),h(ds.$$.fragment,s),h(Cs.$$.fragment,s),h(ks.$$.fragment,s),h(Bs.$$.fragment,s),h(Qs.$$.fragment,s),h(Ws.$$.fragment,s),h(Zs.$$.fragment,s),h(Vs.$$.fragment,s),h(Rs.$$.fragment,s),h(ns.$$.fragment,s),h(zs.$$.fragment,s),h(Fs.$$.fragment,s),h(Ls.$$.fragment,s),h(Ps.$$.fragment,s),h(sl.$$.fragment,s),h(ll.$$.fragment,s),h(nl.$$.fragment,s),h(pl.$$.fragment,s),h(Jl.$$.fragment,s),h(ml.$$.fragment,s),h(ps.$$.fragment,s),h(Ms.$$.fragment,s),h(cl.$$.fragment,s),h(Tl.$$.fragment,s),h(Js.$$.fragment,s),h(rs.$$.fragment,s),h(yl.$$.fragment,s),h(ms.$$.fragment,s),h(cs.$$.fragment,s),h(hl.$$.fragment,s),h(ul.$$.fragment,s),h(Ts.$$.fragment,s),h(is.$$.fragment,s),h(gl.$$.fragment,s),h(dl.$$.fragment,s),h(fl.$$.fragment,s),Fa=!0)},o(s){U(I.$$.fragment,s),U(W.$$.fragment,s),U(C.$$.fragment,s),U(v.$$.fragment,s),U(z.$$.fragment,s),U(L.$$.fragment,s),U(q.$$.fragment,s),U(ds.$$.fragment,s),U(Cs.$$.fragment,s),U(ks.$$.fragment,s),U(Bs.$$.fragment,s),U(Qs.$$.fragment,s),U(Ws.$$.fragment,s),U(Zs.$$.fragment,s),U(Vs.$$.fragment,s),U(Rs.$$.fragment,s),U(ns.$$.fragment,s),U(zs.$$.fragment,s),U(Fs.$$.fragment,s),U(Ls.$$.fragment,s),U(Ps.$$.fragment,s),U(sl.$$.fragment,s),U(ll.$$.fragment,s),U(nl.$$.fragment,s),U(pl.$$.fragment,s),U(Jl.$$.fragment,s),U(ml.$$.fragment,s),U(ps.$$.fragment,s),U(Ms.$$.fragment,s),U(cl.$$.fragment,s),U(Tl.$$.fragment,s),U(Js.$$.fragment,s),U(rs.$$.fragment,s),U(yl.$$.fragment,s),U(ms.$$.fragment,s),U(cs.$$.fragment,s),U(hl.$$.fragment,s),U(ul.$$.fragment,s),U(Ts.$$.fragment,s),U(is.$$.fragment,s),U(gl.$$.fragment,s),U(dl.$$.fragment,s),U(fl.$$.fragment,s),Fa=!1},d(s){s&&(l(c),l(n),l(r),l(A),l(N),l(Z),l(k),l(Q),l(f),l(p),l(b),l(g),l(V),l(E),l(Y),l(H),l(S),l(X),l(P),l(R),l(F),l(K),l(m),l(gs),l(Is),l(xl),l(Wl),l(fs),l(El),l(Zl),l(As),l(_l),l(Vl),l(ls),l(Gl),l($s),l(Dl),l(vl),l(Ns),l(Rl),l(Yl),l(xs),l(Sl),l(zl),l(as),l(Xl),l(Es),l(Fl),l(Hl),l(_s),l(Ll),l(ql),l(Gs),l(Pl),l(es),l(Kl),l(Ds),l(Ol),l(vs),l(sa),l(la),l(Ys),l(aa),l(Ss),l(ea),l(na),l(ta),l(Xs),l(pa),l(Ma),l(Hs),l(Ja),l(ra),l(qs),l(ma),l(ca),l(Ks),l(ja),l(Os),l(Ta),l(ia),l(oa),l(al),l(ya),l(ts),l(ha),l(Ml),l(Ua),l(wa),l(rl),l(ua),l(ba),l(ga),l(Ia),l(da),l(jl),l(fa),l(Ca),l(il),l(Aa),l(ka),l($a),l(ol),l(Ba),l(Na),l(Qa),l(xa),l(Wa),l(Ul),l(Ea),l(wl),l(Za),l(_a),l(js),l(Va),l(Ga),l(Da),l(bl),l(va),l(Ra),l(Il),l(Ya),l(Sa),l(os),l(za),l(Xa),l(Nl)),l(t),w(I,s),w(W,s),w(C,s),w(v,s),w(z,s),w(L,s),w(q,s),w(ds,s),w(Cs,s),w(ks,s),w(Bs,s),w(Qs,s),w(Ws,s),w(Zs,s),w(Vs,s),w(Rs,s),w(ns,s),w(zs,s),w(Fs,s),w(Ls,s),w(Ps,s),w(sl,s),w(ll,s),w(nl),w(pl),w(Jl,s),w(ml,s),w(ps,s),w(Ms,s),w(cl,s),w(Tl,s),w(Js,s),w(rs,s),w(yl,s),w(ms,s),w(cs,s),w(hl,s),w(ul,s),w(Ts,s),w(is,s),w(gl,s),w(dl,s),w(fl,s)}}}const Tn='{"title":"Image Segmentation","local":"image-segmentation","sections":[{"title":"Types of Segmentation","local":"types-of-segmentation","sections":[],"depth":2},{"title":"Fine-tuning a Model for Segmentation","local":"fine-tuning-a-model-for-segmentation","sections":[{"title":"Load SceneParse150 dataset","local":"load-sceneparse150-dataset","sections":[{"title":"Custom dataset","local":"custom-dataset","sections":[],"depth":4}],"depth":3},{"title":"Preprocess","local":"preprocess","sections":[],"depth":3},{"title":"Evaluate","local":"evaluate","sections":[],"depth":3},{"title":"Train","local":"train","sections":[],"depth":3},{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2}],"depth":1}';function on(B){return De(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dn extends ve{constructor(t){super(),Re(this,t,on,jn,Ge,{})}}export{dn as component};
