import{s as Jt,n as ct,o as dt}from"../chunks/scheduler.7da89386.js";import{S as mt,i as wt,g as n,s,r,A as Ct,h as a,f as t,c as i,j as Ut,u as y,x as o,k as Tt,y as ut,a as M,v as p,d as U,t as T,w as J}from"../chunks/index.0b7befd3.js";import{C as c}from"../chunks/CodeBlock.c5b6371f.js";import{H as d,E as jt}from"../chunks/getInferenceSnippets.21ba2220.js";function It(_l){let m,be,he,ge,w,ke,C,Sl=`A kernel can provide layers in addition to kernel functions. A layer from
the Hub can replace the <code>forward</code> method of an existing layer for a certain
device type. This makes it possible to provide more performant kernels for
existing layers.`,$e,u,Zl=`See <a href="kernel-requirements.md">Kernel requirements</a> for more information on the
requirements of Hub layers.`,Ee,j,Re,I,ve,f,Gl=`A layer can be made extensible with the <code>use_kernel_forward_from_hub</code>
decorator. For example:`,Ne,h,Be,A,Wl=`The decorator does not change the behavior of the class — it annotates
the class with the given name (here <code>SiluAndMul</code>). The <code>kernelize</code> function
described below uses this name to look up kernels for the layer.`,_e,b,Se,g,Ll=`An existing layer that does not (yet) have the <code>use_kernel_forward_from_hub</code>
decorator can be made extensible using the <code>replace_kernel_forward_from_hub</code>
function:`,Ze,k,Ge,$,Ql=`<strong>Warning:</strong> we strongly recommend using layers with a decorator, since
it signifies that the maintainer intends to keep the <code>forward</code> signature
compatible with layers from the hub.`,We,E,Le,R,Hl=`A model will not use Hub kernels by default, even if it contains extensible
layers. To enable the use of Hub kernels in the model, it needs to be
‘kernelized’ using the <code>kernelize</code> function. This function traverses the
model graph and replaces the <code>forward</code> methods of extensible layers for which
Hub kernels are registered. <code>kernelize</code> can be used as follows:`,Qe,v,He,N,Vl=`The <code>kernelize</code> function modifies the model in-place, the model itself is
returned as a convenience. The <code>mode</code> specifies that the model will be used
in inference. Similarly, you can ask <code>kernelize</code> to prepare the model for
training:`,Ve,B,xe,_,xl=`A model that is kernelized for training can also be used for inference, but
not the other way around. If you want to change the mode of the kernelized
model, you can just run <code>kernelize</code> on the model again with the new mode.`,Xe,S,Xl=`If you want to compile a model with <code>torch.compile</code>, this should be indicated
in the mode as well. You can do this by combining <code>Mode.INFERENCE</code> or
<code>Mode.TRAINING</code> with <code>Mode.TORCH_COMPILE</code> using the set union (<code>|</code>) operator:`,Fe,Z,qe,G,ze,W,Fl=`Kernels can be registered per device type. For instance, separate <code>cuda</code> and
<code>metal</code> kernels could be registered for the name <code>SiluAndMul</code>. By default,
<code>kernelize</code> will try to infer the device type from the model’s parameters.
You can pass the device type to <code>kernelize</code> if the device type cannot be
inferred (e.g. because the model has no parameters):`,Ye,L,Pe,Q,Oe,H,ql=`If the <code>TRAINING</code> and/or <code>TORCH_COMPILE</code> modes are used, but a registered
kernel does not support backward passes or <code>torch.compile</code> respectively,
<code>kernelize</code> will fall back to the original, non-kernelized, layer. You
can let <code>kernelize</code> raise an exception instead by using <code>use_fallback=False</code>:`,Ke,V,De,x,zl="This can be useful if you want to guarantee that Hub kernels are used.",el,X,ll,F,Yl=`The kernels that are used are logged at the <code>INFO</code> level by <code>kernelize</code>.
See the <a href="https://docs.python.org/3/library/logging.html" rel="nofollow">Python logging</a>
documentation for information on how to configure logging.`,tl,q,Ml,z,Pl=`<code>kernelize</code> relies on kernel mappings to find Hub kernels for layers.
Kernel mappings map a kernel name such as <code>SiluAndMul</code> to a kernel on
the Hub. For example:`,sl,Y,il,P,Ol="You can register such a mapping using <code>register_kernel_mapping</code>:",nl,O,al,K,Kl=`This will register the kernel mapping in the current context, which is
normally global. It is recommended to scope the mapping to where it is
used with the <code>use_kernel_mapping</code> context manager:`,rl,D,yl,ee,Dl=`This ensures that the mapping is not active anymore outside the
<code>with</code>-scope.`,ol,le,pl,te,et=`Kernels are versioned using tags of the form <code>v&lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;</code>.
You can specify which version of the kernel to download using Python version
specifiers:`,Ul,Me,Tl,se,lt=`This will get the layer from latest kernel tagged <code>v0.0.z</code> where <code>z</code> is at
least 4. It is strongly recommended to specify a version bound, since a
kernel author might push incompatible changes to the <code>main</code> branch.`,Jl,ie,cl,ne,tt=`You might want to register two different kernels for a particular layer,
where one kernel is optimized for a specific mode. You can do so by
registering layer repositories for specific modes. For example:`,dl,ae,ml,re,Mt=`The <code>kernelize</code> function will attempt to use the following registered
kernels for a given mode:`,wl,ye,st=`<li><code>INFERENCE</code>: <code>INFERENCE</code> → <code>INFERENCE | TORCH_COMPILE</code> → <code>TRAINING</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>INFERENCE | TORCH_COMPILE</code>: <code>INFERENCE | TORCH_COMPILE</code> →
<code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING</code>: <code>TRAINING</code> → <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li> <li><code>TRAINING | TORCH_COMPILE</code>: <code>TRAINING | TORCH_COMPILE</code> → <code>FALLBACK</code></li>`,Cl,oe,it=`<code>Mode.FALLBACK</code> is a special mode that is used when no other mode matches. It
is also used when a kernel is registered without a mode, as described in the
previous section.`,ul,pe,jl,Ue,nt=`In this case, both <code>Mode.INFERENCE | Mode.TORCH_COMPILE</code> and
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> will use the <code>Mode.FALLBACK</code> kernel,
since the other kernels do not support <code>torch.compile</code>.`,Il,Te,fl,Je,at=`Some kernels only work with newer CUDA architectures. For instance, some
kernels require capability 9.0 for the TMA unit on Hopper GPUs. <code>kernels</code>
supports registering layers for a range of CUDA capabilities. To do so,
you need to register the layer for a <code>Device</code> with type <code>cuda</code> and
set the supported range of CUDA capabilities with using <code>CUDAProperties</code>:`,hl,ce,Al,de,rt="Capabilities behave as follows:",bl,me,yt=`<li><p>The minimum and maximum capabilities are inclusive.</p></li> <li><p>When a new kernel is registered with the same min/max capabilities as
an existing kernel, the new kernel will replace the old kernel.</p></li> <li><p>When there are multiple kernels that support a capability, the kernel
with the smaller capability interval will be used. E.g. given:</p> <ul><li><code>KernelA</code> with <code>min_capability=80</code> and <code>max_capability=89</code>;</li> <li><code>KernelB</code> with <code>min_capability=75</code> and <code>max_capability=89</code>;</li> <li><code>kernelize</code> runs on a system with capability 8.6.</li></ul> <p>Then <code>KernelA</code> will be used because the interval 80..89 is smaller
than 75..89. The motivation is that kernels with smaller ranges
tend to be more optimized for a specific set of GPUs. <strong>This behavior
might still change in the future.</strong></p></li>`,gl,we,kl,Ce,ot=`Registering kernels for the ROCm architecture follows the exact same
pattern as CUDA kernels, using <code>min_capability</code> and <code>max_capability</code> to restrict
a kernel to a range of ROCm capabilities.`,$l,ue,El,je,pt=`The <code>LocalLayerRepository</code> class is provided to load a repository from
a local directory. For example:`,Rl,Ie,vl,fe,Nl,Ae,Bl;return w=new d({props:{title:"Layers",local:"layers",headingTag:"h1"}}),j=new d({props:{title:"Making a layer extensible with kernels from the hub",local:"making-a-layer-extensible-with-kernels-from-the-hub",headingTag:"h2"}}),I=new d({props:{title:"Using a decorator",local:"using-a-decorator",headingTag:"h3"}}),h=new c({props:{code:"JTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBpbnB1dCUzQSUyMHRvcmNoLlRlbnNvciklMjAtJTNFJTIwdG9yY2guVGVuc29yJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZCUyMCUzRCUyMGlucHV0LnNoYXBlJTVCLTElNUQlMjAlMkYlMkYlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zaWx1KGlucHV0JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIwaW5wdXQlNUIuLi4lMkMlMjBkJTNBJTVE",highlighted:`<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, <span class="hljs-built_in">input</span>: torch.Tensor</span>) -&gt; torch.Tensor:
        d = <span class="hljs-built_in">input</span>.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(<span class="hljs-built_in">input</span>[..., :d]) * <span class="hljs-built_in">input</span>[..., d:]`,wrap:!1}}),b=new d({props:{title:"External layers",local:"external-layers",headingTag:"h3"}}),k=new c({props:{code:"ZnJvbSUyMHNvbWVsaWJyYXJ5JTIwaW1wb3J0JTIwU2lsdUFuZE11bCUwQSUwQXJlcGxhY2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIoU2lsdUFuZE11bCUyQyUyMCUyMlNpbHVBbmRNdWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> somelibrary <span class="hljs-keyword">import</span> SiluAndMul

replace_kernel_forward_from_hub(SiluAndMul, <span class="hljs-string">&quot;SiluAndMul&quot;</span>)`,wrap:!1}}),E=new d({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),v=new c({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSk=",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE)`,wrap:!1}}),B=new c({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLlRSQUlOSU5HKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.TRAINING)`,wrap:!1}}),Z=new c({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEElMEElMjMlMjBJbmZlcmVuY2UlMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSklMEElMEElMjMlMjBUcmFpbmluZyUwQW1vZGVsJTIwJTNEJTIwa2VybmVsaXplKG1vZGVsJTJDJTIwbW9kZSUzRE1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUp",highlighted:`model = MyModel(...)

<span class="hljs-comment"># Inference</span>
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE)

<span class="hljs-comment"># Training</span>
model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),G=new d({props:{title:"Kernel device",local:"kernel-device",headingTag:"h3"}}),L=new c({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBtb2RlJTNETW9kZS5JTkZFUkVOQ0Up",highlighted:`model = MyModel(...)
model = kernelize(model, device=<span class="hljs-string">&quot;cuda&quot;</span>, mode=Mode.INFERENCE)`,wrap:!1}}),Q=new d({props:{title:"Fallback forward",local:"fallback-forward",headingTag:"h3"}}),V=new c({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKC4uLiklMEFtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLklORkVSRU5DRSUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSUyQyUyMHVzZV9mYWxsYmFjayUzREZhbHNlKQ==",highlighted:`model = MyModel(...)
model = kernelize(model, mode=Mode.INFERENCE | Mode.TORCH_COMPILE, use_fallback=<span class="hljs-literal">False</span>)`,wrap:!1}}),X=new d({props:{title:"Inspecting which kernels are used",local:"inspecting-which-kernels-are-used",headingTag:"h3"}}),q=new d({props:{title:"Registering a hub kernel for a layer",local:"registering-a-hub-kernel-for-a-layer",headingTag:"h2"}}),Y=new c({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9jbSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        <span class="hljs-string">&quot;rocm&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}`,wrap:!1}}),O=new c({props:{code:"cmVnaXN0ZXJfa2VybmVsX21hcHBpbmcoa2VybmVsX2xheWVyX21hcHBpbmcp",highlighted:"register_kernel_mapping(kernel_layer_mapping)",wrap:!1}}),D=new c({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyhrZXJuZWxfbGF5ZXJfbWFwcGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBsYXllciUyMGZvciUyMHdoaWNoJTIwdGhlJTIwbWFwcGluZyUyMGlzJTIwYXBwbGllZC4lMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGtlcm5lbGl6ZShtb2RlbCUyQyUyMG1vZGUlM0RNb2RlLlRSQUlOSU5HJTIwJTdDJTIwTW9kZS5UT1JDSF9DT01QSUxFKQ==",highlighted:`<span class="hljs-keyword">with</span> use_kernel_mapping(kernel_layer_mapping):
    <span class="hljs-comment"># Use the layer for which the mapping is applied.</span>
    model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),le=new d({props:{title:"Using version bounds",local:"using-version-bounds",headingTag:"h3"}}),Me=new c({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExheWVyUmVwb3NpdG9yeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIya2VybmVscy1jb21tdW5pdHklMkZhY3RpdmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2ZXJzaW9uJTNEJTIyJTNFJTNEMC4wLjQlMkMlM0MwLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2NtJTIyJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZlcnNpb24lM0QlMjIlM0UlM0QwLjAuNCUyQyUzQzAuMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            version=<span class="hljs-string">&quot;&gt;=0.0.4,&lt;0.1.0&quot;</span>,
        ),
        <span class="hljs-string">&quot;rocm&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            version=<span class="hljs-string">&quot;&gt;=0.0.4,&lt;0.1.0&quot;</span>,
        )
    }
}`,wrap:!1}}),ie=new d({props:{title:"Registering kernels for specific modes",local:"registering-kernels-for-specific-modes",headingTag:"h3"}}),ae=new c({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUlM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
          Mode.INFERENCE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
          Mode.TRAINING | Mode.TORCH_COMPILE: LayerRepository(
              repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
              layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
          ),
      }
    }
}`,wrap:!1}}),pe=new c({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuRkFMTEJBQ0slM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuSU5GRVJFTkNFJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taW5mZXJlbmNlLW9wdGltaXplZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1vZGUuVFJBSU5JTkclM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbi10cmFpbmluZy1vcHRpbWl6ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0Q=",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.FALLBACK: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-inference-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;kernels-community/activation-training-optimized&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            ),
        }
    }
}`,wrap:!1}}),Te=new d({props:{title:"Registering kernels for specific CUDA capabilities",local:"registering-kernels-for-specific-cuda-capabilities",headingTag:"h3"}}),ce=new c({props:{code:"a2VybmVsX2xheWVyX21hcHBpbmclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGV2aWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvcGVydGllcyUzRENVREFQcm9wZXJ0aWVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1pbl9jYXBhYmlsaXR5JTNENzUlMkMlMjBtYXhfY2FwYWJpbGl0eSUzRDg5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMERldmljZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtaW5fY2FwYWJpbGl0eSUzRDkwJTJDJTIwbWF4X2NhcGFiaWxpdHklM0RzeXMubWF4c2l6ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24taG9wcGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJfbmFtZSUzRCUyMlNpbHVBbmRNdWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdE",highlighted:`kernel_layer_mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">89</span>
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
        Device(
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
            properties=CUDAProperties(
                min_capability=<span class="hljs-number">90</span>, max_capability=sys.maxsize
            ),
        ): LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation-hopper&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        ),
    }
}`,wrap:!1}}),we=new d({props:{title:"Registering kernels for specific ROCm capabilities",local:"registering-kernels-for-specific-rocm-capabilities",headingTag:"h3"}}),ue=new d({props:{title:"Loading from a local repository for testing",local:"loading-from-a-local-repository-for-testing",headingTag:"h3"}}),Ie=new c({props:{code:"d2l0aCUyMHVzZV9rZXJuZWxfbWFwcGluZyglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJTaWx1QW5kTXVsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUzQSUyMExvY2FsTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9fcGF0aCUzRCUyMiUyRmhvbWUlMkZkYW5pZWwlMkZrZXJuZWxzJTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhY2thZ2VfbmFtZSUzRCUyMmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBpbmhlcml0X21hcHBpbmclM0RGYWxzZSUyQyUwQSklM0ElMEElMjAlMjAlMjAlMjBrZXJuZWxpemUobGluZWFyJTJDJTIwbW9kZSUzRE1vZGUuSU5GRVJFTkNFKQ==",highlighted:`<span class="hljs-keyword">with</span> use_kernel_mapping(
    {
        <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
            <span class="hljs-string">&quot;cuda&quot;</span>: LocalLayerRepository(
                repo_path=<span class="hljs-string">&quot;/home/daniel/kernels/activation&quot;</span>,
                package_name=<span class="hljs-string">&quot;activation&quot;</span>,
                layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
            )
        }
    },
    inherit_mapping=<span class="hljs-literal">False</span>,
):
    kernelize(linear, mode=Mode.INFERENCE)`,wrap:!1}}),fe=new jt({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/layers.md"}}),{c(){m=n("meta"),be=s(),he=n("p"),ge=s(),r(w.$$.fragment),ke=s(),C=n("p"),C.innerHTML=Sl,$e=s(),u=n("p"),u.innerHTML=Zl,Ee=s(),r(j.$$.fragment),Re=s(),r(I.$$.fragment),ve=s(),f=n("p"),f.innerHTML=Gl,Ne=s(),r(h.$$.fragment),Be=s(),A=n("p"),A.innerHTML=Wl,_e=s(),r(b.$$.fragment),Se=s(),g=n("p"),g.innerHTML=Ll,Ze=s(),r(k.$$.fragment),Ge=s(),$=n("p"),$.innerHTML=Ql,We=s(),r(E.$$.fragment),Le=s(),R=n("p"),R.innerHTML=Hl,Qe=s(),r(v.$$.fragment),He=s(),N=n("p"),N.innerHTML=Vl,Ve=s(),r(B.$$.fragment),xe=s(),_=n("p"),_.innerHTML=xl,Xe=s(),S=n("p"),S.innerHTML=Xl,Fe=s(),r(Z.$$.fragment),qe=s(),r(G.$$.fragment),ze=s(),W=n("p"),W.innerHTML=Fl,Ye=s(),r(L.$$.fragment),Pe=s(),r(Q.$$.fragment),Oe=s(),H=n("p"),H.innerHTML=ql,Ke=s(),r(V.$$.fragment),De=s(),x=n("p"),x.textContent=zl,el=s(),r(X.$$.fragment),ll=s(),F=n("p"),F.innerHTML=Yl,tl=s(),r(q.$$.fragment),Ml=s(),z=n("p"),z.innerHTML=Pl,sl=s(),r(Y.$$.fragment),il=s(),P=n("p"),P.innerHTML=Ol,nl=s(),r(O.$$.fragment),al=s(),K=n("p"),K.innerHTML=Kl,rl=s(),r(D.$$.fragment),yl=s(),ee=n("p"),ee.innerHTML=Dl,ol=s(),r(le.$$.fragment),pl=s(),te=n("p"),te.innerHTML=et,Ul=s(),r(Me.$$.fragment),Tl=s(),se=n("p"),se.innerHTML=lt,Jl=s(),r(ie.$$.fragment),cl=s(),ne=n("p"),ne.textContent=tt,dl=s(),r(ae.$$.fragment),ml=s(),re=n("p"),re.innerHTML=Mt,wl=s(),ye=n("ul"),ye.innerHTML=st,Cl=s(),oe=n("p"),oe.innerHTML=it,ul=s(),r(pe.$$.fragment),jl=s(),Ue=n("p"),Ue.innerHTML=nt,Il=s(),r(Te.$$.fragment),fl=s(),Je=n("p"),Je.innerHTML=at,hl=s(),r(ce.$$.fragment),Al=s(),de=n("p"),de.textContent=rt,bl=s(),me=n("ul"),me.innerHTML=yt,gl=s(),r(we.$$.fragment),kl=s(),Ce=n("p"),Ce.innerHTML=ot,$l=s(),r(ue.$$.fragment),El=s(),je=n("p"),je.innerHTML=pt,Rl=s(),r(Ie.$$.fragment),vl=s(),r(fe.$$.fragment),Nl=s(),Ae=n("p"),this.h()},l(e){const l=Ct("svelte-u9bgzb",document.head);m=a(l,"META",{name:!0,content:!0}),l.forEach(t),be=i(e),he=a(e,"P",{}),Ut(he).forEach(t),ge=i(e),y(w.$$.fragment,e),ke=i(e),C=a(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-178x673"&&(C.innerHTML=Sl),$e=i(e),u=a(e,"P",{"data-svelte-h":!0}),o(u)!=="svelte-j3oddw"&&(u.innerHTML=Zl),Ee=i(e),y(j.$$.fragment,e),Re=i(e),y(I.$$.fragment,e),ve=i(e),f=a(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1jd41lf"&&(f.innerHTML=Gl),Ne=i(e),y(h.$$.fragment,e),Be=i(e),A=a(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-tily1x"&&(A.innerHTML=Wl),_e=i(e),y(b.$$.fragment,e),Se=i(e),g=a(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1hj9ahw"&&(g.innerHTML=Ll),Ze=i(e),y(k.$$.fragment,e),Ge=i(e),$=a(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-13coke1"&&($.innerHTML=Ql),We=i(e),y(E.$$.fragment,e),Le=i(e),R=a(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-stkx9y"&&(R.innerHTML=Hl),Qe=i(e),y(v.$$.fragment,e),He=i(e),N=a(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1mdicvi"&&(N.innerHTML=Vl),Ve=i(e),y(B.$$.fragment,e),xe=i(e),_=a(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-xhc5xj"&&(_.innerHTML=xl),Xe=i(e),S=a(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-195gdzl"&&(S.innerHTML=Xl),Fe=i(e),y(Z.$$.fragment,e),qe=i(e),y(G.$$.fragment,e),ze=i(e),W=a(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-808tau"&&(W.innerHTML=Fl),Ye=i(e),y(L.$$.fragment,e),Pe=i(e),y(Q.$$.fragment,e),Oe=i(e),H=a(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-yu926d"&&(H.innerHTML=ql),Ke=i(e),y(V.$$.fragment,e),De=i(e),x=a(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1lkusth"&&(x.textContent=zl),el=i(e),y(X.$$.fragment,e),ll=i(e),F=a(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-161p6z8"&&(F.innerHTML=Yl),tl=i(e),y(q.$$.fragment,e),Ml=i(e),z=a(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1r5il31"&&(z.innerHTML=Pl),sl=i(e),y(Y.$$.fragment,e),il=i(e),P=a(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1mzc83p"&&(P.innerHTML=Ol),nl=i(e),y(O.$$.fragment,e),al=i(e),K=a(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-p5ro9n"&&(K.innerHTML=Kl),rl=i(e),y(D.$$.fragment,e),yl=i(e),ee=a(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-z3xuuf"&&(ee.innerHTML=Dl),ol=i(e),y(le.$$.fragment,e),pl=i(e),te=a(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-130qoue"&&(te.innerHTML=et),Ul=i(e),y(Me.$$.fragment,e),Tl=i(e),se=a(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-8ksrq2"&&(se.innerHTML=lt),Jl=i(e),y(ie.$$.fragment,e),cl=i(e),ne=a(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1ed3b6y"&&(ne.textContent=tt),dl=i(e),y(ae.$$.fragment,e),ml=i(e),re=a(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-sek2d8"&&(re.innerHTML=Mt),wl=i(e),ye=a(e,"UL",{"data-svelte-h":!0}),o(ye)!=="svelte-ewhtf4"&&(ye.innerHTML=st),Cl=i(e),oe=a(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-m4furw"&&(oe.innerHTML=it),ul=i(e),y(pe.$$.fragment,e),jl=i(e),Ue=a(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1oi4pcx"&&(Ue.innerHTML=nt),Il=i(e),y(Te.$$.fragment,e),fl=i(e),Je=a(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1wl92tu"&&(Je.innerHTML=at),hl=i(e),y(ce.$$.fragment,e),Al=i(e),de=a(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1k7nbkd"&&(de.textContent=rt),bl=i(e),me=a(e,"UL",{"data-svelte-h":!0}),o(me)!=="svelte-xyngc6"&&(me.innerHTML=yt),gl=i(e),y(we.$$.fragment,e),kl=i(e),Ce=a(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1q9vv7t"&&(Ce.innerHTML=ot),$l=i(e),y(ue.$$.fragment,e),El=i(e),je=a(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-qa4iob"&&(je.innerHTML=pt),Rl=i(e),y(Ie.$$.fragment,e),vl=i(e),y(fe.$$.fragment,e),Nl=i(e),Ae=a(e,"P",{}),Ut(Ae).forEach(t),this.h()},h(){Tt(m,"name","hf:doc:metadata"),Tt(m,"content",ft)},m(e,l){ut(document.head,m),M(e,be,l),M(e,he,l),M(e,ge,l),p(w,e,l),M(e,ke,l),M(e,C,l),M(e,$e,l),M(e,u,l),M(e,Ee,l),p(j,e,l),M(e,Re,l),p(I,e,l),M(e,ve,l),M(e,f,l),M(e,Ne,l),p(h,e,l),M(e,Be,l),M(e,A,l),M(e,_e,l),p(b,e,l),M(e,Se,l),M(e,g,l),M(e,Ze,l),p(k,e,l),M(e,Ge,l),M(e,$,l),M(e,We,l),p(E,e,l),M(e,Le,l),M(e,R,l),M(e,Qe,l),p(v,e,l),M(e,He,l),M(e,N,l),M(e,Ve,l),p(B,e,l),M(e,xe,l),M(e,_,l),M(e,Xe,l),M(e,S,l),M(e,Fe,l),p(Z,e,l),M(e,qe,l),p(G,e,l),M(e,ze,l),M(e,W,l),M(e,Ye,l),p(L,e,l),M(e,Pe,l),p(Q,e,l),M(e,Oe,l),M(e,H,l),M(e,Ke,l),p(V,e,l),M(e,De,l),M(e,x,l),M(e,el,l),p(X,e,l),M(e,ll,l),M(e,F,l),M(e,tl,l),p(q,e,l),M(e,Ml,l),M(e,z,l),M(e,sl,l),p(Y,e,l),M(e,il,l),M(e,P,l),M(e,nl,l),p(O,e,l),M(e,al,l),M(e,K,l),M(e,rl,l),p(D,e,l),M(e,yl,l),M(e,ee,l),M(e,ol,l),p(le,e,l),M(e,pl,l),M(e,te,l),M(e,Ul,l),p(Me,e,l),M(e,Tl,l),M(e,se,l),M(e,Jl,l),p(ie,e,l),M(e,cl,l),M(e,ne,l),M(e,dl,l),p(ae,e,l),M(e,ml,l),M(e,re,l),M(e,wl,l),M(e,ye,l),M(e,Cl,l),M(e,oe,l),M(e,ul,l),p(pe,e,l),M(e,jl,l),M(e,Ue,l),M(e,Il,l),p(Te,e,l),M(e,fl,l),M(e,Je,l),M(e,hl,l),p(ce,e,l),M(e,Al,l),M(e,de,l),M(e,bl,l),M(e,me,l),M(e,gl,l),p(we,e,l),M(e,kl,l),M(e,Ce,l),M(e,$l,l),p(ue,e,l),M(e,El,l),M(e,je,l),M(e,Rl,l),p(Ie,e,l),M(e,vl,l),p(fe,e,l),M(e,Nl,l),M(e,Ae,l),Bl=!0},p:ct,i(e){Bl||(U(w.$$.fragment,e),U(j.$$.fragment,e),U(I.$$.fragment,e),U(h.$$.fragment,e),U(b.$$.fragment,e),U(k.$$.fragment,e),U(E.$$.fragment,e),U(v.$$.fragment,e),U(B.$$.fragment,e),U(Z.$$.fragment,e),U(G.$$.fragment,e),U(L.$$.fragment,e),U(Q.$$.fragment,e),U(V.$$.fragment,e),U(X.$$.fragment,e),U(q.$$.fragment,e),U(Y.$$.fragment,e),U(O.$$.fragment,e),U(D.$$.fragment,e),U(le.$$.fragment,e),U(Me.$$.fragment,e),U(ie.$$.fragment,e),U(ae.$$.fragment,e),U(pe.$$.fragment,e),U(Te.$$.fragment,e),U(ce.$$.fragment,e),U(we.$$.fragment,e),U(ue.$$.fragment,e),U(Ie.$$.fragment,e),U(fe.$$.fragment,e),Bl=!0)},o(e){T(w.$$.fragment,e),T(j.$$.fragment,e),T(I.$$.fragment,e),T(h.$$.fragment,e),T(b.$$.fragment,e),T(k.$$.fragment,e),T(E.$$.fragment,e),T(v.$$.fragment,e),T(B.$$.fragment,e),T(Z.$$.fragment,e),T(G.$$.fragment,e),T(L.$$.fragment,e),T(Q.$$.fragment,e),T(V.$$.fragment,e),T(X.$$.fragment,e),T(q.$$.fragment,e),T(Y.$$.fragment,e),T(O.$$.fragment,e),T(D.$$.fragment,e),T(le.$$.fragment,e),T(Me.$$.fragment,e),T(ie.$$.fragment,e),T(ae.$$.fragment,e),T(pe.$$.fragment,e),T(Te.$$.fragment,e),T(ce.$$.fragment,e),T(we.$$.fragment,e),T(ue.$$.fragment,e),T(Ie.$$.fragment,e),T(fe.$$.fragment,e),Bl=!1},d(e){e&&(t(be),t(he),t(ge),t(ke),t(C),t($e),t(u),t(Ee),t(Re),t(ve),t(f),t(Ne),t(Be),t(A),t(_e),t(Se),t(g),t(Ze),t(Ge),t($),t(We),t(Le),t(R),t(Qe),t(He),t(N),t(Ve),t(xe),t(_),t(Xe),t(S),t(Fe),t(qe),t(ze),t(W),t(Ye),t(Pe),t(Oe),t(H),t(Ke),t(De),t(x),t(el),t(ll),t(F),t(tl),t(Ml),t(z),t(sl),t(il),t(P),t(nl),t(al),t(K),t(rl),t(yl),t(ee),t(ol),t(pl),t(te),t(Ul),t(Tl),t(se),t(Jl),t(cl),t(ne),t(dl),t(ml),t(re),t(wl),t(ye),t(Cl),t(oe),t(ul),t(jl),t(Ue),t(Il),t(fl),t(Je),t(hl),t(Al),t(de),t(bl),t(me),t(gl),t(kl),t(Ce),t($l),t(El),t(je),t(Rl),t(vl),t(Nl),t(Ae)),t(m),J(w,e),J(j,e),J(I,e),J(h,e),J(b,e),J(k,e),J(E,e),J(v,e),J(B,e),J(Z,e),J(G,e),J(L,e),J(Q,e),J(V,e),J(X,e),J(q,e),J(Y,e),J(O,e),J(D,e),J(le,e),J(Me,e),J(ie,e),J(ae,e),J(pe,e),J(Te,e),J(ce,e),J(we,e),J(ue,e),J(Ie,e),J(fe,e)}}}const ft='{"title":"Layers","local":"layers","sections":[{"title":"Making a layer extensible with kernels from the hub","local":"making-a-layer-extensible-with-kernels-from-the-hub","sections":[{"title":"Using a decorator","local":"using-a-decorator","sections":[],"depth":3},{"title":"External layers","local":"external-layers","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"Kernel device","local":"kernel-device","sections":[],"depth":3},{"title":"Fallback forward","local":"fallback-forward","sections":[],"depth":3},{"title":"Inspecting which kernels are used","local":"inspecting-which-kernels-are-used","sections":[],"depth":3}],"depth":2},{"title":"Registering a hub kernel for a layer","local":"registering-a-hub-kernel-for-a-layer","sections":[{"title":"Using version bounds","local":"using-version-bounds","sections":[],"depth":3},{"title":"Registering kernels for specific modes","local":"registering-kernels-for-specific-modes","sections":[],"depth":3},{"title":"Registering kernels for specific CUDA capabilities","local":"registering-kernels-for-specific-cuda-capabilities","sections":[],"depth":3},{"title":"Registering kernels for specific ROCm capabilities","local":"registering-kernels-for-specific-rocm-capabilities","sections":[],"depth":3},{"title":"Loading from a local repository for testing","local":"loading-from-a-local-repository-for-testing","sections":[],"depth":3}],"depth":2}],"depth":1}';function ht(_l){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $t extends mt{constructor(m){super(),wt(this,m,ht,It,Jt,{})}}export{$t as component};
