import{s as ot,f as rt,n as mt,o as pt}from"../chunks/scheduler.7bc62968.js";import{S as Mt,i as ct,g as i,s as a,r as m,A as yt,h as o,f as s,c as l,j as lt,u as p,x as r,k as P,y as ut,a as n,v as M,d as c,t as y,w as u}from"../chunks/index.2f8492b0.js";import{C as it}from"../chunks/CodeBlock.bb61a5a9.js";import{H as d,E as dt}from"../chunks/getInferenceSnippets.cd80cb94.js";function Ut(Ge){let U,ee,K,te,w,se,h,Se,ne,J,ae,f,Ee="OneFormer is a groundbreaking approach to image segmentation, a computer vision task that involves dividing an image into meaningful segments. Traditional methods used separate models and architectures for different segmentation tasks, like identifying objects (instance segmentation) or labeling regions (semantic segmentation). More recent attempts aimed to unify these tasks using shared architectures but still required separate training for each task.",le,T,Fe="Enter OneFormer, a universal image segmentation framework designed to overcome these challenges. It introduces a unique multi-task approach, allowing a single model to handle semantic, instance, and panoptic segmentation tasks without the need for separate training on each. The key innovation lies in a task-conditioned joint training strategy, where the model is guided by a task input, making it dynamic and adaptive to different tasks during both training and inference.",ie,g,Ne="This breakthrough not only simplifies the training process but also outperforms existing models across various datasets. OneFormer achieves this by using panoptic annotations, unifying the ground truth information needed for all tasks. Additionally, the framework introduces query-text contrastive learning to better distinguish between tasks and improve overall performance.",oe,j,re,C,Qe='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/oneformer.svg" alt="Oneformer Method"/> <em>Image taken from OneFormer paper</em>',me,I,Xe="To understand OneFormer’s significance, let’s look into the background of image segmentation. In image processing, segmentation involves dividing an image into different parts, which is crucial for tasks like recognizing objects and understanding the content of a scene. Traditionally, two main types of segmentation tasks were semantic segmentation, where pixels are labeled with categories like “road” or “sky,” and instance segmentation, which identifies objects with well-defined boundaries.",pe,b,ze="Over time, researchers proposed panoptic segmentation as a way to unify semantic and instance segmentation tasks. However, even with these advancements, there were challenges. Existing models designed for panoptic segmentation still required separate training for each task, making them semi-universal at best.",Me,k,He="This is where OneFormer comes in as a game-changer. It introduces a novel approach – a multi-task universal architecture. The idea is to train this framework only once, using a single universal architecture, a lone model, and just one dataset. The magic happens as OneFormer outperforms specialized frameworks across semantic, instance, and panoptic segmentation tasks. This breakthrough is not just about improving accuracy; it’s about making image segmentation more universal and efficient. With OneFormer, the need for extensive resources and separate training for different tasks becomes a thing of the past.",ce,v,ye,B,Ve='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/text_gen.svg" alt="Task Conditioned Joint Training"/>',ue,Z,qe="Now, let’s break down the key features of OneFormer that make it stand out:",de,W,Ue,A,Ye="OneFormer uses a clever trick called “Task-Dynamic Mask” to better understand and tackle different types of image segmentation tasks. So, when the model encounters an image, it uses this “Task-Dynamic Mask” to decide whether to pay attention to the overall scene, identify specific objects with clear boundaries, or do a combination of both.",he,R,we,x,Oe="One of the groundbreaking features of OneFormer is its task-conditioned joint training strategy. Instead of training separately for semantic, instance, and panoptic segmentation, OneFormer uniformly samples the task during training. This strategy enables the model to learn and generalize across different segmentation tasks simultaneously. By conditioning the architecture on the specific task through the task token, OneFormer unifies the training process, reducing the need for task-specific architectures, models, and datasets. This innovative approach significantly streamlines the training pipeline and resource requirements.",Je,_,fe,$,Le="Lastly, let’s talk about “Query-Text Contrastive Loss.” Think of it as a way for OneFormer to teach itself about the differences between tasks and classes. In the training process, the model compares the features it extracts from the image (queries) with the corresponding text descriptions (like “a photo with a car”). This helps the model understand the unique characteristics of each task and reduces confusion between different classes. OneFormer’s “Task-Dynamic Mask” allows it to be versatile like a multitasking assistant, and the “Query-Text Contrastive Loss” helps it learn the specifics of each task by comparing visual features with textual descriptions.",Te,G,Pe="By combining these core concepts, OneFormer becomes a smart and efficient tool for image segmentation, making the process more universal and accessible.",ge,S,je,E,Ke='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/plots.svg" alt="result comperison"/> <em>Image taken from OneFormer paper</em>',Ce,F,De="In conclusion, the OneFormer framework represents a groundbreaking approach in the field of image segmentation, aiming to simplify and unify the task across various domains. Unlike traditional methods that rely on specialized architectures for each segmentation task, OneFormer introduces a novel multi-task universal architecture that requires only a single model, trained once on a universal dataset, to outperform existing frameworks. Additionally, the incorporation of query-text contrastive loss during training enhances the model’s ability to learn inter-task and inter-class differences. OneFormer utilizes transformer-based architectures, inspired by recent successes in computer vision, and introduces task-guided queries to improve task sensitivity. The results are impressive, as OneFormer surpasses state-of-the-art models across semantic, instance, and panoptic segmentation tasks on benchmark datasets like ADE20k, Cityscapes, and COCO. The framework’s performance is further enhanced with new ConvNeXt and DiNAT backbones.",Ie,N,et="In summary, OneFormer represents a significant step towards universal and accessible image segmentation. By introducing a single model capable of handling diverse segmentation tasks, the framework streamlines the segmentation process and reduces resource requirements.",be,Q,ke,X,tt="Let’s see an example use of the model. Dinat backbone requires Natten library, which may take a while to install.",ve,z,Be,H,st="We can see an inference code below depending on different segmentation types.",Ze,V,We,q,nt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/oneformer_semantic.png" alt="semantic segmentation"/>',Ae,Y,Re,O,at='<li><a href="https://arxiv.org/pdf/2211.06220.pdf" rel="nofollow">OneFormer Paper</a></li> <li><a href="https://huggingface.co/shi-labs/oneformer_ade20k_dinat_large" rel="nofollow">HuggingFace OneFormer model</a></li>',xe,L,_e,D,$e;return w=new d({props:{title:"OneFormer: One Transformer to Rule Universal Image Segmentation",local:"oneformer-one-transformer-to-rule-universal-image-segmentation",headingTag:"h1"}}),J=new d({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),j=new d({props:{title:"Background of OneFormer",local:"background-of-oneformer",headingTag:"h2"}}),v=new d({props:{title:"Core Concepts of OneFormer",local:"core-concepts-of-oneformer",headingTag:"h2"}}),W=new d({props:{title:"Task-Dynamic Mask",local:"task-dynamic-mask",headingTag:"h3"}}),R=new d({props:{title:"Task-Conditioned Joint Training",local:"task-conditioned-joint-training",headingTag:"h3"}}),_=new d({props:{title:"Query-Text Contrastive Loss",local:"query-text-contrastive-loss",headingTag:"h3"}}),S=new d({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Q=new d({props:{title:"Example use of model",local:"example-use-of-model",headingTag:"h2"}}),z=new it({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMG5hdHRlbiUyMA==",highlighted:"!pip install -q natten ",wrap:!1}}),V=new it({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerForUniversalSegmentation
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_segmentation</span>(<span class="hljs-params">image, task_type</span>):
    <span class="hljs-string">&quot;&quot;&quot;Performs image segmentation based on the given task type.

    Args:
        image (PIL.Image): The input image.
        task_type (str): The type of segmentation to perform (&#x27;semantic&#x27;, &#x27;instance&#x27;, or &#x27;panoptic&#x27;).

    Returns:
        PIL.Image: The segmented image.

    Raises:
        ValueError: If the task type is invalid.
    &quot;&quot;&quot;</span>

    processor = OneFormerProcessor.from_pretrained(
        <span class="hljs-string">&quot;shi-labs/oneformer_ade20k_dinat_large&quot;</span>
    )  <span class="hljs-comment"># Load once here</span>
    model = OneFormerForUniversalSegmentation.from_pretrained(
        <span class="hljs-string">&quot;shi-labs/oneformer_ade20k_dinat_large&quot;</span>
    )

    <span class="hljs-keyword">if</span> task_type == <span class="hljs-string">&quot;semantic&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_semantic_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>]

    <span class="hljs-keyword">elif</span> task_type == <span class="hljs-string">&quot;instance&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;instance&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_instance_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]

    <span class="hljs-keyword">elif</span> task_type == <span class="hljs-string">&quot;panoptic&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;panoptic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_panoptic_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]

    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">raise</span> ValueError(
            <span class="hljs-string">&quot;Invalid task type. Choose from &#x27;semantic&#x27;, &#x27;instance&#x27;, or &#x27;panoptic&#x27;&quot;</span>
        )

    <span class="hljs-keyword">return</span> predicted_map


<span class="hljs-keyword">def</span> <span class="hljs-title function_">show_image_comparison</span>(<span class="hljs-params">image, predicted_map, segmentation_title</span>):
    <span class="hljs-string">&quot;&quot;&quot;Displays the original image and the segmented image side-by-side.

    Args:
        image (PIL.Image): The original image.
        predicted_map (PIL.Image): The segmented image.
        segmentation_title (str): The title for the segmented image.
    &quot;&quot;&quot;</span>

    plt.figure(figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">6</span>))
    plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">1</span>)
    plt.imshow(image)
    plt.title(<span class="hljs-string">&quot;Original Image&quot;</span>)
    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
    plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)
    plt.imshow(predicted_map)
    plt.title(segmentation_title + <span class="hljs-string">&quot; Segmentation&quot;</span>)
    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
    plt.show()


url = <span class="hljs-string">&quot;https://huggingface.co/datasets/shi-labs/oneformer_demo/resolve/main/ade20k.jpeg&quot;</span>
response = requests.get(url, stream=<span class="hljs-literal">True</span>)
response.raise_for_status()  <span class="hljs-comment"># Check for HTTP errors</span>
image = Image.<span class="hljs-built_in">open</span>(response.raw)

task_to_run = <span class="hljs-string">&quot;semantic&quot;</span>
predicted_map = run_segmentation(image, task_to_run)
show_image_comparison(image, predicted_map, task_to_run)`,wrap:!1}}),Y=new d({props:{title:"References",local:"references",headingTag:"h2"}}),L=new dt({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit3/vision-transformers/oneformer.mdx"}}),{c(){U=i("meta"),ee=a(),K=i("p"),te=a(),m(w.$$.fragment),se=a(),h=i("img"),ne=a(),m(J.$$.fragment),ae=a(),f=i("p"),f.textContent=Ee,le=a(),T=i("p"),T.textContent=Fe,ie=a(),g=i("p"),g.textContent=Ne,oe=a(),m(j.$$.fragment),re=a(),C=i("p"),C.innerHTML=Qe,me=a(),I=i("p"),I.textContent=Xe,pe=a(),b=i("p"),b.textContent=ze,Me=a(),k=i("p"),k.textContent=He,ce=a(),m(v.$$.fragment),ye=a(),B=i("p"),B.innerHTML=Ve,ue=a(),Z=i("p"),Z.textContent=qe,de=a(),m(W.$$.fragment),Ue=a(),A=i("p"),A.textContent=Ye,he=a(),m(R.$$.fragment),we=a(),x=i("p"),x.textContent=Oe,Je=a(),m(_.$$.fragment),fe=a(),$=i("p"),$.textContent=Le,Te=a(),G=i("p"),G.textContent=Pe,ge=a(),m(S.$$.fragment),je=a(),E=i("p"),E.innerHTML=Ke,Ce=a(),F=i("p"),F.textContent=De,Ie=a(),N=i("p"),N.textContent=et,be=a(),m(Q.$$.fragment),ke=a(),X=i("p"),X.textContent=tt,ve=a(),m(z.$$.fragment),Be=a(),H=i("p"),H.textContent=st,Ze=a(),m(V.$$.fragment),We=a(),q=i("p"),q.innerHTML=nt,Ae=a(),m(Y.$$.fragment),Re=a(),O=i("ul"),O.innerHTML=at,xe=a(),m(L.$$.fragment),_e=a(),D=i("p"),this.h()},l(e){const t=yt("svelte-u9bgzb",document.head);U=o(t,"META",{name:!0,content:!0}),t.forEach(s),ee=l(e),K=o(e,"P",{}),lt(K).forEach(s),te=l(e),p(w.$$.fragment,e),se=l(e),h=o(e,"IMG",{align:!0,width:!0,height:!0,src:!0}),ne=l(e),p(J.$$.fragment,e),ae=l(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1hf6o1y"&&(f.textContent=Ee),le=l(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1ty30hf"&&(T.textContent=Fe),ie=l(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1lma2v6"&&(g.textContent=Ne),oe=l(e),p(j.$$.fragment,e),re=l(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-10j1l9u"&&(C.innerHTML=Qe),me=l(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ucc15p"&&(I.textContent=Xe),pe=l(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-n6259b"&&(b.textContent=ze),Me=l(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1ujmywj"&&(k.textContent=He),ce=l(e),p(v.$$.fragment,e),ye=l(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-m45fcy"&&(B.innerHTML=Ve),ue=l(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-rk7g5b"&&(Z.textContent=qe),de=l(e),p(W.$$.fragment,e),Ue=l(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-iru73r"&&(A.textContent=Ye),he=l(e),p(R.$$.fragment,e),we=l(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-fq7603"&&(x.textContent=Oe),Je=l(e),p(_.$$.fragment,e),fe=l(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1iagkck"&&($.textContent=Le),Te=l(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-xjljcp"&&(G.textContent=Pe),ge=l(e),p(S.$$.fragment,e),je=l(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-s6hco9"&&(E.innerHTML=Ke),Ce=l(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-glyvcc"&&(F.textContent=De),Ie=l(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1fzjv2z"&&(N.textContent=et),be=l(e),p(Q.$$.fragment,e),ke=l(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-3lq6h2"&&(X.textContent=tt),ve=l(e),p(z.$$.fragment,e),Be=l(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-14sbb7i"&&(H.textContent=st),Ze=l(e),p(V.$$.fragment,e),We=l(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ihn2fs"&&(q.innerHTML=nt),Ae=l(e),p(Y.$$.fragment,e),Re=l(e),O=o(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-gdx474"&&(O.innerHTML=at),xe=l(e),p(L.$$.fragment,e),_e=l(e),D=o(e,"P",{}),lt(D).forEach(s),this.h()},h(){P(U,"name","hf:doc:metadata"),P(U,"content",ht),P(h,"align","center"),P(h,"width","1050"),P(h,"height","303"),rt(h.src,Se="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/teaser.svg")||P(h,"src",Se)},m(e,t){ut(document.head,U),n(e,ee,t),n(e,K,t),n(e,te,t),M(w,e,t),n(e,se,t),n(e,h,t),n(e,ne,t),M(J,e,t),n(e,ae,t),n(e,f,t),n(e,le,t),n(e,T,t),n(e,ie,t),n(e,g,t),n(e,oe,t),M(j,e,t),n(e,re,t),n(e,C,t),n(e,me,t),n(e,I,t),n(e,pe,t),n(e,b,t),n(e,Me,t),n(e,k,t),n(e,ce,t),M(v,e,t),n(e,ye,t),n(e,B,t),n(e,ue,t),n(e,Z,t),n(e,de,t),M(W,e,t),n(e,Ue,t),n(e,A,t),n(e,he,t),M(R,e,t),n(e,we,t),n(e,x,t),n(e,Je,t),M(_,e,t),n(e,fe,t),n(e,$,t),n(e,Te,t),n(e,G,t),n(e,ge,t),M(S,e,t),n(e,je,t),n(e,E,t),n(e,Ce,t),n(e,F,t),n(e,Ie,t),n(e,N,t),n(e,be,t),M(Q,e,t),n(e,ke,t),n(e,X,t),n(e,ve,t),M(z,e,t),n(e,Be,t),n(e,H,t),n(e,Ze,t),M(V,e,t),n(e,We,t),n(e,q,t),n(e,Ae,t),M(Y,e,t),n(e,Re,t),n(e,O,t),n(e,xe,t),M(L,e,t),n(e,_e,t),n(e,D,t),$e=!0},p:mt,i(e){$e||(c(w.$$.fragment,e),c(J.$$.fragment,e),c(j.$$.fragment,e),c(v.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(_.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(z.$$.fragment,e),c(V.$$.fragment,e),c(Y.$$.fragment,e),c(L.$$.fragment,e),$e=!0)},o(e){y(w.$$.fragment,e),y(J.$$.fragment,e),y(j.$$.fragment,e),y(v.$$.fragment,e),y(W.$$.fragment,e),y(R.$$.fragment,e),y(_.$$.fragment,e),y(S.$$.fragment,e),y(Q.$$.fragment,e),y(z.$$.fragment,e),y(V.$$.fragment,e),y(Y.$$.fragment,e),y(L.$$.fragment,e),$e=!1},d(e){e&&(s(ee),s(K),s(te),s(se),s(h),s(ne),s(ae),s(f),s(le),s(T),s(ie),s(g),s(oe),s(re),s(C),s(me),s(I),s(pe),s(b),s(Me),s(k),s(ce),s(ye),s(B),s(ue),s(Z),s(de),s(Ue),s(A),s(he),s(we),s(x),s(Je),s(fe),s($),s(Te),s(G),s(ge),s(je),s(E),s(Ce),s(F),s(Ie),s(N),s(be),s(ke),s(X),s(ve),s(Be),s(H),s(Ze),s(We),s(q),s(Ae),s(Re),s(O),s(xe),s(_e),s(D)),s(U),u(w,e),u(J,e),u(j,e),u(v,e),u(W,e),u(R,e),u(_,e),u(S,e),u(Q,e),u(z,e),u(V,e),u(Y,e),u(L,e)}}}const ht='{"title":"OneFormer: One Transformer to Rule Universal Image Segmentation","local":"oneformer-one-transformer-to-rule-universal-image-segmentation","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Background of OneFormer","local":"background-of-oneformer","sections":[],"depth":2},{"title":"Core Concepts of OneFormer","local":"core-concepts-of-oneformer","sections":[{"title":"Task-Dynamic Mask","local":"task-dynamic-mask","sections":[],"depth":3},{"title":"Task-Conditioned Joint Training","local":"task-conditioned-joint-training","sections":[],"depth":3},{"title":"Query-Text Contrastive Loss","local":"query-text-contrastive-loss","sections":[],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"Example use of model","local":"example-use-of-model","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function wt(Ge){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends Mt{constructor(U){super(),ct(this,U,wt,Ut,ot,{})}}export{jt as component};
