import{s as qo,o as So,n as R}from"../chunks/scheduler.25b97de1.js";import{S as Lo,i as Ao,g as m,s as a,r as _,A as Go,h as p,f as n,c as r,j as z,u as b,x as f,k as C,y as d,a as l,v as T,d as y,t as v,w as M}from"../chunks/index.d9030fc9.js";import{T as $t}from"../chunks/Tip.baa67368.js";import{D as F}from"../chunks/Docstring.e257edda.js";import{C as tt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as et}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as mo,E as Do}from"../chunks/EditOnGithub.91d95064.js";function Yo(w){let o,g="IDEFICS modeling code in Transformers is for finetuning and inferencing the pre-trained IDEFICS models.",c,i,u="To train a new IDEFICS model from scratch use the m4 codebase (a link will be provided once it’s made public)";return{c(){o=m("p"),o.textContent=g,c=a(),i=m("p"),i.textContent=u},l(t){o=p(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-1avuyik"&&(o.textContent=g),c=r(t),i=p(t,"P",{"data-svelte-h":!0}),f(i)!=="svelte-22xyvf"&&(i.textContent=u)},m(t,h){l(t,o,h),l(t,c,h),l(t,i,h)},p:R,d(t){t&&(n(o),n(c),n(i))}}}function Oo(w){let o,g="Example:",c,i,u;return i=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMElkZWZpY3NNb2RlbCUyQyUyMElkZWZpY3NDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwSWRlZmljcyUyMGlkZWZpY3MtOWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSWRlZmljc0NvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGlkZWZpY3MtOWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMElkZWZpY3NNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsModel, IdeficsConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Idefics idefics-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = IdeficsConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the idefics-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=m("p"),o.textContent=g,c=a(),_(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-11lpom8"&&(o.textContent=g),c=r(t),b(i.$$.fragment,t)},m(t,h){l(t,o,h),l(t,c,h),T(i,t,h),u=!0},p:R,i(t){u||(y(i.$$.fragment,t),u=!0)},o(t){v(i.$$.fragment,t),u=!1},d(t){t&&(n(o),n(c)),M(i,t)}}}function Xo(w){let o,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=g},l(c){o=p(c,"P",{"data-svelte-h":!0}),f(o)!=="svelte-fincs2"&&(o.innerHTML=g)},m(c,i){l(c,o,i)},p:R,d(c){c&&n(o)}}}function Qo(w){let o,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=g},l(c){o=p(c,"P",{"data-svelte-h":!0}),f(o)!=="svelte-fincs2"&&(o.innerHTML=g)},m(c,i){l(c,o,i)},p:R,d(c){c&&n(o)}}}function Ko(w){let o,g="Example:",c,i,u;return i=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBJZGVmaWNzRm9yVmlzaW9uVGV4dDJUZXh0JTBBJTBBbW9kZWwlMjAlM0QlMjBJZGVmaWNzRm9yVmlzaW9uVGV4dDJUZXh0LmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljcy05YiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljcy05YiUyMiklMEElMEFkb2dzX2ltYWdlX3VybF8xJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX25sdnIyJTJGcmF3JTJGbWFpbiUyRmltYWdlMS5qcGVnJTIyJTBBZG9nc19pbWFnZV91cmxfMiUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlc19ubHZyMiUyRnJhdyUyRm1haW4lMkZpbWFnZTIuanBlZyUyMiUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9nc19pbWFnZV91cmxfMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiU1Q25Bc3Npc3RhbnQlM0ElMjBBbiUyMGltYWdlJTIwb2YlMjB0d28lMjBkb2dzLiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9nc19pbWFnZV91cmxfMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiU1Q25Bc3Npc3RhbnQlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocHJvbXB0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, IdeficsForVisionText2Text

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dogs_image_url_1 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_nlvr2/raw/main/image1.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dogs_image_url_2 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_nlvr2/raw/main/image2.jpeg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>        dogs_image_url_1,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Describe this image.\\nAssistant: An image of two dogs.\\n&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>        dogs_image_url_2,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Describe this image.\\nAssistant:&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=g,c=a(),_(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-11lpom8"&&(o.textContent=g),c=r(t),b(i.$$.fragment,t)},m(t,h){l(t,o,h),l(t,c,h),T(i,t,h),u=!0},p:R,i(t){u||(y(i.$$.fragment,t),u=!0)},o(t){v(i.$$.fragment,t),u=!1},d(t){t&&(n(o),n(c)),M(i,t)}}}function en(w){let o,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=g},l(c){o=p(c,"P",{"data-svelte-h":!0}),f(o)!=="svelte-fincs2"&&(o.innerHTML=g)},m(c,i){l(c,o,i)},p:R,d(c){c&&n(o)}}}function tn(w){let o,g="Example:",c,i,u;return i=new tt({props:{code:"JTNFJTNFJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURklkZWZpY3NGb3JWaXNpb25UZXh0MlRleHQlMEElMEElM0UlM0UlMjBtb2RlbCUyMCUzRCUyMFRGSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MtOWIlMjIpJTBBJTNFJTNFJTIwdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MtOWIlMjIpJTBBJTBBJTNFJTNFJTIwcHJvbXB0JTIwJTNEJTIwJTIySGV5JTJDJTIwYXJlJTIweW91JTIwY29uc2Npb3VycyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBJTNFJTNFJTIwaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBJTBBJTNFJTNFJTIwJTIzJTIwR2VuZXJhdGUlMEElM0UlM0UlMjBnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQSUzRSUzRSUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQSUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cnMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiU1Q25JJ20lMjBub3QlMjBjb25zY2lvdXJzJTJDJTIwYnV0JTIwSSUyMGNhbiUyMHRhbGslMjB0byUyMHlvdS4lMjI=",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFIdeficsForVisionText2Text

&gt;&gt; model = TFIdeficsForVisionText2Text.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)

&gt;&gt; prompt = <span class="hljs-string">&quot;Hey, are you consciours? Can you talk to me?&quot;</span>
&gt;&gt; inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

&gt;&gt; <span class="hljs-comment"># Generate</span>
&gt;&gt; generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
&gt;&gt; tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you consciours? Can you talk to me?\\nI&#x27;m not consciours, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=g,c=a(),_(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-11lpom8"&&(o.textContent=g),c=r(t),b(i.$$.fragment,t)},m(t,h){l(t,o,h),l(t,c,h),T(i,t,h),u=!0},p:R,i(t){u||(y(i.$$.fragment,t),u=!0)},o(t){v(i.$$.fragment,t),u=!1},d(t){t&&(n(o),n(c)),M(i,t)}}}function on(w){let o,g="Example:",c,i,u;return i=new tt({props:{code:"Y2hlY2twb2ludCUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlTTQlMkZpZGVmaWNzLTliJTIyJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmhpcHMuaGVhcnN0YXBwcy5jb20lMkZobWctcHJvZCUyRmltYWdlcyUyRmN1dGUtcGhvdG9zLW9mLWNhdHMtaW4tZ3Jhc3MtMTU5MzE4NDc3Ny5qcGclMjIlMEFpbWclMjAlM0QlMjBwcm9jZXNzb3IuaW1hZ2VfcHJvY2Vzc29yLmZldGNoX2ltYWdlcyglNUJ1cmwlNUQpJTVCMCU1RCUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1nJTJDJTBBJTIwJTIwJTIwJTIwJTIyRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBdCUzQSUyMEFuJTIwaW1hZ2UlMjBvZiUyMHR3byUyMGtpdHRlbnMlMjBpbiUyMGdyYXNzLiUwQSUwQSUyMCUyMCUyMCUyMCUyMlVzZXIlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhpcHMuaGVhcnN0YXBwcy5jb20lMkZobWctcHJvZCUyRmltYWdlcyUyRmRvZy1wdW5zLTE1ODE3MDgyMDguanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBdCUzQSUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMTAwKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>
processor = AutoProcessor.from_pretrained(checkpoint)
url = <span class="hljs-string">&quot;https://hips.hearstapps.com/hmg-prod/images/cute-photos-of-cats-in-grass-1593184777.jpg&quot;</span>
img = processor.image_processor.fetch_images([url])[<span class="hljs-number">0</span>]

prompts = [
    <span class="hljs-string">&quot;User:&quot;</span>,
    img,
    <span class="hljs-string">&quot;Describe this image.
t: An image of two kittens in grass.

    &quot;</span>User:<span class="hljs-string">&quot;,
    &quot;</span>https://hips.hearstapps.com/hmg-prod/images/dog-puns-<span class="hljs-number">1581708208.j</span>pg<span class="hljs-string">&quot;,
    &quot;</span>Describe this image.
t:<span class="hljs-string">&quot;,
]

inputs = processor(prompts, return_tensors=&quot;</span>pt<span class="hljs-string">&quot;)
generated_ids = model.generate(**inputs, max_length=100)
generated_text = processor.batch_decode(generated_ids, skip_special_tokens=True)[0]</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=g,c=a(),_(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-11lpom8"&&(o.textContent=g),c=r(t),b(i.$$.fragment,t)},m(t,h){l(t,o,h),l(t,c,h),T(i,t,h),u=!0},p:R,i(t){u||(y(i.$$.fragment,t),u=!0)},o(t){v(i.$$.fragment,t),u=!1},d(t){t&&(n(o),n(c)),M(i,t)}}}function nn(w){let o,g="In this example the <code>prompts</code> will be converted into:",c,i,u;return i=new tt({props:{code:"JTNDcyUzRVVzZXIlM0ElM0NmYWtlX3Rva2VuX2Fyb3VuZF9pbWFnZSUzRSUzQ2ltYWdlJTNFJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0VEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lMEFBc3Npc3RhbnQlM0ElMjBBbiUyMGltYWdlJTIwb2YlMjB0d28lMjBraXR0ZW5zJTIwaW4lMjBncmFzcy4lMEFVc2VyJTNBJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlM0NpbWFnZSUzRSUzQ2Zha2VfdG9rZW5fYXJvdW5kX2ltYWdlJTNFRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBQXNzaXN0YW50JTNBJw==",highlighted:`&lt;s&gt;<span class="hljs-title class_">User</span><span class="hljs-symbol">:&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;Describe</span> this image.
<span class="hljs-title class_">Assistant</span>: <span class="hljs-title class_">An</span> image of two kittens <span class="hljs-keyword">in</span> grass.
<span class="hljs-title class_">User</span><span class="hljs-symbol">:&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;Describe</span> this image.
<span class="hljs-title class_">Assistant</span><span class="hljs-symbol">:<span class="hljs-string">&#x27;</span></span>`,wrap:!1}}),{c(){o=m("p"),o.innerHTML=g,c=a(),_(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-c8byn"&&(o.innerHTML=g),c=r(t),b(i.$$.fragment,t)},m(t,h){l(t,o,h),l(t,c,h),T(i,t,h),u=!0},p:R,i(t){u||(y(i.$$.fragment,t),u=!0)},o(t){v(i.$$.fragment,t),u=!1},d(t){t&&(n(o),n(c)),M(i,t)}}}function sn(w){let o,g="To do training do:",c,i,u;return i=new tt({props:{code:"aW1hZ2VfdHJhbnNmb3JtJTIwJTNEJTIwdHJhbnNmb3Jtcy5Db21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tUmVzaXplZENyb3AoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHclMkMlMjBoKSUyQyUyMHNjYWxlJTNEKDAuOSUyQyUyMDEuMCklMkMlMjBpbnRlcnBvbGF0aW9uJTNEdHJhbnNmb3Jtcy5JbnRlcnBvbGF0aW9uTW9kZS5CSUNVQklDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKG1lYW4lM0RzZWxmLmltYWdlX21lYW4lMkMlMjBzdGQlM0RzZWxmLmltYWdlX3N0ZCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHByb21wdHMlMkMlMjB0cmFuc2Zvcm0lM0RpbWFnZV90cmFuc2Zvcm0lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:`image_transform = transforms.Compose(
    [
        transforms.RandomResizedCrop(
            (w, h), scale=(<span class="hljs-number">0.9</span>, <span class="hljs-number">1.0</span>), interpolation=transforms.InterpolationMode.BICUBIC
        ),
        transforms.ToTensor(),
        transforms.Normalize(mean=self.image_mean, std=self.image_std),
    ]
)
inputs = processor(prompts, transform=image_transform, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=g,c=a(),_(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-1jbe3nb"&&(o.textContent=g),c=r(t),b(i.$$.fragment,t)},m(t,h){l(t,o,h),l(t,c,h),T(i,t,h),u=!0},p:R,i(t){u||(y(i.$$.fragment,t),u=!0)},o(t){v(i.$$.fragment,t),u=!1},d(t){t&&(n(o),n(c)),M(i,t)}}}function an(w){let o,g,c,i,u,t,h,st,se,po='The IDEFICS model was proposed in <a href="https://huggingface.co/papers/2306.16527" rel="nofollow">OBELICS: An Open Web-Scale Filtered Dataset of Interleaved Image-Text Documents</a> by Hugo Laurençon, Lucile Saulnier, Léo Tronchon, Stas Bekman, Amanpreet Singh, Anton Lozhkov, Thomas Wang, Siddharth Karamcheti, Alexander M. Rush, Douwe Kiela, Matthieu Cord, Victor Sanh',at,ae,fo="The abstract from the paper is the following:",rt,re,uo="<em>Large multimodal models trained on natural documents, which interleave images and text, outperform models trained on image-text pairs on various multimodal benchmarks that require reasoning over one or multiple images to generate a text. However, the datasets used to train these models have not been released, and the collection process has not been fully specified. We introduce the OBELICS dataset, an open web-scale filtered dataset of interleaved image-text documents comprising 141 million web pages extracted from Common Crawl, 353 million associated images, and 115 billion text tokens. We describe the dataset creation process, present comprehensive filtering rules, and provide an analysis of the dataset’s content. To show the viability of OBELISC, we train an 80 billion parameters vision and language model on the dataset and obtain competitive performance on various multimodal benchmarks. We release the code to reproduce the dataset along with the dataset itself.</em>",it,ie,ho='This model was contributed by <a href="https://huggingface.co/HuggingFaceM4" rel="nofollow">HuggingFaceM4</a>. The original code can be found <a href="INSERT%20LINK%20TO%20GITHUB%20REPO%20HERE">here</a>. (TODO: don’t have a public link yet).',dt,A,lt,de,ct,k,le,zt,je,go=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a>. It is used to instantiate an
Idefics model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Idefics-9B.`,Ct,Fe,_o='e.g. <a href="https://huggingface.co/HuggingFaceM4/idefics-9b" rel="nofollow">HuggingFaceM4/idefics-9b</a>',Jt,Ne,bo=`Configuration objects inherit from <a href="/docs/transformers/pr_30627/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30627/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ut,G,mt,ce,To="## IdeficsModel[[transformers.IdeficsModel]]",pt,$,me,jt,We,yo=`The bare LLaMA Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/pr_30627/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ft,Ze,vo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Nt,Ve,Mo="Transformer decoder consisting of <code>config.num_hidden_layers</code> layers. Each layer is a <code>IdeficsDecoderLayer</code>",Wt,B,pe,Zt,Pe,Io='The <a href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a> forward method, overrides the <code>__call__</code> special method.',Vt,D,ft,fe,xo="## IdeficsForVisionText2Text[[transformers.IdeficsForVisionText2Text]]",ut,H,ue,Pt,N,he,Bt,Be,wo='The <a href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.IdeficsForVisionText2Text">IdeficsForVisionText2Text</a> forward method, overrides the <code>__call__</code> special method.',Rt,Y,Ht,O,ht,ge,ko="## TFIdeficsModel[[transformers.TFIdeficsModel]]",gt,E,_e,Et,Re,be,_t,Te,$o="## TFIdeficsForVisionText2Text[[transformers.TFIdeficsForVisionText2Text]]",bt,q,ye,qt,W,ve,St,He,zo='The <a href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.TFIdeficsForVisionText2Text">TFIdeficsForVisionText2Text</a> forward method, overrides the <code>__call__</code> special method.',Lt,X,At,Q,Tt,Me,Co="## IdeficsImageProcessor[[transformers.IdeficsImageProcessor]]",yt,Z,Ie,Gt,Ee,Jo="Constructs a Idefics image processor.",Dt,K,xe,Yt,qe,Uo="Preprocess a batch of images.",vt,we,jo="## IdeficsProcessor[[transformers.IdeficsProcessor]]",Mt,J,ke,Ot,Se,Fo="Constructs a IDEFICS processor which wraps a LLama tokenizer and IDEFICS image processor into a single processor.",Xt,Le,No=`<a href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.IdeficsProcessor">IdeficsProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a> and <a href="/docs/transformers/pr_30627/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See
the docstring of <a href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.IdeficsProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,Qt,I,$e,Kt,Ae,Wo=`This method takes batched or non-batched prompts made of text and images and converts them into prompts that
the model was trained on and prepares the image pixel values for the model to process.`,eo,Ge,Zo="Detailed explanation:",to,De,Vo="Each entry in <code>prompts</code> is either a text to be passed as is or an image that will be processed.",oo,Ye,Po="An image can be either an image object (<code>PIL.Image</code>) or a url from which the image can be retrieved.",no,Oe,Bo=`When the processor encounters an image it’ll inject <code>&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;</code>
entry into the prompt.`,so,ee,ao,te,ro,Xe,Ro=`and the two images will be massaged using <a href="/docs/transformers/pr_30627/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">IdeficsImageProcessor.<strong>call</strong>()</a> method and placed inside the
<code>pixel_values</code> dict entry of the return value.`,io,Qe,Ho=`This example also examplifies that images can be passed as objects or as text urls. It can be seen that the
first image is passed as object and the second one as a url.`,lo,oe,co,Ke,Eo="In order to help debug prompt generation enable <code>debug=True</code> which will show you what’s happening.",It,ze,xt,ot,wt;return u=new mo({props:{title:"IDEFICS",local:"idefics",headingTag:"h1"}}),h=new mo({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new $t({props:{warning:!0,$$slots:{default:[Yo]},$$scope:{ctx:w}}}),de=new mo({props:{title:"IdeficsConfig",local:"transformers.IdeficsConfig",headingTag:"h2"}}),le=new F({props:{name:"class transformers.IdeficsConfig",anchor:"transformers.IdeficsConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"additional_vocab_size",val:" = 0"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"dropout",val:" = 0.0"},{name:"hidden_act",val:" = 'silu'"},{name:"initializer_range",val:" = 0.02"},{name:"alpha_initializer",val:" = 'zeros'"},{name:"alphas_initializer_range",val:" = 0.0"},{name:"alpha_type",val:" = 'float'"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"cross_layer_interval",val:" = 1"},{name:"qk_layer_norms",val:" = False"},{name:"freeze_text_layers",val:" = True"},{name:"freeze_text_module_exceptions",val:" = []"},{name:"freeze_lm_head",val:" = False"},{name:"freeze_vision_layers",val:" = True"},{name:"freeze_vision_module_exceptions",val:" = []"},{name:"use_resampler",val:" = False"},{name:"vision_config",val:" = None"},{name:"perceiver_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsConfig.additional_vocab_size",description:`<strong>additional_vocab_size</strong> (<code>int</code>, *optional\`, defaults to 0) &#x2014;
Additional vocabulary size of the model, typically for the special &#x201D;<img>&#x201D; token. Additional vocab tokens
are always trainable whereas regular vocab tokens can be frozen or not.`,name:"additional_vocab_size"},{anchor:"transformers.IdeficsConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the Idefics model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.IdeficsModel">~IdeficsModel</a>`,name:"vocab_size"},{anchor:"transformers.IdeficsConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.IdeficsConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.IdeficsConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.IdeficsConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.IdeficsConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.IdeficsConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.IdeficsConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.IdeficsConfig.alpha_initializer",description:`<strong>alpha_initializer</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;zeros&quot;</code>) &#x2014;
Initialization type for the alphas.`,name:"alpha_initializer"},{anchor:"transformers.IdeficsConfig.alphas_initializer_range",description:`<strong>alphas_initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing the alphas in the Gated Cross
Attention.`,name:"alphas_initializer_range"},{anchor:"transformers.IdeficsConfig.alpha_type",description:`<strong>alpha_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;float&quot;</code>) &#x2014;
Whether the gating alphas should be vectors or single floats.`,name:"alpha_type"},{anchor:"transformers.IdeficsConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.IdeficsConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.IdeficsConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.IdeficsConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.IdeficsConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.IdeficsConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings(bool,"},{anchor:"transformers.IdeficsConfig.cross_layer_interval",description:`<strong>cross_layer_interval</strong> (<code>int</code>, <em>optional</em>, default to 1) &#x2014;
Interval for cross attention (from text to image) layers.`,name:"cross_layer_interval"},{anchor:"transformers.IdeficsConfig.qk_layer_norms",description:"<strong>qk_layer_norms</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to add layer norm after q and k",name:"qk_layer_norms"},{anchor:"transformers.IdeficsConfig.freeze_text_layers",description:"<strong>freeze_text_layers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; Whether to freeze text layers",name:"freeze_text_layers"},{anchor:"transformers.IdeficsConfig.freeze_text_module_exceptions",description:`<strong>freeze_text_module_exceptions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Exceptions to freezing text layers when <code>freeze_text_layers</code> is <code>True</code>`,name:"freeze_text_module_exceptions"},{anchor:"transformers.IdeficsConfig.freeze_lm_head",description:"<strong>freeze_lm_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to freeze lm head",name:"freeze_lm_head"},{anchor:"transformers.IdeficsConfig.freeze_vision_layers",description:"<strong>freeze_vision_layers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;  Whether to freeze vision layers",name:"freeze_vision_layers"},{anchor:"transformers.IdeficsConfig.freeze_vision_module_exceptions",description:`<strong>freeze_vision_module_exceptions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Exceptions to freezing vision layers when <code>freeze_vision_layers</code> is <code>True</code>`,name:"freeze_vision_module_exceptions"},{anchor:"transformers.IdeficsConfig.use_resampler",description:"<strong>use_resampler</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to use the Resampler",name:"use_resampler"},{anchor:"transformers.IdeficsConfig.vision_config",description:"<strong>vision_config</strong> (<code>IdeficsVisionConfig</code>,  <em>optional</em>) &#x2014; Custom vision config or dict",name:"vision_config"},{anchor:"transformers.IdeficsConfig.perceiver_config",description:"<strong>perceiver_config</strong> (<code>IdeficsPerceiverConfig</code>,  <em>optional</em>) &#x2014; Custom perceiver config or dict",name:"perceiver_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/configuration_idefics.py#L156"}}),G=new et({props:{anchor:"transformers.IdeficsConfig.example",$$slots:{default:[Oo]},$$scope:{ctx:w}}}),me=new F({props:{name:"class transformers.IdeficsModel",anchor:"transformers.IdeficsModel",parameters:[{name:"config",val:": IdeficsConfig"}],parametersDescription:[{anchor:"transformers.IdeficsModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/pr_30627/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; IdeficsConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/modeling_idefics.py#L1034"}}),pe=new F({props:{name:"forward",anchor:"transformers.IdeficsModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"image_encoder_embeddings",val:": Optional = None"},{name:"perceiver_embeddings",val:": Optional = None"},{name:"image_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": Optional = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.IdeficsModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.IdeficsModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.IdeficsModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.IdeficsModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.IdeficsModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.IdeficsModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.IdeficsModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IdeficsModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IdeficsModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30627/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/modeling_idefics.py#L1115"}}),D=new $t({props:{$$slots:{default:[Xo]},$$scope:{ctx:w}}}),ue=new F({props:{name:"class transformers.IdeficsForVisionText2Text",anchor:"transformers.IdeficsForVisionText2Text",parameters:[{name:"config",val:""},{name:"vision_model",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/modeling_idefics.py#L1373"}}),he=new F({props:{name:"forward",anchor:"transformers.IdeficsForVisionText2Text.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"image_encoder_embeddings",val:": Optional = None"},{name:"perceiver_embeddings",val:": Optional = None"},{name:"image_attention_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": Optional = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.IdeficsForVisionText2Text.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.IdeficsForVisionText2Text.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.IdeficsForVisionText2Text.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.IdeficsForVisionText2Text.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.IdeficsForVisionText2Text.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.IdeficsForVisionText2Text.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.IdeficsForVisionText2Text.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IdeficsForVisionText2Text.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IdeficsForVisionText2Text.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30627/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/modeling_idefics.py#L1431",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.idefics.modeling_idefics.IdeficsCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.IdeficsConfig"
>IdeficsConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.</p>
<p>image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.idefics.modeling_idefics.IdeficsCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new $t({props:{$$slots:{default:[Qo]},$$scope:{ctx:w}}}),O=new et({props:{anchor:"transformers.IdeficsForVisionText2Text.forward.example",$$slots:{default:[Ko]},$$scope:{ctx:w}}}),_e=new F({props:{name:"class transformers.TFIdeficsModel",anchor:"transformers.TFIdeficsModel",parameters:[{name:"config",val:": IdeficsConfig"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/modeling_tf_idefics.py#L1559"}}),be=new F({props:{name:"call",anchor:"transformers.TFIdeficsModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": Optional[tf.Tensor] = None"},{name:"position_ids",val:": Optional[tf.Tensor] = None"},{name:"past_key_values",val:": Optional[List[tf.Tensor]] = None"},{name:"inputs_embeds",val:": Optional[tf.Tensor] = None"},{name:"pixel_values",val:": Optional[tf.Tensor] = None"},{name:"image_encoder_embeddings",val:": Optional[tf.Tensor] = None"},{name:"perceiver_embeddings",val:": Optional[tf.Tensor] = None"},{name:"image_attention_mask",val:": Optional[tf.Tensor] = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": Optional[bool] = False"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/modeling_tf_idefics.py#L1565"}}),ye=new F({props:{name:"class transformers.TFIdeficsForVisionText2Text",anchor:"transformers.TFIdeficsForVisionText2Text",parameters:[{name:"config",val:""},{name:"vision_model",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/modeling_tf_idefics.py#L1611"}}),ve=new F({props:{name:"call",anchor:"transformers.TFIdeficsForVisionText2Text.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": Optional[tf.Tensor] = None"},{name:"position_ids",val:": Optional[tf.Tensor] = None"},{name:"past_key_values",val:": Optional[List[tf.Tensor]] = None"},{name:"inputs_embeds",val:": Optional[tf.Tensor] = None"},{name:"pixel_values",val:": Optional[tf.Tensor] = None"},{name:"image_encoder_embeddings",val:": Optional[tf.Tensor] = None"},{name:"perceiver_embeddings",val:": Optional[tf.Tensor] = None"},{name:"image_attention_mask",val:": Optional[tf.Tensor] = None"},{name:"labels",val:": Optional[tf.Tensor] = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": Optional[bool] = False"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:" = False"}],parametersDescription:[{anchor:"transformers.TFIdeficsForVisionText2Text.call.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30627/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30627/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(tf.Tensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFIdeficsForVisionText2Text.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_30627/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/modeling_tf_idefics.py#L1667",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.idefics.modeling_tf_idefics.TFIdeficsCausalLMOutputWithPast</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.IdeficsConfig"
>IdeficsConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(tf.Tensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>) — Tuple of <code>tf.Tensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.</p>
<p>image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.idefics.modeling_tf_idefics.TFIdeficsCausalLMOutputWithPast</code> or <code>tuple(tf.Tensor)</code></p>
`}}),X=new $t({props:{$$slots:{default:[en]},$$scope:{ctx:w}}}),Q=new et({props:{anchor:"transformers.TFIdeficsForVisionText2Text.call.example",$$slots:{default:[tn]},$$scope:{ctx:w}}}),Ie=new F({props:{name:"class transformers.IdeficsImageProcessor",anchor:"transformers.IdeficsImageProcessor",parameters:[{name:"image_size",val:": int = 224"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"image_num_channels",val:": Optional = 3"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsImageProcessor.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
Resize to image size`,name:"image_size"},{anchor:"transformers.IdeficsImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.IdeficsImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.IdeficsImageProcessor.image_num_channels",description:`<strong>image_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of image channels.`,name:"image_num_channels"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/image_processing_idefics.py#L51"}}),xe=new F({props:{name:"preprocess",anchor:"transformers.IdeficsImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"image_num_channels",val:": Optional = 3"},{name:"image_size",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"transform",val:": Callable = None"},{name:"return_tensors",val:": Union = <TensorType.PYTORCH: 'pt'>"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
A list of images to preprocess.`,name:"images"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_size</code>) &#x2014;
Resize to image size`,name:"image_size"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_num_channels",description:`<strong>image_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_num_channels</code>) &#x2014;
Number of image channels.`,name:"image_num_channels"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can
be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.IdeficsImageProcessor.preprocess.transform",description:`<strong>transform</strong> (<code>Callable</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
A custom transform function that accepts a single image can be passed for training. For example,
<code>torchvision.Compose</code> can be used to compose multiple transforms. If <code>None</code> - an inference mode is
assumed - and then a preset of inference-specific transforms will be applied to the images`,name:"transform"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/image_processing_idefics.py#L87",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a PyTorch tensor of the processed images</p>
`}}),ke=new F({props:{name:"class transformers.IdeficsProcessor",anchor:"transformers.IdeficsProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:" = None"},{name:"image_size",val:" = 224"},{name:"add_end_of_utterance_token",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsProcessor.image_processor",description:`<strong>image_processor</strong> (<code>IdeficsImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/pr_30627/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.IdeficsProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>LlamaTokenizerFast</code>) &#x2014;
An instance of <a href="/docs/transformers/pr_30627/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.IdeficsProcessor.image_size",description:"<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014; Image size (assuming a square image)",name:"image_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/processing_idefics.py#L160"}}),$e=new F({props:{name:"__call__",anchor:"transformers.IdeficsProcessor.__call__",parameters:[{name:"prompts",val:": Union"},{name:"padding",val:": Union = 'longest'"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"transform",val:": Callable = None"},{name:"add_eos_token",val:" = False"},{name:"add_end_of_utterance_token",val:" = None"},{name:"debug",val:" = False"},{name:"return_tensors",val:" = 'pt'"}],parametersDescription:[{anchor:"transformers.IdeficsProcessor.__call__.prompts",description:`<strong>prompts</strong> (<code>Union[List[TextInput], [List[List[TextInput]]]]</code>) &#x2014;
either a single prompt or a batched list of prompts - see the detailed description immediately after
the end of the arguments doc section.`,name:"prompts"},{anchor:"transformers.IdeficsProcessor.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/pr_30627/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>&quot;longest&quot;</code>) &#x2014;
Select a strategy to pad the returned sequences (according to the model&#x2019;s padding side and padding
index) among:<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code> (default): Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code>: No padding. This will raise an error if the input sequences are of different
lengths.
Note: Unlike most processors, which set padding=<code>False</code> by default, <code>IdeficsProcessor</code> sets <code>padding=&quot;longest&quot;</code>
by default. See <a href="https://github.com/huggingface/transformers/pull/29449#pullrequestreview-1925576061" rel="nofollow">https://github.com/huggingface/transformers/pull/29449#pullrequestreview-1925576061</a> for why.</li>
</ul>`,name:"padding"},{anchor:"transformers.IdeficsProcessor.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum length of the returned list and optionally padding length (see above).`,name:"max_length"},{anchor:"transformers.IdeficsProcessor.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates truncation to cut input sequences longer than <code>max_length</code> to <code>max_length</code>.`,name:"truncation"},{anchor:"transformers.IdeficsProcessor.__call__.transform",description:`<strong>transform</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A custom transform function that accepts a single image can be passed for training. For example,
<code>torchvision.Compose</code> can be used to compose multiple functions. If <code>None</code> a preset inference-specific
set of transforms will be applied to the images`,name:"transform"},{anchor:"transformers.IdeficsProcessor.__call__.add_eos_token",description:"<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;\nAdds <code>eos_token</code> at the end of the final prompt if True`",name:"add_eos_token"},{anchor:"transformers.IdeficsProcessor.__call__.add_end_of_utterance_token",description:`<strong>add_end_of_utterance_token</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to automatically add <code>&lt;end_of_utterance&gt;</code> after each prompt&#x2019;s text input (unless followed by an
image). If <code>None</code> the tokenizer will be checked instead and if this token is found in
<code>additional_special_tokens</code> then the value will be <code>True</code>.`,name:"add_end_of_utterance_token"},{anchor:"transformers.IdeficsProcessor.__call__.debug",description:`<strong>debug</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
<code>True</code> value will help debug prompt generation by dumping useful information`,name:"debug"},{anchor:"transformers.IdeficsProcessor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>TensorType.PYTORCH</code>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/vr_30627/src/transformers/models/idefics/processing_idefics.py#L201",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>input_ids</code>, <code>attention_mask</code>, <code>pixel_values</code>, <code>image_attention_mask</code> which can be
directly passed to <code>model.generate</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a dict with entries</p>
`}}),ee=new et({props:{anchor:"transformers.IdeficsProcessor.__call__.example",$$slots:{default:[on]},$$scope:{ctx:w}}}),te=new et({props:{anchor:"transformers.IdeficsProcessor.__call__.example-2",$$slots:{default:[nn]},$$scope:{ctx:w}}}),oe=new et({props:{anchor:"transformers.IdeficsProcessor.__call__.example-3",$$slots:{default:[sn]},$$scope:{ctx:w}}}),ze=new Do({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/idefics.md"}}),{c(){o=m("meta"),g=a(),c=m("p"),i=a(),_(u.$$.fragment),t=a(),_(h.$$.fragment),st=a(),se=m("p"),se.innerHTML=po,at=a(),ae=m("p"),ae.textContent=fo,rt=a(),re=m("p"),re.innerHTML=uo,it=a(),ie=m("p"),ie.innerHTML=ho,dt=a(),_(A.$$.fragment),lt=a(),_(de.$$.fragment),ct=a(),k=m("div"),_(le.$$.fragment),zt=a(),je=m("p"),je.innerHTML=go,Ct=a(),Fe=m("p"),Fe.innerHTML=_o,Jt=a(),Ne=m("p"),Ne.innerHTML=bo,Ut=a(),_(G.$$.fragment),mt=a(),ce=m("p"),ce.textContent=To,pt=a(),$=m("div"),_(me.$$.fragment),jt=a(),We=m("p"),We.innerHTML=yo,Ft=a(),Ze=m("p"),Ze.innerHTML=vo,Nt=a(),Ve=m("p"),Ve.innerHTML=Mo,Wt=a(),B=m("div"),_(pe.$$.fragment),Zt=a(),Pe=m("p"),Pe.innerHTML=Io,Vt=a(),_(D.$$.fragment),ft=a(),fe=m("p"),fe.textContent=xo,ut=a(),H=m("div"),_(ue.$$.fragment),Pt=a(),N=m("div"),_(he.$$.fragment),Bt=a(),Be=m("p"),Be.innerHTML=wo,Rt=a(),_(Y.$$.fragment),Ht=a(),_(O.$$.fragment),ht=a(),ge=m("p"),ge.textContent=ko,gt=a(),E=m("div"),_(_e.$$.fragment),Et=a(),Re=m("div"),_(be.$$.fragment),_t=a(),Te=m("p"),Te.textContent=$o,bt=a(),q=m("div"),_(ye.$$.fragment),qt=a(),W=m("div"),_(ve.$$.fragment),St=a(),He=m("p"),He.innerHTML=zo,Lt=a(),_(X.$$.fragment),At=a(),_(Q.$$.fragment),Tt=a(),Me=m("p"),Me.textContent=Co,yt=a(),Z=m("div"),_(Ie.$$.fragment),Gt=a(),Ee=m("p"),Ee.textContent=Jo,Dt=a(),K=m("div"),_(xe.$$.fragment),Yt=a(),qe=m("p"),qe.textContent=Uo,vt=a(),we=m("p"),we.textContent=jo,Mt=a(),J=m("div"),_(ke.$$.fragment),Ot=a(),Se=m("p"),Se.textContent=Fo,Xt=a(),Le=m("p"),Le.innerHTML=No,Qt=a(),I=m("div"),_($e.$$.fragment),Kt=a(),Ae=m("p"),Ae.textContent=Wo,eo=a(),Ge=m("p"),Ge.textContent=Zo,to=a(),De=m("p"),De.innerHTML=Vo,oo=a(),Ye=m("p"),Ye.innerHTML=Po,no=a(),Oe=m("p"),Oe.innerHTML=Bo,so=a(),_(ee.$$.fragment),ao=a(),_(te.$$.fragment),ro=a(),Xe=m("p"),Xe.innerHTML=Ro,io=a(),Qe=m("p"),Qe.textContent=Ho,lo=a(),_(oe.$$.fragment),co=a(),Ke=m("p"),Ke.innerHTML=Eo,It=a(),_(ze.$$.fragment),xt=a(),ot=m("p"),this.h()},l(e){const s=Go("svelte-u9bgzb",document.head);o=p(s,"META",{name:!0,content:!0}),s.forEach(n),g=r(e),c=p(e,"P",{}),z(c).forEach(n),i=r(e),b(u.$$.fragment,e),t=r(e),b(h.$$.fragment,e),st=r(e),se=p(e,"P",{"data-svelte-h":!0}),f(se)!=="svelte-jddp08"&&(se.innerHTML=po),at=r(e),ae=p(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-vfdo9a"&&(ae.textContent=fo),rt=r(e),re=p(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-18xi2yr"&&(re.innerHTML=uo),it=r(e),ie=p(e,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-1nhi3a3"&&(ie.innerHTML=ho),dt=r(e),b(A.$$.fragment,e),lt=r(e),b(de.$$.fragment,e),ct=r(e),k=p(e,"DIV",{class:!0});var U=z(k);b(le.$$.fragment,U),zt=r(U),je=p(U,"P",{"data-svelte-h":!0}),f(je)!=="svelte-18s7swq"&&(je.innerHTML=go),Ct=r(U),Fe=p(U,"P",{"data-svelte-h":!0}),f(Fe)!=="svelte-n7bqeh"&&(Fe.innerHTML=_o),Jt=r(U),Ne=p(U,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-10j4as7"&&(Ne.innerHTML=bo),Ut=r(U),b(G.$$.fragment,U),U.forEach(n),mt=r(e),ce=p(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-4uaji8"&&(ce.textContent=To),pt=r(e),$=p(e,"DIV",{class:!0});var j=z($);b(me.$$.fragment,j),jt=r(j),We=p(j,"P",{"data-svelte-h":!0}),f(We)!=="svelte-bw6i6p"&&(We.innerHTML=yo),Ft=r(j),Ze=p(j,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-1ydu1el"&&(Ze.innerHTML=vo),Nt=r(j),Ve=p(j,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-1rhjct8"&&(Ve.innerHTML=Mo),Wt=r(j),B=p(j,"DIV",{class:!0});var S=z(B);b(pe.$$.fragment,S),Zt=r(S),Pe=p(S,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-1py8m3e"&&(Pe.innerHTML=Io),Vt=r(S),b(D.$$.fragment,S),S.forEach(n),j.forEach(n),ft=r(e),fe=p(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-pohqq4"&&(fe.textContent=xo),ut=r(e),H=p(e,"DIV",{class:!0});var Ce=z(H);b(ue.$$.fragment,Ce),Pt=r(Ce),N=p(Ce,"DIV",{class:!0});var V=z(N);b(he.$$.fragment,V),Bt=r(V),Be=p(V,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-11j05bm"&&(Be.innerHTML=wo),Rt=r(V),b(Y.$$.fragment,V),Ht=r(V),b(O.$$.fragment,V),V.forEach(n),Ce.forEach(n),ht=r(e),ge=p(e,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-jrjvgg"&&(ge.textContent=ko),gt=r(e),E=p(e,"DIV",{class:!0});var Je=z(E);b(_e.$$.fragment,Je),Et=r(Je),Re=p(Je,"DIV",{class:!0});var nt=z(Re);b(be.$$.fragment,nt),nt.forEach(n),Je.forEach(n),_t=r(e),Te=p(e,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-886gk0"&&(Te.textContent=$o),bt=r(e),q=p(e,"DIV",{class:!0});var Ue=z(q);b(ye.$$.fragment,Ue),qt=r(Ue),W=p(Ue,"DIV",{class:!0});var P=z(W);b(ve.$$.fragment,P),St=r(P),He=p(P,"P",{"data-svelte-h":!0}),f(He)!=="svelte-9zzqky"&&(He.innerHTML=zo),Lt=r(P),b(X.$$.fragment,P),At=r(P),b(Q.$$.fragment,P),P.forEach(n),Ue.forEach(n),Tt=r(e),Me=p(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-ivp3y8"&&(Me.textContent=Co),yt=r(e),Z=p(e,"DIV",{class:!0});var L=z(Z);b(Ie.$$.fragment,L),Gt=r(L),Ee=p(L,"P",{"data-svelte-h":!0}),f(Ee)!=="svelte-1m1ucrf"&&(Ee.textContent=Jo),Dt=r(L),K=p(L,"DIV",{class:!0});var kt=z(K);b(xe.$$.fragment,kt),Yt=r(kt),qe=p(kt,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-1xds4wy"&&(qe.textContent=Uo),kt.forEach(n),L.forEach(n),vt=r(e),we=p(e,"P",{"data-svelte-h":!0}),f(we)!=="svelte-1ea5jza"&&(we.textContent=jo),Mt=r(e),J=p(e,"DIV",{class:!0});var ne=z(J);b(ke.$$.fragment,ne),Ot=r(ne),Se=p(ne,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-ntsjs9"&&(Se.textContent=Fo),Xt=r(ne),Le=p(ne,"P",{"data-svelte-h":!0}),f(Le)!=="svelte-1iu75ci"&&(Le.innerHTML=No),Qt=r(ne),I=p(ne,"DIV",{class:!0});var x=z(I);b($e.$$.fragment,x),Kt=r(x),Ae=p(x,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-1dgzv8j"&&(Ae.textContent=Wo),eo=r(x),Ge=p(x,"P",{"data-svelte-h":!0}),f(Ge)!=="svelte-qv5ndj"&&(Ge.textContent=Zo),to=r(x),De=p(x,"P",{"data-svelte-h":!0}),f(De)!=="svelte-xvvltg"&&(De.innerHTML=Vo),oo=r(x),Ye=p(x,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-15i05k0"&&(Ye.innerHTML=Po),no=r(x),Oe=p(x,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-gstss4"&&(Oe.innerHTML=Bo),so=r(x),b(ee.$$.fragment,x),ao=r(x),b(te.$$.fragment,x),ro=r(x),Xe=p(x,"P",{"data-svelte-h":!0}),f(Xe)!=="svelte-1vpqmkq"&&(Xe.innerHTML=Ro),io=r(x),Qe=p(x,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-9aj4iv"&&(Qe.textContent=Ho),lo=r(x),b(oe.$$.fragment,x),co=r(x),Ke=p(x,"P",{"data-svelte-h":!0}),f(Ke)!=="svelte-1drva0b"&&(Ke.innerHTML=Eo),x.forEach(n),ne.forEach(n),It=r(e),b(ze.$$.fragment,e),xt=r(e),ot=p(e,"P",{}),z(ot).forEach(n),this.h()},h(){C(o,"name","hf:doc:metadata"),C(o,"content",rn),C(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){d(document.head,o),l(e,g,s),l(e,c,s),l(e,i,s),T(u,e,s),l(e,t,s),T(h,e,s),l(e,st,s),l(e,se,s),l(e,at,s),l(e,ae,s),l(e,rt,s),l(e,re,s),l(e,it,s),l(e,ie,s),l(e,dt,s),T(A,e,s),l(e,lt,s),T(de,e,s),l(e,ct,s),l(e,k,s),T(le,k,null),d(k,zt),d(k,je),d(k,Ct),d(k,Fe),d(k,Jt),d(k,Ne),d(k,Ut),T(G,k,null),l(e,mt,s),l(e,ce,s),l(e,pt,s),l(e,$,s),T(me,$,null),d($,jt),d($,We),d($,Ft),d($,Ze),d($,Nt),d($,Ve),d($,Wt),d($,B),T(pe,B,null),d(B,Zt),d(B,Pe),d(B,Vt),T(D,B,null),l(e,ft,s),l(e,fe,s),l(e,ut,s),l(e,H,s),T(ue,H,null),d(H,Pt),d(H,N),T(he,N,null),d(N,Bt),d(N,Be),d(N,Rt),T(Y,N,null),d(N,Ht),T(O,N,null),l(e,ht,s),l(e,ge,s),l(e,gt,s),l(e,E,s),T(_e,E,null),d(E,Et),d(E,Re),T(be,Re,null),l(e,_t,s),l(e,Te,s),l(e,bt,s),l(e,q,s),T(ye,q,null),d(q,qt),d(q,W),T(ve,W,null),d(W,St),d(W,He),d(W,Lt),T(X,W,null),d(W,At),T(Q,W,null),l(e,Tt,s),l(e,Me,s),l(e,yt,s),l(e,Z,s),T(Ie,Z,null),d(Z,Gt),d(Z,Ee),d(Z,Dt),d(Z,K),T(xe,K,null),d(K,Yt),d(K,qe),l(e,vt,s),l(e,we,s),l(e,Mt,s),l(e,J,s),T(ke,J,null),d(J,Ot),d(J,Se),d(J,Xt),d(J,Le),d(J,Qt),d(J,I),T($e,I,null),d(I,Kt),d(I,Ae),d(I,eo),d(I,Ge),d(I,to),d(I,De),d(I,oo),d(I,Ye),d(I,no),d(I,Oe),d(I,so),T(ee,I,null),d(I,ao),T(te,I,null),d(I,ro),d(I,Xe),d(I,io),d(I,Qe),d(I,lo),T(oe,I,null),d(I,co),d(I,Ke),l(e,It,s),T(ze,e,s),l(e,xt,s),l(e,ot,s),wt=!0},p(e,[s]){const U={};s&2&&(U.$$scope={dirty:s,ctx:e}),A.$set(U);const j={};s&2&&(j.$$scope={dirty:s,ctx:e}),G.$set(j);const S={};s&2&&(S.$$scope={dirty:s,ctx:e}),D.$set(S);const Ce={};s&2&&(Ce.$$scope={dirty:s,ctx:e}),Y.$set(Ce);const V={};s&2&&(V.$$scope={dirty:s,ctx:e}),O.$set(V);const Je={};s&2&&(Je.$$scope={dirty:s,ctx:e}),X.$set(Je);const nt={};s&2&&(nt.$$scope={dirty:s,ctx:e}),Q.$set(nt);const Ue={};s&2&&(Ue.$$scope={dirty:s,ctx:e}),ee.$set(Ue);const P={};s&2&&(P.$$scope={dirty:s,ctx:e}),te.$set(P);const L={};s&2&&(L.$$scope={dirty:s,ctx:e}),oe.$set(L)},i(e){wt||(y(u.$$.fragment,e),y(h.$$.fragment,e),y(A.$$.fragment,e),y(de.$$.fragment,e),y(le.$$.fragment,e),y(G.$$.fragment,e),y(me.$$.fragment,e),y(pe.$$.fragment,e),y(D.$$.fragment,e),y(ue.$$.fragment,e),y(he.$$.fragment,e),y(Y.$$.fragment,e),y(O.$$.fragment,e),y(_e.$$.fragment,e),y(be.$$.fragment,e),y(ye.$$.fragment,e),y(ve.$$.fragment,e),y(X.$$.fragment,e),y(Q.$$.fragment,e),y(Ie.$$.fragment,e),y(xe.$$.fragment,e),y(ke.$$.fragment,e),y($e.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),y(ze.$$.fragment,e),wt=!0)},o(e){v(u.$$.fragment,e),v(h.$$.fragment,e),v(A.$$.fragment,e),v(de.$$.fragment,e),v(le.$$.fragment,e),v(G.$$.fragment,e),v(me.$$.fragment,e),v(pe.$$.fragment,e),v(D.$$.fragment,e),v(ue.$$.fragment,e),v(he.$$.fragment,e),v(Y.$$.fragment,e),v(O.$$.fragment,e),v(_e.$$.fragment,e),v(be.$$.fragment,e),v(ye.$$.fragment,e),v(ve.$$.fragment,e),v(X.$$.fragment,e),v(Q.$$.fragment,e),v(Ie.$$.fragment,e),v(xe.$$.fragment,e),v(ke.$$.fragment,e),v($e.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),v(oe.$$.fragment,e),v(ze.$$.fragment,e),wt=!1},d(e){e&&(n(g),n(c),n(i),n(t),n(st),n(se),n(at),n(ae),n(rt),n(re),n(it),n(ie),n(dt),n(lt),n(ct),n(k),n(mt),n(ce),n(pt),n($),n(ft),n(fe),n(ut),n(H),n(ht),n(ge),n(gt),n(E),n(_t),n(Te),n(bt),n(q),n(Tt),n(Me),n(yt),n(Z),n(vt),n(we),n(Mt),n(J),n(It),n(xt),n(ot)),n(o),M(u,e),M(h,e),M(A,e),M(de,e),M(le),M(G),M(me),M(pe),M(D),M(ue),M(he),M(Y),M(O),M(_e),M(be),M(ye),M(ve),M(X),M(Q),M(Ie),M(xe),M(ke),M($e),M(ee),M(te),M(oe),M(ze,e)}}}const rn='{"title":"IDEFICS","local":"idefics","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"IdeficsConfig","local":"transformers.IdeficsConfig","sections":[],"depth":2}],"depth":1}';function dn(w){return So(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gn extends Lo{constructor(o){super(),Ao(this,o,dn,an,qo,{})}}export{gn as component};
