import{s as ll,n as el,o as sl}from"../chunks/scheduler.71ff668b.js";import{S as nl,i as al,g as U,s as n,r as p,A as Ul,h as J,f as e,c as a,j as Kt,u as o,x as M,k as tl,y as Jl,a as s,v as T,d as i,t as m,w as y}from"../chunks/index.e0973da1.js";import{C as Bt}from"../chunks/CodeBlock.0c9622a3.js";import{C as Ml}from"../chunks/CourseFloatingBanner.69eb4e28.js";import{H as r,E as pl}from"../chunks/getInferenceSnippets.c8ffc8ef.js";function ol(kt){let f,H,q,K,g,tt,u,lt,d,It="LoRAは最も広く採用されているPEFTメソッドとなっています。これは、注意重み行列に小さなランク分解行列を追加することで機能し、通常、学習可能なパラメータを約90％削減します。",et,F,st,V,vt='LoRA（低ランク適応）は、事前学習されたモデルの重みを固定し、学習可能なランク分解行列をモデルの層に注入するパラメータ効率の良い微調整技術です。微調整中にすべてのモデルパラメータを学習する代わりに、LoRAは低ランク分解を通じて重みの更新を小さな行列に分解し、学習可能なパラメータの数を大幅に削減しながらモデルの性能を維持します。例えば、GPT-3 175Bに適用した場合、LoRAは学習可能なパラメータを10,000倍、GPUメモリ要件を3倍削減しました。LoRAについての詳細は<a href="https://arxiv.org/pdf/2106.09685" rel="nofollow">LoRA論文</a>を参照してください。',nt,w,At="LoRAは、通常、注意重みに焦点を当てて、トランスフォーマーレイヤーにランク分解行列のペアを追加することで機能します。推論中に、これらのアダプタ重みはベースモデルと統合され、追加の遅延オーバーヘッドが発生しません。LoRAは、大規模な言語モデルを特定のタスクやドメインに適応させるのに特に役立ち、リソース要件を管理可能に保ちます。",at,c,Ut,$,Qt="アダプタは、load_adapter()を使用して事前学習されたモデルに読み込むことができ、これは重みが統合されていない異なるアダプタを試すのに便利です。set_adapter()関数を使用してアクティブなアダプタ重みを設定します。ベースモデルに戻るには、unload()を使用してすべてのLoRAモジュールをアンロードできます。これにより、異なるタスク固有の重み間の切り替えが容易になります。",Jt,C,Mt,b,Lt='<img src="./images/lora_adapter.png" alt="lora_load_adapter"/>',pt,R,ot,h,xt="LoRAでトレーニングした後、アダプタ重みをベースモデルに統合して、デプロイを容易にすることができます。これにより、統合された重みを持つ単一のモデルが作成され、推論中にアダプタを別々に読み込む必要がなくなります。",Tt,j,Nt="統合プロセスには、メモリ管理と精度に注意が必要です。ベースモデルとアダプタ重みの両方を同時に読み込む必要があるため、十分なGPU/CPUメモリが利用可能であることを確認してください。<code>transformers</code>の<code>device_map=&quot;auto&quot;</code>を使用すると、自動メモリ管理が容易になります。トレーニング中に使用した精度（例：float16）を一貫して維持し、統合されたモデルを同じ形式で保存してデプロイします。デプロイ前に、アダプタベースのバージョンと出力および性能メトリックを比較して、統合されたモデルを検証してください。",it,E,Gt="アダプタは、異なるタスクやドメイン間の切り替えにも便利です。ベースモデルとアダプタ重みを別々に読み込むことができます。これにより、異なるタスク固有の重み間の迅速な切り替えが可能になります。",mt,z,yt,_,Wt="<code>notebooks/</code>ディレクトリには、さまざまなPEFTメソッドを実装するための実践的なチュートリアルと演習が含まれています。基本的な紹介には<code>load_lora_adapter_example.ipynb</code>を、LoRAとSFTを使用したモデルの微調整について詳しく知りたい場合は<code>lora_finetuning.ipynb</code>を参照してください。",rt,Z,St="PEFTメソッドを実装する際は、LoRAのランク値（4-8）を小さく設定し、トレーニング損失を監視します。検証セットを使用して過学習を防ぎ、可能であればフルファインチューニングのベースラインと結果を比較します。異なるメソッドの有効性はタスクによって異なるため、実験が重要です。",ft,B,gt,k,Ot='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a>は、QR分解を使用してLoRAアダプタを初期化します。OLoRAは、QR分解の係数によってモデルのベース重みを変換します。つまり、トレーニングを行う前に重みを変換します。このアプローチは、安定性を大幅に向上させ、収束速度を加速し、最終的に優れた性能を達成します。',ut,I,dt,v,Xt="PEFTメソッドは、TRL（Transformers Reinforcement Learning）と組み合わせて効率的な微調整を行うことができます。この統合は、RLHF（Reinforcement Learning from Human Feedback）に特に有用であり、メモリ要件を削減します。",Ft,A,Vt,Q,Pt="上記では、<code>device_map=&quot;auto&quot;</code>を使用してモデルを自動的に適切なデバイスに割り当てました。また、<code>device_map={&quot;&quot;: device_index}</code>を使用してモデルを特定のデバイスに手動で割り当てることもできます。メモリ使用量を効率的に保ちながら、複数のGPUにトレーニングをスケールすることもできます。",wt,L,ct,x,Dt="LoRAアダプタをトレーニングした後、アダプタ重みをベースモデルに統合することができます。以下はその方法です：",$t,N,Ct,G,qt="保存されたモデルのサイズに不一致がある場合は、トークナイザーも保存していることを確認してください：",bt,W,Rt,S,ht,O,Yt=`⏩ <a href="prompt_tuning.md">プロンプトチューニング</a>ガイドに進み、プロンプトチューニングでモデルを微調整する方法を学びましょう。
⏩ <a href="../../../notebooks/ja/3_parameter_efficient_finetuning/load_lora_adapter.ipynb">LoRAアダプタの読み込みチュートリアル</a>に進み、LoRAアダプタを読み込む方法を学びましょう。`,jt,X,Et,P,Ht='<li><a href="https://arxiv.org/pdf/2106.09685" rel="nofollow">LORA: LOW-RANK ADAPTATION OF LARGE LANGUAGE MODELS</a></li> <li><a href="https://huggingface.co/docs/peft" rel="nofollow">PEFTドキュメント</a></li> <li><a href="https://huggingface.co/blog/peft" rel="nofollow">Hugging FaceのPEFTに関するブログ記事</a></li>',zt,D,_t,Y,Zt;return g=new r({props:{title:"LoRA (低ランク適応)",local:"lora-低ランク適応",headingTag:"h1"}}),u=new Ml({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/ja/3_parameter_efficient_finetuning/finetune_sft_peft.ipynb"}]}}),F=new r({props:{title:"LoRAの理解",local:"loraの理解",headingTag:"h2"}}),c=new r({props:{title:"LoRAアダプタの読み込み",local:"loraアダプタの読み込み",headingTag:"h2"}}),C=new Bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiUzQ2Jhc2VfbW9kZWxfbmFtZSUzRSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDcGVmdF9hZGFwdGVyX2lkJTNFJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;&lt;base_model_name&gt;&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;&lt;peft_adapter_id&gt;&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),R=new r({props:{title:"LoRAアダプタの統合",local:"loraアダプタの統合",headingTag:"h2"}}),z=new r({props:{title:"実装ガイド",local:"実装ガイド",headingTag:"h2"}}),B=new r({props:{title:"OLoRA",local:"olora",headingTag:"h2"}}),I=new r({props:{title:"TRLとPEFTの使用",local:"trlとpeftの使用",headingTag:"h2"}}),A=new Bt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwUEVGVCVFOCVBOCVBRCVFNSVBRSU5QSVFMyU4MSVBNyVFMyU4MyVBMiVFMyU4MyU4NyVFMyU4MyVBQiVFMyU4MiU5MiVFOCVBQSVBRCVFMyU4MSVCRiVFOCVCRSVCQyVFMyU4MiU4MCUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBJTIzJTIwJUU3JTg5JUI5JUU1JUFFJTlBJUUzJTgxJUFFJUUzJTgzJTg3JUUzJTgzJTkwJUUzJTgyJUE0JUUzJTgyJUI5JUUzJTgxJUFCJUUzJTgzJUEyJUUzJTgzJTg3JUUzJTgzJUFCJUUzJTgyJTkyJUU4JUFBJUFEJUUzJTgxJUJGJUU4JUJFJUJDJUUzJTgyJTgwJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyeW91ci1tb2RlbC1uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMCVFMyU4MiVBQSVFMyU4MyU5NyVFMyU4MiVCNyVFMyU4MyVBNyVFMyU4MyVCMyUzQSUyMDglRTMlODMlOTMlRTMlODMlODMlRTMlODMlODglRTclQjIlQkUlRTUlQkElQTYlRTMlODIlOTIlRTQlQkQlQkYlRTclOTQlQTglMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEbG9yYV9jb25maWclMEEp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># PEFT設定でモデルを読み込む</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

<span class="hljs-comment"># 特定のデバイスにモデルを読み込む</span>
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;your-model-name&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># オプション: 8ビット精度を使用</span>
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    peft_config=lora_config
)`,wrap:!1}}),L=new r({props:{title:"基本的な統合実装",local:"基本的な統合実装",headingTag:"h2"}}),N=new Bt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

<span class="hljs-comment"># 1. ベースモデルを読み込む</span>
base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;base_model_name&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-comment"># 2. アダプタを持つPEFTモデルを読み込む</span>
peft_model = PeftModel.from_pretrained(
    base_model,
    <span class="hljs-string">&quot;path/to/adapter&quot;</span>,
    torch_dtype=torch.float16
)

<span class="hljs-comment"># 3. アダプタ重みをベースモデルと統合</span>
<span class="hljs-keyword">try</span>:
    merged_model = peft_model.merge_and_unload()
<span class="hljs-keyword">except</span> RuntimeError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;統合に失敗しました: <span class="hljs-subst">{e}</span>&quot;</span>)
    <span class="hljs-comment"># フォールバック戦略またはメモリ最適化を実装</span>

<span class="hljs-comment"># 4. 統合されたモデルを保存</span>
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),W=new Bt({props:{code:"JTIzJTIwJUUzJTgzJUEyJUUzJTgzJTg3JUUzJTgzJUFCJUUzJTgxJUE4JUUzJTgzJTg4JUUzJTgzJUJDJUUzJTgyJUFGJUUzJTgzJThBJUUzJTgyJUE0JUUzJTgyJUI2JUUzJTgzJUJDJUUzJTgxJUFFJUU0JUI4JUExJUU2JTk2JUI5JUUzJTgyJTkyJUU0JUJGJTlEJUU1JUFEJTk4JTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmFzZV9tb2RlbF9uYW1lJTIyKSUwQW1lcmdlZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGc2F2ZSUyRm1lcmdlZF9tb2RlbCUyMiklMEF0b2tlbml6ZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRnNhdmUlMkZtZXJnZWRfbW9kZWwlMjIp",highlighted:`<span class="hljs-comment"># モデルとトークナイザーの両方を保存</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;base_model_name&quot;</span>)
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),S=new r({props:{title:"次のステップ",local:"次のステップ",headingTag:"h2"}}),X=new r({props:{title:"リソース",local:"リソース",headingTag:"h1"}}),D=new pl({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/ja/unit3/2.md"}}),{c(){f=U("meta"),H=n(),q=U("p"),K=n(),p(g.$$.fragment),tt=n(),p(u.$$.fragment),lt=n(),d=U("p"),d.textContent=It,et=n(),p(F.$$.fragment),st=n(),V=U("p"),V.innerHTML=vt,nt=n(),w=U("p"),w.textContent=At,at=n(),p(c.$$.fragment),Ut=n(),$=U("p"),$.textContent=Qt,Jt=n(),p(C.$$.fragment),Mt=n(),b=U("p"),b.innerHTML=Lt,pt=n(),p(R.$$.fragment),ot=n(),h=U("p"),h.textContent=xt,Tt=n(),j=U("p"),j.innerHTML=Nt,it=n(),E=U("p"),E.textContent=Gt,mt=n(),p(z.$$.fragment),yt=n(),_=U("p"),_.innerHTML=Wt,rt=n(),Z=U("p"),Z.textContent=St,ft=n(),p(B.$$.fragment),gt=n(),k=U("p"),k.innerHTML=Ot,ut=n(),p(I.$$.fragment),dt=n(),v=U("p"),v.textContent=Xt,Ft=n(),p(A.$$.fragment),Vt=n(),Q=U("p"),Q.innerHTML=Pt,wt=n(),p(L.$$.fragment),ct=n(),x=U("p"),x.textContent=Dt,$t=n(),p(N.$$.fragment),Ct=n(),G=U("p"),G.textContent=qt,bt=n(),p(W.$$.fragment),Rt=n(),p(S.$$.fragment),ht=n(),O=U("p"),O.innerHTML=Yt,jt=n(),p(X.$$.fragment),Et=n(),P=U("ul"),P.innerHTML=Ht,zt=n(),p(D.$$.fragment),_t=n(),Y=U("p"),this.h()},l(t){const l=Ul("svelte-u9bgzb",document.head);f=J(l,"META",{name:!0,content:!0}),l.forEach(e),H=a(t),q=J(t,"P",{}),Kt(q).forEach(e),K=a(t),o(g.$$.fragment,t),tt=a(t),o(u.$$.fragment,t),lt=a(t),d=J(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1hv5qvd"&&(d.textContent=It),et=a(t),o(F.$$.fragment,t),st=a(t),V=J(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-jehduk"&&(V.innerHTML=vt),nt=a(t),w=J(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1ud3nn1"&&(w.textContent=At),at=a(t),o(c.$$.fragment,t),Ut=a(t),$=J(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-19ihy5o"&&($.textContent=Qt),Jt=a(t),o(C.$$.fragment,t),Mt=a(t),b=J(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1ljdidi"&&(b.innerHTML=Lt),pt=a(t),o(R.$$.fragment,t),ot=a(t),h=J(t,"P",{"data-svelte-h":!0}),M(h)!=="svelte-1son8gk"&&(h.textContent=xt),Tt=a(t),j=J(t,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1suxqrc"&&(j.innerHTML=Nt),it=a(t),E=J(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-c8kskf"&&(E.textContent=Gt),mt=a(t),o(z.$$.fragment,t),yt=a(t),_=J(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-oxtlec"&&(_.innerHTML=Wt),rt=a(t),Z=J(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-g1i8wc"&&(Z.textContent=St),ft=a(t),o(B.$$.fragment,t),gt=a(t),k=J(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-4hm87z"&&(k.innerHTML=Ot),ut=a(t),o(I.$$.fragment,t),dt=a(t),v=J(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1f0xxuw"&&(v.textContent=Xt),Ft=a(t),o(A.$$.fragment,t),Vt=a(t),Q=J(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-7m8z9n"&&(Q.innerHTML=Pt),wt=a(t),o(L.$$.fragment,t),ct=a(t),x=J(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-qphsl7"&&(x.textContent=Dt),$t=a(t),o(N.$$.fragment,t),Ct=a(t),G=J(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1y33b1i"&&(G.textContent=qt),bt=a(t),o(W.$$.fragment,t),Rt=a(t),o(S.$$.fragment,t),ht=a(t),O=J(t,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1pzkqfj"&&(O.innerHTML=Yt),jt=a(t),o(X.$$.fragment,t),Et=a(t),P=J(t,"UL",{"data-svelte-h":!0}),M(P)!=="svelte-ky7in5"&&(P.innerHTML=Ht),zt=a(t),o(D.$$.fragment,t),_t=a(t),Y=J(t,"P",{}),Kt(Y).forEach(e),this.h()},h(){tl(f,"name","hf:doc:metadata"),tl(f,"content",Tl)},m(t,l){Jl(document.head,f),s(t,H,l),s(t,q,l),s(t,K,l),T(g,t,l),s(t,tt,l),T(u,t,l),s(t,lt,l),s(t,d,l),s(t,et,l),T(F,t,l),s(t,st,l),s(t,V,l),s(t,nt,l),s(t,w,l),s(t,at,l),T(c,t,l),s(t,Ut,l),s(t,$,l),s(t,Jt,l),T(C,t,l),s(t,Mt,l),s(t,b,l),s(t,pt,l),T(R,t,l),s(t,ot,l),s(t,h,l),s(t,Tt,l),s(t,j,l),s(t,it,l),s(t,E,l),s(t,mt,l),T(z,t,l),s(t,yt,l),s(t,_,l),s(t,rt,l),s(t,Z,l),s(t,ft,l),T(B,t,l),s(t,gt,l),s(t,k,l),s(t,ut,l),T(I,t,l),s(t,dt,l),s(t,v,l),s(t,Ft,l),T(A,t,l),s(t,Vt,l),s(t,Q,l),s(t,wt,l),T(L,t,l),s(t,ct,l),s(t,x,l),s(t,$t,l),T(N,t,l),s(t,Ct,l),s(t,G,l),s(t,bt,l),T(W,t,l),s(t,Rt,l),T(S,t,l),s(t,ht,l),s(t,O,l),s(t,jt,l),T(X,t,l),s(t,Et,l),s(t,P,l),s(t,zt,l),T(D,t,l),s(t,_t,l),s(t,Y,l),Zt=!0},p:el,i(t){Zt||(i(g.$$.fragment,t),i(u.$$.fragment,t),i(F.$$.fragment,t),i(c.$$.fragment,t),i(C.$$.fragment,t),i(R.$$.fragment,t),i(z.$$.fragment,t),i(B.$$.fragment,t),i(I.$$.fragment,t),i(A.$$.fragment,t),i(L.$$.fragment,t),i(N.$$.fragment,t),i(W.$$.fragment,t),i(S.$$.fragment,t),i(X.$$.fragment,t),i(D.$$.fragment,t),Zt=!0)},o(t){m(g.$$.fragment,t),m(u.$$.fragment,t),m(F.$$.fragment,t),m(c.$$.fragment,t),m(C.$$.fragment,t),m(R.$$.fragment,t),m(z.$$.fragment,t),m(B.$$.fragment,t),m(I.$$.fragment,t),m(A.$$.fragment,t),m(L.$$.fragment,t),m(N.$$.fragment,t),m(W.$$.fragment,t),m(S.$$.fragment,t),m(X.$$.fragment,t),m(D.$$.fragment,t),Zt=!1},d(t){t&&(e(H),e(q),e(K),e(tt),e(lt),e(d),e(et),e(st),e(V),e(nt),e(w),e(at),e(Ut),e($),e(Jt),e(Mt),e(b),e(pt),e(ot),e(h),e(Tt),e(j),e(it),e(E),e(mt),e(yt),e(_),e(rt),e(Z),e(ft),e(gt),e(k),e(ut),e(dt),e(v),e(Ft),e(Vt),e(Q),e(wt),e(ct),e(x),e($t),e(Ct),e(G),e(bt),e(Rt),e(ht),e(O),e(jt),e(Et),e(P),e(zt),e(_t),e(Y)),e(f),y(g,t),y(u,t),y(F,t),y(c,t),y(C,t),y(R,t),y(z,t),y(B,t),y(I,t),y(A,t),y(L,t),y(N,t),y(W,t),y(S,t),y(X,t),y(D,t)}}}const Tl='{"title":"LoRA (低ランク適応)","local":"lora-低ランク適応","sections":[{"title":"LoRAの理解","local":"loraの理解","sections":[],"depth":2},{"title":"LoRAアダプタの読み込み","local":"loraアダプタの読み込み","sections":[],"depth":2},{"title":"LoRAアダプタの統合","local":"loraアダプタの統合","sections":[],"depth":2},{"title":"実装ガイド","local":"実装ガイド","sections":[],"depth":2},{"title":"OLoRA","local":"olora","sections":[],"depth":2},{"title":"TRLとPEFTの使用","local":"trlとpeftの使用","sections":[],"depth":2},{"title":"基本的な統合実装","local":"基本的な統合実装","sections":[],"depth":2},{"title":"次のステップ","local":"次のステップ","sections":[],"depth":2}],"depth":1}';function il(kt){return sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends nl{constructor(f){super(),al(this,f,il,ol,ll,{})}}export{ul as component};
