import{s as Ee,o as Ne,n as se}from"../chunks/scheduler.7da89386.js";import{S as Ie,i as Be,g as i,s as l,r as c,A as Xe,h as p,f as n,c as a,j as ke,u,x as r,k as Ze,y as We,a as s,v as M,d as h,t as d,w as f}from"../chunks/index.20910acc.js";import{T as ne}from"../chunks/Tip.53e22153.js";import{C as T}from"../chunks/CodeBlock.143bd81e.js";import{H as ct}from"../chunks/getInferenceSnippets.eb0ed38b.js";function Re(x){let o,j=`A good way to implement a custom ONNX configuration is to look at the existing configuration implementations in the
<code>optimum/exporters/onnx/model_configs.py</code> file.`,m,y,w=`Also, if the architecture you are trying to add is (very) similar to an architecture that is already supported
(for instance adding support for ALBERT when BERT is already supported), trying to simply inheriting from this class
might work.`;return{c(){o=i("p"),o.innerHTML=j,m=l(),y=i("p"),y.textContent=w},l(g){o=p(g,"P",{"data-svelte-h":!0}),r(o)!=="svelte-sqy8xm"&&(o.innerHTML=j),m=a(g),y=p(g,"P",{"data-svelte-h":!0}),r(y)!=="svelte-179x1bi"&&(y.textContent=w)},m(g,b){s(g,o,b),s(g,m,b),s(g,y,b)},p:se,d(g){g&&(n(o),n(m),n(y))}}}function Ge(x){let o,j="Check out <code>BartOnnxConfig</code> for an advanced example.";return{c(){o=i("p"),o.innerHTML=j},l(m){o=p(m,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1lu1znn"&&(o.innerHTML=j)},m(m,y){s(m,o,y)},p:se,d(m){m&&n(o)}}}function He(x){let o,j=`If your model is larger than 2GB, you will see that many additional files are created during the export. This is
<em>expected</em> because ONNX uses <a href="https://developers.google.com/protocol-buffers/" rel="nofollow">Protocol Buffers</a> to store the model
and these have a size limit of 2GB. See the <a href="https://github.com/onnx/onnx/blob/master/docs/ExternalData.md" rel="nofollow">ONNX documentation</a>
for instructions on how to load models with external data.`;return{c(){o=i("p"),o.innerHTML=j},l(m){o=p(m,"P",{"data-svelte-h":!0}),r(o)!=="svelte-iixhlv"&&(o.innerHTML=j)},m(m,y){s(m,o,y)},p:se,d(m){m&&n(o)}}}function Ve(x){let o,j,m,y,w,g,b,le="If you wish to export a model whose architecture is not already supported by the library, these are the main steps to follow:",Mt,_,ae="<li>Implement a custom ONNX configuration.</li> <li>Register the ONNX configuration in the <code>TasksManager</code>.</li> <li>Export the model to ONNX.</li> <li>Validate the outputs of the original and exported models.</li>",ht,$,oe="In this section, we’ll look at how BERT was implemented to show what’s involved with each step.",dt,v,ft,A,ie=`Let’s start with the ONNX configuration object. We provide a 3-level <a href="/exporters/onnx/package_reference/configuration">class hierarchy</a>,
and to add support for a model, inheriting from the right middle-end class will be the way to go most of the time. You might have to
implement a middle-end class yourself if you are adding an architecture handling a modality and/or case never seen before.`,yt,U,gt,k,pe=`When inheriting from a middle-end class, look for the one handling the same modality / category of models as the one you
are trying to support.`,jt,Z,bt,E,re=`Since BERT is an encoder-based model for text, its configuration inherits from the middle-end class <a href="/docs/optimum/pr_30/en/onnx/package_reference/configuration#optimum.exporters.onnx.TextEncoderOnnxConfig">TextEncoderOnnxConfig</a>.
In <code>optimum/exporters/onnx/model_configs.py</code>:`,wt,N,Tt,I,me=`First let’s explain what <code>TextEncoderOnnxConfig</code> is all about. While most of the features are already implemented in <code>OnnxConfig</code>,
this class is modality-agnostic, meaning that it does not know what kind of inputs it should handle. The way input generation is
handled is via the <code>DUMMY_INPUT_GENERATOR_CLASSES</code> attribute, which is a tuple of <code>DummyInputGenerator</code>s.
Here we are making a modality-aware configuration inheriting from <code>OnnxConfig</code> by specifying
<code>DUMMY_INPUT_GENERATOR_CLASSES = (DummyTextInputGenerator,)</code>.`,xt,B,ce="Then comes the model-specific class, <code>BertOnnxConfig</code>. Two class attributes are specified here:",Ut,X,ue=`<li><code>NORMALIZED_CONFIG_CLASS</code>: this must be a <code>NormalizedConfig</code>, it basically allows
the input generator to access the model config attributes in a generic way.</li> <li><code>ATOL_FOR_VALIDATION</code>: it is used when validating the exported model against the original one, this is the absolute
acceptable tolerance for the output values difference.</li>`,Jt,W,Me=`Every configuration object must implement the <a href="/docs/optimum/pr_30/en/onnx/package_reference/configuration#optimum.exporters.onnx.OnnxConfig.inputs">inputs</a> property and return a mapping, where each key corresponds to an
input name, and each value indicates the axes in that input that are dynamic.
For BERT, we can see that three inputs are required: <code>input_ids</code>, <code>attention_mask</code> and <code>token_type_ids</code>.
These inputs have the same shape of <code>(batch_size, sequence_length)</code> (except for the <code>multiple-choice</code> task) which is
why we see the same axes used in the configuration.`,Ct,R,he="Once you have implemented an ONNX configuration, you can instantiate it by providing the base model’s configuration as follows:",_t,G,$t,H,de=`The resulting object has several useful properties. For example, you can view the ONNX
operator set that will be used during the export:`,vt,V,At,L,fe="You can also view the outputs associated with the model as follows:",kt,F,Zt,O,ye=`Notice that the outputs property follows the same structure as the inputs; it returns an
<code>OrderedDict</code> of named outputs and their shapes. The output structure is linked to the
choice of task that the configuration is initialised with. By default, the ONNX
configuration is initialized with the <code>default</code> task that corresponds to exporting a
model loaded with the <code>AutoModel</code> class. If you want to export a model for another task,
just provide a different task to the <code>task</code> argument when you initialize the ONNX
configuration. For example, if we wished to export BERT with a sequence
classification head, we could use:`,Et,Q,Nt,J,It,z,Bt,S,ge=`The <code>TasksManager</code> is the main entry-point to load a model given a name and a task,
and to get the proper configuration for a given (architecture, backend) couple. When adding support for the export to ONNX,
registering the configuration to the <code>TasksManager</code> will make the export available in the command line tool.`,Xt,q,je="To do that, add an entry in the <code>_SUPPORTED_MODEL_TYPE</code> attribute:",Wt,Y,be=`<li>If the model is already supported for other backends than ONNX, it will already have an entry, so you will only need to
add an <code>onnx</code> key specifying the name of the configuration class.</li> <li>Otherwise, you will have to add the whole entry.</li>`,Rt,P,we="For BERT, it looks as follows:",Gt,D,Ht,K,Vt,tt,Te=`Once you have implemented the ONNX configuration, the next step is to export the model.
Here we can use the <code>export()</code> function provided by the <code>optimum.exporters.onnx</code> package.
This function expects the ONNX configuration, along with the base model, and the path to save the exported file:`,Lt,et,Ft,nt,xe=`The <code>onnx_inputs</code> and <code>onnx_outputs</code> returned by the <code>export()</code> function are lists of the keys defined in the <a href="/docs/optimum/pr_30/en/onnx/package_reference/configuration#optimum.exporters.onnx.OnnxConfig.inputs">inputs</a>
and <a href="/docs/optimum/pr_30/en/onnx/package_reference/configuration#optimum.exporters.onnx.OnnxConfig.inputs">inputs</a> properties of the configuration. Once the model is exported, you can test that the model is well formed as follows:`,Ot,st,Qt,C,zt,lt,St,at,Ue=`The final step is to validate that the outputs from the base and exported model agree within some absolute tolerance.
Here we can use the <code>validate_model_outputs()</code> function provided by the <code>optimum.exporters.onnx</code> package:`,qt,ot,Yt,it,Pt,pt,Je="Now that the support for the architectures has been implemented, and validated, there are two things left:",Dt,rt,Ce='<li>Add your model architecture to the tests in <code>tests/exporters/test_onnx_export.py</code></li> <li>Create a PR on the <a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code> repo</a></li>',Kt,mt,_e="Thanks for you contribution!",te,ut,ee;return w=new ct({props:{title:"Adding support for an unsupported architecture",local:"adding-support-for-an-unsupported-architecture",headingTag:"h1"}}),v=new ct({props:{title:"Implementing a custom ONNX configuration",local:"implementing-a-custom-onnx-configuration",headingTag:"h2"}}),U=new ne({props:{$$slots:{default:[Re]},$$scope:{ctx:x}}}),Z=new ct({props:{title:"Example: Adding support for BERT",local:"example-adding-support-for-bert",headingTag:"h3"}}),N=new T({props:{code:"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",highlighted:`<span class="hljs-comment"># This class is actually in optimum/exporters/onnx/config.py</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TextEncoderOnnxConfig</span>(<span class="hljs-title class_ inherited__">OnnxConfig</span>):
    <span class="hljs-comment"># Describes how to generate the dummy inputs.</span>
    DUMMY_INPUT_GENERATOR_CLASSES = (DummyTextInputGenerator,)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">BertOnnxConfig</span>(<span class="hljs-title class_ inherited__">TextEncoderOnnxConfig</span>):
    <span class="hljs-comment"># Specifies how to normalize the BertConfig, this is needed to access common attributes</span>
    <span class="hljs-comment"># during dummy input generation.</span>
    NORMALIZED_CONFIG_CLASS = NormalizedTextConfig
    <span class="hljs-comment"># Sets the absolute tolerance to when validating the exported ONNX model against the</span>
    <span class="hljs-comment"># reference model.</span>
    ATOL_FOR_VALIDATION = <span class="hljs-number">1e-4</span>

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Dict</span>[<span class="hljs-built_in">int</span>, <span class="hljs-built_in">str</span>]]:
        <span class="hljs-keyword">if</span> self.task == <span class="hljs-string">&quot;multiple-choice&quot;</span>:
            dynamic_axis = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;batch_size&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;num_choices&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;sequence_length&quot;</span>}
        <span class="hljs-keyword">else</span>:
            dynamic_axis = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;batch_size&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;sequence_length&quot;</span>}
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;input_ids&quot;</span>: dynamic_axis,
            <span class="hljs-string">&quot;attention_mask&quot;</span>: dynamic_axis,
            <span class="hljs-string">&quot;token_type_ids&quot;</span>: dynamic_axis,
        }`,wrap:!1}}),G=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEFmcm9tJTIwb3B0aW11bS5leHBvcnRlcnMub25ueC5tb2RlbF9jb25maWdzJTIwaW1wb3J0JTIwQmVydE9ubnhDb25maWclMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFvbm54X2NvbmZpZyUyMCUzRCUyMEJlcnRPbm54Q29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.onnx.model_configs <span class="hljs-keyword">import</span> BertOnnxConfig
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config = BertOnnxConfig(config)`,wrap:!1}}),V=new T({props:{code:"cHJpbnQob25ueF9jb25maWcuREVGQVVMVF9PTk5YX09QU0VUKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(onnx_config.DEFAULT_ONNX_OPSET)
<span class="hljs-number">11</span>`,wrap:!1}}),F=new T({props:{code:"cHJpbnQob25ueF9jb25maWcub3V0cHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(onnx_config.outputs)
OrderedDict([(<span class="hljs-string">&#x27;last_hidden_state&#x27;</span>, {<span class="hljs-number">0</span>: <span class="hljs-string">&#x27;batch_size&#x27;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&#x27;sequence_length&#x27;</span>})])`,wrap:!1}}),Q=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEElMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFvbm54X2NvbmZpZ19mb3Jfc2VxX2NsZiUyMCUzRCUyMEJlcnRPbm54Q29uZmlnKGNvbmZpZyUyQyUyMHRhc2slM0QlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyKSUwQXByaW50KG9ubnhfY29uZmlnX2Zvcl9zZXFfY2xmLm91dHB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config_for_seq_clf = BertOnnxConfig(config, task=<span class="hljs-string">&quot;text-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(onnx_config_for_seq_clf.outputs)
OrderedDict([(<span class="hljs-string">&#x27;logits&#x27;</span>, {<span class="hljs-number">0</span>: <span class="hljs-string">&#x27;batch_size&#x27;</span>})])`,wrap:!1}}),J=new ne({props:{$$slots:{default:[Ge]},$$scope:{ctx:x}}}),z=new ct({props:{title:"Registering the ONNX configuration in the TasksManager",local:"registering-the-onnx-configuration-in-the-tasksmanager",headingTag:"h2"}}),D=new T({props:{code:"JTIwJTIwJTIwJTIwJTIyYmVydCUyMiUzQSUyMHN1cHBvcnRlZF90YXNrc19tYXBwaW5nKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlZmF1bHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmaWxsLW1hc2slMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybXVsdGlwbGUtY2hvaWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvbm54JTNEJTIyQmVydE9ubnhDb25maWclMjIlMkMlMEElMjAlMjAlMjAlMjAp",highlighted:`    <span class="hljs-string">&quot;bert&quot;</span>: supported_tasks_mapping(
        <span class="hljs-string">&quot;default&quot;</span>,
        <span class="hljs-string">&quot;fill-mask&quot;</span>,
        <span class="hljs-string">&quot;text-generation&quot;</span>,
        <span class="hljs-string">&quot;text-classification&quot;</span>,
        <span class="hljs-string">&quot;multiple-choice&quot;</span>,
        <span class="hljs-string">&quot;token-classification&quot;</span>,
        <span class="hljs-string">&quot;question-answering&quot;</span>,
        onnx=<span class="hljs-string">&quot;BertOnnxConfig&quot;</span>,
    )`,wrap:!1}}),K=new ct({props:{title:"Exporting the model",local:"exporting-the-model",headingTag:"h2"}}),et=new T({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzJTIwaW1wb3J0JTIwVGFza3NNYW5hZ2VyJTBBZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLm9ubnglMjBpbXBvcnQlMjBleHBvcnQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBb25ueF9wYXRoJTIwJTNEJTIwUGF0aCglMjJtb2RlbC5vbm54JTIyKSUwQW9ubnhfY29uZmlnX2NvbnN0cnVjdG9yJTIwJTNEJTIwVGFza3NNYW5hZ2VyLmdldF9leHBvcnRlcl9jb25maWdfY29uc3RydWN0b3IoJTIyb25ueCUyMiUyQyUyMGJhc2VfbW9kZWwpJTBBb25ueF9jb25maWclMjAlM0QlMjBvbm54X2NvbmZpZ19jb25zdHJ1Y3RvcihiYXNlX21vZGVsLmNvbmZpZyklMEElMEFvbm54X2lucHV0cyUyQyUyMG9ubnhfb3V0cHV0cyUyMCUzRCUyMGV4cG9ydChiYXNlX21vZGVsJTJDJTIwb25ueF9jb25maWclMkMlMjBvbm54X3BhdGglMkMlMjBvbm54X2NvbmZpZy5ERUZBVUxUX09OTlhfT1BTRVQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters <span class="hljs-keyword">import</span> TasksManager
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.onnx <span class="hljs-keyword">import</span> export
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span>base_model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_path = Path(<span class="hljs-string">&quot;model.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config_constructor = TasksManager.get_exporter_config_constructor(<span class="hljs-string">&quot;onnx&quot;</span>, base_model)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config = onnx_config_constructor(base_model.config)

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_inputs, onnx_outputs = export(base_model, onnx_config, onnx_path, onnx_config.DEFAULT_ONNX_OPSET)`,wrap:!1}}),st=new T({props:{code:"aW1wb3J0JTIwb25ueCUwQSUwQW9ubnhfbW9kZWwlMjAlM0QlMjBvbm54LmxvYWQoJTIybW9kZWwub25ueCUyMiklMEFvbm54LmNoZWNrZXIuY2hlY2tfbW9kZWwob25ueF9tb2RlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> onnx

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_model = onnx.load(<span class="hljs-string">&quot;model.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx.checker.check_model(onnx_model)`,wrap:!1}}),C=new ne({props:{$$slots:{default:[He]},$$scope:{ctx:x}}}),lt=new ct({props:{title:"Validating the model outputs",local:"validating-the-model-outputs",headingTag:"h2"}}),ot=new T({props:{code:"ZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLm9ubnglMjBpbXBvcnQlMjB2YWxpZGF0ZV9tb2RlbF9vdXRwdXRzJTBBJTBBdmFsaWRhdGVfbW9kZWxfb3V0cHV0cyglMEElMjAlMjAlMjAlMjBvbm54X2NvbmZpZyUyQyUyMGJhc2VfbW9kZWwlMkMlMjBvbm54X3BhdGglMkMlMjBvbm54X291dHB1dHMlMkMlMjBvbm54X2NvbmZpZy5BVE9MX0ZPUl9WQUxJREFUSU9OJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.onnx <span class="hljs-keyword">import</span> validate_model_outputs

<span class="hljs-meta">&gt;&gt;&gt; </span>validate_model_outputs(
<span class="hljs-meta">... </span>    onnx_config, base_model, onnx_path, onnx_outputs, onnx_config.ATOL_FOR_VALIDATION
<span class="hljs-meta">... </span>)`,wrap:!1}}),it=new ct({props:{title:"Contributing the new configuration to 🤗 Optimum",local:"contributing-the-new-configuration-to--optimum",headingTag:"h2"}}),{c(){o=i("meta"),j=l(),m=i("p"),y=l(),c(w.$$.fragment),g=l(),b=i("p"),b.textContent=le,Mt=l(),_=i("ol"),_.innerHTML=ae,ht=l(),$=i("p"),$.textContent=oe,dt=l(),c(v.$$.fragment),ft=l(),A=i("p"),A.innerHTML=ie,yt=l(),c(U.$$.fragment),gt=l(),k=i("p"),k.textContent=pe,jt=l(),c(Z.$$.fragment),bt=l(),E=i("p"),E.innerHTML=re,wt=l(),c(N.$$.fragment),Tt=l(),I=i("p"),I.innerHTML=me,xt=l(),B=i("p"),B.innerHTML=ce,Ut=l(),X=i("ul"),X.innerHTML=ue,Jt=l(),W=i("p"),W.innerHTML=Me,Ct=l(),R=i("p"),R.textContent=he,_t=l(),c(G.$$.fragment),$t=l(),H=i("p"),H.textContent=de,vt=l(),c(V.$$.fragment),At=l(),L=i("p"),L.textContent=fe,kt=l(),c(F.$$.fragment),Zt=l(),O=i("p"),O.innerHTML=ye,Et=l(),c(Q.$$.fragment),Nt=l(),c(J.$$.fragment),It=l(),c(z.$$.fragment),Bt=l(),S=i("p"),S.innerHTML=ge,Xt=l(),q=i("p"),q.innerHTML=je,Wt=l(),Y=i("ul"),Y.innerHTML=be,Rt=l(),P=i("p"),P.textContent=we,Gt=l(),c(D.$$.fragment),Ht=l(),c(K.$$.fragment),Vt=l(),tt=i("p"),tt.innerHTML=Te,Lt=l(),c(et.$$.fragment),Ft=l(),nt=i("p"),nt.innerHTML=xe,Ot=l(),c(st.$$.fragment),Qt=l(),c(C.$$.fragment),zt=l(),c(lt.$$.fragment),St=l(),at=i("p"),at.innerHTML=Ue,qt=l(),c(ot.$$.fragment),Yt=l(),c(it.$$.fragment),Pt=l(),pt=i("p"),pt.textContent=Je,Dt=l(),rt=i("ol"),rt.innerHTML=Ce,Kt=l(),mt=i("p"),mt.textContent=_e,te=l(),ut=i("p"),this.h()},l(t){const e=Xe("svelte-u9bgzb",document.head);o=p(e,"META",{name:!0,content:!0}),e.forEach(n),j=a(t),m=p(t,"P",{}),ke(m).forEach(n),y=a(t),u(w.$$.fragment,t),g=a(t),b=p(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-wyfgyh"&&(b.textContent=le),Mt=a(t),_=p(t,"OL",{"data-svelte-h":!0}),r(_)!=="svelte-15i0ct7"&&(_.innerHTML=ae),ht=a(t),$=p(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1faxzt5"&&($.textContent=oe),dt=a(t),u(v.$$.fragment,t),ft=a(t),A=p(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-h5ikbh"&&(A.innerHTML=ie),yt=a(t),u(U.$$.fragment,t),gt=a(t),k=p(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1aazjya"&&(k.textContent=pe),jt=a(t),u(Z.$$.fragment,t),bt=a(t),E=p(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-gs6975"&&(E.innerHTML=re),wt=a(t),u(N.$$.fragment,t),Tt=a(t),I=p(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1goyjkt"&&(I.innerHTML=me),xt=a(t),B=p(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-jfkvll"&&(B.innerHTML=ce),Ut=a(t),X=p(t,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1lb8len"&&(X.innerHTML=ue),Jt=a(t),W=p(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-49u840"&&(W.innerHTML=Me),Ct=a(t),R=p(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1hidcfs"&&(R.textContent=he),_t=a(t),u(G.$$.fragment,t),$t=a(t),H=p(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-de93a2"&&(H.textContent=de),vt=a(t),u(V.$$.fragment,t),At=a(t),L=p(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1wxissk"&&(L.textContent=fe),kt=a(t),u(F.$$.fragment,t),Zt=a(t),O=p(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-e8rha9"&&(O.innerHTML=ye),Et=a(t),u(Q.$$.fragment,t),Nt=a(t),u(J.$$.fragment,t),It=a(t),u(z.$$.fragment,t),Bt=a(t),S=p(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-k2wk0s"&&(S.innerHTML=ge),Xt=a(t),q=p(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1sb1s64"&&(q.innerHTML=je),Wt=a(t),Y=p(t,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-glrx48"&&(Y.innerHTML=be),Rt=a(t),P=p(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-17sq7il"&&(P.textContent=we),Gt=a(t),u(D.$$.fragment,t),Ht=a(t),u(K.$$.fragment,t),Vt=a(t),tt=p(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-dpvtiu"&&(tt.innerHTML=Te),Lt=a(t),u(et.$$.fragment,t),Ft=a(t),nt=p(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-gy7y61"&&(nt.innerHTML=xe),Ot=a(t),u(st.$$.fragment,t),Qt=a(t),u(C.$$.fragment,t),zt=a(t),u(lt.$$.fragment,t),St=a(t),at=p(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-je0ksn"&&(at.innerHTML=Ue),qt=a(t),u(ot.$$.fragment,t),Yt=a(t),u(it.$$.fragment,t),Pt=a(t),pt=p(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-m5s9fa"&&(pt.textContent=Je),Dt=a(t),rt=p(t,"OL",{"data-svelte-h":!0}),r(rt)!=="svelte-1eec8bu"&&(rt.innerHTML=Ce),Kt=a(t),mt=p(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-zwsyvs"&&(mt.textContent=_e),te=a(t),ut=p(t,"P",{}),ke(ut).forEach(n),this.h()},h(){Ze(o,"name","hf:doc:metadata"),Ze(o,"content",Le)},m(t,e){We(document.head,o),s(t,j,e),s(t,m,e),s(t,y,e),M(w,t,e),s(t,g,e),s(t,b,e),s(t,Mt,e),s(t,_,e),s(t,ht,e),s(t,$,e),s(t,dt,e),M(v,t,e),s(t,ft,e),s(t,A,e),s(t,yt,e),M(U,t,e),s(t,gt,e),s(t,k,e),s(t,jt,e),M(Z,t,e),s(t,bt,e),s(t,E,e),s(t,wt,e),M(N,t,e),s(t,Tt,e),s(t,I,e),s(t,xt,e),s(t,B,e),s(t,Ut,e),s(t,X,e),s(t,Jt,e),s(t,W,e),s(t,Ct,e),s(t,R,e),s(t,_t,e),M(G,t,e),s(t,$t,e),s(t,H,e),s(t,vt,e),M(V,t,e),s(t,At,e),s(t,L,e),s(t,kt,e),M(F,t,e),s(t,Zt,e),s(t,O,e),s(t,Et,e),M(Q,t,e),s(t,Nt,e),M(J,t,e),s(t,It,e),M(z,t,e),s(t,Bt,e),s(t,S,e),s(t,Xt,e),s(t,q,e),s(t,Wt,e),s(t,Y,e),s(t,Rt,e),s(t,P,e),s(t,Gt,e),M(D,t,e),s(t,Ht,e),M(K,t,e),s(t,Vt,e),s(t,tt,e),s(t,Lt,e),M(et,t,e),s(t,Ft,e),s(t,nt,e),s(t,Ot,e),M(st,t,e),s(t,Qt,e),M(C,t,e),s(t,zt,e),M(lt,t,e),s(t,St,e),s(t,at,e),s(t,qt,e),M(ot,t,e),s(t,Yt,e),M(it,t,e),s(t,Pt,e),s(t,pt,e),s(t,Dt,e),s(t,rt,e),s(t,Kt,e),s(t,mt,e),s(t,te,e),s(t,ut,e),ee=!0},p(t,[e]){const $e={};e&2&&($e.$$scope={dirty:e,ctx:t}),U.$set($e);const ve={};e&2&&(ve.$$scope={dirty:e,ctx:t}),J.$set(ve);const Ae={};e&2&&(Ae.$$scope={dirty:e,ctx:t}),C.$set(Ae)},i(t){ee||(h(w.$$.fragment,t),h(v.$$.fragment,t),h(U.$$.fragment,t),h(Z.$$.fragment,t),h(N.$$.fragment,t),h(G.$$.fragment,t),h(V.$$.fragment,t),h(F.$$.fragment,t),h(Q.$$.fragment,t),h(J.$$.fragment,t),h(z.$$.fragment,t),h(D.$$.fragment,t),h(K.$$.fragment,t),h(et.$$.fragment,t),h(st.$$.fragment,t),h(C.$$.fragment,t),h(lt.$$.fragment,t),h(ot.$$.fragment,t),h(it.$$.fragment,t),ee=!0)},o(t){d(w.$$.fragment,t),d(v.$$.fragment,t),d(U.$$.fragment,t),d(Z.$$.fragment,t),d(N.$$.fragment,t),d(G.$$.fragment,t),d(V.$$.fragment,t),d(F.$$.fragment,t),d(Q.$$.fragment,t),d(J.$$.fragment,t),d(z.$$.fragment,t),d(D.$$.fragment,t),d(K.$$.fragment,t),d(et.$$.fragment,t),d(st.$$.fragment,t),d(C.$$.fragment,t),d(lt.$$.fragment,t),d(ot.$$.fragment,t),d(it.$$.fragment,t),ee=!1},d(t){t&&(n(j),n(m),n(y),n(g),n(b),n(Mt),n(_),n(ht),n($),n(dt),n(ft),n(A),n(yt),n(gt),n(k),n(jt),n(bt),n(E),n(wt),n(Tt),n(I),n(xt),n(B),n(Ut),n(X),n(Jt),n(W),n(Ct),n(R),n(_t),n($t),n(H),n(vt),n(At),n(L),n(kt),n(Zt),n(O),n(Et),n(Nt),n(It),n(Bt),n(S),n(Xt),n(q),n(Wt),n(Y),n(Rt),n(P),n(Gt),n(Ht),n(Vt),n(tt),n(Lt),n(Ft),n(nt),n(Ot),n(Qt),n(zt),n(St),n(at),n(qt),n(Yt),n(Pt),n(pt),n(Dt),n(rt),n(Kt),n(mt),n(te),n(ut)),n(o),f(w,t),f(v,t),f(U,t),f(Z,t),f(N,t),f(G,t),f(V,t),f(F,t),f(Q,t),f(J,t),f(z,t),f(D,t),f(K,t),f(et,t),f(st,t),f(C,t),f(lt,t),f(ot,t),f(it,t)}}}const Le='{"title":"Adding support for an unsupported architecture","local":"adding-support-for-an-unsupported-architecture","sections":[{"title":"Implementing a custom ONNX configuration","local":"implementing-a-custom-onnx-configuration","sections":[{"title":"Example: Adding support for BERT","local":"example-adding-support-for-bert","sections":[],"depth":3}],"depth":2},{"title":"Registering the ONNX configuration in the TasksManager","local":"registering-the-onnx-configuration-in-the-tasksmanager","sections":[],"depth":2},{"title":"Exporting the model","local":"exporting-the-model","sections":[],"depth":2},{"title":"Validating the model outputs","local":"validating-the-model-outputs","sections":[],"depth":2},{"title":"Contributing the new configuration to 🤗 Optimum","local":"contributing-the-new-configuration-to--optimum","sections":[],"depth":2}],"depth":1}';function Fe(x){return Ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ye extends Ie{constructor(o){super(),Be(this,o,Fe,Ve,Ee,{})}}export{Ye as component};
