import{s as At,o as Wt,n as ot}from"../chunks/scheduler.defa9a21.js";import{S as Xt,i as Rt,g as $,s as c,r as f,A as Yt,h as g,f as a,c as o,j as Gt,u,x as b,k as Zt,y as Ht,a as l,v as h,d as y,t as M,w}from"../chunks/index.fe795e71.js";import{T as nt}from"../chunks/Tip.179eb360.js";import{C}from"../chunks/CodeBlock.42404125.js";import{H as k,E as Vt}from"../chunks/EditOnGithub.0f575778.js";import{H as Bt,a as It}from"../chunks/HfOption.3c290b0f.js";function xt(j){let r,T="Accelerate only prepares objects that inherit from their respective PyTorch classes such as <code>torch.optim.Optimizer</code>.";return{c(){r=$("p"),r.innerHTML=T},l(s){r=g(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-1oh2ah6"&&(r.innerHTML=T)},m(s,m){l(s,r,m)},p:ot,d(s){s&&a(r)}}}function zt(j){let r,T='Accelerate enables automatic mixed precision, so <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> is only needed if there are other mixed precision operations besides those performed on loss by <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> which already handles the scaling.';return{c(){r=$("p"),r.innerHTML=T},l(s){r=g(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-cwgvtb"&&(r.innerHTML=T)},m(s,m){l(s,r,m)},p:ot,d(s){s&&a(r)}}}function Ft(j){let r,T='For models from the <a href="https://hf.co/docs/transformers/index" rel="nofollow">Transformers</a> library, save the model with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a> method so that it can be reloaded with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained" rel="nofollow">from_pretrained</a> method.',s,m,n;return m=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQXVud3JhcHBlZF9tb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMEF1bndyYXBwZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnBhdGglMkZ0byUyRm15X21vZGVsX2RpcmVjdG9yeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlzX21haW5fcHJvY2VzcyUzRGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfZnVuY3Rpb24lM0RhY2NlbGVyYXRvci5zYXZlJTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZteV9tb2RlbF9kaXJlY3RvcnklMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

unwrapped_model = accelerator.unwrap_model(model)
unwrapped_model.save_pretrained(
    <span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>,
    is_main_process=accelerator.is_main_process,
    save_function=accelerator.save,
)

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>)`,wrap:!1}}),{c(){r=$("p"),r.innerHTML=T,s=c(),f(m.$$.fragment)},l(p){r=g(p,"P",{"data-svelte-h":!0}),b(r)!=="svelte-y3y63b"&&(r.innerHTML=T),s=o(p),u(m.$$.fragment,p)},m(p,_){l(p,r,_),l(p,s,_),h(m,p,_),n=!0},p:ot,i(p){n||(y(m.$$.fragment,p),n=!0)},o(p){M(m.$$.fragment,p),n=!1},d(p){p&&(a(r),a(s)),w(m,p)}}}function Qt(j){let r,T,s,m,n,p='To load your weights, use the <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method to unwrap the model first before loading the weights. All model parameters are references to tensors, so this loads your weights inside <code>model</code>.',_,U,J;return r=new C({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory)`,wrap:!1}}),s=new nt({props:{$$slots:{default:[Ft]},$$scope:{ctx:j}}}),U=new C({props:{code:"dW53cmFwcGVkX21vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IudW53cmFwX21vZGVsKG1vZGVsKSUwQXBhdGhfdG9fY2hlY2twb2ludCUyMCUzRCUyMG9zLnBhdGguam9pbihzYXZlX2RpcmVjdG9yeSUyQyUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKSUwQXVud3JhcHBlZF9tb2RlbC5sb2FkX3N0YXRlX2RpY3QodG9yY2gubG9hZChwYXRoX3RvX2NoZWNrcG9pbnQpKQ==",highlighted:`unwrapped_model = accelerator.unwrap_model(model)
path_to_checkpoint = os.path.join(save_directory,<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
unwrapped_model.load_state_dict(torch.load(path_to_checkpoint))`,wrap:!1}}),{c(){f(r.$$.fragment),T=c(),f(s.$$.fragment),m=c(),n=$("p"),n.innerHTML=p,_=c(),f(U.$$.fragment)},l(i){u(r.$$.fragment,i),T=o(i),u(s.$$.fragment,i),m=o(i),n=g(i,"P",{"data-svelte-h":!0}),b(n)!=="svelte-xss84c"&&(n.innerHTML=p),_=o(i),u(U.$$.fragment,i)},m(i,d){h(r,i,d),l(i,T,d),h(s,i,d),l(i,m,d),l(i,n,d),l(i,_,d),h(U,i,d),J=!0},p(i,d){const v={};d&2&&(v.$$scope={dirty:d,ctx:i}),s.$set(v)},i(i){J||(y(r.$$.fragment,i),y(s.$$.fragment,i),y(U.$$.fragment,i),J=!0)},o(i){M(r.$$.fragment,i),M(s.$$.fragment,i),M(U.$$.fragment,i),J=!1},d(i){i&&(a(T),a(m),a(n),a(_)),w(r,i),w(s,i),w(U,i)}}}function St(j){let r,T="Set <code>safe_serialization=True</code> to save the model in the safetensor format.",s,m,n,p,_='To load a sharded checkpoint or a safetensor formatted checkpoint, use the <a href="/docs/accelerate/pr_2917/en/package_reference/utilities#accelerate.load_checkpoint_in_model">load_checkpoint_in_model()</a> method. This method allows you to load a checkpoint onto a specific device.',U,J,i;return m=new C({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMG1heF9zaGFyZF9zaXplJTNEJTIyMUdCJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNEVHJ1ZSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>, safe_serialization=<span class="hljs-literal">True</span>)`,wrap:!1}}),J=new C({props:{code:"bG9hZF9jaGVja3BvaW50X2luX21vZGVsKHVud3JhcHBlZF9tb2RlbCUyQyUyMHNhdmVfZGlyZWN0b3J5JTJDJTIwZGV2aWNlX21hcCUzRCU3QiUyMiUyMiUzQWRldmljZSU3RCk=",highlighted:'load_checkpoint_in_model(unwrapped_model, save_directory, device_map={<span class="hljs-string">&quot;&quot;</span>:device})',wrap:!1}}),{c(){r=$("p"),r.innerHTML=T,s=c(),f(m.$$.fragment),n=c(),p=$("p"),p.innerHTML=_,U=c(),f(J.$$.fragment)},l(d){r=g(d,"P",{"data-svelte-h":!0}),b(r)!=="svelte-jahj75"&&(r.innerHTML=T),s=o(d),u(m.$$.fragment,d),n=o(d),p=g(d,"P",{"data-svelte-h":!0}),b(p)!=="svelte-12bs3s4"&&(p.innerHTML=_),U=o(d),u(J.$$.fragment,d)},m(d,v){l(d,r,v),l(d,s,v),h(m,d,v),l(d,n,v),l(d,p,v),l(d,U,v),h(J,d,v),i=!0},p:ot,i(d){i||(y(m.$$.fragment,d),y(J.$$.fragment,d),i=!0)},o(d){M(m.$$.fragment,d),M(J.$$.fragment,d),i=!1},d(d){d&&(a(r),a(s),a(n),a(p),a(U)),w(m,d),w(J,d)}}}function Nt(j){let r,T,s,m;return r=new It({props:{id:"save",option:"single checkpoint",$$slots:{default:[Qt]},$$scope:{ctx:j}}}),s=new It({props:{id:"save",option:"sharded checkpoint",$$slots:{default:[St]},$$scope:{ctx:j}}}),{c(){f(r.$$.fragment),T=c(),f(s.$$.fragment)},l(n){u(r.$$.fragment,n),T=o(n),u(s.$$.fragment,n)},m(n,p){h(r,n,p),l(n,T,p),h(s,n,p),m=!0},p(n,p){const _={};p&2&&(_.$$scope={dirty:p,ctx:n}),r.$set(_);const U={};p&2&&(U.$$scope={dirty:p,ctx:n}),s.$set(U)},i(n){m||(y(r.$$.fragment,n),y(s.$$.fragment,n),m=!0)},o(n){M(r.$$.fragment,n),M(s.$$.fragment,n),m=!1},d(n){n&&a(T),w(r,n),w(s,n)}}}function Lt(j){let r,T,s,m,n,p,_,U="Each distributed training framework has their own way of doing things which can require writing a lot of custom code to adapt it to your PyTorch training code and training environment. Accelerate offers a friendly way to interface with these distributed training frameworks without having to learn the specific details of each one. Accelerate takes care of those details for you, so you can focus on the training code and scale it to any distributed training environment.",J,i,d="In this tutorial, you’ll learn how to adapt your existing PyTorch code with Accelerate and get you on your way toward training on distributed systems with ease! You’ll start with a basic PyTorch training loop (it assumes all the training objects like <code>model</code> and <code>optimizer</code> have been setup already) and progressively integrate Accelerate into it.",v,A,we,W,$e,X,st='The <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is the main class for adapting your code to work with Accelerate. It knows about the distributed setup you’re using such as the number of different processes and your hardware type. This class also provides access to many of the necessary methods for enabling your PyTorch code to work in any distributed training environment and for managing and executing processes across devices.',ge,R,it='That’s why you should always start by importing and creating an <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> instance in your script.',be,Y,Te,H,pt='The <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> also knows which device to move your PyTorch objects to, so it is recommended to let Accelerate handle this for you.',_e,V,Ue,B,Je,x,dt='Next, you need to prepare your PyTorch objects (model, optimizer, scheduler, etc.) for distributed training. The <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method takes care of placing your model in the appropriate container (like single GPU or multi-GPU) for your training setup, adapting the optimizer and scheduler to use Accelerate’s <a href="/docs/accelerate/pr_2917/en/package_reference/torch_wrappers#accelerate.optimizer.AcceleratedOptimizer">AcceleratedOptimizer</a> and <a href="/docs/accelerate/pr_2917/en/package_reference/torch_wrappers#accelerate.scheduler.AcceleratedScheduler">AcceleratedScheduler</a>, and creating a new dataloader that can be sharded across processes.',ve,G,je,z,mt="The PyTorch objects are returned in the same order they’re sent.",Ce,F,ke,Q,Ge,S,ft='Finally, remove the <code>to(device)</code> calls to the inputs and targets in the training loop because Accelerate’s DataLoader classes automatically places them on the right device. You should also replace the usual <code>backward()</code> pass with Accelerate’s <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> method which scales the gradients for you and uses the appropriate <code>backward()</code> method depending on your distributed setup (for example, DeepSpeed or Megatron).',Ze,N,Ie,L,ut="Put everything together and your new Accelerate training loop should now look like this!",Ae,E,We,P,Xe,K,ht="Accelerate offers additional features - like gradient accumulation, gradient clipping, mixed precision training and more - you can add to your script to improve your training run. Let’s explore these three features.",Re,q,Ye,D,yt='Gradient accumulation enables you to train on larger batch sizes by accumulating the gradients over multiple batches before updating the weights. This can be useful for getting around memory limitations. To enable this feature in Accelerate, specify the <code>gradient_accumulation_steps</code> parameter in the <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class and add the <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> context manager to your script.',He,O,Ve,ee,Be,te,Mt="Gradient clipping is a technique to prevent “exploding gradients”, and Accelerate offers:",xe,ae,wt='<li><a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_value_">clip<em>grad_value</em>()</a> to clip gradients to a minimum and maximum value</li> <li><a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_norm_">clip<em>grad_norm</em>()</a> for normalizing gradients to a certain value</li>',ze,le,Fe,re,$t="Mixed precision accelerates training by using a lower precision data type like fp16 (half-precision) to calculate the gradients. For the best performance with Accelerate, the loss should be computed inside your model (like in Transformers models) because computations outside of the model are computed in full precision.",Qe,ce,gt='Set the mixed precision type to use in the <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, and then use the <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> context manager to automatically cast the values to the specified data type.',Se,Z,Ne,oe,Le,ne,Ee,se,bt="Accelerate can also save and load a <em>model</em> once training is complete or you can also save the model and optimizer <em>state</em> which could be useful for resuming training.",Pe,ie,Ke,pe,Tt='Once all processes are complete, unwrap the model with the <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method before saving it because the <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method wrapped your model into the proper interface for distributed training. If you don’t unwrap the model, saving the model state dictionary also saves any potential extra layers from the larger model and you won’t be able to load the weights back into your base model.',qe,de,_t='You should use the <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a> method to unwrap and save the model state dictionary. This method can also save a model into sharded checkpoints or into the <a href="https://hf.co/docs/safetensors/index" rel="nofollow">safetensors</a> format.',De,I,Oe,me,et,fe,Ut='During training, you may want to save the current state of the model, optimizer, random generators, and potentially learning rate schedulers so they can be restored in the <em>same script</em>. You should add the <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a> and <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.load_state">load_state()</a> methods to your script to save and load states.',tt,ue,Jt='To further customize where and how states are saved through <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a>, use the <a href="/docs/accelerate/pr_2917/en/package_reference/utilities#accelerate.utils.ProjectConfiguration">ProjectConfiguration</a> class. For example, if <code>automatic_checkpoint_naming</code> is enabled, each saved checkpoint is stored at <code>Accelerator.project_dir/checkpoints/checkpoint_{checkpoint_number}</code>.',at,he,vt='Any other stateful items to be stored should be registered with the <a href="/docs/accelerate/pr_2917/en/package_reference/accelerator#accelerate.Accelerator.register_for_checkpointing">register_for_checkpointing()</a> method so they can be saved and loaded. Every object passed to this method to be stored must have a <code>load_state_dict</code> and <code>state_dict</code> function.',lt,ye,rt,Me,ct;return n=new k({props:{title:"Add Accelerate to your code",local:"add-accelerate-to-your-code",headingTag:"h1"}}),A=new C({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwdGFyZ2V0cyUyMCUzRCUyMHRhcmdldHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss.backward()
    optimizer.step()
    scheduler.step()`,wrap:!1}}),W=new k({props:{title:"Accelerator",local:"accelerator",headingTag:"h2"}}),Y=new C({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()`,wrap:!1}}),V=new C({props:{code:"LSUyMGRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEElMkIlMjBkZXZpY2UlMjAlM0QlMjBhY2NlbGVyYXRvci5kZXZpY2UlMEElMjAlMjBtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-deletion">- device = &quot;cuda&quot;</span>
<span class="hljs-addition">+ device = accelerator.device</span>
  model.to(device)`,wrap:!1}}),B=new k({props:{title:"Prepare PyTorch objects",local:"prepare-pytorch-objects",headingTag:"h2"}}),G=new nt({props:{warning:!1,$$slots:{default:[xt]},$$scope:{ctx:j}}}),F=new C({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluaW5nX2RhdGFsb2FkZXIlMkMlMjBzY2hlZHVsZXIlMEEp",highlighted:`model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)`,wrap:!1}}),Q=new k({props:{title:"Training loop",local:"training-loop",headingTag:"h2"}}),N=new C({props:{code:"LSUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBLSUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQS0lMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMkIlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKQ==",highlighted:`<span class="hljs-deletion">-   inputs = inputs.to(device)</span>
<span class="hljs-deletion">-   targets = targets.to(device)</span>
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
<span class="hljs-deletion">-   loss.backward()</span>
<span class="hljs-addition">+   accelerator.backward(loss)</span>`,wrap:!1}}),E=new C({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQWRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIuc3RlcCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerator = Accelerator()

device = accelerator.device
model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    accelerator.backward(loss)
    optimizer.step()
    scheduler.step()`,wrap:!1}}),P=new k({props:{title:"Training features",local:"training-features",headingTag:"h2"}}),q=new k({props:{title:"Gradient accumulation",local:"gradient-accumulation",headingTag:"h3"}}),O=new C({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QyKSUwQSUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyKSUwQSUwQSUyMCUyMGZvciUyMGlucHV0JTJDJTIwbGFiZWwlMjBpbiUyMHRyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMkIlMjAlMjAlMjAlMjAlMjB3aXRoJTIwYWNjZWxlcmF0b3IuYWNjdW11bGF0ZShtb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG1vZGVsKGlucHV0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKHByZWRpY3Rpb25zJTJDJTIwbGFiZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_steps=2)</span>
  model, optimizer, training_dataloader = accelerator.prepare(model, optimizer, training_dataloader)

  for input, label in training_dataloader:
<span class="hljs-addition">+     with accelerator.accumulate(model):</span>
          predictions = model(input)
          loss = loss_function(predictions, label)
          accelerator.backward(loss)
          optimizer.step()
          scheduler.step()
          optimizer.zero_grad()`,wrap:!1}}),ee=new k({props:{title:"Gradient clipping",local:"gradient-clipping",headingTag:"h3"}}),le=new k({props:{title:"Mixed precision",local:"mixed-precision",headingTag:"h3"}}),Z=new nt({props:{warning:!0,$$slots:{default:[zt]},$$scope:{ctx:j}}}),oe=new C({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyKSUwQSUyQiUyMHdpdGglMjBhY2NlbGVyYXRvci5hdXRvY2FzdCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGNvbXBsZXhfbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0KSUzQQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(mixed_precision=&quot;fp16&quot;)</span>
<span class="hljs-addition">+ with accelerator.autocast():</span>
      loss = complex_loss_function(outputs, target):`,wrap:!1}}),ne=new k({props:{title:"Save and load",local:"save-and-load",headingTag:"h2"}}),ie=new k({props:{title:"Model",local:"model",headingTag:"h3"}}),I=new Bt({props:{id:"save",options:["single checkpoint","sharded checkpoint"],$$slots:{default:[Nt]},$$scope:{ctx:j}}}),me=new k({props:{title:"State",local:"state",headingTag:"h3"}}),ye=new Vt({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/basic_tutorials/migration.md"}}),{c(){r=$("meta"),T=c(),s=$("p"),m=c(),f(n.$$.fragment),p=c(),_=$("p"),_.textContent=U,J=c(),i=$("p"),i.innerHTML=d,v=c(),f(A.$$.fragment),we=c(),f(W.$$.fragment),$e=c(),X=$("p"),X.innerHTML=st,ge=c(),R=$("p"),R.innerHTML=it,be=c(),f(Y.$$.fragment),Te=c(),H=$("p"),H.innerHTML=pt,_e=c(),f(V.$$.fragment),Ue=c(),f(B.$$.fragment),Je=c(),x=$("p"),x.innerHTML=dt,ve=c(),f(G.$$.fragment),je=c(),z=$("p"),z.textContent=mt,Ce=c(),f(F.$$.fragment),ke=c(),f(Q.$$.fragment),Ge=c(),S=$("p"),S.innerHTML=ft,Ze=c(),f(N.$$.fragment),Ie=c(),L=$("p"),L.textContent=ut,Ae=c(),f(E.$$.fragment),We=c(),f(P.$$.fragment),Xe=c(),K=$("p"),K.textContent=ht,Re=c(),f(q.$$.fragment),Ye=c(),D=$("p"),D.innerHTML=yt,He=c(),f(O.$$.fragment),Ve=c(),f(ee.$$.fragment),Be=c(),te=$("p"),te.textContent=Mt,xe=c(),ae=$("ul"),ae.innerHTML=wt,ze=c(),f(le.$$.fragment),Fe=c(),re=$("p"),re.textContent=$t,Qe=c(),ce=$("p"),ce.innerHTML=gt,Se=c(),f(Z.$$.fragment),Ne=c(),f(oe.$$.fragment),Le=c(),f(ne.$$.fragment),Ee=c(),se=$("p"),se.innerHTML=bt,Pe=c(),f(ie.$$.fragment),Ke=c(),pe=$("p"),pe.innerHTML=Tt,qe=c(),de=$("p"),de.innerHTML=_t,De=c(),f(I.$$.fragment),Oe=c(),f(me.$$.fragment),et=c(),fe=$("p"),fe.innerHTML=Ut,tt=c(),ue=$("p"),ue.innerHTML=Jt,at=c(),he=$("p"),he.innerHTML=vt,lt=c(),f(ye.$$.fragment),rt=c(),Me=$("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);r=g(t,"META",{name:!0,content:!0}),t.forEach(a),T=o(e),s=g(e,"P",{}),Gt(s).forEach(a),m=o(e),u(n.$$.fragment,e),p=o(e),_=g(e,"P",{"data-svelte-h":!0}),b(_)!=="svelte-19zbp5z"&&(_.textContent=U),J=o(e),i=g(e,"P",{"data-svelte-h":!0}),b(i)!=="svelte-1lmjen8"&&(i.innerHTML=d),v=o(e),u(A.$$.fragment,e),we=o(e),u(W.$$.fragment,e),$e=o(e),X=g(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-10aibvr"&&(X.innerHTML=st),ge=o(e),R=g(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-99wgxq"&&(R.innerHTML=it),be=o(e),u(Y.$$.fragment,e),Te=o(e),H=g(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-1pxxcwy"&&(H.innerHTML=pt),_e=o(e),u(V.$$.fragment,e),Ue=o(e),u(B.$$.fragment,e),Je=o(e),x=g(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-p8y2vs"&&(x.innerHTML=dt),ve=o(e),u(G.$$.fragment,e),je=o(e),z=g(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-l5v2wx"&&(z.textContent=mt),Ce=o(e),u(F.$$.fragment,e),ke=o(e),u(Q.$$.fragment,e),Ge=o(e),S=g(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-ku66am"&&(S.innerHTML=ft),Ze=o(e),u(N.$$.fragment,e),Ie=o(e),L=g(e,"P",{"data-svelte-h":!0}),b(L)!=="svelte-1b6tm11"&&(L.textContent=ut),Ae=o(e),u(E.$$.fragment,e),We=o(e),u(P.$$.fragment,e),Xe=o(e),K=g(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-1ef6475"&&(K.textContent=ht),Re=o(e),u(q.$$.fragment,e),Ye=o(e),D=g(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-13nyfsl"&&(D.innerHTML=yt),He=o(e),u(O.$$.fragment,e),Ve=o(e),u(ee.$$.fragment,e),Be=o(e),te=g(e,"P",{"data-svelte-h":!0}),b(te)!=="svelte-bg95gl"&&(te.textContent=Mt),xe=o(e),ae=g(e,"UL",{"data-svelte-h":!0}),b(ae)!=="svelte-12yiq27"&&(ae.innerHTML=wt),ze=o(e),u(le.$$.fragment,e),Fe=o(e),re=g(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-81s14c"&&(re.textContent=$t),Qe=o(e),ce=g(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-1asnha0"&&(ce.innerHTML=gt),Se=o(e),u(Z.$$.fragment,e),Ne=o(e),u(oe.$$.fragment,e),Le=o(e),u(ne.$$.fragment,e),Ee=o(e),se=g(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-dqdivd"&&(se.innerHTML=bt),Pe=o(e),u(ie.$$.fragment,e),Ke=o(e),pe=g(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-5jn3ld"&&(pe.innerHTML=Tt),qe=o(e),de=g(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-iik0en"&&(de.innerHTML=_t),De=o(e),u(I.$$.fragment,e),Oe=o(e),u(me.$$.fragment,e),et=o(e),fe=g(e,"P",{"data-svelte-h":!0}),b(fe)!=="svelte-wqxhr"&&(fe.innerHTML=Ut),tt=o(e),ue=g(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-16whmc4"&&(ue.innerHTML=Jt),at=o(e),he=g(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-1utdgnx"&&(he.innerHTML=vt),lt=o(e),u(ye.$$.fragment,e),rt=o(e),Me=g(e,"P",{}),Gt(Me).forEach(a),this.h()},h(){Zt(r,"name","hf:doc:metadata"),Zt(r,"content",Et)},m(e,t){Ht(document.head,r),l(e,T,t),l(e,s,t),l(e,m,t),h(n,e,t),l(e,p,t),l(e,_,t),l(e,J,t),l(e,i,t),l(e,v,t),h(A,e,t),l(e,we,t),h(W,e,t),l(e,$e,t),l(e,X,t),l(e,ge,t),l(e,R,t),l(e,be,t),h(Y,e,t),l(e,Te,t),l(e,H,t),l(e,_e,t),h(V,e,t),l(e,Ue,t),h(B,e,t),l(e,Je,t),l(e,x,t),l(e,ve,t),h(G,e,t),l(e,je,t),l(e,z,t),l(e,Ce,t),h(F,e,t),l(e,ke,t),h(Q,e,t),l(e,Ge,t),l(e,S,t),l(e,Ze,t),h(N,e,t),l(e,Ie,t),l(e,L,t),l(e,Ae,t),h(E,e,t),l(e,We,t),h(P,e,t),l(e,Xe,t),l(e,K,t),l(e,Re,t),h(q,e,t),l(e,Ye,t),l(e,D,t),l(e,He,t),h(O,e,t),l(e,Ve,t),h(ee,e,t),l(e,Be,t),l(e,te,t),l(e,xe,t),l(e,ae,t),l(e,ze,t),h(le,e,t),l(e,Fe,t),l(e,re,t),l(e,Qe,t),l(e,ce,t),l(e,Se,t),h(Z,e,t),l(e,Ne,t),h(oe,e,t),l(e,Le,t),h(ne,e,t),l(e,Ee,t),l(e,se,t),l(e,Pe,t),h(ie,e,t),l(e,Ke,t),l(e,pe,t),l(e,qe,t),l(e,de,t),l(e,De,t),h(I,e,t),l(e,Oe,t),h(me,e,t),l(e,et,t),l(e,fe,t),l(e,tt,t),l(e,ue,t),l(e,at,t),l(e,he,t),l(e,lt,t),h(ye,e,t),l(e,rt,t),l(e,Me,t),ct=!0},p(e,[t]){const jt={};t&2&&(jt.$$scope={dirty:t,ctx:e}),G.$set(jt);const Ct={};t&2&&(Ct.$$scope={dirty:t,ctx:e}),Z.$set(Ct);const kt={};t&2&&(kt.$$scope={dirty:t,ctx:e}),I.$set(kt)},i(e){ct||(y(n.$$.fragment,e),y(A.$$.fragment,e),y(W.$$.fragment,e),y(Y.$$.fragment,e),y(V.$$.fragment,e),y(B.$$.fragment,e),y(G.$$.fragment,e),y(F.$$.fragment,e),y(Q.$$.fragment,e),y(N.$$.fragment,e),y(E.$$.fragment,e),y(P.$$.fragment,e),y(q.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(Z.$$.fragment,e),y(oe.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(I.$$.fragment,e),y(me.$$.fragment,e),y(ye.$$.fragment,e),ct=!0)},o(e){M(n.$$.fragment,e),M(A.$$.fragment,e),M(W.$$.fragment,e),M(Y.$$.fragment,e),M(V.$$.fragment,e),M(B.$$.fragment,e),M(G.$$.fragment,e),M(F.$$.fragment,e),M(Q.$$.fragment,e),M(N.$$.fragment,e),M(E.$$.fragment,e),M(P.$$.fragment,e),M(q.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(Z.$$.fragment,e),M(oe.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(I.$$.fragment,e),M(me.$$.fragment,e),M(ye.$$.fragment,e),ct=!1},d(e){e&&(a(T),a(s),a(m),a(p),a(_),a(J),a(i),a(v),a(we),a($e),a(X),a(ge),a(R),a(be),a(Te),a(H),a(_e),a(Ue),a(Je),a(x),a(ve),a(je),a(z),a(Ce),a(ke),a(Ge),a(S),a(Ze),a(Ie),a(L),a(Ae),a(We),a(Xe),a(K),a(Re),a(Ye),a(D),a(He),a(Ve),a(Be),a(te),a(xe),a(ae),a(ze),a(Fe),a(re),a(Qe),a(ce),a(Se),a(Ne),a(Le),a(Ee),a(se),a(Pe),a(Ke),a(pe),a(qe),a(de),a(De),a(Oe),a(et),a(fe),a(tt),a(ue),a(at),a(he),a(lt),a(rt),a(Me)),a(r),w(n,e),w(A,e),w(W,e),w(Y,e),w(V,e),w(B,e),w(G,e),w(F,e),w(Q,e),w(N,e),w(E,e),w(P,e),w(q,e),w(O,e),w(ee,e),w(le,e),w(Z,e),w(oe,e),w(ne,e),w(ie,e),w(I,e),w(me,e),w(ye,e)}}}const Et='{"title":"Add Accelerate to your code","local":"add-accelerate-to-your-code","sections":[{"title":"Accelerator","local":"accelerator","sections":[],"depth":2},{"title":"Prepare PyTorch objects","local":"prepare-pytorch-objects","sections":[],"depth":2},{"title":"Training loop","local":"training-loop","sections":[],"depth":2},{"title":"Training features","local":"training-features","sections":[{"title":"Gradient accumulation","local":"gradient-accumulation","sections":[],"depth":3},{"title":"Gradient clipping","local":"gradient-clipping","sections":[],"depth":3},{"title":"Mixed precision","local":"mixed-precision","sections":[],"depth":3}],"depth":2},{"title":"Save and load","local":"save-and-load","sections":[{"title":"Model","local":"model","sections":[],"depth":3},{"title":"State","local":"state","sections":[],"depth":3}],"depth":2}],"depth":1}';function Pt(j){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class aa extends Xt{constructor(r){super(),Rt(this,r,Pt,Lt,At,{})}}export{aa as component};
