import{s as Ke,o as Oe,n as je}from"../chunks/scheduler.f6b352c8.js";import{S as tl,i as sl,g as p,s as n,r as M,A as el,h as o,f as e,c as a,j as Ht,u as j,x as c,k as Le,y as $,a as l,v as J,d as y,t as h,w as T}from"../chunks/index.b90df637.js";import{T as ll}from"../chunks/Tip.366d2e6e.js";import{C as d}from"../chunks/CodeBlock.e5718f9d.js";import{H as f,E as nl}from"../chunks/index.b1d6a402.js";import{H as al,a as De}from"../chunks/HfOption.6047630d.js";function pl(I){let r,U="The MCP specification is still evolving, so the configuration methods are subject to evolution. We’ll focus on the current best practices for configuration.";return{c(){r=p("p"),r.textContent=U},l(m){r=o(m,"P",{"data-svelte-h":!0}),c(r)!=="svelte-n56el2"&&(r.textContent=U)},m(m,w){l(m,r,w)},p:je,d(m){m&&e(r)}}}function ol(I){let r,U="In Python, we use the <code>os</code> module to access environment variables:",m,w,u;return w=new d({props:{code:"aW1wb3J0JTIwb3MlMEElMEElMjMlMjBBY2Nlc3MlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlcyUwQWdpdGh1Yl90b2tlbiUyMCUzRCUyMG9zLmVudmlyb24uZ2V0KCUyMkdJVEhVQl9UT0tFTiUyMiklMEFpZiUyMG5vdCUyMGdpdGh1Yl90b2tlbiUzQSUwQSUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvciglMjJHSVRIVUJfVE9LRU4lMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTIwaXMlMjByZXF1aXJlZCUyMiklMEElMEElMjMlMjBVc2UlMjB0aGUlMjB0b2tlbiUyMGluJTIweW91ciUyMHNlcnZlciUyMGNvZGUlMEFkZWYlMjBtYWtlX2dpdGh1Yl9yZXF1ZXN0KCklM0ElMEElMjAlMjAlMjAlMjBoZWFkZXJzJTIwJTNEJTIwJTdCJTIyQXV0aG9yaXphdGlvbiUyMiUzQSUyMGYlMjJCZWFyZXIlMjAlN0JnaXRodWJfdG9rZW4lN0QlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjByZXN0JTIwb2YlMjB5b3VyJTIwY29kZQ==",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Access environment variables</span>
github_token = os.environ.get(<span class="hljs-string">&quot;GITHUB_TOKEN&quot;</span>)
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> github_token:
    <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;GITHUB_TOKEN environment variable is required&quot;</span>)

<span class="hljs-comment"># Use the token in your server code</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_github_request</span>():
    headers = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{github_token}</span>&quot;</span>}
    <span class="hljs-comment"># ... rest of your code</span>`,wrap:!1}}),{c(){r=p("p"),r.innerHTML=U,m=n(),M(w.$$.fragment)},l(i){r=o(i,"P",{"data-svelte-h":!0}),c(r)!=="svelte-8jwuh1"&&(r.innerHTML=U),m=a(i),j(w.$$.fragment,i)},m(i,C){l(i,r,C),l(i,m,C),J(w,i,C),u=!0},p:je,i(i){u||(y(w.$$.fragment,i),u=!0)},o(i){h(w.$$.fragment,i),u=!1},d(i){i&&(e(r),e(m)),T(w,i)}}}function il(I){let r,U="In JavaScript, we use the <code>process.env</code> object to access environment variables:",m,w,u;return w=new d({props:{code:"JTJGJTJGJTIwQWNjZXNzJTIwZW52aXJvbm1lbnQlMjB2YXJpYWJsZXMlMEFjb25zdCUyMGdpdGh1YlRva2VuJTIwJTNEJTIwcHJvY2Vzcy5lbnYuR0lUSFVCX1RPS0VOJTNCJTBBaWYlMjAoIWdpdGh1YlRva2VuKSUyMCU3QiUwQSUyMCUyMCUyMCUyMHRocm93JTIwbmV3JTIwRXJyb3IoJTIyR0lUSFVCX1RPS0VOJTIwZW52aXJvbm1lbnQlMjB2YXJpYWJsZSUyMGlzJTIwcmVxdWlyZWQlMjIpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwVXNlJTIwdGhlJTIwdG9rZW4lMjBpbiUyMHlvdXIlMjBzZXJ2ZXIlMjBjb2RlJTBBZnVuY3Rpb24lMjBtYWtlR2l0aHViUmVxdWVzdCgpJTIwJTdCJTBBJTIwJTIwJTIwJTIwY29uc3QlMjBoZWFkZXJzJTIwJTNEJTIwJTdCJTIwJTIyQXV0aG9yaXphdGlvbiUyMiUzQSUyMCU2MEJlYXJlciUyMCUyNCU3QmdpdGh1YlRva2VuJTdEJTYwJTIwJTdEJTNCJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwLi4uJTIwcmVzdCUyMG9mJTIweW91ciUyMGNvZGUlMEElN0Q=",highlighted:`<span class="hljs-comment">// Access environment variables</span>
<span class="hljs-keyword">const</span> githubToken = process.<span class="hljs-property">env</span>.<span class="hljs-property">GITHUB_TOKEN</span>;
<span class="hljs-keyword">if</span> (!githubToken) {
    <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;GITHUB_TOKEN environment variable is required&quot;</span>);
}

<span class="hljs-comment">// Use the token in your server code</span>
<span class="hljs-keyword">function</span> <span class="hljs-title function_">makeGithubRequest</span>(<span class="hljs-params"></span>) {
    <span class="hljs-keyword">const</span> headers = { <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">\`Bearer <span class="hljs-subst">\${githubToken}</span>\`</span> };
    <span class="hljs-comment">// ... rest of your code</span>
}`,wrap:!1}}),{c(){r=p("p"),r.innerHTML=U,m=n(),M(w.$$.fragment)},l(i){r=o(i,"P",{"data-svelte-h":!0}),c(r)!=="svelte-1554qq7"&&(r.innerHTML=U),m=a(i),j(w.$$.fragment,i)},m(i,C){l(i,r,C),l(i,m,C),J(w,i,C),u=!0},p:je,i(i){u||(y(w.$$.fragment,i),u=!0)},o(i){h(w.$$.fragment,i),u=!1},d(i){i&&(e(r),e(m)),T(w,i)}}}function rl(I){let r,U,m,w;return r=new De({props:{id:"env-variables",option:"python",$$slots:{default:[ol]},$$scope:{ctx:I}}}),m=new De({props:{id:"env-variables",option:"javascript",$$slots:{default:[il]},$$scope:{ctx:I}}}),{c(){M(r.$$.fragment),U=n(),M(m.$$.fragment)},l(u){j(r.$$.fragment,u),U=a(u),j(m.$$.fragment,u)},m(u,i){J(r,u,i),l(u,U,i),J(m,u,i),w=!0},p(u,i){const C={};i&2&&(C.$$scope={dirty:i,ctx:u}),r.$set(C);const Yt={};i&2&&(Yt.$$scope={dirty:i,ctx:u}),m.$set(Yt)},i(u){w||(y(r.$$.fragment,u),y(m.$$.fragment,u),w=!0)},o(u){h(r.$$.fragment,u),h(m.$$.fragment,u),w=!1},d(u){u&&e(U),T(r,u),T(m,u)}}}function cl(I){let r,U,m,w,u,i,C,Yt="Now that we have a basic understanding of the Model Context Protocol, we can explore the essential role of MCP Clients in the Model Context Protocol ecosystem.",Ft,E,Je="In this part of Unit 1, we’ll explore the essential role of MCP Clients in the Model Context Protocol ecosystem.",Lt,q,ye="In this section, you will:",Dt,x,he="<li>Understand what MCP Clients are and their role in the MCP architecture</li> <li>Learn about the key responsibilities of MCP Clients</li> <li>Explore the major MCP Client implementations</li> <li>Discover how to use Hugging Face’s MCP Client implementation</li> <li>See practical examples of MCP Client usage</li>",Kt,G,Ot,S,Te="MCP Clients are crucial components that act as the bridge between AI applications (Hosts) and external capabilities provided by MCP Servers. Think of the Host as your main application (like an AI assistant or IDE) and the Client as a specialized module within that Host responsible for handling MCP communications.",ts,V,ss,Q,me="Let’s start by exploring the user interface clients that are available for the MCP.",es,k,ls,W,we="Anthropic’s Claude Desktop stands as one of the most prominent MCP Clients, providing integration with various MCP Servers.",ns,X,as,_,Ue="Cursor’s MCP Client implementation enables AI-powered coding assistance through direct integration with code editing capabilities. It supports multiple MCP Server connections and provides real-time tool invocation during coding, making it a powerful tool for developers.",ps,N,Ce="Continue.dev is another example of an interactive development client that supports MCP and connects to an MCP server from VS Code.",os,P,is,R,fe="Now that we’ve covered the core of the MCP protocol, let’s look at how to configure your MCP servers and clients.",rs,H,de="Effective deployment of MCP servers and clients requires proper configuration.",cs,v,us,Y,Ms,z,Ie="MCP hosts use configuration files to manage server connections. These files define which servers are available and how to connect to them.",js,F,$e="Fortunately, the configuration files are very simple, easy to understand, and consistent across major MCP hosts.",Js,L,ys,D,ve="The standard configuration file for MCP is named <code>mcp.json</code>. Here’s the basic structure:",hs,K,Ts,O,be="In this example, we have a single server with a name and a transport type. The transport type is either <code>stdio</code> or <code>sse</code>.",ms,tt,ws,st,ge="For local servers using stdio transport, the configuration includes the command and arguments to launch the server process:",Us,et,Cs,lt,Be="Here, we have a server called “File Explorer” that is a local script.",fs,nt,ds,at,Ae="For remote servers using HTTP+SSE transport, the configuration includes the server URL:",Is,pt,$s,ot,vs,it,Ze="Environment variables can be passed to server processes using the <code>env</code> field. Here’s how to access them in your server code:",bs,b,gs,rt,Ee="The corresponding configuration in <code>mcp.json</code> would look like this:",Bs,ct,As,ut,Zs,Mt,qe="Let’s look at some real-world configuration scenarios:",Es,jt,qs,Jt,xe="In this scenario, we have a local server that is a Python script which could be a file explorer or a code editor.",xs,yt,Gs,ht,Ss,Tt,Ge="In this scenario, we have a remote server that is a weather API.",Vs,mt,Qs,wt,Se="Proper configuration is essential for successfully deploying MCP integrations. By understanding these aspects, you can create robust and reliable connections between AI applications and external capabilities.",ks,Ut,Ve="In the next section, we’ll explore the ecosystem of MCP servers available on Hugging Face Hub and how to publish your own servers there.",Ws,Ct,Xs,ft,Qe="You can also use the MCP Client in within code so that the tools are available to the LLM. Let’s explore some examples in <code>smolagents</code>.",_s,dt,ke="First, let’s explore our weather server from the previous page. In <code>smolagents</code>, we can use the <code>ToolCollection</code> class to automatically discover and register tools from an MCP server. This is done by passing the <code>StdioServerParameters</code> or <code>SSEServerParameters</code> to the <code>ToolCollection.from_mcp</code> method. We can then print the tools to the console.",Ns,It,Ps,g,_t,We="Output",re,$t,Rs,vt,Xe="We can also connect to an MCP server that is hosted on a remote machine. In this case, we need to pass the <code>SSEServerParameters</code> to the <code>ToolCollection.from_mcp</code> method.",Hs,bt,Ys,B,Nt,_e="Output",ce,gt,zs,Bt,Ne="Now, let’s see how we can use the MCP Client in a code agent.",Fs,At,Ls,A,Pt,Pe="Output",ue,Zt,Ds,Et,Re="We can also connect to an MCP packages. Here’s an example of connecting to the <code>pubmedmcp</code> package.",Ks,qt,Os,Z,Rt,He="Output",Me,xt,te,Gt,se,St,Ye="Now that you understand MCP Clients, you’re ready to:",ee,Vt,ze="<li>Explore specific MCP Server implementations</li> <li>Learn about creating custom MCP Clients</li> <li>Dive into advanced MCP integration patterns</li>",le,Qt,Fe="Let’s continue our journey into the world of Model Context Protocol!",ne,kt,ae,zt,pe;return u=new f({props:{title:"MCP Clients",local:"mcp-clients",headingTag:"h1"}}),G=new f({props:{title:"Understanding MCP Clients",local:"understanding-mcp-clients",headingTag:"h2"}}),V=new f({props:{title:"User Interface Client",local:"user-interface-client",headingTag:"h2"}}),k=new f({props:{title:"Chat Interface Clients",local:"chat-interface-clients",headingTag:"h3"}}),X=new f({props:{title:"Interactive Development Clients",local:"interactive-development-clients",headingTag:"h3"}}),P=new f({props:{title:"Configuring MCP Clients",local:"configuring-mcp-clients",headingTag:"h2"}}),v=new ll({props:{$$slots:{default:[pl]},$$scope:{ctx:I}}}),Y=new f({props:{title:"MCP Configuration Files",local:"mcp-configuration-files",headingTag:"h3"}}),L=new f({props:{title:"mcp.json Structure",local:"mcpjson-structure",headingTag:"h4"}}),K=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJTZXJ2ZXIlMjBOYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0ZGlvJTdDc3NlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwVHJhbnNwb3J0LXNwZWNpZmljJTIwY29uZmlndXJhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Server Name&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio|sse&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-comment">// Transport-specific configuration</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),tt=new f({props:{title:"Configuration for stdio Transport",local:"configuration-for-stdio-transport",headingTag:"h4"}}),et=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJGaWxlJTIwRXhwbG9yZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tYW5kJTIyJTNBJTIwJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJncyUyMiUzQSUyMCU1QiUyMiUyRnBhdGglMkZ0byUyRmZpbGVfZXhwbG9yZXJfc2VydmVyLnB5JTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;File Explorer&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;python&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;/path/to/file_explorer_server.py&quot;</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),nt=new f({props:{title:"Configuration for HTTP+SSE Transport",local:"configuration-for-httpsse-transport",headingTag:"h4"}}),pt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJSZW1vdGUlMjBBUEklMjBTZXJ2ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3NlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZleGFtcGxlLmNvbSUyRm1jcC1zZXJ2ZXIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Remote API Server&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sse&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://example.com/mcp-server&quot;</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ot=new f({props:{title:"Environment Variables in Configuration",local:"environment-variables-in-configuration",headingTag:"h4"}}),b=new al({props:{id:"env-variables",options:["python","javascript"],$$slots:{default:[rl]},$$scope:{ctx:I}}}),ct=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJHaXRIdWIlMjBBUEklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tYW5kJTIyJTNBJTIwJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJncyUyMiUzQSUyMCU1QiUyMiUyRnBhdGglMkZ0byUyRmdpdGh1Yl9zZXJ2ZXIucHklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJHSVRIVUJfVE9LRU4lMjIlM0ElMjAlMjJ5b3VyX2dpdGh1Yl90b2tlbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;GitHub API&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;python&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;/path/to/github_server.py&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;GITHUB_TOKEN&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;your_github_token&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ut=new f({props:{title:"Configuration Examples",local:"configuration-examples",headingTag:"h3"}}),jt=new f({props:{title:"Scenario 1: Local Server Configuration",local:"scenario-1-local-server-configuration",headingTag:"h4"}}),yt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJGaWxlJTIwRXhwbG9yZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tYW5kJTIyJTNBJTIwJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJncyUyMiUzQSUyMCU1QiUyMiUyRnBhdGglMkZ0byUyRmZpbGVfZXhwbG9yZXJfc2VydmVyLnB5JTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;File Explorer&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;python&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;/path/to/file_explorer_server.py&quot;</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ht=new f({props:{title:"Scenario 2: Remote Server Configuration",local:"scenario-2-remote-server-configuration",headingTag:"h4"}}),mt=new d({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJXZWF0aGVyJTIwQVBJJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnNzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGZXhhbXBsZS5jb20lMkZtY3Atc2VydmVyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Weather API&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sse&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://example.com/mcp-server&quot;</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ct=new f({props:{title:"Code Clients",local:"code-clients",headingTag:"h2"}}),It=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AuY2xpZW50LnN0ZGlvJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBJTBBc2VydmVyX3BhcmFtZXRlcnMlMjAlM0QlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMoY29tbWFuZCUzRCUyMnV2JTIyJTJDJTIwYXJncyUzRCU1QiUyMnJ1biUyMiUyQyUyMCUyMnNlcnZlci5weSUyMiU1RCklMEElMEF3aXRoJTIwVG9vbENvbGxlY3Rpb24uZnJvbV9tY3AoJTBBJTIwJTIwJTIwJTIwc2VydmVyX3BhcmFtZXRlcnMlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTIwYXMlMjB0b29scyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiU1Q24lMjIuam9pbihmJTIyJTdCdC5uYW1lJTdEJTNBJTIwJTdCdC5kZXNjcmlwdGlvbiU3RCUyMiUyMGZvciUyMHQlMjBpbiUyMHRvb2xzKSklMEE=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp.client.stdio <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(command=<span class="hljs-string">&quot;uv&quot;</span>, args=[<span class="hljs-string">&quot;run&quot;</span>, <span class="hljs-string">&quot;server.py&quot;</span>])

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(
    server_parameters, trust_remote_code=<span class="hljs-literal">True</span>
) <span class="hljs-keyword">as</span> tools:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span>.join(<span class="hljs-string">f&quot;<span class="hljs-subst">{t.name}</span>: <span class="hljs-subst">{t.description}</span>&quot;</span> <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tools))
`,wrap:!1}}),$t=new d({props:{code:"V2VhdGhlciUyMEFQSSUzQSUyMEdldCUyMHRoZSUyMHdlYXRoZXIlMjBpbiUyMGElMjBzcGVjaWZpYyUyMGxvY2F0aW9uJTBB",highlighted:`Weather API: Get the weather <span class="hljs-keyword">in</span> a specific location
`,wrap:!1}}),bt=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMubWNwX2NsaWVudCUyMGltcG9ydCUyME1DUENsaWVudCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTBBJTIwJTIwJTIwJTIwJTdCJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZhYmlkbGFicy1tY3AtdG9vbHMuaGYuc3BhY2UlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTdEJTBBKSUyMGFzJTIwdG9vbHMlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUb29scyUyMGZyb20lMjB0aGUlMjByZW1vdGUlMjBzZXJ2ZXIlMjBhcmUlMjBhdmFpbGFibGUlMEElMjAlMjAlMjAlMjBwcmludCglMjIlNUNuJTIyLmpvaW4oZiUyMiU3QnQubmFtZSU3RCUzQSUyMCU3QnQuZGVzY3JpcHRpb24lN0QlMjIlMjBmb3IlMjB0JTIwaW4lMjB0b29scykp",highlighted:`<span class="hljs-keyword">from</span> smolagents.mcp_client <span class="hljs-keyword">import</span> MCPClient

<span class="hljs-keyword">with</span> MCPClient(
    {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://abidlabs-mcp-tools.hf.space/gradio_api/mcp/sse&quot;</span>}
) <span class="hljs-keyword">as</span> tools:
    <span class="hljs-comment"># Tools from the remote server are available</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span>.join(<span class="hljs-string">f&quot;<span class="hljs-subst">{t.name}</span>: <span class="hljs-subst">{t.description}</span>&quot;</span> <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tools))`,wrap:!1}}),gt=new d({props:{code:"cHJpbWVfZmFjdG9ycyUzQSUyMENvbXB1dGUlMjB0aGUlMjBwcmltZSUyMGZhY3Rvcml6YXRpb24lMjBvZiUyMGElMjBwb3NpdGl2ZSUyMGludGVnZXIuJTBBZ2VuZXJhdGVfY2hlZXRhaF9pbWFnZSUzQSUyMEdlbmVyYXRlJTIwYSUyMGNoZWV0YWglMjBpbWFnZS4lMEFpbWFnZV9vcmllbnRhdGlvbiUzQSUyMFJldHVybnMlMjB3aGV0aGVyJTIwaW1hZ2UlMjBpcyUyMHBvcnRyYWl0JTIwb3IlMjBsYW5kc2NhcGUuJTBBc2VwaWElM0ElMjBBcHBseSUyMGElMjBzZXBpYSUyMGZpbHRlciUyMHRvJTIwdGhlJTIwaW5wdXQlMjBpbWFnZS4=",highlighted:`prime_factors: Compute the prime factorization of a positive <span class="hljs-built_in">integer</span>.
generate_cheetah_image: Generate a cheetah image.
image_orientation: Returns whether image is portrait or landscape.
sepia: Apply a sepia filter to the input image.`,wrap:!1}}),At=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AuY2xpZW50LnN0ZGlvJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUwQSUwQXNlcnZlcl9wYXJhbWV0ZXJzJTIwJTNEJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzKGNvbW1hbmQlM0QlMjJ1diUyMiUyQyUyMGFyZ3MlM0QlNUIlMjJydW4lMjIlMkMlMjAlMjJzZXJ2ZXIucHklMjIlNUQpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKCUwQSUyMCUyMCUyMCUyMHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTBBKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyV2hhdCdzJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwVG9reW8lM0YlMjIpJTBB",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp.client.stdio <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel()

server_parameters = StdioServerParameters(command=<span class="hljs-string">&quot;uv&quot;</span>, args=[<span class="hljs-string">&quot;run&quot;</span>, <span class="hljs-string">&quot;server.py&quot;</span>])

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(
    server_parameters, trust_remote_code=<span class="hljs-literal">True</span>
) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model)
    agent.run(<span class="hljs-string">&quot;What&#x27;s the weather in Tokyo?&quot;</span>)
`,wrap:!1}}),Zt=new d({props:{code:"VGhlJTIwd2VhdGhlciUyMGluJTIwVG9reW8lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGElMjB0ZW1wZXJhdHVyZSUyMG9mJTIwMjAlMjBkZWdyZWVzJTIwQ2Vsc2l1cy4=",highlighted:'The weather <span class="hljs-keyword">in</span> Tokyo is sunny with a temperature of 20 degrees Celsius.',wrap:!1}}),qt=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXYlMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEJTVCJTIyLS1xdWlldCUyMiUyQyUyMCUyMnB1Ym1lZG1jcCU0MDAuMS4zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW52JTNEJTdCJTIyVVZfUFlUSE9OJTIyJTNBJTIwJTIyMy4xMiUyMiUyQyUyMCoqb3MuZW52aXJvbiU3RCUyQyUwQSklMEElMEF3aXRoJTIwVG9vbENvbGxlY3Rpb24uZnJvbV9tY3Aoc2VydmVyX3BhcmFtZXRlcnMlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTIwYXMlMjB0b29sX2NvbGxlY3Rpb24lM0ElMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1Qip0b29sX2NvbGxlY3Rpb24udG9vbHMlNUQlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjBhJTIwcmVtZWR5JTIwZm9yJTIwaGFuZ292ZXIuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uv&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),xt=new d({props:{code:"VGhlJTIwcmVtZWR5JTIwZm9yJTIwaGFuZ292ZXIlMjBpcyUyMHRvJTIwZHJpbmslMjB3YXRlci4=",highlighted:'The remedy <span class="hljs-keyword">for</span> hangover is to drink water.',wrap:!1}}),Gt=new f({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),kt=new nl({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit1/mcp-clients.mdx"}}),{c(){r=p("meta"),U=n(),m=p("p"),w=n(),M(u.$$.fragment),i=n(),C=p("p"),C.textContent=Yt,Ft=n(),E=p("p"),E.textContent=Je,Lt=n(),q=p("p"),q.textContent=ye,Dt=n(),x=p("ul"),x.innerHTML=he,Kt=n(),M(G.$$.fragment),Ot=n(),S=p("p"),S.textContent=Te,ts=n(),M(V.$$.fragment),ss=n(),Q=p("p"),Q.textContent=me,es=n(),M(k.$$.fragment),ls=n(),W=p("p"),W.textContent=we,ns=n(),M(X.$$.fragment),as=n(),_=p("p"),_.textContent=Ue,ps=n(),N=p("p"),N.textContent=Ce,os=n(),M(P.$$.fragment),is=n(),R=p("p"),R.textContent=fe,rs=n(),H=p("p"),H.textContent=de,cs=n(),M(v.$$.fragment),us=n(),M(Y.$$.fragment),Ms=n(),z=p("p"),z.textContent=Ie,js=n(),F=p("p"),F.textContent=$e,Js=n(),M(L.$$.fragment),ys=n(),D=p("p"),D.innerHTML=ve,hs=n(),M(K.$$.fragment),Ts=n(),O=p("p"),O.innerHTML=be,ms=n(),M(tt.$$.fragment),ws=n(),st=p("p"),st.textContent=ge,Us=n(),M(et.$$.fragment),Cs=n(),lt=p("p"),lt.textContent=Be,fs=n(),M(nt.$$.fragment),ds=n(),at=p("p"),at.textContent=Ae,Is=n(),M(pt.$$.fragment),$s=n(),M(ot.$$.fragment),vs=n(),it=p("p"),it.innerHTML=Ze,bs=n(),M(b.$$.fragment),gs=n(),rt=p("p"),rt.innerHTML=Ee,Bs=n(),M(ct.$$.fragment),As=n(),M(ut.$$.fragment),Zs=n(),Mt=p("p"),Mt.textContent=qe,Es=n(),M(jt.$$.fragment),qs=n(),Jt=p("p"),Jt.textContent=xe,xs=n(),M(yt.$$.fragment),Gs=n(),M(ht.$$.fragment),Ss=n(),Tt=p("p"),Tt.textContent=Ge,Vs=n(),M(mt.$$.fragment),Qs=n(),wt=p("p"),wt.textContent=Se,ks=n(),Ut=p("p"),Ut.textContent=Ve,Ws=n(),M(Ct.$$.fragment),Xs=n(),ft=p("p"),ft.innerHTML=Qe,_s=n(),dt=p("p"),dt.innerHTML=ke,Ns=n(),M(It.$$.fragment),Ps=n(),g=p("details"),_t=p("summary"),_t.textContent=We,re=n(),M($t.$$.fragment),Rs=n(),vt=p("p"),vt.innerHTML=Xe,Hs=n(),M(bt.$$.fragment),Ys=n(),B=p("details"),Nt=p("summary"),Nt.textContent=_e,ce=n(),M(gt.$$.fragment),zs=n(),Bt=p("p"),Bt.textContent=Ne,Fs=n(),M(At.$$.fragment),Ls=n(),A=p("details"),Pt=p("summary"),Pt.textContent=Pe,ue=n(),M(Zt.$$.fragment),Ds=n(),Et=p("p"),Et.innerHTML=Re,Ks=n(),M(qt.$$.fragment),Os=n(),Z=p("details"),Rt=p("summary"),Rt.textContent=He,Me=n(),M(xt.$$.fragment),te=n(),M(Gt.$$.fragment),se=n(),St=p("p"),St.textContent=Ye,ee=n(),Vt=p("ul"),Vt.innerHTML=ze,le=n(),Qt=p("p"),Qt.textContent=Fe,ne=n(),M(kt.$$.fragment),ae=n(),zt=p("p"),this.h()},l(t){const s=el("svelte-u9bgzb",document.head);r=o(s,"META",{name:!0,content:!0}),s.forEach(e),U=a(t),m=o(t,"P",{}),Ht(m).forEach(e),w=a(t),j(u.$$.fragment,t),i=a(t),C=o(t,"P",{"data-svelte-h":!0}),c(C)!=="svelte-bq1glt"&&(C.textContent=Yt),Ft=a(t),E=o(t,"P",{"data-svelte-h":!0}),c(E)!=="svelte-3v3t4i"&&(E.textContent=Je),Lt=a(t),q=o(t,"P",{"data-svelte-h":!0}),c(q)!=="svelte-37whj1"&&(q.textContent=ye),Dt=a(t),x=o(t,"UL",{"data-svelte-h":!0}),c(x)!=="svelte-nlhyzy"&&(x.innerHTML=he),Kt=a(t),j(G.$$.fragment,t),Ot=a(t),S=o(t,"P",{"data-svelte-h":!0}),c(S)!=="svelte-s96fp3"&&(S.textContent=Te),ts=a(t),j(V.$$.fragment,t),ss=a(t),Q=o(t,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-38oyrl"&&(Q.textContent=me),es=a(t),j(k.$$.fragment,t),ls=a(t),W=o(t,"P",{"data-svelte-h":!0}),c(W)!=="svelte-sh915n"&&(W.textContent=we),ns=a(t),j(X.$$.fragment,t),as=a(t),_=o(t,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1b87lnp"&&(_.textContent=Ue),ps=a(t),N=o(t,"P",{"data-svelte-h":!0}),c(N)!=="svelte-qfmi3f"&&(N.textContent=Ce),os=a(t),j(P.$$.fragment,t),is=a(t),R=o(t,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1t8u4wf"&&(R.textContent=fe),rs=a(t),H=o(t,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1h6qe5q"&&(H.textContent=de),cs=a(t),j(v.$$.fragment,t),us=a(t),j(Y.$$.fragment,t),Ms=a(t),z=o(t,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1ycrnux"&&(z.textContent=Ie),js=a(t),F=o(t,"P",{"data-svelte-h":!0}),c(F)!=="svelte-z7yl0u"&&(F.textContent=$e),Js=a(t),j(L.$$.fragment,t),ys=a(t),D=o(t,"P",{"data-svelte-h":!0}),c(D)!=="svelte-upbqy5"&&(D.innerHTML=ve),hs=a(t),j(K.$$.fragment,t),Ts=a(t),O=o(t,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1xnp18o"&&(O.innerHTML=be),ms=a(t),j(tt.$$.fragment,t),ws=a(t),st=o(t,"P",{"data-svelte-h":!0}),c(st)!=="svelte-eoeyze"&&(st.textContent=ge),Us=a(t),j(et.$$.fragment,t),Cs=a(t),lt=o(t,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-443kp7"&&(lt.textContent=Be),fs=a(t),j(nt.$$.fragment,t),ds=a(t),at=o(t,"P",{"data-svelte-h":!0}),c(at)!=="svelte-1jwz8f7"&&(at.textContent=Ae),Is=a(t),j(pt.$$.fragment,t),$s=a(t),j(ot.$$.fragment,t),vs=a(t),it=o(t,"P",{"data-svelte-h":!0}),c(it)!=="svelte-1c7z0qi"&&(it.innerHTML=Ze),bs=a(t),j(b.$$.fragment,t),gs=a(t),rt=o(t,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-1oqx78f"&&(rt.innerHTML=Ee),Bs=a(t),j(ct.$$.fragment,t),As=a(t),j(ut.$$.fragment,t),Zs=a(t),Mt=o(t,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-fnutrr"&&(Mt.textContent=qe),Es=a(t),j(jt.$$.fragment,t),qs=a(t),Jt=o(t,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-i95sbi"&&(Jt.textContent=xe),xs=a(t),j(yt.$$.fragment,t),Gs=a(t),j(ht.$$.fragment,t),Ss=a(t),Tt=o(t,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-1d51v8x"&&(Tt.textContent=Ge),Vs=a(t),j(mt.$$.fragment,t),Qs=a(t),wt=o(t,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-146ggji"&&(wt.textContent=Se),ks=a(t),Ut=o(t,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-k8z1tj"&&(Ut.textContent=Ve),Ws=a(t),j(Ct.$$.fragment,t),Xs=a(t),ft=o(t,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-aa5a0z"&&(ft.innerHTML=Qe),_s=a(t),dt=o(t,"P",{"data-svelte-h":!0}),c(dt)!=="svelte-a3lj6q"&&(dt.innerHTML=ke),Ns=a(t),j(It.$$.fragment,t),Ps=a(t),g=o(t,"DETAILS",{});var Wt=Ht(g);_t=o(Wt,"SUMMARY",{"data-svelte-h":!0}),c(_t)!=="svelte-1dioj6p"&&(_t.textContent=We),re=a(Wt),j($t.$$.fragment,Wt),Wt.forEach(e),Rs=a(t),vt=o(t,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-ld29sv"&&(vt.innerHTML=Xe),Hs=a(t),j(bt.$$.fragment,t),Ys=a(t),B=o(t,"DETAILS",{});var Xt=Ht(B);Nt=o(Xt,"SUMMARY",{"data-svelte-h":!0}),c(Nt)!=="svelte-1dioj6p"&&(Nt.textContent=_e),ce=a(Xt),j(gt.$$.fragment,Xt),Xt.forEach(e),zs=a(t),Bt=o(t,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-soysth"&&(Bt.textContent=Ne),Fs=a(t),j(At.$$.fragment,t),Ls=a(t),A=o(t,"DETAILS",{});var oe=Ht(A);Pt=o(oe,"SUMMARY",{"data-svelte-h":!0}),c(Pt)!=="svelte-1dioj6p"&&(Pt.textContent=Pe),ue=a(oe),j(Zt.$$.fragment,oe),oe.forEach(e),Ds=a(t),Et=o(t,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-1w1pqn4"&&(Et.innerHTML=Re),Ks=a(t),j(qt.$$.fragment,t),Os=a(t),Z=o(t,"DETAILS",{});var ie=Ht(Z);Rt=o(ie,"SUMMARY",{"data-svelte-h":!0}),c(Rt)!=="svelte-1dioj6p"&&(Rt.textContent=He),Me=a(ie),j(xt.$$.fragment,ie),ie.forEach(e),te=a(t),j(Gt.$$.fragment,t),se=a(t),St=o(t,"P",{"data-svelte-h":!0}),c(St)!=="svelte-jrhgb1"&&(St.textContent=Ye),ee=a(t),Vt=o(t,"UL",{"data-svelte-h":!0}),c(Vt)!=="svelte-1ypqei0"&&(Vt.innerHTML=ze),le=a(t),Qt=o(t,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-crczat"&&(Qt.textContent=Fe),ne=a(t),j(kt.$$.fragment,t),ae=a(t),zt=o(t,"P",{}),Ht(zt).forEach(e),this.h()},h(){Le(r,"name","hf:doc:metadata"),Le(r,"content",ul)},m(t,s){$(document.head,r),l(t,U,s),l(t,m,s),l(t,w,s),J(u,t,s),l(t,i,s),l(t,C,s),l(t,Ft,s),l(t,E,s),l(t,Lt,s),l(t,q,s),l(t,Dt,s),l(t,x,s),l(t,Kt,s),J(G,t,s),l(t,Ot,s),l(t,S,s),l(t,ts,s),J(V,t,s),l(t,ss,s),l(t,Q,s),l(t,es,s),J(k,t,s),l(t,ls,s),l(t,W,s),l(t,ns,s),J(X,t,s),l(t,as,s),l(t,_,s),l(t,ps,s),l(t,N,s),l(t,os,s),J(P,t,s),l(t,is,s),l(t,R,s),l(t,rs,s),l(t,H,s),l(t,cs,s),J(v,t,s),l(t,us,s),J(Y,t,s),l(t,Ms,s),l(t,z,s),l(t,js,s),l(t,F,s),l(t,Js,s),J(L,t,s),l(t,ys,s),l(t,D,s),l(t,hs,s),J(K,t,s),l(t,Ts,s),l(t,O,s),l(t,ms,s),J(tt,t,s),l(t,ws,s),l(t,st,s),l(t,Us,s),J(et,t,s),l(t,Cs,s),l(t,lt,s),l(t,fs,s),J(nt,t,s),l(t,ds,s),l(t,at,s),l(t,Is,s),J(pt,t,s),l(t,$s,s),J(ot,t,s),l(t,vs,s),l(t,it,s),l(t,bs,s),J(b,t,s),l(t,gs,s),l(t,rt,s),l(t,Bs,s),J(ct,t,s),l(t,As,s),J(ut,t,s),l(t,Zs,s),l(t,Mt,s),l(t,Es,s),J(jt,t,s),l(t,qs,s),l(t,Jt,s),l(t,xs,s),J(yt,t,s),l(t,Gs,s),J(ht,t,s),l(t,Ss,s),l(t,Tt,s),l(t,Vs,s),J(mt,t,s),l(t,Qs,s),l(t,wt,s),l(t,ks,s),l(t,Ut,s),l(t,Ws,s),J(Ct,t,s),l(t,Xs,s),l(t,ft,s),l(t,_s,s),l(t,dt,s),l(t,Ns,s),J(It,t,s),l(t,Ps,s),l(t,g,s),$(g,_t),$(g,re),J($t,g,null),l(t,Rs,s),l(t,vt,s),l(t,Hs,s),J(bt,t,s),l(t,Ys,s),l(t,B,s),$(B,Nt),$(B,ce),J(gt,B,null),l(t,zs,s),l(t,Bt,s),l(t,Fs,s),J(At,t,s),l(t,Ls,s),l(t,A,s),$(A,Pt),$(A,ue),J(Zt,A,null),l(t,Ds,s),l(t,Et,s),l(t,Ks,s),J(qt,t,s),l(t,Os,s),l(t,Z,s),$(Z,Rt),$(Z,Me),J(xt,Z,null),l(t,te,s),J(Gt,t,s),l(t,se,s),l(t,St,s),l(t,ee,s),l(t,Vt,s),l(t,le,s),l(t,Qt,s),l(t,ne,s),J(kt,t,s),l(t,ae,s),l(t,zt,s),pe=!0},p(t,[s]){const Wt={};s&2&&(Wt.$$scope={dirty:s,ctx:t}),v.$set(Wt);const Xt={};s&2&&(Xt.$$scope={dirty:s,ctx:t}),b.$set(Xt)},i(t){pe||(y(u.$$.fragment,t),y(G.$$.fragment,t),y(V.$$.fragment,t),y(k.$$.fragment,t),y(X.$$.fragment,t),y(P.$$.fragment,t),y(v.$$.fragment,t),y(Y.$$.fragment,t),y(L.$$.fragment,t),y(K.$$.fragment,t),y(tt.$$.fragment,t),y(et.$$.fragment,t),y(nt.$$.fragment,t),y(pt.$$.fragment,t),y(ot.$$.fragment,t),y(b.$$.fragment,t),y(ct.$$.fragment,t),y(ut.$$.fragment,t),y(jt.$$.fragment,t),y(yt.$$.fragment,t),y(ht.$$.fragment,t),y(mt.$$.fragment,t),y(Ct.$$.fragment,t),y(It.$$.fragment,t),y($t.$$.fragment,t),y(bt.$$.fragment,t),y(gt.$$.fragment,t),y(At.$$.fragment,t),y(Zt.$$.fragment,t),y(qt.$$.fragment,t),y(xt.$$.fragment,t),y(Gt.$$.fragment,t),y(kt.$$.fragment,t),pe=!0)},o(t){h(u.$$.fragment,t),h(G.$$.fragment,t),h(V.$$.fragment,t),h(k.$$.fragment,t),h(X.$$.fragment,t),h(P.$$.fragment,t),h(v.$$.fragment,t),h(Y.$$.fragment,t),h(L.$$.fragment,t),h(K.$$.fragment,t),h(tt.$$.fragment,t),h(et.$$.fragment,t),h(nt.$$.fragment,t),h(pt.$$.fragment,t),h(ot.$$.fragment,t),h(b.$$.fragment,t),h(ct.$$.fragment,t),h(ut.$$.fragment,t),h(jt.$$.fragment,t),h(yt.$$.fragment,t),h(ht.$$.fragment,t),h(mt.$$.fragment,t),h(Ct.$$.fragment,t),h(It.$$.fragment,t),h($t.$$.fragment,t),h(bt.$$.fragment,t),h(gt.$$.fragment,t),h(At.$$.fragment,t),h(Zt.$$.fragment,t),h(qt.$$.fragment,t),h(xt.$$.fragment,t),h(Gt.$$.fragment,t),h(kt.$$.fragment,t),pe=!1},d(t){t&&(e(U),e(m),e(w),e(i),e(C),e(Ft),e(E),e(Lt),e(q),e(Dt),e(x),e(Kt),e(Ot),e(S),e(ts),e(ss),e(Q),e(es),e(ls),e(W),e(ns),e(as),e(_),e(ps),e(N),e(os),e(is),e(R),e(rs),e(H),e(cs),e(us),e(Ms),e(z),e(js),e(F),e(Js),e(ys),e(D),e(hs),e(Ts),e(O),e(ms),e(ws),e(st),e(Us),e(Cs),e(lt),e(fs),e(ds),e(at),e(Is),e($s),e(vs),e(it),e(bs),e(gs),e(rt),e(Bs),e(As),e(Zs),e(Mt),e(Es),e(qs),e(Jt),e(xs),e(Gs),e(Ss),e(Tt),e(Vs),e(Qs),e(wt),e(ks),e(Ut),e(Ws),e(Xs),e(ft),e(_s),e(dt),e(Ns),e(Ps),e(g),e(Rs),e(vt),e(Hs),e(Ys),e(B),e(zs),e(Bt),e(Fs),e(Ls),e(A),e(Ds),e(Et),e(Ks),e(Os),e(Z),e(te),e(se),e(St),e(ee),e(Vt),e(le),e(Qt),e(ne),e(ae),e(zt)),e(r),T(u,t),T(G,t),T(V,t),T(k,t),T(X,t),T(P,t),T(v,t),T(Y,t),T(L,t),T(K,t),T(tt,t),T(et,t),T(nt,t),T(pt,t),T(ot,t),T(b,t),T(ct,t),T(ut,t),T(jt,t),T(yt,t),T(ht,t),T(mt,t),T(Ct,t),T(It,t),T($t),T(bt,t),T(gt),T(At,t),T(Zt),T(qt,t),T(xt),T(Gt,t),T(kt,t)}}}const ul='{"title":"MCP Clients","local":"mcp-clients","sections":[{"title":"Understanding MCP Clients","local":"understanding-mcp-clients","sections":[],"depth":2},{"title":"User Interface Client","local":"user-interface-client","sections":[{"title":"Chat Interface Clients","local":"chat-interface-clients","sections":[],"depth":3},{"title":"Interactive Development Clients","local":"interactive-development-clients","sections":[],"depth":3}],"depth":2},{"title":"Configuring MCP Clients","local":"configuring-mcp-clients","sections":[{"title":"MCP Configuration Files","local":"mcp-configuration-files","sections":[{"title":"mcp.json Structure","local":"mcpjson-structure","sections":[],"depth":4},{"title":"Configuration for stdio Transport","local":"configuration-for-stdio-transport","sections":[],"depth":4},{"title":"Configuration for HTTP+SSE Transport","local":"configuration-for-httpsse-transport","sections":[],"depth":4},{"title":"Environment Variables in Configuration","local":"environment-variables-in-configuration","sections":[],"depth":4}],"depth":3},{"title":"Configuration Examples","local":"configuration-examples","sections":[{"title":"Scenario 1: Local Server Configuration","local":"scenario-1-local-server-configuration","sections":[],"depth":4},{"title":"Scenario 2: Remote Server Configuration","local":"scenario-2-remote-server-configuration","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Code Clients","local":"code-clients","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Ml(I){return Oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wl extends tl{constructor(r){super(),sl(this,r,Ml,cl,Ke,{})}}export{wl as component};
