import{s as Tn,o as Jn,n as Et}from"../chunks/scheduler.8c3d61f6.js";import{S as Un,i as Zn,g as f,s,r as a,A as jn,h as u,f as n,c as l,j as Xe,u as r,x as g,k as Ve,y as $,a as i,v as p,d,t as c,w as m}from"../chunks/index.da70eac4.js";import{T as qt}from"../chunks/Tip.1d9b8c37.js";import{D as At}from"../chunks/Docstring.6b390b9a.js";import{C as _}from"../chunks/CodeBlock.00a903b3.js";import{E as In}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as b,E as Bn}from"../chunks/EditOnGithub.1e64e623.js";function vn(Z){let o,w="The SD3 pipeline uses three text encoders to generate an image. Model offloading is necessary in order for it to run on most commodity hardware. Please use the <code>torch.float16</code> data type for additional memory savings.";return{c(){o=f("p"),o.innerHTML=w},l(h){o=u(h,"P",{"data-svelte-h":!0}),g(o)!=="svelte-1abcova"&&(o.innerHTML=w)},m(h,M){i(h,o,M)},p:Et,d(h){h&&n(o)}}}function Gn(Z){let o,w="The prompt with the CLIP Text Encoders is still truncated to the 77 token limit.";return{c(){o=f("p"),o.textContent=w},l(h){o=u(h,"P",{"data-svelte-h":!0}),g(o)!=="svelte-1pfxyog"&&(o.textContent=w)},m(h,M){i(h,o,M)},p:Et,d(h){h&&n(o)}}}function Wn(Z){let o,w="The following example loads a checkpoint stored in a 8-bit floating point format which requires PyTorch 2.3 or later.";return{c(){o=f("p"),o.textContent=w},l(h){o=u(h,"P",{"data-svelte-h":!0}),g(o)!=="svelte-msx2hu"&&(o.textContent=w)},m(h,M){i(h,o,M)},p:Et,d(h){h&&n(o)}}}function kn(Z){let o,w="Examples:",h,M,T;return M=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkMy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusion3Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3.png&quot;</span>)`,wrap:!1}}),{c(){o=f("p"),o.textContent=w,h=s(),a(M.$$.fragment)},l(y){o=u(y,"P",{"data-svelte-h":!0}),g(o)!=="svelte-kvfsh7"&&(o.textContent=w),h=l(y),r(M.$$.fragment,y)},m(y,J){i(y,o,J),i(y,h,J),p(M,y,J),T=!0},p:Et,i(y){T||(d(M.$$.fragment,y),T=!0)},o(y){c(M.$$.fragment,y),T=!1},d(y){y&&(n(o),n(h)),m(M,y)}}}function $n(Z){let o,w,h,M,T,y,J,Ot='Stable Diffusion 3 (SD3) was proposed in <a href="https://arxiv.org/pdf/2403.03206.pdf" rel="nofollow">Scaling Rectified Flow Transformers for High-Resolution Image Synthesis</a> by Patrick Esser, Sumith Kulal, Andreas Blattmann, Rahim Entezari, Jonas Muller, Harry Saini, Yam Levi, Dominik Lorenz, Axel Sauer, Frederic Boesel, Dustin Podell, Tim Dockhorn, Zion English, Kyle Lacey, Alex Goodwin, Yannik Marek, and Robin Rombach.',ze,x,Kt="The abstract from the paper is:",Ne,S,en="<em>Diffusion models create data from noise by inverting the forward paths of data towards noise and have emerged as a powerful generative modeling technique for high-dimensional, perceptual data such as images and videos. Rectified flow is a recent generative model formulation that connects data and noise in a straight line. Despite its better theoretical properties and conceptual simplicity, it is not yet decisively established as standard practice. In this work, we improve existing noise sampling techniques for training rectified flow models by biasing them towards perceptually relevant scales. Through a large-scale study, we demonstrate the superior performance of this approach compared to established diffusion formulations for high-resolution text-to-image synthesis. Additionally, we present a novel transformer-based architecture for text-to-image generation that uses separate weights for the two modalities and enables a bidirectional flow of information between image and text tokens, improving text comprehension typography, and human preference ratings. We demonstrate that this architecture follows predictable scaling trends and correlates lower validation loss to improved text-to-image synthesis as measured by various metrics and human evaluations.</em>",De,C,Qe,R,tn='<em>As the model is gated, before using it with diffusers you first need to go to the <a href="https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers" rel="nofollow">Stable Diffusion 3 Medium Hugging Face page</a>, fill in the form and accept the gate. Once you are in, you need to login so that your system knows you’ve accepted the gate.</em>',Ee,Y,nn="Use the command below to log in:",Fe,X,He,v,Le,V,Pe,z,sn="<strong>Note:</strong> Stable Diffusion 3.5 can also be run using the SD3 pipeline, and all mentioned optimizations and techniques apply to it as well. In total there are three official models in the SD3 family:",qe,N,ln='<li><a href="https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers" rel="nofollow"><code>stabilityai/stable-diffusion-3-medium-diffusers</code></a></li> <li><a href="https://huggingface.co/stabilityai/stable-diffusion-3-5-large" rel="nofollow"><code>stabilityai/stable-diffusion-3.5-large</code></a></li> <li><a href="https://huggingface.co/stabilityai/stable-diffusion-3-5-large-turbo" rel="nofollow"><code>stabilityai/stable-diffusion-3.5-large-turbo</code></a></li>',Ae,D,Oe,Q,on="SD3 uses three text encoders, one if which is the very large T5-XXL model. This makes it challenging to run the model on GPUs with less than 24GB of VRAM, even when using <code>fp16</code> precision. The following section outlines a few memory optimizations in Diffusers that make it easier to run SD3 on low resource hardware.",Ke,E,et,F,an="The most basic memory optimization available in Diffusers allows you to offload the components of the model to CPU during inference in order to save memory, while seeing a slight increase in inference latency. Model offloading will only move a model component onto the GPU when it needs to be executed, while keeping the remaining components on the CPU.",tt,H,nt,L,it,P,rn="Removing the memory-intensive 4.7B parameter T5-XXL text encoder during inference can significantly decrease the memory requirements for SD3 with only a slight loss in performance.",st,q,lt,A,ot,O,pn="We can leverage the <code>bitsandbytes</code> library to load and quantize the T5-XXL text encoder to 8-bit precision. This allows you to keep using all three text encoders while only slightly impacting performance.",at,K,dn="First install the <code>bitsandbytes</code> library.",rt,ee,pt,te,cn="Then load the T5-XXL model using the <code>BitsAndBytesConfig</code>.",dt,ne,ct,ie,mn='You can find the end-to-end script <a href="https://gist.github.com/sayakpaul/82acb5976509851f2db1a83456e504f1" rel="nofollow">here</a>.',mt,se,ft,le,ut,oe,fn="Using compiled components in the SD3 pipeline can speed up inference by as much as 4X. The following code snippet demonstrates how to compile the Transformer and VAE components of the SD3 pipeline.",ht,ae,gt,re,un='Check out the full script <a href="https://gist.github.com/sayakpaul/508d89d7aad4f454900813da5d42ca97" rel="nofollow">here</a>.',yt,pe,Mt,de,hn="By default, the T5 Text Encoder prompt uses a maximum sequence length of <code>256</code>. This can be adjusted by setting the <code>max_sequence_length</code> to accept fewer or more tokens. Keep in mind that longer sequences require additional resources and result in longer generation times, such as during batch inference.",bt,ce,wt,me,_t,fe,gn="You can send a different prompt to the CLIP Text Encoders and the T5 Text Encoder to prevent the prompt from being truncated by the CLIP Text Encoders and to improve generation.",Tt,G,Jt,ue,Ut,he,Zt,ge,yn='Tiny AutoEncoder for Stable Diffusion (TAESD3) is a tiny distilled version of Stable Diffusion 3’s VAE by <a href="https://github.com/madebyollin/taesd" rel="nofollow">Ollin Boer Bohan</a> that can decode <a href="/docs/diffusers/pr_10131/en/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3Pipeline">StableDiffusion3Pipeline</a> latents almost instantly.',jt,ye,Mn="To use with Stable Diffusion 3:",It,Me,Bt,be,vt,we,bn="The <code>SD3Transformer2DModel</code> and <code>StableDiffusion3Pipeline</code> classes support loading the original checkpoints via the <code>from_single_file</code> method. This method allows you to load the original checkpoint files that were used to train the models.",Gt,_e,Wt,Te,kt,Je,$t,Ue,xt,Ze,St,je,Ct,W,Rt,Ie,Yt,Be,Xt,ve,Vt,Ge,zt,U,We,Ft,j,ke,Ht,Se,wn="Function invoked when calling the pipeline for generation.",Lt,k,Pt,Ce,$e,Nt,xe,Dt,Re,Qt;return T=new b({props:{title:"Stable Diffusion 3",local:"stable-diffusion-3",headingTag:"h1"}}),C=new b({props:{title:"Usage Example",local:"usage-example",headingTag:"h2"}}),X=new _({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),v=new qt({props:{$$slots:{default:[vn]},$$scope:{ctx:Z}}}),V=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),D=new b({props:{title:"Memory Optimisations for SD3",local:"memory-optimisations-for-sd3",headingTag:"h2"}}),E=new b({props:{title:"Running Inference with Model Offloading",local:"running-inference-with-model-offloading",headingTag:"h3"}}),H=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),L=new b({props:{title:"Dropping the T5 Text Encoder during Inference",local:"dropping-the-t5-text-encoder-during-inference",headingTag:"h3"}}),q=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLW5vLVQ1LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    text_encoder_3=<span class="hljs-literal">None</span>,
    tokenizer_3=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-no-T5.png&quot;</span>)`,wrap:!1}}),A=new b({props:{title:"Using a Quantized Version of the T5 Text Encoder",local:"using-a-quantized-version-of-the-t5-text-encoder",headingTag:"h3"}}),ee=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes",wrap:!1}}),ne=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8zJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfMyUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENy4wJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjJzZDNfaGVsbG9fd29ybGQtOGJpdC1UNS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>
text_encoder = T5EncoderModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;text_encoder_3&quot;</span>,
    quantization_config=quantization_config,
)
pipe = StableDiffusion3Pipeline.from_pretrained(
    model_id,
    text_encoder_3=text_encoder,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    torch_dtype=torch.float16
)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-8bit-T5.png&quot;</span>)`,wrap:!1}}),se=new b({props:{title:"Performance Optimizations for SD3",local:"performance-optimizations-for-sd3",headingTag:"h2"}}),le=new b({props:{title:"Using Torch Compile to Speed Up Inference",local:"using-torch-compile-to-speed-up-inference",headingTag:"h3"}}),ae=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBdG9yY2guc2V0X2Zsb2F0MzJfbWF0bXVsX3ByZWNpc2lvbiglMjJoaWdoJTIyKSUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0tZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2V0X3Byb2dyZXNzX2Jhcl9jb25maWcoZGlzYWJsZSUzRFRydWUpJTBBJTBBcGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEFwaXBlLnZhZS50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEElMEFwaXBlLnRyYW5zZm9ybWVyJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBcGlwZS52YWUuZGVjb2RlJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnZhZS5kZWNvZGUlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBXYXJtJTIwVXAlMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMF8lMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDEpKSUwQSUwQSUyMyUyMFJ1biUyMEluZmVyZW5jZSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZCgxKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

torch.set_float32_matmul_precision(<span class="hljs-string">&quot;high&quot;</span>)

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)

pipe.transformer.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)

pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Warm Up</span>
prompt = <span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    _ = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>))

<span class="hljs-comment"># Run Inference</span>
image = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>)).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),pe=new b({props:{title:"Using Long Prompts with the T5 Text Encoder",local:"using-long-prompts-with-the-t5-text-encoder",headingTag:"h2"}}),ce=new _({props:{code:"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",highlighted:`prompt = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. It features the distinctive, bulky body shape of a hippo. However, instead of the usual grey skin, the creature’s body resembles a golden-brown, crispy waffle fresh off the griddle. The skin is textured with the familiar grid pattern of a waffle, each square filled with a glistening sheen of syrup. The environment combines the natural habitat of a hippo with elements of a breakfast table setting, a river of warm, melted butter, with oversized utensils or plates peeking out from the lush, pancake-like foliage in the background, a towering pepper mill standing in for a tree.  As the sun rises in this fantastical world, it casts a warm, buttery glow over the scene. The creature, content in its butter river, lets out a yawn. Nearby, a flock of birds take flight&quot;</span>

image = pipe(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    guidance_scale=<span class="hljs-number">4.5</span>,
    max_sequence_length=<span class="hljs-number">512</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),me=new b({props:{title:"Sending a different prompt to the T5 Text Encoder",local:"sending-a-different-prompt-to-the-t5-text-encoder",headingTag:"h3"}}),G=new qt({props:{$$slots:{default:[Gn]},$$scope:{ctx:Z}}}),ue=new _({props:{code:"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",highlighted:`prompt = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. A river of warm, melted butter, pancake-like foliage in the background, a towering pepper mill standing in for a tree.&quot;</span>

prompt_3 = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. It features the distinctive, bulky body shape of a hippo. However, instead of the usual grey skin, the creature’s body resembles a golden-brown, crispy waffle fresh off the griddle. The skin is textured with the familiar grid pattern of a waffle, each square filled with a glistening sheen of syrup. The environment combines the natural habitat of a hippo with elements of a breakfast table setting, a river of warm, melted butter, with oversized utensils or plates peeking out from the lush, pancake-like foliage in the background, a towering pepper mill standing in for a tree.  As the sun rises in this fantastical world, it casts a warm, buttery glow over the scene. The creature, content in its butter river, lets out a yawn. Nearby, a flock of birds take flight&quot;</span>

image = pipe(
    prompt=prompt,
    prompt_3=prompt_3,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    guidance_scale=<span class="hljs-number">4.5</span>,
    max_sequence_length=<span class="hljs-number">512</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),he=new b({props:{title:"Tiny AutoEncoder for Stable Diffusion 3",local:"tiny-autoencoder-for-stable-diffusion-3",headingTag:"h2"}}),Me=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTJDJTIwQXV0b2VuY29kZXJUaW55JTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyVGlueS5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZ0YWVzZDMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJzbGljZSUyMG9mJTIwZGVsaWNpb3VzJTIwTmV3JTIwWW9yay1zdHlsZSUyMGJlcnJ5JTIwY2hlZXNlY2FrZSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoZWVzZWNha2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline, AutoencoderTiny

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
)
pipe.vae = AutoencoderTiny.from_pretrained(<span class="hljs-string">&quot;madebyollin/taesd3&quot;</span>, torch_dtype=torch.float16)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;slice of delicious New York-style berry cheesecake&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cheesecake.png&quot;</span>)`,wrap:!1}}),be=new b({props:{title:"Loading the original checkpoints via from_single_file",local:"loading-the-original-checkpoints-via-fromsinglefile",headingTag:"h2"}}),_e=new b({props:{title:"Loading the original checkpoints for the SD3Transformer2DModel",local:"loading-the-original-checkpoints-for-the-sd3transformer2dmodel",headingTag:"h2"}}),Te=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwU0QzVHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fc2luZ2xlX2ZpbGUoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bSUyRmJsb2IlMkZtYWluJTJGc2QzX21lZGl1bS5zYWZldGVuc29ycyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel

model = SD3Transformer2DModel.from_single_file(<span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium.safetensors&quot;</span>)`,wrap:!1}}),Je=new b({props:{title:"Loading the single checkpoint for the StableDiffusion3Pipeline",local:"loading-the-single-checkpoint-for-the-stablediffusion3pipeline",headingTag:"h2"}}),Ue=new b({props:{title:"Loading the single file checkpoint without T5",local:"loading-the-single-file-checkpoint-without-t5",headingTag:"h3"}}),Ze=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0lMkZibG9iJTJGbWFpbiUyRnNkM19tZWRpdW1faW5jbF9jbGlwcy5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8zJTNETm9uZSUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBwaWN0dXJlJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSgnc2QzLXNpbmdsZS1maWxlLnBuZycp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium_incl_clips.safetensors&quot;</span>,
    torch_dtype=torch.float16,
    text_encoder_3=<span class="hljs-literal">None</span>
)
pipe.enable_model_cpu_offload()

image = pipe(<span class="hljs-string">&quot;a picture of a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;sd3-single-file.png&#x27;</span>)`,wrap:!1}}),je=new b({props:{title:"Loading the single file checkpoint with T5",local:"loading-the-single-file-checkpoint-with-t5",headingTag:"h3"}}),W=new qt({props:{warning:!1,$$slots:{default:[Wn]},$$scope:{ctx:Z}}}),Ie=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0lMkZibG9iJTJGbWFpbiUyRnNkM19tZWRpdW1faW5jbF9jbGlwc190NXh4bGZwOC5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBwaWN0dXJlJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSgnc2QzLXNpbmdsZS1maWxlLXQ1LWZwOC5wbmcnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium_incl_clips_t5xxlfp8.safetensors&quot;</span>,
    torch_dtype=torch.float16,
)
pipe.enable_model_cpu_offload()

image = pipe(<span class="hljs-string">&quot;a picture of a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;sd3-single-file-t5-fp8.png&#x27;</span>)`,wrap:!1}}),Be=new b({props:{title:"Loading the single file checkpoint for the Stable Diffusion 3.5 Transformer Model",local:"loading-the-single-file-checkpoint-for-the-stable-diffusion-35-transformer-model",headingTag:"h3"}}),ve=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU0QzVHJhbnNmb3JtZXIyRE1vZGVsJTJDJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBTRDNUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMuNS1sYXJnZS10dXJibyUyRmJsb2IlMkZtYWluJTJGc2QzLjVfbGFyZ2Uuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb24zUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLjUtbGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkMzUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel, StableDiffusion3Pipeline

transformer = SD3Transformer2DModel.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3.5-large-turbo/blob/main/sd3.5_large.safetensors&quot;</span>,
    torch_dtype=torch.bfloat16,
)
pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3.5-large&quot;</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16,
)
pipe.enable_model_cpu_offload()
image = pipe(<span class="hljs-string">&quot;a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sd35.png&quot;</span>)`,wrap:!1}}),Ge=new b({props:{title:"StableDiffusion3Pipeline",local:"diffusers.StableDiffusion3Pipeline",headingTag:"h2"}}),We=new At({props:{name:"class diffusers.StableDiffusion3Pipeline",anchor:"diffusers.StableDiffusion3Pipeline",parameters:[{name:"transformer",val:": SD3Transformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"text_encoder_3",val:": T5EncoderModel"},{name:"tokenizer_3",val:": T5TokenizerFast"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/pr_10131/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.StableDiffusion3Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/pr_10131/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableDiffusion3Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/pr_10131/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant,
with an additional added projection layer that is initialized with a diagonal matrix with the <code>hidden_size</code>
as its dimension.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_3",description:`<strong>text_encoder_3</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion 3 uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder_3"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_3",description:`<strong>tokenizer_3</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer_3"}],source:"https://github.com/huggingface/diffusers/blob/vr_10131/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L131"}}),ke=new At({props:{name:"__call__",anchor:"diffusers.StableDiffusion3Pipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"},{name:"skip_guidance_layers",val:": typing.List[int] = None"},{name:"skip_layer_guidance_scale",val:": int = 2.8"},{name:"skip_layer_guidance_stop",val:": int = 0.2"},{name:"skip_layer_guidance_start",val:": int = 0.01"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_guidance_layers",description:`<strong>skip_guidance_layers</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of integers that specify layers to skip during guidance. If not provided, all layers will be
used for guidance. If provided, the guidance will only be applied to the layers specified in the list.
Recommended value by StabiltyAI for Stable Diffusion 3.5 Medium is [7, 8, 9].`,name:"skip_guidance_layers"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_layer_guidance_scale",description:`<strong>skip_layer_guidance_scale</strong> (<code>int</code>, <em>optional</em>) &#x2014; The scale of the guidance for the layers specified in
<code>skip_guidance_layers</code>. The guidance will be applied to the layers specified in <code>skip_guidance_layers</code>
with a scale of <code>skip_layer_guidance_scale</code>. The guidance will be applied to the rest of the layers
with a scale of <code>1</code>.`,name:"skip_layer_guidance_scale"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_layer_guidance_stop",description:`<strong>skip_layer_guidance_stop</strong> (<code>int</code>, <em>optional</em>) &#x2014; The step at which the guidance for the layers specified in
<code>skip_guidance_layers</code> will stop. The guidance will be applied to the layers specified in
<code>skip_guidance_layers</code> until the fraction specified in <code>skip_layer_guidance_stop</code>. Recommended value by
StabiltyAI for Stable Diffusion 3.5 Medium is 0.2.`,name:"skip_layer_guidance_stop"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_layer_guidance_start",description:`<strong>skip_layer_guidance_start</strong> (<code>int</code>, <em>optional</em>) &#x2014; The step at which the guidance for the layers specified in
<code>skip_guidance_layers</code> will start. The guidance will be applied to the layers specified in
<code>skip_guidance_layers</code> from the fraction specified in <code>skip_layer_guidance_start</code>. Recommended value by
StabiltyAI for Stable Diffusion 3.5 Medium is 0.01.`,name:"skip_layer_guidance_start"}],source:"https://github.com/huggingface/diffusers/blob/vr_10131/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L672",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> or <code>tuple</code></p>
`}}),k=new In({props:{anchor:"diffusers.StableDiffusion3Pipeline.__call__.example",$$slots:{default:[kn]},$$scope:{ctx:Z}}}),$e=new At({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_3",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"max_sequence_length",val:": int = 256"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_10131/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L321"}}),xe=new Bn({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_diffusion/stable_diffusion_3.md"}}),{c(){o=f("meta"),w=s(),h=f("p"),M=s(),a(T.$$.fragment),y=s(),J=f("p"),J.innerHTML=Ot,ze=s(),x=f("p"),x.textContent=Kt,Ne=s(),S=f("p"),S.innerHTML=en,De=s(),a(C.$$.fragment),Qe=s(),R=f("p"),R.innerHTML=tn,Ee=s(),Y=f("p"),Y.textContent=nn,Fe=s(),a(X.$$.fragment),He=s(),a(v.$$.fragment),Le=s(),a(V.$$.fragment),Pe=s(),z=f("p"),z.innerHTML=sn,qe=s(),N=f("ul"),N.innerHTML=ln,Ae=s(),a(D.$$.fragment),Oe=s(),Q=f("p"),Q.innerHTML=on,Ke=s(),a(E.$$.fragment),et=s(),F=f("p"),F.textContent=an,tt=s(),a(H.$$.fragment),nt=s(),a(L.$$.fragment),it=s(),P=f("p"),P.textContent=rn,st=s(),a(q.$$.fragment),lt=s(),a(A.$$.fragment),ot=s(),O=f("p"),O.innerHTML=pn,at=s(),K=f("p"),K.innerHTML=dn,rt=s(),a(ee.$$.fragment),pt=s(),te=f("p"),te.innerHTML=cn,dt=s(),a(ne.$$.fragment),ct=s(),ie=f("p"),ie.innerHTML=mn,mt=s(),a(se.$$.fragment),ft=s(),a(le.$$.fragment),ut=s(),oe=f("p"),oe.textContent=fn,ht=s(),a(ae.$$.fragment),gt=s(),re=f("p"),re.innerHTML=un,yt=s(),a(pe.$$.fragment),Mt=s(),de=f("p"),de.innerHTML=hn,bt=s(),a(ce.$$.fragment),wt=s(),a(me.$$.fragment),_t=s(),fe=f("p"),fe.textContent=gn,Tt=s(),a(G.$$.fragment),Jt=s(),a(ue.$$.fragment),Ut=s(),a(he.$$.fragment),Zt=s(),ge=f("p"),ge.innerHTML=yn,jt=s(),ye=f("p"),ye.textContent=Mn,It=s(),a(Me.$$.fragment),Bt=s(),a(be.$$.fragment),vt=s(),we=f("p"),we.innerHTML=bn,Gt=s(),a(_e.$$.fragment),Wt=s(),a(Te.$$.fragment),kt=s(),a(Je.$$.fragment),$t=s(),a(Ue.$$.fragment),xt=s(),a(Ze.$$.fragment),St=s(),a(je.$$.fragment),Ct=s(),a(W.$$.fragment),Rt=s(),a(Ie.$$.fragment),Yt=s(),a(Be.$$.fragment),Xt=s(),a(ve.$$.fragment),Vt=s(),a(Ge.$$.fragment),zt=s(),U=f("div"),a(We.$$.fragment),Ft=s(),j=f("div"),a(ke.$$.fragment),Ht=s(),Se=f("p"),Se.textContent=wn,Lt=s(),a(k.$$.fragment),Pt=s(),Ce=f("div"),a($e.$$.fragment),Nt=s(),a(xe.$$.fragment),Dt=s(),Re=f("p"),this.h()},l(e){const t=jn("svelte-u9bgzb",document.head);o=u(t,"META",{name:!0,content:!0}),t.forEach(n),w=l(e),h=u(e,"P",{}),Xe(h).forEach(n),M=l(e),r(T.$$.fragment,e),y=l(e),J=u(e,"P",{"data-svelte-h":!0}),g(J)!=="svelte-3c386r"&&(J.innerHTML=Ot),ze=l(e),x=u(e,"P",{"data-svelte-h":!0}),g(x)!=="svelte-1cwsb16"&&(x.textContent=Kt),Ne=l(e),S=u(e,"P",{"data-svelte-h":!0}),g(S)!=="svelte-vkvbjo"&&(S.innerHTML=en),De=l(e),r(C.$$.fragment,e),Qe=l(e),R=u(e,"P",{"data-svelte-h":!0}),g(R)!=="svelte-mtsbjp"&&(R.innerHTML=tn),Ee=l(e),Y=u(e,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-12sg8l0"&&(Y.textContent=nn),Fe=l(e),r(X.$$.fragment,e),He=l(e),r(v.$$.fragment,e),Le=l(e),r(V.$$.fragment,e),Pe=l(e),z=u(e,"P",{"data-svelte-h":!0}),g(z)!=="svelte-16uzmu4"&&(z.innerHTML=sn),qe=l(e),N=u(e,"UL",{"data-svelte-h":!0}),g(N)!=="svelte-1wxish5"&&(N.innerHTML=ln),Ae=l(e),r(D.$$.fragment,e),Oe=l(e),Q=u(e,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-1ovwj93"&&(Q.innerHTML=on),Ke=l(e),r(E.$$.fragment,e),et=l(e),F=u(e,"P",{"data-svelte-h":!0}),g(F)!=="svelte-uyrglw"&&(F.textContent=an),tt=l(e),r(H.$$.fragment,e),nt=l(e),r(L.$$.fragment,e),it=l(e),P=u(e,"P",{"data-svelte-h":!0}),g(P)!=="svelte-k4awn"&&(P.textContent=rn),st=l(e),r(q.$$.fragment,e),lt=l(e),r(A.$$.fragment,e),ot=l(e),O=u(e,"P",{"data-svelte-h":!0}),g(O)!=="svelte-vcvc4f"&&(O.innerHTML=pn),at=l(e),K=u(e,"P",{"data-svelte-h":!0}),g(K)!=="svelte-1t2mxsa"&&(K.innerHTML=dn),rt=l(e),r(ee.$$.fragment,e),pt=l(e),te=u(e,"P",{"data-svelte-h":!0}),g(te)!=="svelte-1pykif5"&&(te.innerHTML=cn),dt=l(e),r(ne.$$.fragment,e),ct=l(e),ie=u(e,"P",{"data-svelte-h":!0}),g(ie)!=="svelte-bsz29z"&&(ie.innerHTML=mn),mt=l(e),r(se.$$.fragment,e),ft=l(e),r(le.$$.fragment,e),ut=l(e),oe=u(e,"P",{"data-svelte-h":!0}),g(oe)!=="svelte-x56fi6"&&(oe.textContent=fn),ht=l(e),r(ae.$$.fragment,e),gt=l(e),re=u(e,"P",{"data-svelte-h":!0}),g(re)!=="svelte-d39h5a"&&(re.innerHTML=un),yt=l(e),r(pe.$$.fragment,e),Mt=l(e),de=u(e,"P",{"data-svelte-h":!0}),g(de)!=="svelte-ejr28n"&&(de.innerHTML=hn),bt=l(e),r(ce.$$.fragment,e),wt=l(e),r(me.$$.fragment,e),_t=l(e),fe=u(e,"P",{"data-svelte-h":!0}),g(fe)!=="svelte-1ey7u3k"&&(fe.textContent=gn),Tt=l(e),r(G.$$.fragment,e),Jt=l(e),r(ue.$$.fragment,e),Ut=l(e),r(he.$$.fragment,e),Zt=l(e),ge=u(e,"P",{"data-svelte-h":!0}),g(ge)!=="svelte-wbjqtu"&&(ge.innerHTML=yn),jt=l(e),ye=u(e,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-cj7nlj"&&(ye.textContent=Mn),It=l(e),r(Me.$$.fragment,e),Bt=l(e),r(be.$$.fragment,e),vt=l(e),we=u(e,"P",{"data-svelte-h":!0}),g(we)!=="svelte-1pvw0yz"&&(we.innerHTML=bn),Gt=l(e),r(_e.$$.fragment,e),Wt=l(e),r(Te.$$.fragment,e),kt=l(e),r(Je.$$.fragment,e),$t=l(e),r(Ue.$$.fragment,e),xt=l(e),r(Ze.$$.fragment,e),St=l(e),r(je.$$.fragment,e),Ct=l(e),r(W.$$.fragment,e),Rt=l(e),r(Ie.$$.fragment,e),Yt=l(e),r(Be.$$.fragment,e),Xt=l(e),r(ve.$$.fragment,e),Vt=l(e),r(Ge.$$.fragment,e),zt=l(e),U=u(e,"DIV",{class:!0});var I=Xe(U);r(We.$$.fragment,I),Ft=l(I),j=u(I,"DIV",{class:!0});var B=Xe(j);r(ke.$$.fragment,B),Ht=l(B),Se=u(B,"P",{"data-svelte-h":!0}),g(Se)!=="svelte-v78lg8"&&(Se.textContent=wn),Lt=l(B),r(k.$$.fragment,B),B.forEach(n),Pt=l(I),Ce=u(I,"DIV",{class:!0});var Ye=Xe(Ce);r($e.$$.fragment,Ye),Ye.forEach(n),I.forEach(n),Nt=l(e),r(xe.$$.fragment,e),Dt=l(e),Re=u(e,"P",{}),Xe(Re).forEach(n),this.h()},h(){Ve(o,"name","hf:doc:metadata"),Ve(o,"content",xn),Ve(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ve(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ve(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){$(document.head,o),i(e,w,t),i(e,h,t),i(e,M,t),p(T,e,t),i(e,y,t),i(e,J,t),i(e,ze,t),i(e,x,t),i(e,Ne,t),i(e,S,t),i(e,De,t),p(C,e,t),i(e,Qe,t),i(e,R,t),i(e,Ee,t),i(e,Y,t),i(e,Fe,t),p(X,e,t),i(e,He,t),p(v,e,t),i(e,Le,t),p(V,e,t),i(e,Pe,t),i(e,z,t),i(e,qe,t),i(e,N,t),i(e,Ae,t),p(D,e,t),i(e,Oe,t),i(e,Q,t),i(e,Ke,t),p(E,e,t),i(e,et,t),i(e,F,t),i(e,tt,t),p(H,e,t),i(e,nt,t),p(L,e,t),i(e,it,t),i(e,P,t),i(e,st,t),p(q,e,t),i(e,lt,t),p(A,e,t),i(e,ot,t),i(e,O,t),i(e,at,t),i(e,K,t),i(e,rt,t),p(ee,e,t),i(e,pt,t),i(e,te,t),i(e,dt,t),p(ne,e,t),i(e,ct,t),i(e,ie,t),i(e,mt,t),p(se,e,t),i(e,ft,t),p(le,e,t),i(e,ut,t),i(e,oe,t),i(e,ht,t),p(ae,e,t),i(e,gt,t),i(e,re,t),i(e,yt,t),p(pe,e,t),i(e,Mt,t),i(e,de,t),i(e,bt,t),p(ce,e,t),i(e,wt,t),p(me,e,t),i(e,_t,t),i(e,fe,t),i(e,Tt,t),p(G,e,t),i(e,Jt,t),p(ue,e,t),i(e,Ut,t),p(he,e,t),i(e,Zt,t),i(e,ge,t),i(e,jt,t),i(e,ye,t),i(e,It,t),p(Me,e,t),i(e,Bt,t),p(be,e,t),i(e,vt,t),i(e,we,t),i(e,Gt,t),p(_e,e,t),i(e,Wt,t),p(Te,e,t),i(e,kt,t),p(Je,e,t),i(e,$t,t),p(Ue,e,t),i(e,xt,t),p(Ze,e,t),i(e,St,t),p(je,e,t),i(e,Ct,t),p(W,e,t),i(e,Rt,t),p(Ie,e,t),i(e,Yt,t),p(Be,e,t),i(e,Xt,t),p(ve,e,t),i(e,Vt,t),p(Ge,e,t),i(e,zt,t),i(e,U,t),p(We,U,null),$(U,Ft),$(U,j),p(ke,j,null),$(j,Ht),$(j,Se),$(j,Lt),p(k,j,null),$(U,Pt),$(U,Ce),p($e,Ce,null),i(e,Nt,t),p(xe,e,t),i(e,Dt,t),i(e,Re,t),Qt=!0},p(e,[t]){const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),v.$set(I);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),G.$set(B);const Ye={};t&2&&(Ye.$$scope={dirty:t,ctx:e}),W.$set(Ye);const _n={};t&2&&(_n.$$scope={dirty:t,ctx:e}),k.$set(_n)},i(e){Qt||(d(T.$$.fragment,e),d(C.$$.fragment,e),d(X.$$.fragment,e),d(v.$$.fragment,e),d(V.$$.fragment,e),d(D.$$.fragment,e),d(E.$$.fragment,e),d(H.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(A.$$.fragment,e),d(ee.$$.fragment,e),d(ne.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(G.$$.fragment,e),d(ue.$$.fragment,e),d(he.$$.fragment,e),d(Me.$$.fragment,e),d(be.$$.fragment,e),d(_e.$$.fragment,e),d(Te.$$.fragment,e),d(Je.$$.fragment,e),d(Ue.$$.fragment,e),d(Ze.$$.fragment,e),d(je.$$.fragment,e),d(W.$$.fragment,e),d(Ie.$$.fragment,e),d(Be.$$.fragment,e),d(ve.$$.fragment,e),d(Ge.$$.fragment,e),d(We.$$.fragment,e),d(ke.$$.fragment,e),d(k.$$.fragment,e),d($e.$$.fragment,e),d(xe.$$.fragment,e),Qt=!0)},o(e){c(T.$$.fragment,e),c(C.$$.fragment,e),c(X.$$.fragment,e),c(v.$$.fragment,e),c(V.$$.fragment,e),c(D.$$.fragment,e),c(E.$$.fragment,e),c(H.$$.fragment,e),c(L.$$.fragment,e),c(q.$$.fragment,e),c(A.$$.fragment,e),c(ee.$$.fragment,e),c(ne.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),c(me.$$.fragment,e),c(G.$$.fragment,e),c(ue.$$.fragment,e),c(he.$$.fragment,e),c(Me.$$.fragment,e),c(be.$$.fragment,e),c(_e.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),c(Ue.$$.fragment,e),c(Ze.$$.fragment,e),c(je.$$.fragment,e),c(W.$$.fragment,e),c(Ie.$$.fragment,e),c(Be.$$.fragment,e),c(ve.$$.fragment,e),c(Ge.$$.fragment,e),c(We.$$.fragment,e),c(ke.$$.fragment,e),c(k.$$.fragment,e),c($e.$$.fragment,e),c(xe.$$.fragment,e),Qt=!1},d(e){e&&(n(w),n(h),n(M),n(y),n(J),n(ze),n(x),n(Ne),n(S),n(De),n(Qe),n(R),n(Ee),n(Y),n(Fe),n(He),n(Le),n(Pe),n(z),n(qe),n(N),n(Ae),n(Oe),n(Q),n(Ke),n(et),n(F),n(tt),n(nt),n(it),n(P),n(st),n(lt),n(ot),n(O),n(at),n(K),n(rt),n(pt),n(te),n(dt),n(ct),n(ie),n(mt),n(ft),n(ut),n(oe),n(ht),n(gt),n(re),n(yt),n(Mt),n(de),n(bt),n(wt),n(_t),n(fe),n(Tt),n(Jt),n(Ut),n(Zt),n(ge),n(jt),n(ye),n(It),n(Bt),n(vt),n(we),n(Gt),n(Wt),n(kt),n($t),n(xt),n(St),n(Ct),n(Rt),n(Yt),n(Xt),n(Vt),n(zt),n(U),n(Nt),n(Dt),n(Re)),n(o),m(T,e),m(C,e),m(X,e),m(v,e),m(V,e),m(D,e),m(E,e),m(H,e),m(L,e),m(q,e),m(A,e),m(ee,e),m(ne,e),m(se,e),m(le,e),m(ae,e),m(pe,e),m(ce,e),m(me,e),m(G,e),m(ue,e),m(he,e),m(Me,e),m(be,e),m(_e,e),m(Te,e),m(Je,e),m(Ue,e),m(Ze,e),m(je,e),m(W,e),m(Ie,e),m(Be,e),m(ve,e),m(Ge,e),m(We),m(ke),m(k),m($e),m(xe,e)}}}const xn='{"title":"Stable Diffusion 3","local":"stable-diffusion-3","sections":[{"title":"Usage Example","local":"usage-example","sections":[],"depth":2},{"title":"Memory Optimisations for SD3","local":"memory-optimisations-for-sd3","sections":[{"title":"Running Inference with Model Offloading","local":"running-inference-with-model-offloading","sections":[],"depth":3},{"title":"Dropping the T5 Text Encoder during Inference","local":"dropping-the-t5-text-encoder-during-inference","sections":[],"depth":3},{"title":"Using a Quantized Version of the T5 Text Encoder","local":"using-a-quantized-version-of-the-t5-text-encoder","sections":[],"depth":3}],"depth":2},{"title":"Performance Optimizations for SD3","local":"performance-optimizations-for-sd3","sections":[{"title":"Using Torch Compile to Speed Up Inference","local":"using-torch-compile-to-speed-up-inference","sections":[],"depth":3}],"depth":2},{"title":"Using Long Prompts with the T5 Text Encoder","local":"using-long-prompts-with-the-t5-text-encoder","sections":[{"title":"Sending a different prompt to the T5 Text Encoder","local":"sending-a-different-prompt-to-the-t5-text-encoder","sections":[],"depth":3}],"depth":2},{"title":"Tiny AutoEncoder for Stable Diffusion 3","local":"tiny-autoencoder-for-stable-diffusion-3","sections":[],"depth":2},{"title":"Loading the original checkpoints via from_single_file","local":"loading-the-original-checkpoints-via-fromsinglefile","sections":[],"depth":2},{"title":"Loading the original checkpoints for the SD3Transformer2DModel","local":"loading-the-original-checkpoints-for-the-sd3transformer2dmodel","sections":[],"depth":2},{"title":"Loading the single checkpoint for the StableDiffusion3Pipeline","local":"loading-the-single-checkpoint-for-the-stablediffusion3pipeline","sections":[{"title":"Loading the single file checkpoint without T5","local":"loading-the-single-file-checkpoint-without-t5","sections":[],"depth":3},{"title":"Loading the single file checkpoint with T5","local":"loading-the-single-file-checkpoint-with-t5","sections":[],"depth":3},{"title":"Loading the single file checkpoint for the Stable Diffusion 3.5 Transformer Model","local":"loading-the-single-file-checkpoint-for-the-stable-diffusion-35-transformer-model","sections":[],"depth":3}],"depth":2},{"title":"StableDiffusion3Pipeline","local":"diffusers.StableDiffusion3Pipeline","sections":[],"depth":2}],"depth":1}';function Sn(Z){return Jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dn extends Un{constructor(o){super(),Zn(this,o,Sn,$n,Tn,{})}}export{Dn as component};
