import{s as Hs,o as $s,n as ts}from"../chunks/scheduler.25b97de1.js";import{S as Es,i as qs,g as o,s as l,r,A as Ss,h as i,f as s,c as n,j as Ot,u as h,x as c,k as Fs,y as J,a,v as d,d as m,t as u,w as M}from"../chunks/index.d9030fc9.js";import{T as es}from"../chunks/Tip.baa67368.js";import{C as T}from"../chunks/CodeBlock.e6cd0d95.js";import{H as w,E as As}from"../chunks/EditOnGithub.91d95064.js";function Ls(U){let p,b="One important concept you need to know when writing your own generation loop, is <code>cache_position</code>. In case you want to reuse an already filled Cache object by calling <code>forward()</code>, you have to pass in a valid <code>cache_position</code> which will indicate the positions of inputs in the sequence. Note that <code>cache_position</code> is not affected by padding, and always adds one more position for each token. For example, if key/value cache contains 10 tokens (no matter how many of it is a pad token), the cache position for the next token should be <code>torch.tensor([10])</code>.";return{c(){p=o("p"),p.innerHTML=b},l(y){p=i(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-fyl20k"&&(p.innerHTML=b)},m(y,f){a(y,p,f)},p:ts,d(y){y&&s(p)}}}function Ds(U){let p,b="Cache quantization can be detrimental in terms of latency if the context length is short and there is enough GPU VRAM available to run without cache quantization. It is recommended to seek balance between memory efficiency and latency.";return{c(){p=o("p"),p.textContent=b},l(y){p=i(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-46etli"&&(p.textContent=b)},m(y,f){a(y,p,f)},p:ts,d(y){y&&s(p)}}}function Ks(U){let p,b="Cache offloading requires a GPU and can be slower than dynamic KV cache. Use it if you are getting CUDA out of memory errors.";return{c(){p=o("p"),p.textContent=b},l(y){p=i(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-16njdjl"&&(p.textContent=b)},m(y,f){a(y,p,f)},p:ts,d(y){y&&s(p)}}}function Ps(U){let p,b,y,f,W,Qe,Z,ss=`Efficient caching is crucial for optimizing the performance of models in various generative tasks,
including text generation, translation, summarization and other transformer-based applications.
Effective caching helps reduce computation time and improve response rates, especially in real-time or resource-intensive applications.`,ze,v,as=`Transformers support various caching methods, leveraging “Cache” classes to abstract and manage the caching logic.
This document outlines best practices for using these classes to maximize performance and efficiency.
Check out all the available <code>Cache</code> classes in the <a href="./internal/generation_utils">API documentation</a>.`,Ye,G,Fe,_,ls="Imagine you’re having a conversation with someone, and instead of remembering what was said previously, you have to start from scratch every time you respond. This would be slow and inefficient, right? In the world of Transformer models, a similar concept applies, and that’s where Caching keys and values come into play. From now on, I’ll refer to the concept as KV Cache.",He,B,ns="KV cache is needed to optimize the generation in autoregressive models, where the model predicts text token by token. This process can be slow since the model can generate only one token at a time, and each new prediction is dependent on the previous context. That means, to predict token number 1000 in the generation, you need information from the previous 999 tokens, which comes in the form of some matrix multiplications across the representations of those tokens. But to predict token number 1001, you also need the same information from the first 999 tokens, plus additional information from token number 1000. That is where key-value cache is used to optimize the sequential generation process by storing previous calculations to reuse in subsequent tokens, so they don’t need to be computed again.",$e,X,os="More concretely, key-value cache acts as a memory bank for these generative models, where the model stores key-value pairs derived from self-attention layers for previously processed tokens. By storing this information, the model can avoid redundant computations and instead retrieve keys and values of previous tokens from the cache. Note that caching can be used only in inference and should be disabled when training, otherwise it might cause unexpected errors.",Ee,g,Be,is="<em>For the Curious Minds Who Like to Dive Deep</em>",qt,R,St,Xe,cs="When utilizing a cache object in the input, the Attention module performs several critical steps to integrate past and present information seamlessly.",At,Re,ps="The Attention module concatenates the current key-values with the past key-values stored in the cache. This results in attention weights of shape <code>(new_tokens_length, past_kv_length + new_tokens_length)</code>. Essentially, the past and current key-values are combined to compute attention scores, ensuring that the model considers both previous context and new input. The concatenated key-values are used to compute the attention scores resulting in attention weights of shape <code>(new_tokens_length, past_kv_length + new_tokens_length)</code>.",Lt,Ne,rs="Therefore, when iteratively calling <code>forward()</code> instead of the <code>generate()</code> method, it’s crucial to ensure that the attention mask shape matches the combined length of past and current key-values. The attention mask should have the shape <code>(batch_size, past_kv_length + new_tokens_length)</code>. This is usually handled internally when you call <code>generate()</code> method. If you want to implement your own generation loop with Cache classes, take this into consideration and prepare the attention mask to hold values to current and past tokens.",Dt,k,Kt,Ve,hs="See an example below for how to implement your own generation loop.",Pt,N,qe,V,Se,x,ds=`In 🤗 Transformers, we support various Cache types to optimize the performance across different models and tasks. By default, all models generate with caching,
with the <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.DynamicCache">~DynamicCache</a> class being the default cache for most models. It allows us to dynamically grow cache size, by saving more and more keys and values as we generate. If for some reason you don’t want to use caches, you can pass <code>use_cache=False</code> into the <code>generate()</code> method.`,Ae,Q,ms="Refer to the table below to see the difference between cache types and choose the one that suits best for your use-case. Models for which initialization is recommended should be initialized before calling the model and passed to model as a kwarg. In all other cases you can simply define desired <code>cache_implementation</code> and we take care of the rest for you.",Le,z,us="<thead><tr><th>Cache Type</th> <th>Memory Efficient</th> <th>Supports torch.compile()</th> <th>Initialization Recommended</th> <th>Latency</th> <th>Long Context Generation</th></tr></thead> <tbody><tr><td>Dynamic Cache</td> <td>No</td> <td>No</td> <td>No</td> <td>Mid</td> <td>No</td></tr> <tr><td>Static Cache</td> <td>No</td> <td>Yes</td> <td>Yes</td> <td>High</td> <td>No</td></tr> <tr><td>Offloaded Cache</td> <td>Yes</td> <td>No</td> <td>No</td> <td>Low</td> <td>Yes</td></tr> <tr><td>Offloaded Static Cache</td> <td>No</td> <td>Yes</td> <td>Yes</td> <td>High</td> <td>Yes</td></tr> <tr><td>Quantized Cache</td> <td>Yes</td> <td>No</td> <td>No</td> <td>Low</td> <td>Yes</td></tr> <tr><td>Sliding Window Cache</td> <td>No</td> <td>Yes</td> <td>Yes</td> <td>High</td> <td>No</td></tr> <tr><td>Sink Cache</td> <td>Yes</td> <td>No</td> <td>Yes</td> <td>Mid</td> <td>Yes</td></tr></tbody>",De,Y,Ms='These cache classes can be set with a <code>cache_implementation</code> argument when generating. To learn about the available options for the cache_implementation flag, please refer to the <a href="./main_classes/text_generation#transformers.GenerationConfig">API Documentation</a>. Now, let’s explore each cache type in detail and see how to use them. Note that the below examples are for decoder-only Tranformer-based models. We also support [“Model-Specific Cache”] classes for models such as Mamba or Jamba, keep reading for more details.',Ke,F,Pe,H,ys=`The key and value cache can occupy a large portion of memory, becoming a <a href="https://huggingface.co/blog/llama31#inference-memory-requirements" rel="nofollow">bottleneck for long-context generation</a>, especially for Large Language Models.
Quantizing the cache when using <code>generate()</code> can significantly reduce memory requirements at the cost of speed.`,Oe,$,gs='KV Cache quantization in <code>transformers</code> is largely inspired by the paper <a href="https://arxiv.org/abs/2402.02750" rel="nofollow">“KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache”</a> and currently supports <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.QuantoQuantizedCache">~QuantoQuantizedCache</a> and <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.HQQQuantizedCache">~HQQQuantizedCache</a> classes. For more information on the inner workings see the paper.',et,E,js=`To enable quantization of the key-value cache, one needs to indicate <code>cache_implementation=&quot;quantized&quot;</code> in the <code>generation_config</code>.
Quantization related arguments should be passed to the <code>generation_config</code> either as a <code>dict</code> or an instance of a <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.QuantizedCacheConfig">~QuantizedCacheConfig</a> class.
One has to indicate which quantization backend to use in the <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.QuantizedCacheConfig">~QuantizedCacheConfig</a>, the default is <code>quanto</code>.`,tt,q,ws="It is recommended to set <code>axis-key/axis-value</code> parameters in the cache config to <code>0</code> if you’re using the <code>quanto</code> backend and to <code>1</code> if you’re using the <code>HQQ</code> backend. For other config values, please use the defaults unless you’re running out of memory. In that case, you may consider decreasing the residual length.",st,C,at,S,lt,A,nt,L,bs=`Similarly to KV cache quantization, <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.OffloadedCache">~OffloadedCache</a> strategy aims to reduce GPU VRAM usage.
It does so by moving the KV cache for most layers to the CPU.
As the model’s <code>forward()</code> method iterates over the layers, this strategy maintains the current layer cache on the GPU.
At the same time it asynchronously prefetches the next layer cache as well as sending the previous layer cache back to the CPU.
Unlike KV cache quantization, this strategy always produces the same result as the default KV cache implementation.
Thus, it can serve as a drop-in replacement or a fallback for it.`,ot,D,Js=`Depending on your model and the characteristics of your generation task (size of context, number of generated tokens, number of beams, etc.)
you may notice a small degradation in generation throughput compared to the default KV cache implementation.`,it,K,Ts=`To enable KV cache offloading, pass <code>cache_implementation=&quot;offloaded&quot;</code> in the <code>generation_config</code> or directly to the <code>generate()</code> call.
Use <code>cache_implementation=&quot;offloaded_static&quot;</code> for an offloaded static cache (see also <a href="#offloaded-static-cache">Offloaded Static Cache</a> below).`,ct,P,pt,I,rt,O,fs="The example below shows how KV cache offloading can be used as a fallback strategy.",ht,ee,dt,te,Us="On a GPU with 50 GB of RAM, running this code will print",mt,se,ut,ae,ks="before successfully generating 40 beams.",Mt,le,yt,ne,Cs=`Since the “DynamicCache” dynamically grows with each generation step, it prevents you from taking advantage of JIT optimizations. The <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.StaticCache">~StaticCache</a> pre-allocates
a specific maximum size for the keys and values, allowing you to generate up to the maximum length without having to modify cache size. Check the below usage example.`,gt,oe,Is='For more examples with Static Cache and JIT compilation, take a look at <a href="./llm_optims#static-kv-cache-and-torchcompile">StaticCache &amp; torchcompile</a>',jt,ie,wt,ce,bt,pe,Ws=`Like <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.OffloadedCache">~OffloadedCache</a> exists for offloading a “DynamicCache”, there is also an offloaded static cache. It fully supports
JIT optimizations. Just pass <code>cache_implementation=&quot;offloaded_static&quot;</code> in the <code>generation_config</code> or directly to the <code>generate()</code> call.
This will use the <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.OffloadedStaticCache">~OffloadedStaticCache</a> implementation instead.`,Jt,re,Tt,he,ft,de,Zs="As the name suggests, this cache type implements a sliding window over previous keys and values, retaining only the last <code>sliding_window</code> tokens. It should be used with models like Mistral that support sliding window attention. Additionally, similar to Static Cache, this one is JIT-friendly and can be used with the same compile tecniques as Static Cache.",Ut,me,vs="Note that you can use this cache only for models that support sliding window, e.g. Mistral models.",kt,ue,Ct,Me,It,ye,Gs='Sink Cache was introduced in <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">“Efficient Streaming Language Models with Attention Sinks”</a>. It allows you to generate long sequences of text (“infinite length” according to the paper) without any fine-tuning. That is achieved by smart handling of previous keys and values, specifically it retains a few initial tokens from the sequence, called “sink tokens”. This is based on the observation that these initial tokens attract a significant portion of attention scores during the generation process. Tokens that come after “sink tokens” are discarded on a sliding windowed basis, keeping only the latest <code>window_size</code> tokens. By keeping these initial tokens as “attention sinks,” the model maintains stable performance even when dealing with very long texts, thus discarding most of the previous knowledge.',Wt,ge,_s="Unlike other cache classes, this one can’t be used directly by indicating a <code>cache_implementation</code>. You have to initialize the Cache before calling on <code>generate()</code> as follows.",Zt,je,vt,we,Gt,be,Bs='The <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.EncoderDecoderCache">~EncoderDecoderCache</a> is a wrapper designed to handle the caching needs of encoder-decoder models. This cache type is specifically built to manage both self-attention and cross-attention caches, ensuring storage and retrieval of past key/values required for these complex models. Cool thing about Encoder-Decoder Cache is that you can set different cache types for the encoder and for the decoder, depending on your use case. Currently this cache is only supported in <a href="./model_doc/whisper">Whisper</a> models but we will be adding more models soon.',_t,Je,Xs="In terms of usage, there is nothing special to be done and calling <code>generate()</code> or <code>forward()</code> will handle everything for you.",Bt,Te,Xt,fe,Rs='Some models require storing previous keys, values, or states in a specific way, and the above cache classes cannot be used. For such cases, we have several specialized cache classes that are designed for specific models. These models only accept their own dedicated cache classes and do not support using any other cache types. Some examples include <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.HybridCache">~HybridCache</a> for <a href="./model_doc/gemma2">Gemma2</a> series models or <a href="/docs/transformers/pr_28250/en/internal/generation_utils#transformers.MambaCache">~MambaCache</a> for <a href="./model_doc/mamba">Mamba</a> architecture models.',Rt,Ue,Nt,ke,Ns="We have seen how to use each of the cache types when generating. What if you want to use cache in iterative generation setting, for example in applications like chatbots, where interactions involve multiple turns and continuous back-and-forth exchanges. Iterative generation with cache allows these systems to handle ongoing conversations effectively without reprocessing the entire context at each step. But there are some tips that you should know before you start implementing:",Vt,Ce,Vs='The general format when doing iterative generation is as below. First you have to initialize an empty cache of the type you want, and you can start feeding in new prompts iteratively. Keeping track of dialogues history and formatting can be done with chat templates, read more on that in <a href="./chat_templating">chat_templating</a>',xt,Ie,xs="In case you are using Sink Cache, you have to crop your inputs to that maximum length because Sink Cache can generate text longer than its maximum window size, but it expects the first input to not exceed the maximum cache length.",Qt,We,zt,Ze,Yt,ve,Qs="Sometimes you would want to first fill-in cache object with key/values for certain prefix prompt and re-use it several times to generate different sequences from it. In that case you can construct a <code>Cache</code> object that will hold the instruction prompt, and re-use it several times with different text sequences.",Ft,Ge,Ht,_e,$t,xe,Et;return W=new w({props:{title:"Best Practices for Generation with Cache",local:"best-practices-for-generation-with-cache",headingTag:"h1"}}),G=new w({props:{title:"What is Cache and why we should care?",local:"what-is-cache-and-why-we-should-care",headingTag:"h2"}}),R=new w({props:{title:"Under the Hood: How Cache Object Works in Attention Mechanism",local:"under-the-hood-how-cache-object-works-in-attention-mechanism",headingTag:"h3"}}),k=new es({props:{warning:!0,$$slots:{default:[Ls]},$$scope:{ctx:U}}}),N=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, what&#x27;s your name.&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = inputs.input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_position = torch.arange(inputs.input_ids.shape[<span class="hljs-number">1</span>], dtype=torch.int64, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>max_new_tokens = <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_new_tokens):
<span class="hljs-meta">... </span>    outputs = model(**inputs, cache_position=cache_position, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Greedily sample one next token</span>
<span class="hljs-meta">... </span>    next_token_ids = outputs.logits[:, -<span class="hljs-number">1</span>:].argmax(-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    generated_ids = torch.cat([generated_ids, next_token_ids], dim=-<span class="hljs-number">1</span>)
...
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare inputs for the next generation step by leaaving unprocessed tokens, in our case we have only one new token</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># and expanding attn mask for the new token, as explained above</span>
<span class="hljs-meta">... </span>    attention_mask = inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>]
<span class="hljs-meta">... </span>    attention_mask = torch.cat([attention_mask, attention_mask.new_ones((attention_mask.shape[<span class="hljs-number">0</span>], <span class="hljs-number">1</span>))], dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    inputs = {<span class="hljs-string">&quot;input_ids&quot;</span>: next_token_ids, <span class="hljs-string">&quot;attention_mask&quot;</span>: attention_mask}
<span class="hljs-meta">... </span>    cache_position = cache_position[-<span class="hljs-number">1</span>:] + <span class="hljs-number">1</span> <span class="hljs-comment"># add one more position for the next token</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;[INST] Hello, what&#x27;s your name. [/INST]  Hello! My name is LLaMA,&quot;</span>`,wrap:!1}}),V=new w({props:{title:"Generate with Cache",local:"generate-with-cache",headingTag:"h2"}}),F=new w({props:{title:"Quantized Cache",local:"quantized-cache",headingTag:"h3"}}),C=new es({props:{warning:!0,$$slots:{default:[Ds]},$$scope:{ctx:U}}}),S=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTNBMCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySSUyMGxpa2UlMjByb2NrJTIwbXVzaWMlMjBiZWNhdXNlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJxdWFudGl6ZWQlMjIlMkMlMjBjYWNoZV9jb25maWclM0QlN0IlMjJuYml0cyUyMiUzQSUyMDQlMkMlMjAlMjJiYWNrZW5kJTIyJTNBJTIwJTIycXVhbnRvJTIyJTdEKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I like rock music because&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;quantized&quot;</span>, cache_config={<span class="hljs-string">&quot;nbits&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;backend&quot;</span>: <span class="hljs-string">&quot;quanto&quot;</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I like rock music because it<span class="hljs-string">&#x27;s loud and energetic. It&#x27;</span>s a great way to express myself <span class="hljs-keyword">and</span> rel

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I like rock music because it<span class="hljs-string">&#x27;s loud and energetic. I like to listen to it when I&#x27;</span>m feeling`,wrap:!1}}),A=new w({props:{title:"Offloaded Cache",local:"offloaded-cache",headingTag:"h3"}}),P=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBY2twdCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktNGstaW5zdHJ1Y3QlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChja3B0KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNrcHQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElM0EwJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJGdW4lMjBmYWN0JTNBJTIwVGhlJTIwc2hvcnRlc3QlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjMlMkMlMjBjYWNoZV9pbXBsZW1lbnRhdGlvbiUzRCUyMm9mZmxvYWRlZCUyMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Fun fact: The shortest&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">23</span>, cache_implementation=<span class="hljs-string">&quot;offloaded&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Fun fact: The shortest war <span class="hljs-keyword">in</span> history was between Britain <span class="hljs-keyword">and</span> Zanzibar on August <span class="hljs-number">27</span>, <span class="hljs-number">1896.</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">23</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Fun fact: The shortest war <span class="hljs-keyword">in</span> history was between Britain <span class="hljs-keyword">and</span> Zanzibar on August <span class="hljs-number">27</span>, <span class="hljs-number">1896.</span>`,wrap:!1}}),I=new es({props:{warning:!0,$$slots:{default:[Ks]},$$scope:{ctx:U}}}),ee=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">resilient_generate</span>(<span class="hljs-params">model, *args, **kwargs</span>):
<span class="hljs-meta">... </span>    oom = <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> model.generate(*args, **kwargs)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span> torch.cuda.OutOfMemoryError <span class="hljs-keyword">as</span> e:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(e)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;retrying with cache_implementation=&#x27;offloaded&#x27;&quot;</span>)
<span class="hljs-meta">... </span>        oom = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> oom:
<span class="hljs-meta">... </span>        torch.cuda.empty_cache()
<span class="hljs-meta">... </span>        kwargs[<span class="hljs-string">&quot;cache_implementation&quot;</span>] = <span class="hljs-string">&quot;offloaded&quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> model.generate(*args, **kwargs)
...
...
<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;okay &quot;</span>*<span class="hljs-number">1000</span> + <span class="hljs-string">&quot;Fun fact: The most&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
<span class="hljs-meta">&gt;&gt;&gt; </span>beams = { <span class="hljs-string">&quot;num_beams&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;num_beam_groups&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;diversity_penalty&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">23</span>, <span class="hljs-string">&quot;early_stopping&quot;</span>: <span class="hljs-literal">True</span>, }
<span class="hljs-meta">&gt;&gt;&gt; </span>out = resilient_generate(model, **inputs, **beams)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses = tokenizer.batch_decode(out[:,-<span class="hljs-number">28</span>:], skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),se=new T({props:{code:"Q1VEQSUyMG91dCUyMG9mJTIwbWVtb3J5LiUyMFRyaWVkJTIwdG8lMjBhbGxvY2F0ZSUyMDQuODMlMjBHaUIuJTIwR1BVJTBBcmV0cnlpbmclMjB3aXRoJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0Qnb2ZmbG9hZGVkJw==",highlighted:`CUDA <span class="hljs-keyword">out</span> <span class="hljs-keyword">of</span> memory. Tried <span class="hljs-keyword">to</span> allocate <span class="hljs-number">4.83</span> GiB. GPU
retrying <span class="hljs-keyword">with</span> cache_implementation=<span class="hljs-string">&#x27;offloaded&#x27;</span>`,wrap:!1}}),le=new w({props:{title:"Static Cache",local:"static-cache",headingTag:"h3"}}),ie=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBuYW1lJTIwaXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwc2ltcGx5JTIwcGFzcyUyMHRoZSUyMGNhY2hlJTIwaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIlMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># simply pass the cache implementation=&quot;static&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hello, my name is [Your Name], and I am a [Your Profession] with [Number of Years] of&quot;</span>`,wrap:!1}}),ce=new w({props:{title:"Offloaded Static Cache",local:"offloaded-static-cache",headingTag:"h2"}}),re=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBuYW1lJTIwaXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwc2ltcGx5JTIwcGFzcyUyMHRoZSUyMGNhY2hlJTIwaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIlMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyb2ZmbG9hZGVkX3N0YXRpYyUyMiklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># simply pass the cache implementation=&quot;static&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;offloaded_static&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hello, my name is [Your Name], and I am a [Your Profession] with [Number of Years] of&quot;</span>`,wrap:!1}}),he=new w({props:{title:"Sliding Window Cache",local:"sliding-window-cache",headingTag:"h3"}}),ue=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwU2lua0NhY2hlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUzQTAlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlllc3RlcmRheSUyMEklMjB3YXMlMjBvbiUyMGElMjByb2NrJTIwY29uY2VydCUyMGFuZC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwY2FuJTIwYmUlMjB1c2VkJTIwYnklMjBwYXNzaW5nJTIwaW4lMjBjYWNoZSUyMGltcGxlbWVudGF0aW9uJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMzAlMkMlMjBjYWNoZV9pbXBsZW1lbnRhdGlvbiUzRCUyMnNsaWRpbmdfd2luZG93JTIyKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Yesterday I was on a rock concert and.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># can be used by passing in cache implementation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">30</span>, cache_implementation=<span class="hljs-string">&quot;sliding_window&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Yesterday I was on a rock concert and. I was so excited to see my favorite band. I was so excited that I was jumping up and down and screaming. I was so excited that I&quot;</span>`,wrap:!1}}),Me=new w({props:{title:"Sink Cache",local:"sink-cache",headingTag:"h3"}}),je=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwU2lua0NhY2hlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTNBMCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhpcyUyMGlzJTIwYSUyMGxvbmclMjBzdG9yeSUyMGFib3V0JTIwdW5pY29ybnMlMkMlMjBmYWlyaWVzJTIwYW5kJTIwbWFnaWMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQSUyMyUyMGdldCUyMG91ciUyMGNhY2hlJTJDJTIwc3BlY2lmeSUyMG51bWJlciUyMG9mJTIwc2luayUyMHRva2VucyUyMGFuZCUyMHdpbmRvdyUyMHNpemUlMEElMjMlMjBOb3RlJTIwdGhhdCUyMHdpbmRvdyUyMHNpemUlMjBhbHJlYWR5JTIwaW5jbHVkZXMlMjBzaW5rJTIwdG9rZW5zJTJDJTIwc28lMjBoYXMlMjB0byUyMGJlJTIwbGFyZ2VyJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwU2lua0NhY2hlKHdpbmRvd19sZW5ndGglM0QyNTYlMkMlMjBudW1fc2lua190b2tlbnMlM0Q0KSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;This is a long story about unicorns, fairies and magic.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get our cache, specify number of sink tokens and window size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that window size already includes sink tokens, so has to be larger</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SinkCache(window_length=<span class="hljs-number">256</span>, num_sink_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">30</span>, past_key_values=past_key_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;This is a long story about unicorns, fairies and magic. It is a fantasy world where unicorns and fairies live together in harmony. The story follows a young girl named Lily&quot;</span>`,wrap:!1}}),we=new w({props:{title:"Encoder-Decoder Cache",local:"encoder-decoder-cache",headingTag:"h3"}}),Te=new w({props:{title:"Model-specific Cache Classes",local:"model-specific-cache-classes",headingTag:"h3"}}),Ue=new w({props:{title:"Iterative Generation with Cache",local:"iterative-generation-with-cache",headingTag:"h2"}}),We=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer,AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.cache_utils <span class="hljs-keyword">import</span> (
<span class="hljs-meta">&gt;&gt;&gt; </span>    DynamicCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    SinkCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    StaticCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    SlidingWindowCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    QuantoQuantizedCache,
<span class="hljs-meta">&gt;&gt;&gt; </span>    QuantizedCacheConfig,
<span class="hljs-meta">&gt;&gt;&gt; </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&#x27;auto&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span>user_prompts = [<span class="hljs-string">&quot;Hello, what&#x27;s your name?&quot;</span>, <span class="hljs-string">&quot;Btw, yesterday I was on a rock concert.&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>max_cache_length = past_key_values.get_max_length()

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> user_prompts:
<span class="hljs-meta">... </span>    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt})
<span class="hljs-meta">... </span>    inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>).to(model.device)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(past_key_values, SinkCache):
<span class="hljs-meta">... </span>        inputs = {k: v[:, -max_cache_length:] <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
...
<span class="hljs-meta">... </span>    input_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]
...
<span class="hljs-meta">... </span>    outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">256</span>, past_key_values=past_key_values)
<span class="hljs-meta">... </span>    completion = tokenizer.decode(outputs[<span class="hljs-number">0</span>, input_length: ], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: completion})

<span class="hljs-built_in">print</span>(messages)
[{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&quot;Hello, what&#x27;s your name?&quot;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&quot; Hello! My name is LLaMA, I&#x27;m a large language model trained by a team of researcher at Meta AI. 😊&quot;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;Btw, yesterday I was on a rock concert.&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27; Oh, cool! That sounds like a lot of fun! 🎉 Did you enjoy the concert? What was the band like? 🤔&#x27;</span>}]`,wrap:!1}}),Ze=new w({props:{title:"Re-use Cache to continue generation",local:"re-use-cache-to-continue-generation",headingTag:"h2"}}),Ge=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> copy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, DynamicCache, StaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Init StaticCache with big enough max-length (1024 tokens for the below example) </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also init a DynamicCache, if that suits you better</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_cache = StaticCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, max_cache_len=<span class="hljs-number">1024</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>INITIAL_PROMPT = <span class="hljs-string">&quot;You are a helpful assistant. &quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs_initial_prompt = tokenizer(INITIAL_PROMPT, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is the common prompt cached, we need to run forward without grad to be abel to copy</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>     prompt_cache = model(**inputs_initial_prompt, past_key_values = prompt_cache).past_key_values

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [<span class="hljs-string">&quot;Help me to write a blogpost about travelling.&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>responses = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> prompts:
<span class="hljs-meta">... </span>    new_inputs = tokenizer(INITIAL_PROMPT + prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">... </span>    past_key_values = copy.deepcopy(prompt_cache)
<span class="hljs-meta">... </span>    outputs = model.generate(**new_inputs, past_key_values=past_key_values,max_new_tokens=<span class="hljs-number">20</span>) 
<span class="hljs-meta">... </span>    response = tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    responses.append(response)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(responses)
[<span class="hljs-string">&#x27;&lt;s&gt; You are a helpful assistant. Help me to write a blogpost about travelling.\\n\\nTitle: The Ultimate Guide to Travelling: Tips, Tricks, and&#x27;</span>, <span class="hljs-string">&#x27;&lt;s&gt; You are a helpful assistant. What is the capital of France?\\n\\nYes, the capital of France is Paris.&lt;/s&gt;&#x27;</span>]`,wrap:!1}}),_e=new As({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/kv_cache.md"}}),{c(){p=o("meta"),b=l(),y=o("p"),f=l(),r(W.$$.fragment),Qe=l(),Z=o("p"),Z.textContent=ss,ze=l(),v=o("p"),v.innerHTML=as,Ye=l(),r(G.$$.fragment),Fe=l(),_=o("p"),_.textContent=ls,He=l(),B=o("p"),B.textContent=ns,$e=l(),X=o("p"),X.textContent=os,Ee=l(),g=o("details"),Be=o("summary"),Be.innerHTML=is,qt=l(),r(R.$$.fragment),St=l(),Xe=o("p"),Xe.textContent=cs,At=l(),Re=o("p"),Re.innerHTML=ps,Lt=l(),Ne=o("p"),Ne.innerHTML=rs,Dt=l(),r(k.$$.fragment),Kt=l(),Ve=o("p"),Ve.textContent=hs,Pt=l(),r(N.$$.fragment),qe=l(),r(V.$$.fragment),Se=l(),x=o("p"),x.innerHTML=ds,Ae=l(),Q=o("p"),Q.innerHTML=ms,Le=l(),z=o("table"),z.innerHTML=us,De=l(),Y=o("p"),Y.innerHTML=Ms,Ke=l(),r(F.$$.fragment),Pe=l(),H=o("p"),H.innerHTML=ys,Oe=l(),$=o("p"),$.innerHTML=gs,et=l(),E=o("p"),E.innerHTML=js,tt=l(),q=o("p"),q.innerHTML=ws,st=l(),r(C.$$.fragment),at=l(),r(S.$$.fragment),lt=l(),r(A.$$.fragment),nt=l(),L=o("p"),L.innerHTML=bs,ot=l(),D=o("p"),D.textContent=Js,it=l(),K=o("p"),K.innerHTML=Ts,ct=l(),r(P.$$.fragment),pt=l(),r(I.$$.fragment),rt=l(),O=o("p"),O.textContent=fs,ht=l(),r(ee.$$.fragment),dt=l(),te=o("p"),te.textContent=Us,mt=l(),r(se.$$.fragment),ut=l(),ae=o("p"),ae.textContent=ks,Mt=l(),r(le.$$.fragment),yt=l(),ne=o("p"),ne.innerHTML=Cs,gt=l(),oe=o("p"),oe.innerHTML=Is,jt=l(),r(ie.$$.fragment),wt=l(),r(ce.$$.fragment),bt=l(),pe=o("p"),pe.innerHTML=Ws,Jt=l(),r(re.$$.fragment),Tt=l(),r(he.$$.fragment),ft=l(),de=o("p"),de.innerHTML=Zs,Ut=l(),me=o("p"),me.textContent=vs,kt=l(),r(ue.$$.fragment),Ct=l(),r(Me.$$.fragment),It=l(),ye=o("p"),ye.innerHTML=Gs,Wt=l(),ge=o("p"),ge.innerHTML=_s,Zt=l(),r(je.$$.fragment),vt=l(),r(we.$$.fragment),Gt=l(),be=o("p"),be.innerHTML=Bs,_t=l(),Je=o("p"),Je.innerHTML=Xs,Bt=l(),r(Te.$$.fragment),Xt=l(),fe=o("p"),fe.innerHTML=Rs,Rt=l(),r(Ue.$$.fragment),Nt=l(),ke=o("p"),ke.textContent=Ns,Vt=l(),Ce=o("p"),Ce.innerHTML=Vs,xt=l(),Ie=o("p"),Ie.textContent=xs,Qt=l(),r(We.$$.fragment),zt=l(),r(Ze.$$.fragment),Yt=l(),ve=o("p"),ve.innerHTML=Qs,Ft=l(),r(Ge.$$.fragment),Ht=l(),r(_e.$$.fragment),$t=l(),xe=o("p"),this.h()},l(e){const t=Ss("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(s),b=n(e),y=i(e,"P",{}),Ot(y).forEach(s),f=n(e),h(W.$$.fragment,e),Qe=n(e),Z=i(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-ivdsz6"&&(Z.textContent=ss),ze=n(e),v=i(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1ru3n2s"&&(v.innerHTML=as),Ye=n(e),h(G.$$.fragment,e),Fe=n(e),_=i(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-pgg2dh"&&(_.textContent=ls),He=n(e),B=i(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1pcidqj"&&(B.textContent=ns),$e=n(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-19ueo1l"&&(X.textContent=os),Ee=n(e),g=i(e,"DETAILS",{});var j=Ot(g);Be=i(j,"SUMMARY",{"data-svelte-h":!0}),c(Be)!=="svelte-8dl4q2"&&(Be.innerHTML=is),qt=n(j),h(R.$$.fragment,j),St=n(j),Xe=i(j,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-1e25at2"&&(Xe.textContent=cs),At=n(j),Re=i(j,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-1l5g8w7"&&(Re.innerHTML=ps),Lt=n(j),Ne=i(j,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-8mjlg7"&&(Ne.innerHTML=rs),Dt=n(j),h(k.$$.fragment,j),Kt=n(j),Ve=i(j,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-181iwu3"&&(Ve.textContent=hs),Pt=n(j),h(N.$$.fragment,j),j.forEach(s),qe=n(e),h(V.$$.fragment,e),Se=n(e),x=i(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1n0b662"&&(x.innerHTML=ds),Ae=n(e),Q=i(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-ez9zp4"&&(Q.innerHTML=ms),Le=n(e),z=i(e,"TABLE",{"data-svelte-h":!0}),c(z)!=="svelte-yhqrld"&&(z.innerHTML=us),De=n(e),Y=i(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-b5pfm0"&&(Y.innerHTML=Ms),Ke=n(e),h(F.$$.fragment,e),Pe=n(e),H=i(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1yajrsk"&&(H.innerHTML=ys),Oe=n(e),$=i(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-ij2abd"&&($.innerHTML=gs),et=n(e),E=i(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-12tvif8"&&(E.innerHTML=js),tt=n(e),q=i(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-3ir57c"&&(q.innerHTML=ws),st=n(e),h(C.$$.fragment,e),at=n(e),h(S.$$.fragment,e),lt=n(e),h(A.$$.fragment,e),nt=n(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1h62y5d"&&(L.innerHTML=bs),ot=n(e),D=i(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1x4pr6r"&&(D.textContent=Js),it=n(e),K=i(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-6aujat"&&(K.innerHTML=Ts),ct=n(e),h(P.$$.fragment,e),pt=n(e),h(I.$$.fragment,e),rt=n(e),O=i(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-f3m4wg"&&(O.textContent=fs),ht=n(e),h(ee.$$.fragment,e),dt=n(e),te=i(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-opu10i"&&(te.textContent=Us),mt=n(e),h(se.$$.fragment,e),ut=n(e),ae=i(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-83p2wm"&&(ae.textContent=ks),Mt=n(e),h(le.$$.fragment,e),yt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-on1zj7"&&(ne.innerHTML=Cs),gt=n(e),oe=i(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-hxs9qp"&&(oe.innerHTML=Is),jt=n(e),h(ie.$$.fragment,e),wt=n(e),h(ce.$$.fragment,e),bt=n(e),pe=i(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1l2iuqx"&&(pe.innerHTML=Ws),Jt=n(e),h(re.$$.fragment,e),Tt=n(e),h(he.$$.fragment,e),ft=n(e),de=i(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-krlgtc"&&(de.innerHTML=Zs),Ut=n(e),me=i(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-14gr42g"&&(me.textContent=vs),kt=n(e),h(ue.$$.fragment,e),Ct=n(e),h(Me.$$.fragment,e),It=n(e),ye=i(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-128onc7"&&(ye.innerHTML=Gs),Wt=n(e),ge=i(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1vy8lmv"&&(ge.innerHTML=_s),Zt=n(e),h(je.$$.fragment,e),vt=n(e),h(we.$$.fragment,e),Gt=n(e),be=i(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-1m6p381"&&(be.innerHTML=Bs),_t=n(e),Je=i(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-159fa3b"&&(Je.innerHTML=Xs),Bt=n(e),h(Te.$$.fragment,e),Xt=n(e),fe=i(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-sgrsg0"&&(fe.innerHTML=Rs),Rt=n(e),h(Ue.$$.fragment,e),Nt=n(e),ke=i(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-au9ho2"&&(ke.textContent=Ns),Vt=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-108v17k"&&(Ce.innerHTML=Vs),xt=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-1yn0icb"&&(Ie.textContent=xs),Qt=n(e),h(We.$$.fragment,e),zt=n(e),h(Ze.$$.fragment,e),Yt=n(e),ve=i(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-1v9i2j4"&&(ve.innerHTML=Qs),Ft=n(e),h(Ge.$$.fragment,e),Ht=n(e),h(_e.$$.fragment,e),$t=n(e),xe=i(e,"P",{}),Ot(xe).forEach(s),this.h()},h(){Fs(p,"name","hf:doc:metadata"),Fs(p,"content",Os)},m(e,t){J(document.head,p),a(e,b,t),a(e,y,t),a(e,f,t),d(W,e,t),a(e,Qe,t),a(e,Z,t),a(e,ze,t),a(e,v,t),a(e,Ye,t),d(G,e,t),a(e,Fe,t),a(e,_,t),a(e,He,t),a(e,B,t),a(e,$e,t),a(e,X,t),a(e,Ee,t),a(e,g,t),J(g,Be),J(g,qt),d(R,g,null),J(g,St),J(g,Xe),J(g,At),J(g,Re),J(g,Lt),J(g,Ne),J(g,Dt),d(k,g,null),J(g,Kt),J(g,Ve),J(g,Pt),d(N,g,null),a(e,qe,t),d(V,e,t),a(e,Se,t),a(e,x,t),a(e,Ae,t),a(e,Q,t),a(e,Le,t),a(e,z,t),a(e,De,t),a(e,Y,t),a(e,Ke,t),d(F,e,t),a(e,Pe,t),a(e,H,t),a(e,Oe,t),a(e,$,t),a(e,et,t),a(e,E,t),a(e,tt,t),a(e,q,t),a(e,st,t),d(C,e,t),a(e,at,t),d(S,e,t),a(e,lt,t),d(A,e,t),a(e,nt,t),a(e,L,t),a(e,ot,t),a(e,D,t),a(e,it,t),a(e,K,t),a(e,ct,t),d(P,e,t),a(e,pt,t),d(I,e,t),a(e,rt,t),a(e,O,t),a(e,ht,t),d(ee,e,t),a(e,dt,t),a(e,te,t),a(e,mt,t),d(se,e,t),a(e,ut,t),a(e,ae,t),a(e,Mt,t),d(le,e,t),a(e,yt,t),a(e,ne,t),a(e,gt,t),a(e,oe,t),a(e,jt,t),d(ie,e,t),a(e,wt,t),d(ce,e,t),a(e,bt,t),a(e,pe,t),a(e,Jt,t),d(re,e,t),a(e,Tt,t),d(he,e,t),a(e,ft,t),a(e,de,t),a(e,Ut,t),a(e,me,t),a(e,kt,t),d(ue,e,t),a(e,Ct,t),d(Me,e,t),a(e,It,t),a(e,ye,t),a(e,Wt,t),a(e,ge,t),a(e,Zt,t),d(je,e,t),a(e,vt,t),d(we,e,t),a(e,Gt,t),a(e,be,t),a(e,_t,t),a(e,Je,t),a(e,Bt,t),d(Te,e,t),a(e,Xt,t),a(e,fe,t),a(e,Rt,t),d(Ue,e,t),a(e,Nt,t),a(e,ke,t),a(e,Vt,t),a(e,Ce,t),a(e,xt,t),a(e,Ie,t),a(e,Qt,t),d(We,e,t),a(e,zt,t),d(Ze,e,t),a(e,Yt,t),a(e,ve,t),a(e,Ft,t),d(Ge,e,t),a(e,Ht,t),d(_e,e,t),a(e,$t,t),a(e,xe,t),Et=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),k.$set(j);const zs={};t&2&&(zs.$$scope={dirty:t,ctx:e}),C.$set(zs);const Ys={};t&2&&(Ys.$$scope={dirty:t,ctx:e}),I.$set(Ys)},i(e){Et||(m(W.$$.fragment,e),m(G.$$.fragment,e),m(R.$$.fragment,e),m(k.$$.fragment,e),m(N.$$.fragment,e),m(V.$$.fragment,e),m(F.$$.fragment,e),m(C.$$.fragment,e),m(S.$$.fragment,e),m(A.$$.fragment,e),m(P.$$.fragment,e),m(I.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),m(re.$$.fragment,e),m(he.$$.fragment,e),m(ue.$$.fragment,e),m(Me.$$.fragment,e),m(je.$$.fragment,e),m(we.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m(We.$$.fragment,e),m(Ze.$$.fragment,e),m(Ge.$$.fragment,e),m(_e.$$.fragment,e),Et=!0)},o(e){u(W.$$.fragment,e),u(G.$$.fragment,e),u(R.$$.fragment,e),u(k.$$.fragment,e),u(N.$$.fragment,e),u(V.$$.fragment,e),u(F.$$.fragment,e),u(C.$$.fragment,e),u(S.$$.fragment,e),u(A.$$.fragment,e),u(P.$$.fragment,e),u(I.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(re.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(je.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(Ue.$$.fragment,e),u(We.$$.fragment,e),u(Ze.$$.fragment,e),u(Ge.$$.fragment,e),u(_e.$$.fragment,e),Et=!1},d(e){e&&(s(b),s(y),s(f),s(Qe),s(Z),s(ze),s(v),s(Ye),s(Fe),s(_),s(He),s(B),s($e),s(X),s(Ee),s(g),s(qe),s(Se),s(x),s(Ae),s(Q),s(Le),s(z),s(De),s(Y),s(Ke),s(Pe),s(H),s(Oe),s($),s(et),s(E),s(tt),s(q),s(st),s(at),s(lt),s(nt),s(L),s(ot),s(D),s(it),s(K),s(ct),s(pt),s(rt),s(O),s(ht),s(dt),s(te),s(mt),s(ut),s(ae),s(Mt),s(yt),s(ne),s(gt),s(oe),s(jt),s(wt),s(bt),s(pe),s(Jt),s(Tt),s(ft),s(de),s(Ut),s(me),s(kt),s(Ct),s(It),s(ye),s(Wt),s(ge),s(Zt),s(vt),s(Gt),s(be),s(_t),s(Je),s(Bt),s(Xt),s(fe),s(Rt),s(Nt),s(ke),s(Vt),s(Ce),s(xt),s(Ie),s(Qt),s(zt),s(Yt),s(ve),s(Ft),s(Ht),s($t),s(xe)),s(p),M(W,e),M(G,e),M(R),M(k),M(N),M(V,e),M(F,e),M(C,e),M(S,e),M(A,e),M(P,e),M(I,e),M(ee,e),M(se,e),M(le,e),M(ie,e),M(ce,e),M(re,e),M(he,e),M(ue,e),M(Me,e),M(je,e),M(we,e),M(Te,e),M(Ue,e),M(We,e),M(Ze,e),M(Ge,e),M(_e,e)}}}const Os='{"title":"Best Practices for Generation with Cache","local":"best-practices-for-generation-with-cache","sections":[{"title":"What is Cache and why we should care?","local":"what-is-cache-and-why-we-should-care","sections":[{"title":"Under the Hood: How Cache Object Works in Attention Mechanism","local":"under-the-hood-how-cache-object-works-in-attention-mechanism","sections":[],"depth":3}],"depth":2},{"title":"Generate with Cache","local":"generate-with-cache","sections":[{"title":"Quantized Cache","local":"quantized-cache","sections":[],"depth":3},{"title":"Offloaded Cache","local":"offloaded-cache","sections":[],"depth":3},{"title":"Static Cache","local":"static-cache","sections":[],"depth":3}],"depth":2},{"title":"Offloaded Static Cache","local":"offloaded-static-cache","sections":[{"title":"Sliding Window Cache","local":"sliding-window-cache","sections":[],"depth":3},{"title":"Sink Cache","local":"sink-cache","sections":[],"depth":3},{"title":"Encoder-Decoder Cache","local":"encoder-decoder-cache","sections":[],"depth":3},{"title":"Model-specific Cache Classes","local":"model-specific-cache-classes","sections":[],"depth":3}],"depth":2},{"title":"Iterative Generation with Cache","local":"iterative-generation-with-cache","sections":[],"depth":2},{"title":"Re-use Cache to continue generation","local":"re-use-cache-to-continue-generation","sections":[],"depth":2}],"depth":1}';function ea(U){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oa extends Es{constructor(p){super(),qs(this,p,ea,Ps,Hs,{})}}export{oa as component};
