import{s as pl,o as rl,n as j}from"../chunks/scheduler.8c3d61f6.js";import{S as ml,i as ul,g as d,s as r,r as M,A as cl,h as y,f as s,c as m,j as _t,u as w,x as b,k as Q,y as N,a as n,v as J,d as g,t as T,w as U}from"../chunks/index.589a98e8.js";import{T as Ve}from"../chunks/Tip.42aa8582.js";import{C as _}from"../chunks/CodeBlock.36627b28.js";import{D as fl}from"../chunks/DocNotebookDropdown.108e4998.js";import{H as _e,E as dl}from"../chunks/EditOnGithub.e5a8d9cb.js";import{H as Wt,a as We}from"../chunks/HfOption.9804ab8b.js";function yl(Z){let t,c='Take a look at GitHub Issue <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">#841</a> for more context about why we’re adding community pipelines to help everyone easily share their work without being slowed down.';return{c(){t=d("p"),t.innerHTML=c},l(o){t=y(o,"P",{"data-svelte-h":!0}),b(t)!=="svelte-13o4p08"&&(t.innerHTML=c)},m(o,p){n(o,t,p)},p:j,d(o){o&&s(t)}}}function hl(Z){let t,c="By loading a community pipeline from the Hugging Face Hub, you are trusting that the code you are loading is safe. Make sure to inspect the code online before loading and running it automatically!";return{c(){t=d("p"),t.textContent=c},l(o){t=y(o,"P",{"data-svelte-h":!0}),b(t)!=="svelte-1d3q3fm"&&(t.textContent=c)},m(o,p){n(o,t,p)},p:j,d(o){o&&s(t)}}}function Ml(Z){let t,c='To load a Hugging Face Hub community pipeline, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you’d like to load the pipeline weights and components from. For example, the example below loads a dummy pipeline from <a href="https://huggingface.co/hf-internal-testing/diffusers-dummy-pipeline/blob/main/pipeline.py" rel="nofollow">hf-internal-testing/diffusers-dummy-pipeline</a> and the pipeline weights and components from <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow">google/ddpm-cifar10-32</a>:',o,p,a,i,h;return p=new Ve({props:{warning:!0,$$slots:{default:[hl]},$$scope:{ctx:Z}}}),i=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1kdW1teS1waXBlbGluZSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;hf-internal-testing/diffusers-dummy-pipeline&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),{c(){t=d("p"),t.innerHTML=c,o=r(),M(p.$$.fragment),a=r(),M(i.$$.fragment)},l(f){t=y(f,"P",{"data-svelte-h":!0}),b(t)!=="svelte-he2t9o"&&(t.innerHTML=c),o=m(f),w(p.$$.fragment,f),a=m(f),w(i.$$.fragment,f)},m(f,u){n(f,t,u),n(f,o,u),J(p,f,u),n(f,a,u),J(i,f,u),h=!0},p(f,u){const $={};u&2&&($.$$scope={dirty:u,ctx:f}),p.$set($)},i(f){h||(g(p.$$.fragment,f),g(i.$$.fragment,f),h=!0)},o(f){T(p.$$.fragment,f),T(i.$$.fragment,f),h=!1},d(f){f&&(s(t),s(o),s(a)),U(p,f),U(i,f)}}}function wl(Z){let t,c='To load a GitHub community pipeline, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you you’d like to load the pipeline weights and components from. You can also load model components directly. The example below loads the community <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#clip-guided-stable-diffusion" rel="nofollow">CLIP Guided Stable Diffusion</a> pipeline and the CLIP model components.',o,p,a;return p=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){t=d("p"),t.innerHTML=c,o=r(),M(p.$$.fragment)},l(i){t=y(i,"P",{"data-svelte-h":!0}),b(t)!=="svelte-wu4rdv"&&(t.innerHTML=c),o=m(i),w(p.$$.fragment,i)},m(i,h){n(i,t,h),n(i,o,h),J(p,i,h),a=!0},p:j,i(i){a||(g(p.$$.fragment,i),a=!0)},o(i){T(p.$$.fragment,i),a=!1},d(i){i&&(s(t),s(o)),U(p,i)}}}function bl(Z){let t,c,o,p;return t=new We({props:{id:"community",option:"Hub pipelines",$$slots:{default:[Ml]},$$scope:{ctx:Z}}}),o=new We({props:{id:"community",option:"GitHub pipelines",$$slots:{default:[wl]},$$scope:{ctx:Z}}}),{c(){M(t.$$.fragment),c=r(),M(o.$$.fragment)},l(a){w(t.$$.fragment,a),c=m(a),w(o.$$.fragment,a)},m(a,i){J(t,a,i),n(a,c,i),J(o,a,i),p=!0},p(a,i){const h={};i&2&&(h.$$scope={dirty:i,ctx:a}),t.$set(h);const f={};i&2&&(f.$$scope={dirty:i,ctx:a}),o.$set(f)},i(a){p||(g(t.$$.fragment,a),g(o.$$.fragment,a),p=!0)},o(a){T(t.$$.fragment,a),T(o.$$.fragment,a),p=!1},d(a){a&&s(c),U(t,a),U(o,a)}}}function Jl(Z){let t,c="For example, to load from the main branch:",o,p,a;return p=new _({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJjbGlwX2d1aWRlZF9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JldmlzaW9uJTNEJTIybWFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    custom_revision=<span class="hljs-string">&quot;main&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){t=d("p"),t.textContent=c,o=r(),M(p.$$.fragment)},l(i){t=y(i,"P",{"data-svelte-h":!0}),b(t)!=="svelte-s49pqe"&&(t.textContent=c),o=m(i),w(p.$$.fragment,i)},m(i,h){n(i,t,h),n(i,o,h),J(p,i,h),a=!0},p:j,i(i){a||(g(p.$$.fragment,i),a=!0)},o(i){T(p.$$.fragment,i),a=!1},d(i){i&&(s(t),s(o)),U(p,i)}}}function gl(Z){let t,c="For example, to load from a previous version of Diffusers like v0.25.0:",o,p,a;return p=new _({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJjbGlwX2d1aWRlZF9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JldmlzaW9uJTNEJTIydjAuMjUuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    custom_revision=<span class="hljs-string">&quot;v0.25.0&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){t=d("p"),t.textContent=c,o=r(),M(p.$$.fragment)},l(i){t=y(i,"P",{"data-svelte-h":!0}),b(t)!=="svelte-1npkm46"&&(t.textContent=c),o=m(i),w(p.$$.fragment,i)},m(i,h){n(i,t,h),n(i,o,h),J(p,i,h),a=!0},p:j,i(i){a||(g(p.$$.fragment,i),a=!0)},o(i){T(p.$$.fragment,i),a=!1},d(i){i&&(s(t),s(o)),U(p,i)}}}function Tl(Z){let t,c,o,p;return t=new We({props:{id:"version",option:"main",$$slots:{default:[Jl]},$$scope:{ctx:Z}}}),o=new We({props:{id:"version",option:"older version",$$slots:{default:[gl]},$$scope:{ctx:Z}}}),{c(){M(t.$$.fragment),c=r(),M(o.$$.fragment)},l(a){w(t.$$.fragment,a),c=m(a),w(o.$$.fragment,a)},m(a,i){J(t,a,i),n(a,c,i),J(o,a,i),p=!0},p(a,i){const h={};i&2&&(h.$$scope={dirty:i,ctx:a}),t.$set(h);const f={};i&2&&(f.$$scope={dirty:i,ctx:a}),o.$set(f)},i(a){p||(g(t.$$.fragment,a),g(o.$$.fragment,a),p=!0)},o(a){T(t.$$.fragment,a),T(o.$$.fragment,a),p=!1},d(a){a&&s(c),U(t,a),U(o,a)}}}function Ul(Z){let t,c='The <a href="/docs/diffusers/pr_8408/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method is particularly useful for loading community pipelines because many of them don’t have pretrained weights and add a feature on top of an existing pipeline like Stable Diffusion or Stable Diffusion XL. You can learn more about the <a href="/docs/diffusers/pr_8408/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method in the <a href="custom_pipeline_overview#load-with-from_pipe">Load with from_pipe</a> section.';return{c(){t=d("p"),t.innerHTML=c},l(o){t=y(o,"P",{"data-svelte-h":!0}),b(t)!=="svelte-1acrol2"&&(t.innerHTML=c)},m(o,p){n(o,t,p)},p:j,d(o){o&&s(t)}}}function Zl(Z){let t,c='<a href="https://marigoldmonodepth.github.io/" rel="nofollow">Marigold</a> is a depth estimation diffusion pipeline that uses the rich existing and inherent visual knowledge in diffusion models. It takes an input image and denoises and decodes it into a depth map. Marigold performs well even on images it hasn’t seen before.',o,p,a,i,h='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/community-marigold.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/marigold-depth.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">colorized depth image</figcaption></div>',f;return p=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnBycy1ldGglMkZtYXJpZ29sZC1sY20tdjEtMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUzRCUyMm1hcmlnb2xkX2RlcHRoX2VzdGltYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSklMEElMEFwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb21tdW5pdHktbWFyaWdvbGQucG5nJTIyKSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZGVub2lzaW5nX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMGVuc2VtYmxlX3NpemUlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19yZXMlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBtYXRjaF9pbnB1dF9yZXMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDAlMkMlMEElMjAlMjAlMjAlMjBzZWVkJTNEMzMlMkMlMEElMjAlMjAlMjAlMjBjb2xvcl9tYXAlM0QlMjJTcGVjdHJhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNob3dfcHJvZ3Jlc3NfYmFyJTNEVHJ1ZSUyQyUwQSklMEFkZXB0aF9jb2xvcmVkJTNBJTIwSW1hZ2UuSW1hZ2UlMjAlM0QlMjBvdXRwdXQuZGVwdGhfY29sb3JlZCUwQWRlcHRoX2NvbG9yZWQuc2F2ZSglMjIuJTJGZGVwdGhfY29sb3JlZC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-lcm-v1-0&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;marigold_depth_estimation&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
)

pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/community-marigold.png&quot;</span>)
output = pipeline(
    image,
    denoising_steps=<span class="hljs-number">4</span>,
    ensemble_size=<span class="hljs-number">5</span>,
    processing_res=<span class="hljs-number">768</span>,
    match_input_res=<span class="hljs-literal">True</span>,
    batch_size=<span class="hljs-number">0</span>,
    seed=<span class="hljs-number">33</span>,
    color_map=<span class="hljs-string">&quot;Spectral&quot;</span>,
    show_progress_bar=<span class="hljs-literal">True</span>,
)
depth_colored: Image.Image = output.depth_colored
depth_colored.save(<span class="hljs-string">&quot;./depth_colored.png&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.innerHTML=c,o=r(),M(p.$$.fragment),a=r(),i=d("div"),i.innerHTML=h,this.h()},l(u){t=y(u,"P",{"data-svelte-h":!0}),b(t)!=="svelte-1edyql4"&&(t.innerHTML=c),o=m(u),w(p.$$.fragment,u),a=m(u),i=y(u,"DIV",{class:!0,"data-svelte-h":!0}),b(i)!=="svelte-1ldzdjg"&&(i.innerHTML=h),this.h()},h(){Q(i,"class","flex flex-row gap-4")},m(u,$){n(u,t,$),n(u,o,$),J(p,u,$),n(u,a,$),n(u,i,$),f=!0},p:j,i(u){f||(g(p.$$.fragment,u),f=!0)},o(u){T(p.$$.fragment,u),f=!1},d(u){u&&(s(t),s(o),s(a),s(i)),U(p,u)}}}function $l(Z){let t,c='<a href="https://hf.co/papers/2312.14091" rel="nofollow">HD-Painter</a> is a high-resolution inpainting pipeline. It introduces a <em>Prompt-Aware Introverted Attention (PAIntA)</em> layer to better align a prompt with the area to be inpainted, and <em>Reweighting Attention Score Guidance (RASG)</em> to keep the latents more prompt-aligned and within their trained domain to generate realistc images.',o,p,a,i,h='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hd-painter.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hd-painter-output.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',f;return p=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJMeWtvbiUyRmRyZWFtc2hhcGVyLTgtaW5wYWludGluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUzRCUyMmhkX3BhaW50ZXIlMjIlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmhkLXBhaW50ZXIuanBnJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmhkLXBhaW50ZXItbWFzay5wbmclMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyZm9vdGJhbGwlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTJDJTIwdXNlX3Jhc2clM0RUcnVlJTJDJTIwdXNlX3BhaW50YSUzRFRydWUlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZCgwKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Lykon/dreamshaper-8-inpainting&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;hd_painter&quot;</span>
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hd-painter.jpg&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hd-painter-mask.png&quot;</span>)
prompt = <span class="hljs-string">&quot;football&quot;</span>
image = pipeline(prompt, init_image, mask_image, use_rasg=<span class="hljs-literal">True</span>, use_painta=<span class="hljs-literal">True</span>, generator=torch.manual_seed(<span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){t=d("p"),t.innerHTML=c,o=r(),M(p.$$.fragment),a=r(),i=d("div"),i.innerHTML=h,this.h()},l(u){t=y(u,"P",{"data-svelte-h":!0}),b(t)!=="svelte-1fb9ggs"&&(t.innerHTML=c),o=m(u),w(p.$$.fragment,u),a=m(u),i=y(u,"DIV",{class:!0,"data-svelte-h":!0}),b(i)!=="svelte-3fh975"&&(i.innerHTML=h),this.h()},h(){Q(i,"class","flex flex-row gap-4")},m(u,$){n(u,t,$),n(u,o,$),J(p,u,$),n(u,a,$),n(u,i,$),f=!0},p:j,i(u){f||(g(p.$$.fragment,u),f=!0)},o(u){T(p.$$.fragment,u),f=!1},d(u){u&&(s(t),s(o),s(a),s(i)),U(p,u)}}}function _l(Z){let t,c,o,p;return t=new We({props:{id:"community",option:"Marigold",$$slots:{default:[Zl]},$$scope:{ctx:Z}}}),o=new We({props:{id:"community",option:"HD-Painter",$$slots:{default:[$l]},$$scope:{ctx:Z}}}),{c(){M(t.$$.fragment),c=r(),M(o.$$.fragment)},l(a){w(t.$$.fragment,a),c=m(a),w(o.$$.fragment,a)},m(a,i){J(t,a,i),n(a,c,i),J(o,a,i),p=!0},p(a,i){const h={};i&2&&(h.$$scope={dirty:i,ctx:a}),t.$set(h);const f={};i&2&&(f.$$scope={dirty:i,ctx:a}),o.$set(f)},i(a){p||(g(t.$$.fragment,a),g(o.$$.fragment,a),p=!0)},o(a){T(t.$$.fragment,a),T(o.$$.fragment,a),p=!1},d(a){a&&s(c),U(t,a),U(o,a)}}}function jl(Z){let t,c='In steps 4 and 5, the custom <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">UNet</a> and <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">pipeline</a> implementation must match the format shown in their files for this example to work.';return{c(){t=d("p"),t.innerHTML=c},l(o){t=y(o,"P",{"data-svelte-h":!0}),b(t)!=="svelte-ptu9pr"&&(t.innerHTML=c)},m(o,p){n(o,t,p)},p:j,d(o){o&&s(t)}}}function Gl(Z){let t,c='As an additional precaution with <code>trust_remote_code=True</code>, we strongly encourage you to pass a commit hash to the <code>revision</code> parameter in <a href="/docs/diffusers/pr_8408/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to make sure the code hasn’t been updated with some malicious new lines of code (unless you fully trust the model owners).';return{c(){t=d("p"),t.innerHTML=c},l(o){t=y(o,"P",{"data-svelte-h":!0}),b(t)!=="svelte-1b1qi1c"&&(t.innerHTML=c)},m(o,p){n(o,t,p)},p:j,d(o){o&&s(t)}}}function vl(Z){let t,c,o,p,a,i,h,f,u,$,I,Ce,Y,It='Community pipelines are any <a href="/docs/diffusers/pr_8408/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class that are different from the original paper implementation (for example, the <a href="/docs/diffusers/pr_8408/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> corresponds to the <a href="https://arxiv.org/abs/2302.05543" rel="nofollow">Text-to-Image Generation with ControlNet Conditioning</a> paper). They provide additional functionality or extend the original implementation of a pipeline.',Be,z,Vt='There are many cool community pipelines like <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#marigold-depth-estimation" rel="nofollow">Marigold Depth Estimation</a> or <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#instantid-pipeline" rel="nofollow">InstantID</a>, and you can find all the official community pipelines <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">here</a>.',ke,F,Ct="There are two types of community pipelines, those stored on the Hugging Face Hub and those stored on Diffusers GitHub repository. Hub pipelines are completely customizable (scheduler, models, pipeline code, etc.) while Diffusers GitHub pipelines are only limited to custom pipeline code.",xe,S,Bt="<thead><tr><th></th> <th>GitHub community pipeline</th> <th>HF Hub community pipeline</th></tr></thead> <tbody><tr><td>usage</td> <td>same</td> <td>same</td></tr> <tr><td>review process</td> <td>open a Pull Request on GitHub and undergo a review process from the Diffusers team before merging; may be slower</td> <td>upload directly to a Hub repository without any review; this is the fastest workflow</td></tr> <tr><td>visibility</td> <td>included in the official Diffusers repository and documentation</td> <td>included on your HF Hub profile and relies on your own usage/promotion to gain visibility</td></tr></tbody>",Re,V,He,L,Xe,D,kt="Community pipelines can also be loaded from a local file if you pass a file path instead. The path to the passed directory must contain a pipeline.py file that contains the pipeline class.",Ee,q,Ne,P,Qe,A,xt="By default, community pipelines are loaded from the latest stable version of Diffusers. To load a community pipeline from another version, use the <code>custom_revision</code> parameter.",Ye,C,ze,K,Fe,O,Rt='Community pipelines can also be loaded with the <a href="/docs/diffusers/pr_8408/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method which allows you to load and reuse multiple pipelines without any additional memory overhead (learn more in the <a href="./loading#reuse-a-pipeline">Reuse a pipeline</a> guide). The memory requirement is determined by the largest single pipeline loaded.',Se,ee,Ht='For example, let’s load a community pipeline that supports <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#long-prompt-weighting-stable-diffusion" rel="nofollow">long prompts with weighting</a> from a Stable Diffusion pipeline.',Le,te,De,B,Xt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/from_pipe_lpw.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion with long prompt weighting</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/from_pipe_non_lpw.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion</figcaption></div>',qe,le,Pe,se,Et='Community pipelines are a really fun and creative way to extend the capabilities of the original pipeline with new and unique features. You can find all community pipelines in the <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">diffusers/examples/community</a> folder with inference and training examples for how to use them.',Ae,ie,Nt="This section showcases a couple of the community pipelines and hopefully it’ll inspire you to create your own (feel free to open a PR for your community pipeline and ping us for a review)!",Ke,k,Oe,x,et,ne,tt,ae,Qt="Community components allow users to build pipelines that may have customized components that are not a part of Diffusers. If your pipeline has custom components that Diffusers doesn’t already support, you need to provide their implementations as Python modules. These customized components could be a VAE, UNet, and scheduler. In most cases, the text encoder is imported from the Transformers library. The pipeline code itself can also be customized.",lt,oe,Yt="This section shows how users should use community components to build a community pipeline.",st,pe,zt='You’ll use the <a href="https://huggingface.co/showlab/show-1-base" rel="nofollow">showlab/show-1-base</a> pipeline checkpoint as an example.',it,re,Ft="<li>Import and load the text encoder from Transformers:</li>",nt,me,at,R,St="<li>Load a scheduler:</li>",ot,ue,pt,H,Lt="<li>Load an image processor:</li>",rt,ce,mt,X,ut,G,v,je,Dt='Now you’ll load a <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">custom UNet</a>, which in this example, has already been implemented in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">showone_unet_3d_condition.py</a> for your convenience. You’ll notice the <a href="/docs/diffusers/pr_8408/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> class name is changed to <code>ShowOneUNet3DConditionModel</code> because <a href="/docs/diffusers/pr_8408/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> already exists in Diffusers. Any components needed for the <code>ShowOneUNet3DConditionModel</code> class should be placed in showone_unet_3d_condition.py.',jt,Ge,qt="Once this is done, you can initialize the UNet:",Gt,fe,vt,ve,Pt='<p>Finally, you’ll load the custom pipeline code. For this example, it has already been created for you in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/pipeline_t2v_base_pixel.py" rel="nofollow">pipeline_t2v_base_pixel.py</a>. This script contains a custom <code>TextToVideoIFPipeline</code> class for generating videos from text. Just like the custom UNet, any code needed for the custom pipeline to work should go in pipeline_t2v_base_pixel.py.</p>',ct,de,At="Once everything is in place, you can initialize the <code>TextToVideoIFPipeline</code> with the <code>ShowOneUNet3DConditionModel</code>:",ft,ye,dt,he,Kt="Push the pipeline to the Hub to share with the community!",yt,Me,ht,we,Ot="After the pipeline is successfully pushed, you need to make a few changes:",Mt,be,el='<li>Change the <code>_class_name</code> attribute in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/model_index.json#L2" rel="nofollow">model_index.json</a> to <code>&quot;pipeline_t2v_base_pixel&quot;</code> and <code>&quot;TextToVideoIFPipeline&quot;</code>.</li> <li>Upload <code>showone_unet_3d_condition.py</code> to the <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">unet</a> subfolder.</li> <li>Upload <code>pipeline_t2v_base_pixel.py</code> to the pipeline <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/tree/main" rel="nofollow">repository</a>.</li>',wt,Je,tl="To run inference, add the <code>trust_remote_code</code> argument while initializing the pipeline to handle all the “magic” behind the scenes.",bt,E,Jt,ge,gt,Te,ll='As an additional reference, take a look at the repository structure of <a href="https://huggingface.co/stabilityai/japanese-stable-diffusion-xl/" rel="nofollow">stabilityai/japanese-stable-diffusion-xl</a> which also uses the <code>trust_remote_code</code> feature.',Tt,Ue,Ut,Ze,Zt,Ie,$t;return a=new _e({props:{title:"Load community pipelines and components",local:"load-community-pipelines-and-components",headingTag:"h1"}}),h=new fl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"}]}}),u=new _e({props:{title:"Community pipelines",local:"community-pipelines",headingTag:"h2"}}),I=new Ve({props:{warning:!1,$$slots:{default:[yl]},$$scope:{ctx:Z}}}),V=new Wt({props:{id:"community",options:["Hub pipelines","GitHub pipelines"],$$slots:{default:[bl]},$$scope:{ctx:Z}}}),L=new _e({props:{title:"Load from a local file",local:"load-from-a-local-file",headingTag:"h3"}}),q=new _({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjIuJTJGcGF0aCUyRnRvJTJGcGlwZWxpbmVfZGlyZWN0b3J5JTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9tb2RlbCUzRGNsaXBfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yJTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSk=",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;./path/to/pipeline_directory/&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),P=new _e({props:{title:"Load from a specific version",local:"load-from-a-specific-version",headingTag:"h3"}}),C=new Wt({props:{id:"version",options:["main","older version"],$$slots:{default:[Tl]},$$scope:{ctx:Z}}}),K=new _e({props:{title:"Load with from_pipe",local:"load-with-frompipe",headingTag:"h3"}}),te=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlX3NkJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmVtaWxpYW5KUiUyRkN5YmVyUmVhbGlzdGljX1YzJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVfc2QudG8oJTIyY3VkYSUyMiklMEElMjMlMjBsb2FkJTIwbG9uZyUyMHByb21wdCUyMHdlaWdodGluZyUyMHBpcGVsaW5lJTBBcGlwZV9scHclMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3BpcGUoJTBBJTIwJTIwJTIwJTIwcGlwZV9zZCUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUzRCUyMmxwd19zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyQyUyMGhpZGluZyUyMGluJTIwdGhlJTIwbGVhdmVzJTJDJTIwKChyYWluKSklMkMlMjB6YXppZSUyMHJhaW55ZGF5JTJDJTIwYmVhdXRpZnVsJTIwZXllcyUyQyUyMG1hY3JvJTIwc2hvdCUyQyUyMGNvbG9yZnVsJTIwZGV0YWlscyUyQyUyMG5hdHVyYWwlMjBsaWdodGluZyUyQyUyMGFtYXppbmclMjBjb21wb3NpdGlvbiUyQyUyMHN1YnN1cmZhY2UlMjBzY2F0dGVyaW5nJTJDJTIwYW1hemluZyUyMHRleHR1cmVzJTJDJTIwZmlsbWljJTJDJTIwc29mdCUyMGxpZ2h0JTJDJTIwdWx0cmEtZGV0YWlsZWQlMjBleWVzJTJDJTIwaW50cmljYXRlJTIwZGV0YWlscyUyQyUyMGRldGFpbGVkJTIwdGV4dHVyZSUyQyUyMGxpZ2h0JTIwc291cmNlJTIwY29udHJhc3QlMkMlMjBkcmFtYXRpYyUyMHNoYWRvd3MlMkMlMjBjaW5lbWF0aWMlMjBsaWdodCUyQyUyMGRlcHRoJTIwb2YlMjBmaWVsZCUyQyUyMGZpbG0lMjBncmFpbiUyQyUyMG5vaXNlJTJDJTIwZGFyayUyMGJhY2tncm91bmQlMkMlMjBoeXBlcnJlYWxpc3RpYyUyMGRzbHIlMjBmaWxtJTIwc3RpbGwlMkMlMjBkaW0lMjB2b2x1bWV0cmljJTIwY2luZW1hdGljJTIwbGlnaHRpbmclMjIlMEFuZWdfcHJvbXB0JTIwJTNEJTIwJTIyKGRlZm9ybWVkJTIwaXJpcyUyQyUyMGRlZm9ybWVkJTIwcHVwaWxzJTJDJTIwc2VtaS1yZWFsaXN0aWMlMkMlMjBjZ2klMkMlMjAzZCUyQyUyMHJlbmRlciUyQyUyMHNrZXRjaCUyQyUyMGNhcnRvb24lMkMlMjBkcmF3aW5nJTJDJTIwYW5pbWUlMkMlMjBtdXRhdGVkJTIwaGFuZHMlMjBhbmQlMjBmaW5nZXJzJTNBMS40KSUyQyUyMChkZWZvcm1lZCUyQyUyMGRpc3RvcnRlZCUyQyUyMGRpc2ZpZ3VyZWQlM0ExLjMpJTJDJTIwcG9vcmx5JTIwZHJhd24lMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd3JvbmclMjBhbmF0b215JTJDJTIwZXh0cmElMjBsaW1iJTJDJTIwbWlzc2luZyUyMGxpbWIlMkMlMjBmbG9hdGluZyUyMGxpbWJzJTJDJTIwZGlzY29ubmVjdGVkJTIwbGltYnMlMkMlMjBtdXRhdGlvbiUyQyUyMG11dGF0ZWQlMkMlMjB1Z2x5JTJDJTIwZGlzZ3VzdGluZyUyQyUyMGFtcHV0YXRpb24lMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgyMCklMEFvdXRfbHB3JTIwJTNEJTIwcGlwZV9scHcoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2VtYmVkZGluZ3NfbXVsdGlwbGVzJTNEMyUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCkuaW1hZ2VzJTVCMCU1RCUwQW91dF9scHc=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe_sd = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/CyberRealistic_V3&quot;</span>, torch_dtype=torch.float16)
pipe_sd.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-comment"># load long prompt weighting pipeline</span>
pipe_lpw = DiffusionPipeline.from_pipe(
    pipe_sd,
    custom_pipeline=<span class="hljs-string">&quot;lpw_stable_diffusion&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;cat, hiding in the leaves, ((rain)), zazie rainyday, beautiful eyes, macro shot, colorful details, natural lighting, amazing composition, subsurface scattering, amazing textures, filmic, soft light, ultra-detailed eyes, intricate details, detailed texture, light source contrast, dramatic shadows, cinematic light, depth of field, film grain, noise, dark background, hyperrealistic dslr film still, dim volumetric cinematic lighting&quot;</span>
neg_prompt = <span class="hljs-string">&quot;(deformed iris, deformed pupils, semi-realistic, cgi, 3d, render, sketch, cartoon, drawing, anime, mutated hands and fingers:1.4), (deformed, distorted, disfigured:1.3), poorly drawn, bad anatomy, wrong anatomy, extra limb, missing limb, floating limbs, disconnected limbs, mutation, mutated, ugly, disgusting, amputation&quot;</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">20</span>)
out_lpw = pipe_lpw(
    prompt,
    negative_prompt=neg_prompt,
    width=<span class="hljs-number">512</span>,
    height=<span class="hljs-number">512</span>,
    max_embeddings_multiples=<span class="hljs-number">3</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
    ).images[<span class="hljs-number">0</span>]
out_lpw`,wrap:!1}}),le=new _e({props:{title:"Example community pipelines",local:"example-community-pipelines",headingTag:"h2"}}),k=new Ve({props:{warning:!1,$$slots:{default:[Ul]},$$scope:{ctx:Z}}}),x=new Wt({props:{id:"community",options:["Marigold","HD-Painter"],$$slots:{default:[_l]},$$scope:{ctx:Z}}}),ne=new _e({props:{title:"Community components",local:"community-components",headingTag:"h2"}}),me=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVFbmNvZGVyTW9kZWwlMEElMEFwaXBlX2lkJTIwJTNEJTIwJTIyc2hvd2xhYiUyRnNob3ctMS1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5EncoderModel

pipe_id = <span class="hljs-string">&quot;showlab/show-1-base&quot;</span>
tokenizer = T5Tokenizer.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
text_encoder = T5EncoderModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)`,wrap:!1}}),ue=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

scheduler = DPMSolverMultistepScheduler.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),ce=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBDTElQRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMmZlYXR1cmVfZXh0cmFjdG9yJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPFeatureExtractor

feature_extractor = CLIPFeatureExtractor.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;feature_extractor&quot;</span>)`,wrap:!1}}),X=new Ve({props:{warning:!0,$$slots:{default:[jl]},$$scope:{ctx:Z}}}),fe=new _({props:{code:"ZnJvbSUyMHNob3dvbmVfdW5ldF8zZF9jb25kaXRpb24lMjBpbXBvcnQlMjBTaG93T25lVU5ldDNEQ29uZGl0aW9uTW9kZWwlMEElMEF1bmV0JTIwJTNEJTIwU2hvd09uZVVOZXQzRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZChwaXBlX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> showone_unet_3d_condition <span class="hljs-keyword">import</span> ShowOneUNet3DConditionModel

unet = ShowOneUNet3DConditionModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),ye=new _({props:{code:"ZnJvbSUyMHBpcGVsaW5lX3Qydl9iYXNlX3BpeGVsJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9JRlBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFRleHRUb1ZpZGVvSUZQaXBlbGluZSglMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3IlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byhkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnRvcmNoX2R0eXBlJTIwJTNEJTIwdG9yY2guZmxvYXQxNg==",highlighted:`<span class="hljs-keyword">from</span> pipeline_t2v_base_pixel <span class="hljs-keyword">import</span> TextToVideoIFPipeline
<span class="hljs-keyword">import</span> torch

pipeline = TextToVideoIFPipeline(
    unet=unet,
    text_encoder=text_encoder,
    tokenizer=tokenizer,
    scheduler=scheduler,
    feature_extractor=feature_extractor
)
pipeline = pipeline.to(device=<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.torch_dtype = torch.float16`,wrap:!1}}),Me=new _({props:{code:"cGlwZWxpbmUucHVzaF90b19odWIoJTIyY3VzdG9tLXQydi1waXBlbGluZSUyMik=",highlighted:'pipeline.push_to_hub(<span class="hljs-string">&quot;custom-t2v-pipeline&quot;</span>)',wrap:!1}}),E=new Ve({props:{warning:!0,$$slots:{default:[Gl]},$$scope:{ctx:Z}}}),ge=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIlM0NjaGFuZ2UtdXNlcm5hbWUlM0UlMkYlM0NjaGFuZ2UtaWQlM0UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyaGVsbG8lMjIlMEElMEElMjMlMjBUZXh0JTIwZW1iZWRzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMG5lZ2F0aXZlX2VtYmVkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQocHJvbXB0KSUwQSUwQSUyMyUyMEtleWZyYW1lcyUyMGdlbmVyYXRpb24lMjAoOHg2NHg0MCUyQyUyMDJmcHMpJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOS4wJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwdCUyMiUwQSkuZnJhbWVz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;&lt;change-username&gt;/&lt;change-id&gt;&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;hello&quot;</span>

<span class="hljs-comment"># Text embeds</span>
prompt_embeds, negative_embeds = pipeline.encode_prompt(prompt)

<span class="hljs-comment"># Keyframes generation (8x64x40, 2fps)</span>
video_frames = pipeline(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    num_frames=<span class="hljs-number">8</span>,
    height=<span class="hljs-number">40</span>,
    width=<span class="hljs-number">64</span>,
    num_inference_steps=<span class="hljs-number">2</span>,
    guidance_scale=<span class="hljs-number">9.0</span>,
    output_type=<span class="hljs-string">&quot;pt&quot;</span>
).frames`,wrap:!1}}),Ue=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRmphcGFuZXNlLXN0YWJsZS1kaWZmdXNpb24teGwlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/japanese-stable-diffusion-xl&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Ze=new dl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/custom_pipeline_overview.md"}}),{c(){t=d("meta"),c=r(),o=d("p"),p=r(),M(a.$$.fragment),i=r(),M(h.$$.fragment),f=r(),M(u.$$.fragment),$=r(),M(I.$$.fragment),Ce=r(),Y=d("p"),Y.innerHTML=It,Be=r(),z=d("p"),z.innerHTML=Vt,ke=r(),F=d("p"),F.textContent=Ct,xe=r(),S=d("table"),S.innerHTML=Bt,Re=r(),M(V.$$.fragment),He=r(),M(L.$$.fragment),Xe=r(),D=d("p"),D.textContent=kt,Ee=r(),M(q.$$.fragment),Ne=r(),M(P.$$.fragment),Qe=r(),A=d("p"),A.innerHTML=xt,Ye=r(),M(C.$$.fragment),ze=r(),M(K.$$.fragment),Fe=r(),O=d("p"),O.innerHTML=Rt,Se=r(),ee=d("p"),ee.innerHTML=Ht,Le=r(),M(te.$$.fragment),De=r(),B=d("div"),B.innerHTML=Xt,qe=r(),M(le.$$.fragment),Pe=r(),se=d("p"),se.innerHTML=Et,Ae=r(),ie=d("p"),ie.textContent=Nt,Ke=r(),M(k.$$.fragment),Oe=r(),M(x.$$.fragment),et=r(),M(ne.$$.fragment),tt=r(),ae=d("p"),ae.textContent=Qt,lt=r(),oe=d("p"),oe.textContent=Yt,st=r(),pe=d("p"),pe.innerHTML=zt,it=r(),re=d("ol"),re.innerHTML=Ft,nt=r(),M(me.$$.fragment),at=r(),R=d("ol"),R.innerHTML=St,ot=r(),M(ue.$$.fragment),pt=r(),H=d("ol"),H.innerHTML=Lt,rt=r(),M(ce.$$.fragment),mt=r(),M(X.$$.fragment),ut=r(),G=d("ol"),v=d("li"),je=d("p"),je.innerHTML=Dt,jt=r(),Ge=d("p"),Ge.textContent=qt,Gt=r(),M(fe.$$.fragment),vt=r(),ve=d("li"),ve.innerHTML=Pt,ct=r(),de=d("p"),de.innerHTML=At,ft=r(),M(ye.$$.fragment),dt=r(),he=d("p"),he.textContent=Kt,yt=r(),M(Me.$$.fragment),ht=r(),we=d("p"),we.textContent=Ot,Mt=r(),be=d("ol"),be.innerHTML=el,wt=r(),Je=d("p"),Je.innerHTML=tl,bt=r(),M(E.$$.fragment),Jt=r(),M(ge.$$.fragment),gt=r(),Te=d("p"),Te.innerHTML=ll,Tt=r(),M(Ue.$$.fragment),Ut=r(),M(Ze.$$.fragment),Zt=r(),Ie=d("p"),this.h()},l(e){const l=cl("svelte-u9bgzb",document.head);t=y(l,"META",{name:!0,content:!0}),l.forEach(s),c=m(e),o=y(e,"P",{}),_t(o).forEach(s),p=m(e),w(a.$$.fragment,e),i=m(e),w(h.$$.fragment,e),f=m(e),w(u.$$.fragment,e),$=m(e),w(I.$$.fragment,e),Ce=m(e),Y=y(e,"P",{"data-svelte-h":!0}),b(Y)!=="svelte-d3upz2"&&(Y.innerHTML=It),Be=m(e),z=y(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-1um0op1"&&(z.innerHTML=Vt),ke=m(e),F=y(e,"P",{"data-svelte-h":!0}),b(F)!=="svelte-1i5arbj"&&(F.textContent=Ct),xe=m(e),S=y(e,"TABLE",{"data-svelte-h":!0}),b(S)!=="svelte-1tu2a4k"&&(S.innerHTML=Bt),Re=m(e),w(V.$$.fragment,e),He=m(e),w(L.$$.fragment,e),Xe=m(e),D=y(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-1ydiyl5"&&(D.textContent=kt),Ee=m(e),w(q.$$.fragment,e),Ne=m(e),w(P.$$.fragment,e),Qe=m(e),A=y(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-17rlizh"&&(A.innerHTML=xt),Ye=m(e),w(C.$$.fragment,e),ze=m(e),w(K.$$.fragment,e),Fe=m(e),O=y(e,"P",{"data-svelte-h":!0}),b(O)!=="svelte-pc9x4m"&&(O.innerHTML=Rt),Se=m(e),ee=y(e,"P",{"data-svelte-h":!0}),b(ee)!=="svelte-p2flxu"&&(ee.innerHTML=Ht),Le=m(e),w(te.$$.fragment,e),De=m(e),B=y(e,"DIV",{class:!0,"data-svelte-h":!0}),b(B)!=="svelte-108dts5"&&(B.innerHTML=Xt),qe=m(e),w(le.$$.fragment,e),Pe=m(e),se=y(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-3nyqz8"&&(se.innerHTML=Et),Ae=m(e),ie=y(e,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-sf3bca"&&(ie.textContent=Nt),Ke=m(e),w(k.$$.fragment,e),Oe=m(e),w(x.$$.fragment,e),et=m(e),w(ne.$$.fragment,e),tt=m(e),ae=y(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-1vh7uou"&&(ae.textContent=Qt),lt=m(e),oe=y(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-phpvnj"&&(oe.textContent=Yt),st=m(e),pe=y(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-10zn7oi"&&(pe.innerHTML=zt),it=m(e),re=y(e,"OL",{"data-svelte-h":!0}),b(re)!=="svelte-8ccbl9"&&(re.innerHTML=Ft),nt=m(e),w(me.$$.fragment,e),at=m(e),R=y(e,"OL",{start:!0,"data-svelte-h":!0}),b(R)!=="svelte-1rtkhjg"&&(R.innerHTML=St),ot=m(e),w(ue.$$.fragment,e),pt=m(e),H=y(e,"OL",{start:!0,"data-svelte-h":!0}),b(H)!=="svelte-o9t4x9"&&(H.innerHTML=Lt),rt=m(e),w(ce.$$.fragment,e),mt=m(e),w(X.$$.fragment,e),ut=m(e),G=y(e,"OL",{start:!0});var $e=_t(G);v=y($e,"LI",{});var W=_t(v);je=y(W,"P",{"data-svelte-h":!0}),b(je)!=="svelte-ztefg"&&(je.innerHTML=Dt),jt=m(W),Ge=y(W,"P",{"data-svelte-h":!0}),b(Ge)!=="svelte-4yol19"&&(Ge.textContent=qt),Gt=m(W),w(fe.$$.fragment,W),W.forEach(s),vt=m($e),ve=y($e,"LI",{"data-svelte-h":!0}),b(ve)!=="svelte-u0mc44"&&(ve.innerHTML=Pt),$e.forEach(s),ct=m(e),de=y(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-1jpprmd"&&(de.innerHTML=At),ft=m(e),w(ye.$$.fragment,e),dt=m(e),he=y(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-14lz5yb"&&(he.textContent=Kt),yt=m(e),w(Me.$$.fragment,e),ht=m(e),we=y(e,"P",{"data-svelte-h":!0}),b(we)!=="svelte-1gts2xf"&&(we.textContent=Ot),Mt=m(e),be=y(e,"OL",{"data-svelte-h":!0}),b(be)!=="svelte-1ymo6a8"&&(be.innerHTML=el),wt=m(e),Je=y(e,"P",{"data-svelte-h":!0}),b(Je)!=="svelte-3cd5s4"&&(Je.innerHTML=tl),bt=m(e),w(E.$$.fragment,e),Jt=m(e),w(ge.$$.fragment,e),gt=m(e),Te=y(e,"P",{"data-svelte-h":!0}),b(Te)!=="svelte-78djp3"&&(Te.innerHTML=ll),Tt=m(e),w(Ue.$$.fragment,e),Ut=m(e),w(Ze.$$.fragment,e),Zt=m(e),Ie=y(e,"P",{}),_t(Ie).forEach(s),this.h()},h(){Q(t,"name","hf:doc:metadata"),Q(t,"content",Wl),Q(B,"class","flex gap-4"),Q(R,"start","2"),Q(H,"start","3"),Q(G,"start","4")},m(e,l){N(document.head,t),n(e,c,l),n(e,o,l),n(e,p,l),J(a,e,l),n(e,i,l),J(h,e,l),n(e,f,l),J(u,e,l),n(e,$,l),J(I,e,l),n(e,Ce,l),n(e,Y,l),n(e,Be,l),n(e,z,l),n(e,ke,l),n(e,F,l),n(e,xe,l),n(e,S,l),n(e,Re,l),J(V,e,l),n(e,He,l),J(L,e,l),n(e,Xe,l),n(e,D,l),n(e,Ee,l),J(q,e,l),n(e,Ne,l),J(P,e,l),n(e,Qe,l),n(e,A,l),n(e,Ye,l),J(C,e,l),n(e,ze,l),J(K,e,l),n(e,Fe,l),n(e,O,l),n(e,Se,l),n(e,ee,l),n(e,Le,l),J(te,e,l),n(e,De,l),n(e,B,l),n(e,qe,l),J(le,e,l),n(e,Pe,l),n(e,se,l),n(e,Ae,l),n(e,ie,l),n(e,Ke,l),J(k,e,l),n(e,Oe,l),J(x,e,l),n(e,et,l),J(ne,e,l),n(e,tt,l),n(e,ae,l),n(e,lt,l),n(e,oe,l),n(e,st,l),n(e,pe,l),n(e,it,l),n(e,re,l),n(e,nt,l),J(me,e,l),n(e,at,l),n(e,R,l),n(e,ot,l),J(ue,e,l),n(e,pt,l),n(e,H,l),n(e,rt,l),J(ce,e,l),n(e,mt,l),J(X,e,l),n(e,ut,l),n(e,G,l),N(G,v),N(v,je),N(v,jt),N(v,Ge),N(v,Gt),J(fe,v,null),N(G,vt),N(G,ve),n(e,ct,l),n(e,de,l),n(e,ft,l),J(ye,e,l),n(e,dt,l),n(e,he,l),n(e,yt,l),J(Me,e,l),n(e,ht,l),n(e,we,l),n(e,Mt,l),n(e,be,l),n(e,wt,l),n(e,Je,l),n(e,bt,l),J(E,e,l),n(e,Jt,l),J(ge,e,l),n(e,gt,l),n(e,Te,l),n(e,Tt,l),J(Ue,e,l),n(e,Ut,l),J(Ze,e,l),n(e,Zt,l),n(e,Ie,l),$t=!0},p(e,[l]){const $e={};l&2&&($e.$$scope={dirty:l,ctx:e}),I.$set($e);const W={};l&2&&(W.$$scope={dirty:l,ctx:e}),V.$set(W);const sl={};l&2&&(sl.$$scope={dirty:l,ctx:e}),C.$set(sl);const il={};l&2&&(il.$$scope={dirty:l,ctx:e}),k.$set(il);const nl={};l&2&&(nl.$$scope={dirty:l,ctx:e}),x.$set(nl);const al={};l&2&&(al.$$scope={dirty:l,ctx:e}),X.$set(al);const ol={};l&2&&(ol.$$scope={dirty:l,ctx:e}),E.$set(ol)},i(e){$t||(g(a.$$.fragment,e),g(h.$$.fragment,e),g(u.$$.fragment,e),g(I.$$.fragment,e),g(V.$$.fragment,e),g(L.$$.fragment,e),g(q.$$.fragment,e),g(P.$$.fragment,e),g(C.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(le.$$.fragment,e),g(k.$$.fragment,e),g(x.$$.fragment,e),g(ne.$$.fragment,e),g(me.$$.fragment,e),g(ue.$$.fragment,e),g(ce.$$.fragment,e),g(X.$$.fragment,e),g(fe.$$.fragment,e),g(ye.$$.fragment,e),g(Me.$$.fragment,e),g(E.$$.fragment,e),g(ge.$$.fragment,e),g(Ue.$$.fragment,e),g(Ze.$$.fragment,e),$t=!0)},o(e){T(a.$$.fragment,e),T(h.$$.fragment,e),T(u.$$.fragment,e),T(I.$$.fragment,e),T(V.$$.fragment,e),T(L.$$.fragment,e),T(q.$$.fragment,e),T(P.$$.fragment,e),T(C.$$.fragment,e),T(K.$$.fragment,e),T(te.$$.fragment,e),T(le.$$.fragment,e),T(k.$$.fragment,e),T(x.$$.fragment,e),T(ne.$$.fragment,e),T(me.$$.fragment,e),T(ue.$$.fragment,e),T(ce.$$.fragment,e),T(X.$$.fragment,e),T(fe.$$.fragment,e),T(ye.$$.fragment,e),T(Me.$$.fragment,e),T(E.$$.fragment,e),T(ge.$$.fragment,e),T(Ue.$$.fragment,e),T(Ze.$$.fragment,e),$t=!1},d(e){e&&(s(c),s(o),s(p),s(i),s(f),s($),s(Ce),s(Y),s(Be),s(z),s(ke),s(F),s(xe),s(S),s(Re),s(He),s(Xe),s(D),s(Ee),s(Ne),s(Qe),s(A),s(Ye),s(ze),s(Fe),s(O),s(Se),s(ee),s(Le),s(De),s(B),s(qe),s(Pe),s(se),s(Ae),s(ie),s(Ke),s(Oe),s(et),s(tt),s(ae),s(lt),s(oe),s(st),s(pe),s(it),s(re),s(nt),s(at),s(R),s(ot),s(pt),s(H),s(rt),s(mt),s(ut),s(G),s(ct),s(de),s(ft),s(dt),s(he),s(yt),s(ht),s(we),s(Mt),s(be),s(wt),s(Je),s(bt),s(Jt),s(gt),s(Te),s(Tt),s(Ut),s(Zt),s(Ie)),s(t),U(a,e),U(h,e),U(u,e),U(I,e),U(V,e),U(L,e),U(q,e),U(P,e),U(C,e),U(K,e),U(te,e),U(le,e),U(k,e),U(x,e),U(ne,e),U(me,e),U(ue,e),U(ce,e),U(X,e),U(fe),U(ye,e),U(Me,e),U(E,e),U(ge,e),U(Ue,e),U(Ze,e)}}}const Wl='{"title":"Load community pipelines and components","local":"load-community-pipelines-and-components","sections":[{"title":"Community pipelines","local":"community-pipelines","sections":[{"title":"Load from a local file","local":"load-from-a-local-file","sections":[],"depth":3},{"title":"Load from a specific version","local":"load-from-a-specific-version","sections":[],"depth":3},{"title":"Load with from_pipe","local":"load-with-frompipe","sections":[],"depth":3}],"depth":2},{"title":"Example community pipelines","local":"example-community-pipelines","sections":[],"depth":2},{"title":"Community components","local":"community-components","sections":[],"depth":2}],"depth":1}';function Il(Z){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xl extends ml{constructor(t){super(),ul(this,t,Il,vl,pl,{})}}export{Xl as component};
