import{s as Ss,n as Js,o as Ds}from"../chunks/scheduler.0219f8bd.js";import{S as zs,i as Ws,g as s,s as o,r as p,A as Vs,h as n,f as l,c as d,j as a,u as c,x as r,k as u,y as Ys,a as i,v as f,d as h,t as m,w as b}from"../chunks/index.f61edf3b.js";import{H as _,E as Gs}from"../chunks/EditOnGithub.48fa589f.js";function Qs(Pd){let $,Dt,St,zt,g,Wt,T,Vt,v,Md='Utility functions to interact with the Hugging Face Hub (<a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>)',Yt,y,Rd='<li><a href="#module_utils/hub">utils/hub</a><ul><li><em>static</em><ul><li><a href="#module_utils/hub.getFile"><code>.getFile(urlOrPath)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response)&gt;</code></li> <li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li> <li><a href="#module_utils/hub.getModelFile..progressInfo"><code>~progressInfo</code></a> : <code>*</code></li></ul></li> <li><a href="#module_utils/hub.getModelJSON"><code>.getModelJSON(modelPath, fileName, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li> <li><a href="#module_utils/hub..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..isValidUrl"><code>~isValidUrl(string, [protocols], [validHosts])</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/hub..handleError"><code>~handleError(status, remoteURL, fatal)</code></a> ⇒ <code>null</code></li> <li><a href="#module_utils/hub..tryCache"><code>~tryCache(cache, ...names)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code></li> <li><a href="#module_utils/hub..readResponse"><code>~readResponse(response, progress_callback)</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code></li> <li><a href="#module_utils/hub..pathJoin"><code>~pathJoin(...parts)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/hub..PretrainedOptions"><code>~PretrainedOptions</code></a> : <code>Object</code></li> <li><a href="#module_utils/hub..ModelSpecificPretrainedOptions"><code>~ModelSpecificPretrainedOptions</code></a> : <code>Object</code></li> <li><a href="#module_utils/hub..PretrainedModelOptions"><code>~PretrainedModelOptions</code></a> : <code>*</code></li></ul></li></ul></li>',Gt,Qt,Xt,P,Zt,M,el,R,Cd="Helper function to get a file, using either the Fetch API or FileSystem API.",tl,C,Hd='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response)&gt;</code> - A promise that resolves to a FileResponse object (if the file is retrieved using the FileSystem API), or a Response object (if the file is retrieved using the Fetch API).',ll,H,Ld="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>urlOrPath</td><td><code>URL</code> | <code>string</code></td><td><p>The URL/path of the file to get.</p></td></tr></tbody>",il,ol,dl,L,sl,F,nl,x,Fd=`Retrieves a file from either a remote URL using the Fetch API or from the local file system using the FileSystem API.
If the filesystem is available and <code>env.useCache = true</code>, the file will be downloaded and cached.`,rl,w,xd='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Uint8Array&gt;</code> - A Promise that resolves with the file content as a buffer.<br/> <strong>Throws</strong>:',ul,A,wd="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",al,j,Ad="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>path_or_repo_id</td><td><code>string</code></td><td></td><td><p>This can be either:</p> <ul><li>a string, the <em>model id</em> of a model repo on huggingface.co.</li> <li>a path to a <em>directory</em> potentially containing the file.</li></ul></td> </tr><tr><td>filename</td><td><code>string</code></td><td></td><td><p>The name of the file to locate in <code>path_or_repo</code>.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",pl,E,jd='<li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li> <li><a href="#module_utils/hub.getModelFile..progressInfo"><code>~progressInfo</code></a> : <code>*</code></li></ul></li>',cl,fl,hl,O,ml,U,bl,B,Ed='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',_l,$l,gl,K,Tl,I,vl,q,Od='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',yl,Pl,Ml,N,Rl,k,Cl,S,Ud='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',Hl,Ll,Fl,J,xl,D,wl,z,Bd='<strong>Kind</strong>: inner constant of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',Al,jl,El,W,Ol,V,Ul,Y,Kd="Fetches a JSON file from a given path and file name.",Bl,G,Id='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - The JSON data parsed into a JavaScript object.<br/> <strong>Throws</strong>:',Kl,Q,qd="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",Il,X,Nd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>modelPath</td><td><code>string</code></td><td></td><td><p>The path to the directory containing the file.</p></td> </tr><tr><td>fileName</td><td><code>string</code></td><td></td><td><p>The name of the file to fetch.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",ql,Nl,kl,Z,Sl,ee,Jl,te,kd='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Dl,le,Sd='<li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',zl,Wl,Vl,ie,Yl,oe,Gl,de,Jd="Creates a new <code>FileResponse</code> object.",Ql,se,Dd="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>filePath</td><td><code>string</code> | <code>URL</code></td></tr></tbody>",Xl,Zl,ei,ne,ti,re,li,ue,zd=`Updates the ‘content-type’ header property of the response based on the extension of
the file specified by the filePath property of the current object.`,ii,ae,Wd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',oi,di,si,pe,ni,ce,ri,fe,Vd="Clone the current FileResponse object.",ui,he,Yd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>FileResponse</code> - A new FileResponse object with the same properties as the current object.',ai,pi,ci,me,fi,be,hi,_e,Gd=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with an ArrayBuffer containing the file’s contents.`,mi,$e,Qd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ArrayBuffer&gt;</code> - A Promise that resolves with an ArrayBuffer containing the file’s contents.<br/> <strong>Throws</strong>:',bi,ge,Xd="<li><code>Error</code> If the file cannot be read.</li>",_i,$i,gi,Te,Ti,ve,vi,ye,Zd=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a Blob containing the file’s contents.`,yi,Pe,es='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Blob&gt;</code> - A Promise that resolves with a Blob containing the file’s contents.<br/> <strong>Throws</strong>:',Pi,Me,ts="<li><code>Error</code> If the file cannot be read.</li>",Mi,Ri,Ci,Re,Hi,Ce,Li,He,ls=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a string containing the file’s contents.`,Fi,Le,is='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;string&gt;</code> - A Promise that resolves with a string containing the file’s contents.<br/> <strong>Throws</strong>:',xi,Fe,os="<li><code>Error</code> If the file cannot be read.</li>",wi,Ai,ji,xe,Ei,we,Oi,Ae,ds=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a parsed JavaScript object containing the file’s contents.`,Ui,je,ss='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves with a parsed JavaScript object containing the file’s contents.<br/> <strong>Throws</strong>:',Bi,Ee,ns="<li><code>Error</code> If the file cannot be read.</li>",Ki,Ii,qi,Oe,Ni,Ue,ki,Be,rs='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Si,Ke,us='<li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response)</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li>',Ji,Di,zi,Ie,Wi,qe,Vi,Ne,as="Instantiate a <code>FileCache</code> object.",Yi,ke,ps="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td></tr></tbody>",Gi,Qi,Xi,Se,Zi,Je,eo,De,cs="Checks whether the given request is in the cache.",to,ze,fs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',lo,We,hs="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td></tr></tbody>",io,oo,so,Ve,no,Ye,ro,Ge,ms="Adds the given response to the cache.",uo,Qe,bs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',ao,Xe,_s="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td> </tr><tr><td>response</td><td><code>Response</code> | <code>FileResponse</code></td></tr></tbody>",po,co,fo,Ze,ho,et,mo,tt,$s="Mapping from file extensions to MIME types.",bo,lt,gs='<strong>Kind</strong>: inner constant of <a href="#module_utils/hub"><code>utils/hub</code></a>',_o,$o,go,it,To,ot,vo,dt,Ts="Determines whether the given string is a valid URL.",yo,st,vs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - True if the string is a valid URL, false otherwise.',Po,nt,ys="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>string</td><td><code>string</code> | <code>URL</code></td><td></td><td><p>The string to test for validity as an URL.</p></td> </tr><tr><td>[protocols]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid protocols. If specified, the protocol must be in this list.</p></td> </tr><tr><td>[validHosts]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid hostnames. If specified, the URL&#39;s hostname must be in this list.</p></td></tr></tbody>",Mo,Ro,Co,rt,Ho,ut,Lo,at,Ps="Helper method to handle fatal errors that occur while trying to load a file from the Hugging Face Hub.",Fo,pt,Ms='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>null</code> - Returns <code>null</code> if <code>fatal = true</code>.<br/> <strong>Throws</strong>:',xo,ct,Rs="<li><code>Error</code> If `fatal = false`.</li>",wo,ft,Cs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>status</td><td><code>number</code></td><td><p>The HTTP status code of the error.</p></td> </tr><tr><td>remoteURL</td><td><code>string</code></td><td><p>The URL of the file that could not be loaded.</p></td> </tr><tr><td>fatal</td><td><code>boolean</code></td><td><p>Whether to raise an error if the file could not be loaded.</p></td></tr></tbody>",Ao,jo,Eo,ht,Oo,mt,Uo,bt,Hs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code> - The item from the cache, or undefined if not found.',Bo,_t,Ls="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>cache</td><td><code>FileCache</code> | <code>Cache</code></td><td><p>The cache to search</p></td> </tr><tr><td>...names</td><td><code>Array.&lt;string&gt;</code></td><td><p>The names of the item to search for</p></td></tr></tbody>",Ko,Io,qo,$t,No,gt,ko,Tt,Fs="Read and track progress when reading a Response object",So,vt,xs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Uint8Array&gt;</code> - A Promise that resolves with the Uint8Array buffer',Jo,yt,ws="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>response</td><td><code>any</code></td><td><p>The Response object to read</p></td> </tr><tr><td>progress_callback</td><td><code>function</code></td><td><p>The function to call with progress updates</p></td></tr></tbody>",Do,zo,Wo,Pt,Vo,Mt,Yo,Rt,As="Joins multiple parts of a path into a single path, while handling leading and trailing slashes.",Go,Ct,js='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>string</code> - A string representing the joined path.',Qo,Ht,Es="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...parts</td><td><code>string</code></td><td><p>Multiple parts of a path.</p></td></tr></tbody>",Xo,Zo,ed,Lt,td,Ft,ld,xt,Os="Options for loading a pretrained model.",id,wt,Us='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',od,At,Bs=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[progress_callback]</td><td><code>*</code></td><td><code></code></td><td><p>If specified, this function will be called during model construction, to provide the user with progress updates.</p></td> </tr><tr><td>[config]</td><td><code>*</code></td><td><code></code></td><td><p>Configuration for the model to use instead of an automatically loaded configuration. Configuration can be automatically loaded when:</p> <ul><li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained model).</li> <li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a configuration JSON file named <em>config.json</em> is found in the directory.</li></ul></td> </tr><tr><td>[cache_dir]</td><td><code>string</code></td><td><code>null</code></td><td><p>Path to a directory in which a downloaded pretrained model configuration should be cached if the standard cache should not be used.</p></td> </tr><tr><td>[local_files_only]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to only look at local files (e.g., not try downloading the model).</p></td> </tr><tr><td>[revision]</td><td><code>string</code></td><td><code>&quot;&#39;main&#39;&quot;</code></td><td><p>The specific model version to use. It can be a branch name, a tag name, or a commit id,
since we use a git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier allowed by git.
NOTE: This setting is ignored for local requests.</p></td></tr></tbody>`,dd,sd,nd,jt,rd,Et,ud,Ot,Ks="Options for loading a pretrained model.",ad,Ut,Is='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',pd,Bt,qs=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[subfolder]</td><td><code>string</code></td><td><code>&quot;&#39;onnx&#39;&quot;</code></td><td><p>In case the relevant files are located inside a subfolder of the model repo on huggingface.co,
you can specify the folder name here.</p></td> </tr><tr><td>[model_file_name]</td><td><code>string</code></td><td><code>null</code></td><td><p>If specified, load the model with this name (excluding the .onnx suffix). Currently only valid for encoder- or decoder-only models.</p></td> </tr><tr><td>[device]</td><td><code>*</code></td><td><code></code></td><td><p>The device to run the model on. If not specified, the device will be chosen from the environment settings.</p></td> </tr><tr><td>[dtype]</td><td><code>*</code></td><td><code></code></td><td><p>The data type to use for the model. If not specified, the data type will be chosen from the environment settings.</p></td> </tr><tr><td>[use_external_data_format]</td><td><code>boolean</code> | <code>Record&lt;string, boolean&gt;</code></td><td><code>false</code></td><td><p>Whether to load the model using the external data format (used for models &gt;= 2GB in size).</p></td> </tr><tr><td>[session_options]</td><td><code>*</code></td><td></td><td><p>(Optional) User-specified session options passed to the runtime. If not provided, suitable defaults will be chosen.</p></td></tr></tbody>`,cd,fd,hd,Kt,md,It,bd,qt,Ns="Options for loading a pretrained model.",_d,Nt,ks='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a>',$d,gd,Td,kt,vd,Jt,yd;return T=new _({props:{title:"utils/hub",local:"utilshub",headingTag:"h1"}}),M=new _({props:{title:"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>",local:"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code",headingTag:"h2"}}),F=new _({props:{title:"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise. < Uint8Array > </code>",local:"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise--uint8array--code",headingTag:"h2"}}),U=new _({props:{title:"getModelFile~cacheKey : <code> string </code>",local:"getmodelfilecachekey--code-string-code",headingTag:"h3"}}),I=new _({props:{title:"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>",local:"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code",headingTag:"h3"}}),k=new _({props:{title:"getModelFile~buffer : <code> Uint8Array </code>",local:"getmodelfilebuffer--code-uint8array-code",headingTag:"h3"}}),D=new _({props:{title:"getModelFile~progressInfo : <code> * </code>",local:"getmodelfileprogressinfo--code--code",headingTag:"h3"}}),V=new _({props:{title:"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>",local:"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code",headingTag:"h2"}}),ee=new _({props:{title:"utils/hub~FileResponse",local:"utilshubfileresponse",headingTag:"h2"}}),oe=new _({props:{title:"new FileResponse(filePath)",local:"new-fileresponsefilepath",headingTag:"h3"}}),re=new _({props:{title:"fileResponse.updateContentType() ⇒ <code> void </code>",local:"fileresponseupdatecontenttype--code-void-code",headingTag:"h3"}}),ce=new _({props:{title:"fileResponse.clone() ⇒ <code> FileResponse </code>",local:"fileresponseclone--code-fileresponse-code",headingTag:"h3"}}),be=new _({props:{title:"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>",local:"fileresponsearraybuffer--code-promise--arraybuffer--code",headingTag:"h3"}}),ve=new _({props:{title:"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>",local:"fileresponseblob--code-promise--blob--code",headingTag:"h3"}}),Ce=new _({props:{title:"fileResponse.text() ⇒ <code> Promise. < string > </code>",local:"fileresponsetext--code-promise--string--code",headingTag:"h3"}}),we=new _({props:{title:"fileResponse.json() ⇒ <code> Promise. < Object > </code>",local:"fileresponsejson--code-promise--object--code",headingTag:"h3"}}),Ue=new _({props:{title:"utils/hub~FileCache",local:"utilshubfilecache",headingTag:"h2"}}),qe=new _({props:{title:"new FileCache(path)",local:"new-filecachepath",headingTag:"h3"}}),Je=new _({props:{title:"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>",local:"filecachematchrequest--code-promise--fileresponseundefined--code",headingTag:"h3"}}),Ye=new _({props:{title:"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>",local:"filecacheputrequest-response--code-promise--void--code",headingTag:"h3"}}),et=new _({props:{title:"utils/hub~CONTENT_TYPE_MAP",local:"utilshubcontenttypemap",headingTag:"h2"}}),ot=new _({props:{title:"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>",local:"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code",headingTag:"h2"}}),ut=new _({props:{title:"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>",local:"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code",headingTag:"h2"}}),mt=new _({props:{title:"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>",local:"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code",headingTag:"h2"}}),gt=new _({props:{title:"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>",local:"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code",headingTag:"h2"}}),Mt=new _({props:{title:"utils/hub~pathJoin(...parts) ⇒ <code> string </code>",local:"utilshubpathjoinparts--code-string-code",headingTag:"h2"}}),Ft=new _({props:{title:"utils/hub~PretrainedOptions : <code> Object </code>",local:"utilshubpretrainedoptions--code-object-code",headingTag:"h2"}}),Et=new _({props:{title:"utils/hub~ModelSpecificPretrainedOptions : <code> Object </code>",local:"utilshubmodelspecificpretrainedoptions--code-object-code",headingTag:"h2"}}),It=new _({props:{title:"utils/hub~PretrainedModelOptions : <code> * </code>",local:"utilshubpretrainedmodeloptions--code--code",headingTag:"h2"}}),kt=new Gs({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/hub.md"}}),{c(){$=s("meta"),Dt=o(),St=s("p"),zt=o(),g=s("a"),Wt=o(),p(T.$$.fragment),Vt=o(),v=s("p"),v.innerHTML=Md,Yt=o(),y=s("ul"),y.innerHTML=Rd,Gt=o(),Qt=s("hr"),Xt=o(),P=s("a"),Zt=o(),p(M.$$.fragment),el=o(),R=s("p"),R.textContent=Cd,tl=o(),C=s("p"),C.innerHTML=Hd,ll=o(),H=s("table"),H.innerHTML=Ld,il=o(),ol=s("hr"),dl=o(),L=s("a"),sl=o(),p(F.$$.fragment),nl=o(),x=s("p"),x.innerHTML=Fd,rl=o(),w=s("p"),w.innerHTML=xd,ul=o(),A=s("ul"),A.innerHTML=wd,al=o(),j=s("table"),j.innerHTML=Ad,pl=o(),E=s("ul"),E.innerHTML=jd,cl=o(),fl=s("hr"),hl=o(),O=s("a"),ml=o(),p(U.$$.fragment),bl=o(),B=s("p"),B.innerHTML=Ed,_l=o(),$l=s("hr"),gl=o(),K=s("a"),Tl=o(),p(I.$$.fragment),vl=o(),q=s("p"),q.innerHTML=Od,yl=o(),Pl=s("hr"),Ml=o(),N=s("a"),Rl=o(),p(k.$$.fragment),Cl=o(),S=s("p"),S.innerHTML=Ud,Hl=o(),Ll=s("hr"),Fl=o(),J=s("a"),xl=o(),p(D.$$.fragment),wl=o(),z=s("p"),z.innerHTML=Bd,Al=o(),jl=s("hr"),El=o(),W=s("a"),Ol=o(),p(V.$$.fragment),Ul=o(),Y=s("p"),Y.textContent=Kd,Bl=o(),G=s("p"),G.innerHTML=Id,Kl=o(),Q=s("ul"),Q.innerHTML=qd,Il=o(),X=s("table"),X.innerHTML=Nd,ql=o(),Nl=s("hr"),kl=o(),Z=s("a"),Sl=o(),p(ee.$$.fragment),Jl=o(),te=s("p"),te.innerHTML=kd,Dl=o(),le=s("ul"),le.innerHTML=Sd,zl=o(),Wl=s("hr"),Vl=o(),ie=s("a"),Yl=o(),p(oe.$$.fragment),Gl=o(),de=s("p"),de.innerHTML=Jd,Ql=o(),se=s("table"),se.innerHTML=Dd,Xl=o(),Zl=s("hr"),ei=o(),ne=s("a"),ti=o(),p(re.$$.fragment),li=o(),ue=s("p"),ue.textContent=zd,ii=o(),ae=s("p"),ae.innerHTML=Wd,oi=o(),di=s("hr"),si=o(),pe=s("a"),ni=o(),p(ce.$$.fragment),ri=o(),fe=s("p"),fe.textContent=Vd,ui=o(),he=s("p"),he.innerHTML=Yd,ai=o(),pi=s("hr"),ci=o(),me=s("a"),fi=o(),p(be.$$.fragment),hi=o(),_e=s("p"),_e.textContent=Gd,mi=o(),$e=s("p"),$e.innerHTML=Qd,bi=o(),ge=s("ul"),ge.innerHTML=Xd,_i=o(),$i=s("hr"),gi=o(),Te=s("a"),Ti=o(),p(ve.$$.fragment),vi=o(),ye=s("p"),ye.textContent=Zd,yi=o(),Pe=s("p"),Pe.innerHTML=es,Pi=o(),Me=s("ul"),Me.innerHTML=ts,Mi=o(),Ri=s("hr"),Ci=o(),Re=s("a"),Hi=o(),p(Ce.$$.fragment),Li=o(),He=s("p"),He.textContent=ls,Fi=o(),Le=s("p"),Le.innerHTML=is,xi=o(),Fe=s("ul"),Fe.innerHTML=os,wi=o(),Ai=s("hr"),ji=o(),xe=s("a"),Ei=o(),p(we.$$.fragment),Oi=o(),Ae=s("p"),Ae.textContent=ds,Ui=o(),je=s("p"),je.innerHTML=ss,Bi=o(),Ee=s("ul"),Ee.innerHTML=ns,Ki=o(),Ii=s("hr"),qi=o(),Oe=s("a"),Ni=o(),p(Ue.$$.fragment),ki=o(),Be=s("p"),Be.innerHTML=rs,Si=o(),Ke=s("ul"),Ke.innerHTML=us,Ji=o(),Di=s("hr"),zi=o(),Ie=s("a"),Wi=o(),p(qe.$$.fragment),Vi=o(),Ne=s("p"),Ne.innerHTML=as,Yi=o(),ke=s("table"),ke.innerHTML=ps,Gi=o(),Qi=s("hr"),Xi=o(),Se=s("a"),Zi=o(),p(Je.$$.fragment),eo=o(),De=s("p"),De.textContent=cs,to=o(),ze=s("p"),ze.innerHTML=fs,lo=o(),We=s("table"),We.innerHTML=hs,io=o(),oo=s("hr"),so=o(),Ve=s("a"),no=o(),p(Ye.$$.fragment),ro=o(),Ge=s("p"),Ge.textContent=ms,uo=o(),Qe=s("p"),Qe.innerHTML=bs,ao=o(),Xe=s("table"),Xe.innerHTML=_s,po=o(),co=s("hr"),fo=o(),Ze=s("a"),ho=o(),p(et.$$.fragment),mo=o(),tt=s("p"),tt.textContent=$s,bo=o(),lt=s("p"),lt.innerHTML=gs,_o=o(),$o=s("hr"),go=o(),it=s("a"),To=o(),p(ot.$$.fragment),vo=o(),dt=s("p"),dt.textContent=Ts,yo=o(),st=s("p"),st.innerHTML=vs,Po=o(),nt=s("table"),nt.innerHTML=ys,Mo=o(),Ro=s("hr"),Co=o(),rt=s("a"),Ho=o(),p(ut.$$.fragment),Lo=o(),at=s("p"),at.textContent=Ps,Fo=o(),pt=s("p"),pt.innerHTML=Ms,xo=o(),ct=s("ul"),ct.innerHTML=Rs,wo=o(),ft=s("table"),ft.innerHTML=Cs,Ao=o(),jo=s("hr"),Eo=o(),ht=s("a"),Oo=o(),p(mt.$$.fragment),Uo=o(),bt=s("p"),bt.innerHTML=Hs,Bo=o(),_t=s("table"),_t.innerHTML=Ls,Ko=o(),Io=s("hr"),qo=o(),$t=s("a"),No=o(),p(gt.$$.fragment),ko=o(),Tt=s("p"),Tt.textContent=Fs,So=o(),vt=s("p"),vt.innerHTML=xs,Jo=o(),yt=s("table"),yt.innerHTML=ws,Do=o(),zo=s("hr"),Wo=o(),Pt=s("a"),Vo=o(),p(Mt.$$.fragment),Yo=o(),Rt=s("p"),Rt.textContent=As,Go=o(),Ct=s("p"),Ct.innerHTML=js,Qo=o(),Ht=s("table"),Ht.innerHTML=Es,Xo=o(),Zo=s("hr"),ed=o(),Lt=s("a"),td=o(),p(Ft.$$.fragment),ld=o(),xt=s("p"),xt.textContent=Os,id=o(),wt=s("p"),wt.innerHTML=Us,od=o(),At=s("table"),At.innerHTML=Bs,dd=o(),sd=s("hr"),nd=o(),jt=s("a"),rd=o(),p(Et.$$.fragment),ud=o(),Ot=s("p"),Ot.textContent=Ks,ad=o(),Ut=s("p"),Ut.innerHTML=Is,pd=o(),Bt=s("table"),Bt.innerHTML=qs,cd=o(),fd=s("hr"),hd=o(),Kt=s("a"),md=o(),p(It.$$.fragment),bd=o(),qt=s("p"),qt.textContent=Ns,_d=o(),Nt=s("p"),Nt.innerHTML=ks,$d=o(),gd=s("hr"),Td=o(),p(kt.$$.fragment),vd=o(),Jt=s("p"),this.h()},l(e){const t=Vs("svelte-u9bgzb",document.head);$=n(t,"META",{name:!0,content:!0}),t.forEach(l),Dt=d(e),St=n(e,"P",{}),a(St).forEach(l),zt=d(e),g=n(e,"A",{id:!0,class:!0}),a(g).forEach(l),Wt=d(e),c(T.$$.fragment,e),Vt=d(e),v=n(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1jxl61c"&&(v.innerHTML=Md),Yt=d(e),y=n(e,"UL",{"data-svelte-h":!0}),r(y)!=="svelte-dqpf7s"&&(y.innerHTML=Rd),Gt=d(e),Qt=n(e,"HR",{}),Xt=d(e),P=n(e,"A",{id:!0,class:!0}),a(P).forEach(l),Zt=d(e),c(M.$$.fragment,e),el=d(e),R=n(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-10mshiw"&&(R.textContent=Cd),tl=d(e),C=n(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1jj7eze"&&(C.innerHTML=Hd),ll=d(e),H=n(e,"TABLE",{"data-svelte-h":!0}),r(H)!=="svelte-pbwhgs"&&(H.innerHTML=Ld),il=d(e),ol=n(e,"HR",{}),dl=d(e),L=n(e,"A",{id:!0,class:!0}),a(L).forEach(l),sl=d(e),c(F.$$.fragment,e),nl=d(e),x=n(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1l3bjq3"&&(x.innerHTML=Fd),rl=d(e),w=n(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-11sljb4"&&(w.innerHTML=xd),ul=d(e),A=n(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-jl6z4b"&&(A.innerHTML=wd),al=d(e),j=n(e,"TABLE",{"data-svelte-h":!0}),r(j)!=="svelte-1o6u9nv"&&(j.innerHTML=Ad),pl=d(e),E=n(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-zelbw8"&&(E.innerHTML=jd),cl=d(e),fl=n(e,"HR",{}),hl=d(e),O=n(e,"A",{id:!0,class:!0}),a(O).forEach(l),ml=d(e),c(U.$$.fragment,e),bl=d(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ys3w38"&&(B.innerHTML=Ed),_l=d(e),$l=n(e,"HR",{}),gl=d(e),K=n(e,"A",{id:!0,class:!0}),a(K).forEach(l),Tl=d(e),c(I.$$.fragment,e),vl=d(e),q=n(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ys3w38"&&(q.innerHTML=Od),yl=d(e),Pl=n(e,"HR",{}),Ml=d(e),N=n(e,"A",{id:!0,class:!0}),a(N).forEach(l),Rl=d(e),c(k.$$.fragment,e),Cl=d(e),S=n(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1ys3w38"&&(S.innerHTML=Ud),Hl=d(e),Ll=n(e,"HR",{}),Fl=d(e),J=n(e,"A",{id:!0,class:!0}),a(J).forEach(l),xl=d(e),c(D.$$.fragment,e),wl=d(e),z=n(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1eej6dp"&&(z.innerHTML=Bd),Al=d(e),jl=n(e,"HR",{}),El=d(e),W=n(e,"A",{id:!0,class:!0}),a(W).forEach(l),Ol=d(e),c(V.$$.fragment,e),Ul=d(e),Y=n(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1en2wh4"&&(Y.textContent=Kd),Bl=d(e),G=n(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1l5qo0i"&&(G.innerHTML=Id),Kl=d(e),Q=n(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-jl6z4b"&&(Q.innerHTML=qd),Il=d(e),X=n(e,"TABLE",{"data-svelte-h":!0}),r(X)!=="svelte-1iel3tk"&&(X.innerHTML=Nd),ql=d(e),Nl=n(e,"HR",{}),kl=d(e),Z=n(e,"A",{id:!0,class:!0}),a(Z).forEach(l),Sl=d(e),c(ee.$$.fragment,e),Jl=d(e),te=n(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-16uuos4"&&(te.innerHTML=kd),Dl=d(e),le=n(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-olh855"&&(le.innerHTML=Sd),zl=d(e),Wl=n(e,"HR",{}),Vl=d(e),ie=n(e,"A",{id:!0,class:!0}),a(ie).forEach(l),Yl=d(e),c(oe.$$.fragment,e),Gl=d(e),de=n(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-zzl0lp"&&(de.innerHTML=Jd),Ql=d(e),se=n(e,"TABLE",{"data-svelte-h":!0}),r(se)!=="svelte-1y2k5ta"&&(se.innerHTML=Dd),Xl=d(e),Zl=n(e,"HR",{}),ei=d(e),ne=n(e,"A",{id:!0,class:!0}),a(ne).forEach(l),ti=d(e),c(re.$$.fragment,e),li=d(e),ue=n(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1u1tjx3"&&(ue.textContent=zd),ii=d(e),ae=n(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1sowe6d"&&(ae.innerHTML=Wd),oi=d(e),di=n(e,"HR",{}),si=d(e),pe=n(e,"A",{id:!0,class:!0}),a(pe).forEach(l),ni=d(e),c(ce.$$.fragment,e),ri=d(e),fe=n(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-d8j2xp"&&(fe.textContent=Vd),ui=d(e),he=n(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-8jlahc"&&(he.innerHTML=Yd),ai=d(e),pi=n(e,"HR",{}),ci=d(e),me=n(e,"A",{id:!0,class:!0}),a(me).forEach(l),fi=d(e),c(be.$$.fragment,e),hi=d(e),_e=n(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1a8fecx"&&(_e.textContent=Gd),mi=d(e),$e=n(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-v2f2ae"&&($e.innerHTML=Qd),bi=d(e),ge=n(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-1f4f3jw"&&(ge.innerHTML=Xd),_i=d(e),$i=n(e,"HR",{}),gi=d(e),Te=n(e,"A",{id:!0,class:!0}),a(Te).forEach(l),Ti=d(e),c(ve.$$.fragment,e),vi=d(e),ye=n(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-h3zv97"&&(ye.textContent=Zd),yi=d(e),Pe=n(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1e723py"&&(Pe.innerHTML=es),Pi=d(e),Me=n(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-1f4f3jw"&&(Me.innerHTML=ts),Mi=d(e),Ri=n(e,"HR",{}),Ci=d(e),Re=n(e,"A",{id:!0,class:!0}),a(Re).forEach(l),Hi=d(e),c(Ce.$$.fragment,e),Li=d(e),He=n(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-jd4zuh"&&(He.textContent=ls),Fi=d(e),Le=n(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1ozy582"&&(Le.innerHTML=is),xi=d(e),Fe=n(e,"UL",{"data-svelte-h":!0}),r(Fe)!=="svelte-1f4f3jw"&&(Fe.innerHTML=os),wi=d(e),Ai=n(e,"HR",{}),ji=d(e),xe=n(e,"A",{id:!0,class:!0}),a(xe).forEach(l),Ei=d(e),c(we.$$.fragment,e),Oi=d(e),Ae=n(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-cd4397"&&(Ae.textContent=ds),Ui=d(e),je=n(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-j83voe"&&(je.innerHTML=ss),Bi=d(e),Ee=n(e,"UL",{"data-svelte-h":!0}),r(Ee)!=="svelte-1f4f3jw"&&(Ee.innerHTML=ns),Ki=d(e),Ii=n(e,"HR",{}),qi=d(e),Oe=n(e,"A",{id:!0,class:!0}),a(Oe).forEach(l),Ni=d(e),c(Ue.$$.fragment,e),ki=d(e),Be=n(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-16uuos4"&&(Be.innerHTML=rs),Si=d(e),Ke=n(e,"UL",{"data-svelte-h":!0}),r(Ke)!=="svelte-136j1yr"&&(Ke.innerHTML=us),Ji=d(e),Di=n(e,"HR",{}),zi=d(e),Ie=n(e,"A",{id:!0,class:!0}),a(Ie).forEach(l),Wi=d(e),c(qe.$$.fragment,e),Vi=d(e),Ne=n(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-pake4r"&&(Ne.innerHTML=as),Yi=d(e),ke=n(e,"TABLE",{"data-svelte-h":!0}),r(ke)!=="svelte-f03x1m"&&(ke.innerHTML=ps),Gi=d(e),Qi=n(e,"HR",{}),Xi=d(e),Se=n(e,"A",{id:!0,class:!0}),a(Se).forEach(l),Zi=d(e),c(Je.$$.fragment,e),eo=d(e),De=n(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-13oc2rp"&&(De.textContent=cs),to=d(e),ze=n(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1wxlxpn"&&(ze.innerHTML=fs),lo=d(e),We=n(e,"TABLE",{"data-svelte-h":!0}),r(We)!=="svelte-2kmk06"&&(We.innerHTML=hs),io=d(e),oo=n(e,"HR",{}),so=d(e),Ve=n(e,"A",{id:!0,class:!0}),a(Ve).forEach(l),no=d(e),c(Ye.$$.fragment,e),ro=d(e),Ge=n(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-bwoz3v"&&(Ge.textContent=ms),uo=d(e),Qe=n(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1wxlxpn"&&(Qe.innerHTML=bs),ao=d(e),Xe=n(e,"TABLE",{"data-svelte-h":!0}),r(Xe)!=="svelte-yj5tj6"&&(Xe.innerHTML=_s),po=d(e),co=n(e,"HR",{}),fo=d(e),Ze=n(e,"A",{id:!0,class:!0}),a(Ze).forEach(l),ho=d(e),c(et.$$.fragment,e),mo=d(e),tt=n(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-15u13r6"&&(tt.textContent=$s),bo=d(e),lt=n(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1tftvai"&&(lt.innerHTML=gs),_o=d(e),$o=n(e,"HR",{}),go=d(e),it=n(e,"A",{id:!0,class:!0}),a(it).forEach(l),To=d(e),c(ot.$$.fragment,e),vo=d(e),dt=n(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-fkm19c"&&(dt.textContent=Ts),yo=d(e),st=n(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-xyh2rt"&&(st.innerHTML=vs),Po=d(e),nt=n(e,"TABLE",{"data-svelte-h":!0}),r(nt)!=="svelte-mnoe75"&&(nt.innerHTML=ys),Mo=d(e),Ro=n(e,"HR",{}),Co=d(e),rt=n(e,"A",{id:!0,class:!0}),a(rt).forEach(l),Ho=d(e),c(ut.$$.fragment,e),Lo=d(e),at=n(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-112gzs0"&&(at.textContent=Ps),Fo=d(e),pt=n(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-9i72aw"&&(pt.innerHTML=Ms),xo=d(e),ct=n(e,"UL",{"data-svelte-h":!0}),r(ct)!=="svelte-w7pu3"&&(ct.innerHTML=Rs),wo=d(e),ft=n(e,"TABLE",{"data-svelte-h":!0}),r(ft)!=="svelte-bpbhxc"&&(ft.innerHTML=Cs),Ao=d(e),jo=n(e,"HR",{}),Eo=d(e),ht=n(e,"A",{id:!0,class:!0}),a(ht).forEach(l),Oo=d(e),c(mt.$$.fragment,e),Uo=d(e),bt=n(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1h1o1yf"&&(bt.innerHTML=Hs),Bo=d(e),_t=n(e,"TABLE",{"data-svelte-h":!0}),r(_t)!=="svelte-17sk6uf"&&(_t.innerHTML=Ls),Ko=d(e),Io=n(e,"HR",{}),qo=d(e),$t=n(e,"A",{id:!0,class:!0}),a($t).forEach(l),No=d(e),c(gt.$$.fragment,e),ko=d(e),Tt=n(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1tqccie"&&(Tt.textContent=Fs),So=d(e),vt=n(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-dyyw29"&&(vt.innerHTML=xs),Jo=d(e),yt=n(e,"TABLE",{"data-svelte-h":!0}),r(yt)!=="svelte-13fau3m"&&(yt.innerHTML=ws),Do=d(e),zo=n(e,"HR",{}),Wo=d(e),Pt=n(e,"A",{id:!0,class:!0}),a(Pt).forEach(l),Vo=d(e),c(Mt.$$.fragment,e),Yo=d(e),Rt=n(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-7vbcne"&&(Rt.textContent=As),Go=d(e),Ct=n(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-wjfx67"&&(Ct.innerHTML=js),Qo=d(e),Ht=n(e,"TABLE",{"data-svelte-h":!0}),r(Ht)!=="svelte-61qi9d"&&(Ht.innerHTML=Es),Xo=d(e),Zo=n(e,"HR",{}),ed=d(e),Lt=n(e,"A",{id:!0,class:!0}),a(Lt).forEach(l),td=d(e),c(Ft.$$.fragment,e),ld=d(e),xt=n(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1oi15lr"&&(xt.textContent=Os),id=d(e),wt=n(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-121rdz"&&(wt.innerHTML=Us),od=d(e),At=n(e,"TABLE",{"data-svelte-h":!0}),r(At)!=="svelte-lhkacd"&&(At.innerHTML=Bs),dd=d(e),sd=n(e,"HR",{}),nd=d(e),jt=n(e,"A",{id:!0,class:!0}),a(jt).forEach(l),rd=d(e),c(Et.$$.fragment,e),ud=d(e),Ot=n(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-1oi15lr"&&(Ot.textContent=Ks),ad=d(e),Ut=n(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-121rdz"&&(Ut.innerHTML=Is),pd=d(e),Bt=n(e,"TABLE",{"data-svelte-h":!0}),r(Bt)!=="svelte-k5ce7a"&&(Bt.innerHTML=qs),cd=d(e),fd=n(e,"HR",{}),hd=d(e),Kt=n(e,"A",{id:!0,class:!0}),a(Kt).forEach(l),md=d(e),c(It.$$.fragment,e),bd=d(e),qt=n(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-1oi15lr"&&(qt.textContent=Ns),_d=d(e),Nt=n(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-ghvp2p"&&(Nt.innerHTML=ks),$d=d(e),gd=n(e,"HR",{}),Td=d(e),c(kt.$$.fragment,e),vd=d(e),Jt=n(e,"P",{}),a(Jt).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",Xs),u(g,"id","module_utils/hub"),u(g,"class","group"),u(P,"id","module_utils/hub.getFile"),u(P,"class","group"),u(L,"id","module_utils/hub.getModelFile"),u(L,"class","group"),u(O,"id","module_utils/hub.getModelFile..cacheKey"),u(O,"class","group"),u(K,"id","module_utils/hub.getModelFile..response"),u(K,"class","group"),u(N,"id","module_utils/hub.getModelFile..buffer"),u(N,"class","group"),u(J,"id","module_utils/hub.getModelFile..progressInfo"),u(J,"class","group"),u(W,"id","module_utils/hub.getModelJSON"),u(W,"class","group"),u(Z,"id","module_utils/hub..FileResponse"),u(Z,"class","group"),u(ie,"id","new_module_utils/hub..FileResponse_new"),u(ie,"class","group"),u(ne,"id","module_utils/hub..FileResponse+updateContentType"),u(ne,"class","group"),u(pe,"id","module_utils/hub..FileResponse+clone"),u(pe,"class","group"),u(me,"id","module_utils/hub..FileResponse+arrayBuffer"),u(me,"class","group"),u(Te,"id","module_utils/hub..FileResponse+blob"),u(Te,"class","group"),u(Re,"id","module_utils/hub..FileResponse+text"),u(Re,"class","group"),u(xe,"id","module_utils/hub..FileResponse+json"),u(xe,"class","group"),u(Oe,"id","module_utils/hub..FileCache"),u(Oe,"class","group"),u(Ie,"id","new_module_utils/hub..FileCache_new"),u(Ie,"class","group"),u(Se,"id","module_utils/hub..FileCache+match"),u(Se,"class","group"),u(Ve,"id","module_utils/hub..FileCache+put"),u(Ve,"class","group"),u(Ze,"id","module_utils/hub..CONTENT_TYPE_MAP"),u(Ze,"class","group"),u(it,"id","module_utils/hub..isValidUrl"),u(it,"class","group"),u(rt,"id","module_utils/hub..handleError"),u(rt,"class","group"),u(ht,"id","module_utils/hub..tryCache"),u(ht,"class","group"),u($t,"id","module_utils/hub..readResponse"),u($t,"class","group"),u(Pt,"id","module_utils/hub..pathJoin"),u(Pt,"class","group"),u(Lt,"id","module_utils/hub..PretrainedOptions"),u(Lt,"class","group"),u(jt,"id","module_utils/hub..ModelSpecificPretrainedOptions"),u(jt,"class","group"),u(Kt,"id","module_utils/hub..PretrainedModelOptions"),u(Kt,"class","group")},m(e,t){Ys(document.head,$),i(e,Dt,t),i(e,St,t),i(e,zt,t),i(e,g,t),i(e,Wt,t),f(T,e,t),i(e,Vt,t),i(e,v,t),i(e,Yt,t),i(e,y,t),i(e,Gt,t),i(e,Qt,t),i(e,Xt,t),i(e,P,t),i(e,Zt,t),f(M,e,t),i(e,el,t),i(e,R,t),i(e,tl,t),i(e,C,t),i(e,ll,t),i(e,H,t),i(e,il,t),i(e,ol,t),i(e,dl,t),i(e,L,t),i(e,sl,t),f(F,e,t),i(e,nl,t),i(e,x,t),i(e,rl,t),i(e,w,t),i(e,ul,t),i(e,A,t),i(e,al,t),i(e,j,t),i(e,pl,t),i(e,E,t),i(e,cl,t),i(e,fl,t),i(e,hl,t),i(e,O,t),i(e,ml,t),f(U,e,t),i(e,bl,t),i(e,B,t),i(e,_l,t),i(e,$l,t),i(e,gl,t),i(e,K,t),i(e,Tl,t),f(I,e,t),i(e,vl,t),i(e,q,t),i(e,yl,t),i(e,Pl,t),i(e,Ml,t),i(e,N,t),i(e,Rl,t),f(k,e,t),i(e,Cl,t),i(e,S,t),i(e,Hl,t),i(e,Ll,t),i(e,Fl,t),i(e,J,t),i(e,xl,t),f(D,e,t),i(e,wl,t),i(e,z,t),i(e,Al,t),i(e,jl,t),i(e,El,t),i(e,W,t),i(e,Ol,t),f(V,e,t),i(e,Ul,t),i(e,Y,t),i(e,Bl,t),i(e,G,t),i(e,Kl,t),i(e,Q,t),i(e,Il,t),i(e,X,t),i(e,ql,t),i(e,Nl,t),i(e,kl,t),i(e,Z,t),i(e,Sl,t),f(ee,e,t),i(e,Jl,t),i(e,te,t),i(e,Dl,t),i(e,le,t),i(e,zl,t),i(e,Wl,t),i(e,Vl,t),i(e,ie,t),i(e,Yl,t),f(oe,e,t),i(e,Gl,t),i(e,de,t),i(e,Ql,t),i(e,se,t),i(e,Xl,t),i(e,Zl,t),i(e,ei,t),i(e,ne,t),i(e,ti,t),f(re,e,t),i(e,li,t),i(e,ue,t),i(e,ii,t),i(e,ae,t),i(e,oi,t),i(e,di,t),i(e,si,t),i(e,pe,t),i(e,ni,t),f(ce,e,t),i(e,ri,t),i(e,fe,t),i(e,ui,t),i(e,he,t),i(e,ai,t),i(e,pi,t),i(e,ci,t),i(e,me,t),i(e,fi,t),f(be,e,t),i(e,hi,t),i(e,_e,t),i(e,mi,t),i(e,$e,t),i(e,bi,t),i(e,ge,t),i(e,_i,t),i(e,$i,t),i(e,gi,t),i(e,Te,t),i(e,Ti,t),f(ve,e,t),i(e,vi,t),i(e,ye,t),i(e,yi,t),i(e,Pe,t),i(e,Pi,t),i(e,Me,t),i(e,Mi,t),i(e,Ri,t),i(e,Ci,t),i(e,Re,t),i(e,Hi,t),f(Ce,e,t),i(e,Li,t),i(e,He,t),i(e,Fi,t),i(e,Le,t),i(e,xi,t),i(e,Fe,t),i(e,wi,t),i(e,Ai,t),i(e,ji,t),i(e,xe,t),i(e,Ei,t),f(we,e,t),i(e,Oi,t),i(e,Ae,t),i(e,Ui,t),i(e,je,t),i(e,Bi,t),i(e,Ee,t),i(e,Ki,t),i(e,Ii,t),i(e,qi,t),i(e,Oe,t),i(e,Ni,t),f(Ue,e,t),i(e,ki,t),i(e,Be,t),i(e,Si,t),i(e,Ke,t),i(e,Ji,t),i(e,Di,t),i(e,zi,t),i(e,Ie,t),i(e,Wi,t),f(qe,e,t),i(e,Vi,t),i(e,Ne,t),i(e,Yi,t),i(e,ke,t),i(e,Gi,t),i(e,Qi,t),i(e,Xi,t),i(e,Se,t),i(e,Zi,t),f(Je,e,t),i(e,eo,t),i(e,De,t),i(e,to,t),i(e,ze,t),i(e,lo,t),i(e,We,t),i(e,io,t),i(e,oo,t),i(e,so,t),i(e,Ve,t),i(e,no,t),f(Ye,e,t),i(e,ro,t),i(e,Ge,t),i(e,uo,t),i(e,Qe,t),i(e,ao,t),i(e,Xe,t),i(e,po,t),i(e,co,t),i(e,fo,t),i(e,Ze,t),i(e,ho,t),f(et,e,t),i(e,mo,t),i(e,tt,t),i(e,bo,t),i(e,lt,t),i(e,_o,t),i(e,$o,t),i(e,go,t),i(e,it,t),i(e,To,t),f(ot,e,t),i(e,vo,t),i(e,dt,t),i(e,yo,t),i(e,st,t),i(e,Po,t),i(e,nt,t),i(e,Mo,t),i(e,Ro,t),i(e,Co,t),i(e,rt,t),i(e,Ho,t),f(ut,e,t),i(e,Lo,t),i(e,at,t),i(e,Fo,t),i(e,pt,t),i(e,xo,t),i(e,ct,t),i(e,wo,t),i(e,ft,t),i(e,Ao,t),i(e,jo,t),i(e,Eo,t),i(e,ht,t),i(e,Oo,t),f(mt,e,t),i(e,Uo,t),i(e,bt,t),i(e,Bo,t),i(e,_t,t),i(e,Ko,t),i(e,Io,t),i(e,qo,t),i(e,$t,t),i(e,No,t),f(gt,e,t),i(e,ko,t),i(e,Tt,t),i(e,So,t),i(e,vt,t),i(e,Jo,t),i(e,yt,t),i(e,Do,t),i(e,zo,t),i(e,Wo,t),i(e,Pt,t),i(e,Vo,t),f(Mt,e,t),i(e,Yo,t),i(e,Rt,t),i(e,Go,t),i(e,Ct,t),i(e,Qo,t),i(e,Ht,t),i(e,Xo,t),i(e,Zo,t),i(e,ed,t),i(e,Lt,t),i(e,td,t),f(Ft,e,t),i(e,ld,t),i(e,xt,t),i(e,id,t),i(e,wt,t),i(e,od,t),i(e,At,t),i(e,dd,t),i(e,sd,t),i(e,nd,t),i(e,jt,t),i(e,rd,t),f(Et,e,t),i(e,ud,t),i(e,Ot,t),i(e,ad,t),i(e,Ut,t),i(e,pd,t),i(e,Bt,t),i(e,cd,t),i(e,fd,t),i(e,hd,t),i(e,Kt,t),i(e,md,t),f(It,e,t),i(e,bd,t),i(e,qt,t),i(e,_d,t),i(e,Nt,t),i(e,$d,t),i(e,gd,t),i(e,Td,t),f(kt,e,t),i(e,vd,t),i(e,Jt,t),yd=!0},p:Js,i(e){yd||(h(T.$$.fragment,e),h(M.$$.fragment,e),h(F.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h(k.$$.fragment,e),h(D.$$.fragment,e),h(V.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(Ce.$$.fragment,e),h(we.$$.fragment,e),h(Ue.$$.fragment,e),h(qe.$$.fragment,e),h(Je.$$.fragment,e),h(Ye.$$.fragment,e),h(et.$$.fragment,e),h(ot.$$.fragment,e),h(ut.$$.fragment,e),h(mt.$$.fragment,e),h(gt.$$.fragment,e),h(Mt.$$.fragment,e),h(Ft.$$.fragment,e),h(Et.$$.fragment,e),h(It.$$.fragment,e),h(kt.$$.fragment,e),yd=!0)},o(e){m(T.$$.fragment,e),m(M.$$.fragment,e),m(F.$$.fragment,e),m(U.$$.fragment,e),m(I.$$.fragment,e),m(k.$$.fragment,e),m(D.$$.fragment,e),m(V.$$.fragment,e),m(ee.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(be.$$.fragment,e),m(ve.$$.fragment,e),m(Ce.$$.fragment,e),m(we.$$.fragment,e),m(Ue.$$.fragment,e),m(qe.$$.fragment,e),m(Je.$$.fragment,e),m(Ye.$$.fragment,e),m(et.$$.fragment,e),m(ot.$$.fragment,e),m(ut.$$.fragment,e),m(mt.$$.fragment,e),m(gt.$$.fragment,e),m(Mt.$$.fragment,e),m(Ft.$$.fragment,e),m(Et.$$.fragment,e),m(It.$$.fragment,e),m(kt.$$.fragment,e),yd=!1},d(e){e&&(l(Dt),l(St),l(zt),l(g),l(Wt),l(Vt),l(v),l(Yt),l(y),l(Gt),l(Qt),l(Xt),l(P),l(Zt),l(el),l(R),l(tl),l(C),l(ll),l(H),l(il),l(ol),l(dl),l(L),l(sl),l(nl),l(x),l(rl),l(w),l(ul),l(A),l(al),l(j),l(pl),l(E),l(cl),l(fl),l(hl),l(O),l(ml),l(bl),l(B),l(_l),l($l),l(gl),l(K),l(Tl),l(vl),l(q),l(yl),l(Pl),l(Ml),l(N),l(Rl),l(Cl),l(S),l(Hl),l(Ll),l(Fl),l(J),l(xl),l(wl),l(z),l(Al),l(jl),l(El),l(W),l(Ol),l(Ul),l(Y),l(Bl),l(G),l(Kl),l(Q),l(Il),l(X),l(ql),l(Nl),l(kl),l(Z),l(Sl),l(Jl),l(te),l(Dl),l(le),l(zl),l(Wl),l(Vl),l(ie),l(Yl),l(Gl),l(de),l(Ql),l(se),l(Xl),l(Zl),l(ei),l(ne),l(ti),l(li),l(ue),l(ii),l(ae),l(oi),l(di),l(si),l(pe),l(ni),l(ri),l(fe),l(ui),l(he),l(ai),l(pi),l(ci),l(me),l(fi),l(hi),l(_e),l(mi),l($e),l(bi),l(ge),l(_i),l($i),l(gi),l(Te),l(Ti),l(vi),l(ye),l(yi),l(Pe),l(Pi),l(Me),l(Mi),l(Ri),l(Ci),l(Re),l(Hi),l(Li),l(He),l(Fi),l(Le),l(xi),l(Fe),l(wi),l(Ai),l(ji),l(xe),l(Ei),l(Oi),l(Ae),l(Ui),l(je),l(Bi),l(Ee),l(Ki),l(Ii),l(qi),l(Oe),l(Ni),l(ki),l(Be),l(Si),l(Ke),l(Ji),l(Di),l(zi),l(Ie),l(Wi),l(Vi),l(Ne),l(Yi),l(ke),l(Gi),l(Qi),l(Xi),l(Se),l(Zi),l(eo),l(De),l(to),l(ze),l(lo),l(We),l(io),l(oo),l(so),l(Ve),l(no),l(ro),l(Ge),l(uo),l(Qe),l(ao),l(Xe),l(po),l(co),l(fo),l(Ze),l(ho),l(mo),l(tt),l(bo),l(lt),l(_o),l($o),l(go),l(it),l(To),l(vo),l(dt),l(yo),l(st),l(Po),l(nt),l(Mo),l(Ro),l(Co),l(rt),l(Ho),l(Lo),l(at),l(Fo),l(pt),l(xo),l(ct),l(wo),l(ft),l(Ao),l(jo),l(Eo),l(ht),l(Oo),l(Uo),l(bt),l(Bo),l(_t),l(Ko),l(Io),l(qo),l($t),l(No),l(ko),l(Tt),l(So),l(vt),l(Jo),l(yt),l(Do),l(zo),l(Wo),l(Pt),l(Vo),l(Yo),l(Rt),l(Go),l(Ct),l(Qo),l(Ht),l(Xo),l(Zo),l(ed),l(Lt),l(td),l(ld),l(xt),l(id),l(wt),l(od),l(At),l(dd),l(sd),l(nd),l(jt),l(rd),l(ud),l(Ot),l(ad),l(Ut),l(pd),l(Bt),l(cd),l(fd),l(hd),l(Kt),l(md),l(bd),l(qt),l(_d),l(Nt),l($d),l(gd),l(Td),l(vd),l(Jt)),l($),b(T,e),b(M,e),b(F,e),b(U,e),b(I,e),b(k,e),b(D,e),b(V,e),b(ee,e),b(oe,e),b(re,e),b(ce,e),b(be,e),b(ve,e),b(Ce,e),b(we,e),b(Ue,e),b(qe,e),b(Je,e),b(Ye,e),b(et,e),b(ot,e),b(ut,e),b(mt,e),b(gt,e),b(Mt,e),b(Ft,e),b(Et,e),b(It,e),b(kt,e)}}}const Xs='{"title":"utils/hub","local":"utilshub","sections":[{"title":"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>","local":"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code","sections":[],"depth":2},{"title":"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options]) ⇒ <code> Promise. < Uint8Array > </code>","local":"utilshubgetmodelfilepathorrepoid-filename-fatal-options--code-promise--uint8array--code","sections":[{"title":"getModelFile~cacheKey : <code> string </code>","local":"getmodelfilecachekey--code-string-code","sections":[],"depth":3},{"title":"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>","local":"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code","sections":[],"depth":3},{"title":"getModelFile~buffer : <code> Uint8Array </code>","local":"getmodelfilebuffer--code-uint8array-code","sections":[],"depth":3},{"title":"getModelFile~progressInfo : <code> * </code>","local":"getmodelfileprogressinfo--code--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>","local":"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code","sections":[],"depth":2},{"title":"utils/hub~FileResponse","local":"utilshubfileresponse","sections":[{"title":"new FileResponse(filePath)","local":"new-fileresponsefilepath","sections":[],"depth":3},{"title":"fileResponse.updateContentType() ⇒ <code> void </code>","local":"fileresponseupdatecontenttype--code-void-code","sections":[],"depth":3},{"title":"fileResponse.clone() ⇒ <code> FileResponse </code>","local":"fileresponseclone--code-fileresponse-code","sections":[],"depth":3},{"title":"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>","local":"fileresponsearraybuffer--code-promise--arraybuffer--code","sections":[],"depth":3},{"title":"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>","local":"fileresponseblob--code-promise--blob--code","sections":[],"depth":3},{"title":"fileResponse.text() ⇒ <code> Promise. < string > </code>","local":"fileresponsetext--code-promise--string--code","sections":[],"depth":3},{"title":"fileResponse.json() ⇒ <code> Promise. < Object > </code>","local":"fileresponsejson--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~FileCache","local":"utilshubfilecache","sections":[{"title":"new FileCache(path)","local":"new-filecachepath","sections":[],"depth":3},{"title":"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>","local":"filecachematchrequest--code-promise--fileresponseundefined--code","sections":[],"depth":3},{"title":"fileCache.put(request, response) ⇒ <code> Promise. < void > </code>","local":"filecacheputrequest-response--code-promise--void--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~CONTENT_TYPE_MAP","local":"utilshubcontenttypemap","sections":[],"depth":2},{"title":"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>","local":"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code","sections":[],"depth":2},{"title":"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>","local":"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code","sections":[],"depth":2},{"title":"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>","local":"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code","sections":[],"depth":2},{"title":"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>","local":"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code","sections":[],"depth":2},{"title":"utils/hub~pathJoin(...parts) ⇒ <code> string </code>","local":"utilshubpathjoinparts--code-string-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedOptions : <code> Object </code>","local":"utilshubpretrainedoptions--code-object-code","sections":[],"depth":2},{"title":"utils/hub~ModelSpecificPretrainedOptions : <code> Object </code>","local":"utilshubmodelspecificpretrainedoptions--code-object-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedModelOptions : <code> * </code>","local":"utilshubpretrainedmodeloptions--code--code","sections":[],"depth":2}],"depth":1}';function Zs(Pd){return Ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class on extends zs{constructor($){super(),Ws(this,$,Zs,Qs,Ss,{})}}export{on as component};
