import{s as Qt,o as Yt,n as Ht}from"../chunks/scheduler.0219f8bd.js";import{S as St,i as Rt,g as i,s as n,r,A as At,h as o,f as s,c as l,j as Wt,u as p,x as g,k as Ft,y as Lt,a,v as d,d as c,t as h,w as f}from"../chunks/index.f61edf3b.js";import{T as Xt}from"../chunks/Tip.5d1e3ef4.js";import{C as M}from"../chunks/CodeBlock.38e566ae.js";import{H as w,E as Et}from"../chunks/EditOnGithub.48fa589f.js";function zt(ge){let m,y='For the full list of available tasks/pipelines, check out <a href="#available-tasks">this table</a>.';return{c(){m=i("p"),m.innerHTML=y},l(u){m=o(u,"P",{"data-svelte-h":!0}),g(m)!=="svelte-gomgj3"&&(m.innerHTML=y)},m(u,b){a(u,m,b)},p:Ht,d(u){u&&s(m)}}}function Pt(ge){let m,y='By default, models will be downloaded from the <a href="https://huggingface.co/models" rel="nofollow">Hugging Face Hub</a> and stored in <a href="https://developer.mozilla.org/en-US/docs/Web/API/Cache" rel="nofollow">browser cache</a>, but there are ways to specify custom models and cache locations. For more information see <a href="./custom_usage">here</a>.';return{c(){m=i("p"),m.innerHTML=y},l(u){m=o(u,"P",{"data-svelte-h":!0}),g(m)!=="svelte-197t2db"&&(m.innerHTML=y)},m(u,b){a(u,m,b)},p:Ht,d(u){u&&s(m)}}}function Vt(ge){let m,y,u,b,T,we,U,ht='Just like the <a href="https://github.com/huggingface/transformers" rel="nofollow">transformers Python library</a>, Transformers.js provides users with a simple way to leverage the power of transformers. The <code>pipeline()</code> function is the easiest and fastest way to use a pretrained model for inference.',ye,J,Me,x,be,$,ft="Start by creating an instance of <code>pipeline()</code> and specifying a task you want to use it for. For example, to create a sentiment analysis pipeline, you can do:",Je,k,je,I,mt="When running for the first time, the <code>pipeline</code> will download and cache the default pretrained model associated with the task. This can take a while, but subsequent calls will be much faster.",Te,j,Ue,G,gt="You can now use the classifier on your target text by calling it as a function:",xe,v,$e,B,ut="If you have multiple inputs, you can pass them as an array:",ke,C,Ie,N,wt="You can also specify a different model to use for the pipeline by passing it as the second argument to the <code>pipeline()</code> function. For example, to use a different model for sentiment analysis (like one trained to predict sentiment of a review as a number of stars between 1 and 5), you can do:",Ge,Z,ve,_,yt='Transformers.js supports loading any model hosted on the Hugging Face Hub, provided it has ONNX weights (located in a subfolder called <code>onnx</code>). For more information on how to convert your PyTorch, TensorFlow, or JAX model to ONNX, see the <a href="./custom_usage#convert-your-models-to-onnx">conversion section</a>.',Be,W,Mt="The <code>pipeline()</code> function is a great way to quickly use a pretrained model for inference, as it takes care of all the preprocessing and postprocessing for you. For example, if you want to perform Automatic Speech Recognition (ASR) using OpenAI’s Whisper model, you can do:",Ce,F,Ne,X,Ze,H,_e,Q,bt=`We offer a variety of options to control how models are loaded from the Hugging Face Hub (or locally).
By default, the <em>quantized</em> version of the model is used, which is smaller and faster, but usually less accurate.
To override this behaviour (i.e., use the unquantized model), you can use a custom <code>PretrainedOptions</code> object
as the third parameter to the <code>pipeline</code> function:`,We,Y,Fe,S,Jt=`You can also specify which revision of the model to use, by passing a <code>revision</code> parameter.
Since the Hugging Face Hub uses a git-based versioning system, you can use any valid git revision specifier (e.g., branch name or commit hash)`,Xe,R,He,A,jt='For the full list of options, check out the <a href="./api/utils/hub#module_utils/hub..PretrainedOptions">PretrainedOptions</a> documentation.',Qe,L,Ye,E,Tt="Many pipelines have additional options that you can specify. For example, when using a model that does multilingual translation, you can specify the source and target languages like this:",Se,z,Re,P,Ut='When using models that support auto-regressive generation, you can specify generation parameters like the number of new tokens, sampling methods, temperature, repetition penalty, and much more. For a full list of available parameters, see to the <a href="./api/utils/generation#module_utils/generation.GenerationConfig">GenerationConfig</a> class.',Ae,V,xt="For example, to generate a poem using <code>LaMini-Flan-T5-783M</code>, you can do:",Le,D,Ee,q,$t="Logging <code>result[0].generated_text</code> to the console gives:",ze,O,Pe,K,kt=`For more information on the available options for each pipeline, refer to the <a href="./api/pipelines">API Reference</a>.
If you would like more control over the inference process, you can use the <a href="./api/models"><code>AutoModel</code></a>, <a href="./api/tokenizers"><code>AutoTokenizer</code></a>, or <a href="./api/processors"><code>AutoProcessor</code></a> classes instead.`,Ve,ee,De,te,qe,se,Oe,ae,It='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill-Mask</a></td> <td><code>fill-mask</code></td> <td>Masking some of the words in a sentence and predicting which words should replace those masks.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FillMaskPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=fill-mask&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td><code>question-answering</code></td> <td>Retrieve the answer to a question from a given text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.QuestionAnsweringPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=question-answering&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td><code>sentence-similarity</code></td> <td>Determining how similar two texts are.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=sentence-similarity&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td><code>summarization</code></td> <td>Producing a shorter version of a document while preserving its important information.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.SummarizationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=summarization&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td><code>table-question-answering</code></td> <td>Answering a question about information from a given table.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td><code>text-classification</code> or <code>sentiment-analysis</code></td> <td>Assigning a label or class to a given text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-generation#completion-generation-models" rel="nofollow">Text Generation</a></td> <td><code>text-generation</code></td> <td>Producing new text by predicting the next word in a sequence.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextGenerationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-generation#text-to-text-generation-models" rel="nofollow">Text-to-text Generation</a></td> <td><code>text2text-generation</code></td> <td>Converting one text sequence into another text sequence.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.Text2TextGenerationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text2text-generation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td><code>token-classification</code> or <code>ner</code></td> <td>Assigning a label to each token in a text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TokenClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=token-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td><code>translation</code></td> <td>Converting text from one language to another.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TranslationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=translation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero-Shot Classification</a></td> <td><code>zero-shot-classification</code></td> <td>Classifying text into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=zero-shot-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td><code>feature-extraction</code></td> <td>Transforming raw data into numerical features that can be processed while preserving the information in the original dataset.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=feature-extraction&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',Ke,ne,et,le,Gt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/depth-estimation" rel="nofollow">Depth Estimation</a></td> <td><code>depth-estimation</code></td> <td>Predicting the depth of objects present in an image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.DepthEstimationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td><code>image-classification</code></td> <td>Assigning a label or class to an entire image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td><code>image-segmentation</code></td> <td>Divides an image into segments where each pixel is mapped to an object. This task has multiple variants such as instance segmentation, panoptic segmentation and semantic segmentation.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageSegmentationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-segmentation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td><code>image-to-image</code></td> <td>Transforming a source image to match the characteristics of a target image or a target image domain.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageToImagePipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-to-image&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/mask-generation" rel="nofollow">Mask Generation</a></td> <td><code>mask-generation</code></td> <td>Generate masks for the objects in an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td><code>object-detection</code></td> <td>Identify objects of certain defined classes within an image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ObjectDetectionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=object-detection&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/video-classification" rel="nofollow">Video Classification</a></td> <td>n/a</td> <td>Assigning a label or class to an entire video.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/unconditional-image-generation" rel="nofollow">Unconditional Image Generation</a></td> <td>n/a</td> <td>Generating images with no condition in any context (like a prompt text or another image).</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/image-feature-extraction" rel="nofollow">Image Feature Extraction</a></td> <td><code>image-feature-extraction</code></td> <td>Transforming raw data into numerical features that can be processed while preserving the information in the original image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageFeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-feature-extraction&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',tt,ie,st,oe,vt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td><code>audio-classification</code></td> <td>Assigning a label or class to a given audio.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.AudioClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=audio-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/audio-to-audio" rel="nofollow">Audio-to-Audio</a></td> <td>n/a</td> <td>Generating audio from an input audio source.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td><code>automatic-speech-recognition</code></td> <td>Transcribing a given audio into text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.AutomaticSpeechRecognitionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td><code>text-to-speech</code> or <code>text-to-audio</code></td> <td>Generating natural-sounding speech given text input.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextToAudioPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-to-audio&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',at,re,nt,pe,Bt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>n/a</td> <td>Classifying a target category (a group) based on set of attributes.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>n/a</td> <td>Predicting a numerical value given a set of attributes.</td> <td>❌</td></tr></tbody>',lt,de,it,ce,Ct='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Document Question Answering</a></td> <td><code>document-question-answering</code></td> <td>Answering questions on document images.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.DocumentQuestionAnsweringPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=document-question-answering&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td><code>image-to-text</code></td> <td>Output text from a given image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageToTextPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-to-text&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td><code>text-to-image</code></td> <td>Generates images from input text.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td><code>visual-question-answering</code></td> <td>Answering open-ended questions based on an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/learn/audio-course/chapter4/classification_models#zero-shot-audio-classification" rel="nofollow">Zero-Shot Audio Classification</a></td> <td><code>zero-shot-audio-classification</code></td> <td>Classifying audios into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotAudioClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?other=zero-shot-audio-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot Image Classification</a></td> <td><code>zero-shot-image-classification</code></td> <td>Classifying images into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotImageClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-object-detection" rel="nofollow">Zero-Shot Object Detection</a></td> <td><code>zero-shot-object-detection</code></td> <td>Identify objects of classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotObjectDetectionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?other=zero-shot-object-detection&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',ot,he,rt,fe,Nt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/reinforcement-learning" rel="nofollow">Reinforcement Learning</a></td> <td>n/a</td> <td>Learning from actions by interacting with an environment through trial and error and receiving rewards (negative or positive) as feedback.</td> <td>✅</td></tr></tbody>',pt,me,dt,ue,ct;return T=new w({props:{title:"The pipeline API",local:"the-pipeline-api",headingTag:"h1"}}),J=new Xt({props:{$$slots:{default:[zt]},$$scope:{ctx:ge}}}),x=new w({props:{title:"The basics",local:"the-basics",headingTag:"h2"}}),k=new M({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWNvbnN0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcycpJTNC",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);`,wrap:!1}}),j=new Xt({props:{$$slots:{default:[Pt]},$$scope:{ctx:ge}}}),v=new M({props:{code:"Y29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzIScpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdQT1NJVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTk4JTdEJTVE",highlighted:`<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9998}]</span>`,wrap:!1}}),C=new M({props:{code:"Y29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJTVCJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzISclMkMlMjAnSSUyMGhhdGUlMjB0cmFuc2Zvcm1lcnMhJyU1RCklM0IlMEElMkYlMkYlMjAlNUIlN0InbGFiZWwnJTNBJTIwJ1BPU0lUSVZFJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5OTglN0QlMkMlMjAlN0InbGFiZWwnJTNBJTIwJ05FR0FUSVZFJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5ODIlN0QlNUQ=",highlighted:`<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>([<span class="hljs-string">&#x27;I love transformers!&#x27;</span>, <span class="hljs-string">&#x27;I hate transformers!&#x27;</span>]);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9998}, {&#x27;label&#x27;: &#x27;NEGATIVE&#x27;, &#x27;score&#x27;: 0.9982}]</span>`,wrap:!1}}),Z=new M({props:{code:"Y29uc3QlMjByZXZpZXdlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGYmVydC1iYXNlLW11bHRpbGluZ3VhbC11bmNhc2VkLXNlbnRpbWVudCcpJTNCJTBBJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHJldmlld2VyKCdUaGUlMjBTaGF3c2hhbmslMjBSZWRlbXB0aW9uJTIwaXMlMjBhJTIwdHJ1ZSUyMG1hc3RlcnBpZWNlJTIwb2YlMjBjaW5lbWEuJyklM0IlMEElMkYlMkYlMjAlNUIlN0JsYWJlbCUzQSUyMCc1JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjgxNjc5Mjk2NDkzNTMwMjclN0QlNUQ=",highlighted:`<span class="hljs-keyword">const</span> reviewer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-multilingual-uncased-sentiment&#x27;</span>);

<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">reviewer</span>(<span class="hljs-string">&#x27;The Shawshank Redemption is a true masterpiece of cinema.&#x27;</span>);
<span class="hljs-comment">// [{label: &#x27;5 stars&#x27;, score: 0.8167929649353027}]</span>`,wrap:!1}}),F=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGUlMjBhJTIwcGlwZWxpbmUlMjBmb3IlMjBBdXRvbWF0aWMlMjBTcGVlY2glMjBSZWNvZ25pdGlvbiUwQWNvbnN0JTIwdHJhbnNjcmliZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJyUyQyUyMCdYZW5vdmElMkZ3aGlzcGVyLXNtYWxsLmVuJyklM0IlMEElMEElMkYlMkYlMjBUcmFuc2NyaWJlJTIwYW4lMjBhdWRpbyUyMGZpbGUlMkMlMjBsb2FkZWQlMjBmcm9tJTIwYSUyMFVSTC4lMEFjb25zdCUyMHJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdHJhbnNjcmliZXIoJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGbWxrLmZsYWMnKSUzQiUwQSUyRiUyRiUyMCU3QnRleHQlM0ElMjAnJTIwSSUyMGhhdmUlMjBhJTIwZHJlYW0lMjB0aGF0JTIwb25lJTIwZGF5JTIwdGhpcyUyMG5hdGlvbiUyMHdpbGwlMjByaXNlJTIwdXAlMjBhbmQlMjBsaXZlJTIwb3V0JTIwdGhlJTIwdHJ1ZSUyMG1lYW5pbmclMjBvZiUyMGl0cyUyMGNyZWVkLiclN0Q=",highlighted:`<span class="hljs-comment">// Allocate a pipeline for Automatic Speech Recognition</span>
<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small.en&#x27;</span>);

<span class="hljs-comment">// Transcribe an audio file, loaded from a URL.</span>
<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>);
<span class="hljs-comment">// {text: &#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;}</span>`,wrap:!1}}),X=new w({props:{title:"Pipeline options",local:"pipeline-options",headingTag:"h2"}}),H=new w({props:{title:"Loading",local:"loading",headingTag:"h3"}}),Y=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGlvbiUyMGElMjBwaXBlbGluZSUyMGZvciUyMGZlYXR1cmUlMjBleHRyYWN0aW9uJTJDJTIwdXNpbmclMjB0aGUlMjB1bnF1YW50aXplZCUyMG1vZGVsJTBBY29uc3QlMjBwaXBlJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZhbGwtTWluaUxNLUw2LXYyJyUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1YW50aXplZCUzQSUyMGZhbHNlJTJDJTBBJTdEKSUzQg==",highlighted:`<span class="hljs-comment">// Allocation a pipeline for feature extraction, using the unquantized model</span>
<span class="hljs-keyword">const</span> pipe = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>, {
    <span class="hljs-attr">quantized</span>: <span class="hljs-literal">false</span>,
});`,wrap:!1}}),R=new M({props:{code:"Y29uc3QlMjB0cmFuc2NyaWJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2F1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24nJTJDJTIwJ1hlbm92YSUyRndoaXNwZXItdGlueS5lbiclMkMlMjAlN0IlMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzQSUyMCdvdXRwdXRfYXR0ZW50aW9ucyclMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>, {
    <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;output_attentions&#x27;</span>,
});`,wrap:!1}}),L=new w({props:{title:"Running",local:"running",headingTag:"h3"}}),z=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGlvbiUyMGElMjBwaXBlbGluZSUyMGZvciUyMHRyYW5zbGF0aW9uJTBBY29uc3QlMjB0cmFuc2xhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndHJhbnNsYXRpb24nJTJDJTIwJ1hlbm92YSUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJyklM0IlMEElMEElMkYlMkYlMjBUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR3JlZWslMEFjb25zdCUyMHJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdHJhbnNsYXRvcignSSUyMGxpa2UlMjB0byUyMHdhbGslMjBteSUyMGRvZy4nJTJDJTIwJTdCJTBBJTIwJTIwJTIwJTIwc3JjX2xhbmclM0ElMjAnZW5nX0xhdG4nJTJDJTBBJTIwJTIwJTIwJTIwdGd0X2xhbmclM0ElMjAnZWxsX0dyZWsnJTBBJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUyMCU3QiUyMHRyYW5zbGF0aW9uX3RleHQlM0ElMjAnJUNFJTlDJUNFJUJGJUNGJTg1JTIwJUNFJUIxJUNGJTgxJUNFJUFEJUNGJTgzJUNFJUI1JUNFJUI5JTIwJUNFJUJEJUNFJUIxJTIwJUNGJTgwJUNFJUI1JUNGJTgxJUNGJTgwJUNFJUIxJUNGJTg0JUNFJUFDJUNGJTg5JTIwJUNGJTg0JUNFJUJGJTIwJUNGJTgzJUNFJUJBJUNGJTg1JUNFJUJCJUNFJUFGJTIwJUNFJUJDJUNFJUJGJUNGJTg1LiclMjAlN0QlMjAlNUQlMEElMEElMkYlMkYlMjBUcmFuc2xhdGUlMjBiYWNrJTIwdG8lMjBFbmdsaXNoJTBBY29uc3QlMjByZXN1bHQyJTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKHJlc3VsdCU1QjAlNUQudHJhbnNsYXRpb25fdGV4dCUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMHNyY19sYW5nJTNBJTIwJ2VsbF9HcmVrJyUyQyUwQSUyMCUyMCUyMCUyMHRndF9sYW5nJTNBJTIwJ2VuZ19MYXRuJyUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlMjAlN0IlMjB0cmFuc2xhdGlvbl90ZXh0JTNBJTIwJ0klMjBsaWtlJTIwdG8lMjB3YWxrJTIwbXklMjBkb2cuJyUyMCU3RCUyMCU1RA==",highlighted:`<span class="hljs-comment">// Allocation a pipeline for translation</span>
<span class="hljs-keyword">const</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>);

<span class="hljs-comment">// Translate from English to Greek</span>
<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;I like to walk my dog.&#x27;</span>, {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;eng_Latn&#x27;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;ell_Grek&#x27;</span>
});
<span class="hljs-comment">// [ { translation_text: &#x27;Μου αρέσει να περπατάω το σκυλί μου.&#x27; } ]</span>

<span class="hljs-comment">// Translate back to English</span>
<span class="hljs-keyword">const</span> result2 = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(result[<span class="hljs-number">0</span>].<span class="hljs-property">translation_text</span>, {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;ell_Grek&#x27;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;eng_Latn&#x27;</span>
});
<span class="hljs-comment">// [ { translation_text: &#x27;I like to walk my dog.&#x27; } ]</span>`,wrap:!1}}),D=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGUlMjBhJTIwcGlwZWxpbmUlMjBmb3IlMjB0ZXh0MnRleHQtZ2VuZXJhdGlvbiUwQWNvbnN0JTIwcG9ldCUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQydGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZMYU1pbmktRmxhbi1UNS03ODNNJyklM0IlMEFjb25zdCUyMHJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwcG9ldCgnV3JpdGUlMjBtZSUyMGElMjBsb3ZlJTIwcG9lbSUyMGFib3V0JTIwY2hlZXNlLiclMkMlMjAlN0IlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzQSUyMDIwMCUyQyUwQSUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNBJTIwMC45JTJDJTBBJTIwJTIwJTIwJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNBJTIwMi4wJTJDJTBBJTIwJTIwJTIwJTIwbm9fcmVwZWF0X25ncmFtX3NpemUlM0ElMjAzJTJDJTBBJTdEKSUzQg==",highlighted:`<span class="hljs-comment">// Allocate a pipeline for text2text-generation</span>
<span class="hljs-keyword">const</span> poet = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text2text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/LaMini-Flan-T5-783M&#x27;</span>);
<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">poet</span>(<span class="hljs-string">&#x27;Write me a love poem about cheese.&#x27;</span>, {
    <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">200</span>,
    <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.9</span>,
    <span class="hljs-attr">repetition_penalty</span>: <span class="hljs-number">2.0</span>,
    <span class="hljs-attr">no_repeat_ngram_size</span>: <span class="hljs-number">3</span>,
});`,wrap:!1}}),O=new M({props:{code:"Q2hlZXNlJTJDJTIwb2glMjBjaGVlc2UhJTIwWW91J3JlJTIwdGhlJTIwcGVyZmVjdCUyMGNvbWZvcnQlMjBmb29kLiUwQVlvdXIlMjB0ZXh0dXJlJTIwc28lMjBzbW9vdGglMjBhbmQlMjBjcmVhbXklMjB5b3UlMjBjYW4lMjBuZXZlciUyMGdldCUyMG9sZC4lMEFXaXRoJTIwZXZlcnklMjBiaXRlJTIwaXQlMjBtZWx0cyUyMGluJTIweW91ciUyMG1vdXRoJTIwbGlrZSUyMGJ1dHRlcnklMjBkZWxpZ2h0cyUwQXRoYXQlMjBtYWtlJTIwbWUlMjBmZWVsJTIwcmlnaHQlMjBhdCUyMGhvbWUlMjB3aXRoJTIwdGhpcyUyMHN3ZWV0JTIwdHJlYXQlMjBvZiUyMG1pbmUuJTIwJTBBJTBBRnJvbSUyMGNsYXNzaWMlMjB0byUyMGJvbGQlMjBmbGF2b3IlMjBjb21iaW5hdGlvbnMlMkMlMEFJJTIwbG92ZSUyMGhvdyUyMHZlcnNhdGlsZSUyMHlvdSUyMGFyZSUyMGFzJTIwYW4lMjBpbmdyZWRpZW50JTIwdG9vJTNGJTBBQ2hlZGRhciUyMGlzJTIwbXklMjBnby10byUyMGZvciUyMGFueSUyMG9jY2FzaW9uJTIwb3IlMjBtb29kJTNCJTIwJTBBSXQlMjBhZGRzJTIwZGVwdGglMjBhbmQlMjByaWNobmVzcyUyMHdpdGhvdXQlMjBiZWluZyUyMG92ZXJwb3dlcmluZyUyMGl0cyUyMHRhc3RlJTIwYnVkcyUyMGFsb25l",highlighted:`Cheese, oh cheese! You&#x27;re <span class="hljs-keyword">the</span> perfect comfort food.
Your texture so smooth <span class="hljs-keyword">and</span> creamy you can never <span class="hljs-keyword">get</span> old.
With <span class="hljs-keyword">every</span> bite <span class="hljs-keyword">it</span> melts <span class="hljs-keyword">in</span> your mouth like buttery delights
<span class="hljs-keyword">that</span> make <span class="hljs-keyword">me</span> feel right <span class="hljs-keyword">at</span> home <span class="hljs-keyword">with</span> this sweet treat <span class="hljs-keyword">of</span> mine. 

From classic <span class="hljs-keyword">to</span> bold flavor combinations,
I love how versatile you are <span class="hljs-keyword">as</span> an ingredient too?
Cheddar <span class="hljs-keyword">is</span> <span class="hljs-keyword">my</span> go-<span class="hljs-keyword">to</span> <span class="hljs-keyword">for</span> any occasion <span class="hljs-keyword">or</span> mood; 
It adds depth <span class="hljs-keyword">and</span> richness <span class="hljs-keyword">without</span> being overpowering <span class="hljs-keyword">its</span> taste buds alone`,wrap:!1}}),ee=new w({props:{title:"Available tasks",local:"available-tasks",headingTag:"h2"}}),te=new w({props:{title:"Tasks",local:"tasks",headingTag:"h3"}}),se=new w({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h4"}}),ne=new w({props:{title:"Vision",local:"vision",headingTag:"h4"}}),ie=new w({props:{title:"Audio",local:"audio",headingTag:"h4"}}),re=new w({props:{title:"Tabular",local:"tabular",headingTag:"h4"}}),de=new w({props:{title:"Multimodal",local:"multimodal",headingTag:"h4"}}),he=new w({props:{title:"Reinforcement Learning",local:"reinforcement-learning",headingTag:"h4"}}),me=new Et({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/pipelines.md"}}),{c(){m=i("meta"),y=n(),u=i("p"),b=n(),r(T.$$.fragment),we=n(),U=i("p"),U.innerHTML=ht,ye=n(),r(J.$$.fragment),Me=n(),r(x.$$.fragment),be=n(),$=i("p"),$.innerHTML=ft,Je=n(),r(k.$$.fragment),je=n(),I=i("p"),I.innerHTML=mt,Te=n(),r(j.$$.fragment),Ue=n(),G=i("p"),G.textContent=gt,xe=n(),r(v.$$.fragment),$e=n(),B=i("p"),B.textContent=ut,ke=n(),r(C.$$.fragment),Ie=n(),N=i("p"),N.innerHTML=wt,Ge=n(),r(Z.$$.fragment),ve=n(),_=i("p"),_.innerHTML=yt,Be=n(),W=i("p"),W.innerHTML=Mt,Ce=n(),r(F.$$.fragment),Ne=n(),r(X.$$.fragment),Ze=n(),r(H.$$.fragment),_e=n(),Q=i("p"),Q.innerHTML=bt,We=n(),r(Y.$$.fragment),Fe=n(),S=i("p"),S.innerHTML=Jt,Xe=n(),r(R.$$.fragment),He=n(),A=i("p"),A.innerHTML=jt,Qe=n(),r(L.$$.fragment),Ye=n(),E=i("p"),E.textContent=Tt,Se=n(),r(z.$$.fragment),Re=n(),P=i("p"),P.innerHTML=Ut,Ae=n(),V=i("p"),V.innerHTML=xt,Le=n(),r(D.$$.fragment),Ee=n(),q=i("p"),q.innerHTML=$t,ze=n(),r(O.$$.fragment),Pe=n(),K=i("p"),K.innerHTML=kt,Ve=n(),r(ee.$$.fragment),De=n(),r(te.$$.fragment),qe=n(),r(se.$$.fragment),Oe=n(),ae=i("table"),ae.innerHTML=It,Ke=n(),r(ne.$$.fragment),et=n(),le=i("table"),le.innerHTML=Gt,tt=n(),r(ie.$$.fragment),st=n(),oe=i("table"),oe.innerHTML=vt,at=n(),r(re.$$.fragment),nt=n(),pe=i("table"),pe.innerHTML=Bt,lt=n(),r(de.$$.fragment),it=n(),ce=i("table"),ce.innerHTML=Ct,ot=n(),r(he.$$.fragment),rt=n(),fe=i("table"),fe.innerHTML=Nt,pt=n(),r(me.$$.fragment),dt=n(),ue=i("p"),this.h()},l(e){const t=At("svelte-u9bgzb",document.head);m=o(t,"META",{name:!0,content:!0}),t.forEach(s),y=l(e),u=o(e,"P",{}),Wt(u).forEach(s),b=l(e),p(T.$$.fragment,e),we=l(e),U=o(e,"P",{"data-svelte-h":!0}),g(U)!=="svelte-i79xeb"&&(U.innerHTML=ht),ye=l(e),p(J.$$.fragment,e),Me=l(e),p(x.$$.fragment,e),be=l(e),$=o(e,"P",{"data-svelte-h":!0}),g($)!=="svelte-1fxrwx6"&&($.innerHTML=ft),Je=l(e),p(k.$$.fragment,e),je=l(e),I=o(e,"P",{"data-svelte-h":!0}),g(I)!=="svelte-q94tv7"&&(I.innerHTML=mt),Te=l(e),p(j.$$.fragment,e),Ue=l(e),G=o(e,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1iimk7d"&&(G.textContent=gt),xe=l(e),p(v.$$.fragment,e),$e=l(e),B=o(e,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1rl0sgr"&&(B.textContent=ut),ke=l(e),p(C.$$.fragment,e),Ie=l(e),N=o(e,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1ceakdm"&&(N.innerHTML=wt),Ge=l(e),p(Z.$$.fragment,e),ve=l(e),_=o(e,"P",{"data-svelte-h":!0}),g(_)!=="svelte-6d1hww"&&(_.innerHTML=yt),Be=l(e),W=o(e,"P",{"data-svelte-h":!0}),g(W)!=="svelte-16cwp52"&&(W.innerHTML=Mt),Ce=l(e),p(F.$$.fragment,e),Ne=l(e),p(X.$$.fragment,e),Ze=l(e),p(H.$$.fragment,e),_e=l(e),Q=o(e,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-1fmte3u"&&(Q.innerHTML=bt),We=l(e),p(Y.$$.fragment,e),Fe=l(e),S=o(e,"P",{"data-svelte-h":!0}),g(S)!=="svelte-1ocw6xp"&&(S.innerHTML=Jt),Xe=l(e),p(R.$$.fragment,e),He=l(e),A=o(e,"P",{"data-svelte-h":!0}),g(A)!=="svelte-166r3ga"&&(A.innerHTML=jt),Qe=l(e),p(L.$$.fragment,e),Ye=l(e),E=o(e,"P",{"data-svelte-h":!0}),g(E)!=="svelte-1pm722b"&&(E.textContent=Tt),Se=l(e),p(z.$$.fragment,e),Re=l(e),P=o(e,"P",{"data-svelte-h":!0}),g(P)!=="svelte-1ml0f50"&&(P.innerHTML=Ut),Ae=l(e),V=o(e,"P",{"data-svelte-h":!0}),g(V)!=="svelte-1tl1lis"&&(V.innerHTML=xt),Le=l(e),p(D.$$.fragment,e),Ee=l(e),q=o(e,"P",{"data-svelte-h":!0}),g(q)!=="svelte-1y86c95"&&(q.innerHTML=$t),ze=l(e),p(O.$$.fragment,e),Pe=l(e),K=o(e,"P",{"data-svelte-h":!0}),g(K)!=="svelte-iq082d"&&(K.innerHTML=kt),Ve=l(e),p(ee.$$.fragment,e),De=l(e),p(te.$$.fragment,e),qe=l(e),p(se.$$.fragment,e),Oe=l(e),ae=o(e,"TABLE",{"data-svelte-h":!0}),g(ae)!=="svelte-16dc737"&&(ae.innerHTML=It),Ke=l(e),p(ne.$$.fragment,e),et=l(e),le=o(e,"TABLE",{"data-svelte-h":!0}),g(le)!=="svelte-q3qz09"&&(le.innerHTML=Gt),tt=l(e),p(ie.$$.fragment,e),st=l(e),oe=o(e,"TABLE",{"data-svelte-h":!0}),g(oe)!=="svelte-vw70ih"&&(oe.innerHTML=vt),at=l(e),p(re.$$.fragment,e),nt=l(e),pe=o(e,"TABLE",{"data-svelte-h":!0}),g(pe)!=="svelte-1rd81se"&&(pe.innerHTML=Bt),lt=l(e),p(de.$$.fragment,e),it=l(e),ce=o(e,"TABLE",{"data-svelte-h":!0}),g(ce)!=="svelte-sb1q1h"&&(ce.innerHTML=Ct),ot=l(e),p(he.$$.fragment,e),rt=l(e),fe=o(e,"TABLE",{"data-svelte-h":!0}),g(fe)!=="svelte-93ujrz"&&(fe.innerHTML=Nt),pt=l(e),p(me.$$.fragment,e),dt=l(e),ue=o(e,"P",{}),Wt(ue).forEach(s),this.h()},h(){Ft(m,"name","hf:doc:metadata"),Ft(m,"content",Dt)},m(e,t){Lt(document.head,m),a(e,y,t),a(e,u,t),a(e,b,t),d(T,e,t),a(e,we,t),a(e,U,t),a(e,ye,t),d(J,e,t),a(e,Me,t),d(x,e,t),a(e,be,t),a(e,$,t),a(e,Je,t),d(k,e,t),a(e,je,t),a(e,I,t),a(e,Te,t),d(j,e,t),a(e,Ue,t),a(e,G,t),a(e,xe,t),d(v,e,t),a(e,$e,t),a(e,B,t),a(e,ke,t),d(C,e,t),a(e,Ie,t),a(e,N,t),a(e,Ge,t),d(Z,e,t),a(e,ve,t),a(e,_,t),a(e,Be,t),a(e,W,t),a(e,Ce,t),d(F,e,t),a(e,Ne,t),d(X,e,t),a(e,Ze,t),d(H,e,t),a(e,_e,t),a(e,Q,t),a(e,We,t),d(Y,e,t),a(e,Fe,t),a(e,S,t),a(e,Xe,t),d(R,e,t),a(e,He,t),a(e,A,t),a(e,Qe,t),d(L,e,t),a(e,Ye,t),a(e,E,t),a(e,Se,t),d(z,e,t),a(e,Re,t),a(e,P,t),a(e,Ae,t),a(e,V,t),a(e,Le,t),d(D,e,t),a(e,Ee,t),a(e,q,t),a(e,ze,t),d(O,e,t),a(e,Pe,t),a(e,K,t),a(e,Ve,t),d(ee,e,t),a(e,De,t),d(te,e,t),a(e,qe,t),d(se,e,t),a(e,Oe,t),a(e,ae,t),a(e,Ke,t),d(ne,e,t),a(e,et,t),a(e,le,t),a(e,tt,t),d(ie,e,t),a(e,st,t),a(e,oe,t),a(e,at,t),d(re,e,t),a(e,nt,t),a(e,pe,t),a(e,lt,t),d(de,e,t),a(e,it,t),a(e,ce,t),a(e,ot,t),d(he,e,t),a(e,rt,t),a(e,fe,t),a(e,pt,t),d(me,e,t),a(e,dt,t),a(e,ue,t),ct=!0},p(e,[t]){const Zt={};t&2&&(Zt.$$scope={dirty:t,ctx:e}),J.$set(Zt);const _t={};t&2&&(_t.$$scope={dirty:t,ctx:e}),j.$set(_t)},i(e){ct||(c(T.$$.fragment,e),c(J.$$.fragment,e),c(x.$$.fragment,e),c(k.$$.fragment,e),c(j.$$.fragment,e),c(v.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(F.$$.fragment,e),c(X.$$.fragment,e),c(H.$$.fragment,e),c(Y.$$.fragment,e),c(R.$$.fragment,e),c(L.$$.fragment,e),c(z.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(he.$$.fragment,e),c(me.$$.fragment,e),ct=!0)},o(e){h(T.$$.fragment,e),h(J.$$.fragment,e),h(x.$$.fragment,e),h(k.$$.fragment,e),h(j.$$.fragment,e),h(v.$$.fragment,e),h(C.$$.fragment,e),h(Z.$$.fragment,e),h(F.$$.fragment,e),h(X.$$.fragment,e),h(H.$$.fragment,e),h(Y.$$.fragment,e),h(R.$$.fragment,e),h(L.$$.fragment,e),h(z.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(me.$$.fragment,e),ct=!1},d(e){e&&(s(y),s(u),s(b),s(we),s(U),s(ye),s(Me),s(be),s($),s(Je),s(je),s(I),s(Te),s(Ue),s(G),s(xe),s($e),s(B),s(ke),s(Ie),s(N),s(Ge),s(ve),s(_),s(Be),s(W),s(Ce),s(Ne),s(Ze),s(_e),s(Q),s(We),s(Fe),s(S),s(Xe),s(He),s(A),s(Qe),s(Ye),s(E),s(Se),s(Re),s(P),s(Ae),s(V),s(Le),s(Ee),s(q),s(ze),s(Pe),s(K),s(Ve),s(De),s(qe),s(Oe),s(ae),s(Ke),s(et),s(le),s(tt),s(st),s(oe),s(at),s(nt),s(pe),s(lt),s(it),s(ce),s(ot),s(rt),s(fe),s(pt),s(dt),s(ue)),s(m),f(T,e),f(J,e),f(x,e),f(k,e),f(j,e),f(v,e),f(C,e),f(Z,e),f(F,e),f(X,e),f(H,e),f(Y,e),f(R,e),f(L,e),f(z,e),f(D,e),f(O,e),f(ee,e),f(te,e),f(se,e),f(ne,e),f(ie,e),f(re,e),f(de,e),f(he,e),f(me,e)}}}const Dt='{"title":"The pipeline API","local":"the-pipeline-api","sections":[{"title":"The basics","local":"the-basics","sections":[],"depth":2},{"title":"Pipeline options","local":"pipeline-options","sections":[{"title":"Loading","local":"loading","sections":[],"depth":3},{"title":"Running","local":"running","sections":[],"depth":3}],"depth":2},{"title":"Available tasks","local":"available-tasks","sections":[{"title":"Tasks","local":"tasks","sections":[{"title":"Natural Language Processing","local":"natural-language-processing","sections":[],"depth":4},{"title":"Vision","local":"vision","sections":[],"depth":4},{"title":"Audio","local":"audio","sections":[],"depth":4},{"title":"Tabular","local":"tabular","sections":[],"depth":4},{"title":"Multimodal","local":"multimodal","sections":[],"depth":4},{"title":"Reinforcement Learning","local":"reinforcement-learning","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function qt(ge){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class as extends St{constructor(m){super(),Rt(this,m,qt,Vt,Qt,{})}}export{as as component};
