import{s as _a,f as He,o as xa,n as hn}from"../chunks/scheduler.a2b4ca8e.js";import{S as ka,i as Ra,g as i,s as n,r as o,A as $a,h as p,f as t,c as a,j as va,u as r,x as m,k as h,y as Sa,a as s,v as u,d as c,t as M,w as d}from"../chunks/index.d2f673cc.js";import{T as yn}from"../chunks/Tip.a902c250.js";import{C as J}from"../chunks/CodeBlock.792343a6.js";import{H as b}from"../chunks/Heading.675d4c1e.js";function Ya(V){let y,T="To apply optimized compute of Unet’s attention score, please configure your environment variable with <code>export NEURON_FUSE_SOFTMAX=1</code>.",f,g,j='Besides, don’t hesitate to tweak the compilation configuration to find the best tradeoff between performance v.s accuracy in your use case. By default, we suggest casting FP32 matrix multiplication operations to BF16 which offers good performance with moderate sacrifice of the accuracy. Check out the guide from <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/appnotes/neuronx-cc/neuronx-cc-training-mixed-precision.html#neuronx-cc-training-mixed-precision" rel="nofollow">AWS Neuron documentation</a> to better understand the options for your compilation.';return{c(){y=i("p"),y.innerHTML=T,f=n(),g=i("p"),g.innerHTML=j},l(w){y=p(w,"P",{"data-svelte-h":!0}),m(y)!=="svelte-6bhicj"&&(y.innerHTML=T),f=a(w),g=p(w,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1dh7n4s"&&(g.innerHTML=j)},m(w,U){s(w,y,U),s(w,f,U),s(w,g,U)},p:hn,d(w){w&&(t(y),t(f),t(g))}}}function Qa(V){let y,T="To avoid Neuron device out of memory, it’s suggested to finish all base inference and release the device memory before running the refiner.";return{c(){y=i("p"),y.textContent=T},l(f){y=p(f,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1323ut2"&&(y.textContent=T)},m(f,g){s(f,y,g)},p:hn,d(f){f&&t(y)}}}function Ea(V){let y,T="Inf2 instances contain one or more Neuron devices, and each Neuron device includes 2 NeuronCore-v2. By default, we load the whole pipeline of LCM to both Neuron cores. It means that when the batch size is divisible by 2, you can fully leverage the compute power of both cores.";return{c(){y=i("p"),y.textContent=T},l(f){y=p(f,"P",{"data-svelte-h":!0}),m(y)!=="svelte-3zwean"&&(y.textContent=T)},m(f,g){s(f,y,g)},p:hn,d(f){f&&t(y)}}}function Fa(V){let y,T,f,g,j,w,U,ze,x,bn='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-txt2img.ipynb" rel="nofollow">here</a></em>.',qe,k,Jn="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",Ae,R,fn='To get started, make sure you have <a href="../installation">configured your inf2 / trn1 instance</a>, and installed optimum:',De,$,Pe,S,Ke,Y,gn="To deploy models, you will need to compile them to TorchScript optimized for AWS Neuron. In the case of Stable Diffusion, there are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",Oe,Q,wn="<li>Text encoder</li> <li>U-Net</li> <li>VAE encoder</li> <li>VAE decoder</li>",lt,E,Tn="You can either compile and export a Stable Diffusion Checkpoint via CLI or <code>NeuronStableDiffusionPipeline</code> class.",et,F,Un="<strong><em>Export via CLI</em></strong>",tt,H,jn="Here is an example of exporting stable diffusion components with <code>Optimum</code> CLI:",st,L,nt,z,Zn="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with the Optimum CLI on a CPU-only instance (needs ~35 GB memory), and then run the pre-compiled model on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",at,q,Wn="<strong><em>Export via Python API</em></strong>",it,A,In="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionPipeline</code>:",pt,N,mt,D,ot,P,rt,K,Gn="<code>NeuronStableDiffusionPipeline</code> class allows you to generate images from a text prompt on neuron devices similar to the experience with <code>Diffusers</code>.",ut,O,Xn="With pre-compiled Stable Diffusion models, now generate an image with a prompt on Neuron:",ct,ll,Mt,Z,Bn,dt,el,yt,tl,Cn="With the <code>NeuronStableDiffusionImg2ImgPipeline</code> class, you can generate a new image conditioned on a text prompt and an initial image.",ht,sl,bt,nl,Vn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/03-sd-img2img-init.png" alt="landscape photo" width="256" height="256"/></td> <td align="center"><strong><em>ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. warm colors, 8K</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/04-sd-img2img.png" alt="drawing" width="250"/></td> <td align="right"></td></tr></tbody>',Jt,al,ft,il,Nn="With the <code>NeuronStableDiffusionInpaintPipeline</code> class, you can edit specific parts of an image by providing a mask and a text prompt.",gt,pl,wt,ml,vn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Face of a yellow cat, high resolution, sitting on a park bench</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/05-sd-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',Tt,ol,Ut,rl,_n="With the <code>NeuronStableDiffusionInstructPix2PixPipeline</code> class, you can apply instruction-based image editing using both text guidance and image guidance.",jt,ul,Zt,cl,xn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Add a beautiful sunset</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/11-sd-ip2p.png" alt="drawing" width="250"/></td></tr></tbody>',Wt,Ml,It,dl,kn='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-xl-txt2img.ipynb" rel="nofollow">here</a></em>.',Gt,yl,Rn="Stable Diffusion XL (SDXL) is a latent diffusion model for text-to-image. Compared to the previous versions of Stable Diffusion models, it improves the quality of generated images with a times larger UNet.",Xt,hl,Bt,bl,$n="To deploy SDXL models, we will also start by compiling the models. We support the export of following components in the pipeline to boost the speed:",Ct,Jl,Sn="<li>Text encoder</li> <li>Second text encoder</li> <li>U-Net (a three times larger UNet than the one in Stable Diffusion pipeline)</li> <li>VAE encoder</li> <li>VAE decoder</li>",Vt,fl,Yn="<strong><em>Export via CLI</em></strong>",Nt,gl,Qn="Here is an example of exporting SDXL components with <code>Optimum</code> CLI:",vt,wl,_t,Tl,En="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with Optimum CLI on a CPU-only instance (needs ~92 GB memory), and then run the pre-compiled models on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",xt,Ul,Fn="<strong><em>Export via Python API</em></strong>",kt,jl,Hn="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionXLPipeline</code>:",Rt,Zl,$t,Wl,St,Il,Ln="With pre-compiled SDXL models, now generate an image with a text prompt on Neuron:",Yt,Gl,Qt,W,zn,Et,Xl,Ft,Bl,qn="With <code>NeuronStableDiffusionXLImg2ImgPipeline</code>, you can pass an initial image, and a text prompt to condition generated images:",Ht,Cl,Lt,Vl,An='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png" alt="castle photo" width="256" height="256"/></td> <td align="center"><strong><em>a dog running, lake, moat</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/06-sdxl-img2img.png" alt="castle with dog" width="250"/></td> <td align="right"></td></tr></tbody>',zt,Nl,qt,vl,Dn="With <code>NeuronStableDiffusionXLInpaintPipeline</code>, pass the original image and a mask of what you want to replace in the original image. Then replace the masked area with content described in a prompt.",At,_l,Dt,xl,Pn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>A deep sea diver floating</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/07-sdxl-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',Pt,kl,Kt,Rl,Kn='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> to denoise low-noise stage images generated from the base model. There are two ways to use the refiner:',Ot,$l,On="<li>use the base and refiner model together to produce a refined image.</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image.</li>",ls,Sl,es,Yl,ts,I,la,ss,Ql,ns,El,as,Fl,ea='<thead><tr><th align="center"><code>Base Image</code></th> <th align="right">Refined Image</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/09-sdxl-base-full.png" alt="drawing" width="250"/></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/010-sdxl-refiner-detailed.png" alt="drawing" width="250"/></td></tr></tbody>',is,v,ps,Hl,ms,Ll,ta='Latent Consistency Models (LCMs) were proposed in <a href="https://huggingface.co/papers/2310.04378" rel="nofollow">Latent Consistency Models: Synthesizing High-Resolution Images with Few-Step Inference by Simian Luo, Yiqin Tan, Longbo Huang, Jian Li, and Hang Zhao</a>. LCMs enable inference with fewer steps on any pre-trained LDMs, including Stable Diffusion and SDXL.',os,zl,sa="In <code>optimum-neuron</code>, you can:",rs,ql,na="<li>Use the class <code>NeuronLatentConsistencyModelPipeline</code> to compile and run inference of LCMs distilled from Stable Diffusion (SD) models.</li> <li>And continue to use the class <code>NeuronStableDiffusionXLPipeline</code> for LCMs distilled from SDXL models.</li>",us,Al,aa='Here are examples to compile the LCMs of Stable Diffusion ( <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> ) and Stable Diffusion XL( <a href="https://huggingface.co/latent-consistency/lcm-sdxl" rel="nofollow">latent-consistency/lcm-sdxl</a> ), and then run inference on AWS Inferentia 2 :',cs,Dl,Ms,Pl,ia="<strong><em>LCM of Stable Diffusion</em></strong>",ds,Kl,ys,Ol,pa="<strong><em>LCM of Stable Diffusion XL</em></strong>",hs,le,bs,ee,Js,te,ma="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",fs,se,oa="<strong><em>LCM of Stable Diffusion</em></strong>",gs,ne,ws,ae,ra="<strong><em>LCM of Stable Diffusion XL</em></strong>",Ts,ie,Us,pe,js,me,ua='SDXL Turbo is an adversarial time-distilled Stable Diffusion XL (SDXL) model capable of running inference in as little as 1 step (<a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl_turbo" rel="nofollow">check <code>🤗diffusers</code> for more details</a>).',Zs,oe,ca="In <code>optimum-neuron</code>, you can:",Ws,re,Ma="<li>Use the class <code>NeuronStableDiffusionXLPipeline</code> to compile and run inference.</li>",Is,ue,da='Here we will compile the <a href="https://huggingface.co/stabilityai/sdxl-turbo" rel="nofollow"><code>stabilityai/sdxl-turbo</code></a> model with Optimum CLI.',Gs,ce,Xs,Me,Bs,de,Cs,ye,ya="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",Vs,he,Ns,_,vs,be,_s,Je,xs,fe,ha="Low-Rank Adaptation is fast way to Stable Diffusion to adapt styles of generated images. In Optimum Neuron, we support using one or multiple LoRA adapters by fusing their parameters into the original parameters of the text encoder(s) and the unet during the compilation. Here below is an example of compiling stable diffusion models with LoRA adapters of your choice and using the compiled artifacts to generate styled images:",ks,ge,Rs,G,ba,$s,we,Ss,Te,Ja="ControlNet conditions the stable diffusion model with an additional input image. In Optimum Neuron, we support the compilation of one or multiple ControlNet(s) along with the stable diffusion checkpoint. The you can use the compiled artifacts to generate styled images.",Ys,Ue,Qs,je,fa="We can either compile one or multiple ControlNet via the Optimum CLI or programatically via the <code>NeuronStableDiffusionControlNetPipeline</code> class by passing the <code>controlnet_ids</code>.",Es,Ze,ga="<li>Export via the Optimum CLI</li>",Fs,We,Hs,Ie,wa="<li>Export via Python API</li>",Ls,Ge,zs,Xe,qs,Be,Ta="For text-to-image, we can specify an additional conditioning input.",As,Ce,Ua="Here is an example with a canny image, a white outline of an image on a black background. The ControlNet will use the canny image as a control to guide the model to generate an image with the same outline.",Ds,Ve,Ps,X,ja,Ks,Ne,Os,ve,Za="With Optimum Neuron, you can also compose multiple ControlNet conditionings from different image inputs:",ln,_e,Wa="<li>Compile multiple ControlNet for SD1.5</li>",en,xe,tn,ke,Ia="<li>Run SD1.5 with OpenPose and Depth conditionings:</li>",sn,Re,nn,B,Ga,an,$e,pn,Se,mn,Ye,on,Qe,rn,Ee,un,C,Xa,cn,Fe,Ba='Are there any other stable diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',Mn,Le,dn;return j=new b({props:{title:"Generate images with Stable Diffusion models on AWS Inferentia",local:"generate-images-with-stable-diffusion-models-on-aws-inferentia",headingTag:"h1"}}),U=new b({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),$=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMm9wdGltdW0lNUJuZXVyb254JTJDJTIwZGlmZnVzZXJzJTVEJTIy",highlighted:'pip install <span class="hljs-string">&quot;optimum[neuronx, diffusers]&quot;</span>',wrap:!1}}),S=new b({props:{title:"Compile Stable Diffusion",local:"compile-stable-diffusion",headingTag:"h3"}}),L=new J({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMS1iYXNlJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbiUyMCU1QyUwQSUyMCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAtLWhlaWdodCUyMDUxMiUyMCU2MCUyMyUyMGhlaWdodCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDUxMiUyQyUyMDc2OCU2MCUyMCU1QyUwQSUyMCUyMC0td2lkdGglMjA1MTIlMjAlNjAlMjMlMjB3aWR0aCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDUxMiUyQyUyMDc2OCU2MCUyMCU1QyUwQSUyMCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwNCUyMCU2MCUyMyUyMG51bWJlciUyMG9mJTIwaW1hZ2VzJTIwdG8lMjBnZW5lcmF0ZSUyMHBlciUyMHByb21wdCUyQyUyMGRlZmF1bHRzJTIwdG8lMjAxJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3QlMjBtYXRtdWwlMjAlNjAlMjMlMjBjYXN0JTIwb25seSUyMG1hdHJpeCUyMG11bHRpcGxpY2F0aW9uJTIwb3BlcmF0aW9ucyU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwJTYwJTIzJTIwY2FzdCUyMG9wZXJhdGlvbnMlMjBmcm9tJTIwRlAzMiUyMHRvJTIwQkYxNiU2MCUyMCU1QyUwQSUyMCUyMHNkX25ldXJvbiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-2-1-base \\\n  --task stable-diffusion \\\n  --batch_size 1 \\\n  --height 512 `<span class="hljs-comment"># height in pixels of generated image, eg. 512, 768` \\</span>\n  --width 512 `<span class="hljs-comment"># width in pixels of generated image, eg. 512, 768` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron/',wrap:!1}}),N=new yn({props:{$$slots:{default:[Ya]},$$scope:{ctx:V}}}),D=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzKSUwQSUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIyc2RfbmV1cm9uJTJGJTIyJTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBc3RhYmxlX2RpZmZ1c2lvbi5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1uZXVyb24tcmVwbyUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),P=new b({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),ll=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbiUyRiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBzdGFibGVfZGlmZnVzaW9uKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),el=new b({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),sl=new J({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBJTIzJTIwY29tcGlsZSUyMCUyNiUyMHNhdmUlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm5pdHJvc29ja2UlMkZHaGlibGktRGlmZnVzaW9uJTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyklMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfaW1nMmltZyUyRiUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZ2hpYmxpJTIwc3R5bGUlMkMlMjBhJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyMHdpdGglMjBzbm93Y2FwcGVkJTIwbW91bnRhaW5zJTJDJTIwdHJlZXMlMkMlMjBsYWtlJTIwd2l0aCUyMGRldGFpbGVkJTIwcmVmbGVjdGlvbi4lMjBzdW5saWdodCUyMGFuZCUyMGNsb3VkJTIwaW4lMjB0aGUlMjBza3klMkMlMjB3YXJtJTIwY29sb3JzJTJDJTIwOEslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionImg2ImgPipeline

<span class="hljs-comment"># compile &amp; save</span>
model_id = <span class="hljs-string">&quot;nitrosocke/Ghibli-Diffusion&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_img2img/&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. sunlight and cloud in the sky, warm colors, 8K&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),al=new b({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),pl=new J({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEFwaXBlbGluZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlJTJDJTIwKippbnB1dF9zaGFwZXMpJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnNkX2lucGFpbnQlMkYlMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UobWFza191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0X29uX2JlbmNoLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionInpaintPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_inpaint/&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat_on_bench.png&quot;</span>)`,wrap:!1}}),ol=new b({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h3"}}),ul=new J({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBQSUwlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMGR5bmFtaWNfYmF0Y2hfc2l6ZSUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSklMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJzZF9pcDJwJTJGJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWRkJTIwYSUyMGJlYXV0aWZ1bCUyMHN1bnNldCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnN1bnNldF9tb3VudGFpbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInstructPix2PixPipeline

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

model_id = <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

pipe = NeuronStableDiffusionInstructPix2PixPipeline.from_pretrained(
  model_id, export=<span class="hljs-literal">True</span>, dynamic_batch_size=<span class="hljs-literal">True</span>, **input_shapes,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_ip2p/&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>
init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Add a beautiful sunset&quot;</span>
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sunset_mountain.png&quot;</span>)`,wrap:!1}}),Ml=new b({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),hl=new b({props:{title:"Compile Stable Diffusion XL",local:"compile-stable-diffusion-xl",headingTag:"h3"}}),wl=new J({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbi14bCUyMCU1QyUwQSUyMCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAtLWhlaWdodCUyMDEwMjQlMjAlNjAlMjMlMjBoZWlnaHQlMjBpbiUyMHBpeGVscyUyMG9mJTIwZ2VuZXJhdGVkJTIwaW1hZ2UlMkMlMjBlZy4lMjA3NjglMkMlMjAxMDI0JTYwJTIwJTVDJTBBJTIwJTIwLS13aWR0aCUyMDEwMjQlMjAlNjAlMjMlMjB3aWR0aCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDc2OCUyQyUyMDEwMjQlNjAlMjAlNUMlMEElMjAlMjAtLW51bV9pbWFnZXNfcGVyX3Byb21wdCUyMDQlMjAlNjAlMjMlMjBudW1iZXIlMjBvZiUyMGltYWdlcyUyMHRvJTIwZ2VuZXJhdGUlMjBwZXIlMjBwcm9tcHQlMkMlMjBkZWZhdWx0cyUyMHRvJTIwMSU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwJTYwJTIzJTIwY2FzdCUyMG9ubHklMjBtYXRyaXglMjBtdWx0aXBsaWNhdGlvbiUyMG9wZXJhdGlvbnMlNjAlMjAlNUMlMEElMjAlMjAtLWF1dG9fY2FzdF90eXBlJTIwYmYxNiUyMCU2MCUyMyUyMGNhc3QlMjBvcGVyYXRpb25zJTIwZnJvbSUyMEZQMzIlMjB0byUyMEJGMTYlNjAlMjAlNUMlMEElMjAlMjBzZF9uZXVyb25feGwlMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-xl-base-1.0 \\\n  --task stable-diffusion-xl \\\n  --batch_size 1 \\\n  --height 1024 `<span class="hljs-comment"># height in pixels of generated image, eg. 768, 1024` \\</span>\n  --width 1024 `<span class="hljs-comment"># width in pixels of generated image, eg. 768, 1024` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron_xl/',wrap:!1}}),Zl=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCU3RCUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX25ldXJvbl94bCUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb25feGwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQXN0YWJsZV9kaWZmdXNpb25feGwucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Wl=new b({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Gl=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbl94bChwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion_xl(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Xl=new b({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),Cl=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBydW5uaW5nJTJDJTIwbGFrZSUyQyUyMG1vYXQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZvcHRpbXVtJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmludGVsJTJGb3BlbnZpbm8lMkZzZF94bCUyRmNhc3RsZV9mcmllZHJpY2gucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bCUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

prompt = <span class="hljs-string">&quot;a dog running, lake, moat&quot;</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

pipe = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Nl=new b({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),_l=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzZHhsLXRleHQyaW1nLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjg1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMi41KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = (
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>
)

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>

pipe = NeuronStableDiffusionXLInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),kl=new b({props:{title:"Refine Image Quality",local:"refine-image-quality",headingTag:"h3"}}),Sl=new b({props:{title:"Base + refiner model",local:"base--refiner-model",headingTag:"h4"}}),Yl=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXNfcGVyX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMGRlbm9pc2luZ19lbmQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWRlbCUyMGJhc2UlMjAlMjAlMjMlMjBUbyUyMGF2b2lkJTIwbmV1cm9uJTIwZGV2aWNlJTIwT09NJTBBJTBBcmVmaW5lciUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGxfcmVmaW5lciUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHJlZmluZXIoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQwJTJDJTBBJTIwJTIwJTIwJTIwZGVub2lzaW5nX3N0YXJ0JTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(
    prompt=prompt,
    num_images_per_prompt=num_images_per_prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ql=new b({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h4"}}),El=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBZGVsJTIwYmFzZSUyMCUyMCUyMyUyMFRvJTIwYXZvaWQlMjBuZXVyb24lMjBkZXZpY2UlMjBPT00lMEElMEFyZWZpbmVyJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bF9yZWZpbmVyJTJGJTIyKSUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),v=new yn({props:{$$slots:{default:[Qa]},$$scope:{ctx:V}}}),Hl=new b({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),Dl=new b({props:{title:"Compile LCM",local:"compile-lcm",headingTag:"h3"}}),Kl=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJTaW1pYW5MdW8lMkZMQ01fRHJlYW1zaGFwZXJfdjclMjIlMEFudW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAlM0QlMjAxJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA3NjglMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDc2OCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZF9uZXVyb24lMkYlMjIlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSklMEElMEElMjMlMjBQdXNoJTIwdG8lMjBodWIlMEFzdGFibGVfZGlmZnVzaW9uLnB1c2hfdG9faHViKHNhdmVfZGlyZWN0b3J5JTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMm15LW5ldXJvbi1yZXBvJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKSUyMCUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIweW91ciUyMHJlcG8lMjBpZCUyQyUyMGVnLiUyMCUyMkppbmd5YSUyRkxDTV9EcmVhbXNoYXBlcl92N19uZXVyb254JTIy",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronLatentConsistencyModelPipeline.from_pretrained(
    model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sd_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>`,wrap:!1}}),le=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBdW5ldF9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1zZHhsJTIyJTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMSUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB1bmV0X2lkJTNEdW5ldF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZHhsX25ldXJvbiUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb24uc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQSUwQSUyMyUyMFB1c2glMjB0byUyMGh1YiUwQXN0YWJsZV9kaWZmdXNpb24ucHVzaF90b19odWIoc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUpJTIwJTIwJTIwJTIzJTIwUmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwcmVwbyUyMGlkJTJDJTIwZWcuJTIwJTIySmluZ3lhJTJGbGNtLXNkeGwtbmV1cm9ueCUyMg==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
unet_id = <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronStableDiffusionXLPipeline.from_pretrained(
    model_id, unet_id=unet_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sdxl_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)   <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/lcm-sdxl-neuronx&quot;</span>`,wrap:!1}}),ee=new b({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),ne=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvbkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGTENNX0RyZWFtc2hhcGVyX3Y3X25ldXJvbnglMjIpJTBBcHJvbXB0cyUyMCUzRCUyMCU1QiUyMlNlbGYtcG9ydHJhaXQlMjBvaWwlMjBwYWludGluZyUyQyUyMGElMjBiZWF1dGlmdWwlMjBjeWJvcmclMjB3aXRoJTIwZ29sZGVuJTIwaGFpciUyQyUyMDhrJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

pipe = NeuronLatentConsistencyModelPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),ie=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZsY20tc2R4bC1uZXVyb254JTIyKSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMjJhJTIwY2xvc2UtdXAlMjBwaWN0dXJlJTIwb2YlMjBhbiUyMG9sZCUyMG1hbiUyMHN0YW5kaW5nJTIwaW4lMjB0aGUlMjByYWluJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/lcm-sdxl-neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;a close-up picture of an old man standing in the rain&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),pe=new b({props:{title:"Stable Diffusion XL Turbo",local:"stable-diffusion-xl-turbo",headingTag:"h2"}}),ce=new b({props:{title:"Compile SDXL Turbo",local:"compile-sdxl-turbo",headingTag:"h3"}}),Me=new J({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbi14bCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLWhlaWdodCUyMDUxMiUyMC0td2lkdGglMjA1MTIlMjAtLWF1dG9fY2FzdCUyMG1hdG11bCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwc2R4bF90dXJib19uZXVyb24lMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/sdxl-turbo --task stable-diffusion-xl --batch_size 1 --height 512 --width 512 --auto_cast matmul --auto_cast_type bf16 sdxl_turbo_neuron/',wrap:!1}}),de=new b({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),he=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZHhsX3R1cmJvX25ldXJvbiUyRiUyMiUyQyUyMGRhdGFfcGFyYWxsZWxfbW9kZSUzRCUyMmFsbCUyMiklMEFwcm9tcHQlMjAlM0QlMjAlNUIlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiU1RCUyMColMjAyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_turbo_neuron/&quot;</span>, data_parallel_mode=<span class="hljs-string">&quot;all&quot;</span>)
prompt = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images`,wrap:!1}}),_=new yn({props:{$$slots:{default:[Ea]},$$scope:{ctx:V}}}),be=new b({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),Je=new b({props:{title:"LoRA",local:"lora",headingTag:"h3"}}),ge=new J({props:{code:"JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExDTVNjaGVkdWxlciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJMeWtvbiUyRmRyZWFtc2hhcGVyLTclMjIlMEFhZGFwdGVyX2lkJTIwJTNEJTIwJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R2MS01JTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMDElN0QlMEFjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBJTBBJTIzJTIwQ29tcGlsZSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwaW5saW5lX3dlaWdodHNfdG9fbmVmZiUzRFRydWUlMkMlMjAlMjAlMjMlMjBjYXZlYXQlM0ElMjBwZXJmb3JtYW5jZSUyMGRyb3AlMjBpZiUyMG5lZmYlMkZ3ZWlnaHRzJTIwc2VwYXJhdGVkJTJDJTIwd2lsbCUyMGJlJTIwaW1wcm92ZWQlMjBieSUyMGElMjBmdXR1cmUlMjBOZXVyb24lMjBzZGslMjByZWxlYXNlLiUwQSUyMCUyMCUyMCUyMGxvcmFfbW9kZWxfaWRzJTNEYWRhcHRlcl9pZCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfd2VpZ2h0X25hbWVzJTNEJTIycHl0b3JjaF9sb3JhX3dlaWdodHMuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FkYXB0ZXJfbmFtZXMlM0QlMjJsY20lMjIlMkMlMEElMjAlMjAlMjAlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSUyMCUyMCUyMCUyMCoqY29tcGlsZXJfYXJncyUyQyUwQSklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBJTIzJTIwU2F2ZSUyMGxvY2FsbHklMjBvciUyMHVwbG9hZCUyMHRvJTIwdGhlJTIwSHVnZ2luZ0ZhY2UlMjBIdWIlMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJkcmVhbXNoYXBlcl83X2xjbV9sb3JhX25ldXJvbiUyRiUyMiklMEElMEElMEElMjMlMjBJbmZlcmVuY2UlMEFwcm9tcHQlMjAlM0QlMjAlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LCMScheduler
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline


model_id = <span class="hljs-string">&quot;Lykon/dreamshaper-7&quot;</span>
adapter_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

<span class="hljs-comment"># Compile</span>
pipe = NeuronStableDiffusionPipeline.from_pretrained(
    model_id,
    export=<span class="hljs-literal">True</span>,
    inline_weights_to_neff=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># caveat: performance drop if neff/weights separated, will be improved by a future Neuron sdk release.</span>
    lora_model_ids=adapter_id,
    lora_weight_names=<span class="hljs-string">&quot;pytorch_lora_weights.safetensors&quot;</span>,
    lora_adapter_names=<span class="hljs-string">&quot;lcm&quot;</span>,
    **input_shapes,
    **compiler_args,
)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
pipe.save_pretrained(<span class="hljs-string">&quot;dreamshaper_7_lcm_lora_neuron/&quot;</span>)


<span class="hljs-comment"># Inference</span>
prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),we=new b({props:{title:"ControlNet",local:"controlnet",headingTag:"h2"}}),Ue=new b({props:{title:"Compile ControlNet",local:"compile-controlnet",headingTag:"h3"}}),We=new J({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbiUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLWhlaWdodCUyMDUxMiUyMC0td2lkdGglMjA1MTIlMjAtLWNvbnRyb2xuZXRfaWRzJTIwbGxseWFzdmllbCUyRnNkLWNvbnRyb2xuZXQtY2FubnklMjAtLW51bV9pbWFnZXNfcGVyX3Byb21wdCUyMDElMjBzZF9uZXVyb25fY29udHJvbG5ldCUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m runwayml/stable-diffusion-v1-5 --task stable-diffusion --batch_size 1 --height 512 --width 512 --controlnet_ids lllyasviel/sd-controlnet-canny --num_images_per_prompt 1 sd_neuron_controlnet/',wrap:!1}}),Ge=new J({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWNvbnRyb2xuZXRfaWQlMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUwQSUwQSUyMyUyMCU1Qk5ldXJvbiU1RCUyMHBpcGVsaW5lJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMDElN0QlMEFjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2lkcyUzRGNvbnRyb2xuZXRfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMlMkMlMEElMjAlMjAlMjAlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMEEpJTBBcGlwZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfbmV1cm9uX2NvbnRyb2xuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
controlnet_id = <span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>

<span class="hljs-comment"># [Neuron] pipeline</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(
    model_id,
    controlnet_ids=controlnet_id,
    export=<span class="hljs-literal">True</span>,
    **input_shapes,
    **compiler_args,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)`,wrap:!1}}),Xe=new b({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Ve=new J({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25TdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUlMEElMEElMEElMjMlMjBwcmVwYXJlJTIwY2FubnklMjBpbWFnZSUwQW9yaWdpbmFsX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnB1dF9pbWFnZV92ZXJtZWVyLnBuZyUyMiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEElMEElMjMlMjBsb2FkJTIwcHJlLWNvbXBpbGVkJTIwbmV1cm9uJTIwbW9kZWwlMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25fY29udHJvbG5ldCUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBpbmZlcmVuY2UlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCUyMnRoZSUyMG1vbmElMjBsaXNhJTIyJTJDJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWNvbXBhcmUlMjAlM0QlMjBtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMpJTBBY29tcGFyZS5zYXZlKCUyMmNvbXBhcmUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline


<span class="hljs-comment"># prepare canny image</span>
original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

<span class="hljs-comment"># load pre-compiled neuron model</span>
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># inference</span>
output = pipe(<span class="hljs-string">&quot;the mona lisa&quot;</span>, image=canny_image).images[<span class="hljs-number">0</span>]
compare = make_image_grid([original_image, canny_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)
compare.save(<span class="hljs-string">&quot;compare.png&quot;</span>)`,wrap:!1}}),Ne=new b({props:{title:"MultiControlNet",local:"multicontrolnet",headingTag:"h3"}}),xe=new J({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLWlubGluZS13ZWlnaHRzLW5lZmYlMjAtLW1vZGVsJTIwanlvdW5nMTA1JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbiUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS1udW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAxJTIwLS1jb250cm9sbmV0X2lkcyUyMGxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMXBfc2QxNV9vcGVucG9zZSUyMGxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMWYxcF9zZDE1X2RlcHRoJTIwLS1oZWlnaHQlMjA1MTIlMjAtLXdpZHRoJTIwNTEyJTIwc2QxNS01MTJ4NTEyLWJmMTYtb3BlbnBvc2UtZGVwdGg=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --inline-weights-neff --model jyoung105/stable-diffusion-v1-5 --task stable-diffusion --auto_cast matmul --auto_cast_type bf16 --batch_size 1 --num_images_per_prompt 1 --controlnet_ids lllyasviel/control_v11p_sd15_openpose lllyasviel/control_v11f1p_sd15_depth --height 512 --width 512 sd15-512x512-bf16-openpose-depth',wrap:!1}}),Re=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> OpenposeDetector
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline


<span class="hljs-comment"># OpenPose+Depth ControlNet</span>
model_id = <span class="hljs-string">&quot;sd15-512x512-bf16-openpose-depth&quot;</span>

<span class="hljs-comment"># Load ControlNet images</span>

<span class="hljs-comment"># 1. openpose</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11p_sd15_openpose/resolve/main/images/input.png&quot;</span>)
processor = OpenposeDetector.from_pretrained(<span class="hljs-string">&#x27;lllyasviel/ControlNet&#x27;</span>)
openpose_image = processor(image)

<span class="hljs-comment"># 2. depth</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11p_sd15_depth/resolve/main/images/input.png&quot;</span>)
depth_estimator = pipeline(<span class="hljs-string">&#x27;depth-estimation&#x27;</span>)
image = depth_estimator(image)[<span class="hljs-string">&#x27;depth&#x27;</span>]
image = np.array(image)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
depth_image = Image.fromarray(image)

images = [openpose_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>)), depth_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))]

<span class="hljs-comment"># 3. inference</span>
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(model_id)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
prompt = <span class="hljs-string">&quot;a giant in a fantasy landscape, best quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>

image = pipe(prompt=prompt, image=images).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;out.png&#x27;</span>)`,wrap:!1}}),$e=new b({props:{title:"ControlNet with Stable Diffusion XL",local:"controlnet-with-stable-diffusion-xl",headingTag:"h2"}}),Se=new b({props:{title:"Compile",local:"compile",headingTag:"h3"}}),Ye=new J({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMC0tdGFzayUyMHN0YWJsZS1kaWZmdXNpb24teGwlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS1oZWlnaHQlMjAxMDI0JTIwLS13aWR0aCUyMDEwMjQlMjAtLWNvbnRyb2xuZXRfaWRzJTIwZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMC1zbWFsbCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwMSUyMHNkeGxfbmV1cm9uX2NvbnRyb2xuZXQlMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m stabilityai/stable-diffusion-xl-base-1.0 --task stable-diffusion-xl --batch_size 1 --height 1024 --width 1024 --controlnet_ids diffusers/controlnet-canny-sdxl-1.0-small --num_images_per_prompt 1 sdxl_neuron_controlnet/',wrap:!1}}),Qe=new b({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Ee=new J({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRQaXBlbGluZSUwQSUwQSUyMyUyMElucHV0cyUwQXByb21wdCUyMCUzRCUyMCUyMmFlcmlhbCUyMHZpZXclMkMlMjBhJTIwZnV0dXJpc3RpYyUyMHJlc2VhcmNoJTIwY29tcGxleCUyMGluJTIwYSUyMGJyaWdodCUyMGZvZ2d5JTIwanVuZ2xlJTJDJTIwaGFyZCUyMGxpZ2h0aW5nJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIybG93JTIwcXVhbGl0eSUyQyUyMGJhZCUyMHF1YWxpdHklMkMlMjBza2V0Y2hlcyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc2RfY29udHJvbG5ldCUyRmhmLWxvZ28ucG5nJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBaW1hZ2UlMjAlM0QlMjBjdjIuQ2FubnkoaW1hZ2UlMkMlMjAxMDAlMkMlMjAyMDApJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEFpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQSUwQWNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTIwJTNEJTIwMC41JTIwJTIwJTIzJTIwcmVjb21tZW5kZWQlMjBmb3IlMjBnb29kJTIwZ2VuZXJhbGl6YXRpb24lMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkeGxfbmV1cm9uX2NvbnRyb2xuZXQlMjIpJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0Rjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmh1Z19sYWIucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLControlNetPipeline

<span class="hljs-comment"># Inputs</span>
prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)
image = np.array(image)
image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
image = Image.fromarray(image)

controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>

pipe = NeuronStableDiffusionXLControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_neuron_controlnet&quot;</span>)

images = pipe(
    prompt,
    negative_prompt=negative_prompt,
    image=image,
    controlnet_conditioning_scale=controlnet_conditioning_scale,
).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;hug_lab.png&quot;</span>)`,wrap:!1}}),{c(){y=i("meta"),T=n(),f=i("p"),g=n(),o(j.$$.fragment),w=n(),o(U.$$.fragment),ze=n(),x=i("p"),x.innerHTML=bn,qe=n(),k=i("p"),k.innerHTML=Jn,Ae=n(),R=i("p"),R.innerHTML=fn,De=n(),o($.$$.fragment),Pe=n(),o(S.$$.fragment),Ke=n(),Y=i("p"),Y.innerHTML=gn,Oe=n(),Q=i("ul"),Q.innerHTML=wn,lt=n(),E=i("p"),E.innerHTML=Tn,et=n(),F=i("p"),F.innerHTML=Un,tt=n(),H=i("p"),H.innerHTML=jn,st=n(),o(L.$$.fragment),nt=n(),z=i("p"),z.innerHTML=Zn,at=n(),q=i("p"),q.innerHTML=Wn,it=n(),A=i("p"),A.innerHTML=In,pt=n(),o(N.$$.fragment),mt=n(),o(D.$$.fragment),ot=n(),o(P.$$.fragment),rt=n(),K=i("p"),K.innerHTML=Gn,ut=n(),O=i("p"),O.textContent=Xn,ct=n(),o(ll.$$.fragment),Mt=n(),Z=i("img"),dt=n(),o(el.$$.fragment),yt=n(),tl=i("p"),tl.innerHTML=Cn,ht=n(),o(sl.$$.fragment),bt=n(),nl=i("table"),nl.innerHTML=Vn,Jt=n(),o(al.$$.fragment),ft=n(),il=i("p"),il.innerHTML=Nn,gt=n(),o(pl.$$.fragment),wt=n(),ml=i("table"),ml.innerHTML=vn,Tt=n(),o(ol.$$.fragment),Ut=n(),rl=i("p"),rl.innerHTML=_n,jt=n(),o(ul.$$.fragment),Zt=n(),cl=i("table"),cl.innerHTML=xn,Wt=n(),o(Ml.$$.fragment),It=n(),dl=i("p"),dl.innerHTML=kn,Gt=n(),yl=i("p"),yl.textContent=Rn,Xt=n(),o(hl.$$.fragment),Bt=n(),bl=i("p"),bl.textContent=$n,Ct=n(),Jl=i("ul"),Jl.innerHTML=Sn,Vt=n(),fl=i("p"),fl.innerHTML=Yn,Nt=n(),gl=i("p"),gl.innerHTML=Qn,vt=n(),o(wl.$$.fragment),_t=n(),Tl=i("p"),Tl.innerHTML=En,xt=n(),Ul=i("p"),Ul.innerHTML=Fn,kt=n(),jl=i("p"),jl.innerHTML=Hn,Rt=n(),o(Zl.$$.fragment),$t=n(),o(Wl.$$.fragment),St=n(),Il=i("p"),Il.textContent=Ln,Yt=n(),o(Gl.$$.fragment),Qt=n(),W=i("img"),Et=n(),o(Xl.$$.fragment),Ft=n(),Bl=i("p"),Bl.innerHTML=qn,Ht=n(),o(Cl.$$.fragment),Lt=n(),Vl=i("table"),Vl.innerHTML=An,zt=n(),o(Nl.$$.fragment),qt=n(),vl=i("p"),vl.innerHTML=Dn,At=n(),o(_l.$$.fragment),Dt=n(),xl=i("table"),xl.innerHTML=Pn,Pt=n(),o(kl.$$.fragment),Kt=n(),Rl=i("p"),Rl.innerHTML=Kn,Ot=n(),$l=i("ol"),$l.innerHTML=On,ls=n(),o(Sl.$$.fragment),es=n(),o(Yl.$$.fragment),ts=n(),I=i("img"),ss=n(),o(Ql.$$.fragment),ns=n(),o(El.$$.fragment),as=n(),Fl=i("table"),Fl.innerHTML=ea,is=n(),o(v.$$.fragment),ps=n(),o(Hl.$$.fragment),ms=n(),Ll=i("p"),Ll.innerHTML=ta,os=n(),zl=i("p"),zl.innerHTML=sa,rs=n(),ql=i("ul"),ql.innerHTML=na,us=n(),Al=i("p"),Al.innerHTML=aa,cs=n(),o(Dl.$$.fragment),Ms=n(),Pl=i("p"),Pl.innerHTML=ia,ds=n(),o(Kl.$$.fragment),ys=n(),Ol=i("p"),Ol.innerHTML=pa,hs=n(),o(le.$$.fragment),bs=n(),o(ee.$$.fragment),Js=n(),te=i("p"),te.textContent=ma,fs=n(),se=i("p"),se.innerHTML=oa,gs=n(),o(ne.$$.fragment),ws=n(),ae=i("p"),ae.innerHTML=ra,Ts=n(),o(ie.$$.fragment),Us=n(),o(pe.$$.fragment),js=n(),me=i("p"),me.innerHTML=ua,Zs=n(),oe=i("p"),oe.innerHTML=ca,Ws=n(),re=i("ul"),re.innerHTML=Ma,Is=n(),ue=i("p"),ue.innerHTML=da,Gs=n(),o(ce.$$.fragment),Xs=n(),o(Me.$$.fragment),Bs=n(),o(de.$$.fragment),Cs=n(),ye=i("p"),ye.textContent=ya,Vs=n(),o(he.$$.fragment),Ns=n(),o(_.$$.fragment),vs=n(),o(be.$$.fragment),_s=n(),o(Je.$$.fragment),xs=n(),fe=i("p"),fe.textContent=ha,ks=n(),o(ge.$$.fragment),Rs=n(),G=i("img"),$s=n(),o(we.$$.fragment),Ss=n(),Te=i("p"),Te.textContent=Ja,Ys=n(),o(Ue.$$.fragment),Qs=n(),je=i("p"),je.innerHTML=fa,Es=n(),Ze=i("ul"),Ze.innerHTML=ga,Fs=n(),o(We.$$.fragment),Hs=n(),Ie=i("ul"),Ie.innerHTML=wa,Ls=n(),o(Ge.$$.fragment),zs=n(),o(Xe.$$.fragment),qs=n(),Be=i("p"),Be.textContent=Ta,As=n(),Ce=i("p"),Ce.textContent=Ua,Ds=n(),o(Ve.$$.fragment),Ps=n(),X=i("img"),Ks=n(),o(Ne.$$.fragment),Os=n(),ve=i("p"),ve.textContent=Za,ln=n(),_e=i("ul"),_e.innerHTML=Wa,en=n(),o(xe.$$.fragment),tn=n(),ke=i("ul"),ke.innerHTML=Ia,sn=n(),o(Re.$$.fragment),nn=n(),B=i("img"),an=n(),o($e.$$.fragment),pn=n(),o(Se.$$.fragment),mn=n(),o(Ye.$$.fragment),on=n(),o(Qe.$$.fragment),rn=n(),o(Ee.$$.fragment),un=n(),C=i("img"),cn=n(),Fe=i("p"),Fe.innerHTML=Ba,Mn=n(),Le=i("p"),this.h()},l(l){const e=$a("svelte-u9bgzb",document.head);y=p(e,"META",{name:!0,content:!0}),e.forEach(t),T=a(l),f=p(l,"P",{}),va(f).forEach(t),g=a(l),r(j.$$.fragment,l),w=a(l),r(U.$$.fragment,l),ze=a(l),x=p(l,"P",{"data-svelte-h":!0}),m(x)!=="svelte-140c11v"&&(x.innerHTML=bn),qe=a(l),k=p(l,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1g87d8z"&&(k.innerHTML=Jn),Ae=a(l),R=p(l,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1u4t7n7"&&(R.innerHTML=fn),De=a(l),r($.$$.fragment,l),Pe=a(l),r(S.$$.fragment,l),Ke=a(l),Y=p(l,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-3qllio"&&(Y.innerHTML=gn),Oe=a(l),Q=p(l,"UL",{"data-svelte-h":!0}),m(Q)!=="svelte-1c1t3y0"&&(Q.innerHTML=wn),lt=a(l),E=p(l,"P",{"data-svelte-h":!0}),m(E)!=="svelte-15y00oa"&&(E.innerHTML=Tn),et=a(l),F=p(l,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1a2m8iq"&&(F.innerHTML=Un),tt=a(l),H=p(l,"P",{"data-svelte-h":!0}),m(H)!=="svelte-ktaj8q"&&(H.innerHTML=jn),st=a(l),r(L.$$.fragment,l),nt=a(l),z=p(l,"P",{"data-svelte-h":!0}),m(z)!=="svelte-jz092x"&&(z.innerHTML=Zn),at=a(l),q=p(l,"P",{"data-svelte-h":!0}),m(q)!=="svelte-kxhd34"&&(q.innerHTML=Wn),it=a(l),A=p(l,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1bahy14"&&(A.innerHTML=In),pt=a(l),r(N.$$.fragment,l),mt=a(l),r(D.$$.fragment,l),ot=a(l),r(P.$$.fragment,l),rt=a(l),K=p(l,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1r61oa5"&&(K.innerHTML=Gn),ut=a(l),O=p(l,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1q8fgqb"&&(O.textContent=Xn),ct=a(l),r(ll.$$.fragment,l),Mt=a(l),Z=p(l,"IMG",{src:!0,width:!0,height:!0,alt:!0}),dt=a(l),r(el.$$.fragment,l),yt=a(l),tl=p(l,"P",{"data-svelte-h":!0}),m(tl)!=="svelte-kqnotf"&&(tl.innerHTML=Cn),ht=a(l),r(sl.$$.fragment,l),bt=a(l),nl=p(l,"TABLE",{"data-svelte-h":!0}),m(nl)!=="svelte-i6e2ex"&&(nl.innerHTML=Vn),Jt=a(l),r(al.$$.fragment,l),ft=a(l),il=p(l,"P",{"data-svelte-h":!0}),m(il)!=="svelte-vhijyl"&&(il.innerHTML=Nn),gt=a(l),r(pl.$$.fragment,l),wt=a(l),ml=p(l,"TABLE",{"data-svelte-h":!0}),m(ml)!=="svelte-v8z5s8"&&(ml.innerHTML=vn),Tt=a(l),r(ol.$$.fragment,l),Ut=a(l),rl=p(l,"P",{"data-svelte-h":!0}),m(rl)!=="svelte-1836mxv"&&(rl.innerHTML=_n),jt=a(l),r(ul.$$.fragment,l),Zt=a(l),cl=p(l,"TABLE",{"data-svelte-h":!0}),m(cl)!=="svelte-w6yzym"&&(cl.innerHTML=xn),Wt=a(l),r(Ml.$$.fragment,l),It=a(l),dl=p(l,"P",{"data-svelte-h":!0}),m(dl)!=="svelte-1q6nuso"&&(dl.innerHTML=kn),Gt=a(l),yl=p(l,"P",{"data-svelte-h":!0}),m(yl)!=="svelte-7xctqf"&&(yl.textContent=Rn),Xt=a(l),r(hl.$$.fragment,l),Bt=a(l),bl=p(l,"P",{"data-svelte-h":!0}),m(bl)!=="svelte-u4wwem"&&(bl.textContent=$n),Ct=a(l),Jl=p(l,"UL",{"data-svelte-h":!0}),m(Jl)!=="svelte-17e9k9s"&&(Jl.innerHTML=Sn),Vt=a(l),fl=p(l,"P",{"data-svelte-h":!0}),m(fl)!=="svelte-1a2m8iq"&&(fl.innerHTML=Yn),Nt=a(l),gl=p(l,"P",{"data-svelte-h":!0}),m(gl)!=="svelte-9niqj3"&&(gl.innerHTML=Qn),vt=a(l),r(wl.$$.fragment,l),_t=a(l),Tl=p(l,"P",{"data-svelte-h":!0}),m(Tl)!=="svelte-eias7g"&&(Tl.innerHTML=En),xt=a(l),Ul=p(l,"P",{"data-svelte-h":!0}),m(Ul)!=="svelte-kxhd34"&&(Ul.innerHTML=Fn),kt=a(l),jl=p(l,"P",{"data-svelte-h":!0}),m(jl)!=="svelte-17tzr0c"&&(jl.innerHTML=Hn),Rt=a(l),r(Zl.$$.fragment,l),$t=a(l),r(Wl.$$.fragment,l),St=a(l),Il=p(l,"P",{"data-svelte-h":!0}),m(Il)!=="svelte-8q3qyn"&&(Il.textContent=Ln),Yt=a(l),r(Gl.$$.fragment,l),Qt=a(l),W=p(l,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Et=a(l),r(Xl.$$.fragment,l),Ft=a(l),Bl=p(l,"P",{"data-svelte-h":!0}),m(Bl)!=="svelte-luub4o"&&(Bl.innerHTML=qn),Ht=a(l),r(Cl.$$.fragment,l),Lt=a(l),Vl=p(l,"TABLE",{"data-svelte-h":!0}),m(Vl)!=="svelte-1s0d0pv"&&(Vl.innerHTML=An),zt=a(l),r(Nl.$$.fragment,l),qt=a(l),vl=p(l,"P",{"data-svelte-h":!0}),m(vl)!=="svelte-11fbw00"&&(vl.innerHTML=Dn),At=a(l),r(_l.$$.fragment,l),Dt=a(l),xl=p(l,"TABLE",{"data-svelte-h":!0}),m(xl)!=="svelte-18741xe"&&(xl.innerHTML=Pn),Pt=a(l),r(kl.$$.fragment,l),Kt=a(l),Rl=p(l,"P",{"data-svelte-h":!0}),m(Rl)!=="svelte-1usq821"&&(Rl.innerHTML=Kn),Ot=a(l),$l=p(l,"OL",{"data-svelte-h":!0}),m($l)!=="svelte-6p4eqi"&&($l.innerHTML=On),ls=a(l),r(Sl.$$.fragment,l),es=a(l),r(Yl.$$.fragment,l),ts=a(l),I=p(l,"IMG",{src:!0,width:!0,height:!0,alt:!0}),ss=a(l),r(Ql.$$.fragment,l),ns=a(l),r(El.$$.fragment,l),as=a(l),Fl=p(l,"TABLE",{"data-svelte-h":!0}),m(Fl)!=="svelte-1s7g03c"&&(Fl.innerHTML=ea),is=a(l),r(v.$$.fragment,l),ps=a(l),r(Hl.$$.fragment,l),ms=a(l),Ll=p(l,"P",{"data-svelte-h":!0}),m(Ll)!=="svelte-1ud6a8q"&&(Ll.innerHTML=ta),os=a(l),zl=p(l,"P",{"data-svelte-h":!0}),m(zl)!=="svelte-1ayizu6"&&(zl.innerHTML=sa),rs=a(l),ql=p(l,"UL",{"data-svelte-h":!0}),m(ql)!=="svelte-r4tdj0"&&(ql.innerHTML=na),us=a(l),Al=p(l,"P",{"data-svelte-h":!0}),m(Al)!=="svelte-c4lhmw"&&(Al.innerHTML=aa),cs=a(l),r(Dl.$$.fragment,l),Ms=a(l),Pl=p(l,"P",{"data-svelte-h":!0}),m(Pl)!=="svelte-1s0vvjb"&&(Pl.innerHTML=ia),ds=a(l),r(Kl.$$.fragment,l),ys=a(l),Ol=p(l,"P",{"data-svelte-h":!0}),m(Ol)!=="svelte-51zp7x"&&(Ol.innerHTML=pa),hs=a(l),r(le.$$.fragment,l),bs=a(l),r(ee.$$.fragment,l),Js=a(l),te=p(l,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1ebkvay"&&(te.textContent=ma),fs=a(l),se=p(l,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1s0vvjb"&&(se.innerHTML=oa),gs=a(l),r(ne.$$.fragment,l),ws=a(l),ae=p(l,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-51zp7x"&&(ae.innerHTML=ra),Ts=a(l),r(ie.$$.fragment,l),Us=a(l),r(pe.$$.fragment,l),js=a(l),me=p(l,"P",{"data-svelte-h":!0}),m(me)!=="svelte-10h80ju"&&(me.innerHTML=ua),Zs=a(l),oe=p(l,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-1ayizu6"&&(oe.innerHTML=ca),Ws=a(l),re=p(l,"UL",{"data-svelte-h":!0}),m(re)!=="svelte-t7g18i"&&(re.innerHTML=Ma),Is=a(l),ue=p(l,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-ohwj0a"&&(ue.innerHTML=da),Gs=a(l),r(ce.$$.fragment,l),Xs=a(l),r(Me.$$.fragment,l),Bs=a(l),r(de.$$.fragment,l),Cs=a(l),ye=p(l,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1ebkvay"&&(ye.textContent=ya),Vs=a(l),r(he.$$.fragment,l),Ns=a(l),r(_.$$.fragment,l),vs=a(l),r(be.$$.fragment,l),_s=a(l),r(Je.$$.fragment,l),xs=a(l),fe=p(l,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-k1lsm0"&&(fe.textContent=ha),ks=a(l),r(ge.$$.fragment,l),Rs=a(l),G=p(l,"IMG",{src:!0,width:!0,height:!0,alt:!0}),$s=a(l),r(we.$$.fragment,l),Ss=a(l),Te=p(l,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-15r2htw"&&(Te.textContent=Ja),Ys=a(l),r(Ue.$$.fragment,l),Qs=a(l),je=p(l,"P",{"data-svelte-h":!0}),m(je)!=="svelte-clsbw5"&&(je.innerHTML=fa),Es=a(l),Ze=p(l,"UL",{"data-svelte-h":!0}),m(Ze)!=="svelte-127fndl"&&(Ze.innerHTML=ga),Fs=a(l),r(We.$$.fragment,l),Hs=a(l),Ie=p(l,"UL",{"data-svelte-h":!0}),m(Ie)!=="svelte-zxjvv9"&&(Ie.innerHTML=wa),Ls=a(l),r(Ge.$$.fragment,l),zs=a(l),r(Xe.$$.fragment,l),qs=a(l),Be=p(l,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-92hvy2"&&(Be.textContent=Ta),As=a(l),Ce=p(l,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-e5xot3"&&(Ce.textContent=Ua),Ds=a(l),r(Ve.$$.fragment,l),Ps=a(l),X=p(l,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Ks=a(l),r(Ne.$$.fragment,l),Os=a(l),ve=p(l,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-ve8s8f"&&(ve.textContent=Za),ln=a(l),_e=p(l,"UL",{"data-svelte-h":!0}),m(_e)!=="svelte-16kkb80"&&(_e.innerHTML=Wa),en=a(l),r(xe.$$.fragment,l),tn=a(l),ke=p(l,"UL",{"data-svelte-h":!0}),m(ke)!=="svelte-1pbmybe"&&(ke.innerHTML=Ia),sn=a(l),r(Re.$$.fragment,l),nn=a(l),B=p(l,"IMG",{src:!0,width:!0,height:!0,alt:!0}),an=a(l),r($e.$$.fragment,l),pn=a(l),r(Se.$$.fragment,l),mn=a(l),r(Ye.$$.fragment,l),on=a(l),r(Qe.$$.fragment,l),rn=a(l),r(Ee.$$.fragment,l),un=a(l),C=p(l,"IMG",{src:!0,width:!0,height:!0,alt:!0}),cn=a(l),Fe=p(l,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-xbi604"&&(Fe.innerHTML=Ba),Mn=a(l),Le=p(l,"P",{}),va(Le).forEach(t),this.h()},h(){h(y,"name","hf:doc:metadata"),h(y,"content",Ha),He(Z.src,Bn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/01-sd-image.png")||h(Z,"src",Bn),h(Z,"width","256"),h(Z,"height","256"),h(Z,"alt","stable diffusion generated image"),He(W.src,zn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/02-sdxl-image.jpeg")||h(W,"src",zn),h(W,"width","256"),h(W,"height","256"),h(W,"alt","sdxl generated image"),He(I.src,la="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/08-sdxl-base-refine.png")||h(I,"src",la),h(I,"width","256"),h(I,"height","256"),h(I,"alt","sdxl base + refiner"),He(G.src,ba="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/03-sd-lora.png")||h(G,"src",ba),h(G,"width","256"),h(G,"height","256"),h(G,"alt","stable diffusion generated image with LoRA adapter."),He(X.src,ja="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/10-sd-text2img-controlnet.png?download=true")||h(X,"src",ja),h(X,"width","768"),h(X,"height","256"),h(X,"alt","stable diffusion 1.5 generated image with controlnet."),He(B.src,Ga="https://huggingface.co/datasets/Jingya/document_images/resolve/main/optimum/neuron/multicontrolnet.png")||h(B,"src",Ga),h(B,"width","768"),h(B,"height","256"),h(B,"alt","stable diffusion 1.5 generated image with OpenPose and Depth controlnet."),He(C.src,Xa="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/12-sdxl-text2img-controlnet.png?download=true")||h(C,"src",Xa),h(C,"width","768"),h(C,"height","256"),h(C,"alt","stable diffusion xl generated image with controlnet.")},m(l,e){Sa(document.head,y),s(l,T,e),s(l,f,e),s(l,g,e),u(j,l,e),s(l,w,e),u(U,l,e),s(l,ze,e),s(l,x,e),s(l,qe,e),s(l,k,e),s(l,Ae,e),s(l,R,e),s(l,De,e),u($,l,e),s(l,Pe,e),u(S,l,e),s(l,Ke,e),s(l,Y,e),s(l,Oe,e),s(l,Q,e),s(l,lt,e),s(l,E,e),s(l,et,e),s(l,F,e),s(l,tt,e),s(l,H,e),s(l,st,e),u(L,l,e),s(l,nt,e),s(l,z,e),s(l,at,e),s(l,q,e),s(l,it,e),s(l,A,e),s(l,pt,e),u(N,l,e),s(l,mt,e),u(D,l,e),s(l,ot,e),u(P,l,e),s(l,rt,e),s(l,K,e),s(l,ut,e),s(l,O,e),s(l,ct,e),u(ll,l,e),s(l,Mt,e),s(l,Z,e),s(l,dt,e),u(el,l,e),s(l,yt,e),s(l,tl,e),s(l,ht,e),u(sl,l,e),s(l,bt,e),s(l,nl,e),s(l,Jt,e),u(al,l,e),s(l,ft,e),s(l,il,e),s(l,gt,e),u(pl,l,e),s(l,wt,e),s(l,ml,e),s(l,Tt,e),u(ol,l,e),s(l,Ut,e),s(l,rl,e),s(l,jt,e),u(ul,l,e),s(l,Zt,e),s(l,cl,e),s(l,Wt,e),u(Ml,l,e),s(l,It,e),s(l,dl,e),s(l,Gt,e),s(l,yl,e),s(l,Xt,e),u(hl,l,e),s(l,Bt,e),s(l,bl,e),s(l,Ct,e),s(l,Jl,e),s(l,Vt,e),s(l,fl,e),s(l,Nt,e),s(l,gl,e),s(l,vt,e),u(wl,l,e),s(l,_t,e),s(l,Tl,e),s(l,xt,e),s(l,Ul,e),s(l,kt,e),s(l,jl,e),s(l,Rt,e),u(Zl,l,e),s(l,$t,e),u(Wl,l,e),s(l,St,e),s(l,Il,e),s(l,Yt,e),u(Gl,l,e),s(l,Qt,e),s(l,W,e),s(l,Et,e),u(Xl,l,e),s(l,Ft,e),s(l,Bl,e),s(l,Ht,e),u(Cl,l,e),s(l,Lt,e),s(l,Vl,e),s(l,zt,e),u(Nl,l,e),s(l,qt,e),s(l,vl,e),s(l,At,e),u(_l,l,e),s(l,Dt,e),s(l,xl,e),s(l,Pt,e),u(kl,l,e),s(l,Kt,e),s(l,Rl,e),s(l,Ot,e),s(l,$l,e),s(l,ls,e),u(Sl,l,e),s(l,es,e),u(Yl,l,e),s(l,ts,e),s(l,I,e),s(l,ss,e),u(Ql,l,e),s(l,ns,e),u(El,l,e),s(l,as,e),s(l,Fl,e),s(l,is,e),u(v,l,e),s(l,ps,e),u(Hl,l,e),s(l,ms,e),s(l,Ll,e),s(l,os,e),s(l,zl,e),s(l,rs,e),s(l,ql,e),s(l,us,e),s(l,Al,e),s(l,cs,e),u(Dl,l,e),s(l,Ms,e),s(l,Pl,e),s(l,ds,e),u(Kl,l,e),s(l,ys,e),s(l,Ol,e),s(l,hs,e),u(le,l,e),s(l,bs,e),u(ee,l,e),s(l,Js,e),s(l,te,e),s(l,fs,e),s(l,se,e),s(l,gs,e),u(ne,l,e),s(l,ws,e),s(l,ae,e),s(l,Ts,e),u(ie,l,e),s(l,Us,e),u(pe,l,e),s(l,js,e),s(l,me,e),s(l,Zs,e),s(l,oe,e),s(l,Ws,e),s(l,re,e),s(l,Is,e),s(l,ue,e),s(l,Gs,e),u(ce,l,e),s(l,Xs,e),u(Me,l,e),s(l,Bs,e),u(de,l,e),s(l,Cs,e),s(l,ye,e),s(l,Vs,e),u(he,l,e),s(l,Ns,e),u(_,l,e),s(l,vs,e),u(be,l,e),s(l,_s,e),u(Je,l,e),s(l,xs,e),s(l,fe,e),s(l,ks,e),u(ge,l,e),s(l,Rs,e),s(l,G,e),s(l,$s,e),u(we,l,e),s(l,Ss,e),s(l,Te,e),s(l,Ys,e),u(Ue,l,e),s(l,Qs,e),s(l,je,e),s(l,Es,e),s(l,Ze,e),s(l,Fs,e),u(We,l,e),s(l,Hs,e),s(l,Ie,e),s(l,Ls,e),u(Ge,l,e),s(l,zs,e),u(Xe,l,e),s(l,qs,e),s(l,Be,e),s(l,As,e),s(l,Ce,e),s(l,Ds,e),u(Ve,l,e),s(l,Ps,e),s(l,X,e),s(l,Ks,e),u(Ne,l,e),s(l,Os,e),s(l,ve,e),s(l,ln,e),s(l,_e,e),s(l,en,e),u(xe,l,e),s(l,tn,e),s(l,ke,e),s(l,sn,e),u(Re,l,e),s(l,nn,e),s(l,B,e),s(l,an,e),u($e,l,e),s(l,pn,e),u(Se,l,e),s(l,mn,e),u(Ye,l,e),s(l,on,e),u(Qe,l,e),s(l,rn,e),u(Ee,l,e),s(l,un,e),s(l,C,e),s(l,cn,e),s(l,Fe,e),s(l,Mn,e),s(l,Le,e),dn=!0},p(l,[e]){const Ca={};e&2&&(Ca.$$scope={dirty:e,ctx:l}),N.$set(Ca);const Va={};e&2&&(Va.$$scope={dirty:e,ctx:l}),v.$set(Va);const Na={};e&2&&(Na.$$scope={dirty:e,ctx:l}),_.$set(Na)},i(l){dn||(c(j.$$.fragment,l),c(U.$$.fragment,l),c($.$$.fragment,l),c(S.$$.fragment,l),c(L.$$.fragment,l),c(N.$$.fragment,l),c(D.$$.fragment,l),c(P.$$.fragment,l),c(ll.$$.fragment,l),c(el.$$.fragment,l),c(sl.$$.fragment,l),c(al.$$.fragment,l),c(pl.$$.fragment,l),c(ol.$$.fragment,l),c(ul.$$.fragment,l),c(Ml.$$.fragment,l),c(hl.$$.fragment,l),c(wl.$$.fragment,l),c(Zl.$$.fragment,l),c(Wl.$$.fragment,l),c(Gl.$$.fragment,l),c(Xl.$$.fragment,l),c(Cl.$$.fragment,l),c(Nl.$$.fragment,l),c(_l.$$.fragment,l),c(kl.$$.fragment,l),c(Sl.$$.fragment,l),c(Yl.$$.fragment,l),c(Ql.$$.fragment,l),c(El.$$.fragment,l),c(v.$$.fragment,l),c(Hl.$$.fragment,l),c(Dl.$$.fragment,l),c(Kl.$$.fragment,l),c(le.$$.fragment,l),c(ee.$$.fragment,l),c(ne.$$.fragment,l),c(ie.$$.fragment,l),c(pe.$$.fragment,l),c(ce.$$.fragment,l),c(Me.$$.fragment,l),c(de.$$.fragment,l),c(he.$$.fragment,l),c(_.$$.fragment,l),c(be.$$.fragment,l),c(Je.$$.fragment,l),c(ge.$$.fragment,l),c(we.$$.fragment,l),c(Ue.$$.fragment,l),c(We.$$.fragment,l),c(Ge.$$.fragment,l),c(Xe.$$.fragment,l),c(Ve.$$.fragment,l),c(Ne.$$.fragment,l),c(xe.$$.fragment,l),c(Re.$$.fragment,l),c($e.$$.fragment,l),c(Se.$$.fragment,l),c(Ye.$$.fragment,l),c(Qe.$$.fragment,l),c(Ee.$$.fragment,l),dn=!0)},o(l){M(j.$$.fragment,l),M(U.$$.fragment,l),M($.$$.fragment,l),M(S.$$.fragment,l),M(L.$$.fragment,l),M(N.$$.fragment,l),M(D.$$.fragment,l),M(P.$$.fragment,l),M(ll.$$.fragment,l),M(el.$$.fragment,l),M(sl.$$.fragment,l),M(al.$$.fragment,l),M(pl.$$.fragment,l),M(ol.$$.fragment,l),M(ul.$$.fragment,l),M(Ml.$$.fragment,l),M(hl.$$.fragment,l),M(wl.$$.fragment,l),M(Zl.$$.fragment,l),M(Wl.$$.fragment,l),M(Gl.$$.fragment,l),M(Xl.$$.fragment,l),M(Cl.$$.fragment,l),M(Nl.$$.fragment,l),M(_l.$$.fragment,l),M(kl.$$.fragment,l),M(Sl.$$.fragment,l),M(Yl.$$.fragment,l),M(Ql.$$.fragment,l),M(El.$$.fragment,l),M(v.$$.fragment,l),M(Hl.$$.fragment,l),M(Dl.$$.fragment,l),M(Kl.$$.fragment,l),M(le.$$.fragment,l),M(ee.$$.fragment,l),M(ne.$$.fragment,l),M(ie.$$.fragment,l),M(pe.$$.fragment,l),M(ce.$$.fragment,l),M(Me.$$.fragment,l),M(de.$$.fragment,l),M(he.$$.fragment,l),M(_.$$.fragment,l),M(be.$$.fragment,l),M(Je.$$.fragment,l),M(ge.$$.fragment,l),M(we.$$.fragment,l),M(Ue.$$.fragment,l),M(We.$$.fragment,l),M(Ge.$$.fragment,l),M(Xe.$$.fragment,l),M(Ve.$$.fragment,l),M(Ne.$$.fragment,l),M(xe.$$.fragment,l),M(Re.$$.fragment,l),M($e.$$.fragment,l),M(Se.$$.fragment,l),M(Ye.$$.fragment,l),M(Qe.$$.fragment,l),M(Ee.$$.fragment,l),dn=!1},d(l){l&&(t(T),t(f),t(g),t(w),t(ze),t(x),t(qe),t(k),t(Ae),t(R),t(De),t(Pe),t(Ke),t(Y),t(Oe),t(Q),t(lt),t(E),t(et),t(F),t(tt),t(H),t(st),t(nt),t(z),t(at),t(q),t(it),t(A),t(pt),t(mt),t(ot),t(rt),t(K),t(ut),t(O),t(ct),t(Mt),t(Z),t(dt),t(yt),t(tl),t(ht),t(bt),t(nl),t(Jt),t(ft),t(il),t(gt),t(wt),t(ml),t(Tt),t(Ut),t(rl),t(jt),t(Zt),t(cl),t(Wt),t(It),t(dl),t(Gt),t(yl),t(Xt),t(Bt),t(bl),t(Ct),t(Jl),t(Vt),t(fl),t(Nt),t(gl),t(vt),t(_t),t(Tl),t(xt),t(Ul),t(kt),t(jl),t(Rt),t($t),t(St),t(Il),t(Yt),t(Qt),t(W),t(Et),t(Ft),t(Bl),t(Ht),t(Lt),t(Vl),t(zt),t(qt),t(vl),t(At),t(Dt),t(xl),t(Pt),t(Kt),t(Rl),t(Ot),t($l),t(ls),t(es),t(ts),t(I),t(ss),t(ns),t(as),t(Fl),t(is),t(ps),t(ms),t(Ll),t(os),t(zl),t(rs),t(ql),t(us),t(Al),t(cs),t(Ms),t(Pl),t(ds),t(ys),t(Ol),t(hs),t(bs),t(Js),t(te),t(fs),t(se),t(gs),t(ws),t(ae),t(Ts),t(Us),t(js),t(me),t(Zs),t(oe),t(Ws),t(re),t(Is),t(ue),t(Gs),t(Xs),t(Bs),t(Cs),t(ye),t(Vs),t(Ns),t(vs),t(_s),t(xs),t(fe),t(ks),t(Rs),t(G),t($s),t(Ss),t(Te),t(Ys),t(Qs),t(je),t(Es),t(Ze),t(Fs),t(Hs),t(Ie),t(Ls),t(zs),t(qs),t(Be),t(As),t(Ce),t(Ds),t(Ps),t(X),t(Ks),t(Os),t(ve),t(ln),t(_e),t(en),t(tn),t(ke),t(sn),t(nn),t(B),t(an),t(pn),t(mn),t(on),t(rn),t(un),t(C),t(cn),t(Fe),t(Mn),t(Le)),t(y),d(j,l),d(U,l),d($,l),d(S,l),d(L,l),d(N,l),d(D,l),d(P,l),d(ll,l),d(el,l),d(sl,l),d(al,l),d(pl,l),d(ol,l),d(ul,l),d(Ml,l),d(hl,l),d(wl,l),d(Zl,l),d(Wl,l),d(Gl,l),d(Xl,l),d(Cl,l),d(Nl,l),d(_l,l),d(kl,l),d(Sl,l),d(Yl,l),d(Ql,l),d(El,l),d(v,l),d(Hl,l),d(Dl,l),d(Kl,l),d(le,l),d(ee,l),d(ne,l),d(ie,l),d(pe,l),d(ce,l),d(Me,l),d(de,l),d(he,l),d(_,l),d(be,l),d(Je,l),d(ge,l),d(we,l),d(Ue,l),d(We,l),d(Ge,l),d(Xe,l),d(Ve,l),d(Ne,l),d(xe,l),d(Re,l),d($e,l),d(Se,l),d(Ye,l),d(Qe,l),d(Ee,l)}}}const Ha='{"title":"Generate images with Stable Diffusion models on AWS Inferentia","local":"generate-images-with-stable-diffusion-models-on-aws-inferentia","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Compile Stable Diffusion","local":"compile-stable-diffusion","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Compile Stable Diffusion XL","local":"compile-stable-diffusion-xl","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"Refine Image Quality","local":"refine-image-quality","sections":[{"title":"Base + refiner model","local":"base--refiner-model","sections":[],"depth":4},{"title":"Base to refiner model","local":"base-to-refiner-model","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Compile LCM","local":"compile-lcm","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL Turbo","local":"stable-diffusion-xl-turbo","sections":[{"title":"Compile SDXL Turbo","local":"compile-sdxl-turbo","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[{"title":"LoRA","local":"lora","sections":[],"depth":3}],"depth":2},{"title":"ControlNet","local":"controlnet","sections":[{"title":"Compile ControlNet","local":"compile-controlnet","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"MultiControlNet","local":"multicontrolnet","sections":[],"depth":3}],"depth":2},{"title":"ControlNet with Stable Diffusion XL","local":"controlnet-with-stable-diffusion-xl","sections":[{"title":"Compile","local":"compile","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function La(V){return xa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ka extends ka{constructor(y){super(),Ra(this,y,La,Fa,_a,{})}}export{Ka as component};
