import{s as Is,o as gs,n as Il}from"../chunks/scheduler.9039eef2.js";import{S as Bs,i as Gs,g as i,s as a,r as M,A as Ws,h as o,f as l,c as n,j as Cs,u as m,x as p,k as bl,y as Zs,a as s,v as c,d as u,t as d,w as h}from"../chunks/index.cdcc3d35.js";import{T as Cl}from"../chunks/Tip.6f74db41.js";import{C as U}from"../chunks/CodeBlock.e3ac94d9.js";import{H as g}from"../chunks/Heading.96ce3702.js";function ks(I){let r,f=`While we will use <code>Llama-3 8B</code> in this tutorial, it is completely possible to use other models, simply by swtiching the <code>model_id</code>.
For instance, it is possible to fine-tune:`,y,w,b='<li>Mistral models, such as  <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.2" rel="nofollow">Mistral 7b (<code>mistralai/Mistral-7B-Instruct-v0.3</code>)</a></li> <li>Llama-2 models, such as <a href="https://huggingface.co/meta-llama/Llama-2-7b-hf" rel="nofollow">Llama-2 7b (<code>meta-llama/Llama-2-7b-hf</code>)</a></li>',T,J,Pe="And many others!";return{c(){r=i("p"),r.innerHTML=f,y=a(),w=i("ul"),w.innerHTML=b,T=a(),J=i("p"),J.textContent=Pe},l(j){r=o(j,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1f24nyx"&&(r.innerHTML=f),y=n(j),w=o(j,"UL",{"data-svelte-h":!0}),p(w)!=="svelte-1fsabqd"&&(w.innerHTML=b),T=n(j),J=o(j,"P",{"data-svelte-h":!0}),p(J)!=="svelte-yii95m"&&(J.textContent=Pe)},m(j,C){s(j,r,C),s(j,y,C),s(j,w,C),s(j,T,C),s(j,J,C)},p:Il,d(j){j&&(l(r),l(y),l(w),l(T),l(J))}}}function _s(I){let r,f='If you want to know more about distributed training you can take a look at the <a href="https://huggingface.co/docs/optimum-neuron/guides/distributed_training" rel="nofollow">documentation</a>.';return{c(){r=i("p"),r.innerHTML=f},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-yp02re"&&(r.innerHTML=f)},m(y,w){s(y,r,w)},p:Il,d(y){y&&l(r)}}}function vs(I){let r,f='This script is a minimalistic version of our official example training script to run causal language modeling fine-tuning, called <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/language-modeling/run_clm.py" rel="nofollow">run_clm.py</a>. For the sake of this tutorial, we tried to get rid of anything that is not necessary, but if you want to do more custom things, maybe the solution is already implemented in <code>run_clm.py</code>!',y,w,b="Also, these scripts are more designed as templates than final scripts. Feel free to take <code>finetune_llm.py</code> or <code>run_clm.py</code> and adapt them to your own needs!";return{c(){r=i("p"),r.innerHTML=f,y=a(),w=i("p"),w.innerHTML=b},l(T){r=o(T,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1lcd2cz"&&(r.innerHTML=f),y=n(T),w=o(T,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1k8wfq8"&&(w.innerHTML=b)},m(T,J){s(T,r,J),s(T,y,J),s(T,w,J)},p:Il,d(T){T&&(l(r),l(y),l(w))}}}function Xs(I){let r,f="Make sure to run this precompilation phase for around 10 training steps. It is usually enough to accumulate and compile all the graphs that will be needed during the actual training.";return{c(){r=i("p"),r.textContent=f},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1k7qt99"&&(r.textContent=f)},m(y,w){s(y,r,w)},p:Il,d(y){y&&l(r)}}}function $s(I){let r,f,y,w,b,T,J,Pe='<em>Note: The complete script for this tutorial can be downloaded <a href="https://github.com/huggingface/optimum-neuron/docs/source/training_tutorials/finetune_llm.py" rel="nofollow">here</a>.</em>',j,C,gl='This tutorial will teach you how to fine-tune open source LLMs like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B" rel="nofollow">Llama 3</a> on AWS Trainium. In our example, we are going to leverage the <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">Optimum Neuron</a>, <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> and <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">Datasets</a> libraries.',Ke,v,Bl="You will learn how to:",Oe,X,Gl='<li><a href="#1-setup-aws-environment">Setup AWS Environment</a></li> <li><a href="#2-load-and-prepare-the-dataset">Load and process the dataset</a></li> <li><a href="#3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer">Fine-tune Llama on AWS Trainium using the <code>NeuronTrainer</code></a></li> <li><a href="#4-launch-training">Launch Training</a></li> <li><a href="#5-evaluate-and-test-fine-tuned-llama-model">Evaluate and test fine-tuned Llama model</a></li>',et,B,tt,$,lt,R,Wl="Before starting this tutorial, you will need to setup your environment:",st,x,Zl='<li>Create an AWS Trainium instance. You can follow this <a href="https://huggingface.co/docs/optimum-neuron/guides/setup_aws_instance" rel="nofollow">guide</a> to create one.</li> <li>Make sure you are logged in on the Hugging Face Hub:</li>',at,V,nt,G,kl="<li>Check that you have access to the model. Some open source models are gated, meaning that users need to apply to the model owner to be able to use the model weights. Here we will be training Llama-3 8B, for which there are two possibilities:</li>",it,A,_l='<li>The official gated repo: <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B" rel="nofollow"><code>meta-llama/Meta-Llama-3-8B</code></a></li> <li>The non-official un-gated repo: <a href="https://huggingface.co/NousResearch/Meta-Llama-3-8B" rel="nofollow"><code>NousResearch/Meta-Llama-3-8B</code></a></li>',ot,W,vl='<li>Clone the Optimum Neuron repository, <strong>which contains the <a href="https://github.com/huggingface/optimum-neuron/docs/source/training_tutorials/finetune_llm.py" rel="nofollow">complete script</a> described in this tutorial:</strong></li>',pt,H,rt,Y,Mt,S,Xl='For this tutorial, we will use <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Dolly</a>, an open source dataset of instruction-following records on categories outlined in the <a href="https://arxiv.org/abs/2203.02155" rel="nofollow">InstructGPT paper</a>, including brainstorming, classification, closed QA, generation, information extraction, open QA, and summarization.',mt,z,$l="Example:",ct,N,ut,E,Rl="We can use the <code>load_dataset()</code> method from the 🤗 Datasets library to load the <code>dolly</code> dataset very easily.",dt,Q,ht,F,xl="To instruct tune our model we need to convert our structured examples into a collection of tasks described via instructions. We define a <code>format_dolly</code> that takes a raw sample and returns a string with our format instruction.",yt,L,wt,q,Vl="In addition to formatting our samples, we also want to pack multiple samples to one sequence to have a more efficient training. In other words, we are stacking multiple samples to one sequence and split them with an EOS Token. Packing/stacking samples can be done during training or before. Here, we will do it before training to save time.",Tt,P,Al="The following function <code>pack_dataset</code> takes a <code>dataset</code> and a <code>chunk_length</code> and returns a packed dataset:",Jt,D,jt,K,Hl="To summarize to prepare our dataset we will:",Ut,O,Yl="<li>Format our samples using the template method and add an EOS token at the end of each sample</li> <li>Tokenize our dataset to convert it from text to tokens</li> <li>Pack our dataset to 2048 tokens</li>",ft,ee,bt,te,Sl="After we processed the datasets we are going save it to disk. You could also save it to S3 or the Hugging Face Hub for later use.",Ct,le,zl="<em>Note: Packing and preprocessing your dataset can be run outside of the Trainium instance.</em>",It,se,gt,ae,Bt,ne,Nl='Normally you would use the <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a></strong> and <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a></strong> classes to fine-tune PyTorch-based transformer models.',Gt,ie,El="But together with AWS, we have developed the [~<code>optimum.neuron.NeuronTrainer</code>] to improve performance, robustness, and ease-of-use when training on Trainium instances. It can be used as a 1-to-1 replacement for the <code>Trainer</code>.",Wt,oe,Ql="Since Llama-3 8B is a big model it will not fit on a single Neuron core, we need distributed training. In Optimum Neuron we support:",Zt,pe,Fl='<li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/frameworks/torch/torch-neuronx/tutorials/training/zero1_gpt2.html" rel="nofollow">ZeRO-1</a>: It is an optimization of data-parallelism which consists in sharding the optimizer state (which usually represents half or more of the memory needed on the device) over the data-parallel ranks.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/tensor_parallelism_overview.html" rel="nofollow">Tensor Parallelism</a>: It is a technique which consists in sharding each of your model matrix-multiplications along a given axis (row or column) on multiple devices. It also known as intra-layer model parallelism. The number of devices to shard your parameters on is called the <code>tensor_parallel_size</code>.</li> <li><a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a>: It is an optimization over Tensor Parallelism which shards the activations on the sequence axis outside of the tensor parallel regions. It is useful because it saves memory by sharding the activations.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/pipeline_parallelism_overview.html" rel="nofollow">Pipeline Parallelism</a>: It consists in sharding the model block layers on multiple devices. It is also known as inter-layer model parallelism. The number of devices to shard your layers on is called the <code>pipeline_parallel_size</code>.</li>',kt,Z,_t,re,Ll=`Here, since we want to fine-tune an 8B model, we will not need to use pipeline parallelism.
Our training code will look as follows:`,vt,Me,Xt,me,ql="The key points here are:",$t,ce,Pl="<li>We use the <code>lazy_load_for_parallelism</code> context manager to lazily load the model. This will not load the full model weights on each worker, but instead only load the required weights (sharded or full). <strong>This is much more memory efficient, and often mandatory to use.</strong></li> <li>We use the [~<code>optimum.neuron.NeuronTrainer</code>] to perform training. It will take the lazily loaded model, along with the <code>training_args</code>, which are an instance of [~<code>optimum.neuron.NeuronTrainingArguments</code>], and will handle all the parallelization and training on the Neuron cores.</li>",Rt,ue,xt,de,Dl='We prepared a script called <a href="https://github.com/huggingface/optimum-neuron/docs/source/training_tutorials/finetune_llm.py" rel="nofollow">finetune_llm.py</a> summing up everything mentioned in this tutorial.',Vt,k,At,he,Ht,ye,Kl="When training models on AWS Trainium we first need to compile our model with our training arguments.",Yt,we,Ol='To overcome this, we added a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">model cache repository</a>, which allows us to use precompiled models from the Hugging Face Hub to skip the compilation step. But be careful: every change in the model configuration might lead to a new compilation, which could result in some cache misses.',St,Te,es='<em>Note: If your model configuration is not cached please open an issue on <a href="https://github.com/huggingface/optimum-neuron/issues" rel="nofollow">Github</a>, we are happy to include it.</em>',zt,Je,ts="The compilation command simply consists in calling your script as an input to the <code>neuron_parallel_compile</code> utility:",Nt,je,Et,_,Qt,Ue,ls="<em>Note: Compiling without a cache can take a while. It will also create dummy files in the <code>dolly_llama_sharded</code> during compilation you will have to remove them afterwards. We also need to add <code>MALLOC_ARENA_MAX=64</code> to limit the CPU allocation to avoid potential crashes, don’t remove it for now.</em>",Ft,fe,Lt,be,qt,Ce,ss="After compilation is done we can start our actual training with a similar command, we just need to remove the use of <code>neuron_parallel_compile</code>.",Pt,Ie,as="We will use <code>torchrun</code> to launch our training script. <code>torchrun</code> is a tool that automatically distributes a PyTorch model across multiple accelerators. We can pass the number of accelerators as <code>nproc_per_node</code> arguments alongside our hyperparameters.",Dt,ge,ns="The difference to the compilation command is that we changed from <code>max_steps=10</code> to <code>num_train_epochs=3</code>.",Kt,Be,is="Launch the training, with the following command.",Ot,Ge,el,We,os="That’s it, we successfully trained Llama-3 8B on AWS Trainium!",tl,Ze,ps="But before we can share and test our model we need to consolidate our model. Since we used Tensor Parallelism during training, we saved sharded versions of the checkpoints. We need to consolidate them now.",ll,ke,sl,_e,rs="The Optimum CLI provides a way of doing that very easily via the <code>optimum neuron consolidate [sharded_checkpoint] [output_dir]</code> command:",al,ve,nl,Xe,il,$e,Ms="As for training, to be able to run inference on AWS Trainium or AWS Inferentia2 we need to compile our model. In this case, we will use our Trainium instance for the inference test, but we recommend customer to switch to Inferentia2 for inference.",ol,Re,ms="Optimum Neuron implements similar to Transformers AutoModel classes for easy inference use. We will use the <code>NeuronModelForCausalLM</code> class to load our vanilla transformers checkpoint and convert it to neuron.",pl,xe,rl,Ve,cs="<em>Note: Inference compilation can take ~25minutes. Luckily, you need to only run this onces. Since you can save the model afterwards. If you are going to run on Inferentia2 you need to recompile again. The compilation is parameter and hardware specific.</em>",Ml,Ae,ml,He,us="We can now test inference, but have to make sure we format our input to our prompt format we used for fine-tuning. Therefore we created a helper method, which accepts a <code>dict</code> with our <code>instruction</code> and optionally a <code>context</code>.",cl,Ye,ul,Se,ds="Let’s test inference. First we test without a context.",dl,ze,hs="<em>Note: Inference is not expected to be super fast on AWS Trainium using 2 cores. For Inference we recommend using Inferentia2.</em>",hl,Ne,yl,Ee,ys="<p>AWS stands for Amazon Web Services. AWS is a suite of remote computing services offered by Amazon. The most widely used of these include Amazon Elastic Compute Cloud (Amazon EC2), which provides resizable compute capacity in the cloud; Amazon Simple Storage Service (Amazon S3), which is an object storage service; and Amazon Elastic Block Store (Amazon EBS), which is designed to provide high performance, durable block storage volumes for use with AWS instances. AWS also provides other services, such as AWS Identity and Access Management (IAM), a service that enables organizations to control access to their AWS resources, and AWS Key Management Service (AWS KMS), which helps customers create and control the use of encryption keys.</p>",wl,Qe,ws="That looks correct. Now, lets add some context, e.g. as you would do for RAG applications:",Tl,Fe,Jl,Le,Ts="<p>You can use the Optimum Neuron interface to train models on AWS Trainium.</p>",jl,qe,Js="Awesome, our model also correctly uses the provided context. We are done. Congrats on fine-tuning Llama on AWS Trainium.",Ul,De,fl;return b=new g({props:{title:"Fine-tune and Test Llama-3 8B on AWS Trainium",local:"fine-tune-and-test-llama-3-8b-on-aws-trainium",headingTag:"h1"}}),B=new Cl({props:{$$slots:{default:[ks]},$$scope:{ctx:I}}}),$=new g({props:{title:"1. Setup AWS Environment",local:"1-setup-aws-environment",headingTag:"h2"}}),V=new U({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMjAtLXRva2VuJTIwWU9VUl9UT0tFTg==",highlighted:"huggingface-cli login --token YOUR_TOKEN",wrap:!1}}),H=new U({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tbmV1cm9uLmdpdA==",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/optimum-neuron.git',wrap:!1}}),Y=new g({props:{title:"2. Load and prepare the dataset",local:"2-load-and-prepare-the-dataset",headingTag:"h2"}}),N=new U({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB3b3JsZCUyMG9mJTIwd2FyY3JhZnQlMjIlMkMlMEElMjAlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAlMjJXb3JsZCUyMG9mJTIwd2FyY3JhZnQlMjBpcyUyMGElMjBtYXNzaXZlJTIwb25saW5lJTIwbXVsdGklMjBwbGF5ZXIlMjByb2xlJTIwcGxheWluZyUyMGdhbWUuJTIwSXQlMjB3YXMlMjByZWxlYXNlZCUyMGluJTIwMjAwNCUyMGJ5JTIwYml6YXJyZSUyMGVudGVydGFpbm1lbnQlMjIlMEElN0Q=",highlighted:`{
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What is world of warcraft&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
  <span class="hljs-string">&quot;response&quot;</span>: <span class="hljs-string">&quot;World of warcraft is a massive online multi player role playing game. It was released in 2004 by bizarre entertainment&quot;</span>
}`,wrap:!1}}),Q=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZGF0YWJyaWNrcyUyRmRhdGFicmlja3MtZG9sbHktMTVrJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEFwcmludChmJTIyZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklN0QlMjIpJTBBcHJpbnQoZGF0YXNldCU1QnJhbmRyYW5nZShsZW4oZGF0YXNldCkpJTVEKSUwQSUyMyUyMGRhdGFzZXQlMjBzaXplJTNBJTIwMTUwMTE=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-comment"># Load dataset from the hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(dataset[randrange(<span class="hljs-built_in">len</span>(dataset))])
<span class="hljs-comment"># dataset size: 15011</span>`,wrap:!1}}),L=new U({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5KHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBpbnN0cnVjdGlvbiUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiU1Q24lN0JzYW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwY29udGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBDb250ZXh0JTVDbiU3QnNhbXBsZSU1Qidjb250ZXh0JyU1RCU3RCUyMiUyMGlmJTIwbGVuKHNhbXBsZSU1QiUyMmNvbnRleHQlMjIlNUQpJTIwJTNFJTIwMCUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiU3QnNhbXBsZSU1QidyZXNwb25zZSclNUQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjBqb2luJTIwYWxsJTIwdGhlJTIwcGFydHMlMjB0b2dldGhlciUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;context&quot;</span>]) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;response&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-comment"># join all the parts together</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt`,wrap:!1}}),D=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial
<span class="hljs-keyword">from</span> itertools <span class="hljs-keyword">import</span> chain

<span class="hljs-comment"># empty list to save remainder from batches to use in next batch</span>
remainder = {<span class="hljs-string">&quot;input_ids&quot;</span>: [], <span class="hljs-string">&quot;attention_mask&quot;</span>: [], <span class="hljs-string">&quot;token_type_ids&quot;</span>: []}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">pack_dataset</span>(<span class="hljs-params">dataset, chunk_length=<span class="hljs-number">2048</span></span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Chunking dataset into chunks of <span class="hljs-subst">{chunk_length}</span> tokens.&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">chunk</span>(<span class="hljs-params">sample, chunk_length=chunk_length</span>):
        <span class="hljs-comment"># define global remainder variable to save remainder from batches to use in next batch</span>
        <span class="hljs-keyword">global</span> remainder
        <span class="hljs-comment"># Concatenate all texts and add remainder from previous batch</span>
        concatenated_examples = {k: <span class="hljs-built_in">list</span>(chain(*sample[k])) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> sample.keys()}
        concatenated_examples = {k: remainder[k] + concatenated_examples[k] <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> concatenated_examples.keys()}
        <span class="hljs-comment"># get total number of tokens for batch</span>
        batch_total_length = <span class="hljs-built_in">len</span>(concatenated_examples[<span class="hljs-built_in">list</span>(sample.keys())[<span class="hljs-number">0</span>]])

        <span class="hljs-comment"># get max number of chunks for batch</span>
        <span class="hljs-keyword">if</span> batch_total_length &gt;= chunk_length:
            batch_chunk_length = (batch_total_length // chunk_length) * chunk_length

        <span class="hljs-comment"># Split by chunks of max_len.</span>
        result = {
            k: [t[i : i + chunk_length] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, batch_chunk_length, chunk_length)]
            <span class="hljs-keyword">for</span> k, t <span class="hljs-keyword">in</span> concatenated_examples.items()
        }
        <span class="hljs-comment"># add remainder to global variable for next batch</span>
        remainder = {k: concatenated_examples[k][batch_chunk_length:] <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> concatenated_examples.keys()}
        <span class="hljs-comment"># prepare labels</span>
        result[<span class="hljs-string">&quot;labels&quot;</span>] = result[<span class="hljs-string">&quot;input_ids&quot;</span>].copy()
        <span class="hljs-keyword">return</span> result

    <span class="hljs-comment"># tokenize and chunk dataset</span>
    lm_dataset = dataset.<span class="hljs-built_in">map</span>(
        partial(chunk, chunk_length=chunk_length),
        batched=<span class="hljs-literal">True</span>,
    )
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total number of samples: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(lm_dataset)}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> lm_dataset`,wrap:!1}}),ee=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwcmFuZG9tJTIwaW1wb3J0JTIwcmFuZGludCUwQSUwQSUyMyUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwbW9kZWwlMjBpZCUyMCUwQSUyMyUyMG1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04QiUyMiUyMCUyMyUyMGdhdGVkJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJOb3VzUmVzZWFyY2glMkZNZXRhLUxsYW1hLTMtOEIlMjIlMjAlMjMlMjB1bmdhdGVkJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBJTIzJTIwdGVtcGxhdGUlMjBkYXRhc2V0JTIwdG8lMjBhZGQlMjBwcm9tcHQlMjB0byUyMGVhY2glMjBzYW1wbGUlMEFkZWYlMjB0ZW1wbGF0ZV9kYXRhc2V0KHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEJTIwJTNEJTIwZiUyMiU3QmZvcm1hdF9kb2xseShzYW1wbGUpJTdEJTdCdG9rZW5pemVyLmVvc190b2tlbiU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNhbXBsZSUwQSUwQSUyMyUyMGFwcGx5JTIwcHJvbXB0JTIwdGVtcGxhdGUlMjBwZXIlMjBzYW1wbGUlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAodGVtcGxhdGVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEbGlzdChkYXRhc2V0LmZlYXR1cmVzKSklMEElMEElMjMlMjBwcmludCUyMHJhbmRvbSUyMHNhbXBsZSUwQXByaW50KGRhdGFzZXQlNUJyYW5kaW50KDAlMkMlMjBsZW4oZGF0YXNldCkpJTVEJTVCJTIydGV4dCUyMiU1RCklMEElMEElMjMlMjB0b2tlbml6ZSUyMGRhdGFzZXQlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwbGFtYmRhJTIwc2FtcGxlJTNBJTIwdG9rZW5pemVyKHNhbXBsZSU1QiUyMnRleHQlMjIlNUQpJTJDJTIwYmF0Y2hlZCUzRFRydWUlMkMlMjByZW1vdmVfY29sdW1ucyUzRGxpc3QoZGF0YXNldC5mZWF0dXJlcyklMEEpJTBBJTBBJTIzJTIwY2h1bmslMjBkYXRhc2V0JTBBbG1fZGF0YXNldCUyMCUzRCUyMHBhY2tfZGF0YXNldChkYXRhc2V0JTJDJTIwY2h1bmtfbGVuZ3RoJTNEMjA0OCklMjAlMjMlMjBXZSUyMHVzZSUyMDIwNDglMjBhcyUyMHRoZSUyMG1heGltdW0lMjBsZW5ndGglMjBmb3IlMjBwYWNraW5n",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randint

<span class="hljs-comment"># Hugging Face Hub model id </span>
<span class="hljs-comment"># model_id = &quot;meta-llama/Meta-Llama-3-8B&quot; # gated</span>
model_id = <span class="hljs-string">&quot;NousResearch/Meta-Llama-3-8B&quot;</span> <span class="hljs-comment"># ungated</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-comment"># template dataset to add prompt to each sample</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">template_dataset</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;text&quot;</span>] = <span class="hljs-string">f&quot;<span class="hljs-subst">{format_dolly(sample)}</span><span class="hljs-subst">{tokenizer.eos_token}</span>&quot;</span>
    <span class="hljs-keyword">return</span> sample

<span class="hljs-comment"># apply prompt template per sample</span>
dataset = dataset.<span class="hljs-built_in">map</span>(template_dataset, remove_columns=<span class="hljs-built_in">list</span>(dataset.features))

<span class="hljs-comment"># print random sample</span>
<span class="hljs-built_in">print</span>(dataset[randint(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset))][<span class="hljs-string">&quot;text&quot;</span>])

<span class="hljs-comment"># tokenize dataset</span>
dataset = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> sample: tokenizer(sample[<span class="hljs-string">&quot;text&quot;</span>]), batched=<span class="hljs-literal">True</span>, remove_columns=<span class="hljs-built_in">list</span>(dataset.features)
)

<span class="hljs-comment"># chunk dataset</span>
lm_dataset = pack_dataset(dataset, chunk_length=<span class="hljs-number">2048</span>) <span class="hljs-comment"># We use 2048 as the maximum length for packing</span>`,wrap:!1}}),se=new U({props:{code:"JTIzJTIwc2F2ZSUyMHRyYWluX2RhdGFzZXQlMjB0byUyMGRpc2slMEFkYXRhc2V0X3BhdGglMjAlM0QlMjAlMjJ0b2tlbml6ZWRfZG9sbHklMjIlMEFsbV9kYXRhc2V0LnNhdmVfdG9fZGlzayhkYXRhc2V0X3BhdGgp",highlighted:`<span class="hljs-comment"># save train_dataset to disk</span>
dataset_path = <span class="hljs-string">&quot;tokenized_dolly&quot;</span>
lm_dataset.save_to_disk(dataset_path)`,wrap:!1}}),ae=new g({props:{title:"3. Fine-tune Llama on AWS Trainium using the NeuronTrainer",local:"3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer",headingTag:"h2"}}),Z=new Cl({props:{$$slots:{default:[_s]},$$scope:{ctx:I}}}),Me=new U({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5lciUyMGFzJTIwVHJhaW5lciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5kaXN0cmlidXRlZCUyMGltcG9ydCUyMGxhenlfbG9hZF9mb3JfcGFyYWxsZWxpc20lMEElMEElMjMlMjBEZWZpbmUlMjB0aGUlMjB0ZW5zb3JfcGFyYWxsZWxfc2l6ZSUwQXRlbnNvcl9wYXJhbGxlbF9zaXplJTIwJTNEJTIwOCUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWdnaW5nJTIwZmFjZSUyMEh1YiUyMCUwQXdpdGglMjBsYXp5X2xvYWRfZm9yX3BhcmFsbGVsaXNtKHRlbnNvcl9wYXJhbGxlbF9zaXplJTNEdGVuc29yX3BhcmFsbGVsX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGVmYXVsdF9kYXRhX2NvbGxhdG9yJTJDJTIwJTIwJTIzJTIwbm8lMjBzcGVjaWFsJTIwY29sbGF0b3IlMjBuZWVkZWQlMjBzaW5jZSUyMHdlJTIwc3RhY2tlZCUyMHRoZSUyMGRhdGFzZXQlMEEpJTBBJTBBJTIzJTIwU3RhcnQlMjB0cmFpbmluZyUwQXRyYWluZXIudHJhaW4oKSUwQSUwQXRyYWluZXIuc2F2ZV9tb2RlbCgpJTIwJTIwJTIzJTIwc2F2ZXMlMjB0aGUlMjB0b2tlbml6ZXIlMjB0b28lMjBmb3IlMjBlYXN5JTIwdXBsb2Fk",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer <span class="hljs-keyword">as</span> Trainer
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> lazy_load_for_parallelism

<span class="hljs-comment"># Define the tensor_parallel_size</span>
tensor_parallel_size = <span class="hljs-number">8</span>

<span class="hljs-comment"># Load model from the Hugging face Hub </span>
<span class="hljs-keyword">with</span> lazy_load_for_parallelism(tensor_parallel_size=tensor_parallel_size):
    model = AutoModelForCausalLM.from_pretrained(model_id)

trainer = Trainer(
    model=model,
    tokenizer=tokenizer,
    args=training_args,
    train_dataset=dataset,
    data_collator=default_data_collator,  <span class="hljs-comment"># no special collator needed since we stacked the dataset</span>
)

<span class="hljs-comment"># Start training</span>
trainer.train()

trainer.save_model()  <span class="hljs-comment"># saves the tokenizer too for easy upload</span>`,wrap:!1}}),ue=new g({props:{title:"4. Launch Training",local:"4-launch-training",headingTag:"h2"}}),k=new Cl({props:{$$slots:{default:[vs]},$$scope:{ctx:I}}}),he=new g({props:{title:"Precompilation",local:"precompilation",headingTag:"h3"}}),je=new U({props:{code:"TUFMTE9DX0FSRU5BX01BWCUzRDY0JTIwWExBX1VTRV9CRjE2JTNEMSUyMG5ldXJvbl9wYXJhbGxlbF9jb21waWxlJTIwdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMzIlMjBmaW5ldHVuZV9sbG0ucHklMjAlNUMlMEElMjAtLW1vZGVsX2lkJTIwJTdCbW9kZWxfaWQlN0QlMjAlNUMlMEElMjAtLWRhdGFzZXRfcGF0aCUyMCU3QmRhdGFzZXRfcGF0aCU3RCUyMCU1QyUwQSUyMC0tYmYxNiUyMFRydWUlMjAlNUMlMEElMjAtLWxlYXJuaW5nX3JhdGUlMjA1ZS01JTIwJTVDJTBBJTIwLS1vdXRwdXRfZGlyJTIwZG9sbHlfbGxhbWElMjAlNUMlMEElMjAtLW92ZXJ3cml0ZV9vdXRwdXRfZGlyJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwMTYlMjAlNUMlMEElMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjBUcnVlJTIwJTVDJTBBJTIwLS10ZW5zb3JfcGFyYWxsZWxfc2l6ZSUyMDglMjAlNUMlMEElMjAtLW1heF9zdGVwcyUyMDEwJTIwJTVDJTBBJTIwLS1sb2dnaW5nX3N0ZXBzJTIwMTA=",highlighted:`MALLOC_ARENA_MAX=64 XLA_USE_BF16=1 neuron_parallel_compile torchrun --nproc_per_node=32 finetune_llm.py \\
 --model_id {model_id} \\
 --dataset_path {dataset_path} \\
 --bf16 True \\
 --learning_rate 5e-5 \\
 --output_dir dolly_llama \\
 --overwrite_output_dir True \\
 --per_device_train_batch_size 1 \\
 --gradient_accumulation_steps 16 \\
 --gradient_checkpointing True \\
 --tensor_parallel_size 8 \\
 --max_steps 10 \\
 --logging_steps 10`,wrap:!1}}),_=new Cl({props:{$$slots:{default:[Xs]},$$scope:{ctx:I}}}),fe=new U({props:{code:"JTIzJTIwcmVtb3ZlJTIwZHVtbXklMjBhcnRpZmFjdHMlMjB3aGljaCUyMGFyZSUyMGNyZWF0ZWQlMjBieSUyMHRoZSUyMHByZWNvbXBpbGF0aW9uJTIwY29tbWFuZCUwQXJtJTIwLXJmJTIwZG9sbHlfbGxhbWE=",highlighted:`<span class="hljs-comment"># remove dummy artifacts which are created by the precompilation command</span>
<span class="hljs-built_in">rm</span> -rf dolly_llama`,wrap:!1}}),be=new g({props:{title:"Actual Training",local:"actual-training",headingTag:"h3"}}),Ge=new U({props:{code:"TUFMTE9DX0FSRU5BX01BWCUzRDY0JTIwWExBX1VTRV9CRjE2JTNEMSUyMHRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDMyJTIwZmluZXR1bmVfbGxtLnB5JTIwJTVDJTBBJTIwLS1tb2RlbF9pZCUyMCU3Qm1vZGVsX2lkJTdEJTIwJTVDJTBBJTIwLS1kYXRhc2V0X3BhdGglMjAlN0JkYXRhc2V0X3BhdGglN0QlMjAlNUMlMEElMjAtLWJmMTYlMjBUcnVlJTIwJTVDJTBBJTIwLS1sZWFybmluZ19yYXRlJTIwNWUtNSUyMCU1QyUwQSUyMC0tb3V0cHV0X2RpciUyMGRvbGx5X2xsYW1hJTIwJTVDJTBBJTIwLS1vdmVyd3JpdGVfb3V0cHV0X2RpciUyMFRydWUlMjAlNUMlMEElMjAtLXNraXBfY2FjaGVfcHVzaCUyMFRydWUlMjAlNUMlMEElMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDE2JTIwJTVDJTBBJTIwLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tdGVuc29yX3BhcmFsbGVsX3NpemUlMjA4JTIwJTVDJTBBJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMyUyMCU1QyUwQSUyMC0tbG9nZ2luZ19zdGVwcyUyMDEw",highlighted:`MALLOC_ARENA_MAX=64 XLA_USE_BF16=1 torchrun --nproc_per_node=32 finetune_llm.py \\
 --model_id {model_id} \\
 --dataset_path {dataset_path} \\
 --bf16 True \\
 --learning_rate 5e-5 \\
 --output_dir dolly_llama \\
 --overwrite_output_dir True \\
 --skip_cache_push True \\
 --per_device_train_batch_size 1 \\
 --gradient_accumulation_steps 16 \\
 --gradient_checkpointing True \\
 --tensor_parallel_size 8 \\
 --num_train_epochs 3 \\
 --logging_steps 10`,wrap:!1}}),ke=new g({props:{title:"Consolidate the Checkpoint",local:"consolidate-the-checkpoint",headingTag:"h3"}}),ve=new U({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMGRvbGx5X2xsYW1hJTIwZG9sbHlfbGxhbWE=",highlighted:"optimum-cli neuron consolidate dolly_llama dolly_llama",wrap:!1}}),Xe=new g({props:{title:"5. Evaluate and test fine-tuned Llama model",local:"5-evaluate-and-test-fine-tuned-llama-model",headingTag:"h2"}}),xe=new U({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMm51bV9jb3JlcyUyMiUzQSUyMDIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCdmcDE2JyU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMjA0OCU3RCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRvbGx5X2xsYW1hJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9sbHlfbGxhbWElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipjb21waWxlcl9hcmdzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

compiler_args = {<span class="hljs-string">&quot;num_cores&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&#x27;fp16&#x27;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">2048</span>}

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dolly_llama&quot;</span>)
model = NeuronModelForCausalLM.from_pretrained(
        <span class="hljs-string">&quot;dolly_llama&quot;</span>,
        export=<span class="hljs-literal">True</span>,
        **compiler_args,
        **input_shapes)`,wrap:!1}}),Ae=new U({props:{code:"JTIzJTIwQ09NTUVOVCUyMElOJTIwaWYlMjB5b3UlMjB3YW50JTIwdG8lMjBzYXZlJTIwdGhlJTIwY29tcGlsZWQlMjBtb2RlbCUwQSUyMyUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJjb21waWxlZF9kb2xseV9sbGFtYSUyMik=",highlighted:`<span class="hljs-comment"># COMMENT IN if you want to save the compiled model</span>
<span class="hljs-comment"># model.save_pretrained(&quot;compiled_dolly_llama&quot;)</span>`,wrap:!1}}),Ye=new U({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5X2luZmVyZW5jZShzYW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW5zdHJ1Y3Rpb24lMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwSW5zdHJ1Y3Rpb24lNUNuJTdCc2FtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMGNvbnRleHQlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQ29udGV4dCU1Q24lN0JzYW1wbGUlNUInY29udGV4dCclNUQlN0QlMjIlMjBpZiUyMCUyMmNvbnRleHQlMjIlMjBpbiUyMHNhbXBsZSUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiUyMiUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdCUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlKHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBmb3JtYXRfZG9sbHlfaW5mZXJlbmNlKHNhbXBsZSklMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuOSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3BfcCUzRDAuOSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSU1Qmxlbihwcm9tcHQpJTNBJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly_inference</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;context&quot;</span> <span class="hljs-keyword">in</span> sample <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n&quot;</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">sample</span>):
    prompt = format_dolly_inference(sample)
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(
        **inputs,
        max_new_tokens=<span class="hljs-number">512</span>,
        do_sample=<span class="hljs-literal">True</span>,
        temperature=<span class="hljs-number">0.9</span>,
        top_k=<span class="hljs-number">50</span>,
        top_p=<span class="hljs-number">0.9</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-built_in">len</span>(prompt):]`,wrap:!1}}),Ne=new U({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJDYW4lMjB5b3UlMjB0ZWxsJTIwbWUlMjBzb21ldGhpbmclMjBhYm91dCUyMEFXUyUzRiUyMiUwQSU3RCUwQXJlcyUyMCUzRCUyMGdlbmVyYXRlKHByb21wdCklMEElMEFwcmludChyZXMp",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Can you tell me something about AWS?&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),Fe=new U({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJIb3clMjBjYW4lMjBJJTIwdHJhaW4lMjBtb2RlbHMlMjBvbiUyMEFXUyUyMFRyYWluaXVtJTNGJTIyJTJDJTBBJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMiVGMCU5RiVBNCU5NyUyME9wdGltdW0lMjBOZXVyb24lMjBpcyUyMHRoZSUyMGludGVyZmFjZSUyMGJldHdlZW4lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjBsaWJyYXJ5JTIwYW5kJTIwQVdTJTIwQWNjZWxlcmF0b3JzJTIwaW5jbHVkaW5nJTIwJTVCQVdTJTIwVHJhaW5pdW0lNUQoaHR0cHMlM0ElMkYlMkZhd3MuYW1hem9uLmNvbSUyRm1hY2hpbmUtbGVhcm5pbmclMkZ0cmFpbml1bSUyRiUzRm5jMSUzRGhfbHMpJTIwYW5kJTIwJTVCQVdTJTIwSW5mZXJlbnRpYSU1RChodHRwcyUzQSUyRiUyRmF3cy5hbWF6b24uY29tJTJGbWFjaGluZS1sZWFybmluZyUyRmluZmVyZW50aWElMkYlM0ZuYzElM0RoX2xzKS4lMjBJdCUyMHByb3ZpZGVzJTIwYSUyMHNldCUyMG9mJTIwdG9vbHMlMjBlbmFibGluZyUyMGVhc3klMjBtb2RlbCUyMGxvYWRpbmclMkMlMjB0cmFpbmluZyUyMGFuZCUyMGluZmVyZW5jZSUyMG9uJTIwc2luZ2xlLSUyMGFuZCUyMG11bHRpLUFjY2VsZXJhdG9yJTIwc2V0dGluZ3MlMjBmb3IlMjBkaWZmZXJlbnQlMjBkb3duc3RyZWFtJTIwdGFza3MuJTIyJTBBJTdEJTBBcmVzJTIwJTNEJTIwZ2VuZXJhdGUocHJvbXB0KSUwQSUwQXByaW50KHJlcyk=",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;How can I train models on AWS Trainium?&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;🤗 Optimum Neuron is the interface between the 🤗 Transformers library and AWS Accelerators including [AWS Trainium](https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls) and [AWS Inferentia](https://aws.amazon.com/machine-learning/inferentia/?nc1=h_ls). It provides a set of tools enabling easy model loading, training and inference on single- and multi-Accelerator settings for different downstream tasks.&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),{c(){r=i("meta"),f=a(),y=i("p"),w=a(),M(b.$$.fragment),T=a(),J=i("p"),J.innerHTML=Pe,j=a(),C=i("p"),C.innerHTML=gl,Ke=a(),v=i("p"),v.textContent=Bl,Oe=a(),X=i("ol"),X.innerHTML=Gl,et=a(),M(B.$$.fragment),tt=a(),M($.$$.fragment),lt=a(),R=i("p"),R.textContent=Wl,st=a(),x=i("ol"),x.innerHTML=Zl,at=a(),M(V.$$.fragment),nt=a(),G=i("ol"),G.innerHTML=kl,it=a(),A=i("ul"),A.innerHTML=_l,ot=a(),W=i("ol"),W.innerHTML=vl,pt=a(),M(H.$$.fragment),rt=a(),M(Y.$$.fragment),Mt=a(),S=i("p"),S.innerHTML=Xl,mt=a(),z=i("p"),z.textContent=$l,ct=a(),M(N.$$.fragment),ut=a(),E=i("p"),E.innerHTML=Rl,dt=a(),M(Q.$$.fragment),ht=a(),F=i("p"),F.innerHTML=xl,yt=a(),M(L.$$.fragment),wt=a(),q=i("p"),q.textContent=Vl,Tt=a(),P=i("p"),P.innerHTML=Al,Jt=a(),M(D.$$.fragment),jt=a(),K=i("p"),K.textContent=Hl,Ut=a(),O=i("ol"),O.innerHTML=Yl,ft=a(),M(ee.$$.fragment),bt=a(),te=i("p"),te.textContent=Sl,Ct=a(),le=i("p"),le.innerHTML=zl,It=a(),M(se.$$.fragment),gt=a(),M(ae.$$.fragment),Bt=a(),ne=i("p"),ne.innerHTML=Nl,Gt=a(),ie=i("p"),ie.innerHTML=El,Wt=a(),oe=i("p"),oe.textContent=Ql,Zt=a(),pe=i("ol"),pe.innerHTML=Fl,kt=a(),M(Z.$$.fragment),_t=a(),re=i("p"),re.textContent=Ll,vt=a(),M(Me.$$.fragment),Xt=a(),me=i("p"),me.textContent=ql,$t=a(),ce=i("ul"),ce.innerHTML=Pl,Rt=a(),M(ue.$$.fragment),xt=a(),de=i("p"),de.innerHTML=Dl,Vt=a(),M(k.$$.fragment),At=a(),M(he.$$.fragment),Ht=a(),ye=i("p"),ye.textContent=Kl,Yt=a(),we=i("p"),we.innerHTML=Ol,St=a(),Te=i("p"),Te.innerHTML=es,zt=a(),Je=i("p"),Je.innerHTML=ts,Nt=a(),M(je.$$.fragment),Et=a(),M(_.$$.fragment),Qt=a(),Ue=i("p"),Ue.innerHTML=ls,Ft=a(),M(fe.$$.fragment),Lt=a(),M(be.$$.fragment),qt=a(),Ce=i("p"),Ce.innerHTML=ss,Pt=a(),Ie=i("p"),Ie.innerHTML=as,Dt=a(),ge=i("p"),ge.innerHTML=ns,Kt=a(),Be=i("p"),Be.textContent=is,Ot=a(),M(Ge.$$.fragment),el=a(),We=i("p"),We.textContent=os,tl=a(),Ze=i("p"),Ze.textContent=ps,ll=a(),M(ke.$$.fragment),sl=a(),_e=i("p"),_e.innerHTML=rs,al=a(),M(ve.$$.fragment),nl=a(),M(Xe.$$.fragment),il=a(),$e=i("p"),$e.textContent=Ms,ol=a(),Re=i("p"),Re.innerHTML=ms,pl=a(),M(xe.$$.fragment),rl=a(),Ve=i("p"),Ve.innerHTML=cs,Ml=a(),M(Ae.$$.fragment),ml=a(),He=i("p"),He.innerHTML=us,cl=a(),M(Ye.$$.fragment),ul=a(),Se=i("p"),Se.textContent=ds,dl=a(),ze=i("p"),ze.innerHTML=hs,hl=a(),M(Ne.$$.fragment),yl=a(),Ee=i("blockquote"),Ee.innerHTML=ys,wl=a(),Qe=i("p"),Qe.textContent=ws,Tl=a(),M(Fe.$$.fragment),Jl=a(),Le=i("blockquote"),Le.innerHTML=Ts,jl=a(),qe=i("p"),qe.textContent=Js,Ul=a(),De=i("p"),this.h()},l(e){const t=Ws("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(l),f=n(e),y=o(e,"P",{}),Cs(y).forEach(l),w=n(e),m(b.$$.fragment,e),T=n(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-190tue7"&&(J.innerHTML=Pe),j=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1w2bqvx"&&(C.innerHTML=gl),Ke=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1hahfn0"&&(v.textContent=Bl),Oe=n(e),X=o(e,"OL",{"data-svelte-h":!0}),p(X)!=="svelte-1yf8yg7"&&(X.innerHTML=Gl),et=n(e),m(B.$$.fragment,e),tt=n(e),m($.$$.fragment,e),lt=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-w52dpm"&&(R.textContent=Wl),st=n(e),x=o(e,"OL",{"data-svelte-h":!0}),p(x)!=="svelte-1hrudyd"&&(x.innerHTML=Zl),at=n(e),m(V.$$.fragment,e),nt=n(e),G=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(G)!=="svelte-ksb30n"&&(G.innerHTML=kl),it=n(e),A=o(e,"UL",{"data-svelte-h":!0}),p(A)!=="svelte-1qiwkz0"&&(A.innerHTML=_l),ot=n(e),W=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(W)!=="svelte-1kzndz4"&&(W.innerHTML=vl),pt=n(e),m(H.$$.fragment,e),rt=n(e),m(Y.$$.fragment,e),Mt=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-s6kf7j"&&(S.innerHTML=Xl),mt=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-11lpom8"&&(z.textContent=$l),ct=n(e),m(N.$$.fragment,e),ut=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1snwaj0"&&(E.innerHTML=Rl),dt=n(e),m(Q.$$.fragment,e),ht=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-voh434"&&(F.innerHTML=xl),yt=n(e),m(L.$$.fragment,e),wt=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-9wnhaa"&&(q.textContent=Vl),Tt=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1tlab3t"&&(P.innerHTML=Al),Jt=n(e),m(D.$$.fragment,e),jt=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-vnokz2"&&(K.textContent=Hl),Ut=n(e),O=o(e,"OL",{"data-svelte-h":!0}),p(O)!=="svelte-v6jbub"&&(O.innerHTML=Yl),ft=n(e),m(ee.$$.fragment,e),bt=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-16jyes1"&&(te.textContent=Sl),Ct=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1qdlstl"&&(le.innerHTML=zl),It=n(e),m(se.$$.fragment,e),gt=n(e),m(ae.$$.fragment,e),Bt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-14g3or9"&&(ne.innerHTML=Nl),Gt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-b4fdk9"&&(ie.innerHTML=El),Wt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-lw48ct"&&(oe.textContent=Ql),Zt=n(e),pe=o(e,"OL",{"data-svelte-h":!0}),p(pe)!=="svelte-xm927i"&&(pe.innerHTML=Fl),kt=n(e),m(Z.$$.fragment,e),_t=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1lnowtd"&&(re.textContent=Ll),vt=n(e),m(Me.$$.fragment,e),Xt=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-t16ze3"&&(me.textContent=ql),$t=n(e),ce=o(e,"UL",{"data-svelte-h":!0}),p(ce)!=="svelte-1ou6zrr"&&(ce.innerHTML=Pl),Rt=n(e),m(ue.$$.fragment,e),xt=n(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1ib8llv"&&(de.innerHTML=Dl),Vt=n(e),m(k.$$.fragment,e),At=n(e),m(he.$$.fragment,e),Ht=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1u0hmu2"&&(ye.textContent=Kl),Yt=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1gsk3gh"&&(we.innerHTML=Ol),St=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-jypm7b"&&(Te.innerHTML=es),zt=n(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-t9z3bd"&&(Je.innerHTML=ts),Nt=n(e),m(je.$$.fragment,e),Et=n(e),m(_.$$.fragment,e),Qt=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-136s4kc"&&(Ue.innerHTML=ls),Ft=n(e),m(fe.$$.fragment,e),Lt=n(e),m(be.$$.fragment,e),qt=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1yiqpri"&&(Ce.innerHTML=ss),Pt=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1anw499"&&(Ie.innerHTML=as),Dt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-ctfnvw"&&(ge.innerHTML=ns),Kt=n(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-17lv8z9"&&(Be.textContent=is),Ot=n(e),m(Ge.$$.fragment,e),el=n(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1v2czzn"&&(We.textContent=os),tl=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-12iaeqv"&&(Ze.textContent=ps),ll=n(e),m(ke.$$.fragment,e),sl=n(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-66io75"&&(_e.innerHTML=rs),al=n(e),m(ve.$$.fragment,e),nl=n(e),m(Xe.$$.fragment,e),il=n(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-emhotm"&&($e.textContent=Ms),ol=n(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1pgrxrm"&&(Re.innerHTML=ms),pl=n(e),m(xe.$$.fragment,e),rl=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1sinvz7"&&(Ve.innerHTML=cs),Ml=n(e),m(Ae.$$.fragment,e),ml=n(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-jx2yqv"&&(He.innerHTML=us),cl=n(e),m(Ye.$$.fragment,e),ul=n(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1ytr5g6"&&(Se.textContent=ds),dl=n(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1j8w2o0"&&(ze.innerHTML=hs),hl=n(e),m(Ne.$$.fragment,e),yl=n(e),Ee=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(Ee)!=="svelte-6l4k0q"&&(Ee.innerHTML=ys),wl=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-ovzcvi"&&(Qe.textContent=ws),Tl=n(e),m(Fe.$$.fragment,e),Jl=n(e),Le=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(Le)!=="svelte-15xrtpx"&&(Le.innerHTML=Ts),jl=n(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-q9f4rf"&&(qe.textContent=Js),Ul=n(e),De=o(e,"P",{}),Cs(De).forEach(l),this.h()},h(){bl(r,"name","hf:doc:metadata"),bl(r,"content",Rs),bl(G,"start","3"),bl(W,"start","4")},m(e,t){Zs(document.head,r),s(e,f,t),s(e,y,t),s(e,w,t),c(b,e,t),s(e,T,t),s(e,J,t),s(e,j,t),s(e,C,t),s(e,Ke,t),s(e,v,t),s(e,Oe,t),s(e,X,t),s(e,et,t),c(B,e,t),s(e,tt,t),c($,e,t),s(e,lt,t),s(e,R,t),s(e,st,t),s(e,x,t),s(e,at,t),c(V,e,t),s(e,nt,t),s(e,G,t),s(e,it,t),s(e,A,t),s(e,ot,t),s(e,W,t),s(e,pt,t),c(H,e,t),s(e,rt,t),c(Y,e,t),s(e,Mt,t),s(e,S,t),s(e,mt,t),s(e,z,t),s(e,ct,t),c(N,e,t),s(e,ut,t),s(e,E,t),s(e,dt,t),c(Q,e,t),s(e,ht,t),s(e,F,t),s(e,yt,t),c(L,e,t),s(e,wt,t),s(e,q,t),s(e,Tt,t),s(e,P,t),s(e,Jt,t),c(D,e,t),s(e,jt,t),s(e,K,t),s(e,Ut,t),s(e,O,t),s(e,ft,t),c(ee,e,t),s(e,bt,t),s(e,te,t),s(e,Ct,t),s(e,le,t),s(e,It,t),c(se,e,t),s(e,gt,t),c(ae,e,t),s(e,Bt,t),s(e,ne,t),s(e,Gt,t),s(e,ie,t),s(e,Wt,t),s(e,oe,t),s(e,Zt,t),s(e,pe,t),s(e,kt,t),c(Z,e,t),s(e,_t,t),s(e,re,t),s(e,vt,t),c(Me,e,t),s(e,Xt,t),s(e,me,t),s(e,$t,t),s(e,ce,t),s(e,Rt,t),c(ue,e,t),s(e,xt,t),s(e,de,t),s(e,Vt,t),c(k,e,t),s(e,At,t),c(he,e,t),s(e,Ht,t),s(e,ye,t),s(e,Yt,t),s(e,we,t),s(e,St,t),s(e,Te,t),s(e,zt,t),s(e,Je,t),s(e,Nt,t),c(je,e,t),s(e,Et,t),c(_,e,t),s(e,Qt,t),s(e,Ue,t),s(e,Ft,t),c(fe,e,t),s(e,Lt,t),c(be,e,t),s(e,qt,t),s(e,Ce,t),s(e,Pt,t),s(e,Ie,t),s(e,Dt,t),s(e,ge,t),s(e,Kt,t),s(e,Be,t),s(e,Ot,t),c(Ge,e,t),s(e,el,t),s(e,We,t),s(e,tl,t),s(e,Ze,t),s(e,ll,t),c(ke,e,t),s(e,sl,t),s(e,_e,t),s(e,al,t),c(ve,e,t),s(e,nl,t),c(Xe,e,t),s(e,il,t),s(e,$e,t),s(e,ol,t),s(e,Re,t),s(e,pl,t),c(xe,e,t),s(e,rl,t),s(e,Ve,t),s(e,Ml,t),c(Ae,e,t),s(e,ml,t),s(e,He,t),s(e,cl,t),c(Ye,e,t),s(e,ul,t),s(e,Se,t),s(e,dl,t),s(e,ze,t),s(e,hl,t),c(Ne,e,t),s(e,yl,t),s(e,Ee,t),s(e,wl,t),s(e,Qe,t),s(e,Tl,t),c(Fe,e,t),s(e,Jl,t),s(e,Le,t),s(e,jl,t),s(e,qe,t),s(e,Ul,t),s(e,De,t),fl=!0},p(e,[t]){const js={};t&2&&(js.$$scope={dirty:t,ctx:e}),B.$set(js);const Us={};t&2&&(Us.$$scope={dirty:t,ctx:e}),Z.$set(Us);const fs={};t&2&&(fs.$$scope={dirty:t,ctx:e}),k.$set(fs);const bs={};t&2&&(bs.$$scope={dirty:t,ctx:e}),_.$set(bs)},i(e){fl||(u(b.$$.fragment,e),u(B.$$.fragment,e),u($.$$.fragment,e),u(V.$$.fragment,e),u(H.$$.fragment,e),u(Y.$$.fragment,e),u(N.$$.fragment,e),u(Q.$$.fragment,e),u(L.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(Z.$$.fragment,e),u(Me.$$.fragment,e),u(ue.$$.fragment,e),u(k.$$.fragment,e),u(he.$$.fragment,e),u(je.$$.fragment,e),u(_.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u(Ge.$$.fragment,e),u(ke.$$.fragment,e),u(ve.$$.fragment,e),u(Xe.$$.fragment,e),u(xe.$$.fragment,e),u(Ae.$$.fragment,e),u(Ye.$$.fragment,e),u(Ne.$$.fragment,e),u(Fe.$$.fragment,e),fl=!0)},o(e){d(b.$$.fragment,e),d(B.$$.fragment,e),d($.$$.fragment,e),d(V.$$.fragment,e),d(H.$$.fragment,e),d(Y.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(Z.$$.fragment,e),d(Me.$$.fragment,e),d(ue.$$.fragment,e),d(k.$$.fragment,e),d(he.$$.fragment,e),d(je.$$.fragment,e),d(_.$$.fragment,e),d(fe.$$.fragment,e),d(be.$$.fragment,e),d(Ge.$$.fragment,e),d(ke.$$.fragment,e),d(ve.$$.fragment,e),d(Xe.$$.fragment,e),d(xe.$$.fragment,e),d(Ae.$$.fragment,e),d(Ye.$$.fragment,e),d(Ne.$$.fragment,e),d(Fe.$$.fragment,e),fl=!1},d(e){e&&(l(f),l(y),l(w),l(T),l(J),l(j),l(C),l(Ke),l(v),l(Oe),l(X),l(et),l(tt),l(lt),l(R),l(st),l(x),l(at),l(nt),l(G),l(it),l(A),l(ot),l(W),l(pt),l(rt),l(Mt),l(S),l(mt),l(z),l(ct),l(ut),l(E),l(dt),l(ht),l(F),l(yt),l(wt),l(q),l(Tt),l(P),l(Jt),l(jt),l(K),l(Ut),l(O),l(ft),l(bt),l(te),l(Ct),l(le),l(It),l(gt),l(Bt),l(ne),l(Gt),l(ie),l(Wt),l(oe),l(Zt),l(pe),l(kt),l(_t),l(re),l(vt),l(Xt),l(me),l($t),l(ce),l(Rt),l(xt),l(de),l(Vt),l(At),l(Ht),l(ye),l(Yt),l(we),l(St),l(Te),l(zt),l(Je),l(Nt),l(Et),l(Qt),l(Ue),l(Ft),l(Lt),l(qt),l(Ce),l(Pt),l(Ie),l(Dt),l(ge),l(Kt),l(Be),l(Ot),l(el),l(We),l(tl),l(Ze),l(ll),l(sl),l(_e),l(al),l(nl),l(il),l($e),l(ol),l(Re),l(pl),l(rl),l(Ve),l(Ml),l(ml),l(He),l(cl),l(ul),l(Se),l(dl),l(ze),l(hl),l(yl),l(Ee),l(wl),l(Qe),l(Tl),l(Jl),l(Le),l(jl),l(qe),l(Ul),l(De)),l(r),h(b,e),h(B,e),h($,e),h(V,e),h(H,e),h(Y,e),h(N,e),h(Q,e),h(L,e),h(D,e),h(ee,e),h(se,e),h(ae,e),h(Z,e),h(Me,e),h(ue,e),h(k,e),h(he,e),h(je,e),h(_,e),h(fe,e),h(be,e),h(Ge,e),h(ke,e),h(ve,e),h(Xe,e),h(xe,e),h(Ae,e),h(Ye,e),h(Ne,e),h(Fe,e)}}}const Rs='{"title":"Fine-tune and Test Llama-3 8B on AWS Trainium","local":"fine-tune-and-test-llama-3-8b-on-aws-trainium","sections":[{"title":"1. Setup AWS Environment","local":"1-setup-aws-environment","sections":[],"depth":2},{"title":"2. Load and prepare the dataset","local":"2-load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune Llama on AWS Trainium using the NeuronTrainer","local":"3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer","sections":[],"depth":2},{"title":"4. Launch Training","local":"4-launch-training","sections":[{"title":"Precompilation","local":"precompilation","sections":[],"depth":3},{"title":"Actual Training","local":"actual-training","sections":[],"depth":3},{"title":"Consolidate the Checkpoint","local":"consolidate-the-checkpoint","sections":[],"depth":3}],"depth":2},{"title":"5. Evaluate and test fine-tuned Llama model","local":"5-evaluate-and-test-fine-tuned-llama-model","sections":[],"depth":2}],"depth":1}';function xs(I){return gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends Bs{constructor(r){super(),Gs(this,r,xs,$s,Is,{})}}export{zs as component};
