import{s as Xs,o as Ks,n as sa}from"../chunks/scheduler.7da89386.js";import{S as aa,i as la,g as e,s as p,r as o,A as na,h as t,f as l,c as M,j as Os,u as J,x as j,k as qs,l as ds,y as pa,a as n,v as w,d as c,t as U,w as h}from"../chunks/index.0b7befd3.js";import{T as Ma}from"../chunks/Tip.1e71740f.js";import{C as bs}from"../chunks/CodeBlock.ce33a881.js";import{H as Qs}from"../chunks/Heading.8a936589.js";function ea(Y){let T,m="Using several devices on an AMD Instinct machine through <code>torchrun</code> on a single node? We recommend using <code>amdrun --ngpus &lt;num_gpus&gt; &lt;script&gt; &lt;script_args&gt;</code> instead to automatically dispatch to the best <code>num_gpus</code> available for maximum performance.";return{c(){T=e("p"),T.innerHTML=m},l(r){T=t(r,"P",{"data-svelte-h":!0}),j(T)!=="svelte-18h7ey9"&&(T.innerHTML=m)},m(r,W){n(r,T,W)},p:sa,d(r){r&&l(T)}}}function ta(Y){let T,m,r,W,u,O,N,gs="When using Hugging Face libraries with AMD Instinct MI210 or MI250 GPUs in a multi-GPU settings where collective operations are used, training and inference performance may vary depending on which devices are used together on a node. Some use cases are for example tensor parallelism, pipeline paralellism or data parallelism.",q,E,X,i,K,d,fs="Let’s take an MI250 machine for example. As <code>rocm-smi</code> shows, 8 devices are available:",ss,b,as,Q,Bs='However, as can be seen on the <a href="https://www.amd.com/content/dam/amd/en/documents/instinct-business-docs/white-papers/amd-cdna2-white-paper.pdf" rel="nofollow">description of the machine architecture</a>, some devices effectively have a privileged connection and two devices (two GCDs, Graphics Compute Die) from <code>rocm-smi</code> actually correspond to one MI250 (one OAM, OCP Accelerator Module).',ls,y,Ds='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/amd/mi250_topology.png" width="512" height="512" alt="4xMI250 machine topology"/>',ns,g,vs='<a href="https://www.amd.com/content/dam/amd/en/documents/instinct-business-docs/white-papers/amd-cdna2-white-paper.pdf" rel="nofollow">4xMI250 machine topology</a>',ps,f,zs="This can be checked by running <code>rocm-smi --shownodesbw</code>: some device &lt;-&gt; device link have a higher maximum bandwith. For example, from the table below, we can conclude that:",Ms,B,Rs="<li>If using two devices, using <code>CUDA_VISIBLE_DEVICES=&quot;0,1&quot;</code>, or <code>&quot;2,3&quot;</code>, or <code>&quot;4,5&quot;</code> or <code>&quot;6,7&quot;</code> should be privileged.</li> <li>If using three devices, <code>CUDA_VISIBLE_DEVICES=&quot;0,1,6&quot;</code> is a good option.</li> <li>If using four devices <code>CUDA_VISIBLE_DEVICES=&quot;0,1,6,7&quot;</code> or <code>&quot;2,3,4,5&quot;</code> is a good option.</li>",es,D,ts,v,Ss='This table only gives theoretical minimum/maximum bandwidth. A good option to validate which devices to use together is to run the <a href="https://github.com/RadeonOpenCompute/rocm_bandwidth_test" rel="nofollow">rocm_bandwidth_test</a> on your device.',js,z,Ts,R,Gs="On certain AMD machines as seen in the figure below, some devices may have a privileged connectivity with certain CPU cores.",rs,A,ks='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/amd/mi250_topology2.png" width="512" height="512" alt="4xMI250 machine topology"/>',os,S,$s='<a href="https://www.supermicro.com/products/brief/product-brief-Universal-GPU.pdf" rel="nofollow">4xMI250 machine topology</a>',Js,G,_s="This can be checked using <code>rocm-smi --showtoponuma</code> that gives the NUMA topology:",ws,k,cs,$,xs='and the difference in bandwidth can be checked using <a href="https://github.com/RadeonOpenCompute/rocm_bandwidth_test" rel="nofollow">rocm_bandwidth_test</a> (redacted):',Us,_,hs,x,Ls='When benchmarking for optimal performances, we advise testing both without/with <a href="https://access.redhat.com/documentation/en-en/red_hat_enterprise_linux/7/html/virtualization_tuning_and_optimization_guide/sect-virtualization_tuning_optimization_guide-numa-auto_numa_balancing" rel="nofollow">NUMA balancing</a> at <code>/proc/sys/kernel/numa_balancing</code>, which may impact performances. The table below shows the difference in performance of <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">Text Generation Inference</a> in a specific case where disabling NUMA balancing greatly increased performances.',is,I,Ps='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/amd/tgi_numa_llama70b.png" alt="Text Generation Inference latency comparison without/with NUMA balancing"/>',ys,L,Vs='An alternative can be to use <code>numactl --membind</code>, binding a process using a GPU to its corresponding NUMA node cores. More details <a href="https://docs.nvidia.com/cuda/cuda-c-best-practices-guide/index.html#numa-best-practices" rel="nofollow">here</a>.',As,P,Is,V,Hs='As seen on the below architecture for an MI210 machine, some GPU devices may be linked by an <a href="https://en.wikichip.org/wiki/amd/infinity_fabric" rel="nofollow">Infinity Fabric link</a> that typically has a higher bandwidth than PCIe switch (up to 100 GB/s per Infinity Fabric link).',Cs,H,Fs="In fact measuring unidirectional copy peak bandwidth, we see that MI210 GPUs linked by Infinity Fabric can communicate ~1.7x times faster than through PCIe switch.",ms,C,Ws='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/amd/mi210_topology.png" width="512" height="512" alt="8xMI210 machine topology"/>',us,F,Zs='<a href="https://www.amd.com/content/dam/amd/en/documents/instinct-business-docs/white-papers/amd-cdna2-white-paper.pdf" rel="nofollow">8xMI210 machine topology</a>',Ns,Z,Es;return u=new Qs({props:{title:"AMD Instinct GPU connectivity",local:"amd-instinct-gpu-connectivity",headingTag:"h1"}}),E=new Qs({props:{title:"Dual-die topology",local:"dual-die-topology",headingTag:"h2"}}),i=new Ma({props:{$$slots:{default:[ea]},$$scope:{ctx:Y}}}),b=new bs({props:{code:"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",highlighted:`<span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span> ROCm System Management Interface <span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span>
<span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span> Concise Info <span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span>
GPU  Temp (DieEdge)  AvgPwr  SCLK    MCLK     Fan  Perf  PwrCap  VRAM%  GPU%
<span class="hljs-number">0</span>    <span class="hljs-number">35.0</span>c           <span class="hljs-number">90.0</span>W   <span class="hljs-number">800</span>Mhz  <span class="hljs-number">1600</span>Mhz  <span class="hljs-number">0</span>%   auto  <span class="hljs-number">560.0</span>W    <span class="hljs-number">0</span>%   <span class="hljs-number">0</span>%
<span class="hljs-number">1</span>    <span class="hljs-number">34.0</span>c           N/A     <span class="hljs-number">800</span>Mhz  <span class="hljs-number">1600</span>Mhz  <span class="hljs-number">0</span>%   auto  <span class="hljs-number">0.0</span>W      <span class="hljs-number">0</span>%   <span class="hljs-number">0</span>%
<span class="hljs-number">2</span>    <span class="hljs-number">31.0</span>c           <span class="hljs-number">95.0</span>W   <span class="hljs-number">800</span>Mhz  <span class="hljs-number">1600</span>Mhz  <span class="hljs-number">0</span>%   auto  <span class="hljs-number">560.0</span>W    <span class="hljs-number">0</span>%   <span class="hljs-number">0</span>%
<span class="hljs-number">3</span>    <span class="hljs-number">37.0</span>c           N/A     <span class="hljs-number">800</span>Mhz  <span class="hljs-number">1600</span>Mhz  <span class="hljs-number">0</span>%   auto  <span class="hljs-number">0.0</span>W      <span class="hljs-number">0</span>%   <span class="hljs-number">0</span>%
<span class="hljs-number">4</span>    <span class="hljs-number">35.0</span>c           <span class="hljs-number">99.0</span>W   <span class="hljs-number">800</span>Mhz  <span class="hljs-number">1600</span>Mhz  <span class="hljs-number">0</span>%   auto  <span class="hljs-number">560.0</span>W    <span class="hljs-number">0</span>%   <span class="hljs-number">0</span>%
<span class="hljs-number">5</span>    <span class="hljs-number">31.0</span>c           N/A     <span class="hljs-number">800</span>Mhz  <span class="hljs-number">1600</span>Mhz  <span class="hljs-number">0</span>%   auto  <span class="hljs-number">0.0</span>W      <span class="hljs-number">0</span>%   <span class="hljs-number">0</span>%
<span class="hljs-number">6</span>    <span class="hljs-number">38.0</span>c           <span class="hljs-number">94.0</span>W   <span class="hljs-number">800</span>Mhz  <span class="hljs-number">1600</span>Mhz  <span class="hljs-number">0</span>%   auto  <span class="hljs-number">560.0</span>W    <span class="hljs-number">0</span>%   <span class="hljs-number">0</span>%
<span class="hljs-number">7</span>    <span class="hljs-number">39.0</span>c           N/A     <span class="hljs-number">800</span>Mhz  <span class="hljs-number">1600</span>Mhz  <span class="hljs-number">0</span>%   auto  <span class="hljs-number">0.0</span>W      <span class="hljs-number">0</span>%   <span class="hljs-number">0</span>%
<span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span><span class="hljs-operator">=</span>`,wrap:!1}}),D=new bs({props:{code:"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",highlighted:`========================= ROCm System Management Interface =========================
==================================== Bandwidth =====================================
       GPU0         GPU1         GPU2         GPU3         GPU4         GPU5         GPU6         GPU7
GPU0   N/A          50000<span class="hljs-string">-200000</span> 50000<span class="hljs-string">-50000</span>  0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-100000</span> 0<span class="hljs-string">-0</span>
GPU1   50000<span class="hljs-string">-200000</span> N/A          0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-50000</span>  0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-50000</span>  0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>
GPU2   50000<span class="hljs-string">-50000</span>  0<span class="hljs-string">-0</span>          N/A          50000<span class="hljs-string">-200000</span> 50000<span class="hljs-string">-100000</span> 0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>
GPU3   0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-50000</span>  50000<span class="hljs-string">-200000</span> N/A          0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-50000</span>
GPU4   0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-100000</span> 0<span class="hljs-string">-0</span>          N/A          50000<span class="hljs-string">-200000</span> 50000<span class="hljs-string">-50000</span>  0<span class="hljs-string">-0</span>
GPU5   0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-50000</span>  0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-200000</span> N/A          0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-50000</span>
GPU6   50000<span class="hljs-string">-100000</span> 0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-50000</span>  0<span class="hljs-string">-0</span>          N/A          50000<span class="hljs-string">-200000</span>
GPU7   0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>          0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-50000</span>  0<span class="hljs-string">-0</span>          50000<span class="hljs-string">-50000</span>  50000<span class="hljs-string">-200000</span> N/A
Format: min-max; Units: mps
&quot;0<span class="hljs-string">-0</span>&quot; min-max bandwidth indicates devices are not connected directly`,wrap:!1}}),z=new Qs({props:{title:"NUMA nodes",local:"numa-nodes",headingTag:"h2"}}),k=new bs({props:{code:"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",highlighted:`==================================== Numa Nodes ====================================
GPU[<span class="hljs-number">0</span>]          : (Topology) Numa <span class="hljs-keyword">Node</span><span class="hljs-title">: 0</span>
GPU[<span class="hljs-number">0</span>]          : (Topology) Numa Affinity: <span class="hljs-number">0</span>
GPU[<span class="hljs-number">1</span>]          : (Topology) Numa <span class="hljs-keyword">Node</span><span class="hljs-title">: 0</span>
GPU[<span class="hljs-number">1</span>]          : (Topology) Numa Affinity: <span class="hljs-number">0</span>
GPU[<span class="hljs-number">2</span>]          : (Topology) Numa <span class="hljs-keyword">Node</span><span class="hljs-title">: 0</span>
GPU[<span class="hljs-number">2</span>]          : (Topology) Numa Affinity: <span class="hljs-number">0</span>
GPU[<span class="hljs-number">3</span>]          : (Topology) Numa <span class="hljs-keyword">Node</span><span class="hljs-title">: 0</span>
GPU[<span class="hljs-number">3</span>]          : (Topology) Numa Affinity: <span class="hljs-number">0</span>
GPU[<span class="hljs-number">4</span>]          : (Topology) Numa <span class="hljs-keyword">Node</span><span class="hljs-title">: 1</span>
GPU[<span class="hljs-number">4</span>]          : (Topology) Numa Affinity: <span class="hljs-number">1</span>
GPU[<span class="hljs-number">5</span>]          : (Topology) Numa <span class="hljs-keyword">Node</span><span class="hljs-title">: 1</span>
GPU[<span class="hljs-number">5</span>]          : (Topology) Numa Affinity: <span class="hljs-number">1</span>
GPU[<span class="hljs-number">6</span>]          : (Topology) Numa <span class="hljs-keyword">Node</span><span class="hljs-title">: 1</span>
GPU[<span class="hljs-number">6</span>]          : (Topology) Numa Affinity: <span class="hljs-number">1</span>
GPU[<span class="hljs-number">7</span>]          : (Topology) Numa <span class="hljs-keyword">Node</span><span class="hljs-title">: 1</span>
GPU[<span class="hljs-number">7</span>]          : (Topology) Numa Affinity: <span class="hljs-number">1</span>`,wrap:!1}}),_=new bs({props:{code:"QmlkaXJlY3Rpb25hbCUyMGNvcHklMjBwZWFrJTIwYmFuZHdpZHRoJTIwR0IlMkZzJTBBJTBBRCUyRkQlMjAlMjAlMjAlMjAlMjAlMjAlMjBjcHUwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3B1MSUwQWNwdTAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBOJTJGQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME4lMkZBJTBBY3B1MSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME4lMkZBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTiUyRkElMEEwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNDcuNzYzJTIwJTIwJTIwJTIwJTIwJTIwMzguMTAxJTBBMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDQ3Ljc5NiUyMCUyMCUyMCUyMCUyMCUyMDM4LjEwMSUwQTIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA0Ny43MzIlMjAlMjAlMjAlMjAlMjAlMjAzNi40MjklMEEzJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNDcuNzA5JTIwJTIwJTIwJTIwJTIwJTIwMzYuMzMwJTBBNCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDM2LjcwNSUyMCUyMCUyMCUyMCUyMCUyMDQ3LjQ2OCUwQTUlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAzNi43MjUlMjAlMjAlMjAlMjAlMjAlMjA0Ny4zOTYlMEE2JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMzUuNjA1JTIwJTIwJTIwJTIwJTIwJTIwNDcuMjk0JTBBNyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDM1LjM3NyUyMCUyMCUyMCUyMCUyMCUyMDQ3LjIzMw==",highlighted:`<span class="hljs-attribute">Bidirectional</span> copy peak bandwidth GB/s

<span class="hljs-attribute">D</span>/D       cpu0           cpu1
<span class="hljs-attribute">cpu0</span>         N/A         N/A
<span class="hljs-attribute">cpu1</span>         N/A         N/A
<span class="hljs-attribute">0</span>            <span class="hljs-number">47</span>.<span class="hljs-number">763</span>      <span class="hljs-number">38</span>.<span class="hljs-number">101</span>
<span class="hljs-attribute">1</span>            <span class="hljs-number">47</span>.<span class="hljs-number">796</span>      <span class="hljs-number">38</span>.<span class="hljs-number">101</span>
<span class="hljs-attribute">2</span>            <span class="hljs-number">47</span>.<span class="hljs-number">732</span>      <span class="hljs-number">36</span>.<span class="hljs-number">429</span>
<span class="hljs-attribute">3</span>            <span class="hljs-number">47</span>.<span class="hljs-number">709</span>      <span class="hljs-number">36</span>.<span class="hljs-number">330</span>
<span class="hljs-attribute">4</span>            <span class="hljs-number">36</span>.<span class="hljs-number">705</span>      <span class="hljs-number">47</span>.<span class="hljs-number">468</span>
<span class="hljs-attribute">5</span>            <span class="hljs-number">36</span>.<span class="hljs-number">725</span>      <span class="hljs-number">47</span>.<span class="hljs-number">396</span>
<span class="hljs-attribute">6</span>            <span class="hljs-number">35</span>.<span class="hljs-number">605</span>      <span class="hljs-number">47</span>.<span class="hljs-number">294</span>
<span class="hljs-attribute">7</span>            <span class="hljs-number">35</span>.<span class="hljs-number">377</span>      <span class="hljs-number">47</span>.<span class="hljs-number">233</span>`,wrap:!1}}),P=new Qs({props:{title:"Infinity Fabric",local:"infinity-fabric",headingTag:"h2"}}),{c(){T=e("meta"),m=p(),r=e("p"),W=p(),o(u.$$.fragment),O=p(),N=e("p"),N.textContent=gs,q=p(),o(E.$$.fragment),X=p(),o(i.$$.fragment),K=p(),d=e("p"),d.innerHTML=fs,ss=p(),o(b.$$.fragment),as=p(),Q=e("p"),Q.innerHTML=Bs,ls=p(),y=e("div"),y.innerHTML=Ds,ns=p(),g=e("p"),g.innerHTML=vs,ps=p(),f=e("p"),f.innerHTML=zs,Ms=p(),B=e("ul"),B.innerHTML=Rs,es=p(),o(D.$$.fragment),ts=p(),v=e("p"),v.innerHTML=Ss,js=p(),o(z.$$.fragment),Ts=p(),R=e("p"),R.textContent=Gs,rs=p(),A=e("div"),A.innerHTML=ks,os=p(),S=e("p"),S.innerHTML=$s,Js=p(),G=e("p"),G.innerHTML=_s,ws=p(),o(k.$$.fragment),cs=p(),$=e("p"),$.innerHTML=xs,Us=p(),o(_.$$.fragment),hs=p(),x=e("p"),x.innerHTML=Ls,is=p(),I=e("div"),I.innerHTML=Ps,ys=p(),L=e("p"),L.innerHTML=Vs,As=p(),o(P.$$.fragment),Is=p(),V=e("p"),V.innerHTML=Hs,Cs=p(),H=e("p"),H.textContent=Fs,ms=p(),C=e("div"),C.innerHTML=Ws,us=p(),F=e("p"),F.innerHTML=Zs,Ns=p(),Z=e("p"),this.h()},l(s){const a=na("svelte-u9bgzb",document.head);T=t(a,"META",{name:!0,content:!0}),a.forEach(l),m=M(s),r=t(s,"P",{}),Os(r).forEach(l),W=M(s),J(u.$$.fragment,s),O=M(s),N=t(s,"P",{"data-svelte-h":!0}),j(N)!=="svelte-car2bi"&&(N.textContent=gs),q=M(s),J(E.$$.fragment,s),X=M(s),J(i.$$.fragment,s),K=M(s),d=t(s,"P",{"data-svelte-h":!0}),j(d)!=="svelte-1ctraos"&&(d.innerHTML=fs),ss=M(s),J(b.$$.fragment,s),as=M(s),Q=t(s,"P",{"data-svelte-h":!0}),j(Q)!=="svelte-1noyqtk"&&(Q.innerHTML=Bs),ls=M(s),y=t(s,"DIV",{style:!0,"data-svelte-h":!0}),j(y)!=="svelte-56c05s"&&(y.innerHTML=Ds),ns=M(s),g=t(s,"P",{"data-svelte-h":!0}),j(g)!=="svelte-15xtw77"&&(g.innerHTML=vs),ps=M(s),f=t(s,"P",{"data-svelte-h":!0}),j(f)!=="svelte-7d3dnm"&&(f.innerHTML=zs),Ms=M(s),B=t(s,"UL",{"data-svelte-h":!0}),j(B)!=="svelte-ex3kul"&&(B.innerHTML=Rs),es=M(s),J(D.$$.fragment,s),ts=M(s),v=t(s,"P",{"data-svelte-h":!0}),j(v)!=="svelte-hi6hof"&&(v.innerHTML=Ss),js=M(s),J(z.$$.fragment,s),Ts=M(s),R=t(s,"P",{"data-svelte-h":!0}),j(R)!=="svelte-qsadxk"&&(R.textContent=Gs),rs=M(s),A=t(s,"DIV",{style:!0,"data-svelte-h":!0}),j(A)!=="svelte-1iavqr2"&&(A.innerHTML=ks),os=M(s),S=t(s,"P",{"data-svelte-h":!0}),j(S)!=="svelte-1yq23ia"&&(S.innerHTML=$s),Js=M(s),G=t(s,"P",{"data-svelte-h":!0}),j(G)!=="svelte-1lanpdy"&&(G.innerHTML=_s),ws=M(s),J(k.$$.fragment,s),cs=M(s),$=t(s,"P",{"data-svelte-h":!0}),j($)!=="svelte-pnlzzg"&&($.innerHTML=xs),Us=M(s),J(_.$$.fragment,s),hs=M(s),x=t(s,"P",{"data-svelte-h":!0}),j(x)!=="svelte-1of3tan"&&(x.innerHTML=Ls),is=M(s),I=t(s,"DIV",{style:!0,"data-svelte-h":!0}),j(I)!=="svelte-wkuigk"&&(I.innerHTML=Ps),ys=M(s),L=t(s,"P",{"data-svelte-h":!0}),j(L)!=="svelte-7k7z7o"&&(L.innerHTML=Vs),As=M(s),J(P.$$.fragment,s),Is=M(s),V=t(s,"P",{"data-svelte-h":!0}),j(V)!=="svelte-ym0olu"&&(V.innerHTML=Hs),Cs=M(s),H=t(s,"P",{"data-svelte-h":!0}),j(H)!=="svelte-knas6n"&&(H.textContent=Fs),ms=M(s),C=t(s,"DIV",{style:!0,"data-svelte-h":!0}),j(C)!=="svelte-4cdibo"&&(C.innerHTML=Ws),us=M(s),F=t(s,"P",{"data-svelte-h":!0}),j(F)!=="svelte-a9hwhv"&&(F.innerHTML=Zs),Ns=M(s),Z=t(s,"P",{}),Os(Z).forEach(l),this.h()},h(){qs(T,"name","hf:doc:metadata"),qs(T,"content",ja),ds(y,"text-align","center"),ds(A,"text-align","center"),ds(I,"text-align","center"),ds(C,"text-align","center")},m(s,a){pa(document.head,T),n(s,m,a),n(s,r,a),n(s,W,a),w(u,s,a),n(s,O,a),n(s,N,a),n(s,q,a),w(E,s,a),n(s,X,a),w(i,s,a),n(s,K,a),n(s,d,a),n(s,ss,a),w(b,s,a),n(s,as,a),n(s,Q,a),n(s,ls,a),n(s,y,a),n(s,ns,a),n(s,g,a),n(s,ps,a),n(s,f,a),n(s,Ms,a),n(s,B,a),n(s,es,a),w(D,s,a),n(s,ts,a),n(s,v,a),n(s,js,a),w(z,s,a),n(s,Ts,a),n(s,R,a),n(s,rs,a),n(s,A,a),n(s,os,a),n(s,S,a),n(s,Js,a),n(s,G,a),n(s,ws,a),w(k,s,a),n(s,cs,a),n(s,$,a),n(s,Us,a),w(_,s,a),n(s,hs,a),n(s,x,a),n(s,is,a),n(s,I,a),n(s,ys,a),n(s,L,a),n(s,As,a),w(P,s,a),n(s,Is,a),n(s,V,a),n(s,Cs,a),n(s,H,a),n(s,ms,a),n(s,C,a),n(s,us,a),n(s,F,a),n(s,Ns,a),n(s,Z,a),Es=!0},p(s,[a]){const Ys={};a&2&&(Ys.$$scope={dirty:a,ctx:s}),i.$set(Ys)},i(s){Es||(c(u.$$.fragment,s),c(E.$$.fragment,s),c(i.$$.fragment,s),c(b.$$.fragment,s),c(D.$$.fragment,s),c(z.$$.fragment,s),c(k.$$.fragment,s),c(_.$$.fragment,s),c(P.$$.fragment,s),Es=!0)},o(s){U(u.$$.fragment,s),U(E.$$.fragment,s),U(i.$$.fragment,s),U(b.$$.fragment,s),U(D.$$.fragment,s),U(z.$$.fragment,s),U(k.$$.fragment,s),U(_.$$.fragment,s),U(P.$$.fragment,s),Es=!1},d(s){s&&(l(m),l(r),l(W),l(O),l(N),l(q),l(X),l(K),l(d),l(ss),l(as),l(Q),l(ls),l(y),l(ns),l(g),l(ps),l(f),l(Ms),l(B),l(es),l(ts),l(v),l(js),l(Ts),l(R),l(rs),l(A),l(os),l(S),l(Js),l(G),l(ws),l(cs),l($),l(Us),l(hs),l(x),l(is),l(I),l(ys),l(L),l(As),l(Is),l(V),l(Cs),l(H),l(ms),l(C),l(us),l(F),l(Ns),l(Z)),l(T),h(u,s),h(E,s),h(i,s),h(b,s),h(D,s),h(z,s),h(k,s),h(_,s),h(P,s)}}}const ja='{"title":"AMD Instinct GPU connectivity","local":"amd-instinct-gpu-connectivity","sections":[{"title":"Dual-die topology","local":"dual-die-topology","sections":[],"depth":2},{"title":"NUMA nodes","local":"numa-nodes","sections":[],"depth":2},{"title":"Infinity Fabric","local":"infinity-fabric","sections":[],"depth":2}],"depth":1}';function Ta(Y){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ua extends aa{constructor(T){super(),la(this,T,Ta,ta,Xs,{})}}export{Ua as component};
