import{s as un,o as pn,n as Ct}from"../chunks/scheduler.b108d059.js";import{S as Mn,i as dn,g as o,s,r as p,A as mn,h as r,f as n,c as i,j as rn,u as M,x as c,k as cn,y as hn,a as l,v as d,d as m,t as h,w as f}from"../chunks/index.008de539.js";import{T as Ut}from"../chunks/Tip.aeb15ab7.js";import{C as w}from"../chunks/CodeBlock.3968c746.js";import{H as Je,E as fn}from"../chunks/EditOnGithub.d1c48e3d.js";function gn(J){let a,y="You can use an existing bucket for storing the fine-tuning artifacts, if you already have a bucket, feel free to skip this step and jump onto the next one.";return{c(){a=o("p"),a.textContent=y},l(u){a=r(u,"P",{"data-svelte-h":!0}),c(a)!=="svelte-16rwlsp"&&(a.textContent=y)},m(u,g){l(u,a,g)},p:Ct,d(u){u&&n(a)}}}function yn(J){let a,y="The <code>CustomContainerTrainingJob</code> will override the default <code>ENTRYPOINT</code> provided within the container URI provided, so if the <code>ENTRYPOINT</code> is already suited to receive the arguments, then there’s no need to define a custom <code>command</code>.";return{c(){a=o("p"),a.innerHTML=y},l(u){a=r(u,"P",{"data-svelte-h":!0}),c(a)!=="svelte-1ekjliv"&&(a.innerHTML=y)},m(u,g){l(u,a,g)},p:Ct,d(u){u&&n(a)}}}function Tn(J){let a,y=`Once you have decided which resources to use to run the job, you need to define the hyper parameters accordingly to ensure that the selected instance is capable of running the job.
Some of the hparams that you may want to look into to avoid running into OOM errors are the following:`,u,g,b='<li><strong>Optimizer</strong>: by default the AdamW optimizer will be used, but alternatively lower precision optimizers can be used to reduce the memory as well e.g. <code>adamw_bnb_8bit</code> (for more information on 8-bit optimizers check <a href="https://huggingface.co/docs/bitsandbytes/main/en/optimizers" rel="nofollow">https://huggingface.co/docs/bitsandbytes/main/en/optimizers</a>).</li> <li><strong>Batch size</strong>: you can tweak this so as to use a lower batch size when running into OOM, or you can also tweak the gradient accumulation steps to simulate a similar batch size for updating the gradients, but providing less inputs within a batch a time e.g. <code>batch_size=8</code> and <code>gradient_accumulation=1</code> is effectively the same as <code>batch_size=4</code> and <code>gradient_accumulation=2</code>.</li>';return{c(){a=o("p"),a.textContent=y,u=s(),g=o("ul"),g.innerHTML=b},l(T){a=r(T,"P",{"data-svelte-h":!0}),c(a)!=="svelte-oq0ay8"&&(a.textContent=y),u=i(T),g=r(T,"UL",{"data-svelte-h":!0}),c(g)!=="svelte-tb4cna"&&(g.innerHTML=b)},m(T,j){l(T,a,j),l(T,u,j),l(T,g,j)},p:Ct,d(T){T&&(n(a),n(u),n(g))}}}function wn(J){let a,y='Since GCS FUSE is used to mount the bucket as a directory within the running container job, the mounted path follows the formatting <code>/gcs/&lt;BUCKET_NAME&gt;</code>. More information at <a href="https://cloud.google.com/vertex-ai/docs/training/code-requirements" rel="nofollow">https://cloud.google.com/vertex-ai/docs/training/code-requirements</a>. So the <code>output_dir</code> needs to be set to the mounted GCS Bucket, meaning that anything the <code>SFTTrainer</code> writes there will be automatically uploaded to the GCS Bucket.';return{c(){a=o("p"),a.innerHTML=y},l(u){a=r(u,"P",{"data-svelte-h":!0}),c(a)!=="svelte-d8v0sp"&&(a.innerHTML=y)},m(u,g){l(u,a,g)},p:Ct,d(u){u&&n(a)}}}function jn(J){let a,y,u,g,b,T,j,It='<a href="https://github.com/huggingface/trl" rel="nofollow">Transformer Reinforcement Learning (TRL)</a> is a framework developed by Hugging Face to fine-tune and align both transformer language and diffusion models using methods such as Supervised Fine-Tuning (SFT), Reward Modeling (RM), Proximal Policy Optimization (PPO), Direct Preference Optimization (DPO), and others. On the other hand, Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.',Ue,_,vt="This example showcases how to create a custom training job on Vertex AI running the Hugging Face PyTorch DLC for training, using the TRL CLI to full fine-tune a 7B LLM with SFT in a multi-GPU setting.",Ce,A,Ie,$,_t='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',ve,Z,At="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",_e,R,Ae,E,$t="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",$e,V,Ze,B,Zt="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",Re,x,Ee,G,Rt="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",Ve,L,Be,S,xe,U,Ge,k,Et="As the Vertex AI job will generate artifacts, you need to specify a Google Cloud Storage (GCS) Bucket to dump those artifacts into. So on, you need to create a GCS Bucket via the <code>gcloud storage buckets create</code> subcommand as follows:",Le,F,Se,W,ke,X,Vt="Once you have configured the environment and created the GCS Bucket (if applicable), you can proceed with the definition of the <code>CustomContainerTrainingJob</code>, which is a standard container job that runs on Vertex AI running a container, being the Hugging Face PyTorch DLC for training.",Fe,q,We,N,Bt="Before proceeding with the definition of the <code>CustomContainerTrainingJob</code>, you need to define the <code>accelerate</code> configuration file that you want to use when running the <code>trl sft</code> command, required as you are in a multi-GPU environment, otherwise the default configuration will be used and may not be getting the most when running the fine-tuning job on multiple GPUs.",Xe,H,xt="You need to define the DeepSpeed Zero3 configuration by creating the following <code>deepspeed.yaml</code> file locally, containing the configuration that will be used to run the SFT fine-tuning in a distributed setting on multiple GPUs. Some of the values defined within the following configuration file are:",qe,Q,Gt="<li><code>mixed_precision=bf16</code> as the fine-tuning will be in <code>bfloat16</code></li> <li><code>num_processes=4</code> as the fine-tuning will run on 4 A100 GPUs</li> <li><code>num_machines=1</code> and <code>same_network=true</code> as the GPUs are within the same single instance</li>",Ne,Y,Lt='Note that DeepSpeed Zero3 has been selected as the distributed configuration for <code>accelerate</code>, but any other can be used and configured via the <code>accelerate config</code> command, that will prompt the different configurations; or just explore some pre-defined configuration files in the <a href="https://github.com/huggingface/accelerate/tree/main/examples/config_yaml_templates" rel="nofollow">Accelerate Config Zoo</a>.',He,z,Qe,P,St="You now need to define a <code>CustomContainerTrainingJob</code> that runs on the Hugging Face PyTorch DLC for training, that needs to run the following sequential steps:",Ye,D,kt="<li>Create the <code>$HF_HOME/accelerate</code> path (if not existing already) as the <code>accelerate</code> config will be dumped there.</li> <li>Write the content of the <code>deepspeed.yaml</code> configuration file into the cache under the <code>default_config.yaml</code> name (as that’s <code>accelerate</code> default path i.e. the configuration that will be used for the fine-tuning job).</li> <li>Add the <code>trl sft</code> command capturing the arguments that will be provided whenever the job runs.</li>",ze,C,Pe,O,De,K,Oe,ee,Ft='Before proceeding to the <code>CustomContainerTrainingJob</code> via the Hugging Face PyTorch DLC for training, you need to define first the configuration required for the job to run successfully i.e. which GPU is capable of fine-tuning <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a> in <code>bfloat16</code>.',Ke,te,Wt='As a rough calculation, you could assume that the amount of GPU VRAM required to fine-tune a model in half precision is about four times the model size (read more about it in <a href="https://blog.eleuther.ai/transformer-math/" rel="nofollow">Eleuther AI - Transformer Math 101</a>).',et,ne,Xt='Alternatively, if your model is uploaded to the Hugging Face Hub, you can check the numbers in the community space <a href="https://huggingface.co/spaces/Vokturz/can-it-run-llm" rel="nofollow"><code>Vokturz/can-it-run-llm</code></a>, which does those calculations for you, based the model to fine-tune and the available hardware.',tt,le,qt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/can-it-run-llm.png" alt="&#39;Vokturz/can-it-run-llm&#39; for &#39;mistralai/Mistral-7B-v0.3&#39;"/>',nt,se,lt,ie,Nt='As mentioned before, the job will run the Supervised Fine-Tuning (SFT) with the TRL CLI on top of <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a> in <code>bfloat16</code> using <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow"><code>timdettmers/openassistant-guanaco</code></a>, which is a subset from <a href="https://huggingface.co/datasets/OpenAssistant/oasst1" rel="nofollow"><code>OpenAssistant/oasst1</code></a> with ~10k samples.',st,I,it,ae,Ht='As the <code>CustomContainerTrainingJob</code> defines the command <code>trl sft</code> the arguments to be provided are listed either in the Python reference at <a href="https://huggingface.co/docs/trl/en/sft_trainer#trl.SFTConfig" rel="nofollow">trl.SFTConfig</a> or via the <code>trl sft --help</code> command.',at,oe,Qt='Read more about the TRL CLI at <a href="https://huggingface.co/docs/trl/en/clis" rel="nofollow">https://huggingface.co/docs/trl/en/clis</a>.',ot,v,rt,re,ct,ce,Yt="Then you need to call the <code>submit</code> method on the <code>aiplatform.CustomContainerTrainingJob</code>, which is a non-blocking method that will schedule the job without blocking the execution.",ut,ue,zt="The arguments provided to the <code>submit</code> method are listed below:",pt,pe,Pt='<li><p><strong><code>args</code></strong> defines the list of arguments to be provided to the <code>trl sft</code> command, provided as <code>trl sft --arg_1=value ...</code>.</p></li> <li><p><strong><code>replica_count</code></strong> defines the number of replicas to run the job in, for training normally this value will be set to one.</p></li> <li><p><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> define the machine i.e. Compute Engine instance, the accelerator (if any), and the number of accelerators (ranging from 1 to 8); respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</p></li> <li><p><strong><code>base_output_dir</code></strong> defines the base directory that will be mounted within the running container from the GCS Bucket, conditioned by the <code>staging_bucket</code> argument provided to the <code>aiplatform.init</code> initially.</p></li> <li><p>(optional) <strong><code>environment_variables</code></strong> defines the environment variables to define within the running container. As you are fine-tuning a gated model i.e. <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a>, you need to set the <code>HF_TOKEN</code> environment variable. Additionally, some other environment variables are defined to set the cache path (<code>HF_HOME</code>) and to ensure that the logging messages are streamed to Google Cloud Logs Explorer properly (<code>TRL_USE_RICH</code>, <code>ACCELERATE_LOG_LEVEL</code>, <code>TRANSFORMERS_LOG_LEVEL</code>, and <code>TQDM_POSITION</code>).</p></li> <li><p>(optional) <strong><code>timeout</code></strong> and <strong><code>create_request_timeout</code></strong> define the timeouts in seconds before interrupting the job execution or the job creation request (time to allocate required resources and start the execution), respectively.</p></li> <li><p>(optional) <strong><code>boot_disk_size</code></strong> defines the size in GiB of the boot disk, increased to store not only the model weights but also all the intermediate checkpoints if any; otherwise, it defaults to 100GiB which may not be sufficient in some cases.</p></li>',Mt,Me,dt,de,mt,me,ht,he,Dt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-scheduled.png" alt="Pipeline created in Vertex AI"/>',ft,fe,Ot='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-completed.png" alt="Vertex AI Pipeline successfully completed"/>',gt,ge,Kt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-logs.png" alt="Vertex AI Pipeline logs"/>',yt,ye,en='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-run.png" alt="Vertex AI Run"/>',Tt,Te,tn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/gcs-bucket-artifacts.png" alt="GCS Bucket with uploaded artifacts"/>',wt,we,nn="Finally, you can upload the fine-tuned model to the Hugging Face Hub, or just keep it within the Google Cloud Storage (GCS) Bucket. Later on, you will be able to run the inference on top of it via either the Hugging Face PyTorch DLC for inference via the <code>pipeline</code> in <code>transformers</code>, or via the Hugging Face DLC for TGI (as the model is fine-tuned for <code>text-generation</code>).",jt,je,Jt,be,bt;return b=new Je({props:{title:"Fine-tune Mistral 7B v0.3 with PyTorch Training DLC using SFT on Vertex AI",local:"fine-tune-mistral-7b-v03-with-pytorch-training-dlc-using-sft-on-vertex-ai",headingTag:"h1"}}),A=new Je({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),R=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),V=new w({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMEJVQ0tFVF9VUkklM0RncyUzQSUyRiUyRmhmLXZlcnRleC1waXBlbGluZXMlMEElMjVlbnYlMjBDT05UQUlORVJfVVJJJTNEdXMtZG9ja2VyLnBrZy5kZXYlMkZkZWVwbGVhcm5pbmctcGxhdGZvcm0tcmVsZWFzZSUyRmdjci5pbyUyRmh1Z2dpbmdmYWNlLXB5dG9yY2gtdHJhaW5pbmctY3UxMjEuMi0zLnRyYW5zZm9ybWVycy40LTQyLnVidW50dTIyMDQucHkzMTA=",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env BUCKET_URI=gs://hf-vertex-pipelines
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-pytorch-training-cu121<span class="hljs-number">.2</span>-<span class="hljs-number">3.</span>transformers<span class="hljs-number">.4</span>-<span class="hljs-number">42.</span>ubuntu2204.py310`,wrap:!1}}),x=new w({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),L=new w({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),S=new Je({props:{title:"Optional: Create bucket in GCS",local:"optional-create-bucket-in-gcs",headingTag:"h2"}}),U=new Ut({props:{$$slots:{default:[gn]},$$scope:{ctx:J}}}),F=new w({props:{code:"IWdjbG91ZCUyMHN0b3JhZ2UlMjBidWNrZXRzJTIwY3JlYXRlJTIwJTI0QlVDS0VUX1VSSSUyMC0tcHJvamVjdCUyMCUyNFBST0pFQ1RfSUQlMjAtLWxvY2F0aW9uJTNEJTI0TE9DQVRJT04lMjAtLWRlZmF1bHQtc3RvcmFnZS1jbGFzcyUzRFNUQU5EQVJEJTIwLS11bmlmb3JtLWJ1Y2tldC1sZXZlbC1hY2Nlc3M=",highlighted:'!gcloud storage buckets create $BUCKET_URI --project $PROJECT_ID --location=$LOCATION --default-storage-<span class="hljs-keyword">class</span>=STANDARD --uniform-bucket-level-access',wrap:!1}}),W=new Je({props:{title:"Prepare CustomContainerTrainingJob",local:"prepare-customcontainertrainingjob",headingTag:"h2"}}),q=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBJTIwJTIwJTIwJTIwc3RhZ2luZ19idWNrZXQlM0Rvcy5nZXRlbnYoJTIyQlVDS0VUX1VSSSUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
    staging_bucket=os.getenv(<span class="hljs-string">&quot;BUCKET_URI&quot;</span>),
)`,wrap:!1}}),z=new w({props:{code:"JTI1JTI1d3JpdGVmaWxlJTIwJTIyLiUyRmFzc2V0cyUyRmRlZXBzcGVlZC55YW1sJTIyJTBBY29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGVlcHNwZWVkX2NvbmZpZyUzQSUwQSUyMCUyMGRlZXBzcGVlZF9tdWx0aW5vZGVfbGF1bmNoZXIlM0ElMjBzdGFuZGFyZCUwQSUyMCUyMG9mZmxvYWRfb3B0aW1pemVyX2RldmljZSUzQSUyMG5vbmUlMEElMjAlMjBvZmZsb2FkX3BhcmFtX2RldmljZSUzQSUyMG5vbmUlMEElMjAlMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBJTIwJTIwemVybzNfc2F2ZV8xNmJpdF9tb2RlbCUzQSUyMHRydWUlMEElMjAlMjB6ZXJvX3N0YWdlJTNBJTIwMyUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGJmMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDQlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdHB1X2VudiUzQSUyMCU1QiU1RCUwQXRwdV91c2VfY2x1c3RlciUzQSUyMGZhbHNlJTBBdHB1X3VzZV9zdWRvJTNBJTIwZmFsc2UlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`%%writefile <span class="hljs-string">&quot;./assets/deepspeed.yaml&quot;</span>
compute_environment: LOCAL_MACHINE
debug: false
deepspeed_config:
  deepspeed_multinode_launcher: standard
  offload_optimizer_device: none
  offload_param_device: none
  zero3_init_flag: true
  zero3_save_16bit_model: true
  zero_stage: <span class="hljs-number">3</span>
distributed_type: DEEPSPEED
downcast_bf16: <span class="hljs-string">&#x27;no&#x27;</span>
machine_rank: <span class="hljs-number">0</span>
main_training_function: main
mixed_precision: bf16
num_machines: <span class="hljs-number">1</span>
num_processes: <span class="hljs-number">4</span>
rdzv_backend: static
same_network: true
tpu_env: []
tpu_use_cluster: false
tpu_use_sudo: false
use_cpu: false`,wrap:!1}}),C=new Ut({props:{$$slots:{default:[yn]},$$scope:{ctx:J}}}),O=new w({props:{code:"am9iJTIwJTNEJTIwYWlwbGF0Zm9ybS5DdXN0b21Db250YWluZXJUcmFpbmluZ0pvYiglMEElMjAlMjAlMjAlMjBkaXNwbGF5X25hbWUlM0QlMjJ0cmwtZnVsbC1zZnQlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250YWluZXJfdXJpJTNEb3MuZ2V0ZW52KCUyMkNPTlRBSU5FUl9VUkklMjIpJTJDJTBBJTIwJTIwJTIwJTIwY29tbWFuZCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLWMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjAlMjYlMjYlMjAlMjIuam9pbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWtkaXIlMjAtcCUyMCUyNEhGX0hPTUUlMkZhY2NlbGVyYXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMmVjaG8lMjAlNUMlMjIlN0JvcGVuKCcuJTJGYXNzZXRzJTJGZGVlcHNwZWVkLnlhbWwnKS5yZWFkKCklN0QlNUMlMjIlMjAlM0UlMjAlMjRIRl9IT01FJTJGYWNjZWxlcmF0ZSUyRmRlZmF1bHRfY29uZmlnLnlhbWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnZXhlYyUyMHRybCUyMHNmdCUyMCUyMiUyNCU0MCUyMiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKQ==",highlighted:`job = aiplatform.CustomContainerTrainingJob(
    display_name=<span class="hljs-string">&quot;trl-full-sft&quot;</span>,
    container_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    command=[
        <span class="hljs-string">&quot;sh&quot;</span>,
        <span class="hljs-string">&quot;-c&quot;</span>,
        <span class="hljs-string">&quot; &amp;&amp; &quot;</span>.join(
            (
                <span class="hljs-string">&quot;mkdir -p $HF_HOME/accelerate&quot;</span>,
                <span class="hljs-string">f&quot;echo \\&quot;<span class="hljs-subst">{<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;./assets/deepspeed.yaml&#x27;</span>).read()}</span>\\&quot; &gt; $HF_HOME/accelerate/default_config.yaml&quot;</span>,
                <span class="hljs-string">&#x27;exec trl sft &quot;$@&quot;&#x27;</span>,
            )
        ),
        <span class="hljs-string">&quot;--&quot;</span>,
    ],
)`,wrap:!1}}),K=new Je({props:{title:"Define CustomContainerTrainingJob Requirements",local:"define-customcontainertrainingjob-requirements",headingTag:"h2"}}),se=new Je({props:{title:"Run CustomContainerTrainingJob",local:"run-customcontainertrainingjob",headingTag:"h2"}}),I=new Ut({props:{$$slots:{default:[Tn]},$$scope:{ctx:J}}}),v=new Ut({props:{$$slots:{default:[wn]},$$scope:{ctx:J}}}),re=new w({props:{code:"YXJncyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMyUyME1PREVMJTBBJTIwJTIwJTIwJTIwJTIyLS1tb2RlbF9uYW1lX29yX3BhdGglM0RtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLXRvcmNoX2R0eXBlJTNEYmZsb2F0MTYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLWF0dG5faW1wbGVtZW50YXRpb24lM0RmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMERBVEFTRVQlMEElMjAlMjAlMjAlMjAlMjItLWRhdGFzZXRfbmFtZSUzRHRpbWRldHRtZXJzJTJGb3BlbmFzc2lzdGFudC1ndWFuYWNvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1kYXRhc2V0X3RleHRfZmllbGQlM0R0ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwVFJBSU5FUiUwQSUyMCUyMCUyMCUyMCUyMi0tYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tbWF4X3NlcV9sZW5ndGglM0QxMDI0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1ncmFkaWVudF9jaGVja3BvaW50aW5nX3VzZV9yZWVudHJhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLWxlYXJuaW5nX3JhdGUlM0QwLjAwMDAyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1scl9zY2hlZHVsZXJfdHlwZSUzRGNvc2luZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tb3B0aW0lM0RhZGFtd19ibmJfOGJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tbnVtX3RyYWluX2Vwb2NocyUzRDElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLWxvZ2dpbmdfc3RlcHMlM0QxMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tZG9fZXZhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tZXZhbF9zdGVwcyUzRDEwMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tc2F2ZV9zdHJhdGVneSUzRGVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1yZXBvcnRfdG8lM0Rub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZiUyMi0tb3V0cHV0X2RpciUzRCU3Qm9zLmdldGVudignQlVDS0VUX1VSSScpLnJlcGxhY2UoJ2dzJTNBJTJGJTJGJyUyQyUyMCclMkZnY3MlMkYnKSU3RCUyRk1pc3RyYWwtN0ItdjAuMy1TRlQtR3VhbmFjbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLXNlZWQlM0Q0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tbG9nX2xldmVsJTNEaW5mbyUyMiUyQyUwQSU1RA==",highlighted:`args = [
    <span class="hljs-comment"># MODEL</span>
    <span class="hljs-string">&quot;--model_name_or_path=mistralai/Mistral-7B-v0.3&quot;</span>,
    <span class="hljs-string">&quot;--torch_dtype=bfloat16&quot;</span>,
    <span class="hljs-string">&quot;--attn_implementation=flash_attention_2&quot;</span>,
    <span class="hljs-comment"># DATASET</span>
    <span class="hljs-string">&quot;--dataset_name=timdettmers/openassistant-guanaco&quot;</span>,
    <span class="hljs-string">&quot;--dataset_text_field=text&quot;</span>,
    <span class="hljs-comment"># TRAINER</span>
    <span class="hljs-string">&quot;--bf16&quot;</span>,
    <span class="hljs-string">&quot;--max_seq_length=1024&quot;</span>,
    <span class="hljs-string">&quot;--per_device_train_batch_size=2&quot;</span>,
    <span class="hljs-string">&quot;--gradient_accumulation_steps=4&quot;</span>,
    <span class="hljs-string">&quot;--gradient_checkpointing&quot;</span>,
    <span class="hljs-string">&quot;--gradient_checkpointing_use_reentrant&quot;</span>,
    <span class="hljs-string">&quot;--learning_rate=0.00002&quot;</span>,
    <span class="hljs-string">&quot;--lr_scheduler_type=cosine&quot;</span>,
    <span class="hljs-string">&quot;--optim=adamw_bnb_8bit&quot;</span>,
    <span class="hljs-string">&quot;--num_train_epochs=1&quot;</span>,
    <span class="hljs-string">&quot;--logging_steps=10&quot;</span>,
    <span class="hljs-string">&quot;--do_eval&quot;</span>,
    <span class="hljs-string">&quot;--eval_steps=100&quot;</span>,
    <span class="hljs-string">&quot;--save_strategy=epoch&quot;</span>,
    <span class="hljs-string">&quot;--report_to=none&quot;</span>,
    <span class="hljs-string">f&quot;--output_dir=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>).replace(<span class="hljs-string">&#x27;gs://&#x27;</span>, <span class="hljs-string">&#x27;/gcs/&#x27;</span>)}</span>/Mistral-7B-v0.3-SFT-Guanaco&quot;</span>,
    <span class="hljs-string">&quot;--overwrite_output_dir&quot;</span>,
    <span class="hljs-string">&quot;--seed=42&quot;</span>,
    <span class="hljs-string">&quot;--log_level=info&quot;</span>,
]`,wrap:!1}}),Me=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"!pip install --upgrade --quiet huggingface_hub",wrap:!1}}),de=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),me=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQSUwQWpvYi5zdWJtaXQoJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjByZXBsaWNhX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmEyLWhpZ2hncHUtNGclMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX1RFU0xBX0ExMDAlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl9jb3VudCUzRDQlMkMlMEElMjAlMjAlMjAlMjBiYXNlX291dHB1dF9kaXIlM0RmJTIyJTdCb3MuZ2V0ZW52KCdCVUNLRVRfVVJJJyklN0QlMkZNaXN0cmFsLTdCLXYwLjMtU0ZULUd1YW5hY28lMjIlMkMlMEElMjAlMjAlMjAlMjBlbnZpcm9ubWVudF92YXJpYWJsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIRl9IT01FJTIyJTNBJTIwJTIyJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySEZfVE9LRU4lMjIlM0ElMjBnZXRfdG9rZW4oKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRSTF9VU0VfUklDSCUyMiUzQSUyMCUyMjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJBQ0NFTEVSQVRFX0xPR19MRVZFTCUyMiUzQSUyMCUyMklORk8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUUkFOU0ZPUk1FUlNfTE9HX0xFVkVMJTIyJTNBJTIwJTIySU5GTyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRRRE1fUE9TSVRJT04lMjIlM0ElMjAlMjItMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHRpbWVvdXQlM0Q2MCUyMColMjA2MCUyMColMjAzJTJDJTIwJTIwJTIzJTIwMyUyMGhvdXJzJTIwKDEwODAwcyklMEElMjAlMjAlMjAlMjBjcmVhdGVfcmVxdWVzdF90aW1lb3V0JTNENjAlMjAqJTIwMTAlMkMlMjAlMjAlMjMlMjAxMCUyMG1pbnV0ZXMlMjAoNjAwcyklMEElMjAlMjAlMjAlMjBib290X2Rpc2tfc2l6ZV9nYiUzRDI1MCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

job.submit(
    args=args,
    replica_count=<span class="hljs-number">1</span>,
    machine_type=<span class="hljs-string">&quot;a2-highgpu-4g&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_TESLA_A100&quot;</span>,
    accelerator_count=<span class="hljs-number">4</span>,
    base_output_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>)}</span>/Mistral-7B-v0.3-SFT-Guanaco&quot;</span>,
    environment_variables={
        <span class="hljs-string">&quot;HF_HOME&quot;</span>: <span class="hljs-string">&quot;/root/.cache/huggingface&quot;</span>,
        <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: get_token(),
        <span class="hljs-string">&quot;TRL_USE_RICH&quot;</span>: <span class="hljs-string">&quot;0&quot;</span>,
        <span class="hljs-string">&quot;ACCELERATE_LOG_LEVEL&quot;</span>: <span class="hljs-string">&quot;INFO&quot;</span>,
        <span class="hljs-string">&quot;TRANSFORMERS_LOG_LEVEL&quot;</span>: <span class="hljs-string">&quot;INFO&quot;</span>,
        <span class="hljs-string">&quot;TQDM_POSITION&quot;</span>: <span class="hljs-string">&quot;-1&quot;</span>,
    },
    timeout=<span class="hljs-number">60</span> * <span class="hljs-number">60</span> * <span class="hljs-number">3</span>,  <span class="hljs-comment"># 3 hours (10800s)</span>
    create_request_timeout=<span class="hljs-number">60</span> * <span class="hljs-number">10</span>,  <span class="hljs-comment"># 10 minutes (600s)</span>
    boot_disk_size_gb=<span class="hljs-number">250</span>,
)`,wrap:!1}}),je=new fn({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-trl-full-sft-fine-tuning-on-vertex-ai.mdx"}}),{c(){a=o("meta"),y=s(),u=o("p"),g=s(),p(b.$$.fragment),T=s(),j=o("p"),j.innerHTML=It,Ue=s(),_=o("p"),_.textContent=vt,Ce=s(),p(A.$$.fragment),Ie=s(),$=o("p"),$.innerHTML=_t,ve=s(),Z=o("p"),Z.innerHTML=At,_e=s(),p(R.$$.fragment),Ae=s(),E=o("p"),E.textContent=$t,$e=s(),p(V.$$.fragment),Ze=s(),B=o("p"),B.textContent=Zt,Re=s(),p(x.$$.fragment),Ee=s(),G=o("p"),G.textContent=Rt,Ve=s(),p(L.$$.fragment),Be=s(),p(S.$$.fragment),xe=s(),p(U.$$.fragment),Ge=s(),k=o("p"),k.innerHTML=Et,Le=s(),p(F.$$.fragment),Se=s(),p(W.$$.fragment),ke=s(),X=o("p"),X.innerHTML=Vt,Fe=s(),p(q.$$.fragment),We=s(),N=o("p"),N.innerHTML=Bt,Xe=s(),H=o("p"),H.innerHTML=xt,qe=s(),Q=o("ul"),Q.innerHTML=Gt,Ne=s(),Y=o("p"),Y.innerHTML=Lt,He=s(),p(z.$$.fragment),Qe=s(),P=o("p"),P.innerHTML=St,Ye=s(),D=o("ol"),D.innerHTML=kt,ze=s(),p(C.$$.fragment),Pe=s(),p(O.$$.fragment),De=s(),p(K.$$.fragment),Oe=s(),ee=o("p"),ee.innerHTML=Ft,Ke=s(),te=o("p"),te.innerHTML=Wt,et=s(),ne=o("p"),ne.innerHTML=Xt,tt=s(),le=o("p"),le.innerHTML=qt,nt=s(),p(se.$$.fragment),lt=s(),ie=o("p"),ie.innerHTML=Nt,st=s(),p(I.$$.fragment),it=s(),ae=o("p"),ae.innerHTML=Ht,at=s(),oe=o("p"),oe.innerHTML=Qt,ot=s(),p(v.$$.fragment),rt=s(),p(re.$$.fragment),ct=s(),ce=o("p"),ce.innerHTML=Yt,ut=s(),ue=o("p"),ue.innerHTML=zt,pt=s(),pe=o("ul"),pe.innerHTML=Pt,Mt=s(),p(Me.$$.fragment),dt=s(),p(de.$$.fragment),mt=s(),p(me.$$.fragment),ht=s(),he=o("p"),he.innerHTML=Dt,ft=s(),fe=o("p"),fe.innerHTML=Ot,gt=s(),ge=o("p"),ge.innerHTML=Kt,yt=s(),ye=o("p"),ye.innerHTML=en,Tt=s(),Te=o("p"),Te.innerHTML=tn,wt=s(),we=o("p"),we.innerHTML=nn,jt=s(),p(je.$$.fragment),Jt=s(),be=o("p"),this.h()},l(e){const t=mn("svelte-u9bgzb",document.head);a=r(t,"META",{name:!0,content:!0}),t.forEach(n),y=i(e),u=r(e,"P",{}),rn(u).forEach(n),g=i(e),M(b.$$.fragment,e),T=i(e),j=r(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1r6b2zf"&&(j.innerHTML=It),Ue=i(e),_=r(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1rm13w4"&&(_.textContent=vt),Ce=i(e),M(A.$$.fragment,e),Ie=i(e),$=r(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1o67gfb"&&($.innerHTML=_t),ve=i(e),Z=r(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1ebrquh"&&(Z.innerHTML=At),_e=i(e),M(R.$$.fragment,e),Ae=i(e),E=r(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1i8n6rq"&&(E.textContent=$t),$e=i(e),M(V.$$.fragment,e),Ze=i(e),B=r(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-15nvzfz"&&(B.textContent=Zt),Re=i(e),M(x.$$.fragment,e),Ee=i(e),G=r(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1nm8o2l"&&(G.textContent=Rt),Ve=i(e),M(L.$$.fragment,e),Be=i(e),M(S.$$.fragment,e),xe=i(e),M(U.$$.fragment,e),Ge=i(e),k=r(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-48jxyw"&&(k.innerHTML=Et),Le=i(e),M(F.$$.fragment,e),Se=i(e),M(W.$$.fragment,e),ke=i(e),X=r(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-169vc8o"&&(X.innerHTML=Vt),Fe=i(e),M(q.$$.fragment,e),We=i(e),N=r(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-5olot6"&&(N.innerHTML=Bt),Xe=i(e),H=r(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1tdnehm"&&(H.innerHTML=xt),qe=i(e),Q=r(e,"UL",{"data-svelte-h":!0}),c(Q)!=="svelte-oihk84"&&(Q.innerHTML=Gt),Ne=i(e),Y=r(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-jsb5oe"&&(Y.innerHTML=Lt),He=i(e),M(z.$$.fragment,e),Qe=i(e),P=r(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-w5gycc"&&(P.innerHTML=St),Ye=i(e),D=r(e,"OL",{"data-svelte-h":!0}),c(D)!=="svelte-1q4i1bb"&&(D.innerHTML=kt),ze=i(e),M(C.$$.fragment,e),Pe=i(e),M(O.$$.fragment,e),De=i(e),M(K.$$.fragment,e),Oe=i(e),ee=r(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1hcwwpn"&&(ee.innerHTML=Ft),Ke=i(e),te=r(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-gy0104"&&(te.innerHTML=Wt),et=i(e),ne=r(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1qv2h88"&&(ne.innerHTML=Xt),tt=i(e),le=r(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-93ywpw"&&(le.innerHTML=qt),nt=i(e),M(se.$$.fragment,e),lt=i(e),ie=r(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-9gv9c8"&&(ie.innerHTML=Nt),st=i(e),M(I.$$.fragment,e),it=i(e),ae=r(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-1h96pqn"&&(ae.innerHTML=Ht),at=i(e),oe=r(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-1u6w4tj"&&(oe.innerHTML=Qt),ot=i(e),M(v.$$.fragment,e),rt=i(e),M(re.$$.fragment,e),ct=i(e),ce=r(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-1dy7udt"&&(ce.innerHTML=Yt),ut=i(e),ue=r(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-c8lo6u"&&(ue.innerHTML=zt),pt=i(e),pe=r(e,"UL",{"data-svelte-h":!0}),c(pe)!=="svelte-3qxazp"&&(pe.innerHTML=Pt),Mt=i(e),M(Me.$$.fragment,e),dt=i(e),M(de.$$.fragment,e),mt=i(e),M(me.$$.fragment,e),ht=i(e),he=r(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-13bkehl"&&(he.innerHTML=Dt),ft=i(e),fe=r(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-7d5aoo"&&(fe.innerHTML=Ot),gt=i(e),ge=r(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-120stu7"&&(ge.innerHTML=Kt),yt=i(e),ye=r(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-i2tmwy"&&(ye.innerHTML=en),Tt=i(e),Te=r(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-1fqsw"&&(Te.innerHTML=tn),wt=i(e),we=r(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-kn7urm"&&(we.innerHTML=nn),jt=i(e),M(je.$$.fragment,e),Jt=i(e),be=r(e,"P",{}),rn(be).forEach(n),this.h()},h(){cn(a,"name","hf:doc:metadata"),cn(a,"content",Jn)},m(e,t){hn(document.head,a),l(e,y,t),l(e,u,t),l(e,g,t),d(b,e,t),l(e,T,t),l(e,j,t),l(e,Ue,t),l(e,_,t),l(e,Ce,t),d(A,e,t),l(e,Ie,t),l(e,$,t),l(e,ve,t),l(e,Z,t),l(e,_e,t),d(R,e,t),l(e,Ae,t),l(e,E,t),l(e,$e,t),d(V,e,t),l(e,Ze,t),l(e,B,t),l(e,Re,t),d(x,e,t),l(e,Ee,t),l(e,G,t),l(e,Ve,t),d(L,e,t),l(e,Be,t),d(S,e,t),l(e,xe,t),d(U,e,t),l(e,Ge,t),l(e,k,t),l(e,Le,t),d(F,e,t),l(e,Se,t),d(W,e,t),l(e,ke,t),l(e,X,t),l(e,Fe,t),d(q,e,t),l(e,We,t),l(e,N,t),l(e,Xe,t),l(e,H,t),l(e,qe,t),l(e,Q,t),l(e,Ne,t),l(e,Y,t),l(e,He,t),d(z,e,t),l(e,Qe,t),l(e,P,t),l(e,Ye,t),l(e,D,t),l(e,ze,t),d(C,e,t),l(e,Pe,t),d(O,e,t),l(e,De,t),d(K,e,t),l(e,Oe,t),l(e,ee,t),l(e,Ke,t),l(e,te,t),l(e,et,t),l(e,ne,t),l(e,tt,t),l(e,le,t),l(e,nt,t),d(se,e,t),l(e,lt,t),l(e,ie,t),l(e,st,t),d(I,e,t),l(e,it,t),l(e,ae,t),l(e,at,t),l(e,oe,t),l(e,ot,t),d(v,e,t),l(e,rt,t),d(re,e,t),l(e,ct,t),l(e,ce,t),l(e,ut,t),l(e,ue,t),l(e,pt,t),l(e,pe,t),l(e,Mt,t),d(Me,e,t),l(e,dt,t),d(de,e,t),l(e,mt,t),d(me,e,t),l(e,ht,t),l(e,he,t),l(e,ft,t),l(e,fe,t),l(e,gt,t),l(e,ge,t),l(e,yt,t),l(e,ye,t),l(e,Tt,t),l(e,Te,t),l(e,wt,t),l(e,we,t),l(e,jt,t),d(je,e,t),l(e,Jt,t),l(e,be,t),bt=!0},p(e,[t]){const ln={};t&2&&(ln.$$scope={dirty:t,ctx:e}),U.$set(ln);const sn={};t&2&&(sn.$$scope={dirty:t,ctx:e}),C.$set(sn);const an={};t&2&&(an.$$scope={dirty:t,ctx:e}),I.$set(an);const on={};t&2&&(on.$$scope={dirty:t,ctx:e}),v.$set(on)},i(e){bt||(m(b.$$.fragment,e),m(A.$$.fragment,e),m(R.$$.fragment,e),m(V.$$.fragment,e),m(x.$$.fragment,e),m(L.$$.fragment,e),m(S.$$.fragment,e),m(U.$$.fragment,e),m(F.$$.fragment,e),m(W.$$.fragment,e),m(q.$$.fragment,e),m(z.$$.fragment,e),m(C.$$.fragment,e),m(O.$$.fragment,e),m(K.$$.fragment,e),m(se.$$.fragment,e),m(I.$$.fragment,e),m(v.$$.fragment,e),m(re.$$.fragment,e),m(Me.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(je.$$.fragment,e),bt=!0)},o(e){h(b.$$.fragment,e),h(A.$$.fragment,e),h(R.$$.fragment,e),h(V.$$.fragment,e),h(x.$$.fragment,e),h(L.$$.fragment,e),h(S.$$.fragment,e),h(U.$$.fragment,e),h(F.$$.fragment,e),h(W.$$.fragment,e),h(q.$$.fragment,e),h(z.$$.fragment,e),h(C.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(se.$$.fragment,e),h(I.$$.fragment,e),h(v.$$.fragment,e),h(re.$$.fragment,e),h(Me.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(je.$$.fragment,e),bt=!1},d(e){e&&(n(y),n(u),n(g),n(T),n(j),n(Ue),n(_),n(Ce),n(Ie),n($),n(ve),n(Z),n(_e),n(Ae),n(E),n($e),n(Ze),n(B),n(Re),n(Ee),n(G),n(Ve),n(Be),n(xe),n(Ge),n(k),n(Le),n(Se),n(ke),n(X),n(Fe),n(We),n(N),n(Xe),n(H),n(qe),n(Q),n(Ne),n(Y),n(He),n(Qe),n(P),n(Ye),n(D),n(ze),n(Pe),n(De),n(Oe),n(ee),n(Ke),n(te),n(et),n(ne),n(tt),n(le),n(nt),n(lt),n(ie),n(st),n(it),n(ae),n(at),n(oe),n(ot),n(rt),n(ct),n(ce),n(ut),n(ue),n(pt),n(pe),n(Mt),n(dt),n(mt),n(ht),n(he),n(ft),n(fe),n(gt),n(ge),n(yt),n(ye),n(Tt),n(Te),n(wt),n(we),n(jt),n(Jt),n(be)),n(a),f(b,e),f(A,e),f(R,e),f(V,e),f(x,e),f(L,e),f(S,e),f(U,e),f(F,e),f(W,e),f(q,e),f(z,e),f(C,e),f(O,e),f(K,e),f(se,e),f(I,e),f(v,e),f(re,e),f(Me,e),f(de,e),f(me,e),f(je,e)}}}const Jn='{"title":"Fine-tune Mistral 7B v0.3 with PyTorch Training DLC using SFT on Vertex AI","local":"fine-tune-mistral-7b-v03-with-pytorch-training-dlc-using-sft-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Optional: Create bucket in GCS","local":"optional-create-bucket-in-gcs","sections":[],"depth":2},{"title":"Prepare CustomContainerTrainingJob","local":"prepare-customcontainertrainingjob","sections":[],"depth":2},{"title":"Define CustomContainerTrainingJob Requirements","local":"define-customcontainertrainingjob-requirements","sections":[],"depth":2},{"title":"Run CustomContainerTrainingJob","local":"run-customcontainertrainingjob","sections":[],"depth":2}],"depth":1}';function bn(J){return pn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class An extends Mn{constructor(a){super(),dn(this,a,bn,jn,un,{})}}export{An as component};
