import{s as Yn,o as qn,n as Fl}from"../chunks/scheduler.b108d059.js";import{S as zn,i as Dn,g as o,s,r,A as Pn,h as i,f as l,c as a,j as Hn,u as c,x as p,k as Ln,y as On,a as n,v as M,d,t as m,w as u}from"../chunks/index.008de539.js";import{T as Sl}from"../chunks/Tip.aeb15ab7.js";import{C as T}from"../chunks/CodeBlock.3968c746.js";import{H as J,E as Kn}from"../chunks/EditOnGithub.d1c48e3d.js";function es(U){let h,g='Starting from TGI 2.3 DLC i.e. <code>us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu124.2-3.ubuntu2204.py311</code>, and onwards, you can set the environment variable value <code>MESSAGES_API_ENABLED=&quot;true&quot;</code> to deploy the <a href="https://huggingface.co/docs/text-generation-inference/main/en/messages_api" rel="nofollow">Messages API</a> on Vertex AI, otherwise, the <a href="https://huggingface.co/docs/text-generation-inference/main/en/quicktour#consuming-tgi" rel="nofollow">Generate API</a> will be deployed instead.';return{c(){h=o("p"),h.innerHTML=g},l(y){h=i(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1jcnsbw"&&(h.innerHTML=g)},m(y,w){n(y,h,w)},p:Fl,d(y){y&&l(h)}}}function ts(U){let h,g="You will need to either retrieve the resource name i.e. the <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code> URL yourself via the Google Cloud Console, or just replace the <code>ENDPOINT_ID</code> below that can either be found via the previously instantiated <code>endpoint</code> as <code>endpoint.id</code> or via the Google Cloud Console under the Online predictions where the endpoint is listed.";return{c(){h=o("p"),h.innerHTML=g},l(y){h=i(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-10r1du6"&&(h.innerHTML=g)},m(y,w){n(y,h,w)},p:Fl,d(y){y&&l(h)}}}function ls(U){let h,g="When deleting the model from Vertex AI, as it’s stored within a GCS Bucket, neither the bucket nor its contents will be removed when removing the model from Vertex AI.";return{c(){h=o("p"),h.textContent=g},l(y){h=i(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-uo7qbi"&&(h.textContent=g)},m(y,w){n(y,h,w)},p:Fl,d(y){y&&l(h)}}}function ns(U){let h,g,y,w,I,at,C,Ql="Gemma is a family of lightweight, state-of-the-art open models built from the same research and technology used to create the Gemini models, developed by Google DeepMind and other teams across Google. Text Generation Inference (TGI) is a toolkit developed by Hugging Face for deploying and serving LLMs, with high performance text generation. And, Google Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.",ot,v,Hl='This example showcases how to deploy any supported text-generation model, in this case <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a>, downloaded from the Hugging Face Hub and uploaded to a Google Cloud Storage (GCS) Bucket, on Vertex AI using the Hugging Face DLC for TGI available in Google Cloud Platform (GCP).',it,Z,Ll='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/model-in-hf-hub.png" alt="&#39;google/gemma-7b-it&#39; in the Hugging Face Hub"/>',pt,G,rt,A,Yl='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',ct,$,ql="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",Mt,V,dt,B,zl="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",mt,x,ut,R,Dl="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",ht,k,yt,W,Pl="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",Tt,_,gt,N,Jt,E,Ol="Unless you already have a GCS Bucket with the artifact that you want to serve, please follow the instructions below in order to create a new bucket and download and upload the model weights into it.",wt,X,Kl="To create the bucket on Google Cloud Storage (GCS), you first need to ensure that the name is unique for the new bucket or if a bucket with the same name already exists. To do so, both the <code>gsutil</code> SDK and the <code>crcmod</code> Python package need to be installed in advance as follows:",Ut,S,ft,F,en="Then you can check whether the bucket exists in GCS, and create it if it doesn’t, with the following bash script:",jt,Q,bt,H,tn='If either the bucket was created or if the bucket existed in advance, you can already upload <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> from either the Hugging Face Hub, or local storage.',It,L,Ct,Y,ln="If the model is available locally, e.g. under the Hugging Face cache path at <code>~/.cache/huggingface/hub/models--google--gemma-7b-it/snapshots/8adab6a35fdbcdae0ae41ab1f711b1bc8d05727e</code>, you should run the following script to upload it to the GCS Bucket.",vt,q,Zt,z,Gt,D,nn='Alternatively, you can also upload the model to the GCS Bucket from the Hugging Face Hub. As <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model, you need to login into your Hugging Face Hub account with a read-access token either fine-grained with access to the gated model, or just overall read-access to your account.',At,P,sn='More information on how to generate a read-only access token for the Hugging Face Hub in the instructions at <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">https://huggingface.co/docs/hub/en/security-tokens</a>.',$t,O,Vt,K,Bt,ee,an="After <code>huggingface_hub</code> installation and login are completed, you can run the following bash script to download the model locally within a temporary directory, and then upload those to the GCS Bucket.",xt,te,Rt,le,on='To see the end to end script, please check <a href="https://github.com/huggingface/Google-Cloud-Containers/blob/main/scripts/upload_model_to_gcs.sh" rel="nofollow"><code>./scripts/upload_model_to_gcs.sh</code></a> within the root directory of this repository.',kt,ne,pn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/gcs-model-artifact.png" alt="GCS Bucket with model artifact"/>',Wt,se,_t,ae,rn="Once everything is set up, you can already initialize the Vertex AI session via the <code>google-cloud-aiplatform</code> Python SDK as follows:",Nt,oe,Et,ie,cn="Then you can already “upload” the model i.e. register the model on Vertex AI. It is not an upload per se, since the model will be automatically downloaded from the GCS Bucket URI on startup, so what is uploaded is only the configuration, not the model weights.",Xt,pe,Mn="Before going into the code, let’s quickly review the arguments provided to the <code>upload</code> method:",St,re,dn='<li><p><strong><code>display_name</code></strong> is the name that will be shown in the Vertex AI Model Registry.</p></li> <li><p><strong><code>artifact_uri</code></strong> is the path to the directory with the artifact within the GCS Bucket.</p></li> <li><p><strong><code>serving_container_image_uri</code></strong> is the location of the Hugging Face DLC for TGI that will be used for serving the model.</p></li> <li><p><strong><code>serving_container_environment_variables</code></strong> are the environment variables that will be used during the container runtime, so these are aligned with the environment variables defined by <code>text-generation-inference</code>, which are analog to the <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher" rel="nofollow"><code>text-generation-launcher</code> arguments</a>. Additionally, the Hugging Face DLCs for TGI also capture the <code>AIP_</code> environment variables from Vertex AI as in <a href="https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements" rel="nofollow">Vertex AI Documentation - Custom container requirements for prediction</a>.</p> <ul><li><code>NUM_SHARD</code> is the number of shards to use if you don’t want to use all GPUs on a given machine e.g. if you have two GPUs but you just want to use one for TGI then <code>NUM_SHARD=1</code>, otherwise it matches the <code>CUDA_VISIBLE_DEVICES</code>.</li> <li><code>MAX_INPUT_TOKENS</code> is the maximum allowed input length (expressed in number of tokens), the larger it is, the larger the prompt can be, but also more memory will be consumed.</li> <li><code>MAX_TOTAL_TOKENS</code> is the most important value to set as it defines the “memory budget” of running clients requests, the larger this value, the larger amount each request will be in your RAM and the less effective batching can be.</li> <li><code>MAX_BATCH_PREFILL_TOKENS</code> limits the number of tokens for the prefill operation, as it takes the most memory and is compute bound, it is interesting to limit the number of requests that can be sent.</li> <li><code>HUGGING_FACE_HUB_TOKEN</code> is the Hugging Face Hub token, required as <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> is a gated model.</li></ul></li> <li><p>(optional) <strong><code>serving_container_ports</code></strong> is the port where the Vertex AI endpoint will be exposed, by default 8080.</p></li>',Ft,ce,mn='For more information on the supported <code>aiplatform.Model.upload</code> arguments, check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload</a>.',Qt,f,Ht,Me,Lt,de,un='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-model.png" alt="Model on Vertex AI Model Registry"/>',Yt,me,hn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-model-path.png" alt="Model on Vertex AI Model Registry with path to GCS"/>',qt,ue,zt,he,yn="After the model is registered on Vertex AI, you need to define the endpoint that you want to deploy the model to, and then link the model deployment to that endpoint resource.",Dt,ye,Tn="To do so, you need to call the method <code>aiplatform.Endpoint.create</code> to create a new Vertex AI endpoint resource (which is not linked to a model or anything usable yet).",Pt,Te,Ot,ge,gn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint.png" alt="Vertex AI Endpoint created"/>',Kt,Je,Jn="Now you can deploy the registered model in an endpoint on Vertex AI.",el,we,wn="The <code>deploy</code> method will link the previously created endpoint resource with the model that contains the configuration of the serving container, and then, it will deploy the model on Vertex AI in the specified instance.",tl,Ue,Un="Before going into the code, let’s quicklyl review the arguments provided to the <code>deploy</code> method:",ll,fe,fn='<li><strong><code>endpoint</code></strong> is the endpoint to deploy the model to, which is optional, and by default will be set to the model display name with the <code>_endpoint</code> suffix.</li> <li><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> are arguments that define which instance to use, and additionally, the accelerator to use and the number of accelerators, respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</li>',nl,je,jn='For more information on the supported <code>aiplatform.Model.deploy</code> arguments, you can check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy</a>.',sl,be,al,Ie,bn="<strong>WARNING</strong>: <em>The Vertex AI endpoint deployment via the <code>deploy</code> method may take from 15 to 25 minutes.</em>",ol,Ce,In='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint-run.png" alt="Vertex AI Endpoint running the model"/>',il,ve,Cn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-endpoint-logs.png" alt="Vertex AI Endpoint logs in Cloud Logging"/>',pl,Ze,rl,Ge,vn="Finally, you can run the online predictions on Vertex AI using the <code>predict</code> method, which will send the requests to the running endpoint in the <code>/predict</code> route specified within the container following Vertex AI I/O payload formatting.",cl,Ae,Zn='As you are serving a <code>text-generation</code> model, you will need to make sure that the chat template, if any, is applied correctly to the input conversation; meaning that <code>transformers</code> need to be installed so as to instantiate the <code>tokenizer</code> for <a href="https://huggingface.co/google/gemma-7b-it" rel="nofollow"><code>google/gemma-7b-it</code></a> and run the <code>apply_chat_template</code> method over the input conversation before sending the input within the payload to the Vertex AI endpoint.',Ml,$e,dl,Ve,Gn="After the installation is complete, the following snippet will apply the chat template to the conversation:",ml,Be,ul,xe,An='Which is what you will be sending within the payload to the deployed Vertex AI Endpoint, as well as the generation parameters as in <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation" rel="nofollow">https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation</a>.',hl,Re,yl,ke,Tl,We,$n="If you are willing to run the online prediction within the current session, you can send requests programmatically via the <code>aiplatform.Endpoint</code> (returned by the <code>aiplatform.Model.deploy</code> method) as in the following snippet:",gl,_e,Jl,Ne,Vn="Producing the following <code>output</code>:",wl,Ee,Ul,Xe,fl,Se,Bn="If the Vertex AI Endpoint was deployed in a different session and you want to use it but don’t have access to the <code>deployed_model</code> variable returned by the <code>aiplatform.Model.deploy</code> method as in the previous section; you can also run the following snippet to instantiate the deployed <code>aiplatform.Endpoint</code> via its resource name as <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code>.",jl,j,bl,Fe,Il,Qe,Cl,He,xn="Alternatively, for testing purposes you can also use the Vertex AI Online Prediction UI, that provides a field that expects the JSON payload formatted according to the Vertex AI specification (as in the examples above) being:",vl,Le,Zl,Ye,Rn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-gemma-from-gcs-on-vertex-ai/assets/vertex-ai-online-prediction.png" alt="Vertex AI Endpoint online inference"/>',Gl,qe,Al,ze,kn="Finally, you can already release the resources that you’ve created as follows, to avoid unnecessary costs:",$l,De,Wn="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully, after the <code>undeploy_all</code> method.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",Vl,b,Bl,Pe,xl,Oe,_n="Alternatively, you can also remove those from the Google Cloud Console following the steps:",Rl,Ke,Nn="<li>Go to Vertex AI in Google Cloud</li> <li>Go to Deploy and use -&gt; Online prediction</li> <li>Click on the endpoint and then on the deployed model/s to “Undeploy model from endpoint”</li> <li>Then go back to the endpoint list and remove the endpoint</li> <li>Finally, go to Deploy and use -&gt; Model Registry, and remove the model</li>",kl,et,En="Additionally, you may also want to remove the GCS Bucket, to do so, you can use the following <code>gcloud</code> command:",Wl,tt,_l,lt,Xn="Or, alternatively, just remove the bucket and/or its contents from the Google Cloud Console.",Nl,nt,El,st,Xl;return I=new J({props:{title:"Deploy Gemma 7B with TGI DLC from GCS on Vertex AI",local:"deploy-gemma-7b-with-tgi-dlc-from-gcs-on-vertex-ai",headingTag:"h1"}}),G=new J({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),V=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),x=new T({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMEJVQ0tFVF9VUkklM0RncyUzQSUyRiUyRmhmLXRnaS12ZXJ0ZXgtYWklMEElMjVlbnYlMjBBUlRJRkFDVF9OQU1FJTNEZ29vZ2xlLS1nZW1tYS03Yi1pdCUwQSUyNWVudiUyMENPTlRBSU5FUl9VUkklM0R1cy1kb2NrZXIucGtnLmRldiUyRmRlZXBsZWFybmluZy1wbGF0Zm9ybS1yZWxlYXNlJTJGZ2NyLmlvJTJGaHVnZ2luZ2ZhY2UtdGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZS1jdTEyNC4yLTMudWJ1bnR1MjIwNC5weTMxMQ==",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env BUCKET_URI=gs://hf-tgi-vertex-ai
%env ARTIFACT_NAME=google--gemma-7b-it
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu124<span class="hljs-number">.2</span>-<span class="hljs-number">3.</span>ubuntu2204.py311`,wrap:!1}}),k=new T({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),_=new T({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),N=new J({props:{title:"Optional: Create bucket and upload model from Hub in GCS",local:"optional-create-bucket-and-upload-model-from-hub-in-gcs",headingTag:"h2"}}),S=new T({props:{code:"IWdjbG91ZCUyMGNvbXBvbmVudHMlMjBpbnN0YWxsJTIwZ3N1dGlsJTBBIXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwY3JjbW9k",highlighted:`!gcloud components install gsutil
!pip install --upgrade --quiet crcmod`,wrap:!1}}),Q=new T({props:{code:"JTI1JTI1YmFzaCUwQSUwQSUyMyUyMFBhcnNlJTIwdGhlJTIwYnVja2V0JTIwZnJvbSUyMHRoZSUyMHByb3ZpZGVkJTIwJTI0QlVDS0VUX1VSSSUyMHBhdGglMjBpLmUuJTIwZ2l2ZW4lMjBncyUzQSUyRiUyRmJ1Y2tldC1uYW1lJTJGZGlyJTJDJTIwZXh0cmFjdCUyMGJ1Y2tldC1uYW1lJTBBQlVDS0VUX05BTUUlM0QlMjQoZWNobyUyMCUyNEJVQ0tFVF9VUkklMjAlN0MlMjBjdXQlMjAtZCclMkYnJTIwLWYzKSUwQSUyMyUyMENoZWNrJTIwaWYlMjB0aGUlMjBidWNrZXQlMjBleGlzdHMlMkMlMjBpZiUyMG5vdCUyMGNyZWF0ZSUyMGl0JTBBaWYlMjAlNUIlMjAteiUyMCUyMiUyNChnc3V0aWwlMjBscyUyMCU3QyUyMGdyZXAlMjBncyUzQSUyRiUyRiUyNEJVQ0tFVF9OQU1FKSUyMiUyMCU1RCUzQiUyMHRoZW4lMEElMjAlMjAlMjAlMjBnY2xvdWQlMjBzdG9yYWdlJTIwYnVja2V0cyUyMGNyZWF0ZSUyMGdzJTNBJTJGJTJGJTI0QlVDS0VUX05BTUUlMjAtLXByb2plY3QlM0QlMjRQUk9KRUNUX0lEJTIwLS1sb2NhdGlvbiUzRCUyNExPQ0FUSU9OJTIwLS1kZWZhdWx0LXN0b3JhZ2UtY2xhc3MlM0RTVEFOREFSRCUyMC0tdW5pZm9ybS1idWNrZXQtbGV2ZWwtYWNjZXNzJTBBZmk=",highlighted:`%%bash

<span class="hljs-comment"># Parse the bucket from the provided $BUCKET_URI path i.e. given gs://bucket-name/dir, extract bucket-name</span>
BUCKET_NAME=$(echo $BUCKET_URI | cut -d<span class="hljs-string">&#x27;/&#x27;</span> -f3)
<span class="hljs-comment"># Check if the bucket exists, if not create it</span>
<span class="hljs-keyword">if</span> [ -z <span class="hljs-string">&quot;$(gsutil ls | grep gs://$BUCKET_NAME)&quot;</span> ]; then
    gcloud storage buckets create gs://$BUCKET_NAME --project=$PROJECT_ID --location=$LOCATION --default-storage-<span class="hljs-keyword">class</span>=STANDARD --uniform-bucket-level-access
fi`,wrap:!1}}),L=new J({props:{title:"Artifact from disk / local storage",local:"artifact-from-disk--local-storage",headingTag:"h3"}}),q=new T({props:{code:"JTI1JTI1YmFzaCUwQSUyMyUyMFVwbG9hZCUyMHRoZSUyMG1vZGVsJTIwdG8lMjBHb29nbGUlMjBDbG91ZCUyMFN0b3JhZ2UlMEFMT0NBTF9ESVIlM0R+JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLWdvb2dsZS0tZ2VtbWEtN2ItaXQlMkZzbmFwc2hvdHMlMkY4YWRhYjZhMzVmZGJjZGFlMGFlNDFhYjFmNzExYjFiYzhkMDU3MjdlJTBBaWYlMjAlNUIlMjAtZCUyMCUyMiUyNExPQ0FMX0RJUiUyMiUyMCU1RCUzQiUyMHRoZW4lMEElMjAlMjAlMjAlMjBnc3V0aWwlMjAtbyUyMEdTVXRpbCUzQXBhcmFsbGVsX2NvbXBvc2l0ZV91cGxvYWRfdGhyZXNob2xkJTNEMTUwTSUyMC1tJTIwY3AlMjAtciUyMCUyNExPQ0FMX0RJUiUyRiolMjAlMjRCVUNLRVRfVVJJJTJGJTI0QVJUSUZBQ1RfTkFNRSUwQWZp",highlighted:`%%bash
<span class="hljs-comment"># Upload the model to Google Cloud Storage</span>
LOCAL_DIR=~/.cache/huggingface/hub/models--google--gemma-7b-it/snapshots/8adab6a35fdbcdae0ae41ab1f711b1bc8d05727e
<span class="hljs-keyword">if</span> [ -d <span class="hljs-string">&quot;$LOCAL_DIR&quot;</span> ]; then
    gsutil -o GSUtil:parallel_composite_upload_threshold=150M -m cp -r $LOCAL_DIR/* $BUCKET_URI/$ARTIFACT_NAME
fi`,wrap:!1}}),z=new J({props:{title:"Artifact from Hugging Face Hub",local:"artifact-from-hugging-face-hub",headingTag:"h3"}}),O=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJodWdnaW5nZmFjZV9odWIlNUJoZl90cmFuc2ZlciU1RCUyMiUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:'!pip install <span class="hljs-string">&quot;huggingface_hub[hf_transfer]&quot;</span> --upgrade --quiet',wrap:!1}}),K=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),te=new T({props:{code:"JTI1JTI1YmFzaCUwQSUyMyUyMEVuc3VyZSUyMHRoZSUyMG5lY2Vzc2FyeSUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIwYXJlJTIwc2V0JTBBZXhwb3J0JTIwSEZfSFVCX0VOQUJMRV9IRl9UUkFOU0ZFUiUzRDElMEElMEElMjMlMjAlMjMlMjBDcmVhdGUlMjBhJTIwbG9jYWwlMjBkaXJlY3RvcnklMjB0byUyMHN0b3JlJTIwdGhlJTIwZG93bmxvYWRlZCUyMG1vZGVscyUwQUxPQ0FMX0RJUiUzRCUyMnRtcCUyRmdvb2dsZS0tZ2VtbWEtN2ItaXQlMjIlMEFta2RpciUyMC1wJTIwJTI0TE9DQUxfRElSJTBBJTBBJTIzJTIwJTIzJTIwRG93bmxvYWQlMjBtb2RlbHMlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMkMlMjBleGNsdWRpbmclMjBjZXJ0YWluJTIwZmlsZSUyMHR5cGVzJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBnb29nbGUlMkZnZW1tYS03Yi1pdCUyMC0tZXhjbHVkZSUyMCUyMiouYmluJTIyJTIwJTIyKi5wdGglMjIlMjAlMjIqLmdndWYlMjIlMjAlMjIuZ2l0YXR0cmlidXRlcyUyMiUyMC0tbG9jYWwtZGlyJTIwJTI0TE9DQUxfRElSJTBBJTBBJTIzJTIwVXBsb2FkJTIwdGhlJTIwZG93bmxvYWRlZCUyMG1vZGVscyUyMHRvJTIwR29vZ2xlJTIwQ2xvdWQlMjBTdG9yYWdlJTBBZ3N1dGlsJTIwLW8lMjBHU1V0aWwlM0FwYXJhbGxlbF9jb21wb3NpdGVfdXBsb2FkX3RocmVzaG9sZCUzRDE1ME0lMjAtbSUyMGNwJTIwLWUlMjAtciUyMCUyNExPQ0FMX0RJUiUyRiolMjAlMjRCVUNLRVRfVVJJJTJGJTI0QVJUSUZBQ1RfTkFNRSUwQSUwQSUyMyUyMFJlbW92ZSUyMGFsbCUyMGZpbGVzJTIwYW5kJTIwaGlkZGVuJTIwZmlsZXMlMjBpbiUyMHRoZSUyMHRhcmdldCUyMGRpcmVjdG9yeSUwQXJtJTIwLXJmJTIwdG1wJTJG",highlighted:`%%bash
<span class="hljs-comment"># Ensure the necessary environment variables are set</span>
export HF_HUB_ENABLE_HF_TRANSFER=<span class="hljs-number">1</span>

<span class="hljs-comment"># # Create a local directory to store the downloaded models</span>
LOCAL_DIR=<span class="hljs-string">&quot;tmp/google--gemma-7b-it&quot;</span>
mkdir -p $LOCAL_DIR

<span class="hljs-comment"># # Download models from HuggingFace, excluding certain file types</span>
huggingface-cli download google/gemma-7b-it --exclude <span class="hljs-string">&quot;*.bin&quot;</span> <span class="hljs-string">&quot;*.pth&quot;</span> <span class="hljs-string">&quot;*.gguf&quot;</span> <span class="hljs-string">&quot;.gitattributes&quot;</span> --local-<span class="hljs-built_in">dir</span> $LOCAL_DIR

<span class="hljs-comment"># Upload the downloaded models to Google Cloud Storage</span>
gsutil -o GSUtil:parallel_composite_upload_threshold=150M -m cp -e -r $LOCAL_DIR/* $BUCKET_URI/$ARTIFACT_NAME

<span class="hljs-comment"># Remove all files and hidden files in the target directory</span>
rm -rf tmp/`,wrap:!1}}),se=new J({props:{title:"Register model on Vertex AI",local:"register-model-on-vertex-ai",headingTag:"h2"}}),oe=new T({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBJTIwJTIwJTIwJTIwc3RhZ2luZ19idWNrZXQlM0Rvcy5nZXRlbnYoJTIyQlVDS0VUX1VSSSUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
    staging_bucket=os.getenv(<span class="hljs-string">&quot;BUCKET_URI&quot;</span>),
)`,wrap:!1}}),f=new Sl({props:{$$slots:{default:[es]},$$scope:{ctx:U}}}),Me=new T({props:{code:"bW9kZWwlMjAlM0QlMjBhaXBsYXRmb3JtLk1vZGVsLnVwbG9hZCglMEElMjAlMjAlMjAlMjBkaXNwbGF5X25hbWUlM0QlMjJnb29nbGUtLWdlbW1hLTdiLWl0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJ0aWZhY3RfdXJpJTNEZiUyMiU3Qm9zLmdldGVudignQlVDS0VUX1VSSScpJTdEJTJGJTdCb3MuZ2V0ZW52KCdBUlRJRkFDVF9OQU1FJyklN0QlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9pbWFnZV91cmklM0Rvcy5nZXRlbnYoJTIyQ09OVEFJTkVSX1VSSSUyMiklMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9lbnZpcm9ubWVudF92YXJpYWJsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOVU1fU0hBUkQlMjIlM0ElMjAlMjIxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX1RPS0VOUyUyMiUzQSUyMCUyMjUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9UT1RBTF9UT0tFTlMlMjIlM0ElMjAlMjIxMDI0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0JBVENIX1BSRUZJTExfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHNlcnZpbmdfY29udGFpbmVyX3BvcnRzJTNEJTVCODA4MCU1RCUyQyUwQSklMEFtb2RlbC53YWl0KCk=",highlighted:`model = aiplatform.Model.upload(
    display_name=<span class="hljs-string">&quot;google--gemma-7b-it&quot;</span>,
    artifact_uri=<span class="hljs-string">f&quot;<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>)}</span>/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;ARTIFACT_NAME&#x27;</span>)}</span>&quot;</span>,
    serving_container_image_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    serving_container_environment_variables={
        <span class="hljs-string">&quot;NUM_SHARD&quot;</span>: <span class="hljs-string">&quot;1&quot;</span>,
        <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
        <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
        <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
    },
    serving_container_ports=[<span class="hljs-number">8080</span>],
)
model.wait()`,wrap:!1}}),ue=new J({props:{title:"Deploy model on Vertex AI",local:"deploy-model-on-vertex-ai",headingTag:"h2"}}),Te=new T({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBhaXBsYXRmb3JtLkVuZHBvaW50LmNyZWF0ZShkaXNwbGF5X25hbWUlM0QlMjJnb29nbGUtLWdlbW1hLTdiLWl0LWVuZHBvaW50JTIyKQ==",highlighted:'endpoint = aiplatform.Endpoint.create(display_name=<span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>)',wrap:!1}}),be=new T({props:{code:"ZGVwbG95ZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0RlbmRwb2ludCUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmcyLXN0YW5kYXJkLTQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX0w0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`deployed_model = model.deploy(
    endpoint=endpoint,
    machine_type=<span class="hljs-string">&quot;g2-standard-4&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_L4&quot;</span>,
    accelerator_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Ze=new J({props:{title:"Online predictions on Vertex AI",local:"online-predictions-on-vertex-ai",headingTag:"h2"}}),$e=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwdHJhbnNmb3JtZXJz",highlighted:"!pip install --upgrade --quiet transformers",wrap:!1}}),Be=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtN2ItaXQlMjIlMkMlMjB0b2tlbiUzRGdldF90b2tlbigpKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUwQSklMEElMjMlMjAlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNu",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-7b-it&quot;</span>, token=get_token())

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s Deep Learning?&quot;</span>},
]

inputs = tokenizer.apply_chat_template(
    messages,
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
)
<span class="hljs-comment"># &lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n</span>`,wrap:!1}}),Re=new J({props:{title:"Via Python",local:"via-python",headingTag:"h3"}}),ke=new J({props:{title:"Within the same session",local:"within-the-same-session",headingTag:"h4"}}),_e=new T({props:{code:"b3V0cHV0JTIwJTNEJTIwZGVwbG95ZWRfbW9kZWwucHJlZGljdCglMEElMjAlMjAlMjAlMjBpbnN0YW5jZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dHMlMjIlM0ElMjAlMjIlM0Nib3MlM0UlM0NzdGFydF9vZl90dXJuJTNFdXNlciU1Q25XaGF0J3MlMjBEZWVwJTIwTGVhcm5pbmclM0YlM0NlbmRfb2ZfdHVybiUzRSU1Q24lM0NzdGFydF9vZl90dXJuJTNFbW9kZWwlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1ldGVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMC45NSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQXByaW50KG91dHB1dC5wcmVkaWN0aW9ucyU1QjAlNUQp",highlighted:`output = deployed_model.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">256</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>,
            },
        },
    ]
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),Ee=new T({props:{code:"UHJlZGljdGlvbihwcmVkaWN0aW9ucyUzRCU1QiclNUNuJTVDbkRlZXAlMjBsZWFybmluZyUyMGlzJTIwYSUyMHR5cGUlMjBvZiUyMG1hY2hpbmUlMjBsZWFybmluZyUyMHRoYXQlMjB1c2VzJTIwYXJ0aWZpY2lhbCUyMG5ldXJhbCUyMG5ldHdvcmtzJTIwdG8lMjBsZWFybiUyMGZyb20lMjBsYXJnZSUyMGFtb3VudHMlMjBvZiUyMGRhdGElMkMlMjBtYWtpbmclMjBpdCUyMGElMjBwb3dlcmZ1bCUyMHRvb2wlMjBmb3IlMjB2YXJpb3VzJTIwdGFza3MlMkMlMjBpbmNsdWRpbmclMjBpbWFnZSUyMHJlY29nbml0aW9uJTJDJTIwbmF0dXJhbCUyMGxhbmd1YWdlJTIwcHJvY2Vzc2luZyUyQyUyMGFuZCUyMHNwZWVjaCUyMHJlY29nbml0aW9uLiU1Q24lNUNuKipLZXklMjBDb25jZXB0cyUzQSoqJTVDbiU1Q24qJTIwKipBcnRpZmljaWFsJTIwTmV1cmFsJTIwTmV0d29ya3MlMjAoQU5OcyklM0EqKiUyMFN0cnVjdHVyZXMlMjB0aGF0JTIwbWltaWMlMjB0aGUlMjBpbnRlcmNvbm5lY3RlZCUyMG5ldXJvbnMlMjBpbiUyMHRoZSUyMGJyYWluLiU1Q24qJTIwKipEZWVwJTIwTGVhcm5pbmclMjBBcmNoaXRlY3R1cmVzJTNBKiolMjBNdWx0aS1sYXllcmVkJTIwQU5OcyUyMHRoYXQlMjBsZWFybiUyMGhpZXJhcmNoaWNhbCUyMGZlYXR1cmVzJTIwZnJvbSUyMGRhdGEuJTVDbiolMjAqKlRyYW5zZmVyJTIwTGVhcm5pbmclM0EqKiUyMFJldXNpbmclMjBsZWFybmVkJTIwZmVhdHVyZXMlMjBmcm9tJTIwb25lJTIwdGFzayUyMHRvJTIwaW1wcm92ZSUyMHBlcmZvcm1hbmNlJTIwb24lMjBhbm90aGVyLiU1Q24lNUNuKipUeXBlcyUyMG9mJTIwRGVlcCUyMExlYXJuaW5nJTNBKiolNUNuJTVDbiolMjAqKlN1cGVydmlzZWQlMjBMZWFybmluZyUzQSoqJTIwTW9kZWxzJTIwYXJlJTIwdHJhaW5lZCUyMG9uJTIwbGFiZWxlZCUyMGRhdGElMkMlMjB3aGVyZSUyMGlucHV0cyUyMGFyZSUyMHBhaXJlZCUyMHdpdGglMjBjb3JyZXNwb25kaW5nJTIwb3V0cHV0cy4lNUNuKiUyMCoqVW5zdXBlcnZpc2VkJTIwTGVhcm5pbmclM0EqKiUyME1vZGVscyUyMGxlYXJuJTIwcGF0dGVybnMlMjBmcm9tJTIwdW5sYWJlbGVkJTIwZGF0YSUyQyUyMHN1Y2glMjBhcyUyMGNsdXN0ZXJpbmclMjBvciUyMGRpbWVuc2lvbmFsaXR5JTIwcmVkdWN0aW9uLiU1Q24qJTIwKipSZWluZm9yY2VtZW50JTIwTGVhcm5pbmclM0EqKiUyME1vZGVscyUyMGxlYXJuJTIwdGhyb3VnaCUyMHRyaWFsLWFuZC1lcnJvciUyMGJ5JTIwaW50ZXJhY3RpbmclMjB3aXRoJTIwYW4lMjBlbnZpcm9ubWVudCUyMHRvJTIwb3B0aW1pemUlMjBhJTIwdGFzay4lNUNuJTVDbioqQmVuZWZpdHMlM0EqKiU1Q24lNUNuKiUyMCoqSGlnaCUyMEFjY3VyYWN5JTNBKiolMjBEZWVwJTIwbGVhcm5pbmclMjBtb2RlbHMlMjBjYW4lMjBhY2hpZXZlJTIwaGlnaCUyMGFjY3VyYWN5JTIwb24lMjBjb21wbGV4JTIwdGFza3MuJTVDbiolMjAqKkFkYXB0YWJpbGl0eSUzQSoqJTIwRGVlcCUyMGxlYXJuaW5nJTIwbW9kZWxzJTIwY2FuJTIwYWRhcHQlMjB0byUyMG5ldyUyMGRhdGElMjBhbmQlMjB0YXNrcy4lNUNuKiUyMCoqU2NhbGFiaWxpdHklM0EqKiUyMERlZXAlMjBsZWFybmluZyUyMG1vZGVscyUyMGNhbiUyMGhhbmRsZSUyMGxhcmdlJTIwYW1vdW50cyUyMG9mJTIwZGF0YS4lNUNuJTVDbioqQXBwbGljYXRpb25zJTNBKiolNUNuJTVDbiolMjBJbWFnZSUyMHJlY29nbml0aW9uJTVDbiolMjBOYXR1cmFsJTIwbGFuZ3VhZ2UlMjBwcm9jZXNzaW5nJTIwKE5MUCklNUNuJyU1RCUyQyUyMGRlcGxveWVkX21vZGVsX2lkJTNEJyoqKiclMkMlMjBtZXRhZGF0YSUzRE5vbmUlMkMlMjBtb2RlbF92ZXJzaW9uX2lkJTNEJzEnJTJDJTIwbW9kZWxfcmVzb3VyY2VfbmFtZSUzRCdwcm9qZWN0cyUyRioqKiUyRmxvY2F0aW9ucyUyRnVzLWNlbnRyYWwxJTJGbW9kZWxzJTJGKioqJyUyQyUyMGV4cGxhbmF0aW9ucyUzRE5vbmUp",highlighted:'<span class="hljs-constructor">Prediction(<span class="hljs-params">predictions</span>=[&#x27;\\<span class="hljs-params">n</span>\\<span class="hljs-params">nDeep</span> <span class="hljs-params">learning</span> <span class="hljs-params">is</span> <span class="hljs-params">a</span> <span class="hljs-params">type</span> <span class="hljs-params">of</span> <span class="hljs-params">machine</span> <span class="hljs-params">learning</span> <span class="hljs-params">that</span> <span class="hljs-params">uses</span> <span class="hljs-params">artificial</span> <span class="hljs-params">neural</span> <span class="hljs-params">networks</span> <span class="hljs-params">to</span> <span class="hljs-params">learn</span> <span class="hljs-params">from</span> <span class="hljs-params">large</span> <span class="hljs-params">amounts</span> <span class="hljs-params">of</span> <span class="hljs-params">data</span>, <span class="hljs-params">making</span> <span class="hljs-params">it</span> <span class="hljs-params">a</span> <span class="hljs-params">powerful</span> <span class="hljs-params">tool</span> <span class="hljs-params">for</span> <span class="hljs-params">various</span> <span class="hljs-params">tasks</span>, <span class="hljs-params">including</span> <span class="hljs-params">image</span> <span class="hljs-params">recognition</span>, <span class="hljs-params">natural</span> <span class="hljs-params">language</span> <span class="hljs-params">processing</span>, <span class="hljs-params">and</span> <span class="hljs-params">speech</span> <span class="hljs-params">recognition</span>.\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">**</span>Key Concepts:<span class="hljs-operator">**</span>\\<span class="hljs-params">n</span>\\<span class="hljs-params">n</span><span class="hljs-operator">*</span> <span class="hljs-operator">**</span>Artificial Neural Networks (ANNs)</span>:** Structures that mimic the interconnected neurons <span class="hljs-keyword">in</span> the brain.\\n* **Deep Learning Architectures:** Multi-layered ANNs that learn hierarchical features from data.\\n* **Transfer Learning:** Reusing learned features from one task <span class="hljs-keyword">to</span> improve performance on another.\\n\\n**Types <span class="hljs-keyword">of</span> Deep Learning:**\\n\\n* **Supervised Learning:** Models are trained on labeled data, where inputs are paired <span class="hljs-keyword">with</span> corresponding outputs.\\n* **Unsupervised Learning:** Models learn patterns from unlabeled data, such <span class="hljs-keyword">as</span> clustering <span class="hljs-keyword">or</span> dimensionality reduction.\\n* **Reinforcement Learning:** Models learn through trial-<span class="hljs-keyword">and</span>-error by interacting <span class="hljs-keyword">with</span> an environment <span class="hljs-keyword">to</span> optimize a task.\\n\\n**Benefits:**\\n\\n* **High Accuracy:** Deep learning models can achieve high accuracy on complex tasks.\\n* **Adaptability:** Deep learning models can adapt <span class="hljs-keyword">to</span> <span class="hljs-keyword">new</span> data <span class="hljs-keyword">and</span> tasks.\\n* **Scalability:** Deep learning models can handle large amounts <span class="hljs-keyword">of</span> data.\\n\\n**Applications:**\\n\\n* Image recognition\\n* Natural language processing (NLP)\\n&#x27;], deployed_model_id=&#x27;***&#x27;, metadata=None, model_version_id=<span class="hljs-character">&#x27;1&#x27;</span>, model_resource_name=&#x27;projects<span class="hljs-comment">/***/</span>locations/us-central1/models<span class="hljs-comment">/***&#x27;, explanations=None)</span>',wrap:!1}}),Xe=new J({props:{title:"From a different session",local:"from-a-different-session",headingTag:"h4"}}),j=new Sl({props:{$$slots:{default:[ts]},$$scope:{ctx:U}}}),Fe=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>), location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>))

endpoint_display_name = <span class="hljs-string">&quot;google--gemma-7b-it-endpoint&quot;</span>  <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> change to your endpoint display name</span>

<span class="hljs-comment"># Iterates over all the Vertex AI Endpoints within the current project and keeps the first match (if any), otherwise set to None</span>
ENDPOINT_ID = <span class="hljs-built_in">next</span>(
    (endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> aiplatform.Endpoint.<span class="hljs-built_in">list</span>() <span class="hljs-keyword">if</span> endpoint.display_name == endpoint_display_name), <span class="hljs-literal">None</span>
)
<span class="hljs-keyword">assert</span> ENDPOINT_ID, (
    <span class="hljs-string">&quot;\`ENDPOINT_ID\` is not set, please make sure that the \`endpoint_display_name\` is correct at &quot;</span>
    <span class="hljs-string">f&quot;https://console.cloud.google.com/vertex-ai/online-prediction/endpoints?project=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>&quot;</span>
)

endpoint = aiplatform.Endpoint(
    <span class="hljs-string">f&quot;projects/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>/locations/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_ID}</span>&quot;</span>
)
output = endpoint.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
            },
        },
    ],
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),Qe=new J({props:{title:"Via the Vertex AI Online Prediction UI",local:"via-the-vertex-ai-online-prediction-ui",headingTag:"h3"}}),Le=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5zdGFuY2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTNDYm9zJTNFJTNDc3RhcnRfb2ZfdHVybiUzRXVzZXIlNUNuV2hhdCdzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTNDZW5kX29mX3R1cm4lM0UlNUNuJTNDc3RhcnRfb2ZfdHVybiUzRW1vZGVsJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3BfcCUyMiUzQSUyMDAuOTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuNyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;instances&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;bos&gt;&lt;start_of_turn&gt;user\\nWhat&#x27;s Deep Learning?&lt;end_of_turn&gt;\\n&lt;start_of_turn&gt;model\\n&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;max_new_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;do_sample&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;top_p&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.95</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;temperature&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.7</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),qe=new J({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),b=new Sl({props:{$$slots:{default:[ls]},$$scope:{ctx:U}}}),Pe=new T({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),tt=new T({props:{code:"IWdjbG91ZCUyMHN0b3JhZ2UlMjBybSUyMC1yJTIwJTI0QlVDS0VUX1VSSQ==",highlighted:"!gcloud storage rm -r $BUCKET_URI",wrap:!1}}),nt=new Kn({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-deploy-gemma-from-gcs-on-vertex-ai.mdx"}}),{c(){h=o("meta"),g=s(),y=o("p"),w=s(),r(I.$$.fragment),at=s(),C=o("p"),C.textContent=Ql,ot=s(),v=o("p"),v.innerHTML=Hl,it=s(),Z=o("p"),Z.innerHTML=Ll,pt=s(),r(G.$$.fragment),rt=s(),A=o("p"),A.innerHTML=Yl,ct=s(),$=o("p"),$.innerHTML=ql,Mt=s(),r(V.$$.fragment),dt=s(),B=o("p"),B.textContent=zl,mt=s(),r(x.$$.fragment),ut=s(),R=o("p"),R.textContent=Dl,ht=s(),r(k.$$.fragment),yt=s(),W=o("p"),W.textContent=Pl,Tt=s(),r(_.$$.fragment),gt=s(),r(N.$$.fragment),Jt=s(),E=o("p"),E.textContent=Ol,wt=s(),X=o("p"),X.innerHTML=Kl,Ut=s(),r(S.$$.fragment),ft=s(),F=o("p"),F.textContent=en,jt=s(),r(Q.$$.fragment),bt=s(),H=o("p"),H.innerHTML=tn,It=s(),r(L.$$.fragment),Ct=s(),Y=o("p"),Y.innerHTML=ln,vt=s(),r(q.$$.fragment),Zt=s(),r(z.$$.fragment),Gt=s(),D=o("p"),D.innerHTML=nn,At=s(),P=o("p"),P.innerHTML=sn,$t=s(),r(O.$$.fragment),Vt=s(),r(K.$$.fragment),Bt=s(),ee=o("p"),ee.innerHTML=an,xt=s(),r(te.$$.fragment),Rt=s(),le=o("p"),le.innerHTML=on,kt=s(),ne=o("p"),ne.innerHTML=pn,Wt=s(),r(se.$$.fragment),_t=s(),ae=o("p"),ae.innerHTML=rn,Nt=s(),r(oe.$$.fragment),Et=s(),ie=o("p"),ie.textContent=cn,Xt=s(),pe=o("p"),pe.innerHTML=Mn,St=s(),re=o("ul"),re.innerHTML=dn,Ft=s(),ce=o("p"),ce.innerHTML=mn,Qt=s(),r(f.$$.fragment),Ht=s(),r(Me.$$.fragment),Lt=s(),de=o("p"),de.innerHTML=un,Yt=s(),me=o("p"),me.innerHTML=hn,qt=s(),r(ue.$$.fragment),zt=s(),he=o("p"),he.textContent=yn,Dt=s(),ye=o("p"),ye.innerHTML=Tn,Pt=s(),r(Te.$$.fragment),Ot=s(),ge=o("p"),ge.innerHTML=gn,Kt=s(),Je=o("p"),Je.textContent=Jn,el=s(),we=o("p"),we.innerHTML=wn,tl=s(),Ue=o("p"),Ue.innerHTML=Un,ll=s(),fe=o("ul"),fe.innerHTML=fn,nl=s(),je=o("p"),je.innerHTML=jn,sl=s(),r(be.$$.fragment),al=s(),Ie=o("p"),Ie.innerHTML=bn,ol=s(),Ce=o("p"),Ce.innerHTML=In,il=s(),ve=o("p"),ve.innerHTML=Cn,pl=s(),r(Ze.$$.fragment),rl=s(),Ge=o("p"),Ge.innerHTML=vn,cl=s(),Ae=o("p"),Ae.innerHTML=Zn,Ml=s(),r($e.$$.fragment),dl=s(),Ve=o("p"),Ve.textContent=Gn,ml=s(),r(Be.$$.fragment),ul=s(),xe=o("p"),xe.innerHTML=An,hl=s(),r(Re.$$.fragment),yl=s(),r(ke.$$.fragment),Tl=s(),We=o("p"),We.innerHTML=$n,gl=s(),r(_e.$$.fragment),Jl=s(),Ne=o("p"),Ne.innerHTML=Vn,wl=s(),r(Ee.$$.fragment),Ul=s(),r(Xe.$$.fragment),fl=s(),Se=o("p"),Se.innerHTML=Bn,jl=s(),r(j.$$.fragment),bl=s(),r(Fe.$$.fragment),Il=s(),r(Qe.$$.fragment),Cl=s(),He=o("p"),He.textContent=xn,vl=s(),r(Le.$$.fragment),Zl=s(),Ye=o("p"),Ye.innerHTML=Rn,Gl=s(),r(qe.$$.fragment),Al=s(),ze=o("p"),ze.textContent=kn,$l=s(),De=o("ul"),De.innerHTML=Wn,Vl=s(),r(b.$$.fragment),Bl=s(),r(Pe.$$.fragment),xl=s(),Oe=o("p"),Oe.textContent=_n,Rl=s(),Ke=o("ul"),Ke.innerHTML=Nn,kl=s(),et=o("p"),et.innerHTML=En,Wl=s(),r(tt.$$.fragment),_l=s(),lt=o("p"),lt.textContent=Xn,Nl=s(),r(nt.$$.fragment),El=s(),st=o("p"),this.h()},l(e){const t=Pn("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),g=a(e),y=i(e,"P",{}),Hn(y).forEach(l),w=a(e),c(I.$$.fragment,e),at=a(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-9afh3f"&&(C.textContent=Ql),ot=a(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-ghxzxz"&&(v.innerHTML=Hl),it=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1tfb3hf"&&(Z.innerHTML=Ll),pt=a(e),c(G.$$.fragment,e),rt=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1o67gfb"&&(A.innerHTML=Yl),ct=a(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1ebrquh"&&($.innerHTML=ql),Mt=a(e),c(V.$$.fragment,e),dt=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1i8n6rq"&&(B.textContent=zl),mt=a(e),c(x.$$.fragment,e),ut=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-15nvzfz"&&(R.textContent=Dl),ht=a(e),c(k.$$.fragment,e),yt=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1nm8o2l"&&(W.textContent=Pl),Tt=a(e),c(_.$$.fragment,e),gt=a(e),c(N.$$.fragment,e),Jt=a(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1ytajks"&&(E.textContent=Ol),wt=a(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-e12o6k"&&(X.innerHTML=Kl),Ut=a(e),c(S.$$.fragment,e),ft=a(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-cxcyab"&&(F.textContent=en),jt=a(e),c(Q.$$.fragment,e),bt=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-d11vo2"&&(H.innerHTML=tn),It=a(e),c(L.$$.fragment,e),Ct=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-sdydm2"&&(Y.innerHTML=ln),vt=a(e),c(q.$$.fragment,e),Zt=a(e),c(z.$$.fragment,e),Gt=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-p7l1hu"&&(D.innerHTML=nn),At=a(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1c2zn5r"&&(P.innerHTML=sn),$t=a(e),c(O.$$.fragment,e),Vt=a(e),c(K.$$.fragment,e),Bt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1mqzlv7"&&(ee.innerHTML=an),xt=a(e),c(te.$$.fragment,e),Rt=a(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1nja5im"&&(le.innerHTML=on),kt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1kl2jg3"&&(ne.innerHTML=pn),Wt=a(e),c(se.$$.fragment,e),_t=a(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-14aynbe"&&(ae.innerHTML=rn),Nt=a(e),c(oe.$$.fragment,e),Et=a(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-nto2bx"&&(ie.textContent=cn),Xt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-zklutt"&&(pe.innerHTML=Mn),St=a(e),re=i(e,"UL",{"data-svelte-h":!0}),p(re)!=="svelte-1fb4x93"&&(re.innerHTML=dn),Ft=a(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1flszm1"&&(ce.innerHTML=mn),Qt=a(e),c(f.$$.fragment,e),Ht=a(e),c(Me.$$.fragment,e),Lt=a(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-wh1hoy"&&(de.innerHTML=un),Yt=a(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1qp0mlv"&&(me.innerHTML=hn),qt=a(e),c(ue.$$.fragment,e),zt=a(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-2nwexf"&&(he.textContent=yn),Dt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1lovlvw"&&(ye.innerHTML=Tn),Pt=a(e),c(Te.$$.fragment,e),Ot=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1oxifpd"&&(ge.innerHTML=gn),Kt=a(e),Je=i(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-it668a"&&(Je.textContent=Jn),el=a(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-njbdvc"&&(we.innerHTML=wn),tl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-v5hhrl"&&(Ue.innerHTML=Un),ll=a(e),fe=i(e,"UL",{"data-svelte-h":!0}),p(fe)!=="svelte-1mv29i5"&&(fe.innerHTML=fn),nl=a(e),je=i(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-9p37qa"&&(je.innerHTML=jn),sl=a(e),c(be.$$.fragment,e),al=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-mraq68"&&(Ie.innerHTML=bn),ol=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-10wybi0"&&(Ce.innerHTML=In),il=a(e),ve=i(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-ffexfv"&&(ve.innerHTML=Cn),pl=a(e),c(Ze.$$.fragment,e),rl=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-166ya0u"&&(Ge.innerHTML=vn),cl=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-17alodq"&&(Ae.innerHTML=Zn),Ml=a(e),c($e.$$.fragment,e),dl=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-rj4r5t"&&(Ve.textContent=Gn),ml=a(e),c(Be.$$.fragment,e),ul=a(e),xe=i(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-nq4b4r"&&(xe.innerHTML=An),hl=a(e),c(Re.$$.fragment,e),yl=a(e),c(ke.$$.fragment,e),Tl=a(e),We=i(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-hnmp6i"&&(We.innerHTML=$n),gl=a(e),c(_e.$$.fragment,e),Jl=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-d9pmg3"&&(Ne.innerHTML=Vn),wl=a(e),c(Ee.$$.fragment,e),Ul=a(e),c(Xe.$$.fragment,e),fl=a(e),Se=i(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-gm5hxo"&&(Se.innerHTML=Bn),jl=a(e),c(j.$$.fragment,e),bl=a(e),c(Fe.$$.fragment,e),Il=a(e),c(Qe.$$.fragment,e),Cl=a(e),He=i(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1ajbcx5"&&(He.textContent=xn),vl=a(e),c(Le.$$.fragment,e),Zl=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-13ph86t"&&(Ye.innerHTML=Rn),Gl=a(e),c(qe.$$.fragment,e),Al=a(e),ze=i(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-l6tvv1"&&(ze.textContent=kn),$l=a(e),De=i(e,"UL",{"data-svelte-h":!0}),p(De)!=="svelte-16ibgml"&&(De.innerHTML=Wn),Vl=a(e),c(b.$$.fragment,e),Bl=a(e),c(Pe.$$.fragment,e),xl=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-sgegyq"&&(Oe.textContent=_n),Rl=a(e),Ke=i(e,"UL",{"data-svelte-h":!0}),p(Ke)!=="svelte-1p833nz"&&(Ke.innerHTML=Nn),kl=a(e),et=i(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1akxsu0"&&(et.innerHTML=En),Wl=a(e),c(tt.$$.fragment,e),_l=a(e),lt=i(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-s495iv"&&(lt.textContent=Xn),Nl=a(e),c(nt.$$.fragment,e),El=a(e),st=i(e,"P",{}),Hn(st).forEach(l),this.h()},h(){Ln(h,"name","hf:doc:metadata"),Ln(h,"content",ss)},m(e,t){On(document.head,h),n(e,g,t),n(e,y,t),n(e,w,t),M(I,e,t),n(e,at,t),n(e,C,t),n(e,ot,t),n(e,v,t),n(e,it,t),n(e,Z,t),n(e,pt,t),M(G,e,t),n(e,rt,t),n(e,A,t),n(e,ct,t),n(e,$,t),n(e,Mt,t),M(V,e,t),n(e,dt,t),n(e,B,t),n(e,mt,t),M(x,e,t),n(e,ut,t),n(e,R,t),n(e,ht,t),M(k,e,t),n(e,yt,t),n(e,W,t),n(e,Tt,t),M(_,e,t),n(e,gt,t),M(N,e,t),n(e,Jt,t),n(e,E,t),n(e,wt,t),n(e,X,t),n(e,Ut,t),M(S,e,t),n(e,ft,t),n(e,F,t),n(e,jt,t),M(Q,e,t),n(e,bt,t),n(e,H,t),n(e,It,t),M(L,e,t),n(e,Ct,t),n(e,Y,t),n(e,vt,t),M(q,e,t),n(e,Zt,t),M(z,e,t),n(e,Gt,t),n(e,D,t),n(e,At,t),n(e,P,t),n(e,$t,t),M(O,e,t),n(e,Vt,t),M(K,e,t),n(e,Bt,t),n(e,ee,t),n(e,xt,t),M(te,e,t),n(e,Rt,t),n(e,le,t),n(e,kt,t),n(e,ne,t),n(e,Wt,t),M(se,e,t),n(e,_t,t),n(e,ae,t),n(e,Nt,t),M(oe,e,t),n(e,Et,t),n(e,ie,t),n(e,Xt,t),n(e,pe,t),n(e,St,t),n(e,re,t),n(e,Ft,t),n(e,ce,t),n(e,Qt,t),M(f,e,t),n(e,Ht,t),M(Me,e,t),n(e,Lt,t),n(e,de,t),n(e,Yt,t),n(e,me,t),n(e,qt,t),M(ue,e,t),n(e,zt,t),n(e,he,t),n(e,Dt,t),n(e,ye,t),n(e,Pt,t),M(Te,e,t),n(e,Ot,t),n(e,ge,t),n(e,Kt,t),n(e,Je,t),n(e,el,t),n(e,we,t),n(e,tl,t),n(e,Ue,t),n(e,ll,t),n(e,fe,t),n(e,nl,t),n(e,je,t),n(e,sl,t),M(be,e,t),n(e,al,t),n(e,Ie,t),n(e,ol,t),n(e,Ce,t),n(e,il,t),n(e,ve,t),n(e,pl,t),M(Ze,e,t),n(e,rl,t),n(e,Ge,t),n(e,cl,t),n(e,Ae,t),n(e,Ml,t),M($e,e,t),n(e,dl,t),n(e,Ve,t),n(e,ml,t),M(Be,e,t),n(e,ul,t),n(e,xe,t),n(e,hl,t),M(Re,e,t),n(e,yl,t),M(ke,e,t),n(e,Tl,t),n(e,We,t),n(e,gl,t),M(_e,e,t),n(e,Jl,t),n(e,Ne,t),n(e,wl,t),M(Ee,e,t),n(e,Ul,t),M(Xe,e,t),n(e,fl,t),n(e,Se,t),n(e,jl,t),M(j,e,t),n(e,bl,t),M(Fe,e,t),n(e,Il,t),M(Qe,e,t),n(e,Cl,t),n(e,He,t),n(e,vl,t),M(Le,e,t),n(e,Zl,t),n(e,Ye,t),n(e,Gl,t),M(qe,e,t),n(e,Al,t),n(e,ze,t),n(e,$l,t),n(e,De,t),n(e,Vl,t),M(b,e,t),n(e,Bl,t),M(Pe,e,t),n(e,xl,t),n(e,Oe,t),n(e,Rl,t),n(e,Ke,t),n(e,kl,t),n(e,et,t),n(e,Wl,t),M(tt,e,t),n(e,_l,t),n(e,lt,t),n(e,Nl,t),M(nt,e,t),n(e,El,t),n(e,st,t),Xl=!0},p(e,[t]){const Sn={};t&2&&(Sn.$$scope={dirty:t,ctx:e}),f.$set(Sn);const Fn={};t&2&&(Fn.$$scope={dirty:t,ctx:e}),j.$set(Fn);const Qn={};t&2&&(Qn.$$scope={dirty:t,ctx:e}),b.$set(Qn)},i(e){Xl||(d(I.$$.fragment,e),d(G.$$.fragment,e),d(V.$$.fragment,e),d(x.$$.fragment,e),d(k.$$.fragment,e),d(_.$$.fragment,e),d(N.$$.fragment,e),d(S.$$.fragment,e),d(Q.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(z.$$.fragment,e),d(O.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(oe.$$.fragment,e),d(f.$$.fragment,e),d(Me.$$.fragment,e),d(ue.$$.fragment,e),d(Te.$$.fragment,e),d(be.$$.fragment,e),d(Ze.$$.fragment,e),d($e.$$.fragment,e),d(Be.$$.fragment,e),d(Re.$$.fragment,e),d(ke.$$.fragment,e),d(_e.$$.fragment,e),d(Ee.$$.fragment,e),d(Xe.$$.fragment,e),d(j.$$.fragment,e),d(Fe.$$.fragment,e),d(Qe.$$.fragment,e),d(Le.$$.fragment,e),d(qe.$$.fragment,e),d(b.$$.fragment,e),d(Pe.$$.fragment,e),d(tt.$$.fragment,e),d(nt.$$.fragment,e),Xl=!0)},o(e){m(I.$$.fragment,e),m(G.$$.fragment,e),m(V.$$.fragment,e),m(x.$$.fragment,e),m(k.$$.fragment,e),m(_.$$.fragment,e),m(N.$$.fragment,e),m(S.$$.fragment,e),m(Q.$$.fragment,e),m(L.$$.fragment,e),m(q.$$.fragment,e),m(z.$$.fragment,e),m(O.$$.fragment,e),m(K.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(oe.$$.fragment,e),m(f.$$.fragment,e),m(Me.$$.fragment,e),m(ue.$$.fragment,e),m(Te.$$.fragment,e),m(be.$$.fragment,e),m(Ze.$$.fragment,e),m($e.$$.fragment,e),m(Be.$$.fragment,e),m(Re.$$.fragment,e),m(ke.$$.fragment,e),m(_e.$$.fragment,e),m(Ee.$$.fragment,e),m(Xe.$$.fragment,e),m(j.$$.fragment,e),m(Fe.$$.fragment,e),m(Qe.$$.fragment,e),m(Le.$$.fragment,e),m(qe.$$.fragment,e),m(b.$$.fragment,e),m(Pe.$$.fragment,e),m(tt.$$.fragment,e),m(nt.$$.fragment,e),Xl=!1},d(e){e&&(l(g),l(y),l(w),l(at),l(C),l(ot),l(v),l(it),l(Z),l(pt),l(rt),l(A),l(ct),l($),l(Mt),l(dt),l(B),l(mt),l(ut),l(R),l(ht),l(yt),l(W),l(Tt),l(gt),l(Jt),l(E),l(wt),l(X),l(Ut),l(ft),l(F),l(jt),l(bt),l(H),l(It),l(Ct),l(Y),l(vt),l(Zt),l(Gt),l(D),l(At),l(P),l($t),l(Vt),l(Bt),l(ee),l(xt),l(Rt),l(le),l(kt),l(ne),l(Wt),l(_t),l(ae),l(Nt),l(Et),l(ie),l(Xt),l(pe),l(St),l(re),l(Ft),l(ce),l(Qt),l(Ht),l(Lt),l(de),l(Yt),l(me),l(qt),l(zt),l(he),l(Dt),l(ye),l(Pt),l(Ot),l(ge),l(Kt),l(Je),l(el),l(we),l(tl),l(Ue),l(ll),l(fe),l(nl),l(je),l(sl),l(al),l(Ie),l(ol),l(Ce),l(il),l(ve),l(pl),l(rl),l(Ge),l(cl),l(Ae),l(Ml),l(dl),l(Ve),l(ml),l(ul),l(xe),l(hl),l(yl),l(Tl),l(We),l(gl),l(Jl),l(Ne),l(wl),l(Ul),l(fl),l(Se),l(jl),l(bl),l(Il),l(Cl),l(He),l(vl),l(Zl),l(Ye),l(Gl),l(Al),l(ze),l($l),l(De),l(Vl),l(Bl),l(xl),l(Oe),l(Rl),l(Ke),l(kl),l(et),l(Wl),l(_l),l(lt),l(Nl),l(El),l(st)),l(h),u(I,e),u(G,e),u(V,e),u(x,e),u(k,e),u(_,e),u(N,e),u(S,e),u(Q,e),u(L,e),u(q,e),u(z,e),u(O,e),u(K,e),u(te,e),u(se,e),u(oe,e),u(f,e),u(Me,e),u(ue,e),u(Te,e),u(be,e),u(Ze,e),u($e,e),u(Be,e),u(Re,e),u(ke,e),u(_e,e),u(Ee,e),u(Xe,e),u(j,e),u(Fe,e),u(Qe,e),u(Le,e),u(qe,e),u(b,e),u(Pe,e),u(tt,e),u(nt,e)}}}const ss='{"title":"Deploy Gemma 7B with TGI DLC from GCS on Vertex AI","local":"deploy-gemma-7b-with-tgi-dlc-from-gcs-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Optional: Create bucket and upload model from Hub in GCS","local":"optional-create-bucket-and-upload-model-from-hub-in-gcs","sections":[{"title":"Artifact from disk / local storage","local":"artifact-from-disk--local-storage","sections":[],"depth":3},{"title":"Artifact from Hugging Face Hub","local":"artifact-from-hugging-face-hub","sections":[],"depth":3}],"depth":2},{"title":"Register model on Vertex AI","local":"register-model-on-vertex-ai","sections":[],"depth":2},{"title":"Deploy model on Vertex AI","local":"deploy-model-on-vertex-ai","sections":[],"depth":2},{"title":"Online predictions on Vertex AI","local":"online-predictions-on-vertex-ai","sections":[{"title":"Via Python","local":"via-python","sections":[{"title":"Within the same session","local":"within-the-same-session","sections":[],"depth":4},{"title":"From a different session","local":"from-a-different-session","sections":[],"depth":4}],"depth":3},{"title":"Via the Vertex AI Online Prediction UI","local":"via-the-vertex-ai-online-prediction-ui","sections":[],"depth":3}],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2}],"depth":1}';function as(U){return qn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ms extends zn{constructor(h){super(),Dn(this,h,as,ns,Yn,{})}}export{Ms as component};
