import{s as G1,n as X1,o as Z1}from"../chunks/scheduler.0219f8bd.js";import{S as e_,i as t_,g as r,s as o,r as u,A as l_,h as i,f as l,c as n,j as h,u as m,x as d,k as a,y as s_,a as s,v as p,d as c,t as T,w as f}from"../chunks/index.f61edf3b.js";import{C as zn}from"../chunks/CodeBlock.38e566ae.js";import{H as _,E as o_}from"../chunks/EditOnGithub.48fa589f.js";function n_(xT){let $,kn,Un,jn,b,Jn,v,En,y,CT="Helper module for <code>Tensor</code> processing.",Dn,M,HT=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,In,x,LT='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clone"><code>.clone()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+slice"><code>.slice(...slices)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li> <li><a href="#module_utils/tensor.permute"><code>.permute(tensor, axes)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.interpolate_4d"><code>.interpolate_4d(input, options)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.matmul"><code>.matmul(a, b)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.rfft"><code>.rfft(x, a)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.topk"><code>.topk(x, k)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <a href="#Tensor"><code>Array.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.full"><code>.full(size, fill_value)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.zeros"><code>.zeros(size)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.zeros_like"><code>.zeros_like(tensor)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.quantize_embeddings"><code>.quantize_embeddings(tensor, precision)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>ONNXTensor</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',qn,Kn,Bn,C,Nn,H,Qn,L,wT='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Vn,w,AT='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clone"><code>.clone()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+slice"><code>.slice(...slices)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li>',Sn,On,Fn,A,Yn,g,Wn,P,gT="Create a new Tensor or copy an existing Tensor.",Gn,z,PT="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",Xn,Zn,er,U,tr,R,lr,k,zT="Dimensions of the tensor.",sr,j,UT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',or,nr,rr,J,ir,E,dr,D,RT="Type of the tensor.",ar,I,kT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ur,mr,pr,q,cr,K,Tr,B,jT="The data stored in the tensor.",fr,N,JT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',hr,_r,$r,Q,br,V,vr,S,ET="The number of elements in the tensor.",yr,O,DT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Mr,xr,Cr,F,Hr,Y,Lr,W,IT="The location of the tensor data.",wr,G,qT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ar,gr,Pr,X,zr,Z,Ur,ee,KT=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,Rr,te,BT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',kr,jr,Jr,le,Er,se,Dr,oe,NT="Index into a Tensor object.",Ir,ne,QT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The data at the specified index.',qr,re,VT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",Kr,Br,Nr,ie,Qr,de,Vr,ae,ST='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',Sr,ue,OT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",Or,Fr,Yr,me,Wr,pe,Gr,ce,FT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Xr,Te,YT="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",Zr,ei,ti,fe,li,he,si,_e,WT=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,oi,$e,GT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',ni,be,XT="<li><code>Error</code> If the tensor has more than one element.</li>",ri,ii,di,ve,ai,ye,ui,Me,ZT="Convert tensor data to a n-dimensional JS list",mi,xe,ef='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',pi,ci,Ti,Ce,fi,He,hi,Le,tf="Return a new Tensor with the sigmoid function applied to each element.",_i,we,lf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The tensor with the sigmoid function applied.',$i,bi,vi,Ae,yi,ge,Mi,Pe,sf="Applies the sigmoid function to the tensor in place.",xi,ze,of='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Ci,Hi,Li,Ue,wi,Re,Ai,ke,nf="Return a new Tensor with a callback function applied to each element.",gi,je,rf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor with the callback function applied to each element.',Pi,Je,df=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,zi,Ui,Ri,Ee,ki,De,ji,Ie,af="Apply a callback function to each element of the tensor in place.",Ji,qe,uf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Ei,Ke,mf=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,Di,Ii,qi,Be,Ki,Ne,Bi,Qe,pf="Return a new Tensor with every element multiplied by a constant.",Ni,Ve,cf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',Qi,Se,Tf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Vi,Si,Oi,Oe,Fi,Fe,Yi,Ye,ff="Multiply the tensor by a constant in place.",Wi,We,hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Gi,Ge,_f="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Xi,Zi,ed,Xe,td,Ze,ld,et,$f="Return a new Tensor with every element divided by a constant.",sd,tt,bf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',od,lt,vf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",nd,rd,id,st,dd,ot,ad,nt,yf="Divide the tensor by a constant in place.",ud,rt,Mf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',md,it,xf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",pd,cd,Td,dt,fd,at,hd,ut,Cf="Return a new Tensor with every element added by a constant.",_d,mt,Hf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',$d,pt,Lf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",bd,vd,yd,ct,Md,Tt,xd,ft,wf="Add the tensor by a constant in place.",Cd,ht,Af='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Hd,_t,gf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Ld,wd,Ad,$t,gd,bt,Pd,vt,Pf="Return a new Tensor with every element subtracted by a constant.",zd,yt,zf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',Ud,Mt,Uf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",Rd,kd,jd,xt,Jd,Ct,Ed,Ht,Rf="Subtract the tensor by a constant in place.",Dd,Lt,kf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Id,wt,jf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",qd,Kd,Bd,At,Nd,gt,Qd,Pt,Jf="Creates a deep copy of the current Tensor.",Vd,zt,Ef='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor with the same type, data, and dimensions as the original.',Sd,Od,Fd,Ut,Yd,Rt,Wd,kt,Df="Performs a slice operation on the Tensor along specified dimensions.",Gd,jt,If="Consider a Tensor that has a dimension of [4, 7]:",Xd,Jt,Zd,Et,qf=`We can slice against the two dims of row and column, for instance in this
case we can start at the second element, and return to the second last,
like this:`,ea,Dt,ta,It,Kf="which would return:",la,qt,sa,Kt,Bf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor containing the selected elements.<br/> <strong>Throws</strong>:',oa,Bt,Nf="<li><code>Error</code> If the slice input is invalid.</li>",na,Nt,Qf="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...slices</td><td><code>number</code> | <code>Array&lt;number&gt;</code> | <code>null</code></td><td><p>The slice specifications for each dimension.</p> <ul><li>If a number is given, then a single element is selected.</li> <li>If an array of two numbers is given, then a range of elements [start, end (exclusive)] is selected.</li> <li>If null is given, then the entire dimension is selected.</li></ul></td></tr></tbody>",ra,ia,da,Qt,aa,Vt,ua,St,Vf="Return a permuted version of this Tensor, according to the provided dimensions.",ma,Ot,Sf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The permuted tensor.',pa,Ft,Of="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to permute.</p></td></tr></tbody>",ca,Ta,fa,Yt,ha,Wt,_a,Gt,Ff="Returns the sum of each row of the input tensor in the given dimension dim.",$a,Xt,Yf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',ba,Zt,Wf="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",va,ya,Ma,el,xa,tl,Ca,ll,Gf="Returns the matrix norm or vector norm of a given tensor.",Ha,sl,Xf='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The norm of the tensor.',La,ol,Zf=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,wa,Aa,ga,nl,Pa,rl,za,il,eh="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",Ua,dl,th='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - <code>this</code> for operation chaining.',Ra,al,lh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",ka,ja,Ja,ul,Ea,ml,Da,pl,sh="Performs <code>L_p</code> normalization of inputs over specified dimension.",Ia,cl,oh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The normalized tensor.',qa,Tl,nh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Ka,Ba,Na,fl,Qa,hl,Va,_l,rh=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,Sa,$l,ih='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',Oa,Fa,Ya,bl,Wa,vl,Ga,yl,dh="Returns a tensor with all specified dimensions of input of size 1 removed.",Xa,Ml,ah=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,Za,xl,uh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The squeezed tensor',eu,Cl,mh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",tu,lu,su,Hl,ou,Ll,nu,wl,ph='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',ru,Al,ch='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',iu,du,au,gl,uu,Pl,mu,zl,Th="Returns a new tensor with a dimension of size one inserted at the specified position.",pu,Ul,fh="NOTE: The returned tensor shares the same underlying data with this tensor.",cu,Rl,hh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The unsqueezed tensor',Tu,kl,_h="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",fu,hu,_u,jl,$u,Jl,bu,El,$h='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',vu,Dl,bh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',yu,Mu,xu,Il,Cu,ql,Hu,Kl,vh='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Lu,Bl,yh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',wu,Au,gu,Nl,Pu,Ql,zu,Vl,Mh=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,Uu,Sl,xh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The flattened tensor.',Ru,Ol,Ch="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",ku,ju,Ju,Fl,Eu,Yl,Du,Wl,Hh="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",Iu,Gl,Lh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The tensor with the same data but different shape',qu,Xl,wh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",Ku,Bu,Nu,Zl,Qu,es,Vu,ts,Ah='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',Su,ls,gh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ou,Fu,Yu,ss,Wu,os,Gu,ns,Ph="Clamps all elements in input into the range [ min, max ]",Xu,rs,zh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - the output tensor.',Zu,is,Uh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",em,tm,lm,ds,sm,as,om,us,Rh='In-place version of @see <a href="Tensor.round">Tensor.round</a>',nm,ms,kh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',rm,im,dm,ps,am,cs,um,Ts,jh="Rounds elements of input to the nearest integer.",mm,fs,Jh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - the output tensor.',pm,cm,Tm,hs,fm,_s,hm,$s,Eh="Performs Tensor dtype conversion.",_m,bs,Dh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The converted tensor.',$m,vs,Ih='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code><a href="#DataType">DataType</a></code></td><td><p>The desired data type.</p></td></tr></tbody>',bm,vm,ym,ys,Mm,Ms,xm,xs,qh="Permutes a tensor according to the provided axes.",Cm,Cs,Kh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The permuted tensor.',Hm,Hs,Bh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to permute.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to permute the tensor along.</p></td></tr></tbody>",Lm,wm,Am,Ls,gm,ws,Pm,As,Nh="Interpolates an Tensor to the given size.",zm,gs,Qh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The interpolated tensor.',Um,Ps,Vh='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>',Rm,km,jm,zs,Jm,Us,Em,Rs,Sh=`Down/up samples the input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html</a>.`,Dm,ks,Oh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - The interpolated tensor.',Im,js,Fh='<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td></td><td><p>the input tensor</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>the options for the interpolation</p></td> </tr><tr><td>[options.size]</td><td><code>*</code></td><td><code></code></td><td><p>output spatial size.</p></td> </tr><tr><td>[options.mode]</td><td><code>&quot;bilinear&quot;</code> | <code>&quot;bicubic&quot;</code></td><td><code>&#39;bilinear&#39;</code></td><td><p>algorithm used for upsampling</p></td></tr></tbody>',qm,Km,Bm,Js,Nm,Es,Qm,Ds,Yh=`Matrix product of two tensors.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.matmul.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.matmul.html</a>`,Vm,Is,Wh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - The matrix product of the two tensors.',Sm,qs,Gh='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>a</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the first tensor to be multiplied</p></td> </tr><tr><td>b</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the second tensor to be multiplied</p></td></tr></tbody>',Om,Fm,Ym,Ks,Wm,Bs,Gm,Ns,Xh=`Computes the one dimensional Fourier transform of real-valued input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.fft.rfft.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.fft.rfft.html</a>`,Xm,Qs,Zh='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - the output tensor.',Zm,Vs,e1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the real input tensor</p></td> </tr><tr><td>a</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The dimension along which to take the one dimensional real FFT.</p></td></tr></tbody>',ep,tp,lp,Ss,sp,Os,op,Fs,t1=`Returns the k largest elements of the given input tensor.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.topk.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.topk.html</a>`,np,Ys,l1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - the output tuple of (Tensor, LongTensor) of top-k elements and their indices.',rp,Ws,s1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tensor</p></td> </tr><tr><td>k</td><td><code>number</code></td><td><p>the k in &quot;top-k&quot;</p></td></tr></tbody>',ip,dp,ap,Gs,up,Xs,mp,Zs,o1="Perform mean pooling of the last hidden state followed by a normalization step.",pp,eo,n1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns a new Tensor of shape [batchSize, embedDim].',cp,to,r1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>',Tp,fp,hp,lo,_p,so,$p,oo,i1="Apply Layer Normalization for last certain number of dimensions.",bp,no,d1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The normalized tensor.',vp,ro,a1='<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>',yp,Mp,xp,io,Cp,ao,Hp,uo,u1="Concatenates an array of tensors along a specified dimension.",Lp,mo,m1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The concatenated tensor.',wp,po,p1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code><a href="#Tensor">Array.&lt;Tensor&gt;</a></code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>',Ap,gp,Pp,co,zp,To,Up,fo,c1="Stack an array of tensors along a specified dimension.",Rp,ho,T1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The stacked tensor.',kp,_o,f1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code><a href="#Tensor">Array.&lt;Tensor&gt;</a></code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>',jp,Jp,Ep,$o,Dp,bo,Ip,vo,h1="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",qp,yo,_1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Array.&lt;Tensor&gt;</code></a> - A tuple of (std, mean) tensors.',Kp,Mo,$1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>',Bp,Np,Qp,xo,Vp,Co,Sp,Ho,b1="Returns the mean value of each row of the input tensor in the given dimension dim.",Op,Lo,v1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new tensor with means taken along the specified dimension.',Fp,wo,y1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>',Yp,Wp,Gp,Ao,Xp,go,Zp,Po,M1="Creates a tensor of size size filled with fill_value. The tensor’s dtype is inferred from fill_value.",ec,zo,x1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The filled tensor.',tc,Uo,C1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td> </tr><tr><td>fill_value</td><td><code>number</code> | <code>bigint</code> | <code>boolean</code></td><td><p>The value to fill the output tensor with.</p></td></tr></tbody>",lc,sc,oc,Ro,nc,ko,rc,jo,H1="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",ic,Jo,L1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The ones tensor.',dc,Eo,w1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",ac,uc,mc,Do,pc,Io,cc,qo,A1="Returns a tensor filled with the scalar value 1, with the same size as input.",Tc,Ko,g1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The ones tensor.',fc,Bo,P1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>',hc,_c,$c,No,bc,Qo,vc,Vo,z1="Returns a tensor filled with the scalar value 0, with the shape defined by the variable argument size.",yc,So,U1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The zeros tensor.',Mc,Oo,R1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",xc,Cc,Hc,Fo,Lc,Yo,wc,Wo,k1="Returns a tensor filled with the scalar value 0, with the same size as input.",Ac,Go,j1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The zeros tensor.',gc,Xo,J1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>',Pc,zc,Uc,Zo,Rc,en,kc,tn,E1="Quantizes the embeddings tensor to binary or unsigned binary precision.",jc,ln,D1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The quantized tensor.',Jc,sn,I1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The tensor to quantize.</p></td> </tr><tr><td>precision</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>',Ec,Dc,Ic,on,qc,nn,Kc,rn,q1='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Bc,Nc,Qc,dn,Vc,an,Sc,un,K1="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",Oc,mn,B1='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',Fc,pn,N1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",Yc,cn,Q1="<strong>Example</strong>",Wc,Tn,Gc,Xc,Zc,fn,eT,hn,tT,_n,V1='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',lT,sT,oT,$n,nT,bn,rT,vn,S1='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',iT,dT,aT,yn,uT,Mn,mT,xn,O1="This creates a nested array of a given type and depth (see examples).",pT,Cn,F1='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',cT,Hn,TT,Ln,Y1="<strong>Example</strong>",fT,wn,hT,An,W1="<strong>Example</strong>",_T,gn,$T,bT,vT,Pn,yT,Rn,MT;return v=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),g=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),R=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),E=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),V=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),Y=new _({props:{title:"tensor.location : <code> string </code>",local:"tensorlocation--code-string-code",headingTag:"h3"}}),Z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),se=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),de=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),he=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),ye=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ge=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),Re=new _({props:{title:"tensor.map(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.map_(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),Ne=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ze=new _({props:{title:"tensor.div(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),ot=new _({props:{title:"tensor.div_(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),at=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Tt=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),bt=new _({props:{title:"tensor.sub(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.sub_(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),gt=new _({props:{title:"tensor.clone() ⇒ <code> Tensor </code>",local:"tensorclone--code-tensor-code",headingTag:"h3"}}),Rt=new _({props:{title:"tensor.slice(...slices) ⇒ <code> Tensor </code>",local:"tensorsliceslices--code-tensor-code",headingTag:"h3"}}),Jt=new zn({props:{code:"JTVCJTIwMSUyQyUyMCUyMDIlMkMlMjAlMjAzJTJDJTIwJTIwNCUyQyUyMCUyMDUlMkMlMjAlMjA2JTJDJTIwJTIwNyU1RCUwQSU1QiUyMDglMkMlMjAlMjA5JTJDJTIwMTAlMkMlMjAxMSUyQyUyMDEyJTJDJTIwMTMlMkMlMjAxNCU1RCUwQSU1QjE1JTJDJTIwMTYlMkMlMjAxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyQyUyMDIxJTVEJTBBJTVCMjIlMkMlMjAyMyUyQyUyMDI0JTJDJTIwMjUlMkMlMjAyNiUyQyUyMDI3JTJDJTIwMjglNUQ=",highlighted:`<span class="hljs-string">[ 1,  2,  3,  4,  5,  6,  7]</span>
<span class="hljs-string">[ 8,  9, 10, 11, 12, 13, 14]</span>
<span class="hljs-string">[15, 16, 17, 18, 19, 20, 21]</span>
<span class="hljs-string">[22, 23, 24, 25, 26, 27, 28]</span>`,wrap:!1}}),Dt=new zn({props:{code:"dGVuc29yLnNsaWNlKCU1QjElMkMlMjAtMSU1RCUyQyUyMCU1QjElMkMlMjAtMSU1RCklM0I=",highlighted:'<span class="hljs-attribute">tensor</span>.slice([<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>],<span class="hljs-meta"> [1, -1]);</span>',wrap:!1}}),qt=new zn({props:{code:"JTVCJTIwJTIwOSUyQyUyMDEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTIwJTVEJTBBJTVCJTIwMTYlMkMlMjAxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyMCU1RA==",highlighted:`<span class="hljs-string">[  9, 10, 11, 12, 13 ]</span>
<span class="hljs-string">[ 16, 17, 18, 19, 20 ]</span>`,wrap:!1}}),Vt=new _({props:{title:"tensor.permute(...dims) ⇒ <code> Tensor </code>",local:"tensorpermutedims--code-tensor-code",headingTag:"h3"}}),Wt=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),tl=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),rl=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),ml=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),hl=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),vl=new _({props:{title:"tensor.squeeze([dim]) ⇒ <code> Tensor </code>",local:"tensorsqueezedim--code-tensor-code",headingTag:"h3"}}),Ll=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),Pl=new _({props:{title:"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>",local:"tensorunsqueezedim--code-tensor-code",headingTag:"h3"}}),Jl=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),ql=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Ql=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>",local:"tensorflattenstartdim-enddim--code-tensor-code",headingTag:"h3"}}),Yl=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),es=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),os=new _({props:{title:"tensor.clamp(min, max) ⇒ <code> Tensor </code>",local:"tensorclampmin-max--code-tensor-code",headingTag:"h3"}}),as=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),cs=new _({props:{title:"tensor.round() ⇒ <code> Tensor </code>",local:"tensorround--code-tensor-code",headingTag:"h3"}}),_s=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Ms=new _({props:{title:"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensorpermutetensor-axes--code-tensor-code",headingTag:"h2"}}),ws=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),Us=new _({props:{title:"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorinterpolate4dinput-options--code-promise--tensor--code",headingTag:"h2"}}),Es=new _({props:{title:"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensormatmula-b--code-promise--tensor--code",headingTag:"h2"}}),Bs=new _({props:{title:"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorrfftx-a--code-promise--tensor--code",headingTag:"h2"}}),Os=new _({props:{title:"utils/tensor.topk(x, k) ⇒ <code> * </code>",local:"utilstensortopkx-k--code--code",headingTag:"h2"}}),Xs=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),so=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),ao=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),To=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),bo=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),Co=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>",local:"utilstensormeaninput-dim-keepdim--code-tensor-code",headingTag:"h2"}}),go=new _({props:{title:"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>",local:"utilstensorfullsize-fillvalue--code-tensor-code",headingTag:"h2"}}),ko=new _({props:{title:"utils/tensor.ones(size) ⇒ <code> Tensor </code>",local:"utilstensoronessize--code-tensor-code",headingTag:"h2"}}),Io=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensoronesliketensor--code-tensor-code",headingTag:"h2"}}),Qo=new _({props:{title:"utils/tensor.zeros(size) ⇒ <code> Tensor </code>",local:"utilstensorzerossize--code-tensor-code",headingTag:"h2"}}),Yo=new _({props:{title:"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensorzerosliketensor--code-tensor-code",headingTag:"h2"}}),en=new _({props:{title:"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>",local:"utilstensorquantizeembeddingstensor-precision--code-tensor-code",headingTag:"h2"}}),nn=new _({props:{title:"utils/tensor~args[0] : <code> ONNXTensor </code>",local:"utilstensorargs0--code-onnxtensor-code",headingTag:"h2"}}),an=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Tn=new zn({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),hn=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),bn=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Mn=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),Hn=new zn({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),wn=new zn({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),gn=new zn({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),Pn=new o_({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/tensor.md"}}),{c(){$=r("meta"),kn=o(),Un=r("p"),jn=o(),b=r("a"),Jn=o(),u(v.$$.fragment),En=o(),y=r("p"),y.innerHTML=CT,Dn=o(),M=r("p"),M.textContent=HT,In=o(),x=r("ul"),x.innerHTML=LT,qn=o(),Kn=r("hr"),Bn=o(),C=r("a"),Nn=o(),u(H.$$.fragment),Qn=o(),L=r("p"),L.innerHTML=wT,Vn=o(),w=r("ul"),w.innerHTML=AT,Sn=o(),On=r("hr"),Fn=o(),A=r("a"),Yn=o(),u(g.$$.fragment),Wn=o(),P=r("p"),P.textContent=gT,Gn=o(),z=r("table"),z.innerHTML=PT,Xn=o(),Zn=r("hr"),er=o(),U=r("a"),tr=o(),u(R.$$.fragment),lr=o(),k=r("p"),k.textContent=zT,sr=o(),j=r("p"),j.innerHTML=UT,or=o(),nr=r("hr"),rr=o(),J=r("a"),ir=o(),u(E.$$.fragment),dr=o(),D=r("p"),D.textContent=RT,ar=o(),I=r("p"),I.innerHTML=kT,ur=o(),mr=r("hr"),pr=o(),q=r("a"),cr=o(),u(K.$$.fragment),Tr=o(),B=r("p"),B.textContent=jT,fr=o(),N=r("p"),N.innerHTML=JT,hr=o(),_r=r("hr"),$r=o(),Q=r("a"),br=o(),u(V.$$.fragment),vr=o(),S=r("p"),S.textContent=ET,yr=o(),O=r("p"),O.innerHTML=DT,Mr=o(),xr=r("hr"),Cr=o(),F=r("a"),Hr=o(),u(Y.$$.fragment),Lr=o(),W=r("p"),W.textContent=IT,wr=o(),G=r("p"),G.innerHTML=qT,Ar=o(),gr=r("hr"),Pr=o(),X=r("a"),zr=o(),u(Z.$$.fragment),Ur=o(),ee=r("p"),ee.textContent=KT,Rr=o(),te=r("p"),te.innerHTML=BT,kr=o(),jr=r("hr"),Jr=o(),le=r("a"),Er=o(),u(se.$$.fragment),Dr=o(),oe=r("p"),oe.textContent=NT,Ir=o(),ne=r("p"),ne.innerHTML=QT,qr=o(),re=r("table"),re.innerHTML=VT,Kr=o(),Br=r("hr"),Nr=o(),ie=r("a"),Qr=o(),u(de.$$.fragment),Vr=o(),ae=r("p"),ae.innerHTML=ST,Sr=o(),ue=r("table"),ue.innerHTML=OT,Or=o(),Fr=r("hr"),Yr=o(),me=r("a"),Wr=o(),u(pe.$$.fragment),Gr=o(),ce=r("p"),ce.innerHTML=FT,Xr=o(),Te=r("table"),Te.innerHTML=YT,Zr=o(),ei=r("hr"),ti=o(),fe=r("a"),li=o(),u(he.$$.fragment),si=o(),_e=r("p"),_e.innerHTML=WT,oi=o(),$e=r("p"),$e.innerHTML=GT,ni=o(),be=r("ul"),be.innerHTML=XT,ri=o(),ii=r("hr"),di=o(),ve=r("a"),ai=o(),u(ye.$$.fragment),ui=o(),Me=r("p"),Me.textContent=ZT,mi=o(),xe=r("p"),xe.innerHTML=ef,pi=o(),ci=r("hr"),Ti=o(),Ce=r("a"),fi=o(),u(He.$$.fragment),hi=o(),Le=r("p"),Le.textContent=tf,_i=o(),we=r("p"),we.innerHTML=lf,$i=o(),bi=r("hr"),vi=o(),Ae=r("a"),yi=o(),u(ge.$$.fragment),Mi=o(),Pe=r("p"),Pe.textContent=sf,xi=o(),ze=r("p"),ze.innerHTML=of,Ci=o(),Hi=r("hr"),Li=o(),Ue=r("a"),wi=o(),u(Re.$$.fragment),Ai=o(),ke=r("p"),ke.textContent=nf,gi=o(),je=r("p"),je.innerHTML=rf,Pi=o(),Je=r("table"),Je.innerHTML=df,zi=o(),Ui=r("hr"),Ri=o(),Ee=r("a"),ki=o(),u(De.$$.fragment),ji=o(),Ie=r("p"),Ie.textContent=af,Ji=o(),qe=r("p"),qe.innerHTML=uf,Ei=o(),Ke=r("table"),Ke.innerHTML=mf,Di=o(),Ii=r("hr"),qi=o(),Be=r("a"),Ki=o(),u(Ne.$$.fragment),Bi=o(),Qe=r("p"),Qe.textContent=pf,Ni=o(),Ve=r("p"),Ve.innerHTML=cf,Qi=o(),Se=r("table"),Se.innerHTML=Tf,Vi=o(),Si=r("hr"),Oi=o(),Oe=r("a"),Fi=o(),u(Fe.$$.fragment),Yi=o(),Ye=r("p"),Ye.textContent=ff,Wi=o(),We=r("p"),We.innerHTML=hf,Gi=o(),Ge=r("table"),Ge.innerHTML=_f,Xi=o(),Zi=r("hr"),ed=o(),Xe=r("a"),td=o(),u(Ze.$$.fragment),ld=o(),et=r("p"),et.textContent=$f,sd=o(),tt=r("p"),tt.innerHTML=bf,od=o(),lt=r("table"),lt.innerHTML=vf,nd=o(),rd=r("hr"),id=o(),st=r("a"),dd=o(),u(ot.$$.fragment),ad=o(),nt=r("p"),nt.textContent=yf,ud=o(),rt=r("p"),rt.innerHTML=Mf,md=o(),it=r("table"),it.innerHTML=xf,pd=o(),cd=r("hr"),Td=o(),dt=r("a"),fd=o(),u(at.$$.fragment),hd=o(),ut=r("p"),ut.textContent=Cf,_d=o(),mt=r("p"),mt.innerHTML=Hf,$d=o(),pt=r("table"),pt.innerHTML=Lf,bd=o(),vd=r("hr"),yd=o(),ct=r("a"),Md=o(),u(Tt.$$.fragment),xd=o(),ft=r("p"),ft.textContent=wf,Cd=o(),ht=r("p"),ht.innerHTML=Af,Hd=o(),_t=r("table"),_t.innerHTML=gf,Ld=o(),wd=r("hr"),Ad=o(),$t=r("a"),gd=o(),u(bt.$$.fragment),Pd=o(),vt=r("p"),vt.textContent=Pf,zd=o(),yt=r("p"),yt.innerHTML=zf,Ud=o(),Mt=r("table"),Mt.innerHTML=Uf,Rd=o(),kd=r("hr"),jd=o(),xt=r("a"),Jd=o(),u(Ct.$$.fragment),Ed=o(),Ht=r("p"),Ht.textContent=Rf,Dd=o(),Lt=r("p"),Lt.innerHTML=kf,Id=o(),wt=r("table"),wt.innerHTML=jf,qd=o(),Kd=r("hr"),Bd=o(),At=r("a"),Nd=o(),u(gt.$$.fragment),Qd=o(),Pt=r("p"),Pt.textContent=Jf,Vd=o(),zt=r("p"),zt.innerHTML=Ef,Sd=o(),Od=r("hr"),Fd=o(),Ut=r("a"),Yd=o(),u(Rt.$$.fragment),Wd=o(),kt=r("p"),kt.textContent=Df,Gd=o(),jt=r("p"),jt.textContent=If,Xd=o(),u(Jt.$$.fragment),Zd=o(),Et=r("p"),Et.textContent=qf,ea=o(),u(Dt.$$.fragment),ta=o(),It=r("p"),It.textContent=Kf,la=o(),u(qt.$$.fragment),sa=o(),Kt=r("p"),Kt.innerHTML=Bf,oa=o(),Bt=r("ul"),Bt.innerHTML=Nf,na=o(),Nt=r("table"),Nt.innerHTML=Qf,ra=o(),ia=r("hr"),da=o(),Qt=r("a"),aa=o(),u(Vt.$$.fragment),ua=o(),St=r("p"),St.textContent=Vf,ma=o(),Ot=r("p"),Ot.innerHTML=Sf,pa=o(),Ft=r("table"),Ft.innerHTML=Of,ca=o(),Ta=r("hr"),fa=o(),Yt=r("a"),ha=o(),u(Wt.$$.fragment),_a=o(),Gt=r("p"),Gt.textContent=Ff,$a=o(),Xt=r("p"),Xt.innerHTML=Yf,ba=o(),Zt=r("table"),Zt.innerHTML=Wf,va=o(),ya=r("hr"),Ma=o(),el=r("a"),xa=o(),u(tl.$$.fragment),Ca=o(),ll=r("p"),ll.textContent=Gf,Ha=o(),sl=r("p"),sl.innerHTML=Xf,La=o(),ol=r("table"),ol.innerHTML=Zf,wa=o(),Aa=r("hr"),ga=o(),nl=r("a"),Pa=o(),u(rl.$$.fragment),za=o(),il=r("p"),il.innerHTML=eh,Ua=o(),dl=r("p"),dl.innerHTML=th,Ra=o(),al=r("table"),al.innerHTML=lh,ka=o(),ja=r("hr"),Ja=o(),ul=r("a"),Ea=o(),u(ml.$$.fragment),Da=o(),pl=r("p"),pl.innerHTML=sh,Ia=o(),cl=r("p"),cl.innerHTML=oh,qa=o(),Tl=r("table"),Tl.innerHTML=nh,Ka=o(),Ba=r("hr"),Na=o(),fl=r("a"),Qa=o(),u(hl.$$.fragment),Va=o(),_l=r("p"),_l.textContent=rh,Sa=o(),$l=r("p"),$l.innerHTML=ih,Oa=o(),Fa=r("hr"),Ya=o(),bl=r("a"),Wa=o(),u(vl.$$.fragment),Ga=o(),yl=r("p"),yl.textContent=dh,Xa=o(),Ml=r("p"),Ml.innerHTML=ah,Za=o(),xl=r("p"),xl.innerHTML=uh,eu=o(),Cl=r("table"),Cl.innerHTML=mh,tu=o(),lu=r("hr"),su=o(),Hl=r("a"),ou=o(),u(Ll.$$.fragment),nu=o(),wl=r("p"),wl.innerHTML=ph,ru=o(),Al=r("p"),Al.innerHTML=ch,iu=o(),du=r("hr"),au=o(),gl=r("a"),uu=o(),u(Pl.$$.fragment),mu=o(),zl=r("p"),zl.textContent=Th,pu=o(),Ul=r("p"),Ul.textContent=fh,cu=o(),Rl=r("p"),Rl.innerHTML=hh,Tu=o(),kl=r("table"),kl.innerHTML=_h,fu=o(),hu=r("hr"),_u=o(),jl=r("a"),$u=o(),u(Jl.$$.fragment),bu=o(),El=r("p"),El.innerHTML=$h,vu=o(),Dl=r("p"),Dl.innerHTML=bh,yu=o(),Mu=r("hr"),xu=o(),Il=r("a"),Cu=o(),u(ql.$$.fragment),Hu=o(),Kl=r("p"),Kl.innerHTML=vh,Lu=o(),Bl=r("p"),Bl.innerHTML=yh,wu=o(),Au=r("hr"),gu=o(),Nl=r("a"),Pu=o(),u(Ql.$$.fragment),zu=o(),Vl=r("p"),Vl.innerHTML=Mh,Uu=o(),Sl=r("p"),Sl.innerHTML=xh,Ru=o(),Ol=r("table"),Ol.innerHTML=Ch,ku=o(),ju=r("hr"),Ju=o(),Fl=r("a"),Eu=o(),u(Yl.$$.fragment),Du=o(),Wl=r("p"),Wl.innerHTML=Hh,Iu=o(),Gl=r("p"),Gl.innerHTML=Lh,qu=o(),Xl=r("table"),Xl.innerHTML=wh,Ku=o(),Bu=r("hr"),Nu=o(),Zl=r("a"),Qu=o(),u(es.$$.fragment),Vu=o(),ts=r("p"),ts.innerHTML=Ah,Su=o(),ls=r("p"),ls.innerHTML=gh,Ou=o(),Fu=r("hr"),Yu=o(),ss=r("a"),Wu=o(),u(os.$$.fragment),Gu=o(),ns=r("p"),ns.textContent=Ph,Xu=o(),rs=r("p"),rs.innerHTML=zh,Zu=o(),is=r("table"),is.innerHTML=Uh,em=o(),tm=r("hr"),lm=o(),ds=r("a"),sm=o(),u(as.$$.fragment),om=o(),us=r("p"),us.innerHTML=Rh,nm=o(),ms=r("p"),ms.innerHTML=kh,rm=o(),im=r("hr"),dm=o(),ps=r("a"),am=o(),u(cs.$$.fragment),um=o(),Ts=r("p"),Ts.textContent=jh,mm=o(),fs=r("p"),fs.innerHTML=Jh,pm=o(),cm=r("hr"),Tm=o(),hs=r("a"),fm=o(),u(_s.$$.fragment),hm=o(),$s=r("p"),$s.textContent=Eh,_m=o(),bs=r("p"),bs.innerHTML=Dh,$m=o(),vs=r("table"),vs.innerHTML=Ih,bm=o(),vm=r("hr"),ym=o(),ys=r("a"),Mm=o(),u(Ms.$$.fragment),xm=o(),xs=r("p"),xs.textContent=qh,Cm=o(),Cs=r("p"),Cs.innerHTML=Kh,Hm=o(),Hs=r("table"),Hs.innerHTML=Bh,Lm=o(),wm=r("hr"),Am=o(),Ls=r("a"),gm=o(),u(ws.$$.fragment),Pm=o(),As=r("p"),As.textContent=Nh,zm=o(),gs=r("p"),gs.innerHTML=Qh,Um=o(),Ps=r("table"),Ps.innerHTML=Vh,Rm=o(),km=r("hr"),jm=o(),zs=r("a"),Jm=o(),u(Us.$$.fragment),Em=o(),Rs=r("p"),Rs.innerHTML=Sh,Dm=o(),ks=r("p"),ks.innerHTML=Oh,Im=o(),js=r("table"),js.innerHTML=Fh,qm=o(),Km=r("hr"),Bm=o(),Js=r("a"),Nm=o(),u(Es.$$.fragment),Qm=o(),Ds=r("p"),Ds.innerHTML=Yh,Vm=o(),Is=r("p"),Is.innerHTML=Wh,Sm=o(),qs=r("table"),qs.innerHTML=Gh,Om=o(),Fm=r("hr"),Ym=o(),Ks=r("a"),Wm=o(),u(Bs.$$.fragment),Gm=o(),Ns=r("p"),Ns.innerHTML=Xh,Xm=o(),Qs=r("p"),Qs.innerHTML=Zh,Zm=o(),Vs=r("table"),Vs.innerHTML=e1,ep=o(),tp=r("hr"),lp=o(),Ss=r("a"),sp=o(),u(Os.$$.fragment),op=o(),Fs=r("p"),Fs.innerHTML=t1,np=o(),Ys=r("p"),Ys.innerHTML=l1,rp=o(),Ws=r("table"),Ws.innerHTML=s1,ip=o(),dp=r("hr"),ap=o(),Gs=r("a"),up=o(),u(Xs.$$.fragment),mp=o(),Zs=r("p"),Zs.textContent=o1,pp=o(),eo=r("p"),eo.innerHTML=n1,cp=o(),to=r("table"),to.innerHTML=r1,Tp=o(),fp=r("hr"),hp=o(),lo=r("a"),_p=o(),u(so.$$.fragment),$p=o(),oo=r("p"),oo.textContent=i1,bp=o(),no=r("p"),no.innerHTML=d1,vp=o(),ro=r("table"),ro.innerHTML=a1,yp=o(),Mp=r("hr"),xp=o(),io=r("a"),Cp=o(),u(ao.$$.fragment),Hp=o(),uo=r("p"),uo.textContent=u1,Lp=o(),mo=r("p"),mo.innerHTML=m1,wp=o(),po=r("table"),po.innerHTML=p1,Ap=o(),gp=r("hr"),Pp=o(),co=r("a"),zp=o(),u(To.$$.fragment),Up=o(),fo=r("p"),fo.textContent=c1,Rp=o(),ho=r("p"),ho.innerHTML=T1,kp=o(),_o=r("table"),_o.innerHTML=f1,jp=o(),Jp=r("hr"),Ep=o(),$o=r("a"),Dp=o(),u(bo.$$.fragment),Ip=o(),vo=r("p"),vo.innerHTML=h1,qp=o(),yo=r("p"),yo.innerHTML=_1,Kp=o(),Mo=r("table"),Mo.innerHTML=$1,Bp=o(),Np=r("hr"),Qp=o(),xo=r("a"),Vp=o(),u(Co.$$.fragment),Sp=o(),Ho=r("p"),Ho.textContent=b1,Op=o(),Lo=r("p"),Lo.innerHTML=v1,Fp=o(),wo=r("table"),wo.innerHTML=y1,Yp=o(),Wp=r("hr"),Gp=o(),Ao=r("a"),Xp=o(),u(go.$$.fragment),Zp=o(),Po=r("p"),Po.textContent=M1,ec=o(),zo=r("p"),zo.innerHTML=x1,tc=o(),Uo=r("table"),Uo.innerHTML=C1,lc=o(),sc=r("hr"),oc=o(),Ro=r("a"),nc=o(),u(ko.$$.fragment),rc=o(),jo=r("p"),jo.textContent=H1,ic=o(),Jo=r("p"),Jo.innerHTML=L1,dc=o(),Eo=r("table"),Eo.innerHTML=w1,ac=o(),uc=r("hr"),mc=o(),Do=r("a"),pc=o(),u(Io.$$.fragment),cc=o(),qo=r("p"),qo.textContent=A1,Tc=o(),Ko=r("p"),Ko.innerHTML=g1,fc=o(),Bo=r("table"),Bo.innerHTML=P1,hc=o(),_c=r("hr"),$c=o(),No=r("a"),bc=o(),u(Qo.$$.fragment),vc=o(),Vo=r("p"),Vo.textContent=z1,yc=o(),So=r("p"),So.innerHTML=U1,Mc=o(),Oo=r("table"),Oo.innerHTML=R1,xc=o(),Cc=r("hr"),Hc=o(),Fo=r("a"),Lc=o(),u(Yo.$$.fragment),wc=o(),Wo=r("p"),Wo.textContent=k1,Ac=o(),Go=r("p"),Go.innerHTML=j1,gc=o(),Xo=r("table"),Xo.innerHTML=J1,Pc=o(),zc=r("hr"),Uc=o(),Zo=r("a"),Rc=o(),u(en.$$.fragment),kc=o(),tn=r("p"),tn.textContent=E1,jc=o(),ln=r("p"),ln.innerHTML=D1,Jc=o(),sn=r("table"),sn.innerHTML=I1,Ec=o(),Dc=r("hr"),Ic=o(),on=r("a"),qc=o(),u(nn.$$.fragment),Kc=o(),rn=r("p"),rn.innerHTML=q1,Bc=o(),Nc=r("hr"),Qc=o(),dn=r("a"),Vc=o(),u(an.$$.fragment),Sc=o(),un=r("p"),un.textContent=K1,Oc=o(),mn=r("p"),mn.innerHTML=B1,Fc=o(),pn=r("table"),pn.innerHTML=N1,Yc=o(),cn=r("p"),cn.innerHTML=Q1,Wc=o(),u(Tn.$$.fragment),Gc=o(),Xc=r("hr"),Zc=o(),fn=r("a"),eT=o(),u(hn.$$.fragment),tT=o(),_n=r("p"),_n.innerHTML=V1,lT=o(),sT=r("hr"),oT=o(),$n=r("a"),nT=o(),u(bn.$$.fragment),rT=o(),vn=r("p"),vn.innerHTML=S1,iT=o(),dT=r("hr"),aT=o(),yn=r("a"),uT=o(),u(Mn.$$.fragment),mT=o(),xn=r("p"),xn.textContent=O1,pT=o(),Cn=r("p"),Cn.innerHTML=F1,cT=o(),u(Hn.$$.fragment),TT=o(),Ln=r("p"),Ln.innerHTML=Y1,fT=o(),u(wn.$$.fragment),hT=o(),An=r("p"),An.innerHTML=W1,_T=o(),u(gn.$$.fragment),$T=o(),bT=r("hr"),vT=o(),u(Pn.$$.fragment),yT=o(),Rn=r("p"),this.h()},l(e){const t=l_("svelte-u9bgzb",document.head);$=i(t,"META",{name:!0,content:!0}),t.forEach(l),kn=n(e),Un=i(e,"P",{}),h(Un).forEach(l),jn=n(e),b=i(e,"A",{id:!0,class:!0}),h(b).forEach(l),Jn=n(e),m(v.$$.fragment,e),En=n(e),y=i(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-uw4y1m"&&(y.innerHTML=CT),Dn=n(e),M=i(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-il3kl8"&&(M.textContent=HT),In=n(e),x=i(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-16lfzbg"&&(x.innerHTML=LT),qn=n(e),Kn=i(e,"HR",{}),Bn=n(e),C=i(e,"A",{id:!0,class:!0}),h(C).forEach(l),Nn=n(e),m(H.$$.fragment,e),Qn=n(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=wT),Vn=n(e),w=i(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-msj2om"&&(w.innerHTML=AT),Sn=n(e),On=i(e,"HR",{}),Fn=n(e),A=i(e,"A",{id:!0,class:!0}),h(A).forEach(l),Yn=n(e),m(g.$$.fragment,e),Wn=n(e),P=i(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-55wecd"&&(P.textContent=gT),Gn=n(e),z=i(e,"TABLE",{"data-svelte-h":!0}),d(z)!=="svelte-ee7emz"&&(z.innerHTML=PT),Xn=n(e),Zn=i(e,"HR",{}),er=n(e),U=i(e,"A",{id:!0,class:!0}),h(U).forEach(l),tr=n(e),m(R.$$.fragment,e),lr=n(e),k=i(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1gc2rt4"&&(k.textContent=zT),sr=n(e),j=i(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-10qzguj"&&(j.innerHTML=UT),or=n(e),nr=i(e,"HR",{}),rr=n(e),J=i(e,"A",{id:!0,class:!0}),h(J).forEach(l),ir=n(e),m(E.$$.fragment,e),dr=n(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-81y0bb"&&(D.textContent=RT),ar=n(e),I=i(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-10qzguj"&&(I.innerHTML=kT),ur=n(e),mr=i(e,"HR",{}),pr=n(e),q=i(e,"A",{id:!0,class:!0}),h(q).forEach(l),cr=n(e),m(K.$$.fragment,e),Tr=n(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1eqabt7"&&(B.textContent=jT),fr=n(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-10qzguj"&&(N.innerHTML=JT),hr=n(e),_r=i(e,"HR",{}),$r=n(e),Q=i(e,"A",{id:!0,class:!0}),h(Q).forEach(l),br=n(e),m(V.$$.fragment,e),vr=n(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-krrt97"&&(S.textContent=ET),yr=n(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-10qzguj"&&(O.innerHTML=DT),Mr=n(e),xr=i(e,"HR",{}),Cr=n(e),F=i(e,"A",{id:!0,class:!0}),h(F).forEach(l),Hr=n(e),m(Y.$$.fragment,e),Lr=n(e),W=i(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1iaptgl"&&(W.textContent=IT),wr=n(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-10qzguj"&&(G.innerHTML=qT),Ar=n(e),gr=i(e,"HR",{}),Pr=n(e),X=i(e,"A",{id:!0,class:!0}),h(X).forEach(l),zr=n(e),m(Z.$$.fragment,e),Ur=n(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1adn56z"&&(ee.textContent=KT),Rr=n(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1gxgvk6"&&(te.innerHTML=BT),kr=n(e),jr=i(e,"HR",{}),Jr=n(e),le=i(e,"A",{id:!0,class:!0}),h(le).forEach(l),Er=n(e),m(se.$$.fragment,e),Dr=n(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1u97xg1"&&(oe.textContent=NT),Ir=n(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1fs0j1e"&&(ne.innerHTML=QT),qr=n(e),re=i(e,"TABLE",{"data-svelte-h":!0}),d(re)!=="svelte-1kq04ga"&&(re.innerHTML=VT),Kr=n(e),Br=i(e,"HR",{}),Nr=n(e),ie=i(e,"A",{id:!0,class:!0}),h(ie).forEach(l),Qr=n(e),m(de.$$.fragment,e),Vr=n(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1cg22af"&&(ae.innerHTML=ST),Sr=n(e),ue=i(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-1hful42"&&(ue.innerHTML=OT),Or=n(e),Fr=i(e,"HR",{}),Yr=n(e),me=i(e,"A",{id:!0,class:!0}),h(me).forEach(l),Wr=n(e),m(pe.$$.fragment,e),Gr=n(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1mr58c3"&&(ce.innerHTML=FT),Xr=n(e),Te=i(e,"TABLE",{"data-svelte-h":!0}),d(Te)!=="svelte-153ftfy"&&(Te.innerHTML=YT),Zr=n(e),ei=i(e,"HR",{}),ti=n(e),fe=i(e,"A",{id:!0,class:!0}),h(fe).forEach(l),li=n(e),m(he.$$.fragment,e),si=n(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-13nzfs3"&&(_e.innerHTML=WT),oi=n(e),$e=i(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-11rv1mu"&&($e.innerHTML=GT),ni=n(e),be=i(e,"UL",{"data-svelte-h":!0}),d(be)!=="svelte-5t2sg3"&&(be.innerHTML=XT),ri=n(e),ii=i(e,"HR",{}),di=n(e),ve=i(e,"A",{id:!0,class:!0}),h(ve).forEach(l),ai=n(e),m(ye.$$.fragment,e),ui=n(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-87xdyr"&&(Me.textContent=ZT),mi=n(e),xe=i(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1mr58c3"&&(xe.innerHTML=ef),pi=n(e),ci=i(e,"HR",{}),Ti=n(e),Ce=i(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),fi=n(e),m(He.$$.fragment,e),hi=n(e),Le=i(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-2wti2w"&&(Le.textContent=tf),_i=n(e),we=i(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1y8z3p1"&&(we.innerHTML=lf),$i=n(e),bi=i(e,"HR",{}),vi=n(e),Ae=i(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),yi=n(e),m(ge.$$.fragment,e),Mi=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1edu6c8"&&(Pe.textContent=sf),xi=n(e),ze=i(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1t595qz"&&(ze.innerHTML=of),Ci=n(e),Hi=i(e,"HR",{}),Li=n(e),Ue=i(e,"A",{id:!0,class:!0}),h(Ue).forEach(l),wi=n(e),m(Re.$$.fragment,e),Ai=n(e),ke=i(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-az0crx"&&(ke.textContent=nf),gi=n(e),je=i(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-w5myiy"&&(je.innerHTML=rf),Pi=n(e),Je=i(e,"TABLE",{"data-svelte-h":!0}),d(Je)!=="svelte-1ok4yhn"&&(Je.innerHTML=df),zi=n(e),Ui=i(e,"HR",{}),Ri=n(e),Ee=i(e,"A",{id:!0,class:!0}),h(Ee).forEach(l),ki=n(e),m(De.$$.fragment,e),ji=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-jlfq15"&&(Ie.textContent=af),Ji=n(e),qe=i(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1t595qz"&&(qe.innerHTML=uf),Ei=n(e),Ke=i(e,"TABLE",{"data-svelte-h":!0}),d(Ke)!=="svelte-1ok4yhn"&&(Ke.innerHTML=mf),Di=n(e),Ii=i(e,"HR",{}),qi=n(e),Be=i(e,"A",{id:!0,class:!0}),h(Be).forEach(l),Ki=n(e),m(Ne.$$.fragment,e),Bi=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-xg80lg"&&(Qe.textContent=pf),Ni=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-9qu32j"&&(Ve.innerHTML=cf),Qi=n(e),Se=i(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-1tbtmqd"&&(Se.innerHTML=Tf),Vi=n(e),Si=i(e,"HR",{}),Oi=n(e),Oe=i(e,"A",{id:!0,class:!0}),h(Oe).forEach(l),Fi=n(e),m(Fe.$$.fragment,e),Yi=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1i12x1s"&&(Ye.textContent=ff),Wi=n(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1t595qz"&&(We.innerHTML=hf),Gi=n(e),Ge=i(e,"TABLE",{"data-svelte-h":!0}),d(Ge)!=="svelte-1tbtmqd"&&(Ge.innerHTML=_f),Xi=n(e),Zi=i(e,"HR",{}),ed=n(e),Xe=i(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),td=n(e),m(Ze.$$.fragment,e),ld=n(e),et=i(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-45kvaw"&&(et.textContent=$f),sd=n(e),tt=i(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-9qu32j"&&(tt.innerHTML=bf),od=n(e),lt=i(e,"TABLE",{"data-svelte-h":!0}),d(lt)!=="svelte-46t58i"&&(lt.innerHTML=vf),nd=n(e),rd=i(e,"HR",{}),id=n(e),st=i(e,"A",{id:!0,class:!0}),h(st).forEach(l),dd=n(e),m(ot.$$.fragment,e),ad=n(e),nt=i(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-6s524n"&&(nt.textContent=yf),ud=n(e),rt=i(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1t595qz"&&(rt.innerHTML=Mf),md=n(e),it=i(e,"TABLE",{"data-svelte-h":!0}),d(it)!=="svelte-46t58i"&&(it.innerHTML=xf),pd=n(e),cd=i(e,"HR",{}),Td=n(e),dt=i(e,"A",{id:!0,class:!0}),h(dt).forEach(l),fd=n(e),m(at.$$.fragment,e),hd=n(e),ut=i(e,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1hl64jn"&&(ut.textContent=Cf),_d=n(e),mt=i(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-9qu32j"&&(mt.innerHTML=Hf),$d=n(e),pt=i(e,"TABLE",{"data-svelte-h":!0}),d(pt)!=="svelte-1p5444"&&(pt.innerHTML=Lf),bd=n(e),vd=i(e,"HR",{}),yd=n(e),ct=i(e,"A",{id:!0,class:!0}),h(ct).forEach(l),Md=n(e),m(Tt.$$.fragment,e),xd=n(e),ft=i(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-bbf4x3"&&(ft.textContent=wf),Cd=n(e),ht=i(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1t595qz"&&(ht.innerHTML=Af),Hd=n(e),_t=i(e,"TABLE",{"data-svelte-h":!0}),d(_t)!=="svelte-1p5444"&&(_t.innerHTML=gf),Ld=n(e),wd=i(e,"HR",{}),Ad=n(e),$t=i(e,"A",{id:!0,class:!0}),h($t).forEach(l),gd=n(e),m(bt.$$.fragment,e),Pd=n(e),vt=i(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-wbrx6g"&&(vt.textContent=Pf),zd=n(e),yt=i(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-9qu32j"&&(yt.innerHTML=zf),Ud=n(e),Mt=i(e,"TABLE",{"data-svelte-h":!0}),d(Mt)!=="svelte-flm2g1"&&(Mt.innerHTML=Uf),Rd=n(e),kd=i(e,"HR",{}),jd=n(e),xt=i(e,"A",{id:!0,class:!0}),h(xt).forEach(l),Jd=n(e),m(Ct.$$.fragment,e),Ed=n(e),Ht=i(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-wqxtec"&&(Ht.textContent=Rf),Dd=n(e),Lt=i(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1t595qz"&&(Lt.innerHTML=kf),Id=n(e),wt=i(e,"TABLE",{"data-svelte-h":!0}),d(wt)!=="svelte-flm2g1"&&(wt.innerHTML=jf),qd=n(e),Kd=i(e,"HR",{}),Bd=n(e),At=i(e,"A",{id:!0,class:!0}),h(At).forEach(l),Nd=n(e),m(gt.$$.fragment,e),Qd=n(e),Pt=i(e,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-zftqbb"&&(Pt.textContent=Jf),Vd=n(e),zt=i(e,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1mgj1au"&&(zt.innerHTML=Ef),Sd=n(e),Od=i(e,"HR",{}),Fd=n(e),Ut=i(e,"A",{id:!0,class:!0}),h(Ut).forEach(l),Yd=n(e),m(Rt.$$.fragment,e),Wd=n(e),kt=i(e,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-yalim1"&&(kt.textContent=Df),Gd=n(e),jt=i(e,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-v4sb1d"&&(jt.textContent=If),Xd=n(e),m(Jt.$$.fragment,e),Zd=n(e),Et=i(e,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-1qggjsc"&&(Et.textContent=qf),ea=n(e),m(Dt.$$.fragment,e),ta=n(e),It=i(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-gtrr4w"&&(It.textContent=Kf),la=n(e),m(qt.$$.fragment,e),sa=n(e),Kt=i(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-15hbb4u"&&(Kt.innerHTML=Bf),oa=n(e),Bt=i(e,"UL",{"data-svelte-h":!0}),d(Bt)!=="svelte-2ixnrf"&&(Bt.innerHTML=Nf),na=n(e),Nt=i(e,"TABLE",{"data-svelte-h":!0}),d(Nt)!=="svelte-xutatr"&&(Nt.innerHTML=Qf),ra=n(e),ia=i(e,"HR",{}),da=n(e),Qt=i(e,"A",{id:!0,class:!0}),h(Qt).forEach(l),aa=n(e),m(Vt.$$.fragment,e),ua=n(e),St=i(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1g8ouql"&&(St.textContent=Vf),ma=n(e),Ot=i(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-19cc47x"&&(Ot.innerHTML=Sf),pa=n(e),Ft=i(e,"TABLE",{"data-svelte-h":!0}),d(Ft)!=="svelte-1p49qvp"&&(Ft.innerHTML=Of),ca=n(e),Ta=i(e,"HR",{}),fa=n(e),Yt=i(e,"A",{id:!0,class:!0}),h(Yt).forEach(l),ha=n(e),m(Wt.$$.fragment,e),_a=n(e),Gt=i(e,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-yjryb1"&&(Gt.textContent=Ff),$a=n(e),Xt=i(e,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-xtr8tc"&&(Xt.innerHTML=Yf),ba=n(e),Zt=i(e,"TABLE",{"data-svelte-h":!0}),d(Zt)!=="svelte-6xvdso"&&(Zt.innerHTML=Wf),va=n(e),ya=i(e,"HR",{}),Ma=n(e),el=i(e,"A",{id:!0,class:!0}),h(el).forEach(l),xa=n(e),m(tl.$$.fragment,e),Ca=n(e),ll=i(e,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-1okfsqx"&&(ll.textContent=Gf),Ha=n(e),sl=i(e,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-bqi4bh"&&(sl.innerHTML=Xf),La=n(e),ol=i(e,"TABLE",{"data-svelte-h":!0}),d(ol)!=="svelte-13m2wni"&&(ol.innerHTML=Zf),wa=n(e),Aa=i(e,"HR",{}),ga=n(e),nl=i(e,"A",{id:!0,class:!0}),h(nl).forEach(l),Pa=n(e),m(rl.$$.fragment,e),za=n(e),il=i(e,"P",{"data-svelte-h":!0}),d(il)!=="svelte-1htpbrk"&&(il.innerHTML=eh),Ua=n(e),dl=i(e,"P",{"data-svelte-h":!0}),d(dl)!=="svelte-13o8e7b"&&(dl.innerHTML=th),Ra=n(e),al=i(e,"TABLE",{"data-svelte-h":!0}),d(al)!=="svelte-1qi99pl"&&(al.innerHTML=lh),ka=n(e),ja=i(e,"HR",{}),Ja=n(e),ul=i(e,"A",{id:!0,class:!0}),h(ul).forEach(l),Ea=n(e),m(ml.$$.fragment,e),Da=n(e),pl=i(e,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-1ztgqp"&&(pl.innerHTML=sh),Ia=n(e),cl=i(e,"P",{"data-svelte-h":!0}),d(cl)!=="svelte-oa1qug"&&(cl.innerHTML=oh),qa=n(e),Tl=i(e,"TABLE",{"data-svelte-h":!0}),d(Tl)!=="svelte-1qi99pl"&&(Tl.innerHTML=nh),Ka=n(e),Ba=i(e,"HR",{}),Na=n(e),fl=i(e,"A",{id:!0,class:!0}),h(fl).forEach(l),Qa=n(e),m(hl.$$.fragment,e),Va=n(e),_l=i(e,"P",{"data-svelte-h":!0}),d(_l)!=="svelte-1a7u185"&&(_l.textContent=rh),Sa=n(e),$l=i(e,"P",{"data-svelte-h":!0}),d($l)!=="svelte-1eu3doh"&&($l.innerHTML=ih),Oa=n(e),Fa=i(e,"HR",{}),Ya=n(e),bl=i(e,"A",{id:!0,class:!0}),h(bl).forEach(l),Wa=n(e),m(vl.$$.fragment,e),Ga=n(e),yl=i(e,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-qls17b"&&(yl.textContent=dh),Xa=n(e),Ml=i(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-5nabmy"&&(Ml.innerHTML=ah),Za=n(e),xl=i(e,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-1fl56ed"&&(xl.innerHTML=uh),eu=n(e),Cl=i(e,"TABLE",{"data-svelte-h":!0}),d(Cl)!=="svelte-52pnzr"&&(Cl.innerHTML=mh),tu=n(e),lu=i(e,"HR",{}),su=n(e),Hl=i(e,"A",{id:!0,class:!0}),h(Hl).forEach(l),ou=n(e),m(Ll.$$.fragment,e),nu=n(e),wl=i(e,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-19w0pic"&&(wl.innerHTML=ph),ru=n(e),Al=i(e,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-1mr58c3"&&(Al.innerHTML=ch),iu=n(e),du=i(e,"HR",{}),au=n(e),gl=i(e,"A",{id:!0,class:!0}),h(gl).forEach(l),uu=n(e),m(Pl.$$.fragment,e),mu=n(e),zl=i(e,"P",{"data-svelte-h":!0}),d(zl)!=="svelte-18ws76n"&&(zl.textContent=Th),pu=n(e),Ul=i(e,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-1tnr5gm"&&(Ul.textContent=fh),cu=n(e),Rl=i(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-13m9nag"&&(Rl.innerHTML=hh),Tu=n(e),kl=i(e,"TABLE",{"data-svelte-h":!0}),d(kl)!=="svelte-1u9lyxp"&&(kl.innerHTML=_h),fu=n(e),hu=i(e,"HR",{}),_u=n(e),jl=i(e,"A",{id:!0,class:!0}),h(jl).forEach(l),$u=n(e),m(Jl.$$.fragment,e),bu=n(e),El=i(e,"P",{"data-svelte-h":!0}),d(El)!=="svelte-1b9ygao"&&(El.innerHTML=$h),vu=n(e),Dl=i(e,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-1mr58c3"&&(Dl.innerHTML=bh),yu=n(e),Mu=i(e,"HR",{}),xu=n(e),Il=i(e,"A",{id:!0,class:!0}),h(Il).forEach(l),Cu=n(e),m(ql.$$.fragment,e),Hu=n(e),Kl=i(e,"P",{"data-svelte-h":!0}),d(Kl)!=="svelte-1vkr5xo"&&(Kl.innerHTML=vh),Lu=n(e),Bl=i(e,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-1mr58c3"&&(Bl.innerHTML=yh),wu=n(e),Au=i(e,"HR",{}),gu=n(e),Nl=i(e,"A",{id:!0,class:!0}),h(Nl).forEach(l),Pu=n(e),m(Ql.$$.fragment,e),zu=n(e),Vl=i(e,"P",{"data-svelte-h":!0}),d(Vl)!=="svelte-1gguudf"&&(Vl.innerHTML=Mh),Uu=n(e),Sl=i(e,"P",{"data-svelte-h":!0}),d(Sl)!=="svelte-1vf2xxu"&&(Sl.innerHTML=xh),Ru=n(e),Ol=i(e,"TABLE",{"data-svelte-h":!0}),d(Ol)!=="svelte-z6whez"&&(Ol.innerHTML=Ch),ku=n(e),ju=i(e,"HR",{}),Ju=n(e),Fl=i(e,"A",{id:!0,class:!0}),h(Fl).forEach(l),Eu=n(e),m(Yl.$$.fragment,e),Du=n(e),Wl=i(e,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-d6gvut"&&(Wl.innerHTML=Hh),Iu=n(e),Gl=i(e,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-1ueenyl"&&(Gl.innerHTML=Lh),qu=n(e),Xl=i(e,"TABLE",{"data-svelte-h":!0}),d(Xl)!=="svelte-jj58dd"&&(Xl.innerHTML=wh),Ku=n(e),Bu=i(e,"HR",{}),Nu=n(e),Zl=i(e,"A",{id:!0,class:!0}),h(Zl).forEach(l),Qu=n(e),m(es.$$.fragment,e),Vu=n(e),ts=i(e,"P",{"data-svelte-h":!0}),d(ts)!=="svelte-1adolpg"&&(ts.innerHTML=Ah),Su=n(e),ls=i(e,"P",{"data-svelte-h":!0}),d(ls)!=="svelte-1mr58c3"&&(ls.innerHTML=gh),Ou=n(e),Fu=i(e,"HR",{}),Yu=n(e),ss=i(e,"A",{id:!0,class:!0}),h(ss).forEach(l),Wu=n(e),m(os.$$.fragment,e),Gu=n(e),ns=i(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-1hm8vtj"&&(ns.textContent=Ph),Xu=n(e),rs=i(e,"P",{"data-svelte-h":!0}),d(rs)!=="svelte-1mnx14"&&(rs.innerHTML=zh),Zu=n(e),is=i(e,"TABLE",{"data-svelte-h":!0}),d(is)!=="svelte-9ff0sy"&&(is.innerHTML=Uh),em=n(e),tm=i(e,"HR",{}),lm=n(e),ds=i(e,"A",{id:!0,class:!0}),h(ds).forEach(l),sm=n(e),m(as.$$.fragment,e),om=n(e),us=i(e,"P",{"data-svelte-h":!0}),d(us)!=="svelte-1e6kzks"&&(us.innerHTML=Rh),nm=n(e),ms=i(e,"P",{"data-svelte-h":!0}),d(ms)!=="svelte-1mr58c3"&&(ms.innerHTML=kh),rm=n(e),im=i(e,"HR",{}),dm=n(e),ps=i(e,"A",{id:!0,class:!0}),h(ps).forEach(l),am=n(e),m(cs.$$.fragment,e),um=n(e),Ts=i(e,"P",{"data-svelte-h":!0}),d(Ts)!=="svelte-t5k6jp"&&(Ts.textContent=jh),mm=n(e),fs=i(e,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-1mnx14"&&(fs.innerHTML=Jh),pm=n(e),cm=i(e,"HR",{}),Tm=n(e),hs=i(e,"A",{id:!0,class:!0}),h(hs).forEach(l),fm=n(e),m(_s.$$.fragment,e),hm=n(e),$s=i(e,"P",{"data-svelte-h":!0}),d($s)!=="svelte-avw2a1"&&($s.textContent=Eh),_m=n(e),bs=i(e,"P",{"data-svelte-h":!0}),d(bs)!=="svelte-3w87vv"&&(bs.innerHTML=Dh),$m=n(e),vs=i(e,"TABLE",{"data-svelte-h":!0}),d(vs)!=="svelte-jj5vaa"&&(vs.innerHTML=Ih),bm=n(e),vm=i(e,"HR",{}),ym=n(e),ys=i(e,"A",{id:!0,class:!0}),h(ys).forEach(l),Mm=n(e),m(Ms.$$.fragment,e),xm=n(e),xs=i(e,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-167n5bd"&&(xs.textContent=qh),Cm=n(e),Cs=i(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-74oixn"&&(Cs.innerHTML=Kh),Hm=n(e),Hs=i(e,"TABLE",{"data-svelte-h":!0}),d(Hs)!=="svelte-1oyadc3"&&(Hs.innerHTML=Bh),Lm=n(e),wm=i(e,"HR",{}),Am=n(e),Ls=i(e,"A",{id:!0,class:!0}),h(Ls).forEach(l),gm=n(e),m(ws.$$.fragment,e),Pm=n(e),As=i(e,"P",{"data-svelte-h":!0}),d(As)!=="svelte-fju8tm"&&(As.textContent=Nh),zm=n(e),gs=i(e,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-16503uw"&&(gs.innerHTML=Qh),Um=n(e),Ps=i(e,"TABLE",{"data-svelte-h":!0}),d(Ps)!=="svelte-1no2z7v"&&(Ps.innerHTML=Vh),Rm=n(e),km=i(e,"HR",{}),jm=n(e),zs=i(e,"A",{id:!0,class:!0}),h(zs).forEach(l),Jm=n(e),m(Us.$$.fragment,e),Em=n(e),Rs=i(e,"P",{"data-svelte-h":!0}),d(Rs)!=="svelte-18v04la"&&(Rs.innerHTML=Sh),Dm=n(e),ks=i(e,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-14kv4rj"&&(ks.innerHTML=Oh),Im=n(e),js=i(e,"TABLE",{"data-svelte-h":!0}),d(js)!=="svelte-1caupec"&&(js.innerHTML=Fh),qm=n(e),Km=i(e,"HR",{}),Bm=n(e),Js=i(e,"A",{id:!0,class:!0}),h(Js).forEach(l),Nm=n(e),m(Es.$$.fragment,e),Qm=n(e),Ds=i(e,"P",{"data-svelte-h":!0}),d(Ds)!=="svelte-1yvow13"&&(Ds.innerHTML=Yh),Vm=n(e),Is=i(e,"P",{"data-svelte-h":!0}),d(Is)!=="svelte-fexugp"&&(Is.innerHTML=Wh),Sm=n(e),qs=i(e,"TABLE",{"data-svelte-h":!0}),d(qs)!=="svelte-1t0kp7i"&&(qs.innerHTML=Gh),Om=n(e),Fm=i(e,"HR",{}),Ym=n(e),Ks=i(e,"A",{id:!0,class:!0}),h(Ks).forEach(l),Wm=n(e),m(Bs.$$.fragment,e),Gm=n(e),Ns=i(e,"P",{"data-svelte-h":!0}),d(Ns)!=="svelte-19dtamh"&&(Ns.innerHTML=Xh),Xm=n(e),Qs=i(e,"P",{"data-svelte-h":!0}),d(Qs)!=="svelte-1q9jl83"&&(Qs.innerHTML=Zh),Zm=n(e),Vs=i(e,"TABLE",{"data-svelte-h":!0}),d(Vs)!=="svelte-po861j"&&(Vs.innerHTML=e1),ep=n(e),tp=i(e,"HR",{}),lp=n(e),Ss=i(e,"A",{id:!0,class:!0}),h(Ss).forEach(l),sp=n(e),m(Os.$$.fragment,e),op=n(e),Fs=i(e,"P",{"data-svelte-h":!0}),d(Fs)!=="svelte-bd7moq"&&(Fs.innerHTML=t1),np=n(e),Ys=i(e,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-jyg3bg"&&(Ys.innerHTML=l1),rp=n(e),Ws=i(e,"TABLE",{"data-svelte-h":!0}),d(Ws)!=="svelte-gsjwyf"&&(Ws.innerHTML=s1),ip=n(e),dp=i(e,"HR",{}),ap=n(e),Gs=i(e,"A",{id:!0,class:!0}),h(Gs).forEach(l),up=n(e),m(Xs.$$.fragment,e),mp=n(e),Zs=i(e,"P",{"data-svelte-h":!0}),d(Zs)!=="svelte-11ei68w"&&(Zs.textContent=o1),pp=n(e),eo=i(e,"P",{"data-svelte-h":!0}),d(eo)!=="svelte-f0cseu"&&(eo.innerHTML=n1),cp=n(e),to=i(e,"TABLE",{"data-svelte-h":!0}),d(to)!=="svelte-1lgev2y"&&(to.innerHTML=r1),Tp=n(e),fp=i(e,"HR",{}),hp=n(e),lo=i(e,"A",{id:!0,class:!0}),h(lo).forEach(l),_p=n(e),m(so.$$.fragment,e),$p=n(e),oo=i(e,"P",{"data-svelte-h":!0}),d(oo)!=="svelte-7ivim4"&&(oo.textContent=i1),bp=n(e),no=i(e,"P",{"data-svelte-h":!0}),d(no)!=="svelte-1t7ypd0"&&(no.innerHTML=d1),vp=n(e),ro=i(e,"TABLE",{"data-svelte-h":!0}),d(ro)!=="svelte-1lmecr"&&(ro.innerHTML=a1),yp=n(e),Mp=i(e,"HR",{}),xp=n(e),io=i(e,"A",{id:!0,class:!0}),h(io).forEach(l),Cp=n(e),m(ao.$$.fragment,e),Hp=n(e),uo=i(e,"P",{"data-svelte-h":!0}),d(uo)!=="svelte-k6p1db"&&(uo.textContent=u1),Lp=n(e),mo=i(e,"P",{"data-svelte-h":!0}),d(mo)!=="svelte-6qi3ne"&&(mo.innerHTML=m1),wp=n(e),po=i(e,"TABLE",{"data-svelte-h":!0}),d(po)!=="svelte-2flruf"&&(po.innerHTML=p1),Ap=n(e),gp=i(e,"HR",{}),Pp=n(e),co=i(e,"A",{id:!0,class:!0}),h(co).forEach(l),zp=n(e),m(To.$$.fragment,e),Up=n(e),fo=i(e,"P",{"data-svelte-h":!0}),d(fo)!=="svelte-8afo9v"&&(fo.textContent=c1),Rp=n(e),ho=i(e,"P",{"data-svelte-h":!0}),d(ho)!=="svelte-fnpm0s"&&(ho.innerHTML=T1),kp=n(e),_o=i(e,"TABLE",{"data-svelte-h":!0}),d(_o)!=="svelte-1m3fin1"&&(_o.innerHTML=f1),jp=n(e),Jp=i(e,"HR",{}),Ep=n(e),$o=i(e,"A",{id:!0,class:!0}),h($o).forEach(l),Dp=n(e),m(bo.$$.fragment,e),Ip=n(e),vo=i(e,"P",{"data-svelte-h":!0}),d(vo)!=="svelte-11plveb"&&(vo.innerHTML=h1),qp=n(e),yo=i(e,"P",{"data-svelte-h":!0}),d(yo)!=="svelte-1k0sd0r"&&(yo.innerHTML=_1),Kp=n(e),Mo=i(e,"TABLE",{"data-svelte-h":!0}),d(Mo)!=="svelte-xda5g6"&&(Mo.innerHTML=$1),Bp=n(e),Np=i(e,"HR",{}),Qp=n(e),xo=i(e,"A",{id:!0,class:!0}),h(xo).forEach(l),Vp=n(e),m(Co.$$.fragment,e),Sp=n(e),Ho=i(e,"P",{"data-svelte-h":!0}),d(Ho)!=="svelte-17f4oxi"&&(Ho.textContent=b1),Op=n(e),Lo=i(e,"P",{"data-svelte-h":!0}),d(Lo)!=="svelte-j8mnym"&&(Lo.innerHTML=v1),Fp=n(e),wo=i(e,"TABLE",{"data-svelte-h":!0}),d(wo)!=="svelte-8q2rcx"&&(wo.innerHTML=y1),Yp=n(e),Wp=i(e,"HR",{}),Gp=n(e),Ao=i(e,"A",{id:!0,class:!0}),h(Ao).forEach(l),Xp=n(e),m(go.$$.fragment,e),Zp=n(e),Po=i(e,"P",{"data-svelte-h":!0}),d(Po)!=="svelte-10qu7f7"&&(Po.textContent=M1),ec=n(e),zo=i(e,"P",{"data-svelte-h":!0}),d(zo)!=="svelte-18rka45"&&(zo.innerHTML=x1),tc=n(e),Uo=i(e,"TABLE",{"data-svelte-h":!0}),d(Uo)!=="svelte-1xtb381"&&(Uo.innerHTML=C1),lc=n(e),sc=i(e,"HR",{}),oc=n(e),Ro=i(e,"A",{id:!0,class:!0}),h(Ro).forEach(l),nc=n(e),m(ko.$$.fragment,e),rc=n(e),jo=i(e,"P",{"data-svelte-h":!0}),d(jo)!=="svelte-1ayje0f"&&(jo.textContent=H1),ic=n(e),Jo=i(e,"P",{"data-svelte-h":!0}),d(Jo)!=="svelte-154ckak"&&(Jo.innerHTML=L1),dc=n(e),Eo=i(e,"TABLE",{"data-svelte-h":!0}),d(Eo)!=="svelte-gyxne1"&&(Eo.innerHTML=w1),ac=n(e),uc=i(e,"HR",{}),mc=n(e),Do=i(e,"A",{id:!0,class:!0}),h(Do).forEach(l),pc=n(e),m(Io.$$.fragment,e),cc=n(e),qo=i(e,"P",{"data-svelte-h":!0}),d(qo)!=="svelte-1wvb8sq"&&(qo.textContent=A1),Tc=n(e),Ko=i(e,"P",{"data-svelte-h":!0}),d(Ko)!=="svelte-154ckak"&&(Ko.innerHTML=g1),fc=n(e),Bo=i(e,"TABLE",{"data-svelte-h":!0}),d(Bo)!=="svelte-esxgyf"&&(Bo.innerHTML=P1),hc=n(e),_c=i(e,"HR",{}),$c=n(e),No=i(e,"A",{id:!0,class:!0}),h(No).forEach(l),bc=n(e),m(Qo.$$.fragment,e),vc=n(e),Vo=i(e,"P",{"data-svelte-h":!0}),d(Vo)!=="svelte-1798kaw"&&(Vo.textContent=z1),yc=n(e),So=i(e,"P",{"data-svelte-h":!0}),d(So)!=="svelte-ue1j5m"&&(So.innerHTML=U1),Mc=n(e),Oo=i(e,"TABLE",{"data-svelte-h":!0}),d(Oo)!=="svelte-gyxne1"&&(Oo.innerHTML=R1),xc=n(e),Cc=i(e,"HR",{}),Hc=n(e),Fo=i(e,"A",{id:!0,class:!0}),h(Fo).forEach(l),Lc=n(e),m(Yo.$$.fragment,e),wc=n(e),Wo=i(e,"P",{"data-svelte-h":!0}),d(Wo)!=="svelte-9nnpip"&&(Wo.textContent=k1),Ac=n(e),Go=i(e,"P",{"data-svelte-h":!0}),d(Go)!=="svelte-ue1j5m"&&(Go.innerHTML=j1),gc=n(e),Xo=i(e,"TABLE",{"data-svelte-h":!0}),d(Xo)!=="svelte-esxgyf"&&(Xo.innerHTML=J1),Pc=n(e),zc=i(e,"HR",{}),Uc=n(e),Zo=i(e,"A",{id:!0,class:!0}),h(Zo).forEach(l),Rc=n(e),m(en.$$.fragment,e),kc=n(e),tn=i(e,"P",{"data-svelte-h":!0}),d(tn)!=="svelte-185sm1b"&&(tn.textContent=E1),jc=n(e),ln=i(e,"P",{"data-svelte-h":!0}),d(ln)!=="svelte-1a5fo0"&&(ln.innerHTML=D1),Jc=n(e),sn=i(e,"TABLE",{"data-svelte-h":!0}),d(sn)!=="svelte-rf6ukr"&&(sn.innerHTML=I1),Ec=n(e),Dc=i(e,"HR",{}),Ic=n(e),on=i(e,"A",{id:!0,class:!0}),h(on).forEach(l),qc=n(e),m(nn.$$.fragment,e),Kc=n(e),rn=i(e,"P",{"data-svelte-h":!0}),d(rn)!=="svelte-12loz97"&&(rn.innerHTML=q1),Bc=n(e),Nc=i(e,"HR",{}),Qc=n(e),dn=i(e,"A",{id:!0,class:!0}),h(dn).forEach(l),Vc=n(e),m(an.$$.fragment,e),Sc=n(e),un=i(e,"P",{"data-svelte-h":!0}),d(un)!=="svelte-40isdg"&&(un.textContent=K1),Oc=n(e),mn=i(e,"P",{"data-svelte-h":!0}),d(mn)!=="svelte-tlsa2h"&&(mn.innerHTML=B1),Fc=n(e),pn=i(e,"TABLE",{"data-svelte-h":!0}),d(pn)!=="svelte-17343p6"&&(pn.innerHTML=N1),Yc=n(e),cn=i(e,"P",{"data-svelte-h":!0}),d(cn)!=="svelte-1aswmub"&&(cn.innerHTML=Q1),Wc=n(e),m(Tn.$$.fragment,e),Gc=n(e),Xc=i(e,"HR",{}),Zc=n(e),fn=i(e,"A",{id:!0,class:!0}),h(fn).forEach(l),eT=n(e),m(hn.$$.fragment,e),tT=n(e),_n=i(e,"P",{"data-svelte-h":!0}),d(_n)!=="svelte-kp31r8"&&(_n.innerHTML=V1),lT=n(e),sT=i(e,"HR",{}),oT=n(e),$n=i(e,"A",{id:!0,class:!0}),h($n).forEach(l),nT=n(e),m(bn.$$.fragment,e),rT=n(e),vn=i(e,"P",{"data-svelte-h":!0}),d(vn)!=="svelte-1fs9no9"&&(vn.innerHTML=S1),iT=n(e),dT=i(e,"HR",{}),aT=n(e),yn=i(e,"A",{id:!0,class:!0}),h(yn).forEach(l),uT=n(e),m(Mn.$$.fragment,e),mT=n(e),xn=i(e,"P",{"data-svelte-h":!0}),d(xn)!=="svelte-2mif9c"&&(xn.textContent=O1),pT=n(e),Cn=i(e,"P",{"data-svelte-h":!0}),d(Cn)!=="svelte-1jas2kw"&&(Cn.innerHTML=F1),cT=n(e),m(Hn.$$.fragment,e),TT=n(e),Ln=i(e,"P",{"data-svelte-h":!0}),d(Ln)!=="svelte-1aswmub"&&(Ln.innerHTML=Y1),fT=n(e),m(wn.$$.fragment,e),hT=n(e),An=i(e,"P",{"data-svelte-h":!0}),d(An)!=="svelte-1aswmub"&&(An.innerHTML=W1),_T=n(e),m(gn.$$.fragment,e),$T=n(e),bT=i(e,"HR",{}),vT=n(e),m(Pn.$$.fragment,e),yT=n(e),Rn=i(e,"P",{}),h(Rn).forEach(l),this.h()},h(){a($,"name","hf:doc:metadata"),a($,"content",r_),a(b,"id","module_utils/tensor"),a(b,"class","group"),a(C,"id","module_utils/tensor.Tensor"),a(C,"class","group"),a(A,"id","new_module_utils/tensor.Tensor_new"),a(A,"class","group"),a(U,"id","module_utils/tensor.Tensor+dims"),a(U,"class","group"),a(J,"id","module_utils/tensor.Tensor+type"),a(J,"class","group"),a(q,"id","module_utils/tensor.Tensor+data"),a(q,"class","group"),a(Q,"id","module_utils/tensor.Tensor+size"),a(Q,"class","group"),a(F,"id","module_utils/tensor.Tensor+location"),a(F,"class","group"),a(X,"id","module_utils/tensor.Tensor+Symbol.iterator"),a(X,"class","group"),a(le,"id","module_utils/tensor.Tensor+_getitem"),a(le,"class","group"),a(ie,"id","module_utils/tensor.Tensor+indexOf"),a(ie,"class","group"),a(me,"id","module_utils/tensor.Tensor+_subarray"),a(me,"class","group"),a(fe,"id","module_utils/tensor.Tensor+item"),a(fe,"class","group"),a(ve,"id","module_utils/tensor.Tensor+tolist"),a(ve,"class","group"),a(Ce,"id","module_utils/tensor.Tensor+sigmoid"),a(Ce,"class","group"),a(Ae,"id","module_utils/tensor.Tensor+sigmoid_"),a(Ae,"class","group"),a(Ue,"id","module_utils/tensor.Tensor+map"),a(Ue,"class","group"),a(Ee,"id","module_utils/tensor.Tensor+map_"),a(Ee,"class","group"),a(Be,"id","module_utils/tensor.Tensor+mul"),a(Be,"class","group"),a(Oe,"id","module_utils/tensor.Tensor+mul_"),a(Oe,"class","group"),a(Xe,"id","module_utils/tensor.Tensor+div"),a(Xe,"class","group"),a(st,"id","module_utils/tensor.Tensor+div_"),a(st,"class","group"),a(dt,"id","module_utils/tensor.Tensor+add"),a(dt,"class","group"),a(ct,"id","module_utils/tensor.Tensor+add_"),a(ct,"class","group"),a($t,"id","module_utils/tensor.Tensor+sub"),a($t,"class","group"),a(xt,"id","module_utils/tensor.Tensor+sub_"),a(xt,"class","group"),a(At,"id","module_utils/tensor.Tensor+clone"),a(At,"class","group"),a(Ut,"id","module_utils/tensor.Tensor+slice"),a(Ut,"class","group"),a(Qt,"id","module_utils/tensor.Tensor+permute"),a(Qt,"class","group"),a(Yt,"id","module_utils/tensor.Tensor+sum"),a(Yt,"class","group"),a(el,"id","module_utils/tensor.Tensor+norm"),a(el,"class","group"),a(nl,"id","module_utils/tensor.Tensor+normalize_"),a(nl,"class","group"),a(ul,"id","module_utils/tensor.Tensor+normalize"),a(ul,"class","group"),a(fl,"id","module_utils/tensor.Tensor+stride"),a(fl,"class","group"),a(bl,"id","module_utils/tensor.Tensor+squeeze"),a(bl,"class","group"),a(Hl,"id","module_utils/tensor.Tensor+squeeze_"),a(Hl,"class","group"),a(gl,"id","module_utils/tensor.Tensor+unsqueeze"),a(gl,"class","group"),a(jl,"id","module_utils/tensor.Tensor+unsqueeze_"),a(jl,"class","group"),a(Il,"id","module_utils/tensor.Tensor+flatten_"),a(Il,"class","group"),a(Nl,"id","module_utils/tensor.Tensor+flatten"),a(Nl,"class","group"),a(Fl,"id","module_utils/tensor.Tensor+view"),a(Fl,"class","group"),a(Zl,"id","module_utils/tensor.Tensor+clamp_"),a(Zl,"class","group"),a(ss,"id","module_utils/tensor.Tensor+clamp"),a(ss,"class","group"),a(ds,"id","module_utils/tensor.Tensor+round_"),a(ds,"class","group"),a(ps,"id","module_utils/tensor.Tensor+round"),a(ps,"class","group"),a(hs,"id","module_utils/tensor.Tensor+to"),a(hs,"class","group"),a(ys,"id","module_utils/tensor.permute"),a(ys,"class","group"),a(Ls,"id","module_utils/tensor.interpolate"),a(Ls,"class","group"),a(zs,"id","module_utils/tensor.interpolate_4d"),a(zs,"class","group"),a(Js,"id","module_utils/tensor.matmul"),a(Js,"class","group"),a(Ks,"id","module_utils/tensor.rfft"),a(Ks,"class","group"),a(Ss,"id","module_utils/tensor.topk"),a(Ss,"class","group"),a(Gs,"id","module_utils/tensor.mean_pooling"),a(Gs,"class","group"),a(lo,"id","module_utils/tensor.layer_norm"),a(lo,"class","group"),a(io,"id","module_utils/tensor.cat"),a(io,"class","group"),a(co,"id","module_utils/tensor.stack"),a(co,"class","group"),a($o,"id","module_utils/tensor.std_mean"),a($o,"class","group"),a(xo,"id","module_utils/tensor.mean"),a(xo,"class","group"),a(Ao,"id","module_utils/tensor.full"),a(Ao,"class","group"),a(Ro,"id","module_utils/tensor.ones"),a(Ro,"class","group"),a(Do,"id","module_utils/tensor.ones_like"),a(Do,"class","group"),a(No,"id","module_utils/tensor.zeros"),a(No,"class","group"),a(Fo,"id","module_utils/tensor.zeros_like"),a(Fo,"class","group"),a(Zo,"id","module_utils/tensor.quantize_embeddings"),a(Zo,"class","group"),a(on,"id","module_utils/tensor..args[0]"),a(on,"class","group"),a(dn,"id","module_utils/tensor..reshape"),a(dn,"class","group"),a(fn,"id","module_utils/tensor..reshape..reshapedArray"),a(fn,"class","group"),a($n,"id","module_utils/tensor..DataArray"),a($n,"class","group"),a(yn,"id","module_utils/tensor..NestArray"),a(yn,"class","group")},m(e,t){s_(document.head,$),s(e,kn,t),s(e,Un,t),s(e,jn,t),s(e,b,t),s(e,Jn,t),p(v,e,t),s(e,En,t),s(e,y,t),s(e,Dn,t),s(e,M,t),s(e,In,t),s(e,x,t),s(e,qn,t),s(e,Kn,t),s(e,Bn,t),s(e,C,t),s(e,Nn,t),p(H,e,t),s(e,Qn,t),s(e,L,t),s(e,Vn,t),s(e,w,t),s(e,Sn,t),s(e,On,t),s(e,Fn,t),s(e,A,t),s(e,Yn,t),p(g,e,t),s(e,Wn,t),s(e,P,t),s(e,Gn,t),s(e,z,t),s(e,Xn,t),s(e,Zn,t),s(e,er,t),s(e,U,t),s(e,tr,t),p(R,e,t),s(e,lr,t),s(e,k,t),s(e,sr,t),s(e,j,t),s(e,or,t),s(e,nr,t),s(e,rr,t),s(e,J,t),s(e,ir,t),p(E,e,t),s(e,dr,t),s(e,D,t),s(e,ar,t),s(e,I,t),s(e,ur,t),s(e,mr,t),s(e,pr,t),s(e,q,t),s(e,cr,t),p(K,e,t),s(e,Tr,t),s(e,B,t),s(e,fr,t),s(e,N,t),s(e,hr,t),s(e,_r,t),s(e,$r,t),s(e,Q,t),s(e,br,t),p(V,e,t),s(e,vr,t),s(e,S,t),s(e,yr,t),s(e,O,t),s(e,Mr,t),s(e,xr,t),s(e,Cr,t),s(e,F,t),s(e,Hr,t),p(Y,e,t),s(e,Lr,t),s(e,W,t),s(e,wr,t),s(e,G,t),s(e,Ar,t),s(e,gr,t),s(e,Pr,t),s(e,X,t),s(e,zr,t),p(Z,e,t),s(e,Ur,t),s(e,ee,t),s(e,Rr,t),s(e,te,t),s(e,kr,t),s(e,jr,t),s(e,Jr,t),s(e,le,t),s(e,Er,t),p(se,e,t),s(e,Dr,t),s(e,oe,t),s(e,Ir,t),s(e,ne,t),s(e,qr,t),s(e,re,t),s(e,Kr,t),s(e,Br,t),s(e,Nr,t),s(e,ie,t),s(e,Qr,t),p(de,e,t),s(e,Vr,t),s(e,ae,t),s(e,Sr,t),s(e,ue,t),s(e,Or,t),s(e,Fr,t),s(e,Yr,t),s(e,me,t),s(e,Wr,t),p(pe,e,t),s(e,Gr,t),s(e,ce,t),s(e,Xr,t),s(e,Te,t),s(e,Zr,t),s(e,ei,t),s(e,ti,t),s(e,fe,t),s(e,li,t),p(he,e,t),s(e,si,t),s(e,_e,t),s(e,oi,t),s(e,$e,t),s(e,ni,t),s(e,be,t),s(e,ri,t),s(e,ii,t),s(e,di,t),s(e,ve,t),s(e,ai,t),p(ye,e,t),s(e,ui,t),s(e,Me,t),s(e,mi,t),s(e,xe,t),s(e,pi,t),s(e,ci,t),s(e,Ti,t),s(e,Ce,t),s(e,fi,t),p(He,e,t),s(e,hi,t),s(e,Le,t),s(e,_i,t),s(e,we,t),s(e,$i,t),s(e,bi,t),s(e,vi,t),s(e,Ae,t),s(e,yi,t),p(ge,e,t),s(e,Mi,t),s(e,Pe,t),s(e,xi,t),s(e,ze,t),s(e,Ci,t),s(e,Hi,t),s(e,Li,t),s(e,Ue,t),s(e,wi,t),p(Re,e,t),s(e,Ai,t),s(e,ke,t),s(e,gi,t),s(e,je,t),s(e,Pi,t),s(e,Je,t),s(e,zi,t),s(e,Ui,t),s(e,Ri,t),s(e,Ee,t),s(e,ki,t),p(De,e,t),s(e,ji,t),s(e,Ie,t),s(e,Ji,t),s(e,qe,t),s(e,Ei,t),s(e,Ke,t),s(e,Di,t),s(e,Ii,t),s(e,qi,t),s(e,Be,t),s(e,Ki,t),p(Ne,e,t),s(e,Bi,t),s(e,Qe,t),s(e,Ni,t),s(e,Ve,t),s(e,Qi,t),s(e,Se,t),s(e,Vi,t),s(e,Si,t),s(e,Oi,t),s(e,Oe,t),s(e,Fi,t),p(Fe,e,t),s(e,Yi,t),s(e,Ye,t),s(e,Wi,t),s(e,We,t),s(e,Gi,t),s(e,Ge,t),s(e,Xi,t),s(e,Zi,t),s(e,ed,t),s(e,Xe,t),s(e,td,t),p(Ze,e,t),s(e,ld,t),s(e,et,t),s(e,sd,t),s(e,tt,t),s(e,od,t),s(e,lt,t),s(e,nd,t),s(e,rd,t),s(e,id,t),s(e,st,t),s(e,dd,t),p(ot,e,t),s(e,ad,t),s(e,nt,t),s(e,ud,t),s(e,rt,t),s(e,md,t),s(e,it,t),s(e,pd,t),s(e,cd,t),s(e,Td,t),s(e,dt,t),s(e,fd,t),p(at,e,t),s(e,hd,t),s(e,ut,t),s(e,_d,t),s(e,mt,t),s(e,$d,t),s(e,pt,t),s(e,bd,t),s(e,vd,t),s(e,yd,t),s(e,ct,t),s(e,Md,t),p(Tt,e,t),s(e,xd,t),s(e,ft,t),s(e,Cd,t),s(e,ht,t),s(e,Hd,t),s(e,_t,t),s(e,Ld,t),s(e,wd,t),s(e,Ad,t),s(e,$t,t),s(e,gd,t),p(bt,e,t),s(e,Pd,t),s(e,vt,t),s(e,zd,t),s(e,yt,t),s(e,Ud,t),s(e,Mt,t),s(e,Rd,t),s(e,kd,t),s(e,jd,t),s(e,xt,t),s(e,Jd,t),p(Ct,e,t),s(e,Ed,t),s(e,Ht,t),s(e,Dd,t),s(e,Lt,t),s(e,Id,t),s(e,wt,t),s(e,qd,t),s(e,Kd,t),s(e,Bd,t),s(e,At,t),s(e,Nd,t),p(gt,e,t),s(e,Qd,t),s(e,Pt,t),s(e,Vd,t),s(e,zt,t),s(e,Sd,t),s(e,Od,t),s(e,Fd,t),s(e,Ut,t),s(e,Yd,t),p(Rt,e,t),s(e,Wd,t),s(e,kt,t),s(e,Gd,t),s(e,jt,t),s(e,Xd,t),p(Jt,e,t),s(e,Zd,t),s(e,Et,t),s(e,ea,t),p(Dt,e,t),s(e,ta,t),s(e,It,t),s(e,la,t),p(qt,e,t),s(e,sa,t),s(e,Kt,t),s(e,oa,t),s(e,Bt,t),s(e,na,t),s(e,Nt,t),s(e,ra,t),s(e,ia,t),s(e,da,t),s(e,Qt,t),s(e,aa,t),p(Vt,e,t),s(e,ua,t),s(e,St,t),s(e,ma,t),s(e,Ot,t),s(e,pa,t),s(e,Ft,t),s(e,ca,t),s(e,Ta,t),s(e,fa,t),s(e,Yt,t),s(e,ha,t),p(Wt,e,t),s(e,_a,t),s(e,Gt,t),s(e,$a,t),s(e,Xt,t),s(e,ba,t),s(e,Zt,t),s(e,va,t),s(e,ya,t),s(e,Ma,t),s(e,el,t),s(e,xa,t),p(tl,e,t),s(e,Ca,t),s(e,ll,t),s(e,Ha,t),s(e,sl,t),s(e,La,t),s(e,ol,t),s(e,wa,t),s(e,Aa,t),s(e,ga,t),s(e,nl,t),s(e,Pa,t),p(rl,e,t),s(e,za,t),s(e,il,t),s(e,Ua,t),s(e,dl,t),s(e,Ra,t),s(e,al,t),s(e,ka,t),s(e,ja,t),s(e,Ja,t),s(e,ul,t),s(e,Ea,t),p(ml,e,t),s(e,Da,t),s(e,pl,t),s(e,Ia,t),s(e,cl,t),s(e,qa,t),s(e,Tl,t),s(e,Ka,t),s(e,Ba,t),s(e,Na,t),s(e,fl,t),s(e,Qa,t),p(hl,e,t),s(e,Va,t),s(e,_l,t),s(e,Sa,t),s(e,$l,t),s(e,Oa,t),s(e,Fa,t),s(e,Ya,t),s(e,bl,t),s(e,Wa,t),p(vl,e,t),s(e,Ga,t),s(e,yl,t),s(e,Xa,t),s(e,Ml,t),s(e,Za,t),s(e,xl,t),s(e,eu,t),s(e,Cl,t),s(e,tu,t),s(e,lu,t),s(e,su,t),s(e,Hl,t),s(e,ou,t),p(Ll,e,t),s(e,nu,t),s(e,wl,t),s(e,ru,t),s(e,Al,t),s(e,iu,t),s(e,du,t),s(e,au,t),s(e,gl,t),s(e,uu,t),p(Pl,e,t),s(e,mu,t),s(e,zl,t),s(e,pu,t),s(e,Ul,t),s(e,cu,t),s(e,Rl,t),s(e,Tu,t),s(e,kl,t),s(e,fu,t),s(e,hu,t),s(e,_u,t),s(e,jl,t),s(e,$u,t),p(Jl,e,t),s(e,bu,t),s(e,El,t),s(e,vu,t),s(e,Dl,t),s(e,yu,t),s(e,Mu,t),s(e,xu,t),s(e,Il,t),s(e,Cu,t),p(ql,e,t),s(e,Hu,t),s(e,Kl,t),s(e,Lu,t),s(e,Bl,t),s(e,wu,t),s(e,Au,t),s(e,gu,t),s(e,Nl,t),s(e,Pu,t),p(Ql,e,t),s(e,zu,t),s(e,Vl,t),s(e,Uu,t),s(e,Sl,t),s(e,Ru,t),s(e,Ol,t),s(e,ku,t),s(e,ju,t),s(e,Ju,t),s(e,Fl,t),s(e,Eu,t),p(Yl,e,t),s(e,Du,t),s(e,Wl,t),s(e,Iu,t),s(e,Gl,t),s(e,qu,t),s(e,Xl,t),s(e,Ku,t),s(e,Bu,t),s(e,Nu,t),s(e,Zl,t),s(e,Qu,t),p(es,e,t),s(e,Vu,t),s(e,ts,t),s(e,Su,t),s(e,ls,t),s(e,Ou,t),s(e,Fu,t),s(e,Yu,t),s(e,ss,t),s(e,Wu,t),p(os,e,t),s(e,Gu,t),s(e,ns,t),s(e,Xu,t),s(e,rs,t),s(e,Zu,t),s(e,is,t),s(e,em,t),s(e,tm,t),s(e,lm,t),s(e,ds,t),s(e,sm,t),p(as,e,t),s(e,om,t),s(e,us,t),s(e,nm,t),s(e,ms,t),s(e,rm,t),s(e,im,t),s(e,dm,t),s(e,ps,t),s(e,am,t),p(cs,e,t),s(e,um,t),s(e,Ts,t),s(e,mm,t),s(e,fs,t),s(e,pm,t),s(e,cm,t),s(e,Tm,t),s(e,hs,t),s(e,fm,t),p(_s,e,t),s(e,hm,t),s(e,$s,t),s(e,_m,t),s(e,bs,t),s(e,$m,t),s(e,vs,t),s(e,bm,t),s(e,vm,t),s(e,ym,t),s(e,ys,t),s(e,Mm,t),p(Ms,e,t),s(e,xm,t),s(e,xs,t),s(e,Cm,t),s(e,Cs,t),s(e,Hm,t),s(e,Hs,t),s(e,Lm,t),s(e,wm,t),s(e,Am,t),s(e,Ls,t),s(e,gm,t),p(ws,e,t),s(e,Pm,t),s(e,As,t),s(e,zm,t),s(e,gs,t),s(e,Um,t),s(e,Ps,t),s(e,Rm,t),s(e,km,t),s(e,jm,t),s(e,zs,t),s(e,Jm,t),p(Us,e,t),s(e,Em,t),s(e,Rs,t),s(e,Dm,t),s(e,ks,t),s(e,Im,t),s(e,js,t),s(e,qm,t),s(e,Km,t),s(e,Bm,t),s(e,Js,t),s(e,Nm,t),p(Es,e,t),s(e,Qm,t),s(e,Ds,t),s(e,Vm,t),s(e,Is,t),s(e,Sm,t),s(e,qs,t),s(e,Om,t),s(e,Fm,t),s(e,Ym,t),s(e,Ks,t),s(e,Wm,t),p(Bs,e,t),s(e,Gm,t),s(e,Ns,t),s(e,Xm,t),s(e,Qs,t),s(e,Zm,t),s(e,Vs,t),s(e,ep,t),s(e,tp,t),s(e,lp,t),s(e,Ss,t),s(e,sp,t),p(Os,e,t),s(e,op,t),s(e,Fs,t),s(e,np,t),s(e,Ys,t),s(e,rp,t),s(e,Ws,t),s(e,ip,t),s(e,dp,t),s(e,ap,t),s(e,Gs,t),s(e,up,t),p(Xs,e,t),s(e,mp,t),s(e,Zs,t),s(e,pp,t),s(e,eo,t),s(e,cp,t),s(e,to,t),s(e,Tp,t),s(e,fp,t),s(e,hp,t),s(e,lo,t),s(e,_p,t),p(so,e,t),s(e,$p,t),s(e,oo,t),s(e,bp,t),s(e,no,t),s(e,vp,t),s(e,ro,t),s(e,yp,t),s(e,Mp,t),s(e,xp,t),s(e,io,t),s(e,Cp,t),p(ao,e,t),s(e,Hp,t),s(e,uo,t),s(e,Lp,t),s(e,mo,t),s(e,wp,t),s(e,po,t),s(e,Ap,t),s(e,gp,t),s(e,Pp,t),s(e,co,t),s(e,zp,t),p(To,e,t),s(e,Up,t),s(e,fo,t),s(e,Rp,t),s(e,ho,t),s(e,kp,t),s(e,_o,t),s(e,jp,t),s(e,Jp,t),s(e,Ep,t),s(e,$o,t),s(e,Dp,t),p(bo,e,t),s(e,Ip,t),s(e,vo,t),s(e,qp,t),s(e,yo,t),s(e,Kp,t),s(e,Mo,t),s(e,Bp,t),s(e,Np,t),s(e,Qp,t),s(e,xo,t),s(e,Vp,t),p(Co,e,t),s(e,Sp,t),s(e,Ho,t),s(e,Op,t),s(e,Lo,t),s(e,Fp,t),s(e,wo,t),s(e,Yp,t),s(e,Wp,t),s(e,Gp,t),s(e,Ao,t),s(e,Xp,t),p(go,e,t),s(e,Zp,t),s(e,Po,t),s(e,ec,t),s(e,zo,t),s(e,tc,t),s(e,Uo,t),s(e,lc,t),s(e,sc,t),s(e,oc,t),s(e,Ro,t),s(e,nc,t),p(ko,e,t),s(e,rc,t),s(e,jo,t),s(e,ic,t),s(e,Jo,t),s(e,dc,t),s(e,Eo,t),s(e,ac,t),s(e,uc,t),s(e,mc,t),s(e,Do,t),s(e,pc,t),p(Io,e,t),s(e,cc,t),s(e,qo,t),s(e,Tc,t),s(e,Ko,t),s(e,fc,t),s(e,Bo,t),s(e,hc,t),s(e,_c,t),s(e,$c,t),s(e,No,t),s(e,bc,t),p(Qo,e,t),s(e,vc,t),s(e,Vo,t),s(e,yc,t),s(e,So,t),s(e,Mc,t),s(e,Oo,t),s(e,xc,t),s(e,Cc,t),s(e,Hc,t),s(e,Fo,t),s(e,Lc,t),p(Yo,e,t),s(e,wc,t),s(e,Wo,t),s(e,Ac,t),s(e,Go,t),s(e,gc,t),s(e,Xo,t),s(e,Pc,t),s(e,zc,t),s(e,Uc,t),s(e,Zo,t),s(e,Rc,t),p(en,e,t),s(e,kc,t),s(e,tn,t),s(e,jc,t),s(e,ln,t),s(e,Jc,t),s(e,sn,t),s(e,Ec,t),s(e,Dc,t),s(e,Ic,t),s(e,on,t),s(e,qc,t),p(nn,e,t),s(e,Kc,t),s(e,rn,t),s(e,Bc,t),s(e,Nc,t),s(e,Qc,t),s(e,dn,t),s(e,Vc,t),p(an,e,t),s(e,Sc,t),s(e,un,t),s(e,Oc,t),s(e,mn,t),s(e,Fc,t),s(e,pn,t),s(e,Yc,t),s(e,cn,t),s(e,Wc,t),p(Tn,e,t),s(e,Gc,t),s(e,Xc,t),s(e,Zc,t),s(e,fn,t),s(e,eT,t),p(hn,e,t),s(e,tT,t),s(e,_n,t),s(e,lT,t),s(e,sT,t),s(e,oT,t),s(e,$n,t),s(e,nT,t),p(bn,e,t),s(e,rT,t),s(e,vn,t),s(e,iT,t),s(e,dT,t),s(e,aT,t),s(e,yn,t),s(e,uT,t),p(Mn,e,t),s(e,mT,t),s(e,xn,t),s(e,pT,t),s(e,Cn,t),s(e,cT,t),p(Hn,e,t),s(e,TT,t),s(e,Ln,t),s(e,fT,t),p(wn,e,t),s(e,hT,t),s(e,An,t),s(e,_T,t),p(gn,e,t),s(e,$T,t),s(e,bT,t),s(e,vT,t),p(Pn,e,t),s(e,yT,t),s(e,Rn,t),MT=!0},p:X1,i(e){MT||(c(v.$$.fragment,e),c(H.$$.fragment,e),c(g.$$.fragment,e),c(R.$$.fragment,e),c(E.$$.fragment,e),c(K.$$.fragment,e),c(V.$$.fragment,e),c(Y.$$.fragment,e),c(Z.$$.fragment,e),c(se.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(He.$$.fragment,e),c(ge.$$.fragment,e),c(Re.$$.fragment,e),c(De.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(Ze.$$.fragment,e),c(ot.$$.fragment,e),c(at.$$.fragment,e),c(Tt.$$.fragment,e),c(bt.$$.fragment,e),c(Ct.$$.fragment,e),c(gt.$$.fragment,e),c(Rt.$$.fragment,e),c(Jt.$$.fragment,e),c(Dt.$$.fragment,e),c(qt.$$.fragment,e),c(Vt.$$.fragment,e),c(Wt.$$.fragment,e),c(tl.$$.fragment,e),c(rl.$$.fragment,e),c(ml.$$.fragment,e),c(hl.$$.fragment,e),c(vl.$$.fragment,e),c(Ll.$$.fragment,e),c(Pl.$$.fragment,e),c(Jl.$$.fragment,e),c(ql.$$.fragment,e),c(Ql.$$.fragment,e),c(Yl.$$.fragment,e),c(es.$$.fragment,e),c(os.$$.fragment,e),c(as.$$.fragment,e),c(cs.$$.fragment,e),c(_s.$$.fragment,e),c(Ms.$$.fragment,e),c(ws.$$.fragment,e),c(Us.$$.fragment,e),c(Es.$$.fragment,e),c(Bs.$$.fragment,e),c(Os.$$.fragment,e),c(Xs.$$.fragment,e),c(so.$$.fragment,e),c(ao.$$.fragment,e),c(To.$$.fragment,e),c(bo.$$.fragment,e),c(Co.$$.fragment,e),c(go.$$.fragment,e),c(ko.$$.fragment,e),c(Io.$$.fragment,e),c(Qo.$$.fragment,e),c(Yo.$$.fragment,e),c(en.$$.fragment,e),c(nn.$$.fragment,e),c(an.$$.fragment,e),c(Tn.$$.fragment,e),c(hn.$$.fragment,e),c(bn.$$.fragment,e),c(Mn.$$.fragment,e),c(Hn.$$.fragment,e),c(wn.$$.fragment,e),c(gn.$$.fragment,e),c(Pn.$$.fragment,e),MT=!0)},o(e){T(v.$$.fragment,e),T(H.$$.fragment,e),T(g.$$.fragment,e),T(R.$$.fragment,e),T(E.$$.fragment,e),T(K.$$.fragment,e),T(V.$$.fragment,e),T(Y.$$.fragment,e),T(Z.$$.fragment,e),T(se.$$.fragment,e),T(de.$$.fragment,e),T(pe.$$.fragment,e),T(he.$$.fragment,e),T(ye.$$.fragment,e),T(He.$$.fragment,e),T(ge.$$.fragment,e),T(Re.$$.fragment,e),T(De.$$.fragment,e),T(Ne.$$.fragment,e),T(Fe.$$.fragment,e),T(Ze.$$.fragment,e),T(ot.$$.fragment,e),T(at.$$.fragment,e),T(Tt.$$.fragment,e),T(bt.$$.fragment,e),T(Ct.$$.fragment,e),T(gt.$$.fragment,e),T(Rt.$$.fragment,e),T(Jt.$$.fragment,e),T(Dt.$$.fragment,e),T(qt.$$.fragment,e),T(Vt.$$.fragment,e),T(Wt.$$.fragment,e),T(tl.$$.fragment,e),T(rl.$$.fragment,e),T(ml.$$.fragment,e),T(hl.$$.fragment,e),T(vl.$$.fragment,e),T(Ll.$$.fragment,e),T(Pl.$$.fragment,e),T(Jl.$$.fragment,e),T(ql.$$.fragment,e),T(Ql.$$.fragment,e),T(Yl.$$.fragment,e),T(es.$$.fragment,e),T(os.$$.fragment,e),T(as.$$.fragment,e),T(cs.$$.fragment,e),T(_s.$$.fragment,e),T(Ms.$$.fragment,e),T(ws.$$.fragment,e),T(Us.$$.fragment,e),T(Es.$$.fragment,e),T(Bs.$$.fragment,e),T(Os.$$.fragment,e),T(Xs.$$.fragment,e),T(so.$$.fragment,e),T(ao.$$.fragment,e),T(To.$$.fragment,e),T(bo.$$.fragment,e),T(Co.$$.fragment,e),T(go.$$.fragment,e),T(ko.$$.fragment,e),T(Io.$$.fragment,e),T(Qo.$$.fragment,e),T(Yo.$$.fragment,e),T(en.$$.fragment,e),T(nn.$$.fragment,e),T(an.$$.fragment,e),T(Tn.$$.fragment,e),T(hn.$$.fragment,e),T(bn.$$.fragment,e),T(Mn.$$.fragment,e),T(Hn.$$.fragment,e),T(wn.$$.fragment,e),T(gn.$$.fragment,e),T(Pn.$$.fragment,e),MT=!1},d(e){e&&(l(kn),l(Un),l(jn),l(b),l(Jn),l(En),l(y),l(Dn),l(M),l(In),l(x),l(qn),l(Kn),l(Bn),l(C),l(Nn),l(Qn),l(L),l(Vn),l(w),l(Sn),l(On),l(Fn),l(A),l(Yn),l(Wn),l(P),l(Gn),l(z),l(Xn),l(Zn),l(er),l(U),l(tr),l(lr),l(k),l(sr),l(j),l(or),l(nr),l(rr),l(J),l(ir),l(dr),l(D),l(ar),l(I),l(ur),l(mr),l(pr),l(q),l(cr),l(Tr),l(B),l(fr),l(N),l(hr),l(_r),l($r),l(Q),l(br),l(vr),l(S),l(yr),l(O),l(Mr),l(xr),l(Cr),l(F),l(Hr),l(Lr),l(W),l(wr),l(G),l(Ar),l(gr),l(Pr),l(X),l(zr),l(Ur),l(ee),l(Rr),l(te),l(kr),l(jr),l(Jr),l(le),l(Er),l(Dr),l(oe),l(Ir),l(ne),l(qr),l(re),l(Kr),l(Br),l(Nr),l(ie),l(Qr),l(Vr),l(ae),l(Sr),l(ue),l(Or),l(Fr),l(Yr),l(me),l(Wr),l(Gr),l(ce),l(Xr),l(Te),l(Zr),l(ei),l(ti),l(fe),l(li),l(si),l(_e),l(oi),l($e),l(ni),l(be),l(ri),l(ii),l(di),l(ve),l(ai),l(ui),l(Me),l(mi),l(xe),l(pi),l(ci),l(Ti),l(Ce),l(fi),l(hi),l(Le),l(_i),l(we),l($i),l(bi),l(vi),l(Ae),l(yi),l(Mi),l(Pe),l(xi),l(ze),l(Ci),l(Hi),l(Li),l(Ue),l(wi),l(Ai),l(ke),l(gi),l(je),l(Pi),l(Je),l(zi),l(Ui),l(Ri),l(Ee),l(ki),l(ji),l(Ie),l(Ji),l(qe),l(Ei),l(Ke),l(Di),l(Ii),l(qi),l(Be),l(Ki),l(Bi),l(Qe),l(Ni),l(Ve),l(Qi),l(Se),l(Vi),l(Si),l(Oi),l(Oe),l(Fi),l(Yi),l(Ye),l(Wi),l(We),l(Gi),l(Ge),l(Xi),l(Zi),l(ed),l(Xe),l(td),l(ld),l(et),l(sd),l(tt),l(od),l(lt),l(nd),l(rd),l(id),l(st),l(dd),l(ad),l(nt),l(ud),l(rt),l(md),l(it),l(pd),l(cd),l(Td),l(dt),l(fd),l(hd),l(ut),l(_d),l(mt),l($d),l(pt),l(bd),l(vd),l(yd),l(ct),l(Md),l(xd),l(ft),l(Cd),l(ht),l(Hd),l(_t),l(Ld),l(wd),l(Ad),l($t),l(gd),l(Pd),l(vt),l(zd),l(yt),l(Ud),l(Mt),l(Rd),l(kd),l(jd),l(xt),l(Jd),l(Ed),l(Ht),l(Dd),l(Lt),l(Id),l(wt),l(qd),l(Kd),l(Bd),l(At),l(Nd),l(Qd),l(Pt),l(Vd),l(zt),l(Sd),l(Od),l(Fd),l(Ut),l(Yd),l(Wd),l(kt),l(Gd),l(jt),l(Xd),l(Zd),l(Et),l(ea),l(ta),l(It),l(la),l(sa),l(Kt),l(oa),l(Bt),l(na),l(Nt),l(ra),l(ia),l(da),l(Qt),l(aa),l(ua),l(St),l(ma),l(Ot),l(pa),l(Ft),l(ca),l(Ta),l(fa),l(Yt),l(ha),l(_a),l(Gt),l($a),l(Xt),l(ba),l(Zt),l(va),l(ya),l(Ma),l(el),l(xa),l(Ca),l(ll),l(Ha),l(sl),l(La),l(ol),l(wa),l(Aa),l(ga),l(nl),l(Pa),l(za),l(il),l(Ua),l(dl),l(Ra),l(al),l(ka),l(ja),l(Ja),l(ul),l(Ea),l(Da),l(pl),l(Ia),l(cl),l(qa),l(Tl),l(Ka),l(Ba),l(Na),l(fl),l(Qa),l(Va),l(_l),l(Sa),l($l),l(Oa),l(Fa),l(Ya),l(bl),l(Wa),l(Ga),l(yl),l(Xa),l(Ml),l(Za),l(xl),l(eu),l(Cl),l(tu),l(lu),l(su),l(Hl),l(ou),l(nu),l(wl),l(ru),l(Al),l(iu),l(du),l(au),l(gl),l(uu),l(mu),l(zl),l(pu),l(Ul),l(cu),l(Rl),l(Tu),l(kl),l(fu),l(hu),l(_u),l(jl),l($u),l(bu),l(El),l(vu),l(Dl),l(yu),l(Mu),l(xu),l(Il),l(Cu),l(Hu),l(Kl),l(Lu),l(Bl),l(wu),l(Au),l(gu),l(Nl),l(Pu),l(zu),l(Vl),l(Uu),l(Sl),l(Ru),l(Ol),l(ku),l(ju),l(Ju),l(Fl),l(Eu),l(Du),l(Wl),l(Iu),l(Gl),l(qu),l(Xl),l(Ku),l(Bu),l(Nu),l(Zl),l(Qu),l(Vu),l(ts),l(Su),l(ls),l(Ou),l(Fu),l(Yu),l(ss),l(Wu),l(Gu),l(ns),l(Xu),l(rs),l(Zu),l(is),l(em),l(tm),l(lm),l(ds),l(sm),l(om),l(us),l(nm),l(ms),l(rm),l(im),l(dm),l(ps),l(am),l(um),l(Ts),l(mm),l(fs),l(pm),l(cm),l(Tm),l(hs),l(fm),l(hm),l($s),l(_m),l(bs),l($m),l(vs),l(bm),l(vm),l(ym),l(ys),l(Mm),l(xm),l(xs),l(Cm),l(Cs),l(Hm),l(Hs),l(Lm),l(wm),l(Am),l(Ls),l(gm),l(Pm),l(As),l(zm),l(gs),l(Um),l(Ps),l(Rm),l(km),l(jm),l(zs),l(Jm),l(Em),l(Rs),l(Dm),l(ks),l(Im),l(js),l(qm),l(Km),l(Bm),l(Js),l(Nm),l(Qm),l(Ds),l(Vm),l(Is),l(Sm),l(qs),l(Om),l(Fm),l(Ym),l(Ks),l(Wm),l(Gm),l(Ns),l(Xm),l(Qs),l(Zm),l(Vs),l(ep),l(tp),l(lp),l(Ss),l(sp),l(op),l(Fs),l(np),l(Ys),l(rp),l(Ws),l(ip),l(dp),l(ap),l(Gs),l(up),l(mp),l(Zs),l(pp),l(eo),l(cp),l(to),l(Tp),l(fp),l(hp),l(lo),l(_p),l($p),l(oo),l(bp),l(no),l(vp),l(ro),l(yp),l(Mp),l(xp),l(io),l(Cp),l(Hp),l(uo),l(Lp),l(mo),l(wp),l(po),l(Ap),l(gp),l(Pp),l(co),l(zp),l(Up),l(fo),l(Rp),l(ho),l(kp),l(_o),l(jp),l(Jp),l(Ep),l($o),l(Dp),l(Ip),l(vo),l(qp),l(yo),l(Kp),l(Mo),l(Bp),l(Np),l(Qp),l(xo),l(Vp),l(Sp),l(Ho),l(Op),l(Lo),l(Fp),l(wo),l(Yp),l(Wp),l(Gp),l(Ao),l(Xp),l(Zp),l(Po),l(ec),l(zo),l(tc),l(Uo),l(lc),l(sc),l(oc),l(Ro),l(nc),l(rc),l(jo),l(ic),l(Jo),l(dc),l(Eo),l(ac),l(uc),l(mc),l(Do),l(pc),l(cc),l(qo),l(Tc),l(Ko),l(fc),l(Bo),l(hc),l(_c),l($c),l(No),l(bc),l(vc),l(Vo),l(yc),l(So),l(Mc),l(Oo),l(xc),l(Cc),l(Hc),l(Fo),l(Lc),l(wc),l(Wo),l(Ac),l(Go),l(gc),l(Xo),l(Pc),l(zc),l(Uc),l(Zo),l(Rc),l(kc),l(tn),l(jc),l(ln),l(Jc),l(sn),l(Ec),l(Dc),l(Ic),l(on),l(qc),l(Kc),l(rn),l(Bc),l(Nc),l(Qc),l(dn),l(Vc),l(Sc),l(un),l(Oc),l(mn),l(Fc),l(pn),l(Yc),l(cn),l(Wc),l(Gc),l(Xc),l(Zc),l(fn),l(eT),l(tT),l(_n),l(lT),l(sT),l(oT),l($n),l(nT),l(rT),l(vn),l(iT),l(dT),l(aT),l(yn),l(uT),l(mT),l(xn),l(pT),l(Cn),l(cT),l(TT),l(Ln),l(fT),l(hT),l(An),l(_T),l($T),l(bT),l(vT),l(yT),l(Rn)),l($),f(v,e),f(H,e),f(g,e),f(R,e),f(E,e),f(K,e),f(V,e),f(Y,e),f(Z,e),f(se,e),f(de,e),f(pe,e),f(he,e),f(ye,e),f(He,e),f(ge,e),f(Re,e),f(De,e),f(Ne,e),f(Fe,e),f(Ze,e),f(ot,e),f(at,e),f(Tt,e),f(bt,e),f(Ct,e),f(gt,e),f(Rt,e),f(Jt,e),f(Dt,e),f(qt,e),f(Vt,e),f(Wt,e),f(tl,e),f(rl,e),f(ml,e),f(hl,e),f(vl,e),f(Ll,e),f(Pl,e),f(Jl,e),f(ql,e),f(Ql,e),f(Yl,e),f(es,e),f(os,e),f(as,e),f(cs,e),f(_s,e),f(Ms,e),f(ws,e),f(Us,e),f(Es,e),f(Bs,e),f(Os,e),f(Xs,e),f(so,e),f(ao,e),f(To,e),f(bo,e),f(Co,e),f(go,e),f(ko,e),f(Io,e),f(Qo,e),f(Yo,e),f(en,e),f(nn,e),f(an,e),f(Tn,e),f(hn,e),f(bn,e),f(Mn,e),f(Hn,e),f(wn,e),f(gn,e),f(Pn,e)}}}const r_='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.location : <code> string </code>","local":"tensorlocation--code-string-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map_(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div_(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub_(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clone() ⇒ <code> Tensor </code>","local":"tensorclone--code-tensor-code","sections":[],"depth":3},{"title":"tensor.slice(...slices) ⇒ <code> Tensor </code>","local":"tensorsliceslices--code-tensor-code","sections":[],"depth":3},{"title":"tensor.permute(...dims) ⇒ <code> Tensor </code>","local":"tensorpermutedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒ <code> Tensor </code>","local":"tensorsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>","local":"tensorunsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>","local":"tensorflattenstartdim-enddim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒ <code> Tensor </code>","local":"tensorclampmin-max--code-tensor-code","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒ <code> Tensor </code>","local":"tensorround--code-tensor-code","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensorpermutetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorinterpolate4dinput-options--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensormatmula-b--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorrfftx-a--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.topk(x, k) ⇒ <code> * </code>","local":"utilstensortopkx-k--code--code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>","local":"utilstensormeaninput-dim-keepdim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>","local":"utilstensorfullsize-fillvalue--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones(size) ⇒ <code> Tensor </code>","local":"utilstensoronessize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensoronesliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros(size) ⇒ <code> Tensor </code>","local":"utilstensorzerossize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensorzerosliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>","local":"utilstensorquantizeembeddingstensor-precision--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> ONNXTensor </code>","local":"utilstensorargs0--code-onnxtensor-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function i_(xT){return Z1(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class p_ extends e_{constructor($){super(),t_(this,$,i_,n_,G1,{})}}export{p_ as component};
