import{s as si,n as ri,o as ni}from"../chunks/scheduler.0219f8bd.js";import{S as gi,i as ui,g as d,s as i,r as n,A as ci,h as o,f as a,c as m,j as g,u,x as s,k as r,y as pi,a as l,v as c,d as p,t as f,w}from"../chunks/index.f61edf3b.js";import{C as fi}from"../chunks/CodeBlock.38e566ae.js";import{H as h,E as wi}from"../chunks/EditOnGithub.48fa589f.js";function hi(pl){let R,Qe,Fe,Xe,I,et,$,tt,v,fl="Helper module for image processing.",at,_,wl=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,lt,T,hl='<li><a href="#module_utils/image">utils/image</a><ul><li><em>static</em><ul><li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+split"><code>.split()</code></a> ⇒ <code>Array.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromCanvas"><code>.fromCanvas(canvas)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/image..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li></ul></li></ul></li>',it,mt,dt,b,ot,C,st,x,Rl='<strong>Kind</strong>: static class of <a href="#module_utils/image"><code>utils/image</code></a>',rt,H,Il='<li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+split"><code>.split()</code></a> ⇒ <code>Array.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromCanvas"><code>.fromCanvas(canvas)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li>',nt,gt,ut,L,ct,y,pt,M,$l="Create a new <code>RawImage</code> object.",ft,P,vl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Uint8ClampedArray</code> | <code>Uint8Array</code></td><td><p>The pixel data.</p></td> </tr><tr><td>width</td><td><code>number</code></td><td><p>The width of the image.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the image.</p></td> </tr><tr><td>channels</td><td><code>1</code> | <code>2</code> | <code>3</code> | <code>4</code></td><td><p>The number of channels.</p></td></tr></tbody>",wt,ht,Rt,A,It,E,$t,z,_l="Returns the size of the image (width, height).",vt,j,Tl='<strong>Kind</strong>: instance property of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The size of the image (width, height).',_t,Tt,bt,U,Ct,B,xt,K,bl="Convert the image to grayscale format.",Ht,k,Cl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',Lt,yt,Mt,Y,Pt,J,At,N,xl="Convert the image to RGB format.",Et,q,Hl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',zt,jt,Ut,G,Bt,S,Kt,O,Ll="Convert the image to RGBA format.",kt,Z,yl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',Yt,Jt,Nt,D,qt,W,Gt,F,Ml="Resize the image to the given dimensions. This method uses the canvas API to perform the resizing.",St,V,Pl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - <code>this</code> to support chaining.',Ot,Q,Al="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>width</td><td><code>number</code></td><td><p>The width of the new image. <code>null</code> or <code>-1</code> will preserve the aspect ratio.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the new image. <code>null</code> or <code>-1</code> will preserve the aspect ratio.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>Additional options for resizing.</p></td> </tr><tr><td>[options.resample]</td><td><code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code> | <code>string</code></td><td><p>The resampling method to use.</p></td></tr></tbody>",Zt,Dt,Wt,X,Ft,ee,Vt,te,El=`Split this image into individual bands. This method returns an array of individual image bands from an image.
For example, splitting an “RGB” image creates three new images each containing a copy of one of the original bands (red, green, blue).`,Qt,ae,zl='Inspired by PIL’s <code>Image.split()</code> <a href="https://pillow.readthedocs.io/en/latest/reference/Image.html#PIL.Image.Image.split" rel="nofollow">function</a>.',Xt,le,jl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;RawImage&gt;</code> - An array containing bands.',ea,ta,aa,ie,la,me,ia,de,Ul="Clone the image",ma,oe,Bl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - The cloned image',da,oa,sa,se,ra,re,na,ne,Kl="Helper method for converting image to have a certain number of channels",ga,ge,kl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',ua,ue,Yl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>numChannels</td><td><code>number</code></td><td><p>The number of channels. Must be 1, 3, or 4.</p></td></tr></tbody>",ca,pa,fa,ce,wa,pe,ha,fe,Jl="Save the image to the given path.",Ra,we,Nl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',Ia,he,ql="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td><td><p>The path to save the image to.</p></td></tr></tbody>",$a,va,_a,Re,Ta,Ie,ba,$e,Gl="Helper method for reading an image from a variety of input types.",Ca,ve,Sl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The image object.',xa,_e,Ol="<strong>Example:</strong> Read image from a URL.",Ha,Te,La,be,Zl="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>RawImage</code> | <code>string</code> | <code>URL</code></td></tr></tbody>",ya,Ma,Pa,Ce,Aa,xe,Ea,He,Dl="Read an image from a canvas.",za,Le,Wl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - The image object.',ja,ye,Fl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>canvas</td><td><code>HTMLCanvasElement</code> | <code>OffscreenCanvas</code></td><td><p>The canvas to read the image from.</p></td></tr></tbody>",Ua,Ba,Ka,Me,ka,Pe,Ya,Ae,Vl="Read an image from a URL or file path.",Ja,Ee,Ql='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',Na,ze,Xl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>url</td><td><code>string</code> | <code>URL</code></td><td><p>The URL or file path to read the image from.</p></td></tr></tbody>",qa,Ga,Sa,je,Oa,Ue,Za,Be,ei="Helper method to create a new Image from a blob.",Da,Ke,ti='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',Wa,ke,ai="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>blob</td><td><code>Blob</code></td><td><p>The blob to read the image from.</p></td></tr></tbody>",Fa,Va,Qa,Ye,Xa,Je,el,Ne,li="Helper method to create a new Image from a tensor",tl,qe,ii='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',al,Ge,mi="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td></tr></tbody>",ll,il,ml,Se,dl,Oe,ol,Ze,di="Mapping from file extensions to MIME types.",sl,De,oi='<strong>Kind</strong>: inner constant of <a href="#module_utils/image"><code>utils/image</code></a>',rl,nl,gl,We,ul,Ve,cl;return $=new h({props:{title:"utils/image",local:"utilsimage",headingTag:"h1"}}),C=new h({props:{title:"utils/image.RawImage",local:"utilsimagerawimage",headingTag:"h2"}}),y=new h({props:{title:"new RawImage(data, width, height, channels)",local:"new-rawimagedata-width-height-channels",headingTag:"h3"}}),E=new h({props:{title:"rawImage.size ⇒ <code> * </code>",local:"rawimagesize--code--code",headingTag:"h3"}}),B=new h({props:{title:"rawImage.grayscale() ⇒ <code> RawImage </code>",local:"rawimagegrayscale--code-rawimage-code",headingTag:"h3"}}),J=new h({props:{title:"rawImage.rgb() ⇒ <code> RawImage </code>",local:"rawimagergb--code-rawimage-code",headingTag:"h3"}}),S=new h({props:{title:"rawImage.rgba() ⇒ <code> RawImage </code>",local:"rawimagergba--code-rawimage-code",headingTag:"h3"}}),W=new h({props:{title:"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>",local:"rawimageresizewidth-height-options--code-promise--rawimage--code",headingTag:"h3"}}),ee=new h({props:{title:"rawImage.split() ⇒ <code> Array. < RawImage > </code>",local:"rawimagesplit--code-array--rawimage--code",headingTag:"h3"}}),me=new h({props:{title:"rawImage.clone() ⇒ <code> RawImage </code>",local:"rawimageclone--code-rawimage-code",headingTag:"h3"}}),re=new h({props:{title:"rawImage.convert(numChannels) ⇒ <code> RawImage </code>",local:"rawimageconvertnumchannels--code-rawimage-code",headingTag:"h3"}}),pe=new h({props:{title:"rawImage.save(path)",local:"rawimagesavepath",headingTag:"h3"}}),Ie=new h({props:{title:"RawImage.read(input) ⇒ <code> * </code>",local:"rawimagereadinput--code--code",headingTag:"h3"}}),Te=new fi({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjBhd2FpdCUyMFJhd0ltYWdlLnJlYWQoJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmb290YmFsbC1tYXRjaC5qcGcnKSUzQiUwQSUyRiUyRiUyMFJhd0ltYWdlJTIw",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-comment">// RawImage </span>`,wrap:!1}}),xe=new h({props:{title:"RawImage.fromCanvas(canvas) ⇒ <code> RawImage </code>",local:"rawimagefromcanvascanvas--code-rawimage-code",headingTag:"h3"}}),Pe=new h({props:{title:"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromurlurl--code-promise--rawimage--code",headingTag:"h3"}}),Ue=new h({props:{title:"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromblobblob--code-promise--rawimage--code",headingTag:"h3"}}),Je=new h({props:{title:"RawImage.fromTensor(tensor)",local:"rawimagefromtensortensor",headingTag:"h3"}}),Oe=new h({props:{title:"utils/image~CONTENT_TYPE_MAP",local:"utilsimagecontenttypemap",headingTag:"h2"}}),We=new wi({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/image.md"}}),{c(){R=d("meta"),Qe=i(),Fe=d("p"),Xe=i(),I=d("a"),et=i(),n($.$$.fragment),tt=i(),v=d("p"),v.textContent=fl,at=i(),_=d("p"),_.textContent=wl,lt=i(),T=d("ul"),T.innerHTML=hl,it=i(),mt=d("hr"),dt=i(),b=d("a"),ot=i(),n(C.$$.fragment),st=i(),x=d("p"),x.innerHTML=Rl,rt=i(),H=d("ul"),H.innerHTML=Il,nt=i(),gt=d("hr"),ut=i(),L=d("a"),ct=i(),n(y.$$.fragment),pt=i(),M=d("p"),M.innerHTML=$l,ft=i(),P=d("table"),P.innerHTML=vl,wt=i(),ht=d("hr"),Rt=i(),A=d("a"),It=i(),n(E.$$.fragment),$t=i(),z=d("p"),z.textContent=_l,vt=i(),j=d("p"),j.innerHTML=Tl,_t=i(),Tt=d("hr"),bt=i(),U=d("a"),Ct=i(),n(B.$$.fragment),xt=i(),K=d("p"),K.textContent=bl,Ht=i(),k=d("p"),k.innerHTML=Cl,Lt=i(),yt=d("hr"),Mt=i(),Y=d("a"),Pt=i(),n(J.$$.fragment),At=i(),N=d("p"),N.textContent=xl,Et=i(),q=d("p"),q.innerHTML=Hl,zt=i(),jt=d("hr"),Ut=i(),G=d("a"),Bt=i(),n(S.$$.fragment),Kt=i(),O=d("p"),O.textContent=Ll,kt=i(),Z=d("p"),Z.innerHTML=yl,Yt=i(),Jt=d("hr"),Nt=i(),D=d("a"),qt=i(),n(W.$$.fragment),Gt=i(),F=d("p"),F.textContent=Ml,St=i(),V=d("p"),V.innerHTML=Pl,Ot=i(),Q=d("table"),Q.innerHTML=Al,Zt=i(),Dt=d("hr"),Wt=i(),X=d("a"),Ft=i(),n(ee.$$.fragment),Vt=i(),te=d("p"),te.textContent=El,Qt=i(),ae=d("p"),ae.innerHTML=zl,Xt=i(),le=d("p"),le.innerHTML=jl,ea=i(),ta=d("hr"),aa=i(),ie=d("a"),la=i(),n(me.$$.fragment),ia=i(),de=d("p"),de.textContent=Ul,ma=i(),oe=d("p"),oe.innerHTML=Bl,da=i(),oa=d("hr"),sa=i(),se=d("a"),ra=i(),n(re.$$.fragment),na=i(),ne=d("p"),ne.textContent=Kl,ga=i(),ge=d("p"),ge.innerHTML=kl,ua=i(),ue=d("table"),ue.innerHTML=Yl,ca=i(),pa=d("hr"),fa=i(),ce=d("a"),wa=i(),n(pe.$$.fragment),ha=i(),fe=d("p"),fe.textContent=Jl,Ra=i(),we=d("p"),we.innerHTML=Nl,Ia=i(),he=d("table"),he.innerHTML=ql,$a=i(),va=d("hr"),_a=i(),Re=d("a"),Ta=i(),n(Ie.$$.fragment),ba=i(),$e=d("p"),$e.textContent=Gl,Ca=i(),ve=d("p"),ve.innerHTML=Sl,xa=i(),_e=d("p"),_e.innerHTML=Ol,Ha=i(),n(Te.$$.fragment),La=i(),be=d("table"),be.innerHTML=Zl,ya=i(),Ma=d("hr"),Pa=i(),Ce=d("a"),Aa=i(),n(xe.$$.fragment),Ea=i(),He=d("p"),He.textContent=Dl,za=i(),Le=d("p"),Le.innerHTML=Wl,ja=i(),ye=d("table"),ye.innerHTML=Fl,Ua=i(),Ba=d("hr"),Ka=i(),Me=d("a"),ka=i(),n(Pe.$$.fragment),Ya=i(),Ae=d("p"),Ae.textContent=Vl,Ja=i(),Ee=d("p"),Ee.innerHTML=Ql,Na=i(),ze=d("table"),ze.innerHTML=Xl,qa=i(),Ga=d("hr"),Sa=i(),je=d("a"),Oa=i(),n(Ue.$$.fragment),Za=i(),Be=d("p"),Be.textContent=ei,Da=i(),Ke=d("p"),Ke.innerHTML=ti,Wa=i(),ke=d("table"),ke.innerHTML=ai,Fa=i(),Va=d("hr"),Qa=i(),Ye=d("a"),Xa=i(),n(Je.$$.fragment),el=i(),Ne=d("p"),Ne.textContent=li,tl=i(),qe=d("p"),qe.innerHTML=ii,al=i(),Ge=d("table"),Ge.innerHTML=mi,ll=i(),il=d("hr"),ml=i(),Se=d("a"),dl=i(),n(Oe.$$.fragment),ol=i(),Ze=d("p"),Ze.textContent=di,sl=i(),De=d("p"),De.innerHTML=oi,rl=i(),nl=d("hr"),gl=i(),n(We.$$.fragment),ul=i(),Ve=d("p"),this.h()},l(e){const t=ci("svelte-u9bgzb",document.head);R=o(t,"META",{name:!0,content:!0}),t.forEach(a),Qe=m(e),Fe=o(e,"P",{}),g(Fe).forEach(a),Xe=m(e),I=o(e,"A",{id:!0,class:!0}),g(I).forEach(a),et=m(e),u($.$$.fragment,e),tt=m(e),v=o(e,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1uts7np"&&(v.textContent=fl),at=m(e),_=o(e,"P",{"data-svelte-h":!0}),s(_)!=="svelte-il3kl8"&&(_.textContent=wl),lt=m(e),T=o(e,"UL",{"data-svelte-h":!0}),s(T)!=="svelte-1wq802f"&&(T.innerHTML=hl),it=m(e),mt=o(e,"HR",{}),dt=m(e),b=o(e,"A",{id:!0,class:!0}),g(b).forEach(a),ot=m(e),u(C.$$.fragment,e),st=m(e),x=o(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-f7iksk"&&(x.innerHTML=Rl),rt=m(e),H=o(e,"UL",{"data-svelte-h":!0}),s(H)!=="svelte-shgyzw"&&(H.innerHTML=Il),nt=m(e),gt=o(e,"HR",{}),ut=m(e),L=o(e,"A",{id:!0,class:!0}),g(L).forEach(a),ct=m(e),u(y.$$.fragment,e),pt=m(e),M=o(e,"P",{"data-svelte-h":!0}),s(M)!=="svelte-36fe9a"&&(M.innerHTML=$l),ft=m(e),P=o(e,"TABLE",{"data-svelte-h":!0}),s(P)!=="svelte-vkeoul"&&(P.innerHTML=vl),wt=m(e),ht=o(e,"HR",{}),Rt=m(e),A=o(e,"A",{id:!0,class:!0}),g(A).forEach(a),It=m(e),u(E.$$.fragment,e),$t=m(e),z=o(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-2j0n9s"&&(z.textContent=_l),vt=m(e),j=o(e,"P",{"data-svelte-h":!0}),s(j)!=="svelte-gwg1mu"&&(j.innerHTML=Tl),_t=m(e),Tt=o(e,"HR",{}),bt=m(e),U=o(e,"A",{id:!0,class:!0}),g(U).forEach(a),Ct=m(e),u(B.$$.fragment,e),xt=m(e),K=o(e,"P",{"data-svelte-h":!0}),s(K)!=="svelte-1owjjfe"&&(K.textContent=bl),Ht=m(e),k=o(e,"P",{"data-svelte-h":!0}),s(k)!=="svelte-11e9r18"&&(k.innerHTML=Cl),Lt=m(e),yt=o(e,"HR",{}),Mt=m(e),Y=o(e,"A",{id:!0,class:!0}),g(Y).forEach(a),Pt=m(e),u(J.$$.fragment,e),At=m(e),N=o(e,"P",{"data-svelte-h":!0}),s(N)!=="svelte-qyo04e"&&(N.textContent=xl),Et=m(e),q=o(e,"P",{"data-svelte-h":!0}),s(q)!=="svelte-11e9r18"&&(q.innerHTML=Hl),zt=m(e),jt=o(e,"HR",{}),Ut=m(e),G=o(e,"A",{id:!0,class:!0}),g(G).forEach(a),Bt=m(e),u(S.$$.fragment,e),Kt=m(e),O=o(e,"P",{"data-svelte-h":!0}),s(O)!=="svelte-19kp14j"&&(O.textContent=Ll),kt=m(e),Z=o(e,"P",{"data-svelte-h":!0}),s(Z)!=="svelte-11e9r18"&&(Z.innerHTML=yl),Yt=m(e),Jt=o(e,"HR",{}),Nt=m(e),D=o(e,"A",{id:!0,class:!0}),g(D).forEach(a),qt=m(e),u(W.$$.fragment,e),Gt=m(e),F=o(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-s4dm9o"&&(F.textContent=Ml),St=m(e),V=o(e,"P",{"data-svelte-h":!0}),s(V)!=="svelte-1jh8cjr"&&(V.innerHTML=Pl),Ot=m(e),Q=o(e,"TABLE",{"data-svelte-h":!0}),s(Q)!=="svelte-h7uulu"&&(Q.innerHTML=Al),Zt=m(e),Dt=o(e,"HR",{}),Wt=m(e),X=o(e,"A",{id:!0,class:!0}),g(X).forEach(a),Ft=m(e),u(ee.$$.fragment,e),Vt=m(e),te=o(e,"P",{"data-svelte-h":!0}),s(te)!=="svelte-2m63ix"&&(te.textContent=El),Qt=m(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-k44jcf"&&(ae.innerHTML=zl),Xt=m(e),le=o(e,"P",{"data-svelte-h":!0}),s(le)!=="svelte-1jdggat"&&(le.innerHTML=jl),ea=m(e),ta=o(e,"HR",{}),aa=m(e),ie=o(e,"A",{id:!0,class:!0}),g(ie).forEach(a),la=m(e),u(me.$$.fragment,e),ia=m(e),de=o(e,"P",{"data-svelte-h":!0}),s(de)!=="svelte-1eu6jk3"&&(de.textContent=Ul),ma=m(e),oe=o(e,"P",{"data-svelte-h":!0}),s(oe)!=="svelte-1w4hta5"&&(oe.innerHTML=Bl),da=m(e),oa=o(e,"HR",{}),sa=m(e),se=o(e,"A",{id:!0,class:!0}),g(se).forEach(a),ra=m(e),u(re.$$.fragment,e),na=m(e),ne=o(e,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-5ze294"&&(ne.textContent=Kl),ga=m(e),ge=o(e,"P",{"data-svelte-h":!0}),s(ge)!=="svelte-11e9r18"&&(ge.innerHTML=kl),ua=m(e),ue=o(e,"TABLE",{"data-svelte-h":!0}),s(ue)!=="svelte-1hxqxaq"&&(ue.innerHTML=Yl),ca=m(e),pa=o(e,"HR",{}),fa=m(e),ce=o(e,"A",{id:!0,class:!0}),g(ce).forEach(a),wa=m(e),u(pe.$$.fragment,e),ha=m(e),fe=o(e,"P",{"data-svelte-h":!0}),s(fe)!=="svelte-119su55"&&(fe.textContent=Jl),Ra=m(e),we=o(e,"P",{"data-svelte-h":!0}),s(we)!=="svelte-1epyezb"&&(we.innerHTML=Nl),Ia=m(e),he=o(e,"TABLE",{"data-svelte-h":!0}),s(he)!=="svelte-1h4z9xq"&&(he.innerHTML=ql),$a=m(e),va=o(e,"HR",{}),_a=m(e),Re=o(e,"A",{id:!0,class:!0}),g(Re).forEach(a),Ta=m(e),u(Ie.$$.fragment,e),ba=m(e),$e=o(e,"P",{"data-svelte-h":!0}),s($e)!=="svelte-5659h9"&&($e.textContent=Gl),Ca=m(e),ve=o(e,"P",{"data-svelte-h":!0}),s(ve)!=="svelte-1800vfp"&&(ve.innerHTML=Sl),xa=m(e),_e=o(e,"P",{"data-svelte-h":!0}),s(_e)!=="svelte-14z54gq"&&(_e.innerHTML=Ol),Ha=m(e),u(Te.$$.fragment,e),La=m(e),be=o(e,"TABLE",{"data-svelte-h":!0}),s(be)!=="svelte-eqolu5"&&(be.innerHTML=Zl),ya=m(e),Ma=o(e,"HR",{}),Pa=m(e),Ce=o(e,"A",{id:!0,class:!0}),g(Ce).forEach(a),Aa=m(e),u(xe.$$.fragment,e),Ea=m(e),He=o(e,"P",{"data-svelte-h":!0}),s(He)!=="svelte-mjjjch"&&(He.textContent=Dl),za=m(e),Le=o(e,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-hagi3s"&&(Le.innerHTML=Wl),ja=m(e),ye=o(e,"TABLE",{"data-svelte-h":!0}),s(ye)!=="svelte-hzvu44"&&(ye.innerHTML=Fl),Ua=m(e),Ba=o(e,"HR",{}),Ka=m(e),Me=o(e,"A",{id:!0,class:!0}),g(Me).forEach(a),ka=m(e),u(Pe.$$.fragment,e),Ya=m(e),Ae=o(e,"P",{"data-svelte-h":!0}),s(Ae)!=="svelte-1355z3u"&&(Ae.textContent=Vl),Ja=m(e),Ee=o(e,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-10btw3j"&&(Ee.innerHTML=Ql),Na=m(e),ze=o(e,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-ncveta"&&(ze.innerHTML=Xl),qa=m(e),Ga=o(e,"HR",{}),Sa=m(e),je=o(e,"A",{id:!0,class:!0}),g(je).forEach(a),Oa=m(e),u(Ue.$$.fragment,e),Za=m(e),Be=o(e,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-1s704mu"&&(Be.textContent=ei),Da=m(e),Ke=o(e,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-10btw3j"&&(Ke.innerHTML=ti),Wa=m(e),ke=o(e,"TABLE",{"data-svelte-h":!0}),s(ke)!=="svelte-34rbhe"&&(ke.innerHTML=ai),Fa=m(e),Va=o(e,"HR",{}),Qa=m(e),Ye=o(e,"A",{id:!0,class:!0}),g(Ye).forEach(a),Xa=m(e),u(Je.$$.fragment,e),el=m(e),Ne=o(e,"P",{"data-svelte-h":!0}),s(Ne)!=="svelte-nwy2y"&&(Ne.textContent=li),tl=m(e),qe=o(e,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-sl3vqa"&&(qe.innerHTML=ii),al=m(e),Ge=o(e,"TABLE",{"data-svelte-h":!0}),s(Ge)!=="svelte-10oxyio"&&(Ge.innerHTML=mi),ll=m(e),il=o(e,"HR",{}),ml=m(e),Se=o(e,"A",{id:!0,class:!0}),g(Se).forEach(a),dl=m(e),u(Oe.$$.fragment,e),ol=m(e),Ze=o(e,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-15u13r6"&&(Ze.textContent=di),sl=m(e),De=o(e,"P",{"data-svelte-h":!0}),s(De)!=="svelte-1cwm6ga"&&(De.innerHTML=oi),rl=m(e),nl=o(e,"HR",{}),gl=m(e),u(We.$$.fragment,e),ul=m(e),Ve=o(e,"P",{}),g(Ve).forEach(a),this.h()},h(){r(R,"name","hf:doc:metadata"),r(R,"content",Ri),r(I,"id","module_utils/image"),r(I,"class","group"),r(b,"id","module_utils/image.RawImage"),r(b,"class","group"),r(L,"id","new_module_utils/image.RawImage_new"),r(L,"class","group"),r(A,"id","module_utils/image.RawImage+size"),r(A,"class","group"),r(U,"id","module_utils/image.RawImage+grayscale"),r(U,"class","group"),r(Y,"id","module_utils/image.RawImage+rgb"),r(Y,"class","group"),r(G,"id","module_utils/image.RawImage+rgba"),r(G,"class","group"),r(D,"id","module_utils/image.RawImage+resize"),r(D,"class","group"),r(X,"id","module_utils/image.RawImage+split"),r(X,"class","group"),r(ie,"id","module_utils/image.RawImage+clone"),r(ie,"class","group"),r(se,"id","module_utils/image.RawImage+convert"),r(se,"class","group"),r(ce,"id","module_utils/image.RawImage+save"),r(ce,"class","group"),r(Re,"id","module_utils/image.RawImage.read"),r(Re,"class","group"),r(Ce,"id","module_utils/image.RawImage.fromCanvas"),r(Ce,"class","group"),r(Me,"id","module_utils/image.RawImage.fromURL"),r(Me,"class","group"),r(je,"id","module_utils/image.RawImage.fromBlob"),r(je,"class","group"),r(Ye,"id","module_utils/image.RawImage.fromTensor"),r(Ye,"class","group"),r(Se,"id","module_utils/image..CONTENT_TYPE_MAP"),r(Se,"class","group")},m(e,t){pi(document.head,R),l(e,Qe,t),l(e,Fe,t),l(e,Xe,t),l(e,I,t),l(e,et,t),c($,e,t),l(e,tt,t),l(e,v,t),l(e,at,t),l(e,_,t),l(e,lt,t),l(e,T,t),l(e,it,t),l(e,mt,t),l(e,dt,t),l(e,b,t),l(e,ot,t),c(C,e,t),l(e,st,t),l(e,x,t),l(e,rt,t),l(e,H,t),l(e,nt,t),l(e,gt,t),l(e,ut,t),l(e,L,t),l(e,ct,t),c(y,e,t),l(e,pt,t),l(e,M,t),l(e,ft,t),l(e,P,t),l(e,wt,t),l(e,ht,t),l(e,Rt,t),l(e,A,t),l(e,It,t),c(E,e,t),l(e,$t,t),l(e,z,t),l(e,vt,t),l(e,j,t),l(e,_t,t),l(e,Tt,t),l(e,bt,t),l(e,U,t),l(e,Ct,t),c(B,e,t),l(e,xt,t),l(e,K,t),l(e,Ht,t),l(e,k,t),l(e,Lt,t),l(e,yt,t),l(e,Mt,t),l(e,Y,t),l(e,Pt,t),c(J,e,t),l(e,At,t),l(e,N,t),l(e,Et,t),l(e,q,t),l(e,zt,t),l(e,jt,t),l(e,Ut,t),l(e,G,t),l(e,Bt,t),c(S,e,t),l(e,Kt,t),l(e,O,t),l(e,kt,t),l(e,Z,t),l(e,Yt,t),l(e,Jt,t),l(e,Nt,t),l(e,D,t),l(e,qt,t),c(W,e,t),l(e,Gt,t),l(e,F,t),l(e,St,t),l(e,V,t),l(e,Ot,t),l(e,Q,t),l(e,Zt,t),l(e,Dt,t),l(e,Wt,t),l(e,X,t),l(e,Ft,t),c(ee,e,t),l(e,Vt,t),l(e,te,t),l(e,Qt,t),l(e,ae,t),l(e,Xt,t),l(e,le,t),l(e,ea,t),l(e,ta,t),l(e,aa,t),l(e,ie,t),l(e,la,t),c(me,e,t),l(e,ia,t),l(e,de,t),l(e,ma,t),l(e,oe,t),l(e,da,t),l(e,oa,t),l(e,sa,t),l(e,se,t),l(e,ra,t),c(re,e,t),l(e,na,t),l(e,ne,t),l(e,ga,t),l(e,ge,t),l(e,ua,t),l(e,ue,t),l(e,ca,t),l(e,pa,t),l(e,fa,t),l(e,ce,t),l(e,wa,t),c(pe,e,t),l(e,ha,t),l(e,fe,t),l(e,Ra,t),l(e,we,t),l(e,Ia,t),l(e,he,t),l(e,$a,t),l(e,va,t),l(e,_a,t),l(e,Re,t),l(e,Ta,t),c(Ie,e,t),l(e,ba,t),l(e,$e,t),l(e,Ca,t),l(e,ve,t),l(e,xa,t),l(e,_e,t),l(e,Ha,t),c(Te,e,t),l(e,La,t),l(e,be,t),l(e,ya,t),l(e,Ma,t),l(e,Pa,t),l(e,Ce,t),l(e,Aa,t),c(xe,e,t),l(e,Ea,t),l(e,He,t),l(e,za,t),l(e,Le,t),l(e,ja,t),l(e,ye,t),l(e,Ua,t),l(e,Ba,t),l(e,Ka,t),l(e,Me,t),l(e,ka,t),c(Pe,e,t),l(e,Ya,t),l(e,Ae,t),l(e,Ja,t),l(e,Ee,t),l(e,Na,t),l(e,ze,t),l(e,qa,t),l(e,Ga,t),l(e,Sa,t),l(e,je,t),l(e,Oa,t),c(Ue,e,t),l(e,Za,t),l(e,Be,t),l(e,Da,t),l(e,Ke,t),l(e,Wa,t),l(e,ke,t),l(e,Fa,t),l(e,Va,t),l(e,Qa,t),l(e,Ye,t),l(e,Xa,t),c(Je,e,t),l(e,el,t),l(e,Ne,t),l(e,tl,t),l(e,qe,t),l(e,al,t),l(e,Ge,t),l(e,ll,t),l(e,il,t),l(e,ml,t),l(e,Se,t),l(e,dl,t),c(Oe,e,t),l(e,ol,t),l(e,Ze,t),l(e,sl,t),l(e,De,t),l(e,rl,t),l(e,nl,t),l(e,gl,t),c(We,e,t),l(e,ul,t),l(e,Ve,t),cl=!0},p:ri,i(e){cl||(p($.$$.fragment,e),p(C.$$.fragment,e),p(y.$$.fragment,e),p(E.$$.fragment,e),p(B.$$.fragment,e),p(J.$$.fragment,e),p(S.$$.fragment,e),p(W.$$.fragment,e),p(ee.$$.fragment,e),p(me.$$.fragment,e),p(re.$$.fragment,e),p(pe.$$.fragment,e),p(Ie.$$.fragment,e),p(Te.$$.fragment,e),p(xe.$$.fragment,e),p(Pe.$$.fragment,e),p(Ue.$$.fragment,e),p(Je.$$.fragment,e),p(Oe.$$.fragment,e),p(We.$$.fragment,e),cl=!0)},o(e){f($.$$.fragment,e),f(C.$$.fragment,e),f(y.$$.fragment,e),f(E.$$.fragment,e),f(B.$$.fragment,e),f(J.$$.fragment,e),f(S.$$.fragment,e),f(W.$$.fragment,e),f(ee.$$.fragment,e),f(me.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(Ie.$$.fragment,e),f(Te.$$.fragment,e),f(xe.$$.fragment,e),f(Pe.$$.fragment,e),f(Ue.$$.fragment,e),f(Je.$$.fragment,e),f(Oe.$$.fragment,e),f(We.$$.fragment,e),cl=!1},d(e){e&&(a(Qe),a(Fe),a(Xe),a(I),a(et),a(tt),a(v),a(at),a(_),a(lt),a(T),a(it),a(mt),a(dt),a(b),a(ot),a(st),a(x),a(rt),a(H),a(nt),a(gt),a(ut),a(L),a(ct),a(pt),a(M),a(ft),a(P),a(wt),a(ht),a(Rt),a(A),a(It),a($t),a(z),a(vt),a(j),a(_t),a(Tt),a(bt),a(U),a(Ct),a(xt),a(K),a(Ht),a(k),a(Lt),a(yt),a(Mt),a(Y),a(Pt),a(At),a(N),a(Et),a(q),a(zt),a(jt),a(Ut),a(G),a(Bt),a(Kt),a(O),a(kt),a(Z),a(Yt),a(Jt),a(Nt),a(D),a(qt),a(Gt),a(F),a(St),a(V),a(Ot),a(Q),a(Zt),a(Dt),a(Wt),a(X),a(Ft),a(Vt),a(te),a(Qt),a(ae),a(Xt),a(le),a(ea),a(ta),a(aa),a(ie),a(la),a(ia),a(de),a(ma),a(oe),a(da),a(oa),a(sa),a(se),a(ra),a(na),a(ne),a(ga),a(ge),a(ua),a(ue),a(ca),a(pa),a(fa),a(ce),a(wa),a(ha),a(fe),a(Ra),a(we),a(Ia),a(he),a($a),a(va),a(_a),a(Re),a(Ta),a(ba),a($e),a(Ca),a(ve),a(xa),a(_e),a(Ha),a(La),a(be),a(ya),a(Ma),a(Pa),a(Ce),a(Aa),a(Ea),a(He),a(za),a(Le),a(ja),a(ye),a(Ua),a(Ba),a(Ka),a(Me),a(ka),a(Ya),a(Ae),a(Ja),a(Ee),a(Na),a(ze),a(qa),a(Ga),a(Sa),a(je),a(Oa),a(Za),a(Be),a(Da),a(Ke),a(Wa),a(ke),a(Fa),a(Va),a(Qa),a(Ye),a(Xa),a(el),a(Ne),a(tl),a(qe),a(al),a(Ge),a(ll),a(il),a(ml),a(Se),a(dl),a(ol),a(Ze),a(sl),a(De),a(rl),a(nl),a(gl),a(ul),a(Ve)),a(R),w($,e),w(C,e),w(y,e),w(E,e),w(B,e),w(J,e),w(S,e),w(W,e),w(ee,e),w(me,e),w(re,e),w(pe,e),w(Ie,e),w(Te,e),w(xe,e),w(Pe,e),w(Ue,e),w(Je,e),w(Oe,e),w(We,e)}}}const Ri='{"title":"utils/image","local":"utilsimage","sections":[{"title":"utils/image.RawImage","local":"utilsimagerawimage","sections":[{"title":"new RawImage(data, width, height, channels)","local":"new-rawimagedata-width-height-channels","sections":[],"depth":3},{"title":"rawImage.size ⇒ <code> * </code>","local":"rawimagesize--code--code","sections":[],"depth":3},{"title":"rawImage.grayscale() ⇒ <code> RawImage </code>","local":"rawimagegrayscale--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgb() ⇒ <code> RawImage </code>","local":"rawimagergb--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgba() ⇒ <code> RawImage </code>","local":"rawimagergba--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>","local":"rawimageresizewidth-height-options--code-promise--rawimage--code","sections":[],"depth":3},{"title":"rawImage.split() ⇒ <code> Array. < RawImage > </code>","local":"rawimagesplit--code-array--rawimage--code","sections":[],"depth":3},{"title":"rawImage.clone() ⇒ <code> RawImage </code>","local":"rawimageclone--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.convert(numChannels) ⇒ <code> RawImage </code>","local":"rawimageconvertnumchannels--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.save(path)","local":"rawimagesavepath","sections":[],"depth":3},{"title":"RawImage.read(input) ⇒ <code> * </code>","local":"rawimagereadinput--code--code","sections":[],"depth":3},{"title":"RawImage.fromCanvas(canvas) ⇒ <code> RawImage </code>","local":"rawimagefromcanvascanvas--code-rawimage-code","sections":[],"depth":3},{"title":"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromurlurl--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromblobblob--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromTensor(tensor)","local":"rawimagefromtensortensor","sections":[],"depth":3}],"depth":2},{"title":"utils/image~CONTENT_TYPE_MAP","local":"utilsimagecontenttypemap","sections":[],"depth":2}],"depth":1}';function Ii(pl){return ni(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bi extends gi{constructor(R){super(),ui(this,R,Ii,hi,si,{})}}export{bi as component};
