import{s as il,n as al,o as sl}from"../chunks/scheduler.8b74b908.js";import{S as rl,i as pl,g as a,s as n,r as p,A as dl,h as s,f as l,c as i,j as ol,u as d,x as r,k as nl,y as cl,a as o,v as c,d as u,t as m,w as g}from"../chunks/index.0ed2a570.js";import{C as h}from"../chunks/CodeBlock.530268b7.js";import{H as ye,E as ul}from"../chunks/EditOnGithub.d2d81eda.js";function ml(Ut){let f,be,Me,ve,y,Te,M,xt="FLUX is an open-weights 12B parameter rectified flow transformer that generates images from text descriptions, pushing the boundaries of text-to-image generation created by Black Forest Labs, with a non-commercial license making it widely accessible for exploration and experimentation. And, Google Cloud Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.",Ue,w,Ct='This example showcases how to deploy any supported <a href="https://github.com/huggingface/diffusers" rel="nofollow"><code>diffusers</code></a> text-to-image model from the Hugging Face Hub, in this case <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-dev</code></a>, on Vertex AI using the Hugging Face PyTorch DLC for Inference available in Google Cloud Platform (GCP) in both CPU and GPU instances.',xe,b,$t='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-flux-on-vertex-ai/assets/model-in-hf-hub.png" alt="&#39;black-forest-labs/FLUX.1-dev&#39; in the Hugging Face Hub"/>',Ce,v,$e,T,jt='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',je,U,It="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",Ie,x,Je,C,Jt="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",_e,$,Ge,j,_t="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",Ze,I,ke,J,Gt="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",Le,_,Ve,G,We,Z,Zt='Once everything is set up, you can already initialize the Vertex AI session via the <a href="https://github.com/googleapis/python-aiplatform" rel="nofollow"><code>google-cloud-aiplatform</code></a> Python SDK as follows:',Ae,k,He,L,kt='Since <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-dev</code></a> is a gated model, you need to login into your Hugging Face Hub account with a read-access token either fine-grained with access to the gated model, or just read-access to your account. More information on how to generate a read-only access token for the Hugging Face Hub at <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">https://huggingface.co/docs/hub/en/security-tokens</a>.',Fe,V,Re,W,Xe,A,Lt="Then you can already “upload” the model i.e. register the model on Vertex AI. It is not an upload per se, since the model will be automatically downloaded from the Hugging Face Hub in the Hugging Face PyTorch DLC for Inference on startup via the <code>HF_MODEL_ID</code> environment variable, so what is uploaded is only the configuration, not the model weights.",Be,H,Vt="Before going into the code, let’s quickly review the arguments provided to the <code>upload</code> method:",Ee,F,Wt='<li><strong><code>display_name</code></strong> is the name that will be shown in the Vertex AI Model Registry.</li> <li><strong><code>serving_container_image_uri</code></strong> is the location of the Hugging Face PyTorch DLC for Inference that will be used for serving the model.</li> <li><strong><code>serving_container_environment_variables</code></strong> are the environment variables that will be used during the container runtime, so these are aligned with the environment variables defined by <a href="https://github.com/huggingface/huggingface-inference-toolkit" rel="nofollow">huggingface-inference-toolkit</a> Python SDK, which exposes some environment variables such as the following:<ul><li><code>HF_MODEL_ID</code> is the identifier of the model in the Hugging Face Hub. To explore all the supported models please check <a href="https://huggingface.co/models?sort=trending" rel="nofollow">https://huggingface.co/models?sort=trending</a> filtering by the task that you want to use e.g. <code>text-classification</code>.</li> <li><code>HF_TASK</code> is the task identifier within the Hugging Face Hub. To see all the supported tasks please check [<a href="https://huggingface.co/docs/transformers/en/task_summary#natural-language-processing" rel="nofollow">https://huggingface.co/docs/transformers/en/task_summary#natural-language-processing</a>.</li> <li><code>HUGGING_FACE_HUB_TOKEN</code> is the Hugging Face Hub token, required as <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-dev</code></a> is a gated model.</li></ul></li>',Pe,R,At='For more information on the supported <code>aiplatform.Model.upload</code> arguments, check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload</a>.',Se,X,Ne,B,Ht='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-flux-on-vertex-ai/assets/vertex-ai-model.png" alt="Model in Vertex AI Model Registry"/>',Qe,E,Ft='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-flux-on-vertex-ai/assets/vertex-ai-model-version.png" alt="Model Version in Vertex AI Model Registry"/>',Ye,P,qe,S,Rt="After the model is registered on Vertex AI, you need to define the endpoint that you want to deploy the model to, and then link the model deployment to that endpoint resource.",De,N,Xt="To do so, you need to call the method <code>aiplatform.Endpoint.create</code> to create a new Vertex AI endpoint resource (which is not linked to a model or anything usable yet).",ze,Q,Oe,Y,Bt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-flux-on-vertex-ai/assets/vertex-ai-endpoint.png" alt="Vertex AI Endpoint created"/>',Ke,q,Et="Now you can deploy the registered model in an endpoint on Vertex AI.",et,D,Pt="The <code>deploy</code> method will link the previously created endpoint resource with the model that contains the configuration of the serving container, and then, it will deploy the model on Vertex AI in the specified instance.",tt,z,St="Before going into the code, let’s quicklyl review the arguments provided to the <code>deploy</code> method:",lt,O,Nt='<li><strong><code>endpoint</code></strong> is the endpoint to deploy the model to, which is optional, and by default will be set to the model display name with the <code>_endpoint</code> suffix.</li> <li><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> are arguments that define which instance to use, and additionally, the accelerator to use and the number of accelerators, respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</li> <li><strong><code>enable_access_logging</code></strong> is an argument to enable endpoint access logging i.e. to record the information about requests made to the endpoint within Google Cloud Logging.</li>',ot,K,Qt='For more information on the supported <code>aiplatform.Model.deploy</code> arguments, you can check its Python reference at <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy" rel="nofollow">https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy</a>.',nt,ee,it,te,Yt="<strong>WARNING</strong>: <em>The Vertex AI endpoint deployment via the <code>deploy</code> method may take from 15 to 25 minutes.</em>",at,le,qt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-flux-on-vertex-ai/assets/vertex-ai-endpoint-ready.png" alt="Vertex AI Endpoint Ready"/>',st,oe,Dt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-flux-on-vertex-ai/assets/vertex-ai-model-ready.png" alt="Vertex AI Model Ready"/>',rt,ne,pt,ie,zt="Finally, you can run the online predictions on Vertex AI using the <code>predict</code> method, which will send the requests to the running endpoint in the <code>/predict</code> route specified within the container following Vertex AI I/O payload formatting.",dt,ae,ct,se,Ot='As the deployed model is a text-to-image model, the output payload will contain the generated image for the text description provided, but encoded in base64; meaning that you will need to decode it and load it using the <a href="https://github.com/python-pillow/Pillow" rel="nofollow"><code>Pillow</code></a> Python library.',ut,re,mt,pe,gt,de,Kt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-flux-on-vertex-ai/assets/flux-dev-output.png" alt="FLUX.1-dev output"/>',ht,ce,el='<strong>WARNING</strong> At the moment, the Hugging Face DLCs on Google Cloud have a request timeout of 60 seconds, meaning that if the prediction request takes longer than that, an HTTP 503 will be raised. To prevent that, you can increase the default prediction timeout as per <a href="https://cloud.google.com/vertex-ai/docs/predictions/get-online-predictions" rel="nofollow">Vertex AI Documentation - Get online predictions from a custom trained model</a> by either filing a support ticket or contact your Google Cloud representative. Anyway, for the publicly released Hugging Face DLCs, the Google Cloud team is currently working on whitelisting those to increase the prediction timeout to 600 seconds.',ft,ue,yt,me,tl="Finally, you can release the resources programmatically within the same Python session as follows:",Mt,ge,ll="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully after the <code>undeploy_all</code>.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",wt,he,bt,fe,vt,we,Tt;return y=new ye({props:{title:"Deploy FLUX with PyTorch Inference DLC on Vertex AI",local:"deploy-flux-with-pytorch-inference-dlc-on-vertex-ai",headingTag:"h1"}}),v=new ye({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),x=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),$=new h({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMENPTlRBSU5FUl9VUkklM0R1cy1kb2NrZXIucGtnLmRldiUyRmRlZXBsZWFybmluZy1wbGF0Zm9ybS1yZWxlYXNlJTJGZ2NyLmlvJTJGaHVnZ2luZ2ZhY2UtcHl0b3JjaC1pbmZlcmVuY2UtY3UxMjEuMi0yLnRyYW5zZm9ybWVycy40LTQ0LnVidW50dTIyMDQucHkzMTE=",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-pytorch-inference-cu121<span class="hljs-number">.2</span>-<span class="hljs-number">2.</span>transformers<span class="hljs-number">.4</span>-<span class="hljs-number">44.</span>ubuntu2204.py311`,wrap:!1}}),I=new h({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),_=new h({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),G=new ye({props:{title:"Register model in Vertex AI",local:"register-model-in-vertex-ai",headingTag:"h2"}}),k=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
)`,wrap:!1}}),V=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"!pip install --upgrade --quiet huggingface_hub",wrap:!1}}),W=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),X=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQSUwQW1vZGVsJTIwJTNEJTIwYWlwbGF0Zm9ybS5Nb2RlbC51cGxvYWQoJTBBJTIwJTIwJTIwJTIwZGlzcGxheV9uYW1lJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMtLUZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9pbWFnZV91cmklM0Rvcy5nZXRlbnYoJTIyQ09OVEFJTkVSX1VSSSUyMiklMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9lbnZpcm9ubWVudF92YXJpYWJsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIRl9NT0RFTF9JRCUyMiUzQSUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhGX1RBU0slMjIlM0ElMjAlMjJ0ZXh0LXRvLWltYWdlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySEZfVE9LRU4lMjIlM0ElMjBnZXRfdG9rZW4oKSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEFtb2RlbC53YWl0KCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

model = aiplatform.Model.upload(
    display_name=<span class="hljs-string">&quot;black-forest-labs--FLUX.1-dev&quot;</span>,
    serving_container_image_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    serving_container_environment_variables={
        <span class="hljs-string">&quot;HF_MODEL_ID&quot;</span>: <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
        <span class="hljs-string">&quot;HF_TASK&quot;</span>: <span class="hljs-string">&quot;text-to-image&quot;</span>,
        <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: get_token(),
    },
)
model.wait()`,wrap:!1}}),P=new ye({props:{title:"Deploy model in Vertex AI",local:"deploy-model-in-vertex-ai",headingTag:"h2"}}),Q=new h({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBhaXBsYXRmb3JtLkVuZHBvaW50LmNyZWF0ZShkaXNwbGF5X25hbWUlM0QlMjJibGFjay1mb3Jlc3QtbGFicy0tRkxVWC4xLWRldi1lbmRwb2ludCUyMik=",highlighted:'endpoint = aiplatform.Endpoint.create(display_name=<span class="hljs-string">&quot;black-forest-labs--FLUX.1-dev-endpoint&quot;</span>)',wrap:!1}}),ee=new h({props:{code:"JTI1JTI1dGltZSUwQWRlcGxveWVkX21vZGVsJTIwJTNEJTIwbW9kZWwuZGVwbG95KCUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEZW5kcG9pbnQlMkMlMEElMjAlMjAlMjAlMjBtYWNoaW5lX3R5cGUlM0QlMjJnMi1zdGFuZGFyZC00OCUyMiUyQyUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yX3R5cGUlM0QlMjJOVklESUFfTDQlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl9jb3VudCUzRDQlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfYWNjZXNzX2xvZ2dpbmclM0RUcnVlJTJDJTBBKQ==",highlighted:`%%time
deployed_model = model.deploy(
    endpoint=endpoint,
    machine_type=<span class="hljs-string">&quot;g2-standard-48&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_L4&quot;</span>,
    accelerator_count=<span class="hljs-number">4</span>,
    enable_access_logging=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ne=new ye({props:{title:"Online predictions on Vertex AI",local:"online-predictions-on-vertex-ai",headingTag:"h2"}}),ae=new h({props:{code:"JTI1JTI1dGltZSUwQW91dHB1dCUyMCUzRCUyMGRlcGxveWVkX21vZGVsLnByZWRpY3QoJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VzJTNEJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhcmFtZXRlcnMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlaWdodCUyMiUzQSUyMDUxMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm51bV9pbmZlcmVuY2Vfc3RlcHMlMjIlM0ElMjA4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZ3VpZGFuY2Vfc2NhbGUlMjIlM0ElMjAzLjUlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEEp",highlighted:`%%time
output = deployed_model.predict(
    instances=[<span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>],
    parameters={
        <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>,
        <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>,
        <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">8</span>,
        <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    },
)`,wrap:!1}}),re=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwUGlsbG93",highlighted:"!pip install --upgrade --quiet Pillow",wrap:!1}}),pe=new h({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBaW1wb3J0JTIwaW8lMEElMEFmcm9tJTIwSVB5dGhvbi5kaXNwbGF5JTIwaW1wb3J0JTIwZGlzcGxheSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3Blbihpby5CeXRlc0lPKGJhc2U2NC5iNjRkZWNvZGUob3V0cHV0LnByZWRpY3Rpb25zJTVCMCU1RCkpKSUwQWRpc3BsYXkoaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">import</span> io

<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> display
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

image = Image.<span class="hljs-built_in">open</span>(io.BytesIO(base64.b64decode(output.predictions[<span class="hljs-number">0</span>])))
display(image)`,wrap:!1}}),ue=new ye({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),he=new h({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),fe=new ul({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-deploy-flux-on-vertex-ai.mdx"}}),{c(){f=a("meta"),be=n(),Me=a("p"),ve=n(),p(y.$$.fragment),Te=n(),M=a("p"),M.textContent=xt,Ue=n(),w=a("p"),w.innerHTML=Ct,xe=n(),b=a("p"),b.innerHTML=$t,Ce=n(),p(v.$$.fragment),$e=n(),T=a("p"),T.innerHTML=jt,je=n(),U=a("p"),U.innerHTML=It,Ie=n(),p(x.$$.fragment),Je=n(),C=a("p"),C.textContent=Jt,_e=n(),p($.$$.fragment),Ge=n(),j=a("p"),j.textContent=_t,Ze=n(),p(I.$$.fragment),ke=n(),J=a("p"),J.textContent=Gt,Le=n(),p(_.$$.fragment),Ve=n(),p(G.$$.fragment),We=n(),Z=a("p"),Z.innerHTML=Zt,Ae=n(),p(k.$$.fragment),He=n(),L=a("p"),L.innerHTML=kt,Fe=n(),p(V.$$.fragment),Re=n(),p(W.$$.fragment),Xe=n(),A=a("p"),A.innerHTML=Lt,Be=n(),H=a("p"),H.innerHTML=Vt,Ee=n(),F=a("ul"),F.innerHTML=Wt,Pe=n(),R=a("p"),R.innerHTML=At,Se=n(),p(X.$$.fragment),Ne=n(),B=a("p"),B.innerHTML=Ht,Qe=n(),E=a("p"),E.innerHTML=Ft,Ye=n(),p(P.$$.fragment),qe=n(),S=a("p"),S.textContent=Rt,De=n(),N=a("p"),N.innerHTML=Xt,ze=n(),p(Q.$$.fragment),Oe=n(),Y=a("p"),Y.innerHTML=Bt,Ke=n(),q=a("p"),q.textContent=Et,et=n(),D=a("p"),D.innerHTML=Pt,tt=n(),z=a("p"),z.innerHTML=St,lt=n(),O=a("ul"),O.innerHTML=Nt,ot=n(),K=a("p"),K.innerHTML=Qt,nt=n(),p(ee.$$.fragment),it=n(),te=a("p"),te.innerHTML=Yt,at=n(),le=a("p"),le.innerHTML=qt,st=n(),oe=a("p"),oe.innerHTML=Dt,rt=n(),p(ne.$$.fragment),pt=n(),ie=a("p"),ie.innerHTML=zt,dt=n(),p(ae.$$.fragment),ct=n(),se=a("p"),se.innerHTML=Ot,ut=n(),p(re.$$.fragment),mt=n(),p(pe.$$.fragment),gt=n(),de=a("p"),de.innerHTML=Kt,ht=n(),ce=a("p"),ce.innerHTML=el,ft=n(),p(ue.$$.fragment),yt=n(),me=a("p"),me.textContent=tl,Mt=n(),ge=a("ul"),ge.innerHTML=ll,wt=n(),p(he.$$.fragment),bt=n(),p(fe.$$.fragment),vt=n(),we=a("p"),this.h()},l(e){const t=dl("svelte-u9bgzb",document.head);f=s(t,"META",{name:!0,content:!0}),t.forEach(l),be=i(e),Me=s(e,"P",{}),ol(Me).forEach(l),ve=i(e),d(y.$$.fragment,e),Te=i(e),M=s(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-s59s5h"&&(M.textContent=xt),Ue=i(e),w=s(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1ad48lf"&&(w.innerHTML=Ct),xe=i(e),b=s(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1jd3ocw"&&(b.innerHTML=$t),Ce=i(e),d(v.$$.fragment,e),$e=i(e),T=s(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1o67gfb"&&(T.innerHTML=jt),je=i(e),U=s(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1ebrquh"&&(U.innerHTML=It),Ie=i(e),d(x.$$.fragment,e),Je=i(e),C=s(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1i8n6rq"&&(C.textContent=Jt),_e=i(e),d($.$$.fragment,e),Ge=i(e),j=s(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-15nvzfz"&&(j.textContent=_t),Ze=i(e),d(I.$$.fragment,e),ke=i(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1nm8o2l"&&(J.textContent=Gt),Le=i(e),d(_.$$.fragment,e),Ve=i(e),d(G.$$.fragment,e),We=i(e),Z=s(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1f1rnfu"&&(Z.innerHTML=Zt),Ae=i(e),d(k.$$.fragment,e),He=i(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-o43qmx"&&(L.innerHTML=kt),Fe=i(e),d(V.$$.fragment,e),Re=i(e),d(W.$$.fragment,e),Xe=i(e),A=s(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-19b1hpg"&&(A.innerHTML=Lt),Be=i(e),H=s(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-zklutt"&&(H.innerHTML=Vt),Ee=i(e),F=s(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-e4n5sz"&&(F.innerHTML=Wt),Pe=i(e),R=s(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1flszm1"&&(R.innerHTML=At),Se=i(e),d(X.$$.fragment,e),Ne=i(e),B=s(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1i81ad5"&&(B.innerHTML=Ht),Qe=i(e),E=s(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-82rf8k"&&(E.innerHTML=Ft),Ye=i(e),d(P.$$.fragment,e),qe=i(e),S=s(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-2nwexf"&&(S.textContent=Rt),De=i(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1lovlvw"&&(N.innerHTML=Xt),ze=i(e),d(Q.$$.fragment,e),Oe=i(e),Y=s(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1uv850w"&&(Y.innerHTML=Bt),Ke=i(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-it668a"&&(q.textContent=Et),et=i(e),D=s(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-njbdvc"&&(D.innerHTML=Pt),tt=i(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-v5hhrl"&&(z.innerHTML=St),lt=i(e),O=s(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-agrvv0"&&(O.innerHTML=Nt),ot=i(e),K=s(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-9p37qa"&&(K.innerHTML=Qt),nt=i(e),d(ee.$$.fragment,e),it=i(e),te=s(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-mraq68"&&(te.innerHTML=Yt),at=i(e),le=s(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-5xetq9"&&(le.innerHTML=qt),st=i(e),oe=s(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1j74yyt"&&(oe.innerHTML=Dt),rt=i(e),d(ne.$$.fragment,e),pt=i(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-166ya0u"&&(ie.innerHTML=zt),dt=i(e),d(ae.$$.fragment,e),ct=i(e),se=s(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-zo7qy0"&&(se.innerHTML=Ot),ut=i(e),d(re.$$.fragment,e),mt=i(e),d(pe.$$.fragment,e),gt=i(e),de=s(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1cac9eu"&&(de.innerHTML=Kt),ht=i(e),ce=s(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-fil2qx"&&(ce.innerHTML=el),ft=i(e),d(ue.$$.fragment,e),yt=i(e),me=s(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1a8svyd"&&(me.textContent=tl),Mt=i(e),ge=s(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-8vrgpw"&&(ge.innerHTML=ll),wt=i(e),d(he.$$.fragment,e),bt=i(e),d(fe.$$.fragment,e),vt=i(e),we=s(e,"P",{}),ol(we).forEach(l),this.h()},h(){nl(f,"name","hf:doc:metadata"),nl(f,"content",gl)},m(e,t){cl(document.head,f),o(e,be,t),o(e,Me,t),o(e,ve,t),c(y,e,t),o(e,Te,t),o(e,M,t),o(e,Ue,t),o(e,w,t),o(e,xe,t),o(e,b,t),o(e,Ce,t),c(v,e,t),o(e,$e,t),o(e,T,t),o(e,je,t),o(e,U,t),o(e,Ie,t),c(x,e,t),o(e,Je,t),o(e,C,t),o(e,_e,t),c($,e,t),o(e,Ge,t),o(e,j,t),o(e,Ze,t),c(I,e,t),o(e,ke,t),o(e,J,t),o(e,Le,t),c(_,e,t),o(e,Ve,t),c(G,e,t),o(e,We,t),o(e,Z,t),o(e,Ae,t),c(k,e,t),o(e,He,t),o(e,L,t),o(e,Fe,t),c(V,e,t),o(e,Re,t),c(W,e,t),o(e,Xe,t),o(e,A,t),o(e,Be,t),o(e,H,t),o(e,Ee,t),o(e,F,t),o(e,Pe,t),o(e,R,t),o(e,Se,t),c(X,e,t),o(e,Ne,t),o(e,B,t),o(e,Qe,t),o(e,E,t),o(e,Ye,t),c(P,e,t),o(e,qe,t),o(e,S,t),o(e,De,t),o(e,N,t),o(e,ze,t),c(Q,e,t),o(e,Oe,t),o(e,Y,t),o(e,Ke,t),o(e,q,t),o(e,et,t),o(e,D,t),o(e,tt,t),o(e,z,t),o(e,lt,t),o(e,O,t),o(e,ot,t),o(e,K,t),o(e,nt,t),c(ee,e,t),o(e,it,t),o(e,te,t),o(e,at,t),o(e,le,t),o(e,st,t),o(e,oe,t),o(e,rt,t),c(ne,e,t),o(e,pt,t),o(e,ie,t),o(e,dt,t),c(ae,e,t),o(e,ct,t),o(e,se,t),o(e,ut,t),c(re,e,t),o(e,mt,t),c(pe,e,t),o(e,gt,t),o(e,de,t),o(e,ht,t),o(e,ce,t),o(e,ft,t),c(ue,e,t),o(e,yt,t),o(e,me,t),o(e,Mt,t),o(e,ge,t),o(e,wt,t),c(he,e,t),o(e,bt,t),c(fe,e,t),o(e,vt,t),o(e,we,t),Tt=!0},p:al,i(e){Tt||(u(y.$$.fragment,e),u(v.$$.fragment,e),u(x.$$.fragment,e),u($.$$.fragment,e),u(I.$$.fragment,e),u(_.$$.fragment,e),u(G.$$.fragment,e),u(k.$$.fragment,e),u(V.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(P.$$.fragment,e),u(Q.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),Tt=!0)},o(e){m(y.$$.fragment,e),m(v.$$.fragment,e),m(x.$$.fragment,e),m($.$$.fragment,e),m(I.$$.fragment,e),m(_.$$.fragment,e),m(G.$$.fragment,e),m(k.$$.fragment,e),m(V.$$.fragment,e),m(W.$$.fragment,e),m(X.$$.fragment,e),m(P.$$.fragment,e),m(Q.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(ue.$$.fragment,e),m(he.$$.fragment,e),m(fe.$$.fragment,e),Tt=!1},d(e){e&&(l(be),l(Me),l(ve),l(Te),l(M),l(Ue),l(w),l(xe),l(b),l(Ce),l($e),l(T),l(je),l(U),l(Ie),l(Je),l(C),l(_e),l(Ge),l(j),l(Ze),l(ke),l(J),l(Le),l(Ve),l(We),l(Z),l(Ae),l(He),l(L),l(Fe),l(Re),l(Xe),l(A),l(Be),l(H),l(Ee),l(F),l(Pe),l(R),l(Se),l(Ne),l(B),l(Qe),l(E),l(Ye),l(qe),l(S),l(De),l(N),l(ze),l(Oe),l(Y),l(Ke),l(q),l(et),l(D),l(tt),l(z),l(lt),l(O),l(ot),l(K),l(nt),l(it),l(te),l(at),l(le),l(st),l(oe),l(rt),l(pt),l(ie),l(dt),l(ct),l(se),l(ut),l(mt),l(gt),l(de),l(ht),l(ce),l(ft),l(yt),l(me),l(Mt),l(ge),l(wt),l(bt),l(vt),l(we)),l(f),g(y,e),g(v,e),g(x,e),g($,e),g(I,e),g(_,e),g(G,e),g(k,e),g(V,e),g(W,e),g(X,e),g(P,e),g(Q,e),g(ee,e),g(ne,e),g(ae,e),g(re,e),g(pe,e),g(ue,e),g(he,e),g(fe,e)}}}const gl='{"title":"Deploy FLUX with PyTorch Inference DLC on Vertex AI","local":"deploy-flux-with-pytorch-inference-dlc-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Register model in Vertex AI","local":"register-model-in-vertex-ai","sections":[],"depth":2},{"title":"Deploy model in Vertex AI","local":"deploy-model-in-vertex-ai","sections":[],"depth":2},{"title":"Online predictions on Vertex AI","local":"online-predictions-on-vertex-ai","sections":[],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2}],"depth":1}';function hl(Ut){return sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends rl{constructor(f){super(),pl(this,f,hl,ml,il,{})}}export{bl as component};
