import{s as Mn,o as dn,n as Ie}from"../chunks/scheduler.b108d059.js";import{S as mn,i as hn,g as a,s as i,r as p,A as fn,h as r,f as n,c as s,j as un,u as M,x as c,k as pn,y as gn,a as l,v as d,d as m,t as h,w as f}from"../chunks/index.008de539.js";import{T as Ce}from"../chunks/Tip.aeb15ab7.js";import{C as b}from"../chunks/CodeBlock.3968c746.js";import{H as Je,E as yn}from"../chunks/EditOnGithub.d1c48e3d.js";function Tn(w){let o,y="You can use an existing bucket for storing the fine-tuning artifacts, if you already have a bucket, feel free to skip this step and jump onto the next one.";return{c(){o=a("p"),o.textContent=y},l(u){o=r(u,"P",{"data-svelte-h":!0}),c(o)!=="svelte-16rwlsp"&&(o.textContent=y)},m(u,g){l(u,o,g)},p:Ie,d(u){u&&n(o)}}}function wn(w){let o,y="The <code>CustomContainerTrainingJob</code> will override the default <code>ENTRYPOINT</code> provided within the container URI provided, so if the <code>ENTRYPOINT</code> is already suited to receive the arguments, then there’s no need to define a custom <code>command</code>.";return{c(){o=a("p"),o.innerHTML=y},l(u){o=r(u,"P",{"data-svelte-h":!0}),c(o)!=="svelte-1ekjliv"&&(o.innerHTML=y)},m(u,g){l(u,o,g)},p:Ie,d(u){u&&n(o)}}}function bn(w){let o,y=`Once you have decided which resources to use to run the job, you need to define the hyper parameters accordingly to ensure that the selected instance is capable of running the job.
Some of the hparams that you may want to look into to avoid running into OOM errors are the following:`,u,g,J='<li><strong>Optimizer</strong>: by default the AdamW optimizer will be used, but alternatively lower precision optimizers can be used to reduce the memory as well e.g. <code>adamw_bnb_8bit</code> (for more information on 8-bit optimizers check <a href="https://huggingface.co/docs/bitsandbytes/main/en/optimizers" rel="nofollow">https://huggingface.co/docs/bitsandbytes/main/en/optimizers</a>).</li> <li><strong>Batch size</strong>: you can tweak this so as to use a lower batch size when running into OOM, or you can also tweak the gradient accumulation steps to simulate a similar batch size for updating the gradients, but providing less inputs within a batch a time e.g. <code>batch_size=8</code> and <code>gradient_accumulation=1</code> is effectively the same as <code>batch_size=4</code> and <code>gradient_accumulation=2</code>.</li>';return{c(){o=a("p"),o.textContent=y,u=i(),g=a("ul"),g.innerHTML=J},l(T){o=r(T,"P",{"data-svelte-h":!0}),c(o)!=="svelte-oq0ay8"&&(o.textContent=y),u=s(T),g=r(T,"UL",{"data-svelte-h":!0}),c(g)!=="svelte-tb4cna"&&(g.innerHTML=J)},m(T,j){l(T,o,j),l(T,u,j),l(T,g,j)},p:Ie,d(T){T&&(n(o),n(u),n(g))}}}function jn(w){let o,y='Since GCS FUSE is used to mount the bucket as a directory within the running container job, the mounted path follows the formatting <code>/gcs/&lt;BUCKET_NAME&gt;</code>. More information at <a href="https://cloud.google.com/vertex-ai/docs/training/code-requirements" rel="nofollow">https://cloud.google.com/vertex-ai/docs/training/code-requirements</a>. So the <code>output_dir</code> needs to be set to the mounted GCS Bucket, meaning that anything the <code>SFTTrainer</code> writes there will be automatically uploaded to the GCS Bucket.';return{c(){o=a("p"),o.innerHTML=y},l(u){o=r(u,"P",{"data-svelte-h":!0}),c(o)!=="svelte-d8v0sp"&&(o.innerHTML=y)},m(u,g){l(u,o,g)},p:Ie,d(u){u&&n(o)}}}function Jn(w){let o,y='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Google-Cloud-Containers/tree/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai" rel="nofollow">here</a>!';return{c(){o=a("p"),o.innerHTML=y},l(u){o=r(u,"P",{"data-svelte-h":!0}),c(o)!=="svelte-5vzscs"&&(o.innerHTML=y)},m(u,g){l(u,o,g)},p:Ie,d(u){u&&n(o)}}}function Un(w){let o,y,u,g,J,T,j,$t='<a href="https://github.com/huggingface/trl" rel="nofollow">Transformer Reinforcement Learning (TRL)</a> is a framework developed by Hugging Face to fine-tune and align both transformer language and diffusion models using methods such as Supervised Fine-Tuning (SFT), Reward Modeling (RM), Proximal Policy Optimization (PPO), Direct Preference Optimization (DPO), and others. On the other hand, Vertex AI is a Machine Learning (ML) platform that lets you train and deploy ML models and AI applications, and customize large language models (LLMs) for use in your AI-powered applications.',ve,_,_t="This example showcases how to create a custom training job on Vertex AI running the Hugging Face PyTorch DLC for training, using the TRL CLI to full fine-tune a 7B LLM with SFT in a multi-GPU setting.",$e,A,_e,Z,At='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',Ae,R,Zt="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",Ze,E,Re,x,Rt="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",Ee,V,xe,B,Et="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",Ve,G,Be,L,xt="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",Ge,S,Le,k,Se,U,ke,F,Vt="As the Vertex AI job will generate artifacts, you need to specify a Google Cloud Storage (GCS) Bucket to dump those artifacts into. So on, you need to create a GCS Bucket via the <code>gcloud storage buckets create</code> subcommand as follows:",Fe,W,We,X,Xe,q,Bt="Once you have configured the environment and created the GCS Bucket (if applicable), you can proceed with the definition of the <code>CustomContainerTrainingJob</code>, which is a standard container job that runs on Vertex AI running a container, being the Hugging Face PyTorch DLC for training.",qe,H,He,N,Gt="Before proceeding with the definition of the <code>CustomContainerTrainingJob</code>, you need to define the <code>accelerate</code> configuration file that you want to use when running the <code>trl sft</code> command, required as you are in a multi-GPU environment, otherwise the default configuration will be used and may not be getting the most when running the fine-tuning job on multiple GPUs.",Ne,Q,Lt="You need to define the DeepSpeed Zero3 configuration by creating the following <code>deepspeed.yaml</code> file locally, containing the configuration that will be used to run the SFT fine-tuning in a distributed setting on multiple GPUs. Some of the values defined within the following configuration file are:",Qe,Y,St="<li><code>mixed_precision=bf16</code> as the fine-tuning will be in <code>bfloat16</code></li> <li><code>num_processes=4</code> as the fine-tuning will run on 4 A100 GPUs</li> <li><code>num_machines=1</code> and <code>same_network=true</code> as the GPUs are within the same single instance</li>",Ye,z,kt='Note that DeepSpeed Zero3 has been selected as the distributed configuration for <code>accelerate</code>, but any other can be used and configured via the <code>accelerate config</code> command, that will prompt the different configurations; or just explore some pre-defined configuration files in the <a href="https://github.com/huggingface/accelerate/tree/main/examples/config_yaml_templates" rel="nofollow">Accelerate Config Zoo</a>.',ze,P,Pe,D,Ft="You now need to define a <code>CustomContainerTrainingJob</code> that runs on the Hugging Face PyTorch DLC for training, that needs to run the following sequential steps:",De,O,Wt="<li>Create the <code>$HF_HOME/accelerate</code> path (if not existing already) as the <code>accelerate</code> config will be dumped there.</li> <li>Write the content of the <code>deepspeed.yaml</code> configuration file into the cache under the <code>default_config.yaml</code> name (as that’s <code>accelerate</code> default path i.e. the configuration that will be used for the fine-tuning job).</li> <li>Add the <code>trl sft</code> command capturing the arguments that will be provided whenever the job runs.</li>",Oe,C,Ke,K,et,ee,tt,te,Xt='Before proceeding to the <code>CustomContainerTrainingJob</code> via the Hugging Face PyTorch DLC for training, you need to define first the configuration required for the job to run successfully i.e. which GPU is capable of fine-tuning <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a> in <code>bfloat16</code>.',nt,ne,qt='As a rough calculation, you could assume that the amount of GPU VRAM required to fine-tune a model in half precision is about four times the model size (read more about it in <a href="https://blog.eleuther.ai/transformer-math/" rel="nofollow">Eleuther AI - Transformer Math 101</a>).',lt,le,Ht='Alternatively, if your model is uploaded to the Hugging Face Hub, you can check the numbers in the community space <a href="https://huggingface.co/spaces/Vokturz/can-it-run-llm" rel="nofollow"><code>Vokturz/can-it-run-llm</code></a>, which does those calculations for you, based the model to fine-tune and the available hardware.',it,ie,Nt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/can-it-run-llm.png" alt="&#39;Vokturz/can-it-run-llm&#39; for &#39;mistralai/Mistral-7B-v0.3&#39;"/>',st,se,ot,oe,Qt='As mentioned before, the job will run the Supervised Fine-Tuning (SFT) with the TRL CLI on top of <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a> in <code>bfloat16</code> using <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow"><code>timdettmers/openassistant-guanaco</code></a>, which is a subset from <a href="https://huggingface.co/datasets/OpenAssistant/oasst1" rel="nofollow"><code>OpenAssistant/oasst1</code></a> with ~10k samples.',at,I,rt,ae,Yt='As the <code>CustomContainerTrainingJob</code> defines the command <code>trl sft</code> the arguments to be provided are listed either in the Python reference at <a href="https://huggingface.co/docs/trl/en/sft_trainer#trl.SFTConfig" rel="nofollow">trl.SFTConfig</a> or via the <code>trl sft --help</code> command.',ct,re,zt='Read more about the TRL CLI at <a href="https://huggingface.co/docs/trl/en/clis" rel="nofollow">https://huggingface.co/docs/trl/en/clis</a>.',ut,v,pt,ce,Mt,ue,Pt="Then you need to call the <code>submit</code> method on the <code>aiplatform.CustomContainerTrainingJob</code>, which is a non-blocking method that will schedule the job without blocking the execution.",dt,pe,Dt="The arguments provided to the <code>submit</code> method are listed below:",mt,Me,Ot='<li><p><strong><code>args</code></strong> defines the list of arguments to be provided to the <code>trl sft</code> command, provided as <code>trl sft --arg_1=value ...</code>.</p></li> <li><p><strong><code>replica_count</code></strong> defines the number of replicas to run the job in, for training normally this value will be set to one.</p></li> <li><p><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> define the machine i.e. Compute Engine instance, the accelerator (if any), and the number of accelerators (ranging from 1 to 8); respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</p></li> <li><p><strong><code>base_output_dir</code></strong> defines the base directory that will be mounted within the running container from the GCS Bucket, conditioned by the <code>staging_bucket</code> argument provided to the <code>aiplatform.init</code> initially.</p></li> <li><p>(optional) <strong><code>environment_variables</code></strong> defines the environment variables to define within the running container. As you are fine-tuning a gated model i.e. <a href="https://huggingface.co/mistralai/Mistral-7B-v0.3" rel="nofollow"><code>mistralai/Mistral-7B-v0.3</code></a>, you need to set the <code>HF_TOKEN</code> environment variable. Additionally, some other environment variables are defined to set the cache path (<code>HF_HOME</code>) and to ensure that the logging messages are streamed to Google Cloud Logs Explorer properly (<code>TRL_USE_RICH</code>, <code>ACCELERATE_LOG_LEVEL</code>, <code>TRANSFORMERS_LOG_LEVEL</code>, and <code>TQDM_POSITION</code>).</p></li> <li><p>(optional) <strong><code>timeout</code></strong> and <strong><code>create_request_timeout</code></strong> define the timeouts in seconds before interrupting the job execution or the job creation request (time to allocate required resources and start the execution), respectively.</p></li> <li><p>(optional) <strong><code>boot_disk_size</code></strong> defines the size in GiB of the boot disk, increased to store not only the model weights but also all the intermediate checkpoints if any; otherwise, it defaults to 100GiB which may not be sufficient in some cases.</p></li>',ht,de,ft,me,gt,he,yt,fe,Kt='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-scheduled.png" alt="Pipeline created in Vertex AI"/>',Tt,ge,en='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-completed.png" alt="Vertex AI Pipeline successfully completed"/>',wt,ye,tn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-pipeline-logs.png" alt="Vertex AI Pipeline logs"/>',bt,Te,nn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/vertex-ai-run.png" alt="Vertex AI Run"/>',jt,we,ln='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/trl-full-sft-fine-tuning-on-vertex-ai/assets/gcs-bucket-artifacts.png" alt="GCS Bucket with uploaded artifacts"/>',Jt,be,Ut,$,Ct,je,It,Ue,vt;return J=new Je({props:{title:"Fine-tune Mistral 7B v0.3 with PyTorch Training DLC using SFT on Vertex AI",local:"fine-tune-mistral-7b-v03-with-pytorch-training-dlc-using-sft-on-vertex-ai",headingTag:"h1"}}),A=new Je({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),E=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),V=new b({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMEJVQ0tFVF9VUkklM0RncyUzQSUyRiUyRmhmLXZlcnRleC1waXBlbGluZXMlMEElMjVlbnYlMjBDT05UQUlORVJfVVJJJTNEdXMtZG9ja2VyLnBrZy5kZXYlMkZkZWVwbGVhcm5pbmctcGxhdGZvcm0tcmVsZWFzZSUyRmdjci5pbyUyRmh1Z2dpbmdmYWNlLXB5dG9yY2gtdHJhaW5pbmctY3UxMjEuMi0zLnRyYW5zZm9ybWVycy40LTQyLnVidW50dTIyMDQucHkzMTA=",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env BUCKET_URI=gs://hf-vertex-pipelines
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-pytorch-training-cu121<span class="hljs-number">.2</span>-<span class="hljs-number">3.</span>transformers<span class="hljs-number">.4</span>-<span class="hljs-number">42.</span>ubuntu2204.py310`,wrap:!1}}),G=new b({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),S=new b({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),k=new Je({props:{title:"Optional: Create bucket in GCS",local:"optional-create-bucket-in-gcs",headingTag:"h2"}}),U=new Ce({props:{$$slots:{default:[Tn]},$$scope:{ctx:w}}}),W=new b({props:{code:"IWdjbG91ZCUyMHN0b3JhZ2UlMjBidWNrZXRzJTIwY3JlYXRlJTIwJTI0QlVDS0VUX1VSSSUyMC0tcHJvamVjdCUyMCUyNFBST0pFQ1RfSUQlMjAtLWxvY2F0aW9uJTNEJTI0TE9DQVRJT04lMjAtLWRlZmF1bHQtc3RvcmFnZS1jbGFzcyUzRFNUQU5EQVJEJTIwLS11bmlmb3JtLWJ1Y2tldC1sZXZlbC1hY2Nlc3M=",highlighted:'!gcloud storage buckets create $BUCKET_URI --project $PROJECT_ID --location=$LOCATION --default-storage-<span class="hljs-keyword">class</span>=STANDARD --uniform-bucket-level-access',wrap:!1}}),X=new Je({props:{title:"Prepare CustomContainerTrainingJob",local:"prepare-customcontainertrainingjob",headingTag:"h2"}}),H=new b({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBJTIwJTIwJTIwJTIwc3RhZ2luZ19idWNrZXQlM0Rvcy5nZXRlbnYoJTIyQlVDS0VUX1VSSSUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
    staging_bucket=os.getenv(<span class="hljs-string">&quot;BUCKET_URI&quot;</span>),
)`,wrap:!1}}),P=new b({props:{code:"JTI1JTI1d3JpdGVmaWxlJTIwJTIyLiUyRmFzc2V0cyUyRmRlZXBzcGVlZC55YW1sJTIyJTBBY29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGVlcHNwZWVkX2NvbmZpZyUzQSUwQSUyMCUyMGRlZXBzcGVlZF9tdWx0aW5vZGVfbGF1bmNoZXIlM0ElMjBzdGFuZGFyZCUwQSUyMCUyMG9mZmxvYWRfb3B0aW1pemVyX2RldmljZSUzQSUyMG5vbmUlMEElMjAlMjBvZmZsb2FkX3BhcmFtX2RldmljZSUzQSUyMG5vbmUlMEElMjAlMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBJTIwJTIwemVybzNfc2F2ZV8xNmJpdF9tb2RlbCUzQSUyMHRydWUlMEElMjAlMjB6ZXJvX3N0YWdlJTNBJTIwMyUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGJmMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDQlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdHB1X2VudiUzQSUyMCU1QiU1RCUwQXRwdV91c2VfY2x1c3RlciUzQSUyMGZhbHNlJTBBdHB1X3VzZV9zdWRvJTNBJTIwZmFsc2UlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`%%writefile <span class="hljs-string">&quot;./assets/deepspeed.yaml&quot;</span>
compute_environment: LOCAL_MACHINE
debug: false
deepspeed_config:
  deepspeed_multinode_launcher: standard
  offload_optimizer_device: none
  offload_param_device: none
  zero3_init_flag: true
  zero3_save_16bit_model: true
  zero_stage: <span class="hljs-number">3</span>
distributed_type: DEEPSPEED
downcast_bf16: <span class="hljs-string">&#x27;no&#x27;</span>
machine_rank: <span class="hljs-number">0</span>
main_training_function: main
mixed_precision: bf16
num_machines: <span class="hljs-number">1</span>
num_processes: <span class="hljs-number">4</span>
rdzv_backend: static
same_network: true
tpu_env: []
tpu_use_cluster: false
tpu_use_sudo: false
use_cpu: false`,wrap:!1}}),C=new Ce({props:{$$slots:{default:[wn]},$$scope:{ctx:w}}}),K=new b({props:{code:"am9iJTIwJTNEJTIwYWlwbGF0Zm9ybS5DdXN0b21Db250YWluZXJUcmFpbmluZ0pvYiglMEElMjAlMjAlMjAlMjBkaXNwbGF5X25hbWUlM0QlMjJ0cmwtZnVsbC1zZnQlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250YWluZXJfdXJpJTNEb3MuZ2V0ZW52KCUyMkNPTlRBSU5FUl9VUkklMjIpJTJDJTBBJTIwJTIwJTIwJTIwY29tbWFuZCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyLWMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjAlMjYlMjYlMjAlMjIuam9pbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWtkaXIlMjAtcCUyMCUyNEhGX0hPTUUlMkZhY2NlbGVyYXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMmVjaG8lMjAlNUMlMjIlN0JvcGVuKCcuJTJGYXNzZXRzJTJGZGVlcHNwZWVkLnlhbWwnKS5yZWFkKCklN0QlNUMlMjIlMjAlM0UlMjAlMjRIRl9IT01FJTJGYWNjZWxlcmF0ZSUyRmRlZmF1bHRfY29uZmlnLnlhbWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnZXhlYyUyMHRybCUyMHNmdCUyMCUyMiUyNCU0MCUyMiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMi0tJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKQ==",highlighted:`job = aiplatform.CustomContainerTrainingJob(
    display_name=<span class="hljs-string">&quot;trl-full-sft&quot;</span>,
    container_uri=os.getenv(<span class="hljs-string">&quot;CONTAINER_URI&quot;</span>),
    command=[
        <span class="hljs-string">&quot;sh&quot;</span>,
        <span class="hljs-string">&quot;-c&quot;</span>,
        <span class="hljs-string">&quot; &amp;&amp; &quot;</span>.join(
            (
                <span class="hljs-string">&quot;mkdir -p $HF_HOME/accelerate&quot;</span>,
                <span class="hljs-string">f&quot;echo \\&quot;<span class="hljs-subst">{<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;./assets/deepspeed.yaml&#x27;</span>).read()}</span>\\&quot; &gt; $HF_HOME/accelerate/default_config.yaml&quot;</span>,
                <span class="hljs-string">&#x27;exec trl sft &quot;$@&quot;&#x27;</span>,
            )
        ),
        <span class="hljs-string">&quot;--&quot;</span>,
    ],
)`,wrap:!1}}),ee=new Je({props:{title:"Define CustomContainerTrainingJob Requirements",local:"define-customcontainertrainingjob-requirements",headingTag:"h2"}}),se=new Je({props:{title:"Run CustomContainerTrainingJob",local:"run-customcontainertrainingjob",headingTag:"h2"}}),I=new Ce({props:{$$slots:{default:[bn]},$$scope:{ctx:w}}}),v=new Ce({props:{$$slots:{default:[jn]},$$scope:{ctx:w}}}),ce=new b({props:{code:"YXJncyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMyUyME1PREVMJTBBJTIwJTIwJTIwJTIwJTIyLS1tb2RlbF9uYW1lX29yX3BhdGglM0RtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLXRvcmNoX2R0eXBlJTNEYmZsb2F0MTYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLWF0dG5faW1wbGVtZW50YXRpb24lM0RmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMERBVEFTRVQlMEElMjAlMjAlMjAlMjAlMjItLWRhdGFzZXRfbmFtZSUzRHRpbWRldHRtZXJzJTJGb3BlbmFzc2lzdGFudC1ndWFuYWNvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1kYXRhc2V0X3RleHRfZmllbGQlM0R0ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwVFJBSU5FUiUwQSUyMCUyMCUyMCUyMCUyMi0tYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tbWF4X3NlcV9sZW5ndGglM0QxMDI0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1ncmFkaWVudF9jaGVja3BvaW50aW5nX3VzZV9yZWVudHJhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLWxlYXJuaW5nX3JhdGUlM0QwLjAwMDAyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1scl9zY2hlZHVsZXJfdHlwZSUzRGNvc2luZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tb3B0aW0lM0RhZGFtd19ibmJfOGJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tbnVtX3RyYWluX2Vwb2NocyUzRDElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLWxvZ2dpbmdfc3RlcHMlM0QxMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tZG9fZXZhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tZXZhbF9zdGVwcyUzRDEwMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tc2F2ZV9zdHJhdGVneSUzRGVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyLS1yZXBvcnRfdG8lM0Rub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZiUyMi0tb3V0cHV0X2RpciUzRCU3Qm9zLmdldGVudignQlVDS0VUX1VSSScpLnJlcGxhY2UoJ2dzJTNBJTJGJTJGJyUyQyUyMCclMkZnY3MlMkYnKSU3RCUyRk1pc3RyYWwtN0ItdjAuMy1TRlQtR3VhbmFjbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjItLXNlZWQlM0Q0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMi0tbG9nX2xldmVsJTNEaW5mbyUyMiUyQyUwQSU1RA==",highlighted:`args = [
    <span class="hljs-comment"># MODEL</span>
    <span class="hljs-string">&quot;--model_name_or_path=mistralai/Mistral-7B-v0.3&quot;</span>,
    <span class="hljs-string">&quot;--torch_dtype=bfloat16&quot;</span>,
    <span class="hljs-string">&quot;--attn_implementation=flash_attention_2&quot;</span>,
    <span class="hljs-comment"># DATASET</span>
    <span class="hljs-string">&quot;--dataset_name=timdettmers/openassistant-guanaco&quot;</span>,
    <span class="hljs-string">&quot;--dataset_text_field=text&quot;</span>,
    <span class="hljs-comment"># TRAINER</span>
    <span class="hljs-string">&quot;--bf16&quot;</span>,
    <span class="hljs-string">&quot;--max_seq_length=1024&quot;</span>,
    <span class="hljs-string">&quot;--per_device_train_batch_size=2&quot;</span>,
    <span class="hljs-string">&quot;--gradient_accumulation_steps=4&quot;</span>,
    <span class="hljs-string">&quot;--gradient_checkpointing&quot;</span>,
    <span class="hljs-string">&quot;--gradient_checkpointing_use_reentrant&quot;</span>,
    <span class="hljs-string">&quot;--learning_rate=0.00002&quot;</span>,
    <span class="hljs-string">&quot;--lr_scheduler_type=cosine&quot;</span>,
    <span class="hljs-string">&quot;--optim=adamw_bnb_8bit&quot;</span>,
    <span class="hljs-string">&quot;--num_train_epochs=1&quot;</span>,
    <span class="hljs-string">&quot;--logging_steps=10&quot;</span>,
    <span class="hljs-string">&quot;--do_eval&quot;</span>,
    <span class="hljs-string">&quot;--eval_steps=100&quot;</span>,
    <span class="hljs-string">&quot;--save_strategy=epoch&quot;</span>,
    <span class="hljs-string">&quot;--report_to=none&quot;</span>,
    <span class="hljs-string">f&quot;--output_dir=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>).replace(<span class="hljs-string">&#x27;gs://&#x27;</span>, <span class="hljs-string">&#x27;/gcs/&#x27;</span>)}</span>/Mistral-7B-v0.3-SFT-Guanaco&quot;</span>,
    <span class="hljs-string">&quot;--overwrite_output_dir&quot;</span>,
    <span class="hljs-string">&quot;--seed=42&quot;</span>,
    <span class="hljs-string">&quot;--log_level=info&quot;</span>,
]`,wrap:!1}}),de=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"!pip install --upgrade --quiet huggingface_hub",wrap:!1}}),me=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),he=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQSUwQWpvYi5zdWJtaXQoJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjByZXBsaWNhX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMG1hY2hpbmVfdHlwZSUzRCUyMmEyLWhpZ2hncHUtNGclMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl90eXBlJTNEJTIyTlZJRElBX1RFU0xBX0ExMDAlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl9jb3VudCUzRDQlMkMlMEElMjAlMjAlMjAlMjBiYXNlX291dHB1dF9kaXIlM0RmJTIyJTdCb3MuZ2V0ZW52KCdCVUNLRVRfVVJJJyklN0QlMkZNaXN0cmFsLTdCLXYwLjMtU0ZULUd1YW5hY28lMjIlMkMlMEElMjAlMjAlMjAlMjBlbnZpcm9ubWVudF92YXJpYWJsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIRl9IT01FJTIyJTNBJTIwJTIyJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySEZfVE9LRU4lMjIlM0ElMjBnZXRfdG9rZW4oKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRSTF9VU0VfUklDSCUyMiUzQSUyMCUyMjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJBQ0NFTEVSQVRFX0xPR19MRVZFTCUyMiUzQSUyMCUyMklORk8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUUkFOU0ZPUk1FUlNfTE9HX0xFVkVMJTIyJTNBJTIwJTIySU5GTyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRRRE1fUE9TSVRJT04lMjIlM0ElMjAlMjItMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHRpbWVvdXQlM0Q2MCUyMColMjA2MCUyMColMjAzJTJDJTIwJTIwJTIzJTIwMyUyMGhvdXJzJTIwKDEwODAwcyklMEElMjAlMjAlMjAlMjBjcmVhdGVfcmVxdWVzdF90aW1lb3V0JTNENjAlMjAqJTIwMTAlMkMlMjAlMjAlMjMlMjAxMCUyMG1pbnV0ZXMlMjAoNjAwcyklMEElMjAlMjAlMjAlMjBib290X2Rpc2tfc2l6ZV9nYiUzRDI1MCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

job.submit(
    args=args,
    replica_count=<span class="hljs-number">1</span>,
    machine_type=<span class="hljs-string">&quot;a2-highgpu-4g&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_TESLA_A100&quot;</span>,
    accelerator_count=<span class="hljs-number">4</span>,
    base_output_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;BUCKET_URI&#x27;</span>)}</span>/Mistral-7B-v0.3-SFT-Guanaco&quot;</span>,
    environment_variables={
        <span class="hljs-string">&quot;HF_HOME&quot;</span>: <span class="hljs-string">&quot;/root/.cache/huggingface&quot;</span>,
        <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: get_token(),
        <span class="hljs-string">&quot;TRL_USE_RICH&quot;</span>: <span class="hljs-string">&quot;0&quot;</span>,
        <span class="hljs-string">&quot;ACCELERATE_LOG_LEVEL&quot;</span>: <span class="hljs-string">&quot;INFO&quot;</span>,
        <span class="hljs-string">&quot;TRANSFORMERS_LOG_LEVEL&quot;</span>: <span class="hljs-string">&quot;INFO&quot;</span>,
        <span class="hljs-string">&quot;TQDM_POSITION&quot;</span>: <span class="hljs-string">&quot;-1&quot;</span>,
    },
    timeout=<span class="hljs-number">60</span> * <span class="hljs-number">60</span> * <span class="hljs-number">3</span>,  <span class="hljs-comment"># 3 hours (10800s)</span>
    create_request_timeout=<span class="hljs-number">60</span> * <span class="hljs-number">10</span>,  <span class="hljs-comment"># 10 minutes (600s)</span>
    boot_disk_size_gb=<span class="hljs-number">250</span>,
)`,wrap:!1}}),be=new Je({props:{title:"Finally, you can upload the fine-tuned model to the Hugging Face Hub, or just keep it within the Google Cloud Storage (GCS) Bucket. Later on, you will be able to run the inference on top of it via either the Hugging Face PyTorch DLC for inference via the pipeline in transformers , or via the Hugging Face DLC for TGI (as the model is fine-tuned for text-generation ).",local:"finally-you-can-upload-the-fine-tuned-model-to-the-hugging-face-hub-or-just-keep-it-within-the-google-cloud-storage-gcs-bucket-later-on-you-will-be-able-to-run-the-inference-on-top-of-it-via-either-the-hugging-face-pytorch-dlc-for-inference-via-the-pipeline-in-transformers--or-via-the-hugging-face-dlc-for-tgi-as-the-model-is-fine-tuned-for-text-generation-",headingTag:"h2"}}),$=new Ce({props:{$$slots:{default:[Jn]},$$scope:{ctx:w}}}),je=new yn({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-trl-full-sft-fine-tuning-on-vertex-ai.mdx"}}),{c(){o=a("meta"),y=i(),u=a("p"),g=i(),p(J.$$.fragment),T=i(),j=a("p"),j.innerHTML=$t,ve=i(),_=a("p"),_.textContent=_t,$e=i(),p(A.$$.fragment),_e=i(),Z=a("p"),Z.innerHTML=At,Ae=i(),R=a("p"),R.innerHTML=Zt,Ze=i(),p(E.$$.fragment),Re=i(),x=a("p"),x.textContent=Rt,Ee=i(),p(V.$$.fragment),xe=i(),B=a("p"),B.textContent=Et,Ve=i(),p(G.$$.fragment),Be=i(),L=a("p"),L.textContent=xt,Ge=i(),p(S.$$.fragment),Le=i(),p(k.$$.fragment),Se=i(),p(U.$$.fragment),ke=i(),F=a("p"),F.innerHTML=Vt,Fe=i(),p(W.$$.fragment),We=i(),p(X.$$.fragment),Xe=i(),q=a("p"),q.innerHTML=Bt,qe=i(),p(H.$$.fragment),He=i(),N=a("p"),N.innerHTML=Gt,Ne=i(),Q=a("p"),Q.innerHTML=Lt,Qe=i(),Y=a("ul"),Y.innerHTML=St,Ye=i(),z=a("p"),z.innerHTML=kt,ze=i(),p(P.$$.fragment),Pe=i(),D=a("p"),D.innerHTML=Ft,De=i(),O=a("ol"),O.innerHTML=Wt,Oe=i(),p(C.$$.fragment),Ke=i(),p(K.$$.fragment),et=i(),p(ee.$$.fragment),tt=i(),te=a("p"),te.innerHTML=Xt,nt=i(),ne=a("p"),ne.innerHTML=qt,lt=i(),le=a("p"),le.innerHTML=Ht,it=i(),ie=a("p"),ie.innerHTML=Nt,st=i(),p(se.$$.fragment),ot=i(),oe=a("p"),oe.innerHTML=Qt,at=i(),p(I.$$.fragment),rt=i(),ae=a("p"),ae.innerHTML=Yt,ct=i(),re=a("p"),re.innerHTML=zt,ut=i(),p(v.$$.fragment),pt=i(),p(ce.$$.fragment),Mt=i(),ue=a("p"),ue.innerHTML=Pt,dt=i(),pe=a("p"),pe.innerHTML=Dt,mt=i(),Me=a("ul"),Me.innerHTML=Ot,ht=i(),p(de.$$.fragment),ft=i(),p(me.$$.fragment),gt=i(),p(he.$$.fragment),yt=i(),fe=a("p"),fe.innerHTML=Kt,Tt=i(),ge=a("p"),ge.innerHTML=en,wt=i(),ye=a("p"),ye.innerHTML=tn,bt=i(),Te=a("p"),Te.innerHTML=nn,jt=i(),we=a("p"),we.innerHTML=ln,Jt=i(),p(be.$$.fragment),Ut=i(),p($.$$.fragment),Ct=i(),p(je.$$.fragment),It=i(),Ue=a("p"),this.h()},l(e){const t=fn("svelte-u9bgzb",document.head);o=r(t,"META",{name:!0,content:!0}),t.forEach(n),y=s(e),u=r(e,"P",{}),un(u).forEach(n),g=s(e),M(J.$$.fragment,e),T=s(e),j=r(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1r6b2zf"&&(j.innerHTML=$t),ve=s(e),_=r(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1rm13w4"&&(_.textContent=_t),$e=s(e),M(A.$$.fragment,e),_e=s(e),Z=r(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1o67gfb"&&(Z.innerHTML=At),Ae=s(e),R=r(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1ebrquh"&&(R.innerHTML=Zt),Ze=s(e),M(E.$$.fragment,e),Re=s(e),x=r(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1i8n6rq"&&(x.textContent=Rt),Ee=s(e),M(V.$$.fragment,e),xe=s(e),B=r(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-15nvzfz"&&(B.textContent=Et),Ve=s(e),M(G.$$.fragment,e),Be=s(e),L=r(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1nm8o2l"&&(L.textContent=xt),Ge=s(e),M(S.$$.fragment,e),Le=s(e),M(k.$$.fragment,e),Se=s(e),M(U.$$.fragment,e),ke=s(e),F=r(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-48jxyw"&&(F.innerHTML=Vt),Fe=s(e),M(W.$$.fragment,e),We=s(e),M(X.$$.fragment,e),Xe=s(e),q=r(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-169vc8o"&&(q.innerHTML=Bt),qe=s(e),M(H.$$.fragment,e),He=s(e),N=r(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-5olot6"&&(N.innerHTML=Gt),Ne=s(e),Q=r(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1tdnehm"&&(Q.innerHTML=Lt),Qe=s(e),Y=r(e,"UL",{"data-svelte-h":!0}),c(Y)!=="svelte-oihk84"&&(Y.innerHTML=St),Ye=s(e),z=r(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-jsb5oe"&&(z.innerHTML=kt),ze=s(e),M(P.$$.fragment,e),Pe=s(e),D=r(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-w5gycc"&&(D.innerHTML=Ft),De=s(e),O=r(e,"OL",{"data-svelte-h":!0}),c(O)!=="svelte-1q4i1bb"&&(O.innerHTML=Wt),Oe=s(e),M(C.$$.fragment,e),Ke=s(e),M(K.$$.fragment,e),et=s(e),M(ee.$$.fragment,e),tt=s(e),te=r(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-1hcwwpn"&&(te.innerHTML=Xt),nt=s(e),ne=r(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-gy0104"&&(ne.innerHTML=qt),lt=s(e),le=r(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1qv2h88"&&(le.innerHTML=Ht),it=s(e),ie=r(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-93ywpw"&&(ie.innerHTML=Nt),st=s(e),M(se.$$.fragment,e),ot=s(e),oe=r(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-9gv9c8"&&(oe.innerHTML=Qt),at=s(e),M(I.$$.fragment,e),rt=s(e),ae=r(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-1h96pqn"&&(ae.innerHTML=Yt),ct=s(e),re=r(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-1u6w4tj"&&(re.innerHTML=zt),ut=s(e),M(v.$$.fragment,e),pt=s(e),M(ce.$$.fragment,e),Mt=s(e),ue=r(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1dy7udt"&&(ue.innerHTML=Pt),dt=s(e),pe=r(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-c8lo6u"&&(pe.innerHTML=Dt),mt=s(e),Me=r(e,"UL",{"data-svelte-h":!0}),c(Me)!=="svelte-3qxazp"&&(Me.innerHTML=Ot),ht=s(e),M(de.$$.fragment,e),ft=s(e),M(me.$$.fragment,e),gt=s(e),M(he.$$.fragment,e),yt=s(e),fe=r(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-13bkehl"&&(fe.innerHTML=Kt),Tt=s(e),ge=r(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-7d5aoo"&&(ge.innerHTML=en),wt=s(e),ye=r(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-120stu7"&&(ye.innerHTML=tn),bt=s(e),Te=r(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-i2tmwy"&&(Te.innerHTML=nn),jt=s(e),we=r(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-1fqsw"&&(we.innerHTML=ln),Jt=s(e),M(be.$$.fragment,e),Ut=s(e),M($.$$.fragment,e),Ct=s(e),M(je.$$.fragment,e),It=s(e),Ue=r(e,"P",{}),un(Ue).forEach(n),this.h()},h(){pn(o,"name","hf:doc:metadata"),pn(o,"content",Cn)},m(e,t){gn(document.head,o),l(e,y,t),l(e,u,t),l(e,g,t),d(J,e,t),l(e,T,t),l(e,j,t),l(e,ve,t),l(e,_,t),l(e,$e,t),d(A,e,t),l(e,_e,t),l(e,Z,t),l(e,Ae,t),l(e,R,t),l(e,Ze,t),d(E,e,t),l(e,Re,t),l(e,x,t),l(e,Ee,t),d(V,e,t),l(e,xe,t),l(e,B,t),l(e,Ve,t),d(G,e,t),l(e,Be,t),l(e,L,t),l(e,Ge,t),d(S,e,t),l(e,Le,t),d(k,e,t),l(e,Se,t),d(U,e,t),l(e,ke,t),l(e,F,t),l(e,Fe,t),d(W,e,t),l(e,We,t),d(X,e,t),l(e,Xe,t),l(e,q,t),l(e,qe,t),d(H,e,t),l(e,He,t),l(e,N,t),l(e,Ne,t),l(e,Q,t),l(e,Qe,t),l(e,Y,t),l(e,Ye,t),l(e,z,t),l(e,ze,t),d(P,e,t),l(e,Pe,t),l(e,D,t),l(e,De,t),l(e,O,t),l(e,Oe,t),d(C,e,t),l(e,Ke,t),d(K,e,t),l(e,et,t),d(ee,e,t),l(e,tt,t),l(e,te,t),l(e,nt,t),l(e,ne,t),l(e,lt,t),l(e,le,t),l(e,it,t),l(e,ie,t),l(e,st,t),d(se,e,t),l(e,ot,t),l(e,oe,t),l(e,at,t),d(I,e,t),l(e,rt,t),l(e,ae,t),l(e,ct,t),l(e,re,t),l(e,ut,t),d(v,e,t),l(e,pt,t),d(ce,e,t),l(e,Mt,t),l(e,ue,t),l(e,dt,t),l(e,pe,t),l(e,mt,t),l(e,Me,t),l(e,ht,t),d(de,e,t),l(e,ft,t),d(me,e,t),l(e,gt,t),d(he,e,t),l(e,yt,t),l(e,fe,t),l(e,Tt,t),l(e,ge,t),l(e,wt,t),l(e,ye,t),l(e,bt,t),l(e,Te,t),l(e,jt,t),l(e,we,t),l(e,Jt,t),d(be,e,t),l(e,Ut,t),d($,e,t),l(e,Ct,t),d(je,e,t),l(e,It,t),l(e,Ue,t),vt=!0},p(e,[t]){const sn={};t&2&&(sn.$$scope={dirty:t,ctx:e}),U.$set(sn);const on={};t&2&&(on.$$scope={dirty:t,ctx:e}),C.$set(on);const an={};t&2&&(an.$$scope={dirty:t,ctx:e}),I.$set(an);const rn={};t&2&&(rn.$$scope={dirty:t,ctx:e}),v.$set(rn);const cn={};t&2&&(cn.$$scope={dirty:t,ctx:e}),$.$set(cn)},i(e){vt||(m(J.$$.fragment,e),m(A.$$.fragment,e),m(E.$$.fragment,e),m(V.$$.fragment,e),m(G.$$.fragment,e),m(S.$$.fragment,e),m(k.$$.fragment,e),m(U.$$.fragment,e),m(W.$$.fragment,e),m(X.$$.fragment,e),m(H.$$.fragment,e),m(P.$$.fragment,e),m(C.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(I.$$.fragment,e),m(v.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(he.$$.fragment,e),m(be.$$.fragment,e),m($.$$.fragment,e),m(je.$$.fragment,e),vt=!0)},o(e){h(J.$$.fragment,e),h(A.$$.fragment,e),h(E.$$.fragment,e),h(V.$$.fragment,e),h(G.$$.fragment,e),h(S.$$.fragment,e),h(k.$$.fragment,e),h(U.$$.fragment,e),h(W.$$.fragment,e),h(X.$$.fragment,e),h(H.$$.fragment,e),h(P.$$.fragment,e),h(C.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(I.$$.fragment,e),h(v.$$.fragment,e),h(ce.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(be.$$.fragment,e),h($.$$.fragment,e),h(je.$$.fragment,e),vt=!1},d(e){e&&(n(y),n(u),n(g),n(T),n(j),n(ve),n(_),n($e),n(_e),n(Z),n(Ae),n(R),n(Ze),n(Re),n(x),n(Ee),n(xe),n(B),n(Ve),n(Be),n(L),n(Ge),n(Le),n(Se),n(ke),n(F),n(Fe),n(We),n(Xe),n(q),n(qe),n(He),n(N),n(Ne),n(Q),n(Qe),n(Y),n(Ye),n(z),n(ze),n(Pe),n(D),n(De),n(O),n(Oe),n(Ke),n(et),n(tt),n(te),n(nt),n(ne),n(lt),n(le),n(it),n(ie),n(st),n(ot),n(oe),n(at),n(rt),n(ae),n(ct),n(re),n(ut),n(pt),n(Mt),n(ue),n(dt),n(pe),n(mt),n(Me),n(ht),n(ft),n(gt),n(yt),n(fe),n(Tt),n(ge),n(wt),n(ye),n(bt),n(Te),n(jt),n(we),n(Jt),n(Ut),n(Ct),n(It),n(Ue)),n(o),f(J,e),f(A,e),f(E,e),f(V,e),f(G,e),f(S,e),f(k,e),f(U,e),f(W,e),f(X,e),f(H,e),f(P,e),f(C,e),f(K,e),f(ee,e),f(se,e),f(I,e),f(v,e),f(ce,e),f(de,e),f(me,e),f(he,e),f(be,e),f($,e),f(je,e)}}}const Cn='{"title":"Fine-tune Mistral 7B v0.3 with PyTorch Training DLC using SFT on Vertex AI","local":"fine-tune-mistral-7b-v03-with-pytorch-training-dlc-using-sft-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Optional: Create bucket in GCS","local":"optional-create-bucket-in-gcs","sections":[],"depth":2},{"title":"Prepare CustomContainerTrainingJob","local":"prepare-customcontainertrainingjob","sections":[],"depth":2},{"title":"Define CustomContainerTrainingJob Requirements","local":"define-customcontainertrainingjob-requirements","sections":[],"depth":2},{"title":"Run CustomContainerTrainingJob","local":"run-customcontainertrainingjob","sections":[],"depth":2},{"title":"Finally, you can upload the fine-tuned model to the Hugging Face Hub, or just keep it within the Google Cloud Storage (GCS) Bucket. Later on, you will be able to run the inference on top of it via either the Hugging Face PyTorch DLC for inference via the pipeline in transformers , or via the Hugging Face DLC for TGI (as the model is fine-tuned for text-generation ).","local":"finally-you-can-upload-the-fine-tuned-model-to-the-hugging-face-hub-or-just-keep-it-within-the-google-cloud-storage-gcs-bucket-later-on-you-will-be-able-to-run-the-inference-on-top-of-it-via-either-the-hugging-face-pytorch-dlc-for-inference-via-the-pipeline-in-transformers--or-via-the-hugging-face-dlc-for-tgi-as-the-model-is-fine-tuned-for-text-generation-","sections":[],"depth":2}],"depth":1}';function In(w){return dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rn extends mn{constructor(o){super(),hn(this,o,In,Un,Mn,{})}}export{Rn as component};
