import{s as Xn,o as Fn,n as yt}from"../chunks/scheduler.b108d059.js";import{S as Yn,i as Pn,g as o,s,r as c,A as Hn,h as i,f as l,c as a,j as b,u as p,x as r,k as Bn,y,a as n,v as M,d,t as T,w as h}from"../chunks/index.008de539.js";import{T as Jt}from"../chunks/Tip.aeb15ab7.js";import{C as w}from"../chunks/CodeBlock.3968c746.js";import{H as g,E as Dn}from"../chunks/EditOnGithub.d1c48e3d.js";function zn(f){let u,m='GPU support on Cloud Run is only available as a waitlisted public preview. If you’re interested in trying out the feature, <a href="https://cloud.google.com/run/quotas#increase" rel="nofollow">request a quota increase</a> for <code>Total Nvidia L4 GPU allocation, per project per region</code>. At the time of writing this example, NVIDIA L4 GPUs (24GiB VRAM) are the only available GPUs on Cloud Run; enabling automatic scaling up to 7 instances by default (more available via quota), as well as scaling down to zero instances when there are no requests.';return{c(){u=o("p"),u.innerHTML=m},l(J){u=i(J,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1bcphve"&&(u.innerHTML=m)},m(J,U){n(J,u,U)},p:yt,d(J){J&&l(u)}}}function On(f){let u,m="The first time you deploy a new container on Cloud Run it will take around 5 minutes to deploy as it needs to import it from the Google Cloud Artifact Registry, but on the follow up deployments it will take less time as the image has been already imported before.";return{c(){u=o("p"),u.textContent=m},l(J){u=i(J,"P",{"data-svelte-h":!0}),r(u)!=="svelte-18e6hwd"&&(u.textContent=m)},m(J,U){n(J,u,U)},p:yt,d(J){J&&l(u)}}}function Kn(f){let u,m='The alternatives mentioned below are for development scenarios, and should not be used in production-ready scenarios as is. The approach below is following the guide defined in <a href="https://cloud.google.com/run/docs/authenticating/developers" rel="nofollow">Cloud Run Documentation - Authenticate Developers</a>; but you can find every other guide as mentioned above in <a href="https://cloud.google.com/run/docs/authenticating/overview" rel="nofollow">Cloud Run Documentation - Authentication overview</a>.';return{c(){u=o("p"),u.innerHTML=m},l(J){u=i(J,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1qznp3b"&&(u.innerHTML=m)},m(J,U){n(J,u,U)},p:yt,d(J){J&&l(u)}}}function es(f){let u,m="Note that the examples below are using the <code>/v1/chat/completions</code> TGI endpoint with is OpenAI-compatible, meaning that both <code>cURL</code> and Python are just some proposals, but any OpenAI-compatible client can be used instead.";return{c(){u=o("p"),u.innerHTML=m},l(J){u=i(J,"P",{"data-svelte-h":!0}),r(u)!=="svelte-11wzgde"&&(u.innerHTML=m)},m(J,U){n(J,u,U)},p:yt,d(J){J&&l(u)}}}function ts(f){let u,m="The access token is short-lived and will expire, by default after 1 hour. If you want to extend the token lifetime beyond the default, you must create and organization policy and use the <code>--lifetime</code> argument when createing the token. Refer to (Access token lifetime)[[https://cloud.google.com/resource-manager/docs/organization-policy/restricting-service-accounts#extend_oauth_ttl]] to learn more. Otherwise, you can also generate a new token by running the same command again.";return{c(){u=o("p"),u.innerHTML=m},l(J){u=i(J,"P",{"data-svelte-h":!0}),r(u)!=="svelte-jzjamm"&&(u.innerHTML=m)},m(J,U){n(J,u,U)},p:yt,d(J){J&&l(u)}}}function ls(f){let u,m="Note that the examples below are using the <code>/v1/chat/completions</code> TGI endpoint with is OpenAI-compatible, meaning that both <code>cURL</code> and Python are just some proposals, but any OpenAI-compatible client can be used instead.";return{c(){u=o("p"),u.innerHTML=m},l(J){u=i(J,"P",{"data-svelte-h":!0}),r(u)!=="svelte-11wzgde"&&(u.innerHTML=m)},m(J,U){n(J,u,U)},p:yt,d(J){J&&l(u)}}}function ns(f){let u,m,J,U,Z,wt,L,en="Meta Llama 3.1 is the latest open LLM from Meta, released in July 2024. Meta Llama 3.1 comes in three sizes: 8B for efficient deployment and development on consumer-size GPU, 70B for large-scale AI native applications, and 405B for synthetic data, LLM as a Judge or distillation; among other use cases. Text Generation Inference (TGI) is a toolkit developed by Hugging Face for deploying and serving LLMs, with high performance text generation. Google Cloud Run is a serverless container platform that allows developers to deploy and manage containerized applications without managing infrastructure, enabling automatic scaling and billing only for usage.",Ut,q,tn='This example showcases how to deploy an LLM from the Hugging Face Hub, in this case Meta Llama 3.1 8B Instruct model quantized to INT4 using AWQ, with the Hugging Face DLC for TGI on Google Cloud Run with GPU support (<a href="https://cloud.google.com/products#product-launch-stages" rel="nofollow">in preview</a>).',gt,v,ft,G,It,x,ln='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',Ct,k,nn="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",jt,W,$t,_,sn="Then you need to login into your Google Cloud account and set the project ID you want to use to deploy Cloud Run.",bt,Q,vt,B,an="Once you are logged in, you need to enable the Cloud Run API, which is required for the Hugging Face DLC for TGI deployment on Cloud Run.",At,X,Vt,F,Et,Y,on="Once you are all set, you can call the <code>gcloud beta run deploy</code> command (still on beta because GPU support is on preview, as mentioned above).",Rt,P,un="The <code>gcloud beta run deploy</code> command needs you to specify the following parameters:",Nt,H,rn='<li><code>--image</code>: The container image URI to deploy.</li> <li><code>--args</code>: The arguments to pass to the container entrypoint, being <code>text-generation-launcher</code> for the Hugging Face DLC for TGI. Read more about the supported arguments at <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher" rel="nofollow">Text-generation-launcher arguments</a>.<ul><li><code>--model-id</code>: The model ID to use, in this case, <a href="https://huggingface.co/hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4" rel="nofollow"><code>hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4</code></a>.</li> <li><code>--quantize</code>: The quantization method to use, in this case, <code>awq</code>. If not specified, it will be retrieved from the <code>quantization_config-&gt;quant_method</code> in the <code>config.json</code> file.</li></ul></li> <li><code>--port</code>: The port the container listens to.</li> <li><code>--cpu</code> and <code>--memory</code>: The number of CPUs and amount of memory to allocate to the container. Needs to be set to 4 and 16Gi (16 GiB), respectively; as that’s the minimum requirement for using the GPU.</li> <li><code>--no-cpu-throttling</code>: Disables CPU throttling, which is required for using the GPU.</li> <li><code>--gpu</code> and <code>--gpu-type</code>: The number of GPUs and the GPU type to use. Needs to be set to 1 and <code>nvidia-l4</code>, respectively; as at the time of writing this tutorial, those are the only available options as Cloud Run on GPUs is still under preview.</li> <li><code>--max-instances</code>: The maximum number of instances to run, set to 3, but default maximum value is 7. Alternatively, one could set it to 1 too, but that could eventually lead to downtime during infrastructure migrations, so anything above 1 is recommended.</li> <li><code>--concurrency</code>: the maximum number of concurrent requests per instance, set to 64. The value is not arbitrary, but determined after running and evaluating the results of <a href="https://github.com/huggingface/text-generation-inference/tree/main/benchmark" rel="nofollow"><code>text-generation-benchmark</code></a>, as the most optimal balance between throughput and latency; where the current default for TGI being 128 is a bit too much. Note that this value is also aligned with the <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher#maxconcurrentrequests" rel="nofollow"><code>--max-concurrent-requests</code></a> argument in TGI.</li> <li><code>--region</code>: The region to deploy the Cloud Run service.</li> <li><code>--no-allow-unauthenticated</code>: Disables unauthenticated access to the service, which is a good practice as adds an authentication layer managed by Google Cloud IAM.</li>',St,D,Zt,z,cn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/cloud-run/tgi-deployment/imgs/cloud-run-deployment.png" alt="Cloud Run Deployment"/>',Lt,O,pn='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/cloud-run/tgi-deployment/imgs/cloud-run-details.png" alt="Cloud Run Deployment Details"/>',qt,A,Gt,K,xt,ee,Mn='Once deployed, you can send requests to the service via any of the supported TGI endpoints, check <a href="https://huggingface.github.io/text-generation-inference/" rel="nofollow">TGI’s OpenAPI Specification</a> to see all the available endpoints and their respective parameters.',kt,te,dn="All Cloud Run services are deployed privately by default, which means that they can’t be accessed without providing authentication credentials in the request headers. These services are secured by IAM and are only callable by Project Owners, Project Editors, and Cloud Run Admins and Cloud Run Invokers.",Wt,le,Tn='In this case, a couple of alternatives to enable developer access will be showcased; while the other use cases are out of the scope of this example, as those are either not secure due to the authentication being disabled (for public access scenarios), or require additional setup for production-ready scenarios (<a href="https://cloud.google.com/run/docs/authenticating/service-to-service" rel="nofollow">service-to-service authentication</a>, <a href="https://cloud.google.com/run/docs/authenticating/end-users" rel="nofollow">end-user access</a>).',_t,V,Qt,ne,Bt,se,hn="Cloud Run Proxy runs a server on localhost that proxies requests to the specified Cloud Run Service with credentials attached; which is useful for testing and experimentation.",Xt,ae,Ft,oe,Jn='Then you can send requests to the deployed service on Cloud Run, using the <a href="http://localhost:8080" rel="nofollow">http://localhost:8080</a> URL, with no authentication, exposed by the proxy as shown in the examples below.',Yt,E,Pt,ie,Ht,ue,yn="To send a POST request to the TGI service using <code>cURL</code>, you can run the following command:",Dt,re,zt,ce,Ot,pe,mn="To run the inference using Python, you can either use the <code>huggingface_hub</code> Python SDK (recommended) or the <code>openai</code> Python SDK.",Kt,Me,el,de,wn="You can install it via <code>pip</code> as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",tl,Te,ll,he,nl,Je,Un="You can install it via <code>pip</code> as <code>pip install --upgrade openai</code>, and then run:",sl,ye,al,me,ol,we,gn="Cloud Run Service has an unique URL assigned that can be used to send requests from anywhere, using the Google Cloud Credentials with Cloud Run Invoke access to the service; which is the recommended approach as it’s more secure and consistent than using the Cloud Run Proxy.",il,Ue,fn="The URL of the Cloud Run service can be obtained via the following command (assigned to the <code>SERVICE_URL</code> variable for convenience):",ul,ge,rl,fe,In="Then you can send requests to the deployed service on Cloud Run, using the <code>SERVICE_URL</code> and any Google Cloud Credentials with Cloud Run Invoke access. For setting up the credentials there are multiple approaches, some of those are listed below:",cl,R,I,ut,Cn="Using the default identity token from the Google Cloud SDK:",_l,rt,jn="<li>Via <code>gcloud</code> as:</li>",Ql,Ie,Bl,ct,$n="<li>Via Python as:</li>",Xl,Ce,Fl,pt,bn="<p>Using a Service Account with Cloud Run Invoke access, which can either be done with any of the following approaches:</p> <ul><li>Create a Service Account before the Cloud Run Service was created, and then set the <code>--service-account</code> flag to the Service Account email when creating the Cloud Run Service. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.</li> <li>Create a Service Account after the Cloud Run Service was created, and then update the Cloud Run Service to use the Service Account. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.</li></ul>",pl,je,vn="The recommended approach is to use a Service Account (SA), as the access can be controlled better and the permissions are more granular; as the Cloud Run Service was not created using a SA, which is another nice option, you need to now create the SA, gran it the necessary permissions, update the Cloud Run Service to use the SA, and then generate an access token to set as the authentication token within the requests, that can be revoked later once you are done using it.",Ml,j,$e,Mt,An="Set the <code>SERVICE_ACCOUNT_NAME</code> environment variable for convenience:",Yl,be,Pl,ve,dt,Vn="Create the Service Account:",Hl,Ae,Dl,Ve,Tt,En="Grant the Service Account the Cloud Run Invoker role:",zl,Ee,Ol,Re,ht,Rn="Generate the Access Token for the Service Account:",Kl,Ne,dl,N,Tl,Se,Nn="Now you can already dive into the different alternatives for sending the requests to the deployed Cloud Run Service using the <code>SERVICE_URL</code> AND <code>ACCESS_TOKEN</code> as described above.",hl,S,Jl,Ze,yl,Le,Sn="To send a POST request to the TGI service using <code>cURL</code>, you can run the following command:",ml,qe,wl,Ge,Ul,xe,Zn="To run the inference using Python, you can either use the <code>huggingface_hub</code> Python SDK (recommended) or the <code>openai</code> Python SDK.",gl,ke,fl,We,Ln="You can install it via <code>pip</code> as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",Il,_e,Cl,Qe,jl,Be,qn="You can install it via <code>pip</code> as <code>pip install --upgrade openai</code>, and then run:",$l,Xe,bl,Fe,vl,Ye,Gn="Finally, once you are done using TGI on the Cloud Run Service, you can safely delete it to avoid incurring in unnecessary costs e.g. if the Cloud Run services are inadvertently invoked more times than your monthly Cloud Run invokement allocation in the free tier.",Al,Pe,xn='To delete the Cloud Run Service you can either go to the Google Cloud Console at <a href="https://console.cloud.google.com/run" rel="nofollow">https://console.cloud.google.com/run</a> and delete it manually; or use the Google Cloud SDK via <code>gcloud</code> as follows:',Vl,He,El,De,kn='Additionally, if you followed the steps in <a href="#via-cloud-run-service-url">via Cloud Run Service URL</a> and generated a Service Account and an access token, you can either remove the Service Account, or just revoke the access token if it is still valid.',Rl,ze,Wn="<li>(recommended) Revoke the Access Token as</li>",Nl,Oe,Sl,Ke,_n="<li>(optional) Delete the Service Account as:</li>",Zl,et,Ll,tt,ql,lt,Qn='<li><a href="https://cloud.google.com/run/docs" rel="nofollow">Cloud Run Documentation - Overview</a></li> <li><a href="https://cloud.google.com/run/docs/configuring/services/gpu" rel="nofollow">Cloud Run Documentation - GPU services</a></li> <li><a href="https://cloud.google.com/blog/products/application-development/run-your-ai-inference-applications-on-cloud-run-with-nvidia-gpus" rel="nofollow">Google Cloud Blog - Run your AI inference applications on Cloud Run with NVIDIA GPUs</a></li>',Gl,nt,xl,mt,kl;return Z=new g({props:{title:"Deploy Meta Llama 3.1 8B with TGI DLC on Cloud Run",local:"deploy-meta-llama-31-8b-with-tgi-dlc-on-cloud-run",headingTag:"h1"}}),v=new Jt({props:{$$slots:{default:[zn]},$$scope:{ctx:f}}}),G=new g({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),W=new w({props:{code:"ZXhwb3J0JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQWV4cG9ydCUyMExPQ0FUSU9OJTNEdXMtY2VudHJhbDElMjAlMjMlMjBvciUyMGFueSUyMGxvY2F0aW9uJTIwd2hlcmUlMjBDbG91ZCUyMFJ1biUyMG9mZmVycyUyMEdQVXMlM0ElMjBodHRwcyUzQSUyRiUyRmNsb3VkLmdvb2dsZS5jb20lMkZydW4lMkZkb2NzJTJGbG9jYXRpb25zJTIzZ3B1JTBBZXhwb3J0JTIwQ09OVEFJTkVSX1VSSSUzRHVzLWRvY2tlci5wa2cuZGV2JTJGZGVlcGxlYXJuaW5nLXBsYXRmb3JtLXJlbGVhc2UlMkZnY3IuaW8lMkZodWdnaW5nZmFjZS10ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlLWN1MTIxLjItMi51YnVudHUyMjA0LnB5MzEwJTBBZXhwb3J0JTIwU0VSVklDRV9OQU1FJTNEdGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZQ==",highlighted:`<span class="hljs-built_in">export</span> PROJECT_ID=your-project-id
<span class="hljs-built_in">export</span> LOCATION=us-central1 <span class="hljs-comment"># or any location where Cloud Run offers GPUs: https://cloud.google.com/run/docs/locations#gpu</span>
<span class="hljs-built_in">export</span> CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu121.2-2.ubuntu2204.py310
<span class="hljs-built_in">export</span> SERVICE_NAME=text-generation-inference`,wrap:!1}}),Q=new w({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMGxvZ2luJTBBZ2Nsb3VkJTIwYXV0aCUyMGFwcGxpY2F0aW9uLWRlZmF1bHQlMjBsb2dpbiUyMCUyMCUyMyUyMEZvciUyMGxvY2FsJTIwZGV2ZWxvcG1lbnQlMEFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`gcloud auth login
gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
gcloud config <span class="hljs-built_in">set</span> project <span class="hljs-variable">$PROJECT_ID</span>`,wrap:!1}}),X=new w({props:{code:"Z2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBydW4uZ29vZ2xlYXBpcy5jb20=",highlighted:'gcloud services <span class="hljs-built_in">enable</span> run.googleapis.com',wrap:!1}}),F=new g({props:{title:"Deploy TGI on Cloud Run",local:"deploy-tgi-on-cloud-run",headingTag:"h2"}}),D=new w({props:{code:"Z2Nsb3VkJTIwYmV0YSUyMHJ1biUyMGRlcGxveSUyMCUyNFNFUlZJQ0VfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0taW1hZ2UlM0QlMjRDT05UQUlORVJfVVJJJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1hcmdzJTNEJTIyLS1tb2RlbC1pZCUzRGh1Z2dpbmctcXVhbnRzJTJGTWV0YS1MbGFtYS0zLjEtOEItSW5zdHJ1Y3QtQVdRLUlOVDQlMkMtLXF1YW50aXplJTNEYXdxJTJDLS1tYXgtY29uY3VycmVudC1yZXF1ZXN0cyUzRDY0JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wb3J0JTNEODA4MCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3B1JTNENCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWVtb3J5JTNEMTZHaSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbm8tY3B1LXRocm90dGxpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdSUzRDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdS10eXBlJTNEbnZpZGlhLWw0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXgtaW5zdGFuY2VzJTNEMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY29uY3VycmVuY3klM0Q2NCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWFsbG93LXVuYXV0aGVudGljYXRlZA==",highlighted:`gcloud beta run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4,--quantize=awq,--max-concurrent-requests=64&quot;</span> \\
    --port=8080 \\
    --cpu=4 \\
    --memory=16Gi \\
    --no-cpu-throttling \\
    --gpu=1 \\
    --gpu-type=nvidia-l4 \\
    --max-instances=3 \\
    --concurrency=64 \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated`,wrap:!1}}),A=new Jt({props:{$$slots:{default:[On]},$$scope:{ctx:f}}}),K=new g({props:{title:"Inference on Cloud Run",local:"inference-on-cloud-run",headingTag:"h2"}}),V=new Jt({props:{$$slots:{default:[Kn]},$$scope:{ctx:f}}}),ne=new g({props:{title:"Via Cloud Run Proxy",local:"via-cloud-run-proxy",headingTag:"h3"}}),ae=new w({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBwcm94eSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04=",highlighted:'gcloud run services proxy <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),E=new Jt({props:{$$slots:{default:[es]},$$scope:{ctx:f}}}),ie=new g({props:{title:"cURL",local:"curl",headingTag:"h4"}}),re=new w({props:{code:"Y3VybCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkZjaGF0JTJGY29tcGxldGlvbnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLWQlMjAnJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4X3Rva2VucyUyMiUzQSUyMDEyOCUwQSUyMCUyMCUyMCUyMCU3RCc=",highlighted:`curl http://localhost:8080/v1/chat/completions \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tgi&quot;,
        &quot;messages&quot;: [
            {
                &quot;role&quot;: &quot;system&quot;,
                &quot;content&quot;: &quot;You are a helpful assistant.&quot;
            },
            {
                &quot;role&quot;: &quot;user&quot;,
                &quot;content&quot;: &quot;What is Deep Learning?&quot;
            }
        ],
        &quot;max_tokens&quot;: 128
    }&#x27;</span>`,wrap:!1}}),ce=new g({props:{title:"Python",local:"python",headingTag:"h4"}}),Me=new g({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),Te=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTIyJTJDJTIwYXBpX2tleSUzRCUyMi0lMjIpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMG1vZGVsJTNEJTIyaHVnZ2luZy1xdWFudHMlMkZNZXRhLUxsYW1hLTMuMS04Qi1JbnN0cnVjdC1BV1EtSU5UNCUyMiUyQyUwQSUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBEZWVwJTIwTGVhcm5pbmclM0YlMjIlN0QlMkMlMEElMjAlMjAlNUQlMkMlMEElMjAlMjBtYXhfdG9rZW5zJTNEMTI4JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(base_url=<span class="hljs-string">&quot;http://localhost:8080&quot;</span>, api_key=<span class="hljs-string">&quot;-&quot;</span>)

chat_completion = client.chat.completions.create(
  model=<span class="hljs-string">&quot;hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4&quot;</span>,
  messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
  ],
  max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),he=new g({props:{title:"openai",local:"openai",headingTag:"h5"}}),ye=new w({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkYlMjIlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyLSUyMiUyQyUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEyOCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:8080/v1/&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>,
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
    ],
    max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),me=new g({props:{title:"(recommended) Via Cloud Run Service URL",local:"recommended-via-cloud-run-service-url",headingTag:"h3"}}),ge=new w({props:{code:"U0VSVklDRV9VUkwlM0QlMjQoZ2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZXNjcmliZSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04lMjAtLWZvcm1hdCUyMCd2YWx1ZShzdGF0dXMudXJsKScp",highlighted:'SERVICE_URL=$(gcloud run services describe <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span> --format <span class="hljs-string">&#x27;value(status.url)&#x27;</span>)',wrap:!1}}),Ie=new w({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHByaW50LWlkZW50aXR5LXRva2Vu",highlighted:"gcloud auth print-identity-token",wrap:!1}}),Ce=new w({props:{code:"aW1wb3J0JTIwZ29vZ2xlLmF1dGglMEFmcm9tJTIwZ29vZ2xlLmF1dGgudHJhbnNwb3J0LnJlcXVlc3RzJTIwaW1wb3J0JTIwUmVxdWVzdCUyMGFzJTIwR29vZ2xlQXV0aFJlcXVlc3QlMEElMEFhdXRoX3JlcSUyMCUzRCUyMEdvb2dsZUF1dGhSZXF1ZXN0KCklMEFjcmVkcyUyQyUyMF8lMjAlM0QlMjBnb29nbGUuYXV0aC5kZWZhdWx0KCklMEFjcmVkcy5yZWZyZXNoKGF1dGhfcmVxKSUwQSUwQWlkX3Rva2VuJTIwJTNEJTIwY3JlZHMuaWRfdG9rZW4=",highlighted:`<span class="hljs-keyword">import</span> google.auth
<span class="hljs-keyword">from</span> google.auth.transport.requests <span class="hljs-keyword">import</span> Request <span class="hljs-keyword">as</span> GoogleAuthRequest

auth_req = GoogleAuthRequest()
creds, _ = google.auth.default()
creds.refresh(auth_req)

id_token = creds.id_token`,wrap:!1}}),be=new w({props:{code:"ZXhwb3J0JTIwU0VSVklDRV9BQ0NPVU5UX05BTUUlM0R0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlLWludm9rZXI=",highlighted:'<span class="hljs-built_in">export</span> SERVICE_ACCOUNT_NAME=text-generation-inference-invoker',wrap:!1}}),Ae=new w({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGNyZWF0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1F",highlighted:'gcloud iam service-accounts create <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>',wrap:!1}}),Ee=new w({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBhZGQtaWFtLXBvbGljeS1iaW5kaW5nJTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tZW1iZXIlM0QlMjJzZXJ2aWNlQWNjb3VudCUzQSUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9sZSUzRCUyMnJvbGVzJTJGcnVuLmludm9rZXIlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9O",highlighted:`gcloud run services add-iam-policy-binding <span class="hljs-variable">$SERVICE_NAME</span> \\
    --member=<span class="hljs-string">&quot;serviceAccount:<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com&quot;</span> \\
    --role=<span class="hljs-string">&quot;roles/run.invoker&quot;</span> \\
    --region=<span class="hljs-variable">$LOCATION</span>`,wrap:!1}}),Ne=new w({props:{code:"ZXhwb3J0JTIwQUNDRVNTX1RPS0VOJTNEJTI0KGdjbG91ZCUyMGF1dGglMjBwcmludC1hY2Nlc3MtdG9rZW4lMjAtLWltcGVyc29uYXRlLXNlcnZpY2UtYWNjb3VudCUzRCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSk=",highlighted:'<span class="hljs-built_in">export</span> ACCESS_TOKEN=$(gcloud auth print-access-token --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com)',wrap:!1}}),N=new Jt({props:{warning:!0,$$slots:{default:[ts]},$$scope:{ctx:f}}}),S=new Jt({props:{$$slots:{default:[ls]},$$scope:{ctx:f}}}),Ze=new g({props:{title:"cURL",local:"curl",headingTag:"h4"}}),qe=new w({props:{code:"Y3VybCUyMCUyNFNFUlZJQ0VfVVJMJTJGdjElMkZjaGF0JTJGY29tcGxldGlvbnMlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCUyMkF1dGhvcml6YXRpb24lM0ElMjBCZWFyZXIlMjAlMjRBQ0NFU1NfVE9LRU4lMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLWQlMjAnJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4X3Rva2VucyUyMiUzQSUyMDEyOCUwQSUyMCUyMCUyMCUyMCU3RCc=",highlighted:`curl <span class="hljs-variable">$SERVICE_URL</span>/v1/chat/completions \\
    -X POST \\
    -H <span class="hljs-string">&quot;Authorization: Bearer <span class="hljs-variable">$ACCESS_TOKEN</span>&quot;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tgi&quot;,
        &quot;messages&quot;: [
            {
                &quot;role&quot;: &quot;system&quot;,
                &quot;content&quot;: &quot;You are a helpful assistant.&quot;
            },
            {
                &quot;role&quot;: &quot;user&quot;,
                &quot;content&quot;: &quot;What is Deep Learning?&quot;
            }
        ],
        &quot;max_tokens&quot;: 128
    }&#x27;</span>`,wrap:!1}}),Ge=new g({props:{title:"Python",local:"python",headingTag:"h4"}}),ke=new g({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),_e=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwbW9kZWwlM0QlMjJodWdnaW5nLXF1YW50cyUyRk1ldGEtTGxhbWEtMy4xLThCLUluc3RydWN0LUFXUS1JTlQ0JTIyJTJDJTBBJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMERlZXAlMjBMZWFybmluZyUzRiUyMiU3RCUyQyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMG1heF90b2tlbnMlM0QxMjglMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

chat_completion = client.chat.completions.create(
  model=<span class="hljs-string">&quot;hugging-quants/Meta-Llama-3.1-8B-Instruct-AWQ-INT4&quot;</span>,
  messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
  ],
  max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),Qe=new g({props:{title:"openai",local:"openai",headingTag:"h5"}}),Xe=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBY2xpZW50JTIwJTNEJTIwT3BlbkFJKCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFjaGF0X2NvbXBsZXRpb24lMjAlM0QlMjBjbGllbnQuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwRGVlcCUyMExlYXJuaW5nJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEyOCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is Deep Learning?&quot;</span>},
    ],
    max_tokens=<span class="hljs-number">128</span>,
)`,wrap:!1}}),Fe=new g({props:{title:"Resource clean up",local:"resource-clean-up",headingTag:"h2"}}),He=new w({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZWxldGUlMjAlMjRTRVJWSUNFX05BTUUlMjAtLXJlZ2lvbiUyMCUyNExPQ0FUSU9O",highlighted:'gcloud run services delete <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),Oe=new w({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHJldm9rZSUyMC0taW1wZXJzb25hdGUtc2VydmljZS1hY2NvdW50JTNEJTI0U0VSVklDRV9BQ0NPVU5UX05BTUUlNDAlMjRQUk9KRUNUX0lELmlhbS5nc2VydmljZWFjY291bnQuY29t",highlighted:'gcloud auth revoke --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),et=new w({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGRlbGV0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbQ==",highlighted:'gcloud iam service-accounts delete <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),tt=new g({props:{title:"References",local:"references",headingTag:"h2"}}),nt=new Dn({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/cloud-run-tgi-deployment.mdx"}}),{c(){u=o("meta"),m=s(),J=o("p"),U=s(),c(Z.$$.fragment),wt=s(),L=o("p"),L.textContent=en,Ut=s(),q=o("p"),q.innerHTML=tn,gt=s(),c(v.$$.fragment),ft=s(),c(G.$$.fragment),It=s(),x=o("p"),x.innerHTML=ln,Ct=s(),k=o("p"),k.textContent=nn,jt=s(),c(W.$$.fragment),$t=s(),_=o("p"),_.textContent=sn,bt=s(),c(Q.$$.fragment),vt=s(),B=o("p"),B.textContent=an,At=s(),c(X.$$.fragment),Vt=s(),c(F.$$.fragment),Et=s(),Y=o("p"),Y.innerHTML=on,Rt=s(),P=o("p"),P.innerHTML=un,Nt=s(),H=o("ul"),H.innerHTML=rn,St=s(),c(D.$$.fragment),Zt=s(),z=o("p"),z.innerHTML=cn,Lt=s(),O=o("p"),O.innerHTML=pn,qt=s(),c(A.$$.fragment),Gt=s(),c(K.$$.fragment),xt=s(),ee=o("p"),ee.innerHTML=Mn,kt=s(),te=o("p"),te.textContent=dn,Wt=s(),le=o("p"),le.innerHTML=Tn,_t=s(),c(V.$$.fragment),Qt=s(),c(ne.$$.fragment),Bt=s(),se=o("p"),se.textContent=hn,Xt=s(),c(ae.$$.fragment),Ft=s(),oe=o("p"),oe.innerHTML=Jn,Yt=s(),c(E.$$.fragment),Pt=s(),c(ie.$$.fragment),Ht=s(),ue=o("p"),ue.innerHTML=yn,Dt=s(),c(re.$$.fragment),zt=s(),c(ce.$$.fragment),Ot=s(),pe=o("p"),pe.innerHTML=mn,Kt=s(),c(Me.$$.fragment),el=s(),de=o("p"),de.innerHTML=wn,tl=s(),c(Te.$$.fragment),ll=s(),c(he.$$.fragment),nl=s(),Je=o("p"),Je.innerHTML=Un,sl=s(),c(ye.$$.fragment),al=s(),c(me.$$.fragment),ol=s(),we=o("p"),we.textContent=gn,il=s(),Ue=o("p"),Ue.innerHTML=fn,ul=s(),c(ge.$$.fragment),rl=s(),fe=o("p"),fe.innerHTML=In,cl=s(),R=o("ul"),I=o("li"),ut=o("p"),ut.textContent=Cn,_l=s(),rt=o("ul"),rt.innerHTML=jn,Ql=s(),c(Ie.$$.fragment),Bl=s(),ct=o("ul"),ct.innerHTML=$n,Xl=s(),c(Ce.$$.fragment),Fl=s(),pt=o("li"),pt.innerHTML=bn,pl=s(),je=o("p"),je.textContent=vn,Ml=s(),j=o("ul"),$e=o("li"),Mt=o("p"),Mt.innerHTML=An,Yl=s(),c(be.$$.fragment),Pl=s(),ve=o("li"),dt=o("p"),dt.textContent=Vn,Hl=s(),c(Ae.$$.fragment),Dl=s(),Ve=o("li"),Tt=o("p"),Tt.textContent=En,zl=s(),c(Ee.$$.fragment),Ol=s(),Re=o("li"),ht=o("p"),ht.textContent=Rn,Kl=s(),c(Ne.$$.fragment),dl=s(),c(N.$$.fragment),Tl=s(),Se=o("p"),Se.innerHTML=Nn,hl=s(),c(S.$$.fragment),Jl=s(),c(Ze.$$.fragment),yl=s(),Le=o("p"),Le.innerHTML=Sn,ml=s(),c(qe.$$.fragment),wl=s(),c(Ge.$$.fragment),Ul=s(),xe=o("p"),xe.innerHTML=Zn,gl=s(),c(ke.$$.fragment),fl=s(),We=o("p"),We.innerHTML=Ln,Il=s(),c(_e.$$.fragment),Cl=s(),c(Qe.$$.fragment),jl=s(),Be=o("p"),Be.innerHTML=qn,$l=s(),c(Xe.$$.fragment),bl=s(),c(Fe.$$.fragment),vl=s(),Ye=o("p"),Ye.textContent=Gn,Al=s(),Pe=o("p"),Pe.innerHTML=xn,Vl=s(),c(He.$$.fragment),El=s(),De=o("p"),De.innerHTML=kn,Rl=s(),ze=o("ul"),ze.innerHTML=Wn,Nl=s(),c(Oe.$$.fragment),Sl=s(),Ke=o("ul"),Ke.innerHTML=_n,Zl=s(),c(et.$$.fragment),Ll=s(),c(tt.$$.fragment),ql=s(),lt=o("ul"),lt.innerHTML=Qn,Gl=s(),c(nt.$$.fragment),xl=s(),mt=o("p"),this.h()},l(e){const t=Hn("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),m=a(e),J=i(e,"P",{}),b(J).forEach(l),U=a(e),p(Z.$$.fragment,e),wt=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-rqjgi7"&&(L.textContent=en),Ut=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-mah12k"&&(q.innerHTML=tn),gt=a(e),p(v.$$.fragment,e),ft=a(e),p(G.$$.fragment,e),It=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1o67gfb"&&(x.innerHTML=ln),Ct=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1i8n6rq"&&(k.textContent=nn),jt=a(e),p(W.$$.fragment,e),$t=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-pfbeqd"&&(_.textContent=sn),bt=a(e),p(Q.$$.fragment,e),vt=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1usj4y5"&&(B.textContent=an),At=a(e),p(X.$$.fragment,e),Vt=a(e),p(F.$$.fragment,e),Et=a(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-v1hrv3"&&(Y.innerHTML=on),Rt=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1edwfmt"&&(P.innerHTML=un),Nt=a(e),H=i(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-1v1f721"&&(H.innerHTML=rn),St=a(e),p(D.$$.fragment,e),Zt=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-h7x8wp"&&(z.innerHTML=cn),Lt=a(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-epx368"&&(O.innerHTML=pn),qt=a(e),p(A.$$.fragment,e),Gt=a(e),p(K.$$.fragment,e),xt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1d9o3zj"&&(ee.innerHTML=Mn),kt=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1gzo66i"&&(te.textContent=dn),Wt=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1rn2q59"&&(le.innerHTML=Tn),_t=a(e),p(V.$$.fragment,e),Qt=a(e),p(ne.$$.fragment,e),Bt=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1n42sxg"&&(se.textContent=hn),Xt=a(e),p(ae.$$.fragment,e),Ft=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-yd30oz"&&(oe.innerHTML=Jn),Yt=a(e),p(E.$$.fragment,e),Pt=a(e),p(ie.$$.fragment,e),Ht=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1ks8djk"&&(ue.innerHTML=yn),Dt=a(e),p(re.$$.fragment,e),zt=a(e),p(ce.$$.fragment,e),Ot=a(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-wqgbww"&&(pe.innerHTML=mn),Kt=a(e),p(Me.$$.fragment,e),el=a(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-u758zp"&&(de.innerHTML=wn),tl=a(e),p(Te.$$.fragment,e),ll=a(e),p(he.$$.fragment,e),nl=a(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1bjj57d"&&(Je.innerHTML=Un),sl=a(e),p(ye.$$.fragment,e),al=a(e),p(me.$$.fragment,e),ol=a(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1o5h253"&&(we.textContent=gn),il=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-7kvofg"&&(Ue.innerHTML=fn),ul=a(e),p(ge.$$.fragment,e),rl=a(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-niuemd"&&(fe.innerHTML=In),cl=a(e),R=i(e,"UL",{});var st=b(R);I=i(st,"LI",{});var C=b(I);ut=i(C,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-4rg0sg"&&(ut.textContent=Cn),_l=a(C),rt=i(C,"UL",{"data-svelte-h":!0}),r(rt)!=="svelte-1vwi62o"&&(rt.innerHTML=jn),Ql=a(C),p(Ie.$$.fragment,C),Bl=a(C),ct=i(C,"UL",{"data-svelte-h":!0}),r(ct)!=="svelte-b6nbfv"&&(ct.innerHTML=$n),Xl=a(C),p(Ce.$$.fragment,C),C.forEach(l),Fl=a(st),pt=i(st,"LI",{"data-svelte-h":!0}),r(pt)!=="svelte-1v3f4rq"&&(pt.innerHTML=bn),st.forEach(l),pl=a(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-18iwnqm"&&(je.textContent=vn),Ml=a(e),j=i(e,"UL",{});var $=b(j);$e=i($,"LI",{});var at=b($e);Mt=i(at,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-tbapg4"&&(Mt.innerHTML=An),Yl=a(at),p(be.$$.fragment,at),at.forEach(l),Pl=a($),ve=i($,"LI",{});var ot=b(ve);dt=i(ot,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1nwc9xz"&&(dt.textContent=Vn),Hl=a(ot),p(Ae.$$.fragment,ot),ot.forEach(l),Dl=a($),Ve=i($,"LI",{});var it=b(Ve);Tt=i(it,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-19ickcu"&&(Tt.textContent=En),zl=a(it),p(Ee.$$.fragment,it),it.forEach(l),Ol=a($),Re=i($,"LI",{});var Wl=b(Re);ht=i(Wl,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-v6tnr5"&&(ht.textContent=Rn),Kl=a(Wl),p(Ne.$$.fragment,Wl),Wl.forEach(l),$.forEach(l),dl=a(e),p(N.$$.fragment,e),Tl=a(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-ur1pan"&&(Se.innerHTML=Nn),hl=a(e),p(S.$$.fragment,e),Jl=a(e),p(Ze.$$.fragment,e),yl=a(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1ks8djk"&&(Le.innerHTML=Sn),ml=a(e),p(qe.$$.fragment,e),wl=a(e),p(Ge.$$.fragment,e),Ul=a(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-wqgbww"&&(xe.innerHTML=Zn),gl=a(e),p(ke.$$.fragment,e),fl=a(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-u758zp"&&(We.innerHTML=Ln),Il=a(e),p(_e.$$.fragment,e),Cl=a(e),p(Qe.$$.fragment,e),jl=a(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1bjj57d"&&(Be.innerHTML=qn),$l=a(e),p(Xe.$$.fragment,e),bl=a(e),p(Fe.$$.fragment,e),vl=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-qym8z6"&&(Ye.textContent=Gn),Al=a(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1sjp15c"&&(Pe.innerHTML=xn),Vl=a(e),p(He.$$.fragment,e),El=a(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-l00oox"&&(De.innerHTML=kn),Rl=a(e),ze=i(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-hs3g2x"&&(ze.innerHTML=Wn),Nl=a(e),p(Oe.$$.fragment,e),Sl=a(e),Ke=i(e,"UL",{"data-svelte-h":!0}),r(Ke)!=="svelte-1toh59e"&&(Ke.innerHTML=_n),Zl=a(e),p(et.$$.fragment,e),Ll=a(e),p(tt.$$.fragment,e),ql=a(e),lt=i(e,"UL",{"data-svelte-h":!0}),r(lt)!=="svelte-1fx9lvo"&&(lt.innerHTML=Qn),Gl=a(e),p(nt.$$.fragment,e),xl=a(e),mt=i(e,"P",{}),b(mt).forEach(l),this.h()},h(){Bn(u,"name","hf:doc:metadata"),Bn(u,"content",ss)},m(e,t){y(document.head,u),n(e,m,t),n(e,J,t),n(e,U,t),M(Z,e,t),n(e,wt,t),n(e,L,t),n(e,Ut,t),n(e,q,t),n(e,gt,t),M(v,e,t),n(e,ft,t),M(G,e,t),n(e,It,t),n(e,x,t),n(e,Ct,t),n(e,k,t),n(e,jt,t),M(W,e,t),n(e,$t,t),n(e,_,t),n(e,bt,t),M(Q,e,t),n(e,vt,t),n(e,B,t),n(e,At,t),M(X,e,t),n(e,Vt,t),M(F,e,t),n(e,Et,t),n(e,Y,t),n(e,Rt,t),n(e,P,t),n(e,Nt,t),n(e,H,t),n(e,St,t),M(D,e,t),n(e,Zt,t),n(e,z,t),n(e,Lt,t),n(e,O,t),n(e,qt,t),M(A,e,t),n(e,Gt,t),M(K,e,t),n(e,xt,t),n(e,ee,t),n(e,kt,t),n(e,te,t),n(e,Wt,t),n(e,le,t),n(e,_t,t),M(V,e,t),n(e,Qt,t),M(ne,e,t),n(e,Bt,t),n(e,se,t),n(e,Xt,t),M(ae,e,t),n(e,Ft,t),n(e,oe,t),n(e,Yt,t),M(E,e,t),n(e,Pt,t),M(ie,e,t),n(e,Ht,t),n(e,ue,t),n(e,Dt,t),M(re,e,t),n(e,zt,t),M(ce,e,t),n(e,Ot,t),n(e,pe,t),n(e,Kt,t),M(Me,e,t),n(e,el,t),n(e,de,t),n(e,tl,t),M(Te,e,t),n(e,ll,t),M(he,e,t),n(e,nl,t),n(e,Je,t),n(e,sl,t),M(ye,e,t),n(e,al,t),M(me,e,t),n(e,ol,t),n(e,we,t),n(e,il,t),n(e,Ue,t),n(e,ul,t),M(ge,e,t),n(e,rl,t),n(e,fe,t),n(e,cl,t),n(e,R,t),y(R,I),y(I,ut),y(I,_l),y(I,rt),y(I,Ql),M(Ie,I,null),y(I,Bl),y(I,ct),y(I,Xl),M(Ce,I,null),y(R,Fl),y(R,pt),n(e,pl,t),n(e,je,t),n(e,Ml,t),n(e,j,t),y(j,$e),y($e,Mt),y($e,Yl),M(be,$e,null),y(j,Pl),y(j,ve),y(ve,dt),y(ve,Hl),M(Ae,ve,null),y(j,Dl),y(j,Ve),y(Ve,Tt),y(Ve,zl),M(Ee,Ve,null),y(j,Ol),y(j,Re),y(Re,ht),y(Re,Kl),M(Ne,Re,null),n(e,dl,t),M(N,e,t),n(e,Tl,t),n(e,Se,t),n(e,hl,t),M(S,e,t),n(e,Jl,t),M(Ze,e,t),n(e,yl,t),n(e,Le,t),n(e,ml,t),M(qe,e,t),n(e,wl,t),M(Ge,e,t),n(e,Ul,t),n(e,xe,t),n(e,gl,t),M(ke,e,t),n(e,fl,t),n(e,We,t),n(e,Il,t),M(_e,e,t),n(e,Cl,t),M(Qe,e,t),n(e,jl,t),n(e,Be,t),n(e,$l,t),M(Xe,e,t),n(e,bl,t),M(Fe,e,t),n(e,vl,t),n(e,Ye,t),n(e,Al,t),n(e,Pe,t),n(e,Vl,t),M(He,e,t),n(e,El,t),n(e,De,t),n(e,Rl,t),n(e,ze,t),n(e,Nl,t),M(Oe,e,t),n(e,Sl,t),n(e,Ke,t),n(e,Zl,t),M(et,e,t),n(e,Ll,t),M(tt,e,t),n(e,ql,t),n(e,lt,t),n(e,Gl,t),M(nt,e,t),n(e,xl,t),n(e,mt,t),kl=!0},p(e,[t]){const st={};t&2&&(st.$$scope={dirty:t,ctx:e}),v.$set(st);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),A.$set(C);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),V.$set($);const at={};t&2&&(at.$$scope={dirty:t,ctx:e}),E.$set(at);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),N.$set(ot);const it={};t&2&&(it.$$scope={dirty:t,ctx:e}),S.$set(it)},i(e){kl||(d(Z.$$.fragment,e),d(v.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(Q.$$.fragment,e),d(X.$$.fragment,e),d(F.$$.fragment,e),d(D.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(V.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(E.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(Me.$$.fragment,e),d(Te.$$.fragment,e),d(he.$$.fragment,e),d(ye.$$.fragment,e),d(me.$$.fragment,e),d(ge.$$.fragment,e),d(Ie.$$.fragment,e),d(Ce.$$.fragment,e),d(be.$$.fragment,e),d(Ae.$$.fragment,e),d(Ee.$$.fragment,e),d(Ne.$$.fragment,e),d(N.$$.fragment,e),d(S.$$.fragment,e),d(Ze.$$.fragment,e),d(qe.$$.fragment,e),d(Ge.$$.fragment,e),d(ke.$$.fragment,e),d(_e.$$.fragment,e),d(Qe.$$.fragment,e),d(Xe.$$.fragment,e),d(Fe.$$.fragment,e),d(He.$$.fragment,e),d(Oe.$$.fragment,e),d(et.$$.fragment,e),d(tt.$$.fragment,e),d(nt.$$.fragment,e),kl=!0)},o(e){T(Z.$$.fragment,e),T(v.$$.fragment,e),T(G.$$.fragment,e),T(W.$$.fragment,e),T(Q.$$.fragment,e),T(X.$$.fragment,e),T(F.$$.fragment,e),T(D.$$.fragment,e),T(A.$$.fragment,e),T(K.$$.fragment,e),T(V.$$.fragment,e),T(ne.$$.fragment,e),T(ae.$$.fragment,e),T(E.$$.fragment,e),T(ie.$$.fragment,e),T(re.$$.fragment,e),T(ce.$$.fragment,e),T(Me.$$.fragment,e),T(Te.$$.fragment,e),T(he.$$.fragment,e),T(ye.$$.fragment,e),T(me.$$.fragment,e),T(ge.$$.fragment,e),T(Ie.$$.fragment,e),T(Ce.$$.fragment,e),T(be.$$.fragment,e),T(Ae.$$.fragment,e),T(Ee.$$.fragment,e),T(Ne.$$.fragment,e),T(N.$$.fragment,e),T(S.$$.fragment,e),T(Ze.$$.fragment,e),T(qe.$$.fragment,e),T(Ge.$$.fragment,e),T(ke.$$.fragment,e),T(_e.$$.fragment,e),T(Qe.$$.fragment,e),T(Xe.$$.fragment,e),T(Fe.$$.fragment,e),T(He.$$.fragment,e),T(Oe.$$.fragment,e),T(et.$$.fragment,e),T(tt.$$.fragment,e),T(nt.$$.fragment,e),kl=!1},d(e){e&&(l(m),l(J),l(U),l(wt),l(L),l(Ut),l(q),l(gt),l(ft),l(It),l(x),l(Ct),l(k),l(jt),l($t),l(_),l(bt),l(vt),l(B),l(At),l(Vt),l(Et),l(Y),l(Rt),l(P),l(Nt),l(H),l(St),l(Zt),l(z),l(Lt),l(O),l(qt),l(Gt),l(xt),l(ee),l(kt),l(te),l(Wt),l(le),l(_t),l(Qt),l(Bt),l(se),l(Xt),l(Ft),l(oe),l(Yt),l(Pt),l(Ht),l(ue),l(Dt),l(zt),l(Ot),l(pe),l(Kt),l(el),l(de),l(tl),l(ll),l(nl),l(Je),l(sl),l(al),l(ol),l(we),l(il),l(Ue),l(ul),l(rl),l(fe),l(cl),l(R),l(pl),l(je),l(Ml),l(j),l(dl),l(Tl),l(Se),l(hl),l(Jl),l(yl),l(Le),l(ml),l(wl),l(Ul),l(xe),l(gl),l(fl),l(We),l(Il),l(Cl),l(jl),l(Be),l($l),l(bl),l(vl),l(Ye),l(Al),l(Pe),l(Vl),l(El),l(De),l(Rl),l(ze),l(Nl),l(Sl),l(Ke),l(Zl),l(Ll),l(ql),l(lt),l(Gl),l(xl),l(mt)),l(u),h(Z,e),h(v,e),h(G,e),h(W,e),h(Q,e),h(X,e),h(F,e),h(D,e),h(A,e),h(K,e),h(V,e),h(ne,e),h(ae,e),h(E,e),h(ie,e),h(re,e),h(ce,e),h(Me,e),h(Te,e),h(he,e),h(ye,e),h(me,e),h(ge,e),h(Ie),h(Ce),h(be),h(Ae),h(Ee),h(Ne),h(N,e),h(S,e),h(Ze,e),h(qe,e),h(Ge,e),h(ke,e),h(_e,e),h(Qe,e),h(Xe,e),h(Fe,e),h(He,e),h(Oe,e),h(et,e),h(tt,e),h(nt,e)}}}const ss='{"title":"Deploy Meta Llama 3.1 8B with TGI DLC on Cloud Run","local":"deploy-meta-llama-31-8b-with-tgi-dlc-on-cloud-run","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Deploy TGI on Cloud Run","local":"deploy-tgi-on-cloud-run","sections":[],"depth":2},{"title":"Inference on Cloud Run","local":"inference-on-cloud-run","sections":[{"title":"Via Cloud Run Proxy","local":"via-cloud-run-proxy","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5},{"title":"openai","local":"openai","sections":[],"depth":5}],"depth":4}],"depth":3},{"title":"(recommended) Via Cloud Run Service URL","local":"recommended-via-cloud-run-service-url","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5},{"title":"openai","local":"openai","sections":[],"depth":5}],"depth":4}],"depth":3}],"depth":2},{"title":"Resource clean up","local":"resource-clean-up","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function as(f){return Fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ps extends Yn{constructor(u){super(),Pn(this,u,as,ns,Xn,{})}}export{ps as component};
