import{s as At,n as Rt,o as Ft}from"../chunks/scheduler.8c3d61f6.js";import{S as It,i as Gt,g as l,s as a,r as H,A as Et,h as s,f as o,c as i,j as kt,u as k,x as r,k as Wt,y as Qt,a as n,v as W,d as A,t as R,w as F}from"../chunks/index.da70eac4.js";import{C as ft}from"../chunks/CodeBlock.00a903b3.js";import{H as yt,E as Xt}from"../chunks/EditOnGithub.1e64e623.js";function Lt(wt){let d,E,I,Q,c,X,m,Mt='<a href="https://github.com/pytorch/ao" rel="nofollow">TorchAO</a> is an architecture optimization library for PyTorch. It provides high-performance dtypes, optimization techniques, and kernels for inference and training, featuring composability with native PyTorch features like <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a>, FullyShardedDataParallel (FSDP), and more.',L,u,bt="Before you begin, make sure you have Pytorch 2.5+ and TorchAO installed.",P,p,S,h,gt='Quantize a model by passing <a href="/docs/diffusers/pr_10033/en/api/quantization#diffusers.TorchAoConfig">TorchAoConfig</a> to <a href="/docs/diffusers/pr_10033/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> (you can also load pre-quantized models). This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',Y,f,_t="The example below only quantizes the weights to int8.",D,y,N,w,Tt='TorchAO is fully compatible with <a href="./optimization/torch2.0#torchcompile">torch.compile</a>, setting it apart from other quantization methods. This makes it easy to speed up inference with just one line of code.',V,M,O,b,vt='For speed and memory benchmarks on Flux and CogVideoX, please refer to the table <a href="https://github.com/huggingface/diffusers/pull/10009#issue-2688781450" rel="nofollow">here</a>. You can also find some torchao <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">benchmarks</a> numbers for various hardware.',K,g,xt='torchao also supports an automatic quantization API through <a href="https://github.com/pytorch/ao/blob/main/torchao/quantization/README.md#autoquantization" rel="nofollow">autoquant</a>. Autoquantization determines the best quantization strategy applicable to a model by comparing the performance of each technique on chosen input types and shapes. Currently, this can be used directly on the underlying modeling components. Diffusers will also expose an autoquant configuration option in the future.',tt,_,qt="The <code>TorchAoConfig</code> class accepts three parameters:",et,T,Ct='<li><code>quant_type</code>: A string value mentioning one of the quantization types below.</li> <li><code>modules_to_not_convert</code>: A list of module full/partial module names for which quantization should not be performed. For example, to not perform any quantization of the <a href="/docs/diffusers/pr_10033/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>’s first block, one would specify: <code>modules_to_not_convert=[&quot;single_transformer_blocks.0&quot;]</code>.</li> <li><code>kwargs</code>: A dict of keyword arguments to pass to the underlying quantization method which will be invoked based on <code>quant_type</code>.</li>',ot,v,nt,x,Jt="torchao supports weight-only quantization and weight and dynamic-activation quantization for int8, float3-float8, and uint1-uint7.",at,q,Ut="Weight-only quantization stores the model weights in a specific low-bit data type but performs computation with a higher-precision data type, like <code>bfloat16</code>. This lowers the memory requirements from model weights but retains the memory peaks for activation computation.",it,C,jt="Dynamic activation quantization stores the model weights in a low-bit dtype, while also quantizing the activations on-the-fly to save additional memory. This lowers the memory requirements from model weights, while also lowering the memory overhead from activation computations. However, this may come at a quality tradeoff at times, so it is recommended to test different models thoroughly.",lt,J,zt="The quantization methods supported are as follows:",st,U,$t="<thead><tr><th><strong>Category</strong></th> <th><strong>Full Function Names</strong></th> <th><strong>Shorthands</strong></th></tr></thead> <tbody><tr><td><strong>Integer quantization</strong></td> <td><code>int4_weight_only</code>, <code>int8_dynamic_activation_int4_weight</code>, <code>int8_weight_only</code>, <code>int8_dynamic_activation_int8_weight</code></td> <td><code>int4wo</code>, <code>int4dq</code>, <code>int8wo</code>, <code>int8dq</code></td></tr> <tr><td><strong>Floating point 8-bit quantization</strong></td> <td><code>float8_weight_only</code>, <code>float8_dynamic_activation_float8_weight</code>, <code>float8_static_activation_float8_weight</code></td> <td><code>float8wo</code>, <code>float8wo_e5m2</code>, <code>float8wo_e4m3</code>, <code>float8dq</code>, <code>float8dq_e4m3</code>, <code>float8_e4m3_tensor</code>, <code>float8_e4m3_row</code></td></tr> <tr><td><strong>Floating point X-bit quantization</strong></td> <td><code>fpx_weight_only</code></td> <td><code>fpX_eAwB</code> where <code>X</code> is the number of bits (1-7), <code>A</code> is exponent bits, and <code>B</code> is mantissa bits. Constraint: <code>X == A + B + 1</code></td></tr> <tr><td><strong>Unsigned Integer quantization</strong></td> <td><code>uintx_weight_only</code></td> <td><code>uint1wo</code>, <code>uint2wo</code>, <code>uint3wo</code>, <code>uint4wo</code>, <code>uint5wo</code>, <code>uint6wo</code>, <code>uint7wo</code></td></tr></tbody>",rt,j,Zt="Some quantization methods are aliases (for example, <code>int8wo</code> is the commonly used shorthand for <code>int8_weight_only</code>). This allows using the quantization methods described in the torchao docs as-is, while also making it convenient to remember their shorthand notations.",dt,z,Bt="Refer to the official torchao documentation for a better understanding of the available quantization methods and the exhaustive list of configuration options available.",ct,$,mt,Z,Ht='<li><a href="https://github.com/pytorch/ao/blob/main/torchao/quantization/README.md" rel="nofollow">TorchAO Quantization API</a></li> <li><a href="https://github.com/sayakpaul/diffusers-torchao" rel="nofollow">Diffusers-TorchAO examples</a></li>',ut,B,pt,G,ht;return c=new yt({props:{title:"torchao",local:"torchao",headingTag:"h1"}}),p=new ft({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwdG9yY2glMjB0b3JjaGFv",highlighted:"pip install -U torch torchao",wrap:!1}}),y=new ft({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUyQyUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZsdXguMS1EZXYlMjIlMEFkdHlwZSUyMCUzRCUyMHRvcmNoLmJmbG9hdDE2JTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFRvcmNoQW9Db25maWcoJTIyaW50OHdvJTIyKSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0RkdHlwZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwRmx1eFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRGR0eXBlJTJDJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMC4wKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, FluxTransformer2DModel, TorchAoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>
dtype = torch.bfloat16

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)
transformer = FluxTransformer2DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=dtype,
)
pipe = FluxPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=dtype,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">28</span>, guidance_scale=<span class="hljs-number">0.0</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),M=new ft({props:{code:"JTIzJTIwSW4lMjB0aGUlMjBhYm92ZSUyMGNvZGUlMkMlMjBhZGQlMjB0aGUlMjBmb2xsb3dpbmclMjBhZnRlciUyMGluaXRpYWxpemluZyUyMHRoZSUyMHRyYW5zZm9ybWVyJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjB0b3JjaC5jb21waWxlKHRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUp",highlighted:`<span class="hljs-comment"># In the above code, add the following after initializing the transformer</span>
transformer = torch.<span class="hljs-built_in">compile</span>(transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),v=new yt({props:{title:"Supported quantization types",local:"supported-quantization-types",headingTag:"h2"}}),$=new yt({props:{title:"Resources",local:"resources",headingTag:"h2"}}),B=new Xt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){d=l("meta"),E=a(),I=l("p"),Q=a(),H(c.$$.fragment),X=a(),m=l("p"),m.innerHTML=Mt,L=a(),u=l("p"),u.textContent=bt,P=a(),H(p.$$.fragment),S=a(),h=l("p"),h.innerHTML=gt,Y=a(),f=l("p"),f.textContent=_t,D=a(),H(y.$$.fragment),N=a(),w=l("p"),w.innerHTML=Tt,V=a(),H(M.$$.fragment),O=a(),b=l("p"),b.innerHTML=vt,K=a(),g=l("p"),g.innerHTML=xt,tt=a(),_=l("p"),_.innerHTML=qt,et=a(),T=l("ul"),T.innerHTML=Ct,ot=a(),H(v.$$.fragment),nt=a(),x=l("p"),x.textContent=Jt,at=a(),q=l("p"),q.innerHTML=Ut,it=a(),C=l("p"),C.textContent=jt,lt=a(),J=l("p"),J.textContent=zt,st=a(),U=l("table"),U.innerHTML=$t,rt=a(),j=l("p"),j.innerHTML=Zt,dt=a(),z=l("p"),z.textContent=Bt,ct=a(),H($.$$.fragment),mt=a(),Z=l("ul"),Z.innerHTML=Ht,ut=a(),H(B.$$.fragment),pt=a(),G=l("p"),this.h()},l(t){const e=Et("svelte-u9bgzb",document.head);d=s(e,"META",{name:!0,content:!0}),e.forEach(o),E=i(t),I=s(t,"P",{}),kt(I).forEach(o),Q=i(t),k(c.$$.fragment,t),X=i(t),m=s(t,"P",{"data-svelte-h":!0}),r(m)!=="svelte-3zt1h"&&(m.innerHTML=Mt),L=i(t),u=s(t,"P",{"data-svelte-h":!0}),r(u)!=="svelte-xmmcvn"&&(u.textContent=bt),P=i(t),k(p.$$.fragment,t),S=i(t),h=s(t,"P",{"data-svelte-h":!0}),r(h)!=="svelte-fzakv1"&&(h.innerHTML=gt),Y=i(t),f=s(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1d14wga"&&(f.textContent=_t),D=i(t),k(y.$$.fragment,t),N=i(t),w=s(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1mb3hq5"&&(w.innerHTML=Tt),V=i(t),k(M.$$.fragment,t),O=i(t),b=s(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-exfnd4"&&(b.innerHTML=vt),K=i(t),g=s(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1fx3nq1"&&(g.innerHTML=xt),tt=i(t),_=s(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1eoai4f"&&(_.innerHTML=qt),et=i(t),T=s(t,"UL",{"data-svelte-h":!0}),r(T)!=="svelte-i00c2w"&&(T.innerHTML=Ct),ot=i(t),k(v.$$.fragment,t),nt=i(t),x=s(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1dy3rwb"&&(x.textContent=Jt),at=i(t),q=s(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-17x1tdo"&&(q.innerHTML=Ut),it=i(t),C=s(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1nbmql6"&&(C.textContent=jt),lt=i(t),J=s(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-4xexxq"&&(J.textContent=zt),st=i(t),U=s(t,"TABLE",{"data-svelte-h":!0}),r(U)!=="svelte-18shdov"&&(U.innerHTML=$t),rt=i(t),j=s(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1r64eqr"&&(j.innerHTML=Zt),dt=i(t),z=s(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-9cn9y3"&&(z.textContent=Bt),ct=i(t),k($.$$.fragment,t),mt=i(t),Z=s(t,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-96lbpr"&&(Z.innerHTML=Ht),ut=i(t),k(B.$$.fragment,t),pt=i(t),G=s(t,"P",{}),kt(G).forEach(o),this.h()},h(){Wt(d,"name","hf:doc:metadata"),Wt(d,"content",Pt)},m(t,e){Qt(document.head,d),n(t,E,e),n(t,I,e),n(t,Q,e),W(c,t,e),n(t,X,e),n(t,m,e),n(t,L,e),n(t,u,e),n(t,P,e),W(p,t,e),n(t,S,e),n(t,h,e),n(t,Y,e),n(t,f,e),n(t,D,e),W(y,t,e),n(t,N,e),n(t,w,e),n(t,V,e),W(M,t,e),n(t,O,e),n(t,b,e),n(t,K,e),n(t,g,e),n(t,tt,e),n(t,_,e),n(t,et,e),n(t,T,e),n(t,ot,e),W(v,t,e),n(t,nt,e),n(t,x,e),n(t,at,e),n(t,q,e),n(t,it,e),n(t,C,e),n(t,lt,e),n(t,J,e),n(t,st,e),n(t,U,e),n(t,rt,e),n(t,j,e),n(t,dt,e),n(t,z,e),n(t,ct,e),W($,t,e),n(t,mt,e),n(t,Z,e),n(t,ut,e),W(B,t,e),n(t,pt,e),n(t,G,e),ht=!0},p:Rt,i(t){ht||(A(c.$$.fragment,t),A(p.$$.fragment,t),A(y.$$.fragment,t),A(M.$$.fragment,t),A(v.$$.fragment,t),A($.$$.fragment,t),A(B.$$.fragment,t),ht=!0)},o(t){R(c.$$.fragment,t),R(p.$$.fragment,t),R(y.$$.fragment,t),R(M.$$.fragment,t),R(v.$$.fragment,t),R($.$$.fragment,t),R(B.$$.fragment,t),ht=!1},d(t){t&&(o(E),o(I),o(Q),o(X),o(m),o(L),o(u),o(P),o(S),o(h),o(Y),o(f),o(D),o(N),o(w),o(V),o(O),o(b),o(K),o(g),o(tt),o(_),o(et),o(T),o(ot),o(nt),o(x),o(at),o(q),o(it),o(C),o(lt),o(J),o(st),o(U),o(rt),o(j),o(dt),o(z),o(ct),o(mt),o(Z),o(ut),o(pt),o(G)),o(d),F(c,t),F(p,t),F(y,t),F(M,t),F(v,t),F($,t),F(B,t)}}}const Pt='{"title":"torchao","local":"torchao","sections":[{"title":"Supported quantization types","local":"supported-quantization-types","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function St(wt){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends It{constructor(d){super(),Gt(this,d,St,Lt,At,{})}}export{Ot as component};
