import{s as gl,n as Ul,o as $l}from"../chunks/scheduler.39a43cde.js";import{S as jl,i as Cl,g as p,s as n,r as o,A as Gl,h as i,f as l,c as a,j as dl,u,x as m,k as wl,y as xl,a as s,v as b,d as r,t as M,w as y}from"../chunks/index.23ec2204.js";import{D as Bl,C as f}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as Ut,E as vl}from"../chunks/EditOnGithub.f2d09226.js";function Zl(Re){let J,Ct,$t,Gt,T,xt,c,Bt,h,He='<em>作者: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a></em>',vt,d,Xe='本 notebook 展示了如何使用 <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a> 模型和 LangChain 快速构建一个针对项目 GitHub issues 的简单 RAG。',Zt,w,We="<strong>什么是 RAG</strong>",_t,g,Ve="RAG 是一个很流行的方法，用来解决强大的 LLM 不知道具体内容的问题，因为具体内容不在其训练数据中，或者当它看到它之前时产生幻觉。这样的具体内容可能是专有的、敏感的，或者，就像这个例子中一样，是最近的和更新的。",kt,U,Ne="如果你的数据集是静态的和不需要定期更新的，那么你可能会考虑微调一个大模型。但在大多数情况下，微调模型花费巨大并且重复去微调的话(比如，处理数据漂移的时候)，可能会导致“模型偏移”。这种情况模型行为的变换就不是设计的那样了。",It,$,Fe="<strong>RAG (检索增强生成)</strong> 并不需要模型微调。相反， RAG 通过提供检索到的额外的相关内容喂给 LLM 以此来获得更好的回答。",Rt,j,Se="这里是一个简单说明：",Ht,C,Le='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/rag-diagram.png" alt="RAG diagram"/>',Xt,G,ze="<li><p>额外的数据通过独立的嵌入模型会被转化为嵌入向量，这些向量会储存在向量数据库里。嵌入模型通常都比较小，因此在常规偏差上更新嵌入向量相比于微调模型会更快，便宜，和简单。</p></li> <li><p>与此同时，由于不需要微调，给了你极大的自由度去切换选择你自己的更强的 LLM，或者对于更快速的推理去切换更小的蒸馏模型。</p></li>",Wt,x,Ee="让我们用开源的 LLM ，嵌入模型，和 LangChain 快速构建一个针对项目 GitHub issues 的简单 RAG。",Vt,B,Qe="首先安装相关依赖：",Nt,v,Ft,Z,St,_,Lt,k,zt,I,Ye='在这个例子中，我们会从<a href="https://github.com/huggingface/peft" rel="nofollow">PEFT 库的仓库</a>加载所有的 issues（包括现在开放的和已经关闭的）。',Et,R,qe='首先，你需要获取一个 <a href="https://github.com/settings/tokens?type=beta" rel="nofollow">GitHub 个人权限 token</a> 来访问 GitHub API。',Qt,H,Yt,X,Ae='下一步，我们将会加载  <a href="https://github.com/huggingface/peft" rel="nofollow">huggingface/peft</a> 仓库中所有的 issues:',qt,W,Pe="<li>默认情况下， PR 也被认定为 issues，这里我们要设置 <code>include_prs=False</code> 来排除 PR。</li> <li>设置 <code>state = &quot;all&quot;</code> 意味着我们会把开放和已经关闭的 issues 都加载了。</li>",At,V,Pt,N,De="个人仓库的 issues 内容可能会长于一个嵌入模型可以最为输入处理的长度。如果我们想要嵌入所有可用的内容，我们需要把文档分割成适当大小的块。",Dt,F,Ke="最普通直接的切块方法就是定义一个固定的块大小，以及判断块之间是否加入重叠。保存一些块之间的重叠允许我们去保存一些语义上下文。",Kt,S,Oe="其他方法通常更复杂，会考虑到文档的结构和上下文。例如，人们可能希望根据句子或段落来分割文档，然而，固定大小的分块在大多数常见情况下都表现得很好，所以我们将在这里采用这种方法。",Ot,L,te,z,ee,E,tl="现在所有的文档都设置成立合适的大小，我们可以用他们的嵌入创建一个数据集了。",le,Q,el='为了创建文档块嵌入，我们将会使用 <code>HuggingFaceEmbeddings</code> 和 <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a> 嵌入模型。在 Hub 上有许多其他的嵌入模型可用，你也可以查看 <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">Massive Text Embedding Benchmark (MTEB) Leaderboard</a> 关注表现最好的模型。',se,Y,ll="为了创建向量数据库，我们将会使用 <code>FAISS</code> 库。这个库提供高效的相似度搜索和稠密向量的聚类，正是我们需要的。FAISS 目前是大规模数据集上 NN 搜索最常用的库之一。",ne,q,sl="我们通过 LangChain 的 API 来获取嵌入模型和 FAISS 向量数据库。",ae,A,pe,P,nl="我们需要一种方式，来返回给定无结构的查询所需要的文档。针对这个，我们会使用 <code>as_retriever</code> 方法，使用 <code>db</code> 作为支柱：",ie,D,al="<li><code>search_type=&quot;similarity&quot;</code> 意味着我们会执行查询和文档之间的相似度搜索</li> <li><code>search_kwargs={&#39;k&#39;: 4}</code> 指示我们指定返回的最高的 4 个结果</li>",me,K,oe,O,pl="向量数据库和检索器现在设置好了，下一步我们需要设置好链中的下一块 - 模型。",ue,tt,be,et,il='针对本例，我们选择 <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>, 一个小而强大的模型。',re,lt,ml='随着每周都会出好多模型，你可能会想要替换这个模型到最新的最好的模型。最好的方式是查看 <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>。',Me,st,ol="为了推理更快，我们将加载模型的量化版本：",ye,nt,fe,at,Je,pt,ul="最后，我们有了所有的需要设置的 LLM 链的部分。",Te,it,bl="首先，使用加载的模型和他的tokenizer创建一个文本生成的流水线(pipeline)",ce,mt,rl="下一步，创建一个提示模板-这个应该遵循模型的格式，所以如果你替换了模型检查点，确保使用合适的格式。",he,ot,de,ut,Ml="注意：你也可以使用 <code>tokenizer.apply_chat_template</code> 转换列表消息为合适聊天格式的字符串（字典也行  <code>{&#39;role&#39;: &#39;user&#39;, &#39;content&#39;: &#39;(...)&#39;}</code>）",we,bt,yl="最后，我们需要将 LLM 链与检索器(retriever)结合起来创建一个 RAG 链。我们将原始问题以及检索到的文档上下文传递到最后生成步骤：",ge,rt,Ue,Mt,$e,yt,fl="让我们看看对于特定领域库的问题不同的 RAG 的生成的回答。",je,ft,Ce,Jt,Jl="首先，让我们看看仅仅通过模型自身不加检索内容能得到什么答案:",Ge,Tt,xe,ct,Tl=`可以看到，模型将这个问题解释为关于物理电脑适配器的问题，而在 PEFT 的背景下，“适配器”指的是 LoRA 适配器。
让我们看看添加 GitHub issues 的上下文是否有助于模型给出更相关的答案：`,Be,ht,ve,dt,cl="我们可以看到，加入检索的信息后，同一个模型能够对于特定库的问题给出更准确、更相关的答案。",Ze,wt,hl="值得注意的是，将多个适配器结合用于推理的功能已经被添加到库中，人们可以在文档中找到这些信息，因此在下一个迭代的RAG中，包含文档嵌入可能是有价值的。",_e,gt,ke,jt,Ie;return T=new Bl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/enterprise_cookbook_gradio_remove_outputs/notebooks/zh-CN/rag_zephyr_langchain.ipynb"}]}}),c=new Ut({props:{title:"用 Hugging Face Zephyr 和 LangChain 针对 Github issues 构建简单的 RAG",local:"用-hugging-face-zephyr-和-langchain-针对-github-issues-构建简单的-rag",headingTag:"h1"}}),v=new f({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHRyYW5zZm9ybWVycyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdQ==",highlighted:"!pip install -q torch transformers accelerate bitsandbytes transformers sentence-transformers faiss-gpu",wrap:!1}}),Z=new f({props:{code:"JTIzJTIwSWYlMjBydW5uaW5nJTIwaW4lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMG1heSUyMG5lZWQlMjB0byUyMHJ1biUyMHRoaXMlMjBjZWxsJTIwdG8lMjBtYWtlJTIwc3VyZSUyMHlvdSdyZSUyMHVzaW5nJTIwVVRGLTglMjBsb2NhbGUlMjB0byUyMGluc3RhbGwlMjBMYW5nQ2hhaW4lMEFpbXBvcnQlMjBsb2NhbGUlMEElMEFsb2NhbGUuZ2V0cHJlZmVycmVkZW5jb2RpbmclMjAlM0QlMjBsYW1iZGElM0ElMjAlMjJVVEYtOCUyMg==",highlighted:`<span class="hljs-comment"># If running in Google Colab, you may need to run this cell to make sure you&#x27;re using UTF-8 locale to install LangChain</span>
<span class="hljs-keyword">import</span> locale

locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>`,wrap:!1}}),_=new f({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGxhbmdjaGFpbg==",highlighted:"!pip install -q langchain",wrap:!1}}),k=new Ut({props:{title:"准备数据",local:"准备数据",headingTag:"h2"}}),H=new f({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBJTBBQUNDRVNTX1RPS0VOJTIwJTNEJTIwZ2V0cGFzcyglMjJZT1VSX0dJVEhVQl9QRVJTT05BTF9UT0tFTiUyMik=",highlighted:`<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass

ACCESS_TOKEN = getpass(<span class="hljs-string">&quot;YOUR_GITHUB_PERSONAL_TOKEN&quot;</span>)`,wrap:!1}}),V=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2N1bWVudF9sb2FkZXJzJTIwaW1wb3J0JTIwR2l0SHViSXNzdWVzTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwR2l0SHViSXNzdWVzTG9hZGVyKHJlcG8lM0QlMjJodWdnaW5nZmFjZSUyRnBlZnQlMjIlMkMlMjBhY2Nlc3NfdG9rZW4lM0RBQ0NFU1NfVE9LRU4lMkMlMjBpbmNsdWRlX3BycyUzREZhbHNlJTJDJTIwc3RhdGUlM0QlMjJhbGwlMjIpJTBBJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.document_loaders <span class="hljs-keyword">import</span> GitHubIssuesLoader

loader = GitHubIssuesLoader(repo=<span class="hljs-string">&quot;huggingface/peft&quot;</span>, access_token=ACCESS_TOKEN, include_prs=<span class="hljs-literal">False</span>, state=<span class="hljs-string">&quot;all&quot;</span>)

docs = loader.load()`,wrap:!1}}),L=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBc3BsaXR0ZXIlMjAlM0QlMjBDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUxMiUyQyUyMGNodW5rX292ZXJsYXAlM0QzMCklMEElMEFjaHVua2VkX2RvY3MlMjAlM0QlMjBzcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> CharacterTextSplitter

splitter = CharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">30</span>)

chunked_docs = splitter.split_documents(docs)`,wrap:!1}}),z=new Ut({props:{title:"创建嵌入和检索器",local:"创建嵌入和检索器",headingTag:"h2"}}),A=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW4uZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQSUwQWRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoY2h1bmtlZF9kb2NzJTJDJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLWJhc2UtZW4tdjEuNSUyMikp",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

db = FAISS.from_documents(chunked_docs, HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>))`,wrap:!1}}),K=new f({props:{code:"cmV0cmlldmVyJTIwJTNEJTIwZGIuYXNfcmV0cmlldmVyKHNlYXJjaF90eXBlJTNEJTIyc2ltaWxhcml0eSUyMiUyQyUyMHNlYXJjaF9rd2FyZ3MlM0QlN0IlMjJrJTIyJTNBJTIwNCU3RCk=",highlighted:'retriever = db.as_retriever(search_type=<span class="hljs-string">&quot;similarity&quot;</span>, search_kwargs={<span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">4</span>})',wrap:!1}}),tt=new Ut({props:{title:"加载量化模型",local:"加载量化模型",headingTag:"h2"}}),nt=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiUwQSUwQWJuYl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9jb25maWcpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>, bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)`,wrap:!1}}),at=new Ut({props:{title:"设置 LLM 链",local:"设置-llm-链",headingTag:"h2"}}),ot=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5sbG1zJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VQaXBlbGluZSUwQWZyb20lMjBsYW5nY2hhaW4ucHJvbXB0cyUyMGltcG9ydCUyMFByb21wdFRlbXBsYXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm91dHB1dF9wYXJzZXJzJTIwaW1wb3J0JTIwU3RyT3V0cHV0UGFyc2VyJTBBJTBBdGV4dF9nZW5lcmF0aW9uX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDAwJTJDJTBBKSUwQSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlUGlwZWxpbmUocGlwZWxpbmUlM0R0ZXh0X2dlbmVyYXRpb25fcGlwZWxpbmUpJTBBJTBBcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIyJTIyJTBBJTNDJTdDc3lzdGVtJTdDJTNFJTBBQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb24lMjBiYXNlZCUyMG9uJTIweW91ciUyMGtub3dsZWRnZS4lMjBVc2UlMjB0aGUlMjBmb2xsb3dpbmclMjBjb250ZXh0JTIwdG8lMjBoZWxwJTNBJTBBJTBBJTdCY29udGV4dCU3RCUwQSUwQSUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBJTdCcXVlc3Rpb24lN0QlMEElM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBJTBBJTIwJTIyJTIyJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwaW5wdXRfdmFyaWFibGVzJTNEJTVCJTIyY29udGV4dCUyMiUyQyUyMCUyMnF1ZXN0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0Rwcm9tcHRfdGVtcGxhdGUlMkMlMEEpJTBBJTBBbGxtX2NoYWluJTIwJTNEJTIwcHJvbXB0JTIwJTdDJTIwbGxtJTIwJTdDJTIwU3RyT3V0cHV0UGFyc2VyKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">400</span>,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
&lt;|system|&gt;
Answer the question based on your knowledge. Use the following context to help:

{context}

&lt;/s&gt;
&lt;|user|&gt;
{question}
&lt;/s&gt;
&lt;|assistant|&gt;

 &quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)

llm_chain = prompt | llm | StrOutputParser()`,wrap:!1}}),rt=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLnJ1bm5hYmxlcyUyMGltcG9ydCUyMFJ1bm5hYmxlUGFzc3Rocm91Z2glMEElMEFyZXRyaWV2ZXIlMjAlM0QlMjBkYi5hc19yZXRyaWV2ZXIoKSUwQSUwQXJhZ19jaGFpbiUyMCUzRCUyMCU3QiUyMmNvbnRleHQlMjIlM0ElMjByZXRyaWV2ZXIlMkMlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMFJ1bm5hYmxlUGFzc3Rocm91Z2goKSU3RCUyMCU3QyUyMGxsbV9jaGFpbg==",highlighted:`<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough

retriever = db.as_retriever()

rag_chain = {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()} | llm_chain`,wrap:!1}}),Mt=new Ut({props:{title:"比较结果",local:"比较结果",headingTag:"h2"}}),ft=new f({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJIb3clMjBkbyUyMHlvdSUyMGNvbWJpbmUlMjBtdWx0aXBsZSUyMGFkYXB0ZXJzJTNGJTIy",highlighted:'question = <span class="hljs-string">&quot;How do you combine multiple adapters?&quot;</span>',wrap:!1}}),Tt=new f({props:{code:"bGxtX2NoYWluLmludm9rZSglN0IlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiU3RCk=",highlighted:'llm_chain.invoke({<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>: question})',wrap:!1}}),ht=new f({props:{code:"cmFnX2NoYWluLmludm9rZShxdWVzdGlvbik=",highlighted:"rag_chain.invoke(question)",wrap:!1}}),gt=new vl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_zephyr_langchain.md"}}),{c(){J=p("meta"),Ct=n(),$t=p("p"),Gt=n(),o(T.$$.fragment),xt=n(),o(c.$$.fragment),Bt=n(),h=p("p"),h.innerHTML=He,vt=n(),d=p("p"),d.innerHTML=Xe,Zt=n(),w=p("p"),w.innerHTML=We,_t=n(),g=p("p"),g.textContent=Ve,kt=n(),U=p("p"),U.textContent=Ne,It=n(),$=p("p"),$.innerHTML=Fe,Rt=n(),j=p("p"),j.textContent=Se,Ht=n(),C=p("p"),C.innerHTML=Le,Xt=n(),G=p("ul"),G.innerHTML=ze,Wt=n(),x=p("p"),x.textContent=Ee,Vt=n(),B=p("p"),B.textContent=Qe,Nt=n(),o(v.$$.fragment),Ft=n(),o(Z.$$.fragment),St=n(),o(_.$$.fragment),Lt=n(),o(k.$$.fragment),zt=n(),I=p("p"),I.innerHTML=Ye,Et=n(),R=p("p"),R.innerHTML=qe,Qt=n(),o(H.$$.fragment),Yt=n(),X=p("p"),X.innerHTML=Ae,qt=n(),W=p("ul"),W.innerHTML=Pe,At=n(),o(V.$$.fragment),Pt=n(),N=p("p"),N.textContent=De,Dt=n(),F=p("p"),F.textContent=Ke,Kt=n(),S=p("p"),S.textContent=Oe,Ot=n(),o(L.$$.fragment),te=n(),o(z.$$.fragment),ee=n(),E=p("p"),E.textContent=tl,le=n(),Q=p("p"),Q.innerHTML=el,se=n(),Y=p("p"),Y.innerHTML=ll,ne=n(),q=p("p"),q.textContent=sl,ae=n(),o(A.$$.fragment),pe=n(),P=p("p"),P.innerHTML=nl,ie=n(),D=p("ul"),D.innerHTML=al,me=n(),o(K.$$.fragment),oe=n(),O=p("p"),O.textContent=pl,ue=n(),o(tt.$$.fragment),be=n(),et=p("p"),et.innerHTML=il,re=n(),lt=p("p"),lt.innerHTML=ml,Me=n(),st=p("p"),st.textContent=ol,ye=n(),o(nt.$$.fragment),fe=n(),o(at.$$.fragment),Je=n(),pt=p("p"),pt.textContent=ul,Te=n(),it=p("p"),it.textContent=bl,ce=n(),mt=p("p"),mt.textContent=rl,he=n(),o(ot.$$.fragment),de=n(),ut=p("p"),ut.innerHTML=Ml,we=n(),bt=p("p"),bt.textContent=yl,ge=n(),o(rt.$$.fragment),Ue=n(),o(Mt.$$.fragment),$e=n(),yt=p("p"),yt.textContent=fl,je=n(),o(ft.$$.fragment),Ce=n(),Jt=p("p"),Jt.textContent=Jl,Ge=n(),o(Tt.$$.fragment),xe=n(),ct=p("p"),ct.textContent=Tl,Be=n(),o(ht.$$.fragment),ve=n(),dt=p("p"),dt.textContent=cl,Ze=n(),wt=p("p"),wt.textContent=hl,_e=n(),o(gt.$$.fragment),ke=n(),jt=p("p"),this.h()},l(t){const e=Gl("svelte-u9bgzb",document.head);J=i(e,"META",{name:!0,content:!0}),e.forEach(l),Ct=a(t),$t=i(t,"P",{}),dl($t).forEach(l),Gt=a(t),u(T.$$.fragment,t),xt=a(t),u(c.$$.fragment,t),Bt=a(t),h=i(t,"P",{"data-svelte-h":!0}),m(h)!=="svelte-1dsumsc"&&(h.innerHTML=He),vt=a(t),d=i(t,"P",{"data-svelte-h":!0}),m(d)!=="svelte-1nxrv0b"&&(d.innerHTML=Xe),Zt=a(t),w=i(t,"P",{"data-svelte-h":!0}),m(w)!=="svelte-15ot3ve"&&(w.innerHTML=We),_t=a(t),g=i(t,"P",{"data-svelte-h":!0}),m(g)!=="svelte-11u8woo"&&(g.textContent=Ve),kt=a(t),U=i(t,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1fwpup0"&&(U.textContent=Ne),It=a(t),$=i(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-2xs5eo"&&($.innerHTML=Fe),Rt=a(t),j=i(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-2l10hj"&&(j.textContent=Se),Ht=a(t),C=i(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1c1z86r"&&(C.innerHTML=Le),Xt=a(t),G=i(t,"UL",{"data-svelte-h":!0}),m(G)!=="svelte-1cd3ng1"&&(G.innerHTML=ze),Wt=a(t),x=i(t,"P",{"data-svelte-h":!0}),m(x)!=="svelte-nhx78j"&&(x.textContent=Ee),Vt=a(t),B=i(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-10677r8"&&(B.textContent=Qe),Nt=a(t),u(v.$$.fragment,t),Ft=a(t),u(Z.$$.fragment,t),St=a(t),u(_.$$.fragment,t),Lt=a(t),u(k.$$.fragment,t),zt=a(t),I=i(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1f0miko"&&(I.innerHTML=Ye),Et=a(t),R=i(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1fd32v"&&(R.innerHTML=qe),Qt=a(t),u(H.$$.fragment,t),Yt=a(t),X=i(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1hkyu0j"&&(X.innerHTML=Ae),qt=a(t),W=i(t,"UL",{"data-svelte-h":!0}),m(W)!=="svelte-1a0rln0"&&(W.innerHTML=Pe),At=a(t),u(V.$$.fragment,t),Pt=a(t),N=i(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-ryc3lv"&&(N.textContent=De),Dt=a(t),F=i(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-s0tphm"&&(F.textContent=Ke),Kt=a(t),S=i(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1ir96rw"&&(S.textContent=Oe),Ot=a(t),u(L.$$.fragment,t),te=a(t),u(z.$$.fragment,t),ee=a(t),E=i(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-frdo0o"&&(E.textContent=tl),le=a(t),Q=i(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1cfgvps"&&(Q.innerHTML=el),se=a(t),Y=i(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-x85d74"&&(Y.innerHTML=ll),ne=a(t),q=i(t,"P",{"data-svelte-h":!0}),m(q)!=="svelte-9ffz7p"&&(q.textContent=sl),ae=a(t),u(A.$$.fragment,t),pe=a(t),P=i(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-xex2hi"&&(P.innerHTML=nl),ie=a(t),D=i(t,"UL",{"data-svelte-h":!0}),m(D)!=="svelte-4jbas3"&&(D.innerHTML=al),me=a(t),u(K.$$.fragment,t),oe=a(t),O=i(t,"P",{"data-svelte-h":!0}),m(O)!=="svelte-5nilxz"&&(O.textContent=pl),ue=a(t),u(tt.$$.fragment,t),be=a(t),et=i(t,"P",{"data-svelte-h":!0}),m(et)!=="svelte-df64rt"&&(et.innerHTML=il),re=a(t),lt=i(t,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-1yhmn0n"&&(lt.innerHTML=ml),Me=a(t),st=i(t,"P",{"data-svelte-h":!0}),m(st)!=="svelte-jk1sm8"&&(st.textContent=ol),ye=a(t),u(nt.$$.fragment,t),fe=a(t),u(at.$$.fragment,t),Je=a(t),pt=i(t,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-oeo873"&&(pt.textContent=ul),Te=a(t),it=i(t,"P",{"data-svelte-h":!0}),m(it)!=="svelte-if5n97"&&(it.textContent=bl),ce=a(t),mt=i(t,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-1a017u5"&&(mt.textContent=rl),he=a(t),u(ot.$$.fragment,t),de=a(t),ut=i(t,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-kibc99"&&(ut.innerHTML=Ml),we=a(t),bt=i(t,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-18onexw"&&(bt.textContent=yl),ge=a(t),u(rt.$$.fragment,t),Ue=a(t),u(Mt.$$.fragment,t),$e=a(t),yt=i(t,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-1hik170"&&(yt.textContent=fl),je=a(t),u(ft.$$.fragment,t),Ce=a(t),Jt=i(t,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-gn3i6x"&&(Jt.textContent=Jl),Ge=a(t),u(Tt.$$.fragment,t),xe=a(t),ct=i(t,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-15qdncx"&&(ct.textContent=Tl),Be=a(t),u(ht.$$.fragment,t),ve=a(t),dt=i(t,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-11ic9g3"&&(dt.textContent=cl),Ze=a(t),wt=i(t,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-gcl5gb"&&(wt.textContent=hl),_e=a(t),u(gt.$$.fragment,t),ke=a(t),jt=i(t,"P",{}),dl(jt).forEach(l),this.h()},h(){wl(J,"name","hf:doc:metadata"),wl(J,"content",_l)},m(t,e){xl(document.head,J),s(t,Ct,e),s(t,$t,e),s(t,Gt,e),b(T,t,e),s(t,xt,e),b(c,t,e),s(t,Bt,e),s(t,h,e),s(t,vt,e),s(t,d,e),s(t,Zt,e),s(t,w,e),s(t,_t,e),s(t,g,e),s(t,kt,e),s(t,U,e),s(t,It,e),s(t,$,e),s(t,Rt,e),s(t,j,e),s(t,Ht,e),s(t,C,e),s(t,Xt,e),s(t,G,e),s(t,Wt,e),s(t,x,e),s(t,Vt,e),s(t,B,e),s(t,Nt,e),b(v,t,e),s(t,Ft,e),b(Z,t,e),s(t,St,e),b(_,t,e),s(t,Lt,e),b(k,t,e),s(t,zt,e),s(t,I,e),s(t,Et,e),s(t,R,e),s(t,Qt,e),b(H,t,e),s(t,Yt,e),s(t,X,e),s(t,qt,e),s(t,W,e),s(t,At,e),b(V,t,e),s(t,Pt,e),s(t,N,e),s(t,Dt,e),s(t,F,e),s(t,Kt,e),s(t,S,e),s(t,Ot,e),b(L,t,e),s(t,te,e),b(z,t,e),s(t,ee,e),s(t,E,e),s(t,le,e),s(t,Q,e),s(t,se,e),s(t,Y,e),s(t,ne,e),s(t,q,e),s(t,ae,e),b(A,t,e),s(t,pe,e),s(t,P,e),s(t,ie,e),s(t,D,e),s(t,me,e),b(K,t,e),s(t,oe,e),s(t,O,e),s(t,ue,e),b(tt,t,e),s(t,be,e),s(t,et,e),s(t,re,e),s(t,lt,e),s(t,Me,e),s(t,st,e),s(t,ye,e),b(nt,t,e),s(t,fe,e),b(at,t,e),s(t,Je,e),s(t,pt,e),s(t,Te,e),s(t,it,e),s(t,ce,e),s(t,mt,e),s(t,he,e),b(ot,t,e),s(t,de,e),s(t,ut,e),s(t,we,e),s(t,bt,e),s(t,ge,e),b(rt,t,e),s(t,Ue,e),b(Mt,t,e),s(t,$e,e),s(t,yt,e),s(t,je,e),b(ft,t,e),s(t,Ce,e),s(t,Jt,e),s(t,Ge,e),b(Tt,t,e),s(t,xe,e),s(t,ct,e),s(t,Be,e),b(ht,t,e),s(t,ve,e),s(t,dt,e),s(t,Ze,e),s(t,wt,e),s(t,_e,e),b(gt,t,e),s(t,ke,e),s(t,jt,e),Ie=!0},p:Ul,i(t){Ie||(r(T.$$.fragment,t),r(c.$$.fragment,t),r(v.$$.fragment,t),r(Z.$$.fragment,t),r(_.$$.fragment,t),r(k.$$.fragment,t),r(H.$$.fragment,t),r(V.$$.fragment,t),r(L.$$.fragment,t),r(z.$$.fragment,t),r(A.$$.fragment,t),r(K.$$.fragment,t),r(tt.$$.fragment,t),r(nt.$$.fragment,t),r(at.$$.fragment,t),r(ot.$$.fragment,t),r(rt.$$.fragment,t),r(Mt.$$.fragment,t),r(ft.$$.fragment,t),r(Tt.$$.fragment,t),r(ht.$$.fragment,t),r(gt.$$.fragment,t),Ie=!0)},o(t){M(T.$$.fragment,t),M(c.$$.fragment,t),M(v.$$.fragment,t),M(Z.$$.fragment,t),M(_.$$.fragment,t),M(k.$$.fragment,t),M(H.$$.fragment,t),M(V.$$.fragment,t),M(L.$$.fragment,t),M(z.$$.fragment,t),M(A.$$.fragment,t),M(K.$$.fragment,t),M(tt.$$.fragment,t),M(nt.$$.fragment,t),M(at.$$.fragment,t),M(ot.$$.fragment,t),M(rt.$$.fragment,t),M(Mt.$$.fragment,t),M(ft.$$.fragment,t),M(Tt.$$.fragment,t),M(ht.$$.fragment,t),M(gt.$$.fragment,t),Ie=!1},d(t){t&&(l(Ct),l($t),l(Gt),l(xt),l(Bt),l(h),l(vt),l(d),l(Zt),l(w),l(_t),l(g),l(kt),l(U),l(It),l($),l(Rt),l(j),l(Ht),l(C),l(Xt),l(G),l(Wt),l(x),l(Vt),l(B),l(Nt),l(Ft),l(St),l(Lt),l(zt),l(I),l(Et),l(R),l(Qt),l(Yt),l(X),l(qt),l(W),l(At),l(Pt),l(N),l(Dt),l(F),l(Kt),l(S),l(Ot),l(te),l(ee),l(E),l(le),l(Q),l(se),l(Y),l(ne),l(q),l(ae),l(pe),l(P),l(ie),l(D),l(me),l(oe),l(O),l(ue),l(be),l(et),l(re),l(lt),l(Me),l(st),l(ye),l(fe),l(Je),l(pt),l(Te),l(it),l(ce),l(mt),l(he),l(de),l(ut),l(we),l(bt),l(ge),l(Ue),l($e),l(yt),l(je),l(Ce),l(Jt),l(Ge),l(xe),l(ct),l(Be),l(ve),l(dt),l(Ze),l(wt),l(_e),l(ke),l(jt)),l(J),y(T,t),y(c,t),y(v,t),y(Z,t),y(_,t),y(k,t),y(H,t),y(V,t),y(L,t),y(z,t),y(A,t),y(K,t),y(tt,t),y(nt,t),y(at,t),y(ot,t),y(rt,t),y(Mt,t),y(ft,t),y(Tt,t),y(ht,t),y(gt,t)}}}const _l='{"title":"用 Hugging Face Zephyr 和 LangChain 针对 Github issues 构建简单的 RAG","local":"用-hugging-face-zephyr-和-langchain-针对-github-issues-构建简单的-rag","sections":[{"title":"准备数据","local":"准备数据","sections":[],"depth":2},{"title":"创建嵌入和检索器","local":"创建嵌入和检索器","sections":[],"depth":2},{"title":"加载量化模型","local":"加载量化模型","sections":[],"depth":2},{"title":"设置 LLM 链","local":"设置-llm-链","sections":[],"depth":2},{"title":"比较结果","local":"比较结果","sections":[],"depth":2}],"depth":1}';function kl(Re){return $l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wl extends jl{constructor(J){super(),Cl(this,J,kl,Zl,gl,{})}}export{Wl as component};
