import{s as Rt,f as Tt,n as _t,o as Ft}from"../chunks/scheduler.7bc62968.js";import{S as Ut,i as Jt,g as a,s as l,r as p,A as Nt,h as r,f as n,c as s,j as $t,u as d,x as o,k as ie,y as jt,a as i,v as m,d as u,t as c,w as h}from"../chunks/index.2f8492b0.js";import{C as Mt}from"../chunks/CodeBlock.bb61a5a9.js";import{H as w,E as Ht}from"../chunks/getInferenceSnippets.7ce1588a.js";function zt(Ae){let f,ae,le,re,y,oe,x,Qe="Neural networks with more layers were assumed to be more effective because adding more layers improves the model performance.",pe,b,De="As the networks became deeper, the extracted features could be further enriched, such as seen with VGG16 and VGG19.",de,v,Ke=`A question arose: “Is learning networks as easy as stacking more layers”?
An obstacle to answering this question, the gradient vanishing problem, was addressed by normalized initializations and intermediate normalization layers.`,me,C,Oe="However, a new issue emerged: the degradation problem. As the neural networks became deeper, accuracy saturated and degraded rapidly. An experiment comparing shallow and deep plain networks revealed that deeper models exhibited higher training and test errors, suggesting a fundamental challenge in training deeper architectures effectively. This degradation was not because of overfitting but because the training error increased when the network became deeper. The added layers did not approximate the identity function.",ue,g,et,ce,k,tt="ResNet’s residual connections unlocked the potential of the extreme depth, propelling the accuracy upwards compared to the previous architectures.",he,$,fe,M,nt=`<li>A Residual Block. Source: ResNet Paper
<img src="https://huggingface.co/datasets/hf-vision/course-assets/blob/main/ResnetBlock.png" alt="residual"/></li>`,ge,R,it="ResNets introduce a concept called residual learning, which allows the network to learn the residuals (i.e., the difference between the learned representation and the input), instead of trying to directly map inputs to outputs. This is achieved through skip connections (or shortcut connections).",we,T,lt="Let’s break this down:",ye,_,xe,F,st="In a typical neural network layer, we aim to learn a mapping F(x), where x is the input and F is the transformation the network applies. Without residual learning, the transformation at a layer is: y = F(x). In ResNets, instead of learning F(x) directly, the network is designed to learn the residual R(x), where: R(x) = F(x) − x. Thus, the transformation in a residual block is written as: y = F(x) + x.",be,U,at="Here, x is the input to the residual block, and F(x) is the output of the block’s stacked layers (usually convolutions, batch normalization, and ReLU). The identity mapping x is directly added to the output of F(x) (through the skip connection). So the block is learning the residual R(x) = F(x), and the final output is F(x) + x. This residual function is easier to optimize compared to the original mapping. If the optimal transformation is close to the identity (i.e., no transformation is needed), the network can easily set F(x) ≈ 0 to pass through the input as it is.",ve,J,rt="<li>The building block of ResNet can be shown in the picture, source ResNet paper.</li>",Ce,N,ot='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/ResnetBlock.png" alt="resnet_building_block"/>',ke,j,$e,H,pt="The primary reason ResNets work well for very deep networks is due to improved gradient flow during backpropagation. Let’s analyze the backward pass mathematically. Let’s say you have the residual block y = F(x) + x. When calculating gradients via the chain rule, we compute the derivative of the loss 𝐿 with respect to the input x. For a standard block (without residuals), the gradient is:",Me,z,dt="<code>∂x/∂L = ∂F(x)/∂L * ∂F(x)/∂x</code>",Re,Z,mt="However, for the residual block, where y = F(x) + x, the gradient becomes:",Te,L,ut="<code>∂L/∂x = ∂L/∂F(x) * ∂F(x)/∂x + ∂L/∂F(x) ⋅1</code>",_e,B,ct="Notice that we now have an additional term 1 in the gradient calculation. This means that the gradient at each layer has a direct path back to earlier layers, improving gradient flow and reducing the chance of vanishing gradients. The gradients flow more easily through the network, allowing deeper networks to train without degradation.",Fe,G,Ue,P,ht="ResNets made it feasible to train networks with hundreds or even thousands of layers. Here’s why deeper networks benefit from this:",Je,V,ft=`<li>Identity Shortcut Connections: Shortcut connections perform identity mapping and their output is added to the output of the stacked layers. Identity shortcut connections add neither extra parameters nor
computational complexity, these connections bypass layers, creating direct paths for information flow, and they enable neural networks to learn the residual function (F).</li> <li>Better Gradient Flow: As explained earlier, the residuals help gradients propagate better during backpropagation, addressing the vanishing gradient problem in very deep networks.</li> <li>Easier to Optimize: By learning residuals, the network is essentially breaking down the learning process into easier, incremental steps. It’s easier for the network to learn the residual R(x) = F(x) − x than it is to learn F(x) directly, especially in very deep networks.</li>`,Ne,W,je,I,gt="We can conclude that ResNet Network ->  Plain Network + Shortcuts!",He,E,wt=`For operations  (F(x) + x), (F(x)) and (x) should have identical dimensions.
ResNet employs two techniques to achieve this:`,ze,Y,yt="<li>Zero-padding shortcuts that add channels with zero values, maintaining dimensions without introducing extra parameters to be learned.</li> <li>Projection shortcuts that use 1x1 convolutions to adjust dimensions when necessary, involving some additional learnable parameters.</li>",Ze,q,xt="In deeper ResNet architectures like ResNet 50, 101, and 152, a specialized “bottleneck building block” is employed to manage parameter complexity and maintain efficiency while enabling even deeper learning.",Le,S,Be,X,Ge,A,bt="Below you can see how to load pre-trained ResNet with an image classification head using transformers library.",Pe,Q,Ve,D,vt="All pre-trained models expect input images normalized similarly, i.e. mini-batches of 3-channel RGB images of shape (3 x H x W), where H and W are expected to be at least 224. The images have to be loaded into a range of [0, 1] and then normalized using mean = [0.485, 0.456, 0.406] and std = [0.229, 0.224, 0.225].",We,K,Ct='Here’s a sample execution. This example is available in the <a href="https://huggingface.co/docs/transformers/v4.18.0/en/model_doc/resnet" rel="nofollow">Hugging Face documentation</a>.',Ie,O,Ee,ee,Ye,te,kt='<li><p><a href="https://pytorch.org/hub/pytorch_vision_resnet/" rel="nofollow">PyTorch docs</a></p></li> <li><p><a href="https://arxiv.org/abs/1512.03385" rel="nofollow">ResNet: Deep Residual Learning for Image Recognition</a></p></li> <li><p><a href="https://arxiv.org/abs/1512.03385" rel="nofollow">Resnet Architecture Source: ResNet Paper</a></p></li> <li><p><a href="https://huggingface.co/docs/transformers/en/model_doc/resnet" rel="nofollow">Hugging Face Documentation on ResNet</a></p></li>',qe,ne,Se,se,Xe;return y=new w({props:{title:"ResNet (Residual Network)",local:"resnet-residual-network",headingTag:"h1"}}),$=new w({props:{title:"ResNet Architecture",local:"resnet-architecture",headingTag:"h2"}}),_=new w({props:{title:"1. Basic Building Block: Residual Block",local:"1-basic-building-block-residual-block",headingTag:"h4"}}),j=new w({props:{title:"2. Learning Residuals and Gradient Flow",local:"2-learning-residuals-and-gradient-flow",headingTag:"h4"}}),G=new w({props:{title:"3. Why Deeper Networks are Now Possible:",local:"3-why-deeper-networks-are-now-possible",headingTag:"h4"}}),W=new w({props:{title:"Summarizing:",local:"summarizing",headingTag:"h3"}}),S=new w({props:{title:"ResNet Code",local:"resnet-code",headingTag:"h2"}}),X=new w({props:{title:"Deep Residual Networks Pre-trained on ImageNet",local:"deep-residual-networks-pre-trained-on-imagenet",headingTag:"h3"}}),Q=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlc05ldEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFJlc05ldEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnJlc25ldC01MCUyMiklMEElMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ResNetForImageClassification

model = ResNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)

model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),O=new Mt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwUmVzTmV0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnJlc25ldC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMFJlc05ldEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnJlc25ldC01MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, ResNetForImageClassification
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)
model = ResNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/resnet-50&quot;</span>)

inputs = feature_extractor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    logits = model(**inputs).logits

<span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])`,wrap:!1}}),ee=new w({props:{title:"References",local:"references",headingTag:"h2"}}),ne=new Ht({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit2/cnns/resnet.mdx"}}),{c(){f=a("meta"),ae=l(),le=a("p"),re=l(),p(y.$$.fragment),oe=l(),x=a("p"),x.textContent=Qe,pe=l(),b=a("p"),b.textContent=De,de=l(),v=a("p"),v.textContent=Ke,me=l(),C=a("p"),C.textContent=Oe,ue=l(),g=a("img"),ce=l(),k=a("p"),k.textContent=tt,he=l(),p($.$$.fragment),fe=l(),M=a("ul"),M.innerHTML=nt,ge=l(),R=a("p"),R.textContent=it,we=l(),T=a("p"),T.textContent=lt,ye=l(),p(_.$$.fragment),xe=l(),F=a("p"),F.textContent=st,be=l(),U=a("p"),U.textContent=at,ve=l(),J=a("ul"),J.innerHTML=rt,Ce=l(),N=a("p"),N.innerHTML=ot,ke=l(),p(j.$$.fragment),$e=l(),H=a("p"),H.textContent=pt,Me=l(),z=a("p"),z.innerHTML=dt,Re=l(),Z=a("p"),Z.textContent=mt,Te=l(),L=a("p"),L.innerHTML=ut,_e=l(),B=a("p"),B.textContent=ct,Fe=l(),p(G.$$.fragment),Ue=l(),P=a("p"),P.textContent=ht,Je=l(),V=a("ul"),V.innerHTML=ft,Ne=l(),p(W.$$.fragment),je=l(),I=a("p"),I.textContent=gt,He=l(),E=a("p"),E.textContent=wt,ze=l(),Y=a("ul"),Y.innerHTML=yt,Ze=l(),q=a("p"),q.textContent=xt,Le=l(),p(S.$$.fragment),Be=l(),p(X.$$.fragment),Ge=l(),A=a("p"),A.textContent=bt,Pe=l(),p(Q.$$.fragment),Ve=l(),D=a("p"),D.textContent=vt,We=l(),K=a("p"),K.innerHTML=Ct,Ie=l(),p(O.$$.fragment),Ee=l(),p(ee.$$.fragment),Ye=l(),te=a("ul"),te.innerHTML=kt,qe=l(),p(ne.$$.fragment),Se=l(),se=a("p"),this.h()},l(e){const t=Nt("svelte-u9bgzb",document.head);f=r(t,"META",{name:!0,content:!0}),t.forEach(n),ae=s(e),le=r(e,"P",{}),$t(le).forEach(n),re=s(e),d(y.$$.fragment,e),oe=s(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-v6nqw1"&&(x.textContent=Qe),pe=s(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-tay29i"&&(b.textContent=De),de=s(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-f2z8gv"&&(v.textContent=Ke),me=s(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1xf9wlr"&&(C.textContent=Oe),ue=s(e),g=r(e,"IMG",{src:!0,alt:!0,width:!0,height:!0}),ce=s(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-jv7kti"&&(k.textContent=tt),he=s(e),d($.$$.fragment,e),fe=s(e),M=r(e,"UL",{"data-svelte-h":!0}),o(M)!=="svelte-w6gay8"&&(M.innerHTML=nt),ge=s(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1p5guo4"&&(R.textContent=it),we=s(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1cey2tw"&&(T.textContent=lt),ye=s(e),d(_.$$.fragment,e),xe=s(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-44heq9"&&(F.textContent=st),be=s(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1goagz5"&&(U.textContent=at),ve=s(e),J=r(e,"UL",{"data-svelte-h":!0}),o(J)!=="svelte-1kw1zsp"&&(J.innerHTML=rt),Ce=s(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-stgboa"&&(N.innerHTML=ot),ke=s(e),d(j.$$.fragment,e),$e=s(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-oye9bo"&&(H.textContent=pt),Me=s(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1hto4hp"&&(z.innerHTML=dt),Re=s(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1samybc"&&(Z.textContent=mt),Te=s(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-tjrw20"&&(L.innerHTML=ut),_e=s(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-u45k4s"&&(B.textContent=ct),Fe=s(e),d(G.$$.fragment,e),Ue=s(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-19fc4i8"&&(P.textContent=ht),Je=s(e),V=r(e,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-sttfnk"&&(V.innerHTML=ft),Ne=s(e),d(W.$$.fragment,e),je=s(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-6p3q0z"&&(I.textContent=gt),He=s(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-v51ypa"&&(E.textContent=wt),ze=s(e),Y=r(e,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-1rnct1s"&&(Y.innerHTML=yt),Ze=s(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1r7ha0d"&&(q.textContent=xt),Le=s(e),d(S.$$.fragment,e),Be=s(e),d(X.$$.fragment,e),Ge=s(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-xgcjij"&&(A.textContent=bt),Pe=s(e),d(Q.$$.fragment,e),Ve=s(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-kh8rtv"&&(D.textContent=vt),We=s(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-q6mi08"&&(K.innerHTML=Ct),Ie=s(e),d(O.$$.fragment,e),Ee=s(e),d(ee.$$.fragment,e),Ye=s(e),te=r(e,"UL",{"data-svelte-h":!0}),o(te)!=="svelte-s3zcq2"&&(te.innerHTML=kt),qe=s(e),d(ne.$$.fragment,e),Se=s(e),se=r(e,"P",{}),$t(se).forEach(n),this.h()},h(){ie(f,"name","hf:doc:metadata"),ie(f,"content",Zt),Tt(g.src,et="https://i.sstatic.net/xDLez.jpg")||ie(g,"src",et),ie(g,"alt","Degradation-error"),ie(g,"width","512"),ie(g,"height","512")},m(e,t){jt(document.head,f),i(e,ae,t),i(e,le,t),i(e,re,t),m(y,e,t),i(e,oe,t),i(e,x,t),i(e,pe,t),i(e,b,t),i(e,de,t),i(e,v,t),i(e,me,t),i(e,C,t),i(e,ue,t),i(e,g,t),i(e,ce,t),i(e,k,t),i(e,he,t),m($,e,t),i(e,fe,t),i(e,M,t),i(e,ge,t),i(e,R,t),i(e,we,t),i(e,T,t),i(e,ye,t),m(_,e,t),i(e,xe,t),i(e,F,t),i(e,be,t),i(e,U,t),i(e,ve,t),i(e,J,t),i(e,Ce,t),i(e,N,t),i(e,ke,t),m(j,e,t),i(e,$e,t),i(e,H,t),i(e,Me,t),i(e,z,t),i(e,Re,t),i(e,Z,t),i(e,Te,t),i(e,L,t),i(e,_e,t),i(e,B,t),i(e,Fe,t),m(G,e,t),i(e,Ue,t),i(e,P,t),i(e,Je,t),i(e,V,t),i(e,Ne,t),m(W,e,t),i(e,je,t),i(e,I,t),i(e,He,t),i(e,E,t),i(e,ze,t),i(e,Y,t),i(e,Ze,t),i(e,q,t),i(e,Le,t),m(S,e,t),i(e,Be,t),m(X,e,t),i(e,Ge,t),i(e,A,t),i(e,Pe,t),m(Q,e,t),i(e,Ve,t),i(e,D,t),i(e,We,t),i(e,K,t),i(e,Ie,t),m(O,e,t),i(e,Ee,t),m(ee,e,t),i(e,Ye,t),i(e,te,t),i(e,qe,t),m(ne,e,t),i(e,Se,t),i(e,se,t),Xe=!0},p:_t,i(e){Xe||(u(y.$$.fragment,e),u($.$$.fragment,e),u(_.$$.fragment,e),u(j.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(S.$$.fragment,e),u(X.$$.fragment,e),u(Q.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),Xe=!0)},o(e){c(y.$$.fragment,e),c($.$$.fragment,e),c(_.$$.fragment,e),c(j.$$.fragment,e),c(G.$$.fragment,e),c(W.$$.fragment,e),c(S.$$.fragment,e),c(X.$$.fragment,e),c(Q.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(ne.$$.fragment,e),Xe=!1},d(e){e&&(n(ae),n(le),n(re),n(oe),n(x),n(pe),n(b),n(de),n(v),n(me),n(C),n(ue),n(g),n(ce),n(k),n(he),n(fe),n(M),n(ge),n(R),n(we),n(T),n(ye),n(xe),n(F),n(be),n(U),n(ve),n(J),n(Ce),n(N),n(ke),n($e),n(H),n(Me),n(z),n(Re),n(Z),n(Te),n(L),n(_e),n(B),n(Fe),n(Ue),n(P),n(Je),n(V),n(Ne),n(je),n(I),n(He),n(E),n(ze),n(Y),n(Ze),n(q),n(Le),n(Be),n(Ge),n(A),n(Pe),n(Ve),n(D),n(We),n(K),n(Ie),n(Ee),n(Ye),n(te),n(qe),n(Se),n(se)),n(f),h(y,e),h($,e),h(_,e),h(j,e),h(G,e),h(W,e),h(S,e),h(X,e),h(Q,e),h(O,e),h(ee,e),h(ne,e)}}}const Zt='{"title":"ResNet (Residual Network)","local":"resnet-residual-network","sections":[{"title":"ResNet Architecture","local":"resnet-architecture","sections":[{"title":"1. Basic Building Block: Residual Block","local":"1-basic-building-block-residual-block","sections":[],"depth":4},{"title":"2. Learning Residuals and Gradient Flow","local":"2-learning-residuals-and-gradient-flow","sections":[],"depth":4},{"title":"3. Why Deeper Networks are Now Possible:","local":"3-why-deeper-networks-are-now-possible","sections":[],"depth":4},{"title":"Summarizing:","local":"summarizing","sections":[],"depth":3}],"depth":2},{"title":"ResNet Code","local":"resnet-code","sections":[{"title":"Deep Residual Networks Pre-trained on ImageNet","local":"deep-residual-networks-pre-trained-on-imagenet","sections":[],"depth":3}],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Lt(Ae){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends Ut{constructor(f){super(),Jt(this,f,Lt,zt,Rt,{})}}export{Wt as component};
