import{s as Gt,n as Rt,o as Ft}from"../chunks/scheduler.c59d9fbb.js";import{S as It,i as At,g as r,s,r as c,A as Zt,h as i,f as l,c as n,j as $t,u as p,x as o,k as Wt,y as Bt,a,v as M,d,t as m,w as b}from"../chunks/index.a47918e3.js";import{C as bt}from"../chunks/CodeBlock.936db8cd.js";import{H as E,E as Xt}from"../chunks/EditOnGithub.813e7c73.js";function Yt(ft){let f,x,Y,Q,h,H,y,ht="SetFit models can be influenced by callbacks, for example for logging or early stopping.",N,u,yt="This guide will show you what they are and how they can be used.",V,g,q,T,ut='Callbacks are objects that customize the behaviour of the training loop in the SetFit <a href="/docs/setfit/pr_577/en/reference/trainer#setfit.Trainer">Trainer</a> that can inspect the training loop state (for progress reporting, logging, inspecting embeddings during training) and take decisions (e.g. early stopping).',z,U,gt='In particular, the <a href="/docs/setfit/pr_577/en/reference/trainer#setfit.Trainer">Trainer</a> uses a <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerControl" rel="nofollow"><code>TrainerControl</code></a> that can be influenced by callbacks to stop training, save models, evaluate, or log, and a <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerState" rel="nofollow"><code>TrainerState</code></a> which tracks some training loop metrics during training, such as the number of training steps so far.',L,j,Tt='SetFit relies on the Callbacks implemented in <code>transformers</code>, as described in the <code>transformers</code> documentation <a href="https://huggingface.co/docs/transformers/main_classes/callback" rel="nofollow">here</a>.',P,J,K,w,Ut='SetFit uses the <code>TrainingArguments.report_to</code> argument to specify which of the built-in callbacks should be enabled. This argument defaults to <code>&quot;all&quot;</code>, meaning that all third-party callbacks from <code>transformers</code> that are also installed will be enabled. For example the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.TensorBoardCallback" rel="nofollow"><code>TensorBoardCallback</code></a> or the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.WandbCallback" rel="nofollow"><code>WandbCallback</code></a>.',D,C,jt='Beyond that, the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.PrinterCallback" rel="nofollow"><code>PrinterCallback</code></a> or <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.ProgressCallback" rel="nofollow"><code>ProgressCallback</code></a> is always enabled to show the training progress, and <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.DefaultFlowCallback" rel="nofollow"><code>DefaultFlowCallback</code></a> is also always enabled to properly update the <code>TrainerControl</code>.',O,k,tt,_,Jt="As mentioned, you can use <code>TrainingArguments.report_to</code> to specify exactly which callbacks you would like to enable. For example:",et,v,lt,$,wt='You can also use <a href="/docs/setfit/pr_577/en/reference/trainer#setfit.Trainer.add_callback">Trainer.add_callback()</a>, <a href="/docs/setfit/pr_577/en/reference/trainer#setfit.Trainer.pop_callback">Trainer.pop_callback()</a> and <a href="/docs/setfit/pr_577/en/reference/trainer#setfit.Trainer.remove_callback">Trainer.remove_callback()</a> to influence the trainer callbacks, and you can specify callbacks via the <a href="/docs/setfit/pr_577/en/reference/trainer#setfit.Trainer">Trainer</a> init, e.g.:',at,W,st,G,nt,R,Ct='SetFit supports custom callbacks in the same way that <code>transformers</code> does: by subclassing <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerCallback" rel="nofollow"><code>TrainerCallback</code></a>. This class implements a lot of <code>on_...</code> methods that can be overridden. For example, the following script shows a custom callback that saves plots of the tSNE of the training and evaluation embeddings during training.',rt,F,it,I,kt="with",ot,A,ct,Z,_t="The <code>on_evaluate</code> from <code>EmbeddingPlotCallback</code> will be triggered on every single evaluation call. In the case of this example, it resulted in the following figures being plotted:",pt,B,vt='<thead><tr><th>Step 20</th> <th>Step 40</th></tr></thead> <tbody><tr><td><img src="https://github.com/huggingface/setfit/assets/37621491/7200d00a-fd48-4038-bcbe-f2d5f1280162" alt="step_20"/></td> <td><img src="https://github.com/huggingface/setfit/assets/37621491/be12e3c4-867c-452d-89a0-0677f035516d" alt="step_40"/></td></tr> <tr><td><strong>Step 60</strong></td> <td><strong>Step 80</strong></td></tr> <tr><td><img src="https://github.com/huggingface/setfit/assets/37621491/3a384aa2-51ce-40d7-b02c-a2c986f3aeb4" alt="step_60"/></td> <td><img src="https://github.com/huggingface/setfit/assets/37621491/b5aa9835-40cb-4327-9f31-b3ababeca769" alt="step_80"/></td></tr></tbody>',Mt,X,dt,S,mt;return h=new E({props:{title:"Callbacks",local:"callbacks",headingTag:"h1"}}),g=new E({props:{title:"Callbacks in SetFit",local:"callbacks-in-setfit",headingTag:"h2"}}),J=new E({props:{title:"Default Callbacks",local:"default-callbacks",headingTag:"h2"}}),k=new E({props:{title:"Using Callbacks",local:"using-callbacks",headingTag:"h2"}}),v=new bt({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9ydF90byUzRCUyMndhbmRiJTIyJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTJDJTBBKSUwQSUyMyUyMG9yJTIwJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9ydF90byUzRCU1QiUyMndhbmRiJTIyJTJDJTIwJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAuLi4lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> TrainingArguments

args = TrainingArguments(
    ...,
    report_to=<span class="hljs-string">&quot;wandb&quot;</span>,
    ...,
)
<span class="hljs-comment"># or </span>
args = TrainingArguments(
    ...,
    report_to=[<span class="hljs-string">&quot;wandb&quot;</span>, <span class="hljs-string">&quot;tensorboard&quot;</span>],
    ...,
)`,wrap:!1}}),W=new bt({props:{code:"JTBB",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> Trainer

...

trainer = Trainer(
    model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    callbacks=[EarlyStoppingCallback(early_stopping_patience=<span class="hljs-number">5</span>)],
)
trainer.train()`,wrap:!1}}),G=new E({props:{title:"Custom Callbacks",local:"custom-callbacks",headingTag:"h2"}}),F=new bt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">from</span> sklearn.manifold <span class="hljs-keyword">import</span> TSNE

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmbeddingPlotCallback</span>(<span class="hljs-title class_ inherited__">TrainerCallback</span>):
    <span class="hljs-string">&quot;&quot;&quot;Simple embedding plotting callback that plots the tSNE of the training and evaluation datasets throughout training.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_init_end</span>(<span class="hljs-params">self, args: TrainingArguments, state: TrainerState, control: TrainerControl, **kwargs</span>):
        os.makedirs(<span class="hljs-string">&quot;logs&quot;</span>, exist_ok=<span class="hljs-literal">True</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_evaluate</span>(<span class="hljs-params">self, args: TrainingArguments, state: TrainerState, control: TrainerControl, model: SetFitModel, **kwargs</span>):
        train_embeddings = model.encode(train_dataset[<span class="hljs-string">&quot;text&quot;</span>])
        eval_embeddings = model.encode(eval_dataset[<span class="hljs-string">&quot;text&quot;</span>])

        fig, (train_ax, eval_ax) = plt.subplots(ncols=<span class="hljs-number">2</span>)

        train_X = TSNE(n_components=<span class="hljs-number">2</span>).fit_transform(train_embeddings)
        train_ax.scatter(*train_X.T, c=train_dataset[<span class="hljs-string">&quot;label&quot;</span>], label=train_dataset[<span class="hljs-string">&quot;label&quot;</span>])
        train_ax.set_title(<span class="hljs-string">&quot;Training embeddings&quot;</span>)

        eval_X = TSNE(n_components=<span class="hljs-number">2</span>).fit_transform(eval_embeddings)
        eval_ax.scatter(*eval_X.T, c=eval_dataset[<span class="hljs-string">&quot;label&quot;</span>], label=eval_dataset[<span class="hljs-string">&quot;label&quot;</span>])
        eval_ax.set_title(<span class="hljs-string">&quot;Evaluation embeddings&quot;</span>)

        fig.suptitle(<span class="hljs-string">f&quot;tSNE of training and evaluation embeddings at step <span class="hljs-subst">{state.global_step}</span> of <span class="hljs-subst">{state.max_steps}</span>.&quot;</span>)
        fig.savefig(<span class="hljs-string">f&quot;logs/step_<span class="hljs-subst">{state.global_step}</span>.png&quot;</span>)`,wrap:!1}}),A=new bt({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja3MlM0QlNUJFbWJlZGRpbmdQbG90Q2FsbGJhY2soKSU1RCUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    callbacks=[EmbeddingPlotCallback()]
)
trainer.train()`,wrap:!1}}),X=new Xt({props:{source:"https://github.com/huggingface/setfit/blob/main/docs/source/en/how_to/callbacks.mdx"}}),{c(){f=r("meta"),x=s(),Y=r("p"),Q=s(),c(h.$$.fragment),H=s(),y=r("p"),y.textContent=ht,N=s(),u=r("p"),u.textContent=yt,V=s(),c(g.$$.fragment),q=s(),T=r("p"),T.innerHTML=ut,z=s(),U=r("p"),U.innerHTML=gt,L=s(),j=r("p"),j.innerHTML=Tt,P=s(),c(J.$$.fragment),K=s(),w=r("p"),w.innerHTML=Ut,D=s(),C=r("p"),C.innerHTML=jt,O=s(),c(k.$$.fragment),tt=s(),_=r("p"),_.innerHTML=Jt,et=s(),c(v.$$.fragment),lt=s(),$=r("p"),$.innerHTML=wt,at=s(),c(W.$$.fragment),st=s(),c(G.$$.fragment),nt=s(),R=r("p"),R.innerHTML=Ct,rt=s(),c(F.$$.fragment),it=s(),I=r("p"),I.textContent=kt,ot=s(),c(A.$$.fragment),ct=s(),Z=r("p"),Z.innerHTML=_t,pt=s(),B=r("table"),B.innerHTML=vt,Mt=s(),c(X.$$.fragment),dt=s(),S=r("p"),this.h()},l(t){const e=Zt("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(l),x=n(t),Y=i(t,"P",{}),$t(Y).forEach(l),Q=n(t),p(h.$$.fragment,t),H=n(t),y=i(t,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1qsyej"&&(y.textContent=ht),N=n(t),u=i(t,"P",{"data-svelte-h":!0}),o(u)!=="svelte-1neobwt"&&(u.textContent=yt),V=n(t),p(g.$$.fragment,t),q=n(t),T=i(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1w6bbfy"&&(T.innerHTML=ut),z=n(t),U=i(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1jb1un9"&&(U.innerHTML=gt),L=n(t),j=i(t,"P",{"data-svelte-h":!0}),o(j)!=="svelte-m6jr23"&&(j.innerHTML=Tt),P=n(t),p(J.$$.fragment,t),K=n(t),w=i(t,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1d5its4"&&(w.innerHTML=Ut),D=n(t),C=i(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-195z5eh"&&(C.innerHTML=jt),O=n(t),p(k.$$.fragment,t),tt=n(t),_=i(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-9jofl1"&&(_.innerHTML=Jt),et=n(t),p(v.$$.fragment,t),lt=n(t),$=i(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-1418m9j"&&($.innerHTML=wt),at=n(t),p(W.$$.fragment,t),st=n(t),p(G.$$.fragment,t),nt=n(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1a0isl"&&(R.innerHTML=Ct),rt=n(t),p(F.$$.fragment,t),it=n(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1jtaf10"&&(I.textContent=kt),ot=n(t),p(A.$$.fragment,t),ct=n(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-14nrepa"&&(Z.innerHTML=_t),pt=n(t),B=i(t,"TABLE",{"data-svelte-h":!0}),o(B)!=="svelte-g475cj"&&(B.innerHTML=vt),Mt=n(t),p(X.$$.fragment,t),dt=n(t),S=i(t,"P",{}),$t(S).forEach(l),this.h()},h(){Wt(f,"name","hf:doc:metadata"),Wt(f,"content",St)},m(t,e){Bt(document.head,f),a(t,x,e),a(t,Y,e),a(t,Q,e),M(h,t,e),a(t,H,e),a(t,y,e),a(t,N,e),a(t,u,e),a(t,V,e),M(g,t,e),a(t,q,e),a(t,T,e),a(t,z,e),a(t,U,e),a(t,L,e),a(t,j,e),a(t,P,e),M(J,t,e),a(t,K,e),a(t,w,e),a(t,D,e),a(t,C,e),a(t,O,e),M(k,t,e),a(t,tt,e),a(t,_,e),a(t,et,e),M(v,t,e),a(t,lt,e),a(t,$,e),a(t,at,e),M(W,t,e),a(t,st,e),M(G,t,e),a(t,nt,e),a(t,R,e),a(t,rt,e),M(F,t,e),a(t,it,e),a(t,I,e),a(t,ot,e),M(A,t,e),a(t,ct,e),a(t,Z,e),a(t,pt,e),a(t,B,e),a(t,Mt,e),M(X,t,e),a(t,dt,e),a(t,S,e),mt=!0},p:Rt,i(t){mt||(d(h.$$.fragment,t),d(g.$$.fragment,t),d(J.$$.fragment,t),d(k.$$.fragment,t),d(v.$$.fragment,t),d(W.$$.fragment,t),d(G.$$.fragment,t),d(F.$$.fragment,t),d(A.$$.fragment,t),d(X.$$.fragment,t),mt=!0)},o(t){m(h.$$.fragment,t),m(g.$$.fragment,t),m(J.$$.fragment,t),m(k.$$.fragment,t),m(v.$$.fragment,t),m(W.$$.fragment,t),m(G.$$.fragment,t),m(F.$$.fragment,t),m(A.$$.fragment,t),m(X.$$.fragment,t),mt=!1},d(t){t&&(l(x),l(Y),l(Q),l(H),l(y),l(N),l(u),l(V),l(q),l(T),l(z),l(U),l(L),l(j),l(P),l(K),l(w),l(D),l(C),l(O),l(tt),l(_),l(et),l(lt),l($),l(at),l(st),l(nt),l(R),l(rt),l(it),l(I),l(ot),l(ct),l(Z),l(pt),l(B),l(Mt),l(dt),l(S)),l(f),b(h,t),b(g,t),b(J,t),b(k,t),b(v,t),b(W,t),b(G,t),b(F,t),b(A,t),b(X,t)}}}const St='{"title":"Callbacks","local":"callbacks","sections":[{"title":"Callbacks in SetFit","local":"callbacks-in-setfit","sections":[],"depth":2},{"title":"Default Callbacks","local":"default-callbacks","sections":[],"depth":2},{"title":"Using Callbacks","local":"using-callbacks","sections":[],"depth":2},{"title":"Custom Callbacks","local":"custom-callbacks","sections":[],"depth":2}],"depth":1}';function Et(ft){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends It{constructor(f){super(),At(this,f,Et,Yt,Gt,{})}}export{Vt as component};
