import{s as Ps,n as Vs,o as Ws}from"../chunks/scheduler.6062bdaf.js";import{S as Ys,i as Ls,g as i,s as l,r as u,A as Ss,h as p,f as a,c as n,j as Bs,u as r,x as c,k as Es,y as Qs,a as t,v as o,d as h,t as g,w as f}from"../chunks/index.4bca734e.js";import{C as P}from"../chunks/CodeBlock.fa01571c.js";import{H as Y,E as Fs}from"../chunks/EditOnGithub.74ab2baa.js";function Ks(Us){let d,L,V,S,m,Q,_,ks=`The <code>huggingface_hub</code> library provides a Python interface to interact with Pull Requests and Discussions on the Hub.
Visit <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">the dedicated documentation page</a>
for a deeper view of what Discussions and Pull Requests on the Hub are, and how they work under the hood.`,F,M,K,b,$s="The <code>HfApi</code> class allows you to retrieve Discussions and Pull Requests on a given repo:",O,j,ss,y,vs="<code>HfApi.get_repo_discussions</code> supports filtering by author, type (Pull Request or Discussion) and status (<code>open</code> or <code>closed</code>):",es,T,as,w,qs=`<code>HfApi.get_repo_discussions</code> returns a <a href="https://docs.python.org/3.7/howto/functional.html#generators" rel="nofollow">generator</a> that yields
<a href="/docs/huggingface_hub/pr_2378/en/package_reference/community#huggingface_hub.Discussion">Discussion</a> objects. To get all the Discussions in a single list, run:`,ts,J,ls,U,Hs=`The <a href="/docs/huggingface_hub/pr_2378/en/package_reference/community#huggingface_hub.Discussion">Discussion</a> object returned by <a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.get_repo_discussions">HfApi.get_repo_discussions()</a> contains high-level overview of the
Discussion or Pull Request. You can also get more detailed information using <a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.get_discussion_details">HfApi.get_discussion_details()</a>:`,ns,k,is,$,Zs=`<a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.get_discussion_details">HfApi.get_discussion_details()</a> returns a <a href="/docs/huggingface_hub/pr_2378/en/package_reference/community#huggingface_hub.DiscussionWithDetails">DiscussionWithDetails</a> object, which is a subclass of <a href="/docs/huggingface_hub/pr_2378/en/package_reference/community#huggingface_hub.Discussion">Discussion</a>
with more detailed information about the Discussion or Pull Request. Information includes all the comments, status changes,
and renames of the Discussion via <code>DiscussionWithDetails.events</code>.`,ps,v,Gs=`In case of a Pull Request, you can retrieve the raw git diff with <code>DiscussionWithDetails.diff</code>. All the commits of the
Pull Request are listed in <code>DiscussionWithDetails.events</code>.`,cs,q,us,H,As=`The <a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> class also offers ways to create and edit Discussions and Pull Requests.
You will need an <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">access token</a> to create and edit Discussions
or Pull Requests.`,rs,Z,Rs=`The simplest way to propose changes on a repo on the Hub is via the <a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> API: just
set the <code>create_pr</code> parameter to <code>True</code>. This parameter is also available on other methods that wrap <a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>:`,os,G,Cs='<li><a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a></li> <li><a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a></li> <li><a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.delete_file">delete_file()</a></li> <li><a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.delete_folder">delete_folder()</a></li> <li><a href="/docs/huggingface_hub/pr_2378/en/package_reference/cards#huggingface_hub.metadata_update">metadata_update()</a></li>',hs,A,gs,R,Xs=`You can also use <a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.create_discussion">HfApi.create_discussion()</a> (respectively <a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.create_pull_request">HfApi.create_pull_request()</a>) to create a Discussion (respectively a Pull Request) on a repo.
Opening a Pull Request this way can be useful if you need to work on changes locally. Pull Requests opened this way will be in <code>&quot;draft&quot;</code> mode.`,fs,C,ds,X,Is='Managing Pull Requests and Discussions can be done entirely with the <a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> class. For example:',ms,I,xs='<li><a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.comment_discussion">comment_discussion()</a> to add comments</li> <li><a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.edit_discussion_comment">edit_discussion_comment()</a> to edit comments</li> <li><a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.rename_discussion">rename_discussion()</a> to rename a Discussion or Pull Request</li> <li><a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.change_discussion_status">change_discussion_status()</a> to open or close a Discussion / Pull Request</li> <li><a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi.merge_pull_request">merge_pull_request()</a> to merge a Pull Request</li>',_s,x,Ns='Visit the <a href="/docs/huggingface_hub/pr_2378/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> documentation page for an exhaustive reference of all available methods.',Ms,N,bs,z,zs="<em>Coming soon !</em>",js,D,ys,B,Ds='For a more detailed reference, visit the <a href="../package_reference/community">Discussions and Pull Requests</a> and the <a href="../package_reference/hf_api">hf_api</a> documentation page.',Ts,E,ws,W,Js;return m=new Y({props:{title:"Interact with Discussions and Pull Requests",local:"interact-with-discussions-and-pull-requests",headingTag:"h1"}}),M=new Y({props:{title:"Retrieve Discussions and Pull Requests from the Hub",local:"retrieve-discussions-and-pull-requests-from-the-hub",headingTag:"h2"}}),j=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZm9yJTIwZGlzY3Vzc2lvbiUyMGluJTIwZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJpZ3NjaWVuY2UlMkZibG9vbSUyMiklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCZGlzY3Vzc2lvbi5udW0lN0QlMjAtJTIwJTdCZGlzY3Vzc2lvbi50aXRsZSU3RCUyQyUyMHByJTNBJTIwJTdCZGlzY3Vzc2lvbi5pc19wdWxsX3JlcXVlc3QlN0QlMjIpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> discussion <span class="hljs-keyword">in</span> get_repo_discussions(repo_id=<span class="hljs-string">&quot;bigscience/bloom&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{discussion.num}</span> - <span class="hljs-subst">{discussion.title}</span>, pr: <span class="hljs-subst">{discussion.is_pull_request}</span>&quot;</span>)

<span class="hljs-comment"># 11 - Add Flax weights, pr: True</span>
<span class="hljs-comment"># 10 - Update README.md, pr: True</span>
<span class="hljs-comment"># 9 - Training languages in the model card, pr: True</span>
<span class="hljs-comment"># 8 - Update tokenizer_config.json, pr: True</span>
<span class="hljs-comment"># 7 - Slurm training script, pr: False</span>
[...]`,wrap:!1}}),T=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZm9yJTIwZGlzY3Vzc2lvbiUyMGluJTIwZ2V0X3JlcG9fZGlzY3Vzc2lvbnMoJTBBJTIwJTIwJTIwcmVwb19pZCUzRCUyMmJpZ3NjaWVuY2UlMkZibG9vbSUyMiUyQyUwQSUyMCUyMCUyMGF1dGhvciUzRCUyMkFydGh1clolMjIlMkMlMEElMjAlMjAlMjBkaXNjdXNzaW9uX3R5cGUlM0QlMjJwdWxsX3JlcXVlc3QlMjIlMkMlMEElMjAlMjAlMjBkaXNjdXNzaW9uX3N0YXR1cyUzRCUyMm9wZW4lMjIlMkMlMEEpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU3QmRpc2N1c3Npb24ubnVtJTdEJTIwLSUyMCU3QmRpc2N1c3Npb24udGl0bGUlN0QlMjBieSUyMCU3QmRpc2N1c3Npb24uYXV0aG9yJTdEJTJDJTIwcHIlM0ElMjAlN0JkaXNjdXNzaW9uLmlzX3B1bGxfcmVxdWVzdCU3RCUyMiklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> discussion <span class="hljs-keyword">in</span> get_repo_discussions(
<span class="hljs-meta">... </span>   repo_id=<span class="hljs-string">&quot;bigscience/bloom&quot;</span>,
<span class="hljs-meta">... </span>   author=<span class="hljs-string">&quot;ArthurZ&quot;</span>,
<span class="hljs-meta">... </span>   discussion_type=<span class="hljs-string">&quot;pull_request&quot;</span>,
<span class="hljs-meta">... </span>   discussion_status=<span class="hljs-string">&quot;open&quot;</span>,
<span class="hljs-meta">... </span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{discussion.num}</span> - <span class="hljs-subst">{discussion.title}</span> by <span class="hljs-subst">{discussion.author}</span>, pr: <span class="hljs-subst">{discussion.is_pull_request}</span>&quot;</span>)

<span class="hljs-comment"># 19 - Add Flax weights by ArthurZ, pr: True</span>`,wrap:!1}}),J=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9yZXBvX2Rpc2N1c3Npb25zJTBBZGlzY3Vzc2lvbnNfbGlzdCUyMCUzRCUyMGxpc3QoZ2V0X3JlcG9fZGlzY3Vzc2lvbnMocmVwb19pZCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_repo_discussions
<span class="hljs-meta">&gt;&gt;&gt; </span>discussions_list = <span class="hljs-built_in">list</span>(get_repo_discussions(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>))`,wrap:!1}}),k=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9kaXNjdXNzaW9uX2RldGFpbHMlMEElMEFnZXRfZGlzY3Vzc2lvbl9kZXRhaWxzKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJiaWdzY2llbmNlJTJGYmxvb20tMWIzJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lM0QyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_discussion_details

<span class="hljs-meta">&gt;&gt;&gt; </span>get_discussion_details(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;bigscience/bloom-1b3&quot;</span>,
<span class="hljs-meta">... </span>    discussion_num=<span class="hljs-number">2</span>
<span class="hljs-meta">... </span>)
DiscussionWithDetails(
    num=<span class="hljs-number">2</span>,
    author=<span class="hljs-string">&#x27;cakiki&#x27;</span>,
    title=<span class="hljs-string">&#x27;Update VRAM memory for the V100s&#x27;</span>,
    status=<span class="hljs-string">&#x27;open&#x27;</span>,
    is_pull_request=<span class="hljs-literal">True</span>,
    events=[
        DiscussionComment(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;comment&#x27;</span>, author=<span class="hljs-string">&#x27;cakiki&#x27;</span>, ...),
        DiscussionCommit(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;commit&#x27;</span>, author=<span class="hljs-string">&#x27;cakiki&#x27;</span>, summary=<span class="hljs-string">&#x27;Update VRAM memory for the V100s&#x27;</span>, oid=<span class="hljs-string">&#x27;1256f9d9a33fa8887e1c1bf0e09b4713da96773a&#x27;</span>, ...),
    ],
    conflicting_files=[],
    target_branch=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>,
    merge_commit_oid=<span class="hljs-literal">None</span>,
    diff=<span class="hljs-string">&#x27;diff --git a/README.md b/README.md\\nindex a6ae3b9294edf8d0eda0d67c7780a10241242a7e..3a1814f212bc3f0d3cc8f74bdbd316de4ae7b9e3 100644\\n--- a/README.md\\n+++ b/README.md\\n@@ -132,7 +132,7 [...]&#x27;</span>,
)`,wrap:!1}}),q=new Y({props:{title:"Create and edit a Discussion or Pull Request programmatically",local:"create-and-edit-a-discussion-or-pull-request-programmatically",headingTag:"h2"}}),A=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQSUwQW1ldGFkYXRhX3VwZGF0ZSglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZyZXBvX25hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnRhZ3MlMjIlM0ElMjAlNUIlMjJjb21wdXRlci12aXNpb24lMjIlMkMlMjAlMjJhd2Vzb21lLW1vZGVsJTIyJTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwY3JlYXRlX3ByJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update

<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo_name&quot;</span>,
<span class="hljs-meta">... </span>    metadata={<span class="hljs-string">&quot;tags&quot;</span>: [<span class="hljs-string">&quot;computer-vision&quot;</span>, <span class="hljs-string">&quot;awesome-model&quot;</span>]},
<span class="hljs-meta">... </span>    create_pr=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),C=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9kaXNjdXNzaW9uJTJDJTIwY3JlYXRlX3B1bGxfcmVxdWVzdCUwQSUwQWNyZWF0ZV9kaXNjdXNzaW9uKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRnJlcG8tbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIySGklMjBmcm9tJTIwdGhlJTIwaHVnZ2luZ2ZhY2VfaHViJTIwbGlicmFyeSElMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRCUyMiUzQ2luc2VydCUyMHlvdXIlMjBhY2Nlc3MlMjB0b2tlbiUyMGhlcmUlM0UlMjIlMkMlMEEpJTBBJTBBY3JlYXRlX3B1bGxfcmVxdWVzdCglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZyZXBvLW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjB0aXRsZSUzRCUyMkhpJTIwZnJvbSUyMHRoZSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxpYnJhcnkhJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0QlMjIlM0NpbnNlcnQlMjB5b3VyJTIwYWNjZXNzJTIwdG9rZW4lMjBoZXJlJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_discussion, create_pull_request

<span class="hljs-meta">&gt;&gt;&gt; </span>create_discussion(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo-name&quot;</span>,
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;Hi from the huggingface_hub library!&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;&lt;insert your access token here&gt;&quot;</span>,
<span class="hljs-meta">... </span>)
DiscussionWithDetails(...)

<span class="hljs-meta">&gt;&gt;&gt; </span>create_pull_request(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/repo-name&quot;</span>,
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;Hi from the huggingface_hub library!&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-string">&quot;&lt;insert your access token here&gt;&quot;</span>,
<span class="hljs-meta">... </span>)
DiscussionWithDetails(..., is_pull_request=<span class="hljs-literal">True</span>)`,wrap:!1}}),N=new Y({props:{title:"Push changes to a Pull Request",local:"push-changes-to-a-pull-request",headingTag:"h2"}}),D=new Y({props:{title:"See also",local:"see-also",headingTag:"h2"}}),E=new Fs({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/community.md"}}),{c(){d=i("meta"),L=l(),V=i("p"),S=l(),u(m.$$.fragment),Q=l(),_=i("p"),_.innerHTML=ks,F=l(),u(M.$$.fragment),K=l(),b=i("p"),b.innerHTML=$s,O=l(),u(j.$$.fragment),ss=l(),y=i("p"),y.innerHTML=vs,es=l(),u(T.$$.fragment),as=l(),w=i("p"),w.innerHTML=qs,ts=l(),u(J.$$.fragment),ls=l(),U=i("p"),U.innerHTML=Hs,ns=l(),u(k.$$.fragment),is=l(),$=i("p"),$.innerHTML=Zs,ps=l(),v=i("p"),v.innerHTML=Gs,cs=l(),u(q.$$.fragment),us=l(),H=i("p"),H.innerHTML=As,rs=l(),Z=i("p"),Z.innerHTML=Rs,os=l(),G=i("ul"),G.innerHTML=Cs,hs=l(),u(A.$$.fragment),gs=l(),R=i("p"),R.innerHTML=Xs,fs=l(),u(C.$$.fragment),ds=l(),X=i("p"),X.innerHTML=Is,ms=l(),I=i("ul"),I.innerHTML=xs,_s=l(),x=i("p"),x.innerHTML=Ns,Ms=l(),u(N.$$.fragment),bs=l(),z=i("p"),z.innerHTML=zs,js=l(),u(D.$$.fragment),ys=l(),B=i("p"),B.innerHTML=Ds,Ts=l(),u(E.$$.fragment),ws=l(),W=i("p"),this.h()},l(s){const e=Ss("svelte-u9bgzb",document.head);d=p(e,"META",{name:!0,content:!0}),e.forEach(a),L=n(s),V=p(s,"P",{}),Bs(V).forEach(a),S=n(s),r(m.$$.fragment,s),Q=n(s),_=p(s,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1wn47li"&&(_.innerHTML=ks),F=n(s),r(M.$$.fragment,s),K=n(s),b=p(s,"P",{"data-svelte-h":!0}),c(b)!=="svelte-6bkla6"&&(b.innerHTML=$s),O=n(s),r(j.$$.fragment,s),ss=n(s),y=p(s,"P",{"data-svelte-h":!0}),c(y)!=="svelte-1ehry1x"&&(y.innerHTML=vs),es=n(s),r(T.$$.fragment,s),as=n(s),w=p(s,"P",{"data-svelte-h":!0}),c(w)!=="svelte-aeli49"&&(w.innerHTML=qs),ts=n(s),r(J.$$.fragment,s),ls=n(s),U=p(s,"P",{"data-svelte-h":!0}),c(U)!=="svelte-u8fzy7"&&(U.innerHTML=Hs),ns=n(s),r(k.$$.fragment,s),is=n(s),$=p(s,"P",{"data-svelte-h":!0}),c($)!=="svelte-fsfydp"&&($.innerHTML=Zs),ps=n(s),v=p(s,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1pbvmum"&&(v.innerHTML=Gs),cs=n(s),r(q.$$.fragment,s),us=n(s),H=p(s,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1bmr7i"&&(H.innerHTML=As),rs=n(s),Z=p(s,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1aagvi8"&&(Z.innerHTML=Rs),os=n(s),G=p(s,"UL",{"data-svelte-h":!0}),c(G)!=="svelte-vogyqa"&&(G.innerHTML=Cs),hs=n(s),r(A.$$.fragment,s),gs=n(s),R=p(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-46j94v"&&(R.innerHTML=Xs),fs=n(s),r(C.$$.fragment,s),ds=n(s),X=p(s,"P",{"data-svelte-h":!0}),c(X)!=="svelte-n7dhho"&&(X.innerHTML=Is),ms=n(s),I=p(s,"UL",{"data-svelte-h":!0}),c(I)!=="svelte-nhedjq"&&(I.innerHTML=xs),_s=n(s),x=p(s,"P",{"data-svelte-h":!0}),c(x)!=="svelte-5e6muz"&&(x.innerHTML=Ns),Ms=n(s),r(N.$$.fragment,s),bs=n(s),z=p(s,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1j277qo"&&(z.innerHTML=zs),js=n(s),r(D.$$.fragment,s),ys=n(s),B=p(s,"P",{"data-svelte-h":!0}),c(B)!=="svelte-19t3fo7"&&(B.innerHTML=Ds),Ts=n(s),r(E.$$.fragment,s),ws=n(s),W=p(s,"P",{}),Bs(W).forEach(a),this.h()},h(){Es(d,"name","hf:doc:metadata"),Es(d,"content",Os)},m(s,e){Qs(document.head,d),t(s,L,e),t(s,V,e),t(s,S,e),o(m,s,e),t(s,Q,e),t(s,_,e),t(s,F,e),o(M,s,e),t(s,K,e),t(s,b,e),t(s,O,e),o(j,s,e),t(s,ss,e),t(s,y,e),t(s,es,e),o(T,s,e),t(s,as,e),t(s,w,e),t(s,ts,e),o(J,s,e),t(s,ls,e),t(s,U,e),t(s,ns,e),o(k,s,e),t(s,is,e),t(s,$,e),t(s,ps,e),t(s,v,e),t(s,cs,e),o(q,s,e),t(s,us,e),t(s,H,e),t(s,rs,e),t(s,Z,e),t(s,os,e),t(s,G,e),t(s,hs,e),o(A,s,e),t(s,gs,e),t(s,R,e),t(s,fs,e),o(C,s,e),t(s,ds,e),t(s,X,e),t(s,ms,e),t(s,I,e),t(s,_s,e),t(s,x,e),t(s,Ms,e),o(N,s,e),t(s,bs,e),t(s,z,e),t(s,js,e),o(D,s,e),t(s,ys,e),t(s,B,e),t(s,Ts,e),o(E,s,e),t(s,ws,e),t(s,W,e),Js=!0},p:Vs,i(s){Js||(h(m.$$.fragment,s),h(M.$$.fragment,s),h(j.$$.fragment,s),h(T.$$.fragment,s),h(J.$$.fragment,s),h(k.$$.fragment,s),h(q.$$.fragment,s),h(A.$$.fragment,s),h(C.$$.fragment,s),h(N.$$.fragment,s),h(D.$$.fragment,s),h(E.$$.fragment,s),Js=!0)},o(s){g(m.$$.fragment,s),g(M.$$.fragment,s),g(j.$$.fragment,s),g(T.$$.fragment,s),g(J.$$.fragment,s),g(k.$$.fragment,s),g(q.$$.fragment,s),g(A.$$.fragment,s),g(C.$$.fragment,s),g(N.$$.fragment,s),g(D.$$.fragment,s),g(E.$$.fragment,s),Js=!1},d(s){s&&(a(L),a(V),a(S),a(Q),a(_),a(F),a(K),a(b),a(O),a(ss),a(y),a(es),a(as),a(w),a(ts),a(ls),a(U),a(ns),a(is),a($),a(ps),a(v),a(cs),a(us),a(H),a(rs),a(Z),a(os),a(G),a(hs),a(gs),a(R),a(fs),a(ds),a(X),a(ms),a(I),a(_s),a(x),a(Ms),a(bs),a(z),a(js),a(ys),a(B),a(Ts),a(ws),a(W)),a(d),f(m,s),f(M,s),f(j,s),f(T,s),f(J,s),f(k,s),f(q,s),f(A,s),f(C,s),f(N,s),f(D,s),f(E,s)}}}const Os='{"title":"Interact with Discussions and Pull Requests","local":"interact-with-discussions-and-pull-requests","sections":[{"title":"Retrieve Discussions and Pull Requests from the Hub","local":"retrieve-discussions-and-pull-requests-from-the-hub","sections":[],"depth":2},{"title":"Create and edit a Discussion or Pull Request programmatically","local":"create-and-edit-a-discussion-or-pull-request-programmatically","sections":[],"depth":2},{"title":"Push changes to a Pull Request","local":"push-changes-to-a-pull-request","sections":[],"depth":2},{"title":"See also","local":"see-also","sections":[],"depth":2}],"depth":1}';function se(Us){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ne extends Ys{constructor(d){super(),Ls(this,d,se,Ks,Ps,{})}}export{ne as component};
