import{s as At,f as at,o as kt,n as vt}from"../chunks/scheduler.37c15a92.js";import{S as xt,i as _t,g as i,s as a,r as o,A as Xt,h as r,f as l,c as n,j as we,u as m,x as p,k as M,y as Et,a as s,v as y,d as w,t as c,w as d,m as $t,n as Rt}from"../chunks/index.2bf4358c.js";import{T as Wt}from"../chunks/Tip.363c041f.js";import{C as me}from"../chunks/CodeBlock.4f5fc1ad.js";import{H as f,E as Ft}from"../chunks/EditOnGithub.8916dc7c.js";function Yt(ce){let J,T,I="Open R1 implementation",C;return{c(){J=$t("This chapter is aimed at TRL beginners. If you are already familiar with TRL, you might want to also check out the "),T=i("a"),T.textContent=I,C=$t(" of GRPO."),this.h()},l(U){J=Rt(U,"This chapter is aimed at TRL beginners. If you are already familiar with TRL, you might want to also check out the "),T=r(U,"A",{href:!0,"data-svelte-h":!0}),p(T)!=="svelte-14o79x4"&&(T.textContent=I),C=Rt(U," of GRPO."),this.h()},h(){M(T,"href","https://github.com/huggingface/open-r1/blob/main/src/open_r1/grpo.py")},m(U,b){s(U,J,b),s(U,T,b),s(U,C,b)},p:vt,d(U){U&&(l(J),l(T),l(C))}}}function St(ce){let J,T,I,C,U,b,G,nt="In this page, we’ll learn how to implement Group Relative Policy Optimization (GRPO) using the Transformer Reinforcement Learning (TRL) library. We’ll focus on practical implementation with minimal code.",de,B,it="We’ll explore the core concepts of GRPO as they are embodied in TRL’s GRPOTrainer, using snippets from the official TRL documentation to guide us.",Ue,g,Je,Z,rt="First, let’s remind ourselves of some of the important concepts of GRPO algorithm:",Te,$,pt="<li>Group Formation: The model generates multiple completions for each prompt.</li> <li>Preference Learning: The model learns from a reward function that compares groups of completions.</li> <li>Training Configuration: The model uses a configuration to control the training process.</li>",ue,R,Mt="What do we need to do to implement GRPO?",je,A,ot="<li>Define a dataset of prompts.</li> <li>Define a reward function that takes a list of completions and returns a list of rewards.</li> <li>Configure the training process with a GRPOConfig.</li> <li>Train the model using the GRPOTrainer.</li>",he,k,mt="Here’s a minimal example to get started with GRPO training:",fe,v,Ce,x,Ie,_,be,X,yt="Your dataset should contain prompts that the model will respond to. The GRPO trainer will generate multiple completions for each prompt and use the reward function to compare them.",ge,E,Ge,W,wt="The reward function is crucial - it determines how the model learns. Here are two practical examples:",Be,F,Ze,Y,$e,S,ct="Key parameters to consider in <code>GRPOConfig</code>:",Re,V,Ae,Q,dt="The <code>num_generation</code> parameter is particularly important for GRPO as it defines the group size - how many different completions the model will generate for each prompt. This is a key differentiator from other RL methods:",ke,z,Ut="<li>Too small (e.g., 2-3): May not provide enough diversity for meaningful comparisons</li> <li>Recommended (4-16): Provides good balance between diversity and computational efficiency</li> <li>Larger values: May improve learning but significantly increases computational cost</li>",ve,N,Jt="The group size should be chosen based on your computational resources and the complexity of your task. For simple tasks, smaller groups (4-8) may be sufficient, while more complex reasoning tasks might benefit from larger groups (8-16).",xe,H,_e,L,Tt="<li><strong>Memory Management</strong>: Adjust <code>per_device_train_batch_size</code> and <code>gradient_accumulation_steps</code> based on your GPU memory.</li> <li><strong>Speed</strong>: Enable <code>use_vllm=True</code> for faster generation if your model is supported.</li> <li><strong>Monitoring</strong>: Watch the logged metrics during training:<ul><li><code>reward</code>: Average reward across completions</li> <li><code>reward_std</code>: Standard deviation within reward groups</li> <li><code>kl</code>: KL divergence from reference model</li></ul></li>",Xe,P,Ee,q,ut="The DeepSeek R1 paper demonstrates several effective approaches to reward function design that you can adapt for your own GRPO implementation:",We,D,Fe,K,jt="One of the easiest rewards to implement is a length-based reward. You can reward longer completions:",Ye,O,Se,ee,ht="This reward function penalizes completions that are too short or too long, encouraging the model to generate completions that are close to the ideal length of 20 tokens.",Ve,u,ft,Qe,te,ze,le,Ct="For tasks with objectively correct answers (like mathematics or coding), you can implement rule-based reward functions:",Ne,se,He,j,It,Le,ae,Pe,ne,bt="You can also reward proper formatting, which was important in the DeepSeek R1 training:",qe,ie,De,h,gt,Ke,re,Gt="These examples demonstrate how you can implement reward functions inspired by the DeepSeek R1 training process, focusing on correctness, formatting, and combined signals.",Oe,pe,et,Me,Bt="In the next section, you will follow an exercise to implement GRPO in TRL.",tt,oe,lt,ye,st;return U=new f({props:{title:"Implementing GRPO in TRL",local:"implementing-grpo-in-trl",headingTag:"h1"}}),g=new Wt({props:{$$slots:{default:[Yt]},$$scope:{ctx:ce}}}),v=new me({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMEdSUE9UcmFpbmVyJTJDJTIwR1JQT0NvbmZpZyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMDEuJTIwTG9hZCUyMHlvdXIlMjBkYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ5b3VyX2RhdGFzZXQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQSUwQSUyMyUyMDIuJTIwRGVmaW5lJTIwYSUyMHNpbXBsZSUyMHJld2FyZCUyMGZ1bmN0aW9uJTBBZGVmJTIwcmV3YXJkX2Z1bmMoY29tcGxldGlvbnMlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJFeGFtcGxlJTNBJTIwUmV3YXJkJTIwbG9uZ2VyJTIwY29tcGxldGlvbnMlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJmbG9hdChsZW4oY29tcGxldGlvbikpJTIwZm9yJTIwY29tcGxldGlvbiUyMGluJTIwY29tcGxldGlvbnMlNUQlMEElMEElMEElMjMlMjAzLiUyMENvbmZpZ3VyZSUyMHRyYWluaW5nJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMEdSUE9Db25maWcoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMm91dHB1dCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMTAlMkMlMEEpJTBBJTBBJTIzJTIwNC4lMjBJbml0aWFsaXplJTIwYW5kJTIwdHJhaW4lMEF0cmFpbmVyJTIwJTNEJTIwR1JQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJ5b3VyX21vZGVsJTIyJTJDJTIwJTIwJTIzJTIwZS5nLiUyMCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHJld2FyZF9mdW5jcyUzRHJld2FyZF9mdW5jJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> GRPOTrainer, GRPOConfig
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># 1. Load your dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;your_dataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-comment"># 2. Define a simple reward function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_func</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;Example: Reward longer completions&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-built_in">float</span>(<span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]


<span class="hljs-comment"># 3. Configure training</span>
training_args = GRPOConfig(
    output_dir=<span class="hljs-string">&quot;output&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    logging_steps=<span class="hljs-number">10</span>,
)

<span class="hljs-comment"># 4. Initialize and train</span>
trainer = GRPOTrainer(
    model=<span class="hljs-string">&quot;your_model&quot;</span>,  <span class="hljs-comment"># e.g. &quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>
    args=training_args,
    train_dataset=dataset,
    reward_funcs=reward_func,
)
trainer.train()`,wrap:!1}}),x=new f({props:{title:"Key Components",local:"key-components",headingTag:"h2"}}),_=new f({props:{title:"1. Dataset Format",local:"1-dataset-format",headingTag:"h3"}}),E=new f({props:{title:"2. Reward Function",local:"2-reward-function",headingTag:"h3"}}),F=new me({props:{code:"JTIzJTIwRXhhbXBsZSUyMDElM0ElMjBSZXdhcmQlMjBiYXNlZCUyMG9uJTIwY29tcGxldGlvbiUyMGxlbmd0aCUwQWRlZiUyMHJld2FyZF9sZW5ndGgoY29tcGxldGlvbnMlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJmbG9hdChsZW4oY29tcGxldGlvbikpJTIwZm9yJTIwY29tcGxldGlvbiUyMGluJTIwY29tcGxldGlvbnMlNUQlMEElMEElMEElMjMlMjBFeGFtcGxlJTIwMiUzQSUyMFJld2FyZCUyMGJhc2VkJTIwb24lMjBtYXRjaGluZyUyMGElMjBwYXR0ZXJuJTBBaW1wb3J0JTIwcmUlMEElMEElMEFkZWYlMjByZXdhcmRfZm9ybWF0KGNvbXBsZXRpb25zJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwcGF0dGVybiUyMCUzRCUyMHIlMjIlNUUlM0N0aGluayUzRS4qJTNGJTNDJTJGdGhpbmslM0UlM0NhbnN3ZXIlM0UuKiUzRiUzQyUyRmFuc3dlciUzRSUyNCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QjEuMCUyMGlmJTIwcmUubWF0Y2gocGF0dGVybiUyQyUyMGMpJTIwZWxzZSUyMDAuMCUyMGZvciUyMGMlMjBpbiUyMGNvbXBsZXRpb25zJTVE",highlighted:`<span class="hljs-comment"># Example 1: Reward based on completion length</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_length</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-keyword">return</span> [<span class="hljs-built_in">float</span>(<span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]


<span class="hljs-comment"># Example 2: Reward based on matching a pattern</span>
<span class="hljs-keyword">import</span> re


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_format</span>(<span class="hljs-params">completions, **kwargs</span>):
    pattern = <span class="hljs-string">r&quot;^&lt;think&gt;.*?&lt;/think&gt;&lt;answer&gt;.*?&lt;/answer&gt;$&quot;</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">1.0</span> <span class="hljs-keyword">if</span> re.<span class="hljs-keyword">match</span>(pattern, c) <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> completions]`,wrap:!1}}),Y=new f({props:{title:"3. Training Configuration",local:"3-training-configuration",headingTag:"h3"}}),V=new me({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEdSUE9Db25maWcoJTBBJTIwJTIwJTIwJTIwJTIzJTIwRXNzZW50aWFsJTIwcGFyYW1ldGVycyUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJvdXRwdXQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMyUyQyUwQSUyMCUyMCUyMCUyMG51bV9nZW5lcmF0aW9uJTNENCUyQyUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwY29tcGxldGlvbnMlMjB0byUyMGdlbmVyYXRlJTIwZm9yJTIwZWFjaCUyMHByb21wdCUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMjAlMjAlMjMlMjBXZSUyMHdhbnQlMjB0byUyMGdldCUyMGFsbCUyMGdlbmVyYXRpb25zJTIwaW4lMjBvbmUlMjBkZXZpY2UlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMyUyME9wdGlvbmFsJTIwYnV0JTIwdXNlZnVsJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwR1JQTyUyMHNwZWNpZmljJTIwKG9wdGlvbmFsKSUwQSUyMCUyMCUyMCUyMHVzZV92bGxtJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMFNwZWVkJTIwdXAlMjBnZW5lcmF0aW9uJTBBKQ==",highlighted:`training_args = GRPOConfig(
    <span class="hljs-comment"># Essential parameters</span>
    output_dir=<span class="hljs-string">&quot;output&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    num_generation=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Number of completions to generate for each prompt</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,  <span class="hljs-comment"># We want to get all generations in one device batch</span>
    <span class="hljs-comment"># Optional but useful</span>
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    <span class="hljs-comment"># GRPO specific (optional)</span>
    use_vllm=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Speed up generation</span>
)`,wrap:!1}}),H=new f({props:{title:"Tips for Success",local:"tips-for-success",headingTag:"h2"}}),P=new f({props:{title:"Reward Function Design",local:"reward-function-design",headingTag:"h2"}}),D=new f({props:{title:"1. Length-Based Rewards",local:"1-length-based-rewards",headingTag:"h3"}}),O=new me({props:{code:"ZGVmJTIwcmV3YXJkX2xlbihjb21wbGV0aW9ucyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMGlkZWFsX2xlbmd0aCUyMCUzRCUyMDIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCLWFicyhpZGVhbF9sZW5ndGglMjAtJTIwbGVuKGNvbXBsZXRpb24pKSUyMGZvciUyMGNvbXBsZXRpb24lMjBpbiUyMGNvbXBsZXRpb25zJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_len</span>(<span class="hljs-params">completions, **kwargs</span>):
    ideal_length = <span class="hljs-number">20</span>
    <span class="hljs-keyword">return</span> [-<span class="hljs-built_in">abs</span>(ideal_length - <span class="hljs-built_in">len</span>(completion)) <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]`,wrap:!1}}),te=new f({props:{title:"2. Rule-Based Rewards for Verifiable Tasks",local:"2-rule-based-rewards-for-verifiable-tasks",headingTag:"h2"}}),se=new me({props:{code:"ZGVmJTIwcHJvYmxlbV9yZXdhcmQoY29tcGxldGlvbnMlMkMlMjBhbnN3ZXJzJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyUmV3YXJkJTIwZnVuY3Rpb24lMjBmb3IlMjBtYXRoJTIwcHJvYmxlbXMlMjB3aXRoJTIwdmVyaWZpYWJsZSUyMGFuc3dlcnMlMEElMjAlMjAlMjAlMjBjb21wbGV0aW9ucyUzQSUyMGxpc3QlMjBvZiUyMGNvbXBsZXRpb25zJTIwdG8lMjBldmFsdWF0ZSUwQSUyMCUyMCUyMCUyMGFuc3dlcnMlM0ElMjBsaXN0JTIwb2YlMjBhbnN3ZXJzJTIwdG8lMjB0aGUlMjBwcm9ibGVtcyUyMGZyb20lMjB0aGUlMjBkYXRhc2V0JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwcmV3YXJkcyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGNvbXBsZXRpb24lMkMlMjBjb3JyZWN0X2Fuc3dlciUyMGluJTIwemlwKGNvbXBsZXRpb25zJTJDJTIwYW5zd2VycyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBFeHRyYWN0JTIwdGhlJTIwYW5zd2VyJTIwZnJvbSUyMHRoZSUyMGNvbXBsZXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUaGlzJTIwaXMlMjBhJTIwc2ltcGxpZmllZCUyMGV4YW1wbGUlMjAtJTIweW91J2QlMjBuZWVkJTIwcHJvcGVyJTIwcGFyc2luZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFuc3dlciUyMCUzRCUyMGV4dHJhY3RfZmluYWxfYW5zd2VyKGNvbXBsZXRpb24pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQmluYXJ5JTIwcmV3YXJkJTNBJTIwMSUyMGZvciUyMGNvcnJlY3QlMkMlMjAwJTIwZm9yJTIwaW5jb3JyZWN0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkJTIwJTNEJTIwMS4wJTIwaWYlMjBhbnN3ZXIlMjAlM0QlM0QlMjBjb3JyZWN0X2Fuc3dlciUyMGVsc2UlMjAwLjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXdhcmRzLmFwcGVuZChyZXdhcmQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhjZXB0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwSWYlMjB3ZSUyMGNhbid0JTIwcGFyc2UlMjBhbiUyMGFuc3dlciUyQyUyMGdpdmUlMjBhJTIwbG93JTIwcmV3YXJkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkcy5hcHBlbmQoMC4wKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJld2FyZHM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">problem_reward</span>(<span class="hljs-params">completions, answers, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;Reward function for math problems with verifiable answers
    completions: list of completions to evaluate
    answers: list of answers to the problems from the dataset
    &quot;&quot;&quot;</span>

    rewards = []
    <span class="hljs-keyword">for</span> completion, correct_answer <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(completions, answers):
        <span class="hljs-comment"># Extract the answer from the completion</span>
        <span class="hljs-keyword">try</span>:
            <span class="hljs-comment"># This is a simplified example - you&#x27;d need proper parsing</span>
            answer = extract_final_answer(completion)
            <span class="hljs-comment"># Binary reward: 1 for correct, 0 for incorrect</span>
            reward = <span class="hljs-number">1.0</span> <span class="hljs-keyword">if</span> answer == correct_answer <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span>
            rewards.append(reward)
        <span class="hljs-keyword">except</span>:
            <span class="hljs-comment"># If we can&#x27;t parse an answer, give a low reward</span>
            rewards.append(<span class="hljs-number">0.0</span>)

    <span class="hljs-keyword">return</span> rewards`,wrap:!1}}),ae=new f({props:{title:"3. Format-Based Rewards",local:"3-format-based-rewards",headingTag:"h2"}}),ie=new me({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_reward</span>(<span class="hljs-params">completions, **kwargs</span>):
    <span class="hljs-string">&quot;&quot;&quot;Reward completions that follow the desired format&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Example: Check if the completion follows a think-then-answer format</span>
    pattern = <span class="hljs-string">r&quot;&lt;think&gt;(.*?)&lt;/think&gt;\\s*&lt;answer&gt;(.*?)&lt;/answer&gt;&quot;</span>

    rewards = []
    <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions:
        <span class="hljs-keyword">match</span> = re.search(pattern, completion, re.DOTALL)
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">match</span>:
            <span class="hljs-comment"># Check if there&#x27;s substantial content in both sections</span>
            think_content = <span class="hljs-keyword">match</span>.group(<span class="hljs-number">1</span>).strip()
            answer_content = <span class="hljs-keyword">match</span>.group(<span class="hljs-number">2</span>).strip()

            <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(think_content) &gt; <span class="hljs-number">20</span> <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(answer_content) &gt; <span class="hljs-number">0</span>:
                rewards.append(<span class="hljs-number">1.0</span>)
            <span class="hljs-keyword">else</span>:
                rewards.append(
                    <span class="hljs-number">0.5</span>
                )  <span class="hljs-comment"># Partial reward for correct format but limited content</span>
        <span class="hljs-keyword">else</span>:
            rewards.append(<span class="hljs-number">0.0</span>)  <span class="hljs-comment"># No reward for incorrect format</span>

    <span class="hljs-keyword">return</span> rewards`,wrap:!1}}),pe=new f({props:{title:"That’s it!",local:"thats-it",headingTag:"h2"}}),oe=new Ft({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter12/4.mdx"}}),{c(){J=i("meta"),T=a(),I=i("p"),C=a(),o(U.$$.fragment),b=a(),G=i("p"),G.textContent=nt,de=a(),B=i("p"),B.textContent=it,Ue=a(),o(g.$$.fragment),Je=a(),Z=i("p"),Z.textContent=rt,Te=a(),$=i("ul"),$.innerHTML=pt,ue=a(),R=i("p"),R.textContent=Mt,je=a(),A=i("ul"),A.innerHTML=ot,he=a(),k=i("p"),k.textContent=mt,fe=a(),o(v.$$.fragment),Ce=a(),o(x.$$.fragment),Ie=a(),o(_.$$.fragment),be=a(),X=i("p"),X.textContent=yt,ge=a(),o(E.$$.fragment),Ge=a(),W=i("p"),W.textContent=wt,Be=a(),o(F.$$.fragment),Ze=a(),o(Y.$$.fragment),$e=a(),S=i("p"),S.innerHTML=ct,Re=a(),o(V.$$.fragment),Ae=a(),Q=i("p"),Q.innerHTML=dt,ke=a(),z=i("ul"),z.innerHTML=Ut,ve=a(),N=i("p"),N.textContent=Jt,xe=a(),o(H.$$.fragment),_e=a(),L=i("ol"),L.innerHTML=Tt,Xe=a(),o(P.$$.fragment),Ee=a(),q=i("p"),q.textContent=ut,We=a(),o(D.$$.fragment),Fe=a(),K=i("p"),K.textContent=jt,Ye=a(),o(O.$$.fragment),Se=a(),ee=i("p"),ee.textContent=ht,Ve=a(),u=i("iframe"),Qe=a(),o(te.$$.fragment),ze=a(),le=i("p"),le.textContent=Ct,Ne=a(),o(se.$$.fragment),He=a(),j=i("iframe"),Le=a(),o(ae.$$.fragment),Pe=a(),ne=i("p"),ne.textContent=bt,qe=a(),o(ie.$$.fragment),De=a(),h=i("iframe"),Ke=a(),re=i("p"),re.textContent=Gt,Oe=a(),o(pe.$$.fragment),et=a(),Me=i("p"),Me.textContent=Bt,tt=a(),o(oe.$$.fragment),lt=a(),ye=i("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);J=r(t,"META",{name:!0,content:!0}),t.forEach(l),T=n(e),I=r(e,"P",{}),we(I).forEach(l),C=n(e),m(U.$$.fragment,e),b=n(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-v9iq5e"&&(G.textContent=nt),de=n(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-iqdzey"&&(B.textContent=it),Ue=n(e),m(g.$$.fragment,e),Je=n(e),Z=r(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-14hk95q"&&(Z.textContent=rt),Te=n(e),$=r(e,"UL",{"data-svelte-h":!0}),p($)!=="svelte-1vd6wz6"&&($.innerHTML=pt),ue=n(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-pzoe2y"&&(R.textContent=Mt),je=n(e),A=r(e,"UL",{"data-svelte-h":!0}),p(A)!=="svelte-1hif2as"&&(A.innerHTML=ot),he=n(e),k=r(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-ac9u4w"&&(k.textContent=mt),fe=n(e),m(v.$$.fragment,e),Ce=n(e),m(x.$$.fragment,e),Ie=n(e),m(_.$$.fragment,e),be=n(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1pnmwnq"&&(X.textContent=yt),ge=n(e),m(E.$$.fragment,e),Ge=n(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-ths948"&&(W.textContent=wt),Be=n(e),m(F.$$.fragment,e),Ze=n(e),m(Y.$$.fragment,e),$e=n(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1uukcnx"&&(S.innerHTML=ct),Re=n(e),m(V.$$.fragment,e),Ae=n(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1tdjaxe"&&(Q.innerHTML=dt),ke=n(e),z=r(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1b1t69f"&&(z.innerHTML=Ut),ve=n(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-7howml"&&(N.textContent=Jt),xe=n(e),m(H.$$.fragment,e),_e=n(e),L=r(e,"OL",{"data-svelte-h":!0}),p(L)!=="svelte-4ukx5l"&&(L.innerHTML=Tt),Xe=n(e),m(P.$$.fragment,e),Ee=n(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-5lvuy8"&&(q.textContent=ut),We=n(e),m(D.$$.fragment,e),Fe=n(e),K=r(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-jhf03w"&&(K.textContent=jt),Ye=n(e),m(O.$$.fragment,e),Se=n(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-jlmna3"&&(ee.textContent=ht),Ve=n(e),u=r(e,"IFRAME",{src:!0,title:!0,width:!0,height:!0,frameborder:!0,allow:!0}),we(u).forEach(l),Qe=n(e),m(te.$$.fragment,e),ze=n(e),le=r(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-mrpax"&&(le.textContent=Ct),Ne=n(e),m(se.$$.fragment,e),He=n(e),j=r(e,"IFRAME",{src:!0,title:!0,width:!0,height:!0,frameborder:!0,allow:!0}),we(j).forEach(l),Le=n(e),m(ae.$$.fragment,e),Pe=n(e),ne=r(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-18k4wdv"&&(ne.textContent=bt),qe=n(e),m(ie.$$.fragment,e),De=n(e),h=r(e,"IFRAME",{src:!0,title:!0,width:!0,height:!0,frameborder:!0,allow:!0}),we(h).forEach(l),Ke=n(e),re=r(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-fzl1fe"&&(re.textContent=Gt),Oe=n(e),m(pe.$$.fragment,e),et=n(e),Me=r(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-chd5s6"&&(Me.textContent=Bt),tt=n(e),m(oe.$$.fragment,e),lt=n(e),ye=r(e,"P",{}),we(ye).forEach(l),this.h()},h(){M(J,"name","hf:doc:metadata"),M(J,"content",Vt),at(u.src,ft="https://marimo.app/gh/huggingface/notebooks/main/e?entrypoint=course%2Fen%2Fchapter13%2Fgrpo_length.py&embed=true&show-chrome=false")||M(u,"src",ft),M(u,"title","Marimo Notebook"),M(u,"width","100%"),M(u,"height","800px"),M(u,"frameborder","0"),M(u,"allow","clipboard-write"),at(j.src,It="https://marimo.app/gh/huggingface/notebooks/main/e?entrypoint=course%2Fen%2Fchapter13%2Fgrpo_math.py&embed=true&show-chrome=false")||M(j,"src",It),M(j,"title","Marimo Notebook"),M(j,"width","100%"),M(j,"height","800px"),M(j,"frameborder","0"),M(j,"allow","clipboard-write"),at(h.src,gt="https://marimo.app/gh/huggingface/notebooks/main/e?entrypoint=course%2Fen%2Fchapter13%2Fgrpo_format.py&embed=true&show-chrome=false")||M(h,"src",gt),M(h,"title","Marimo Notebook"),M(h,"width","100%"),M(h,"height","800px"),M(h,"frameborder","0"),M(h,"allow","clipboard-write")},m(e,t){Et(document.head,J),s(e,T,t),s(e,I,t),s(e,C,t),y(U,e,t),s(e,b,t),s(e,G,t),s(e,de,t),s(e,B,t),s(e,Ue,t),y(g,e,t),s(e,Je,t),s(e,Z,t),s(e,Te,t),s(e,$,t),s(e,ue,t),s(e,R,t),s(e,je,t),s(e,A,t),s(e,he,t),s(e,k,t),s(e,fe,t),y(v,e,t),s(e,Ce,t),y(x,e,t),s(e,Ie,t),y(_,e,t),s(e,be,t),s(e,X,t),s(e,ge,t),y(E,e,t),s(e,Ge,t),s(e,W,t),s(e,Be,t),y(F,e,t),s(e,Ze,t),y(Y,e,t),s(e,$e,t),s(e,S,t),s(e,Re,t),y(V,e,t),s(e,Ae,t),s(e,Q,t),s(e,ke,t),s(e,z,t),s(e,ve,t),s(e,N,t),s(e,xe,t),y(H,e,t),s(e,_e,t),s(e,L,t),s(e,Xe,t),y(P,e,t),s(e,Ee,t),s(e,q,t),s(e,We,t),y(D,e,t),s(e,Fe,t),s(e,K,t),s(e,Ye,t),y(O,e,t),s(e,Se,t),s(e,ee,t),s(e,Ve,t),s(e,u,t),s(e,Qe,t),y(te,e,t),s(e,ze,t),s(e,le,t),s(e,Ne,t),y(se,e,t),s(e,He,t),s(e,j,t),s(e,Le,t),y(ae,e,t),s(e,Pe,t),s(e,ne,t),s(e,qe,t),y(ie,e,t),s(e,De,t),s(e,h,t),s(e,Ke,t),s(e,re,t),s(e,Oe,t),y(pe,e,t),s(e,et,t),s(e,Me,t),s(e,tt,t),y(oe,e,t),s(e,lt,t),s(e,ye,t),st=!0},p(e,[t]){const Zt={};t&2&&(Zt.$$scope={dirty:t,ctx:e}),g.$set(Zt)},i(e){st||(w(U.$$.fragment,e),w(g.$$.fragment,e),w(v.$$.fragment,e),w(x.$$.fragment,e),w(_.$$.fragment,e),w(E.$$.fragment,e),w(F.$$.fragment,e),w(Y.$$.fragment,e),w(V.$$.fragment,e),w(H.$$.fragment,e),w(P.$$.fragment,e),w(D.$$.fragment,e),w(O.$$.fragment,e),w(te.$$.fragment,e),w(se.$$.fragment,e),w(ae.$$.fragment,e),w(ie.$$.fragment,e),w(pe.$$.fragment,e),w(oe.$$.fragment,e),st=!0)},o(e){c(U.$$.fragment,e),c(g.$$.fragment,e),c(v.$$.fragment,e),c(x.$$.fragment,e),c(_.$$.fragment,e),c(E.$$.fragment,e),c(F.$$.fragment,e),c(Y.$$.fragment,e),c(V.$$.fragment,e),c(H.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(oe.$$.fragment,e),st=!1},d(e){e&&(l(T),l(I),l(C),l(b),l(G),l(de),l(B),l(Ue),l(Je),l(Z),l(Te),l($),l(ue),l(R),l(je),l(A),l(he),l(k),l(fe),l(Ce),l(Ie),l(be),l(X),l(ge),l(Ge),l(W),l(Be),l(Ze),l($e),l(S),l(Re),l(Ae),l(Q),l(ke),l(z),l(ve),l(N),l(xe),l(_e),l(L),l(Xe),l(Ee),l(q),l(We),l(Fe),l(K),l(Ye),l(Se),l(ee),l(Ve),l(u),l(Qe),l(ze),l(le),l(Ne),l(He),l(j),l(Le),l(Pe),l(ne),l(qe),l(De),l(h),l(Ke),l(re),l(Oe),l(et),l(Me),l(tt),l(lt),l(ye)),l(J),d(U,e),d(g,e),d(v,e),d(x,e),d(_,e),d(E,e),d(F,e),d(Y,e),d(V,e),d(H,e),d(P,e),d(D,e),d(O,e),d(te,e),d(se,e),d(ae,e),d(ie,e),d(pe,e),d(oe,e)}}}const Vt='{"title":"Implementing GRPO in TRL","local":"implementing-grpo-in-trl","sections":[{"title":"Key Components","local":"key-components","sections":[{"title":"1. Dataset Format","local":"1-dataset-format","sections":[],"depth":3},{"title":"2. Reward Function","local":"2-reward-function","sections":[],"depth":3},{"title":"3. Training Configuration","local":"3-training-configuration","sections":[],"depth":3}],"depth":2},{"title":"Tips for Success","local":"tips-for-success","sections":[],"depth":2},{"title":"Reward Function Design","local":"reward-function-design","sections":[{"title":"1. Length-Based Rewards","local":"1-length-based-rewards","sections":[],"depth":3}],"depth":2},{"title":"2. Rule-Based Rewards for Verifiable Tasks","local":"2-rule-based-rewards-for-verifiable-tasks","sections":[],"depth":2},{"title":"3. Format-Based Rewards","local":"3-format-based-rewards","sections":[],"depth":2},{"title":"That’s it!","local":"thats-it","sections":[],"depth":2}],"depth":1}';function Qt(ce){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends xt{constructor(J){super(),_t(this,J,Qt,St,At,{})}}export{qt as component};
