import{s as il,f as he,n as Ml,o as pl}from"../chunks/scheduler.3e37077e.js";import{S as rl,i as yl,g as o,s as n,r as y,A as ml,h as i,f as l,c as a,j as de,u as m,x as M,k as r,y as cl,a as s,v as c,d as u,t as j,w as U}from"../chunks/index.0b341bf5.js";import{C as we}from"../chunks/CodeBlock.6444d2b6.js";import{H as jt}from"../chunks/Heading.639933af.js";import{E as ul}from"../chunks/EditOnGithub.aed3507d.js";function jl(be){let w,Ut,ct,wt,h,ht,d,Te="In the last section, we learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by <strong>handling much of the heavy lifting for you</strong>.",dt,b,Je="In this tutorial, <strong>you’ll create your very first Agent</strong> capable of performing actions such as image generation, web search, time zone checking and much more!",bt,T,ge="You will also publish your agent <strong>on a Hugging Face Space so you can share it with friends and colleagues</strong>.",Tt,J,Ce="Let’s get started!",Jt,g,gt,C,fe,Ct,f,Be="To make this Agent, we’re going to use <code>smolagents</code>, a library that <strong>provides a framework for developing your agents with ease</strong>.",ft,B,Ie="This lightweight library is designed for simplicity, but it abstracts away much of the complexity of building an Agent, allowing you to focus on designing your agent’s behavior.",Bt,I,ve='We’re going to get deeper into smolagents in the next Unit. Meanwhile, you can also check this <a href="https://huggingface.co/blog/smolagents" target="_blank">blog post</a> or the library’s <a href="https://github.com/huggingface/smolagents" target="_blank">repo in GitHub</a>.',It,v,Ze="In short, <code>smolagents</code> is a library that focuses on <strong>codeAgent</strong>, a kind of agent that performs <strong>“Actions”</strong> through code blocks, and then <strong>“Observes”</strong> results by executing the code.",vt,Z,Ae="Here is an example of what we’ll build!",Zt,A,We="We provided our agent with an <strong>Image generation tool</strong> and asked it to generate an image of a cat.",At,W,Ee="The agent inside <code>smolagents</code> is going to have the <strong>same behaviors as the custom one we built previously</strong>: it’s going <strong>to think, act and observe in cycle</strong> until it reaches a final answer:",Wt,p,He,Et,E,Ge="Exciting, right?",Ht,H,Gt,G,_e='To start, duplicate this Space: <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',_t,_,xe='<p>Thanks to <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> for this template! 🙌</p>',xt,x,ke="Duplicating this space means <strong>creating a local copy on your own profile</strong>:",kt,k,Qe,Qt,Q,Re='Throughout this lesson, the only file you will need to modify is the (currently incomplete) <strong>“app.py”</strong>. You can see here the <a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original one in the template</a>. To find yours, go to your copy of the space, then click the <code>Files</code> tab and then on <code>app.py</code> in the directory listing.',Rt,R,Xe="Let’s break down the code together:",Xt,X,Se="<li>The file begins with some simple but necessary library imports</li>",St,S,zt,z,ze="As outlined earlier, we will directly use the <strong>CodeAgent</strong> class from <strong>smolagents</strong>.",Ft,F,Nt,N,Fe='Now let’s get into the tools! If you want a refresher about tools, don’t hesitate to go back to the <a href="tools">Tools</a> section of the course.',Vt,V,Lt,L,Ne="The Tools are what we are encouraging you to build in this section! We give you two examples:",$t,$,Ve="<li>A <strong>non-working dummy Tool</strong> that you can modify to make something useful.</li> <li>An <strong>actually working Tool</strong> that gets the current time somewhere in the world.</li>",Yt,Y,Le="To define your tool it is important to:",qt,q,$e="<li>Provide input and output types for your function, like in <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>A well formatted docstring</strong>. <code>smolagents</code> is expecting all the arguments to have a <strong>textual description in the docstring</strong>.</li>",Pt,P,Dt,D,Ye='It uses <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> as the LLM engine. This is a very capable model that we’ll access via the serverless API.',Kt,K,Ot,O,qe="This Agent still uses the <code>InferenceClient</code> we saw in an earlier section behind the <strong>HfApiModel</strong> class!",te,tt,Pe="We will give more in-depth examples when we present the framework in Unit 2. For now, you need to focus on <strong>adding new tools to the list of tools</strong> using the <code>tools</code> parameter of your Agent.",ee,et,De="For example, you could use the <code>DuckDuckGoSearchTool</code> that was imported in the first line of the code, or you can examine the <code>image_generation_tool</code> that is loaded from the Hub later in the code.",le,lt,Ke="<strong>Adding tools will give your agent new capabilities</strong>, try to be creative here!",se,st,Oe="The complete “app.py”:",ne,nt,ae,at,tl="Your <strong>Goal</strong> is to get familiar with the Space and the Agent.",oe,ot,el="Currently, the agent in the template <strong>does not use any tools, so try to provide it with some of the pre-made ones or even make some new tools yourself!</strong>",ie,it,ll="We are eagerly waiting for your amazing agents output in the discord channel <strong>#agents-course-showcase</strong>!",Me,pe,re,Mt,sl="Congratulations, you’ve built your first Agent! Don’t hesitate to share it with your friends and colleagues.",ye,pt,nl="Since this is your first try, it’s perfectly normal if it’s a little buggy or slow. In future units, we’ll learn how to build even better Agents.",me,rt,al="The best way to learn is to try, so don’t hesitate to update it, add more tools, try with another model, etc.",ce,yt,ol="In the next section, you’re going to fill the final Quiz and get your certificate!",ue,mt,je,ut,Ue;return h=new jt({props:{title:"Let’s Create Our First Agent Using smolagents",local:"lets-create-our-first-agent-using-smolagents",headingTag:"h1"}}),g=new jt({props:{title:"What is smolagents?",local:"what-is-smolagents",headingTag:"h2"}}),H=new jt({props:{title:"Let’s build our Agent!",local:"lets-build-our-agent",headingTag:"h2"}}),S=new we({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkMlMjBsb2FkX3Rvb2wlMkMlMjB0b29sJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMHB5dHolMEFpbXBvcnQlMjB5YW1sJTBBZnJvbSUyMHRvb2xzLmZpbmFsX2Fuc3dlciUyMGltcG9ydCUyMEZpbmFsQW5zd2VyVG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),F=new jt({props:{title:"The Tools",local:"the-tools",headingTag:"h3"}}),V=new we({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),P=new jt({props:{title:"The Agent",local:"the-agent",headingTag:"h3"}}),K=new we({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwoJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDIwOTYlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJ1F3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcm9sZV9jb252ZXJzaW9ucyUzRE5vbmUlMkMlMEEpJTBBJTBBd2l0aCUyMG9wZW4oJTIycHJvbXB0cy55YW1sJTIyJTJDJTIwJ3InKSUyMGFzJTIwc3RyZWFtJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUyMCUzRCUyMHlhbWwuc2FmZV9sb2FkKHN0cmVhbSklMEElMjAlMjAlMjAlMjAlMEElMjMlMjBXZSdyZSUyMGNyZWF0aW5nJTIwb3VyJTIwQ29kZUFnZW50JTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCZmluYWxfYW5zd2VyJTVEJTJDJTIwJTIzJTIwYWRkJTIweW91ciUyMHRvb2xzJTIwaGVyZSUyMChkb24ndCUyMHJlbW92ZSUyMGZpbmFsX2Fuc3dlciklMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q2JTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMSUyQyUwQSUyMCUyMCUyMCUyMGdyYW1tYXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfdGVtcGxhdGVzJTNEcHJvbXB0X3RlbXBsYXRlcyUwQSklMEElMEFHcmFkaW9VSShhZ2VudCkubGF1bmNoKCk=",highlighted:`final_answer = FinalAnswerTool()
model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># We&#x27;re creating our CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),nt=new we({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = HfApiModel(
max_tokens=<span class="hljs-number">2096</span>,
temperature=<span class="hljs-number">0.5</span>,
model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),mt=new ul({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tutorial.mdx"}}),{c(){w=o("meta"),Ut=n(),ct=o("p"),wt=n(),y(h.$$.fragment),ht=n(),d=o("p"),d.innerHTML=Te,dt=n(),b=o("p"),b.innerHTML=Je,bt=n(),T=o("p"),T.innerHTML=ge,Tt=n(),J=o("p"),J.textContent=Ce,Jt=n(),y(g.$$.fragment),gt=n(),C=o("img"),Ct=n(),f=o("p"),f.innerHTML=Be,ft=n(),B=o("p"),B.textContent=Ie,Bt=n(),I=o("p"),I.innerHTML=ve,It=n(),v=o("p"),v.innerHTML=Ze,vt=n(),Z=o("p"),Z.textContent=Ae,Zt=n(),A=o("p"),A.innerHTML=We,At=n(),W=o("p"),W.innerHTML=Ee,Wt=n(),p=o("iframe"),Et=n(),E=o("p"),E.textContent=Ge,Ht=n(),y(H.$$.fragment),Gt=n(),G=o("p"),G.innerHTML=_e,_t=n(),_=o("blockquote"),_.innerHTML=xe,xt=n(),x=o("p"),x.innerHTML=ke,kt=n(),k=o("img"),Qt=n(),Q=o("p"),Q.innerHTML=Re,Rt=n(),R=o("p"),R.textContent=Xe,Xt=n(),X=o("ul"),X.innerHTML=Se,St=n(),y(S.$$.fragment),zt=n(),z=o("p"),z.innerHTML=ze,Ft=n(),y(F.$$.fragment),Nt=n(),N=o("p"),N.innerHTML=Fe,Vt=n(),y(V.$$.fragment),Lt=n(),L=o("p"),L.textContent=Ne,$t=n(),$=o("ol"),$.innerHTML=Ve,Yt=n(),Y=o("p"),Y.textContent=Le,qt=n(),q=o("ol"),q.innerHTML=$e,Pt=n(),y(P.$$.fragment),Dt=n(),D=o("p"),D.innerHTML=Ye,Kt=n(),y(K.$$.fragment),Ot=n(),O=o("p"),O.innerHTML=qe,te=n(),tt=o("p"),tt.innerHTML=Pe,ee=n(),et=o("p"),et.innerHTML=De,le=n(),lt=o("p"),lt.innerHTML=Ke,se=n(),st=o("p"),st.textContent=Oe,ne=n(),y(nt.$$.fragment),ae=n(),at=o("p"),at.innerHTML=tl,oe=n(),ot=o("p"),ot.innerHTML=el,ie=n(),it=o("p"),it.innerHTML=ll,Me=n(),pe=o("hr"),re=n(),Mt=o("p"),Mt.textContent=sl,ye=n(),pt=o("p"),pt.textContent=nl,me=n(),rt=o("p"),rt.textContent=al,ce=n(),yt=o("p"),yt.textContent=ol,ue=n(),y(mt.$$.fragment),je=n(),ut=o("p"),this.h()},l(t){const e=ml("svelte-u9bgzb",document.head);w=i(e,"META",{name:!0,content:!0}),e.forEach(l),Ut=a(t),ct=i(t,"P",{}),de(ct).forEach(l),wt=a(t),m(h.$$.fragment,t),ht=a(t),d=i(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-gmmoh4"&&(d.innerHTML=Te),dt=a(t),b=i(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-isl0ka"&&(b.innerHTML=Je),bt=a(t),T=i(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-zy1mev"&&(T.innerHTML=ge),Tt=a(t),J=i(t,"P",{"data-svelte-h":!0}),M(J)!=="svelte-4b3xjd"&&(J.textContent=Ce),Jt=a(t),m(g.$$.fragment,t),gt=a(t),C=i(t,"IMG",{src:!0,alt:!0}),Ct=a(t),f=i(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1bet7no"&&(f.innerHTML=Be),ft=a(t),B=i(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-oceeap"&&(B.textContent=Ie),Bt=a(t),I=i(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1wfbi7x"&&(I.innerHTML=ve),It=a(t),v=i(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1kxxgvd"&&(v.innerHTML=Ze),vt=a(t),Z=i(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1x3dozw"&&(Z.textContent=Ae),Zt=a(t),A=i(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1kwa3nr"&&(A.innerHTML=We),At=a(t),W=i(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-4nw0u8"&&(W.innerHTML=Ee),Wt=a(t),p=i(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),de(p).forEach(l),Et=a(t),E=i(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1riubhm"&&(E.textContent=Ge),Ht=a(t),m(H.$$.fragment,t),Gt=a(t),G=i(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-3pukde"&&(G.innerHTML=_e),_t=a(t),_=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(_)!=="svelte-1lji2e8"&&(_.innerHTML=xe),xt=a(t),x=i(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-xpoxi8"&&(x.innerHTML=ke),kt=a(t),k=i(t,"IMG",{src:!0,alt:!0}),Qt=a(t),Q=i(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-e4oew5"&&(Q.innerHTML=Re),Rt=a(t),R=i(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-xgl3rm"&&(R.textContent=Xe),Xt=a(t),X=i(t,"UL",{"data-svelte-h":!0}),M(X)!=="svelte-g8ecnx"&&(X.innerHTML=Se),St=a(t),m(S.$$.fragment,t),zt=a(t),z=i(t,"P",{"data-svelte-h":!0}),M(z)!=="svelte-eq9rdr"&&(z.innerHTML=ze),Ft=a(t),m(F.$$.fragment,t),Nt=a(t),N=i(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1qrccm5"&&(N.innerHTML=Fe),Vt=a(t),m(V.$$.fragment,t),Lt=a(t),L=i(t,"P",{"data-svelte-h":!0}),M(L)!=="svelte-qrpozm"&&(L.textContent=Ne),$t=a(t),$=i(t,"OL",{"data-svelte-h":!0}),M($)!=="svelte-12muy28"&&($.innerHTML=Ve),Yt=a(t),Y=i(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-mmcol7"&&(Y.textContent=Le),qt=a(t),q=i(t,"OL",{"data-svelte-h":!0}),M(q)!=="svelte-p349vr"&&(q.innerHTML=$e),Pt=a(t),m(P.$$.fragment,t),Dt=a(t),D=i(t,"P",{"data-svelte-h":!0}),M(D)!=="svelte-16qafzg"&&(D.innerHTML=Ye),Kt=a(t),m(K.$$.fragment,t),Ot=a(t),O=i(t,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1o74ygl"&&(O.innerHTML=qe),te=a(t),tt=i(t,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-t0wd0t"&&(tt.innerHTML=Pe),ee=a(t),et=i(t,"P",{"data-svelte-h":!0}),M(et)!=="svelte-1m08tlu"&&(et.innerHTML=De),le=a(t),lt=i(t,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-13ckn13"&&(lt.innerHTML=Ke),se=a(t),st=i(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-11duvvf"&&(st.textContent=Oe),ne=a(t),m(nt.$$.fragment,t),ae=a(t),at=i(t,"P",{"data-svelte-h":!0}),M(at)!=="svelte-1fyjbth"&&(at.innerHTML=tl),oe=a(t),ot=i(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-1xqfrp"&&(ot.innerHTML=el),ie=a(t),it=i(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-h3h5uq"&&(it.innerHTML=ll),Me=a(t),pe=i(t,"HR",{}),re=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-1vcdjz4"&&(Mt.textContent=sl),ye=a(t),pt=i(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-10mjkny"&&(pt.textContent=nl),me=a(t),rt=i(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-10xgfu5"&&(rt.textContent=al),ce=a(t),yt=i(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-1s9m3df"&&(yt.textContent=ol),ue=a(t),m(mt.$$.fragment,t),je=a(t),ut=i(t,"P",{}),de(ut).forEach(l),this.h()},h(){r(w,"name","hf:doc:metadata"),r(w,"content",Ul),he(C.src,fe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||r(C,"src",fe),r(C,"alt","smolagents"),r(p,"width","560"),r(p,"height","315"),he(p.src,He="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||r(p,"src",He),r(p,"title","YouTube video player"),r(p,"frameborder","0"),r(p,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),r(p,"referrerpolicy","strict-origin-when-cross-origin"),p.allowFullscreen="",he(k.src,Qe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||r(k,"src",Qe),r(k,"alt","Duplicate")},m(t,e){cl(document.head,w),s(t,Ut,e),s(t,ct,e),s(t,wt,e),c(h,t,e),s(t,ht,e),s(t,d,e),s(t,dt,e),s(t,b,e),s(t,bt,e),s(t,T,e),s(t,Tt,e),s(t,J,e),s(t,Jt,e),c(g,t,e),s(t,gt,e),s(t,C,e),s(t,Ct,e),s(t,f,e),s(t,ft,e),s(t,B,e),s(t,Bt,e),s(t,I,e),s(t,It,e),s(t,v,e),s(t,vt,e),s(t,Z,e),s(t,Zt,e),s(t,A,e),s(t,At,e),s(t,W,e),s(t,Wt,e),s(t,p,e),s(t,Et,e),s(t,E,e),s(t,Ht,e),c(H,t,e),s(t,Gt,e),s(t,G,e),s(t,_t,e),s(t,_,e),s(t,xt,e),s(t,x,e),s(t,kt,e),s(t,k,e),s(t,Qt,e),s(t,Q,e),s(t,Rt,e),s(t,R,e),s(t,Xt,e),s(t,X,e),s(t,St,e),c(S,t,e),s(t,zt,e),s(t,z,e),s(t,Ft,e),c(F,t,e),s(t,Nt,e),s(t,N,e),s(t,Vt,e),c(V,t,e),s(t,Lt,e),s(t,L,e),s(t,$t,e),s(t,$,e),s(t,Yt,e),s(t,Y,e),s(t,qt,e),s(t,q,e),s(t,Pt,e),c(P,t,e),s(t,Dt,e),s(t,D,e),s(t,Kt,e),c(K,t,e),s(t,Ot,e),s(t,O,e),s(t,te,e),s(t,tt,e),s(t,ee,e),s(t,et,e),s(t,le,e),s(t,lt,e),s(t,se,e),s(t,st,e),s(t,ne,e),c(nt,t,e),s(t,ae,e),s(t,at,e),s(t,oe,e),s(t,ot,e),s(t,ie,e),s(t,it,e),s(t,Me,e),s(t,pe,e),s(t,re,e),s(t,Mt,e),s(t,ye,e),s(t,pt,e),s(t,me,e),s(t,rt,e),s(t,ce,e),s(t,yt,e),s(t,ue,e),c(mt,t,e),s(t,je,e),s(t,ut,e),Ue=!0},p:Ml,i(t){Ue||(u(h.$$.fragment,t),u(g.$$.fragment,t),u(H.$$.fragment,t),u(S.$$.fragment,t),u(F.$$.fragment,t),u(V.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(nt.$$.fragment,t),u(mt.$$.fragment,t),Ue=!0)},o(t){j(h.$$.fragment,t),j(g.$$.fragment,t),j(H.$$.fragment,t),j(S.$$.fragment,t),j(F.$$.fragment,t),j(V.$$.fragment,t),j(P.$$.fragment,t),j(K.$$.fragment,t),j(nt.$$.fragment,t),j(mt.$$.fragment,t),Ue=!1},d(t){t&&(l(Ut),l(ct),l(wt),l(ht),l(d),l(dt),l(b),l(bt),l(T),l(Tt),l(J),l(Jt),l(gt),l(C),l(Ct),l(f),l(ft),l(B),l(Bt),l(I),l(It),l(v),l(vt),l(Z),l(Zt),l(A),l(At),l(W),l(Wt),l(p),l(Et),l(E),l(Ht),l(Gt),l(G),l(_t),l(_),l(xt),l(x),l(kt),l(k),l(Qt),l(Q),l(Rt),l(R),l(Xt),l(X),l(St),l(zt),l(z),l(Ft),l(Nt),l(N),l(Vt),l(Lt),l(L),l($t),l($),l(Yt),l(Y),l(qt),l(q),l(Pt),l(Dt),l(D),l(Kt),l(Ot),l(O),l(te),l(tt),l(ee),l(et),l(le),l(lt),l(se),l(st),l(ne),l(ae),l(at),l(oe),l(ot),l(ie),l(it),l(Me),l(pe),l(re),l(Mt),l(ye),l(pt),l(me),l(rt),l(ce),l(yt),l(ue),l(je),l(ut)),l(w),U(h,t),U(g,t),U(H,t),U(S,t),U(F,t),U(V,t),U(P,t),U(K,t),U(nt,t),U(mt,t)}}}const Ul='{"title":"Let’s Create Our First Agent Using smolagents","local":"lets-create-our-first-agent-using-smolagents","sections":[{"title":"What is smolagents?","local":"what-is-smolagents","sections":[],"depth":2},{"title":"Let’s build our Agent!","local":"lets-build-our-agent","sections":[{"title":"The Tools","local":"the-tools","sections":[],"depth":3},{"title":"The Agent","local":"the-agent","sections":[],"depth":3}],"depth":2}],"depth":1}';function wl(be){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gl extends rl{constructor(w){super(),yl(this,w,wl,jl,il,{})}}export{gl as component};
