import{s as ve,f as xe,n as Xe,o as Ze}from"../chunks/scheduler.f6b352c8.js";import{S as qe,i as Ye,g as i,s as n,r as h,A as Ne,h as p,f as e,c as a,j as Qs,u,x as o,k as Fs,y as Ls,a as l,v as r,d as M,t as c,w as y}from"../chunks/index.7f38e934.js";import{C as w}from"../chunks/CodeBlock.2a338b68.js";import{H as Ss}from"../chunks/Heading.333929c4.js";import{E as Ee}from"../chunks/EditOnGithub.c3245a01.js";function We(Hs){let j,Gt,kt,Ct,d,vt,T,zs,xt,J,Ps="This course is framework agnostic because we want to <strong>focus on the concepts of AI agents and avoid getting bogged down in the specifics of a particular framework</strong>.",Xt,f,Os="Also, we want students to be able to use the concepts they learn in this course in their own projects, in any framework.",Zt,b,Ds="Therefore, for this Unit 1, we will use a dummy agent library and simple severless API, which will be our LLM engine.",qt,U,Ks="In reality, you would not use these in production, but they will serve as a good <strong>starting point for understanding how agents work</strong>.",Yt,g,te="But, after this section, you’ll <strong>create a simple Agent</strong> using <code>smolagents</code>",Nt,B,se="And in the following Units we will also use other AI Agent libraries like <code>LangGraph</code>, <code>LangChain</code>, and <code>LlamaIndex</code>.",Et,$,ee="To keep things simple we will use a simple Python function as a Tool and Agent.",Wt,_,le="We will use built in python packages like <code>datetime</code> and <code>os</code> so that you can try it out in any environment.",Rt,k,ne='You can find the notebook <a href="https://colab.research.google.com/drive/1MmVo8V9bLkgcVA1RB5LZtX_lO8y_HBxm?usp=sharing" rel="nofollow">here</a>. If you <strong>want to run the code</strong>.',Vt,I,Ft,G,ae="In the Hugging Face ecosystem there is a conveniant feature called <em>Serverless API</em> that allows you to <strong>test some models</strong>. This uses a shared enpoints between multiples users to compute some requests. This is conveniant to test some models.",At,C,Qt,v,Lt,x,ie="output:",St,X,Ht,Z,pe="As seen in the LLM section, if we just do decoding, <strong>the model will only stop when it predicts an EOS token</strong> and this does not happen here because <strong>we forgot to add the special tokens of this model</strong>.",zt,q,oe='If we now add the special tokens related to the <a href="https://huggingface.co/meta-llama/Llama-3.2-3B-Instruct">Llama-3.2-3B-Instruct model</a> that we’re using, the behaviour changes and is now the expected EOS.',Pt,Y,Ot,N,he="output:",Dt,E,Kt,W,ue="Manually adding special tokens is equivalent to using the “chat” method:",ts,R,ss,V,re="output:",es,F,ls,A,Me="The chat method is the RECOMMENDED method to use in order to ensure a smooth transition between models but since this notebook is only educationnal, we will keep using the “text_generation” method to understand the details.",ns,Q,as,L,ce="In the previous sections, we saw that the core of an agent library is to append information in the system prompt.",is,S,ye="This system prompt is a bit more complex than the one we saw earlier, but it already contains:",ps,H,we="<li><strong>Information about the tools</strong></li> <li><strong>Cycle instructions</strong> (Thought → Action → Observation)</li>",os,z,hs,P,je="Since we are running the “text_generation”, we need to add the right special tokens.",us,O,rs,D,me="This is equivalent to the following code that happens inside the chat method :",Ms,K,cs,tt,de="The prompt now is :",ys,st,ws,et,Te="Let’s decode !",js,lt,ms,nt,Je="output:",ds,at,Ts,it,fe=`{
“action”: “get_weather”,
“action”: {“location”: “London”}
}`,Js,pt,fs,ot,be="Do you see the issue ?",bs,m,_t,Ue=`The answer was hallucinated by the model. We need to stop to actually execute the function !
Let’s now stop on “Obersavation” so that we don’t hallucinate the actual function response`,As,ht,Us,ut,ge="print(output)",gs,rt,Bs,Mt,Be="Action:",$s,ct,_s,yt,$e=`Thought: I will check the weather in London.
Observation:`,ks,wt,Is,jt,_e="output:",Gs,mt,Cs,dt,ke="Let’s concatenate the base prompt, the completion untill function execution and the result of the function as an Observation and resume the generation.",vs,Tt,xs,Jt,Ie="Here is the new prompt:",Xs,ft,Zs,bt,Ge=`{
“action”: “get_weather”,
“action”: {“location”: {“type”: “string”, “value”: “London”}
}`,qs,Ut,Ys,gt,Ce="output:",Ns,Bt,Es,$t,Ws,It,Rs;return d=new Ss({props:{title:"Dummy Agent Library",local:"dummy-agent-library",headingTag:"h1"}}),I=new Ss({props:{title:"Serverless API",local:"serverless-api",headingTag:"h2"}}),C=new w({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIzJTIwWW91JTIwbmVlZCUyMGElMjB0b2tlbiUyQyUyMHRoaXMlMjBjYW4lMjBiZSUyMHNldCUyMGluJTIwdGhlJTIwJTIyc2V0dGluZ3MlMjIlMjB0YWIlMjB1bmRlciUyMCUyMnNlY3JldCUyMi4lMjBNYWtlJTIwc3VyZSUyMHRvJTIwY2FsbCUyMGl0JTIwJTIySEZfVE9LRU4lMjIlMEFvcy5lbnZpcm9uJTVCJTIySEZfVE9LRU4lMjIlNUQlM0QlMjJoZl94eHh4eHh4eHh4eHh4eCUyMiUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4yLTNCLUluc3RydWN0JTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment">## You need a token, this can be set in the &quot;settings&quot; tab under &quot;secret&quot;. Make sure to call it &quot;HF_TOKEN&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>]=<span class="hljs-string">&quot;hf_xxxxxxxxxxxxxx&quot;</span>

client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)`,wrap:!1}}),v=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBmcmFuY2UlMjBpcyUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBKSUwQSUwQXByaW50KG91dHB1dCk=",highlighted:`output = client.text_generation(
    <span class="hljs-string">&quot;The capital of france is&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),X=new w({props:{code:"UGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLg==",highlighted:'Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),Y=new w({props:{code:"cHJvbXB0JTNEJTIyJTIyJTIyJTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBVGhlJTIwY2FwaXRhbCUyMG9mJTIwZnJhbmNlJTIwaXMlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTIyJTIyJTIyJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`prompt=<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
The capital of france is&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;&quot;&quot;&quot;</span>
output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),E=new w({props:{code:"VGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4=",highlighted:'The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),R=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwZnJhbmNlJTIwaXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKQ==",highlighted:`output = client.chat.completions.create(
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The capital of france is&quot;</span>},
    ],
    stream=<span class="hljs-literal">False</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)`,wrap:!1}}),F=new w({props:{code:"UGFyaXMu",highlighted:"Paris.",wrap:!1}}),Q=new Ss({props:{title:"Dummy Agent",local:"dummy-agent",headingTag:"h2"}}),z=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`Answer the following questions as best you can. You have access to the following tools:

get_weather: Get the current weather in a given location

The way you <span class="hljs-keyword">use</span> the tools is by specifying a json blob.
Specifically, <span class="hljs-keyword">this</span> json should have a \`action\` key (<span class="hljs-keyword">with</span> the name of the tool to <span class="hljs-keyword">use</span>) <span class="hljs-keyword">and</span> a \`action_input\` key (<span class="hljs-keyword">with</span> the <span class="hljs-keyword">input</span> to the tool going here).

The only values that should be in the <span class="hljs-string">&quot;action&quot;</span> field are:
get_weather: Get the current weather in a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example <span class="hljs-keyword">use</span> : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS <span class="hljs-keyword">use</span> the following format:

Question: the <span class="hljs-keyword">input</span> question you must answer
Thought: you should <span class="hljs-keyword">always</span> think about one action to take. Only one action at a <span class="hljs-keyword">time</span> in <span class="hljs-keyword">this</span> format:
Action:

$JSON_BLOB (<span class="hljs-keyword">inside</span> markdown <span class="hljs-keyword">cell</span>)

Observation: the result of the action. This Observation is <span class="hljs-keyword">unique</span>, complete, <span class="hljs-keyword">and</span> the source of truth.
... (<span class="hljs-keyword">this</span> Thought/Action/Observation can <span class="hljs-keyword">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted as markdown <span class="hljs-keyword">and</span> only <span class="hljs-keyword">use</span> a SINGLE action at a <span class="hljs-keyword">time</span>.)

Youb must <span class="hljs-keyword">always</span> <span class="hljs-keyword">end</span> your <span class="hljs-keyword">output</span> <span class="hljs-keyword">with</span> the following format:

Thought: I now know the <span class="hljs-keyword">final</span> answer
Final Answer: the <span class="hljs-keyword">final</span> answer to the original <span class="hljs-keyword">input</span> question

Now <span class="hljs-keyword">begin</span>! Reminder to ALWAYS <span class="hljs-keyword">use</span> the exact characters \`Final Answer:\` when you provide a definitive answer.`,wrap:!1}}),O=new w({props:{code:"cHJvbXB0JTNEZiUyMiUyMiUyMiUzQyU3Q2JlZ2luX29mX3RleHQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0VzeXN0ZW0lM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTdCU1lTVEVNX1BST01QVCU3RCUwQSUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBV2hhdCdzJTIwdGhlJTIwd2VpdGhlciUyMGluJTIwTG9uZG9uJTIwJTNGJTBBJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-attr">prompt</span>=f<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;
{SYSTEM_PROMPT}
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
What&#x27;s the weither in London ?
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new w({props:{code:"bWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMFNZU1RFTV9QUk9NUFQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjB3ZWl0aGVyJTIwaW4lMjBMb25kb24lMjAlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSk=",highlighted:`messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weither in London ?&quot;</span>},
    ]
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)

tokenizer.apply_chat_template(messages, <span class="hljs-keyword">tokenize</span>=<span class="hljs-keyword">False</span>,add_generation_prompt=<span class="hljs-keyword">True</span>)`,wrap:!1}}),st=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have a \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

Youb must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weither <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),lt=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),at=new w({props:{code:"QWN0aW9uJTNB",highlighted:'<span class="hljs-symbol">Action:</span>',wrap:!1}}),pt=new w({props:{code:"VGhvdWdodCUzQSUyMEklMjB3aWxsJTIwY2hlY2slMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24uJTBBT2JzZXJ2YXRpb24lM0ElMjBUaGUlMjBjdXJyZW50JTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwaXMlMjBtb3N0bHklMjBjbG91ZHklMjB3aXRoJTIwYSUyMGhpZ2glMjBvZiUyMDEyJUMyJUIwQyUyMGFuZCUyMGElMjBsb3clMjBvZiUyMDglQzIlQjBDLg==",highlighted:`Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Observation: The current weather in London is mostly cloudy with a high of 12°C<span class="hljs-built_in"> and </span>a low of 8°C.`,wrap:!1}}),ht=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHN0b3AlM0QlNUIlMjJPYnNlcnZhdGlvbiUzQSUyMiU1RCUyMCUyMyUyMExldCdzJTIwc3RvcCUyMGJlZm9yZSUyMGFueSUyMGFjdHVhbCUyMGZ1bmN0aW9uJTIwaXMlMjBjYWxsZWQlMEEp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
    stop=[<span class="hljs-string">&quot;Observation:&quot;</span>] <span class="hljs-comment"># Let&#x27;s stop before any actual function is called</span>
)`,wrap:!1}}),rt=new w({props:{code:"b3V0cHV0JTNB",highlighted:'<span class="hljs-symbol">output:</span>',wrap:!1}}),ct=new w({props:{code:"JTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMkxvbmRvbiUyMiU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;London&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),wt=new w({props:{code:"TXVjaCUyMEJldHRlciUyMCElMjAlMEFMZXQncyUyMG5vdyUyMGNyZWF0ZSUyMGElMjBkdW1teSUyMGdldCUyMHdlaXRoZXIlMjBmdW5jdGlvbi4lMjBJbiUyMHJlYWwlMjBzaXR1YXRpb24lMjB5b3UlMjBjb3VsZCUyMGNhbGwlMjBhbmQlMjBBUEkuJTBBJTYwJTYwJTYwcHl0aG9uJTBBJTIzRHVtbXklMjBmdW5jdGlvbiUwQWRlZiUyMGdldF93ZWF0aGVyKGxvY2F0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJ0aGUlMjB3ZWF0aGVyJTIwaW4lMjAlN0Jsb2NhdGlvbiU3RCUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24lMjIlMEElMEFnZXRfd2VhdGhlcignTG9uZG9uJyk=",highlighted:`Much Better ! 
Let<span class="hljs-symbol">&#x27;s</span> now create a dummy get weither <span class="hljs-keyword">function</span>. <span class="hljs-keyword">In</span> real situation you could call <span class="hljs-keyword">and</span> API.
\`\`\`python
#Dummy <span class="hljs-keyword">function</span>
<span class="hljs-title">def</span> get_weather(location):
    <span class="hljs-keyword">return</span> <span class="hljs-type">f&quot;the</span> weather <span class="hljs-keyword">in</span> {location} <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures. \\n<span class="hljs-string">&quot;

get_weather(&#x27;London&#x27;)</span>`,wrap:!1}}),mt=new w({props:{code:"J3RoZSUyMHdlYXRoZXIlMjBpbiUyMExvbmRvbiUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24n",highlighted:'<span class="hljs-symbol">&#x27;the</span> weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures. \\n&#x27;',wrap:!1}}),Tt=new w({props:{code:"bmV3X3Byb21wdCUzRHByb21wdCUyQm91dHB1dCUyQmdldF93ZWF0aGVyKCdMb25kb24nKSUwQWZpbmFsX291dHB1dCUyMCUzRCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwbmV3X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjAwJTJDJTBBKSUwQSUwQXByaW50KGZpbmFsX291dHB1dCk=",highlighted:`new_prompt=prompt+output+get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)
final_output = client.text_generation(
    new_prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(final_output)`,wrap:!1}}),ft=new w({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
    Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have a \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

Youb must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weither <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

Action</span>:`,wrap:!1}}),Ut=new w({props:{code:"VGhvdWdodCUzQSUyMEklMjB3aWxsJTIwY2hlY2slMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24uJTBBT2JzZXJ2YXRpb24lM0F0aGUlMjB3ZWl0aGVyJTIwaW4lMjBMb25kb24lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4lMjA=",highlighted:`Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Observation:the weither in London is sunny with low temperatures. `,wrap:!1}}),Bt=new w({props:{code:"RmluYWwlMjBBbnN3ZXIlM0ElMjBUaGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4=",highlighted:'<span class="hljs-keyword">Final</span> Answer: The weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures.',wrap:!1}}),$t=new Ee({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/dummy-agent-library.mdx"}}),{c(){j=i("meta"),Gt=n(),kt=i("p"),Ct=n(),h(d.$$.fragment),vt=n(),T=i("img"),xt=n(),J=i("p"),J.innerHTML=Ps,Xt=n(),f=i("p"),f.textContent=Os,Zt=n(),b=i("p"),b.textContent=Ds,qt=n(),U=i("p"),U.innerHTML=Ks,Yt=n(),g=i("p"),g.innerHTML=te,Nt=n(),B=i("p"),B.innerHTML=se,Et=n(),$=i("p"),$.textContent=ee,Wt=n(),_=i("p"),_.innerHTML=le,Rt=n(),k=i("p"),k.innerHTML=ne,Vt=n(),h(I.$$.fragment),Ft=n(),G=i("p"),G.innerHTML=ae,At=n(),h(C.$$.fragment),Qt=n(),h(v.$$.fragment),Lt=n(),x=i("p"),x.textContent=ie,St=n(),h(X.$$.fragment),Ht=n(),Z=i("p"),Z.innerHTML=pe,zt=n(),q=i("p"),q.innerHTML=oe,Pt=n(),h(Y.$$.fragment),Ot=n(),N=i("p"),N.textContent=he,Dt=n(),h(E.$$.fragment),Kt=n(),W=i("p"),W.textContent=ue,ts=n(),h(R.$$.fragment),ss=n(),V=i("p"),V.textContent=re,es=n(),h(F.$$.fragment),ls=n(),A=i("p"),A.textContent=Me,ns=n(),h(Q.$$.fragment),as=n(),L=i("p"),L.textContent=ce,is=n(),S=i("p"),S.textContent=ye,ps=n(),H=i("ol"),H.innerHTML=we,os=n(),h(z.$$.fragment),hs=n(),P=i("p"),P.textContent=je,us=n(),h(O.$$.fragment),rs=n(),D=i("p"),D.textContent=me,Ms=n(),h(K.$$.fragment),cs=n(),tt=i("p"),tt.textContent=de,ys=n(),h(st.$$.fragment),ws=n(),et=i("p"),et.textContent=Te,js=n(),h(lt.$$.fragment),ms=n(),nt=i("p"),nt.textContent=Je,ds=n(),h(at.$$.fragment),Ts=n(),it=i("p"),it.textContent=fe,Js=n(),h(pt.$$.fragment),fs=n(),ot=i("p"),ot.textContent=be,bs=n(),m=i("blockquote"),_t=i("p"),_t.textContent=Ue,As=n(),h(ht.$$.fragment),Us=n(),ut=i("p"),ut.textContent=ge,gs=n(),h(rt.$$.fragment),Bs=n(),Mt=i("p"),Mt.textContent=Be,$s=n(),h(ct.$$.fragment),_s=n(),yt=i("p"),yt.textContent=$e,ks=n(),h(wt.$$.fragment),Is=n(),jt=i("p"),jt.textContent=_e,Gs=n(),h(mt.$$.fragment),Cs=n(),dt=i("p"),dt.textContent=ke,vs=n(),h(Tt.$$.fragment),xs=n(),Jt=i("p"),Jt.textContent=Ie,Xs=n(),h(ft.$$.fragment),Zs=n(),bt=i("p"),bt.textContent=Ge,qs=n(),h(Ut.$$.fragment),Ys=n(),gt=i("p"),gt.textContent=Ce,Ns=n(),h(Bt.$$.fragment),Es=n(),h($t.$$.fragment),Ws=n(),It=i("p"),this.h()},l(t){const s=Ne("svelte-u9bgzb",document.head);j=p(s,"META",{name:!0,content:!0}),s.forEach(e),Gt=a(t),kt=p(t,"P",{}),Qs(kt).forEach(e),Ct=a(t),u(d.$$.fragment,t),vt=a(t),T=p(t,"IMG",{src:!0,alt:!0}),xt=a(t),J=p(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-8i1n71"&&(J.innerHTML=Ps),Xt=a(t),f=p(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1pws4bx"&&(f.textContent=Os),Zt=a(t),b=p(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1ojgbiq"&&(b.textContent=Ds),qt=a(t),U=p(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-10n19id"&&(U.innerHTML=Ks),Yt=a(t),g=p(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1oqu5up"&&(g.innerHTML=te),Nt=a(t),B=p(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-9snja6"&&(B.innerHTML=se),Et=a(t),$=p(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-scmak8"&&($.textContent=ee),Wt=a(t),_=p(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-lkrnwe"&&(_.innerHTML=le),Rt=a(t),k=p(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1iabpjr"&&(k.innerHTML=ne),Vt=a(t),u(I.$$.fragment,t),Ft=a(t),G=p(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-hb5rtv"&&(G.innerHTML=ae),At=a(t),u(C.$$.fragment,t),Qt=a(t),u(v.$$.fragment,t),Lt=a(t),x=p(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1wueeet"&&(x.textContent=ie),St=a(t),u(X.$$.fragment,t),Ht=a(t),Z=p(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-zazh8y"&&(Z.innerHTML=pe),zt=a(t),q=p(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1lqz920"&&(q.innerHTML=oe),Pt=a(t),u(Y.$$.fragment,t),Ot=a(t),N=p(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1wueeet"&&(N.textContent=he),Dt=a(t),u(E.$$.fragment,t),Kt=a(t),W=p(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-15c2891"&&(W.textContent=ue),ts=a(t),u(R.$$.fragment,t),ss=a(t),V=p(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1wueeet"&&(V.textContent=re),es=a(t),u(F.$$.fragment,t),ls=a(t),A=p(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-13hfgx0"&&(A.textContent=Me),ns=a(t),u(Q.$$.fragment,t),as=a(t),L=p(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-xr84ar"&&(L.textContent=ce),is=a(t),S=p(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1m7y210"&&(S.textContent=ye),ps=a(t),H=p(t,"OL",{"data-svelte-h":!0}),o(H)!=="svelte-27sevg"&&(H.innerHTML=we),os=a(t),u(z.$$.fragment,t),hs=a(t),P=p(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-160hwoz"&&(P.textContent=je),us=a(t),u(O.$$.fragment,t),rs=a(t),D=p(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1bxqlg8"&&(D.textContent=me),Ms=a(t),u(K.$$.fragment,t),cs=a(t),tt=p(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-u9o4sn"&&(tt.textContent=de),ys=a(t),u(st.$$.fragment,t),ws=a(t),et=p(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-2islzy"&&(et.textContent=Te),js=a(t),u(lt.$$.fragment,t),ms=a(t),nt=p(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1wueeet"&&(nt.textContent=Je),ds=a(t),u(at.$$.fragment,t),Ts=a(t),it=p(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1u60rex"&&(it.textContent=fe),Js=a(t),u(pt.$$.fragment,t),fs=a(t),ot=p(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-6czrbs"&&(ot.textContent=be),bs=a(t),m=p(t,"BLOCKQUOTE",{});var Vs=Qs(m);_t=p(Vs,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-16ye1w0"&&(_t.textContent=Ue),As=a(Vs),u(ht.$$.fragment,Vs),Vs.forEach(e),Us=a(t),ut=p(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1yqfqub"&&(ut.textContent=ge),gs=a(t),u(rt.$$.fragment,t),Bs=a(t),Mt=p(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-ui9i8k"&&(Mt.textContent=Be),$s=a(t),u(ct.$$.fragment,t),_s=a(t),yt=p(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1s2rtg2"&&(yt.textContent=$e),ks=a(t),u(wt.$$.fragment,t),Is=a(t),jt=p(t,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-1wueeet"&&(jt.textContent=_e),Gs=a(t),u(mt.$$.fragment,t),Cs=a(t),dt=p(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-167b27o"&&(dt.textContent=ke),vs=a(t),u(Tt.$$.fragment,t),xs=a(t),Jt=p(t,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-smcbfz"&&(Jt.textContent=Ie),Xs=a(t),u(ft.$$.fragment,t),Zs=a(t),bt=p(t,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1i7u2e4"&&(bt.textContent=Ge),qs=a(t),u(Ut.$$.fragment,t),Ys=a(t),gt=p(t,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1wueeet"&&(gt.textContent=Ce),Ns=a(t),u(Bt.$$.fragment,t),Es=a(t),u($t.$$.fragment,t),Ws=a(t),It=p(t,"P",{}),Qs(It).forEach(e),this.h()},h(){Fs(j,"name","hf:doc:metadata"),Fs(j,"content",Re),xe(T.src,zs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-unit1sub3DONE.jpg")||Fs(T,"src",zs),Fs(T,"alt","Unit 1 planning")},m(t,s){Ls(document.head,j),l(t,Gt,s),l(t,kt,s),l(t,Ct,s),r(d,t,s),l(t,vt,s),l(t,T,s),l(t,xt,s),l(t,J,s),l(t,Xt,s),l(t,f,s),l(t,Zt,s),l(t,b,s),l(t,qt,s),l(t,U,s),l(t,Yt,s),l(t,g,s),l(t,Nt,s),l(t,B,s),l(t,Et,s),l(t,$,s),l(t,Wt,s),l(t,_,s),l(t,Rt,s),l(t,k,s),l(t,Vt,s),r(I,t,s),l(t,Ft,s),l(t,G,s),l(t,At,s),r(C,t,s),l(t,Qt,s),r(v,t,s),l(t,Lt,s),l(t,x,s),l(t,St,s),r(X,t,s),l(t,Ht,s),l(t,Z,s),l(t,zt,s),l(t,q,s),l(t,Pt,s),r(Y,t,s),l(t,Ot,s),l(t,N,s),l(t,Dt,s),r(E,t,s),l(t,Kt,s),l(t,W,s),l(t,ts,s),r(R,t,s),l(t,ss,s),l(t,V,s),l(t,es,s),r(F,t,s),l(t,ls,s),l(t,A,s),l(t,ns,s),r(Q,t,s),l(t,as,s),l(t,L,s),l(t,is,s),l(t,S,s),l(t,ps,s),l(t,H,s),l(t,os,s),r(z,t,s),l(t,hs,s),l(t,P,s),l(t,us,s),r(O,t,s),l(t,rs,s),l(t,D,s),l(t,Ms,s),r(K,t,s),l(t,cs,s),l(t,tt,s),l(t,ys,s),r(st,t,s),l(t,ws,s),l(t,et,s),l(t,js,s),r(lt,t,s),l(t,ms,s),l(t,nt,s),l(t,ds,s),r(at,t,s),l(t,Ts,s),l(t,it,s),l(t,Js,s),r(pt,t,s),l(t,fs,s),l(t,ot,s),l(t,bs,s),l(t,m,s),Ls(m,_t),Ls(m,As),r(ht,m,null),l(t,Us,s),l(t,ut,s),l(t,gs,s),r(rt,t,s),l(t,Bs,s),l(t,Mt,s),l(t,$s,s),r(ct,t,s),l(t,_s,s),l(t,yt,s),l(t,ks,s),r(wt,t,s),l(t,Is,s),l(t,jt,s),l(t,Gs,s),r(mt,t,s),l(t,Cs,s),l(t,dt,s),l(t,vs,s),r(Tt,t,s),l(t,xs,s),l(t,Jt,s),l(t,Xs,s),r(ft,t,s),l(t,Zs,s),l(t,bt,s),l(t,qs,s),r(Ut,t,s),l(t,Ys,s),l(t,gt,s),l(t,Ns,s),r(Bt,t,s),l(t,Es,s),r($t,t,s),l(t,Ws,s),l(t,It,s),Rs=!0},p:Xe,i(t){Rs||(M(d.$$.fragment,t),M(I.$$.fragment,t),M(C.$$.fragment,t),M(v.$$.fragment,t),M(X.$$.fragment,t),M(Y.$$.fragment,t),M(E.$$.fragment,t),M(R.$$.fragment,t),M(F.$$.fragment,t),M(Q.$$.fragment,t),M(z.$$.fragment,t),M(O.$$.fragment,t),M(K.$$.fragment,t),M(st.$$.fragment,t),M(lt.$$.fragment,t),M(at.$$.fragment,t),M(pt.$$.fragment,t),M(ht.$$.fragment,t),M(rt.$$.fragment,t),M(ct.$$.fragment,t),M(wt.$$.fragment,t),M(mt.$$.fragment,t),M(Tt.$$.fragment,t),M(ft.$$.fragment,t),M(Ut.$$.fragment,t),M(Bt.$$.fragment,t),M($t.$$.fragment,t),Rs=!0)},o(t){c(d.$$.fragment,t),c(I.$$.fragment,t),c(C.$$.fragment,t),c(v.$$.fragment,t),c(X.$$.fragment,t),c(Y.$$.fragment,t),c(E.$$.fragment,t),c(R.$$.fragment,t),c(F.$$.fragment,t),c(Q.$$.fragment,t),c(z.$$.fragment,t),c(O.$$.fragment,t),c(K.$$.fragment,t),c(st.$$.fragment,t),c(lt.$$.fragment,t),c(at.$$.fragment,t),c(pt.$$.fragment,t),c(ht.$$.fragment,t),c(rt.$$.fragment,t),c(ct.$$.fragment,t),c(wt.$$.fragment,t),c(mt.$$.fragment,t),c(Tt.$$.fragment,t),c(ft.$$.fragment,t),c(Ut.$$.fragment,t),c(Bt.$$.fragment,t),c($t.$$.fragment,t),Rs=!1},d(t){t&&(e(Gt),e(kt),e(Ct),e(vt),e(T),e(xt),e(J),e(Xt),e(f),e(Zt),e(b),e(qt),e(U),e(Yt),e(g),e(Nt),e(B),e(Et),e($),e(Wt),e(_),e(Rt),e(k),e(Vt),e(Ft),e(G),e(At),e(Qt),e(Lt),e(x),e(St),e(Ht),e(Z),e(zt),e(q),e(Pt),e(Ot),e(N),e(Dt),e(Kt),e(W),e(ts),e(ss),e(V),e(es),e(ls),e(A),e(ns),e(as),e(L),e(is),e(S),e(ps),e(H),e(os),e(hs),e(P),e(us),e(rs),e(D),e(Ms),e(cs),e(tt),e(ys),e(ws),e(et),e(js),e(ms),e(nt),e(ds),e(Ts),e(it),e(Js),e(fs),e(ot),e(bs),e(m),e(Us),e(ut),e(gs),e(Bs),e(Mt),e($s),e(_s),e(yt),e(ks),e(Is),e(jt),e(Gs),e(Cs),e(dt),e(vs),e(xs),e(Jt),e(Xs),e(Zs),e(bt),e(qs),e(Ys),e(gt),e(Ns),e(Es),e(Ws),e(It)),e(j),y(d,t),y(I,t),y(C,t),y(v,t),y(X,t),y(Y,t),y(E,t),y(R,t),y(F,t),y(Q,t),y(z,t),y(O,t),y(K,t),y(st,t),y(lt,t),y(at,t),y(pt,t),y(ht),y(rt,t),y(ct,t),y(wt,t),y(mt,t),y(Tt,t),y(ft,t),y(Ut,t),y(Bt,t),y($t,t)}}}const Re='{"title":"Dummy Agent Library","local":"dummy-agent-library","sections":[{"title":"Serverless API","local":"serverless-api","sections":[],"depth":2},{"title":"Dummy Agent","local":"dummy-agent","sections":[],"depth":2}],"depth":1}';function Ve(Hs){return Ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class He extends qe{constructor(j){super(),Ye(this,j,Ve,We,ve,{})}}export{He as component};
