import{s as Pl,o as Dl,n as Je}from"../chunks/scheduler.8c3d61f6.js";import{S as Kl,i as Ol,g as o,s as a,r as u,A as et,h as r,f as t,c as i,j as Ll,u as d,x as m,k as ql,y as lt,a as s,v as f,d as y,t as h,w}from"../chunks/index.589a98e8.js";import{T as we}from"../chunks/Tip.42aa8582.js";import{C as v}from"../chunks/CodeBlock.36627b28.js";import{H as B,E as tt}from"../chunks/EditOnGithub.e5a8d9cb.js";function st(U){let n,J='In many cases, optimizing for memory or speed leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on minimizing memory usage, but you can also learn more about how to <a href="fp16">Speed up inference</a>.';return{c(){n=o("p"),n.innerHTML=J},l(p){n=r(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-15lbm2y"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&t(n)}}}function nt(U){let n,J='Consider using <a href="#model-offloading">model offloading</a> if you want to optimize for speed because it is much faster. The tradeoff is your memory savings won’t be as large.';return{c(){n=o("p"),n.innerHTML=J},l(p){n=r(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-1yyrc0t"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&t(n)}}}function at(U){let n,J='When using <a href="/docs/diffusers/pr_7830/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, don’t move the pipeline to CUDA beforehand or else the gain in memory consumption will only be minimal (see this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more information).',p,c,j='<a href="/docs/diffusers/pr_7830/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> is a stateful operation that installs hooks on the models.';return{c(){n=o("p"),n.innerHTML=J,p=a(),c=o("p"),c.innerHTML=j},l(M){n=r(M,"P",{"data-svelte-h":!0}),m(n)!=="svelte-1d2vyzq"&&(n.innerHTML=J),p=i(M),c=r(M,"P",{"data-svelte-h":!0}),m(c)!=="svelte-2tg3xt"&&(c.innerHTML=j)},m(M,T){s(M,n,T),s(M,p,T),s(M,c,T)},p:Je,d(M){M&&(t(n),t(p),t(c))}}}function it(U){let n,J="Model offloading requires 🤗 Accelerate version 0.17.0 or higher.";return{c(){n=o("p"),n.textContent=J},l(p){n=r(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-1guxtqy"&&(n.textContent=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&t(n)}}}function pt(U){let n,J='In order to properly offload models after they’re called, it is required to run the entire pipeline and models are called in the pipeline’s expected order. Exercise caution if models are reused outside the context of the pipeline after hooks have been installed. See <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a> for more information.',p,c,j='<a href="/docs/diffusers/pr_7830/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> is a stateful operation that installs hooks on the models and state on the pipeline.';return{c(){n=o("p"),n.innerHTML=J,p=a(),c=o("p"),c.innerHTML=j},l(M){n=r(M,"P",{"data-svelte-h":!0}),m(n)!=="svelte-bljvwk"&&(n.innerHTML=J),p=i(M),c=r(M,"P",{"data-svelte-h":!0}),m(c)!=="svelte-19mcmrh"&&(c.innerHTML=j)},m(M,T){s(M,n,T),s(M,p,T),s(M,c,T)},p:Je,d(M){M&&(t(n),t(p),t(c))}}}function ot(U){let n,J="If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling <code>xformers</code>.";return{c(){n=o("p"),n.innerHTML=J},l(p){n=r(p,"P",{"data-svelte-h":!0}),m(n)!=="svelte-17vr965"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&t(n)}}}function rt(U){let n,J,p,c,j,M,T,yl="A barrier to using diffusion models is the large amount of memory required. To overcome this challenge, there are several memory-reducing techniques you can use to run even some of the largest models on free-tier or consumer GPUs. Some of these techniques can even be combined to further reduce memory usage.",Ue,b,je,G,hl="The results below are obtained from generating a single 512x512 image from the prompt a photo of an astronaut riding a horse on mars with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect as a result of reduced memory consumption.",be,$,wl="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory-efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",Ze,V,_e,W,Jl='Sliced VAE enables decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time. You’ll likely want to couple this with <a href="/docs/diffusers/pr_7830/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',Ce,E,Tl='To use sliced VAE, call <a href="/docs/diffusers/pr_7830/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_slicing">enable_vae_slicing()</a> on your pipeline before inference:',ge,R,Ie,k,Ul="You may see a small performance boost in VAE decoding on multi-image batches, and there should be no performance impact on single-image batches.",ve,X,Be,S,jl='Tiled VAE processing also enables working with large images on limited VRAM (for example, generating 4k images on 8GB of VRAM) by splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image. You should also used tiled VAE with <a href="/docs/diffusers/pr_7830/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',Ge,N,bl='To use tiled VAE processing, call <a href="/docs/diffusers/pr_7830/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_tiling">enable_vae_tiling()</a> on your pipeline before inference:',$e,H,Ve,Q,Zl="The output image has some tile-to-tile tone variation because the tiles are decoded separately, but you shouldn’t see any sharp and obvious seams between the tiles. Tiling is turned off for images that are 512x512 or smaller.",We,A,Ee,x,_l="Offloading the weights to the CPU and only loading them on the GPU when performing the forward pass can also save memory. Often, this technique can reduce memory consumption to less than 3GB.",Re,Y,Cl='To perform CPU offloading, call <a href="/docs/diffusers/pr_7830/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>:',ke,F,Xe,z,gl="CPU offloading works on submodules rather than whole models. This is the best way to minimize memory consumption, but inference is much slower due to the iterative nature of the diffusion process. The UNet component of the pipeline runs several times (as many as <code>num_inference_steps</code>); each time, the different UNet submodules are sequentially onloaded and offloaded as needed, resulting in a large number of memory transfers.",Se,Z,Ne,_,He,L,Qe,C,Ae,q,Il='<a href="#cpu-offloading">Sequential CPU offloading</a> preserves a lot of memory but it makes inference slower because submodules are moved to GPU as needed, and they’re immediately returned to the CPU when a new module runs.',xe,P,vl="Full-model offloading is an alternative that moves whole models to the GPU, instead of handling each model’s constituent <em>submodules</em>. There is a negligible impact on inference time (compared with moving the pipeline to <code>cuda</code>), and it still provides some memory savings.",Ye,D,Bl=`During model offloading, only one of the main components of the pipeline (typically the text encoder, UNet and VAE)
is placed on the GPU while the others wait on the CPU. Components like the UNet that run for multiple iterations stay on the GPU until they’re no longer needed.`,Fe,K,Gl='Enable model offloading by calling <a href="/docs/diffusers/pr_7830/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on the pipeline:',ze,O,Le,g,qe,ee,Pe,le,$l="The channels-last memory format is an alternative way of ordering NCHW tensors in memory to preserve dimension ordering. Channels-last tensors are ordered in such a way that the channels become the densest dimension (storing images pixel-per-pixel). Since not all operators currently support the channels-last format, it may result in worst performance but you should still try and see if it works for your model.",De,te,Vl="For example, to set the pipeline’s UNet to use the channels-last format:",Ke,se,Oe,ne,el,ae,Wl="Tracing runs an example input tensor through the model and captures the operations that are performed on it as that input makes its way through the model’s layers. The executable or <code>ScriptFunction</code> that is returned is optimized with just-in-time compilation.",ll,ie,El="To trace a UNet:",tl,pe,sl,oe,Rl="Replace the <code>unet</code> attribute of the pipeline with the traced model:",nl,re,al,me,il,ce,kl='Recent work on optimizing bandwidth in the attention block has generated huge speed-ups and reductions in GPU memory usage. The most recent type of memory-efficient attention is <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention</a> (you can check out the original code at <a href="https://github.com/HazyResearch/flash-attention" rel="nofollow">HazyResearch/flash-attention</a>).',pl,I,ol,Me,Xl="To use Flash Attention, install the following:",rl,ue,Sl='<li>PyTorch &gt; 1.12</li> <li>CUDA available</li> <li><a href="xformers">xFormers</a></li>',ml,de,Nl='Then call <a href="/docs/diffusers/pr_7830/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on the pipeline:',cl,fe,Ml,ye,Hl='The iteration speed when using <code>xformers</code> should match the iteration speed of PyTorch 2.0 as described <a href="torch2.0">here</a>.',ul,he,dl,Te,fl;return j=new B({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h1"}}),b=new we({props:{$$slots:{default:[st]},$$scope:{ctx:U}}}),V=new B({props:{title:"Sliced VAE",local:"sliced-vae",headingTag:"h2"}}),R=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTIzcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDMyKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_vae_slicing()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>
images = pipe([prompt] * <span class="hljs-number">32</span>).images`,wrap:!1}}),X=new B({props:{title:"Tiled VAE",local:"tiled-vae",headingTag:"h2"}}),H=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJlYXV0aWZ1bCUyMGxhbmRzY2FwZSUyMHBob3RvZ3JhcGglMjIlMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMjNwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyQyUyMHdpZHRoJTNEMzg0MCUyQyUyMGhlaWdodCUzRDIyMjQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a beautiful landscape photograph&quot;</span>
pipe.enable_vae_tiling()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>

image = pipe([prompt], width=<span class="hljs-number">3840</span>, height=<span class="hljs-number">2224</span>, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),A=new B({props:{title:"CPU offloading",local:"cpu-offloading",headingTag:"h2"}}),F=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZCgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_sequential_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Z=new we({props:{$$slots:{default:[nt]},$$scope:{ctx:U}}}),_=new we({props:{warning:!0,$$slots:{default:[at]},$$scope:{ctx:U}}}),L=new B({props:{title:"Model offloading",local:"model-offloading",headingTag:"h2"}}),C=new we({props:{$$slots:{default:[it]},$$scope:{ctx:U}}}),O=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_model_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),g=new we({props:{warning:!0,$$slots:{default:[pt]},$$scope:{ctx:U}}}),ee=new B({props:{title:"Channels-last memory format",local:"channels-last-memory-format",headingTag:"h2"}}),se=new v({props:{code:"cHJpbnQocGlwZS51bmV0LmNvbnZfb3V0LnN0YXRlX2RpY3QoKSU1QiUyMndlaWdodCUyMiU1RC5zdHJpZGUoKSklMjAlMjAlMjMlMjAoMjg4MCUyQyUyMDklMkMlMjAzJTJDJTIwMSklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTIwJTIwJTIzJTIwaW4tcGxhY2UlMjBvcGVyYXRpb24lMEFwcmludCglMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipe.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`,wrap:!1}}),ne=new B({props:{title:"Tracing",local:"tracing",headingTag:"h2"}}),pe=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>


<span class="hljs-comment"># load inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    timestep = torch.rand(<span class="hljs-number">1</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16) * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipe.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)


<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)


<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`,wrap:!1}}),re=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLlRlbnNvciUwQSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMHVzZSUyMGppdHRlZCUyMHVuZXQlMEF1bmV0X3RyYWNlZCUyMCUzRCUyMHRvcmNoLmppdC5sb2FkKCUyMnVuZXRfdHJhY2VkLnB0JTIyKSUwQSUwQSUwQSUyMyUyMGRlbCUyMHBpcGUudW5ldCUwQWNsYXNzJTIwVHJhY2VkVU5ldCh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmluX2NoYW5uZWxzJTIwJTNEJTIwcGlwZS51bmV0LmNvbmZpZy5pbl9jaGFubmVscyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGV2aWNlJTIwJTNEJTIwcGlwZS51bmV0LmRldmljZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHQlMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2FtcGxlJTIwJTNEJTIwdW5ldF90cmFjZWQobGF0ZW50X21vZGVsX2lucHV0JTJDJTIwdCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyklNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwVU5ldDJEQ29uZGl0aW9uT3V0cHV0KHNhbXBsZSUzRHNhbXBsZSklMEElMEElMEFwaXBlLnVuZXQlMjAlM0QlMjBUcmFjZWRVTmV0KCklMEElMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZSglNUJwcm9tcHQlNUQlMjAqJTIwMSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.Tensor


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)


<span class="hljs-comment"># del pipe.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.config.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)


pipe.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),me=new B({props:{title:"Memory-efficient attention",local:"memory-efficient-attention",headingTag:"h2"}}),I=new we({props:{$$slots:{default:[ot]},$$scope:{ctx:U}}}),fe=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBzYW1wbGUlMjAlM0QlMjBwaXBlKCUyMmElMjBzbWFsbCUyMGNhdCUyMiklMEElMEElMjMlMjBvcHRpb25hbCUzQSUyMFlvdSUyMGNhbiUyMGRpc2FibGUlMjBpdCUyMHZpYSUwQSUyMyUyMHBpcGUuZGlzYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-keyword">with</span> torch.inference_mode():
    sample = pipe(<span class="hljs-string">&quot;a small cat&quot;</span>)

<span class="hljs-comment"># optional: You can disable it via</span>
<span class="hljs-comment"># pipe.disable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),he=new tt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/memory.md"}}),{c(){n=o("meta"),J=a(),p=o("p"),c=a(),u(j.$$.fragment),M=a(),T=o("p"),T.textContent=yl,Ue=a(),u(b.$$.fragment),je=a(),G=o("p"),G.textContent=hl,be=a(),$=o("table"),$.innerHTML=wl,Ze=a(),u(V.$$.fragment),_e=a(),W=o("p"),W.innerHTML=Jl,Ce=a(),E=o("p"),E.innerHTML=Tl,ge=a(),u(R.$$.fragment),Ie=a(),k=o("p"),k.textContent=Ul,ve=a(),u(X.$$.fragment),Be=a(),S=o("p"),S.innerHTML=jl,Ge=a(),N=o("p"),N.innerHTML=bl,$e=a(),u(H.$$.fragment),Ve=a(),Q=o("p"),Q.textContent=Zl,We=a(),u(A.$$.fragment),Ee=a(),x=o("p"),x.textContent=_l,Re=a(),Y=o("p"),Y.innerHTML=Cl,ke=a(),u(F.$$.fragment),Xe=a(),z=o("p"),z.innerHTML=gl,Se=a(),u(Z.$$.fragment),Ne=a(),u(_.$$.fragment),He=a(),u(L.$$.fragment),Qe=a(),u(C.$$.fragment),Ae=a(),q=o("p"),q.innerHTML=Il,xe=a(),P=o("p"),P.innerHTML=vl,Ye=a(),D=o("p"),D.textContent=Bl,Fe=a(),K=o("p"),K.innerHTML=Gl,ze=a(),u(O.$$.fragment),Le=a(),u(g.$$.fragment),qe=a(),u(ee.$$.fragment),Pe=a(),le=o("p"),le.textContent=$l,De=a(),te=o("p"),te.textContent=Vl,Ke=a(),u(se.$$.fragment),Oe=a(),u(ne.$$.fragment),el=a(),ae=o("p"),ae.innerHTML=Wl,ll=a(),ie=o("p"),ie.textContent=El,tl=a(),u(pe.$$.fragment),sl=a(),oe=o("p"),oe.innerHTML=Rl,nl=a(),u(re.$$.fragment),al=a(),u(me.$$.fragment),il=a(),ce=o("p"),ce.innerHTML=kl,pl=a(),u(I.$$.fragment),ol=a(),Me=o("p"),Me.textContent=Xl,rl=a(),ue=o("ul"),ue.innerHTML=Sl,ml=a(),de=o("p"),de.innerHTML=Nl,cl=a(),u(fe.$$.fragment),Ml=a(),ye=o("p"),ye.innerHTML=Hl,ul=a(),u(he.$$.fragment),dl=a(),Te=o("p"),this.h()},l(e){const l=et("svelte-u9bgzb",document.head);n=r(l,"META",{name:!0,content:!0}),l.forEach(t),J=i(e),p=r(e,"P",{}),Ll(p).forEach(t),c=i(e),d(j.$$.fragment,e),M=i(e),T=r(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-18ag1qn"&&(T.textContent=yl),Ue=i(e),d(b.$$.fragment,e),je=i(e),G=r(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1nfsyhf"&&(G.textContent=hl),be=i(e),$=r(e,"TABLE",{"data-svelte-h":!0}),m($)!=="svelte-qiiy0g"&&($.innerHTML=wl),Ze=i(e),d(V.$$.fragment,e),_e=i(e),W=r(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1lcrbq4"&&(W.innerHTML=Jl),Ce=i(e),E=r(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-abqvyf"&&(E.innerHTML=Tl),ge=i(e),d(R.$$.fragment,e),Ie=i(e),k=r(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-fte8mn"&&(k.textContent=Ul),ve=i(e),d(X.$$.fragment,e),Be=i(e),S=r(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1pj5jct"&&(S.innerHTML=jl),Ge=i(e),N=r(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1oe4pci"&&(N.innerHTML=bl),$e=i(e),d(H.$$.fragment,e),Ve=i(e),Q=r(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-nyzaca"&&(Q.textContent=Zl),We=i(e),d(A.$$.fragment,e),Ee=i(e),x=r(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-435lli"&&(x.textContent=_l),Re=i(e),Y=r(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-15e51tt"&&(Y.innerHTML=Cl),ke=i(e),d(F.$$.fragment,e),Xe=i(e),z=r(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-153k8wf"&&(z.innerHTML=gl),Se=i(e),d(Z.$$.fragment,e),Ne=i(e),d(_.$$.fragment,e),He=i(e),d(L.$$.fragment,e),Qe=i(e),d(C.$$.fragment,e),Ae=i(e),q=r(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1w0xgx8"&&(q.innerHTML=Il),xe=i(e),P=r(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-nislc4"&&(P.innerHTML=vl),Ye=i(e),D=r(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-11gjm3"&&(D.textContent=Bl),Fe=i(e),K=r(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-rpvhbm"&&(K.innerHTML=Gl),ze=i(e),d(O.$$.fragment,e),Le=i(e),d(g.$$.fragment,e),qe=i(e),d(ee.$$.fragment,e),Pe=i(e),le=r(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-sky5la"&&(le.textContent=$l),De=i(e),te=r(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-mhdc10"&&(te.textContent=Vl),Ke=i(e),d(se.$$.fragment,e),Oe=i(e),d(ne.$$.fragment,e),el=i(e),ae=r(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1hj6sqj"&&(ae.innerHTML=Wl),ll=i(e),ie=r(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1ca1ko1"&&(ie.textContent=El),tl=i(e),d(pe.$$.fragment,e),sl=i(e),oe=r(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-mpebhd"&&(oe.innerHTML=Rl),nl=i(e),d(re.$$.fragment,e),al=i(e),d(me.$$.fragment,e),il=i(e),ce=r(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1tu2ji2"&&(ce.innerHTML=kl),pl=i(e),d(I.$$.fragment,e),ol=i(e),Me=r(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-rpfoyf"&&(Me.textContent=Xl),rl=i(e),ue=r(e,"UL",{"data-svelte-h":!0}),m(ue)!=="svelte-1q6gndt"&&(ue.innerHTML=Sl),ml=i(e),de=r(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1me6yhr"&&(de.innerHTML=Nl),cl=i(e),d(fe.$$.fragment,e),Ml=i(e),ye=r(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1nf2kxh"&&(ye.innerHTML=Hl),ul=i(e),d(he.$$.fragment,e),dl=i(e),Te=r(e,"P",{}),Ll(Te).forEach(t),this.h()},h(){ql(n,"name","hf:doc:metadata"),ql(n,"content",mt)},m(e,l){lt(document.head,n),s(e,J,l),s(e,p,l),s(e,c,l),f(j,e,l),s(e,M,l),s(e,T,l),s(e,Ue,l),f(b,e,l),s(e,je,l),s(e,G,l),s(e,be,l),s(e,$,l),s(e,Ze,l),f(V,e,l),s(e,_e,l),s(e,W,l),s(e,Ce,l),s(e,E,l),s(e,ge,l),f(R,e,l),s(e,Ie,l),s(e,k,l),s(e,ve,l),f(X,e,l),s(e,Be,l),s(e,S,l),s(e,Ge,l),s(e,N,l),s(e,$e,l),f(H,e,l),s(e,Ve,l),s(e,Q,l),s(e,We,l),f(A,e,l),s(e,Ee,l),s(e,x,l),s(e,Re,l),s(e,Y,l),s(e,ke,l),f(F,e,l),s(e,Xe,l),s(e,z,l),s(e,Se,l),f(Z,e,l),s(e,Ne,l),f(_,e,l),s(e,He,l),f(L,e,l),s(e,Qe,l),f(C,e,l),s(e,Ae,l),s(e,q,l),s(e,xe,l),s(e,P,l),s(e,Ye,l),s(e,D,l),s(e,Fe,l),s(e,K,l),s(e,ze,l),f(O,e,l),s(e,Le,l),f(g,e,l),s(e,qe,l),f(ee,e,l),s(e,Pe,l),s(e,le,l),s(e,De,l),s(e,te,l),s(e,Ke,l),f(se,e,l),s(e,Oe,l),f(ne,e,l),s(e,el,l),s(e,ae,l),s(e,ll,l),s(e,ie,l),s(e,tl,l),f(pe,e,l),s(e,sl,l),s(e,oe,l),s(e,nl,l),f(re,e,l),s(e,al,l),f(me,e,l),s(e,il,l),s(e,ce,l),s(e,pl,l),f(I,e,l),s(e,ol,l),s(e,Me,l),s(e,rl,l),s(e,ue,l),s(e,ml,l),s(e,de,l),s(e,cl,l),f(fe,e,l),s(e,Ml,l),s(e,ye,l),s(e,ul,l),f(he,e,l),s(e,dl,l),s(e,Te,l),fl=!0},p(e,[l]){const Ql={};l&2&&(Ql.$$scope={dirty:l,ctx:e}),b.$set(Ql);const Al={};l&2&&(Al.$$scope={dirty:l,ctx:e}),Z.$set(Al);const xl={};l&2&&(xl.$$scope={dirty:l,ctx:e}),_.$set(xl);const Yl={};l&2&&(Yl.$$scope={dirty:l,ctx:e}),C.$set(Yl);const Fl={};l&2&&(Fl.$$scope={dirty:l,ctx:e}),g.$set(Fl);const zl={};l&2&&(zl.$$scope={dirty:l,ctx:e}),I.$set(zl)},i(e){fl||(y(j.$$.fragment,e),y(b.$$.fragment,e),y(V.$$.fragment,e),y(R.$$.fragment,e),y(X.$$.fragment,e),y(H.$$.fragment,e),y(A.$$.fragment,e),y(F.$$.fragment,e),y(Z.$$.fragment,e),y(_.$$.fragment,e),y(L.$$.fragment,e),y(C.$$.fragment,e),y(O.$$.fragment,e),y(g.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(me.$$.fragment,e),y(I.$$.fragment,e),y(fe.$$.fragment,e),y(he.$$.fragment,e),fl=!0)},o(e){h(j.$$.fragment,e),h(b.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(F.$$.fragment,e),h(Z.$$.fragment,e),h(_.$$.fragment,e),h(L.$$.fragment,e),h(C.$$.fragment,e),h(O.$$.fragment,e),h(g.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(re.$$.fragment,e),h(me.$$.fragment,e),h(I.$$.fragment,e),h(fe.$$.fragment,e),h(he.$$.fragment,e),fl=!1},d(e){e&&(t(J),t(p),t(c),t(M),t(T),t(Ue),t(je),t(G),t(be),t($),t(Ze),t(_e),t(W),t(Ce),t(E),t(ge),t(Ie),t(k),t(ve),t(Be),t(S),t(Ge),t(N),t($e),t(Ve),t(Q),t(We),t(Ee),t(x),t(Re),t(Y),t(ke),t(Xe),t(z),t(Se),t(Ne),t(He),t(Qe),t(Ae),t(q),t(xe),t(P),t(Ye),t(D),t(Fe),t(K),t(ze),t(Le),t(qe),t(Pe),t(le),t(De),t(te),t(Ke),t(Oe),t(el),t(ae),t(ll),t(ie),t(tl),t(sl),t(oe),t(nl),t(al),t(il),t(ce),t(pl),t(ol),t(Me),t(rl),t(ue),t(ml),t(de),t(cl),t(Ml),t(ye),t(ul),t(dl),t(Te)),t(n),w(j,e),w(b,e),w(V,e),w(R,e),w(X,e),w(H,e),w(A,e),w(F,e),w(Z,e),w(_,e),w(L,e),w(C,e),w(O,e),w(g,e),w(ee,e),w(se,e),w(ne,e),w(pe,e),w(re,e),w(me,e),w(I,e),w(fe,e),w(he,e)}}}const mt='{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[{"title":"Sliced VAE","local":"sliced-vae","sections":[],"depth":2},{"title":"Tiled VAE","local":"tiled-vae","sections":[],"depth":2},{"title":"CPU offloading","local":"cpu-offloading","sections":[],"depth":2},{"title":"Model offloading","local":"model-offloading","sections":[],"depth":2},{"title":"Channels-last memory format","local":"channels-last-memory-format","sections":[],"depth":2},{"title":"Tracing","local":"tracing","sections":[],"depth":2},{"title":"Memory-efficient attention","local":"memory-efficient-attention","sections":[],"depth":2}],"depth":1}';function ct(U){return Dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ht extends Kl{constructor(n){super(),Ol(this,n,ct,rt,Pl,{})}}export{ht as component};
