import{s as Cd,n as bd,o as Pd}from"../chunks/scheduler.0219f8bd.js";import{S as Hd,i as wd,g as d,s as u,r as c,A as Md,h as o,f as i,c as r,j as n,u as p,x as s,k as a,y as Qd,a as l,v as f,d as m,t as h,w as T}from"../chunks/index.f61edf3b.js";import{H as $,E as Ad}from"../chunks/EditOnGithub.48fa589f.js";function Nd(sr){let _,Kt,It,jt,y,Dt,k,Ut,L,ar="Custom data structures.",Bt,v,nr=`These are only used internally, meaning an end-user shouldn’t
need to access anything here.`,St,x,cr='<li><a href="#module_utils/data-structures">utils/data-structures</a><ul><li><em>static</em><ul><li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+_siftUpFrom"><code>._siftUpFrom(node)</code></a></li></ul></li> <li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li> <li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array.&lt;string&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li> <li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li></ul></li></ul></li>',Ft,Gt,Ot,C,Vt,b,Wt,P,pr=`Efficient Heap-based Implementation of a Priority Queue.
It uses an array-based binary heap, where the root is at index <code>0</code>, and the
children of node <code>i</code> are located at indices <code>2i + 1</code> and <code>2i + 2</code>, respectively.`,Jt,H,fr="Adapted from the following sources:",Xt,w,mr='<li><a href="https://stackoverflow.com/a/42919752/13989043" rel="nofollow">https://stackoverflow.com/a/42919752/13989043</a> (original)</li> <li><a href="https://github.com/belladoreai/llama-tokenizer-js" rel="nofollow">https://github.com/belladoreai/llama-tokenizer-js</a> (minor improvements)</li>',Yt,M,hr='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Zt,Q,Tr='<li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+_siftUpFrom"><code>._siftUpFrom(node)</code></a></li></ul></li>',ei,ti,ii,A,li,N,ui,E,$r="Create a new PriorityQueue.",ri,q,_r="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>comparator</td><td><code>function</code></td><td><p>Comparator function to determine priority. Defaults to a MaxHeap.</p></td></tr></tbody>",di,oi,si,g,ai,R,ni,I,yr="The size of the queue",ci,z,kr='<strong>Kind</strong>: instance property of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a>',pi,fi,mi,K,hi,j,Ti,D,Lr="Check if the queue is empty.",$i,U,vr='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - <code>true</code> if the queue is empty, <code>false</code> otherwise.',_i,yi,ki,B,Li,S,vi,F,xr="Return the element with the highest priority in the queue.",xi,G,Cr='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The highest priority element in the queue.',Ci,bi,Pi,O,Hi,V,wi,W,br="Add one or more elements to the queue.",Mi,J,Pr='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',Qi,X,Hr="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...values</td><td><code>any</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",Ai,Ni,Ei,Y,qi,Z,gi,ee,wr="Add multiple elements to the queue.",Ri,te,Mr='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',Ii,ie,Qr="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>values</td><td><code>Array.&lt;any&gt;</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",zi,Ki,ji,le,Di,ue,Ui,re,Ar="Remove and return the element with the highest priority in the queue.",Bi,de,Nr='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The element with the highest priority in the queue.',Si,Fi,Gi,oe,Oi,se,Vi,ae,Er="Replace the element with the highest priority in the queue with a new value.",Wi,ne,qr='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>*</code> - The replaced value.',Ji,ce,gr="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>value</td><td><code>*</code></td><td><p>The new value.</p></td></tr></tbody>",Xi,Yi,Zi,pe,el,fe,tl,me,Rr="Helper function to sift up from a given node.",il,he,Ir='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a>',ll,Te,zr="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>node</td><td><code>number</code></td><td><p>The index of the node to start sifting up from.</p></td></tr></tbody>",ul,rl,dl,$e,ol,_e,sl,ye,Kr="A trie structure to efficiently store and search for strings.",al,ke,jr='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',nl,Le,Dr='<li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li>',cl,pl,fl,ve,ml,xe,hl,Ce,Ur="Adds one or more <code>texts</code> to the trie.",Tl,be,Br='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',$l,Pe,Sr="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;string&gt;</code></td><td><p>The strings to add to the trie.</p></td></tr></tbody>",_l,yl,kl,He,Ll,we,vl,Me,Fr="Adds text to the trie.",xl,Qe,Gr='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',Cl,Ae,Or="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The string to add to the trie.</p></td></tr></tbody>",bl,Pl,Hl,Ne,wl,Ee,Ml,qe,Vr="Searches the trie for all strings with a common prefix of <code>text</code>.",Ql,ge,Wr='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',Al,Re,Jr="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The common prefix to search for.</p></td></tr></tbody>",Nl,El,ql,Ie,gl,ze,Rl,Ke,Xr="A lattice data structure to be used for tokenization.",Il,je,Yr='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',zl,De,Zr='<li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array.&lt;string&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li></ul></li>',Kl,jl,Dl,Ue,Ul,Be,Bl,Se,ed="Creates a new TokenLattice instance.",Sl,Fe,td="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>sentence</td><td><code>string</code></td><td><p>The input sentence to be tokenized.</p></td> </tr><tr><td>bosTokenId</td><td><code>number</code></td><td><p>The beginning-of-sequence token ID.</p></td> </tr><tr><td>eosTokenId</td><td><code>number</code></td><td><p>The end-of-sequence token ID.</p></td></tr></tbody>",Fl,Gl,Ol,Ge,Vl,Oe,Wl,Ve,id="Inserts a new token node into the token lattice.",Jl,We,ld='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a>',Xl,Je,ud="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score of the token.</p></td> </tr><tr><td>tokenId</td><td><code>number</code></td><td><p>The token ID of the token.</p></td></tr></tbody>",Yl,Zl,eu,Xe,tu,Ye,iu,Ze,rd="Implements the Viterbi algorithm to compute the most likely sequence of tokens.",lu,et,dd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;TokenLatticeNode&gt;</code> - The most likely sequence of tokens.',uu,ru,du,tt,ou,it,su,lt,od='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>string</code> - The array of nodes representing the most likely sequence of tokens.',au,ut,sd="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>node</td><td><code>TokenLatticeNode</code></td></tr></tbody>",nu,cu,pu,rt,fu,dt,mu,ot,ad='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;string&gt;</code> - The most likely sequence of tokens.',hu,Tu,$u,st,_u,at,yu,nt,nd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The most likely sequence of token ids.',ku,Lu,vu,ct,xu,pt,Cu,ft,cd="Represents a node in a character trie.",bu,mt,pd='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Pu,ht,fd='<li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li>',Hu,wu,Mu,Tt,Qu,$t,Au,_t,md="Create a new CharTrieNode.",Nu,yt,hd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>isLeaf</td><td><code>boolean</code></td><td><p>Whether the node is a leaf node or not.</p></td> </tr><tr><td>children</td><td><code>Map.&lt;string, CharTrieNode&gt;</code></td><td><p>A map containing the node&#39;s children, where the key is a character and the value is a <code>CharTrieNode</code>.</p></td></tr></tbody>",Eu,qu,gu,kt,Ru,Lt,Iu,vt,Td="Returns a new <code>CharTrieNode</code> instance with default values.",zu,xt,$d='<strong>Kind</strong>: static method of <a href="#module_utils/data-structures..CharTrieNode"><code>CharTrieNode</code></a><br/> <strong>Returns</strong>: <code>CharTrieNode</code> - A new <code>CharTrieNode</code> instance with <code>isLeaf</code> set to <code>false</code> and an empty <code>children</code> map.',Ku,ju,Du,Ct,Uu,bt,Bu,Pt,_d='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Su,Ht,yd='<li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li>',Fu,Gu,Ou,wt,Vu,Mt,Wu,Qt,kd="Represents a node in a token lattice for a given sentence.",Ju,At,Ld="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tokenId</td><td><code>number</code></td><td><p>The ID of the token associated with this node.</p></td> </tr><tr><td>nodeId</td><td><code>number</code></td><td><p>The ID of this node.</p></td> </tr><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token in the sentence.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score associated with the token.</p></td></tr></tbody>",Xu,Yu,Zu,Nt,er,Et,tr,qt,vd="Returns a clone of this node.",ir,gt,xd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures..TokenLatticeNode"><code>TokenLatticeNode</code></a><br/> <strong>Returns</strong>: <code>TokenLatticeNode</code> - A clone of this node.',lr,ur,rr,Rt,dr,zt,or;return k=new $({props:{title:"utils/data-structures",local:"utilsdata-structures",headingTag:"h1"}}),b=new $({props:{title:"utils/data-structures.PriorityQueue",local:"utilsdata-structurespriorityqueue",headingTag:"h2"}}),N=new $({props:{title:"new PriorityQueue(comparator)",local:"new-priorityqueuecomparator",headingTag:"h3"}}),R=new $({props:{title:"priorityQueue.size",local:"priorityqueuesize",headingTag:"h3"}}),j=new $({props:{title:"priorityQueue.isEmpty() ⇒ <code> boolean </code>",local:"priorityqueueisempty--code-boolean-code",headingTag:"h3"}}),S=new $({props:{title:"priorityQueue.peek() ⇒ <code> any </code>",local:"priorityqueuepeek--code-any-code",headingTag:"h3"}}),V=new $({props:{title:"priorityQueue.push(...values) ⇒ <code> number </code>",local:"priorityqueuepushvalues--code-number-code",headingTag:"h3"}}),Z=new $({props:{title:"priorityQueue.extend(values) ⇒ <code> number </code>",local:"priorityqueueextendvalues--code-number-code",headingTag:"h3"}}),ue=new $({props:{title:"priorityQueue.pop() ⇒ <code> any </code>",local:"priorityqueuepop--code-any-code",headingTag:"h3"}}),se=new $({props:{title:"priorityQueue.replace(value) ⇒ <code> * </code>",local:"priorityqueuereplacevalue--code--code",headingTag:"h3"}}),fe=new $({props:{title:"priorityQueue._siftUpFrom(node)",local:"priorityqueuesiftupfromnode",headingTag:"h3"}}),_e=new $({props:{title:"utils/data-structures.CharTrie",local:"utilsdata-structureschartrie",headingTag:"h2"}}),xe=new $({props:{title:"charTrie.extend(texts)",local:"chartrieextendtexts",headingTag:"h3"}}),we=new $({props:{title:"charTrie.push(text)",local:"chartriepushtext",headingTag:"h3"}}),Ee=new $({props:{title:"charTrie.commonPrefixSearch(text)",local:"chartriecommonprefixsearchtext",headingTag:"h3"}}),ze=new $({props:{title:"utils/data-structures.TokenLattice",local:"utilsdata-structurestokenlattice",headingTag:"h2"}}),Be=new $({props:{title:"new TokenLattice(sentence, bosTokenId, eosTokenId)",local:"new-tokenlatticesentence-bostokenid-eostokenid",headingTag:"h3"}}),Oe=new $({props:{title:"tokenLattice.insert(pos, length, score, tokenId)",local:"tokenlatticeinsertpos-length-score-tokenid",headingTag:"h3"}}),Ye=new $({props:{title:"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>",local:"tokenlatticeviterbi--code-array--tokenlatticenode--code",headingTag:"h3"}}),it=new $({props:{title:"tokenLattice.piece(node) ⇒ <code> string </code>",local:"tokenlatticepiecenode--code-string-code",headingTag:"h3"}}),dt=new $({props:{title:"tokenLattice.tokens() ⇒ <code> Array. < string > </code>",local:"tokenlatticetokens--code-array--string--code",headingTag:"h3"}}),at=new $({props:{title:"tokenLattice.tokenIds() ⇒ <code> Array. < number > </code>",local:"tokenlatticetokenids--code-array--number--code",headingTag:"h3"}}),pt=new $({props:{title:"utils/data-structures~CharTrieNode",local:"utilsdata-structureschartrienode",headingTag:"h2"}}),$t=new $({props:{title:"new CharTrieNode(isLeaf, children)",local:"new-chartrienodeisleaf-children",headingTag:"h3"}}),Lt=new $({props:{title:"CharTrieNode.default() ⇒ <code> CharTrieNode </code>",local:"chartrienodedefault--code-chartrienode-code",headingTag:"h3"}}),bt=new $({props:{title:"utils/data-structures~TokenLatticeNode",local:"utilsdata-structurestokenlatticenode",headingTag:"h2"}}),Mt=new $({props:{title:"new TokenLatticeNode(tokenId, nodeId, pos, length, score)",local:"new-tokenlatticenodetokenid-nodeid-pos-length-score",headingTag:"h3"}}),Et=new $({props:{title:"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>",local:"tokenlatticenodeclone--code-tokenlatticenode-code",headingTag:"h3"}}),Rt=new Ad({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/data-structures.md"}}),{c(){_=d("meta"),Kt=u(),It=d("p"),jt=u(),y=d("a"),Dt=u(),c(k.$$.fragment),Ut=u(),L=d("p"),L.textContent=ar,Bt=u(),v=d("p"),v.textContent=nr,St=u(),x=d("ul"),x.innerHTML=cr,Ft=u(),Gt=d("hr"),Ot=u(),C=d("a"),Vt=u(),c(b.$$.fragment),Wt=u(),P=d("p"),P.innerHTML=pr,Jt=u(),H=d("p"),H.textContent=fr,Xt=u(),w=d("ul"),w.innerHTML=mr,Yt=u(),M=d("p"),M.innerHTML=hr,Zt=u(),Q=d("ul"),Q.innerHTML=Tr,ei=u(),ti=d("hr"),ii=u(),A=d("a"),li=u(),c(N.$$.fragment),ui=u(),E=d("p"),E.textContent=$r,ri=u(),q=d("table"),q.innerHTML=_r,di=u(),oi=d("hr"),si=u(),g=d("a"),ai=u(),c(R.$$.fragment),ni=u(),I=d("p"),I.textContent=yr,ci=u(),z=d("p"),z.innerHTML=kr,pi=u(),fi=d("hr"),mi=u(),K=d("a"),hi=u(),c(j.$$.fragment),Ti=u(),D=d("p"),D.textContent=Lr,$i=u(),U=d("p"),U.innerHTML=vr,_i=u(),yi=d("hr"),ki=u(),B=d("a"),Li=u(),c(S.$$.fragment),vi=u(),F=d("p"),F.textContent=xr,xi=u(),G=d("p"),G.innerHTML=Cr,Ci=u(),bi=d("hr"),Pi=u(),O=d("a"),Hi=u(),c(V.$$.fragment),wi=u(),W=d("p"),W.textContent=br,Mi=u(),J=d("p"),J.innerHTML=Pr,Qi=u(),X=d("table"),X.innerHTML=Hr,Ai=u(),Ni=d("hr"),Ei=u(),Y=d("a"),qi=u(),c(Z.$$.fragment),gi=u(),ee=d("p"),ee.textContent=wr,Ri=u(),te=d("p"),te.innerHTML=Mr,Ii=u(),ie=d("table"),ie.innerHTML=Qr,zi=u(),Ki=d("hr"),ji=u(),le=d("a"),Di=u(),c(ue.$$.fragment),Ui=u(),re=d("p"),re.textContent=Ar,Bi=u(),de=d("p"),de.innerHTML=Nr,Si=u(),Fi=d("hr"),Gi=u(),oe=d("a"),Oi=u(),c(se.$$.fragment),Vi=u(),ae=d("p"),ae.textContent=Er,Wi=u(),ne=d("p"),ne.innerHTML=qr,Ji=u(),ce=d("table"),ce.innerHTML=gr,Xi=u(),Yi=d("hr"),Zi=u(),pe=d("a"),el=u(),c(fe.$$.fragment),tl=u(),me=d("p"),me.textContent=Rr,il=u(),he=d("p"),he.innerHTML=Ir,ll=u(),Te=d("table"),Te.innerHTML=zr,ul=u(),rl=d("hr"),dl=u(),$e=d("a"),ol=u(),c(_e.$$.fragment),sl=u(),ye=d("p"),ye.textContent=Kr,al=u(),ke=d("p"),ke.innerHTML=jr,nl=u(),Le=d("ul"),Le.innerHTML=Dr,cl=u(),pl=d("hr"),fl=u(),ve=d("a"),ml=u(),c(xe.$$.fragment),hl=u(),Ce=d("p"),Ce.innerHTML=Ur,Tl=u(),be=d("p"),be.innerHTML=Br,$l=u(),Pe=d("table"),Pe.innerHTML=Sr,_l=u(),yl=d("hr"),kl=u(),He=d("a"),Ll=u(),c(we.$$.fragment),vl=u(),Me=d("p"),Me.textContent=Fr,xl=u(),Qe=d("p"),Qe.innerHTML=Gr,Cl=u(),Ae=d("table"),Ae.innerHTML=Or,bl=u(),Pl=d("hr"),Hl=u(),Ne=d("a"),wl=u(),c(Ee.$$.fragment),Ml=u(),qe=d("p"),qe.innerHTML=Vr,Ql=u(),ge=d("p"),ge.innerHTML=Wr,Al=u(),Re=d("table"),Re.innerHTML=Jr,Nl=u(),El=d("hr"),ql=u(),Ie=d("a"),gl=u(),c(ze.$$.fragment),Rl=u(),Ke=d("p"),Ke.textContent=Xr,Il=u(),je=d("p"),je.innerHTML=Yr,zl=u(),De=d("ul"),De.innerHTML=Zr,Kl=u(),jl=d("hr"),Dl=u(),Ue=d("a"),Ul=u(),c(Be.$$.fragment),Bl=u(),Se=d("p"),Se.textContent=ed,Sl=u(),Fe=d("table"),Fe.innerHTML=td,Fl=u(),Gl=d("hr"),Ol=u(),Ge=d("a"),Vl=u(),c(Oe.$$.fragment),Wl=u(),Ve=d("p"),Ve.textContent=id,Jl=u(),We=d("p"),We.innerHTML=ld,Xl=u(),Je=d("table"),Je.innerHTML=ud,Yl=u(),Zl=d("hr"),eu=u(),Xe=d("a"),tu=u(),c(Ye.$$.fragment),iu=u(),Ze=d("p"),Ze.textContent=rd,lu=u(),et=d("p"),et.innerHTML=dd,uu=u(),ru=d("hr"),du=u(),tt=d("a"),ou=u(),c(it.$$.fragment),su=u(),lt=d("p"),lt.innerHTML=od,au=u(),ut=d("table"),ut.innerHTML=sd,nu=u(),cu=d("hr"),pu=u(),rt=d("a"),fu=u(),c(dt.$$.fragment),mu=u(),ot=d("p"),ot.innerHTML=ad,hu=u(),Tu=d("hr"),$u=u(),st=d("a"),_u=u(),c(at.$$.fragment),yu=u(),nt=d("p"),nt.innerHTML=nd,ku=u(),Lu=d("hr"),vu=u(),ct=d("a"),xu=u(),c(pt.$$.fragment),Cu=u(),ft=d("p"),ft.textContent=cd,bu=u(),mt=d("p"),mt.innerHTML=pd,Pu=u(),ht=d("ul"),ht.innerHTML=fd,Hu=u(),wu=d("hr"),Mu=u(),Tt=d("a"),Qu=u(),c($t.$$.fragment),Au=u(),_t=d("p"),_t.textContent=md,Nu=u(),yt=d("table"),yt.innerHTML=hd,Eu=u(),qu=d("hr"),gu=u(),kt=d("a"),Ru=u(),c(Lt.$$.fragment),Iu=u(),vt=d("p"),vt.innerHTML=Td,zu=u(),xt=d("p"),xt.innerHTML=$d,Ku=u(),ju=d("hr"),Du=u(),Ct=d("a"),Uu=u(),c(bt.$$.fragment),Bu=u(),Pt=d("p"),Pt.innerHTML=_d,Su=u(),Ht=d("ul"),Ht.innerHTML=yd,Fu=u(),Gu=d("hr"),Ou=u(),wt=d("a"),Vu=u(),c(Mt.$$.fragment),Wu=u(),Qt=d("p"),Qt.textContent=kd,Ju=u(),At=d("table"),At.innerHTML=Ld,Xu=u(),Yu=d("hr"),Zu=u(),Nt=d("a"),er=u(),c(Et.$$.fragment),tr=u(),qt=d("p"),qt.textContent=vd,ir=u(),gt=d("p"),gt.innerHTML=xd,lr=u(),ur=d("hr"),rr=u(),c(Rt.$$.fragment),dr=u(),zt=d("p"),this.h()},l(e){const t=Md("svelte-u9bgzb",document.head);_=o(t,"META",{name:!0,content:!0}),t.forEach(i),Kt=r(e),It=o(e,"P",{}),n(It).forEach(i),jt=r(e),y=o(e,"A",{id:!0,class:!0}),n(y).forEach(i),Dt=r(e),p(k.$$.fragment,e),Ut=r(e),L=o(e,"P",{"data-svelte-h":!0}),s(L)!=="svelte-1aeeeid"&&(L.textContent=ar),Bt=r(e),v=o(e,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1r3ntfo"&&(v.textContent=nr),St=r(e),x=o(e,"UL",{"data-svelte-h":!0}),s(x)!=="svelte-kea2e6"&&(x.innerHTML=cr),Ft=r(e),Gt=o(e,"HR",{}),Ot=r(e),C=o(e,"A",{id:!0,class:!0}),n(C).forEach(i),Vt=r(e),p(b.$$.fragment,e),Wt=r(e),P=o(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-1ux83uj"&&(P.innerHTML=pr),Jt=r(e),H=o(e,"P",{"data-svelte-h":!0}),s(H)!=="svelte-vi2pz9"&&(H.textContent=fr),Xt=r(e),w=o(e,"UL",{"data-svelte-h":!0}),s(w)!=="svelte-qlvgg9"&&(w.innerHTML=mr),Yt=r(e),M=o(e,"P",{"data-svelte-h":!0}),s(M)!=="svelte-1saulos"&&(M.innerHTML=hr),Zt=r(e),Q=o(e,"UL",{"data-svelte-h":!0}),s(Q)!=="svelte-fzyqbp"&&(Q.innerHTML=Tr),ei=r(e),ti=o(e,"HR",{}),ii=r(e),A=o(e,"A",{id:!0,class:!0}),n(A).forEach(i),li=r(e),p(N.$$.fragment,e),ui=r(e),E=o(e,"P",{"data-svelte-h":!0}),s(E)!=="svelte-1dgukb8"&&(E.textContent=$r),ri=r(e),q=o(e,"TABLE",{"data-svelte-h":!0}),s(q)!=="svelte-15lsmj7"&&(q.innerHTML=_r),di=r(e),oi=o(e,"HR",{}),si=r(e),g=o(e,"A",{id:!0,class:!0}),n(g).forEach(i),ai=r(e),p(R.$$.fragment,e),ni=r(e),I=o(e,"P",{"data-svelte-h":!0}),s(I)!=="svelte-19ll7y9"&&(I.textContent=yr),ci=r(e),z=o(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-1spompf"&&(z.innerHTML=kr),pi=r(e),fi=o(e,"HR",{}),mi=r(e),K=o(e,"A",{id:!0,class:!0}),n(K).forEach(i),hi=r(e),p(j.$$.fragment,e),Ti=r(e),D=o(e,"P",{"data-svelte-h":!0}),s(D)!=="svelte-iwo0ja"&&(D.textContent=Lr),$i=r(e),U=o(e,"P",{"data-svelte-h":!0}),s(U)!=="svelte-usw3zo"&&(U.innerHTML=vr),_i=r(e),yi=o(e,"HR",{}),ki=r(e),B=o(e,"A",{id:!0,class:!0}),n(B).forEach(i),Li=r(e),p(S.$$.fragment,e),vi=r(e),F=o(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-1g38rzl"&&(F.textContent=xr),xi=r(e),G=o(e,"P",{"data-svelte-h":!0}),s(G)!=="svelte-1jn2os3"&&(G.innerHTML=Cr),Ci=r(e),bi=o(e,"HR",{}),Pi=r(e),O=o(e,"A",{id:!0,class:!0}),n(O).forEach(i),Hi=r(e),p(V.$$.fragment,e),wi=r(e),W=o(e,"P",{"data-svelte-h":!0}),s(W)!=="svelte-1o3p42d"&&(W.textContent=br),Mi=r(e),J=o(e,"P",{"data-svelte-h":!0}),s(J)!=="svelte-1hty3q7"&&(J.innerHTML=Pr),Qi=r(e),X=o(e,"TABLE",{"data-svelte-h":!0}),s(X)!=="svelte-19plha1"&&(X.innerHTML=Hr),Ai=r(e),Ni=o(e,"HR",{}),Ei=r(e),Y=o(e,"A",{id:!0,class:!0}),n(Y).forEach(i),qi=r(e),p(Z.$$.fragment,e),gi=r(e),ee=o(e,"P",{"data-svelte-h":!0}),s(ee)!=="svelte-1rf8gmz"&&(ee.textContent=wr),Ri=r(e),te=o(e,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1hty3q7"&&(te.innerHTML=Mr),Ii=r(e),ie=o(e,"TABLE",{"data-svelte-h":!0}),s(ie)!=="svelte-txh99d"&&(ie.innerHTML=Qr),zi=r(e),Ki=o(e,"HR",{}),ji=r(e),le=o(e,"A",{id:!0,class:!0}),n(le).forEach(i),Di=r(e),p(ue.$$.fragment,e),Ui=r(e),re=o(e,"P",{"data-svelte-h":!0}),s(re)!=="svelte-1l3oksc"&&(re.textContent=Ar),Bi=r(e),de=o(e,"P",{"data-svelte-h":!0}),s(de)!=="svelte-vpswb8"&&(de.innerHTML=Nr),Si=r(e),Fi=o(e,"HR",{}),Gi=r(e),oe=o(e,"A",{id:!0,class:!0}),n(oe).forEach(i),Oi=r(e),p(se.$$.fragment,e),Vi=r(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-7s4t0d"&&(ae.textContent=Er),Wi=r(e),ne=o(e,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-ckytvb"&&(ne.innerHTML=qr),Ji=r(e),ce=o(e,"TABLE",{"data-svelte-h":!0}),s(ce)!=="svelte-1xv2m9q"&&(ce.innerHTML=gr),Xi=r(e),Yi=o(e,"HR",{}),Zi=r(e),pe=o(e,"A",{id:!0,class:!0}),n(pe).forEach(i),el=r(e),p(fe.$$.fragment,e),tl=r(e),me=o(e,"P",{"data-svelte-h":!0}),s(me)!=="svelte-hj5sse"&&(me.textContent=Rr),il=r(e),he=o(e,"P",{"data-svelte-h":!0}),s(he)!=="svelte-6p6lmz"&&(he.innerHTML=Ir),ll=r(e),Te=o(e,"TABLE",{"data-svelte-h":!0}),s(Te)!=="svelte-fj2fu5"&&(Te.innerHTML=zr),ul=r(e),rl=o(e,"HR",{}),dl=r(e),$e=o(e,"A",{id:!0,class:!0}),n($e).forEach(i),ol=r(e),p(_e.$$.fragment,e),sl=r(e),ye=o(e,"P",{"data-svelte-h":!0}),s(ye)!=="svelte-nklgrc"&&(ye.textContent=Kr),al=r(e),ke=o(e,"P",{"data-svelte-h":!0}),s(ke)!=="svelte-1saulos"&&(ke.innerHTML=jr),nl=r(e),Le=o(e,"UL",{"data-svelte-h":!0}),s(Le)!=="svelte-1yt2jf0"&&(Le.innerHTML=Dr),cl=r(e),pl=o(e,"HR",{}),fl=r(e),ve=o(e,"A",{id:!0,class:!0}),n(ve).forEach(i),ml=r(e),p(xe.$$.fragment,e),hl=r(e),Ce=o(e,"P",{"data-svelte-h":!0}),s(Ce)!=="svelte-moeq8l"&&(Ce.innerHTML=Ur),Tl=r(e),be=o(e,"P",{"data-svelte-h":!0}),s(be)!=="svelte-33rax3"&&(be.innerHTML=Br),$l=r(e),Pe=o(e,"TABLE",{"data-svelte-h":!0}),s(Pe)!=="svelte-18dtsnv"&&(Pe.innerHTML=Sr),_l=r(e),yl=o(e,"HR",{}),kl=r(e),He=o(e,"A",{id:!0,class:!0}),n(He).forEach(i),Ll=r(e),p(we.$$.fragment,e),vl=r(e),Me=o(e,"P",{"data-svelte-h":!0}),s(Me)!=="svelte-4q846v"&&(Me.textContent=Fr),xl=r(e),Qe=o(e,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-33rax3"&&(Qe.innerHTML=Gr),Cl=r(e),Ae=o(e,"TABLE",{"data-svelte-h":!0}),s(Ae)!=="svelte-hqwgb9"&&(Ae.innerHTML=Or),bl=r(e),Pl=o(e,"HR",{}),Hl=r(e),Ne=o(e,"A",{id:!0,class:!0}),n(Ne).forEach(i),wl=r(e),p(Ee.$$.fragment,e),Ml=r(e),qe=o(e,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-bmaw98"&&(qe.innerHTML=Vr),Ql=r(e),ge=o(e,"P",{"data-svelte-h":!0}),s(ge)!=="svelte-33rax3"&&(ge.innerHTML=Wr),Al=r(e),Re=o(e,"TABLE",{"data-svelte-h":!0}),s(Re)!=="svelte-18qxh0x"&&(Re.innerHTML=Jr),Nl=r(e),El=o(e,"HR",{}),ql=r(e),Ie=o(e,"A",{id:!0,class:!0}),n(Ie).forEach(i),gl=r(e),p(ze.$$.fragment,e),Rl=r(e),Ke=o(e,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-1xkinx1"&&(Ke.textContent=Xr),Il=r(e),je=o(e,"P",{"data-svelte-h":!0}),s(je)!=="svelte-1saulos"&&(je.innerHTML=Yr),zl=r(e),De=o(e,"UL",{"data-svelte-h":!0}),s(De)!=="svelte-12y4jvx"&&(De.innerHTML=Zr),Kl=r(e),jl=o(e,"HR",{}),Dl=r(e),Ue=o(e,"A",{id:!0,class:!0}),n(Ue).forEach(i),Ul=r(e),p(Be.$$.fragment,e),Bl=r(e),Se=o(e,"P",{"data-svelte-h":!0}),s(Se)!=="svelte-ziiz62"&&(Se.textContent=ed),Sl=r(e),Fe=o(e,"TABLE",{"data-svelte-h":!0}),s(Fe)!=="svelte-1h8dv5n"&&(Fe.innerHTML=td),Fl=r(e),Gl=o(e,"HR",{}),Ol=r(e),Ge=o(e,"A",{id:!0,class:!0}),n(Ge).forEach(i),Vl=r(e),p(Oe.$$.fragment,e),Wl=r(e),Ve=o(e,"P",{"data-svelte-h":!0}),s(Ve)!=="svelte-1hzq3te"&&(Ve.textContent=id),Jl=r(e),We=o(e,"P",{"data-svelte-h":!0}),s(We)!=="svelte-1bjyh7n"&&(We.innerHTML=ld),Xl=r(e),Je=o(e,"TABLE",{"data-svelte-h":!0}),s(Je)!=="svelte-1a01i2a"&&(Je.innerHTML=ud),Yl=r(e),Zl=o(e,"HR",{}),eu=r(e),Xe=o(e,"A",{id:!0,class:!0}),n(Xe).forEach(i),tu=r(e),p(Ye.$$.fragment,e),iu=r(e),Ze=o(e,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-jv0r"&&(Ze.textContent=rd),lu=r(e),et=o(e,"P",{"data-svelte-h":!0}),s(et)!=="svelte-1hp113b"&&(et.innerHTML=dd),uu=r(e),ru=o(e,"HR",{}),du=r(e),tt=o(e,"A",{id:!0,class:!0}),n(tt).forEach(i),ou=r(e),p(it.$$.fragment,e),su=r(e),lt=o(e,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1n9zjoi"&&(lt.innerHTML=od),au=r(e),ut=o(e,"TABLE",{"data-svelte-h":!0}),s(ut)!=="svelte-6nufyb"&&(ut.innerHTML=sd),nu=r(e),cu=o(e,"HR",{}),pu=r(e),rt=o(e,"A",{id:!0,class:!0}),n(rt).forEach(i),fu=r(e),p(dt.$$.fragment,e),mu=r(e),ot=o(e,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-1ipxykz"&&(ot.innerHTML=ad),hu=r(e),Tu=o(e,"HR",{}),$u=r(e),st=o(e,"A",{id:!0,class:!0}),n(st).forEach(i),_u=r(e),p(at.$$.fragment,e),yu=r(e),nt=o(e,"P",{"data-svelte-h":!0}),s(nt)!=="svelte-1nolezc"&&(nt.innerHTML=nd),ku=r(e),Lu=o(e,"HR",{}),vu=r(e),ct=o(e,"A",{id:!0,class:!0}),n(ct).forEach(i),xu=r(e),p(pt.$$.fragment,e),Cu=r(e),ft=o(e,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-1auz3rh"&&(ft.textContent=cd),bu=r(e),mt=o(e,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-1p9ver0"&&(mt.innerHTML=pd),Pu=r(e),ht=o(e,"UL",{"data-svelte-h":!0}),s(ht)!=="svelte-4v7sww"&&(ht.innerHTML=fd),Hu=r(e),wu=o(e,"HR",{}),Mu=r(e),Tt=o(e,"A",{id:!0,class:!0}),n(Tt).forEach(i),Qu=r(e),p($t.$$.fragment,e),Au=r(e),_t=o(e,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-mt1jex"&&(_t.textContent=md),Nu=r(e),yt=o(e,"TABLE",{"data-svelte-h":!0}),s(yt)!=="svelte-nk427c"&&(yt.innerHTML=hd),Eu=r(e),qu=o(e,"HR",{}),gu=r(e),kt=o(e,"A",{id:!0,class:!0}),n(kt).forEach(i),Ru=r(e),p(Lt.$$.fragment,e),Iu=r(e),vt=o(e,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-9cjdkj"&&(vt.innerHTML=Td),zu=r(e),xt=o(e,"P",{"data-svelte-h":!0}),s(xt)!=="svelte-3pigfy"&&(xt.innerHTML=$d),Ku=r(e),ju=o(e,"HR",{}),Du=r(e),Ct=o(e,"A",{id:!0,class:!0}),n(Ct).forEach(i),Uu=r(e),p(bt.$$.fragment,e),Bu=r(e),Pt=o(e,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-1p9ver0"&&(Pt.innerHTML=_d),Su=r(e),Ht=o(e,"UL",{"data-svelte-h":!0}),s(Ht)!=="svelte-r6qh2h"&&(Ht.innerHTML=yd),Fu=r(e),Gu=o(e,"HR",{}),Ou=r(e),wt=o(e,"A",{id:!0,class:!0}),n(wt).forEach(i),Vu=r(e),p(Mt.$$.fragment,e),Wu=r(e),Qt=o(e,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-vrhdhn"&&(Qt.textContent=kd),Ju=r(e),At=o(e,"TABLE",{"data-svelte-h":!0}),s(At)!=="svelte-5ahzuq"&&(At.innerHTML=Ld),Xu=r(e),Yu=o(e,"HR",{}),Zu=r(e),Nt=o(e,"A",{id:!0,class:!0}),n(Nt).forEach(i),er=r(e),p(Et.$$.fragment,e),tr=r(e),qt=o(e,"P",{"data-svelte-h":!0}),s(qt)!=="svelte-34g670"&&(qt.textContent=vd),ir=r(e),gt=o(e,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-7303j9"&&(gt.innerHTML=xd),lr=r(e),ur=o(e,"HR",{}),rr=r(e),p(Rt.$$.fragment,e),dr=r(e),zt=o(e,"P",{}),n(zt).forEach(i),this.h()},h(){a(_,"name","hf:doc:metadata"),a(_,"content",Ed),a(y,"id","module_utils/data-structures"),a(y,"class","group"),a(C,"id","module_utils/data-structures.PriorityQueue"),a(C,"class","group"),a(A,"id","new_module_utils/data-structures.PriorityQueue_new"),a(A,"class","group"),a(g,"id","module_utils/data-structures.PriorityQueue+size"),a(g,"class","group"),a(K,"id","module_utils/data-structures.PriorityQueue+isEmpty"),a(K,"class","group"),a(B,"id","module_utils/data-structures.PriorityQueue+peek"),a(B,"class","group"),a(O,"id","module_utils/data-structures.PriorityQueue+push"),a(O,"class","group"),a(Y,"id","module_utils/data-structures.PriorityQueue+extend"),a(Y,"class","group"),a(le,"id","module_utils/data-structures.PriorityQueue+pop"),a(le,"class","group"),a(oe,"id","module_utils/data-structures.PriorityQueue+replace"),a(oe,"class","group"),a(pe,"id","module_utils/data-structures.PriorityQueue+_siftUpFrom"),a(pe,"class","group"),a($e,"id","module_utils/data-structures.CharTrie"),a($e,"class","group"),a(ve,"id","module_utils/data-structures.CharTrie+extend"),a(ve,"class","group"),a(He,"id","module_utils/data-structures.CharTrie+push"),a(He,"class","group"),a(Ne,"id","module_utils/data-structures.CharTrie+commonPrefixSearch"),a(Ne,"class","group"),a(Ie,"id","module_utils/data-structures.TokenLattice"),a(Ie,"class","group"),a(Ue,"id","new_module_utils/data-structures.TokenLattice_new"),a(Ue,"class","group"),a(Ge,"id","module_utils/data-structures.TokenLattice+insert"),a(Ge,"class","group"),a(Xe,"id","module_utils/data-structures.TokenLattice+viterbi"),a(Xe,"class","group"),a(tt,"id","module_utils/data-structures.TokenLattice+piece"),a(tt,"class","group"),a(rt,"id","module_utils/data-structures.TokenLattice+tokens"),a(rt,"class","group"),a(st,"id","module_utils/data-structures.TokenLattice+tokenIds"),a(st,"class","group"),a(ct,"id","module_utils/data-structures..CharTrieNode"),a(ct,"class","group"),a(Tt,"id","new_module_utils/data-structures..CharTrieNode_new"),a(Tt,"class","group"),a(kt,"id","module_utils/data-structures..CharTrieNode.default"),a(kt,"class","group"),a(Ct,"id","module_utils/data-structures..TokenLatticeNode"),a(Ct,"class","group"),a(wt,"id","new_module_utils/data-structures..TokenLatticeNode_new"),a(wt,"class","group"),a(Nt,"id","module_utils/data-structures..TokenLatticeNode+clone"),a(Nt,"class","group")},m(e,t){Qd(document.head,_),l(e,Kt,t),l(e,It,t),l(e,jt,t),l(e,y,t),l(e,Dt,t),f(k,e,t),l(e,Ut,t),l(e,L,t),l(e,Bt,t),l(e,v,t),l(e,St,t),l(e,x,t),l(e,Ft,t),l(e,Gt,t),l(e,Ot,t),l(e,C,t),l(e,Vt,t),f(b,e,t),l(e,Wt,t),l(e,P,t),l(e,Jt,t),l(e,H,t),l(e,Xt,t),l(e,w,t),l(e,Yt,t),l(e,M,t),l(e,Zt,t),l(e,Q,t),l(e,ei,t),l(e,ti,t),l(e,ii,t),l(e,A,t),l(e,li,t),f(N,e,t),l(e,ui,t),l(e,E,t),l(e,ri,t),l(e,q,t),l(e,di,t),l(e,oi,t),l(e,si,t),l(e,g,t),l(e,ai,t),f(R,e,t),l(e,ni,t),l(e,I,t),l(e,ci,t),l(e,z,t),l(e,pi,t),l(e,fi,t),l(e,mi,t),l(e,K,t),l(e,hi,t),f(j,e,t),l(e,Ti,t),l(e,D,t),l(e,$i,t),l(e,U,t),l(e,_i,t),l(e,yi,t),l(e,ki,t),l(e,B,t),l(e,Li,t),f(S,e,t),l(e,vi,t),l(e,F,t),l(e,xi,t),l(e,G,t),l(e,Ci,t),l(e,bi,t),l(e,Pi,t),l(e,O,t),l(e,Hi,t),f(V,e,t),l(e,wi,t),l(e,W,t),l(e,Mi,t),l(e,J,t),l(e,Qi,t),l(e,X,t),l(e,Ai,t),l(e,Ni,t),l(e,Ei,t),l(e,Y,t),l(e,qi,t),f(Z,e,t),l(e,gi,t),l(e,ee,t),l(e,Ri,t),l(e,te,t),l(e,Ii,t),l(e,ie,t),l(e,zi,t),l(e,Ki,t),l(e,ji,t),l(e,le,t),l(e,Di,t),f(ue,e,t),l(e,Ui,t),l(e,re,t),l(e,Bi,t),l(e,de,t),l(e,Si,t),l(e,Fi,t),l(e,Gi,t),l(e,oe,t),l(e,Oi,t),f(se,e,t),l(e,Vi,t),l(e,ae,t),l(e,Wi,t),l(e,ne,t),l(e,Ji,t),l(e,ce,t),l(e,Xi,t),l(e,Yi,t),l(e,Zi,t),l(e,pe,t),l(e,el,t),f(fe,e,t),l(e,tl,t),l(e,me,t),l(e,il,t),l(e,he,t),l(e,ll,t),l(e,Te,t),l(e,ul,t),l(e,rl,t),l(e,dl,t),l(e,$e,t),l(e,ol,t),f(_e,e,t),l(e,sl,t),l(e,ye,t),l(e,al,t),l(e,ke,t),l(e,nl,t),l(e,Le,t),l(e,cl,t),l(e,pl,t),l(e,fl,t),l(e,ve,t),l(e,ml,t),f(xe,e,t),l(e,hl,t),l(e,Ce,t),l(e,Tl,t),l(e,be,t),l(e,$l,t),l(e,Pe,t),l(e,_l,t),l(e,yl,t),l(e,kl,t),l(e,He,t),l(e,Ll,t),f(we,e,t),l(e,vl,t),l(e,Me,t),l(e,xl,t),l(e,Qe,t),l(e,Cl,t),l(e,Ae,t),l(e,bl,t),l(e,Pl,t),l(e,Hl,t),l(e,Ne,t),l(e,wl,t),f(Ee,e,t),l(e,Ml,t),l(e,qe,t),l(e,Ql,t),l(e,ge,t),l(e,Al,t),l(e,Re,t),l(e,Nl,t),l(e,El,t),l(e,ql,t),l(e,Ie,t),l(e,gl,t),f(ze,e,t),l(e,Rl,t),l(e,Ke,t),l(e,Il,t),l(e,je,t),l(e,zl,t),l(e,De,t),l(e,Kl,t),l(e,jl,t),l(e,Dl,t),l(e,Ue,t),l(e,Ul,t),f(Be,e,t),l(e,Bl,t),l(e,Se,t),l(e,Sl,t),l(e,Fe,t),l(e,Fl,t),l(e,Gl,t),l(e,Ol,t),l(e,Ge,t),l(e,Vl,t),f(Oe,e,t),l(e,Wl,t),l(e,Ve,t),l(e,Jl,t),l(e,We,t),l(e,Xl,t),l(e,Je,t),l(e,Yl,t),l(e,Zl,t),l(e,eu,t),l(e,Xe,t),l(e,tu,t),f(Ye,e,t),l(e,iu,t),l(e,Ze,t),l(e,lu,t),l(e,et,t),l(e,uu,t),l(e,ru,t),l(e,du,t),l(e,tt,t),l(e,ou,t),f(it,e,t),l(e,su,t),l(e,lt,t),l(e,au,t),l(e,ut,t),l(e,nu,t),l(e,cu,t),l(e,pu,t),l(e,rt,t),l(e,fu,t),f(dt,e,t),l(e,mu,t),l(e,ot,t),l(e,hu,t),l(e,Tu,t),l(e,$u,t),l(e,st,t),l(e,_u,t),f(at,e,t),l(e,yu,t),l(e,nt,t),l(e,ku,t),l(e,Lu,t),l(e,vu,t),l(e,ct,t),l(e,xu,t),f(pt,e,t),l(e,Cu,t),l(e,ft,t),l(e,bu,t),l(e,mt,t),l(e,Pu,t),l(e,ht,t),l(e,Hu,t),l(e,wu,t),l(e,Mu,t),l(e,Tt,t),l(e,Qu,t),f($t,e,t),l(e,Au,t),l(e,_t,t),l(e,Nu,t),l(e,yt,t),l(e,Eu,t),l(e,qu,t),l(e,gu,t),l(e,kt,t),l(e,Ru,t),f(Lt,e,t),l(e,Iu,t),l(e,vt,t),l(e,zu,t),l(e,xt,t),l(e,Ku,t),l(e,ju,t),l(e,Du,t),l(e,Ct,t),l(e,Uu,t),f(bt,e,t),l(e,Bu,t),l(e,Pt,t),l(e,Su,t),l(e,Ht,t),l(e,Fu,t),l(e,Gu,t),l(e,Ou,t),l(e,wt,t),l(e,Vu,t),f(Mt,e,t),l(e,Wu,t),l(e,Qt,t),l(e,Ju,t),l(e,At,t),l(e,Xu,t),l(e,Yu,t),l(e,Zu,t),l(e,Nt,t),l(e,er,t),f(Et,e,t),l(e,tr,t),l(e,qt,t),l(e,ir,t),l(e,gt,t),l(e,lr,t),l(e,ur,t),l(e,rr,t),f(Rt,e,t),l(e,dr,t),l(e,zt,t),or=!0},p:bd,i(e){or||(m(k.$$.fragment,e),m(b.$$.fragment,e),m(N.$$.fragment,e),m(R.$$.fragment,e),m(j.$$.fragment,e),m(S.$$.fragment,e),m(V.$$.fragment,e),m(Z.$$.fragment,e),m(ue.$$.fragment,e),m(se.$$.fragment,e),m(fe.$$.fragment,e),m(_e.$$.fragment,e),m(xe.$$.fragment,e),m(we.$$.fragment,e),m(Ee.$$.fragment,e),m(ze.$$.fragment,e),m(Be.$$.fragment,e),m(Oe.$$.fragment,e),m(Ye.$$.fragment,e),m(it.$$.fragment,e),m(dt.$$.fragment,e),m(at.$$.fragment,e),m(pt.$$.fragment,e),m($t.$$.fragment,e),m(Lt.$$.fragment,e),m(bt.$$.fragment,e),m(Mt.$$.fragment,e),m(Et.$$.fragment,e),m(Rt.$$.fragment,e),or=!0)},o(e){h(k.$$.fragment,e),h(b.$$.fragment,e),h(N.$$.fragment,e),h(R.$$.fragment,e),h(j.$$.fragment,e),h(S.$$.fragment,e),h(V.$$.fragment,e),h(Z.$$.fragment,e),h(ue.$$.fragment,e),h(se.$$.fragment,e),h(fe.$$.fragment,e),h(_e.$$.fragment,e),h(xe.$$.fragment,e),h(we.$$.fragment,e),h(Ee.$$.fragment,e),h(ze.$$.fragment,e),h(Be.$$.fragment,e),h(Oe.$$.fragment,e),h(Ye.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(at.$$.fragment,e),h(pt.$$.fragment,e),h($t.$$.fragment,e),h(Lt.$$.fragment,e),h(bt.$$.fragment,e),h(Mt.$$.fragment,e),h(Et.$$.fragment,e),h(Rt.$$.fragment,e),or=!1},d(e){e&&(i(Kt),i(It),i(jt),i(y),i(Dt),i(Ut),i(L),i(Bt),i(v),i(St),i(x),i(Ft),i(Gt),i(Ot),i(C),i(Vt),i(Wt),i(P),i(Jt),i(H),i(Xt),i(w),i(Yt),i(M),i(Zt),i(Q),i(ei),i(ti),i(ii),i(A),i(li),i(ui),i(E),i(ri),i(q),i(di),i(oi),i(si),i(g),i(ai),i(ni),i(I),i(ci),i(z),i(pi),i(fi),i(mi),i(K),i(hi),i(Ti),i(D),i($i),i(U),i(_i),i(yi),i(ki),i(B),i(Li),i(vi),i(F),i(xi),i(G),i(Ci),i(bi),i(Pi),i(O),i(Hi),i(wi),i(W),i(Mi),i(J),i(Qi),i(X),i(Ai),i(Ni),i(Ei),i(Y),i(qi),i(gi),i(ee),i(Ri),i(te),i(Ii),i(ie),i(zi),i(Ki),i(ji),i(le),i(Di),i(Ui),i(re),i(Bi),i(de),i(Si),i(Fi),i(Gi),i(oe),i(Oi),i(Vi),i(ae),i(Wi),i(ne),i(Ji),i(ce),i(Xi),i(Yi),i(Zi),i(pe),i(el),i(tl),i(me),i(il),i(he),i(ll),i(Te),i(ul),i(rl),i(dl),i($e),i(ol),i(sl),i(ye),i(al),i(ke),i(nl),i(Le),i(cl),i(pl),i(fl),i(ve),i(ml),i(hl),i(Ce),i(Tl),i(be),i($l),i(Pe),i(_l),i(yl),i(kl),i(He),i(Ll),i(vl),i(Me),i(xl),i(Qe),i(Cl),i(Ae),i(bl),i(Pl),i(Hl),i(Ne),i(wl),i(Ml),i(qe),i(Ql),i(ge),i(Al),i(Re),i(Nl),i(El),i(ql),i(Ie),i(gl),i(Rl),i(Ke),i(Il),i(je),i(zl),i(De),i(Kl),i(jl),i(Dl),i(Ue),i(Ul),i(Bl),i(Se),i(Sl),i(Fe),i(Fl),i(Gl),i(Ol),i(Ge),i(Vl),i(Wl),i(Ve),i(Jl),i(We),i(Xl),i(Je),i(Yl),i(Zl),i(eu),i(Xe),i(tu),i(iu),i(Ze),i(lu),i(et),i(uu),i(ru),i(du),i(tt),i(ou),i(su),i(lt),i(au),i(ut),i(nu),i(cu),i(pu),i(rt),i(fu),i(mu),i(ot),i(hu),i(Tu),i($u),i(st),i(_u),i(yu),i(nt),i(ku),i(Lu),i(vu),i(ct),i(xu),i(Cu),i(ft),i(bu),i(mt),i(Pu),i(ht),i(Hu),i(wu),i(Mu),i(Tt),i(Qu),i(Au),i(_t),i(Nu),i(yt),i(Eu),i(qu),i(gu),i(kt),i(Ru),i(Iu),i(vt),i(zu),i(xt),i(Ku),i(ju),i(Du),i(Ct),i(Uu),i(Bu),i(Pt),i(Su),i(Ht),i(Fu),i(Gu),i(Ou),i(wt),i(Vu),i(Wu),i(Qt),i(Ju),i(At),i(Xu),i(Yu),i(Zu),i(Nt),i(er),i(tr),i(qt),i(ir),i(gt),i(lr),i(ur),i(rr),i(dr),i(zt)),i(_),T(k,e),T(b,e),T(N,e),T(R,e),T(j,e),T(S,e),T(V,e),T(Z,e),T(ue,e),T(se,e),T(fe,e),T(_e,e),T(xe,e),T(we,e),T(Ee,e),T(ze,e),T(Be,e),T(Oe,e),T(Ye,e),T(it,e),T(dt,e),T(at,e),T(pt,e),T($t,e),T(Lt,e),T(bt,e),T(Mt,e),T(Et,e),T(Rt,e)}}}const Ed='{"title":"utils/data-structures","local":"utilsdata-structures","sections":[{"title":"utils/data-structures.PriorityQueue","local":"utilsdata-structurespriorityqueue","sections":[{"title":"new PriorityQueue(comparator)","local":"new-priorityqueuecomparator","sections":[],"depth":3},{"title":"priorityQueue.size","local":"priorityqueuesize","sections":[],"depth":3},{"title":"priorityQueue.isEmpty() ⇒ <code> boolean </code>","local":"priorityqueueisempty--code-boolean-code","sections":[],"depth":3},{"title":"priorityQueue.peek() ⇒ <code> any </code>","local":"priorityqueuepeek--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.push(...values) ⇒ <code> number </code>","local":"priorityqueuepushvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.extend(values) ⇒ <code> number </code>","local":"priorityqueueextendvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.pop() ⇒ <code> any </code>","local":"priorityqueuepop--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.replace(value) ⇒ <code> * </code>","local":"priorityqueuereplacevalue--code--code","sections":[],"depth":3},{"title":"priorityQueue._siftUpFrom(node)","local":"priorityqueuesiftupfromnode","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.CharTrie","local":"utilsdata-structureschartrie","sections":[{"title":"charTrie.extend(texts)","local":"chartrieextendtexts","sections":[],"depth":3},{"title":"charTrie.push(text)","local":"chartriepushtext","sections":[],"depth":3},{"title":"charTrie.commonPrefixSearch(text)","local":"chartriecommonprefixsearchtext","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.TokenLattice","local":"utilsdata-structurestokenlattice","sections":[{"title":"new TokenLattice(sentence, bosTokenId, eosTokenId)","local":"new-tokenlatticesentence-bostokenid-eostokenid","sections":[],"depth":3},{"title":"tokenLattice.insert(pos, length, score, tokenId)","local":"tokenlatticeinsertpos-length-score-tokenid","sections":[],"depth":3},{"title":"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>","local":"tokenlatticeviterbi--code-array--tokenlatticenode--code","sections":[],"depth":3},{"title":"tokenLattice.piece(node) ⇒ <code> string </code>","local":"tokenlatticepiecenode--code-string-code","sections":[],"depth":3},{"title":"tokenLattice.tokens() ⇒ <code> Array. < string > </code>","local":"tokenlatticetokens--code-array--string--code","sections":[],"depth":3},{"title":"tokenLattice.tokenIds() ⇒ <code> Array. < number > </code>","local":"tokenlatticetokenids--code-array--number--code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~CharTrieNode","local":"utilsdata-structureschartrienode","sections":[{"title":"new CharTrieNode(isLeaf, children)","local":"new-chartrienodeisleaf-children","sections":[],"depth":3},{"title":"CharTrieNode.default() ⇒ <code> CharTrieNode </code>","local":"chartrienodedefault--code-chartrienode-code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~TokenLatticeNode","local":"utilsdata-structurestokenlatticenode","sections":[{"title":"new TokenLatticeNode(tokenId, nodeId, pos, length, score)","local":"new-tokenlatticenodetokenid-nodeid-pos-length-score","sections":[],"depth":3},{"title":"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>","local":"tokenlatticenodeclone--code-tokenlatticenode-code","sections":[],"depth":3}],"depth":2}],"depth":1}';function qd(sr){return Pd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zd extends Hd{constructor(_){super(),wd(this,_,qd,Nd,Cd,{})}}export{zd as component};
