import{s as w_,n as A_,o as g_}from"../chunks/scheduler.0219f8bd.js";import{S as P_,i as z_,g as r,s as o,r as u,A as R_,h as i,f as l,c as n,j as h,u as m,x as d,k as a,y as U_,a as s,v as p,d as c,t as f,w as T}from"../chunks/index.f61edf3b.js";import{C as Kn}from"../chunks/CodeBlock.38e566ae.js";import{H as _,E as k_}from"../chunks/EditOnGithub.48fa589f.js";function j_(Ff){let $,Qn,Bn,Vn,b,Sn,v,On,y,Yf="Helper module for <code>Tensor</code> processing.",Fn,M,Wf=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Yn,x,Gf='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clone"><code>.clone()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+slice"><code>.slice(...slices)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li> <li><a href="#module_utils/tensor.permute"><code>.permute(tensor, axes)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.interpolate_4d"><code>.interpolate_4d(input, options)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.matmul"><code>.matmul(a, b)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.rfft"><code>.rfft(x, a)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.topk"><code>.topk(x, [k])</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/tensor.slice"><code>.slice(data:, starts:, ends:, axes:, [steps])</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <a href="#Tensor"><code>Array.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.full"><code>.full(size, fill_value)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.zeros"><code>.zeros(size)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.zeros_like"><code>.zeros_like(tensor)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.rand"><code>.rand(size)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.quantize_embeddings"><code>.quantize_embeddings(tensor, precision)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>ONNXTensor</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',Wn,Gn,Xn,C,Zn,H,er,L,Xf='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',tr,w,Zf='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clone"><code>.clone()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+slice"><code>.slice(...slices)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li>',lr,sr,or,A,nr,g,rr,P,eT="Create a new Tensor or copy an existing Tensor.",ir,z,tT="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",dr,ar,ur,R,mr,U,pr,k,lT="Dimensions of the tensor.",cr,j,sT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',fr,Tr,hr,E,_r,J,$r,D,oT="Type of the tensor.",br,I,nT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',vr,yr,Mr,q,xr,K,Cr,B,rT="The data stored in the tensor.",Hr,N,iT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Lr,wr,Ar,Q,gr,V,Pr,S,dT="The number of elements in the tensor.",zr,O,aT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Rr,Ur,kr,F,jr,Y,Er,W,uT="The location of the tensor data.",Jr,G,mT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Dr,Ir,qr,X,Kr,Z,Br,ee,pT=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,Nr,te,cT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',Qr,Vr,Sr,le,Or,se,Fr,oe,fT="Index into a Tensor object.",Yr,ne,TT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The data at the specified index.',Wr,re,hT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",Gr,Xr,Zr,ie,ei,de,ti,ae,_T='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',li,ue,$T="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",si,oi,ni,me,ri,pe,ii,ce,bT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',di,fe,vT="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",ai,ui,mi,Te,pi,he,ci,_e,yT=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,fi,$e,MT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',Ti,be,xT="<li><code>Error</code> If the tensor has more than one element.</li>",hi,_i,$i,ve,bi,ye,vi,Me,CT="Convert tensor data to a n-dimensional JS list",yi,xe,HT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Mi,xi,Ci,Ce,Hi,He,Li,Le,LT="Return a new Tensor with the sigmoid function applied to each element.",wi,we,wT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The tensor with the sigmoid function applied.',Ai,gi,Pi,Ae,zi,ge,Ri,Pe,AT="Applies the sigmoid function to the tensor in place.",Ui,ze,gT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',ki,ji,Ei,Re,Ji,Ue,Di,ke,PT="Return a new Tensor with a callback function applied to each element.",Ii,je,zT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor with the callback function applied to each element.',qi,Ee,RT=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,Ki,Bi,Ni,Je,Qi,De,Vi,Ie,UT="Apply a callback function to each element of the tensor in place.",Si,qe,kT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Oi,Ke,jT=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,Fi,Yi,Wi,Be,Gi,Ne,Xi,Qe,ET="Return a new Tensor with every element multiplied by a constant.",Zi,Ve,JT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',ed,Se,DT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",td,ld,sd,Oe,od,Fe,nd,Ye,IT="Multiply the tensor by a constant in place.",rd,We,qT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',id,Ge,KT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",dd,ad,ud,Xe,md,Ze,pd,et,BT="Return a new Tensor with every element divided by a constant.",cd,tt,NT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',fd,lt,QT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",Td,hd,_d,st,$d,ot,bd,nt,VT="Divide the tensor by a constant in place.",vd,rt,ST='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',yd,it,OT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",Md,xd,Cd,dt,Hd,at,Ld,ut,FT="Return a new Tensor with every element added by a constant.",wd,mt,YT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',Ad,pt,WT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",gd,Pd,zd,ct,Rd,ft,Ud,Tt,GT="Add the tensor by a constant in place.",kd,ht,XT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',jd,_t,ZT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Ed,Jd,Dd,$t,Id,bt,qd,vt,eh="Return a new Tensor with every element subtracted by a constant.",Kd,yt,th='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',Bd,Mt,lh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",Nd,Qd,Vd,xt,Sd,Ct,Od,Ht,sh="Subtract the tensor by a constant in place.",Fd,Lt,oh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Yd,wt,nh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",Wd,Gd,Xd,At,Zd,gt,ea,Pt,rh="Creates a deep copy of the current Tensor.",ta,zt,ih='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor with the same type, data, and dimensions as the original.',la,sa,oa,Rt,na,Ut,ra,kt,dh="Performs a slice operation on the Tensor along specified dimensions.",ia,jt,ah="Consider a Tensor that has a dimension of [4, 7]:",da,Et,aa,Jt,uh=`We can slice against the two dims of row and column, for instance in this
case we can start at the second element, and return to the second last,
like this:`,ua,Dt,ma,It,mh="which would return:",pa,qt,ca,Kt,ph='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor containing the selected elements.<br/> <strong>Throws</strong>:',fa,Bt,ch="<li><code>Error</code> If the slice input is invalid.</li>",Ta,Nt,fh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...slices</td><td><code>number</code> | <code>Array&lt;number&gt;</code> | <code>null</code></td><td><p>The slice specifications for each dimension.</p> <ul><li>If a number is given, then a single element is selected.</li> <li>If an array of two numbers is given, then a range of elements [start, end (exclusive)] is selected.</li> <li>If null is given, then the entire dimension is selected.</li></ul></td></tr></tbody>",ha,_a,$a,Qt,ba,Vt,va,St,Th="Return a permuted version of this Tensor, according to the provided dimensions.",ya,Ot,hh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The permuted tensor.',Ma,Ft,_h="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to permute.</p></td></tr></tbody>",xa,Ca,Ha,Yt,La,Wt,wa,Gt,$h="Returns the sum of each row of the input tensor in the given dimension dim.",Aa,Xt,bh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',ga,Zt,vh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",Pa,za,Ra,el,Ua,tl,ka,ll,yh="Returns the matrix norm or vector norm of a given tensor.",ja,sl,Mh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The norm of the tensor.',Ea,ol,xh=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,Ja,Da,Ia,nl,qa,rl,Ka,il,Ch="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",Ba,dl,Hh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - <code>this</code> for operation chaining.',Na,al,Lh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Qa,Va,Sa,ul,Oa,ml,Fa,pl,wh="Performs <code>L_p</code> normalization of inputs over specified dimension.",Ya,cl,Ah='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The normalized tensor.',Wa,fl,gh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Ga,Xa,Za,Tl,eu,hl,tu,_l,Ph=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,lu,$l,zh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',su,ou,nu,bl,ru,vl,iu,yl,Rh="Returns a tensor with all specified dimensions of input of size 1 removed.",du,Ml,Uh=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,au,xl,kh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The squeezed tensor',uu,Cl,jh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",mu,pu,cu,Hl,fu,Ll,Tu,wl,Eh='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',hu,Al,Jh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',_u,$u,bu,gl,vu,Pl,yu,zl,Dh="Returns a new tensor with a dimension of size one inserted at the specified position.",Mu,Rl,Ih="NOTE: The returned tensor shares the same underlying data with this tensor.",xu,Ul,qh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The unsqueezed tensor',Cu,kl,Kh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",Hu,Lu,wu,jl,Au,El,gu,Jl,Bh='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',Pu,Dl,Nh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',zu,Ru,Uu,Il,ku,ql,ju,Kl,Qh='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Eu,Bl,Vh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ju,Du,Iu,Nl,qu,Ql,Ku,Vl,Sh=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,Bu,Sl,Oh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The flattened tensor.',Nu,Ol,Fh="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",Qu,Vu,Su,Fl,Ou,Yl,Fu,Wl,Yh="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",Yu,Gl,Wh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The tensor with the same data but different shape',Wu,Xl,Gh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",Gu,Xu,Zu,Zl,em,es,tm,ts,Xh='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',lm,ls,Zh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',sm,om,nm,ss,rm,os,im,ns,e1="Clamps all elements in input into the range [ min, max ]",dm,rs,t1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - the output tensor.',am,is,l1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",um,mm,pm,ds,cm,as,fm,us,s1='In-place version of @see <a href="Tensor.round">Tensor.round</a>',Tm,ms,o1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',hm,_m,$m,ps,bm,cs,vm,fs,n1="Rounds elements of input to the nearest integer.",ym,Ts,r1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - the output tensor.',Mm,xm,Cm,hs,Hm,_s,Lm,$s,i1="Performs Tensor dtype conversion.",wm,bs,d1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The converted tensor.',Am,vs,a1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code><a href="#DataType">DataType</a></code></td><td><p>The desired data type.</p></td></tr></tbody>',gm,Pm,zm,ys,Rm,Ms,Um,xs,u1="Permutes a tensor according to the provided axes.",km,Cs,m1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The permuted tensor.',jm,Hs,p1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to permute.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to permute the tensor along.</p></td></tr></tbody>",Em,Jm,Dm,Ls,Im,ws,qm,As,c1="Interpolates an Tensor to the given size.",Km,gs,f1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The interpolated tensor.',Bm,Ps,T1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>',Nm,Qm,Vm,zs,Sm,Rs,Om,Us,h1=`Down/up samples the input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html</a>.`,Fm,ks,_1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - The interpolated tensor.',Ym,js,$1='<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td></td><td><p>the input tensor</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>the options for the interpolation</p></td> </tr><tr><td>[options.size]</td><td><code>*</code></td><td><code></code></td><td><p>output spatial size.</p></td> </tr><tr><td>[options.mode]</td><td><code>&quot;nearest&quot;</code> | <code>&quot;bilinear&quot;</code> | <code>&quot;bicubic&quot;</code></td><td><code>&#39;bilinear&#39;</code></td><td><p>algorithm used for upsampling</p></td></tr></tbody>',Wm,Gm,Xm,Es,Zm,Js,ep,Ds,b1=`Matrix product of two tensors.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.matmul.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.matmul.html</a>`,tp,Is,v1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - The matrix product of the two tensors.',lp,qs,y1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>a</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the first tensor to be multiplied</p></td> </tr><tr><td>b</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the second tensor to be multiplied</p></td></tr></tbody>',sp,op,np,Ks,rp,Bs,ip,Ns,M1=`Computes the one dimensional Fourier transform of real-valued input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.fft.rfft.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.fft.rfft.html</a>`,dp,Qs,x1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - the output tensor.',ap,Vs,C1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the real input tensor</p></td> </tr><tr><td>a</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The dimension along which to take the one dimensional real FFT.</p></td></tr></tbody>',up,mp,pp,Ss,cp,Os,fp,Fs,H1=`Returns the k largest elements of the given input tensor.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.topk.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.topk.html</a>`,Tp,Ys,L1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - the output tuple of (Tensor, LongTensor) of top-k elements and their indices.',hp,Ws,w1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tensor</p></td> </tr><tr><td>[k]</td><td><code>number</code></td><td><p>the k in &quot;top-k&quot;</p></td></tr></tbody>',_p,$p,bp,Gs,vp,Xs,yp,Zs,A1="Slice a multidimensional float32 tensor.",Mp,eo,g1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - Sliced data tensor.',xp,to,P1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data:</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>Tensor of data to extract slices from</p></td> </tr><tr><td>starts:</td><td><code>Array.&lt;number&gt;</code></td><td><p>1-D array of starting indices of corresponding axis in axes</p></td> </tr><tr><td>ends:</td><td><code>Array.&lt;number&gt;</code></td><td><p>1-D array of ending indices (exclusive) of corresponding axis in axes</p></td> </tr><tr><td>axes:</td><td><code>Array.&lt;number&gt;</code></td><td><p>1-D array of axes that starts and ends apply to</p></td> </tr><tr><td>[steps]</td><td><code>Array.&lt;number&gt;</code></td><td><p>1-D array of slice step of corresponding axis in axes.</p></td></tr></tbody>',Cp,Hp,Lp,lo,wp,so,Ap,oo,z1="Perform mean pooling of the last hidden state followed by a normalization step.",gp,no,R1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns a new Tensor of shape [batchSize, embedDim].',Pp,ro,U1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>',zp,Rp,Up,io,kp,ao,jp,uo,k1="Apply Layer Normalization for last certain number of dimensions.",Ep,mo,j1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The normalized tensor.',Jp,po,E1='<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>',Dp,Ip,qp,co,Kp,fo,Bp,To,J1="Concatenates an array of tensors along a specified dimension.",Np,ho,D1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The concatenated tensor.',Qp,_o,I1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code><a href="#Tensor">Array.&lt;Tensor&gt;</a></code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>',Vp,Sp,Op,$o,Fp,bo,Yp,vo,q1="Stack an array of tensors along a specified dimension.",Wp,yo,K1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The stacked tensor.',Gp,Mo,B1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code><a href="#Tensor">Array.&lt;Tensor&gt;</a></code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>',Xp,Zp,ec,xo,tc,Co,lc,Ho,N1="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",sc,Lo,Q1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Array.&lt;Tensor&gt;</code></a> - A tuple of (std, mean) tensors.',oc,wo,V1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>',nc,rc,ic,Ao,dc,go,ac,Po,S1="Returns the mean value of each row of the input tensor in the given dimension dim.",uc,zo,O1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new tensor with means taken along the specified dimension.',mc,Ro,F1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>',pc,cc,fc,Uo,Tc,ko,hc,jo,Y1="Creates a tensor of size size filled with fill_value. The tensor’s dtype is inferred from fill_value.",_c,Eo,W1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The filled tensor.',$c,Jo,G1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td> </tr><tr><td>fill_value</td><td><code>number</code> | <code>bigint</code> | <code>boolean</code></td><td><p>The value to fill the output tensor with.</p></td></tr></tbody>",bc,vc,yc,Do,Mc,Io,xc,qo,X1="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",Cc,Ko,Z1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The ones tensor.',Hc,Bo,e_="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Lc,wc,Ac,No,gc,Qo,Pc,Vo,t_="Returns a tensor filled with the scalar value 1, with the same size as input.",zc,So,l_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The ones tensor.',Rc,Oo,s_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>',Uc,kc,jc,Fo,Ec,Yo,Jc,Wo,o_="Returns a tensor filled with the scalar value 0, with the shape defined by the variable argument size.",Dc,Go,n_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The zeros tensor.',Ic,Xo,r_="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",qc,Kc,Bc,Zo,Nc,en,Qc,tn,i_="Returns a tensor filled with the scalar value 0, with the same size as input.",Vc,ln,d_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The zeros tensor.',Sc,sn,a_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>',Oc,Fc,Yc,on,Wc,nn,Gc,rn,u_="Returns a tensor filled with random numbers from a uniform distribution on the interval [0, 1)",Xc,dn,m_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The random tensor.',Zc,an,p_="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",ef,tf,lf,un,sf,mn,of,pn,c_="Quantizes the embeddings tensor to binary or unsigned binary precision.",nf,cn,f_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The quantized tensor.',rf,fn,T_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The tensor to quantize.</p></td> </tr><tr><td>precision</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>',df,af,uf,Tn,mf,hn,pf,_n,h_='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',cf,ff,Tf,$n,hf,bn,_f,vn,__="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",$f,yn,$_='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',bf,Mn,b_="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",vf,xn,v_="<strong>Example</strong>",yf,Cn,Mf,xf,Cf,Hn,Hf,Ln,Lf,wn,y_='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',wf,Af,gf,An,Pf,gn,zf,Pn,M_='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Rf,Uf,kf,zn,jf,Rn,Ef,Un,x_="This creates a nested array of a given type and depth (see examples).",Jf,kn,C_='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',Df,jn,If,En,H_="<strong>Example</strong>",qf,Jn,Kf,Dn,L_="<strong>Example</strong>",Bf,In,Nf,Qf,Vf,qn,Sf,Nn,Of;return v=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),g=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),U=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),J=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),V=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),Y=new _({props:{title:"tensor.location : <code> string </code>",local:"tensorlocation--code-string-code",headingTag:"h3"}}),Z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),se=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),de=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),he=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),ye=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ge=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),Ue=new _({props:{title:"tensor.map(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.map_(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),Ne=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ze=new _({props:{title:"tensor.div(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),ot=new _({props:{title:"tensor.div_(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),at=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),ft=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),bt=new _({props:{title:"tensor.sub(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.sub_(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),gt=new _({props:{title:"tensor.clone() ⇒ <code> Tensor </code>",local:"tensorclone--code-tensor-code",headingTag:"h3"}}),Ut=new _({props:{title:"tensor.slice(...slices) ⇒ <code> Tensor </code>",local:"tensorsliceslices--code-tensor-code",headingTag:"h3"}}),Et=new Kn({props:{code:"JTVCJTIwMSUyQyUyMCUyMDIlMkMlMjAlMjAzJTJDJTIwJTIwNCUyQyUyMCUyMDUlMkMlMjAlMjA2JTJDJTIwJTIwNyU1RCUwQSU1QiUyMDglMkMlMjAlMjA5JTJDJTIwMTAlMkMlMjAxMSUyQyUyMDEyJTJDJTIwMTMlMkMlMjAxNCU1RCUwQSU1QjE1JTJDJTIwMTYlMkMlMjAxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyQyUyMDIxJTVEJTBBJTVCMjIlMkMlMjAyMyUyQyUyMDI0JTJDJTIwMjUlMkMlMjAyNiUyQyUyMDI3JTJDJTIwMjglNUQ=",highlighted:`<span class="hljs-string">[ 1,  2,  3,  4,  5,  6,  7]</span>
<span class="hljs-string">[ 8,  9, 10, 11, 12, 13, 14]</span>
<span class="hljs-string">[15, 16, 17, 18, 19, 20, 21]</span>
<span class="hljs-string">[22, 23, 24, 25, 26, 27, 28]</span>`,wrap:!1}}),Dt=new Kn({props:{code:"dGVuc29yLnNsaWNlKCU1QjElMkMlMjAtMSU1RCUyQyUyMCU1QjElMkMlMjAtMSU1RCklM0I=",highlighted:'<span class="hljs-attribute">tensor</span>.slice([<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>],<span class="hljs-meta"> [1, -1]);</span>',wrap:!1}}),qt=new Kn({props:{code:"JTVCJTIwJTIwOSUyQyUyMDEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTIwJTVEJTBBJTVCJTIwMTYlMkMlMjAxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyMCU1RA==",highlighted:`<span class="hljs-string">[  9, 10, 11, 12, 13 ]</span>
<span class="hljs-string">[ 16, 17, 18, 19, 20 ]</span>`,wrap:!1}}),Vt=new _({props:{title:"tensor.permute(...dims) ⇒ <code> Tensor </code>",local:"tensorpermutedims--code-tensor-code",headingTag:"h3"}}),Wt=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),tl=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),rl=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),ml=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),hl=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),vl=new _({props:{title:"tensor.squeeze([dim]) ⇒ <code> Tensor </code>",local:"tensorsqueezedim--code-tensor-code",headingTag:"h3"}}),Ll=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),Pl=new _({props:{title:"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>",local:"tensorunsqueezedim--code-tensor-code",headingTag:"h3"}}),El=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),ql=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Ql=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>",local:"tensorflattenstartdim-enddim--code-tensor-code",headingTag:"h3"}}),Yl=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),es=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),os=new _({props:{title:"tensor.clamp(min, max) ⇒ <code> Tensor </code>",local:"tensorclampmin-max--code-tensor-code",headingTag:"h3"}}),as=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),cs=new _({props:{title:"tensor.round() ⇒ <code> Tensor </code>",local:"tensorround--code-tensor-code",headingTag:"h3"}}),_s=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Ms=new _({props:{title:"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensorpermutetensor-axes--code-tensor-code",headingTag:"h2"}}),ws=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),Rs=new _({props:{title:"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorinterpolate4dinput-options--code-promise--tensor--code",headingTag:"h2"}}),Js=new _({props:{title:"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensormatmula-b--code-promise--tensor--code",headingTag:"h2"}}),Bs=new _({props:{title:"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorrfftx-a--code-promise--tensor--code",headingTag:"h2"}}),Os=new _({props:{title:"utils/tensor.topk(x, [k]) ⇒ <code> * </code>",local:"utilstensortopkx-k--code--code",headingTag:"h2"}}),Xs=new _({props:{title:"utils/tensor.slice(data:, starts:, ends:, axes:, [steps]) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorslicedata-starts-ends-axes-steps--code-promise--tensor--code",headingTag:"h2"}}),so=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),ao=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),fo=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),bo=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),Co=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),go=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>",local:"utilstensormeaninput-dim-keepdim--code-tensor-code",headingTag:"h2"}}),ko=new _({props:{title:"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>",local:"utilstensorfullsize-fillvalue--code-tensor-code",headingTag:"h2"}}),Io=new _({props:{title:"utils/tensor.ones(size) ⇒ <code> Tensor </code>",local:"utilstensoronessize--code-tensor-code",headingTag:"h2"}}),Qo=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensoronesliketensor--code-tensor-code",headingTag:"h2"}}),Yo=new _({props:{title:"utils/tensor.zeros(size) ⇒ <code> Tensor </code>",local:"utilstensorzerossize--code-tensor-code",headingTag:"h2"}}),en=new _({props:{title:"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensorzerosliketensor--code-tensor-code",headingTag:"h2"}}),nn=new _({props:{title:"utils/tensor.rand(size) ⇒ <code> Tensor </code>",local:"utilstensorrandsize--code-tensor-code",headingTag:"h2"}}),mn=new _({props:{title:"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>",local:"utilstensorquantizeembeddingstensor-precision--code-tensor-code",headingTag:"h2"}}),hn=new _({props:{title:"utils/tensor~args[0] : <code> ONNXTensor </code>",local:"utilstensorargs0--code-onnxtensor-code",headingTag:"h2"}}),bn=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Cn=new Kn({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),Ln=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),gn=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Rn=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),jn=new Kn({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),Jn=new Kn({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),In=new Kn({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),qn=new k_({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/tensor.md"}}),{c(){$=r("meta"),Qn=o(),Bn=r("p"),Vn=o(),b=r("a"),Sn=o(),u(v.$$.fragment),On=o(),y=r("p"),y.innerHTML=Yf,Fn=o(),M=r("p"),M.textContent=Wf,Yn=o(),x=r("ul"),x.innerHTML=Gf,Wn=o(),Gn=r("hr"),Xn=o(),C=r("a"),Zn=o(),u(H.$$.fragment),er=o(),L=r("p"),L.innerHTML=Xf,tr=o(),w=r("ul"),w.innerHTML=Zf,lr=o(),sr=r("hr"),or=o(),A=r("a"),nr=o(),u(g.$$.fragment),rr=o(),P=r("p"),P.textContent=eT,ir=o(),z=r("table"),z.innerHTML=tT,dr=o(),ar=r("hr"),ur=o(),R=r("a"),mr=o(),u(U.$$.fragment),pr=o(),k=r("p"),k.textContent=lT,cr=o(),j=r("p"),j.innerHTML=sT,fr=o(),Tr=r("hr"),hr=o(),E=r("a"),_r=o(),u(J.$$.fragment),$r=o(),D=r("p"),D.textContent=oT,br=o(),I=r("p"),I.innerHTML=nT,vr=o(),yr=r("hr"),Mr=o(),q=r("a"),xr=o(),u(K.$$.fragment),Cr=o(),B=r("p"),B.textContent=rT,Hr=o(),N=r("p"),N.innerHTML=iT,Lr=o(),wr=r("hr"),Ar=o(),Q=r("a"),gr=o(),u(V.$$.fragment),Pr=o(),S=r("p"),S.textContent=dT,zr=o(),O=r("p"),O.innerHTML=aT,Rr=o(),Ur=r("hr"),kr=o(),F=r("a"),jr=o(),u(Y.$$.fragment),Er=o(),W=r("p"),W.textContent=uT,Jr=o(),G=r("p"),G.innerHTML=mT,Dr=o(),Ir=r("hr"),qr=o(),X=r("a"),Kr=o(),u(Z.$$.fragment),Br=o(),ee=r("p"),ee.textContent=pT,Nr=o(),te=r("p"),te.innerHTML=cT,Qr=o(),Vr=r("hr"),Sr=o(),le=r("a"),Or=o(),u(se.$$.fragment),Fr=o(),oe=r("p"),oe.textContent=fT,Yr=o(),ne=r("p"),ne.innerHTML=TT,Wr=o(),re=r("table"),re.innerHTML=hT,Gr=o(),Xr=r("hr"),Zr=o(),ie=r("a"),ei=o(),u(de.$$.fragment),ti=o(),ae=r("p"),ae.innerHTML=_T,li=o(),ue=r("table"),ue.innerHTML=$T,si=o(),oi=r("hr"),ni=o(),me=r("a"),ri=o(),u(pe.$$.fragment),ii=o(),ce=r("p"),ce.innerHTML=bT,di=o(),fe=r("table"),fe.innerHTML=vT,ai=o(),ui=r("hr"),mi=o(),Te=r("a"),pi=o(),u(he.$$.fragment),ci=o(),_e=r("p"),_e.innerHTML=yT,fi=o(),$e=r("p"),$e.innerHTML=MT,Ti=o(),be=r("ul"),be.innerHTML=xT,hi=o(),_i=r("hr"),$i=o(),ve=r("a"),bi=o(),u(ye.$$.fragment),vi=o(),Me=r("p"),Me.textContent=CT,yi=o(),xe=r("p"),xe.innerHTML=HT,Mi=o(),xi=r("hr"),Ci=o(),Ce=r("a"),Hi=o(),u(He.$$.fragment),Li=o(),Le=r("p"),Le.textContent=LT,wi=o(),we=r("p"),we.innerHTML=wT,Ai=o(),gi=r("hr"),Pi=o(),Ae=r("a"),zi=o(),u(ge.$$.fragment),Ri=o(),Pe=r("p"),Pe.textContent=AT,Ui=o(),ze=r("p"),ze.innerHTML=gT,ki=o(),ji=r("hr"),Ei=o(),Re=r("a"),Ji=o(),u(Ue.$$.fragment),Di=o(),ke=r("p"),ke.textContent=PT,Ii=o(),je=r("p"),je.innerHTML=zT,qi=o(),Ee=r("table"),Ee.innerHTML=RT,Ki=o(),Bi=r("hr"),Ni=o(),Je=r("a"),Qi=o(),u(De.$$.fragment),Vi=o(),Ie=r("p"),Ie.textContent=UT,Si=o(),qe=r("p"),qe.innerHTML=kT,Oi=o(),Ke=r("table"),Ke.innerHTML=jT,Fi=o(),Yi=r("hr"),Wi=o(),Be=r("a"),Gi=o(),u(Ne.$$.fragment),Xi=o(),Qe=r("p"),Qe.textContent=ET,Zi=o(),Ve=r("p"),Ve.innerHTML=JT,ed=o(),Se=r("table"),Se.innerHTML=DT,td=o(),ld=r("hr"),sd=o(),Oe=r("a"),od=o(),u(Fe.$$.fragment),nd=o(),Ye=r("p"),Ye.textContent=IT,rd=o(),We=r("p"),We.innerHTML=qT,id=o(),Ge=r("table"),Ge.innerHTML=KT,dd=o(),ad=r("hr"),ud=o(),Xe=r("a"),md=o(),u(Ze.$$.fragment),pd=o(),et=r("p"),et.textContent=BT,cd=o(),tt=r("p"),tt.innerHTML=NT,fd=o(),lt=r("table"),lt.innerHTML=QT,Td=o(),hd=r("hr"),_d=o(),st=r("a"),$d=o(),u(ot.$$.fragment),bd=o(),nt=r("p"),nt.textContent=VT,vd=o(),rt=r("p"),rt.innerHTML=ST,yd=o(),it=r("table"),it.innerHTML=OT,Md=o(),xd=r("hr"),Cd=o(),dt=r("a"),Hd=o(),u(at.$$.fragment),Ld=o(),ut=r("p"),ut.textContent=FT,wd=o(),mt=r("p"),mt.innerHTML=YT,Ad=o(),pt=r("table"),pt.innerHTML=WT,gd=o(),Pd=r("hr"),zd=o(),ct=r("a"),Rd=o(),u(ft.$$.fragment),Ud=o(),Tt=r("p"),Tt.textContent=GT,kd=o(),ht=r("p"),ht.innerHTML=XT,jd=o(),_t=r("table"),_t.innerHTML=ZT,Ed=o(),Jd=r("hr"),Dd=o(),$t=r("a"),Id=o(),u(bt.$$.fragment),qd=o(),vt=r("p"),vt.textContent=eh,Kd=o(),yt=r("p"),yt.innerHTML=th,Bd=o(),Mt=r("table"),Mt.innerHTML=lh,Nd=o(),Qd=r("hr"),Vd=o(),xt=r("a"),Sd=o(),u(Ct.$$.fragment),Od=o(),Ht=r("p"),Ht.textContent=sh,Fd=o(),Lt=r("p"),Lt.innerHTML=oh,Yd=o(),wt=r("table"),wt.innerHTML=nh,Wd=o(),Gd=r("hr"),Xd=o(),At=r("a"),Zd=o(),u(gt.$$.fragment),ea=o(),Pt=r("p"),Pt.textContent=rh,ta=o(),zt=r("p"),zt.innerHTML=ih,la=o(),sa=r("hr"),oa=o(),Rt=r("a"),na=o(),u(Ut.$$.fragment),ra=o(),kt=r("p"),kt.textContent=dh,ia=o(),jt=r("p"),jt.textContent=ah,da=o(),u(Et.$$.fragment),aa=o(),Jt=r("p"),Jt.textContent=uh,ua=o(),u(Dt.$$.fragment),ma=o(),It=r("p"),It.textContent=mh,pa=o(),u(qt.$$.fragment),ca=o(),Kt=r("p"),Kt.innerHTML=ph,fa=o(),Bt=r("ul"),Bt.innerHTML=ch,Ta=o(),Nt=r("table"),Nt.innerHTML=fh,ha=o(),_a=r("hr"),$a=o(),Qt=r("a"),ba=o(),u(Vt.$$.fragment),va=o(),St=r("p"),St.textContent=Th,ya=o(),Ot=r("p"),Ot.innerHTML=hh,Ma=o(),Ft=r("table"),Ft.innerHTML=_h,xa=o(),Ca=r("hr"),Ha=o(),Yt=r("a"),La=o(),u(Wt.$$.fragment),wa=o(),Gt=r("p"),Gt.textContent=$h,Aa=o(),Xt=r("p"),Xt.innerHTML=bh,ga=o(),Zt=r("table"),Zt.innerHTML=vh,Pa=o(),za=r("hr"),Ra=o(),el=r("a"),Ua=o(),u(tl.$$.fragment),ka=o(),ll=r("p"),ll.textContent=yh,ja=o(),sl=r("p"),sl.innerHTML=Mh,Ea=o(),ol=r("table"),ol.innerHTML=xh,Ja=o(),Da=r("hr"),Ia=o(),nl=r("a"),qa=o(),u(rl.$$.fragment),Ka=o(),il=r("p"),il.innerHTML=Ch,Ba=o(),dl=r("p"),dl.innerHTML=Hh,Na=o(),al=r("table"),al.innerHTML=Lh,Qa=o(),Va=r("hr"),Sa=o(),ul=r("a"),Oa=o(),u(ml.$$.fragment),Fa=o(),pl=r("p"),pl.innerHTML=wh,Ya=o(),cl=r("p"),cl.innerHTML=Ah,Wa=o(),fl=r("table"),fl.innerHTML=gh,Ga=o(),Xa=r("hr"),Za=o(),Tl=r("a"),eu=o(),u(hl.$$.fragment),tu=o(),_l=r("p"),_l.textContent=Ph,lu=o(),$l=r("p"),$l.innerHTML=zh,su=o(),ou=r("hr"),nu=o(),bl=r("a"),ru=o(),u(vl.$$.fragment),iu=o(),yl=r("p"),yl.textContent=Rh,du=o(),Ml=r("p"),Ml.innerHTML=Uh,au=o(),xl=r("p"),xl.innerHTML=kh,uu=o(),Cl=r("table"),Cl.innerHTML=jh,mu=o(),pu=r("hr"),cu=o(),Hl=r("a"),fu=o(),u(Ll.$$.fragment),Tu=o(),wl=r("p"),wl.innerHTML=Eh,hu=o(),Al=r("p"),Al.innerHTML=Jh,_u=o(),$u=r("hr"),bu=o(),gl=r("a"),vu=o(),u(Pl.$$.fragment),yu=o(),zl=r("p"),zl.textContent=Dh,Mu=o(),Rl=r("p"),Rl.textContent=Ih,xu=o(),Ul=r("p"),Ul.innerHTML=qh,Cu=o(),kl=r("table"),kl.innerHTML=Kh,Hu=o(),Lu=r("hr"),wu=o(),jl=r("a"),Au=o(),u(El.$$.fragment),gu=o(),Jl=r("p"),Jl.innerHTML=Bh,Pu=o(),Dl=r("p"),Dl.innerHTML=Nh,zu=o(),Ru=r("hr"),Uu=o(),Il=r("a"),ku=o(),u(ql.$$.fragment),ju=o(),Kl=r("p"),Kl.innerHTML=Qh,Eu=o(),Bl=r("p"),Bl.innerHTML=Vh,Ju=o(),Du=r("hr"),Iu=o(),Nl=r("a"),qu=o(),u(Ql.$$.fragment),Ku=o(),Vl=r("p"),Vl.innerHTML=Sh,Bu=o(),Sl=r("p"),Sl.innerHTML=Oh,Nu=o(),Ol=r("table"),Ol.innerHTML=Fh,Qu=o(),Vu=r("hr"),Su=o(),Fl=r("a"),Ou=o(),u(Yl.$$.fragment),Fu=o(),Wl=r("p"),Wl.innerHTML=Yh,Yu=o(),Gl=r("p"),Gl.innerHTML=Wh,Wu=o(),Xl=r("table"),Xl.innerHTML=Gh,Gu=o(),Xu=r("hr"),Zu=o(),Zl=r("a"),em=o(),u(es.$$.fragment),tm=o(),ts=r("p"),ts.innerHTML=Xh,lm=o(),ls=r("p"),ls.innerHTML=Zh,sm=o(),om=r("hr"),nm=o(),ss=r("a"),rm=o(),u(os.$$.fragment),im=o(),ns=r("p"),ns.textContent=e1,dm=o(),rs=r("p"),rs.innerHTML=t1,am=o(),is=r("table"),is.innerHTML=l1,um=o(),mm=r("hr"),pm=o(),ds=r("a"),cm=o(),u(as.$$.fragment),fm=o(),us=r("p"),us.innerHTML=s1,Tm=o(),ms=r("p"),ms.innerHTML=o1,hm=o(),_m=r("hr"),$m=o(),ps=r("a"),bm=o(),u(cs.$$.fragment),vm=o(),fs=r("p"),fs.textContent=n1,ym=o(),Ts=r("p"),Ts.innerHTML=r1,Mm=o(),xm=r("hr"),Cm=o(),hs=r("a"),Hm=o(),u(_s.$$.fragment),Lm=o(),$s=r("p"),$s.textContent=i1,wm=o(),bs=r("p"),bs.innerHTML=d1,Am=o(),vs=r("table"),vs.innerHTML=a1,gm=o(),Pm=r("hr"),zm=o(),ys=r("a"),Rm=o(),u(Ms.$$.fragment),Um=o(),xs=r("p"),xs.textContent=u1,km=o(),Cs=r("p"),Cs.innerHTML=m1,jm=o(),Hs=r("table"),Hs.innerHTML=p1,Em=o(),Jm=r("hr"),Dm=o(),Ls=r("a"),Im=o(),u(ws.$$.fragment),qm=o(),As=r("p"),As.textContent=c1,Km=o(),gs=r("p"),gs.innerHTML=f1,Bm=o(),Ps=r("table"),Ps.innerHTML=T1,Nm=o(),Qm=r("hr"),Vm=o(),zs=r("a"),Sm=o(),u(Rs.$$.fragment),Om=o(),Us=r("p"),Us.innerHTML=h1,Fm=o(),ks=r("p"),ks.innerHTML=_1,Ym=o(),js=r("table"),js.innerHTML=$1,Wm=o(),Gm=r("hr"),Xm=o(),Es=r("a"),Zm=o(),u(Js.$$.fragment),ep=o(),Ds=r("p"),Ds.innerHTML=b1,tp=o(),Is=r("p"),Is.innerHTML=v1,lp=o(),qs=r("table"),qs.innerHTML=y1,sp=o(),op=r("hr"),np=o(),Ks=r("a"),rp=o(),u(Bs.$$.fragment),ip=o(),Ns=r("p"),Ns.innerHTML=M1,dp=o(),Qs=r("p"),Qs.innerHTML=x1,ap=o(),Vs=r("table"),Vs.innerHTML=C1,up=o(),mp=r("hr"),pp=o(),Ss=r("a"),cp=o(),u(Os.$$.fragment),fp=o(),Fs=r("p"),Fs.innerHTML=H1,Tp=o(),Ys=r("p"),Ys.innerHTML=L1,hp=o(),Ws=r("table"),Ws.innerHTML=w1,_p=o(),$p=r("hr"),bp=o(),Gs=r("a"),vp=o(),u(Xs.$$.fragment),yp=o(),Zs=r("p"),Zs.textContent=A1,Mp=o(),eo=r("p"),eo.innerHTML=g1,xp=o(),to=r("table"),to.innerHTML=P1,Cp=o(),Hp=r("hr"),Lp=o(),lo=r("a"),wp=o(),u(so.$$.fragment),Ap=o(),oo=r("p"),oo.textContent=z1,gp=o(),no=r("p"),no.innerHTML=R1,Pp=o(),ro=r("table"),ro.innerHTML=U1,zp=o(),Rp=r("hr"),Up=o(),io=r("a"),kp=o(),u(ao.$$.fragment),jp=o(),uo=r("p"),uo.textContent=k1,Ep=o(),mo=r("p"),mo.innerHTML=j1,Jp=o(),po=r("table"),po.innerHTML=E1,Dp=o(),Ip=r("hr"),qp=o(),co=r("a"),Kp=o(),u(fo.$$.fragment),Bp=o(),To=r("p"),To.textContent=J1,Np=o(),ho=r("p"),ho.innerHTML=D1,Qp=o(),_o=r("table"),_o.innerHTML=I1,Vp=o(),Sp=r("hr"),Op=o(),$o=r("a"),Fp=o(),u(bo.$$.fragment),Yp=o(),vo=r("p"),vo.textContent=q1,Wp=o(),yo=r("p"),yo.innerHTML=K1,Gp=o(),Mo=r("table"),Mo.innerHTML=B1,Xp=o(),Zp=r("hr"),ec=o(),xo=r("a"),tc=o(),u(Co.$$.fragment),lc=o(),Ho=r("p"),Ho.innerHTML=N1,sc=o(),Lo=r("p"),Lo.innerHTML=Q1,oc=o(),wo=r("table"),wo.innerHTML=V1,nc=o(),rc=r("hr"),ic=o(),Ao=r("a"),dc=o(),u(go.$$.fragment),ac=o(),Po=r("p"),Po.textContent=S1,uc=o(),zo=r("p"),zo.innerHTML=O1,mc=o(),Ro=r("table"),Ro.innerHTML=F1,pc=o(),cc=r("hr"),fc=o(),Uo=r("a"),Tc=o(),u(ko.$$.fragment),hc=o(),jo=r("p"),jo.textContent=Y1,_c=o(),Eo=r("p"),Eo.innerHTML=W1,$c=o(),Jo=r("table"),Jo.innerHTML=G1,bc=o(),vc=r("hr"),yc=o(),Do=r("a"),Mc=o(),u(Io.$$.fragment),xc=o(),qo=r("p"),qo.textContent=X1,Cc=o(),Ko=r("p"),Ko.innerHTML=Z1,Hc=o(),Bo=r("table"),Bo.innerHTML=e_,Lc=o(),wc=r("hr"),Ac=o(),No=r("a"),gc=o(),u(Qo.$$.fragment),Pc=o(),Vo=r("p"),Vo.textContent=t_,zc=o(),So=r("p"),So.innerHTML=l_,Rc=o(),Oo=r("table"),Oo.innerHTML=s_,Uc=o(),kc=r("hr"),jc=o(),Fo=r("a"),Ec=o(),u(Yo.$$.fragment),Jc=o(),Wo=r("p"),Wo.textContent=o_,Dc=o(),Go=r("p"),Go.innerHTML=n_,Ic=o(),Xo=r("table"),Xo.innerHTML=r_,qc=o(),Kc=r("hr"),Bc=o(),Zo=r("a"),Nc=o(),u(en.$$.fragment),Qc=o(),tn=r("p"),tn.textContent=i_,Vc=o(),ln=r("p"),ln.innerHTML=d_,Sc=o(),sn=r("table"),sn.innerHTML=a_,Oc=o(),Fc=r("hr"),Yc=o(),on=r("a"),Wc=o(),u(nn.$$.fragment),Gc=o(),rn=r("p"),rn.textContent=u_,Xc=o(),dn=r("p"),dn.innerHTML=m_,Zc=o(),an=r("table"),an.innerHTML=p_,ef=o(),tf=r("hr"),lf=o(),un=r("a"),sf=o(),u(mn.$$.fragment),of=o(),pn=r("p"),pn.textContent=c_,nf=o(),cn=r("p"),cn.innerHTML=f_,rf=o(),fn=r("table"),fn.innerHTML=T_,df=o(),af=r("hr"),uf=o(),Tn=r("a"),mf=o(),u(hn.$$.fragment),pf=o(),_n=r("p"),_n.innerHTML=h_,cf=o(),ff=r("hr"),Tf=o(),$n=r("a"),hf=o(),u(bn.$$.fragment),_f=o(),vn=r("p"),vn.textContent=__,$f=o(),yn=r("p"),yn.innerHTML=$_,bf=o(),Mn=r("table"),Mn.innerHTML=b_,vf=o(),xn=r("p"),xn.innerHTML=v_,yf=o(),u(Cn.$$.fragment),Mf=o(),xf=r("hr"),Cf=o(),Hn=r("a"),Hf=o(),u(Ln.$$.fragment),Lf=o(),wn=r("p"),wn.innerHTML=y_,wf=o(),Af=r("hr"),gf=o(),An=r("a"),Pf=o(),u(gn.$$.fragment),zf=o(),Pn=r("p"),Pn.innerHTML=M_,Rf=o(),Uf=r("hr"),kf=o(),zn=r("a"),jf=o(),u(Rn.$$.fragment),Ef=o(),Un=r("p"),Un.textContent=x_,Jf=o(),kn=r("p"),kn.innerHTML=C_,Df=o(),u(jn.$$.fragment),If=o(),En=r("p"),En.innerHTML=H_,qf=o(),u(Jn.$$.fragment),Kf=o(),Dn=r("p"),Dn.innerHTML=L_,Bf=o(),u(In.$$.fragment),Nf=o(),Qf=r("hr"),Vf=o(),u(qn.$$.fragment),Sf=o(),Nn=r("p"),this.h()},l(e){const t=R_("svelte-u9bgzb",document.head);$=i(t,"META",{name:!0,content:!0}),t.forEach(l),Qn=n(e),Bn=i(e,"P",{}),h(Bn).forEach(l),Vn=n(e),b=i(e,"A",{id:!0,class:!0}),h(b).forEach(l),Sn=n(e),m(v.$$.fragment,e),On=n(e),y=i(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-uw4y1m"&&(y.innerHTML=Yf),Fn=n(e),M=i(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-il3kl8"&&(M.textContent=Wf),Yn=n(e),x=i(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-1ggciz3"&&(x.innerHTML=Gf),Wn=n(e),Gn=i(e,"HR",{}),Xn=n(e),C=i(e,"A",{id:!0,class:!0}),h(C).forEach(l),Zn=n(e),m(H.$$.fragment,e),er=n(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=Xf),tr=n(e),w=i(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-msj2om"&&(w.innerHTML=Zf),lr=n(e),sr=i(e,"HR",{}),or=n(e),A=i(e,"A",{id:!0,class:!0}),h(A).forEach(l),nr=n(e),m(g.$$.fragment,e),rr=n(e),P=i(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-55wecd"&&(P.textContent=eT),ir=n(e),z=i(e,"TABLE",{"data-svelte-h":!0}),d(z)!=="svelte-ee7emz"&&(z.innerHTML=tT),dr=n(e),ar=i(e,"HR",{}),ur=n(e),R=i(e,"A",{id:!0,class:!0}),h(R).forEach(l),mr=n(e),m(U.$$.fragment,e),pr=n(e),k=i(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1gc2rt4"&&(k.textContent=lT),cr=n(e),j=i(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-10qzguj"&&(j.innerHTML=sT),fr=n(e),Tr=i(e,"HR",{}),hr=n(e),E=i(e,"A",{id:!0,class:!0}),h(E).forEach(l),_r=n(e),m(J.$$.fragment,e),$r=n(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-81y0bb"&&(D.textContent=oT),br=n(e),I=i(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-10qzguj"&&(I.innerHTML=nT),vr=n(e),yr=i(e,"HR",{}),Mr=n(e),q=i(e,"A",{id:!0,class:!0}),h(q).forEach(l),xr=n(e),m(K.$$.fragment,e),Cr=n(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1eqabt7"&&(B.textContent=rT),Hr=n(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-10qzguj"&&(N.innerHTML=iT),Lr=n(e),wr=i(e,"HR",{}),Ar=n(e),Q=i(e,"A",{id:!0,class:!0}),h(Q).forEach(l),gr=n(e),m(V.$$.fragment,e),Pr=n(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-krrt97"&&(S.textContent=dT),zr=n(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-10qzguj"&&(O.innerHTML=aT),Rr=n(e),Ur=i(e,"HR",{}),kr=n(e),F=i(e,"A",{id:!0,class:!0}),h(F).forEach(l),jr=n(e),m(Y.$$.fragment,e),Er=n(e),W=i(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1iaptgl"&&(W.textContent=uT),Jr=n(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-10qzguj"&&(G.innerHTML=mT),Dr=n(e),Ir=i(e,"HR",{}),qr=n(e),X=i(e,"A",{id:!0,class:!0}),h(X).forEach(l),Kr=n(e),m(Z.$$.fragment,e),Br=n(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1adn56z"&&(ee.textContent=pT),Nr=n(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1gxgvk6"&&(te.innerHTML=cT),Qr=n(e),Vr=i(e,"HR",{}),Sr=n(e),le=i(e,"A",{id:!0,class:!0}),h(le).forEach(l),Or=n(e),m(se.$$.fragment,e),Fr=n(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1u97xg1"&&(oe.textContent=fT),Yr=n(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1fs0j1e"&&(ne.innerHTML=TT),Wr=n(e),re=i(e,"TABLE",{"data-svelte-h":!0}),d(re)!=="svelte-1kq04ga"&&(re.innerHTML=hT),Gr=n(e),Xr=i(e,"HR",{}),Zr=n(e),ie=i(e,"A",{id:!0,class:!0}),h(ie).forEach(l),ei=n(e),m(de.$$.fragment,e),ti=n(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1cg22af"&&(ae.innerHTML=_T),li=n(e),ue=i(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-1hful42"&&(ue.innerHTML=$T),si=n(e),oi=i(e,"HR",{}),ni=n(e),me=i(e,"A",{id:!0,class:!0}),h(me).forEach(l),ri=n(e),m(pe.$$.fragment,e),ii=n(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1mr58c3"&&(ce.innerHTML=bT),di=n(e),fe=i(e,"TABLE",{"data-svelte-h":!0}),d(fe)!=="svelte-153ftfy"&&(fe.innerHTML=vT),ai=n(e),ui=i(e,"HR",{}),mi=n(e),Te=i(e,"A",{id:!0,class:!0}),h(Te).forEach(l),pi=n(e),m(he.$$.fragment,e),ci=n(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-13nzfs3"&&(_e.innerHTML=yT),fi=n(e),$e=i(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-11rv1mu"&&($e.innerHTML=MT),Ti=n(e),be=i(e,"UL",{"data-svelte-h":!0}),d(be)!=="svelte-5t2sg3"&&(be.innerHTML=xT),hi=n(e),_i=i(e,"HR",{}),$i=n(e),ve=i(e,"A",{id:!0,class:!0}),h(ve).forEach(l),bi=n(e),m(ye.$$.fragment,e),vi=n(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-87xdyr"&&(Me.textContent=CT),yi=n(e),xe=i(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1mr58c3"&&(xe.innerHTML=HT),Mi=n(e),xi=i(e,"HR",{}),Ci=n(e),Ce=i(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),Hi=n(e),m(He.$$.fragment,e),Li=n(e),Le=i(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-2wti2w"&&(Le.textContent=LT),wi=n(e),we=i(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1y8z3p1"&&(we.innerHTML=wT),Ai=n(e),gi=i(e,"HR",{}),Pi=n(e),Ae=i(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),zi=n(e),m(ge.$$.fragment,e),Ri=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1edu6c8"&&(Pe.textContent=AT),Ui=n(e),ze=i(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1t595qz"&&(ze.innerHTML=gT),ki=n(e),ji=i(e,"HR",{}),Ei=n(e),Re=i(e,"A",{id:!0,class:!0}),h(Re).forEach(l),Ji=n(e),m(Ue.$$.fragment,e),Di=n(e),ke=i(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-az0crx"&&(ke.textContent=PT),Ii=n(e),je=i(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-w5myiy"&&(je.innerHTML=zT),qi=n(e),Ee=i(e,"TABLE",{"data-svelte-h":!0}),d(Ee)!=="svelte-1ok4yhn"&&(Ee.innerHTML=RT),Ki=n(e),Bi=i(e,"HR",{}),Ni=n(e),Je=i(e,"A",{id:!0,class:!0}),h(Je).forEach(l),Qi=n(e),m(De.$$.fragment,e),Vi=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-jlfq15"&&(Ie.textContent=UT),Si=n(e),qe=i(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1t595qz"&&(qe.innerHTML=kT),Oi=n(e),Ke=i(e,"TABLE",{"data-svelte-h":!0}),d(Ke)!=="svelte-1ok4yhn"&&(Ke.innerHTML=jT),Fi=n(e),Yi=i(e,"HR",{}),Wi=n(e),Be=i(e,"A",{id:!0,class:!0}),h(Be).forEach(l),Gi=n(e),m(Ne.$$.fragment,e),Xi=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-xg80lg"&&(Qe.textContent=ET),Zi=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-9qu32j"&&(Ve.innerHTML=JT),ed=n(e),Se=i(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-1tbtmqd"&&(Se.innerHTML=DT),td=n(e),ld=i(e,"HR",{}),sd=n(e),Oe=i(e,"A",{id:!0,class:!0}),h(Oe).forEach(l),od=n(e),m(Fe.$$.fragment,e),nd=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1i12x1s"&&(Ye.textContent=IT),rd=n(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1t595qz"&&(We.innerHTML=qT),id=n(e),Ge=i(e,"TABLE",{"data-svelte-h":!0}),d(Ge)!=="svelte-1tbtmqd"&&(Ge.innerHTML=KT),dd=n(e),ad=i(e,"HR",{}),ud=n(e),Xe=i(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),md=n(e),m(Ze.$$.fragment,e),pd=n(e),et=i(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-45kvaw"&&(et.textContent=BT),cd=n(e),tt=i(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-9qu32j"&&(tt.innerHTML=NT),fd=n(e),lt=i(e,"TABLE",{"data-svelte-h":!0}),d(lt)!=="svelte-46t58i"&&(lt.innerHTML=QT),Td=n(e),hd=i(e,"HR",{}),_d=n(e),st=i(e,"A",{id:!0,class:!0}),h(st).forEach(l),$d=n(e),m(ot.$$.fragment,e),bd=n(e),nt=i(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-6s524n"&&(nt.textContent=VT),vd=n(e),rt=i(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1t595qz"&&(rt.innerHTML=ST),yd=n(e),it=i(e,"TABLE",{"data-svelte-h":!0}),d(it)!=="svelte-46t58i"&&(it.innerHTML=OT),Md=n(e),xd=i(e,"HR",{}),Cd=n(e),dt=i(e,"A",{id:!0,class:!0}),h(dt).forEach(l),Hd=n(e),m(at.$$.fragment,e),Ld=n(e),ut=i(e,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1hl64jn"&&(ut.textContent=FT),wd=n(e),mt=i(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-9qu32j"&&(mt.innerHTML=YT),Ad=n(e),pt=i(e,"TABLE",{"data-svelte-h":!0}),d(pt)!=="svelte-1p5444"&&(pt.innerHTML=WT),gd=n(e),Pd=i(e,"HR",{}),zd=n(e),ct=i(e,"A",{id:!0,class:!0}),h(ct).forEach(l),Rd=n(e),m(ft.$$.fragment,e),Ud=n(e),Tt=i(e,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-bbf4x3"&&(Tt.textContent=GT),kd=n(e),ht=i(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1t595qz"&&(ht.innerHTML=XT),jd=n(e),_t=i(e,"TABLE",{"data-svelte-h":!0}),d(_t)!=="svelte-1p5444"&&(_t.innerHTML=ZT),Ed=n(e),Jd=i(e,"HR",{}),Dd=n(e),$t=i(e,"A",{id:!0,class:!0}),h($t).forEach(l),Id=n(e),m(bt.$$.fragment,e),qd=n(e),vt=i(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-wbrx6g"&&(vt.textContent=eh),Kd=n(e),yt=i(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-9qu32j"&&(yt.innerHTML=th),Bd=n(e),Mt=i(e,"TABLE",{"data-svelte-h":!0}),d(Mt)!=="svelte-flm2g1"&&(Mt.innerHTML=lh),Nd=n(e),Qd=i(e,"HR",{}),Vd=n(e),xt=i(e,"A",{id:!0,class:!0}),h(xt).forEach(l),Sd=n(e),m(Ct.$$.fragment,e),Od=n(e),Ht=i(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-wqxtec"&&(Ht.textContent=sh),Fd=n(e),Lt=i(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1t595qz"&&(Lt.innerHTML=oh),Yd=n(e),wt=i(e,"TABLE",{"data-svelte-h":!0}),d(wt)!=="svelte-flm2g1"&&(wt.innerHTML=nh),Wd=n(e),Gd=i(e,"HR",{}),Xd=n(e),At=i(e,"A",{id:!0,class:!0}),h(At).forEach(l),Zd=n(e),m(gt.$$.fragment,e),ea=n(e),Pt=i(e,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-zftqbb"&&(Pt.textContent=rh),ta=n(e),zt=i(e,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1mgj1au"&&(zt.innerHTML=ih),la=n(e),sa=i(e,"HR",{}),oa=n(e),Rt=i(e,"A",{id:!0,class:!0}),h(Rt).forEach(l),na=n(e),m(Ut.$$.fragment,e),ra=n(e),kt=i(e,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-yalim1"&&(kt.textContent=dh),ia=n(e),jt=i(e,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-v4sb1d"&&(jt.textContent=ah),da=n(e),m(Et.$$.fragment,e),aa=n(e),Jt=i(e,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1qggjsc"&&(Jt.textContent=uh),ua=n(e),m(Dt.$$.fragment,e),ma=n(e),It=i(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-gtrr4w"&&(It.textContent=mh),pa=n(e),m(qt.$$.fragment,e),ca=n(e),Kt=i(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-15hbb4u"&&(Kt.innerHTML=ph),fa=n(e),Bt=i(e,"UL",{"data-svelte-h":!0}),d(Bt)!=="svelte-2ixnrf"&&(Bt.innerHTML=ch),Ta=n(e),Nt=i(e,"TABLE",{"data-svelte-h":!0}),d(Nt)!=="svelte-xutatr"&&(Nt.innerHTML=fh),ha=n(e),_a=i(e,"HR",{}),$a=n(e),Qt=i(e,"A",{id:!0,class:!0}),h(Qt).forEach(l),ba=n(e),m(Vt.$$.fragment,e),va=n(e),St=i(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1g8ouql"&&(St.textContent=Th),ya=n(e),Ot=i(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-19cc47x"&&(Ot.innerHTML=hh),Ma=n(e),Ft=i(e,"TABLE",{"data-svelte-h":!0}),d(Ft)!=="svelte-1p49qvp"&&(Ft.innerHTML=_h),xa=n(e),Ca=i(e,"HR",{}),Ha=n(e),Yt=i(e,"A",{id:!0,class:!0}),h(Yt).forEach(l),La=n(e),m(Wt.$$.fragment,e),wa=n(e),Gt=i(e,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-yjryb1"&&(Gt.textContent=$h),Aa=n(e),Xt=i(e,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-xtr8tc"&&(Xt.innerHTML=bh),ga=n(e),Zt=i(e,"TABLE",{"data-svelte-h":!0}),d(Zt)!=="svelte-6xvdso"&&(Zt.innerHTML=vh),Pa=n(e),za=i(e,"HR",{}),Ra=n(e),el=i(e,"A",{id:!0,class:!0}),h(el).forEach(l),Ua=n(e),m(tl.$$.fragment,e),ka=n(e),ll=i(e,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-1okfsqx"&&(ll.textContent=yh),ja=n(e),sl=i(e,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-bqi4bh"&&(sl.innerHTML=Mh),Ea=n(e),ol=i(e,"TABLE",{"data-svelte-h":!0}),d(ol)!=="svelte-13m2wni"&&(ol.innerHTML=xh),Ja=n(e),Da=i(e,"HR",{}),Ia=n(e),nl=i(e,"A",{id:!0,class:!0}),h(nl).forEach(l),qa=n(e),m(rl.$$.fragment,e),Ka=n(e),il=i(e,"P",{"data-svelte-h":!0}),d(il)!=="svelte-1htpbrk"&&(il.innerHTML=Ch),Ba=n(e),dl=i(e,"P",{"data-svelte-h":!0}),d(dl)!=="svelte-13o8e7b"&&(dl.innerHTML=Hh),Na=n(e),al=i(e,"TABLE",{"data-svelte-h":!0}),d(al)!=="svelte-1qi99pl"&&(al.innerHTML=Lh),Qa=n(e),Va=i(e,"HR",{}),Sa=n(e),ul=i(e,"A",{id:!0,class:!0}),h(ul).forEach(l),Oa=n(e),m(ml.$$.fragment,e),Fa=n(e),pl=i(e,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-1ztgqp"&&(pl.innerHTML=wh),Ya=n(e),cl=i(e,"P",{"data-svelte-h":!0}),d(cl)!=="svelte-oa1qug"&&(cl.innerHTML=Ah),Wa=n(e),fl=i(e,"TABLE",{"data-svelte-h":!0}),d(fl)!=="svelte-1qi99pl"&&(fl.innerHTML=gh),Ga=n(e),Xa=i(e,"HR",{}),Za=n(e),Tl=i(e,"A",{id:!0,class:!0}),h(Tl).forEach(l),eu=n(e),m(hl.$$.fragment,e),tu=n(e),_l=i(e,"P",{"data-svelte-h":!0}),d(_l)!=="svelte-1a7u185"&&(_l.textContent=Ph),lu=n(e),$l=i(e,"P",{"data-svelte-h":!0}),d($l)!=="svelte-1eu3doh"&&($l.innerHTML=zh),su=n(e),ou=i(e,"HR",{}),nu=n(e),bl=i(e,"A",{id:!0,class:!0}),h(bl).forEach(l),ru=n(e),m(vl.$$.fragment,e),iu=n(e),yl=i(e,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-qls17b"&&(yl.textContent=Rh),du=n(e),Ml=i(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-5nabmy"&&(Ml.innerHTML=Uh),au=n(e),xl=i(e,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-1fl56ed"&&(xl.innerHTML=kh),uu=n(e),Cl=i(e,"TABLE",{"data-svelte-h":!0}),d(Cl)!=="svelte-52pnzr"&&(Cl.innerHTML=jh),mu=n(e),pu=i(e,"HR",{}),cu=n(e),Hl=i(e,"A",{id:!0,class:!0}),h(Hl).forEach(l),fu=n(e),m(Ll.$$.fragment,e),Tu=n(e),wl=i(e,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-19w0pic"&&(wl.innerHTML=Eh),hu=n(e),Al=i(e,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-1mr58c3"&&(Al.innerHTML=Jh),_u=n(e),$u=i(e,"HR",{}),bu=n(e),gl=i(e,"A",{id:!0,class:!0}),h(gl).forEach(l),vu=n(e),m(Pl.$$.fragment,e),yu=n(e),zl=i(e,"P",{"data-svelte-h":!0}),d(zl)!=="svelte-18ws76n"&&(zl.textContent=Dh),Mu=n(e),Rl=i(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-1tnr5gm"&&(Rl.textContent=Ih),xu=n(e),Ul=i(e,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-13m9nag"&&(Ul.innerHTML=qh),Cu=n(e),kl=i(e,"TABLE",{"data-svelte-h":!0}),d(kl)!=="svelte-1u9lyxp"&&(kl.innerHTML=Kh),Hu=n(e),Lu=i(e,"HR",{}),wu=n(e),jl=i(e,"A",{id:!0,class:!0}),h(jl).forEach(l),Au=n(e),m(El.$$.fragment,e),gu=n(e),Jl=i(e,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-1b9ygao"&&(Jl.innerHTML=Bh),Pu=n(e),Dl=i(e,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-1mr58c3"&&(Dl.innerHTML=Nh),zu=n(e),Ru=i(e,"HR",{}),Uu=n(e),Il=i(e,"A",{id:!0,class:!0}),h(Il).forEach(l),ku=n(e),m(ql.$$.fragment,e),ju=n(e),Kl=i(e,"P",{"data-svelte-h":!0}),d(Kl)!=="svelte-1vkr5xo"&&(Kl.innerHTML=Qh),Eu=n(e),Bl=i(e,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-1mr58c3"&&(Bl.innerHTML=Vh),Ju=n(e),Du=i(e,"HR",{}),Iu=n(e),Nl=i(e,"A",{id:!0,class:!0}),h(Nl).forEach(l),qu=n(e),m(Ql.$$.fragment,e),Ku=n(e),Vl=i(e,"P",{"data-svelte-h":!0}),d(Vl)!=="svelte-1gguudf"&&(Vl.innerHTML=Sh),Bu=n(e),Sl=i(e,"P",{"data-svelte-h":!0}),d(Sl)!=="svelte-1vf2xxu"&&(Sl.innerHTML=Oh),Nu=n(e),Ol=i(e,"TABLE",{"data-svelte-h":!0}),d(Ol)!=="svelte-z6whez"&&(Ol.innerHTML=Fh),Qu=n(e),Vu=i(e,"HR",{}),Su=n(e),Fl=i(e,"A",{id:!0,class:!0}),h(Fl).forEach(l),Ou=n(e),m(Yl.$$.fragment,e),Fu=n(e),Wl=i(e,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-d6gvut"&&(Wl.innerHTML=Yh),Yu=n(e),Gl=i(e,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-1ueenyl"&&(Gl.innerHTML=Wh),Wu=n(e),Xl=i(e,"TABLE",{"data-svelte-h":!0}),d(Xl)!=="svelte-jj58dd"&&(Xl.innerHTML=Gh),Gu=n(e),Xu=i(e,"HR",{}),Zu=n(e),Zl=i(e,"A",{id:!0,class:!0}),h(Zl).forEach(l),em=n(e),m(es.$$.fragment,e),tm=n(e),ts=i(e,"P",{"data-svelte-h":!0}),d(ts)!=="svelte-1adolpg"&&(ts.innerHTML=Xh),lm=n(e),ls=i(e,"P",{"data-svelte-h":!0}),d(ls)!=="svelte-1mr58c3"&&(ls.innerHTML=Zh),sm=n(e),om=i(e,"HR",{}),nm=n(e),ss=i(e,"A",{id:!0,class:!0}),h(ss).forEach(l),rm=n(e),m(os.$$.fragment,e),im=n(e),ns=i(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-1hm8vtj"&&(ns.textContent=e1),dm=n(e),rs=i(e,"P",{"data-svelte-h":!0}),d(rs)!=="svelte-1mnx14"&&(rs.innerHTML=t1),am=n(e),is=i(e,"TABLE",{"data-svelte-h":!0}),d(is)!=="svelte-9ff0sy"&&(is.innerHTML=l1),um=n(e),mm=i(e,"HR",{}),pm=n(e),ds=i(e,"A",{id:!0,class:!0}),h(ds).forEach(l),cm=n(e),m(as.$$.fragment,e),fm=n(e),us=i(e,"P",{"data-svelte-h":!0}),d(us)!=="svelte-1e6kzks"&&(us.innerHTML=s1),Tm=n(e),ms=i(e,"P",{"data-svelte-h":!0}),d(ms)!=="svelte-1mr58c3"&&(ms.innerHTML=o1),hm=n(e),_m=i(e,"HR",{}),$m=n(e),ps=i(e,"A",{id:!0,class:!0}),h(ps).forEach(l),bm=n(e),m(cs.$$.fragment,e),vm=n(e),fs=i(e,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-t5k6jp"&&(fs.textContent=n1),ym=n(e),Ts=i(e,"P",{"data-svelte-h":!0}),d(Ts)!=="svelte-1mnx14"&&(Ts.innerHTML=r1),Mm=n(e),xm=i(e,"HR",{}),Cm=n(e),hs=i(e,"A",{id:!0,class:!0}),h(hs).forEach(l),Hm=n(e),m(_s.$$.fragment,e),Lm=n(e),$s=i(e,"P",{"data-svelte-h":!0}),d($s)!=="svelte-avw2a1"&&($s.textContent=i1),wm=n(e),bs=i(e,"P",{"data-svelte-h":!0}),d(bs)!=="svelte-3w87vv"&&(bs.innerHTML=d1),Am=n(e),vs=i(e,"TABLE",{"data-svelte-h":!0}),d(vs)!=="svelte-jj5vaa"&&(vs.innerHTML=a1),gm=n(e),Pm=i(e,"HR",{}),zm=n(e),ys=i(e,"A",{id:!0,class:!0}),h(ys).forEach(l),Rm=n(e),m(Ms.$$.fragment,e),Um=n(e),xs=i(e,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-167n5bd"&&(xs.textContent=u1),km=n(e),Cs=i(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-74oixn"&&(Cs.innerHTML=m1),jm=n(e),Hs=i(e,"TABLE",{"data-svelte-h":!0}),d(Hs)!=="svelte-1oyadc3"&&(Hs.innerHTML=p1),Em=n(e),Jm=i(e,"HR",{}),Dm=n(e),Ls=i(e,"A",{id:!0,class:!0}),h(Ls).forEach(l),Im=n(e),m(ws.$$.fragment,e),qm=n(e),As=i(e,"P",{"data-svelte-h":!0}),d(As)!=="svelte-fju8tm"&&(As.textContent=c1),Km=n(e),gs=i(e,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-16503uw"&&(gs.innerHTML=f1),Bm=n(e),Ps=i(e,"TABLE",{"data-svelte-h":!0}),d(Ps)!=="svelte-1no2z7v"&&(Ps.innerHTML=T1),Nm=n(e),Qm=i(e,"HR",{}),Vm=n(e),zs=i(e,"A",{id:!0,class:!0}),h(zs).forEach(l),Sm=n(e),m(Rs.$$.fragment,e),Om=n(e),Us=i(e,"P",{"data-svelte-h":!0}),d(Us)!=="svelte-18v04la"&&(Us.innerHTML=h1),Fm=n(e),ks=i(e,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-14kv4rj"&&(ks.innerHTML=_1),Ym=n(e),js=i(e,"TABLE",{"data-svelte-h":!0}),d(js)!=="svelte-1almd9d"&&(js.innerHTML=$1),Wm=n(e),Gm=i(e,"HR",{}),Xm=n(e),Es=i(e,"A",{id:!0,class:!0}),h(Es).forEach(l),Zm=n(e),m(Js.$$.fragment,e),ep=n(e),Ds=i(e,"P",{"data-svelte-h":!0}),d(Ds)!=="svelte-1yvow13"&&(Ds.innerHTML=b1),tp=n(e),Is=i(e,"P",{"data-svelte-h":!0}),d(Is)!=="svelte-fexugp"&&(Is.innerHTML=v1),lp=n(e),qs=i(e,"TABLE",{"data-svelte-h":!0}),d(qs)!=="svelte-1t0kp7i"&&(qs.innerHTML=y1),sp=n(e),op=i(e,"HR",{}),np=n(e),Ks=i(e,"A",{id:!0,class:!0}),h(Ks).forEach(l),rp=n(e),m(Bs.$$.fragment,e),ip=n(e),Ns=i(e,"P",{"data-svelte-h":!0}),d(Ns)!=="svelte-19dtamh"&&(Ns.innerHTML=M1),dp=n(e),Qs=i(e,"P",{"data-svelte-h":!0}),d(Qs)!=="svelte-1q9jl83"&&(Qs.innerHTML=x1),ap=n(e),Vs=i(e,"TABLE",{"data-svelte-h":!0}),d(Vs)!=="svelte-po861j"&&(Vs.innerHTML=C1),up=n(e),mp=i(e,"HR",{}),pp=n(e),Ss=i(e,"A",{id:!0,class:!0}),h(Ss).forEach(l),cp=n(e),m(Os.$$.fragment,e),fp=n(e),Fs=i(e,"P",{"data-svelte-h":!0}),d(Fs)!=="svelte-bd7moq"&&(Fs.innerHTML=H1),Tp=n(e),Ys=i(e,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-jyg3bg"&&(Ys.innerHTML=L1),hp=n(e),Ws=i(e,"TABLE",{"data-svelte-h":!0}),d(Ws)!=="svelte-15nix8z"&&(Ws.innerHTML=w1),_p=n(e),$p=i(e,"HR",{}),bp=n(e),Gs=i(e,"A",{id:!0,class:!0}),h(Gs).forEach(l),vp=n(e),m(Xs.$$.fragment,e),yp=n(e),Zs=i(e,"P",{"data-svelte-h":!0}),d(Zs)!=="svelte-9z0ni1"&&(Zs.textContent=A1),Mp=n(e),eo=i(e,"P",{"data-svelte-h":!0}),d(eo)!=="svelte-av0ptf"&&(eo.innerHTML=g1),xp=n(e),to=i(e,"TABLE",{"data-svelte-h":!0}),d(to)!=="svelte-1bqi98p"&&(to.innerHTML=P1),Cp=n(e),Hp=i(e,"HR",{}),Lp=n(e),lo=i(e,"A",{id:!0,class:!0}),h(lo).forEach(l),wp=n(e),m(so.$$.fragment,e),Ap=n(e),oo=i(e,"P",{"data-svelte-h":!0}),d(oo)!=="svelte-11ei68w"&&(oo.textContent=z1),gp=n(e),no=i(e,"P",{"data-svelte-h":!0}),d(no)!=="svelte-f0cseu"&&(no.innerHTML=R1),Pp=n(e),ro=i(e,"TABLE",{"data-svelte-h":!0}),d(ro)!=="svelte-1lgev2y"&&(ro.innerHTML=U1),zp=n(e),Rp=i(e,"HR",{}),Up=n(e),io=i(e,"A",{id:!0,class:!0}),h(io).forEach(l),kp=n(e),m(ao.$$.fragment,e),jp=n(e),uo=i(e,"P",{"data-svelte-h":!0}),d(uo)!=="svelte-7ivim4"&&(uo.textContent=k1),Ep=n(e),mo=i(e,"P",{"data-svelte-h":!0}),d(mo)!=="svelte-1t7ypd0"&&(mo.innerHTML=j1),Jp=n(e),po=i(e,"TABLE",{"data-svelte-h":!0}),d(po)!=="svelte-1lmecr"&&(po.innerHTML=E1),Dp=n(e),Ip=i(e,"HR",{}),qp=n(e),co=i(e,"A",{id:!0,class:!0}),h(co).forEach(l),Kp=n(e),m(fo.$$.fragment,e),Bp=n(e),To=i(e,"P",{"data-svelte-h":!0}),d(To)!=="svelte-k6p1db"&&(To.textContent=J1),Np=n(e),ho=i(e,"P",{"data-svelte-h":!0}),d(ho)!=="svelte-6qi3ne"&&(ho.innerHTML=D1),Qp=n(e),_o=i(e,"TABLE",{"data-svelte-h":!0}),d(_o)!=="svelte-2flruf"&&(_o.innerHTML=I1),Vp=n(e),Sp=i(e,"HR",{}),Op=n(e),$o=i(e,"A",{id:!0,class:!0}),h($o).forEach(l),Fp=n(e),m(bo.$$.fragment,e),Yp=n(e),vo=i(e,"P",{"data-svelte-h":!0}),d(vo)!=="svelte-8afo9v"&&(vo.textContent=q1),Wp=n(e),yo=i(e,"P",{"data-svelte-h":!0}),d(yo)!=="svelte-fnpm0s"&&(yo.innerHTML=K1),Gp=n(e),Mo=i(e,"TABLE",{"data-svelte-h":!0}),d(Mo)!=="svelte-1m3fin1"&&(Mo.innerHTML=B1),Xp=n(e),Zp=i(e,"HR",{}),ec=n(e),xo=i(e,"A",{id:!0,class:!0}),h(xo).forEach(l),tc=n(e),m(Co.$$.fragment,e),lc=n(e),Ho=i(e,"P",{"data-svelte-h":!0}),d(Ho)!=="svelte-11plveb"&&(Ho.innerHTML=N1),sc=n(e),Lo=i(e,"P",{"data-svelte-h":!0}),d(Lo)!=="svelte-1k0sd0r"&&(Lo.innerHTML=Q1),oc=n(e),wo=i(e,"TABLE",{"data-svelte-h":!0}),d(wo)!=="svelte-xda5g6"&&(wo.innerHTML=V1),nc=n(e),rc=i(e,"HR",{}),ic=n(e),Ao=i(e,"A",{id:!0,class:!0}),h(Ao).forEach(l),dc=n(e),m(go.$$.fragment,e),ac=n(e),Po=i(e,"P",{"data-svelte-h":!0}),d(Po)!=="svelte-17f4oxi"&&(Po.textContent=S1),uc=n(e),zo=i(e,"P",{"data-svelte-h":!0}),d(zo)!=="svelte-j8mnym"&&(zo.innerHTML=O1),mc=n(e),Ro=i(e,"TABLE",{"data-svelte-h":!0}),d(Ro)!=="svelte-8q2rcx"&&(Ro.innerHTML=F1),pc=n(e),cc=i(e,"HR",{}),fc=n(e),Uo=i(e,"A",{id:!0,class:!0}),h(Uo).forEach(l),Tc=n(e),m(ko.$$.fragment,e),hc=n(e),jo=i(e,"P",{"data-svelte-h":!0}),d(jo)!=="svelte-10qu7f7"&&(jo.textContent=Y1),_c=n(e),Eo=i(e,"P",{"data-svelte-h":!0}),d(Eo)!=="svelte-18rka45"&&(Eo.innerHTML=W1),$c=n(e),Jo=i(e,"TABLE",{"data-svelte-h":!0}),d(Jo)!=="svelte-1xtb381"&&(Jo.innerHTML=G1),bc=n(e),vc=i(e,"HR",{}),yc=n(e),Do=i(e,"A",{id:!0,class:!0}),h(Do).forEach(l),Mc=n(e),m(Io.$$.fragment,e),xc=n(e),qo=i(e,"P",{"data-svelte-h":!0}),d(qo)!=="svelte-1ayje0f"&&(qo.textContent=X1),Cc=n(e),Ko=i(e,"P",{"data-svelte-h":!0}),d(Ko)!=="svelte-154ckak"&&(Ko.innerHTML=Z1),Hc=n(e),Bo=i(e,"TABLE",{"data-svelte-h":!0}),d(Bo)!=="svelte-gyxne1"&&(Bo.innerHTML=e_),Lc=n(e),wc=i(e,"HR",{}),Ac=n(e),No=i(e,"A",{id:!0,class:!0}),h(No).forEach(l),gc=n(e),m(Qo.$$.fragment,e),Pc=n(e),Vo=i(e,"P",{"data-svelte-h":!0}),d(Vo)!=="svelte-1wvb8sq"&&(Vo.textContent=t_),zc=n(e),So=i(e,"P",{"data-svelte-h":!0}),d(So)!=="svelte-154ckak"&&(So.innerHTML=l_),Rc=n(e),Oo=i(e,"TABLE",{"data-svelte-h":!0}),d(Oo)!=="svelte-esxgyf"&&(Oo.innerHTML=s_),Uc=n(e),kc=i(e,"HR",{}),jc=n(e),Fo=i(e,"A",{id:!0,class:!0}),h(Fo).forEach(l),Ec=n(e),m(Yo.$$.fragment,e),Jc=n(e),Wo=i(e,"P",{"data-svelte-h":!0}),d(Wo)!=="svelte-1798kaw"&&(Wo.textContent=o_),Dc=n(e),Go=i(e,"P",{"data-svelte-h":!0}),d(Go)!=="svelte-ue1j5m"&&(Go.innerHTML=n_),Ic=n(e),Xo=i(e,"TABLE",{"data-svelte-h":!0}),d(Xo)!=="svelte-gyxne1"&&(Xo.innerHTML=r_),qc=n(e),Kc=i(e,"HR",{}),Bc=n(e),Zo=i(e,"A",{id:!0,class:!0}),h(Zo).forEach(l),Nc=n(e),m(en.$$.fragment,e),Qc=n(e),tn=i(e,"P",{"data-svelte-h":!0}),d(tn)!=="svelte-9nnpip"&&(tn.textContent=i_),Vc=n(e),ln=i(e,"P",{"data-svelte-h":!0}),d(ln)!=="svelte-ue1j5m"&&(ln.innerHTML=d_),Sc=n(e),sn=i(e,"TABLE",{"data-svelte-h":!0}),d(sn)!=="svelte-esxgyf"&&(sn.innerHTML=a_),Oc=n(e),Fc=i(e,"HR",{}),Yc=n(e),on=i(e,"A",{id:!0,class:!0}),h(on).forEach(l),Wc=n(e),m(nn.$$.fragment,e),Gc=n(e),rn=i(e,"P",{"data-svelte-h":!0}),d(rn)!=="svelte-106iz9p"&&(rn.textContent=u_),Xc=n(e),dn=i(e,"P",{"data-svelte-h":!0}),d(dn)!=="svelte-1uu5d6"&&(dn.innerHTML=m_),Zc=n(e),an=i(e,"TABLE",{"data-svelte-h":!0}),d(an)!=="svelte-gyxne1"&&(an.innerHTML=p_),ef=n(e),tf=i(e,"HR",{}),lf=n(e),un=i(e,"A",{id:!0,class:!0}),h(un).forEach(l),sf=n(e),m(mn.$$.fragment,e),of=n(e),pn=i(e,"P",{"data-svelte-h":!0}),d(pn)!=="svelte-185sm1b"&&(pn.textContent=c_),nf=n(e),cn=i(e,"P",{"data-svelte-h":!0}),d(cn)!=="svelte-1a5fo0"&&(cn.innerHTML=f_),rf=n(e),fn=i(e,"TABLE",{"data-svelte-h":!0}),d(fn)!=="svelte-rf6ukr"&&(fn.innerHTML=T_),df=n(e),af=i(e,"HR",{}),uf=n(e),Tn=i(e,"A",{id:!0,class:!0}),h(Tn).forEach(l),mf=n(e),m(hn.$$.fragment,e),pf=n(e),_n=i(e,"P",{"data-svelte-h":!0}),d(_n)!=="svelte-12loz97"&&(_n.innerHTML=h_),cf=n(e),ff=i(e,"HR",{}),Tf=n(e),$n=i(e,"A",{id:!0,class:!0}),h($n).forEach(l),hf=n(e),m(bn.$$.fragment,e),_f=n(e),vn=i(e,"P",{"data-svelte-h":!0}),d(vn)!=="svelte-40isdg"&&(vn.textContent=__),$f=n(e),yn=i(e,"P",{"data-svelte-h":!0}),d(yn)!=="svelte-tlsa2h"&&(yn.innerHTML=$_),bf=n(e),Mn=i(e,"TABLE",{"data-svelte-h":!0}),d(Mn)!=="svelte-17343p6"&&(Mn.innerHTML=b_),vf=n(e),xn=i(e,"P",{"data-svelte-h":!0}),d(xn)!=="svelte-1aswmub"&&(xn.innerHTML=v_),yf=n(e),m(Cn.$$.fragment,e),Mf=n(e),xf=i(e,"HR",{}),Cf=n(e),Hn=i(e,"A",{id:!0,class:!0}),h(Hn).forEach(l),Hf=n(e),m(Ln.$$.fragment,e),Lf=n(e),wn=i(e,"P",{"data-svelte-h":!0}),d(wn)!=="svelte-kp31r8"&&(wn.innerHTML=y_),wf=n(e),Af=i(e,"HR",{}),gf=n(e),An=i(e,"A",{id:!0,class:!0}),h(An).forEach(l),Pf=n(e),m(gn.$$.fragment,e),zf=n(e),Pn=i(e,"P",{"data-svelte-h":!0}),d(Pn)!=="svelte-1fs9no9"&&(Pn.innerHTML=M_),Rf=n(e),Uf=i(e,"HR",{}),kf=n(e),zn=i(e,"A",{id:!0,class:!0}),h(zn).forEach(l),jf=n(e),m(Rn.$$.fragment,e),Ef=n(e),Un=i(e,"P",{"data-svelte-h":!0}),d(Un)!=="svelte-2mif9c"&&(Un.textContent=x_),Jf=n(e),kn=i(e,"P",{"data-svelte-h":!0}),d(kn)!=="svelte-1jas2kw"&&(kn.innerHTML=C_),Df=n(e),m(jn.$$.fragment,e),If=n(e),En=i(e,"P",{"data-svelte-h":!0}),d(En)!=="svelte-1aswmub"&&(En.innerHTML=H_),qf=n(e),m(Jn.$$.fragment,e),Kf=n(e),Dn=i(e,"P",{"data-svelte-h":!0}),d(Dn)!=="svelte-1aswmub"&&(Dn.innerHTML=L_),Bf=n(e),m(In.$$.fragment,e),Nf=n(e),Qf=i(e,"HR",{}),Vf=n(e),m(qn.$$.fragment,e),Sf=n(e),Nn=i(e,"P",{}),h(Nn).forEach(l),this.h()},h(){a($,"name","hf:doc:metadata"),a($,"content",E_),a(b,"id","module_utils/tensor"),a(b,"class","group"),a(C,"id","module_utils/tensor.Tensor"),a(C,"class","group"),a(A,"id","new_module_utils/tensor.Tensor_new"),a(A,"class","group"),a(R,"id","module_utils/tensor.Tensor+dims"),a(R,"class","group"),a(E,"id","module_utils/tensor.Tensor+type"),a(E,"class","group"),a(q,"id","module_utils/tensor.Tensor+data"),a(q,"class","group"),a(Q,"id","module_utils/tensor.Tensor+size"),a(Q,"class","group"),a(F,"id","module_utils/tensor.Tensor+location"),a(F,"class","group"),a(X,"id","module_utils/tensor.Tensor+Symbol.iterator"),a(X,"class","group"),a(le,"id","module_utils/tensor.Tensor+_getitem"),a(le,"class","group"),a(ie,"id","module_utils/tensor.Tensor+indexOf"),a(ie,"class","group"),a(me,"id","module_utils/tensor.Tensor+_subarray"),a(me,"class","group"),a(Te,"id","module_utils/tensor.Tensor+item"),a(Te,"class","group"),a(ve,"id","module_utils/tensor.Tensor+tolist"),a(ve,"class","group"),a(Ce,"id","module_utils/tensor.Tensor+sigmoid"),a(Ce,"class","group"),a(Ae,"id","module_utils/tensor.Tensor+sigmoid_"),a(Ae,"class","group"),a(Re,"id","module_utils/tensor.Tensor+map"),a(Re,"class","group"),a(Je,"id","module_utils/tensor.Tensor+map_"),a(Je,"class","group"),a(Be,"id","module_utils/tensor.Tensor+mul"),a(Be,"class","group"),a(Oe,"id","module_utils/tensor.Tensor+mul_"),a(Oe,"class","group"),a(Xe,"id","module_utils/tensor.Tensor+div"),a(Xe,"class","group"),a(st,"id","module_utils/tensor.Tensor+div_"),a(st,"class","group"),a(dt,"id","module_utils/tensor.Tensor+add"),a(dt,"class","group"),a(ct,"id","module_utils/tensor.Tensor+add_"),a(ct,"class","group"),a($t,"id","module_utils/tensor.Tensor+sub"),a($t,"class","group"),a(xt,"id","module_utils/tensor.Tensor+sub_"),a(xt,"class","group"),a(At,"id","module_utils/tensor.Tensor+clone"),a(At,"class","group"),a(Rt,"id","module_utils/tensor.Tensor+slice"),a(Rt,"class","group"),a(Qt,"id","module_utils/tensor.Tensor+permute"),a(Qt,"class","group"),a(Yt,"id","module_utils/tensor.Tensor+sum"),a(Yt,"class","group"),a(el,"id","module_utils/tensor.Tensor+norm"),a(el,"class","group"),a(nl,"id","module_utils/tensor.Tensor+normalize_"),a(nl,"class","group"),a(ul,"id","module_utils/tensor.Tensor+normalize"),a(ul,"class","group"),a(Tl,"id","module_utils/tensor.Tensor+stride"),a(Tl,"class","group"),a(bl,"id","module_utils/tensor.Tensor+squeeze"),a(bl,"class","group"),a(Hl,"id","module_utils/tensor.Tensor+squeeze_"),a(Hl,"class","group"),a(gl,"id","module_utils/tensor.Tensor+unsqueeze"),a(gl,"class","group"),a(jl,"id","module_utils/tensor.Tensor+unsqueeze_"),a(jl,"class","group"),a(Il,"id","module_utils/tensor.Tensor+flatten_"),a(Il,"class","group"),a(Nl,"id","module_utils/tensor.Tensor+flatten"),a(Nl,"class","group"),a(Fl,"id","module_utils/tensor.Tensor+view"),a(Fl,"class","group"),a(Zl,"id","module_utils/tensor.Tensor+clamp_"),a(Zl,"class","group"),a(ss,"id","module_utils/tensor.Tensor+clamp"),a(ss,"class","group"),a(ds,"id","module_utils/tensor.Tensor+round_"),a(ds,"class","group"),a(ps,"id","module_utils/tensor.Tensor+round"),a(ps,"class","group"),a(hs,"id","module_utils/tensor.Tensor+to"),a(hs,"class","group"),a(ys,"id","module_utils/tensor.permute"),a(ys,"class","group"),a(Ls,"id","module_utils/tensor.interpolate"),a(Ls,"class","group"),a(zs,"id","module_utils/tensor.interpolate_4d"),a(zs,"class","group"),a(Es,"id","module_utils/tensor.matmul"),a(Es,"class","group"),a(Ks,"id","module_utils/tensor.rfft"),a(Ks,"class","group"),a(Ss,"id","module_utils/tensor.topk"),a(Ss,"class","group"),a(Gs,"id","module_utils/tensor.slice"),a(Gs,"class","group"),a(lo,"id","module_utils/tensor.mean_pooling"),a(lo,"class","group"),a(io,"id","module_utils/tensor.layer_norm"),a(io,"class","group"),a(co,"id","module_utils/tensor.cat"),a(co,"class","group"),a($o,"id","module_utils/tensor.stack"),a($o,"class","group"),a(xo,"id","module_utils/tensor.std_mean"),a(xo,"class","group"),a(Ao,"id","module_utils/tensor.mean"),a(Ao,"class","group"),a(Uo,"id","module_utils/tensor.full"),a(Uo,"class","group"),a(Do,"id","module_utils/tensor.ones"),a(Do,"class","group"),a(No,"id","module_utils/tensor.ones_like"),a(No,"class","group"),a(Fo,"id","module_utils/tensor.zeros"),a(Fo,"class","group"),a(Zo,"id","module_utils/tensor.zeros_like"),a(Zo,"class","group"),a(on,"id","module_utils/tensor.rand"),a(on,"class","group"),a(un,"id","module_utils/tensor.quantize_embeddings"),a(un,"class","group"),a(Tn,"id","module_utils/tensor..args[0]"),a(Tn,"class","group"),a($n,"id","module_utils/tensor..reshape"),a($n,"class","group"),a(Hn,"id","module_utils/tensor..reshape..reshapedArray"),a(Hn,"class","group"),a(An,"id","module_utils/tensor..DataArray"),a(An,"class","group"),a(zn,"id","module_utils/tensor..NestArray"),a(zn,"class","group")},m(e,t){U_(document.head,$),s(e,Qn,t),s(e,Bn,t),s(e,Vn,t),s(e,b,t),s(e,Sn,t),p(v,e,t),s(e,On,t),s(e,y,t),s(e,Fn,t),s(e,M,t),s(e,Yn,t),s(e,x,t),s(e,Wn,t),s(e,Gn,t),s(e,Xn,t),s(e,C,t),s(e,Zn,t),p(H,e,t),s(e,er,t),s(e,L,t),s(e,tr,t),s(e,w,t),s(e,lr,t),s(e,sr,t),s(e,or,t),s(e,A,t),s(e,nr,t),p(g,e,t),s(e,rr,t),s(e,P,t),s(e,ir,t),s(e,z,t),s(e,dr,t),s(e,ar,t),s(e,ur,t),s(e,R,t),s(e,mr,t),p(U,e,t),s(e,pr,t),s(e,k,t),s(e,cr,t),s(e,j,t),s(e,fr,t),s(e,Tr,t),s(e,hr,t),s(e,E,t),s(e,_r,t),p(J,e,t),s(e,$r,t),s(e,D,t),s(e,br,t),s(e,I,t),s(e,vr,t),s(e,yr,t),s(e,Mr,t),s(e,q,t),s(e,xr,t),p(K,e,t),s(e,Cr,t),s(e,B,t),s(e,Hr,t),s(e,N,t),s(e,Lr,t),s(e,wr,t),s(e,Ar,t),s(e,Q,t),s(e,gr,t),p(V,e,t),s(e,Pr,t),s(e,S,t),s(e,zr,t),s(e,O,t),s(e,Rr,t),s(e,Ur,t),s(e,kr,t),s(e,F,t),s(e,jr,t),p(Y,e,t),s(e,Er,t),s(e,W,t),s(e,Jr,t),s(e,G,t),s(e,Dr,t),s(e,Ir,t),s(e,qr,t),s(e,X,t),s(e,Kr,t),p(Z,e,t),s(e,Br,t),s(e,ee,t),s(e,Nr,t),s(e,te,t),s(e,Qr,t),s(e,Vr,t),s(e,Sr,t),s(e,le,t),s(e,Or,t),p(se,e,t),s(e,Fr,t),s(e,oe,t),s(e,Yr,t),s(e,ne,t),s(e,Wr,t),s(e,re,t),s(e,Gr,t),s(e,Xr,t),s(e,Zr,t),s(e,ie,t),s(e,ei,t),p(de,e,t),s(e,ti,t),s(e,ae,t),s(e,li,t),s(e,ue,t),s(e,si,t),s(e,oi,t),s(e,ni,t),s(e,me,t),s(e,ri,t),p(pe,e,t),s(e,ii,t),s(e,ce,t),s(e,di,t),s(e,fe,t),s(e,ai,t),s(e,ui,t),s(e,mi,t),s(e,Te,t),s(e,pi,t),p(he,e,t),s(e,ci,t),s(e,_e,t),s(e,fi,t),s(e,$e,t),s(e,Ti,t),s(e,be,t),s(e,hi,t),s(e,_i,t),s(e,$i,t),s(e,ve,t),s(e,bi,t),p(ye,e,t),s(e,vi,t),s(e,Me,t),s(e,yi,t),s(e,xe,t),s(e,Mi,t),s(e,xi,t),s(e,Ci,t),s(e,Ce,t),s(e,Hi,t),p(He,e,t),s(e,Li,t),s(e,Le,t),s(e,wi,t),s(e,we,t),s(e,Ai,t),s(e,gi,t),s(e,Pi,t),s(e,Ae,t),s(e,zi,t),p(ge,e,t),s(e,Ri,t),s(e,Pe,t),s(e,Ui,t),s(e,ze,t),s(e,ki,t),s(e,ji,t),s(e,Ei,t),s(e,Re,t),s(e,Ji,t),p(Ue,e,t),s(e,Di,t),s(e,ke,t),s(e,Ii,t),s(e,je,t),s(e,qi,t),s(e,Ee,t),s(e,Ki,t),s(e,Bi,t),s(e,Ni,t),s(e,Je,t),s(e,Qi,t),p(De,e,t),s(e,Vi,t),s(e,Ie,t),s(e,Si,t),s(e,qe,t),s(e,Oi,t),s(e,Ke,t),s(e,Fi,t),s(e,Yi,t),s(e,Wi,t),s(e,Be,t),s(e,Gi,t),p(Ne,e,t),s(e,Xi,t),s(e,Qe,t),s(e,Zi,t),s(e,Ve,t),s(e,ed,t),s(e,Se,t),s(e,td,t),s(e,ld,t),s(e,sd,t),s(e,Oe,t),s(e,od,t),p(Fe,e,t),s(e,nd,t),s(e,Ye,t),s(e,rd,t),s(e,We,t),s(e,id,t),s(e,Ge,t),s(e,dd,t),s(e,ad,t),s(e,ud,t),s(e,Xe,t),s(e,md,t),p(Ze,e,t),s(e,pd,t),s(e,et,t),s(e,cd,t),s(e,tt,t),s(e,fd,t),s(e,lt,t),s(e,Td,t),s(e,hd,t),s(e,_d,t),s(e,st,t),s(e,$d,t),p(ot,e,t),s(e,bd,t),s(e,nt,t),s(e,vd,t),s(e,rt,t),s(e,yd,t),s(e,it,t),s(e,Md,t),s(e,xd,t),s(e,Cd,t),s(e,dt,t),s(e,Hd,t),p(at,e,t),s(e,Ld,t),s(e,ut,t),s(e,wd,t),s(e,mt,t),s(e,Ad,t),s(e,pt,t),s(e,gd,t),s(e,Pd,t),s(e,zd,t),s(e,ct,t),s(e,Rd,t),p(ft,e,t),s(e,Ud,t),s(e,Tt,t),s(e,kd,t),s(e,ht,t),s(e,jd,t),s(e,_t,t),s(e,Ed,t),s(e,Jd,t),s(e,Dd,t),s(e,$t,t),s(e,Id,t),p(bt,e,t),s(e,qd,t),s(e,vt,t),s(e,Kd,t),s(e,yt,t),s(e,Bd,t),s(e,Mt,t),s(e,Nd,t),s(e,Qd,t),s(e,Vd,t),s(e,xt,t),s(e,Sd,t),p(Ct,e,t),s(e,Od,t),s(e,Ht,t),s(e,Fd,t),s(e,Lt,t),s(e,Yd,t),s(e,wt,t),s(e,Wd,t),s(e,Gd,t),s(e,Xd,t),s(e,At,t),s(e,Zd,t),p(gt,e,t),s(e,ea,t),s(e,Pt,t),s(e,ta,t),s(e,zt,t),s(e,la,t),s(e,sa,t),s(e,oa,t),s(e,Rt,t),s(e,na,t),p(Ut,e,t),s(e,ra,t),s(e,kt,t),s(e,ia,t),s(e,jt,t),s(e,da,t),p(Et,e,t),s(e,aa,t),s(e,Jt,t),s(e,ua,t),p(Dt,e,t),s(e,ma,t),s(e,It,t),s(e,pa,t),p(qt,e,t),s(e,ca,t),s(e,Kt,t),s(e,fa,t),s(e,Bt,t),s(e,Ta,t),s(e,Nt,t),s(e,ha,t),s(e,_a,t),s(e,$a,t),s(e,Qt,t),s(e,ba,t),p(Vt,e,t),s(e,va,t),s(e,St,t),s(e,ya,t),s(e,Ot,t),s(e,Ma,t),s(e,Ft,t),s(e,xa,t),s(e,Ca,t),s(e,Ha,t),s(e,Yt,t),s(e,La,t),p(Wt,e,t),s(e,wa,t),s(e,Gt,t),s(e,Aa,t),s(e,Xt,t),s(e,ga,t),s(e,Zt,t),s(e,Pa,t),s(e,za,t),s(e,Ra,t),s(e,el,t),s(e,Ua,t),p(tl,e,t),s(e,ka,t),s(e,ll,t),s(e,ja,t),s(e,sl,t),s(e,Ea,t),s(e,ol,t),s(e,Ja,t),s(e,Da,t),s(e,Ia,t),s(e,nl,t),s(e,qa,t),p(rl,e,t),s(e,Ka,t),s(e,il,t),s(e,Ba,t),s(e,dl,t),s(e,Na,t),s(e,al,t),s(e,Qa,t),s(e,Va,t),s(e,Sa,t),s(e,ul,t),s(e,Oa,t),p(ml,e,t),s(e,Fa,t),s(e,pl,t),s(e,Ya,t),s(e,cl,t),s(e,Wa,t),s(e,fl,t),s(e,Ga,t),s(e,Xa,t),s(e,Za,t),s(e,Tl,t),s(e,eu,t),p(hl,e,t),s(e,tu,t),s(e,_l,t),s(e,lu,t),s(e,$l,t),s(e,su,t),s(e,ou,t),s(e,nu,t),s(e,bl,t),s(e,ru,t),p(vl,e,t),s(e,iu,t),s(e,yl,t),s(e,du,t),s(e,Ml,t),s(e,au,t),s(e,xl,t),s(e,uu,t),s(e,Cl,t),s(e,mu,t),s(e,pu,t),s(e,cu,t),s(e,Hl,t),s(e,fu,t),p(Ll,e,t),s(e,Tu,t),s(e,wl,t),s(e,hu,t),s(e,Al,t),s(e,_u,t),s(e,$u,t),s(e,bu,t),s(e,gl,t),s(e,vu,t),p(Pl,e,t),s(e,yu,t),s(e,zl,t),s(e,Mu,t),s(e,Rl,t),s(e,xu,t),s(e,Ul,t),s(e,Cu,t),s(e,kl,t),s(e,Hu,t),s(e,Lu,t),s(e,wu,t),s(e,jl,t),s(e,Au,t),p(El,e,t),s(e,gu,t),s(e,Jl,t),s(e,Pu,t),s(e,Dl,t),s(e,zu,t),s(e,Ru,t),s(e,Uu,t),s(e,Il,t),s(e,ku,t),p(ql,e,t),s(e,ju,t),s(e,Kl,t),s(e,Eu,t),s(e,Bl,t),s(e,Ju,t),s(e,Du,t),s(e,Iu,t),s(e,Nl,t),s(e,qu,t),p(Ql,e,t),s(e,Ku,t),s(e,Vl,t),s(e,Bu,t),s(e,Sl,t),s(e,Nu,t),s(e,Ol,t),s(e,Qu,t),s(e,Vu,t),s(e,Su,t),s(e,Fl,t),s(e,Ou,t),p(Yl,e,t),s(e,Fu,t),s(e,Wl,t),s(e,Yu,t),s(e,Gl,t),s(e,Wu,t),s(e,Xl,t),s(e,Gu,t),s(e,Xu,t),s(e,Zu,t),s(e,Zl,t),s(e,em,t),p(es,e,t),s(e,tm,t),s(e,ts,t),s(e,lm,t),s(e,ls,t),s(e,sm,t),s(e,om,t),s(e,nm,t),s(e,ss,t),s(e,rm,t),p(os,e,t),s(e,im,t),s(e,ns,t),s(e,dm,t),s(e,rs,t),s(e,am,t),s(e,is,t),s(e,um,t),s(e,mm,t),s(e,pm,t),s(e,ds,t),s(e,cm,t),p(as,e,t),s(e,fm,t),s(e,us,t),s(e,Tm,t),s(e,ms,t),s(e,hm,t),s(e,_m,t),s(e,$m,t),s(e,ps,t),s(e,bm,t),p(cs,e,t),s(e,vm,t),s(e,fs,t),s(e,ym,t),s(e,Ts,t),s(e,Mm,t),s(e,xm,t),s(e,Cm,t),s(e,hs,t),s(e,Hm,t),p(_s,e,t),s(e,Lm,t),s(e,$s,t),s(e,wm,t),s(e,bs,t),s(e,Am,t),s(e,vs,t),s(e,gm,t),s(e,Pm,t),s(e,zm,t),s(e,ys,t),s(e,Rm,t),p(Ms,e,t),s(e,Um,t),s(e,xs,t),s(e,km,t),s(e,Cs,t),s(e,jm,t),s(e,Hs,t),s(e,Em,t),s(e,Jm,t),s(e,Dm,t),s(e,Ls,t),s(e,Im,t),p(ws,e,t),s(e,qm,t),s(e,As,t),s(e,Km,t),s(e,gs,t),s(e,Bm,t),s(e,Ps,t),s(e,Nm,t),s(e,Qm,t),s(e,Vm,t),s(e,zs,t),s(e,Sm,t),p(Rs,e,t),s(e,Om,t),s(e,Us,t),s(e,Fm,t),s(e,ks,t),s(e,Ym,t),s(e,js,t),s(e,Wm,t),s(e,Gm,t),s(e,Xm,t),s(e,Es,t),s(e,Zm,t),p(Js,e,t),s(e,ep,t),s(e,Ds,t),s(e,tp,t),s(e,Is,t),s(e,lp,t),s(e,qs,t),s(e,sp,t),s(e,op,t),s(e,np,t),s(e,Ks,t),s(e,rp,t),p(Bs,e,t),s(e,ip,t),s(e,Ns,t),s(e,dp,t),s(e,Qs,t),s(e,ap,t),s(e,Vs,t),s(e,up,t),s(e,mp,t),s(e,pp,t),s(e,Ss,t),s(e,cp,t),p(Os,e,t),s(e,fp,t),s(e,Fs,t),s(e,Tp,t),s(e,Ys,t),s(e,hp,t),s(e,Ws,t),s(e,_p,t),s(e,$p,t),s(e,bp,t),s(e,Gs,t),s(e,vp,t),p(Xs,e,t),s(e,yp,t),s(e,Zs,t),s(e,Mp,t),s(e,eo,t),s(e,xp,t),s(e,to,t),s(e,Cp,t),s(e,Hp,t),s(e,Lp,t),s(e,lo,t),s(e,wp,t),p(so,e,t),s(e,Ap,t),s(e,oo,t),s(e,gp,t),s(e,no,t),s(e,Pp,t),s(e,ro,t),s(e,zp,t),s(e,Rp,t),s(e,Up,t),s(e,io,t),s(e,kp,t),p(ao,e,t),s(e,jp,t),s(e,uo,t),s(e,Ep,t),s(e,mo,t),s(e,Jp,t),s(e,po,t),s(e,Dp,t),s(e,Ip,t),s(e,qp,t),s(e,co,t),s(e,Kp,t),p(fo,e,t),s(e,Bp,t),s(e,To,t),s(e,Np,t),s(e,ho,t),s(e,Qp,t),s(e,_o,t),s(e,Vp,t),s(e,Sp,t),s(e,Op,t),s(e,$o,t),s(e,Fp,t),p(bo,e,t),s(e,Yp,t),s(e,vo,t),s(e,Wp,t),s(e,yo,t),s(e,Gp,t),s(e,Mo,t),s(e,Xp,t),s(e,Zp,t),s(e,ec,t),s(e,xo,t),s(e,tc,t),p(Co,e,t),s(e,lc,t),s(e,Ho,t),s(e,sc,t),s(e,Lo,t),s(e,oc,t),s(e,wo,t),s(e,nc,t),s(e,rc,t),s(e,ic,t),s(e,Ao,t),s(e,dc,t),p(go,e,t),s(e,ac,t),s(e,Po,t),s(e,uc,t),s(e,zo,t),s(e,mc,t),s(e,Ro,t),s(e,pc,t),s(e,cc,t),s(e,fc,t),s(e,Uo,t),s(e,Tc,t),p(ko,e,t),s(e,hc,t),s(e,jo,t),s(e,_c,t),s(e,Eo,t),s(e,$c,t),s(e,Jo,t),s(e,bc,t),s(e,vc,t),s(e,yc,t),s(e,Do,t),s(e,Mc,t),p(Io,e,t),s(e,xc,t),s(e,qo,t),s(e,Cc,t),s(e,Ko,t),s(e,Hc,t),s(e,Bo,t),s(e,Lc,t),s(e,wc,t),s(e,Ac,t),s(e,No,t),s(e,gc,t),p(Qo,e,t),s(e,Pc,t),s(e,Vo,t),s(e,zc,t),s(e,So,t),s(e,Rc,t),s(e,Oo,t),s(e,Uc,t),s(e,kc,t),s(e,jc,t),s(e,Fo,t),s(e,Ec,t),p(Yo,e,t),s(e,Jc,t),s(e,Wo,t),s(e,Dc,t),s(e,Go,t),s(e,Ic,t),s(e,Xo,t),s(e,qc,t),s(e,Kc,t),s(e,Bc,t),s(e,Zo,t),s(e,Nc,t),p(en,e,t),s(e,Qc,t),s(e,tn,t),s(e,Vc,t),s(e,ln,t),s(e,Sc,t),s(e,sn,t),s(e,Oc,t),s(e,Fc,t),s(e,Yc,t),s(e,on,t),s(e,Wc,t),p(nn,e,t),s(e,Gc,t),s(e,rn,t),s(e,Xc,t),s(e,dn,t),s(e,Zc,t),s(e,an,t),s(e,ef,t),s(e,tf,t),s(e,lf,t),s(e,un,t),s(e,sf,t),p(mn,e,t),s(e,of,t),s(e,pn,t),s(e,nf,t),s(e,cn,t),s(e,rf,t),s(e,fn,t),s(e,df,t),s(e,af,t),s(e,uf,t),s(e,Tn,t),s(e,mf,t),p(hn,e,t),s(e,pf,t),s(e,_n,t),s(e,cf,t),s(e,ff,t),s(e,Tf,t),s(e,$n,t),s(e,hf,t),p(bn,e,t),s(e,_f,t),s(e,vn,t),s(e,$f,t),s(e,yn,t),s(e,bf,t),s(e,Mn,t),s(e,vf,t),s(e,xn,t),s(e,yf,t),p(Cn,e,t),s(e,Mf,t),s(e,xf,t),s(e,Cf,t),s(e,Hn,t),s(e,Hf,t),p(Ln,e,t),s(e,Lf,t),s(e,wn,t),s(e,wf,t),s(e,Af,t),s(e,gf,t),s(e,An,t),s(e,Pf,t),p(gn,e,t),s(e,zf,t),s(e,Pn,t),s(e,Rf,t),s(e,Uf,t),s(e,kf,t),s(e,zn,t),s(e,jf,t),p(Rn,e,t),s(e,Ef,t),s(e,Un,t),s(e,Jf,t),s(e,kn,t),s(e,Df,t),p(jn,e,t),s(e,If,t),s(e,En,t),s(e,qf,t),p(Jn,e,t),s(e,Kf,t),s(e,Dn,t),s(e,Bf,t),p(In,e,t),s(e,Nf,t),s(e,Qf,t),s(e,Vf,t),p(qn,e,t),s(e,Sf,t),s(e,Nn,t),Of=!0},p:A_,i(e){Of||(c(v.$$.fragment,e),c(H.$$.fragment,e),c(g.$$.fragment,e),c(U.$$.fragment,e),c(J.$$.fragment,e),c(K.$$.fragment,e),c(V.$$.fragment,e),c(Y.$$.fragment,e),c(Z.$$.fragment,e),c(se.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(He.$$.fragment,e),c(ge.$$.fragment,e),c(Ue.$$.fragment,e),c(De.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(Ze.$$.fragment,e),c(ot.$$.fragment,e),c(at.$$.fragment,e),c(ft.$$.fragment,e),c(bt.$$.fragment,e),c(Ct.$$.fragment,e),c(gt.$$.fragment,e),c(Ut.$$.fragment,e),c(Et.$$.fragment,e),c(Dt.$$.fragment,e),c(qt.$$.fragment,e),c(Vt.$$.fragment,e),c(Wt.$$.fragment,e),c(tl.$$.fragment,e),c(rl.$$.fragment,e),c(ml.$$.fragment,e),c(hl.$$.fragment,e),c(vl.$$.fragment,e),c(Ll.$$.fragment,e),c(Pl.$$.fragment,e),c(El.$$.fragment,e),c(ql.$$.fragment,e),c(Ql.$$.fragment,e),c(Yl.$$.fragment,e),c(es.$$.fragment,e),c(os.$$.fragment,e),c(as.$$.fragment,e),c(cs.$$.fragment,e),c(_s.$$.fragment,e),c(Ms.$$.fragment,e),c(ws.$$.fragment,e),c(Rs.$$.fragment,e),c(Js.$$.fragment,e),c(Bs.$$.fragment,e),c(Os.$$.fragment,e),c(Xs.$$.fragment,e),c(so.$$.fragment,e),c(ao.$$.fragment,e),c(fo.$$.fragment,e),c(bo.$$.fragment,e),c(Co.$$.fragment,e),c(go.$$.fragment,e),c(ko.$$.fragment,e),c(Io.$$.fragment,e),c(Qo.$$.fragment,e),c(Yo.$$.fragment,e),c(en.$$.fragment,e),c(nn.$$.fragment,e),c(mn.$$.fragment,e),c(hn.$$.fragment,e),c(bn.$$.fragment,e),c(Cn.$$.fragment,e),c(Ln.$$.fragment,e),c(gn.$$.fragment,e),c(Rn.$$.fragment,e),c(jn.$$.fragment,e),c(Jn.$$.fragment,e),c(In.$$.fragment,e),c(qn.$$.fragment,e),Of=!0)},o(e){f(v.$$.fragment,e),f(H.$$.fragment,e),f(g.$$.fragment,e),f(U.$$.fragment,e),f(J.$$.fragment,e),f(K.$$.fragment,e),f(V.$$.fragment,e),f(Y.$$.fragment,e),f(Z.$$.fragment,e),f(se.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(He.$$.fragment,e),f(ge.$$.fragment,e),f(Ue.$$.fragment,e),f(De.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(Ze.$$.fragment,e),f(ot.$$.fragment,e),f(at.$$.fragment,e),f(ft.$$.fragment,e),f(bt.$$.fragment,e),f(Ct.$$.fragment,e),f(gt.$$.fragment,e),f(Ut.$$.fragment,e),f(Et.$$.fragment,e),f(Dt.$$.fragment,e),f(qt.$$.fragment,e),f(Vt.$$.fragment,e),f(Wt.$$.fragment,e),f(tl.$$.fragment,e),f(rl.$$.fragment,e),f(ml.$$.fragment,e),f(hl.$$.fragment,e),f(vl.$$.fragment,e),f(Ll.$$.fragment,e),f(Pl.$$.fragment,e),f(El.$$.fragment,e),f(ql.$$.fragment,e),f(Ql.$$.fragment,e),f(Yl.$$.fragment,e),f(es.$$.fragment,e),f(os.$$.fragment,e),f(as.$$.fragment,e),f(cs.$$.fragment,e),f(_s.$$.fragment,e),f(Ms.$$.fragment,e),f(ws.$$.fragment,e),f(Rs.$$.fragment,e),f(Js.$$.fragment,e),f(Bs.$$.fragment,e),f(Os.$$.fragment,e),f(Xs.$$.fragment,e),f(so.$$.fragment,e),f(ao.$$.fragment,e),f(fo.$$.fragment,e),f(bo.$$.fragment,e),f(Co.$$.fragment,e),f(go.$$.fragment,e),f(ko.$$.fragment,e),f(Io.$$.fragment,e),f(Qo.$$.fragment,e),f(Yo.$$.fragment,e),f(en.$$.fragment,e),f(nn.$$.fragment,e),f(mn.$$.fragment,e),f(hn.$$.fragment,e),f(bn.$$.fragment,e),f(Cn.$$.fragment,e),f(Ln.$$.fragment,e),f(gn.$$.fragment,e),f(Rn.$$.fragment,e),f(jn.$$.fragment,e),f(Jn.$$.fragment,e),f(In.$$.fragment,e),f(qn.$$.fragment,e),Of=!1},d(e){e&&(l(Qn),l(Bn),l(Vn),l(b),l(Sn),l(On),l(y),l(Fn),l(M),l(Yn),l(x),l(Wn),l(Gn),l(Xn),l(C),l(Zn),l(er),l(L),l(tr),l(w),l(lr),l(sr),l(or),l(A),l(nr),l(rr),l(P),l(ir),l(z),l(dr),l(ar),l(ur),l(R),l(mr),l(pr),l(k),l(cr),l(j),l(fr),l(Tr),l(hr),l(E),l(_r),l($r),l(D),l(br),l(I),l(vr),l(yr),l(Mr),l(q),l(xr),l(Cr),l(B),l(Hr),l(N),l(Lr),l(wr),l(Ar),l(Q),l(gr),l(Pr),l(S),l(zr),l(O),l(Rr),l(Ur),l(kr),l(F),l(jr),l(Er),l(W),l(Jr),l(G),l(Dr),l(Ir),l(qr),l(X),l(Kr),l(Br),l(ee),l(Nr),l(te),l(Qr),l(Vr),l(Sr),l(le),l(Or),l(Fr),l(oe),l(Yr),l(ne),l(Wr),l(re),l(Gr),l(Xr),l(Zr),l(ie),l(ei),l(ti),l(ae),l(li),l(ue),l(si),l(oi),l(ni),l(me),l(ri),l(ii),l(ce),l(di),l(fe),l(ai),l(ui),l(mi),l(Te),l(pi),l(ci),l(_e),l(fi),l($e),l(Ti),l(be),l(hi),l(_i),l($i),l(ve),l(bi),l(vi),l(Me),l(yi),l(xe),l(Mi),l(xi),l(Ci),l(Ce),l(Hi),l(Li),l(Le),l(wi),l(we),l(Ai),l(gi),l(Pi),l(Ae),l(zi),l(Ri),l(Pe),l(Ui),l(ze),l(ki),l(ji),l(Ei),l(Re),l(Ji),l(Di),l(ke),l(Ii),l(je),l(qi),l(Ee),l(Ki),l(Bi),l(Ni),l(Je),l(Qi),l(Vi),l(Ie),l(Si),l(qe),l(Oi),l(Ke),l(Fi),l(Yi),l(Wi),l(Be),l(Gi),l(Xi),l(Qe),l(Zi),l(Ve),l(ed),l(Se),l(td),l(ld),l(sd),l(Oe),l(od),l(nd),l(Ye),l(rd),l(We),l(id),l(Ge),l(dd),l(ad),l(ud),l(Xe),l(md),l(pd),l(et),l(cd),l(tt),l(fd),l(lt),l(Td),l(hd),l(_d),l(st),l($d),l(bd),l(nt),l(vd),l(rt),l(yd),l(it),l(Md),l(xd),l(Cd),l(dt),l(Hd),l(Ld),l(ut),l(wd),l(mt),l(Ad),l(pt),l(gd),l(Pd),l(zd),l(ct),l(Rd),l(Ud),l(Tt),l(kd),l(ht),l(jd),l(_t),l(Ed),l(Jd),l(Dd),l($t),l(Id),l(qd),l(vt),l(Kd),l(yt),l(Bd),l(Mt),l(Nd),l(Qd),l(Vd),l(xt),l(Sd),l(Od),l(Ht),l(Fd),l(Lt),l(Yd),l(wt),l(Wd),l(Gd),l(Xd),l(At),l(Zd),l(ea),l(Pt),l(ta),l(zt),l(la),l(sa),l(oa),l(Rt),l(na),l(ra),l(kt),l(ia),l(jt),l(da),l(aa),l(Jt),l(ua),l(ma),l(It),l(pa),l(ca),l(Kt),l(fa),l(Bt),l(Ta),l(Nt),l(ha),l(_a),l($a),l(Qt),l(ba),l(va),l(St),l(ya),l(Ot),l(Ma),l(Ft),l(xa),l(Ca),l(Ha),l(Yt),l(La),l(wa),l(Gt),l(Aa),l(Xt),l(ga),l(Zt),l(Pa),l(za),l(Ra),l(el),l(Ua),l(ka),l(ll),l(ja),l(sl),l(Ea),l(ol),l(Ja),l(Da),l(Ia),l(nl),l(qa),l(Ka),l(il),l(Ba),l(dl),l(Na),l(al),l(Qa),l(Va),l(Sa),l(ul),l(Oa),l(Fa),l(pl),l(Ya),l(cl),l(Wa),l(fl),l(Ga),l(Xa),l(Za),l(Tl),l(eu),l(tu),l(_l),l(lu),l($l),l(su),l(ou),l(nu),l(bl),l(ru),l(iu),l(yl),l(du),l(Ml),l(au),l(xl),l(uu),l(Cl),l(mu),l(pu),l(cu),l(Hl),l(fu),l(Tu),l(wl),l(hu),l(Al),l(_u),l($u),l(bu),l(gl),l(vu),l(yu),l(zl),l(Mu),l(Rl),l(xu),l(Ul),l(Cu),l(kl),l(Hu),l(Lu),l(wu),l(jl),l(Au),l(gu),l(Jl),l(Pu),l(Dl),l(zu),l(Ru),l(Uu),l(Il),l(ku),l(ju),l(Kl),l(Eu),l(Bl),l(Ju),l(Du),l(Iu),l(Nl),l(qu),l(Ku),l(Vl),l(Bu),l(Sl),l(Nu),l(Ol),l(Qu),l(Vu),l(Su),l(Fl),l(Ou),l(Fu),l(Wl),l(Yu),l(Gl),l(Wu),l(Xl),l(Gu),l(Xu),l(Zu),l(Zl),l(em),l(tm),l(ts),l(lm),l(ls),l(sm),l(om),l(nm),l(ss),l(rm),l(im),l(ns),l(dm),l(rs),l(am),l(is),l(um),l(mm),l(pm),l(ds),l(cm),l(fm),l(us),l(Tm),l(ms),l(hm),l(_m),l($m),l(ps),l(bm),l(vm),l(fs),l(ym),l(Ts),l(Mm),l(xm),l(Cm),l(hs),l(Hm),l(Lm),l($s),l(wm),l(bs),l(Am),l(vs),l(gm),l(Pm),l(zm),l(ys),l(Rm),l(Um),l(xs),l(km),l(Cs),l(jm),l(Hs),l(Em),l(Jm),l(Dm),l(Ls),l(Im),l(qm),l(As),l(Km),l(gs),l(Bm),l(Ps),l(Nm),l(Qm),l(Vm),l(zs),l(Sm),l(Om),l(Us),l(Fm),l(ks),l(Ym),l(js),l(Wm),l(Gm),l(Xm),l(Es),l(Zm),l(ep),l(Ds),l(tp),l(Is),l(lp),l(qs),l(sp),l(op),l(np),l(Ks),l(rp),l(ip),l(Ns),l(dp),l(Qs),l(ap),l(Vs),l(up),l(mp),l(pp),l(Ss),l(cp),l(fp),l(Fs),l(Tp),l(Ys),l(hp),l(Ws),l(_p),l($p),l(bp),l(Gs),l(vp),l(yp),l(Zs),l(Mp),l(eo),l(xp),l(to),l(Cp),l(Hp),l(Lp),l(lo),l(wp),l(Ap),l(oo),l(gp),l(no),l(Pp),l(ro),l(zp),l(Rp),l(Up),l(io),l(kp),l(jp),l(uo),l(Ep),l(mo),l(Jp),l(po),l(Dp),l(Ip),l(qp),l(co),l(Kp),l(Bp),l(To),l(Np),l(ho),l(Qp),l(_o),l(Vp),l(Sp),l(Op),l($o),l(Fp),l(Yp),l(vo),l(Wp),l(yo),l(Gp),l(Mo),l(Xp),l(Zp),l(ec),l(xo),l(tc),l(lc),l(Ho),l(sc),l(Lo),l(oc),l(wo),l(nc),l(rc),l(ic),l(Ao),l(dc),l(ac),l(Po),l(uc),l(zo),l(mc),l(Ro),l(pc),l(cc),l(fc),l(Uo),l(Tc),l(hc),l(jo),l(_c),l(Eo),l($c),l(Jo),l(bc),l(vc),l(yc),l(Do),l(Mc),l(xc),l(qo),l(Cc),l(Ko),l(Hc),l(Bo),l(Lc),l(wc),l(Ac),l(No),l(gc),l(Pc),l(Vo),l(zc),l(So),l(Rc),l(Oo),l(Uc),l(kc),l(jc),l(Fo),l(Ec),l(Jc),l(Wo),l(Dc),l(Go),l(Ic),l(Xo),l(qc),l(Kc),l(Bc),l(Zo),l(Nc),l(Qc),l(tn),l(Vc),l(ln),l(Sc),l(sn),l(Oc),l(Fc),l(Yc),l(on),l(Wc),l(Gc),l(rn),l(Xc),l(dn),l(Zc),l(an),l(ef),l(tf),l(lf),l(un),l(sf),l(of),l(pn),l(nf),l(cn),l(rf),l(fn),l(df),l(af),l(uf),l(Tn),l(mf),l(pf),l(_n),l(cf),l(ff),l(Tf),l($n),l(hf),l(_f),l(vn),l($f),l(yn),l(bf),l(Mn),l(vf),l(xn),l(yf),l(Mf),l(xf),l(Cf),l(Hn),l(Hf),l(Lf),l(wn),l(wf),l(Af),l(gf),l(An),l(Pf),l(zf),l(Pn),l(Rf),l(Uf),l(kf),l(zn),l(jf),l(Ef),l(Un),l(Jf),l(kn),l(Df),l(If),l(En),l(qf),l(Kf),l(Dn),l(Bf),l(Nf),l(Qf),l(Vf),l(Sf),l(Nn)),l($),T(v,e),T(H,e),T(g,e),T(U,e),T(J,e),T(K,e),T(V,e),T(Y,e),T(Z,e),T(se,e),T(de,e),T(pe,e),T(he,e),T(ye,e),T(He,e),T(ge,e),T(Ue,e),T(De,e),T(Ne,e),T(Fe,e),T(Ze,e),T(ot,e),T(at,e),T(ft,e),T(bt,e),T(Ct,e),T(gt,e),T(Ut,e),T(Et,e),T(Dt,e),T(qt,e),T(Vt,e),T(Wt,e),T(tl,e),T(rl,e),T(ml,e),T(hl,e),T(vl,e),T(Ll,e),T(Pl,e),T(El,e),T(ql,e),T(Ql,e),T(Yl,e),T(es,e),T(os,e),T(as,e),T(cs,e),T(_s,e),T(Ms,e),T(ws,e),T(Rs,e),T(Js,e),T(Bs,e),T(Os,e),T(Xs,e),T(so,e),T(ao,e),T(fo,e),T(bo,e),T(Co,e),T(go,e),T(ko,e),T(Io,e),T(Qo,e),T(Yo,e),T(en,e),T(nn,e),T(mn,e),T(hn,e),T(bn,e),T(Cn,e),T(Ln,e),T(gn,e),T(Rn,e),T(jn,e),T(Jn,e),T(In,e),T(qn,e)}}}const E_='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.location : <code> string </code>","local":"tensorlocation--code-string-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map_(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div_(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub_(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clone() ⇒ <code> Tensor </code>","local":"tensorclone--code-tensor-code","sections":[],"depth":3},{"title":"tensor.slice(...slices) ⇒ <code> Tensor </code>","local":"tensorsliceslices--code-tensor-code","sections":[],"depth":3},{"title":"tensor.permute(...dims) ⇒ <code> Tensor </code>","local":"tensorpermutedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒ <code> Tensor </code>","local":"tensorsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>","local":"tensorunsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>","local":"tensorflattenstartdim-enddim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒ <code> Tensor </code>","local":"tensorclampmin-max--code-tensor-code","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒ <code> Tensor </code>","local":"tensorround--code-tensor-code","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensorpermutetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorinterpolate4dinput-options--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensormatmula-b--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorrfftx-a--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.topk(x, [k]) ⇒ <code> * </code>","local":"utilstensortopkx-k--code--code","sections":[],"depth":2},{"title":"utils/tensor.slice(data:, starts:, ends:, axes:, [steps]) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorslicedata-starts-ends-axes-steps--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>","local":"utilstensormeaninput-dim-keepdim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>","local":"utilstensorfullsize-fillvalue--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones(size) ⇒ <code> Tensor </code>","local":"utilstensoronessize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensoronesliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros(size) ⇒ <code> Tensor </code>","local":"utilstensorzerossize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensorzerosliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.rand(size) ⇒ <code> Tensor </code>","local":"utilstensorrandsize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>","local":"utilstensorquantizeembeddingstensor-precision--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> ONNXTensor </code>","local":"utilstensorargs0--code-onnxtensor-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function J_(Ff){return g_(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class B_ extends P_{constructor($){super(),z_(this,$,J_,j_,w_,{})}}export{B_ as component};
