import{s as pd,o as ud,n as J}from"../chunks/scheduler.6062bdaf.js";import{S as gd,i as md,g,s as r,r as h,A as hd,h as m,f as p,c as i,j as C,u as d,x as I,k as U,y as l,a as _,v as f,d as y,t as M,w as b}from"../chunks/index.4bca734e.js";import{T as N}from"../chunks/Tip.b9ac1f03.js";import{D as q}from"../chunks/Docstring.d7918b6d.js";import{C as $}from"../chunks/CodeBlock.fa01571c.js";import{E as A}from"../chunks/ExampleCodeBlock.d27cbfa4.js";import{H as it,E as dd}from"../chunks/EditOnGithub.74ab2baa.js";function fd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function yd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBYXVkaW9fb3V0cHV0JTIwJTNEJTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBZm9yJTIwaSUyQyUyMGl0ZW0lMjBpbiUyMGVudW1lcmF0ZShhdWRpb19vdXRwdXQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oZiUyMm91dHB1dF8lN0JpJTdELmZsYWMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Md(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function bd(T){let n,u=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-9iksi9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function jd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function _d(T){let n,u="Example (stream=True):",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBZm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1cae0d6"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Td(T){let n,u="Example using OpenAI’s syntax:",a,t,o;return t=new $({props:{code:"JTIzJTIwaW5zdGVhZCUyMG9mJTIwJTYwZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSU2MCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QuLi4lMkMlMEEpJTBBJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDb3VudCUyMHRvJTIwMTAlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMjQlMkMlMEEpJTBBJTBBZm9yJTIwY2h1bmslMjBpbiUyMG91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQp",highlighted:`<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = InferenceClient(
    base_url=...,
    api_key=...,
)

output = client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-i0a0yp"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Id(T){let n,u="Example using tools:",a,t,o;return t=new $({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1ksikbz"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Jd(T){let n,u="Example using response_format:",a,t,o;return t=new $({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1klcxsv"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function xd(T){let n,u=`<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">InferenceClient.conversational()</a> API is deprecated and will be removed in a future release. Please use
<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> instead.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-r43x4s"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function wd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUyMkhpJTJDJTIwd2hvJTIwYXJlJTIweW91JTNGJTIyKSUwQW91dHB1dCUwQWNsaWVudC5jb252ZXJzYXRpb25hbCglMEElMjAlMjAlMjAlMjAlMjJXb3clMkMlMjB0aGF0J3MlMjBzY2FyeSElMjIlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfcmVzcG9uc2VzJTNEb3V0cHV0JTVCJTIyY29udmVyc2F0aW9uJTIyJTVEJTVCJTIyZ2VuZXJhdGVkX3Jlc3BvbnNlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhc3RfdXNlcl9pbnB1dHMlM0RvdXRwdXQlNUIlMjJjb252ZXJzYXRpb24lMjIlNUQlNUIlMjJwYXN0X3VzZXJfaW5wdXRzJTIyJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = client.conversational(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>, <span class="hljs-string">&#x27;conversation&#x27;</span>: {<span class="hljs-string">&#x27;generated_responses&#x27;</span>: [<span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>], <span class="hljs-string">&#x27;past_user_inputs&#x27;</span>: [<span class="hljs-string">&#x27;Hi, who are you?&#x27;</span>]}, <span class="hljs-string">&#x27;warnings&#x27;</span>: [<span class="hljs-string">&#x27;Setting \`pad_token_id\` to \`eos_token_id\`:50256 for open-end generation.&#x27;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.conversational(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Wow, that&#x27;s scary!&quot;</span>,
<span class="hljs-meta">... </span>    generated_responses=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;generated_responses&quot;</span>],
<span class="hljs-meta">... </span>    past_user_inputs=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;past_user_inputs&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Cd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(score=<span class="hljs-number">0.42515629529953003</span>, answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, start=<span class="hljs-number">16</span>, end=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Ud(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function $d(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function vd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEFjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function kd(T){let n,u=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1xcqxp5"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function qd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_model_status(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Ad(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmp6Z3UwYnVlaTUudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIpJTBBY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Ed(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(score=<span class="hljs-number">0.9779096841812134</span>, label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Zd(T){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Nd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKSUzQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>):
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Wd(T){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Gd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Bd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFjbGllbnQuaW1hZ2VfdG9fdGV4dCglMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Qd(T){let n,u=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11ftl3v"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Vd(T){let n,u=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1kgqbcg"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Yd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBbW9kZWxzJTIwJTNEJTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFjbGllbnQubGlzdF9kZXBsb3llZF9tb2RlbHMoJTIydGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Sd(T){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Xd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMiklM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>):
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Rd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(score=<span class="hljs-number">0.9326562285423279</span>, start=<span class="hljs-number">11</span>, end=<span class="hljs-number">16</span>, answer=<span class="hljs-string">&#x27;Clara&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Dd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Hd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Fd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcXVlcnklMjAlM0QlMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMEF0YWJsZSUyMCUzRCUyMCU3QiUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlN0QlMEFjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function zd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMkMlMEElN0QlMEFjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Ld(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJIZWlnaHQlMjIlM0ElMjAlNUIlMjIxMS41MiUyMiUyQyUyMCUyMjEyLjQ4JTIyJTJDJTIwJTIyMTIuMzc3OCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDElMjIlM0ElMjAlNUIlMjIyMy4yJTIyJTJDJTIwJTIyMjQlMjIlMkMlMjAlMjIyMy45JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMiUyMiUzQSUyMCU1QiUyMjI1LjQlMjIlMkMlMjAlMjIyNi4zJTIyJTJDJTIwJTIyMjYuNSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDMlMjIlM0ElMjAlNUIlMjIzMCUyMiUyQyUyMCUyMjMxLjIlMjIlMkMlMjAlMjIzMS4xJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyU3BlY2llcyUyMiUzQSUyMCU1QiUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMldpZHRoJTIyJTNBJTIwJTVCJTIyNC4wMiUyMiUyQyUyMCUyMjQuMzA1NiUyMiUyQyUyMCUyMjQuNjk2MSUyMiU1RCUyQyUwQSU3RCUwQWNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Od(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Pd(T){let n,u=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1yavfy1"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Kd(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBodWdnaW5nZmFjZV9odWIlMjBsaWJyYXJ5JTIwaXMlMjAlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyKSUwQSUwQWZvciUyMHRva2VuJTIwaW4lMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMlRoZSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxpYnJhcnklMjBpcyUyMCUyMiUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTIlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKSUwQSUwQWNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTIyVGhlJTIwaHVnZ2luZ2ZhY2VfaHViJTIwbGlicmFyeSUyMGlzJTIwJTIyJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMiUyQyUyMGRldGFpbHMlM0RUcnVlKSUwQSUwQWZvciUyMGRldGFpbHMlMjBpbiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTIyVGhlJTIwaHVnZ2luZ2ZhY2VfaHViJTIwbGlicmFyeSUyMGlzJTIwJTIyJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMiUyQyUyMGRldGFpbHMlM0RUcnVlJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludChkZXRhaWxzKSUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJJJTIwc2F3JTIwYSUyMHB1cHB5JTIwYSUyMGNhdCUyMGFuZCUyMGElMjByYWNjb29uJTIwZHVyaW5nJTIwbXklMjBiaWtlJTIwcmlkZSUyMGluJTIwdGhlJTIwcGFyayUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci1vcnBvLTE0MWItQTM1Yi12MC4xJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjMlMkMlMEElMjAlMjAlMjAlMjBncmFtbWFyJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmpzb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2YWx1ZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnByb3BlcnRpZXMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb2NhdGlvbiUyMiUzQSUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJzdHJpbmclMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhY3Rpdml0eSUyMiUzQSUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJzdHJpbmclMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbmltYWxzX3NlZW4lMjIlM0ElMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW50ZWdlciUyMiUyQyUyMCUyMm1pbmltdW0lMjIlM0ElMjAxJTJDJTIwJTIybWF4aW11bSUyMiUzQSUyMDUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbmltYWxzJTIyJTNBJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMmFycmF5JTIyJTJDJTIwJTIyaXRlbXMlMjIlM0ElMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTdEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVxdWlyZWQlMjIlM0ElMjAlNUIlMjJsb2NhdGlvbiUyMiUyQyUyMCUyMmFjdGl2aXR5JTIyJTJDJTIwJTIyYW5pbWFsc19zZWVuJTIyJTJDJTIwJTIyYW5pbWFscyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEFqc29uLmxvYWRzKHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function ef(T){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function nf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybG93JTIwcmVzb2x1dGlvbiUyQyUyMGJsdXJyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmJldHRlcl9hc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function tf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBYXVkaW8lMjAlM0QlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function sf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function af(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWNsaWVudC50cmFuc2xhdGlvbiglMjJNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiUyMiUyQyUyMG1vZGVsJTNEJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1mciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function lf(T){let n,u="Specifying languages:",a,t,o;return t=new $({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-mhcj6c"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function of(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function rf(T){let n,u="Example with <code>multi_label=False</code>:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGV4dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBJTIwbmV3JTIwbW9kZWwlMjBvZmZlcnMlMjBhbiUyMGV4cGxhbmF0aW9uJTIwZm9yJTIwaG93JTIwdGhlJTIwR2FsaWxlYW4lMjBzYXRlbGxpdGVzJTIwZm9ybWVkJTIwYXJvdW5kJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0ncyUyMiUwQSUyMCUyMCUyMCUyMCUyMmxhcmdlc3QlMjB3b3JsZC4lMjBLb25zdGFudGluJTIwQmF0eWdpbiUyMGRpZCUyMG5vdCUyMHNldCUyMG91dCUyMHRvJTIwc29sdmUlMjBvbmUlMjBvZiUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjBtb3N0JTIwcHV6emxpbmclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjBteXN0ZXJpZXMlMjB3aGVuJTIwaGUlMjB3ZW50JTIwZm9yJTIwYSUyMHJ1biUyMHVwJTIwYSUyMGhpbGwlMjBpbiUyME5pY2UlMkMlMjBGcmFuY2UuJTIyJTBBKSUwQWxhYmVscyUyMCUzRCUyMCU1QiUyMnNwYWNlJTIwJTI2JTIwY29zbW9zJTIyJTJDJTIwJTIyc2NpZW50aWZpYyUyMGRpc2NvdmVyeSUyMiUyQyUyMCUyMm1pY3JvYmlvbG9neSUyMiUyQyUyMCUyMnJvYm90cyUyMiUyQyUyMCUyMmFyY2hlb2xvZ3klMjIlNUQlMEFjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.innerHTML=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-90ztrp"&&(n.innerHTML=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function cf(T){let n,u="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=g("p"),n.innerHTML=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1qklg9x"&&(n.innerHTML=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function pf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function uf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function gf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF1ZGlvX291dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBYXN5bmMlMjBmb3IlMjBpJTJDJTIwaXRlbSUyMGluJTIwZW51bWVyYXRlKGF1ZGlvX291dHB1dCklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbihmJTIyb3V0cHV0XyU3QmklN0QuZmxhYyUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = <span class="hljs-keyword">await</span> client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function mf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function hf(T){let n,u=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-9iksi9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function df(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function ff(T){let n,u="Example (stream=True):",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMCUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4p",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1cae0d6"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function yf(T){let n,u="Example using OpenAI’s syntax:",a,t,o;return t=new $({props:{code:"JTIzJTIwTXVzdCUyMGJlJTIwcnVuJTIwaW4lMjBhbiUyMGFzeW5jJTIwY29udGV4dCUwQSUyMyUyMGluc3RlYWQlMjBvZiUyMCU2MGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklNjAlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNELi4uJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRC4uLiUyQyUwQSklMEElMEFvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = AsyncInferenceClient(
    base_url=...,
    api_key=...,
)

output = <span class="hljs-keyword">await</span> client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-i0a0yp"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Mf(T){let n,u="Example using tools:",a,t,o;return t=new $({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1ksikbz"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function bf(T){let n,u="Example using response_format:",a,t,o;return t=new $({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1klcxsv"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function jf(T){let n,u=`<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">InferenceClient.conversational()</a> API is deprecated and will be removed in a future release. Please use
<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> instead.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-r43x4s"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function _f(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQW91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUyMkhpJTJDJTIwd2hvJTIwYXJlJTIweW91JTNGJTIyKSUwQW91dHB1dCUwQWF3YWl0JTIwY2xpZW50LmNvbnZlcnNhdGlvbmFsKCUwQSUyMCUyMCUyMCUyMCUyMldvdyUyQyUyMHRoYXQncyUyMHNjYXJ5ISUyMiUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9yZXNwb25zZXMlM0RvdXRwdXQlNUIlMjJjb252ZXJzYXRpb24lMjIlNUQlNUIlMjJnZW5lcmF0ZWRfcmVzcG9uc2VzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFzdF91c2VyX2lucHV0cyUzRG91dHB1dCU1QiUyMmNvbnZlcnNhdGlvbiUyMiU1RCU1QiUyMnBhc3RfdXNlcl9pbnB1dHMlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = <span class="hljs-keyword">await</span> client.conversational(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>, <span class="hljs-string">&#x27;conversation&#x27;</span>: {<span class="hljs-string">&#x27;generated_responses&#x27;</span>: [<span class="hljs-string">&#x27;I am the one who knocks.&#x27;</span>], <span class="hljs-string">&#x27;past_user_inputs&#x27;</span>: [<span class="hljs-string">&#x27;Hi, who are you?&#x27;</span>]}, <span class="hljs-string">&#x27;warnings&#x27;</span>: [<span class="hljs-string">&#x27;Setting \`pad_token_id\` to \`eos_token_id\`:50256 for open-end generation.&#x27;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.conversational(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Wow, that&#x27;s scary!&quot;</span>,
<span class="hljs-meta">... </span>    generated_responses=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;generated_responses&quot;</span>],
<span class="hljs-meta">... </span>    past_user_inputs=output[<span class="hljs-string">&quot;conversation&quot;</span>][<span class="hljs-string">&quot;past_user_inputs&quot;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Tf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(score=<span class="hljs-number">0.42515629529953003</span>, answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, start=<span class="hljs-number">16</span>, end=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function If(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Jf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function xf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBYXdhaXQlMjBjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function wf(T){let n,u=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1xcqxp5"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Cf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_model_status(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Uf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIyaHR0cHMlM0ElMkYlMkZqemd1MGJ1ZWk1LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTIyKSUwQWF3YWl0JTIwY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function $f(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(score=<span class="hljs-number">0.9779096841812134</span>, label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function vf(T){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function kf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKSUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>):
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function qf(T){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Af(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Ef(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFhd2FpdCUyMGNsaWVudC5pbWFnZV90b190ZXh0KCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Zf(T){let n,u=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11ftl3v"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Nf(T){let n,u=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1kgqbcg"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Wf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQW1vZGVscyUyMCUzRCUyMGF3YWl0JTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFhd2FpdCUyMGNsaWVudC5saXN0X2RlcGxveWVkX21vZGVscyglMjJ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async contextthon</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = <span class="hljs-keyword">await</span> client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Gf(T){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Bf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMiklM0E=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>):
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Qf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(score=<span class="hljs-number">0.9326562285423279</span>, start=<span class="hljs-number">11</span>, end=<span class="hljs-number">16</span>, answer=<span class="hljs-string">&#x27;Clara&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Vf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Yf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Sf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXF1ZXJ5JTIwJTNEJTIwJTIySG93JTIwbWFueSUyMHN0YXJzJTIwZG9lcyUyMHRoZSUyMHRyYW5zZm9ybWVycyUyMHJlcG9zaXRvcnklMjBoYXZlJTNGJTIyJTBBdGFibGUlMjAlM0QlMjAlN0IlMjJSZXBvc2l0b3J5JTIyJTNBJTIwJTVCJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyRGF0YXNldHMlMjIlMkMlMjAlMjJUb2tlbml6ZXJzJTIyJTVEJTJDJTIwJTIyU3RhcnMlMjIlM0ElMjAlNUIlMjIzNjU0MiUyMiUyQyUyMCUyMjQ1MTIlMjIlMkMlMjAlMjIzOTM0JTIyJTVEJTdEJTBBYXdhaXQlMjBjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Xf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZml4ZWRfYWNpZGl0eSUyMiUzQSUyMCU1QiUyMjcuNCUyMiUyQyUyMCUyMjcuOCUyMiUyQyUyMCUyMjEwLjMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2b2xhdGlsZV9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyMC43JTIyJTJDJTIwJTIyMC44OCUyMiUyQyUyMCUyMjAuMzIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaXRyaWNfYWNpZCUyMiUzQSUyMCU1QiUyMjAlMjIlMkMlMjAlMjIwJTIyJTJDJTIwJTIyMC40NSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlc2lkdWFsX3N1Z2FyJTIyJTNBJTIwJTVCJTIyMS45JTIyJTJDJTIwJTIyMi42JTIyJTJDJTIwJTIyNi40JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hsb3JpZGVzJTIyJTNBJTIwJTVCJTIyMC4wNzYlMjIlMkMlMjAlMjIwLjA5OCUyMiUyQyUyMCUyMjAuMDczJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnJlZV9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjExJTIyJTJDJTIwJTIyMjUlMjIlMkMlMjAlMjI1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydG90YWxfc3VsZnVyX2Rpb3hpZGUlMjIlM0ElMjAlNUIlMjIzNCUyMiUyQyUyMCUyMjY3JTIyJTJDJTIwJTIyMTMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZW5zaXR5JTIyJTNBJTIwJTVCJTIyMC45OTc4JTIyJTJDJTIwJTIyMC45OTY4JTIyJTJDJTIwJTIyMC45OTc2JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycEglMjIlM0ElMjAlNUIlMjIzLjUxJTIyJTJDJTIwJTIyMy4yJTIyJTJDJTIwJTIyMy4yMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnN1bHBoYXRlcyUyMiUzQSUyMCU1QiUyMjAuNTYlMjIlMkMlMjAlMjIwLjY4JTIyJTJDJTIwJTIyMC44MiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmFsY29ob2wlMjIlM0ElMjAlNUIlMjI5LjQlMjIlMkMlMjAlMjI5LjglMjIlMkMlMjAlMjIxMi42JTIyJTVEJTJDJTBBJTdEJTBBYXdhaXQlMjBjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Rf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIySGVpZ2h0JTIyJTNBJTIwJTVCJTIyMTEuNTIlMjIlMkMlMjAlMjIxMi40OCUyMiUyQyUyMCUyMjEyLjM3NzglMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgxJTIyJTNBJTIwJTVCJTIyMjMuMiUyMiUyQyUyMCUyMjI0JTIyJTJDJTIwJTIyMjMuOSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDIlMjIlM0ElMjAlNUIlMjIyNS40JTIyJTJDJTIwJTIyMjYuMyUyMiUyQyUyMCUyMjI2LjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgzJTIyJTNBJTIwJTVCJTIyMzAlMjIlMkMlMjAlMjIzMS4yJTIyJTJDJTIwJTIyMzEuMSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMlNwZWNpZXMlMjIlM0ElMjAlNUIlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJXaWR0aCUyMiUzQSUyMCU1QiUyMjQuMDIlMjIlMkMlMjAlMjI0LjMwNTYlMjIlMkMlMjAlMjI0LjY5NjElMjIlNUQlMkMlMEElN0QlMEFhd2FpdCUyMGNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Df(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Hf(T){let n,u=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1yavfy1"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Ff(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function zf(T){let n,u="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=g("p"),n.innerHTML=u},l(a){n=m(a,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=u)},m(a,t){_(a,n,t)},p:J,d(a){a&&p(n)}}}function Lf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJsb3clMjByZXNvbHV0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYmV0dGVyX2FzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Of(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF1ZGlvJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-keyword">await</span> client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Pf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function Kf(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyJTJDJTIwbW9kZWwlM0QlMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWZyJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function ey(T){let n,u="Specifying languages:",a,t,o;return t=new $({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-mhcj6c"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function ny(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function ty(T){let n,u="Example with <code>multi_label=False</code>:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG5ldyUyMG1vZGVsJTIwb2ZmZXJzJTIwYW4lMjBleHBsYW5hdGlvbiUyMGZvciUyMGhvdyUyMHRoZSUyMEdhbGlsZWFuJTIwc2F0ZWxsaXRlcyUyMGZvcm1lZCUyMGFyb3VuZCUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjIlMEElMjAlMjAlMjAlMjAlMjJsYXJnZXN0JTIwd29ybGQuJTIwS29uc3RhbnRpbiUyMEJhdHlnaW4lMjBkaWQlMjBub3QlMjBzZXQlMjBvdXQlMjB0byUyMHNvbHZlJTIwb25lJTIwb2YlMjB0aGUlMjBzb2xhciUyMHN5c3RlbSdzJTIwbW9zdCUyMHB1enpsaW5nJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTIwbXlzdGVyaWVzJTIwd2hlbiUyMGhlJTIwd2VudCUyMGZvciUyMGElMjBydW4lMjB1cCUyMGElMjBoaWxsJTIwaW4lMjBOaWNlJTJDJTIwRnJhbmNlLiUyMiUwQSklMEFsYWJlbHMlMjAlM0QlMjAlNUIlMjJzcGFjZSUyMCUyNiUyMGNvc21vcyUyMiUyQyUyMCUyMnNjaWVudGlmaWMlMjBkaXNjb3ZlcnklMjIlMkMlMjAlMjJtaWNyb2Jpb2xvZ3klMjIlMkMlMjAlMjJyb2JvdHMlMjIlMkMlMjAlMjJhcmNoZW9sb2d5JTIyJTVEJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMlMkMlMjBtdWx0aV9sYWJlbCUzRFRydWUp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=g("p"),n.innerHTML=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-90ztrp"&&(n.innerHTML=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function sy(T){let n,u="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=g("p"),n.innerHTML=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1qklg9x"&&(n.innerHTML=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function ay(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function ly(T){let n,u="Example:",a,t,o;return t=new $({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.inference_api <span class="hljs-keyword">import</span> InferenceApi

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask-fill example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Question Answering example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>,
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9326569437980652</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Clara&#x27;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Zero-shot example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>: [<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Overriding configured task</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Text-to-image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(<span class="hljs-string">&quot;cat&quot;</span>)
&lt;PIL.PngImagePlugin.PngImageFile image (...)&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Return as raw response to parse the output yourself</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;mio/amadeus&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = inference(<span class="hljs-string">&quot;hello world&quot;</span>, raw_response=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.headers
{<span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;audio/flac&quot;</span>, ...}
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes from server</span>
<span class="hljs-string">b&#x27;(...)&#x27;</span>`,wrap:!1}}),{c(){n=g("p"),n.textContent=u,a=r(),h(t.$$.fragment)},l(e){n=m(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=u),a=i(e),d(t.$$.fragment,e)},m(e,c){_(e,n,c),_(e,a,c),f(t,e,c),o=!0},p:J,i(e){o||(y(t.$$.fragment,e),o=!0)},o(e){M(t.$$.fragment,e),o=!1},d(e){e&&(p(n),p(a)),b(t,e)}}}function oy(T){let n,u,a,t,o,e,c,Kg="추론은 학습된 모델을 사용하여 새로운 데이터를 예측하는 과정입니다. 이 과정은 계산량이 많을 수 있기 때문에, 전용 서버에서 실행하는 것이 흥미로운 옵션이 될 수 있습니다. <code>huggingface_hub</code> 라이브러리는 호스팅된 모델에 대한 추론을 실행하는 간단한 방법을 제공합니다. 연결할 수 있는 서비스는 여러가지가 있습니다:",Br,aa,em='<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">추론 API</a>: Hugging Face의 인프라에서 가속화된 추론을 무료로 실행할 수 있는 서비스입니다. 이 서비스는 시작하기 위한 빠른 방법이며, 다양한 모델을 테스트하고 AI 제품을 프로토타입화하는 데에도 유용합니다.</li> <li><a href="https://huggingface.co/inference-endpoints" rel="nofollow">추론 엔드포인트</a>: 모델을 쉽게 운영 환경으로 배포할 수 있는 제품입니다. 추론은 여러분이 선택한 클라우드 제공업체의 전용 및 완전히 관리되는 인프라에서 Hugging Face에 의해 실행됩니다.</li>',Qr,la,nm='이러한 서비스는 <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> 객체를 사용하여 호출할 수 있습니다. 자세한 사용 방법에 대해서는 <a href="../guides/inference">이 가이드</a>를 참조해주세요.',Vr,oa,Yr,x,ra,ci,Pl,tm="Initialize a new Inference Client.",pi,Kl,sm=`<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API or self-hosted Inference Endpoints.`,ui,Be,ia,gi,eo,am="Perform audio classification on the provided audio content.",mi,ct,hi,Qe,ca,di,no,lm="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",fi,pt,yi,Ve,pa,Mi,to,om="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",bi,ut,ji,E,ua,_i,so,rm="A method for completing conversations using a specified language model.",Ti,gt,Ii,mt,Ji,ht,xi,dt,wi,ft,Ci,yt,Ui,K,ga,$i,ao,im="Generate conversational responses based on the given input text (i.e. chat with the API).",vi,Mt,ki,bt,qi,Ye,ma,Ai,lo,cm="Answer questions on document images.",Ei,jt,Zi,Se,ha,Ni,oo,pm="Generate embeddings for a given text.",Wi,_t,Gi,Xe,da,Bi,ro,um="Fill in a hole with a missing word (token to be precise).",Qi,Tt,Vi,ee,fa,Yi,io,gm="Get information about the deployed endpoint.",Si,co,mm=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,Xi,It,Ri,ne,ya,Di,po,hm="Get the status of a model hosted on the Inference API.",Hi,Jt,Fi,xt,zi,wt,Ma,Li,uo,dm="Get the model Hugging Face recommends for the input task.",Oi,te,ba,Pi,go,fm="Check the health of the deployed endpoint.",Ki,mo,ym=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,ec,Ct,nc,Re,ja,tc,ho,Mm="Perform image classification on the given image using the specified model.",sc,Ut,ac,se,_a,lc,fo,bm="Perform image segmentation on the given image using the specified model.",oc,$t,rc,vt,ic,ae,Ta,cc,yo,jm="Perform image-to-image translation using a specified model.",pc,kt,uc,qt,gc,le,Ia,mc,Mo,_m="Takes an input image and return text.",hc,bo,Tm=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,dc,At,fc,B,Ja,yc,jo,Im="List models deployed on the Serverless Inference API service.",Mc,_o,Jm=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,bc,Et,jc,Zt,_c,Nt,Tc,oe,xa,Ic,To,xm="Perform object detection on the given image using the specified model.",Jc,Wt,xc,Gt,wc,Bt,wa,Cc,Io,wm="Make a POST request to the inference server.",Uc,De,Ca,$c,Jo,Cm="Retrieve the answer to a question from a given text.",vc,Qt,kc,He,Ua,qc,xo,Um="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",Ac,Vt,Ec,Fe,$a,Zc,wo,$m="Generate a summary of a given text using a specified model.",Nc,Yt,Wc,ze,va,Gc,Co,vm="Retrieve the answer to a question from information given in a table.",Bc,St,Qc,Le,ka,Vc,Uo,km="Classifying a target category (a group) based on a set of attributes.",Yc,Xt,Sc,Oe,qa,Xc,$o,qm="Predicting a numerical target value given a set of attributes/features in a table.",Rc,Rt,Dc,Pe,Aa,Hc,vo,Am="Perform text classification (e.g. sentiment-analysis) on the given text.",Fc,Dt,zc,Q,Ea,Lc,ko,Em="Given a prompt, generate the following text.",Oc,qo,Zm=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,Pc,Ao,Nm='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',Kc,Ht,ep,Ft,np,re,Za,tp,Eo,Wm="Generate an image based on a given text using a specified model.",sp,zt,ap,Lt,lp,Ke,Na,op,Zo,Gm="Synthesize an audio of a voice pronouncing a given text.",rp,Ot,ip,en,Wa,cp,No,Bm=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,pp,Pt,up,F,Ga,gp,Wo,Qm="Convert text from one language to another.",mp,Go,Vm=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.
You can find this information in the model card.`,hp,Kt,dp,es,fp,nn,Ba,yp,Bo,Ym="Answering open-ended questions based on an image.",Mp,ns,bp,ie,Qa,jp,Qo,Sm="Provide as input a text and a set of candidate labels to classify the input text.",_p,ts,Tp,ss,Ip,tn,Va,Jp,Vo,Xm="Provide input image and text labels to predict text labels for the image.",xp,as,Sr,Ya,Xr,Sa,Rm=`비동기 버전의 클라이언트도 제공되며, 이는 <code>asyncio</code>와 <code>aiohttp</code>를 기반으로 작동합니다.
이를 사용하려면 <code>aiohttp</code>를 직접 설치하거나 <code>[inference]</code> 추가 기능을 사용할 수 있습니다:`,Rr,Xa,Dr,w,Ra,wp,Yo,Dm="Initialize a new Inference Client.",Cp,So,Hm=`<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API or self-hosted Inference Endpoints.`,Up,sn,Da,$p,Xo,Fm="Perform audio classification on the provided audio content.",vp,ls,kp,an,Ha,qp,Ro,zm="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",Ap,os,Ep,ln,Fa,Zp,Do,Lm="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",Np,rs,Wp,Z,za,Gp,Ho,Om="A method for completing conversations using a specified language model.",Bp,is,Qp,cs,Vp,ps,Yp,us,Sp,gs,Xp,ms,Rp,ce,La,Dp,Fo,Pm="Generate conversational responses based on the given input text (i.e. chat with the API).",Hp,hs,Fp,ds,zp,on,Oa,Lp,zo,Km="Answer questions on document images.",Op,fs,Pp,rn,Pa,Kp,Lo,eh="Generate embeddings for a given text.",eu,ys,nu,cn,Ka,tu,Oo,nh="Fill in a hole with a missing word (token to be precise).",su,Ms,au,pe,el,lu,Po,th="Get information about the deployed endpoint.",ou,Ko,sh=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,ru,bs,iu,ue,nl,cu,er,ah="Get the status of a model hosted on the Inference API.",pu,js,uu,_s,gu,Ts,tl,mu,nr,lh="Get the model Hugging Face recommends for the input task.",hu,ge,sl,du,tr,oh="Check the health of the deployed endpoint.",fu,sr,rh=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,yu,Is,Mu,pn,al,bu,ar,ih="Perform image classification on the given image using the specified model.",ju,Js,_u,me,ll,Tu,lr,ch="Perform image segmentation on the given image using the specified model.",Iu,xs,Ju,ws,xu,he,ol,wu,or,ph="Perform image-to-image translation using a specified model.",Cu,Cs,Uu,Us,$u,de,rl,vu,rr,uh="Takes an input image and return text.",ku,ir,gh=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,qu,$s,Au,V,il,Eu,cr,mh="List models deployed on the Serverless Inference API service.",Zu,pr,hh=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,Nu,vs,Wu,ks,Gu,qs,Bu,fe,cl,Qu,ur,dh="Perform object detection on the given image using the specified model.",Vu,As,Yu,Es,Su,Zs,pl,Xu,gr,fh="Make a POST request to the inference server.",Ru,un,ul,Du,mr,yh="Retrieve the answer to a question from a given text.",Hu,Ns,Fu,gn,gl,zu,hr,Mh="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",Lu,Ws,Ou,mn,ml,Pu,dr,bh="Generate a summary of a given text using a specified model.",Ku,Gs,eg,hn,hl,ng,fr,jh="Retrieve the answer to a question from information given in a table.",tg,Bs,sg,dn,dl,ag,yr,_h="Classifying a target category (a group) based on a set of attributes.",lg,Qs,og,fn,fl,rg,Mr,Th="Predicting a numerical target value given a set of attributes/features in a table.",ig,Vs,cg,yn,yl,pg,br,Ih="Perform text classification (e.g. sentiment-analysis) on the given text.",ug,Ys,gg,Y,Ml,mg,jr,Jh="Given a prompt, generate the following text.",hg,_r,xh=`API endpoint is supposed to run with the <code>text-generation-inference</code> backend (TGI). This backend is the
go-to solution to run large language models at scale. However, for some smaller models (e.g. “gpt2”) the
default <code>transformers</code> + <code>api-inference</code> solution is still in use. Both approaches have very similar APIs, but
not exactly the same. This method is compatible with both approaches but some parameters are only available for
<code>text-generation-inference</code>. If some parameters are ignored, a warning message is triggered but the process
continues correctly.`,dg,Tr,wh='To learn more about the TGI project, please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">https://github.com/huggingface/text-generation-inference</a>.',fg,Ss,yg,Xs,Mg,ye,bl,bg,Ir,Ch="Generate an image based on a given text using a specified model.",jg,Rs,_g,Ds,Tg,Mn,jl,Ig,Jr,Uh="Synthesize an audio of a voice pronouncing a given text.",Jg,Hs,xg,bn,_l,wg,xr,$h=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,Cg,Fs,Ug,z,Tl,$g,wr,vh="Convert text from one language to another.",vg,Cr,kh=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.
You can find this information in the model card.`,kg,zs,qg,Ls,Ag,jn,Il,Eg,Ur,qh="Answering open-ended questions based on an image.",Zg,Os,Ng,Me,Jl,Wg,$r,Ah="Provide as input a text and a set of candidate labels to classify the input text.",Gg,Ps,Bg,Ks,Qg,_n,xl,Vg,vr,Eh="Provide input image and text labels to predict text labels for the image.",Yg,ea,Hr,wl,Fr,Tn,Cl,Sg,kr,Zh="Error raised when a model is unavailable or the request times out.",zr,Ul,Lr,$l,Nh="대부분의 작업에 대해, 반환 값은 내장된 유형(string, list, image…)을 갖습니다. 보다 복잡한 유형을 위한 목록은 다음과 같습니다.",Or,vl,Pr,In,kl,Xg,qr,Wh='Dictionary containing the “conversation” part of a <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">conversational()</a> task.',Kr,ql,ei,Jn,Al,Rg,Ar,Gh='Dictionary containing the output of a  <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">conversational()</a> task.',ni,El,ti,xn,Zl,Dg,Er,Bh="This Dataclass represents the the model status in the Hugging Face Inference API.",si,Nl,ai,Wl,Qh='<code>InferenceAPI</code>는 추론 API를 호출하는 레거시 방식입니다. 이 인터페이스는 더 간단하며 각 작업의 입력 매개변수와 출력 형식을 알아야 합니다. 또한 추론 엔드포인트나 AWS SageMaker와 같은 다른 서비스에 연결할 수 있는 기능이 없습니다. <code>InferenceAPI</code>는 곧 폐지될 예정이므로 가능한 경우 <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>를 사용하는 것을 권장합니다. 스크립트에서 <code>InferenceAPI</code>를 <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>로 전환하는 방법에 대해 알아보려면 <a href="../guides/inference#legacy-inferenceapi-client">이 가이드</a>를 참조하세요.',li,S,Gl,Hg,Zr,Vh="Client to configure requests and make calls to the HuggingFace Inference API.",Fg,na,zg,ta,Bl,Lg,Nr,Yh="Inits headers and API call information.",Og,sa,Ql,Pg,Wr,Sh="Make a call to the Inference API.",oi,Vl,ri,Gr,ii;return o=new it({props:{title:"추론",local:"inference",headingTag:"h1"}}),oa=new it({props:{title:"추론 클라이언트",local:"huggingface_hub.InferenceClient ][ huggingface_hub.InferenceClient",headingTag:"h2"}}),ra=new q({props:{name:"class huggingface_hub.InferenceClient",anchor:"huggingface_hub.InferenceClient",parameters:[{name:"model",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"timeout",val:": Optional = None"},{name:"headers",val:": Optional = None"},{name:"cookies",val:": Optional = None"},{name:"proxies",val:": Optional = None"},{name:"base_url",val:": Optional = None"},{name:"api_key",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.InferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.InferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.InferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.InferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.InferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L129"}}),ia=new q({props:{name:"audio_classification",anchor:"huggingface_hub.InferenceClient.audio_classification",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L334",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ct=new A({props:{anchor:"huggingface_hub.InferenceClient.audio_classification.example",$$slots:{default:[fd]},$$scope:{ctx:T}}}),ca=new q({props:{name:"audio_to_audio",anchor:"huggingface_hub.InferenceClient.audio_to_audio",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L376",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),pt=new A({props:{anchor:"huggingface_hub.InferenceClient.audio_to_audio.example",$$slots:{default:[yd]},$$scope:{ctx:T}}}),pa=new q({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L419",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ut=new A({props:{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.example",$$slots:{default:[Md]},$$scope:{ctx:T}}}),ua=new q({props:{name:"chat_completion",anchor:"huggingface_hub.InferenceClient.chat_completion",parameters:[{name:"messages",val:": List"},{name:"model",val:": Optional = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"logit_bias",val:": Optional = None"},{name:"logprobs",val:": Optional = None"},{name:"max_tokens",val:": Optional = None"},{name:"n",val:": Optional = None"},{name:"presence_penalty",val:": Optional = None"},{name:"response_format",val:": Optional = None"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"tool_choice",val:": Union = None"},{name:"tool_prompt",val:": Optional = None"},{name:"tools",val:": Optional = None"},{name:"top_logprobs",val:": Optional = None"},{name:"top_p",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List[Union[<code>SystemMessage</code>, <code>UserMessage</code>, <code>AssistantMessage</code>]]) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.InferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.</p>
<p>If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens
(specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically,
the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model,
but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should
result in a ban or exclusive selection of the relevant token. Defaults to None.`,name:"logit_bias"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 20.`,name:"max_tokens"},{anchor:"huggingface_hub.InferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
UNUSED.`,name:"n"},{anchor:"huggingface_hub.InferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputGrammarType">ChatCompletionInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.InferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolTypeClass">ChatCompletionInputToolTypeClass</a> or <code>str</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L527",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),gt=new N({props:{$$slots:{default:[bd]},$$scope:{ctx:T}}}),mt=new A({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example",$$slots:{default:[jd]},$$scope:{ctx:T}}}),ht=new A({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-2",$$slots:{default:[_d]},$$scope:{ctx:T}}}),dt=new A({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-3",$$slots:{default:[Td]},$$scope:{ctx:T}}}),ft=new A({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-4",$$slots:{default:[Id]},$$scope:{ctx:T}}}),yt=new A({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-5",$$slots:{default:[Jd]},$$scope:{ctx:T}}}),ga=new q({props:{name:"conversational",anchor:"huggingface_hub.InferenceClient.conversational",parameters:[{name:"text",val:": str"},{name:"generated_responses",val:": Optional = None"},{name:"past_user_inputs",val:": Optional = None"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.conversational.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The last input from the user in the conversation.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.conversational.generated_responses",description:`<strong>generated_responses</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the model. Defaults to None.`,name:"generated_responses"},{anchor:"huggingface_hub.InferenceClient.conversational.past_user_inputs",description:`<strong>past_user_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the user. Should be the same length as
<code>generated_responses</code>. Defaults to None.`,name:"past_user_inputs"},{anchor:"huggingface_hub.InferenceClient.conversational.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for the conversational task. Defaults to None. For more details about the available
parameters, please refer to <a href="https://huggingface.co/docs/api-inference/detailed_parameters#conversational-task" rel="nofollow">this page</a>`,name:"parameters"},{anchor:"huggingface_hub.InferenceClient.conversational.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L939",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated conversational output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Mt=new N({props:{warning:!0,$$slots:{default:[xd]},$$scope:{ctx:T}}}),bt=new A({props:{anchor:"huggingface_hub.InferenceClient.conversational.example",$$slots:{default:[wd]},$$scope:{ctx:T}}}),ma=new q({props:{name:"document_question_answering",anchor:"huggingface_hub.InferenceClient.document_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1012",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),jt=new A({props:{anchor:"huggingface_hub.InferenceClient.document_question_answering.example",$$slots:{default:[Cd]},$$scope:{ctx:T}}}),ha=new q({props:{name:"feature_extraction",anchor:"huggingface_hub.InferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": Optional = None"},{name:"prompt_name",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"truncation_direction",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1053",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>HTTPError</code></p>
`}}),_t=new A({props:{anchor:"huggingface_hub.InferenceClient.feature_extraction.example",$$slots:{default:[Ud]},$$scope:{ctx:T}}}),da=new q({props:{name:"fill_mask",anchor:"huggingface_hub.InferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.InferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1121",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Tt=new A({props:{anchor:"huggingface_hub.InferenceClient.fill_mask.example",$$slots:{default:[$d]},$$scope:{ctx:T}}}),fa=new q({props:{name:"get_endpoint_info",anchor:"huggingface_hub.InferenceClient.get_endpoint_info",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L2745",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),It=new A({props:{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.example",$$slots:{default:[vd]},$$scope:{ctx:T}}}),ya=new q({props:{name:"get_model_status",anchor:"huggingface_hub.InferenceClient.get_model_status",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L2834",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),Jt=new N({props:{$$slots:{default:[kd]},$$scope:{ctx:T}}}),xt=new A({props:{anchor:"huggingface_hub.InferenceClient.get_model_status.example",$$slots:{default:[qd]},$$scope:{ctx:T}}}),Ma=new q({props:{name:"get_recommended_model",anchor:"huggingface_hub.InferenceClient.get_recommended_model",parameters:[{name:"task",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_recommended_model.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The Hugging Face task to get which model Hugging Face recommends.
All available tasks can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L2721",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Name of the model recommended for the input task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If Hugging Face has no recommendation for the input task.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),ba=new q({props:{name:"health_check",anchor:"huggingface_hub.InferenceClient.health_check",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L2800",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Ct=new A({props:{anchor:"huggingface_hub.InferenceClient.health_check.example",$$slots:{default:[Ad]},$$scope:{ctx:T}}}),ja=new q({props:{name:"image_classification",anchor:"huggingface_hub.InferenceClient.image_classification",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1157",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ut=new A({props:{anchor:"huggingface_hub.InferenceClient.image_classification.example",$$slots:{default:[Ed]},$$scope:{ctx:T}}}),_a=new q({props:{name:"image_segmentation",anchor:"huggingface_hub.InferenceClient.image_segmentation",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),$t=new N({props:{warning:!0,$$slots:{default:[Zd]},$$scope:{ctx:T}}}),vt=new A({props:{anchor:"huggingface_hub.InferenceClient.image_segmentation.example",$$slots:{default:[Nd]},$$scope:{ctx:T}}}),Ta=new q({props:{name:"image_to_image",anchor:"huggingface_hub.InferenceClient.image_to_image",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Optional = None"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A negative prompt to guide the translation process.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.image_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1238",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),kt=new N({props:{warning:!0,$$slots:{default:[Wd]},$$scope:{ctx:T}}}),qt=new A({props:{anchor:"huggingface_hub.InferenceClient.image_to_image.example",$$slots:{default:[Gd]},$$scope:{ctx:T}}}),Ia=new q({props:{name:"image_to_text",anchor:"huggingface_hub.InferenceClient.image_to_text",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1322",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),At=new A({props:{anchor:"huggingface_hub.InferenceClient.image_to_text.example",$$slots:{default:[Bd]},$$scope:{ctx:T}}}),Ja=new q({props:{name:"list_deployed_models",anchor:"huggingface_hub.InferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1359",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),Et=new N({props:{warning:!0,$$slots:{default:[Qd]},$$scope:{ctx:T}}}),Zt=new N({props:{$$slots:{default:[Vd]},$$scope:{ctx:T}}}),Nt=new A({props:{anchor:"huggingface_hub.InferenceClient.list_deployed_models.example",$$slots:{default:[Yd]},$$scope:{ctx:T}}}),xa=new q({props:{name:"object_detection",anchor:"huggingface_hub.InferenceClient.object_detection",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1442",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),Wt=new N({props:{warning:!0,$$slots:{default:[Sd]},$$scope:{ctx:T}}}),Gt=new A({props:{anchor:"huggingface_hub.InferenceClient.object_detection.example",$$slots:{default:[Xd]},$$scope:{ctx:T}}}),wa=new q({props:{name:"post",anchor:"huggingface_hub.InferenceClient.post",parameters:[{name:"json",val:": Union = None"},{name:"data",val:": Union = None"},{name:"model",val:": Optional = None"},{name:"task",val:": Optional = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.InferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.InferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. All available tasks can be found
<a href="https://huggingface.co/tasks" rel="nofollow">here</a>. Used only to default to a recommended model if <code>model</code> is not
provided. At least <code>model</code> or <code>task</code> must be provided. Defaults to None.`,name:"task"},{anchor:"huggingface_hub.InferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L239",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ca=new q({props:{name:"question_answering",anchor:"huggingface_hub.InferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.InferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1487",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an question answering output containing the score, start index, end index, and answer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Qt=new A({props:{anchor:"huggingface_hub.InferenceClient.question_answering.example",$$slots:{default:[Rd]},$$scope:{ctx:T}}}),Ua=new q({props:{name:"sentence_similarity",anchor:"huggingface_hub.InferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Vt=new A({props:{anchor:"huggingface_hub.InferenceClient.sentence_similarity.example",$$slots:{default:[Dd]},$$scope:{ctx:T}}}),$a=new q({props:{name:"summarization",anchor:"huggingface_hub.InferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.InferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1575",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Yt=new A({props:{anchor:"huggingface_hub.InferenceClient.summarization.example",$$slots:{default:[Hd]},$$scope:{ctx:T}}}),va=new q({props:{name:"table_question_answering",anchor:"huggingface_hub.InferenceClient.table_question_answering",parameters:[{name:"table",val:": Dict"},{name:"query",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1618",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),St=new A({props:{anchor:"huggingface_hub.InferenceClient.table_question_answering.example",$$slots:{default:[Fd]},$$scope:{ctx:T}}}),ka=new q({props:{name:"tabular_classification",anchor:"huggingface_hub.InferenceClient.tabular_classification",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1663",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Xt=new A({props:{anchor:"huggingface_hub.InferenceClient.tabular_classification.example",$$slots:{default:[zd]},$$scope:{ctx:T}}}),qa=new q({props:{name:"tabular_regression",anchor:"huggingface_hub.InferenceClient.tabular_regression",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1708",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Rt=new A({props:{anchor:"huggingface_hub.InferenceClient.tabular_regression.example",$$slots:{default:[Ld]},$$scope:{ctx:T}}}),Aa=new q({props:{name:"text_classification",anchor:"huggingface_hub.InferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1748",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Dt=new A({props:{anchor:"huggingface_hub.InferenceClient.text_classification.example",$$slots:{default:[Od]},$$scope:{ctx:T}}}),Ea=new q({props:{name:"text_generation",anchor:"huggingface_hub.InferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": Optional = None"},{name:"adapter_id",val:": Optional = None"},{name:"best_of",val:": Optional = None"},{name:"decoder_input_details",val:": Optional = None"},{name:"do_sample",val:": Optional = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"grammar",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"repetition_penalty",val:": Optional = None"},{name:"return_full_text",val:": Optional = False"},{name:"seed",val:": Optional = None"},{name:"stop_sequences",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_n_tokens",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"watermark",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.InferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.InferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.InferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.InferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.InferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.InferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop_sequences</code> is generated`,name:"stop_sequences"},{anchor:"huggingface_hub.InferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.InferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L1928",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ht=new N({props:{$$slots:{default:[Pd]},$$scope:{ctx:T}}}),Ft=new A({props:{anchor:"huggingface_hub.InferenceClient.text_generation.example",$$slots:{default:[Kd]},$$scope:{ctx:T}}}),Za=new q({props:{name:"text_to_image",anchor:"huggingface_hub.InferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional negative prompt for the image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L2262",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),zt=new N({props:{warning:!0,$$slots:{default:[ef]},$$scope:{ctx:T}}}),Lt=new A({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example",$$slots:{default:[nf]},$$scope:{ctx:T}}}),Na=new q({props:{name:"text_to_speech",anchor:"huggingface_hub.InferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L2342",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ot=new A({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example",$$slots:{default:[tf]},$$scope:{ctx:T}}}),Wa=new q({props:{name:"token_classification",anchor:"huggingface_hub.InferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L2374",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Pt=new A({props:{anchor:"huggingface_hub.InferenceClient.token_classification.example",$$slots:{default:[sf]},$$scope:{ctx:T}}}),Ga=new q({props:{name:"translation",anchor:"huggingface_hub.InferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"src_lang",val:": Optional = None"},{name:"tgt_lang",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Source language of the translation task, i.e. input language. Cannot be passed without <code>tgt_lang</code>.`,name:"src_lang"},{anchor:"huggingface_hub.InferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language of the translation task, i.e. output language. Cannot be passed without <code>src_lang</code>.`,name:"tgt_lang"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L2429",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),Kt=new A({props:{anchor:"huggingface_hub.InferenceClient.translation.example",$$slots:{default:[af]},$$scope:{ctx:T}}}),es=new A({props:{anchor:"huggingface_hub.InferenceClient.translation.example-2",$$slots:{default:[lf]},$$scope:{ctx:T}}}),Ba=new q({props:{name:"visual_question_answering",anchor:"huggingface_hub.InferenceClient.visual_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L2494",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),ns=new A({props:{anchor:"huggingface_hub.InferenceClient.visual_question_answering.example",$$slots:{default:[of]},$$scope:{ctx:T}}}),Qa=new q({props:{name:"zero_shot_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"labels",val:": List"},{name:"multi_label",val:": bool = False"},{name:"hypothesis_template",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>) &#x2014;
Boolean. If True, the probability for each label is evaluated independently and multiple labels can have a probability close to 1 simultaneously or all probabilities can be close to 0.
If False, the labels are considered mutually exclusive and the probability over all labels always sums to 1. Defaults to False.`,name:"multi_label"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A template sentence string with curly brackets to which the label strings are added. The label strings are added at the position of the curly brackets &#x201D;{}&#x201C;.
Zero-shot classifiers are based on NLI models, which evaluate if a hypothesis is entailed in another text or not.
For example, with hypothesis_template=&#x201C;This text is about {}.&#x201D; and labels=[&#x201C;economics&#x201D;, &#x201C;politics&#x201D;], the system internally creates the two hypotheses &#x201C;This text is about economics.&#x201D; and &#x201C;This text is about politics.&#x201D;.
The model then evaluates for both hypotheses if they are entailed in the provided <code>text</code> or not.`,name:"hypothesis_template"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L2541",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ts=new A({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example",$$slots:{default:[rf]},$$scope:{ctx:T}}}),ss=new A({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example-2",$$slots:{default:[cf]},$$scope:{ctx:T}}}),Va=new q({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": Union"},{name:"labels",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_client.py#L2644",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),as=new A({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.example",$$slots:{default:[pf]},$$scope:{ctx:T}}}),Ya=new it({props:{title:"비동기 추론 클라이언트",local:"huggingface_hub.AsyncInferenceClient ][ huggingface_hub.AsyncInferenceClient",headingTag:"h2"}}),Xa=new $({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMCVFQiU5OCU5MCVFQiU4QSU5NCUwQSUyMyUyMHBpcCUyMGluc3RhbGwlMjBhaW9odHRw",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># 또는</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),Ra=new q({props:{name:"class huggingface_hub.AsyncInferenceClient",anchor:"huggingface_hub.AsyncInferenceClient",parameters:[{name:"model",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"timeout",val:": Optional = None"},{name:"headers",val:": Optional = None"},{name:"cookies",val:": Optional = None"},{name:"proxies",val:": Optional = None"},{name:"base_url",val:": Optional = None"},{name:"api_key",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.AsyncInferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.AsyncInferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.AsyncInferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.AsyncInferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.AsyncInferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L114"}}),Da=new q({props:{name:"audio_classification",anchor:"huggingface_hub.AsyncInferenceClient.audio_classification",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L332",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ls=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.example",$$slots:{default:[uf]},$$scope:{ctx:T}}}),Ha=new q({props:{name:"audio_to_audio",anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L375",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),os=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.example",$$slots:{default:[gf]},$$scope:{ctx:T}}}),Fa=new q({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L419",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),rs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.example",$$slots:{default:[mf]},$$scope:{ctx:T}}}),za=new q({props:{name:"chat_completion",anchor:"huggingface_hub.AsyncInferenceClient.chat_completion",parameters:[{name:"messages",val:": List"},{name:"model",val:": Optional = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"logit_bias",val:": Optional = None"},{name:"logprobs",val:": Optional = None"},{name:"max_tokens",val:": Optional = None"},{name:"n",val:": Optional = None"},{name:"presence_penalty",val:": Optional = None"},{name:"response_format",val:": Optional = None"},{name:"seed",val:": Optional = None"},{name:"stop",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"tool_choice",val:": Union = None"},{name:"tool_prompt",val:": Optional = None"},{name:"tools",val:": Optional = None"},{name:"top_logprobs",val:": Optional = None"},{name:"top_p",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List[Union[<code>SystemMessage</code>, <code>UserMessage</code>, <code>AssistantMessage</code>]]) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.</p>
<p>If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Modify the likelihood of specified tokens appearing in the completion. Accepts a JSON object that maps tokens
(specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically,
the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model,
but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should
result in a ban or exclusive selection of the relevant token. Defaults to None.`,name:"logit_bias"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 20.`,name:"max_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
UNUSED.`,name:"n"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputGrammarType">ChatCompletionInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stop",description:`<strong>stop</strong> (Optional<code>str</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolTypeClass">ChatCompletionInputToolTypeClass</a> or <code>str</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),is=new N({props:{$$slots:{default:[hf]},$$scope:{ctx:T}}}),cs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example",$$slots:{default:[df]},$$scope:{ctx:T}}}),ps=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-2",$$slots:{default:[ff]},$$scope:{ctx:T}}}),us=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-3",$$slots:{default:[yf]},$$scope:{ctx:T}}}),gs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-4",$$slots:{default:[Mf]},$$scope:{ctx:T}}}),ms=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-5",$$slots:{default:[bf]},$$scope:{ctx:T}}}),La=new q({props:{name:"conversational",anchor:"huggingface_hub.AsyncInferenceClient.conversational",parameters:[{name:"text",val:": str"},{name:"generated_responses",val:": Optional = None"},{name:"past_user_inputs",val:": Optional = None"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.conversational.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The last input from the user in the conversation.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.generated_responses",description:`<strong>generated_responses</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the model. Defaults to None.`,name:"generated_responses"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.past_user_inputs",description:`<strong>past_user_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of strings corresponding to the earlier replies from the user. Should be the same length as
<code>generated_responses</code>. Defaults to None.`,name:"past_user_inputs"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for the conversational task. Defaults to None. For more details about the available
parameters, please refer to <a href="https://huggingface.co/docs/api-inference/detailed_parameters#conversational-task" rel="nofollow">this page</a>`,name:"parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.conversational.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L945",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated conversational output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),hs=new N({props:{warning:!0,$$slots:{default:[jf]},$$scope:{ctx:T}}}),ds=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.conversational.example",$$slots:{default:[_f]},$$scope:{ctx:T}}}),Oa=new q({props:{name:"document_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1019",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),fs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.example",$$slots:{default:[Tf]},$$scope:{ctx:T}}}),Pa=new q({props:{name:"feature_extraction",anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": Optional = None"},{name:"prompt_name",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"truncation_direction",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not. Defaults to None.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1061",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>aiohttp.ClientResponseError</code></p>
`}}),ys=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.example",$$slots:{default:[If]},$$scope:{ctx:T}}}),Ka=new q({props:{name:"fill_mask",anchor:"huggingface_hub.AsyncInferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1130",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ms=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.example",$$slots:{default:[Jf]},$$scope:{ctx:T}}}),el=new q({props:{name:"get_endpoint_info",anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L2784",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),bs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.example",$$slots:{default:[xf]},$$scope:{ctx:T}}}),nl=new q({props:{name:"get_model_status",anchor:"huggingface_hub.AsyncInferenceClient.get_model_status",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L2877",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),js=new N({props:{$$slots:{default:[wf]},$$scope:{ctx:T}}}),_s=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.example",$$slots:{default:[Cf]},$$scope:{ctx:T}}}),tl=new q({props:{name:"get_recommended_model",anchor:"huggingface_hub.AsyncInferenceClient.get_recommended_model",parameters:[{name:"task",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_recommended_model.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The Hugging Face task to get which model Hugging Face recommends.
All available tasks can be found <a href="https://huggingface.co/tasks" rel="nofollow">here</a>.`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L2760",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Name of the model recommended for the input task.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If Hugging Face has no recommendation for the input task.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),sl=new q({props:{name:"health_check",anchor:"huggingface_hub.AsyncInferenceClient.health_check",parameters:[{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L2841",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Is=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.health_check.example",$$slots:{default:[Uf]},$$scope:{ctx:T}}}),al=new q({props:{name:"image_classification",anchor:"huggingface_hub.AsyncInferenceClient.image_classification",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1167",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Js=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.example",$$slots:{default:[$f]},$$scope:{ctx:T}}}),ll=new q({props:{name:"image_segmentation",anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1204",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),xs=new N({props:{warning:!0,$$slots:{default:[vf]},$$scope:{ctx:T}}}),ws=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.example",$$slots:{default:[kf]},$$scope:{ctx:T}}}),ol=new q({props:{name:"image_to_image",anchor:"huggingface_hub.AsyncInferenceClient.image_to_image",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Optional = None"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A negative prompt to guide the translation process.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1250",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Cs=new N({props:{warning:!0,$$slots:{default:[qf]},$$scope:{ctx:T}}}),Us=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.example",$$slots:{default:[Af]},$$scope:{ctx:T}}}),rl=new q({props:{name:"image_to_text",anchor:"huggingface_hub.AsyncInferenceClient.image_to_text",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1335",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),$s=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.example",$$slots:{default:[Ef]},$$scope:{ctx:T}}}),il=new q({props:{name:"list_deployed_models",anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1373",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),vs=new N({props:{warning:!0,$$slots:{default:[Zf]},$$scope:{ctx:T}}}),ks=new N({props:{$$slots:{default:[Nf]},$$scope:{ctx:T}}}),qs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.example",$$slots:{default:[Wf]},$$scope:{ctx:T}}}),cl=new q({props:{name:"object_detection",anchor:"huggingface_hub.AsyncInferenceClient.object_detection",parameters:[{name:"image",val:": Union"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1462",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),As=new N({props:{warning:!0,$$slots:{default:[Gf]},$$scope:{ctx:T}}}),Es=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.example",$$slots:{default:[Bf]},$$scope:{ctx:T}}}),pl=new q({props:{name:"post",anchor:"huggingface_hub.AsyncInferenceClient.post",parameters:[{name:"json",val:": Union = None"},{name:"data",val:": Union = None"},{name:"model",val:": Optional = None"},{name:"task",val:": Optional = None"},{name:"stream",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.post.json",description:`<strong>json</strong> (<code>Union[str, Dict, List]</code>, <em>optional</em>) &#x2014;
The JSON data to send in the request body, specific to each task. Defaults to None.`,name:"json"},{anchor:"huggingface_hub.AsyncInferenceClient.post.data",description:`<strong>data</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>, <em>optional</em>) &#x2014;
The content to send in the request body, specific to each task.
It can be raw bytes, a pointer to an opened file, a local file path,
or a URL to an online resource (image, audio file,&#x2026;). If both <code>json</code> and <code>data</code> are passed,
<code>data</code> will take precedence. At least <code>json</code> or <code>data</code> must be provided. Defaults to None.`,name:"data"},{anchor:"huggingface_hub.AsyncInferenceClient.post.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. Will override the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.post.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task to perform on the inference. All available tasks can be found
<a href="https://huggingface.co/tasks" rel="nofollow">here</a>. Used only to default to a recommended model if <code>model</code> is not
provided. At least <code>model</code> or <code>task</code> must be provided. Defaults to None.`,name:"task"},{anchor:"huggingface_hub.AsyncInferenceClient.post.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to iterate over streaming APIs.`,name:"stream"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L224",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The raw bytes returned by the server.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bytes</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ul=new q({props:{name:"question_answering",anchor:"huggingface_hub.AsyncInferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1508",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an question answering output containing the score, start index, end index, and answer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ns=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.example",$$slots:{default:[Qf]},$$scope:{ctx:T}}}),gl=new q({props:{name:"sentence_similarity",anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1550",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ws=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.example",$$slots:{default:[Vf]},$$scope:{ctx:T}}}),ml=new q({props:{name:"summarization",anchor:"huggingface_hub.AsyncInferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"parameters",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.parameters",description:`<strong>parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters for summarization. Check out this <a href="https://huggingface.co/docs/api-inference/detailed_parameters#summarization-task" rel="nofollow">page</a>
for more details.`,name:"parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1598",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Gs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.summarization.example",$$slots:{default:[Yf]},$$scope:{ctx:T}}}),hl=new q({props:{name:"table_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering",parameters:[{name:"table",val:": Dict"},{name:"query",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1642",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Bs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.example",$$slots:{default:[Sf]},$$scope:{ctx:T}}}),dl=new q({props:{name:"tabular_classification",anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1688",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Qs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.example",$$slots:{default:[Xf]},$$scope:{ctx:T}}}),fl=new q({props:{name:"tabular_regression",anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression",parameters:[{name:"table",val:": Dict"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1734",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Vs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.example",$$slots:{default:[Rf]},$$scope:{ctx:T}}}),yl=new q({props:{name:"text_classification",anchor:"huggingface_hub.AsyncInferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1775",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ys=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.example",$$slots:{default:[Df]},$$scope:{ctx:T}}}),Ml=new q({props:{name:"text_generation",anchor:"huggingface_hub.AsyncInferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": Optional = None"},{name:"adapter_id",val:": Optional = None"},{name:"best_of",val:": Optional = None"},{name:"decoder_input_details",val:": Optional = None"},{name:"do_sample",val:": Optional = False"},{name:"frequency_penalty",val:": Optional = None"},{name:"grammar",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"repetition_penalty",val:": Optional = None"},{name:"return_full_text",val:": Optional = False"},{name:"seed",val:": Optional = None"},{name:"stop_sequences",val:": Optional = None"},{name:"temperature",val:": Optional = None"},{name:"top_k",val:": Optional = None"},{name:"top_n_tokens",val:": Optional = None"},{name:"top_p",val:": Optional = None"},{name:"truncate",val:": Optional = None"},{name:"typical_p",val:": Optional = None"},{name:"watermark",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop_sequences</code> is generated`,name:"stop_sequences"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L1958",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ss=new N({props:{$$slots:{default:[Hf]},$$scope:{ctx:T}}}),Xs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.example",$$slots:{default:[Ff]},$$scope:{ctx:T}}}),bl=new q({props:{name:"text_to_image",anchor:"huggingface_hub.AsyncInferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": Optional = None"},{name:"guidance_scale",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional negative prompt for the image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L2293",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Rs=new N({props:{warning:!0,$$slots:{default:[zf]},$$scope:{ctx:T}}}),Ds=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example",$$slots:{default:[Lf]},$$scope:{ctx:T}}}),jl=new q({props:{name:"text_to_speech",anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L2374",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Hs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example",$$slots:{default:[Of]},$$scope:{ctx:T}}}),_l=new q({props:{name:"token_classification",anchor:"huggingface_hub.AsyncInferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L2407",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Fs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.example",$$slots:{default:[Pf]},$$scope:{ctx:T}}}),Tl=new q({props:{name:"translation",anchor:"huggingface_hub.AsyncInferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": Optional = None"},{name:"src_lang",val:": Optional = None"},{name:"tgt_lang",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Source language of the translation task, i.e. input language. Cannot be passed without <code>tgt_lang</code>.`,name:"src_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language of the translation task, i.e. output language. Cannot be passed without <code>src_lang</code>.`,name:"tgt_lang"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L2463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),zs=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example",$$slots:{default:[Kf]},$$scope:{ctx:T}}}),Ls=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example-2",$$slots:{default:[ey]},$$scope:{ctx:T}}}),Il=new q({props:{name:"visual_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering",parameters:[{name:"image",val:": Union"},{name:"question",val:": str"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L2529",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),Os=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.example",$$slots:{default:[ny]},$$scope:{ctx:T}}}),Jl=new q({props:{name:"zero_shot_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"labels",val:": List"},{name:"multi_label",val:": bool = False"},{name:"hypothesis_template",val:": Optional = None"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>) &#x2014;
Boolean. If True, the probability for each label is evaluated independently and multiple labels can have a probability close to 1 simultaneously or all probabilities can be close to 0.
If False, the labels are considered mutually exclusive and the probability over all labels always sums to 1. Defaults to False.`,name:"multi_label"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A template sentence string with curly brackets to which the label strings are added. The label strings are added at the position of the curly brackets &#x201D;{}&#x201C;.
Zero-shot classifiers are based on NLI models, which evaluate if a hypothesis is entailed in another text or not.
For example, with hypothesis_template=&#x201C;This text is about {}.&#x201D; and labels=[&#x201C;economics&#x201D;, &#x201C;politics&#x201D;], the system internally creates the two hypotheses &#x201C;This text is about economics.&#x201D; and &#x201C;This text is about politics.&#x201D;.
The model then evaluates for both hypotheses if they are entailed in the provided <code>text</code> or not.`,name:"hypothesis_template"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L2577",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ps=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example",$$slots:{default:[ty]},$$scope:{ctx:T}}}),Ks=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example-2",$$slots:{default:[sy]},$$scope:{ctx:T}}}),xl=new q({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": Union"},{name:"labels",val:": List"},{name:"model",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>) &#x2014;
List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_generated/_async_client.py#L2682",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/pr_2405/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ea=new A({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.example",$$slots:{default:[ay]},$$scope:{ctx:T}}}),wl=new it({props:{title:"추론 시간 초과 오류",local:"huggingface_hub.InferenceTimeoutError ][ huggingface_hub.InferenceTimeoutError",headingTag:"h2"}}),Cl=new q({props:{name:"class huggingface_hub.InferenceTimeoutError",anchor:"huggingface_hub.InferenceTimeoutError",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/errors.py#L23"}}),Ul=new it({props:{title:"반환 유형",local:"return-types",headingTag:"h2"}}),vl=new it({props:{title:"대화형 출력 대화",local:"huggingface_hub.inference._types.ConversationalOutputConversation ][ huggingface_hub.inference._types.ConversationalOutputConversation",headingTag:"h3"}}),kl=new q({props:{name:"class huggingface_hub.inference._types.ConversationalOutputConversation",anchor:"huggingface_hub.inference._types.ConversationalOutputConversation",parameters:"",parametersDescription:[{anchor:"huggingface_hub.inference._types.ConversationalOutputConversation.generated_responses",description:`<strong>generated_responses</strong> (<code>List[str]</code>) &#x2014;
A list of the responses from the model.`,name:"generated_responses"},{anchor:"huggingface_hub.inference._types.ConversationalOutputConversation.past_user_inputs",description:`<strong>past_user_inputs</strong> (<code>List[str]</code>) &#x2014;
A list of the inputs from the user. Must be the same length as <code>generated_responses</code>.`,name:"past_user_inputs"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_types.py#L24"}}),ql=new it({props:{title:"대화형 출력",local:"huggingface_hub.inference._types.ConversationalOutput ][ huggingface_hub.inference._types.ConversationalOutput",headingTag:"h3"}}),Al=new q({props:{name:"class huggingface_hub.inference._types.ConversationalOutput",anchor:"huggingface_hub.inference._types.ConversationalOutput",parameters:"",parametersDescription:[{anchor:"huggingface_hub.inference._types.ConversationalOutput.generated_text",description:`<strong>generated_text</strong> (<code>str</code>) &#x2014;
The last response from the model.`,name:"generated_text"},{anchor:"huggingface_hub.inference._types.ConversationalOutput.conversation",description:`<strong>conversation</strong> (<code>ConversationalOutputConversation</code>) &#x2014;
The past conversation.`,name:"conversation"},{anchor:"huggingface_hub.inference._types.ConversationalOutput.warnings",description:`<strong>warnings</strong> (<code>List[str]</code>) &#x2014;
A list of warnings associated with the process.`,name:"warnings"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_types.py#L38"}}),El=new it({props:{title:"모델 상태",local:"huggingface_hub.inference._common.ModelStatus ][ huggingface_hub.inference._common.ModelStatus",headingTag:"h3"}}),Zl=new q({props:{name:"class huggingface_hub.inference._common.ModelStatus",anchor:"huggingface_hub.inference._common.ModelStatus",parameters:[{name:"loaded",val:": bool"},{name:"state",val:": str"},{name:"compute_type",val:": Dict"},{name:"framework",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.inference._common.ModelStatus.loaded",description:`<strong>loaded</strong> (<code>bool</code>) &#x2014;
If the model is currently loaded into Hugging Face&#x2019;s InferenceAPI. Models
are loaded on-demand, leading to the user&#x2019;s first request taking longer.
If a model is loaded, you can be assured that it is in a healthy state.`,name:"loaded"},{anchor:"huggingface_hub.inference._common.ModelStatus.state",description:`<strong>state</strong> (<code>str</code>) &#x2014;
The current state of the model. This can be &#x2018;Loaded&#x2019;, &#x2018;Loadable&#x2019;, &#x2018;TooBig&#x2019;.
If a model&#x2019;s state is &#x2018;Loadable&#x2019;, it&#x2019;s not too big and has a supported
backend. Loadable models are automatically loaded when the user first
requests inference on the endpoint. This means it is transparent for the
user to load a model, except that the first call takes longer to complete.`,name:"state"},{anchor:"huggingface_hub.inference._common.ModelStatus.compute_type",description:`<strong>compute_type</strong> (<code>Dict</code>) &#x2014;
Information about the compute resource the model is using or will use, such as &#x2018;gpu&#x2019; type and number of
replicas.`,name:"compute_type"},{anchor:"huggingface_hub.inference._common.ModelStatus.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The name of the framework that the model was built with, such as &#x2018;transformers&#x2019;
or &#x2018;text-generation-inference&#x2019;.`,name:"framework"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference/_common.py#L87"}}),Nl=new it({props:{title:"추론 API",local:"huggingface_hub.InferenceApi ][ huggingface_hub.InferenceApi",headingTag:"h2"}}),Gl=new q({props:{name:"class huggingface_hub.InferenceApi",anchor:"huggingface_hub.InferenceApi",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"gpu",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference_api.py#L46"}}),na=new A({props:{anchor:"huggingface_hub.InferenceApi.example",$$slots:{default:[ly]},$$scope:{ctx:T}}}),Bl=new q({props:{name:"__init__",anchor:"huggingface_hub.InferenceApi.__init__",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"gpu",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__init__.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
Id of repository (e.g. <em>user/bert-base-uncased</em>).`,name:"repo_id"},{anchor:"huggingface_hub.InferenceApi.__init__.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>, defaults <code>None</code>) &#x2014;
Whether to force a task instead of using task specified in the
repository.`,name:"task"},{anchor:"huggingface_hub.InferenceApi.__init__.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API token to use as HTTP bearer authorization. This is not
the authentication token. You can find the token in
<a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>. Alternatively, you can
find both your organizations and personal API tokens using
<em>HfApi().whoami(token)</em>.`,name:"token"},{anchor:"huggingface_hub.InferenceApi.__init__.gpu",description:`<strong>gpu</strong> (<em>bool</em>, <em>optional</em>, defaults <em>False</em>) &#x2014;
Whether to use GPU instead of CPU for inference(requires Startup
plan at least).`,name:"gpu"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference_api.py#L93"}}),Ql=new q({props:{name:"__call__",anchor:"huggingface_hub.InferenceApi.__call__",parameters:[{name:"inputs",val:": Union = None"},{name:"params",val:": Optional = None"},{name:"data",val:": Optional = None"},{name:"raw_response",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>Dict</code> or <code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Inputs for the prediction.`,name:"inputs"},{anchor:"huggingface_hub.InferenceApi.__call__.params",description:`<strong>params</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional parameters for the models. Will be sent as <code>parameters</code> in the
payload.`,name:"params"},{anchor:"huggingface_hub.InferenceApi.__call__.data",description:`<strong>data</strong> (<code>bytes</code>, <em>optional</em>) &#x2014;
Bytes content of the request. In this case, leave <code>inputs</code> and <code>params</code> empty.`,name:"data"},{anchor:"huggingface_hub.InferenceApi.__call__.raw_response",description:`<strong>raw_response</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the raw <code>Response</code> object is returned. You can parse its content
as preferred. By default, the content is parsed into a more practical format
(json dictionary or PIL Image for example).`,name:"raw_response"}],source:"https://github.com/huggingface/huggingface_hub/blob/vr_2405/src/huggingface_hub/inference_api.py#L158"}}),Vl=new dd({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/inference_client.md"}}),{c(){n=g("meta"),u=r(),a=g("p"),t=r(),h(o.$$.fragment),e=r(),c=g("p"),c.innerHTML=Kg,Br=r(),aa=g("ul"),aa.innerHTML=em,Qr=r(),la=g("p"),la.innerHTML=nm,Vr=r(),h(oa.$$.fragment),Yr=r(),x=g("div"),h(ra.$$.fragment),ci=r(),Pl=g("p"),Pl.textContent=tm,pi=r(),Kl=g("p"),Kl.innerHTML=sm,ui=r(),Be=g("div"),h(ia.$$.fragment),gi=r(),eo=g("p"),eo.textContent=am,mi=r(),h(ct.$$.fragment),hi=r(),Qe=g("div"),h(ca.$$.fragment),di=r(),no=g("p"),no.textContent=lm,fi=r(),h(pt.$$.fragment),yi=r(),Ve=g("div"),h(pa.$$.fragment),Mi=r(),to=g("p"),to.textContent=om,bi=r(),h(ut.$$.fragment),ji=r(),E=g("div"),h(ua.$$.fragment),_i=r(),so=g("p"),so.textContent=rm,Ti=r(),h(gt.$$.fragment),Ii=r(),h(mt.$$.fragment),Ji=r(),h(ht.$$.fragment),xi=r(),h(dt.$$.fragment),wi=r(),h(ft.$$.fragment),Ci=r(),h(yt.$$.fragment),Ui=r(),K=g("div"),h(ga.$$.fragment),$i=r(),ao=g("p"),ao.textContent=im,vi=r(),h(Mt.$$.fragment),ki=r(),h(bt.$$.fragment),qi=r(),Ye=g("div"),h(ma.$$.fragment),Ai=r(),lo=g("p"),lo.textContent=cm,Ei=r(),h(jt.$$.fragment),Zi=r(),Se=g("div"),h(ha.$$.fragment),Ni=r(),oo=g("p"),oo.textContent=pm,Wi=r(),h(_t.$$.fragment),Gi=r(),Xe=g("div"),h(da.$$.fragment),Bi=r(),ro=g("p"),ro.textContent=um,Qi=r(),h(Tt.$$.fragment),Vi=r(),ee=g("div"),h(fa.$$.fragment),Yi=r(),io=g("p"),io.textContent=gm,Si=r(),co=g("p"),co.innerHTML=mm,Xi=r(),h(It.$$.fragment),Ri=r(),ne=g("div"),h(ya.$$.fragment),Di=r(),po=g("p"),po.textContent=hm,Hi=r(),h(Jt.$$.fragment),Fi=r(),h(xt.$$.fragment),zi=r(),wt=g("div"),h(Ma.$$.fragment),Li=r(),uo=g("p"),uo.textContent=dm,Oi=r(),te=g("div"),h(ba.$$.fragment),Pi=r(),go=g("p"),go.textContent=fm,Ki=r(),mo=g("p"),mo.innerHTML=ym,ec=r(),h(Ct.$$.fragment),nc=r(),Re=g("div"),h(ja.$$.fragment),tc=r(),ho=g("p"),ho.textContent=Mm,sc=r(),h(Ut.$$.fragment),ac=r(),se=g("div"),h(_a.$$.fragment),lc=r(),fo=g("p"),fo.textContent=bm,oc=r(),h($t.$$.fragment),rc=r(),h(vt.$$.fragment),ic=r(),ae=g("div"),h(Ta.$$.fragment),cc=r(),yo=g("p"),yo.textContent=jm,pc=r(),h(kt.$$.fragment),uc=r(),h(qt.$$.fragment),gc=r(),le=g("div"),h(Ia.$$.fragment),mc=r(),Mo=g("p"),Mo.textContent=_m,hc=r(),bo=g("p"),bo.textContent=Tm,dc=r(),h(At.$$.fragment),fc=r(),B=g("div"),h(Ja.$$.fragment),yc=r(),jo=g("p"),jo.textContent=Im,Mc=r(),_o=g("p"),_o.innerHTML=Jm,bc=r(),h(Et.$$.fragment),jc=r(),h(Zt.$$.fragment),_c=r(),h(Nt.$$.fragment),Tc=r(),oe=g("div"),h(xa.$$.fragment),Ic=r(),To=g("p"),To.textContent=xm,Jc=r(),h(Wt.$$.fragment),xc=r(),h(Gt.$$.fragment),wc=r(),Bt=g("div"),h(wa.$$.fragment),Cc=r(),Io=g("p"),Io.textContent=wm,Uc=r(),De=g("div"),h(Ca.$$.fragment),$c=r(),Jo=g("p"),Jo.textContent=Cm,vc=r(),h(Qt.$$.fragment),kc=r(),He=g("div"),h(Ua.$$.fragment),qc=r(),xo=g("p"),xo.textContent=Um,Ac=r(),h(Vt.$$.fragment),Ec=r(),Fe=g("div"),h($a.$$.fragment),Zc=r(),wo=g("p"),wo.textContent=$m,Nc=r(),h(Yt.$$.fragment),Wc=r(),ze=g("div"),h(va.$$.fragment),Gc=r(),Co=g("p"),Co.textContent=vm,Bc=r(),h(St.$$.fragment),Qc=r(),Le=g("div"),h(ka.$$.fragment),Vc=r(),Uo=g("p"),Uo.textContent=km,Yc=r(),h(Xt.$$.fragment),Sc=r(),Oe=g("div"),h(qa.$$.fragment),Xc=r(),$o=g("p"),$o.textContent=qm,Rc=r(),h(Rt.$$.fragment),Dc=r(),Pe=g("div"),h(Aa.$$.fragment),Hc=r(),vo=g("p"),vo.textContent=Am,Fc=r(),h(Dt.$$.fragment),zc=r(),Q=g("div"),h(Ea.$$.fragment),Lc=r(),ko=g("p"),ko.textContent=Em,Oc=r(),qo=g("p"),qo.innerHTML=Zm,Pc=r(),Ao=g("p"),Ao.innerHTML=Nm,Kc=r(),h(Ht.$$.fragment),ep=r(),h(Ft.$$.fragment),np=r(),re=g("div"),h(Za.$$.fragment),tp=r(),Eo=g("p"),Eo.textContent=Wm,sp=r(),h(zt.$$.fragment),ap=r(),h(Lt.$$.fragment),lp=r(),Ke=g("div"),h(Na.$$.fragment),op=r(),Zo=g("p"),Zo.textContent=Gm,rp=r(),h(Ot.$$.fragment),ip=r(),en=g("div"),h(Wa.$$.fragment),cp=r(),No=g("p"),No.textContent=Bm,pp=r(),h(Pt.$$.fragment),up=r(),F=g("div"),h(Ga.$$.fragment),gp=r(),Wo=g("p"),Wo.textContent=Qm,mp=r(),Go=g("p"),Go.innerHTML=Vm,hp=r(),h(Kt.$$.fragment),dp=r(),h(es.$$.fragment),fp=r(),nn=g("div"),h(Ba.$$.fragment),yp=r(),Bo=g("p"),Bo.textContent=Ym,Mp=r(),h(ns.$$.fragment),bp=r(),ie=g("div"),h(Qa.$$.fragment),jp=r(),Qo=g("p"),Qo.textContent=Sm,_p=r(),h(ts.$$.fragment),Tp=r(),h(ss.$$.fragment),Ip=r(),tn=g("div"),h(Va.$$.fragment),Jp=r(),Vo=g("p"),Vo.textContent=Xm,xp=r(),h(as.$$.fragment),Sr=r(),h(Ya.$$.fragment),Xr=r(),Sa=g("p"),Sa.innerHTML=Rm,Rr=r(),h(Xa.$$.fragment),Dr=r(),w=g("div"),h(Ra.$$.fragment),wp=r(),Yo=g("p"),Yo.textContent=Dm,Cp=r(),So=g("p"),So.innerHTML=Hm,Up=r(),sn=g("div"),h(Da.$$.fragment),$p=r(),Xo=g("p"),Xo.textContent=Fm,vp=r(),h(ls.$$.fragment),kp=r(),an=g("div"),h(Ha.$$.fragment),qp=r(),Ro=g("p"),Ro.textContent=zm,Ap=r(),h(os.$$.fragment),Ep=r(),ln=g("div"),h(Fa.$$.fragment),Zp=r(),Do=g("p"),Do.textContent=Lm,Np=r(),h(rs.$$.fragment),Wp=r(),Z=g("div"),h(za.$$.fragment),Gp=r(),Ho=g("p"),Ho.textContent=Om,Bp=r(),h(is.$$.fragment),Qp=r(),h(cs.$$.fragment),Vp=r(),h(ps.$$.fragment),Yp=r(),h(us.$$.fragment),Sp=r(),h(gs.$$.fragment),Xp=r(),h(ms.$$.fragment),Rp=r(),ce=g("div"),h(La.$$.fragment),Dp=r(),Fo=g("p"),Fo.textContent=Pm,Hp=r(),h(hs.$$.fragment),Fp=r(),h(ds.$$.fragment),zp=r(),on=g("div"),h(Oa.$$.fragment),Lp=r(),zo=g("p"),zo.textContent=Km,Op=r(),h(fs.$$.fragment),Pp=r(),rn=g("div"),h(Pa.$$.fragment),Kp=r(),Lo=g("p"),Lo.textContent=eh,eu=r(),h(ys.$$.fragment),nu=r(),cn=g("div"),h(Ka.$$.fragment),tu=r(),Oo=g("p"),Oo.textContent=nh,su=r(),h(Ms.$$.fragment),au=r(),pe=g("div"),h(el.$$.fragment),lu=r(),Po=g("p"),Po.textContent=th,ou=r(),Ko=g("p"),Ko.innerHTML=sh,ru=r(),h(bs.$$.fragment),iu=r(),ue=g("div"),h(nl.$$.fragment),cu=r(),er=g("p"),er.textContent=ah,pu=r(),h(js.$$.fragment),uu=r(),h(_s.$$.fragment),gu=r(),Ts=g("div"),h(tl.$$.fragment),mu=r(),nr=g("p"),nr.textContent=lh,hu=r(),ge=g("div"),h(sl.$$.fragment),du=r(),tr=g("p"),tr.textContent=oh,fu=r(),sr=g("p"),sr.innerHTML=rh,yu=r(),h(Is.$$.fragment),Mu=r(),pn=g("div"),h(al.$$.fragment),bu=r(),ar=g("p"),ar.textContent=ih,ju=r(),h(Js.$$.fragment),_u=r(),me=g("div"),h(ll.$$.fragment),Tu=r(),lr=g("p"),lr.textContent=ch,Iu=r(),h(xs.$$.fragment),Ju=r(),h(ws.$$.fragment),xu=r(),he=g("div"),h(ol.$$.fragment),wu=r(),or=g("p"),or.textContent=ph,Cu=r(),h(Cs.$$.fragment),Uu=r(),h(Us.$$.fragment),$u=r(),de=g("div"),h(rl.$$.fragment),vu=r(),rr=g("p"),rr.textContent=uh,ku=r(),ir=g("p"),ir.textContent=gh,qu=r(),h($s.$$.fragment),Au=r(),V=g("div"),h(il.$$.fragment),Eu=r(),cr=g("p"),cr.textContent=mh,Zu=r(),pr=g("p"),pr.innerHTML=hh,Nu=r(),h(vs.$$.fragment),Wu=r(),h(ks.$$.fragment),Gu=r(),h(qs.$$.fragment),Bu=r(),fe=g("div"),h(cl.$$.fragment),Qu=r(),ur=g("p"),ur.textContent=dh,Vu=r(),h(As.$$.fragment),Yu=r(),h(Es.$$.fragment),Su=r(),Zs=g("div"),h(pl.$$.fragment),Xu=r(),gr=g("p"),gr.textContent=fh,Ru=r(),un=g("div"),h(ul.$$.fragment),Du=r(),mr=g("p"),mr.textContent=yh,Hu=r(),h(Ns.$$.fragment),Fu=r(),gn=g("div"),h(gl.$$.fragment),zu=r(),hr=g("p"),hr.textContent=Mh,Lu=r(),h(Ws.$$.fragment),Ou=r(),mn=g("div"),h(ml.$$.fragment),Pu=r(),dr=g("p"),dr.textContent=bh,Ku=r(),h(Gs.$$.fragment),eg=r(),hn=g("div"),h(hl.$$.fragment),ng=r(),fr=g("p"),fr.textContent=jh,tg=r(),h(Bs.$$.fragment),sg=r(),dn=g("div"),h(dl.$$.fragment),ag=r(),yr=g("p"),yr.textContent=_h,lg=r(),h(Qs.$$.fragment),og=r(),fn=g("div"),h(fl.$$.fragment),rg=r(),Mr=g("p"),Mr.textContent=Th,ig=r(),h(Vs.$$.fragment),cg=r(),yn=g("div"),h(yl.$$.fragment),pg=r(),br=g("p"),br.textContent=Ih,ug=r(),h(Ys.$$.fragment),gg=r(),Y=g("div"),h(Ml.$$.fragment),mg=r(),jr=g("p"),jr.textContent=Jh,hg=r(),_r=g("p"),_r.innerHTML=xh,dg=r(),Tr=g("p"),Tr.innerHTML=wh,fg=r(),h(Ss.$$.fragment),yg=r(),h(Xs.$$.fragment),Mg=r(),ye=g("div"),h(bl.$$.fragment),bg=r(),Ir=g("p"),Ir.textContent=Ch,jg=r(),h(Rs.$$.fragment),_g=r(),h(Ds.$$.fragment),Tg=r(),Mn=g("div"),h(jl.$$.fragment),Ig=r(),Jr=g("p"),Jr.textContent=Uh,Jg=r(),h(Hs.$$.fragment),xg=r(),bn=g("div"),h(_l.$$.fragment),wg=r(),xr=g("p"),xr.textContent=$h,Cg=r(),h(Fs.$$.fragment),Ug=r(),z=g("div"),h(Tl.$$.fragment),$g=r(),wr=g("p"),wr.textContent=vh,vg=r(),Cr=g("p"),Cr.innerHTML=kh,kg=r(),h(zs.$$.fragment),qg=r(),h(Ls.$$.fragment),Ag=r(),jn=g("div"),h(Il.$$.fragment),Eg=r(),Ur=g("p"),Ur.textContent=qh,Zg=r(),h(Os.$$.fragment),Ng=r(),Me=g("div"),h(Jl.$$.fragment),Wg=r(),$r=g("p"),$r.textContent=Ah,Gg=r(),h(Ps.$$.fragment),Bg=r(),h(Ks.$$.fragment),Qg=r(),_n=g("div"),h(xl.$$.fragment),Vg=r(),vr=g("p"),vr.textContent=Eh,Yg=r(),h(ea.$$.fragment),Hr=r(),h(wl.$$.fragment),Fr=r(),Tn=g("div"),h(Cl.$$.fragment),Sg=r(),kr=g("p"),kr.textContent=Zh,zr=r(),h(Ul.$$.fragment),Lr=r(),$l=g("p"),$l.textContent=Nh,Or=r(),h(vl.$$.fragment),Pr=r(),In=g("div"),h(kl.$$.fragment),Xg=r(),qr=g("p"),qr.innerHTML=Wh,Kr=r(),h(ql.$$.fragment),ei=r(),Jn=g("div"),h(Al.$$.fragment),Rg=r(),Ar=g("p"),Ar.innerHTML=Gh,ni=r(),h(El.$$.fragment),ti=r(),xn=g("div"),h(Zl.$$.fragment),Dg=r(),Er=g("p"),Er.textContent=Bh,si=r(),h(Nl.$$.fragment),ai=r(),Wl=g("p"),Wl.innerHTML=Qh,li=r(),S=g("div"),h(Gl.$$.fragment),Hg=r(),Zr=g("p"),Zr.textContent=Vh,Fg=r(),h(na.$$.fragment),zg=r(),ta=g("div"),h(Bl.$$.fragment),Lg=r(),Nr=g("p"),Nr.textContent=Yh,Og=r(),sa=g("div"),h(Ql.$$.fragment),Pg=r(),Wr=g("p"),Wr.textContent=Sh,oi=r(),h(Vl.$$.fragment),ri=r(),Gr=g("p"),this.h()},l(s){const j=hd("svelte-u9bgzb",document.head);n=m(j,"META",{name:!0,content:!0}),j.forEach(p),u=i(s),a=m(s,"P",{}),C(a).forEach(p),t=i(s),d(o.$$.fragment,s),e=i(s),c=m(s,"P",{"data-svelte-h":!0}),I(c)!=="svelte-10zkjtm"&&(c.innerHTML=Kg),Br=i(s),aa=m(s,"UL",{"data-svelte-h":!0}),I(aa)!=="svelte-5iysbw"&&(aa.innerHTML=em),Qr=i(s),la=m(s,"P",{"data-svelte-h":!0}),I(la)!=="svelte-1evlv3d"&&(la.innerHTML=nm),Vr=i(s),d(oa.$$.fragment,s),Yr=i(s),x=m(s,"DIV",{class:!0});var v=C(x);d(ra.$$.fragment,v),ci=i(v),Pl=m(v,"P",{"data-svelte-h":!0}),I(Pl)!=="svelte-1p4u01l"&&(Pl.textContent=tm),pi=i(v),Kl=m(v,"P",{"data-svelte-h":!0}),I(Kl)!=="svelte-1w4j4sw"&&(Kl.innerHTML=sm),ui=i(v),Be=m(v,"DIV",{class:!0});var wn=C(Be);d(ia.$$.fragment,wn),gi=i(wn),eo=m(wn,"P",{"data-svelte-h":!0}),I(eo)!=="svelte-1hs5qib"&&(eo.textContent=am),mi=i(wn),d(ct.$$.fragment,wn),wn.forEach(p),hi=i(v),Qe=m(v,"DIV",{class:!0});var Cn=C(Qe);d(ca.$$.fragment,Cn),di=i(Cn),no=m(Cn,"P",{"data-svelte-h":!0}),I(no)!=="svelte-z9e742"&&(no.textContent=lm),fi=i(Cn),d(pt.$$.fragment,Cn),Cn.forEach(p),yi=i(v),Ve=m(v,"DIV",{class:!0});var Un=C(Ve);d(pa.$$.fragment,Un),Mi=i(Un),to=m(Un,"P",{"data-svelte-h":!0}),I(to)!=="svelte-lahnll"&&(to.textContent=om),bi=i(Un),d(ut.$$.fragment,Un),Un.forEach(p),ji=i(v),E=m(v,"DIV",{class:!0});var W=C(E);d(ua.$$.fragment,W),_i=i(W),so=m(W,"P",{"data-svelte-h":!0}),I(so)!=="svelte-5o70yf"&&(so.textContent=rm),Ti=i(W),d(gt.$$.fragment,W),Ii=i(W),d(mt.$$.fragment,W),Ji=i(W),d(ht.$$.fragment,W),xi=i(W),d(dt.$$.fragment,W),wi=i(W),d(ft.$$.fragment,W),Ci=i(W),d(yt.$$.fragment,W),W.forEach(p),Ui=i(v),K=m(v,"DIV",{class:!0});var be=C(K);d(ga.$$.fragment,be),$i=i(be),ao=m(be,"P",{"data-svelte-h":!0}),I(ao)!=="svelte-2dk21c"&&(ao.textContent=im),vi=i(be),d(Mt.$$.fragment,be),ki=i(be),d(bt.$$.fragment,be),be.forEach(p),qi=i(v),Ye=m(v,"DIV",{class:!0});var $n=C(Ye);d(ma.$$.fragment,$n),Ai=i($n),lo=m($n,"P",{"data-svelte-h":!0}),I(lo)!=="svelte-qs8cmr"&&(lo.textContent=cm),Ei=i($n),d(jt.$$.fragment,$n),$n.forEach(p),Zi=i(v),Se=m(v,"DIV",{class:!0});var vn=C(Se);d(ha.$$.fragment,vn),Ni=i(vn),oo=m(vn,"P",{"data-svelte-h":!0}),I(oo)!=="svelte-1axtrg9"&&(oo.textContent=pm),Wi=i(vn),d(_t.$$.fragment,vn),vn.forEach(p),Gi=i(v),Xe=m(v,"DIV",{class:!0});var kn=C(Xe);d(da.$$.fragment,kn),Bi=i(kn),ro=m(kn,"P",{"data-svelte-h":!0}),I(ro)!=="svelte-1lnjtsz"&&(ro.textContent=um),Qi=i(kn),d(Tt.$$.fragment,kn),kn.forEach(p),Vi=i(v),ee=m(v,"DIV",{class:!0});var je=C(ee);d(fa.$$.fragment,je),Yi=i(je),io=m(je,"P",{"data-svelte-h":!0}),I(io)!=="svelte-s2la9t"&&(io.textContent=gm),Si=i(je),co=m(je,"P",{"data-svelte-h":!0}),I(co)!=="svelte-1xhka28"&&(co.innerHTML=mm),Xi=i(je),d(It.$$.fragment,je),je.forEach(p),Ri=i(v),ne=m(v,"DIV",{class:!0});var _e=C(ne);d(ya.$$.fragment,_e),Di=i(_e),po=m(_e,"P",{"data-svelte-h":!0}),I(po)!=="svelte-1htupoc"&&(po.textContent=hm),Hi=i(_e),d(Jt.$$.fragment,_e),Fi=i(_e),d(xt.$$.fragment,_e),_e.forEach(p),zi=i(v),wt=m(v,"DIV",{class:!0});var Yl=C(wt);d(Ma.$$.fragment,Yl),Li=i(Yl),uo=m(Yl,"P",{"data-svelte-h":!0}),I(uo)!=="svelte-1qi4mtg"&&(uo.textContent=dm),Yl.forEach(p),Oi=i(v),te=m(v,"DIV",{class:!0});var Te=C(te);d(ba.$$.fragment,Te),Pi=i(Te),go=m(Te,"P",{"data-svelte-h":!0}),I(go)!=="svelte-1m9sgvu"&&(go.textContent=fm),Ki=i(Te),mo=m(Te,"P",{"data-svelte-h":!0}),I(mo)!=="svelte-13rkne5"&&(mo.innerHTML=ym),ec=i(Te),d(Ct.$$.fragment,Te),Te.forEach(p),nc=i(v),Re=m(v,"DIV",{class:!0});var qn=C(Re);d(ja.$$.fragment,qn),tc=i(qn),ho=m(qn,"P",{"data-svelte-h":!0}),I(ho)!=="svelte-u63854"&&(ho.textContent=Mm),sc=i(qn),d(Ut.$$.fragment,qn),qn.forEach(p),ac=i(v),se=m(v,"DIV",{class:!0});var Ie=C(se);d(_a.$$.fragment,Ie),lc=i(Ie),fo=m(Ie,"P",{"data-svelte-h":!0}),I(fo)!=="svelte-k6f11e"&&(fo.textContent=bm),oc=i(Ie),d($t.$$.fragment,Ie),rc=i(Ie),d(vt.$$.fragment,Ie),Ie.forEach(p),ic=i(v),ae=m(v,"DIV",{class:!0});var Je=C(ae);d(Ta.$$.fragment,Je),cc=i(Je),yo=m(Je,"P",{"data-svelte-h":!0}),I(yo)!=="svelte-7cx5l1"&&(yo.textContent=jm),pc=i(Je),d(kt.$$.fragment,Je),uc=i(Je),d(qt.$$.fragment,Je),Je.forEach(p),gc=i(v),le=m(v,"DIV",{class:!0});var xe=C(le);d(Ia.$$.fragment,xe),mc=i(xe),Mo=m(xe,"P",{"data-svelte-h":!0}),I(Mo)!=="svelte-1tnfouk"&&(Mo.textContent=_m),hc=i(xe),bo=m(xe,"P",{"data-svelte-h":!0}),I(bo)!=="svelte-qrqo93"&&(bo.textContent=Tm),dc=i(xe),d(At.$$.fragment,xe),xe.forEach(p),fc=i(v),B=m(v,"DIV",{class:!0});var X=C(B);d(Ja.$$.fragment,X),yc=i(X),jo=m(X,"P",{"data-svelte-h":!0}),I(jo)!=="svelte-71vo6e"&&(jo.textContent=Im),Mc=i(X),_o=m(X,"P",{"data-svelte-h":!0}),I(_o)!=="svelte-1k36r1q"&&(_o.innerHTML=Jm),bc=i(X),d(Et.$$.fragment,X),jc=i(X),d(Zt.$$.fragment,X),_c=i(X),d(Nt.$$.fragment,X),X.forEach(p),Tc=i(v),oe=m(v,"DIV",{class:!0});var we=C(oe);d(xa.$$.fragment,we),Ic=i(we),To=m(we,"P",{"data-svelte-h":!0}),I(To)!=="svelte-fzfwfh"&&(To.textContent=xm),Jc=i(we),d(Wt.$$.fragment,we),xc=i(we),d(Gt.$$.fragment,we),we.forEach(p),wc=i(v),Bt=m(v,"DIV",{class:!0});var Sl=C(Bt);d(wa.$$.fragment,Sl),Cc=i(Sl),Io=m(Sl,"P",{"data-svelte-h":!0}),I(Io)!=="svelte-14tnsya"&&(Io.textContent=wm),Sl.forEach(p),Uc=i(v),De=m(v,"DIV",{class:!0});var An=C(De);d(Ca.$$.fragment,An),$c=i(An),Jo=m(An,"P",{"data-svelte-h":!0}),I(Jo)!=="svelte-1mibg86"&&(Jo.textContent=Cm),vc=i(An),d(Qt.$$.fragment,An),An.forEach(p),kc=i(v),He=m(v,"DIV",{class:!0});var En=C(He);d(Ua.$$.fragment,En),qc=i(En),xo=m(En,"P",{"data-svelte-h":!0}),I(xo)!=="svelte-1nuhgbh"&&(xo.textContent=Um),Ac=i(En),d(Vt.$$.fragment,En),En.forEach(p),Ec=i(v),Fe=m(v,"DIV",{class:!0});var Zn=C(Fe);d($a.$$.fragment,Zn),Zc=i(Zn),wo=m(Zn,"P",{"data-svelte-h":!0}),I(wo)!=="svelte-1uepm2o"&&(wo.textContent=$m),Nc=i(Zn),d(Yt.$$.fragment,Zn),Zn.forEach(p),Wc=i(v),ze=m(v,"DIV",{class:!0});var Nn=C(ze);d(va.$$.fragment,Nn),Gc=i(Nn),Co=m(Nn,"P",{"data-svelte-h":!0}),I(Co)!=="svelte-77a94i"&&(Co.textContent=vm),Bc=i(Nn),d(St.$$.fragment,Nn),Nn.forEach(p),Qc=i(v),Le=m(v,"DIV",{class:!0});var Wn=C(Le);d(ka.$$.fragment,Wn),Vc=i(Wn),Uo=m(Wn,"P",{"data-svelte-h":!0}),I(Uo)!=="svelte-61sxmo"&&(Uo.textContent=km),Yc=i(Wn),d(Xt.$$.fragment,Wn),Wn.forEach(p),Sc=i(v),Oe=m(v,"DIV",{class:!0});var Gn=C(Oe);d(qa.$$.fragment,Gn),Xc=i(Gn),$o=m(Gn,"P",{"data-svelte-h":!0}),I($o)!=="svelte-hzldyu"&&($o.textContent=qm),Rc=i(Gn),d(Rt.$$.fragment,Gn),Gn.forEach(p),Dc=i(v),Pe=m(v,"DIV",{class:!0});var Bn=C(Pe);d(Aa.$$.fragment,Bn),Hc=i(Bn),vo=m(Bn,"P",{"data-svelte-h":!0}),I(vo)!=="svelte-b4yzyj"&&(vo.textContent=Am),Fc=i(Bn),d(Dt.$$.fragment,Bn),Bn.forEach(p),zc=i(v),Q=m(v,"DIV",{class:!0});var R=C(Q);d(Ea.$$.fragment,R),Lc=i(R),ko=m(R,"P",{"data-svelte-h":!0}),I(ko)!=="svelte-qakvx8"&&(ko.textContent=Em),Oc=i(R),qo=m(R,"P",{"data-svelte-h":!0}),I(qo)!=="svelte-1irx2op"&&(qo.innerHTML=Zm),Pc=i(R),Ao=m(R,"P",{"data-svelte-h":!0}),I(Ao)!=="svelte-140zl9b"&&(Ao.innerHTML=Nm),Kc=i(R),d(Ht.$$.fragment,R),ep=i(R),d(Ft.$$.fragment,R),R.forEach(p),np=i(v),re=m(v,"DIV",{class:!0});var Ce=C(re);d(Za.$$.fragment,Ce),tp=i(Ce),Eo=m(Ce,"P",{"data-svelte-h":!0}),I(Eo)!=="svelte-9lmcnw"&&(Eo.textContent=Wm),sp=i(Ce),d(zt.$$.fragment,Ce),ap=i(Ce),d(Lt.$$.fragment,Ce),Ce.forEach(p),lp=i(v),Ke=m(v,"DIV",{class:!0});var Qn=C(Ke);d(Na.$$.fragment,Qn),op=i(Qn),Zo=m(Qn,"P",{"data-svelte-h":!0}),I(Zo)!=="svelte-12mjzdy"&&(Zo.textContent=Gm),rp=i(Qn),d(Ot.$$.fragment,Qn),Qn.forEach(p),ip=i(v),en=m(v,"DIV",{class:!0});var Vn=C(en);d(Wa.$$.fragment,Vn),cp=i(Vn),No=m(Vn,"P",{"data-svelte-h":!0}),I(No)!=="svelte-1araal"&&(No.textContent=Bm),pp=i(Vn),d(Pt.$$.fragment,Vn),Vn.forEach(p),up=i(v),F=m(v,"DIV",{class:!0});var L=C(F);d(Ga.$$.fragment,L),gp=i(L),Wo=m(L,"P",{"data-svelte-h":!0}),I(Wo)!=="svelte-1v3lqck"&&(Wo.textContent=Qm),mp=i(L),Go=m(L,"P",{"data-svelte-h":!0}),I(Go)!=="svelte-19inetw"&&(Go.innerHTML=Vm),hp=i(L),d(Kt.$$.fragment,L),dp=i(L),d(es.$$.fragment,L),L.forEach(p),fp=i(v),nn=m(v,"DIV",{class:!0});var Yn=C(nn);d(Ba.$$.fragment,Yn),yp=i(Yn),Bo=m(Yn,"P",{"data-svelte-h":!0}),I(Bo)!=="svelte-1jbp6ey"&&(Bo.textContent=Ym),Mp=i(Yn),d(ns.$$.fragment,Yn),Yn.forEach(p),bp=i(v),ie=m(v,"DIV",{class:!0});var Ue=C(ie);d(Qa.$$.fragment,Ue),jp=i(Ue),Qo=m(Ue,"P",{"data-svelte-h":!0}),I(Qo)!=="svelte-1c9xuqj"&&(Qo.textContent=Sm),_p=i(Ue),d(ts.$$.fragment,Ue),Tp=i(Ue),d(ss.$$.fragment,Ue),Ue.forEach(p),Ip=i(v),tn=m(v,"DIV",{class:!0});var Sn=C(tn);d(Va.$$.fragment,Sn),Jp=i(Sn),Vo=m(Sn,"P",{"data-svelte-h":!0}),I(Vo)!=="svelte-108ipf8"&&(Vo.textContent=Xm),xp=i(Sn),d(as.$$.fragment,Sn),Sn.forEach(p),v.forEach(p),Sr=i(s),d(Ya.$$.fragment,s),Xr=i(s),Sa=m(s,"P",{"data-svelte-h":!0}),I(Sa)!=="svelte-1vkrv9k"&&(Sa.innerHTML=Rm),Rr=i(s),d(Xa.$$.fragment,s),Dr=i(s),w=m(s,"DIV",{class:!0});var k=C(w);d(Ra.$$.fragment,k),wp=i(k),Yo=m(k,"P",{"data-svelte-h":!0}),I(Yo)!=="svelte-1p4u01l"&&(Yo.textContent=Dm),Cp=i(k),So=m(k,"P",{"data-svelte-h":!0}),I(So)!=="svelte-1w4j4sw"&&(So.innerHTML=Hm),Up=i(k),sn=m(k,"DIV",{class:!0});var Xn=C(sn);d(Da.$$.fragment,Xn),$p=i(Xn),Xo=m(Xn,"P",{"data-svelte-h":!0}),I(Xo)!=="svelte-1hs5qib"&&(Xo.textContent=Fm),vp=i(Xn),d(ls.$$.fragment,Xn),Xn.forEach(p),kp=i(k),an=m(k,"DIV",{class:!0});var Rn=C(an);d(Ha.$$.fragment,Rn),qp=i(Rn),Ro=m(Rn,"P",{"data-svelte-h":!0}),I(Ro)!=="svelte-z9e742"&&(Ro.textContent=zm),Ap=i(Rn),d(os.$$.fragment,Rn),Rn.forEach(p),Ep=i(k),ln=m(k,"DIV",{class:!0});var Dn=C(ln);d(Fa.$$.fragment,Dn),Zp=i(Dn),Do=m(Dn,"P",{"data-svelte-h":!0}),I(Do)!=="svelte-lahnll"&&(Do.textContent=Lm),Np=i(Dn),d(rs.$$.fragment,Dn),Dn.forEach(p),Wp=i(k),Z=m(k,"DIV",{class:!0});var G=C(Z);d(za.$$.fragment,G),Gp=i(G),Ho=m(G,"P",{"data-svelte-h":!0}),I(Ho)!=="svelte-5o70yf"&&(Ho.textContent=Om),Bp=i(G),d(is.$$.fragment,G),Qp=i(G),d(cs.$$.fragment,G),Vp=i(G),d(ps.$$.fragment,G),Yp=i(G),d(us.$$.fragment,G),Sp=i(G),d(gs.$$.fragment,G),Xp=i(G),d(ms.$$.fragment,G),G.forEach(p),Rp=i(k),ce=m(k,"DIV",{class:!0});var $e=C(ce);d(La.$$.fragment,$e),Dp=i($e),Fo=m($e,"P",{"data-svelte-h":!0}),I(Fo)!=="svelte-2dk21c"&&(Fo.textContent=Pm),Hp=i($e),d(hs.$$.fragment,$e),Fp=i($e),d(ds.$$.fragment,$e),$e.forEach(p),zp=i(k),on=m(k,"DIV",{class:!0});var Hn=C(on);d(Oa.$$.fragment,Hn),Lp=i(Hn),zo=m(Hn,"P",{"data-svelte-h":!0}),I(zo)!=="svelte-qs8cmr"&&(zo.textContent=Km),Op=i(Hn),d(fs.$$.fragment,Hn),Hn.forEach(p),Pp=i(k),rn=m(k,"DIV",{class:!0});var Fn=C(rn);d(Pa.$$.fragment,Fn),Kp=i(Fn),Lo=m(Fn,"P",{"data-svelte-h":!0}),I(Lo)!=="svelte-1axtrg9"&&(Lo.textContent=eh),eu=i(Fn),d(ys.$$.fragment,Fn),Fn.forEach(p),nu=i(k),cn=m(k,"DIV",{class:!0});var zn=C(cn);d(Ka.$$.fragment,zn),tu=i(zn),Oo=m(zn,"P",{"data-svelte-h":!0}),I(Oo)!=="svelte-1lnjtsz"&&(Oo.textContent=nh),su=i(zn),d(Ms.$$.fragment,zn),zn.forEach(p),au=i(k),pe=m(k,"DIV",{class:!0});var ve=C(pe);d(el.$$.fragment,ve),lu=i(ve),Po=m(ve,"P",{"data-svelte-h":!0}),I(Po)!=="svelte-s2la9t"&&(Po.textContent=th),ou=i(ve),Ko=m(ve,"P",{"data-svelte-h":!0}),I(Ko)!=="svelte-1xhka28"&&(Ko.innerHTML=sh),ru=i(ve),d(bs.$$.fragment,ve),ve.forEach(p),iu=i(k),ue=m(k,"DIV",{class:!0});var ke=C(ue);d(nl.$$.fragment,ke),cu=i(ke),er=m(ke,"P",{"data-svelte-h":!0}),I(er)!=="svelte-1htupoc"&&(er.textContent=ah),pu=i(ke),d(js.$$.fragment,ke),uu=i(ke),d(_s.$$.fragment,ke),ke.forEach(p),gu=i(k),Ts=m(k,"DIV",{class:!0});var Xl=C(Ts);d(tl.$$.fragment,Xl),mu=i(Xl),nr=m(Xl,"P",{"data-svelte-h":!0}),I(nr)!=="svelte-1qi4mtg"&&(nr.textContent=lh),Xl.forEach(p),hu=i(k),ge=m(k,"DIV",{class:!0});var qe=C(ge);d(sl.$$.fragment,qe),du=i(qe),tr=m(qe,"P",{"data-svelte-h":!0}),I(tr)!=="svelte-1m9sgvu"&&(tr.textContent=oh),fu=i(qe),sr=m(qe,"P",{"data-svelte-h":!0}),I(sr)!=="svelte-13rkne5"&&(sr.innerHTML=rh),yu=i(qe),d(Is.$$.fragment,qe),qe.forEach(p),Mu=i(k),pn=m(k,"DIV",{class:!0});var Ln=C(pn);d(al.$$.fragment,Ln),bu=i(Ln),ar=m(Ln,"P",{"data-svelte-h":!0}),I(ar)!=="svelte-u63854"&&(ar.textContent=ih),ju=i(Ln),d(Js.$$.fragment,Ln),Ln.forEach(p),_u=i(k),me=m(k,"DIV",{class:!0});var Ae=C(me);d(ll.$$.fragment,Ae),Tu=i(Ae),lr=m(Ae,"P",{"data-svelte-h":!0}),I(lr)!=="svelte-k6f11e"&&(lr.textContent=ch),Iu=i(Ae),d(xs.$$.fragment,Ae),Ju=i(Ae),d(ws.$$.fragment,Ae),Ae.forEach(p),xu=i(k),he=m(k,"DIV",{class:!0});var Ee=C(he);d(ol.$$.fragment,Ee),wu=i(Ee),or=m(Ee,"P",{"data-svelte-h":!0}),I(or)!=="svelte-7cx5l1"&&(or.textContent=ph),Cu=i(Ee),d(Cs.$$.fragment,Ee),Uu=i(Ee),d(Us.$$.fragment,Ee),Ee.forEach(p),$u=i(k),de=m(k,"DIV",{class:!0});var Ze=C(de);d(rl.$$.fragment,Ze),vu=i(Ze),rr=m(Ze,"P",{"data-svelte-h":!0}),I(rr)!=="svelte-1tnfouk"&&(rr.textContent=uh),ku=i(Ze),ir=m(Ze,"P",{"data-svelte-h":!0}),I(ir)!=="svelte-qrqo93"&&(ir.textContent=gh),qu=i(Ze),d($s.$$.fragment,Ze),Ze.forEach(p),Au=i(k),V=m(k,"DIV",{class:!0});var D=C(V);d(il.$$.fragment,D),Eu=i(D),cr=m(D,"P",{"data-svelte-h":!0}),I(cr)!=="svelte-71vo6e"&&(cr.textContent=mh),Zu=i(D),pr=m(D,"P",{"data-svelte-h":!0}),I(pr)!=="svelte-1k36r1q"&&(pr.innerHTML=hh),Nu=i(D),d(vs.$$.fragment,D),Wu=i(D),d(ks.$$.fragment,D),Gu=i(D),d(qs.$$.fragment,D),D.forEach(p),Bu=i(k),fe=m(k,"DIV",{class:!0});var Ne=C(fe);d(cl.$$.fragment,Ne),Qu=i(Ne),ur=m(Ne,"P",{"data-svelte-h":!0}),I(ur)!=="svelte-fzfwfh"&&(ur.textContent=dh),Vu=i(Ne),d(As.$$.fragment,Ne),Yu=i(Ne),d(Es.$$.fragment,Ne),Ne.forEach(p),Su=i(k),Zs=m(k,"DIV",{class:!0});var Rl=C(Zs);d(pl.$$.fragment,Rl),Xu=i(Rl),gr=m(Rl,"P",{"data-svelte-h":!0}),I(gr)!=="svelte-14tnsya"&&(gr.textContent=fh),Rl.forEach(p),Ru=i(k),un=m(k,"DIV",{class:!0});var On=C(un);d(ul.$$.fragment,On),Du=i(On),mr=m(On,"P",{"data-svelte-h":!0}),I(mr)!=="svelte-1mibg86"&&(mr.textContent=yh),Hu=i(On),d(Ns.$$.fragment,On),On.forEach(p),Fu=i(k),gn=m(k,"DIV",{class:!0});var Pn=C(gn);d(gl.$$.fragment,Pn),zu=i(Pn),hr=m(Pn,"P",{"data-svelte-h":!0}),I(hr)!=="svelte-1nuhgbh"&&(hr.textContent=Mh),Lu=i(Pn),d(Ws.$$.fragment,Pn),Pn.forEach(p),Ou=i(k),mn=m(k,"DIV",{class:!0});var Kn=C(mn);d(ml.$$.fragment,Kn),Pu=i(Kn),dr=m(Kn,"P",{"data-svelte-h":!0}),I(dr)!=="svelte-1uepm2o"&&(dr.textContent=bh),Ku=i(Kn),d(Gs.$$.fragment,Kn),Kn.forEach(p),eg=i(k),hn=m(k,"DIV",{class:!0});var et=C(hn);d(hl.$$.fragment,et),ng=i(et),fr=m(et,"P",{"data-svelte-h":!0}),I(fr)!=="svelte-77a94i"&&(fr.textContent=jh),tg=i(et),d(Bs.$$.fragment,et),et.forEach(p),sg=i(k),dn=m(k,"DIV",{class:!0});var nt=C(dn);d(dl.$$.fragment,nt),ag=i(nt),yr=m(nt,"P",{"data-svelte-h":!0}),I(yr)!=="svelte-61sxmo"&&(yr.textContent=_h),lg=i(nt),d(Qs.$$.fragment,nt),nt.forEach(p),og=i(k),fn=m(k,"DIV",{class:!0});var tt=C(fn);d(fl.$$.fragment,tt),rg=i(tt),Mr=m(tt,"P",{"data-svelte-h":!0}),I(Mr)!=="svelte-hzldyu"&&(Mr.textContent=Th),ig=i(tt),d(Vs.$$.fragment,tt),tt.forEach(p),cg=i(k),yn=m(k,"DIV",{class:!0});var st=C(yn);d(yl.$$.fragment,st),pg=i(st),br=m(st,"P",{"data-svelte-h":!0}),I(br)!=="svelte-b4yzyj"&&(br.textContent=Ih),ug=i(st),d(Ys.$$.fragment,st),st.forEach(p),gg=i(k),Y=m(k,"DIV",{class:!0});var H=C(Y);d(Ml.$$.fragment,H),mg=i(H),jr=m(H,"P",{"data-svelte-h":!0}),I(jr)!=="svelte-qakvx8"&&(jr.textContent=Jh),hg=i(H),_r=m(H,"P",{"data-svelte-h":!0}),I(_r)!=="svelte-1irx2op"&&(_r.innerHTML=xh),dg=i(H),Tr=m(H,"P",{"data-svelte-h":!0}),I(Tr)!=="svelte-140zl9b"&&(Tr.innerHTML=wh),fg=i(H),d(Ss.$$.fragment,H),yg=i(H),d(Xs.$$.fragment,H),H.forEach(p),Mg=i(k),ye=m(k,"DIV",{class:!0});var We=C(ye);d(bl.$$.fragment,We),bg=i(We),Ir=m(We,"P",{"data-svelte-h":!0}),I(Ir)!=="svelte-9lmcnw"&&(Ir.textContent=Ch),jg=i(We),d(Rs.$$.fragment,We),_g=i(We),d(Ds.$$.fragment,We),We.forEach(p),Tg=i(k),Mn=m(k,"DIV",{class:!0});var at=C(Mn);d(jl.$$.fragment,at),Ig=i(at),Jr=m(at,"P",{"data-svelte-h":!0}),I(Jr)!=="svelte-12mjzdy"&&(Jr.textContent=Uh),Jg=i(at),d(Hs.$$.fragment,at),at.forEach(p),xg=i(k),bn=m(k,"DIV",{class:!0});var lt=C(bn);d(_l.$$.fragment,lt),wg=i(lt),xr=m(lt,"P",{"data-svelte-h":!0}),I(xr)!=="svelte-1araal"&&(xr.textContent=$h),Cg=i(lt),d(Fs.$$.fragment,lt),lt.forEach(p),Ug=i(k),z=m(k,"DIV",{class:!0});var O=C(z);d(Tl.$$.fragment,O),$g=i(O),wr=m(O,"P",{"data-svelte-h":!0}),I(wr)!=="svelte-1v3lqck"&&(wr.textContent=vh),vg=i(O),Cr=m(O,"P",{"data-svelte-h":!0}),I(Cr)!=="svelte-19inetw"&&(Cr.innerHTML=kh),kg=i(O),d(zs.$$.fragment,O),qg=i(O),d(Ls.$$.fragment,O),O.forEach(p),Ag=i(k),jn=m(k,"DIV",{class:!0});var ot=C(jn);d(Il.$$.fragment,ot),Eg=i(ot),Ur=m(ot,"P",{"data-svelte-h":!0}),I(Ur)!=="svelte-1jbp6ey"&&(Ur.textContent=qh),Zg=i(ot),d(Os.$$.fragment,ot),ot.forEach(p),Ng=i(k),Me=m(k,"DIV",{class:!0});var Ge=C(Me);d(Jl.$$.fragment,Ge),Wg=i(Ge),$r=m(Ge,"P",{"data-svelte-h":!0}),I($r)!=="svelte-1c9xuqj"&&($r.textContent=Ah),Gg=i(Ge),d(Ps.$$.fragment,Ge),Bg=i(Ge),d(Ks.$$.fragment,Ge),Ge.forEach(p),Qg=i(k),_n=m(k,"DIV",{class:!0});var rt=C(_n);d(xl.$$.fragment,rt),Vg=i(rt),vr=m(rt,"P",{"data-svelte-h":!0}),I(vr)!=="svelte-108ipf8"&&(vr.textContent=Eh),Yg=i(rt),d(ea.$$.fragment,rt),rt.forEach(p),k.forEach(p),Hr=i(s),d(wl.$$.fragment,s),Fr=i(s),Tn=m(s,"DIV",{class:!0});var Dl=C(Tn);d(Cl.$$.fragment,Dl),Sg=i(Dl),kr=m(Dl,"P",{"data-svelte-h":!0}),I(kr)!=="svelte-2793d9"&&(kr.textContent=Zh),Dl.forEach(p),zr=i(s),d(Ul.$$.fragment,s),Lr=i(s),$l=m(s,"P",{"data-svelte-h":!0}),I($l)!=="svelte-1lzrumh"&&($l.textContent=Nh),Or=i(s),d(vl.$$.fragment,s),Pr=i(s),In=m(s,"DIV",{class:!0});var Hl=C(In);d(kl.$$.fragment,Hl),Xg=i(Hl),qr=m(Hl,"P",{"data-svelte-h":!0}),I(qr)!=="svelte-qv6x9s"&&(qr.innerHTML=Wh),Hl.forEach(p),Kr=i(s),d(ql.$$.fragment,s),ei=i(s),Jn=m(s,"DIV",{class:!0});var Fl=C(Jn);d(Al.$$.fragment,Fl),Rg=i(Fl),Ar=m(Fl,"P",{"data-svelte-h":!0}),I(Ar)!=="svelte-19e3juo"&&(Ar.innerHTML=Gh),Fl.forEach(p),ni=i(s),d(El.$$.fragment,s),ti=i(s),xn=m(s,"DIV",{class:!0});var zl=C(xn);d(Zl.$$.fragment,zl),Dg=i(zl),Er=m(zl,"P",{"data-svelte-h":!0}),I(Er)!=="svelte-18ffdgx"&&(Er.textContent=Bh),zl.forEach(p),si=i(s),d(Nl.$$.fragment,s),ai=i(s),Wl=m(s,"P",{"data-svelte-h":!0}),I(Wl)!=="svelte-14muynu"&&(Wl.innerHTML=Qh),li=i(s),S=m(s,"DIV",{class:!0});var P=C(S);d(Gl.$$.fragment,P),Hg=i(P),Zr=m(P,"P",{"data-svelte-h":!0}),I(Zr)!=="svelte-xkrgz1"&&(Zr.textContent=Vh),Fg=i(P),d(na.$$.fragment,P),zg=i(P),ta=m(P,"DIV",{class:!0});var Ll=C(ta);d(Bl.$$.fragment,Ll),Lg=i(Ll),Nr=m(Ll,"P",{"data-svelte-h":!0}),I(Nr)!=="svelte-1ruvvxs"&&(Nr.textContent=Yh),Ll.forEach(p),Og=i(P),sa=m(P,"DIV",{class:!0});var Ol=C(sa);d(Ql.$$.fragment,Ol),Pg=i(Ol),Wr=m(Ol,"P",{"data-svelte-h":!0}),I(Wr)!=="svelte-ss15d2"&&(Wr.textContent=Sh),Ol.forEach(p),P.forEach(p),oi=i(s),d(Vl.$$.fragment,s),ri=i(s),Gr=m(s,"P",{}),C(Gr).forEach(p),this.h()},h(){U(n,"name","hf:doc:metadata"),U(n,"content",ry),U(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Ts,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(ta,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(sa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,j){l(document.head,n),_(s,u,j),_(s,a,j),_(s,t,j),f(o,s,j),_(s,e,j),_(s,c,j),_(s,Br,j),_(s,aa,j),_(s,Qr,j),_(s,la,j),_(s,Vr,j),f(oa,s,j),_(s,Yr,j),_(s,x,j),f(ra,x,null),l(x,ci),l(x,Pl),l(x,pi),l(x,Kl),l(x,ui),l(x,Be),f(ia,Be,null),l(Be,gi),l(Be,eo),l(Be,mi),f(ct,Be,null),l(x,hi),l(x,Qe),f(ca,Qe,null),l(Qe,di),l(Qe,no),l(Qe,fi),f(pt,Qe,null),l(x,yi),l(x,Ve),f(pa,Ve,null),l(Ve,Mi),l(Ve,to),l(Ve,bi),f(ut,Ve,null),l(x,ji),l(x,E),f(ua,E,null),l(E,_i),l(E,so),l(E,Ti),f(gt,E,null),l(E,Ii),f(mt,E,null),l(E,Ji),f(ht,E,null),l(E,xi),f(dt,E,null),l(E,wi),f(ft,E,null),l(E,Ci),f(yt,E,null),l(x,Ui),l(x,K),f(ga,K,null),l(K,$i),l(K,ao),l(K,vi),f(Mt,K,null),l(K,ki),f(bt,K,null),l(x,qi),l(x,Ye),f(ma,Ye,null),l(Ye,Ai),l(Ye,lo),l(Ye,Ei),f(jt,Ye,null),l(x,Zi),l(x,Se),f(ha,Se,null),l(Se,Ni),l(Se,oo),l(Se,Wi),f(_t,Se,null),l(x,Gi),l(x,Xe),f(da,Xe,null),l(Xe,Bi),l(Xe,ro),l(Xe,Qi),f(Tt,Xe,null),l(x,Vi),l(x,ee),f(fa,ee,null),l(ee,Yi),l(ee,io),l(ee,Si),l(ee,co),l(ee,Xi),f(It,ee,null),l(x,Ri),l(x,ne),f(ya,ne,null),l(ne,Di),l(ne,po),l(ne,Hi),f(Jt,ne,null),l(ne,Fi),f(xt,ne,null),l(x,zi),l(x,wt),f(Ma,wt,null),l(wt,Li),l(wt,uo),l(x,Oi),l(x,te),f(ba,te,null),l(te,Pi),l(te,go),l(te,Ki),l(te,mo),l(te,ec),f(Ct,te,null),l(x,nc),l(x,Re),f(ja,Re,null),l(Re,tc),l(Re,ho),l(Re,sc),f(Ut,Re,null),l(x,ac),l(x,se),f(_a,se,null),l(se,lc),l(se,fo),l(se,oc),f($t,se,null),l(se,rc),f(vt,se,null),l(x,ic),l(x,ae),f(Ta,ae,null),l(ae,cc),l(ae,yo),l(ae,pc),f(kt,ae,null),l(ae,uc),f(qt,ae,null),l(x,gc),l(x,le),f(Ia,le,null),l(le,mc),l(le,Mo),l(le,hc),l(le,bo),l(le,dc),f(At,le,null),l(x,fc),l(x,B),f(Ja,B,null),l(B,yc),l(B,jo),l(B,Mc),l(B,_o),l(B,bc),f(Et,B,null),l(B,jc),f(Zt,B,null),l(B,_c),f(Nt,B,null),l(x,Tc),l(x,oe),f(xa,oe,null),l(oe,Ic),l(oe,To),l(oe,Jc),f(Wt,oe,null),l(oe,xc),f(Gt,oe,null),l(x,wc),l(x,Bt),f(wa,Bt,null),l(Bt,Cc),l(Bt,Io),l(x,Uc),l(x,De),f(Ca,De,null),l(De,$c),l(De,Jo),l(De,vc),f(Qt,De,null),l(x,kc),l(x,He),f(Ua,He,null),l(He,qc),l(He,xo),l(He,Ac),f(Vt,He,null),l(x,Ec),l(x,Fe),f($a,Fe,null),l(Fe,Zc),l(Fe,wo),l(Fe,Nc),f(Yt,Fe,null),l(x,Wc),l(x,ze),f(va,ze,null),l(ze,Gc),l(ze,Co),l(ze,Bc),f(St,ze,null),l(x,Qc),l(x,Le),f(ka,Le,null),l(Le,Vc),l(Le,Uo),l(Le,Yc),f(Xt,Le,null),l(x,Sc),l(x,Oe),f(qa,Oe,null),l(Oe,Xc),l(Oe,$o),l(Oe,Rc),f(Rt,Oe,null),l(x,Dc),l(x,Pe),f(Aa,Pe,null),l(Pe,Hc),l(Pe,vo),l(Pe,Fc),f(Dt,Pe,null),l(x,zc),l(x,Q),f(Ea,Q,null),l(Q,Lc),l(Q,ko),l(Q,Oc),l(Q,qo),l(Q,Pc),l(Q,Ao),l(Q,Kc),f(Ht,Q,null),l(Q,ep),f(Ft,Q,null),l(x,np),l(x,re),f(Za,re,null),l(re,tp),l(re,Eo),l(re,sp),f(zt,re,null),l(re,ap),f(Lt,re,null),l(x,lp),l(x,Ke),f(Na,Ke,null),l(Ke,op),l(Ke,Zo),l(Ke,rp),f(Ot,Ke,null),l(x,ip),l(x,en),f(Wa,en,null),l(en,cp),l(en,No),l(en,pp),f(Pt,en,null),l(x,up),l(x,F),f(Ga,F,null),l(F,gp),l(F,Wo),l(F,mp),l(F,Go),l(F,hp),f(Kt,F,null),l(F,dp),f(es,F,null),l(x,fp),l(x,nn),f(Ba,nn,null),l(nn,yp),l(nn,Bo),l(nn,Mp),f(ns,nn,null),l(x,bp),l(x,ie),f(Qa,ie,null),l(ie,jp),l(ie,Qo),l(ie,_p),f(ts,ie,null),l(ie,Tp),f(ss,ie,null),l(x,Ip),l(x,tn),f(Va,tn,null),l(tn,Jp),l(tn,Vo),l(tn,xp),f(as,tn,null),_(s,Sr,j),f(Ya,s,j),_(s,Xr,j),_(s,Sa,j),_(s,Rr,j),f(Xa,s,j),_(s,Dr,j),_(s,w,j),f(Ra,w,null),l(w,wp),l(w,Yo),l(w,Cp),l(w,So),l(w,Up),l(w,sn),f(Da,sn,null),l(sn,$p),l(sn,Xo),l(sn,vp),f(ls,sn,null),l(w,kp),l(w,an),f(Ha,an,null),l(an,qp),l(an,Ro),l(an,Ap),f(os,an,null),l(w,Ep),l(w,ln),f(Fa,ln,null),l(ln,Zp),l(ln,Do),l(ln,Np),f(rs,ln,null),l(w,Wp),l(w,Z),f(za,Z,null),l(Z,Gp),l(Z,Ho),l(Z,Bp),f(is,Z,null),l(Z,Qp),f(cs,Z,null),l(Z,Vp),f(ps,Z,null),l(Z,Yp),f(us,Z,null),l(Z,Sp),f(gs,Z,null),l(Z,Xp),f(ms,Z,null),l(w,Rp),l(w,ce),f(La,ce,null),l(ce,Dp),l(ce,Fo),l(ce,Hp),f(hs,ce,null),l(ce,Fp),f(ds,ce,null),l(w,zp),l(w,on),f(Oa,on,null),l(on,Lp),l(on,zo),l(on,Op),f(fs,on,null),l(w,Pp),l(w,rn),f(Pa,rn,null),l(rn,Kp),l(rn,Lo),l(rn,eu),f(ys,rn,null),l(w,nu),l(w,cn),f(Ka,cn,null),l(cn,tu),l(cn,Oo),l(cn,su),f(Ms,cn,null),l(w,au),l(w,pe),f(el,pe,null),l(pe,lu),l(pe,Po),l(pe,ou),l(pe,Ko),l(pe,ru),f(bs,pe,null),l(w,iu),l(w,ue),f(nl,ue,null),l(ue,cu),l(ue,er),l(ue,pu),f(js,ue,null),l(ue,uu),f(_s,ue,null),l(w,gu),l(w,Ts),f(tl,Ts,null),l(Ts,mu),l(Ts,nr),l(w,hu),l(w,ge),f(sl,ge,null),l(ge,du),l(ge,tr),l(ge,fu),l(ge,sr),l(ge,yu),f(Is,ge,null),l(w,Mu),l(w,pn),f(al,pn,null),l(pn,bu),l(pn,ar),l(pn,ju),f(Js,pn,null),l(w,_u),l(w,me),f(ll,me,null),l(me,Tu),l(me,lr),l(me,Iu),f(xs,me,null),l(me,Ju),f(ws,me,null),l(w,xu),l(w,he),f(ol,he,null),l(he,wu),l(he,or),l(he,Cu),f(Cs,he,null),l(he,Uu),f(Us,he,null),l(w,$u),l(w,de),f(rl,de,null),l(de,vu),l(de,rr),l(de,ku),l(de,ir),l(de,qu),f($s,de,null),l(w,Au),l(w,V),f(il,V,null),l(V,Eu),l(V,cr),l(V,Zu),l(V,pr),l(V,Nu),f(vs,V,null),l(V,Wu),f(ks,V,null),l(V,Gu),f(qs,V,null),l(w,Bu),l(w,fe),f(cl,fe,null),l(fe,Qu),l(fe,ur),l(fe,Vu),f(As,fe,null),l(fe,Yu),f(Es,fe,null),l(w,Su),l(w,Zs),f(pl,Zs,null),l(Zs,Xu),l(Zs,gr),l(w,Ru),l(w,un),f(ul,un,null),l(un,Du),l(un,mr),l(un,Hu),f(Ns,un,null),l(w,Fu),l(w,gn),f(gl,gn,null),l(gn,zu),l(gn,hr),l(gn,Lu),f(Ws,gn,null),l(w,Ou),l(w,mn),f(ml,mn,null),l(mn,Pu),l(mn,dr),l(mn,Ku),f(Gs,mn,null),l(w,eg),l(w,hn),f(hl,hn,null),l(hn,ng),l(hn,fr),l(hn,tg),f(Bs,hn,null),l(w,sg),l(w,dn),f(dl,dn,null),l(dn,ag),l(dn,yr),l(dn,lg),f(Qs,dn,null),l(w,og),l(w,fn),f(fl,fn,null),l(fn,rg),l(fn,Mr),l(fn,ig),f(Vs,fn,null),l(w,cg),l(w,yn),f(yl,yn,null),l(yn,pg),l(yn,br),l(yn,ug),f(Ys,yn,null),l(w,gg),l(w,Y),f(Ml,Y,null),l(Y,mg),l(Y,jr),l(Y,hg),l(Y,_r),l(Y,dg),l(Y,Tr),l(Y,fg),f(Ss,Y,null),l(Y,yg),f(Xs,Y,null),l(w,Mg),l(w,ye),f(bl,ye,null),l(ye,bg),l(ye,Ir),l(ye,jg),f(Rs,ye,null),l(ye,_g),f(Ds,ye,null),l(w,Tg),l(w,Mn),f(jl,Mn,null),l(Mn,Ig),l(Mn,Jr),l(Mn,Jg),f(Hs,Mn,null),l(w,xg),l(w,bn),f(_l,bn,null),l(bn,wg),l(bn,xr),l(bn,Cg),f(Fs,bn,null),l(w,Ug),l(w,z),f(Tl,z,null),l(z,$g),l(z,wr),l(z,vg),l(z,Cr),l(z,kg),f(zs,z,null),l(z,qg),f(Ls,z,null),l(w,Ag),l(w,jn),f(Il,jn,null),l(jn,Eg),l(jn,Ur),l(jn,Zg),f(Os,jn,null),l(w,Ng),l(w,Me),f(Jl,Me,null),l(Me,Wg),l(Me,$r),l(Me,Gg),f(Ps,Me,null),l(Me,Bg),f(Ks,Me,null),l(w,Qg),l(w,_n),f(xl,_n,null),l(_n,Vg),l(_n,vr),l(_n,Yg),f(ea,_n,null),_(s,Hr,j),f(wl,s,j),_(s,Fr,j),_(s,Tn,j),f(Cl,Tn,null),l(Tn,Sg),l(Tn,kr),_(s,zr,j),f(Ul,s,j),_(s,Lr,j),_(s,$l,j),_(s,Or,j),f(vl,s,j),_(s,Pr,j),_(s,In,j),f(kl,In,null),l(In,Xg),l(In,qr),_(s,Kr,j),f(ql,s,j),_(s,ei,j),_(s,Jn,j),f(Al,Jn,null),l(Jn,Rg),l(Jn,Ar),_(s,ni,j),f(El,s,j),_(s,ti,j),_(s,xn,j),f(Zl,xn,null),l(xn,Dg),l(xn,Er),_(s,si,j),f(Nl,s,j),_(s,ai,j),_(s,Wl,j),_(s,li,j),_(s,S,j),f(Gl,S,null),l(S,Hg),l(S,Zr),l(S,Fg),f(na,S,null),l(S,zg),l(S,ta),f(Bl,ta,null),l(ta,Lg),l(ta,Nr),l(S,Og),l(S,sa),f(Ql,sa,null),l(sa,Pg),l(sa,Wr),_(s,oi,j),f(Vl,s,j),_(s,ri,j),_(s,Gr,j),ii=!0},p(s,[j]){const v={};j&2&&(v.$$scope={dirty:j,ctx:s}),ct.$set(v);const wn={};j&2&&(wn.$$scope={dirty:j,ctx:s}),pt.$set(wn);const Cn={};j&2&&(Cn.$$scope={dirty:j,ctx:s}),ut.$set(Cn);const Un={};j&2&&(Un.$$scope={dirty:j,ctx:s}),gt.$set(Un);const W={};j&2&&(W.$$scope={dirty:j,ctx:s}),mt.$set(W);const be={};j&2&&(be.$$scope={dirty:j,ctx:s}),ht.$set(be);const $n={};j&2&&($n.$$scope={dirty:j,ctx:s}),dt.$set($n);const vn={};j&2&&(vn.$$scope={dirty:j,ctx:s}),ft.$set(vn);const kn={};j&2&&(kn.$$scope={dirty:j,ctx:s}),yt.$set(kn);const je={};j&2&&(je.$$scope={dirty:j,ctx:s}),Mt.$set(je);const _e={};j&2&&(_e.$$scope={dirty:j,ctx:s}),bt.$set(_e);const Yl={};j&2&&(Yl.$$scope={dirty:j,ctx:s}),jt.$set(Yl);const Te={};j&2&&(Te.$$scope={dirty:j,ctx:s}),_t.$set(Te);const qn={};j&2&&(qn.$$scope={dirty:j,ctx:s}),Tt.$set(qn);const Ie={};j&2&&(Ie.$$scope={dirty:j,ctx:s}),It.$set(Ie);const Je={};j&2&&(Je.$$scope={dirty:j,ctx:s}),Jt.$set(Je);const xe={};j&2&&(xe.$$scope={dirty:j,ctx:s}),xt.$set(xe);const X={};j&2&&(X.$$scope={dirty:j,ctx:s}),Ct.$set(X);const we={};j&2&&(we.$$scope={dirty:j,ctx:s}),Ut.$set(we);const Sl={};j&2&&(Sl.$$scope={dirty:j,ctx:s}),$t.$set(Sl);const An={};j&2&&(An.$$scope={dirty:j,ctx:s}),vt.$set(An);const En={};j&2&&(En.$$scope={dirty:j,ctx:s}),kt.$set(En);const Zn={};j&2&&(Zn.$$scope={dirty:j,ctx:s}),qt.$set(Zn);const Nn={};j&2&&(Nn.$$scope={dirty:j,ctx:s}),At.$set(Nn);const Wn={};j&2&&(Wn.$$scope={dirty:j,ctx:s}),Et.$set(Wn);const Gn={};j&2&&(Gn.$$scope={dirty:j,ctx:s}),Zt.$set(Gn);const Bn={};j&2&&(Bn.$$scope={dirty:j,ctx:s}),Nt.$set(Bn);const R={};j&2&&(R.$$scope={dirty:j,ctx:s}),Wt.$set(R);const Ce={};j&2&&(Ce.$$scope={dirty:j,ctx:s}),Gt.$set(Ce);const Qn={};j&2&&(Qn.$$scope={dirty:j,ctx:s}),Qt.$set(Qn);const Vn={};j&2&&(Vn.$$scope={dirty:j,ctx:s}),Vt.$set(Vn);const L={};j&2&&(L.$$scope={dirty:j,ctx:s}),Yt.$set(L);const Yn={};j&2&&(Yn.$$scope={dirty:j,ctx:s}),St.$set(Yn);const Ue={};j&2&&(Ue.$$scope={dirty:j,ctx:s}),Xt.$set(Ue);const Sn={};j&2&&(Sn.$$scope={dirty:j,ctx:s}),Rt.$set(Sn);const k={};j&2&&(k.$$scope={dirty:j,ctx:s}),Dt.$set(k);const Xn={};j&2&&(Xn.$$scope={dirty:j,ctx:s}),Ht.$set(Xn);const Rn={};j&2&&(Rn.$$scope={dirty:j,ctx:s}),Ft.$set(Rn);const Dn={};j&2&&(Dn.$$scope={dirty:j,ctx:s}),zt.$set(Dn);const G={};j&2&&(G.$$scope={dirty:j,ctx:s}),Lt.$set(G);const $e={};j&2&&($e.$$scope={dirty:j,ctx:s}),Ot.$set($e);const Hn={};j&2&&(Hn.$$scope={dirty:j,ctx:s}),Pt.$set(Hn);const Fn={};j&2&&(Fn.$$scope={dirty:j,ctx:s}),Kt.$set(Fn);const zn={};j&2&&(zn.$$scope={dirty:j,ctx:s}),es.$set(zn);const ve={};j&2&&(ve.$$scope={dirty:j,ctx:s}),ns.$set(ve);const ke={};j&2&&(ke.$$scope={dirty:j,ctx:s}),ts.$set(ke);const Xl={};j&2&&(Xl.$$scope={dirty:j,ctx:s}),ss.$set(Xl);const qe={};j&2&&(qe.$$scope={dirty:j,ctx:s}),as.$set(qe);const Ln={};j&2&&(Ln.$$scope={dirty:j,ctx:s}),ls.$set(Ln);const Ae={};j&2&&(Ae.$$scope={dirty:j,ctx:s}),os.$set(Ae);const Ee={};j&2&&(Ee.$$scope={dirty:j,ctx:s}),rs.$set(Ee);const Ze={};j&2&&(Ze.$$scope={dirty:j,ctx:s}),is.$set(Ze);const D={};j&2&&(D.$$scope={dirty:j,ctx:s}),cs.$set(D);const Ne={};j&2&&(Ne.$$scope={dirty:j,ctx:s}),ps.$set(Ne);const Rl={};j&2&&(Rl.$$scope={dirty:j,ctx:s}),us.$set(Rl);const On={};j&2&&(On.$$scope={dirty:j,ctx:s}),gs.$set(On);const Pn={};j&2&&(Pn.$$scope={dirty:j,ctx:s}),ms.$set(Pn);const Kn={};j&2&&(Kn.$$scope={dirty:j,ctx:s}),hs.$set(Kn);const et={};j&2&&(et.$$scope={dirty:j,ctx:s}),ds.$set(et);const nt={};j&2&&(nt.$$scope={dirty:j,ctx:s}),fs.$set(nt);const tt={};j&2&&(tt.$$scope={dirty:j,ctx:s}),ys.$set(tt);const st={};j&2&&(st.$$scope={dirty:j,ctx:s}),Ms.$set(st);const H={};j&2&&(H.$$scope={dirty:j,ctx:s}),bs.$set(H);const We={};j&2&&(We.$$scope={dirty:j,ctx:s}),js.$set(We);const at={};j&2&&(at.$$scope={dirty:j,ctx:s}),_s.$set(at);const lt={};j&2&&(lt.$$scope={dirty:j,ctx:s}),Is.$set(lt);const O={};j&2&&(O.$$scope={dirty:j,ctx:s}),Js.$set(O);const ot={};j&2&&(ot.$$scope={dirty:j,ctx:s}),xs.$set(ot);const Ge={};j&2&&(Ge.$$scope={dirty:j,ctx:s}),ws.$set(Ge);const rt={};j&2&&(rt.$$scope={dirty:j,ctx:s}),Cs.$set(rt);const Dl={};j&2&&(Dl.$$scope={dirty:j,ctx:s}),Us.$set(Dl);const Hl={};j&2&&(Hl.$$scope={dirty:j,ctx:s}),$s.$set(Hl);const Fl={};j&2&&(Fl.$$scope={dirty:j,ctx:s}),vs.$set(Fl);const zl={};j&2&&(zl.$$scope={dirty:j,ctx:s}),ks.$set(zl);const P={};j&2&&(P.$$scope={dirty:j,ctx:s}),qs.$set(P);const Ll={};j&2&&(Ll.$$scope={dirty:j,ctx:s}),As.$set(Ll);const Ol={};j&2&&(Ol.$$scope={dirty:j,ctx:s}),Es.$set(Ol);const Xh={};j&2&&(Xh.$$scope={dirty:j,ctx:s}),Ns.$set(Xh);const Rh={};j&2&&(Rh.$$scope={dirty:j,ctx:s}),Ws.$set(Rh);const Dh={};j&2&&(Dh.$$scope={dirty:j,ctx:s}),Gs.$set(Dh);const Hh={};j&2&&(Hh.$$scope={dirty:j,ctx:s}),Bs.$set(Hh);const Fh={};j&2&&(Fh.$$scope={dirty:j,ctx:s}),Qs.$set(Fh);const zh={};j&2&&(zh.$$scope={dirty:j,ctx:s}),Vs.$set(zh);const Lh={};j&2&&(Lh.$$scope={dirty:j,ctx:s}),Ys.$set(Lh);const Oh={};j&2&&(Oh.$$scope={dirty:j,ctx:s}),Ss.$set(Oh);const Ph={};j&2&&(Ph.$$scope={dirty:j,ctx:s}),Xs.$set(Ph);const Kh={};j&2&&(Kh.$$scope={dirty:j,ctx:s}),Rs.$set(Kh);const ed={};j&2&&(ed.$$scope={dirty:j,ctx:s}),Ds.$set(ed);const nd={};j&2&&(nd.$$scope={dirty:j,ctx:s}),Hs.$set(nd);const td={};j&2&&(td.$$scope={dirty:j,ctx:s}),Fs.$set(td);const sd={};j&2&&(sd.$$scope={dirty:j,ctx:s}),zs.$set(sd);const ad={};j&2&&(ad.$$scope={dirty:j,ctx:s}),Ls.$set(ad);const ld={};j&2&&(ld.$$scope={dirty:j,ctx:s}),Os.$set(ld);const od={};j&2&&(od.$$scope={dirty:j,ctx:s}),Ps.$set(od);const rd={};j&2&&(rd.$$scope={dirty:j,ctx:s}),Ks.$set(rd);const id={};j&2&&(id.$$scope={dirty:j,ctx:s}),ea.$set(id);const cd={};j&2&&(cd.$$scope={dirty:j,ctx:s}),na.$set(cd)},i(s){ii||(y(o.$$.fragment,s),y(oa.$$.fragment,s),y(ra.$$.fragment,s),y(ia.$$.fragment,s),y(ct.$$.fragment,s),y(ca.$$.fragment,s),y(pt.$$.fragment,s),y(pa.$$.fragment,s),y(ut.$$.fragment,s),y(ua.$$.fragment,s),y(gt.$$.fragment,s),y(mt.$$.fragment,s),y(ht.$$.fragment,s),y(dt.$$.fragment,s),y(ft.$$.fragment,s),y(yt.$$.fragment,s),y(ga.$$.fragment,s),y(Mt.$$.fragment,s),y(bt.$$.fragment,s),y(ma.$$.fragment,s),y(jt.$$.fragment,s),y(ha.$$.fragment,s),y(_t.$$.fragment,s),y(da.$$.fragment,s),y(Tt.$$.fragment,s),y(fa.$$.fragment,s),y(It.$$.fragment,s),y(ya.$$.fragment,s),y(Jt.$$.fragment,s),y(xt.$$.fragment,s),y(Ma.$$.fragment,s),y(ba.$$.fragment,s),y(Ct.$$.fragment,s),y(ja.$$.fragment,s),y(Ut.$$.fragment,s),y(_a.$$.fragment,s),y($t.$$.fragment,s),y(vt.$$.fragment,s),y(Ta.$$.fragment,s),y(kt.$$.fragment,s),y(qt.$$.fragment,s),y(Ia.$$.fragment,s),y(At.$$.fragment,s),y(Ja.$$.fragment,s),y(Et.$$.fragment,s),y(Zt.$$.fragment,s),y(Nt.$$.fragment,s),y(xa.$$.fragment,s),y(Wt.$$.fragment,s),y(Gt.$$.fragment,s),y(wa.$$.fragment,s),y(Ca.$$.fragment,s),y(Qt.$$.fragment,s),y(Ua.$$.fragment,s),y(Vt.$$.fragment,s),y($a.$$.fragment,s),y(Yt.$$.fragment,s),y(va.$$.fragment,s),y(St.$$.fragment,s),y(ka.$$.fragment,s),y(Xt.$$.fragment,s),y(qa.$$.fragment,s),y(Rt.$$.fragment,s),y(Aa.$$.fragment,s),y(Dt.$$.fragment,s),y(Ea.$$.fragment,s),y(Ht.$$.fragment,s),y(Ft.$$.fragment,s),y(Za.$$.fragment,s),y(zt.$$.fragment,s),y(Lt.$$.fragment,s),y(Na.$$.fragment,s),y(Ot.$$.fragment,s),y(Wa.$$.fragment,s),y(Pt.$$.fragment,s),y(Ga.$$.fragment,s),y(Kt.$$.fragment,s),y(es.$$.fragment,s),y(Ba.$$.fragment,s),y(ns.$$.fragment,s),y(Qa.$$.fragment,s),y(ts.$$.fragment,s),y(ss.$$.fragment,s),y(Va.$$.fragment,s),y(as.$$.fragment,s),y(Ya.$$.fragment,s),y(Xa.$$.fragment,s),y(Ra.$$.fragment,s),y(Da.$$.fragment,s),y(ls.$$.fragment,s),y(Ha.$$.fragment,s),y(os.$$.fragment,s),y(Fa.$$.fragment,s),y(rs.$$.fragment,s),y(za.$$.fragment,s),y(is.$$.fragment,s),y(cs.$$.fragment,s),y(ps.$$.fragment,s),y(us.$$.fragment,s),y(gs.$$.fragment,s),y(ms.$$.fragment,s),y(La.$$.fragment,s),y(hs.$$.fragment,s),y(ds.$$.fragment,s),y(Oa.$$.fragment,s),y(fs.$$.fragment,s),y(Pa.$$.fragment,s),y(ys.$$.fragment,s),y(Ka.$$.fragment,s),y(Ms.$$.fragment,s),y(el.$$.fragment,s),y(bs.$$.fragment,s),y(nl.$$.fragment,s),y(js.$$.fragment,s),y(_s.$$.fragment,s),y(tl.$$.fragment,s),y(sl.$$.fragment,s),y(Is.$$.fragment,s),y(al.$$.fragment,s),y(Js.$$.fragment,s),y(ll.$$.fragment,s),y(xs.$$.fragment,s),y(ws.$$.fragment,s),y(ol.$$.fragment,s),y(Cs.$$.fragment,s),y(Us.$$.fragment,s),y(rl.$$.fragment,s),y($s.$$.fragment,s),y(il.$$.fragment,s),y(vs.$$.fragment,s),y(ks.$$.fragment,s),y(qs.$$.fragment,s),y(cl.$$.fragment,s),y(As.$$.fragment,s),y(Es.$$.fragment,s),y(pl.$$.fragment,s),y(ul.$$.fragment,s),y(Ns.$$.fragment,s),y(gl.$$.fragment,s),y(Ws.$$.fragment,s),y(ml.$$.fragment,s),y(Gs.$$.fragment,s),y(hl.$$.fragment,s),y(Bs.$$.fragment,s),y(dl.$$.fragment,s),y(Qs.$$.fragment,s),y(fl.$$.fragment,s),y(Vs.$$.fragment,s),y(yl.$$.fragment,s),y(Ys.$$.fragment,s),y(Ml.$$.fragment,s),y(Ss.$$.fragment,s),y(Xs.$$.fragment,s),y(bl.$$.fragment,s),y(Rs.$$.fragment,s),y(Ds.$$.fragment,s),y(jl.$$.fragment,s),y(Hs.$$.fragment,s),y(_l.$$.fragment,s),y(Fs.$$.fragment,s),y(Tl.$$.fragment,s),y(zs.$$.fragment,s),y(Ls.$$.fragment,s),y(Il.$$.fragment,s),y(Os.$$.fragment,s),y(Jl.$$.fragment,s),y(Ps.$$.fragment,s),y(Ks.$$.fragment,s),y(xl.$$.fragment,s),y(ea.$$.fragment,s),y(wl.$$.fragment,s),y(Cl.$$.fragment,s),y(Ul.$$.fragment,s),y(vl.$$.fragment,s),y(kl.$$.fragment,s),y(ql.$$.fragment,s),y(Al.$$.fragment,s),y(El.$$.fragment,s),y(Zl.$$.fragment,s),y(Nl.$$.fragment,s),y(Gl.$$.fragment,s),y(na.$$.fragment,s),y(Bl.$$.fragment,s),y(Ql.$$.fragment,s),y(Vl.$$.fragment,s),ii=!0)},o(s){M(o.$$.fragment,s),M(oa.$$.fragment,s),M(ra.$$.fragment,s),M(ia.$$.fragment,s),M(ct.$$.fragment,s),M(ca.$$.fragment,s),M(pt.$$.fragment,s),M(pa.$$.fragment,s),M(ut.$$.fragment,s),M(ua.$$.fragment,s),M(gt.$$.fragment,s),M(mt.$$.fragment,s),M(ht.$$.fragment,s),M(dt.$$.fragment,s),M(ft.$$.fragment,s),M(yt.$$.fragment,s),M(ga.$$.fragment,s),M(Mt.$$.fragment,s),M(bt.$$.fragment,s),M(ma.$$.fragment,s),M(jt.$$.fragment,s),M(ha.$$.fragment,s),M(_t.$$.fragment,s),M(da.$$.fragment,s),M(Tt.$$.fragment,s),M(fa.$$.fragment,s),M(It.$$.fragment,s),M(ya.$$.fragment,s),M(Jt.$$.fragment,s),M(xt.$$.fragment,s),M(Ma.$$.fragment,s),M(ba.$$.fragment,s),M(Ct.$$.fragment,s),M(ja.$$.fragment,s),M(Ut.$$.fragment,s),M(_a.$$.fragment,s),M($t.$$.fragment,s),M(vt.$$.fragment,s),M(Ta.$$.fragment,s),M(kt.$$.fragment,s),M(qt.$$.fragment,s),M(Ia.$$.fragment,s),M(At.$$.fragment,s),M(Ja.$$.fragment,s),M(Et.$$.fragment,s),M(Zt.$$.fragment,s),M(Nt.$$.fragment,s),M(xa.$$.fragment,s),M(Wt.$$.fragment,s),M(Gt.$$.fragment,s),M(wa.$$.fragment,s),M(Ca.$$.fragment,s),M(Qt.$$.fragment,s),M(Ua.$$.fragment,s),M(Vt.$$.fragment,s),M($a.$$.fragment,s),M(Yt.$$.fragment,s),M(va.$$.fragment,s),M(St.$$.fragment,s),M(ka.$$.fragment,s),M(Xt.$$.fragment,s),M(qa.$$.fragment,s),M(Rt.$$.fragment,s),M(Aa.$$.fragment,s),M(Dt.$$.fragment,s),M(Ea.$$.fragment,s),M(Ht.$$.fragment,s),M(Ft.$$.fragment,s),M(Za.$$.fragment,s),M(zt.$$.fragment,s),M(Lt.$$.fragment,s),M(Na.$$.fragment,s),M(Ot.$$.fragment,s),M(Wa.$$.fragment,s),M(Pt.$$.fragment,s),M(Ga.$$.fragment,s),M(Kt.$$.fragment,s),M(es.$$.fragment,s),M(Ba.$$.fragment,s),M(ns.$$.fragment,s),M(Qa.$$.fragment,s),M(ts.$$.fragment,s),M(ss.$$.fragment,s),M(Va.$$.fragment,s),M(as.$$.fragment,s),M(Ya.$$.fragment,s),M(Xa.$$.fragment,s),M(Ra.$$.fragment,s),M(Da.$$.fragment,s),M(ls.$$.fragment,s),M(Ha.$$.fragment,s),M(os.$$.fragment,s),M(Fa.$$.fragment,s),M(rs.$$.fragment,s),M(za.$$.fragment,s),M(is.$$.fragment,s),M(cs.$$.fragment,s),M(ps.$$.fragment,s),M(us.$$.fragment,s),M(gs.$$.fragment,s),M(ms.$$.fragment,s),M(La.$$.fragment,s),M(hs.$$.fragment,s),M(ds.$$.fragment,s),M(Oa.$$.fragment,s),M(fs.$$.fragment,s),M(Pa.$$.fragment,s),M(ys.$$.fragment,s),M(Ka.$$.fragment,s),M(Ms.$$.fragment,s),M(el.$$.fragment,s),M(bs.$$.fragment,s),M(nl.$$.fragment,s),M(js.$$.fragment,s),M(_s.$$.fragment,s),M(tl.$$.fragment,s),M(sl.$$.fragment,s),M(Is.$$.fragment,s),M(al.$$.fragment,s),M(Js.$$.fragment,s),M(ll.$$.fragment,s),M(xs.$$.fragment,s),M(ws.$$.fragment,s),M(ol.$$.fragment,s),M(Cs.$$.fragment,s),M(Us.$$.fragment,s),M(rl.$$.fragment,s),M($s.$$.fragment,s),M(il.$$.fragment,s),M(vs.$$.fragment,s),M(ks.$$.fragment,s),M(qs.$$.fragment,s),M(cl.$$.fragment,s),M(As.$$.fragment,s),M(Es.$$.fragment,s),M(pl.$$.fragment,s),M(ul.$$.fragment,s),M(Ns.$$.fragment,s),M(gl.$$.fragment,s),M(Ws.$$.fragment,s),M(ml.$$.fragment,s),M(Gs.$$.fragment,s),M(hl.$$.fragment,s),M(Bs.$$.fragment,s),M(dl.$$.fragment,s),M(Qs.$$.fragment,s),M(fl.$$.fragment,s),M(Vs.$$.fragment,s),M(yl.$$.fragment,s),M(Ys.$$.fragment,s),M(Ml.$$.fragment,s),M(Ss.$$.fragment,s),M(Xs.$$.fragment,s),M(bl.$$.fragment,s),M(Rs.$$.fragment,s),M(Ds.$$.fragment,s),M(jl.$$.fragment,s),M(Hs.$$.fragment,s),M(_l.$$.fragment,s),M(Fs.$$.fragment,s),M(Tl.$$.fragment,s),M(zs.$$.fragment,s),M(Ls.$$.fragment,s),M(Il.$$.fragment,s),M(Os.$$.fragment,s),M(Jl.$$.fragment,s),M(Ps.$$.fragment,s),M(Ks.$$.fragment,s),M(xl.$$.fragment,s),M(ea.$$.fragment,s),M(wl.$$.fragment,s),M(Cl.$$.fragment,s),M(Ul.$$.fragment,s),M(vl.$$.fragment,s),M(kl.$$.fragment,s),M(ql.$$.fragment,s),M(Al.$$.fragment,s),M(El.$$.fragment,s),M(Zl.$$.fragment,s),M(Nl.$$.fragment,s),M(Gl.$$.fragment,s),M(na.$$.fragment,s),M(Bl.$$.fragment,s),M(Ql.$$.fragment,s),M(Vl.$$.fragment,s),ii=!1},d(s){s&&(p(u),p(a),p(t),p(e),p(c),p(Br),p(aa),p(Qr),p(la),p(Vr),p(Yr),p(x),p(Sr),p(Xr),p(Sa),p(Rr),p(Dr),p(w),p(Hr),p(Fr),p(Tn),p(zr),p(Lr),p($l),p(Or),p(Pr),p(In),p(Kr),p(ei),p(Jn),p(ni),p(ti),p(xn),p(si),p(ai),p(Wl),p(li),p(S),p(oi),p(ri),p(Gr)),p(n),b(o,s),b(oa,s),b(ra),b(ia),b(ct),b(ca),b(pt),b(pa),b(ut),b(ua),b(gt),b(mt),b(ht),b(dt),b(ft),b(yt),b(ga),b(Mt),b(bt),b(ma),b(jt),b(ha),b(_t),b(da),b(Tt),b(fa),b(It),b(ya),b(Jt),b(xt),b(Ma),b(ba),b(Ct),b(ja),b(Ut),b(_a),b($t),b(vt),b(Ta),b(kt),b(qt),b(Ia),b(At),b(Ja),b(Et),b(Zt),b(Nt),b(xa),b(Wt),b(Gt),b(wa),b(Ca),b(Qt),b(Ua),b(Vt),b($a),b(Yt),b(va),b(St),b(ka),b(Xt),b(qa),b(Rt),b(Aa),b(Dt),b(Ea),b(Ht),b(Ft),b(Za),b(zt),b(Lt),b(Na),b(Ot),b(Wa),b(Pt),b(Ga),b(Kt),b(es),b(Ba),b(ns),b(Qa),b(ts),b(ss),b(Va),b(as),b(Ya,s),b(Xa,s),b(Ra),b(Da),b(ls),b(Ha),b(os),b(Fa),b(rs),b(za),b(is),b(cs),b(ps),b(us),b(gs),b(ms),b(La),b(hs),b(ds),b(Oa),b(fs),b(Pa),b(ys),b(Ka),b(Ms),b(el),b(bs),b(nl),b(js),b(_s),b(tl),b(sl),b(Is),b(al),b(Js),b(ll),b(xs),b(ws),b(ol),b(Cs),b(Us),b(rl),b($s),b(il),b(vs),b(ks),b(qs),b(cl),b(As),b(Es),b(pl),b(ul),b(Ns),b(gl),b(Ws),b(ml),b(Gs),b(hl),b(Bs),b(dl),b(Qs),b(fl),b(Vs),b(yl),b(Ys),b(Ml),b(Ss),b(Xs),b(bl),b(Rs),b(Ds),b(jl),b(Hs),b(_l),b(Fs),b(Tl),b(zs),b(Ls),b(Il),b(Os),b(Jl),b(Ps),b(Ks),b(xl),b(ea),b(wl,s),b(Cl),b(Ul,s),b(vl,s),b(kl),b(ql,s),b(Al),b(El,s),b(Zl),b(Nl,s),b(Gl),b(na),b(Bl),b(Ql),b(Vl,s)}}}const ry='{"title":"추론","local":"inference","sections":[{"title":"추론 클라이언트","local":"huggingface_hub.InferenceClient ][ huggingface_hub.InferenceClient","sections":[],"depth":2},{"title":"비동기 추론 클라이언트","local":"huggingface_hub.AsyncInferenceClient ][ huggingface_hub.AsyncInferenceClient","sections":[],"depth":2},{"title":"추론 시간 초과 오류","local":"huggingface_hub.InferenceTimeoutError ][ huggingface_hub.InferenceTimeoutError","sections":[],"depth":2},{"title":"반환 유형","local":"return-types","sections":[{"title":"대화형 출력 대화","local":"huggingface_hub.inference._types.ConversationalOutputConversation ][ huggingface_hub.inference._types.ConversationalOutputConversation","sections":[],"depth":3},{"title":"대화형 출력","local":"huggingface_hub.inference._types.ConversationalOutput ][ huggingface_hub.inference._types.ConversationalOutput","sections":[],"depth":3},{"title":"모델 상태","local":"huggingface_hub.inference._common.ModelStatus ][ huggingface_hub.inference._common.ModelStatus","sections":[],"depth":3}],"depth":2},{"title":"추론 API","local":"huggingface_hub.InferenceApi ][ huggingface_hub.InferenceApi","sections":[],"depth":2}],"depth":1}';function iy(T){return ud(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fy extends gd{constructor(n){super(),md(this,n,iy,oy,pd,{})}}export{fy as component};
