import{s as hl,n as dl,o as ul}from"../chunks/scheduler.f3b1e791.js";import{S as fl,i as Tl,e as s,s as i,c as m,h as wl,a as o,d as l,b as a,f as gt,g as p,j as r,k as cl,l as w,m as n,n as c,t as h,o as d,p as u}from"../chunks/index.023a9934.js";import{C as yl,H as f,E as Ml}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.99db8c42.js";import{C as ve}from"../chunks/CodeBlock.3f4fc5e4.js";function bl(jt){let b,Ue,ge,Ie,J,xe,$,ke,v,Ht=`Kernels on the Hub must fulfill the requirements outlined on this page. By
ensuring kernels are compliant, they can be used on a wide range of Linux
systems and Torch builds.`,_e,g,Lt=`You can use <a href="https://github.com/huggingface/kernel-builder/" rel="nofollow">kernel-builder</a>
to build compliant kernels.`,je,C,He,U,Bt=`A kernel repository on the Hub must contain a <code>build</code> directory. This
directory contains build variants of a kernel in the form of directories
following the template
<code>&lt;framework&gt;&lt;version&gt;-cxx&lt;abiver&gt;-&lt;cu&gt;&lt;cudaver&gt;-&lt;arch&gt;-&lt;os&gt;</code>.
For example <code>build/torch26-cxx98-cu118-x86_64-linux</code>.`,Le,I,Gt=`Each variant directory must contain a single directory with the same name
as the repository (replacing <code>-</code> by <code>_</code>). For instance, kernels in the
<code>kernels-community/activation</code> repository have a directories like
<code>build/&lt;variant&gt;/activation</code>. This directory
must be a Python package with an <code>__init__.py</code> file.`,Be,x,Ge,k,At=`A kernel can be compliant for a specific compute framework (e.g. CUDA) or
architecture (e.g. x86_64). For compliance with a compute framework and
architecture combination, all the variants from the <a href="https://github.com/huggingface/kernel-builder/blob/main/docs/build-variants.md" rel="nofollow">build variant list</a>
must be available for that combination.`,Ae,_,Se,j,St=`Kernels are versioned on the Hub using Git tags. Version tags must be of
the form <code>v&lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;</code>. Versions are used by <a href="./locking.md">locking</a>
to resolve the version constraints.`,Pe,H,Pt='We recommend using <a href="https://semver.org/" rel="nofollow">semver</a> to version kernels.',Ze,L,Ee,B,Zt=`Kernels will typically contain a native Python module with precompiled
compute kernels and bindings. This module must fulfill the requirements
outlined in this section. For all operating systems, a kernel must not
have dynamic library dependencies outside:`,ze,G,Et="<li>Torch;</li> <li>CUDA/ROCm libraries installed as dependencies of Torch.</li>",Fe,A,Ne,S,zt=`The Kernel Hub also encourages to write the kernels in a <code>torch.compile</code>
compliant way. This helps to ensure that the kernels are compatible with
<code>torch.compile</code> without introducing any graph breaks and triggering
recompilation which can limit the benefits of compilation.`,Ve,P,Ft=`<a href="https://github.com/huggingface/kernel-builder/blob/d1ee9bf9301ac8c5199099d90ee1c9d5c789d5ba/examples/relu-backprop-compile/tests/test_relu.py#L162" rel="nofollow">Here</a> is a simple test example which checks for graph breaks and
recompilation triggers during <code>torch.compile</code>.`,Qe,Z,Re,E,Nt=`<li>Use <a href="https://docs.python.org/3/c-api/stable.html#stable-application-binary-interface" rel="nofollow">ABI3/Limited API</a>
for compatibility with Python 3.9 and later.</li> <li>Compatible with <a href="https://github.com/pypa/manylinux?tab=readme-ov-file#manylinux_2_28-almalinux-8-based" rel="nofollow"><code>manylinux_2_28</code></a>.
This means that the extension <strong>must not</strong> use symbols versions higher than:
<ul><li>GLIBC 2.28</li> <li>GLIBCXX 3.4.24</li> <li>CXXABI 1.3.11</li> <li>GCC 7.0.0</li></ul></li>`,We,z,Vt="These requirements can be checked with the ABI checker (see below).",Xe,F,Ye,N,Qt=`<li>Use <a href="https://docs.python.org/3/c-api/stable.html#stable-application-binary-interface" rel="nofollow">ABI3/Limited API</a>
for compatibility with Python 3.9 and later.</li> <li>macOS deployment target 15.0.</li> <li>Metal 3.0 (<code>-std=metal3.0</code>).</li>`,qe,V,Rt="The ABI3 requirement can be checked with the ABI checker (see below).",De,Q,Oe,R,Wt=`The manylinux_2_28 and Python ABI 3.9 version requirements can be checked with
<a href="https://crates.io/crates/kernel-abi-check" rel="nofollow"><code>kernel-abi-check</code></a>:`,Ke,W,et,X,tt,Y,Xt=`Torch native extension functions must be <a href="https://pytorch.org/tutorials/advanced/cpp_custom_ops.html#cpp-custom-ops-tutorial" rel="nofollow">registered</a>
in <code>torch.ops.&lt;namespace&gt;</code>. Since we allow loading of multiple versions of
a module in the same Python process, <code>namespace</code> must be unique for each
version of a kernel. Failing to do so will create clashes when different
versions of the same kernel are loaded. Two suggested ways of doing this
are:`,lt,q,Yt=`<li>Appending a truncated SHA-1 hash of the git commit that the kernel was
built from to the name of the extension.</li> <li>Appending random material to the name of the extension.</li>`,nt,D,qt=`<strong>Note:</strong> we recommend against appending a version number or git tag.
Version numbers are typically not bumped on each commit, so users
might use two different commits that happen to have the same version
number. Git tags are not stable, so they do not provide a good way
of guaranteeing uniqueness of the namespace.`,it,O,at,K,Dt=`A kernel can provide layers in addition to kernel functions. A layer from
the Hub can replace the <code>forward</code> method of an existing layer for a certain
device type. This makes it possible to provide more performant kernels for
existing layers. See the <a href="layers.md">layers documentation</a> for more information
on how to use layers.`,st,ee,ot,te,Ot=`To make the extension of layers safe, the layers must fulfill the following
requirements:`,rt,le,Kt=`<li>The layers are subclasses of <code>torch.nn.Module</code>.</li> <li>The layers are pure, meaning that they do not have their own state. This
means that:
<ul><li>The layer must not define its own constructor.</li> <li>The layer must not use class variables.</li></ul></li> <li>No other methods must be defined than <code>forward</code>.</li> <li>The <code>forward</code> method has a signature that is compatible with the
<code>forward</code> method that it is extending.</li>`,mt,ne,el="There are two exceptions to the <em>no class variables rule</em>:",pt,ie,tl=`<li>The <code>has_backward</code> variable can be used to indicate whether the layer has
a backward pass implemented (<code>True</code> when absent).</li> <li>The <code>can_torch_compile</code> variable can be used to indicate whether the layer
supports <code>torch.compile</code> (<code>False</code> when absent).</li>`,ct,ae,ll="This is an example of a pure layer:",ht,se,dt,oe,nl=`For some layers, the <code>forward</code> method has to use state from the adopting class.
In these cases, we recommend to use type annotations to indicate what member
variables are expected. For instance:`,ut,re,ft,me,il=`This layer expects the adopting layer to have <code>weight</code> and <code>variance_epsilon</code>
member variables and uses them in the <code>forward</code> method.`,Tt,pe,wt,ce,al=`To accommodate portable loading, <code>layers</code> must be defined in the main
<code>__init__.py</code> file. For example:`,yt,he,Mt,de,bt,y,we,sl="<p>Python code must be compatible with Python 3.9 and later.</p>",Ct,T,ye,ol=`All Python code imports from the kernel itself must be relative. So,
for instance if in the example kernel <code>example</code>,
<code>module_b</code> needs a function from <code>module_a</code>, import as:`,Ut,ue,It,Me,rl="<strong>Never use:</strong>",xt,fe,kt,be,ml=`The latter would import from the module <code>example</code> that is in Python’s
global module dict. However, since we allow loading multiple versions
of a module, we uniquely name the module.`,_t,Je,pl=`<p>Only modules from the Python standard library, Torch, or the kernel itself
can be imported.</p>`,Jt,Te,$t,Ce,vt;return J=new yl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),$=new f({props:{title:"Kernel requirements",local:"kernel-requirements",headingTag:"h1"}}),C=new f({props:{title:"Directory layout",local:"directory-layout",headingTag:"h2"}}),x=new f({props:{title:"Build variants",local:"build-variants",headingTag:"h2"}}),_=new f({props:{title:"Versioning",local:"versioning",headingTag:"h2"}}),L=new f({props:{title:"Native Python module",local:"native-python-module",headingTag:"h2"}}),A=new f({props:{title:"Compatibility with torch.compile",local:"compatibility-with-torchcompile",headingTag:"h2"}}),Z=new f({props:{title:"Linux",local:"linux",headingTag:"h3"}}),F=new f({props:{title:"macOS",local:"macos",headingTag:"h3"}}),Q=new f({props:{title:"ABI checker",local:"abi-checker",headingTag:"h3"}}),W=new ve({props:{code:"JTBBJTI0JTIwY2FyZ28lMjBpbnN0YWxsJTIwa2VybmVsLWFiaS1jaGVjayUwQSUyNCUyMGtlcm5lbC1hYmktY2hlY2slMjByZXN1bHQlMkZyZWx1JTJGX3JlbHVfZTg3ZTBjYV9kaXJ0eS5hYmkzLnNvJTBBJUYwJTlGJTkwJThEJTIwQ2hlY2tpbmclMjBmb3IlMjBjb21wYXRpYmlsaXR5JTIwd2l0aCUyMG1hbnlsaW51eF8yXzI4JTIwYW5kJTIwUHl0aG9uJTIwQUJJJTIwdmVyc2lvbiUyMDMuOSUwQSVFMiU5QyU4NSUyME5vJTIwY29tcGF0aWJpbGl0eSUyMGlzc3VlcyUyMGZvdW5k",highlighted:`
$ cargo install kernel-abi-check
$ kernel-abi-check result/relu/_relu_e87e0ca_dirty.abi3.so
🐍 Checking <span class="hljs-keyword">for</span> compatibility with manylinux_2_28 and Python ABI version 3.9
✅ No compatibility issues found`,wrap:!1}}),X=new f({props:{title:"Torch extension",local:"torch-extension",headingTag:"h2"}}),O=new f({props:{title:"Layers",local:"layers",headingTag:"h2"}}),ee=new f({props:{title:"Writing layers",local:"writing-layers",headingTag:"h3"}}),se=new ve({props:{code:"Y2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGlzJTIwbGF5ZXIlMjBkb2VzJTIwbm90JTIwaW1wbGVtZW50JTIwYmFja3dhcmQuJTBBJTIwJTIwJTIwJTIwaGFzX2JhY2t3YXJkJTNBJTIwYm9vbCUyMCUzRCUyMEZhbHNlJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCUzQSUyMHRvcmNoLlRlbnNvciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkJTIwJTNEJTIweC5zaGFwZSU1Qi0xJTVEJTIwJTJGJTJGJTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF9zaGFwZSUyMCUzRCUyMHguc2hhcGUlNUIlM0EtMSU1RCUyMCUyQiUyMChkJTJDKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMHRvcmNoLmVtcHR5KG91dHB1dF9zaGFwZSUyQyUyMGR0eXBlJTNEeC5kdHlwZSUyQyUyMGRldmljZSUzRHguZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wcy5zaWx1X2FuZF9tdWwob3V0JTJDJTIweCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXQ=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-comment"># This layer does not implement backward.</span>
    has_backward: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>):
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        output_shape = x.shape[:-<span class="hljs-number">1</span>] + (d,)
        out = torch.empty(output_shape, dtype=x.dtype, device=x.device)
        ops.silu_and_mul(out, x)
        <span class="hljs-keyword">return</span> out`,wrap:!1}}),re=new ve({props:{code:"Y2xhc3MlMjBMbGFtYVJNU05vcm0obm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMHdlaWdodCUzQSUyMHRvcmNoLlRlbnNvciUwQSUyMCUyMCUyMCUyMHZhcmlhbmNlX2Vwc2lsb24lM0ElMjBmbG9hdCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMGhpZGRlbl9zdGF0ZXMlM0ElMjB0b3JjaC5UZW5zb3IpJTIwLSUzRSUyMHRvcmNoLlRlbnNvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHJtc19ub3JtX2ZuKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGhpZGRlbl9zdGF0ZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLndlaWdodCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJpYXMlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWwlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXBzJTNEc2VsZi52YXJpYW5jZV9lcHNpbG9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHJvcG91dF9wJTNEMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlbm9ybSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWxfaW5fZnAzMiUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LlamaRMSNorm</span>(nn.Module):
    weight: torch.Tensor
    variance_epsilon: <span class="hljs-built_in">float</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states: torch.Tensor</span>) -&gt; torch.Tensor:
        <span class="hljs-keyword">return</span> rms_norm_fn(
            hidden_states,
            self.weight,
            bias=<span class="hljs-literal">None</span>,
            residual=<span class="hljs-literal">None</span>,
            eps=self.variance_epsilon,
            dropout_p=<span class="hljs-number">0.0</span>,
            prenorm=<span class="hljs-literal">False</span>,
            residual_in_fp32=<span class="hljs-literal">False</span>,
        )`,wrap:!1}}),pe=new f({props:{title:"Exporting layers",local:"exporting-layers",headingTag:"h3"}}),he=new ve({props:{code:"ZnJvbSUyMC4lMjBpbXBvcnQlMjBsYXllcnMlMEElMEFfX2FsbF9fJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIzJTIwLi4uJTBBJTIwJTIwJTIybGF5ZXJzJTIyJTBBJTIwJTIwJTIzJTIwLi4uJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> . <span class="hljs-keyword">import</span> layers

__all__ = [
  <span class="hljs-comment"># ...</span>
  <span class="hljs-string">&quot;layers&quot;</span>
  <span class="hljs-comment"># ...</span>
]`,wrap:!1}}),de=new f({props:{title:"Python requirements",local:"python-requirements",headingTag:"h2"}}),ue=new ve({props:{code:"ZnJvbSUyMC5tb2R1bGVfYSUyMGltcG9ydCUyMGZvbw==",highlighted:'<span class="hljs-keyword">from</span> .module_a <span class="hljs-keyword">import</span> foo',wrap:!1}}),fe=new ve({props:{code:"JTIzJTIwRE8lMjBOT1QlMjBETyUyMFRISVMhJTBBJTBBZnJvbSUyMGV4YW1wbGUubW9kdWxlX2ElMjBpbXBvcnQlMjBmb28=",highlighted:`<span class="hljs-comment"># DO NOT DO THIS!</span>

<span class="hljs-keyword">from</span> example.module_a <span class="hljs-keyword">import</span> foo`,wrap:!1}}),Te=new Ml({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/kernel-requirements.md"}}),{c(){b=s("meta"),Ue=i(),ge=s("p"),Ie=i(),m(J.$$.fragment),xe=i(),m($.$$.fragment),ke=i(),v=s("p"),v.textContent=Ht,_e=i(),g=s("p"),g.innerHTML=Lt,je=i(),m(C.$$.fragment),He=i(),U=s("p"),U.innerHTML=Bt,Le=i(),I=s("p"),I.innerHTML=Gt,Be=i(),m(x.$$.fragment),Ge=i(),k=s("p"),k.innerHTML=At,Ae=i(),m(_.$$.fragment),Se=i(),j=s("p"),j.innerHTML=St,Pe=i(),H=s("p"),H.innerHTML=Pt,Ze=i(),m(L.$$.fragment),Ee=i(),B=s("p"),B.textContent=Zt,ze=i(),G=s("ul"),G.innerHTML=Et,Fe=i(),m(A.$$.fragment),Ne=i(),S=s("p"),S.innerHTML=zt,Ve=i(),P=s("p"),P.innerHTML=Ft,Qe=i(),m(Z.$$.fragment),Re=i(),E=s("ul"),E.innerHTML=Nt,We=i(),z=s("p"),z.textContent=Vt,Xe=i(),m(F.$$.fragment),Ye=i(),N=s("ul"),N.innerHTML=Qt,qe=i(),V=s("p"),V.textContent=Rt,De=i(),m(Q.$$.fragment),Oe=i(),R=s("p"),R.innerHTML=Wt,Ke=i(),m(W.$$.fragment),et=i(),m(X.$$.fragment),tt=i(),Y=s("p"),Y.innerHTML=Xt,lt=i(),q=s("ul"),q.innerHTML=Yt,nt=i(),D=s("p"),D.innerHTML=qt,it=i(),m(O.$$.fragment),at=i(),K=s("p"),K.innerHTML=Dt,st=i(),m(ee.$$.fragment),ot=i(),te=s("p"),te.textContent=Ot,rt=i(),le=s("ul"),le.innerHTML=Kt,mt=i(),ne=s("p"),ne.innerHTML=el,pt=i(),ie=s("ol"),ie.innerHTML=tl,ct=i(),ae=s("p"),ae.textContent=ll,ht=i(),m(se.$$.fragment),dt=i(),oe=s("p"),oe.innerHTML=nl,ut=i(),m(re.$$.fragment),ft=i(),me=s("p"),me.innerHTML=il,Tt=i(),m(pe.$$.fragment),wt=i(),ce=s("p"),ce.innerHTML=al,yt=i(),m(he.$$.fragment),Mt=i(),m(de.$$.fragment),bt=i(),y=s("ul"),we=s("li"),we.innerHTML=sl,Ct=i(),T=s("li"),ye=s("p"),ye.innerHTML=ol,Ut=i(),m(ue.$$.fragment),It=i(),Me=s("p"),Me.innerHTML=rl,xt=i(),m(fe.$$.fragment),kt=i(),be=s("p"),be.innerHTML=ml,_t=i(),Je=s("li"),Je.innerHTML=pl,Jt=i(),m(Te.$$.fragment),$t=i(),Ce=s("p"),this.h()},l(e){const t=wl("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ue=a(e),ge=o(e,"P",{}),gt(ge).forEach(l),Ie=a(e),p(J.$$.fragment,e),xe=a(e),p($.$$.fragment,e),ke=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-omjx4j"&&(v.textContent=Ht),_e=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-mwob7l"&&(g.innerHTML=Lt),je=a(e),p(C.$$.fragment,e),He=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1j93b1m"&&(U.innerHTML=Bt),Le=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1cuxqpl"&&(I.innerHTML=Gt),Be=a(e),p(x.$$.fragment,e),Ge=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-11ghnwy"&&(k.innerHTML=At),Ae=a(e),p(_.$$.fragment,e),Se=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1869t00"&&(j.innerHTML=St),Pe=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1lhbdsc"&&(H.innerHTML=Pt),Ze=a(e),p(L.$$.fragment,e),Ee=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-17te4hc"&&(B.textContent=Zt),ze=a(e),G=o(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-17x1sgf"&&(G.innerHTML=Et),Fe=a(e),p(A.$$.fragment,e),Ne=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-f057os"&&(S.innerHTML=zt),Ve=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-nz528e"&&(P.innerHTML=Ft),Qe=a(e),p(Z.$$.fragment,e),Re=a(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-1z0ex63"&&(E.innerHTML=Nt),We=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-vq3k4i"&&(z.textContent=Vt),Xe=a(e),p(F.$$.fragment,e),Ye=a(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-nrm36c"&&(N.innerHTML=Qt),qe=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1xbbttu"&&(V.textContent=Rt),De=a(e),p(Q.$$.fragment,e),Oe=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-16l01xm"&&(R.innerHTML=Wt),Ke=a(e),p(W.$$.fragment,e),et=a(e),p(X.$$.fragment,e),tt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1z00i8l"&&(Y.innerHTML=Xt),lt=a(e),q=o(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-1n44n6m"&&(q.innerHTML=Yt),nt=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-vo8uhp"&&(D.innerHTML=qt),it=a(e),p(O.$$.fragment,e),at=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-17jmyq"&&(K.innerHTML=Dt),st=a(e),p(ee.$$.fragment,e),ot=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-ew142v"&&(te.textContent=Ot),rt=a(e),le=o(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-d986sl"&&(le.innerHTML=Kt),mt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-17brked"&&(ne.innerHTML=el),pt=a(e),ie=o(e,"OL",{"data-svelte-h":!0}),r(ie)!=="svelte-1a9mvrx"&&(ie.innerHTML=tl),ct=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-mthj86"&&(ae.textContent=ll),ht=a(e),p(se.$$.fragment,e),dt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1xsl1kb"&&(oe.innerHTML=nl),ut=a(e),p(re.$$.fragment,e),ft=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-9hcs08"&&(me.innerHTML=il),Tt=a(e),p(pe.$$.fragment,e),wt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1jwjnkj"&&(ce.innerHTML=al),yt=a(e),p(he.$$.fragment,e),Mt=a(e),p(de.$$.fragment,e),bt=a(e),y=o(e,"UL",{});var $e=gt(y);we=o($e,"LI",{"data-svelte-h":!0}),r(we)!=="svelte-1yjmw8t"&&(we.innerHTML=sl),Ct=a($e),T=o($e,"LI",{});var M=gt(T);ye=o(M,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1xx048c"&&(ye.innerHTML=ol),Ut=a(M),p(ue.$$.fragment,M),It=a(M),Me=o(M,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-ca1g42"&&(Me.innerHTML=rl),xt=a(M),p(fe.$$.fragment,M),kt=a(M),be=o(M,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1v83762"&&(be.innerHTML=ml),M.forEach(l),_t=a($e),Je=o($e,"LI",{"data-svelte-h":!0}),r(Je)!=="svelte-wkdo8"&&(Je.innerHTML=pl),$e.forEach(l),Jt=a(e),p(Te.$$.fragment,e),$t=a(e),Ce=o(e,"P",{}),gt(Ce).forEach(l),this.h()},h(){cl(b,"name","hf:doc:metadata"),cl(b,"content",Jl)},m(e,t){w(document.head,b),n(e,Ue,t),n(e,ge,t),n(e,Ie,t),c(J,e,t),n(e,xe,t),c($,e,t),n(e,ke,t),n(e,v,t),n(e,_e,t),n(e,g,t),n(e,je,t),c(C,e,t),n(e,He,t),n(e,U,t),n(e,Le,t),n(e,I,t),n(e,Be,t),c(x,e,t),n(e,Ge,t),n(e,k,t),n(e,Ae,t),c(_,e,t),n(e,Se,t),n(e,j,t),n(e,Pe,t),n(e,H,t),n(e,Ze,t),c(L,e,t),n(e,Ee,t),n(e,B,t),n(e,ze,t),n(e,G,t),n(e,Fe,t),c(A,e,t),n(e,Ne,t),n(e,S,t),n(e,Ve,t),n(e,P,t),n(e,Qe,t),c(Z,e,t),n(e,Re,t),n(e,E,t),n(e,We,t),n(e,z,t),n(e,Xe,t),c(F,e,t),n(e,Ye,t),n(e,N,t),n(e,qe,t),n(e,V,t),n(e,De,t),c(Q,e,t),n(e,Oe,t),n(e,R,t),n(e,Ke,t),c(W,e,t),n(e,et,t),c(X,e,t),n(e,tt,t),n(e,Y,t),n(e,lt,t),n(e,q,t),n(e,nt,t),n(e,D,t),n(e,it,t),c(O,e,t),n(e,at,t),n(e,K,t),n(e,st,t),c(ee,e,t),n(e,ot,t),n(e,te,t),n(e,rt,t),n(e,le,t),n(e,mt,t),n(e,ne,t),n(e,pt,t),n(e,ie,t),n(e,ct,t),n(e,ae,t),n(e,ht,t),c(se,e,t),n(e,dt,t),n(e,oe,t),n(e,ut,t),c(re,e,t),n(e,ft,t),n(e,me,t),n(e,Tt,t),c(pe,e,t),n(e,wt,t),n(e,ce,t),n(e,yt,t),c(he,e,t),n(e,Mt,t),c(de,e,t),n(e,bt,t),n(e,y,t),w(y,we),w(y,Ct),w(y,T),w(T,ye),w(T,Ut),c(ue,T,null),w(T,It),w(T,Me),w(T,xt),c(fe,T,null),w(T,kt),w(T,be),w(y,_t),w(y,Je),n(e,Jt,t),c(Te,e,t),n(e,$t,t),n(e,Ce,t),vt=!0},p:dl,i(e){vt||(h(J.$$.fragment,e),h($.$$.fragment,e),h(C.$$.fragment,e),h(x.$$.fragment,e),h(_.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(Z.$$.fragment,e),h(F.$$.fragment,e),h(Q.$$.fragment,e),h(W.$$.fragment,e),h(X.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(Te.$$.fragment,e),vt=!0)},o(e){d(J.$$.fragment,e),d($.$$.fragment,e),d(C.$$.fragment,e),d(x.$$.fragment,e),d(_.$$.fragment,e),d(L.$$.fragment,e),d(A.$$.fragment,e),d(Z.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(W.$$.fragment,e),d(X.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(he.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(fe.$$.fragment,e),d(Te.$$.fragment,e),vt=!1},d(e){e&&(l(Ue),l(ge),l(Ie),l(xe),l(ke),l(v),l(_e),l(g),l(je),l(He),l(U),l(Le),l(I),l(Be),l(Ge),l(k),l(Ae),l(Se),l(j),l(Pe),l(H),l(Ze),l(Ee),l(B),l(ze),l(G),l(Fe),l(Ne),l(S),l(Ve),l(P),l(Qe),l(Re),l(E),l(We),l(z),l(Xe),l(Ye),l(N),l(qe),l(V),l(De),l(Oe),l(R),l(Ke),l(et),l(tt),l(Y),l(lt),l(q),l(nt),l(D),l(it),l(at),l(K),l(st),l(ot),l(te),l(rt),l(le),l(mt),l(ne),l(pt),l(ie),l(ct),l(ae),l(ht),l(dt),l(oe),l(ut),l(ft),l(me),l(Tt),l(wt),l(ce),l(yt),l(Mt),l(bt),l(y),l(Jt),l($t),l(Ce)),l(b),u(J,e),u($,e),u(C,e),u(x,e),u(_,e),u(L,e),u(A,e),u(Z,e),u(F,e),u(Q,e),u(W,e),u(X,e),u(O,e),u(ee,e),u(se,e),u(re,e),u(pe,e),u(he,e),u(de,e),u(ue),u(fe),u(Te,e)}}}const Jl='{"title":"Kernel requirements","local":"kernel-requirements","sections":[{"title":"Directory layout","local":"directory-layout","sections":[],"depth":2},{"title":"Build variants","local":"build-variants","sections":[],"depth":2},{"title":"Versioning","local":"versioning","sections":[],"depth":2},{"title":"Native Python module","local":"native-python-module","sections":[],"depth":2},{"title":"Compatibility with torch.compile","local":"compatibility-with-torchcompile","sections":[{"title":"Linux","local":"linux","sections":[],"depth":3},{"title":"macOS","local":"macos","sections":[],"depth":3},{"title":"ABI checker","local":"abi-checker","sections":[],"depth":3}],"depth":2},{"title":"Torch extension","local":"torch-extension","sections":[],"depth":2},{"title":"Layers","local":"layers","sections":[{"title":"Writing layers","local":"writing-layers","sections":[],"depth":3},{"title":"Exporting layers","local":"exporting-layers","sections":[],"depth":3}],"depth":2},{"title":"Python requirements","local":"python-requirements","sections":[],"depth":2}],"depth":1}';function $l(jt){return ul(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends fl{constructor(b){super(),Tl(this,b,$l,bl,hl,{})}}export{Il as component};
