import{s as Wt,f as at,n as Rt,o as Qt}from"../chunks/scheduler.37c15a92.js";import{S as St,i as Vt,g as i,s as a,r as y,A as Xt,h as p,f as l,c as n,j as ue,u as m,x as o,k as r,y as Nt,a as s,v as d,d as w,t as T,w as j}from"../chunks/index.2bf4358c.js";import{C as nt}from"../chunks/CodeBlock.4e987730.js";import{C as Yt}from"../chunks/CourseFloatingBanner.9ff4c771.js";import{H as pe,E as Pt}from"../chunks/getInferenceSnippets.39afd8fb.js";function zt(it){let J,Me,oe,ce,h,ye,f,me,U,pt=`В этом разделе мы подробно рассмотрим класс <code>Interface</code> и разберем
основные параметры, используемые для его создания.`,de,b,we,I,ot="Вы заметите, что класс <code>Interface</code> имеет 3 обязательных параметра:",Te,C,rt="<code>Interface(fn, inputs, outputs, ...)</code>",je,v,ut="Это параметры:",Je,g,Mt="<li><code>fn</code>: функция прогнозирования, обернутая интерфейсом Gradio. Эта функция может принимать один или несколько параметров и возвращать одно или несколько значений</li> <li><code>inputs</code>: тип(ы) компонента(ов) ввода. Gradio предоставляет множество готовых компонентов, таких как <code>&quot;image&quot;</code> или <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: тип(ы) компонента(ов) вывода. Опять же, Gradio предоставляет множество предварительно созданных компонентов, например, <code>&quot; image&quot;</code> или <code>&quot;label&quot;</code>.</li>",he,k,ct='Полный список компонентов <a href="https://gradio.app/docs" rel="nofollow">смотрите в документации Gradio</a>. Каждый предварительно созданный компонент можно настроить, инстанцировав соответствующий ему класс.',fe,A,yt=`Например, как мы видели в <a href="../chapter9/2">предыдущем разделе</a>,
вместо передачи <code>&quot;textbox&quot;</code> в параметр <code>inputs</code>, вы можете передать компонент <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> для создания текстового поля с 7 строками и меткой.`,Ue,x,mt="Давайте рассмотрим еще один пример, на этот раз с компонентом <code>Audio</code>.",be,$,Ie,G,dt=`Как уже говорилось, Gradio предоставляет множество различных входов и выходов.
Поэтому давайте создадим <code>Interface</code>, работающий с аудио.`,Ce,q,wt=`В этом примере мы создадим функцию audio-to-audio, которая принимает
аудиофайл и просто переворачивает его.`,ve,B,Tt=`Для ввода мы будем использовать компонент <code>Audio</code>. При использовании компонента <code>Audio</code>,
вы можете указать, будет ли источником звука файл, который загружает пользователь
или микрофон, с помощью которого пользователь записывает свой голос. В данном случае давайте
зададим <code>&quot;microphone&quot;</code>. Просто ради интереса добавим к <code>Audio</code> метку, которая будет гласить
“Speak here…“.`,ge,_,jt=`Кроме того, мы хотели бы получать аудио в виде массива numpy, чтобы можно было легко
“перевернуть” его. Поэтому мы зададим <code>&quot;type&quot;</code> в значение <code>&quot;numpy&quot;</code>, которое передаст входные
данные в виде кортежа (<code>sample_rate</code>, <code>data</code>) в нашу функцию.`,ke,Z,Jt=`Мы также будем использовать компонент вывода <code>Audio</code>, который может автоматически
рендерить кортеж с частотой дискретизации и массивом данных numpy в воспроизводимый аудиофайл.
В этом случае нам не нужно делать никаких настроек, поэтому мы будем использовать строку
ярлык <code>&quot;audio&quot;</code>.`,Ae,H,xe,E,ht=`Код, приведенный выше, создаст интерфейс, подобный приведенному ниже (если ваш браузер не
не запрашивает разрешения на использование микрофона, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">откройте демо в отдельной вкладке</a>.)`,$e,u,ft,Ge,L,Ut="Теперь вы сможете записать свой голос и услышать, как вы говорите в обратную сторону - жутковато 👻!",qe,W,Be,R,bt=`Допустим, у нас есть более сложная функция, с несколькими входами и выходами.
В примере ниже у нас есть функция, которая принимает индекс выпадающего списка, значение слайдера и число,
и возвращает пример музыкального тона.`,_e,Q,It=`Посмотрите, как мы передаем список входных и выходных компонентов,
и посмотрите, сможете ли вы проследить за тем, что происходит.`,Ze,S,Ct="Ключевым моментом здесь является то, что когда вы передаете:",He,V,vt="<li>список входных компонентов, каждый компонент соответствует параметру по порядку.</li> <li>список выходных компонентов, каждый компонент соответствует возвращаемому значению.</li>",Ee,X,gt="В приведенном ниже фрагменте кода показано, как три компонента ввода соответствуют трем аргументам функции <code>generate_tone()</code>:",Le,N,We,M,kt,Re,Y,Qe,P,At=`До сих пор мы использовали метод <code>launch()</code> для запуска интерфейса, но мы
не обсуждали, что он делает.`,Se,z,xt=`По умолчанию метод <code>launch()</code> запускает демо на веб-сервере, который
работает локально. Если вы выполняете свой код в блокноте Jupyter или Colab, то
Gradio встроит демо GUI в блокнот, чтобы вы могли легко им пользоваться.`,Ve,F,$t="Вы можете настроить поведение <code>launch()</code> с помощью различных параметров:",Xe,D,Gt="<li><code>inline</code> - отображать ли интерфейс в виде строки в блокнотах Python.</li> <li><code>inbrowser</code> - автоматически ли запускать интерфейс в новой вкладке браузера по умолчанию.</li> <li><code>share</code> - создавать ли для интерфейса общедоступную ссылку с вашего компьютера. Что-то вроде ссылки на Google Drive!</li>",Ne,K,qt="Мы рассмотрим параметр <code>share</code> более подробно в следующем разделе!",Ye,O,Pe,ee,Bt=`Давайте создадим интерфейс, который позволит вам продемонстрировать демо модели <strong>распознавания речи</strong>.
Чтобы было интереснее, мы будем принимать <em>либо</em> микрофонный вход, либо загруженный файл.`,ze,te,_t=`Как обычно, мы загрузим нашу модель распознавания речи с помощью функции <code>pipeline()</code> из 🤗 Transformers.
Если вам нужно быстро вспомнить, вы можете вернуться к <a href="../chapter1/3">этому разделу в Главе 1</a>. Далее мы реализуем функцию <code>transcribe_audio()</code>, которая обрабатывает аудио и возвращает транскрипцию. Наконец, мы обернем эту функцию в <code>Interface</code> с компонентами <code>Audio</code> на входе и просто текстом на выходе. В целом, код этого приложения выглядит следующим образом:`,Fe,le,De,se,Zt='Если ваш браузер не запрашивает разрешения на использование микрофона, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">откройте демо в отдельной вкладке</a>.',Ke,c,Ht,Oe,ae,Et=`Вот и все! Теперь вы можете использовать этот интерфейс для транскрибирования аудио. Обратите внимание, что
передавая параметр <code>optional</code> как <code>True</code>, мы позволяем пользователю предоставить
либо микрофон, либо аудиофайл (либо ни то, ни другое, но в этом случае будет выдано сообщение об ошибке).`,et,ne,Lt="Продолжайте, чтобы узнать, как поделиться своим интерфейсом с другими!",tt,ie,lt,re,st;return h=new pe({props:{title:"Понимание класса Interface",local:"understanding-the-interface-class",headingTag:"h1"}}),f=new Yt({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"}]}}),b=new pe({props:{title:"Как создать Interface",local:"how-to-create-an-interface",headingTag:"h2"}}),$=new pe({props:{title:"Простой пример со звуком",local:"a-simple-example-with-audio",headingTag:"h2"}}),H=new nt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),W=new pe({props:{title:"Обработка нескольких входов и выходов",local:"handling-multiple-inputs-and-outputs",headingTag:"h2"}}),N=new nt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),Y=new pe({props:{title:"Метод launch()",local:"the-launch-method",headingTag:"h3"}}),O=new pe({props:{title:"✏️ Давайте применим это!",local:"lets-apply-it",headingTag:"h2"}}),le=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),ie=new Pt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/ru/chapter9/3.mdx"}}),{c(){J=i("meta"),Me=a(),oe=i("p"),ce=a(),y(h.$$.fragment),ye=a(),y(f.$$.fragment),me=a(),U=i("p"),U.innerHTML=pt,de=a(),y(b.$$.fragment),we=a(),I=i("p"),I.innerHTML=ot,Te=a(),C=i("p"),C.innerHTML=rt,je=a(),v=i("p"),v.textContent=ut,Je=a(),g=i("ul"),g.innerHTML=Mt,he=a(),k=i("p"),k.innerHTML=ct,fe=a(),A=i("p"),A.innerHTML=yt,Ue=a(),x=i("p"),x.innerHTML=mt,be=a(),y($.$$.fragment),Ie=a(),G=i("p"),G.innerHTML=dt,Ce=a(),q=i("p"),q.textContent=wt,ve=a(),B=i("p"),B.innerHTML=Tt,ge=a(),_=i("p"),_.innerHTML=jt,ke=a(),Z=i("p"),Z.innerHTML=Jt,Ae=a(),y(H.$$.fragment),xe=a(),E=i("p"),E.innerHTML=ht,$e=a(),u=i("iframe"),Ge=a(),L=i("p"),L.textContent=Ut,qe=a(),y(W.$$.fragment),Be=a(),R=i("p"),R.textContent=bt,_e=a(),Q=i("p"),Q.textContent=It,Ze=a(),S=i("p"),S.textContent=Ct,He=a(),V=i("ul"),V.innerHTML=vt,Ee=a(),X=i("p"),X.innerHTML=gt,Le=a(),y(N.$$.fragment),We=a(),M=i("iframe"),Re=a(),y(Y.$$.fragment),Qe=a(),P=i("p"),P.innerHTML=At,Se=a(),z=i("p"),z.innerHTML=xt,Ve=a(),F=i("p"),F.innerHTML=$t,Xe=a(),D=i("ul"),D.innerHTML=Gt,Ne=a(),K=i("p"),K.innerHTML=qt,Ye=a(),y(O.$$.fragment),Pe=a(),ee=i("p"),ee.innerHTML=Bt,ze=a(),te=i("p"),te.innerHTML=_t,Fe=a(),y(le.$$.fragment),De=a(),se=i("p"),se.innerHTML=Zt,Ke=a(),c=i("iframe"),Oe=a(),ae=i("p"),ae.innerHTML=Et,et=a(),ne=i("p"),ne.textContent=Lt,tt=a(),y(ie.$$.fragment),lt=a(),re=i("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);J=p(t,"META",{name:!0,content:!0}),t.forEach(l),Me=n(e),oe=p(e,"P",{}),ue(oe).forEach(l),ce=n(e),m(h.$$.fragment,e),ye=n(e),m(f.$$.fragment,e),me=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-enud80"&&(U.innerHTML=pt),de=n(e),m(b.$$.fragment,e),we=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-o67r3h"&&(I.innerHTML=ot),Te=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-5xxju6"&&(C.innerHTML=rt),je=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-8iucyy"&&(v.textContent=ut),Je=n(e),g=p(e,"UL",{"data-svelte-h":!0}),o(g)!=="svelte-1akaxuo"&&(g.innerHTML=Mt),he=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-mxtpfm"&&(k.innerHTML=ct),fe=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1gornw1"&&(A.innerHTML=yt),Ue=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-4nkf1r"&&(x.innerHTML=mt),be=n(e),m($.$$.fragment,e),Ie=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-rfepod"&&(G.innerHTML=dt),Ce=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-n97h54"&&(q.textContent=wt),ve=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-ar1v2m"&&(B.innerHTML=Tt),ge=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1uvsg1h"&&(_.innerHTML=jt),ke=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-c9vyv"&&(Z.innerHTML=Jt),Ae=n(e),m(H.$$.fragment,e),xe=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1af1p3z"&&(E.innerHTML=ht),$e=n(e),u=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(u).forEach(l),Ge=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-jmjdad"&&(L.textContent=Ut),qe=n(e),m(W.$$.fragment,e),Be=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-s5r27g"&&(R.textContent=bt),_e=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1hey8tu"&&(Q.textContent=It),Ze=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1lht4t5"&&(S.textContent=Ct),He=n(e),V=p(e,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-1p7h9vd"&&(V.innerHTML=vt),Ee=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-17e54rp"&&(X.innerHTML=gt),Le=n(e),m(N.$$.fragment,e),We=n(e),M=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(M).forEach(l),Re=n(e),m(Y.$$.fragment,e),Qe=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-14rvhw3"&&(P.innerHTML=At),Se=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1ssmino"&&(z.innerHTML=xt),Ve=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1gc9s6c"&&(F.innerHTML=$t),Xe=n(e),D=p(e,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-8vsj85"&&(D.innerHTML=Gt),Ne=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-15hrsz7"&&(K.innerHTML=qt),Ye=n(e),m(O.$$.fragment,e),Pe=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-kv7bmf"&&(ee.innerHTML=Bt),ze=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-ifycgo"&&(te.innerHTML=_t),Fe=n(e),m(le.$$.fragment,e),De=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1riv6tk"&&(se.innerHTML=Zt),Ke=n(e),c=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ue(c).forEach(l),Oe=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1gkr56k"&&(ae.innerHTML=Et),et=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-o596jh"&&(ne.textContent=Lt),tt=n(e),m(ie.$$.fragment,e),lt=n(e),re=p(e,"P",{}),ue(re).forEach(l),this.h()},h(){r(J,"name","hf:doc:metadata"),r(J,"content",Ft),at(u.src,ft="https://course-demos-audio-reverse.hf.space")||r(u,"src",ft),r(u,"frameborder","0"),r(u,"height","250"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),at(M.src,kt="https://course-demos-generate-tone.hf.space")||r(M,"src",kt),r(M,"frameborder","0"),r(M,"height","450"),r(M,"title","Gradio app"),r(M,"class","container p-0 flex-grow space-iframe"),r(M,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(M,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),at(c.src,Ht="https://course-demos-asr.hf.space")||r(c,"src",Ht),r(c,"frameborder","0"),r(c,"height","550"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Nt(document.head,J),s(e,Me,t),s(e,oe,t),s(e,ce,t),d(h,e,t),s(e,ye,t),d(f,e,t),s(e,me,t),s(e,U,t),s(e,de,t),d(b,e,t),s(e,we,t),s(e,I,t),s(e,Te,t),s(e,C,t),s(e,je,t),s(e,v,t),s(e,Je,t),s(e,g,t),s(e,he,t),s(e,k,t),s(e,fe,t),s(e,A,t),s(e,Ue,t),s(e,x,t),s(e,be,t),d($,e,t),s(e,Ie,t),s(e,G,t),s(e,Ce,t),s(e,q,t),s(e,ve,t),s(e,B,t),s(e,ge,t),s(e,_,t),s(e,ke,t),s(e,Z,t),s(e,Ae,t),d(H,e,t),s(e,xe,t),s(e,E,t),s(e,$e,t),s(e,u,t),s(e,Ge,t),s(e,L,t),s(e,qe,t),d(W,e,t),s(e,Be,t),s(e,R,t),s(e,_e,t),s(e,Q,t),s(e,Ze,t),s(e,S,t),s(e,He,t),s(e,V,t),s(e,Ee,t),s(e,X,t),s(e,Le,t),d(N,e,t),s(e,We,t),s(e,M,t),s(e,Re,t),d(Y,e,t),s(e,Qe,t),s(e,P,t),s(e,Se,t),s(e,z,t),s(e,Ve,t),s(e,F,t),s(e,Xe,t),s(e,D,t),s(e,Ne,t),s(e,K,t),s(e,Ye,t),d(O,e,t),s(e,Pe,t),s(e,ee,t),s(e,ze,t),s(e,te,t),s(e,Fe,t),d(le,e,t),s(e,De,t),s(e,se,t),s(e,Ke,t),s(e,c,t),s(e,Oe,t),s(e,ae,t),s(e,et,t),s(e,ne,t),s(e,tt,t),d(ie,e,t),s(e,lt,t),s(e,re,t),st=!0},p:Rt,i(e){st||(w(h.$$.fragment,e),w(f.$$.fragment,e),w(b.$$.fragment,e),w($.$$.fragment,e),w(H.$$.fragment,e),w(W.$$.fragment,e),w(N.$$.fragment,e),w(Y.$$.fragment,e),w(O.$$.fragment,e),w(le.$$.fragment,e),w(ie.$$.fragment,e),st=!0)},o(e){T(h.$$.fragment,e),T(f.$$.fragment,e),T(b.$$.fragment,e),T($.$$.fragment,e),T(H.$$.fragment,e),T(W.$$.fragment,e),T(N.$$.fragment,e),T(Y.$$.fragment,e),T(O.$$.fragment,e),T(le.$$.fragment,e),T(ie.$$.fragment,e),st=!1},d(e){e&&(l(Me),l(oe),l(ce),l(ye),l(me),l(U),l(de),l(we),l(I),l(Te),l(C),l(je),l(v),l(Je),l(g),l(he),l(k),l(fe),l(A),l(Ue),l(x),l(be),l(Ie),l(G),l(Ce),l(q),l(ve),l(B),l(ge),l(_),l(ke),l(Z),l(Ae),l(xe),l(E),l($e),l(u),l(Ge),l(L),l(qe),l(Be),l(R),l(_e),l(Q),l(Ze),l(S),l(He),l(V),l(Ee),l(X),l(Le),l(We),l(M),l(Re),l(Qe),l(P),l(Se),l(z),l(Ve),l(F),l(Xe),l(D),l(Ne),l(K),l(Ye),l(Pe),l(ee),l(ze),l(te),l(Fe),l(De),l(se),l(Ke),l(c),l(Oe),l(ae),l(et),l(ne),l(tt),l(lt),l(re)),l(J),j(h,e),j(f,e),j(b,e),j($,e),j(H,e),j(W,e),j(N,e),j(Y,e),j(O,e),j(le,e),j(ie,e)}}}const Ft='{"title":"Понимание класса Interface","local":"understanding-the-interface-class","sections":[{"title":"Как создать Interface","local":"how-to-create-an-interface","sections":[],"depth":2},{"title":"Простой пример со звуком","local":"a-simple-example-with-audio","sections":[],"depth":2},{"title":"Обработка нескольких входов и выходов","local":"handling-multiple-inputs-and-outputs","sections":[{"title":"Метод launch()","local":"the-launch-method","sections":[],"depth":3}],"depth":2},{"title":"✏️ Давайте применим это!","local":"lets-apply-it","sections":[],"depth":2}],"depth":1}';function Dt(it){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends St{constructor(J){super(),Vt(this,J,Dt,zt,Wt,{})}}export{sl as component};
