# Optimization

## ORTOptimizer[[optimum.onnxruntime.ORTOptimizer]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.onnxruntime.ORTOptimizer</name><anchor>optimum.onnxruntime.ORTOptimizer</anchor><source>https://github.com/huggingface/optimum-onnx/blob/vr_79/optimum/onnxruntime/optimization.py#L49</source><parameters>[{"name": "onnx_model_path", "val": ": list[os.PathLike]"}, {"name": "config", "val": ": PretrainedConfig"}, {"name": "from_ortmodel", "val": ": bool = False"}]</parameters></docstring>
Handles the ONNX Runtime optimization process for models shared on huggingface.co/models.


<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_pretrained</name><anchor>optimum.onnxruntime.ORTOptimizer.from_pretrained</anchor><source>https://github.com/huggingface/optimum-onnx/blob/vr_79/optimum/onnxruntime/optimization.py#L80</source><parameters>[{"name": "model_or_path", "val": ": str | os.PathLike | ORTModel"}, {"name": "file_names", "val": ": list[str] | None = None"}]</parameters><paramsdesc>- **model_or_path** (`Union[str, os.PathLike, ORTModel]`) --
  The path to a local directory hosting the model to optimize or an instance of an `ORTModel` to quantize.
  Can be either:
  - A path to a local *directory* containing the model to optimize.
  - An instance of [ORTModel](/docs/optimum/pr_79/en/onnxruntime/package_reference/modeling#optimum.onnxruntime.ORTModel).
- **file_names(`Optional[List[str]]`,** defaults to `None`) --
  The list of file names of the models to optimize.</paramsdesc><paramgroups>0</paramgroups></docstring>
Initializes the `ORTOptimizer` from a local directory or an `ORTModel`.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_fused_operators</name><anchor>optimum.onnxruntime.ORTOptimizer.get_fused_operators</anchor><source>https://github.com/huggingface/optimum-onnx/blob/vr_79/optimum/onnxruntime/optimization.py#L247</source><parameters>[{"name": "onnx_model_path", "val": ": str | os.PathLike"}]</parameters><paramsdesc>- **onnx_model_path** (`Union[str, os.PathLike]`) --
  Path of the ONNX model.</paramsdesc><paramgroups>0</paramgroups><retdesc>The dictionary mapping the name of the fused operators to their number of apparition in the model.</retdesc></docstring>
Computes the dictionary mapping the name of the fused operators to their number of apparition in the model.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_nodes_number_difference</name><anchor>optimum.onnxruntime.ORTOptimizer.get_nodes_number_difference</anchor><source>https://github.com/huggingface/optimum-onnx/blob/vr_79/optimum/onnxruntime/optimization.py#L265</source><parameters>[{"name": "onnx_model_path", "val": ": str | os.PathLike"}, {"name": "onnx_optimized_model_path", "val": ": str | os.PathLike"}]</parameters><paramsdesc>- **onnx_model_path** (`Union[str, os.PathLike]`) --
  Path of the ONNX model.
- **onnx_optimized_model_path** (`Union[str, os.PathLike]`) --
  Path of the optimized ONNX model.</paramsdesc><paramgroups>0</paramgroups><retdesc>The difference in the number of nodes between the original and the optimized model.</retdesc></docstring>
Compute the difference in the number of nodes between the original and the optimized model.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_operators_difference</name><anchor>optimum.onnxruntime.ORTOptimizer.get_operators_difference</anchor><source>https://github.com/huggingface/optimum-onnx/blob/vr_79/optimum/onnxruntime/optimization.py#L293</source><parameters>[{"name": "onnx_model_path", "val": ": str | os.PathLike"}, {"name": "onnx_optimized_model_path", "val": ": str | os.PathLike"}]</parameters><paramsdesc>- **onnx_model_path** (`Union[str, os.PathLike]`) --
  Path of the ONNX model.
- **onnx_optimized_model_path** (`Union[str, os.PathLike]`) --
  Path of the optimized ONNX model.</paramsdesc><paramgroups>0</paramgroups><retdesc>The dictionary mapping the operators name to the difference in the number of corresponding nodes between the
original and the optimized model.</retdesc></docstring>
Compute the dictionary mapping the operators name to the difference in the number of corresponding nodes between
the original and the optimized model.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>optimize</name><anchor>optimum.onnxruntime.ORTOptimizer.optimize</anchor><source>https://github.com/huggingface/optimum-onnx/blob/vr_79/optimum/onnxruntime/optimization.py#L128</source><parameters>[{"name": "optimization_config", "val": ": OptimizationConfig"}, {"name": "save_dir", "val": ": str | os.PathLike"}, {"name": "file_suffix", "val": ": str | None = 'optimized'"}, {"name": "one_external_file", "val": ": bool = True"}]</parameters><paramsdesc>- **optimization_config** ([OptimizationConfig](/docs/optimum/pr_79/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.OptimizationConfig)) --
  The configuration containing the parameters related to optimization.
- **save_dir** (`Union[str, os.PathLike]`) --
  The path used to save the optimized model.
- **file_suffix** (`str`, defaults to `"optimized"`) --
  The file suffix used to save the optimized model.
- **one_external_file** (`bool`, defaults to `True`) --
  When `use_external_data_format=True`, whether to save all tensors to one external file.
  If False, save each tensor to a file named with the tensor name.</paramsdesc><paramgroups>0</paramgroups></docstring>
Optimizes a model given the optimization specifications defined in `optimization_config`.




</div></div>