import{s as gs,o as Bs,n as Bl}from"../chunks/scheduler.f6b352c8.js";import{S as Zs,i as Gs,g as i,s as n,r as y,A as As,h as p,f as l,c as a,j as fl,u as r,x as M,k as bs,y as bl,a as s,v as J,d as T,t as u,w as c}from"../chunks/index.b90df637.js";import{T as gl}from"../chunks/Tip.366d2e6e.js";import{C as d}from"../chunks/CodeBlock.e5718f9d.js";import{H as U,E as vs}from"../chunks/getInferenceSnippets.ff8f18ec.js";function Ws(m){let o,j="This tutorial uses Python and Gradio, but you can adapt the approach to any language that can make HTTP requests. The models deployed on Inference Endpoints use standard APIs, so you can integrate them into web applications, mobile apps, or any other system.";return{c(){o=i("p"),o.textContent=j},l(w){o=p(w,"P",{"data-svelte-h":!0}),M(o)!=="svelte-1kzcndf"&&(o.textContent=j)},m(w,I){s(w,o,I)},p:Bl,d(w){w&&l(o)}}}function Ns(m){let o,j="You might also want to use <code>os.getenv</code> for your endpoint details.";return{c(){o=i("p"),o.innerHTML=j},l(w){o=p(w,"P",{"data-svelte-h":!0}),M(o)!=="svelte-1ene528"&&(o.innerHTML=j)},m(w,I){s(w,o,I)},p:Bl,d(w){w&&l(o)}}}function $s(m){let o,j="The transcription endpoint expects a file upload in the <code>files</code> parameter. Make sure to read the audio file as binary data and pass it correctly to the API.";return{c(){o=i("p"),o.innerHTML=j},l(w){o=p(w,"P",{"data-svelte-h":!0}),M(o)!=="svelte-1xad941"&&(o.innerHTML=j)},m(w,I){s(w,o,I)},p:Bl,d(w){w&&l(o)}}}function Ss(m){let o,j,w,I,g,Dt,B,Zl="This tutorial will guide you through building a complete transcription application using Hugging Face Inference Endpoints. We’ll create an app that can transcribe audio files and generate intelligent summaries with action items - perfect for meeting notes, interviews, or any audio content.",Ot,h,Kt,Z,te,G,Gl="First, we need to create an Inference Endpoint for audio transcription. We’ll use OpenAI’s Whisper model for high-quality speech recognition.",ee,A,Al="Start by navigating to the Inference Endpoints UI, and once you have logged in you should see a button for creating a new Inference Endpoint. Click the “New” button.",le,v,vl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/update/large-rewrite/assets/quick_start/1-new-button.png" alt="new-button"/>',se,W,Wl="From there you’ll be directed to the catalog. The Model Catalog consists of popular models which have tuned configurations to work as one-click deploys. You can filter by name, task, price of the hardware and much more.",ne,N,Nl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/update/large-rewrite/assets/quick_start/2-catalog.png" alt="catalog"/>',ae,$,$l='Search for “whisper” to find transcription models, or you can create a custom endpoint with <a href="https://huggingface.co/openai/whisper-large-v3" rel="nofollow">openai/whisper-large-v3</a>. This model provides excellent transcription quality for multiple languages and handles various audio formats.',ie,S,Sl="For transcription models, we recommend:",pe,X,Xl="<li><strong>GPU</strong>: NVIDIA L4 or A10G for good performance with audio processing</li> <li><strong>Instance Size</strong>: x1 (sufficient for most transcription workloads)</li> <li><strong>Auto-scaling</strong>: Enable scale-to-zero to save costs when not in use</li>",Me,q,ql="Click “Create Endpoint” to deploy your transcription service.",oe,E,El='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/update/large-rewrite/assets/quick_start/4-config.png" alt="config"/>',ye,V,Vl="Your endpoint will take about 5 minutes to initialize. Once it’s ready, you’ll see it in the “Running” state.",re,Q,Je,k,Ql='Now let’s do the same again but now for a text generation model. For generating summaries and action items, we’ll create a second endpoint using the <a href="https://huggingface.co/Qwen/Qwen3-1.7B" rel="nofollow">Qwen/Qwen3-1.7B</a> model.',Te,R,kl="Follow the same process:",ue,H,Rl="<li>Click “New” button in the Inference Endpoints UI</li> <li>Search for <code>qwen3 1.7b</code> in the catalog</li> <li>The NVIDIA L4 with x1 instance size is recommended for this model</li> <li>Keep the default settings (scale-to-zero enabled, 1-hour timeout)</li> <li>Click “Create Endpoint”</li>",ce,x,Hl="This model is optimized for text generation tasks and will provide excellent summarization capabilities. Both endpoints will take about 3-5 minutes to initialize.",we,z,Ue,Y,xl="Once your endpoints are running, you can test them in the playground. The transcription endpoint will accept audio files and return text transcripts.",je,F,zl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/chatbot-tutorial/assets/tutorials/chatbot/playground.png" alt="playground"/>',Ie,_,Yl="Test with a short audio sample to verify the transcription quality.",de,P,me,L,Fl='You’ll need the endpoint details from your <a href="https://endpoints.huggingface.co/" rel="nofollow">endpoints page</a>:',he,D,_l='<li><strong>Base URL</strong>: <code>https://&lt;endpoint-name&gt;.endpoints.huggingface.cloud/v1/</code></li> <li><strong>Model name</strong>: The name of your endpoint</li> <li><strong>Token</strong>: Your HF token from <a href="https://huggingface.co/settings/tokens" rel="nofollow">settings</a></li>',Ce,O,Pl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/chatbot-tutorial/assets/tutorials/chatbot/endpoint-page.png" alt="endpoint-details"/>',fe,K,Ll="You can validate your details by testing your endpoint out in the command line with curl.",be,tt,ge,et,Be,lt,Dl="Now let’s build a transcription application step by step. We’ll break it down into logical blocks to create a complete solution that can transcribe audio and generate intelligent summaries.",Ze,st,Ge,nt,Ol="We’ll use the <code>requests</code> library to connect to both endpoints and <code>gradio</code> to create the interface. Let’s install the required packages:",Ae,at,ve,it,Kl="Then, set up your imports in a new Python file:",We,pt,Ne,Mt,$e,ot,ts="Set up the configuration to connect to both your transcription and summarization endpoints based on the details you collected in the previous steps.",Se,yt,Xe,rt,es="Your endpoints are now configured to handle both audio transcription and text summarization.",qe,C,Ee,Jt,Ve,Tt,ls="Next, we’ll create a function to handle audio file uploads and transcription:",Qe,ut,ke,f,Re,ct,He,wt,ss="Now we’ll create a function to generate summaries from the transcribed text. We’ll do some simple prompt engineering to get the best results.",xe,Ut,ze,jt,Ye,It,ns="Now let’s build our Gradio interface. We’ll use the <code>gr.Interface</code> class to create a simple interface that allows us to upload an audio file and see the transcript and summary.",Fe,dt,as="First, we’ll create a main processing function that handles the complete workflow.",_e,mt,Pe,ht,is="Then, we can run that function in a Gradio interface. We’ll add some descriptions and a title to make it more user-friendly.",Le,Ct,De,ft,ps="That’s it! You can now run the app locally with <code>python app.py</code> and test it out.",Oe,b,Pt,Ms="Click to view the complete script",Cl,bt,Ke,gt,os='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/transcription-tutorial/assets/tutorials/transcriptions/app.png" alt="app"/>',tl,Bt,el,Zt,ys="Now, let’s deploy it to Hugging Face Spaces so everyone can use it!",ll,Gt,rs='<li><strong>Create a new Space</strong>: Go to <a href="https://huggingface.co/new-space" rel="nofollow">huggingface.co/new-space</a></li> <li><strong>Choose Gradio SDK</strong> and make it public</li> <li><strong>Upload your files</strong>: Upload <code>app.py</code> and any requirements</li> <li><strong>Add your token</strong>: In Space settings, add <code>HF_TOKEN</code> as a secret</li> <li><strong>Configure hardware</strong>: Consider GPU for faster processing</li> <li><strong>Launch</strong>: Your app will be live at <code>https://huggingface.co/spaces/your-username/your-space-name</code></li>',sl,At,Js="Your transcription app is now ready to handle meeting notes, interviews, podcasts, and any other audio content that needs to be transcribed and summarized!",nl,vt,al,Wt,Ts="For production transcription applications, especially those handling sensitive audio data like confidential meetings, legal proceedings, or medical consultations, security is paramount. AWS PrivateLink allows you to access your Inference Endpoints from within your AWS VPC without exposing traffic to the public internet.",il,Nt,pl,$t,us="When creating your Whisper and Qwen endpoints, select <strong>“Private”</strong> as the security level:",Ml,St,cs='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/6_private_type.png" alt="private-type"/>',ol,Xt,yl,qt,ws='After your endpoints are created, you’ll receive VPC Service Names. Use these to create VPC Interface Endpoints in your <a href="https://console.aws.amazon.com/vpc/home?#Endpoints" rel="nofollow">AWS VPC Console</a>.',rl,Et,Us='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/6_4_add_private_link.png" alt="add-private-link"/>',Jl,Vt,Tl,Qt,js="Modify your endpoint URLs to use the private VPC endpoints:",ul,kt,cl,Rt,Is='For complete setup instructions, see our <a href="/docs/inference-endpoints/guides/private_link">Private Link guide</a>.',wl,Ht,Ul,xt,ds="Great work! You’ve now built a complete transcription application with intelligent summarization.",jl,zt,ms="Here are some ways to extend your transcription app:",Il,Yt,hs="<li><strong>Multi-language support</strong>: Add language detection and support for multiple languages</li> <li><strong>Speaker identification</strong>: Use a model from the hub with speaker diarization capabilities.</li> <li><strong>Custom prompts</strong>: Allow users to customize the summary format and style</li> <li><strong>Implement Text-to-Speech</strong>: Use a model from the hub to convert your summary to another audio file!</li>",dl,Ft,ml,Lt,hl;return g=new U({props:{title:"Create your own transcription app",local:"create-your-own-transcription-app",headingTag:"h1"}}),h=new gl({props:{$$slots:{default:[Ws]},$$scope:{ctx:m}}}),Z=new U({props:{title:"Create your transcription endpoint",local:"create-your-transcription-endpoint",headingTag:"h2"}}),Q=new U({props:{title:"Create your text generation endpoint",local:"create-your-text-generation-endpoint",headingTag:"h2"}}),z=new U({props:{title:"Test your endpoints",local:"test-your-endpoints",headingTag:"h2"}}),P=new U({props:{title:"Get your endpoint details",local:"get-your-endpoint-details",headingTag:"h2"}}),tt=new d({props:{code:"Y3VybCUyMCUyMiUzQ2VuZHBvaW50LXVybCUzRSUyMiUyMCU1QyUwQS1YJTIwUE9TVCUyMCU1QyUwQS0tZGF0YS1iaW5hcnklMjAnJTQwJTNDYXVkaW8tZmlsZSUzRSclMjAlNUMlMEEtSCUyMCUyMkFjY2VwdCUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUyMiUyMCU1QyUwQS1IJTIwJTIyQ29udGVudC1UeXBlJTNBJTIwYXVkaW8lMkZmbGFjJTIyJTIwJTVD",highlighted:`curl <span class="hljs-string">&quot;&lt;endpoint-url&gt;&quot;</span> \\
-X POST \\
--data-binary <span class="hljs-string">&#x27;@&lt;audio-file&gt;&#x27;</span> \\
-H <span class="hljs-string">&quot;Accept: application/json&quot;</span> \\
-H <span class="hljs-string">&quot;Content-Type: audio/flac&quot;</span> \\`,wrap:!1}}),et=new U({props:{title:"Building the transcription app",local:"building-the-transcription-app",headingTag:"h2"}}),st=new U({props:{title:"Step 1: Set up dependencies and imports",local:"step-1-set-up-dependencies-and-imports",headingTag:"h3"}}),at=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdyYWRpbyUyMHJlcXVlc3Rz",highlighted:"pip install gradio requests",wrap:!1}}),pt=new d({props:{code:"aW1wb3J0JTIwb3MlMEElMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBaW1wb3J0JTIwcmVxdWVzdHM=",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> requests`,wrap:!1}}),Mt=new U({props:{title:"Step 2: Configure your endpoint connections",local:"step-2-configure-your-endpoint-connections",headingTag:"h3"}}),yt=new d({props:{code:"JTIzJTIwQ29uZmlndXJhdGlvbiUyMGZvciUyMGJvdGglMjBlbmRwb2ludHMlMEFUUkFOU0NSSVBUSU9OX0VORFBPSU5UJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ5b3VyLXdoaXNwZXItZW5kcG9pbnQuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGYXBpJTJGdjElMkZhdWRpbyUyRnRyYW5zY3JpcHRpb25zJTIyJTBBU1VNTUFSSVpBVElPTl9FTkRQT0lOVCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGeW91ci1xd2VuLWVuZHBvaW50LmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTIyJTBBSEZfVE9LRU4lMjAlM0QlMjBvcy5nZXRlbnYoJTIySEZfVE9LRU4lMjIpJTIwJTIwJTIzJTIwWW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwdG9rZW4lMEElMEElMjMlMjBIZWFkZXJzJTIwZm9yJTIwYXV0aGVudGljYXRpb24lMEFoZWFkZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQXV0aG9yaXphdGlvbiUyMiUzQSUyMGYlMjJCZWFyZXIlMjAlN0JIRl9UT0tFTiU3RCUyMiUwQSU3RA==",highlighted:`<span class="hljs-comment"># Configuration for both endpoints</span>
TRANSCRIPTION_ENDPOINT = <span class="hljs-string">&quot;https://your-whisper-endpoint.endpoints.huggingface.cloud/api/v1/audio/transcriptions&quot;</span>
SUMMARIZATION_ENDPOINT = <span class="hljs-string">&quot;https://your-qwen-endpoint.endpoints.huggingface.cloud/v1/chat/completions&quot;</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)  <span class="hljs-comment"># Your Hugging Face Hub token</span>

<span class="hljs-comment"># Headers for authentication</span>
headers = {
    <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
}`,wrap:!1}}),C=new gl({props:{$$slots:{default:[Ns]},$$scope:{ctx:m}}}),Jt=new U({props:{title:"Step 3: Create the transcription function",local:"step-3-create-the-transcription-function",headingTag:"h3"}}),ut=new d({props:{code:"ZGVmJTIwdHJhbnNjcmliZV9hdWRpbyhhdWRpb19maWxlX3BhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyVHJhbnNjcmliZSUyMGF1ZGlvJTIwdXNpbmclMjBkaXJlY3QlMjByZXF1ZXN0cyUyMHRvJTIwdGhlJTIwZW5kcG9pbnQlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBSZWFkJTIwYXVkaW8lMjBmaWxlJTIwYW5kJTIwcHJlcGFyZSUyMGZvciUyMHVwbG9hZCUwQSUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKGF1ZGlvX2ZpbGVfcGF0aCUyQyUyMCUyMnJiJTIyKSUyMGFzJTIwYXVkaW9fZmlsZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFJlYWQlMjB0aGUlMjBhdWRpbyUyMGZpbGUlMjBhcyUyMGJpbmFyeSUyMGRhdGElMjBhbmQlMjByZXByZXNlbnQlMjBpdCUyMGFzJTIwYSUyMGZpbGUlMjBvYmplY3QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWxlcyUyMCUzRCUyMCU3QiUyMmZpbGUlMjIlM0ElMjBhdWRpb19maWxlLnJlYWQoKSU3RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyME1ha2UlMjB0aGUlMjByZXF1ZXN0JTIwdG8lMjB0aGUlMjB0cmFuc2NyaXB0aW9uJTIwZW5kcG9pbnQlMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLnBvc3QoVFJBTlNDUklQVElPTl9FTkRQT0lOVCUyQyUyMGhlYWRlcnMlM0RoZWFkZXJzJTJDJTIwZmlsZXMlM0RmaWxlcyklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBDaGVjayUyMGlmJTIwdGhlJTIwcmVxdWVzdCUyMHdhcyUyMHN1Y2Nlc3NmdWwlMEElMjAlMjAlMjAlMjBpZiUyMHJlc3BvbnNlLnN0YXR1c19jb2RlJTIwJTNEJTNEJTIwMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcmVzcG9uc2UuanNvbigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzdWx0LmdldCglMjJ0ZXh0JTIyJTJDJTIwJTIyTm8lMjB0cmFuc2NyaXB0aW9uJTIwYXZhaWxhYmxlJTIyKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyRXJyb3IlM0ElMjAlN0JyZXNwb25zZS5zdGF0dXNfY29kZSU3RCUyMC0lMjAlN0JyZXNwb25zZS50ZXh0JTdEJTIy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio_file_path</span>):
    <span class="hljs-string">&quot;&quot;&quot;Transcribe audio using direct requests to the endpoint&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Read audio file and prepare for upload</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(audio_file_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> audio_file:
        <span class="hljs-comment"># Read the audio file as binary data and represent it as a file object</span>
        files = {<span class="hljs-string">&quot;file&quot;</span>: audio_file.read()}
    
    <span class="hljs-comment"># Make the request to the transcription endpoint</span>
    response = requests.post(TRANSCRIPTION_ENDPOINT, headers=headers, files=files)
    
    <span class="hljs-comment"># Check if the request was successful</span>
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        result = response.json()
        <span class="hljs-keyword">return</span> result.get(<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;No transcription available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error: <span class="hljs-subst">{response.status_code}</span> - <span class="hljs-subst">{response.text}</span>&quot;</span>`,wrap:!1}}),f=new gl({props:{$$slots:{default:[$s]},$$scope:{ctx:m}}}),ct=new U({props:{title:"Step 4: Create the summarization function",local:"step-4-create-the-summarization-function",headingTag:"h3"}}),Ut=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_summary</span>(<span class="hljs-params">transcript</span>):
    <span class="hljs-string">&quot;&quot;&quot;Generate summary using requests to the chat completions endpoint&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># define a nice prompt to get the best results for our use case</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Analyze this meeting transcript and provide:
    1. A concise summary of key points
    2. Action items with responsible parties
    3. Important decisions made
    
    Transcript: <span class="hljs-subst">{transcript}</span>
    
    Format with clear sections:
    ## Summary
    ## Action Items  
    ## Decisions Made
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Prepare the payload using the Messages API format</span>
    payload = {
        <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;your-qwen-endpoint-name&quot;</span>,  <span class="hljs-comment"># Use the name of your endpoint</span>
        <span class="hljs-string">&quot;messages&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}],
        <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">1000</span>, <span class="hljs-comment"># we can also set a max_tokens parameter to limit the length of the response</span>
        <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>, <span class="hljs-comment"># we might want to set lower temperature for more deterministic results</span>
        <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">False</span> <span class="hljs-comment"># we don&#x27;t need streaming for this use case</span>
    }
    
    <span class="hljs-comment"># Headers for chat completions</span>
    chat_headers = {
        <span class="hljs-string">&quot;Accept&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
    }
    
    <span class="hljs-comment"># Make the request</span>
    response = requests.post(SUMMARIZATION_ENDPOINT, headers=chat_headers, json=payload)
    response.raise_for_status()
    
    <span class="hljs-comment"># Parse the response</span>
    result = response.json()
    <span class="hljs-keyword">return</span> result[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>]`,wrap:!1}}),jt=new U({props:{title:"Step 5: Wrap it all together",local:"step-5-wrap-it-all-together",headingTag:"h3"}}),mt=new d({props:{code:"ZGVmJTIwcHJvY2Vzc19tZWV0aW5nX2F1ZGlvKGF1ZGlvX2ZpbGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTWFpbiUyMHByb2Nlc3NpbmclMjBmdW5jdGlvbiUyMHRoYXQlMjBoYW5kbGVzJTIwdGhlJTIwY29tcGxldGUlMjB3b3JrZmxvdyUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwYXVkaW9fZmlsZSUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMlBsZWFzZSUyMHVwbG9hZCUyMGFuJTIwYXVkaW8lMjBmaWxlLiUyMiUyQyUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFN0ZXAlMjAxJTNBJTIwVHJhbnNjcmliZSUyMHRoZSUyMGF1ZGlvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNjcmlwdCUyMCUzRCUyMHRyYW5zY3JpYmVfYXVkaW8oYXVkaW9fZmlsZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTdGVwJTIwMiUzQSUyMEdlbmVyYXRlJTIwc3VtbWFyeSUyMGZyb20lMjB0cmFuc2NyaXB0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VtbWFyeSUyMCUzRCUyMGdlbmVyYXRlX3N1bW1hcnkodHJhbnNjcmlwdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjB0cmFuc2NyaXB0JTJDJTIwc3VtbWFyeSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJFcnJvciUyMHByb2Nlc3NpbmclMjBhdWRpbyUzQSUyMCU3QnN0cihlKSU3RCUyMiUyQyUyMCUyMiUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_meeting_audio</span>(<span class="hljs-params">audio_file</span>):
    <span class="hljs-string">&quot;&quot;&quot;Main processing function that handles the complete workflow&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_file <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Please upload an audio file.&quot;</span>, <span class="hljs-string">&quot;&quot;</span>
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Step 1: Transcribe the audio</span>
        transcript = transcribe_audio(audio_file)
        
        <span class="hljs-comment"># Step 2: Generate summary from transcript</span>
        summary = generate_summary(transcript)
        
        <span class="hljs-keyword">return</span> transcript, summary
    
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error processing audio: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>, <span class="hljs-string">&quot;&quot;</span>`,wrap:!1}}),Ct=new d({props:{code:"JTIzJTIwQ3JlYXRlJTIwR3JhZGlvJTIwaW50ZXJmYWNlJTBBYXBwJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEcHJvY2Vzc19tZWV0aW5nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuQXVkaW8obGFiZWwlM0QlMjJVcGxvYWQlMjBNZWV0aW5nJTIwQXVkaW8lMjIlMkMlMjB0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3gobGFiZWwlM0QlMjJGdWxsJTIwVHJhbnNjcmlwdCUyMiUyQyUyMGxpbmVzJTNEMTApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3IuVGV4dGJveChsYWJlbCUzRCUyMk1lZXRpbmclMjBTdW1tYXJ5JTIyJTJDJTIwbGluZXMlM0Q4KSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyJUYwJTlGJThFJUE0JTIwQUklMjBNZWV0aW5nJTIwTm90ZXMlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlVwbG9hZCUyMGF1ZGlvJTIwdG8lMjBnZXQlMjBpbnN0YW50JTIwdHJhbnNjcmlwdHMlMjBhbmQlMjBzdW1tYXJpZXMuJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># Create Gradio interface</span>
app = gr.Interface(
    fn=process_meeting_audio,
    inputs=gr.Audio(label=<span class="hljs-string">&quot;Upload Meeting Audio&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=[
        gr.Textbox(label=<span class="hljs-string">&quot;Full Transcript&quot;</span>, lines=<span class="hljs-number">10</span>),
        gr.Textbox(label=<span class="hljs-string">&quot;Meeting Summary&quot;</span>, lines=<span class="hljs-number">8</span>),
    ],
    title=<span class="hljs-string">&quot;🎤 AI Meeting Notes&quot;</span>,
    description=<span class="hljs-string">&quot;Upload audio to get instant transcripts and summaries.&quot;</span>,
)`,wrap:!1}}),bt=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> requests

<span class="hljs-comment"># Configuration for both endpoints</span>
TRANSCRIPTION_ENDPOINT = <span class="hljs-string">&quot;https://your-whisper-endpoint.endpoints.huggingface.cloud/api/v1/audio/transcriptions&quot;</span>
SUMMARIZATION_ENDPOINT = <span class="hljs-string">&quot;https://your-qwen-endpoint.endpoints.huggingface.cloud/v1/chat/completions&quot;</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)  <span class="hljs-comment"># Your Hugging Face Hub token</span>

<span class="hljs-comment"># Headers for authentication</span>
headers = {
    <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio_file_path</span>):
    <span class="hljs-string">&quot;&quot;&quot;Transcribe audio using direct requests to the endpoint&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Read audio file and prepare for upload</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(audio_file_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> audio_file:
        files = {<span class="hljs-string">&quot;file&quot;</span>: audio_file.read()}
    
    <span class="hljs-comment"># Make the request to the transcription endpoint</span>
    response = requests.post(TRANSCRIPTION_ENDPOINT, headers=headers, files=files)
    
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        result = response.json()
        <span class="hljs-keyword">return</span> result.get(<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;No transcription available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error: <span class="hljs-subst">{response.status_code}</span> - <span class="hljs-subst">{response.text}</span>&quot;</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_summary</span>(<span class="hljs-params">transcript</span>):
    <span class="hljs-string">&quot;&quot;&quot;Generate summary using requests to the chat completions endpoint&quot;&quot;&quot;</span>
    
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Analyze this meeting transcript and provide:
    1. A concise summary of key points
    2. Action items with responsible parties
    3. Important decisions made
    
    Transcript: <span class="hljs-subst">{transcript}</span>
    
    Format with clear sections:
    ## Summary
    ## Action Items  
    ## Decisions Made
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Prepare the payload using the Messages API format</span>
    payload = {
        <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;your-qwen-endpoint-name&quot;</span>,  <span class="hljs-comment"># Use the name of your endpoint</span>
        <span class="hljs-string">&quot;messages&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}],
        <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">1000</span>,
        <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
        <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">False</span>
    }
    
    <span class="hljs-comment"># Headers for chat completions</span>
    chat_headers = {
        <span class="hljs-string">&quot;Accept&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
    }
    
    <span class="hljs-comment"># Make the request</span>
    response = requests.post(SUMMARIZATION_ENDPOINT, headers=chat_headers, json=payload)
    response.raise_for_status()
    
    <span class="hljs-comment"># Parse the response</span>
    result = response.json()
    <span class="hljs-keyword">return</span> result[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_meeting_audio</span>(<span class="hljs-params">audio_file</span>):
    <span class="hljs-string">&quot;&quot;&quot;Main processing function that handles the complete workflow&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_file <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Please upload an audio file.&quot;</span>, <span class="hljs-string">&quot;&quot;</span>
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Step 1: Transcribe the audio</span>
        transcript = transcribe_audio(audio_file)
        
        <span class="hljs-comment"># Step 2: Generate summary from transcript</span>
        summary = generate_summary(transcript)
        
        <span class="hljs-keyword">return</span> transcript, summary
    
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error processing audio: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>, <span class="hljs-string">&quot;&quot;</span>


<span class="hljs-comment"># Create Gradio interface</span>
app = gr.Interface(
    fn=process_meeting_audio,
    inputs=gr.Audio(label=<span class="hljs-string">&quot;Upload Meeting Audio&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=[
        gr.Textbox(label=<span class="hljs-string">&quot;Full Transcript&quot;</span>, lines=<span class="hljs-number">10</span>),
        gr.Textbox(label=<span class="hljs-string">&quot;Meeting Summary&quot;</span>, lines=<span class="hljs-number">8</span>),
    ],
    title=<span class="hljs-string">&quot;🎤 AI Meeting Notes&quot;</span>,
    description=<span class="hljs-string">&quot;Upload audio to get instant transcripts and summaries.&quot;</span>,
)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    app.launch()`,wrap:!1}}),Bt=new U({props:{title:"Deploy your transcription app",local:"deploy-your-transcription-app",headingTag:"h2"}}),vt=new U({props:{title:"Bonus: Secure your app with AWS PrivateLink",local:"bonus-secure-your-app-with-aws-privatelink",headingTag:"h2"}}),Nt=new U({props:{title:"Step 1: Create Private Endpoints",local:"step-1-create-private-endpoints",headingTag:"h3"}}),Xt=new U({props:{title:"Step 2: Configure VPC Interface Endpoint",local:"step-2-configure-vpc-interface-endpoint",headingTag:"h3"}}),Vt=new U({props:{title:"Step 3: Update your application",local:"step-3-update-your-application",headingTag:"h4"}}),kt=new d({props:{code:"JTIzJTIwVXNlJTIweW91ciUyMHByaXZhdGUlMjBWUEMlMjBlbmRwb2ludCUyMFVSTHMlMEFUUkFOU0NSSVBUSU9OX0VORFBPSU5UJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ5b3VyLXByaXZhdGUtdnBjLWVuZHBvaW50LnZwYy1lbmRwb2ludC5yZWdpb24udnBjZS5hbWF6b25hd3MuY29tJTJGYXBpJTJGdjElMkZhdWRpbyUyRnRyYW5zY3JpcHRpb25zJTIyJTBBU1VNTUFSSVpBVElPTl9FTkRQT0lOVCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGeW91ci1wcml2YXRlLXZwYy1lbmRwb2ludC52cGMtZW5kcG9pbnQucmVnaW9uLnZwY2UuYW1hem9uYXdzLmNvbSUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTIy",highlighted:`<span class="hljs-comment"># Use your private VPC endpoint URLs</span>
TRANSCRIPTION_ENDPOINT = <span class="hljs-string">&quot;https://your-private-vpc-endpoint.vpc-endpoint.region.vpce.amazonaws.com/api/v1/audio/transcriptions&quot;</span>
SUMMARIZATION_ENDPOINT = <span class="hljs-string">&quot;https://your-private-vpc-endpoint.vpc-endpoint.region.vpce.amazonaws.com/v1/chat/completions&quot;</span>`,wrap:!1}}),Ht=new U({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Ft=new vs({props:{source:"https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/tutorials/transcription.mdx"}}),{c(){o=i("meta"),j=n(),w=i("p"),I=n(),y(g.$$.fragment),Dt=n(),B=i("p"),B.textContent=Zl,Ot=n(),y(h.$$.fragment),Kt=n(),y(Z.$$.fragment),te=n(),G=i("p"),G.textContent=Gl,ee=n(),A=i("p"),A.textContent=Al,le=n(),v=i("p"),v.innerHTML=vl,se=n(),W=i("p"),W.textContent=Wl,ne=n(),N=i("p"),N.innerHTML=Nl,ae=n(),$=i("p"),$.innerHTML=$l,ie=n(),S=i("p"),S.textContent=Sl,pe=n(),X=i("ul"),X.innerHTML=Xl,Me=n(),q=i("p"),q.textContent=ql,oe=n(),E=i("p"),E.innerHTML=El,ye=n(),V=i("p"),V.textContent=Vl,re=n(),y(Q.$$.fragment),Je=n(),k=i("p"),k.innerHTML=Ql,Te=n(),R=i("p"),R.textContent=kl,ue=n(),H=i("ol"),H.innerHTML=Rl,ce=n(),x=i("p"),x.textContent=Hl,we=n(),y(z.$$.fragment),Ue=n(),Y=i("p"),Y.textContent=xl,je=n(),F=i("p"),F.innerHTML=zl,Ie=n(),_=i("p"),_.textContent=Yl,de=n(),y(P.$$.fragment),me=n(),L=i("p"),L.innerHTML=Fl,he=n(),D=i("ul"),D.innerHTML=_l,Ce=n(),O=i("p"),O.innerHTML=Pl,fe=n(),K=i("p"),K.textContent=Ll,be=n(),y(tt.$$.fragment),ge=n(),y(et.$$.fragment),Be=n(),lt=i("p"),lt.textContent=Dl,Ze=n(),y(st.$$.fragment),Ge=n(),nt=i("p"),nt.innerHTML=Ol,Ae=n(),y(at.$$.fragment),ve=n(),it=i("p"),it.textContent=Kl,We=n(),y(pt.$$.fragment),Ne=n(),y(Mt.$$.fragment),$e=n(),ot=i("p"),ot.textContent=ts,Se=n(),y(yt.$$.fragment),Xe=n(),rt=i("p"),rt.textContent=es,qe=n(),y(C.$$.fragment),Ee=n(),y(Jt.$$.fragment),Ve=n(),Tt=i("p"),Tt.textContent=ls,Qe=n(),y(ut.$$.fragment),ke=n(),y(f.$$.fragment),Re=n(),y(ct.$$.fragment),He=n(),wt=i("p"),wt.textContent=ss,xe=n(),y(Ut.$$.fragment),ze=n(),y(jt.$$.fragment),Ye=n(),It=i("p"),It.innerHTML=ns,Fe=n(),dt=i("p"),dt.textContent=as,_e=n(),y(mt.$$.fragment),Pe=n(),ht=i("p"),ht.textContent=is,Le=n(),y(Ct.$$.fragment),De=n(),ft=i("p"),ft.innerHTML=ps,Oe=n(),b=i("details"),Pt=i("summary"),Pt.textContent=Ms,Cl=n(),y(bt.$$.fragment),Ke=n(),gt=i("p"),gt.innerHTML=os,tl=n(),y(Bt.$$.fragment),el=n(),Zt=i("p"),Zt.textContent=ys,ll=n(),Gt=i("ol"),Gt.innerHTML=rs,sl=n(),At=i("p"),At.textContent=Js,nl=n(),y(vt.$$.fragment),al=n(),Wt=i("p"),Wt.textContent=Ts,il=n(),y(Nt.$$.fragment),pl=n(),$t=i("p"),$t.innerHTML=us,Ml=n(),St=i("p"),St.innerHTML=cs,ol=n(),y(Xt.$$.fragment),yl=n(),qt=i("p"),qt.innerHTML=ws,rl=n(),Et=i("p"),Et.innerHTML=Us,Jl=n(),y(Vt.$$.fragment),Tl=n(),Qt=i("p"),Qt.textContent=js,ul=n(),y(kt.$$.fragment),cl=n(),Rt=i("p"),Rt.innerHTML=Is,wl=n(),y(Ht.$$.fragment),Ul=n(),xt=i("p"),xt.textContent=ds,jl=n(),zt=i("p"),zt.textContent=ms,Il=n(),Yt=i("ul"),Yt.innerHTML=hs,dl=n(),y(Ft.$$.fragment),ml=n(),Lt=i("p"),this.h()},l(t){const e=As("svelte-u9bgzb",document.head);o=p(e,"META",{name:!0,content:!0}),e.forEach(l),j=a(t),w=p(t,"P",{}),fl(w).forEach(l),I=a(t),r(g.$$.fragment,t),Dt=a(t),B=p(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-11kksmv"&&(B.textContent=Zl),Ot=a(t),r(h.$$.fragment,t),Kt=a(t),r(Z.$$.fragment,t),te=a(t),G=p(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-z0skyq"&&(G.textContent=Gl),ee=a(t),A=p(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-2crr1b"&&(A.textContent=Al),le=a(t),v=p(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-rr08y1"&&(v.innerHTML=vl),se=a(t),W=p(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-4f7swo"&&(W.textContent=Wl),ne=a(t),N=p(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1fpb2w2"&&(N.innerHTML=Nl),ae=a(t),$=p(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-csv139"&&($.innerHTML=$l),ie=a(t),S=p(t,"P",{"data-svelte-h":!0}),M(S)!=="svelte-lld6nd"&&(S.textContent=Sl),pe=a(t),X=p(t,"UL",{"data-svelte-h":!0}),M(X)!=="svelte-10gw77w"&&(X.innerHTML=Xl),Me=a(t),q=p(t,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1shrp82"&&(q.textContent=ql),oe=a(t),E=p(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-l3aysm"&&(E.innerHTML=El),ye=a(t),V=p(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-r8kuit"&&(V.textContent=Vl),re=a(t),r(Q.$$.fragment,t),Je=a(t),k=p(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-13t63ie"&&(k.innerHTML=Ql),Te=a(t),R=p(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-6jil6r"&&(R.textContent=kl),ue=a(t),H=p(t,"OL",{"data-svelte-h":!0}),M(H)!=="svelte-1vkmkhw"&&(H.innerHTML=Rl),ce=a(t),x=p(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1hrp0qn"&&(x.textContent=Hl),we=a(t),r(z.$$.fragment,t),Ue=a(t),Y=p(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-o2p4m3"&&(Y.textContent=xl),je=a(t),F=p(t,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1q3yauu"&&(F.innerHTML=zl),Ie=a(t),_=p(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1rqdtmf"&&(_.textContent=Yl),de=a(t),r(P.$$.fragment,t),me=a(t),L=p(t,"P",{"data-svelte-h":!0}),M(L)!=="svelte-13oqpkl"&&(L.innerHTML=Fl),he=a(t),D=p(t,"UL",{"data-svelte-h":!0}),M(D)!=="svelte-1mxq0ya"&&(D.innerHTML=_l),Ce=a(t),O=p(t,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1m8fr79"&&(O.innerHTML=Pl),fe=a(t),K=p(t,"P",{"data-svelte-h":!0}),M(K)!=="svelte-5vve8m"&&(K.textContent=Ll),be=a(t),r(tt.$$.fragment,t),ge=a(t),r(et.$$.fragment,t),Be=a(t),lt=p(t,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-1jgxvf2"&&(lt.textContent=Dl),Ze=a(t),r(st.$$.fragment,t),Ge=a(t),nt=p(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-u4wya2"&&(nt.innerHTML=Ol),Ae=a(t),r(at.$$.fragment,t),ve=a(t),it=p(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-16rd7fj"&&(it.textContent=Kl),We=a(t),r(pt.$$.fragment,t),Ne=a(t),r(Mt.$$.fragment,t),$e=a(t),ot=p(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-14dcghr"&&(ot.textContent=ts),Se=a(t),r(yt.$$.fragment,t),Xe=a(t),rt=p(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-1vvhq4u"&&(rt.textContent=es),qe=a(t),r(C.$$.fragment,t),Ee=a(t),r(Jt.$$.fragment,t),Ve=a(t),Tt=p(t,"P",{"data-svelte-h":!0}),M(Tt)!=="svelte-llct1j"&&(Tt.textContent=ls),Qe=a(t),r(ut.$$.fragment,t),ke=a(t),r(f.$$.fragment,t),Re=a(t),r(ct.$$.fragment,t),He=a(t),wt=p(t,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1afb0a0"&&(wt.textContent=ss),xe=a(t),r(Ut.$$.fragment,t),ze=a(t),r(jt.$$.fragment,t),Ye=a(t),It=p(t,"P",{"data-svelte-h":!0}),M(It)!=="svelte-xfdfb"&&(It.innerHTML=ns),Fe=a(t),dt=p(t,"P",{"data-svelte-h":!0}),M(dt)!=="svelte-1kwhso3"&&(dt.textContent=as),_e=a(t),r(mt.$$.fragment,t),Pe=a(t),ht=p(t,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-byxuh9"&&(ht.textContent=is),Le=a(t),r(Ct.$$.fragment,t),De=a(t),ft=p(t,"P",{"data-svelte-h":!0}),M(ft)!=="svelte-p0i73e"&&(ft.innerHTML=ps),Oe=a(t),b=p(t,"DETAILS",{});var _t=fl(b);Pt=p(_t,"SUMMARY",{"data-svelte-h":!0}),M(Pt)!=="svelte-1ri4alz"&&(Pt.textContent=Ms),Cl=a(_t),r(bt.$$.fragment,_t),_t.forEach(l),Ke=a(t),gt=p(t,"P",{"data-svelte-h":!0}),M(gt)!=="svelte-yfhpg7"&&(gt.innerHTML=os),tl=a(t),r(Bt.$$.fragment,t),el=a(t),Zt=p(t,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-6mo49f"&&(Zt.textContent=ys),ll=a(t),Gt=p(t,"OL",{"data-svelte-h":!0}),M(Gt)!=="svelte-1rcpgt7"&&(Gt.innerHTML=rs),sl=a(t),At=p(t,"P",{"data-svelte-h":!0}),M(At)!=="svelte-1hlivpl"&&(At.textContent=Js),nl=a(t),r(vt.$$.fragment,t),al=a(t),Wt=p(t,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-h1so3u"&&(Wt.textContent=Ts),il=a(t),r(Nt.$$.fragment,t),pl=a(t),$t=p(t,"P",{"data-svelte-h":!0}),M($t)!=="svelte-ysbai4"&&($t.innerHTML=us),Ml=a(t),St=p(t,"P",{"data-svelte-h":!0}),M(St)!=="svelte-12z98a4"&&(St.innerHTML=cs),ol=a(t),r(Xt.$$.fragment,t),yl=a(t),qt=p(t,"P",{"data-svelte-h":!0}),M(qt)!=="svelte-xrb5o9"&&(qt.innerHTML=ws),rl=a(t),Et=p(t,"P",{"data-svelte-h":!0}),M(Et)!=="svelte-1ihtib7"&&(Et.innerHTML=Us),Jl=a(t),r(Vt.$$.fragment,t),Tl=a(t),Qt=p(t,"P",{"data-svelte-h":!0}),M(Qt)!=="svelte-1n4w3sz"&&(Qt.textContent=js),ul=a(t),r(kt.$$.fragment,t),cl=a(t),Rt=p(t,"P",{"data-svelte-h":!0}),M(Rt)!=="svelte-10hd5kd"&&(Rt.innerHTML=Is),wl=a(t),r(Ht.$$.fragment,t),Ul=a(t),xt=p(t,"P",{"data-svelte-h":!0}),M(xt)!=="svelte-e08du4"&&(xt.textContent=ds),jl=a(t),zt=p(t,"P",{"data-svelte-h":!0}),M(zt)!=="svelte-8g6jer"&&(zt.textContent=ms),Il=a(t),Yt=p(t,"UL",{"data-svelte-h":!0}),M(Yt)!=="svelte-gv9avz"&&(Yt.innerHTML=hs),dl=a(t),r(Ft.$$.fragment,t),ml=a(t),Lt=p(t,"P",{}),fl(Lt).forEach(l),this.h()},h(){bs(o,"name","hf:doc:metadata"),bs(o,"content",Xs)},m(t,e){bl(document.head,o),s(t,j,e),s(t,w,e),s(t,I,e),J(g,t,e),s(t,Dt,e),s(t,B,e),s(t,Ot,e),J(h,t,e),s(t,Kt,e),J(Z,t,e),s(t,te,e),s(t,G,e),s(t,ee,e),s(t,A,e),s(t,le,e),s(t,v,e),s(t,se,e),s(t,W,e),s(t,ne,e),s(t,N,e),s(t,ae,e),s(t,$,e),s(t,ie,e),s(t,S,e),s(t,pe,e),s(t,X,e),s(t,Me,e),s(t,q,e),s(t,oe,e),s(t,E,e),s(t,ye,e),s(t,V,e),s(t,re,e),J(Q,t,e),s(t,Je,e),s(t,k,e),s(t,Te,e),s(t,R,e),s(t,ue,e),s(t,H,e),s(t,ce,e),s(t,x,e),s(t,we,e),J(z,t,e),s(t,Ue,e),s(t,Y,e),s(t,je,e),s(t,F,e),s(t,Ie,e),s(t,_,e),s(t,de,e),J(P,t,e),s(t,me,e),s(t,L,e),s(t,he,e),s(t,D,e),s(t,Ce,e),s(t,O,e),s(t,fe,e),s(t,K,e),s(t,be,e),J(tt,t,e),s(t,ge,e),J(et,t,e),s(t,Be,e),s(t,lt,e),s(t,Ze,e),J(st,t,e),s(t,Ge,e),s(t,nt,e),s(t,Ae,e),J(at,t,e),s(t,ve,e),s(t,it,e),s(t,We,e),J(pt,t,e),s(t,Ne,e),J(Mt,t,e),s(t,$e,e),s(t,ot,e),s(t,Se,e),J(yt,t,e),s(t,Xe,e),s(t,rt,e),s(t,qe,e),J(C,t,e),s(t,Ee,e),J(Jt,t,e),s(t,Ve,e),s(t,Tt,e),s(t,Qe,e),J(ut,t,e),s(t,ke,e),J(f,t,e),s(t,Re,e),J(ct,t,e),s(t,He,e),s(t,wt,e),s(t,xe,e),J(Ut,t,e),s(t,ze,e),J(jt,t,e),s(t,Ye,e),s(t,It,e),s(t,Fe,e),s(t,dt,e),s(t,_e,e),J(mt,t,e),s(t,Pe,e),s(t,ht,e),s(t,Le,e),J(Ct,t,e),s(t,De,e),s(t,ft,e),s(t,Oe,e),s(t,b,e),bl(b,Pt),bl(b,Cl),J(bt,b,null),s(t,Ke,e),s(t,gt,e),s(t,tl,e),J(Bt,t,e),s(t,el,e),s(t,Zt,e),s(t,ll,e),s(t,Gt,e),s(t,sl,e),s(t,At,e),s(t,nl,e),J(vt,t,e),s(t,al,e),s(t,Wt,e),s(t,il,e),J(Nt,t,e),s(t,pl,e),s(t,$t,e),s(t,Ml,e),s(t,St,e),s(t,ol,e),J(Xt,t,e),s(t,yl,e),s(t,qt,e),s(t,rl,e),s(t,Et,e),s(t,Jl,e),J(Vt,t,e),s(t,Tl,e),s(t,Qt,e),s(t,ul,e),J(kt,t,e),s(t,cl,e),s(t,Rt,e),s(t,wl,e),J(Ht,t,e),s(t,Ul,e),s(t,xt,e),s(t,jl,e),s(t,zt,e),s(t,Il,e),s(t,Yt,e),s(t,dl,e),J(Ft,t,e),s(t,ml,e),s(t,Lt,e),hl=!0},p(t,[e]){const _t={};e&2&&(_t.$$scope={dirty:e,ctx:t}),h.$set(_t);const Cs={};e&2&&(Cs.$$scope={dirty:e,ctx:t}),C.$set(Cs);const fs={};e&2&&(fs.$$scope={dirty:e,ctx:t}),f.$set(fs)},i(t){hl||(T(g.$$.fragment,t),T(h.$$.fragment,t),T(Z.$$.fragment,t),T(Q.$$.fragment,t),T(z.$$.fragment,t),T(P.$$.fragment,t),T(tt.$$.fragment,t),T(et.$$.fragment,t),T(st.$$.fragment,t),T(at.$$.fragment,t),T(pt.$$.fragment,t),T(Mt.$$.fragment,t),T(yt.$$.fragment,t),T(C.$$.fragment,t),T(Jt.$$.fragment,t),T(ut.$$.fragment,t),T(f.$$.fragment,t),T(ct.$$.fragment,t),T(Ut.$$.fragment,t),T(jt.$$.fragment,t),T(mt.$$.fragment,t),T(Ct.$$.fragment,t),T(bt.$$.fragment,t),T(Bt.$$.fragment,t),T(vt.$$.fragment,t),T(Nt.$$.fragment,t),T(Xt.$$.fragment,t),T(Vt.$$.fragment,t),T(kt.$$.fragment,t),T(Ht.$$.fragment,t),T(Ft.$$.fragment,t),hl=!0)},o(t){u(g.$$.fragment,t),u(h.$$.fragment,t),u(Z.$$.fragment,t),u(Q.$$.fragment,t),u(z.$$.fragment,t),u(P.$$.fragment,t),u(tt.$$.fragment,t),u(et.$$.fragment,t),u(st.$$.fragment,t),u(at.$$.fragment,t),u(pt.$$.fragment,t),u(Mt.$$.fragment,t),u(yt.$$.fragment,t),u(C.$$.fragment,t),u(Jt.$$.fragment,t),u(ut.$$.fragment,t),u(f.$$.fragment,t),u(ct.$$.fragment,t),u(Ut.$$.fragment,t),u(jt.$$.fragment,t),u(mt.$$.fragment,t),u(Ct.$$.fragment,t),u(bt.$$.fragment,t),u(Bt.$$.fragment,t),u(vt.$$.fragment,t),u(Nt.$$.fragment,t),u(Xt.$$.fragment,t),u(Vt.$$.fragment,t),u(kt.$$.fragment,t),u(Ht.$$.fragment,t),u(Ft.$$.fragment,t),hl=!1},d(t){t&&(l(j),l(w),l(I),l(Dt),l(B),l(Ot),l(Kt),l(te),l(G),l(ee),l(A),l(le),l(v),l(se),l(W),l(ne),l(N),l(ae),l($),l(ie),l(S),l(pe),l(X),l(Me),l(q),l(oe),l(E),l(ye),l(V),l(re),l(Je),l(k),l(Te),l(R),l(ue),l(H),l(ce),l(x),l(we),l(Ue),l(Y),l(je),l(F),l(Ie),l(_),l(de),l(me),l(L),l(he),l(D),l(Ce),l(O),l(fe),l(K),l(be),l(ge),l(Be),l(lt),l(Ze),l(Ge),l(nt),l(Ae),l(ve),l(it),l(We),l(Ne),l($e),l(ot),l(Se),l(Xe),l(rt),l(qe),l(Ee),l(Ve),l(Tt),l(Qe),l(ke),l(Re),l(He),l(wt),l(xe),l(ze),l(Ye),l(It),l(Fe),l(dt),l(_e),l(Pe),l(ht),l(Le),l(De),l(ft),l(Oe),l(b),l(Ke),l(gt),l(tl),l(el),l(Zt),l(ll),l(Gt),l(sl),l(At),l(nl),l(al),l(Wt),l(il),l(pl),l($t),l(Ml),l(St),l(ol),l(yl),l(qt),l(rl),l(Et),l(Jl),l(Tl),l(Qt),l(ul),l(cl),l(Rt),l(wl),l(Ul),l(xt),l(jl),l(zt),l(Il),l(Yt),l(dl),l(ml),l(Lt)),l(o),c(g,t),c(h,t),c(Z,t),c(Q,t),c(z,t),c(P,t),c(tt,t),c(et,t),c(st,t),c(at,t),c(pt,t),c(Mt,t),c(yt,t),c(C,t),c(Jt,t),c(ut,t),c(f,t),c(ct,t),c(Ut,t),c(jt,t),c(mt,t),c(Ct,t),c(bt),c(Bt,t),c(vt,t),c(Nt,t),c(Xt,t),c(Vt,t),c(kt,t),c(Ht,t),c(Ft,t)}}}const Xs='{"title":"Create your own transcription app","local":"create-your-own-transcription-app","sections":[{"title":"Create your transcription endpoint","local":"create-your-transcription-endpoint","sections":[],"depth":2},{"title":"Create your text generation endpoint","local":"create-your-text-generation-endpoint","sections":[],"depth":2},{"title":"Test your endpoints","local":"test-your-endpoints","sections":[],"depth":2},{"title":"Get your endpoint details","local":"get-your-endpoint-details","sections":[],"depth":2},{"title":"Building the transcription app","local":"building-the-transcription-app","sections":[{"title":"Step 1: Set up dependencies and imports","local":"step-1-set-up-dependencies-and-imports","sections":[],"depth":3},{"title":"Step 2: Configure your endpoint connections","local":"step-2-configure-your-endpoint-connections","sections":[],"depth":3},{"title":"Step 3: Create the transcription function","local":"step-3-create-the-transcription-function","sections":[],"depth":3},{"title":"Step 4: Create the summarization function","local":"step-4-create-the-summarization-function","sections":[],"depth":3},{"title":"Step 5: Wrap it all together","local":"step-5-wrap-it-all-together","sections":[],"depth":3}],"depth":2},{"title":"Deploy your transcription app","local":"deploy-your-transcription-app","sections":[],"depth":2},{"title":"Bonus: Secure your app with AWS PrivateLink","local":"bonus-secure-your-app-with-aws-privatelink","sections":[{"title":"Step 1: Create Private Endpoints","local":"step-1-create-private-endpoints","sections":[],"depth":3},{"title":"Step 2: Configure VPC Interface Endpoint","local":"step-2-configure-vpc-interface-endpoint","sections":[{"title":"Step 3: Update your application","local":"step-3-update-your-application","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function qs(m){return Bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends Zs{constructor(o){super(),Gs(this,o,qs,Ss,gs,{})}}export{Hs as component};
