import{s as jn,o as mn,n as cn}from"../chunks/scheduler.cd324960.js";import{S as wn,i as rn,e as p,s as a,c as i,h as un,a as M,d as t,b as n,f as Jn,g as U,j as T,k as la,l as hn,m as s,n as y,t as J,o as j,p as m}from"../chunks/index.d5c3adcc.js";import{T as fn}from"../chunks/Tip.889bec11.js";import{C as dn,H as u,E as on}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6c592b5b.js";import{C as c}from"../chunks/CodeBlock.a3e45d18.js";function Cn(Be){let w,o="在我们的示例中，我们将使用大约 40 小时的训练数据。如果您想使用 Google Colab 免费版的 GPU 复现，需要将训练数据量减少到大约 10-15 小时，并减少训练步骤的数量。";return{c(){w=p("p"),w.textContent=o},l(r){w=M(r,"P",{"data-svelte-h":!0}),T(w)!=="svelte-az1j4w"&&(w.textContent=o)},m(r,_e){s(r,w,_e)},p:cn,d(r){r&&t(w)}}}function bn(Be){let w,o,r,_e,C,Ge,b,Ye,$,ea="现在您已经熟悉了语音合成任务和 SpeechT5 模型的内部工作原理，该模型是在英语数据上预训练的，让我们看看如何将其微调到另一种语言。",ve,I,Xe,k,ta="如果您想复现这个示例，请确保您有一个 GPU。在笔记本中，您可以使用以下命令检查：",Ee,Z,Ne,h,ze,Q,sa="您还需要一些额外的依赖：",Fe,g,He,x,aa="最后，不要忘记登录您的 Hugging Face 账户，以便您能够上传并与社区共享您的模型：",Se,R,qe,A,De,V,na=`在这个示例中，我们将使用 <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> 数据集的荷兰语（<code>nl</code>）子集。
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> 是一个大规模的多语言语音语料库，包含了 2009-2020 年欧洲议会事件的录音数据。
它包含 15 种欧洲语言的带标签的音频-转写数据。虽然我们将使用荷兰语子集，但您可以自由选择其他子集。`,Oe,_,pa="这是一个语音识别（ASR）数据集，所以，如前所述，它不是训练 TTS 模型的最佳选择。然而，对于这个练习来说，它已经足够好了。",Le,W,Ma="让我们加载数据：",Pe,B,Ke,G,Ta="<strong>输出：</strong>",lt,Y,et,v,ia="20968 条数据应该足以进行微调。输入 SpeechT5 的音频数据应具有 16 kHz 的采样率，所以要确保我们的数据集满足这一要求：",tt,X,st,E,at,N,Ua="处理器包含了分词器和特征提取器，我们需要用它们来预处理训练数据。所以我们先定义要使用的模型检查点，并加载对应的处理器：",nt,z,pt,F,Mt,H,ya="首先，为了处理文本，我们需要处理器的分词器部分，所以让我们来获取它：",Tt,S,it,q,Ja="让我们看一个示例：",Ut,D,yt,O,ja="<strong>输出：</strong>",Jt,L,jt,P,ma=`您可能会注意到数据包含 <code>raw_text</code> 和 <code>normalized_text</code> 特征。在决定使用哪个特征作为文本输入时，需要注意的是 SpeechT5 分词器没有任何数字的词元。
在 <code>normalized_text</code> 中，数字被写成文本。因此，它更合适，我们应该使用 <code>normalized_text</code> 作为输入文本。`,mt,K,ca=`因为 SpeechT5 是在英语上训练的，它可能无法识别荷兰语数据集中的某些字符。如果保持原样，这些字符将被转换为 <code>&lt;unk&gt;</code> 词元。
然而，在荷兰语中，某些字符如 <code>à</code> 用于强调音节。为了保留文本的含义，我们可以将此字符替换为普通的 <code>a</code>。`,ct,ll,wa=`要识别不支持的词元，使用 <code>SpeechT5Tokenizer</code> 提取数据集中所有独特字符，该分词器将字符视为词元。为此，我们将编写 <code>extract_all_chars</code> 映射函数，
该函数将所有数据样例的转写连接成一个字符串，然后转换为字符集。确保在 <code>dataset.map()</code> 中设置 <code>batched=True</code> 和 <code>batch_size=-1</code>，以便一次性获取所有转写并输入映射函数。`,wt,el,rt,tl,ra="现在您有两组字符：一个来自数据集，另一个来自分词器。要识别数据集中任何不支持的字符，您可以取这两组的差集，结果将包含在数据集中而不在分词器中的字符。",ut,sl,ht,al,ua="<strong>输出：</strong>",ft,nl,dt,pl,ha="为了处理上一步骤中识别的不支持字符，我们可以定义一个将这些字符映射到有效词元的函数。注意，分词器中的空格已经被替换为 <code>▁</code>，因此不需要单独处理。",ot,Ml,Ct,Tl,fa="现在我们处理好了文本中的特殊字符，是时候将注意力转移到音频数据上了。",bt,il,$t,Ul,da=`VoxPopuli 数据集包含多个说话人的语音，但到底有多少呢？我们可以计算一下数据集中说话人的数量以及每个说话人贡献的数据量。
数据集总共有 20,968 条数据，这些信息将帮助我们更好地了解数据中的说话人和数据样例的分布。`,It,yl,kt,Jl,oa="通过绘制直方图，您可以了解每个说话人的数据量。",Zt,jl,Qt,f,Ca='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',gt,ml,ba="直方图显示，数据集中大约三分之一的说话人的数据少于 100 条，而大约十个说话人的数据超过 500 条。为了提高训练效率并平衡数据集，我们可以将数据限制在有 100 到 400 条数据的说话人之间。",xt,cl,Rt,wl,$a="让我们检查还剩多少个说话人：",At,rl,Vt,ul,Ia="<strong>输出：</strong>",_t,hl,Wt,fl,ka="让我们看看还剩多少条数据：",Bt,dl,Gt,ol,Za="<strong>输出：</strong>",Yt,Cl,vt,bl,Qa="您留下了不到 10,000 条数据，来自大约 40 个独特的说话人，这应该足够用了。",Xt,$l,ga=`请注意，如果某些数据很长，一些看似数据样例量较少的说话人可能有比预想的更多的音频数据。然而，确定每个说话人的总音频量需要扫描整个数据集，
这是一个耗时的过程，涉及加载和解码每个音频文件。因此，我们在这里选择跳过这一步。`,Et,Il,Nt,kl,xa=`为了使 TTS 模型能够区分多个说话人，您需要为每条数据创建一个说话人嵌入。说话人嵌入是模型的一个额外输入，用于描述特定说话人的声音特征。
要生成这些说话人嵌入，可以使用来自 SpeechBrain 的预训练模型 <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>。`,zt,Zl,Ra="创建一个 <code>create_speaker_embedding()</code> 函数，该函数接受音频波形作为输入，并输出包含相应说话人嵌入的 512 维向量。",Ft,Ql,Ht,gl,Aa=`注意，<code>speechbrain/spkrec-xvect-voxceleb</code> 模型是在 VoxCeleb 数据集的英语语音上训练的，而这个示例训练的是荷兰语。
虽然我们相信这个模型仍然可以为我们的荷兰语数据集生成合理的说话人嵌入，但这个假设可能不总是成立。`,St,xl,Va=`为了获得最佳结果，我们需要首先在目标语音上训练 X-Vector 模型。这将确保模型能够更好地捕捉荷兰语中存在的独特声音特征。如果您想训练自己的 X-向量模型，
可以参考 <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">此脚本</a>。`,qt,Rl,Dt,Al,_a="最后，让我们将数据处理成模型能够读入的格式。创建一个 <code>prepare_dataset</code> 函数，输入单个示例并使用 <code>SpeechT5Processor</code> 对象来对输入文本进行分词，并将目标音频加载成对数梅尔谱。它还应该额外输入说话人嵌入。",Ot,Vl,Lt,_l,Wa="查看单个示例来验证处理是否正确：",Pt,Wl,Kt,Bl,Ba="<strong>输出：</strong>",ls,Gl,es,Yl,Ga="说话人嵌入应该是一个 512 维向量：",ts,vl,ss,Xl,Ya="<strong>输出：</strong>",as,El,ns,Nl,va="标签应该是一个有 80 个 mel 频段的对数梅尔谱。",ps,zl,Ms,d,Xa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',Ts,Fl,Ea="注：如果您看不明白这个频谱图，可能是因为您习惯将低频放在底部，高频放在顶部。然而，在使用 matplotlib 库将频谱图作为图像绘制时，y 轴是反过来的，频谱图看起来是倒置的。",is,Hl,Na="现在我们需要将处理函数应用于整个数据集。这将花费 5 到 10 分钟的时间。",Us,Sl,ys,ql,za="您会看到一个警告说数据集中的某些数据长于模型能够处理的最大输入长度（600 词元），得从数据集中删除这些数据。在这里，我们更进一步，为了允许更大的批量大小，删除任何超过 200 词元的内容。",Js,Dl,js,Ol,Fa="<strong>输出：</strong>",ms,Ll,cs,Pl,Ha="接下来，把数据集分成基本的训练/测试子集：",ws,Kl,rs,le,us,ee,Sa=`为了将多条数据组合成一个批次，您需要定义一个自定义数据整理器。这个整理器将使用填充词元填充较短的序列，确保所有示例都具有相同的长度。
对于频谱图标签，填充部分将被特殊值 <code>-100</code> 替换。这个特殊值指示模型在计算频谱图的损失函数时忽略那部分频谱图。`,hs,te,fs,se,qa=`在 SpeechT5 中，模型的解码器部分的输入减少了 2 倍（reduction factor）。换句话说，它抛弃了目标序列中每两步中的一步。然后，解码器预测一个两倍长度的序列。
由于原来的目标序列长度可能是奇数，数据整理器会确保将批次的最大长度调整为 2 的倍数。`,ds,ae,os,ne,Cs,pe,Da="从与处理器相同的检查点加载预训练模型：",bs,Me,$s,Te,Oa="<code>use_cache=True</code> 选项与梯度检查点不兼容。我们在训练时禁用这个选项，并在生成时重新启用缓存以加快推理：",Is,ie,ks,Ue,La="定义训练参数。这里我们在训练过程中不计算任何评估指标，我们将在本章稍后讨论评估。这里，我们先只关注损失函数：",Zs,ye,Qs,Je,Pa="实例化 <code>Trainer</code> 对象并将模型、数据集和数据整理器传递给它。",gs,je,xs,me,Ka="有了这个，我们就准备开始训练了！训练将花费几个小时。由于 GPU 不同，当您开始训练时，可能会遇到 CUDA 报“out-of-memory”（显存不足）的错误。这时，您可以尝试将 <code>per_device_train_batch_size</code> 两倍两倍地减少，并将 <code>gradient_accumulation_steps</code> 增加到两倍以补偿。",Rs,ce,As,we,ln="将最终的模型上传到 🤗 Hub：",Vs,re,_s,ue,Ws,he,en="一旦您微调了一个模型，您就可以使用它进行推理！从 🤗 Hub 加载模型（记得在以下代码片段中使用您的账号名）：",Bs,fe,Gs,de,tn="选择一个示例，这里我们将从测试数据集中取一个。获取说话人嵌入。",Ys,oe,vs,Ce,sn="定义一些输入文本并对它进行分词。",Xs,be,Es,$e,an="预处理输入文本：",Ns,Ie,zs,ke,nn="实例化一个声码器并生成语音：",Fs,Ze,Hs,Qe,pn="准备好听结果了吗？",Ss,ge,qs,xe,Mn="用这个模型在新语言上获得的满意结果可能很有挑战性。说话人嵌入的质量可能是一个重要因素。由于 SpeechT5 是使用英语 X-Vector 预训练的，它在使用英语说话人嵌入时表现最佳。如果合成的语音听起来效果不好，尝试使用不同的说话人嵌入。",Ds,Re,Tn="增加训练时长也可能提高结果的质量。但即便不继续训练，语音也显然是荷兰语而不是英语，并且它确实学到了说话人的声音特征（与示例中的原始音频相比较）。另一个可以试验的是模型的配置。例如，尝试使用 <code>config.reduction_factor = 1</code> 来看是否能改善结果。",Os,Ae,Un="在下一节中，我们将讨论如何评估语音合成模型。",Ls,Ve,Ps,We,Ks;return C=new dn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new u({props:{title:"微调 SpeechT5",local:"微调-speecht5",headingTag:"h1"}}),I=new u({props:{title:"基础准备",local:"基础准备",headingTag:"h2"}}),Z=new c({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),h=new fn({props:{warning:!0,$$slots:{default:[Cn]},$$scope:{ctx:Be}}}),g=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate",wrap:!1}}),R=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),A=new u({props:{title:"数据集",local:"数据集",headingTag:"h2"}}),B=new c({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),Y=new c({props:{code:"MjA5Njg=",highlighted:"20968",wrap:!1}}),X=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),E=new u({props:{title:"数据预处理",local:"数据预处理",headingTag:"h2"}}),z=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),F=new u({props:{title:"为 SpeechT5 分词进行文本清理",local:"为-speecht5-分词进行文本清理",headingTag:"h3"}}),S=new c({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer",wrap:!1}}),D=new c({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),L=new c({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`,wrap:!1}}),el=new c({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),sl=new c({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab",wrap:!1}}),nl=new c({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}",wrap:!1}}),Ml=new c({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),il=new u({props:{title:"说话人",local:"说话人",headingTag:"h3"}}),yl=new c({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),jl=new c({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`,wrap:!1}}),cl=new c({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),rl=new c({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))',wrap:!1}}),hl=new c({props:{code:"NDI=",highlighted:"42",wrap:!1}}),dl=new c({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)',wrap:!1}}),Cl=new c({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>',wrap:!1}}),Il=new u({props:{title:"说话人嵌入",local:"说话人嵌入",headingTag:"h3"}}),Ql=new c({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),Rl=new u({props:{title:"处理数据集",local:"处理数据集",headingTag:"h3"}}),Vl=new c({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTUlOEUlQkIlRTYlOEUlODklRTYlODklQjklRTklODclOEYlRTUlQTQlODQlRTclOTAlODYlRTclOUElODQlRTclQkIlQjQlRTUlQkElQTYlMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCU1QjAlNUQlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTclOTQlQTglMjBTcGVlY2hCcmFpbiUyMCVFOCU4RSVCNyVFNSU4RiU5NiUyMFgtVmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># 去掉批量处理的维度</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># 用 SpeechBrain 获取 X-Vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Wl=new c({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`,wrap:!1}}),Gl=new c({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]',wrap:!1}}),vl=new c({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape',wrap:!1}}),El=new c({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)',wrap:!1}}),zl=new c({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`,wrap:!1}}),Sl=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),Dl=new c({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),Ll=new c({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>',wrap:!1}}),Kl=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),le=new u({props:{title:"数据整理器",local:"数据整理器",headingTag:"h3"}}),te=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># 把输入数据和生成目标整合进一个批次</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># 把填充词元换成 -100 来正确地忽略这一部分的损失函数</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># 在微调时用不上，删了</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># 把目标长度下调到 reduction factor 的整数倍</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># 加上说话人嵌入</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),ae=new c({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)",wrap:!1}}),ne=new u({props:{title:"训练模型",local:"训练模型",headingTag:"h2"}}),Me=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),ie=new c({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjAlRTUlOUMlQTglRTglQUUlQUQlRTclQkIlODMlRTYlOTclQjYlRTclQTYlODElRTclOTQlQTglRTclQkMlOTMlRTUlQUQlOTglMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjAlRTglQUUlQkUlRTclQkQlQUUlRTglQUYlQUQlRTglQTglODAlRTUlOTIlOEMlRTQlQkIlQkIlRTUlOEElQTElRTUlODclODYlRTUlQTQlODclRTYlOEUlQTglRTclOTAlODYlRUYlQkMlOEMlRTUlQjklQjYlRTklODclOEQlRTYlOTYlQjAlRTUlOTAlQUYlRTclOTQlQTglRTclQkMlOTMlRTUlQUQlOTglMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># 在训练时禁用缓存</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># 设置语言和任务准备推理，并重新启用缓存</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`,wrap:!1}}),ye=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjAlRTYlOTQlQjklRTYlODglOTAlRTYlODIlQTglRTklODAlODklRTYlOEIlQTklRTclOUElODQlRTQlQkIlOTMlRTUlQkElOTMlRTUlOTAlOEQlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNENTAwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENDAwMCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTVCJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># 改成您选择的仓库名</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),je=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`,wrap:!1}}),ce=new c({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),re=new c({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),ue=new u({props:{title:"推理",local:"推理",headingTag:"h2"}}),fe=new c({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyJUU2JTgyJUE4JUU3JTlBJTg0JUU4JUI0JUE2JUU1JThGJUI3JTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;您的账号/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`,wrap:!1}}),oe=new c({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),be=new c({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),Ie=new c({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Ze=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`,wrap:!1}}),ge=new c({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),Ve=new on({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/zh-CN/chapter6/fine-tuning.mdx"}}),{c(){w=p("meta"),o=a(),r=p("p"),_e=a(),i(C.$$.fragment),Ge=a(),i(b.$$.fragment),Ye=a(),$=p("p"),$.textContent=ea,ve=a(),i(I.$$.fragment),Xe=a(),k=p("p"),k.textContent=ta,Ee=a(),i(Z.$$.fragment),Ne=a(),i(h.$$.fragment),ze=a(),Q=p("p"),Q.textContent=sa,Fe=a(),i(g.$$.fragment),He=a(),x=p("p"),x.textContent=aa,Se=a(),i(R.$$.fragment),qe=a(),i(A.$$.fragment),De=a(),V=p("p"),V.innerHTML=na,Oe=a(),_=p("p"),_.textContent=pa,Le=a(),W=p("p"),W.textContent=Ma,Pe=a(),i(B.$$.fragment),Ke=a(),G=p("p"),G.innerHTML=Ta,lt=a(),i(Y.$$.fragment),et=a(),v=p("p"),v.textContent=ia,tt=a(),i(X.$$.fragment),st=a(),i(E.$$.fragment),at=a(),N=p("p"),N.textContent=Ua,nt=a(),i(z.$$.fragment),pt=a(),i(F.$$.fragment),Mt=a(),H=p("p"),H.textContent=ya,Tt=a(),i(S.$$.fragment),it=a(),q=p("p"),q.textContent=Ja,Ut=a(),i(D.$$.fragment),yt=a(),O=p("p"),O.innerHTML=ja,Jt=a(),i(L.$$.fragment),jt=a(),P=p("p"),P.innerHTML=ma,mt=a(),K=p("p"),K.innerHTML=ca,ct=a(),ll=p("p"),ll.innerHTML=wa,wt=a(),i(el.$$.fragment),rt=a(),tl=p("p"),tl.textContent=ra,ut=a(),i(sl.$$.fragment),ht=a(),al=p("p"),al.innerHTML=ua,ft=a(),i(nl.$$.fragment),dt=a(),pl=p("p"),pl.innerHTML=ha,ot=a(),i(Ml.$$.fragment),Ct=a(),Tl=p("p"),Tl.textContent=fa,bt=a(),i(il.$$.fragment),$t=a(),Ul=p("p"),Ul.textContent=da,It=a(),i(yl.$$.fragment),kt=a(),Jl=p("p"),Jl.textContent=oa,Zt=a(),i(jl.$$.fragment),Qt=a(),f=p("div"),f.innerHTML=Ca,gt=a(),ml=p("p"),ml.textContent=ba,xt=a(),i(cl.$$.fragment),Rt=a(),wl=p("p"),wl.textContent=$a,At=a(),i(rl.$$.fragment),Vt=a(),ul=p("p"),ul.innerHTML=Ia,_t=a(),i(hl.$$.fragment),Wt=a(),fl=p("p"),fl.textContent=ka,Bt=a(),i(dl.$$.fragment),Gt=a(),ol=p("p"),ol.innerHTML=Za,Yt=a(),i(Cl.$$.fragment),vt=a(),bl=p("p"),bl.textContent=Qa,Xt=a(),$l=p("p"),$l.textContent=ga,Et=a(),i(Il.$$.fragment),Nt=a(),kl=p("p"),kl.innerHTML=xa,zt=a(),Zl=p("p"),Zl.innerHTML=Ra,Ft=a(),i(Ql.$$.fragment),Ht=a(),gl=p("p"),gl.innerHTML=Aa,St=a(),xl=p("p"),xl.innerHTML=Va,qt=a(),i(Rl.$$.fragment),Dt=a(),Al=p("p"),Al.innerHTML=_a,Ot=a(),i(Vl.$$.fragment),Lt=a(),_l=p("p"),_l.textContent=Wa,Pt=a(),i(Wl.$$.fragment),Kt=a(),Bl=p("p"),Bl.innerHTML=Ba,ls=a(),i(Gl.$$.fragment),es=a(),Yl=p("p"),Yl.textContent=Ga,ts=a(),i(vl.$$.fragment),ss=a(),Xl=p("p"),Xl.innerHTML=Ya,as=a(),i(El.$$.fragment),ns=a(),Nl=p("p"),Nl.textContent=va,ps=a(),i(zl.$$.fragment),Ms=a(),d=p("div"),d.innerHTML=Xa,Ts=a(),Fl=p("p"),Fl.textContent=Ea,is=a(),Hl=p("p"),Hl.textContent=Na,Us=a(),i(Sl.$$.fragment),ys=a(),ql=p("p"),ql.textContent=za,Js=a(),i(Dl.$$.fragment),js=a(),Ol=p("p"),Ol.innerHTML=Fa,ms=a(),i(Ll.$$.fragment),cs=a(),Pl=p("p"),Pl.textContent=Ha,ws=a(),i(Kl.$$.fragment),rs=a(),i(le.$$.fragment),us=a(),ee=p("p"),ee.innerHTML=Sa,hs=a(),i(te.$$.fragment),fs=a(),se=p("p"),se.textContent=qa,ds=a(),i(ae.$$.fragment),os=a(),i(ne.$$.fragment),Cs=a(),pe=p("p"),pe.textContent=Da,bs=a(),i(Me.$$.fragment),$s=a(),Te=p("p"),Te.innerHTML=Oa,Is=a(),i(ie.$$.fragment),ks=a(),Ue=p("p"),Ue.textContent=La,Zs=a(),i(ye.$$.fragment),Qs=a(),Je=p("p"),Je.innerHTML=Pa,gs=a(),i(je.$$.fragment),xs=a(),me=p("p"),me.innerHTML=Ka,Rs=a(),i(ce.$$.fragment),As=a(),we=p("p"),we.textContent=ln,Vs=a(),i(re.$$.fragment),_s=a(),i(ue.$$.fragment),Ws=a(),he=p("p"),he.textContent=en,Bs=a(),i(fe.$$.fragment),Gs=a(),de=p("p"),de.textContent=tn,Ys=a(),i(oe.$$.fragment),vs=a(),Ce=p("p"),Ce.textContent=sn,Xs=a(),i(be.$$.fragment),Es=a(),$e=p("p"),$e.textContent=an,Ns=a(),i(Ie.$$.fragment),zs=a(),ke=p("p"),ke.textContent=nn,Fs=a(),i(Ze.$$.fragment),Hs=a(),Qe=p("p"),Qe.textContent=pn,Ss=a(),i(ge.$$.fragment),qs=a(),xe=p("p"),xe.textContent=Mn,Ds=a(),Re=p("p"),Re.innerHTML=Tn,Os=a(),Ae=p("p"),Ae.textContent=Un,Ls=a(),i(Ve.$$.fragment),Ps=a(),We=p("p"),this.h()},l(l){const e=un("svelte-u9bgzb",document.head);w=M(e,"META",{name:!0,content:!0}),e.forEach(t),o=n(l),r=M(l,"P",{}),Jn(r).forEach(t),_e=n(l),U(C.$$.fragment,l),Ge=n(l),U(b.$$.fragment,l),Ye=n(l),$=M(l,"P",{"data-svelte-h":!0}),T($)!=="svelte-1mq8wfv"&&($.textContent=ea),ve=n(l),U(I.$$.fragment,l),Xe=n(l),k=M(l,"P",{"data-svelte-h":!0}),T(k)!=="svelte-1e5vilx"&&(k.textContent=ta),Ee=n(l),U(Z.$$.fragment,l),Ne=n(l),U(h.$$.fragment,l),ze=n(l),Q=M(l,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-f18nl2"&&(Q.textContent=sa),Fe=n(l),U(g.$$.fragment,l),He=n(l),x=M(l,"P",{"data-svelte-h":!0}),T(x)!=="svelte-j2pd5z"&&(x.textContent=aa),Se=n(l),U(R.$$.fragment,l),qe=n(l),U(A.$$.fragment,l),De=n(l),V=M(l,"P",{"data-svelte-h":!0}),T(V)!=="svelte-80f883"&&(V.innerHTML=na),Oe=n(l),_=M(l,"P",{"data-svelte-h":!0}),T(_)!=="svelte-1mt7w1y"&&(_.textContent=pa),Le=n(l),W=M(l,"P",{"data-svelte-h":!0}),T(W)!=="svelte-1ee133t"&&(W.textContent=Ma),Pe=n(l),U(B.$$.fragment,l),Ke=n(l),G=M(l,"P",{"data-svelte-h":!0}),T(G)!=="svelte-1yevus4"&&(G.innerHTML=Ta),lt=n(l),U(Y.$$.fragment,l),et=n(l),v=M(l,"P",{"data-svelte-h":!0}),T(v)!=="svelte-14mygxn"&&(v.textContent=ia),tt=n(l),U(X.$$.fragment,l),st=n(l),U(E.$$.fragment,l),at=n(l),N=M(l,"P",{"data-svelte-h":!0}),T(N)!=="svelte-myc28k"&&(N.textContent=Ua),nt=n(l),U(z.$$.fragment,l),pt=n(l),U(F.$$.fragment,l),Mt=n(l),H=M(l,"P",{"data-svelte-h":!0}),T(H)!=="svelte-1k6p6xo"&&(H.textContent=ya),Tt=n(l),U(S.$$.fragment,l),it=n(l),q=M(l,"P",{"data-svelte-h":!0}),T(q)!=="svelte-o1gog8"&&(q.textContent=Ja),Ut=n(l),U(D.$$.fragment,l),yt=n(l),O=M(l,"P",{"data-svelte-h":!0}),T(O)!=="svelte-1yevus4"&&(O.innerHTML=ja),Jt=n(l),U(L.$$.fragment,l),jt=n(l),P=M(l,"P",{"data-svelte-h":!0}),T(P)!=="svelte-qqgwx7"&&(P.innerHTML=ma),mt=n(l),K=M(l,"P",{"data-svelte-h":!0}),T(K)!=="svelte-snkesy"&&(K.innerHTML=ca),ct=n(l),ll=M(l,"P",{"data-svelte-h":!0}),T(ll)!=="svelte-zq9kvx"&&(ll.innerHTML=wa),wt=n(l),U(el.$$.fragment,l),rt=n(l),tl=M(l,"P",{"data-svelte-h":!0}),T(tl)!=="svelte-1yggo6j"&&(tl.textContent=ra),ut=n(l),U(sl.$$.fragment,l),ht=n(l),al=M(l,"P",{"data-svelte-h":!0}),T(al)!=="svelte-1yevus4"&&(al.innerHTML=ua),ft=n(l),U(nl.$$.fragment,l),dt=n(l),pl=M(l,"P",{"data-svelte-h":!0}),T(pl)!=="svelte-18q69cr"&&(pl.innerHTML=ha),ot=n(l),U(Ml.$$.fragment,l),Ct=n(l),Tl=M(l,"P",{"data-svelte-h":!0}),T(Tl)!=="svelte-t46ksf"&&(Tl.textContent=fa),bt=n(l),U(il.$$.fragment,l),$t=n(l),Ul=M(l,"P",{"data-svelte-h":!0}),T(Ul)!=="svelte-si6krf"&&(Ul.textContent=da),It=n(l),U(yl.$$.fragment,l),kt=n(l),Jl=M(l,"P",{"data-svelte-h":!0}),T(Jl)!=="svelte-1a4y7jc"&&(Jl.textContent=oa),Zt=n(l),U(jl.$$.fragment,l),Qt=n(l),f=M(l,"DIV",{class:!0,"data-svelte-h":!0}),T(f)!=="svelte-1uufiik"&&(f.innerHTML=Ca),gt=n(l),ml=M(l,"P",{"data-svelte-h":!0}),T(ml)!=="svelte-1n2xy9x"&&(ml.textContent=ba),xt=n(l),U(cl.$$.fragment,l),Rt=n(l),wl=M(l,"P",{"data-svelte-h":!0}),T(wl)!=="svelte-w4zc6g"&&(wl.textContent=$a),At=n(l),U(rl.$$.fragment,l),Vt=n(l),ul=M(l,"P",{"data-svelte-h":!0}),T(ul)!=="svelte-1yevus4"&&(ul.innerHTML=Ia),_t=n(l),U(hl.$$.fragment,l),Wt=n(l),fl=M(l,"P",{"data-svelte-h":!0}),T(fl)!=="svelte-3ki28v"&&(fl.textContent=ka),Bt=n(l),U(dl.$$.fragment,l),Gt=n(l),ol=M(l,"P",{"data-svelte-h":!0}),T(ol)!=="svelte-1yevus4"&&(ol.innerHTML=Za),Yt=n(l),U(Cl.$$.fragment,l),vt=n(l),bl=M(l,"P",{"data-svelte-h":!0}),T(bl)!=="svelte-1r0ckxv"&&(bl.textContent=Qa),Xt=n(l),$l=M(l,"P",{"data-svelte-h":!0}),T($l)!=="svelte-115y9a6"&&($l.textContent=ga),Et=n(l),U(Il.$$.fragment,l),Nt=n(l),kl=M(l,"P",{"data-svelte-h":!0}),T(kl)!=="svelte-1vb1v7p"&&(kl.innerHTML=xa),zt=n(l),Zl=M(l,"P",{"data-svelte-h":!0}),T(Zl)!=="svelte-15d2tc9"&&(Zl.innerHTML=Ra),Ft=n(l),U(Ql.$$.fragment,l),Ht=n(l),gl=M(l,"P",{"data-svelte-h":!0}),T(gl)!=="svelte-1ojzcke"&&(gl.innerHTML=Aa),St=n(l),xl=M(l,"P",{"data-svelte-h":!0}),T(xl)!=="svelte-vn616r"&&(xl.innerHTML=Va),qt=n(l),U(Rl.$$.fragment,l),Dt=n(l),Al=M(l,"P",{"data-svelte-h":!0}),T(Al)!=="svelte-1blnag0"&&(Al.innerHTML=_a),Ot=n(l),U(Vl.$$.fragment,l),Lt=n(l),_l=M(l,"P",{"data-svelte-h":!0}),T(_l)!=="svelte-1nl861s"&&(_l.textContent=Wa),Pt=n(l),U(Wl.$$.fragment,l),Kt=n(l),Bl=M(l,"P",{"data-svelte-h":!0}),T(Bl)!=="svelte-1yevus4"&&(Bl.innerHTML=Ba),ls=n(l),U(Gl.$$.fragment,l),es=n(l),Yl=M(l,"P",{"data-svelte-h":!0}),T(Yl)!=="svelte-crgj40"&&(Yl.textContent=Ga),ts=n(l),U(vl.$$.fragment,l),ss=n(l),Xl=M(l,"P",{"data-svelte-h":!0}),T(Xl)!=="svelte-1yevus4"&&(Xl.innerHTML=Ya),as=n(l),U(El.$$.fragment,l),ns=n(l),Nl=M(l,"P",{"data-svelte-h":!0}),T(Nl)!=="svelte-g6mluh"&&(Nl.textContent=va),ps=n(l),U(zl.$$.fragment,l),Ms=n(l),d=M(l,"DIV",{class:!0,"data-svelte-h":!0}),T(d)!=="svelte-j4o1b8"&&(d.innerHTML=Xa),Ts=n(l),Fl=M(l,"P",{"data-svelte-h":!0}),T(Fl)!=="svelte-82ihiz"&&(Fl.textContent=Ea),is=n(l),Hl=M(l,"P",{"data-svelte-h":!0}),T(Hl)!=="svelte-61um8j"&&(Hl.textContent=Na),Us=n(l),U(Sl.$$.fragment,l),ys=n(l),ql=M(l,"P",{"data-svelte-h":!0}),T(ql)!=="svelte-19pcez9"&&(ql.textContent=za),Js=n(l),U(Dl.$$.fragment,l),js=n(l),Ol=M(l,"P",{"data-svelte-h":!0}),T(Ol)!=="svelte-1yevus4"&&(Ol.innerHTML=Fa),ms=n(l),U(Ll.$$.fragment,l),cs=n(l),Pl=M(l,"P",{"data-svelte-h":!0}),T(Pl)!=="svelte-1aub7yi"&&(Pl.textContent=Ha),ws=n(l),U(Kl.$$.fragment,l),rs=n(l),U(le.$$.fragment,l),us=n(l),ee=M(l,"P",{"data-svelte-h":!0}),T(ee)!=="svelte-1ug6prq"&&(ee.innerHTML=Sa),hs=n(l),U(te.$$.fragment,l),fs=n(l),se=M(l,"P",{"data-svelte-h":!0}),T(se)!=="svelte-n9sw30"&&(se.textContent=qa),ds=n(l),U(ae.$$.fragment,l),os=n(l),U(ne.$$.fragment,l),Cs=n(l),pe=M(l,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-kpt5ph"&&(pe.textContent=Da),bs=n(l),U(Me.$$.fragment,l),$s=n(l),Te=M(l,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-7avbs0"&&(Te.innerHTML=Oa),Is=n(l),U(ie.$$.fragment,l),ks=n(l),Ue=M(l,"P",{"data-svelte-h":!0}),T(Ue)!=="svelte-169ijvl"&&(Ue.textContent=La),Zs=n(l),U(ye.$$.fragment,l),Qs=n(l),Je=M(l,"P",{"data-svelte-h":!0}),T(Je)!=="svelte-hto4ro"&&(Je.innerHTML=Pa),gs=n(l),U(je.$$.fragment,l),xs=n(l),me=M(l,"P",{"data-svelte-h":!0}),T(me)!=="svelte-4sfz1e"&&(me.innerHTML=Ka),Rs=n(l),U(ce.$$.fragment,l),As=n(l),we=M(l,"P",{"data-svelte-h":!0}),T(we)!=="svelte-w4esym"&&(we.textContent=ln),Vs=n(l),U(re.$$.fragment,l),_s=n(l),U(ue.$$.fragment,l),Ws=n(l),he=M(l,"P",{"data-svelte-h":!0}),T(he)!=="svelte-ou25m7"&&(he.textContent=en),Bs=n(l),U(fe.$$.fragment,l),Gs=n(l),de=M(l,"P",{"data-svelte-h":!0}),T(de)!=="svelte-xms5tj"&&(de.textContent=tn),Ys=n(l),U(oe.$$.fragment,l),vs=n(l),Ce=M(l,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-4e57y3"&&(Ce.textContent=sn),Xs=n(l),U(be.$$.fragment,l),Es=n(l),$e=M(l,"P",{"data-svelte-h":!0}),T($e)!=="svelte-b1ybtn"&&($e.textContent=an),Ns=n(l),U(Ie.$$.fragment,l),zs=n(l),ke=M(l,"P",{"data-svelte-h":!0}),T(ke)!=="svelte-m4c265"&&(ke.textContent=nn),Fs=n(l),U(Ze.$$.fragment,l),Hs=n(l),Qe=M(l,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-v08fsb"&&(Qe.textContent=pn),Ss=n(l),U(ge.$$.fragment,l),qs=n(l),xe=M(l,"P",{"data-svelte-h":!0}),T(xe)!=="svelte-8y01aj"&&(xe.textContent=Mn),Ds=n(l),Re=M(l,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-185eq6j"&&(Re.innerHTML=Tn),Os=n(l),Ae=M(l,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-g4ct72"&&(Ae.textContent=Un),Ls=n(l),U(Ve.$$.fragment,l),Ps=n(l),We=M(l,"P",{}),Jn(We).forEach(t),this.h()},h(){la(w,"name","hf:doc:metadata"),la(w,"content",$n),la(f,"class","flex justify-center"),la(d,"class","flex justify-center")},m(l,e){hn(document.head,w),s(l,o,e),s(l,r,e),s(l,_e,e),y(C,l,e),s(l,Ge,e),y(b,l,e),s(l,Ye,e),s(l,$,e),s(l,ve,e),y(I,l,e),s(l,Xe,e),s(l,k,e),s(l,Ee,e),y(Z,l,e),s(l,Ne,e),y(h,l,e),s(l,ze,e),s(l,Q,e),s(l,Fe,e),y(g,l,e),s(l,He,e),s(l,x,e),s(l,Se,e),y(R,l,e),s(l,qe,e),y(A,l,e),s(l,De,e),s(l,V,e),s(l,Oe,e),s(l,_,e),s(l,Le,e),s(l,W,e),s(l,Pe,e),y(B,l,e),s(l,Ke,e),s(l,G,e),s(l,lt,e),y(Y,l,e),s(l,et,e),s(l,v,e),s(l,tt,e),y(X,l,e),s(l,st,e),y(E,l,e),s(l,at,e),s(l,N,e),s(l,nt,e),y(z,l,e),s(l,pt,e),y(F,l,e),s(l,Mt,e),s(l,H,e),s(l,Tt,e),y(S,l,e),s(l,it,e),s(l,q,e),s(l,Ut,e),y(D,l,e),s(l,yt,e),s(l,O,e),s(l,Jt,e),y(L,l,e),s(l,jt,e),s(l,P,e),s(l,mt,e),s(l,K,e),s(l,ct,e),s(l,ll,e),s(l,wt,e),y(el,l,e),s(l,rt,e),s(l,tl,e),s(l,ut,e),y(sl,l,e),s(l,ht,e),s(l,al,e),s(l,ft,e),y(nl,l,e),s(l,dt,e),s(l,pl,e),s(l,ot,e),y(Ml,l,e),s(l,Ct,e),s(l,Tl,e),s(l,bt,e),y(il,l,e),s(l,$t,e),s(l,Ul,e),s(l,It,e),y(yl,l,e),s(l,kt,e),s(l,Jl,e),s(l,Zt,e),y(jl,l,e),s(l,Qt,e),s(l,f,e),s(l,gt,e),s(l,ml,e),s(l,xt,e),y(cl,l,e),s(l,Rt,e),s(l,wl,e),s(l,At,e),y(rl,l,e),s(l,Vt,e),s(l,ul,e),s(l,_t,e),y(hl,l,e),s(l,Wt,e),s(l,fl,e),s(l,Bt,e),y(dl,l,e),s(l,Gt,e),s(l,ol,e),s(l,Yt,e),y(Cl,l,e),s(l,vt,e),s(l,bl,e),s(l,Xt,e),s(l,$l,e),s(l,Et,e),y(Il,l,e),s(l,Nt,e),s(l,kl,e),s(l,zt,e),s(l,Zl,e),s(l,Ft,e),y(Ql,l,e),s(l,Ht,e),s(l,gl,e),s(l,St,e),s(l,xl,e),s(l,qt,e),y(Rl,l,e),s(l,Dt,e),s(l,Al,e),s(l,Ot,e),y(Vl,l,e),s(l,Lt,e),s(l,_l,e),s(l,Pt,e),y(Wl,l,e),s(l,Kt,e),s(l,Bl,e),s(l,ls,e),y(Gl,l,e),s(l,es,e),s(l,Yl,e),s(l,ts,e),y(vl,l,e),s(l,ss,e),s(l,Xl,e),s(l,as,e),y(El,l,e),s(l,ns,e),s(l,Nl,e),s(l,ps,e),y(zl,l,e),s(l,Ms,e),s(l,d,e),s(l,Ts,e),s(l,Fl,e),s(l,is,e),s(l,Hl,e),s(l,Us,e),y(Sl,l,e),s(l,ys,e),s(l,ql,e),s(l,Js,e),y(Dl,l,e),s(l,js,e),s(l,Ol,e),s(l,ms,e),y(Ll,l,e),s(l,cs,e),s(l,Pl,e),s(l,ws,e),y(Kl,l,e),s(l,rs,e),y(le,l,e),s(l,us,e),s(l,ee,e),s(l,hs,e),y(te,l,e),s(l,fs,e),s(l,se,e),s(l,ds,e),y(ae,l,e),s(l,os,e),y(ne,l,e),s(l,Cs,e),s(l,pe,e),s(l,bs,e),y(Me,l,e),s(l,$s,e),s(l,Te,e),s(l,Is,e),y(ie,l,e),s(l,ks,e),s(l,Ue,e),s(l,Zs,e),y(ye,l,e),s(l,Qs,e),s(l,Je,e),s(l,gs,e),y(je,l,e),s(l,xs,e),s(l,me,e),s(l,Rs,e),y(ce,l,e),s(l,As,e),s(l,we,e),s(l,Vs,e),y(re,l,e),s(l,_s,e),y(ue,l,e),s(l,Ws,e),s(l,he,e),s(l,Bs,e),y(fe,l,e),s(l,Gs,e),s(l,de,e),s(l,Ys,e),y(oe,l,e),s(l,vs,e),s(l,Ce,e),s(l,Xs,e),y(be,l,e),s(l,Es,e),s(l,$e,e),s(l,Ns,e),y(Ie,l,e),s(l,zs,e),s(l,ke,e),s(l,Fs,e),y(Ze,l,e),s(l,Hs,e),s(l,Qe,e),s(l,Ss,e),y(ge,l,e),s(l,qs,e),s(l,xe,e),s(l,Ds,e),s(l,Re,e),s(l,Os,e),s(l,Ae,e),s(l,Ls,e),y(Ve,l,e),s(l,Ps,e),s(l,We,e),Ks=!0},p(l,[e]){const yn={};e&2&&(yn.$$scope={dirty:e,ctx:l}),h.$set(yn)},i(l){Ks||(J(C.$$.fragment,l),J(b.$$.fragment,l),J(I.$$.fragment,l),J(Z.$$.fragment,l),J(h.$$.fragment,l),J(g.$$.fragment,l),J(R.$$.fragment,l),J(A.$$.fragment,l),J(B.$$.fragment,l),J(Y.$$.fragment,l),J(X.$$.fragment,l),J(E.$$.fragment,l),J(z.$$.fragment,l),J(F.$$.fragment,l),J(S.$$.fragment,l),J(D.$$.fragment,l),J(L.$$.fragment,l),J(el.$$.fragment,l),J(sl.$$.fragment,l),J(nl.$$.fragment,l),J(Ml.$$.fragment,l),J(il.$$.fragment,l),J(yl.$$.fragment,l),J(jl.$$.fragment,l),J(cl.$$.fragment,l),J(rl.$$.fragment,l),J(hl.$$.fragment,l),J(dl.$$.fragment,l),J(Cl.$$.fragment,l),J(Il.$$.fragment,l),J(Ql.$$.fragment,l),J(Rl.$$.fragment,l),J(Vl.$$.fragment,l),J(Wl.$$.fragment,l),J(Gl.$$.fragment,l),J(vl.$$.fragment,l),J(El.$$.fragment,l),J(zl.$$.fragment,l),J(Sl.$$.fragment,l),J(Dl.$$.fragment,l),J(Ll.$$.fragment,l),J(Kl.$$.fragment,l),J(le.$$.fragment,l),J(te.$$.fragment,l),J(ae.$$.fragment,l),J(ne.$$.fragment,l),J(Me.$$.fragment,l),J(ie.$$.fragment,l),J(ye.$$.fragment,l),J(je.$$.fragment,l),J(ce.$$.fragment,l),J(re.$$.fragment,l),J(ue.$$.fragment,l),J(fe.$$.fragment,l),J(oe.$$.fragment,l),J(be.$$.fragment,l),J(Ie.$$.fragment,l),J(Ze.$$.fragment,l),J(ge.$$.fragment,l),J(Ve.$$.fragment,l),Ks=!0)},o(l){j(C.$$.fragment,l),j(b.$$.fragment,l),j(I.$$.fragment,l),j(Z.$$.fragment,l),j(h.$$.fragment,l),j(g.$$.fragment,l),j(R.$$.fragment,l),j(A.$$.fragment,l),j(B.$$.fragment,l),j(Y.$$.fragment,l),j(X.$$.fragment,l),j(E.$$.fragment,l),j(z.$$.fragment,l),j(F.$$.fragment,l),j(S.$$.fragment,l),j(D.$$.fragment,l),j(L.$$.fragment,l),j(el.$$.fragment,l),j(sl.$$.fragment,l),j(nl.$$.fragment,l),j(Ml.$$.fragment,l),j(il.$$.fragment,l),j(yl.$$.fragment,l),j(jl.$$.fragment,l),j(cl.$$.fragment,l),j(rl.$$.fragment,l),j(hl.$$.fragment,l),j(dl.$$.fragment,l),j(Cl.$$.fragment,l),j(Il.$$.fragment,l),j(Ql.$$.fragment,l),j(Rl.$$.fragment,l),j(Vl.$$.fragment,l),j(Wl.$$.fragment,l),j(Gl.$$.fragment,l),j(vl.$$.fragment,l),j(El.$$.fragment,l),j(zl.$$.fragment,l),j(Sl.$$.fragment,l),j(Dl.$$.fragment,l),j(Ll.$$.fragment,l),j(Kl.$$.fragment,l),j(le.$$.fragment,l),j(te.$$.fragment,l),j(ae.$$.fragment,l),j(ne.$$.fragment,l),j(Me.$$.fragment,l),j(ie.$$.fragment,l),j(ye.$$.fragment,l),j(je.$$.fragment,l),j(ce.$$.fragment,l),j(re.$$.fragment,l),j(ue.$$.fragment,l),j(fe.$$.fragment,l),j(oe.$$.fragment,l),j(be.$$.fragment,l),j(Ie.$$.fragment,l),j(Ze.$$.fragment,l),j(ge.$$.fragment,l),j(Ve.$$.fragment,l),Ks=!1},d(l){l&&(t(o),t(r),t(_e),t(Ge),t(Ye),t($),t(ve),t(Xe),t(k),t(Ee),t(Ne),t(ze),t(Q),t(Fe),t(He),t(x),t(Se),t(qe),t(De),t(V),t(Oe),t(_),t(Le),t(W),t(Pe),t(Ke),t(G),t(lt),t(et),t(v),t(tt),t(st),t(at),t(N),t(nt),t(pt),t(Mt),t(H),t(Tt),t(it),t(q),t(Ut),t(yt),t(O),t(Jt),t(jt),t(P),t(mt),t(K),t(ct),t(ll),t(wt),t(rt),t(tl),t(ut),t(ht),t(al),t(ft),t(dt),t(pl),t(ot),t(Ct),t(Tl),t(bt),t($t),t(Ul),t(It),t(kt),t(Jl),t(Zt),t(Qt),t(f),t(gt),t(ml),t(xt),t(Rt),t(wl),t(At),t(Vt),t(ul),t(_t),t(Wt),t(fl),t(Bt),t(Gt),t(ol),t(Yt),t(vt),t(bl),t(Xt),t($l),t(Et),t(Nt),t(kl),t(zt),t(Zl),t(Ft),t(Ht),t(gl),t(St),t(xl),t(qt),t(Dt),t(Al),t(Ot),t(Lt),t(_l),t(Pt),t(Kt),t(Bl),t(ls),t(es),t(Yl),t(ts),t(ss),t(Xl),t(as),t(ns),t(Nl),t(ps),t(Ms),t(d),t(Ts),t(Fl),t(is),t(Hl),t(Us),t(ys),t(ql),t(Js),t(js),t(Ol),t(ms),t(cs),t(Pl),t(ws),t(rs),t(us),t(ee),t(hs),t(fs),t(se),t(ds),t(os),t(Cs),t(pe),t(bs),t($s),t(Te),t(Is),t(ks),t(Ue),t(Zs),t(Qs),t(Je),t(gs),t(xs),t(me),t(Rs),t(As),t(we),t(Vs),t(_s),t(Ws),t(he),t(Bs),t(Gs),t(de),t(Ys),t(vs),t(Ce),t(Xs),t(Es),t($e),t(Ns),t(zs),t(ke),t(Fs),t(Hs),t(Qe),t(Ss),t(qs),t(xe),t(Ds),t(Re),t(Os),t(Ae),t(Ls),t(Ps),t(We)),t(w),m(C,l),m(b,l),m(I,l),m(Z,l),m(h,l),m(g,l),m(R,l),m(A,l),m(B,l),m(Y,l),m(X,l),m(E,l),m(z,l),m(F,l),m(S,l),m(D,l),m(L,l),m(el,l),m(sl,l),m(nl,l),m(Ml,l),m(il,l),m(yl,l),m(jl,l),m(cl,l),m(rl,l),m(hl,l),m(dl,l),m(Cl,l),m(Il,l),m(Ql,l),m(Rl,l),m(Vl,l),m(Wl,l),m(Gl,l),m(vl,l),m(El,l),m(zl,l),m(Sl,l),m(Dl,l),m(Ll,l),m(Kl,l),m(le,l),m(te,l),m(ae,l),m(ne,l),m(Me,l),m(ie,l),m(ye,l),m(je,l),m(ce,l),m(re,l),m(ue,l),m(fe,l),m(oe,l),m(be,l),m(Ie,l),m(Ze,l),m(ge,l),m(Ve,l)}}}const $n='{"title":"微调 SpeechT5","local":"微调-speecht5","sections":[{"title":"基础准备","local":"基础准备","sections":[],"depth":2},{"title":"数据集","local":"数据集","sections":[],"depth":2},{"title":"数据预处理","local":"数据预处理","sections":[{"title":"为 SpeechT5 分词进行文本清理","local":"为-speecht5-分词进行文本清理","sections":[],"depth":3},{"title":"说话人","local":"说话人","sections":[],"depth":3},{"title":"说话人嵌入","local":"说话人嵌入","sections":[],"depth":3},{"title":"处理数据集","local":"处理数据集","sections":[],"depth":3},{"title":"数据整理器","local":"数据整理器","sections":[],"depth":3}],"depth":2},{"title":"训练模型","local":"训练模型","sections":[],"depth":2},{"title":"推理","local":"推理","sections":[],"depth":2}],"depth":1}';function In(Be){return mn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rn extends wn{constructor(w){super(),rn(this,w,In,bn,jn,{})}}export{Rn as component};
