# Выбор набора данных

Как и в любой другой задаче машинного обучения, наша модель хороша лишь настолько, насколько хороши данные, на которых мы ее обучаем.
Наборы данных для распознавания речи существенно различаются по способу их формирования и областям, которые они охватывают.
Чтобы выбрать правильный набор данных, необходимо сопоставить наши критерии с возможностями, которые предоставляет набор данных.

Прежде чем выбрать набор данных, необходимо понять его ключевые определяющие характеристики.

## Характеристики речевых наборов данных

### 1. Количество часов
Проще говоря, количество часов обучения показывает, насколько велик набор данных. Это аналогично количеству обучающих примеров в наборе данных
для обработки естественного языка (NLP). Однако, большой набор данных не означает что этот набор лучший. Если мы хотим получить модель, которая
хорошо обобщает, нам нужна **разнообразный** набор данных с большим количеством различных дикторов, источников и стилей речи.

### 2. Источник данных
Источник данных означает, откуда были взяты данные, будь то аудиокниги, подкасты, YouTube или финансовые встречи. Для каждого источника характерно
свое распределение данных. Например, аудиокниги записываются в качественных студийных условиях (без посторонних шумов), а текст берется из
письменной литературы. В то время как для YouTube аудиозапись, скорее всего, содержит больше фонового шума и более неформальный стиль речи.

Мы должны соотнести наш источник с условиями, которые мы ожидаем в момент вывода. Например, если мы обучаем нашу модель на аудиокнигах, мы не можем
ожидать, что она будет хорошо работать в шумной обстановке.

### 3. Стиль речи
Стиль речи относится к одной из двух категорий:

* Дикторская: чтение по сценарию
* Спонтанная: речь без сценария, разговорная речь

Аудио- и текстовые данные отражают стиль речи. Поскольку дикторский текст написан по сценарию, он, как правило, произносится внятно и без ошибок:

```
“Рассмотрим задачу обучения модели на наборе данных распознавания речи”
```

В то время как для спонтанной речи можно ожидать более разговорного стиля речи, с повторениями, запинаниями и других речевых сбоев:

```
“Let’s uhh let's take a look at how you'd go about training a model on uhm a sp- speech recognition dataset”
```

### 4. Стиль транскрипции
Стиль транскрипции относится к тому, есть ли в целевом тексте пунктуация, регистр или и то, и другое. Если мы хотим, чтобы система
генерировала полностью отформатированный текст, который можно было бы использовать для публикации или транскрипции собрания, нам нужны
обучающие данные с пунктуацией и регистром. Если нам просто нужны произносимые слова в неформатированной структуре, ни пунктуация,
ни регистр не нужны. В этом случае мы можем либо выбрать набор данных без знаков препинания и регистра, либо выбрать тот, в котором
есть знаки препинания и регистр, а затем впоследствии удалить их из целевого текста с помощью предварительной обработки.

## Сводная информация о наборах данных на Hugging Face Hub

Ниже приведен обзор наиболее популярных наборов данных для распознавания английской речи на Hugging Face Hub:

| Dataset                                                                                 | Train Hours | Domain                      | Speaking Style        | Casing | Punctuation | License         | Recommended Use                  |
|-----------------------------------------------------------------------------------------|-------------|-----------------------------|-----------------------|--------|-------------|-----------------|----------------------------------|
| [LibriSpeech](https://huggingface.co/datasets/librispeech_asr)                          | 960         | Audiobook                   | Narrated              | ❌      | ❌           | CC-BY-4.0       | Academic benchmarks              |
| [Common Voice 11](https://huggingface.co/datasets/mozilla-foundation/common_voice_11_0) | 3000        | Wikipedia                   | Narrated              | ✅      | ✅           | CC0-1.0         | Non-native speakers              |
| [VoxPopuli](https://huggingface.co/datasets/facebook/voxpopuli)                         | 540         | European Parliament         | Oratory               | ❌      | ✅           | CC0             | Non-native speakers              |
| [TED-LIUM](https://huggingface.co/datasets/LIUM/tedlium)                                | 450         | TED talks                   | Oratory               | ❌      | ❌           | CC-BY-NC-ND 3.0 | Technical topics                 |
| [GigaSpeech](https://huggingface.co/datasets/speechcolab/gigaspeech)                    | 10000       | Audiobook, podcast, YouTube | Narrated, spontaneous | ❌      | ✅           | apache-2.0      | Robustness over multiple domains |
| [SPGISpeech](https://huggingface.co/datasets/kensho/spgispeech)                         | 5000        | Financial meetings          | Oratory, spontaneous  | ✅      | ✅           | User Agreement  | Fully formatted transcriptions   |
| [Earnings-22](https://huggingface.co/datasets/revdotcom/earnings22)                     | 119         | Financial meetings          | Oratory, spontaneous  | ✅      | ✅           | CC-BY-SA-4.0    | Diversity of accents             |
| [AMI](https://huggingface.co/datasets/edinburghcstr/ami)                                | 100         | Meetings                    | Spontaneous           | ✅      | ✅           | CC-BY-4.0       | Noisy speech conditions          |

Эта таблица служит справочной информацией для выбора набора данных на основе вашего критерия. Ниже приведена эквивалентная таблица
для многоязычного распознавания речи. Обратите внимание, что мы опускаем столбец "Время обучения", поскольку оно зависит от языка для
каждого набора данных, и заменяем его на количество языков для каждого набора данных:

| Dataset                                                                                       | Languages | Domain                                | Speaking Style | Casing | Punctuation | License   | Recommended Usage       |
|-----------------------------------------------------------------------------------------------|-----------|---------------------------------------|----------------|--------|-------------|-----------|-------------------------|
| [Multilingual LibriSpeech](https://huggingface.co/datasets/facebook/multilingual_librispeech) | 6         | Audiobooks                            | Narrated       | ❌      | ❌           | CC-BY-4.0 | Academic benchmarks     |
| [Common Voice 13](https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0)       | 108       | Wikipedia text & crowd-sourced speech | Narrated       | ✅      | ✅           | CC0-1.0   | Diverse speaker set     |
| [VoxPopuli](https://huggingface.co/datasets/facebook/voxpopuli)                               | 15        | European Parliament recordings        | Spontaneous    | ❌      | ✅           | CC0       | European languages      |
| [FLEURS](https://huggingface.co/datasets/google/fleurs)                                       | 101       | European Parliament recordings        | Spontaneous    | ❌      | ❌           | CC-BY-4.0 | Multilingual evaluation |

Подробную информацию о наборах аудиоданных, представленных в обеих таблицах, можно найти в блоге [Полное руководство по работе с наборами аудиоданных](https://huggingface.co/blog/audio-datasets#a-tour-of-audio-datasets-on-the-hub).
Хотя на Hugging Face Hub имеется более 180 наборов данных для распознавания речи, может оказаться, что среди них нет такого,
который соответствует вашим потребностям. Для создания пользовательского набора аудиоданных см. руководство [Создание набора аудиоданных](https://huggingface.co/docs/datasets/audio_dataset).
При создании пользовательского набора аудиоданных подумайте о том, чтобы опубликовать окончательный набор данных в Hugging Face Hub, чтобы
другие участники сообщества могли извлечь пользу из ваших усилий — сообщество аудио является обширно и многогранно, и другие оценят вашу
работу так же, как и вы.

Хорошо! Теперь, когда мы рассмотрели все критерии выбора набора данных ASR, давайте выберем один из них для целей данного руководства.
Мы знаем, что Whisper уже достаточно хорошо справляется с транскрибацией данных на ресурсоемких языках(таких как английский
и испанский), поэтому мы сосредоточимся на многоязычной транскрибации данных с низким уровнем ресурсов. Мы хотим сохранить способность Whisper
предсказывать знаки препинания и регистр, поэтому из второй таблицы видно, что Common Voice 13 является отличным набором данных!

## Common Voice 13

Common Voice 13 - это набор данных, созданный на основе краудсорсинга, в котором дикторы записывают текст из Википедии на разных языках.
Он является частью серии Common Voice - коллекции наборов данных Common Voice, выпускаемой Mozilla Foundation. На момент написания статьи
Common Voice 13 является последней редакцией набора данных, содержащей наибольшее количество языков и часов на один язык из всех выпущенных
на сегодняшний день.

Полный список языков для набора данных Common Voice 13 можно получить, заглянув на страницу набора данных на Hugging Face Hub:
[mozilla-foundation/common_voice_13_0](https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0).
При первом просмотре этой страницы вам будет предложено принять условия использования. После этого вам будет предоставлен полный доступ к набору данных.

После того как мы выполнили аутентификацию для использования набора данных, нам будет представлен предварительный просмотр набора данных.
Предварительный просмотр набора данных показывает нам первые 100 образцов набора данных для каждого языка. Более того, в него загружены аудиообразцы,
которые мы можем прослушать в режиме реального времени. Для этого Раздела мы выберем [_Дивехи_](https://en.wikipedia.org/wiki/Maldivian_language)
или (_Мальдивский язык_), это индоарийский язык, на котором разговаривают в островном государстве Мальдивы, расположенном в Южной Азии. Хотя для данного
руководства мы выбрали Дивехи, описанные здесь шаги применимы к любому из 108 языков, входящих в набор данных Common Voice 13, и вообще к любому из 180
с лишним наборов аудиоданных на Hugging Face Hub, поэтому нет никаких ограничений по языку или диалекту.

Мы можем выбрать подмножество Дивехи в Common Voice 13, установив в выпадающем меню подмножество `dv` (`dv` - код идентификатора языка Dhivehi):

<div class="flex justify-center">
    <img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/cv_13_dv_selection.png" alt="Selecting the Dhivehi split from the Dataset's Preview">
</div>

Если мы нажмем кнопку воспроизведения на первом примере, то сможем прослушать звук и увидеть соответствующий текст. Пролистайте примеры обучающего
и тестового наборов, чтобы лучше понять, с какими аудио- и текстовыми данными мы имеем дело. По интонации и стилю можно определить, что записи
сделаны с дикторской речи. Вы также, вероятно, заметите большой разброс между дикторами и качеством записи, что является общей чертой что является
общей чертой краудсорсинговых данных.

Предварительный просмотр данных - это отличный способ ознакомиться с наборами аудиоданных, прежде чем приступить к их использованию. Вы можете
выбрать любой набор данных в Hugging Face Hub, просмотреть образцы и прослушать аудио для различных подмножеств и разбиений, оценив, подходит
ли этот набор данных для ваших нужд. Выбрав набор данных, можно загрузить их и начать использовать.

Итак, я лично не владею Дивехи, и предполагаю, что подавляющее большинство читателей тоже! Чтобы узнать, насколько хороша наша
дообученная модель, нам потребуется строгий способ _оценить_ ее на невидимых данных и измерить достоверность транскрипции. Именно об этом
мы расскажем в следующем разделе!

<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ru/chapter5/choosing_dataset.mdx" />