# Vérifier votre compréhension de l'unité

### 1. En quelles unités le taux d'échantillonnage est-il mesuré ?

<Question
	choices={[
		{
			text: "dB",
			explain: "Non, l'amplitude est mesurée en décibels (dB)."
		},
		{
			text: "Hz",
			explain: "La fréquence d'échantillonnage est le nombre d'échantillons prélevés en une seconde et est mesurée en hertz (Hz).",
			correct: true
		},
		{
			text: "bit",
			explain: "Les bits sont utilisés pour décrire la profondeur de bits, qui fait référence au nombre de bits d'information utilisés pour représenter chaque échantillon d'un signal audio.",
		}
	]}
/>

### 2. Lorsqu'un grand jeu de données audio est streamé, à quel moment peut-on commencer à l'utiliser ?

<Question
	choices={[
		{
			text: "Dès que le jeu de données complet est téléchargé.",
			explain: "L'objectif du streaming de données est de pouvoir travailler avec ces données sans avoir à télécharger entièrement un jeu de données."
		},
		{
			text: "Dès que les 16 premiers exemples sont téléchargés.",
			explain: " Réessayez !"
		},
		{
			text: "Dès que le premier exemple est téléchargé.",
			explain: "",
			correct: true
		}
	]}
/>

### 3. Qu'est-ce qu'un spectrogramme ?

<Question
	choices={[
		{
			text: "Un appareil utilisé pour numériser le son qui est d'abord capturé par un microphone, qui convertit les ondes sonores en un signal électrique.",
			explain: "Un dispositif utilisé pour numériser un tel signal électrique est appelé convertisseur analogique-numérique. Réessayez !"
		},
		{
			text: "Un graphique qui montre comment l'amplitude d'un signal audio change dans le temps. Il est également connu sous le nom de représentation du son dans le *domaine temporel*.",
			explain: "La description ci-dessus se réfère à la forme d'onde, et non au spectrogramme."
		},
		{
			text: "Une représentation visuelle du spectre de fréquence d'un signal qui varie en fonction du temps.",
			explain: "",
			correct: true
		}
	]}
/>

### 4. Quel est le moyen le plus simple de convertir des données audio brutes en spectrogramme log-mel attendu par Whisper ?

A.

```python
librosa.feature.melspectrogram(audio["array"])
```

B.

```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.

```python
dataset.feature(audio["array"], model="whisper")
```

<Question
	choices={[
		{
			text: "A",
			explain: "`librosa.feature.melspectrogram()` crée un spectrogramme de puissance."
		},
		{
			text: "B",
			explain: "",
			correct: true
		},
		{
			text: "C",
			explain: "Le jeu de données ne prépare pas les caractéristiques pour les <i>Transformers</i>, ceci est fait par le préprocesseur du modèle."
		}
	]}
/>

### 5. Comment charger un jeu de données depuis me 🤗 Hub ?

A.

```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.

```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.

```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

<Question
	choices={[
		{
			text: "A",
			explain: "Le meilleur moyen est d'utiliser la bibliothèque 🤗 <i>Datasets</i>.",
			correct: true
		},
		{
			text: "B",
			explain: "<code>Librosa.load</code> est utile pour charger un fichier audio individuel à partir d'un chemin dans un tuple avec des séries temporelles audio et une fréquence d'échantillonnage, mais pas un jeu de données entier avec de nombreux exemples et de multiples caractéristiques. "
		},
		{
			text: "C",
			explain: "La méthode <code>load_dataset</code> se trouve dans la bibliothèque 🤗 <i>Datasets</i>, pas dans 🤗 <i>Transformers</i>."
		}
	]}
/>

### 6. Votre jeu de données personnalisé contient des données audio de haute qualité avec une fréquence d'échantillonnage de 32 kHz. Vous souhaitez entraîner un modèle de reconnaissance vocale qui s'attend à ce que les exemples audio aient une fréquence d'échantillonnage de 16 kHz. Que devez-vous faire ?


<Question
	choices={[
		{
			text: "Utilisez les exemples tels quels, le modèle se généralisera facilement à des exemples audio de meilleure qualité.",
			explain: "En raison de la dépendance à l'égard des mécanismes d'attention, il est difficile pour les modèles de généraliser entre les taux d'échantillonnage."
		},
		{
			text: "Utiliser le module <code>Audio</code> de la bibliothèque 🤗 <i>Datasets</i> pour sous-échantillonner les exemples du jeu de données personnalisé.",
			explain: "",
			correct: true
		},
		{
			text: "Réduire l'échantillonnage d'un facteur 2 en éliminant tous les autres échantillons.",
			explain: "Cela créera des distorsions dans le signal, appelées alias. Le rééchantillonnage est une opération délicate qu'il vaut mieux confier à des bibliothèques éprouvées telles que librosa ou 🤗 <i>Datasets</i>."
		}
	]}
/>

### 7. Comment convertir un spectrogramme généré par un modèle d'apprentissage automatique en une forme d'onde ?

<Question
	choices={[
		{
			text: "Nous pouvons utiliser un réseau neuronal appelé vocodeur pour reconstruire une forme d'onde à partir du spectrogramme.",
			explain: "Comme l'information de phase est manquante dans ce cas, nous devons utiliser un vocodeur ou l'algorithme classique de Griffin-Lim pour reconstruire la forme d'onde.",
			correct: true
		},
		{
			text: "Nous pouvons utiliser l'inverse de la TFCT pour convertir le spectrogramme généré en une forme d'onde.",
			explain: "Un spectrogramme généré ne contient pas les informations de phase nécessaires à l'utilisation de l'inverse de la TFCT. "
		},
		{
			text: "Il est impossible de convertir un spectrogramme généré par un modèle d'apprentissage automatique en une forme d'onde.",
			explain: "Réessayez !"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter1/quiz.mdx" />